Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["AVF",
 FontSlant->"Italic"]], "Title",
 FontColor->RGBColor[1, 0, 0]],

Cell["Exterior calculus with algebra valued forms", "Subtitle",
 FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
 "Hugo D. Wahlquist ",
 StyleBox["\[Copyright] 2003-2015\n",
  FontSize->18],
 "\n",
 StyleBox["Now mantained by Frank B. Estabrook and Jos\[EAcute] M. Mart\
\[IAcute]n-Garc\[IAcute]a after Hugo passed away in 2008.",
  FontSize->14]
}], "Subsubtitle"],

Cell[TextData[{
 "This file contains a reorganization of the powerful programs ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", by Hugo D. Wahlquist. We have simply added a package structure to them. \
The usage messages for the functions and variables are closely based on the \
information given at the end of the file AVF_Introduction.nb."
}], "Text"],

Cell[TextData[{
 "This package follows the structure of the ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " framework, but it is actually independent of the rest of packages, except \
for a minimal dependency on ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " to find out the ",
 StyleBox["$xActDirectory", "Input",
  FontWeight->"Plain"],
 ". ",
 StyleBox["AVF ",
  FontSlant->"Italic"],
 "does not yet talk to the other mathematical packages of ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 ". That is, the ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " package must be used separatedly from them. It is bundled with ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " because it covers an important area of tensor calculus that is not yet \
handled directly by ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`AVF`$Version", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.0.0\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2011", ",", "12", ",", "18"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell["Package structure", "Section"],

Cell[CellGroupData[{

Cell["Info package", "Subsection"],

Cell["\<\
(* :Title: AVF *)

(* :Author: Hugo D. Wahlquist *)

(* :Summary: Exterior calculus with algebra valued forms *)

(* :Brief Discussion:
   - Handles products of scalars, forms and algebra elements.
   - Works with general algebras, defined by giving the table of products.
   - Cartan-Kahler theory.
   - Dedicated code for Clifford algebras. Precomputed results for many of \
them.
   - Riemannian geometry with orthonormal (moving) frames.
   - Cartan characters.
*)
  
(* :Context: xAct`AVF` *)

(* :Package Version: 1.0.0 *)

(* :Copyright: Hugo D. Wahlquist (2003-2015). Since 2011, mantained by Frank \
B. Estabrook and Jose M. Martin-Garcia.
*)

(* :History: see AVF.History file *)

(* :Keywords: *)

(* :Source: AVF.nb *)

(* :Warning: This package does not talk to the other xAct packages *)

(* :Mathematica Version: 7.0 and later *)

(* :Limitations: *)\
\>", "Input",
 PageWidth->PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Begin package", "Subsection"],

Cell[TextData[{
 "Load ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " to get directory information about the ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " distribution:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{"xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`AVF`\>\""}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", 
   RowBox[{"\"\<xAct`AVF`\>\"", ",", 
    RowBox[{"{", "\"\<xAct`xCore`\>\"", "}"}]}], "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell["Print copyright message and GPL disclaimer:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
  RowBox[{
  "Print", "[", "\"\<Package xAct`AVF`  version 1.0, {2011, 12, 18}\>\"", 
   "]"}], ";", 
  RowBox[{
  "Print", "[", 
   "\"\<CopyRight (C) 2003-2015, Hugo D. Wahlquist, under the General Public \
License.\>\"", "]"}]}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData["\<\"Package xAct`AVF`  version 1.0, {2011, 12, 18}\"\>"], \
"Print"],

Cell[BoxData["\<\"CopyRight (C) 2003-2015, Hugo D. Wahlquist, under the \
General Public License.\"\>"], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`AVF`\>\""}], 
    ",", 
    RowBox[{
     RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", 
      "\"\<These packages come with ABSOLUTELY NO WARRANTY; for details type \
Disclaimer[]. This is free software, and you are welcome to redistribute it \
under certain conditions. See the General Public License for details.\>\"", 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`AVF`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", 
   "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Usage messages", "Subsection"],

Cell["Usage messages for functions:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"adjmat", "::", "usage"}], "=", 
   "\"\<adjmat[elems] returns the matrix adjmat.adjlist = \
argument_list.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"adL", "::", "usage"}], "=", 
   "\"\<adL[elem, elem1] returns elem ** elem1. adL[elem, {elem1, elem2, \
...}] returns {elem**elem1, elem**elem2, ...}.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"adR", "::", "usage"}], "=", 
   "\"\<adR[elem1, elem] returns elem1 ** elem. adR[{elem1, elem2, ...}, \
elem] returns {elem1**elem, elem2**elem, ...}.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"applydrules", "::", "usage"}], "=", 
   "\"\<applydrules[avf] implements expand[avf /. drules].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"associators", "::", "usage"}], "=", 
   "\"\<associators[n] returns up to n associators for algebra.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeffs", "::", "usage"}], "=", 
   "\"\<coeffs[avf] returns a list of the non-zero coefficients of elements \
in avf.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"collect", "::", "usage"}], "=", 
   "\"\<collect[avf] collects the factors of elements. It displays the \
identity element.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"contract", "::", "usage"}], "=", 
   "\"\<contract[v, avf] contracts the vector v on avf. It has infix form \
given by SmallCircle.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"contractedidentity", "::", "usage"}], "=", 
   "\"\<contractedidentity[] returns the differential identity for the \
Einstein 3-form \!\(\*OverscriptBox[OverscriptBox[\(G\), \(^\)], \(\\\ \)]\).\
\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"curvatureidentity", "::", "usage"}], "=", 
   "\"\<curvatureidentity[] returns the Bianchi identity. It is a general \
identity for the CAV field \!\(\*OverscriptBox[\(\[CapitalOmega]\), \(^\)]\).\
\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "::", "usage"}], "=", 
   "\"\<d[avf] returns the exterior derivative of the argument.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"da", "::", "usage"}], "=", 
   "\"\<da[avf] is a shortcut for applydrules[d[avf]].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Delta]", "::", "usage"}], "=", 
   "\"\<\[Delta][avf] is the coderivative for arguments expressed in frame. \
It equals hs[da[hs[avf]]].\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dot", "::", "usage"}], "=", 
   "\"\<dot[pform1, pform2] gives the scalar product of arguments expressed \
in frame.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"embedsub", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"expand", "::", "usage"}], "=", 
   "\"\<expand[avf] replaces infix multiplication operator ** by \
\[Wedge].\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"factor", "::", "usage"}], "=", 
   "\"\<factor[basisform, avf] returns the righthand factor of basisform in \
avf.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"generic", "::", "usage"}], "=", 
   "\"\<generic[] constructs a general algebra for elements using skew and \
symm.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grade", "::", "usage"}], "=", 
   "\"\<grade[integer, CAV] returns the specified grade of a CAV form.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grades", "::", "usage"}], "=", 
   "\"\<grades[CAV] returns a list of all grades of a CAV form.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hs", "::", "usage"}], "=", 
   "\"\<hs[avf] returns the Hodge dual of avf expressed in frame.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"in", "::", "usage"}], "=", 
   "\"\<in[avf] converts avf to an equivalent List expression for AVF \
operations.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"involute", "::", "usage"}], "=", 
   "\"\<involute[CAV] changes sign of all odd grades of a CAV form.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lie", "::", "usage"}], "=", 
   "\"\<lie[v, avf] returns the Lie derivative of avf with respect to the \
vector v.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"liealgebra", "::", "usage"}], "=", 
   "\"\<liealgebra[] returns the Lie algebra of the dual vectors to non-exact \
forms.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makealgebra", "::", "usage"}], "=", 
   "\"\<makealgebra[productmatrix] establishes the multiplication table for \
elements.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeall", "::", "usage"}], "=", 
   "\"\<makeall[] in CAV does makethetahat, makeomegahat, maketorsion and \
makecurvature.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeclifford", "::", "usage"}], "=", 
   "\"\<makeclifford[signaturelist] makes Clifford algebra with specified \
signature.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makecoords", "::", "usage"}], "=", 
   "\"\<makecoords[symbols] defines a set of independent scalars and \
partials.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makecurvature", "::", "usage"}], "=", 
   "\"\<makecurvature[] calculates the CAV 2-form \!\(\*OverscriptBox[\(\
\[CapitalOmega]\), \(^\)]\) from the connection 1-form \!\(\*OverscriptBox[\(\
\[Omega]\), \(^\)]\).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makedrules", "::", "usage"}], "=", 
   "\"\<makedrules[replacementlist] establishes drules for dforms, plus \
optional Rules.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeeinstein", "::", "usage"}], "=", 
   "\"\<makeeinstein[] makes a CAV 3-form \!\(\*OverscriptBox[\(G\), \
\(^\)]\)=(\!\(\*OverscriptBox[\(\[Theta]\), \(^\)]\) **\!\(\*OverscriptBox[\(\
\[CapitalOmega]\), \(^\)]\)+\!\(\*OverscriptBox[\(\[CapitalOmega]\), \
\(^\)]\)**\!\(\*OverscriptBox[\(\[Theta]\), \(^\)]\) )/2 (foudimensional \
Einstein tensor).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeelements", "::", "usage"}], "=", 
   "\"\<makeelements[symbols] establishes the list of generators for an \
algebra.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeforms", "::", "usage"}], "=", 
   "\"\<makeforms[symbols] establishes the list of fundamental non-exact \
1-forms.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeframe", "::", "usage"}], "=", 
   "\"\<makeframe[symbols] defines a set of orthonormal basis forms. They are \
stored in the global variable frame.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makematrices", "::", "usage"}], "=", 
   "\"\<makematrices[] constructs a matrix representation of the chosen \
Clifford algebra.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeomegahat", "::", "usage"}], "=", 
   "\"\<makeomegahat[] makes the generalized CAV connection 1-form \
\!\(\*OverscriptBox[OverscriptBox[\(\[Omega]\), \(^\)], \(\\\ \)]\).\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeorthonormalcurvature", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makescalars", "::", "usage"}], "=", 
   "\"\<makescalars[symbols] establishes the list of fundamental scalars \
(0-forms).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makethetahat", "::", "usage"}], "=", 
   "\"\<makethetahat[] makes the generalized CAV co-frame 1-form \
\!\(\*OverscriptBox[\(\[Theta]\), \(^\)]\).\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"maketorsion", "::", "usage"}], "=", 
   "\"\<maketorsion[] calculates the CAV 2-form \!\(\*OverscriptBox[\(\
\[CapitalTheta]\), \(^\)]\) from the CAV 1-forms \!\(\*OverscriptBox[\(\
\[Theta]\), \(^\)]\) and \!\(\*OverscriptBox[\(\[Omega]\), \(^\)]\).\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makevectors", "::", "usage"}], "=", 
   "\"\<makevectors[] makes a set of four lists named {vec1, vec2, vec3, \
vec4}.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matmult", "::", "usage"}], "=", 
   "\"\<matmult[m1, m2] performs multiplication of AVF matrices. It can be \
given in infix form using CircleTimes.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mtx", "::", "usage"}], "=", 
   "\"\<mtx[array] outputs the argument in MatrixForm. By default such \
argument is the global variable algebra.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"out", "::", "usage"}], "=", 
   "\"\<out[listavf] converts back the given avf in list form to a product of \
scalar, form and element. It is the inverse function of in.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"prune", "::", "usage"}], "=", 
   "\"\<prune[list, exp] keeps only those members of list that appear in exp.\
\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pullback", "::", "usage"}], "=", 
   "\"\<pullback[avf] pulls back avf into the subspace sub.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"reset", "::", "usage"}], "=", 
   "\"\<reset[] sets timer to zero.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"reverse", "::", "usage"}], "=", 
   "\"\<reverse[CAV] returns the reversion of CAV; it is equivalent to \
reversing all \!\(\*SubscriptBox[\(\[Gamma]\), \(i\)]\) products.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setzero", "::", "usage"}], "=", 
   "\"\<setzero[list] turns each argument of list into an equation to 0. \
\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"subspace", "::", "usage"}], "=", 
   "\"\<subspace[basislist] makes replacement list tosub for pullback.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"timer", "::", "usage"}], "=", 
   "\"\<timer[] returns elapsed time from most recent reset.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"torsionidentity", "::", "usage"}], "=", 
   "\"\<torsionidentity[] gives the general identity for CAV field \
\!\(\*OverscriptBox[\(\[CapitalTheta]\), \(^\)]\). Also known as Cartan \
identity.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zerocurvature", "::", "usage"}], "=", 
   "\"\<zerocurvature[] constructs a list of drules giving vanishing CAV \
curvature \!\(\*OverscriptBox[\(\[CapitalOmega]\), \(^\)]\).\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zerotorsion", "::", "usage"}], "=", 
   "\"\<zerotorsion[] constructs a list of drules giving vanishing CAV \
torsion \!\(\*OverscriptBox[OverscriptBox[\(\[CapitalTheta]\), \(^\)], \(\\\ \
\)]\).\>\""}], ";"}]}], "Input",
 InitializationCell->True],

Cell["Usage messages for global variables:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"adjlist", "::", "usage"}], "=", 
   "\"\<adjlist is a global variable containing an arbitrary permutation of \
the list elements.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"algebra", "::", "usage"}], "=", 
   "\"\<algebra is a global variable containing the multiplication table for \
the elements of an algebra.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"brackets", "::", "usage"}], "=", 
   "\"\<brackets is a global variable containing the Lie brackets for \
non-exact dual vectors.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cadim", "::", "usage"}], "=", 
   "\"\<cadim is a global variable containing the number of generators in the \
orthonormal basis of a clifford algebra.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"clifflist", "::", "usage"}], "=", 
   "\"\<clifflist is a global variable containing the list of the filenames \
in the CliffordAlgebra folder.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coords", "::", "usage"}], "=", 
   "\"\<coords is a global variable containing the list of scalars designated \
as independent variables.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coordsdim", "::", "usage"}], "=", 
   "\"\<coordsdim is a global variable containing the number of independent \
variables. It equals the length of the list coords.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cosub", "::", "usage"}], "=", 
   "\"\<cosub is a global variable containing the list of basis 1-forms to be \
annulled in a subspace.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"depend", "::", "usage"}], "=", 
   "\"\<depend is a global variable containing the list coords as a Sequence. \
It is used for function arguments.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dforms", "::", "usage"}], "=", 
   "\"\<dforms is a global variable containing the list of symbols for the \
exterior derivatives of the members of forms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"drules", "::", "usage"}], "=", 
   "\"\<drules is a global variable containing the list of replacement rules \
for the exterior derivatives of forms.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dscalars", "::", "usage"}], "=", 
   "\"\<dscalars is a global variable containing the list of symbols for the \
exterior derivatives of the list scalars.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eldim", "::", "usage"}], "=", 
   "\"\<eldim is a global variable containing the number of algebra elements. \
It equals the length of the list elements.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"elements", "::", "usage"}], "=", 
   "\"\<elements is a global variable containing the list of generators of \
the algebra specified by algebra.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fderiv", "::", "usage"}], "=", 
   "\"\<fderiv is a global variable containing the basic rules to give \
exterior derivatives of forms and dforms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fmdim", "::", "usage"}], "=", 
   "\"\<fmdim is a global variable containing the number of independent basis \
1-forms. It equals the length of the list forms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"forms", "::", "usage"}], "=", 
   "\"\<forms is a global variable containing the list of basis 1-forms \
generating the exterior algebra. It includes dscalars.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"frame", "::", "usage"}], "=", 
   "\"\<frame is a global variable containing the list of orthonomal basis \
forms.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"frdim", "::", "usage"}], "=", 
   "\"\<frdim is a global variable containing the number of orthonormal basis \
1-forms. It equals the length of the list frame.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gammas", "::", "usage"}], "=", 
   "\"\<gammas is a global variable containing all Clifford elements, \
retrieved from a file in the CliffordAlgebras folder.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"identity", "::", "usage"}], "=", 
   "\"\<identity represents the identity element of the initial trivial \
algebra.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"names", "::", "usage"}], "=", 
   "\"\<names is a global variable containing the list of all AVF and CAV \
variables and functions.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"natural", "::", "usage"}], "=", 
   "\"\<natural is a global variable containing the drules specifying closed \
basis 1-forms. This is the default value of drules.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"omegas", "::", "usage"}], "=", 
   "\"\<omegas is a global variable containing the first list of graded \
symbols for a complete set of CAV 1-forms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scalars", "::", "usage"}], "=", 
   "\"\<scalars is a global variable containing the list of 0-forms which \
will have exterior derivatives given by dscalars.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scdim", "::", "usage"}], "=", 
   "\"\<scdim is a global variable containing the number of scalars. It \
equals the length of the list scalars.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sderiv", "::", "usage"}], "=", 
   "\"\<sderiv is a global variable containing the basic rules to give \
exterior derivatives of scalars.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sig", "::", "usage"}], "=", 
   "\"\<sig[i] gives the ith eigenvalue, \!\(\*SubscriptBox[\(g\), \
\(ii\)]\),of the diagonal Clifford metric. It must be either +1 or -1.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"signature", "::", "usage"}], "=", 
   "\"\<signature is a global variable containing the list of all sig[i]. It \
is the argument for makeclifford[signature].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"skew", "::", "usage"}], "=", 
   "\"\<skew is a global variable containing the list of skew-symmetric \
structure constants: \!\(\*SubscriptBox[\(sk\), \(i, j, \
k\)]\)+\!\(\*SubscriptBox[\(sk\), \(i, k, j\)]\)=0.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sk", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sub", "::", "usage"}], "=", 
   "\"\<sub is a global variable containing the list of basis 1-forms \
spanning a subspace. It equals Complement[forms, cosub].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"symm", "::", "usage"}], "=", 
   "\"\<symm is a global variable containing the list of symmetric structure \
constants: \!\(\*SubscriptBox[\(sy\), \(i, j, \
k\)]\)-\!\(\*SubscriptBox[\(sy\), \(i, k, j\)]\)=0.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sy", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"thetas", "::", "usage"}], "=", 
   "\"\<thetas is a global variable containing the second list of graded \
symbols for a complete set of CAV 1-forms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"topartials", "::", "usage"}], "=", 
   "\"\<topartials is a global variable containing the list of rules to \
express exterior derivatives by partials.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tosub", "::", "usage"}], "=", 
   "\"\<tosub is a global variable containing the list of rules to annul \
cosub and d[cosub] in a subspace.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"trivial", "::", "usage"}], "=", 
   "\"\<trivial represents the initial default value of algebra, having \
identity in most positions. \>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec1", "::", "usage"}], "=", 
   "\"\<vec1 is the first of four independent vectors created by makevectors.\
\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec2", "::", "usage"}], "=", 
   "\"\<vec2 is the second of four independent vectors created by \
makevectors.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec3", "::", "usage"}], "=", 
   "\"\<vec3 is the third of four independent vectors created by makevectors.\
\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vec4", "::", "usage"}], "=", 
   "\"\<vec4 is the fourth of four independent vectors created by \
makevectors.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v1", "::", "usage"}], "=", 
   "\"\<\!\(\*SubscriptBox[\(v1\), \(i\)]\) is the ith component of the \
vector vec1 in the dual basis to forms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v2", "::", "usage"}], "=", 
   "\"\<\!\(\*SubscriptBox[\(v2\), \(i\)]\) is the ith component of the \
vector vec2 in the dual basis to forms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v3", "::", "usage"}], "=", 
   "\"\<\!\(\*SubscriptBox[\(v3\), \(i\)]\) is the ith component of the \
vector vec3 in the dual basis to forms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v4", "::", "usage"}], "=", 
   "\"\<\!\(\*SubscriptBox[\(v4\), \(i\)]\) is the ith component of the \
vector vec4 in the dual basis to forms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Omega]", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d\[Omega]", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalOmega]", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d\[CapitalOmega]", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d\[Theta]", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalTheta]", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d\[CapitalTheta]", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalGamma]", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"L", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"V", "::", "usage"}], "=", "\"\<\>\""}], ";"}]}], "Input",
 InitializationCell->True],

Cell["These are needed for the Riemann part of the code:", "Text"],

Cell[BoxData[{
 RowBox[{"R", ";"}], "\[IndentingNewLine]", 
 RowBox[{"ONFvalue", ";"}]}], "Input",
 InitializationCell->True],

Cell["These are needed for the Characters part of the code:", "Text"],

Cell[BoxData[{
 RowBox[{"characters", ";"}], "\[IndentingNewLine]", 
 RowBox[{"maxrandom", ";"}], "\[IndentingNewLine]", 
 RowBox[{"maxnum", 
  ";"}], "\[IndentingNewLine]", "pforms", "\[IndentingNewLine]", 
 RowBox[{"embeddingforms", ";"}], "\[IndentingNewLine]", 
 RowBox[{"fieldforms", ";"}], "\[IndentingNewLine]", 
 RowBox[{"subR\[Theta]", ";"}], "\[IndentingNewLine]", 
 RowBox[{"solutionvectors", ";"}], "\[IndentingNewLine]", 
 RowBox[{"involutoryvectors", ";"}], "\[IndentingNewLine]", 
 RowBox[{"allones", ";"}], "\[IndentingNewLine]", 
 RowBox[{"check", ";"}], "\[IndentingNewLine]", 
 RowBox[{"genvec", ";"}], "\[IndentingNewLine]", 
 RowBox[{"invset", ";"}], "\[IndentingNewLine]", 
 RowBox[{"idealforms", ";"}], "\[IndentingNewLine]", 
 RowBox[{"absentforms", ";"}], "\[IndentingNewLine]", 
 RowBox[{"cauchys", ";"}], "\[IndentingNewLine]", 
 RowBox[{"checkinvolution", ";"}], "\[IndentingNewLine]", 
 RowBox[{"chars", ";"}], "\[IndentingNewLine]", 
 RowBox[{"charv", ";"}]}], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Handling of global variables", "Subsection"],

Cell[TextData[{
 "These three symbols (and one more at the end of the package) have been \
added by Jose to help in keeping track of the internal state of global \
variables of ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 "."
}], "Text"],

Cell["Report the current ownvalues of the global variables:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AVFstate", ":=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\"\<adjlist\>\"", ",", "\"\<algebra\>\"", ",", "\"\<brackets\>\"", 
       ",", "\"\<cadim\>\"", ",", "\"\<clifflist\>\"", ",", 
       "\"\<cliffname\>\"", ",", "\"\<coords\>\"", ",", "\"\<coordsdim\>\"", 
       ",", "\"\<cosub\>\"", ",", "\"\<depend\>\"", ",", "\"\<dforms\>\"", 
       ",", "\"\<drules\>\"", ",", "\"\<dscalars\>\"", ",", "\"\<eldim\>\"", 
       ",", "\"\<elements\>\"", ",", "\"\<fderiv\>\"", ",", "\"\<fmdim\>\"", 
       ",", "\"\<forms\>\"", ",", "\"\<frame\>\"", ",", "\"\<frdim\>\"", ",", 
       "\"\<gammas\>\"", ",", "\"\<identity\>\"", ",", "\"\<natural\>\"", 
       ",", "\"\<omegas\>\"", ",", "\"\<scalars\>\"", ",", "\"\<scdim\>\"", 
       ",", "\"\<sderiv\>\"", ",", "\"\<sig\>\"", ",", "\"\<signature\>\"", 
       ",", "\"\<skew\>\"", ",", "\"\<sub\>\"", ",", "\"\<symm\>\"", ",", 
       "\"\<thetas\>\"", ",", "\"\<topartials\>\"", ",", "\"\<tosub\>\"", 
       ",", "\"\<trivial\>\"", ",", "\"\<vec1\>\"", ",", "\"\<vec2\>\"", ",", 
       "\"\<vec3\>\"", ",", "\"\<vec4\>\"", ",", "\"\<v1\>\"", ",", 
       "\"\<v2\>\"", ",", "\"\<v3\>\"", ",", "\"\<v4\>\"", ",", 
       "\"\<\[Omega]\>\"", ",", "\"\<d\[Omega]\>\"", ",", 
       "\"\<\!\(\*TagBox[OverscriptBox[\"\[Omega]\", \"^\"],
HoldForm]\)\>\"", ",", "\"\<\[CapitalOmega]\>\"", ",", 
       "\"\<d\[CapitalOmega]\>\"", ",", "\"\<\[Theta]\>\"", ",", 
       "\"\<d\[Theta]\>\"", ",", 
       "\"\<\!\(\*TagBox[OverscriptBox[\"\[Theta]\", \"^\"],
HoldForm]\)\>\"", ",", "\"\<\[CapitalTheta]\>\"", ",", 
       "\"\<d\[CapitalTheta]\>\"", ",", "\"\<\[CapitalGamma]\>\"", ",", 
       "\"\<L\>\"", ",", "\"\<V\>\"", ",", "\"\<av$34\>\"", ",", 
       "\"\<av$35\>\"", ",", "\"\<av$44\>\"", ",", "\"\<av$49\>\"", ",", 
       "\"\<av$55\>\"", ",", "\"\<av$63\>\"", ",", "\"\<av$92\>\"", ",", 
       "\"\<av$93\>\"", ",", "\"\<av$94\>\"", ",", "\"\<av$fg\>\"", ",", 
       "\"\<av$cs\>\"", ",", "\"\<av$c\>\"", ",", "\"\<av$star\>\"", ",", 
       "\"\<av$fm\>\"", ",", "\"\<av$0\>\"", ",", "\"\<av$h\>\"", ",", 
       "\"\<av$x\>\"", ",", "\"\<av$null\>\"", ",", "\"\<spintable\>\"", ",", 
       "\"\<omdim\>\"", ",", "\"\<R\>\"", ",", "\"\<maxrandom\>\"", ",", 
       "\"\<embeddingforms\>\"", ",", "\"\<fieldforms\>\"", ",", 
       "\"\<solutionvectors\>\"", ",", "\"\<involutoryvectors\>\"", ",", 
       "\"\<allones\>\"", ",", "\"\<genvec\>\"", ",", "\"\<invset\>\"", ",", 
       "\"\<idealforms\>\"", ",", "\"\<absentforms\>\"", ",", 
       "\"\<cauchys\>\"", ",", "\"\<checkinvolution\>\""}], "}"}], "\[Rule]", 
     
     RowBox[{"HoldForm", "/@", 
      RowBox[{"{", 
       RowBox[{
       "adjlist", ",", "algebra", ",", "brackets", ",", "cadim", ",", 
        "clifflist", ",", "xAct`AVF`Private`cliffname", ",", "coords", ",", 
        "coordsdim", ",", "cosub", ",", 
        RowBox[{"Hold", "[", "depend", "]"}], ",", "dforms", ",", "drules", 
        ",", "dscalars", ",", "eldim", ",", "elements", ",", "fderiv", ",", 
        "fmdim", ",", "forms", ",", "frame", ",", "frdim", ",", "gammas", ",",
         "identity", ",", "natural", ",", "omegas", ",", "scalars", ",", 
        "scdim", ",", "sderiv", ",", "sig", ",", "signature", ",", "skew", 
        ",", "sub", ",", "symm", ",", "thetas", ",", "topartials", ",", 
        "tosub", ",", "trivial", ",", "vec1", ",", "vec2", ",", "vec3", ",", 
        "vec4", ",", "v1", ",", "v2", ",", "v3", ",", "v4", ",", "\[Omega]", 
        ",", "d\[Omega]", ",", 
        RowBox[{"OverHat", "[", "\[Omega]", "]"}], ",", "\[CapitalOmega]", 
        ",", "d\[CapitalOmega]", ",", "\[Theta]", ",", "d\[Theta]", ",", 
        RowBox[{"OverHat", "[", "\[Theta]", "]"}], ",", "\[CapitalTheta]", 
        ",", "d\[CapitalTheta]", ",", "\[CapitalGamma]", ",", "L", ",", "V", 
        ",", "xAct`AVF`Private`av$34", ",", "xAct`AVF`Private`av$35", ",", 
        "xAct`AVF`Private`av$44", ",", "xAct`AVF`Private`av$49", ",", 
        "xAct`AVF`Private`av$55", ",", "xAct`AVF`Private`av$63", ",", 
        "xAct`AVF`Private`av$92", ",", "xAct`AVF`Private`av$93", ",", 
        "xAct`AVF`Private`av$94", ",", "xAct`AVF`Private`av$fg", ",", 
        "xAct`AVF`Private`av$cs", ",", "xAct`AVF`Private`av$c", ",", 
        "xAct`AVF`Private`av$star", ",", "xAct`AVF`Private`av$fm", ",", 
        "xAct`AVF`Private`av$0", ",", "xAct`AVF`Private`av$h", ",", 
        "xAct`AVF`Private`av$x", ",", "xAct`AVF`Private`av$null", ",", 
        "xAct`AVF`Private`spintable", ",", "xAct`AVF`Private`omdim", ",", "R",
         ",", "maxrandom", ",", "embeddingforms", ",", "fieldforms", ",", 
        "solutionvectors", ",", "involutoryvectors", ",", "allones", ",", 
        "genvec", ",", "invset", ",", "idealforms", ",", "absentforms", ",", 
        "cauchys", ",", "checkinvolution"}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Find which global variables have been modified with respect to their original \
value:\
\>", "Text"],

Cell[BoxData[
 RowBox[{"ModifiedGlobalVariables", ":=", 
  RowBox[{"Delete", "[", 
   RowBox[{
    RowBox[{"First", "/@", "AVFstate"}], ",", 
    RowBox[{
     RowBox[{"Position", "[", 
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{"AVFinitialstate", "\[Equal]", "AVFstate"}], "]"}], ",", 
       "True", ",", 
       RowBox[{"{", "1", "}"}]}], "]"}], "/.", 
     RowBox[{
      RowBox[{"{", "}"}], "\[Rule]", 
      RowBox[{"List", "/@", 
       RowBox[{"Range", "[", 
        RowBox[{"Length", "@", "AVFstate"}], "]"}]}]}]}]}], "]"}]}]], "Input",
 
 InitializationCell->True],

Cell["\<\
Restore most (not all) global variables to their original trivial value:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"makeclear", "[", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"makeelements", "[", 
     RowBox[{"{", "identity", "}"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"makealgebra", "[", 
     RowBox[{"{", 
      RowBox[{"{", "identity", "}"}], "}"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"makeclifford", "[", 
     RowBox[{"{", "}"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"makeframe", "[", 
     RowBox[{"{", "}"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"makeforms", "[", 
     RowBox[{"{", "}"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"makecoords", "[", 
     RowBox[{"{", "}"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"makescalars", "[", 
     RowBox[{"{", "}"}], "]"}], ";"}], "\[IndentingNewLine]", 
   ")"}]}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Begin private", "Subsection"],

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->True],

Cell["Private directory for the package:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$AVFDir", "=", 
   RowBox[{"$xActDirectory", "<>", "\"\</AVF\>\""}]}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AVF code", "Section"],

Cell[CellGroupData[{

Cell["Tools", "Subsection"],

Cell["\<\
This code was present in the original, but now it is not needed.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Off", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"General", "::", "spell"}], ",", "\[IndentingNewLine]", 
    RowBox[{"General", "::", "spell1"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Set", "::", "wrsym"}], ",", "\[IndentingNewLine]", 
    RowBox[{"SetDelayed", "::", "write"}], ",", "\[IndentingNewLine]", 
    RowBox[{"SetDelayed", "::", "wrsym"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Syntax", "::", "newl"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 Evaluatable->False],

Cell["\<\
Timings. Note that it uses the global private variable av$bt.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"timer", "[", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Elapsed time = \>\"", ",", 
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"AbsoluteTime", "[", "]"}], "-", "av$bt"}], "]"}], ",", 
      "\"\< sec.\>\""}], "]"}], ")"}]}], ";", 
  RowBox[{
   RowBox[{"reset", "[", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"av$bt", "=", 
      RowBox[{"AbsoluteTime", "[", "]"}]}], ";"}], ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["List of names.", "Text"],

Cell[BoxData[
 RowBox[{"names", ":=", 
  RowBox[{"Names", "[", "\"\<xAct`AVF`*\>\"", "]"}]}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Algebra preliminaries", "Subsection"],

Cell["\<\
Declare the list of generators (called \[OpenCurlyDoubleQuote]elements\
\[CloseCurlyDoubleQuote]) for an algebra. Store information in elements and \
eldim. The global variable adjlist will be used to hold an arbitrary \
permutation of elements, and it is initialized to elements itself.\
\>", "Text"],

Cell["\<\
Renamed:
\tav$g\t->\telems
\tav$s30 \t->\tvalidateelements\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeelements", "[", "elems_List", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"validateelements", "[", "elems", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Unprotect", "[", 
      RowBox[{"eldim", ",", "elements"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"elements", "=", "elems"}], ";", "\[IndentingNewLine]", 
     RowBox[{"eldim", "=", 
      RowBox[{"Length", "[", "elements", "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"Protect", "[", 
      RowBox[{"eldim", ",", "elements"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"adjlist", "=", "elements"}]}], "\[IndentingNewLine]", ")"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Declare an algebra by providing its product table. The first row and first \
column are rewritten with the generators in elements (meaning that the first \
element is assumed to be the identity). A second argument allows prepending a \
new generator, which is then assumed to be the identity. (Note the hack of \
using id==True when the second argument is not used.) The table is stored in \
the variable algebra.\
\>", "Text"],

Cell["\<\
Renamed:
\tav$g\t->\tptab
\tav$g1 \t->\tid\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makealgebra", "[", 
    RowBox[{"ptab_", ",", 
     RowBox[{"id_:", "True"}]}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$1", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Unprotect", "[", "algebra", "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"av$1", "=", 
       RowBox[{"Length", "[", 
        RowBox[{"ptab", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"If", "[", 
       RowBox[{"id", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"algebra", "=", "ptab"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Do", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"algebra", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "i$1"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{"algebra", "[", 
              RowBox[{"[", 
               RowBox[{"i$1", ",", "1"}], "]"}], "]"}], "=", 
             RowBox[{"elements", "[", 
              RowBox[{"[", "i$1", "]"}], "]"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i$1", ",", "av$1"}], "}"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Protect", "[", "algebra", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Return", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"makeelements", "[", 
       RowBox[{"Prepend", "[", 
        RowBox[{"elements", ",", "id"}], "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$1", "=", 
       RowBox[{"av$1", "+", "1"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"algebra", "=", 
       RowBox[{"IdentityMatrix", "[", "av$1", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"algebra", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "i$1"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"algebra", "[", 
           RowBox[{"[", 
            RowBox[{"i$1", ",", "1"}], "]"}], "]"}], "=", 
          RowBox[{"elements", "[", 
           RowBox[{"[", "i$1", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "av$1"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"algebra", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i$3", "+", "1"}], ",", 
             RowBox[{"i$2", "+", "1"}]}], "]"}], "]"}], "=", 
          RowBox[{"ptab", "[", 
           RowBox[{"[", 
            RowBox[{"i$3", ",", "i$2"}], "]"}], "]"}]}], ";", "  ", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Repeated", " ", "!"}], "?"}], " ", "*)"}], 
         RowBox[{
          RowBox[{"algebra", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i$2", "+", "1"}], ",", 
             RowBox[{"i$3", "+", "1"}]}], "]"}], "]"}], "=", 
          RowBox[{"ptab", "[", 
           RowBox[{"[", 
            RowBox[{"i$2", ",", "i$3"}], "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"av$1", "-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"av$1", "-", "1"}]}], "}"}]}], "\[IndentingNewLine]", "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "algebra", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Print the product table in formatted form:", "Text"],

Cell["\<\
Renamed:
\tav$g\t->\tptab\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mtx", "[", 
    RowBox[{"ptab_:", "algebra"}], "]"}], ":=", 
   RowBox[{"MatrixForm", "[", "ptab", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Construct two special set of structure constants: the symmetric and the \
antisymmetric ones. I don\[CloseCurlyQuote]t understand this construction. \
The symbols sy and sk seem to leak out.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"generic", "[", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"symm", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["sy", 
          RowBox[{"j$1", ",", "j$2", ",", "j$3"}]], ",", 
         RowBox[{"{", 
          RowBox[{"j$1", ",", "0", ",", 
           RowBox[{"eldim", "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j$2", ",", 
           RowBox[{"eldim", "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j$3", ",", "j$2", ",", 
           RowBox[{"eldim", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"skew", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["sk", 
          RowBox[{"j$1", ",", "j$2", ",", "j$3"}]], ",", 
         RowBox[{"{", 
          RowBox[{"j$1", ",", "0", ",", 
           RowBox[{"eldim", "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j$2", ",", 
           RowBox[{"eldim", "-", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j$3", ",", 
           RowBox[{"j$2", "+", "1"}], ",", 
           RowBox[{"eldim", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Which", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"j$2", "*", "j$3"}], "==", "0"}], ",", 
         RowBox[{"elements", "[", 
          RowBox[{"[", 
           RowBox[{"j$2", "+", "1"}], "]"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"j$2", "==", "j$3"}], ",", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            SubscriptBox["sy", 
             RowBox[{"j$1", ",", "j$2", ",", "j$3"}]], 
            RowBox[{"elements", "[", 
             RowBox[{"[", 
              RowBox[{"j$1", "+", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"j$1", ",", "0", ",", 
             RowBox[{"eldim", "-", "1"}]}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"j$2", "<", "j$3"}], ",", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["sy", 
               RowBox[{"j$1", ",", "j$2", ",", "j$3"}]], "+", " ", 
              SubscriptBox["sk", 
               RowBox[{"j$1", ",", "j$2", ",", "j$3"}]]}], ")"}], 
            RowBox[{"elements", "[", 
             RowBox[{"[", 
              RowBox[{"j$1", "+", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"j$1", ",", "0", ",", 
             RowBox[{"eldim", "-", "1"}]}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"j$2", ">", "j$3"}], ",", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["sy", 
               RowBox[{"j$1", ",", "j$3", ",", "j$2"}]], "-", " ", 
              SubscriptBox["sk", 
               RowBox[{"j$1", ",", "j$3", ",", "j$2"}]]}], ")"}], 
            RowBox[{"elements", "[", 
             RowBox[{"[", 
              RowBox[{"j$1", "+", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"j$1", ",", "0", ",", 
             RowBox[{"eldim", "-", "1"}]}], "}"}]}], "]"}]}], 
        "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"j$2", ",", "0", ",", 
         RowBox[{"eldim", "-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"j$3", ",", "0", ",", 
         RowBox[{"eldim", "-", "1"}]}], "}"}]}], "\[IndentingNewLine]", 
      "]"}]}], "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Differential forms preliminaries", "Subsection"],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"Wedge", ",", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "OneIdentity"}], "}"}]}], "]"}]], "Input",
 InitializationCell->True],

Cell["\<\
Declare a list of fundamental non-exact forms. Various properties are stored \
in various global variables, some of them with really strange names... In \
particular note the switch av$fg that sets the list natural to be rules dform \
-> 0 for all those non-exact forms.\
\>", "Text"],

Cell["\<\
Renamed:
\tav$g\t->\telems
\tav$s30\t->\tvalidateelements
\tav$g1\t->\tnodscs
Blocked:
\tnodscs\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeforms", "[", "elems_List", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "nodscs", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"validateelements", "[", "elems", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Unprotect", "[", 
       RowBox[{
       "fmdim", ",", "forms", ",", "dforms", ",", "fderiv", ",", "sderiv", 
        ",", "natural", ",", "av$c", ",", "av$bs", ",", "av$cs"}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"nodscs", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"elems", ",", 
         RowBox[{"dsc_", "/;", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"dscalars", ",", "dsc"}], "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"forms", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"nodscs", ",", "dscalars"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"fmdim", "=", 
       RowBox[{"Length", "[", "forms", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dforms", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"prependinhead", "[", 
          RowBox[{"d", ",", 
           RowBox[{"forms", "[", 
            RowBox[{"[", "i$1", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", 
           RowBox[{"fmdim", "-", "scdim"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$bs", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", "av$fm", "}"}], ",", "forms", ",", "dforms"}], "]"}]}], 
      ";", "\t", "\[IndentingNewLine]", 
      RowBox[{"fderiv", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"av$fm", "->", "0"}], "}"}], ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"dforms", "[", 
                RowBox[{"[", "i$2", "]"}], "]"}], "->", "0"}], ",", 
              RowBox[{
               RowBox[{"forms", "[", 
                RowBox[{"[", "i$2", "]"}], "]"}], "->", 
               RowBox[{"dforms", "[", 
                RowBox[{"[", "i$2", "]"}], "]"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i$2", ",", 
              RowBox[{"fmdim", "-", "scdim"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"forms", "[", 
              RowBox[{"[", 
               RowBox[{"fmdim", "-", "scdim", "+", "i$1"}], "]"}], "]"}], "->",
              "0"}], ",", 
            RowBox[{"{", 
             RowBox[{"i$1", ",", "scdim"}], "}"}]}], "]"}]}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"sderiv", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Dt", "[", 
           RowBox[{"scalars", "[", 
            RowBox[{"[", "i$1", "]"}], "]"}], "]"}], "->", 
          RowBox[{"dscalars", "[", 
           RowBox[{"[", "i$1", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", "scdim"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"av$fg", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"natural", "=", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"dforms", "[", 
              RowBox[{"[", "i$1", "]"}], "]"}], "->", "0"}], ",", 
            RowBox[{"{", 
             RowBox[{"i$1", ",", 
              RowBox[{"fmdim", "-", "scdim"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"makedrules", "[", "natural", "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$fg", "=", "True"}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$cs", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["av$c", "i$1"], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", "fmdim"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"makevectors", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", 
       RowBox[{
       "fmdim", ",", "forms", ",", "dforms", ",", "fderiv", ",", "sderiv", 
        ",", "natural", ",", "av$c", ",", "av$bs", ",", "av$cs"}], "]"}], ";",
       "\[IndentingNewLine]", "forms"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Curious function to create simple vectors, stored in variables vec1 to vec4, \
with components subscripted v1 to v4 in the dual basis forms. This is quite \
ugly.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makevectors", "[", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["v1", "i$1"], "=", 
         RowBox[{
          SubscriptBox["v2", "i$1"], "=", 
          RowBox[{
           SubscriptBox["v3", "i$1"], "=", 
           RowBox[{
            SubscriptBox["v4", "i$1"], "=", "0"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         SubscriptBox["v1", "i$1"], "=."}], ";", "\[IndentingNewLine]", 
        RowBox[{
         SubscriptBox["v2", "i$1"], "=."}], ";", "\[IndentingNewLine]", 
        RowBox[{
         SubscriptBox["v3", "i$1"], "=."}], ";", "\[IndentingNewLine]", 
        RowBox[{
         SubscriptBox["v4", "i$1"], "=."}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i$1", ",", "fmdim"}], "}"}]}], "\[IndentingNewLine]", "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"vec1", "=", 
      RowBox[{"av$cs", "/.", 
       RowBox[{"av$c", "->", "v1"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vec2", "=", 
      RowBox[{"av$cs", "/.", 
       RowBox[{"av$c", "->", "v2"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vec3", "=", 
      RowBox[{"av$cs", "/.", 
       RowBox[{"av$c", "->", "v3"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vec4", "=", 
      RowBox[{"av$cs", "/.", 
       RowBox[{"av$c", "->", "v4"}]}]}], ";"}], "\[IndentingNewLine]", 
    ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Declare a list of scalars. This function keeps the old non-exact forms (at \
the beginning of the list forms), and replaces the old scalars with the new \
scalars. The switch av$fg is set to False before calling makeforms, and hence \
the list natural will not be constructed.\
\>", "Text"],

Cell["\<\
Renamed:
\tav$g\t->\telems
\tav$s30\t->\tvalidateelements
\tav$s20\t->\tprependinhead\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makescalars", "[", "elems_List", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$55", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"validateelements", "[", "elems", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Unprotect", "[", 
       RowBox[{"scdim", ",", "scalars", ",", "dscalars"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$55", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"forms", ",", 
         RowBox[{"fmdim", "-", "scdim"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"scalars", "=", "elems"}], ";", "\[IndentingNewLine]", 
      RowBox[{"scdim", "=", 
       RowBox[{"Length", "[", "scalars", "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"dscalars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"prependinhead", "[", 
          RowBox[{"d", ",", 
           RowBox[{"scalars", "[", 
            RowBox[{"[", "i$1", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", "scdim"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$fg", "=", "False"}], ";", "\[IndentingNewLine]", 
      RowBox[{"makeforms", "[", "av$55", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", 
       RowBox[{"scdim", ",", "scalars", ",", "dscalars"}], "]"}], ";", 
      "\[IndentingNewLine]", "scalars"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Complicated code that declares a list of scalars as coordinates. In principle \
this list is asumed to be a sublist of the list scalars, but if they are not \
there then they are added.\
\>", "Text"],

Cell["\<\
Renamed:
\tav$g\t->\telems
Note that av$id cannot be blocked because there is a definition for D here \
that needs to remember its value after leaving this function.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"makecoords", "[", "elems_List", "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Unprotect", "[", 
        RowBox[{
        "coords", ",", "coordsdim", ",", "depend", ",", "topartials"}], "]"}],
        ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Format", "[", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"av$z_", "[", "depend", "]"}], ",", 
             RowBox[{"coords", "[", 
              RowBox[{"[", "j$3", "]"}], "]"}]}], "]"}], "]"}], "=."}], ",", 
         RowBox[{"{", 
          RowBox[{"j$3", ",", "coordsdim"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Format", "[", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{
               RowBox[{"av$z_", "[", "depend", "]"}], ",", 
               RowBox[{"coords", "[", 
                RowBox[{"[", "j$3", "]"}], "]"}]}], "]"}], ",", 
             RowBox[{"coords", "[", 
              RowBox[{"[", "j$4", "]"}], "]"}]}], "]"}], "]"}], "=."}], ",", 
         RowBox[{"{", 
          RowBox[{"j$3", ",", "coordsdim"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j$4", ",", "j$3", ",", "coordsdim"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"makescalars", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"elems", ",", 
          RowBox[{"Complement", "[", 
           RowBox[{"scalars", ",", "elems"}], "]"}]}], "]"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"coords", "=", "elems"}], ";", "\[IndentingNewLine]", 
       RowBox[{"coordsdim", "=", 
        RowBox[{"Length", "[", "coords", "]"}]}], ";", "\[IndentingNewLine]", 
       
       RowBox[{"depend", "=", 
        RowBox[{"coords", "/.", 
         RowBox[{"List", "->", "Sequence"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Jose", ":", " ", 
          RowBox[{
          "These", " ", "two", " ", "are", " ", "a", " ", "dangerous", " ", 
           "definitions"}]}], ",", " ", 
         RowBox[{"because", " ", "they", " ", "cannot", " ", "use", " ", 
          RowBox[{"SetDelayed", ".", " ", "They"}], " ", "need", " ", "to", 
          " ", "do", " ", "the", " ", "loop", " ", "right", " ", "now"}]}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Format", "[", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"av$z_", "[", "depend", "]"}], ",", 
             RowBox[{"coords", "[", 
              RowBox[{"[", "j$3", "]"}], "]"}]}], "]"}], "]"}], "=", 
          RowBox[{"Subscript", "[", 
           RowBox[{"av$z", ",", 
            RowBox[{"coords", "[", 
             RowBox[{"[", "j$3", "]"}], "]"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j$3", ",", "coordsdim"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Format", "[", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{
               RowBox[{"av$z_", "[", "depend", "]"}], ",", 
               RowBox[{"coords", "[", 
                RowBox[{"[", "j$3", "]"}], "]"}]}], "]"}], ",", 
             RowBox[{"coords", "[", 
              RowBox[{"[", "j$4", "]"}], "]"}]}], "]"}], "]"}], "=", 
          RowBox[{"Subscript", "[", 
           RowBox[{"av$z", ",", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{"coords", "[", 
               RowBox[{"[", "j$3", "]"}], "]"}], "]"}], "<>", 
             RowBox[{"ToString", "[", " ", 
              RowBox[{"coords", "[", 
               RowBox[{"[", "j$4", "]"}], "]"}], "]"}]}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j$3", ",", "coordsdim"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j$4", ",", "j$3", ",", "coordsdim"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"topartials", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"dscalars", "[", 
            RowBox[{"[", "j$1", "]"}], "]"}], "->", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"D", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"scalars", "[", 
                  RowBox[{"[", "j$1", "]"}], "]"}], "[", "depend", "]"}], ",", 
                RowBox[{"coords", "[", 
                 RowBox[{"[", "j$2", "]"}], "]"}]}], "]"}], " ", 
              RowBox[{"dscalars", "[", 
               RowBox[{"[", "j$2", "]"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"j$2", ",", "coordsdim"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j$1", ",", 
            RowBox[{"1", "+", "coordsdim"}], ",", "scdim"}], "}"}]}], "]"}]}],
        ";", "\[IndentingNewLine]", 
       RowBox[{"av$id", ":=", 
        RowBox[{"IdentityMatrix", "[", 
         RowBox[{"fmdim", "-", "scdim", "+", "coordsdim"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         SubscriptBox["D", "av$gu_"], "[", "av$gx_", "]"}], ":=", 
        RowBox[{"Block", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"av$dr", ",", "av$ret"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"av$dr", "=", "drules"}], ";", "\[IndentingNewLine]", 
           RowBox[{"makedrules", "[", "topartials", "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Head", "[", "av$gu", "]"}], "===", "Integer"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"av$ret", "=", 
              RowBox[{
               RowBox[{"av$id", "[", 
                RowBox[{"[", 
                 RowBox[{"fmdim", "-", "scdim", "+", "av$gu"}], "]"}], "]"}], 
               "\[SmallCircle]", 
               RowBox[{"d", "[", "av$gx", "]"}]}]}], ",", 
             RowBox[{"av$ret", "=", 
              RowBox[{
               RowBox[{"Flatten", "[", 
                RowBox[{"Extract", "[", 
                 RowBox[{"av$id", ",", 
                  RowBox[{"fmdim", "-", "scdim", "+", 
                   RowBox[{"Position", "[", 
                    RowBox[{"coords", ",", "av$gu"}], "]"}]}]}], "]"}], "]"}],
                "\[SmallCircle]", 
               RowBox[{"d", "[", "av$gx", "]"}]}]}]}], "\[IndentingNewLine]", 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"makedrules", "[", "av$dr", "]"}], ";", 
           "\[IndentingNewLine]", "av$ret"}]}], "\[IndentingNewLine]", 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"makedrules", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"drules", ",", "topartials"}], "]"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Protect", "[", 
        RowBox[{
        "coords", ",", "coordsdim", ",", "depend", ",", "topartials"}], "]"}],
        ";", "\[IndentingNewLine]", "coords"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Jose", ":", " ", 
    RowBox[{
    "added", " ", "initial", " ", "value", " ", "for", " ", "coords", " ", 
     "and", " ", "topartials"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coords", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topartials", "=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Declare a frame. Note that the signs of the elements of the original list are \
converted into a signature specification.\
\>", "Text"],

Cell["\<\
Renamed:
\tav$g\t->\telems
Blocked:
\tav$31
\tav$32
\tav$33\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeframe", "[", 
    RowBox[{"{", "}"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Unprotect", "[", 
       RowBox[{"frame", ",", "frdim"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ValueQ", "[", "frame", "]"}], ",", 
        RowBox[{"frame", "=."}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ValueQ", "[", "frdim", "]"}], ",", 
        RowBox[{"frdim", "=."}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ValueQ", "[", "signature", "]"}], ",", 
        RowBox[{"signature", "=."}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeframe", "[", "elems_List", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$31", ",", "av$32", ",", "av$33"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Unprotect", "[", 
       RowBox[{"frame", ",", "frdim"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"frdim", "=", 
       RowBox[{"Length", "[", "elems", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"signature", "=", 
       RowBox[{"av$31", "=", 
        RowBox[{"av$32", "=", 
         RowBox[{"{", "}"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"av$33", "=", 
          RowBox[{"elems", "[", 
           RowBox[{"[", "i$7", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Head", "[", "av$33", "]"}], "===", "Times"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"AppendTo", "[", 
             RowBox[{"av$31", ",", 
              RowBox[{"-", "av$33"}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"av$32", ",", 
              RowBox[{"-", "1"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"AppendTo", "[", 
             RowBox[{"av$31", ",", "av$33"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"av$32", ",", "1"}], "]"}]}]}], "\[IndentingNewLine]", 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$7", ",", "frdim"}], "}"}]}], "\[IndentingNewLine]", "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"frame", "=", 
       RowBox[{"Sort", "[", "av$31", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sig", "[", "i$7", "]"}], "=", 
          RowBox[{
           RowBox[{"Extract", "[", 
            RowBox[{"av$32", ",", 
             RowBox[{"Position", "[", 
              RowBox[{"av$31", ",", 
               RowBox[{"frame", "[", 
                RowBox[{"[", "i$7", "]"}], "]"}]}], "]"}]}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"signature", ",", 
           RowBox[{"sig", "[", "i$7", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$7", ",", "frdim"}], "}"}]}], "\[IndentingNewLine]", "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"av$fg", "=", "False"}], ";", "\[IndentingNewLine]", 
      RowBox[{"makeforms", "[", 
       RowBox[{"Join", "[", 
        RowBox[{"frame", ",", 
         RowBox[{"Complement", "[", 
          RowBox[{"forms", ",", "frame"}], "]"}]}], "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$s82", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", 
       RowBox[{"frame", ",", "frdim"}], "]"}], ";", "\[IndentingNewLine]", 
      "frame"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Auxiliary code for the previous function, declaring the Hodge dual of the \
frame. It is capable of dealing with frames of up to 6 elements.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s82", "[", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"av$star", "[", 
       RowBox[{"{", "av$fm", "}"}], "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "frame"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$star", "[", "frame", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"sig", "[", "i$3", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", "frdim"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", "av$fm", "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"frdim", "==", "1"}], ",", 
       RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"av$star", "[", 
         RowBox[{"{", 
          RowBox[{"frame", "[", 
           RowBox[{"[", "i$1", "]"}], "]"}], "}"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"i$1", "-", "1"}], ")"}]}], 
           RowBox[{"sig", "[", "i$1", "]"}]}], " ", ",", 
          RowBox[{"Delete", "[", 
           RowBox[{"frame", ",", 
            RowBox[{"{", "i$1", "}"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i$1", ",", "frdim"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"frdim", "==", "2"}], ",", 
       RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"av$star", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$1", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$2", "]"}], "]"}]}], "}"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"i$1", "+", "i$2", "-", "1"}], ")"}]}], 
           RowBox[{"sig", "[", "i$1", "]"}], " ", 
           RowBox[{"sig", "[", "i$2", "]"}]}], ",", 
          RowBox[{"Delete", "[", 
           RowBox[{"frame", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "i$1", "}"}], ",", 
              RowBox[{"{", "i$2", "}"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i$1", ",", 
         RowBox[{"frdim", "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$2", ",", 
         RowBox[{"i$1", "+", "1"}], ",", "frdim"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"frdim", "==", "3"}], ",", 
       RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"av$star", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$1", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$2", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$3", "]"}], "]"}]}], "}"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"i$1", "+", "i$2", "+", "i$3"}], ")"}]}], 
           RowBox[{"sig", "[", "i$1", "]"}], " ", 
           RowBox[{"sig", "[", "i$2", "]"}], 
           RowBox[{"sig", "[", "i$3", "]"}]}], ",", 
          RowBox[{"Delete", "[", 
           RowBox[{"frame", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "i$1", "}"}], ",", 
              RowBox[{"{", "i$2", "}"}], ",", 
              RowBox[{"{", "i$3", "}"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i$1", ",", 
         RowBox[{"frdim", "-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$2", ",", 
         RowBox[{"i$1", "+", "1"}], ",", 
         RowBox[{"frdim", "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$3", ",", 
         RowBox[{"i$2", "+", "1"}], ",", "frdim"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"frdim", "==", "4"}], ",", 
       RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"av$star", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$1", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$2", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$3", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$4", "]"}], "]"}]}], "}"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"i$1", "+", "i$2", "+", "i$3", "+", "i$4"}], ")"}]}], 
           RowBox[{"sig", "[", "i$1", "]"}], " ", 
           RowBox[{"sig", "[", "i$2", "]"}], 
           RowBox[{"sig", "[", "i$3", "]"}], 
           RowBox[{"sig", "[", "i$4", "]"}]}], ",", 
          RowBox[{"Delete", "[", 
           RowBox[{"frame", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "i$1", "}"}], ",", 
              RowBox[{"{", "i$2", "}"}], ",", 
              RowBox[{"{", "i$3", "}"}], ",", 
              RowBox[{"{", "i$4", "}"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i$1", ",", 
         RowBox[{"frdim", "-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$2", ",", 
         RowBox[{"i$1", "+", "1"}], ",", 
         RowBox[{"frdim", "-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$3", ",", 
         RowBox[{"i$2", "+", "1"}], ",", 
         RowBox[{"frdim", "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$4", ",", 
         RowBox[{"i$3", "+", "1"}], ",", "frdim"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"frdim", "==", "5"}], ",", 
       RowBox[{"Return", "[", "]"}]}], "]"}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"av$star", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$1", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$2", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$3", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$4", "]"}], "]"}], ",", 
           RowBox[{"frame", "[", 
            RowBox[{"[", "i$5", "]"}], "]"}]}], "}"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
             "i$1", "+", "i$2", "+", "i$3", "+", "i$4", "+", "i$5", "-", 
              "1"}], ")"}]}], 
           RowBox[{"sig", "[", "i$1", "]"}], " ", 
           RowBox[{"sig", "[", "i$2", "]"}], 
           RowBox[{"sig", "[", "i$3", "]"}], 
           RowBox[{"sig", "[", "i$4", "]"}], 
           RowBox[{"sig", "[", "i$5", "]"}]}], ",", 
          RowBox[{"Delete", "[", 
           RowBox[{"frame", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "i$1", "}"}], ",", 
              RowBox[{"{", "i$2", "}"}], ",", 
              RowBox[{"{", "i$3", "}"}], ",", 
              RowBox[{"{", "i$4", "}"}], ",", 
              RowBox[{"{", "i$5", "}"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i$1", ",", 
         RowBox[{"frdim", "-", "4"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$2", ",", 
         RowBox[{"i$1", "+", "1"}], ",", 
         RowBox[{"frdim", "-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$3", ",", 
         RowBox[{"i$2", "+", "1"}], ",", 
         RowBox[{"frdim", "-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$4", ",", 
         RowBox[{"i$3", "+", "1"}], ",", 
         RowBox[{"frdim", "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i$5", ",", 
         RowBox[{"i$4", "+", "1"}], ",", "frdim"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"frdim", "==", "6"}], ",", 
       RowBox[{"Return", "[", "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
    ")"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Calculations", "Subsection"],

Cell["\<\
For efficiency, convert the sums of objects into a List-based notation: a \
list of elements { scalar, form, algebraelelement } representing the sum of \
those elements.\
\>", "Text"],

Cell["\<\
Renamed:
\tav$g\t->\texpr\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"in", "[", "expr_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$1", ",", "av$2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Head", "[", "expr", "]"}], "===", "List"}], ",", 
        RowBox[{"Return", "[", "expr", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$1", "=", 
       RowBox[{"Expand", "[", "expr", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$1", "==", "0"}], ",", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"av$0", ",", 
            RowBox[{"{", "av$fm", "}"}], ",", 
            RowBox[{"elements", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}], "]"}]}], "]"}], 
      ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Head", "[", "av$1", "]"}], "=!=", "Plus"}], ",", 
        RowBox[{"av$1", "=", 
         RowBox[{"av$1", "+", 
          RowBox[{"av$0", "*", "av$fm", " ", "*", 
           RowBox[{"elements", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}]}]}], "]"}], ";", 
      RowBox[{"av$2", "=", 
       RowBox[{"Apply", "[", 
        RowBox[{"List", ",", "av$1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{"av$s1", ",", "av$2"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Treat each individual term of the sum. Note that av$3 is used to ensure that \
we have a product when applying List. Hence av$4 is a list of factors. Those \
must be separated into a scalar factor av$5, the form av$6 and the \
algebraelement av$7.\
\>", "Text"],

Cell["\<\
Renamed:
\tav$g\t->\tterm
Note that the variable av$99 can be modified by av$s10 and hence it cannot be \
blocked.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s1", "[", "term_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$3", ",", "av$4", ",", "av$5", ",", "av$6", ",", "av$7"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"term", "===", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"{", "av$fm", "}"}], ",", 
           RowBox[{"elements", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"av$4", "=", 
         RowBox[{"Apply", "[", 
          RowBox[{"List", ",", 
           RowBox[{"av$3", "  ", "term"}]}], "]"}]}]}], "\[IndentingNewLine]",
        "]"}], ";", 
      RowBox[{"av$6", "=", 
       RowBox[{"Cases", "[", 
        RowBox[{"av$4", ",", 
         RowBox[{"av$12_", "/;", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "av$12", "]"}], "===", "Wedge"}], "||", 
            RowBox[{"MemberQ", "[", 
             RowBox[{"av$bs", ",", "av$12"}], "]"}]}], ")"}]}]}], "]"}]}], 
      ";", 
      RowBox[{"av$99", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$6", "==", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"av$6", "=", 
          RowBox[{"{", "av$fm", "}"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"av$5", "=", "av$4"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"av$6", "=", 
          RowBox[{"av$6", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"av$5", "=", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{"av$4", ",", "av$6"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"av$6", "=", 
          RowBox[{"av$6", "/.", 
           RowBox[{"Wedge", "->", "List"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"av$6", "=", 
          RowBox[{"av$s10", "[", "av$6", "]"}]}]}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$7", "=", 
       RowBox[{"Cases", "[", 
        RowBox[{"av$5", ",", 
         RowBox[{"av$12_", "/;", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"elements", ",", "av$12"}], "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$7", "==", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"av$7", "=", 
         RowBox[{"elements", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"av$7", "=", 
          RowBox[{"av$7", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"av$5", "=", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{"av$5", ",", "av$7"}], "]"}]}]}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$5", "==", 
         RowBox[{"{", "av$3", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"av$5", "=", "av$99"}], ",", "\[IndentingNewLine]", 
        RowBox[{"av$5", "=", 
         RowBox[{"Apply", "[", 
          RowBox[{"Times", ",", 
           RowBox[{"Join", "[", 
            RowBox[{
             RowBox[{"{", "av$99", "}"}], ",", 
             RowBox[{"av$5", "/.", 
              RowBox[{"av$3", "->", "1"}]}]}], "]"}]}], "]"}]}]}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"av$5", ",", "av$6", ",", "av$7"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Arrange the form factors. The variable av$99 is leaked on purpose to store \
the Signature result (of the reordering in a wedge product):\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s10", "[", "av$g_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$8", ",", "av$9"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Head", "[", "av$g", "]"}], "=!=", "List"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"{", "av$g", "}"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"av$8", "=", 
         RowBox[{"Cases", "[", 
          RowBox[{"av$g", ",", 
           RowBox[{"av$12_", "/;", 
            RowBox[{"MemberQ", "[", 
             RowBox[{"forms", ",", "av$12"}], "]"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"av$9", "=", 
         RowBox[{"Cases", "[", 
          RowBox[{"av$g", ",", 
           RowBox[{"av$13_", "/;", 
            RowBox[{"MemberQ", "[", 
             RowBox[{"dforms", ",", "av$13"}], "]"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"av$99", "=", 
         RowBox[{"Signature", "[", "av$8", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Sort", "[", "av$8", "]"}], ",", 
          RowBox[{"Sort", "[", "av$9", "]"}]}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Inverse operation, converting the list notation into a product:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"out", "[", "av$g_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$1", ",", "av$2", ",", "av$s2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Head", "[", "av$g", "]"}], "=!=", "List"}], ",", 
        RowBox[{"Return", "[", "av$g", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s2", "[", "i$8_", "]"}], ":=", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"av$2", "=", 
          RowBox[{"av$g", "[", 
           RowBox[{"[", 
            RowBox[{"i$8", ",", "2"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", "av$2", "]"}], "==", "1"}], ",", 
           RowBox[{"av$2", "=", 
            RowBox[{"av$2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"av$2", "=", 
            RowBox[{"Apply", "[", 
             RowBox[{"Wedge", ",", "av$2"}], "]"}]}]}], "]"}]}], 
        "\[IndentingNewLine]", ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$1", "=", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"av$g", "[", 
           RowBox[{"[", 
            RowBox[{"i$2", ",", "1"}], "]"}], "]"}], 
          RowBox[{"av$s2", "[", "i$2", "]"}], 
          RowBox[{"av$g", "[", 
           RowBox[{"[", 
            RowBox[{"i$2", ",", "3"}], "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i$2", ",", 
           RowBox[{"Length", "[", "av$g", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$1", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"av$fm", "->", "1"}], ",", 
         RowBox[{
          RowBox[{"elements", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "->", "1"}], ",", 
         RowBox[{"av$0", "->", "0"}]}], "}"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Multiplication of general expressions:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mult", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$1", ",", "av$2", ",", "av$s4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"av$g1", "==", "0"}], "||", 
         RowBox[{"av$g2", "==", "0"}]}], ",", 
        RowBox[{"Return", "[", "0", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"NumberQ", "[", "av$g1", "]"}], ",", 
        RowBox[{"Return", "[", 
         RowBox[{"av$g1", "*", 
          RowBox[{"out", "[", 
           RowBox[{"in", "[", "av$g2", "]"}], "]"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"NumberQ", "[", "av$g2", "]"}], ",", 
        RowBox[{"Return", "[", 
         RowBox[{"av$g2", "*", 
          RowBox[{"out", "[", 
           RowBox[{"in", "[", "av$g1", "]"}], "]"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$1", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Outer", "[", 
          RowBox[{"List", ",", 
           RowBox[{"in", "[", "av$g1", "]"}], ",", 
           RowBox[{"in", "[", "av$g2", "]"}], ",", "1"}], "]"}], ",", "1"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s4", "[", "av$g3_", "]"}], ":=", 
       RowBox[{"Thread", "[", "av$g3", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$2", "=", 
       RowBox[{"Map", "[", 
        RowBox[{"av$s4", ",", "av$1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"out", "[", 
       RowBox[{"Map", "[", 
        RowBox[{"av$s3", ",", "av$2"}], "]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Auxiliary function for the previous one. Note that av$99 can be modified by \
the function av$s10, and hence cannot be blocked:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s3", "[", "av$g_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$4", ",", "av$5", ",", "av$6"}], "}"}], ",", 
     RowBox[{
      RowBox[{"av$5", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"av$g", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "av$fm"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"av$99", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$5", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"Length", "[", "av$5", "]"}], ",", "\[IndentingNewLine]", 
         "0", ",", 
         RowBox[{"{", "av$fm", "}"}], ",", "\[IndentingNewLine]", "1", ",", 
         "av$5", ",", "\[IndentingNewLine]", "_", ",", 
         RowBox[{"av$s10", "[", "av$5", "]"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$4", "=", 
       RowBox[{"av$99", "*", 
        RowBox[{"Apply", "[", 
         RowBox[{"Times", ",", 
          RowBox[{"av$g", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$6", "=", 
       RowBox[{"algebra", "[", 
        RowBox[{"[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"elements", ",", 
             RowBox[{"av$g", "[", 
              RowBox[{"[", 
               RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"elements", ",", 
             RowBox[{"av$g", "[", 
              RowBox[{"[", 
               RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
         "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"av$4", ",", "av$5", ",", "av$6"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Give a meaning to NonCommutativeMultiply:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "NonCommutativeMultiply", "]"}], ";", 
  RowBox[{
   RowBox[{"NonCommutativeMultiply", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{"mult", "[", 
    RowBox[{"av$g1", ",", "av$g2"}], "]"}]}], ";", 
  RowBox[{"Protect", "[", "NonCommutativeMultiply", "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Multiplication of two matrices of algebraic objects. This is only valid for \
two matrices. The dimensions of the result can be different, but it is \
assumed (no check) that the dotted dimensions coincide.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matmult", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sum", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"av$g1", "[", 
          RowBox[{"[", 
           RowBox[{"i$1", ",", "i$3"}], "]"}], "]"}], "**", 
         RowBox[{"av$g2", "[", 
          RowBox[{"[", 
           RowBox[{"i$3", ",", "i$2"}], "]"}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{
           RowBox[{"Dimensions", "[", "av$g1", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i$1", ",", 
        RowBox[{
         RowBox[{"Dimensions", "[", "av$g1", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{"i$2", ",", 
        RowBox[{
         RowBox[{"Dimensions", "[", "av$g2", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Give a meaning to CircleTimes. Note that for some reason the change in \
attributes reprotects the function ...\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "CircleTimes", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"CircleTimes", ",", 
    RowBox[{"{", 
     RowBox[{"Flat", ",", "OneIdentity"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Unprotect", "[", "CircleTimes", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CircleTimes", "[", 
    RowBox[{"av$g11_", ",", "av$g12_"}], "]"}], ":=", 
   RowBox[{"matmult", "[", 
    RowBox[{"av$g11", ",", "av$g12"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "CircleTimes", "]"}], ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Factorize the first argument from the form given in the second argument.\
\>", "Text"],

Cell["\<\
Blocked:
 \tav$s6\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"factor", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$2", ",", "av$3", ",", "av$4", ",", "av$s6"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"av$g2", ",", "av$g1"}], "]"}], ",", 
        RowBox[{"Return", "[", "0", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$2", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"av$0", ",", 
          RowBox[{"{", "av$fm", "}"}], ",", 
          RowBox[{"elements", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$3", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s6", "[", "av$g_", "]"}], ":=", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"av$g", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "av$g1"}], "]"}], ",", 
           RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"av$g", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], "==", "1"}], ",", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$2", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"av$g", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"{", "av$fm", "}"}], ",", 
               RowBox[{"av$g", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"av$4", "=", 
             RowBox[{"Position", "[", 
              RowBox[{
               RowBox[{"av$g", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", "av$g1"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"forms", ",", "av$g1"}], "]"}], ",", 
              RowBox[{"av$3", "=", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"av$4", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", "1"}], 
                 ")"}]}]}]}], "]"}], ";", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"av$2", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"av$3", "*", 
                 RowBox[{"av$g", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                RowBox[{"Delete", "[", 
                 RowBox[{
                  RowBox[{"av$g", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], ",", 
                  RowBox[{"av$4", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
                RowBox[{"av$g", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
          "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", ")"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{"av$s6", ",", 
        RowBox[{"in", "[", "av$g2", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"out", "[", "av$2", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Contract vector in the first argument into form (or list of forms) in the \
second argument.\
\>", "Text"],

Cell["\<\
Blocked:
 \tav$s14\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"contract", "[", 
    RowBox[{"av$g3_", ",", "av$g4_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$s14", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"av$s14", "[", " ", "av$g5_", "]"}], " ", ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", "av$g5", "]"}], " ", "=!=", " ", "List"}], ",",
          "\[IndentingNewLine]", " ", 
         RowBox[{"Return", "[", 
          RowBox[{"av$s12", "[", 
           RowBox[{"av$g3", ",", " ", "av$g5"}], "]"}], "]"}], ",", 
         "\[IndentingNewLine]", " ", 
         RowBox[{"av$s14", "/@", " ", "av$g5"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$s14", "[", "av$g4", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Auxiliary code for the previous function:", "Text"],

Cell["\<\
Blocked:
 \tav$s16\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s12", "[", 
    RowBox[{"av$g6_", ",", "av$g7_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$1", ",", "av$2", ",", "av$s16"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$2", "=", 
       RowBox[{"applydrules", "[", "av$g7", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s16", "[", "av$g_", "]"}], ":=", 
       RowBox[{"ReplacePart", "[", 
        RowBox[{"av$g", ",", 
         RowBox[{
          RowBox[{"av$g6", "[", 
           RowBox[{"[", "i$8", "]"}], "]"}], 
          RowBox[{"av$g", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$1", "=", 
       RowBox[{"{", "}"}]}], ";", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{"av$2", ",", 
            RowBox[{"forms", "[", 
             RowBox[{"[", "i$8", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"Continue", "[", "]"}], ",", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"av$1", ",", 
            RowBox[{"Map", "[", 
             RowBox[{"av$s16", ",", 
              RowBox[{"av$s15", "[", 
               RowBox[{
                RowBox[{"forms", "[", 
                 RowBox[{"[", "i$8", "]"}], "]"}], ",", "av$2"}], "]"}]}], 
             "]"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$8", ",", "fmdim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"out", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"av$1", ",", "1"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Auxiliary code for the previous function:", "Text"],

Cell["\<\
Blocked:
 \tav$s17\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s15", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$3", ",", "av$4", ",", "av$s17"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$4", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s17", "[", "av$gs_", "]"}], ":=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"av$gs", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "av$g1"}], "]"}], ",", 
           RowBox[{"Return", "[", "]"}]}], "]"}], ";", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"av$gs", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], "==", "1"}], ",", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$4", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"av$gs", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"{", "av$fm", "}"}], ",", 
               RowBox[{"av$gs", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"av$3", "=", 
             RowBox[{"Position", "[", 
              RowBox[{
               RowBox[{"av$gs", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", "av$g1"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"av$4", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"av$3", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", "1"}], 
                   ")"}]}], "*", 
                 RowBox[{"av$gs", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                RowBox[{"Delete", "[", 
                 RowBox[{
                  RowBox[{"av$gs", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], ",", 
                  RowBox[{"av$3", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
                RowBox[{"av$gs", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
          "]"}]}], "\[IndentingNewLine]", ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{"av$s17", ",", 
        RowBox[{"in", "[", "av$g2", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "av$4"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["Give a meaning to SmallCircle:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "SmallCircle", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"SmallCircle", ",", 
    RowBox[{"{", 
     RowBox[{"Flat", ",", "OneIdentity"}], "}"}]}], "]"}], ";", " ", 
  RowBox[{
   RowBox[{"SmallCircle", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{"contract", "[", 
    RowBox[{"av$g1", ",", "av$g2"}], "]"}]}], ";", 
  RowBox[{"Protect", "[", "SmallCircle", "]"}], ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Change the Wedge product (that does not evaluate) into the \
NonCommutativeMultiply product (that does evaluate).\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"expand", "[", "expr_", "]"}], ":=", 
   RowBox[{"Expand", "[", 
    RowBox[{"expr", "/.", 
     RowBox[{"Wedge", "->", "NonCommutativeMultiply"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["A variant of Collect:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"collect", "[", "expr_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$1", ",", "av$2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$1", "=", 
       RowBox[{"Collect", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Expand", "[", "expr", "]"}], "/.", 
          RowBox[{
           RowBox[{"elements", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "->", "1"}]}], ",", "elements"}], 
        "]"}]}], ";", 
      RowBox[{"av$2", "=", 
       RowBox[{"av$1", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"av$13_", "/;", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"elements", ",", "av$13"}], "]"}]}], "->", "0"}], 
         "}"}]}]}], ";", 
      RowBox[{"av$1", "-", "av$2", "+", 
       RowBox[{"av$2", " ", 
        RowBox[{"elements", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["The associated coefficients function:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"coeffs", "[", "expr_", "]"}], ":=", 
   RowBox[{"DeleteCases", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"collect", "[", "expr", "]"}], ",", "elements"}], "]"}], ",", 
     "0"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Preliminaries for Calculus", "Subsection"],

Cell["\<\
This object will be used as a representation of the scalar 0:\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"av$0", ",", "Constant"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "av$0", "]"}], ";"}]}], "Input",
 InitializationCell->True],

Cell["\<\
Initial value of drules: it represents the fact that all non-exact forms are \
constants.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"drules", "=", "natural"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "drules", "]"}], ";"}]}], "Input",
 InitializationCell->True],

Cell["Declare a list of drules:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makedrules", "[", "av$g_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$4", ",", "av$98"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$4", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Head", "[", 
            RowBox[{"av$g", "[", 
             RowBox[{"[", "i$1", "]"}], "]"}], "]"}], "===", "Rule"}], ",", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"av$4", ",", 
            RowBox[{"av$g", "[", 
             RowBox[{"[", "i$1", "]"}], "]"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"Length", "[", "av$g", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$98", "=", 
       RowBox[{"Complement", "[", 
        RowBox[{"av$g", ",", "av$4"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$98", "=!=", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Invalid input:   \>\"", ",", "av$98"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Abort", "[", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Unprotect", "[", "drules", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"av$g", "==", 
            RowBox[{"{", "}"}]}], ",", 
           RowBox[{"drules", "=", "natural"}], ",", 
           RowBox[{"drules", "=", "av$g"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Protect", "[", "drules", "]"}], ";", "\[IndentingNewLine]", 
         "drules"}]}], "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Apply those stored drules:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"applydrules", "[", "av$g2_", "]"}], ":=", 
   RowBox[{"expand", "[", 
    RowBox[{"av$g2", "/.", "drules"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Exterior differentiation. It can act on a form or a list of forms:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "av$g8_", "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Head", "[", "av$g8", "]"}], "=!=", "List"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"av$s21", "[", "av$g8", "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Map", "[", 
      RowBox[{"d", ",", "av$g8"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Auxiliary code for exterior differentiation. Note that av$99 can be modified \
by av$s10, and hence it cannot be blocked.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s21", "[", "av$g_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "av$1", ",", "av$2", ",", "av$3", ",", "av$4", ",", "av$5", ",", "av$6",
        ",", "av$7", ",", "av$s9", ",", "av$s11"}], "}"}], ",", 
     RowBox[{
      RowBox[{"av$1", "=", 
       RowBox[{"in", "[", "av$g", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$2", "=", 
       RowBox[{"av$s7", "[", "av$1", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s9", "[", "av$g1_", "]"}], ":=", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"i$3", "++"}], ";", "\[IndentingNewLine]", 
         RowBox[{"av$7", "=", 
          RowBox[{"av$g1", "/.", "fderiv"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"av$7", "===", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"av$6", "=", "av$5"}], ";", "\[IndentingNewLine]", 
            RowBox[{"av$99", "=", "1"}], ";", 
            RowBox[{"av$4", "=", 
             RowBox[{"ReplacePart", "[", 
              RowBox[{"av$3", ",", 
               RowBox[{"av$s10", "[", 
                RowBox[{"Delete", "[", 
                 RowBox[{
                  RowBox[{"AppendTo", "[", 
                   RowBox[{"av$6", ",", "av$7"}], "]"}], ",", "i$3"}], "]"}], 
                "]"}], ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"av$4", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "=", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"i$3", "-", "1"}], ")"}]}], "*", "av$99", "*", 
              RowBox[{"av$3", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"av$2", ",", "av$4"}], "]"}]}]}], "\[IndentingNewLine]", 
          "]"}]}], "\[IndentingNewLine]", ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s11", "[", "av$g2_", "]"}], ":=", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"av$3", "=", "av$g2"}], ";", "\[IndentingNewLine]", 
         RowBox[{"av$5", "=", 
          RowBox[{"av$g2", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"i$3", "=", "0"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Map", "[", 
          RowBox[{"av$s9", ",", "av$5"}], "]"}]}], "\[IndentingNewLine]", 
        ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{"av$s11", ",", "av$1"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"out", "[", "av$2", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["Auxiliary code for the previous function:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s7", "[", "av$g4_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$8", ",", "av$9", ",", "av$11", ",", "av$s8"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$11", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s8", "[", "av$g_", "]"}], ":=", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"av$8", "=", 
          RowBox[{
           RowBox[{"Dt", "[", 
            RowBox[{"av$g", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}], "/.", "sderiv"}]}], ";", 
         RowBox[{"av$8", "=", 
          RowBox[{"av$8", "-", 
           RowBox[{"(", 
            RowBox[{"av$8", "/.", 
             RowBox[{
              RowBox[{"av$12_", "/;", 
               RowBox[{"MemberQ", "[", 
                RowBox[{"dscalars", ",", "av$12"}], "]"}]}], "->", "0"}]}], 
            ")"}]}]}], ";", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"av$8", "===", "0"}], ",", 
           RowBox[{"Return", "[", "]"}], ",", 
           RowBox[{
            RowBox[{"av$9", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"av$0", ",", 
                 RowBox[{"{", "av$fm", "}"}], ",", 
                 RowBox[{"elements", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"av$g", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ",", 
                 RowBox[{"av$g", "[", 
                  RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
            RowBox[{"av$11", "=", 
             RowBox[{"av$11", "+", 
              RowBox[{"mult", "[", 
               RowBox[{"av$8", ",", "av$9"}], "]"}]}]}]}]}], "]"}]}], ")"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{"av$s8", ",", "av$g4"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"in", "[", "av$11", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["Combination of exterior differentiation and applying drules:", "Text"],

Cell["\<\
Renamed:
 \tav$g\t->\texpr\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"da", "[", "expr_", "]"}], ":=", 
   RowBox[{"applydrules", "[", 
    RowBox[{"d", "[", "expr", "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Lie differentiation of forms:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"lie", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"av$g1", "\[SmallCircle]", 
     RowBox[{"d", "[", "av$g2", "]"}]}], "+", 
    RowBox[{"da", "[", 
     RowBox[{"av$g1", "\[SmallCircle]", "av$g2"}], "]"}]}]}], ";"}]], "Input",
 
 InitializationCell->True],

Cell["Commutators of the dual vectors of the non-exact forms :", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"liealgebra", "[", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$82", ",", "av$83", ",", "av$84"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$84", "=", 
       RowBox[{"fmdim", "-", "scdim"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$82", "=", 
       RowBox[{"{", "}"}]}], ";", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{"drules", ",", 
            RowBox[{"dforms", "[", 
             RowBox[{"[", "j$3", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"av$82", ",", 
            RowBox[{"dforms", "[", 
             RowBox[{"[", "j$3", "]"}], "]"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"j$3", ",", "av$84"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$82", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Need drules for: \>\"", ",", "av$82"}], "]"}], ";", 
         RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$83", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"Take", "[", 
         RowBox[{"forms", ",", "av$84"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=."}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<order = \>\"", ",", "av$83"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"brackets", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"L", "[", 
            RowBox[{
             RowBox[{"Overscript", "[", 
              RowBox[{"V", ",", 
               RowBox[{"av$83", "[", 
                RowBox[{"[", "j$1", "]"}], "]"}]}], "]"}], ",", 
             RowBox[{"Overscript", "[", 
              RowBox[{"V", ",", 
               RowBox[{"av$83", "[", 
                RowBox[{"[", "j$2", "]"}], "]"}]}], "]"}]}], "]"}], "->", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Coefficient", "[", 
                RowBox[{
                 RowBox[{"da", "[", 
                  RowBox[{"av$83", "[", 
                   RowBox[{"[", "j$3", "]"}], "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"av$83", "[", 
                   RowBox[{"[", "j$1", "]"}], "]"}], "\[Wedge]", 
                  RowBox[{"av$83", "[", 
                   RowBox[{"[", "j$2", "]"}], "]"}]}]}], "]"}]}], " ", 
              RowBox[{"Overscript", "[", 
               RowBox[{"V", ",", 
                RowBox[{"av$83", "[", 
                 RowBox[{"[", "j$3", "]"}], "]"}]}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"j$3", ",", "av$84"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j$1", ",", 
            RowBox[{"av$84", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j$2", ",", 
            RowBox[{"j$1", "+", "1"}], ",", "av$84"}], "}"}]}], "]"}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$82", "=", "brackets"}], ";", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"av$82", "=", 
         RowBox[{"ReplacePart", "[", 
          RowBox[{"av$82", ",", "j$1", ",", 
           RowBox[{"Position", "[", 
            RowBox[{"av$82", ",", 
             RowBox[{"av$83", "[", 
              RowBox[{"[", "j$1", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j$1", ",", "av$84"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "av$82"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary procedures", "Subsection"],

Cell["\<\
Renamings with respect to the original:
\tav$s30\t->\tvalidateelements
\tav$g16\t->\telems
\tav$s20\t->\tprependinhead\
\>", "Text"],

Cell["\<\
Validate a list of expressions as objects that can be considered elementary \
scalars or forms or algebra elements:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"validateelements", "[", "elems_List", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$98", "=", 
       RowBox[{"Cases", "[", 
        RowBox[{"elems", ",", 
         RowBox[{"av$5_", "/;", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "Plus", ",", "Times", ",", "Power", ",", "Wedge", ",", "List"}],
               "}"}], ",", 
             RowBox[{"Head", "[", "av$5", "]"}]}], "]"}], "||", 
           RowBox[{"NumericQ", "[", "av$5", "]"}]}]}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"av$98", "=!=", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Invalid input:   \>\"", ",", "av$98"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["prependinhead[ pre, h[ g[ 1 ] ] ] returns preh[ g[ 1 ] ] .", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"prependinhead", "[", 
    RowBox[{"prefix_", ",", "expr_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"subhead", ",", "newhead"}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"subhead", "=", "expr"}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Head", "[", "subhead", "]"}], "=!=", "Symbol"}], ",", 
        RowBox[{"subhead", "=", 
         RowBox[{"subhead", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ";", 
      RowBox[{"newhead", "=", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "prefix", "]"}], "<>", 
         RowBox[{"ToString", "[", "subhead", "]"}]}], "]"}]}], ";", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{"expr", ",", "newhead", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"expr", ",", " ", "subhead"}], "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Delete all elements of the first argument that are not present in the second \
argument. It is a sort of intersection, but keeping order and repetition in \
the first argument.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"prune", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{"DeleteCases", "[", 
    RowBox[{"av$g1", ",", 
     RowBox[{"av$1_", "/;", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"av$g2", ",", "av$1"}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Convert into equations x==0 and drop the trivial cases:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"setzero", "[", "av$g2_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$s41", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"av$s41", "[", "av$g1_", "]"}], ":=", 
       RowBox[{"av$g1", "==", "0"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{"av$s41", ",", "av$g2"}], "]"}], ",", "True"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Multipliy all elements of the second argument (assumed to be several) by the \
element on the first argument. It is a left-multiplication.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"adL", "[", 
    RowBox[{"av$41_", ",", "av$42_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$s71", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"av$s71", "[", "av$43_", "]"}], ":=", 
       RowBox[{"collect", "[", 
        RowBox[{"av$41", "**", "av$43"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{"av$s71", ",", "av$42"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Multipliy all elements of the first argument (assumed to be several) by the \
element on the second argument. It is a right-multiplication.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"adR", "[", 
    RowBox[{"av$42_", ",", "av$41_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$s72", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"av$s72", "[", "av$43_", "]"}], ":=", 
       RowBox[{"collect", "[", 
        RowBox[{"av$43", "**", "av$41"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{"av$s72", ",", "av$42"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["A global table. Rather bad code.", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"av$44", ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["av$49", 
      RowBox[{"j$8", ",", "j$9"}]], ",", 
     RowBox[{"{", 
      RowBox[{"j$8", ",", 
       RowBox[{"Length", "[", "adjlist", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j$9", ",", 
       RowBox[{"Length", "[", "adjlist", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"adjmat", "[", "av$46_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$45", ",", "av$47"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$47", "=", 
       RowBox[{
        RowBox[{"av$44", ".", "adjlist"}], "-", "av$46"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$47", "=", " ", 
       RowBox[{"setzero", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"coeffs", "[", 
            RowBox[{"av$47", "[", 
             RowBox[{"[", "i$1", "]"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i$1", ",", 
             RowBox[{"Length", "[", "av$47", "]"}]}], "}"}]}], "]"}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$45", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Solve", "[", 
         RowBox[{"av$47", ",", 
          RowBox[{"Flatten", "[", "av$44", "]"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$44", "/.", "av$45"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["Computation of the Hodge dual:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"hs", "[", "av$g17_", "]"}], " ", ":=", " ", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Head", "[", "av$g17", "]"}], " ", "=!=", " ", "List"}], ",", 
      " ", 
      RowBox[{"av$s83", "[", 
       RowBox[{"applydrules", "[", "av$g17", "]"}], "]"}], ",", " ", 
      RowBox[{"hs", " ", "/@", " ", "av$g17"}]}], "]"}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Auxiliary code for Hodge duality:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s83", "[", "av$g15_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$2", ",", "av$s81"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"av$s81", "[", "av$g1_", "]"}], ":=", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"av$2", "=", 
          RowBox[{"av$star", "[", 
           RowBox[{"av$g1", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"ReplacePart", "[", 
          RowBox[{
           RowBox[{"ReplacePart", "[", 
            RowBox[{"av$g1", ",", 
             RowBox[{
              RowBox[{"av$2", "[", 
               RowBox[{"[", "1", "]"}], "]"}], " ", 
              RowBox[{"av$g1", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ",", 
             RowBox[{"{", "1", "}"}]}], "]"}], ",", 
           RowBox[{"av$2", "[", 
            RowBox[{"[", "2", "]"}], "]"}], " ", ",", 
           RowBox[{"{", "2", "}"}]}], "]"}]}], "\[IndentingNewLine]", ")"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"out", "[", 
       RowBox[{"Map", "[", 
        RowBox[{"av$s81", ",", 
         RowBox[{"in", "[", "av$g15", "]"}]}], "]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Co-differential:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Delta]", "[", "av$g16_", "]"}], ":=", 
   RowBox[{
    RowBox[{"hs", "[", 
     RowBox[{"hs", "[", "1", "]"}], "]"}], 
    RowBox[{"hs", "[", 
     RowBox[{"da", "[", 
      RowBox[{"hs", "[", "av$g16", "]"}], "]"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dot", "[", 
    RowBox[{"av$g18_", ",", " ", "av$g19_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"hs", "[", 
     RowBox[{"hs", "[", "1", "]"}], "]"}], "*", 
    RowBox[{"hs", "[", 
     RowBox[{"av$g18", "**", 
      RowBox[{"hs", "[", "av$g19", "]"}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"subspace", "[", "av$g_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"cosub", "=", "av$g"}], ";", "\[IndentingNewLine]", 
     RowBox[{"sub", "=", 
      RowBox[{"Complement", "[", 
       RowBox[{"forms", ",", "cosub"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tosub", "=", 
      RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"cosub", "[", 
             RowBox[{"[", "i$1", "]"}], "]"}], "->", "0"}], ",", 
           RowBox[{
            RowBox[{"d", "[", 
             RowBox[{"cosub", "[", 
              RowBox[{"[", "i$1", "]"}], "]"}], "]"}], "->", "0"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", 
           RowBox[{"Length", "[", "cosub", "]"}]}], "}"}]}], "]"}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", ")"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pullback", "[", "av$g_", "]"}], ":=", 
   RowBox[{"expand", "[", 
    RowBox[{"av$g", "/.", "tosub"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["I don' t know what associator means.", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"associators", "[", "i$7_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$1", ",", "av$2", ",", "av$3"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$2", "=", 
       RowBox[{"Length", "[", 
        RowBox[{"algebra", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"av$3", "=", "0"}], ";", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"av$1", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$4", "]"}], "]"}], "**", 
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$5", "]"}], "]"}]}], ")"}], "**", 
            RowBox[{"elements", "[", 
             RowBox[{"[", "i$6", "]"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"elements", "[", 
             RowBox[{"[", "i$4", "]"}], "]"}], "**", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$5", "]"}], "]"}], "**", 
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$6", "]"}], "]"}]}], ")"}]}]}]}], ";", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"av$1", "=!=", "0"}], ",", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<(\>\"", ",", 
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$4", "]"}], "]"}], ",", "\"\<\>\"", ",", 
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$5", "]"}], "]"}], ",", "\"\<)\>\"", ",", 
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$6", "]"}], "]"}], ",", "\"\< - \>\"", ",", 
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$4", "]"}], "]"}], ",", "\"\<(\>\"", ",", 
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$5", "]"}], "]"}], ",", "\"\<\>\"", ",", 
              RowBox[{"elements", "[", 
               RowBox[{"[", "i$6", "]"}], "]"}], ",", "\"\<) = \>\"", ",", 
              "av$1"}], "]"}], ";", 
            RowBox[{"av$3", "=", 
             RowBox[{"av$3", "+", "1"}]}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"av$3", "+", "1"}], ">", "i$7"}], ",", 
           RowBox[{"Return", "[", "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$4", ",", "2", ",", "av$2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$5", ",", "2", ",", "av$2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$6", ",", "2", ",", "av$2"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Done. Found:\>\"", ",", "av$3"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Setting up a Clifford algebra", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"clifflist", "=", 
   RowBox[{"Get", "[", 
    RowBox[{"$AVFDir", "<>", "\"\</CliffordAlgebras/Cltypes\>\""}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Jose: Intercept the signature={} case here, to do the right thing, instead of \
trying to modify the general code.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeclifford", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"av$cg1_:", "12"}]}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"av$s50", "[", 
      RowBox[{"{", "}"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"makescalars", "[", 
      RowBox[{"{", "}"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"makelements", "[", 
      RowBox[{"{", "identity", "}"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"makealgebra", "[", 
      RowBox[{"{", 
       RowBox[{"{", "identity", "}"}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"omdim", "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{"gammas", "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{"omegas", "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{"thetas", "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "producttable", "]"}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ValueQ", "[", 
        RowBox[{"OverHat", "[", "\[Theta]", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"OverHat", "[", "\[Theta]", "]"}], "=."}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ValueQ", "[", 
        RowBox[{"OverHat", "[", "\[Omega]", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"OverHat", "[", "\[Omega]", "]"}], "=."}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeclifford", "[", 
    RowBox[{"av$cg_", ",", 
     RowBox[{"av$cg1_:", "12"}]}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"av$34", "=", "av$cg1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"av$s50", "[", "av$cg", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"signature", "==", "False"}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Invalid signature!\>\"", "]"}], ";", 
        RowBox[{"Return", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Jose", ":", " ", 
       RowBox[{"why", " ", "is", " ", 
        RowBox[{"makescalars", "[", 
         RowBox[{"{", "}"}], "]"}], " ", "needed", " ", 
        RowBox[{"here", "?"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"makescalars", "[", 
      RowBox[{"{", "}"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"MemberQ", "[", 
        RowBox[{"clifflist", ",", "cliffname"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "gammas", ",", "omegas", ",", "thetas", ",", "producttable"}], "}"}],
         "=", 
        RowBox[{"Get", "[", 
         RowBox[{
         "$AVFDir", "<>", "\"\</CliffordAlgebras/\>\"", "<>", "cliffname"}], 
         "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"av$cg", "=!=", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"av$s51", "[", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"makeelements", "[", "gammas", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"makealgebra", "[", "producttable", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "producttable", "]"}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"omdim", "=", 
      RowBox[{"Length", "[", "omegas", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"makeforms", "[", 
      RowBox[{"Join", "[", 
       RowBox[{"thetas", ",", "omegas"}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"makethetahat", "[", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"makeomegahat", "[", "]"}], ";"}], "\[IndentingNewLine]", 
    ")"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Initialization procedures", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"fmdim", ",", "scdim", ",", "coordsdim", ",", "dscalars"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fmdim", "=", 
   RowBox[{"scdim", "=", 
    RowBox[{"coordsdim", "=", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dscalars", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"av$fg", "=", "True"}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"makeelements", "[", 
   RowBox[{"{", "identity", "}"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"makealgebra", "[", 
   RowBox[{"{", 
    RowBox[{"{", "identity", "}"}], "}"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"makeforms", "[", 
   RowBox[{"{", "}"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"makescalars", "[", 
   RowBox[{"{", "}"}], "]"}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{
   "av$fm", ",", "av$s1", ",", "av$s3", ",", "av$s7", ",", "av$s10", ",", 
    "av$s12", ",", "av$s15", ",", "prependinhead", ",", "av$s21", ",", 
    "validateelements", ",", "av$s82", ",", "av$s83", ",", "adL", ",", "adR", 
    ",", "adjmat", ",", "makeelements", ",", "makealgebra", ",", 
    "makeclifford", ",", "makeforms", ",", "makeframe", ",", "makescalars", 
    ",", "makevectors", ",", "makecoords", ",", "makedrules", ",", 
    "associators", ",", "generic", ",", "in", ",", "out", ",", "d", ",", "da",
     ",", "\[Delta]", ",", "contract", ",", "lie", ",", "mult", ",", 
    "matmult", ",", "coeffs", ",", "collect", ",", "dot", ",", "expand", ",", 
    "timer", ",", "reset", ",", "setzero", ",", "hs", ",", "applydrules", ",",
     "factor", ",", "subspace", ",", "pullback", ",", "prune", ",", "mtx"}], 
   "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell["Again, this code has been eliminated from the package:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"On", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Set", "::", "wrsym"}], ",", "\[IndentingNewLine]", 
    RowBox[{"SetDelayed", "::", "write"}], ",", "\[IndentingNewLine]", 
    RowBox[{"SetDelayed", "::", "wrsym"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Syntax", "::", "newl"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 Evaluatable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"reset", "[", "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CAV code", "Section"],

Cell[CellGroupData[{

Cell["Tools", "Subsection"],

Cell["\<\
This code was present in the original, but now it is not needed.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Off", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"General", "::", "spell1"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Set", "::", "wrsym"}], ",", "\[IndentingNewLine]", 
    RowBox[{"SetDelayed", "::", "write"}], ",", "\[IndentingNewLine]", 
    RowBox[{"SetDelayed", "::", "wrsym"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Syntax", "::", "newl"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
Jose: Intercept the signature={} case here, to do the right thing, instead of \
trying to modify the general code.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s50", "[", 
    RowBox[{"{", "}"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"cadim", "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{"signature", "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{"cliffname", "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{"av$34", "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{"av$92", "=."}], ";"}], "\[IndentingNewLine]", ")"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Generates some properties of the algebra from the input \"signature\".\
\>", "Input",
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s50", "[", "av$g1_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$2", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"cadim", "=", 
       RowBox[{"Length", "[", "av$g1", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"signature", "=", "av$g1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"cliffname", "=", "\"\<Cl(\>\""}], ";", "\[IndentingNewLine]", 
      RowBox[{"clifflist", "=", 
       RowBox[{"Get", "[", 
        RowBox[{"$AVFDir", "<>", "\"\</CliffordAlgebras/Cltypes\>\""}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$2", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{"cadim", ",", "4"}], "]"}], ",", "\[IndentingNewLine]", "0",
          ",", "1", ",", "\[IndentingNewLine]", "1", ",", "1", ",", 
         "\[IndentingNewLine]", "2", ",", 
         RowBox[{"-", "1"}], ",", "\[IndentingNewLine]", "3", ",", 
         RowBox[{"-", "1"}]}], "\[IndentingNewLine]", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$92", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"i$1", ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", "cadim"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sig", "[", "0", "]"}], "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sig", "[", "i$2", "]"}], "=", 
          RowBox[{"signature", "[", 
           RowBox[{"[", "i$2", "]"}], "]"}]}], ";", 
         RowBox[{"Switch", "[", 
          RowBox[{
           RowBox[{"sig", "[", "i$2", "]"}], ",", "1", ",", 
           RowBox[{"cliffname", "=", 
            RowBox[{"cliffname", "<>", "\"\<+\>\""}]}], ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"cliffname", "=", 
            RowBox[{"cliffname", "<>", "\"\<-\>\""}]}], ",", "_", ",", 
           RowBox[{
            RowBox[{"signature", "=", "False"}], ";", 
            RowBox[{"Return", "[", "]"}]}]}], "]"}], ";"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", "cadim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"signature", "==", "False"}], ",", 
        RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$34", ">", 
         RowBox[{"cadim", "-", "1"}]}], ",", 
        RowBox[{"cliffname", "=", 
         RowBox[{"cliffname", "<>", "\"\<)\>\""}]}], ",", 
        RowBox[{"cliffname", "=", 
         RowBox[{"cliffname", "<>", "\"\<,\>\"", "<>", 
          RowBox[{"ToString", "[", "av$34", "]"}], "<>", "\"\<)\>\""}]}]}], 
       "]"}], ";", 
      RowBox[{
       RowBox[{"sig", "[", 
        RowBox[{"cadim", "+", "1"}], "]"}], "=", 
       RowBox[{"av$2", " ", 
        RowBox[{
         UnderoverscriptBox["\[Product]", 
          RowBox[{"i$3", "=", "1"}], "cadim"], 
         RowBox[{"sig", "[", "i$3", "]"}]}]}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
av$s59 generates the elements list and the basis form list for CAV systems.\
\>", "Text",
 FontFamily->"Times"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s59", "[", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$1", ",", "av$2", ",", "av$3", ",", "av$4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"i$9", "=", "cadim"}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$1", "=", 
       RowBox[{"{", 
        RowBox[{"{", "}"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$3", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"i$9", "+", "1"}], "}"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$2", "=", 
       RowBox[{"{", 
        OverscriptBox["\[Omega]", "0"], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$4", "=", 
       RowBox[{"{", 
        OverscriptBox["\[Omega]", "i$9"], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", "==", "0"}], ",", 
        RowBox[{"av$3", "=", 
         RowBox[{"av$4", "=", 
          RowBox[{"{", "}"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", "==", "1"}], ",", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"av$1", ",", 
           RowBox[{"{", "1", "}"}]}], "]"}], ";", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"av$2", ",", 
           OverscriptBox["\[Omega]", "1"]}], "]"}], ";", 
         RowBox[{"av$3", "=", 
          RowBox[{"av$4", "=", 
           RowBox[{"{", "}"}]}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "1"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$1", ",", 
             RowBox[{"{", "i$1", "}"}]}], "]"}], ";", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$2", ",", 
             OverscriptBox["\[Omega]", "1"]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "i$9"}], "}"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "2"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$3", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"i$9", "+", "1", "-", "i$1"}], ",", 
               RowBox[{"i$9", "+", "1"}]}], "}"}]}], "]"}], ";", 
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$4", ",", 
             OverscriptBox["\[Omega]", 
              RowBox[{"i$9", "-", "1"}]]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "i$9"}], "}"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "3"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$1", ",", 
             RowBox[{"{", 
              RowBox[{"i$1", ",", "i$2"}], "}"}]}], "]"}], ";", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$2", ",", 
             OverscriptBox["\[Omega]", "2"]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"i$9", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"i$1", "+", "1"}], ",", "i$9"}], "}"}]}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "4"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$3", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"i$9", "-", "i$1"}], ",", 
               RowBox[{"i$9", "-", "i$2"}], ",", 
               RowBox[{"i$9", "+", "1"}]}], "}"}]}], "]"}], ";", 
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$4", ",", 
             OverscriptBox["\[Omega]", 
              RowBox[{"i$9", "-", "2"}]]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"i$9", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", "0", ",", 
            RowBox[{"i$1", "-", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "5"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$1", ",", 
             RowBox[{"{", 
              RowBox[{"i$1", ",", "i$2", ",", "i$3"}], "}"}]}], "]"}], ";", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$2", ",", 
             OverscriptBox["\[Omega]", "3"]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"i$9", "-", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"i$1", "+", "1"}], ",", 
            RowBox[{"i$9", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", 
            RowBox[{"i$2", "+", "1"}], ",", "i$9"}], "}"}]}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "6"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$3", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"i$9", "-", "i$1"}], ",", 
               RowBox[{"i$9", "-", "i$2"}], ",", 
               RowBox[{"i$9", "-", "i$3"}], ",", 
               RowBox[{"i$9", "+", "1"}]}], "}"}]}], "]"}], ";", 
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$4", ",", 
             OverscriptBox["\[Omega]", 
              RowBox[{"i$9", "-", "3"}]]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "2", ",", 
            RowBox[{"i$9", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", "1", ",", 
            RowBox[{"i$1", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", "0", ",", 
            RowBox[{"i$2", "-", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "7"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$1", ",", 
             RowBox[{"{", 
              RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}], "}"}]}], 
            "]"}], ";", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$2", ",", 
             OverscriptBox["\[Omega]", "4"]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"i$9", "-", "3"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"i$1", "+", "1"}], ",", 
            RowBox[{"i$9", "-", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", 
            RowBox[{"i$2", "+", "1"}], ",", 
            RowBox[{"i$9", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$4", ",", 
            RowBox[{"i$3", "+", "1"}], ",", "i$9"}], "}"}]}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "8"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$3", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"i$9", "-", "i$1"}], ",", 
               RowBox[{"i$9", "-", "i$2"}], ",", 
               RowBox[{"i$9", "-", "i$3"}], ",", 
               RowBox[{"i$9", "-", "i$4"}], ",", 
               RowBox[{"i$9", "+", "1"}]}], "}"}]}], "]"}], ";", 
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$4", ",", 
             OverscriptBox["\[Omega]", 
              RowBox[{"i$9", "-", "4"}]]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "3", ",", 
            RowBox[{"i$9", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", "2", ",", 
            RowBox[{"i$1", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", "1", ",", 
            RowBox[{"i$2", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$4", ",", "0", ",", 
            RowBox[{"i$3", "-", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "9"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$1", ",", 
             RowBox[{"{", 
              RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4", ",", "i$5"}],
               "}"}]}], "]"}], ";", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"av$2", ",", 
             OverscriptBox["\[Omega]", 
              RowBox[{"i$9", "-", "5"}]]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"i$9", "-", "4"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"i$1", "+", "1"}], ",", 
            RowBox[{"i$9", "-", "3"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", 
            RowBox[{"i$2", "+", "1"}], ",", 
            RowBox[{"i$9", "-", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$4", ",", 
            RowBox[{"i$3", "+", "1"}], ",", 
            RowBox[{"i$9", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$5", ",", 
            RowBox[{"i$4", "+", "1"}], ",", "i$9"}], "}"}]}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i$9", ">", "10"}], ",", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$3", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"i$9", "-", "i$1"}], ",", 
               RowBox[{"i$9", "-", "i$2"}], ",", 
               RowBox[{"i$9", "-", "i$3"}], ",", 
               RowBox[{"i$9", "-", "i$4"}], ",", 
               RowBox[{"i$9", "-", "i$5"}], ",", 
               RowBox[{"i$9", "+", "1"}]}], "}"}]}], "]"}], ";", 
           RowBox[{"PrependTo", "[", 
            RowBox[{"av$4", ",", 
             OverscriptBox["\[Omega]", 
              RowBox[{"i$9", "-", "5"}]]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "4", ",", 
            RowBox[{"i$9", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", "3", ",", 
            RowBox[{"i$1", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", "2", ",", 
            RowBox[{"i$2", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$4", ",", "1", ",", 
            RowBox[{"i$3", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$5", ",", "0", ",", 
            RowBox[{"i$4", "-", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Unprotect", "[", "eldim", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"makeforms", "[", 
       RowBox[{"{", "}"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$93", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"av$2", ",", "av$4"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$94", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"av$1", ",", "av$3"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"eldim", "=", 
       RowBox[{"Length", "[", "av$94", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$34", ">", 
         RowBox[{"cadim", "-", "1"}]}], ",", 
        RowBox[{"av$35", "=", "eldim"}], ",", 
        RowBox[{
         RowBox[{"av$35", "=", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{"Binomial", "[", 
             RowBox[{"cadim", ",", "i$6"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i$6", ",", "0", ",", " ", "av$34"}], "}"}]}], "]"}]}], 
         ";", 
         RowBox[{"av$93", "=", 
          RowBox[{"Take", "[", 
           RowBox[{"av$93", ",", "av$35"}], "]"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "eldim", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["Calculation sub-routines.", "Text",
 FontFamily->"Times"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s54", "[", "av$g_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$4", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"av$4", "=", 
         RowBox[{"av$4", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"av$g", "[", 
            RowBox[{"[", "i$1", "]"}], "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"Length", "[", "av$g", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ToExpression", "[", "av$4", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s55", "[", "av$g_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$4", ",", "av$5"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$5", "=", "av$g"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"av$5", "=!=", 
          RowBox[{"{", "}"}]}], "&&", 
         RowBox[{
          RowBox[{"Last", "[", "av$5", "]"}], "==", 
          RowBox[{"cadim", "+", "1"}]}]}], ",", 
        RowBox[{"av$5", "=", 
         RowBox[{"Drop", "[", 
          RowBox[{"av$5", ",", 
           RowBox[{"-", "1"}]}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"av$4", "=", 
         RowBox[{"av$4", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"av$5", "[", 
            RowBox[{"[", "i$1", "]"}], "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"Length", "[", "av$5", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ToExpression", "[", "av$4", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
Jose: warning: The variables av$2 and av$3 might be used uninitialized in \
this function. I block them anyway.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s56", "[", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k$1", ",", "av$2", ",", "av$3"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k$1", "=", "20"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Count", "[", 
            RowBox[{"av$2", ",", "k$11"}], "]"}], "==", "2"}], ",", 
          RowBox[{
           RowBox[{"av$2", "=", 
            RowBox[{"ReplacePart", "[", 
             RowBox[{
              RowBox[{"ReplacePart", "[", 
               RowBox[{"av$2", ",", 
                RowBox[{"k$1", "++"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"av$2", ",", "k$11"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"k$1", "++"}], ",", 
              RowBox[{
               RowBox[{"Position", "[", 
                RowBox[{"av$2", ",", "k$11"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
           RowBox[{"av$3", "=", 
            RowBox[{"av$3", " ", 
             RowBox[{"sig", "[", "k$11", "]"}]}]}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"k$11", ",", "1", ",", "cadim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$3", "=", 
       RowBox[{"av$3", "  ", 
        RowBox[{"Signature", "[", "av$2", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$2", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{"Sort", "[", "av$2", "]"}], ",", 
         RowBox[{"20", "-", "k$1"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s58", "[", "av$g1_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$2", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$2", "=", 
       RowBox[{"av$94", "[", 
        RowBox[{"[", "av$g1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"av$2", "=!=", 
          RowBox[{"{", "}"}]}], "&&", 
         RowBox[{
          RowBox[{"Last", "[", "av$2", "]"}], "==", 
          RowBox[{"1", "+", "cadim"}]}]}], ",", 
        RowBox[{"av$2", "=", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"Drop", "[", 
            RowBox[{"av$2", ",", 
             RowBox[{"-", "1"}]}], "]"}], ",", "av$92"}], "]"}]}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"av$s56", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
The following routine sets up \"gammas\", \"omegas\", \"thetas\", and \
calculates the \"producttable\".\
\>", "Text",
 FontFamily->"Times"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s51", "[", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "av$2", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$s59", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"gammas", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", 
          SubscriptBox["\[Gamma]", "0"], "}"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           SubscriptBox["\[Gamma]", 
            RowBox[{"av$s54", "[", 
             RowBox[{"av$94", "[", 
              RowBox[{"[", "i$1", "]"}], "]"}], "]"}]], ",", 
           RowBox[{"{", 
            RowBox[{"i$1", ",", "2", ",", "eldim"}], "}"}]}], "]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"omegas", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"av$93", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           SubscriptBox[
            RowBox[{"(", 
             RowBox[{"av$93", "[", 
              RowBox[{"[", "j$1", "]"}], "]"}], ")"}], 
            RowBox[{"av$s55", "[", 
             RowBox[{"av$94", "[", 
              RowBox[{"[", "j$1", "]"}], "]"}], "]"}]], ",", 
           RowBox[{"{", 
            RowBox[{"j$1", ",", "2", ",", 
             RowBox[{"av$35", "-", "1"}]}], "}"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$35", "==", "eldim"}], ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"omegas", ",", 
          RowBox[{"av$93", "[", 
           RowBox[{"[", "eldim", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"omegas", ",", 
          SubscriptBox[
           RowBox[{"(", 
            RowBox[{"av$93", "[", 
             RowBox[{"[", "av$35", "]"}], "]"}], ")"}], 
           RowBox[{"av$s55", "[", 
            RowBox[{"av$94", "[", 
             RowBox[{"[", "av$35", "]"}], "]"}], "]"}]]}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", "av$93", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"thetas", "=", 
       RowBox[{"omegas", "/.", 
        RowBox[{"\[Omega]", "->", "\[Theta]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"producttable", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"av$3", "=", "1"}], ";", 
          RowBox[{"av$2", "=", 
           RowBox[{"Join", "[", 
            RowBox[{
             RowBox[{"av$s58", "[", "i$1", "]"}], ",", 
             RowBox[{"av$s58", "[", "i$2", "]"}]}], "]"}]}], ";", 
          RowBox[{"av$s56", "[", "]"}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "av$2", "]"}], ">", 
             RowBox[{"cadim", "/", "2"}]}], ",", 
            RowBox[{
             RowBox[{"av$2", "=", 
              RowBox[{"Join", "[", 
               RowBox[{"av$2", ",", "av$92", ",", 
                RowBox[{"{", 
                 RowBox[{"cadim", "+", "1"}], "}"}]}], "]"}]}], ";", 
             RowBox[{"av$3", "=", 
              RowBox[{"av$3", " ", 
               RowBox[{"sig", "[", 
                RowBox[{"cadim", "+", "1"}], "]"}]}]}], ";", 
             RowBox[{"av$s56", "[", "]"}]}]}], "]"}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"av$2", "==", 
             RowBox[{"{", "}"}]}], ",", 
            RowBox[{"av$2", "=", 
             RowBox[{"{", "0", "}"}]}]}], "]"}], ";", 
          RowBox[{"av$3", " ", 
           SubscriptBox["\[Gamma]", 
            RowBox[{"av$s54", "[", "av$2", "]"}]]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", "1", ",", "av$35"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i$2", ",", "1", ",", "av$35"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", "av$94", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"clifflist", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"clifflist", ",", "cliffname"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Put", "[", 
       RowBox[{"clifflist", ",", "\"\<xAct/CliffordAlgebras/Cltypes\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"gammas", "=", 
       RowBox[{"prune", "[", 
        RowBox[{"gammas", ",", "producttable"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Put", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "gammas", ",", "omegas", ",", "thetas", ",", "producttable"}], "}"}],
         ",", "  ", "cliffname"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["Some CAV forms and functions.", "Text",
 FontFamily->"Times"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"makethetahat", "[", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["\[Theta]", "^"], "=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"thetas", "[", 
         RowBox[{"[", "i$1", "]"}], "]"}], " ", 
        RowBox[{"elements", "[", 
         RowBox[{"[", "i$1", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i$1", ",", "omdim"}], "}"}]}], "]"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeomegahat", "[", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["\[Omega]", "^"], "=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"omegas", "[", 
         RowBox[{"[", "i$2", "]"}], "]"}], " ", 
        RowBox[{"elements", "[", 
         RowBox[{"[", "i$2", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i$2", ",", "omdim"}], "}"}]}], "]"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"maketorsion", "[", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["\[CapitalTheta]", "^"], "=", 
     RowBox[{"collect", "[", " ", 
      RowBox[{
       RowBox[{"d", "[", 
        OverscriptBox["\[Theta]", "^"], "]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          OverscriptBox["\[Omega]", "^"], "/", "2"}], ")"}], "**", 
        OverscriptBox["\[Theta]", "^"]}], "+", 
       RowBox[{
        OverscriptBox["\[Theta]", "^"], "**", 
        RowBox[{"(", 
         RowBox[{
          OverscriptBox["\[Omega]", "^"], "/", "2"}], ")"}]}]}], "]"}]}], 
    ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"makecurvature", "[", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["\[CapitalOmega]", "^"], "=", 
      RowBox[{"collect", "[", " ", 
       RowBox[{
        RowBox[{"d", "[", 
         OverscriptBox["\[Omega]", "^"], "]"}], "+", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{
           OverscriptBox["\[Omega]", "^"], "/", "2"}], ")"}], "**", " ", 
         OverscriptBox["\[Omega]", "^"]}]}], "]"}]}], ")"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeeinstein", "[", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["G", "^"], "=", 
     RowBox[{"collect", "[", 
      RowBox[{
       RowBox[{
        OverscriptBox["\[Theta]", "^"], "**", 
        RowBox[{"(", 
         RowBox[{
          OverscriptBox["\[CapitalOmega]", "^"], "/", "2"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          OverscriptBox["\[CapitalOmega]", "^"], "/", "2"}], ")"}], "**", 
        OverscriptBox["\[Theta]", "^"]}]}], "]"}]}], ")"}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeall", "[", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"makeforms", "[", 
      RowBox[{"Join", "[", 
       RowBox[{"thetas", ",", "omegas"}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      OverscriptBox["\[Omega]", "^"], "=", 
      RowBox[{
       OverscriptBox["\[Theta]", "^"], "=", 
       RowBox[{
        OverscriptBox["\[CapitalOmega]", "^"], "=", 
        RowBox[{
         OverscriptBox["\[CapitalTheta]", "^"], "=", "0"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      OverscriptBox["\[Omega]", "^"], "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{
      OverscriptBox["\[Theta]", "^"], "=."}], ";", "\[IndentingNewLine]", 
     RowBox[{
      OverscriptBox["\[CapitalOmega]", "^"], "=."}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      OverscriptBox["\[CapitalTheta]", "^"], "=."}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"makethetahat", "[", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"makeomegahat", "[", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"makecurvature", "[", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"maketorsion", "[", "]"}], ";"}], "\[IndentingNewLine]", ")"}]}],
   ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"grade", "[", 
    RowBox[{"i$4_", ",", "av$g_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$1", ",", "av$s5"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$1", "=", 
       RowBox[{"collect", "[", "av$g", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s5", "[", 
        RowBox[{"-", "1"}], "]"}], "=", 
       RowBox[{"-", "1"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"av$s5", "[", "i$2_", "]"}], ":=", 
       RowBox[{
        RowBox[{"av$s5", "[", 
         RowBox[{"i$2", "-", "1"}], "]"}], "+", 
        RowBox[{"Binomial", "[", 
         RowBox[{"cadim", ",", "i$2"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"av$1", ",", 
            RowBox[{"gammas", "[", 
             RowBox[{"[", "i$1", "]"}], "]"}]}], "]"}], " ", 
          RowBox[{"gammas", "[", 
           RowBox[{"[", "i$1", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", 
           RowBox[{
            RowBox[{"av$s5", "[", 
             RowBox[{"i$4", "-", "1"}], "]"}], "+", "2"}], ",", 
           RowBox[{
            RowBox[{"av$s5", "[", "i$4", "]"}], "+", "1"}]}], "}"}]}], "]"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"grades", "[", "av$g1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"grade", "[", 
       RowBox[{"i$5", ",", "av$g1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i$5", ",", "0", ",", "cadim"}], "}"}]}], "]"}], ")"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"reverse", "[", "av$g_", "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Switch", "[", 
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{"i$6", ",", "4"}], "]"}], ",", "0", ",", "1", ",", "1", ",", 
        "1", ",", "2", ",", 
        RowBox[{"-", "1"}], ",", "3", ",", 
        RowBox[{"-", "1"}]}], "]"}], 
      RowBox[{"grade", "[", 
       RowBox[{"i$6", ",", "av$g"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i$6", ",", "0", ",", "cadim"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"involute", "[", "av$g_", "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "i$7"}], " ", 
      RowBox[{"grade", "[", 
       RowBox[{"i$7", ",", "av$g"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i$7", ",", "0", ",", "cadim"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell["Some drules and identities.", "Text",
 FontFamily->"Times"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"zerotorsion", "[", "]"}], ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"setzero", "[", 
       RowBox[{"coeffs", "[", 
        OverscriptBox["\[CapitalTheta]", "^"], "]"}], "]"}], ",", 
      RowBox[{"prune", "[", 
       RowBox[{"dforms", ",", 
        OverscriptBox["\[CapitalTheta]", "^"]}], "]"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zerocurvature", "[", "]"}], ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"setzero", "[", 
       RowBox[{"coeffs", "[", 
        OverscriptBox["\[CapitalOmega]", "^"], "]"}], "]"}], ",", 
      RowBox[{"prune", "[", 
       RowBox[{"dforms", ",", 
        OverscriptBox["\[CapitalOmega]", "^"]}], "]"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"curvatureidentity", "[", "]"}], " ", ":=", 
   RowBox[{"(", " ", 
    RowBox[{
     RowBox[{"d", "[", 
      OverscriptBox["\[CapitalOmega]", "^"], "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[Omega]", "^"], "/", "2"}], ")"}], "**", 
      OverscriptBox["\[CapitalOmega]", "^"]}], "-", 
     RowBox[{
      OverscriptBox["\[CapitalOmega]", "^"], "**", 
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[Omega]", "^"], "/", "2"}], ")"}]}]}], ")"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"torsionidentity", "[", "]"}], " ", ":=", 
   RowBox[{"(", " ", 
    RowBox[{
     RowBox[{"d", "[", 
      OverscriptBox["\[CapitalTheta]", "^"], "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[Omega]", "^"], "/", "2"}], ")"}], "**", 
      OverscriptBox["\[CapitalTheta]", "^"]}], "-", 
     RowBox[{
      OverscriptBox["\[CapitalTheta]", "^"], "**", 
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[Omega]", "^"], "/", "2"}], ")"}]}], "+", 
     RowBox[{
      OverscriptBox["\[Theta]", "^"], "**", 
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[CapitalOmega]", "^"], "/", "2"}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[CapitalOmega]", "^"], "/", "2"}], ")"}], "**", 
      OverscriptBox["\[Theta]", "^"]}]}], " ", ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"contractedidentity", "[", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", 
      OverscriptBox["G", "^"], "]"}], "+", 
     RowBox[{
      OverscriptBox["\[Omega]", "^"], "**", 
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["G", "^"], "/", "2"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["G", "^"], "/", "2"}], ")"}], "**", 
      OverscriptBox["\[Omega]", "^"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[CapitalTheta]", "^"], "/", "2"}], ")"}], "**", 
      OverscriptBox["\[CapitalOmega]", "^"]}], "-", 
     RowBox[{
      OverscriptBox["\[CapitalOmega]", "^"], "**", 
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[CapitalTheta]", "^"], "/", "2"}], ")"}]}]}], ")"}]}],
   ";"}]}], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["CAVmatrices", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makematrices", "[", 
    RowBox[{"av$85_:", "True"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"av$s85", "[", "av$85", "]"}], ";"}], "\[IndentingNewLine]", 
    ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"av$s85", "[", 
    RowBox[{"av$g9_:", "True"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ind", ",", "av$n", ",", "av$mat"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$n", "=", 
       RowBox[{"IntegerPart", "[", 
        RowBox[{"cadim", "/", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"ind", "=", 
            RowBox[{"Sort", "[", 
             RowBox[{"{", 
              RowBox[{"i$1", ",", "i$2"}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            SubscriptBox["\[Xi]", 
             RowBox[{"i$1", ",", "i$2"}]], "=", 
            RowBox[{
             RowBox[{"Signature", "[", 
              RowBox[{"{", 
               RowBox[{"i$1", ",", "i$2"}], "}"}], "]"}], 
             SubscriptBox["\[Xi]", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"ind", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}]]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Do", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"ind", "=", 
               RowBox[{"Sort", "[", 
                RowBox[{"{", 
                 RowBox[{"i$1", ",", "i$2", ",", "i$3"}], "}"}], "]"}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{
               SubscriptBox["\[Xi]", 
                RowBox[{"i$1", ",", "i$2", ",", "i$3"}]], "=", 
               RowBox[{
                RowBox[{"Signature", "[", 
                 RowBox[{"{", 
                  RowBox[{"i$1", ",", "i$2", ",", "i$3"}], "}"}], "]"}], 
                SubscriptBox["\[Xi]", 
                 RowBox[{
                  RowBox[{"ind", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", 
                  RowBox[{"ind", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], ",", 
                  RowBox[{"ind", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}]]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Do", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"ind", "=", 
                  RowBox[{"Sort", "[", 
                   RowBox[{"{", 
                    RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}], 
                    "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
                 RowBox[{
                  SubscriptBox["\[Xi]", 
                   RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], "=", 
                  
                  RowBox[{
                   RowBox[{"Signature", "[", 
                    RowBox[{"{", 
                    RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}], 
                    "}"}], "]"}], 
                   SubscriptBox["\[Xi]", 
                    RowBox[{
                    RowBox[{"ind", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"ind", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"ind", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", 
                    RowBox[{"ind", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]]}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Do", "[", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"ind", "=", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "i$1", ",", "i$2", ",", "i$3", ",", "i$4", ",", "i$5"}], 
                    "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
                    RowBox[{
                    SubscriptBox["\[Xi]", 
                    RowBox[{
                    "i$1", ",", "i$2", ",", "i$3", ",", "i$4", ",", "i$5"}]], 
                    "=", 
                    RowBox[{
                    RowBox[{"Signature", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "i$1", ",", "i$2", ",", "i$3", ",", "i$4", ",", "i$5"}], 
                    "}"}], "]"}], 
                    SubscriptBox["\[Xi]", 
                    RowBox[{
                    RowBox[{"ind", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"ind", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"ind", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", 
                    RowBox[{"ind", "[", 
                    RowBox[{"[", "4", "]"}], "]"}], ",", 
                    RowBox[{"ind", "[", 
                    RowBox[{"[", "5", "]"}], "]"}]}]]}]}]}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"{", 
                    RowBox[{"i$5", ",", "av$n"}], "}"}]}], "]"}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"i$4", ",", "av$n"}], "}"}]}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"i$3", ",", "av$n"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", "av$n"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"spins", "=", 
       RowBox[{"{", 
        SubscriptBox["\[Xi]", "0"], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"spins", ",", 
          SubscriptBox["\[Xi]", "i$1"]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "av$n"}], "}"}]}], "]"}], ";", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"spins", ",", 
          SubscriptBox["\[Xi]", 
           RowBox[{"i$1", ",", "i$2"}]]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"spins", ",", 
          SubscriptBox["\[Xi]", 
           RowBox[{"i$1", ",", "i$2", ",", "i$3"}]]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"i$2", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"spins", ",", 
          SubscriptBox["\[Xi]", 
           RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"i$2", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$4", ",", 
          RowBox[{"i$3", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$n", ">", "4"}], ",", "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"spins", ",", 
          SubscriptBox["\[Xi]", 
           RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}]]}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"spdim", "=", 
       RowBox[{"Length", "[", "spins", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       SubscriptBox["av$h", "0"], "=", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Xi]", "i$1"], 
          SubscriptBox["av$x", "i$1"]}], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", "0", ",", "av$n"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["av$h", "i$1"], "=", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Xi]", "0"], " ", 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$1"]}], "-", 
          RowBox[{
           SubscriptBox["\[Xi]", "i$1"], 
           SubscriptBox["av$x", "0"]}], "+", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[Xi]", 
              RowBox[{"i$1", ",", "i$2"}]], 
             SubscriptBox["av$x", "i$2"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i$2", ",", "av$n"}], "}"}]}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["av$h", 
          RowBox[{"i$1", ",", "i$2"}]], "=", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Xi]", "i$1"], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$2"]}], "-", 
          RowBox[{
           SubscriptBox["\[Xi]", "i$2"], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$1"]}], "+", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$1", ",", "i$2"}]], 
           SubscriptBox["av$x", "0"]}], "+", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[Xi]", 
              RowBox[{"i$1", ",", "i$2", ",", "i$3"}]], 
             SubscriptBox["av$x", "i$3"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i$3", ",", "av$n"}], "}"}]}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["av$h", 
          RowBox[{"i$1", ",", "i$2", ",", "i$3"}]], "=", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$1", ",", "i$2"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$3"]}], "+", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$2", ",", "i$3"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$1"]}], "+", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$3", ",", "i$1"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$2"]}], "-", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$1", ",", "i$2", ",", "i$3"}]], 
           SubscriptBox["av$x", "0"]}], "+", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[Xi]", 
              RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], 
             SubscriptBox["av$x", "i$4"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i$4", ",", "av$n"}], "}"}]}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"i$2", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["av$h", 
          RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], "=", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$1", ",", "i$2", ",", "i$3"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$4"]}], "-", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$2", ",", "i$3", ",", "i$4"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$1"]}], "+", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$3", ",", "i$4", ",", "i$1"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$2"]}], "-", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$4", ",", "i$1", ",", "i$2"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$3"]}], "+", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], 
           SubscriptBox["av$x", "0"]}], "+", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[Xi]", 
              RowBox[{
              "i$1", ",", "i$2", ",", "i$3", ",", "i$4", ",", "i$5"}]], 
             SubscriptBox["av$x", "i$5"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i$5", ",", "av$n"}], "}"}]}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"i$2", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$4", ",", 
          RowBox[{"i$3", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["av$h", 
          RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4", ",", "i$5"}]], 
         "=", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$5"]}], "+", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$2", ",", "i$3", ",", "i$4", ",", "i$5"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$1"]}], "+", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$3", ",", "i$4", ",", "i$5", ",", "i$1"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$2"]}], "+", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$4", ",", "i$5", ",", "i$1", ",", "i$2"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$3"]}], "+", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$5", ",", "i$1", ",", "i$2", ",", "i$3"}]], 
           SubscriptBox[
            OverscriptBox["av$x", "_"], "i$4"]}], "-", 
          RowBox[{
           SubscriptBox["\[Xi]", 
            RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4", ",", "i$5"}]], 
           
           SubscriptBox["av$x", "0"]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "4"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"i$2", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$4", ",", 
          RowBox[{"i$3", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$5", ",", 
          RowBox[{"i$4", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$mat", "=", 
       RowBox[{"{", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{
            SubscriptBox["av$h", "0"], ",", 
            RowBox[{"spins", "[", 
             RowBox[{"[", "q", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"q", ",", "spdim"}], "}"}]}], "]"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"av$mat", ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              SubscriptBox["av$h", "i$1"], ",", 
              RowBox[{"spins", "[", 
               RowBox[{"[", "q", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"q", ",", "spdim"}], "}"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"av$mat", ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              SubscriptBox["av$h", 
               RowBox[{"i$1", ",", "i$2"}]], ",", 
              RowBox[{"spins", "[", 
               RowBox[{"[", "q", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"q", ",", "spdim"}], "}"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"av$mat", ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              SubscriptBox["av$h", 
               RowBox[{"i$1", ",", "i$2", ",", "i$3"}]], ",", 
              RowBox[{"spins", "[", 
               RowBox[{"[", "q", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"q", ",", "spdim"}], "}"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"i$2", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"av$mat", ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              SubscriptBox["av$h", 
               RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], ",", 
              RowBox[{"spins", "[", 
               RowBox[{"[", "q", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"q", ",", "spdim"}], "}"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"i$2", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$4", ",", 
          RowBox[{"i$3", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"AppendTo", "[", 
         RowBox[{"av$mat", ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{
              SubscriptBox["av$h", 
               RowBox[{
               "i$1", ",", "i$2", ",", "i$3", ",", "i$4", ",", "i$5"}]], ",", 
              
              RowBox[{"spins", "[", 
               RowBox[{"[", "q", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"q", ",", "spdim"}], "}"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"av$n", "-", "4"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"i$2", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$4", ",", 
          RowBox[{"i$3", "+", "1"}], ",", 
          RowBox[{"av$n", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$5", ",", 
          RowBox[{"i$4", "+", "1"}], ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["av$null", "i$1"], "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"av$mat", "/.", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["av$x", "i$1"], "->", 
               RowBox[{"1", "+", 
                SubscriptBox["av$x", "i$1"]}]}], "}"}]}], ")"}], "-", 
           "av$mat"}]}], ";", 
         RowBox[{
          OverscriptBox[
           SubscriptBox["av$null", "i$1"], "t"], "=", 
          RowBox[{"Transpose", "[", 
           SubscriptBox["av$null", "i$1"], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "0", ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"matrep", "[", "av$g_", "]"}], ":=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"av$64", ",", "av$65"}], "}"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{
          RowBox[{"av$65", "=", 
           RowBox[{"ToString", "[", 
            RowBox[{"av$g", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"av$64", "=", 
           SubscriptBox["\[CapitalGamma]", "0"]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{"av$64", "=", 
             RowBox[{"av$64", ".", 
              SubscriptBox["\[CapitalGamma]", 
               RowBox[{"ToExpression", "[", 
                RowBox[{"StringTake", "[", 
                 RowBox[{"av$65", ",", 
                  RowBox[{"{", "i$1", "}"}]}], "]"}], "]"}]]}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i$1", ",", 
              RowBox[{"StringLength", "[", "av$65", "]"}]}], "}"}]}], "]"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{"av$g", "[", 
             RowBox[{"[", "2", "]"}], "]"}]], "=", "av$64"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       SubscriptBox["\[CapitalGamma]", "0"], "=", 
       RowBox[{"IdentityMatrix", "[", "spdim", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"spincomps", "=", "spins"}], ";", "\[IndentingNewLine]", 
      RowBox[{"zero", "=", 
       RowBox[{
        SubscriptBox["\[CapitalGamma]", 
         RowBox[{"0", " "}]], "-", 
        SubscriptBox["\[CapitalGamma]", "0"]}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"spins", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          SubscriptBox["\[Nu]", "i"]}], ";", 
         RowBox[{
          SubscriptBox["\[CapitalNu]", "i"], "=", 
          RowBox[{
           SubscriptBox["\[CapitalGamma]", "0"], "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "spdim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       SubscriptBox["\[CapitalGamma]", "cadim"], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"sig", "[", "cadim", "]"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}]}], 
        SubscriptBox["av$null", "0"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["\[CapitalGamma]", "i$1"], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"sig", "[", "i$1", "]"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"1", "/", "2"}], ")"}]}], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["av$null", "i$1"], "+", 
             OverscriptBox[
              SubscriptBox["av$null", "i$1"], "t"]}], ")"}]}]}], ";", 
         RowBox[{
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i$1", "+", "av$n"}]], "=", 
          RowBox[{"I", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"sig", "[", 
              RowBox[{"i$1", "+", "av$n"}], "]"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"1", "/", "2"}], ")"}]}], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["av$null", "i$1"], "-", 
             OverscriptBox[
              SubscriptBox["av$null", "i$1"], "t"]}], ")"}]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       SubscriptBox["\[CapitalGamma]", 
        RowBox[{"cadim", "+", "1"}]], "=", 
       SubscriptBox["\[CapitalGamma]", "1"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"cadim", "+", "1"}]], "=", 
         RowBox[{
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"cadim", "+", "1"}]], ".", 
          SubscriptBox["\[CapitalGamma]", "i$1"]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "2", ",", "cadim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       OverscriptBox["C", "~"], "=", 
       SubscriptBox["\[CapitalGamma]", "0"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         OverscriptBox["C", "~"], "=", 
         RowBox[{
          OverscriptBox["C", "~"], ".", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["av$null", "i$1"], "-", 
            OverscriptBox[
             SubscriptBox["av$null", "i$1"], "t"]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "av$n"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"av$g9", "=!=", "True"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"av$g8", "=", 
          RowBox[{"Inverse", "[", "av$g9", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          OverscriptBox["C", "~"], "=", 
          RowBox[{"av$g9", ".", 
           OverscriptBox["C", "~"], ".", "av$g8"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Do", "[", 
          RowBox[{
           RowBox[{
            SubscriptBox["\[CapitalGamma]", "i$2"], "=", 
            RowBox[{"av$g9", ".", 
             SubscriptBox["\[CapitalGamma]", "i$2"], ".", "av$g8"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i$2", ",", 
             RowBox[{"cadim", "+", "1"}]}], "}"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"matrep", "[", 
         RowBox[{"elements", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"1", "+", "cadim"}], ",", 
          RowBox[{"eldim", "-", "1"}]}], "}"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell["\<\
What is this code for? Note right now it is not in an initialization cell. \
Should it be part of the previous function?\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"av$s61", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$61", ",", "av$62"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$61", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"elements", "[", 
           RowBox[{"[", "av$g1", "]"}], "]"}], "/.", 
          RowBox[{"\[Gamma]", "->", "\[CapitalGamma]"}]}], ")"}], ".", 
        "spins"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"av$62", "=", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"av$61", ",", 
          RowBox[{"spins", "[", 
           RowBox[{"[", "av$g2", "]"}], "]"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"av$61", "[", 
          RowBox[{"[", "av$62", "]"}], "]"}], ",", 
         RowBox[{"spins", "[", 
          RowBox[{"[", "av$g2", "]"}], "]"}]}], "]"}], " ", 
       RowBox[{"spins", "[", 
        RowBox[{"[", "av$62", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"av$s62", "[", 
    RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"av$61", ",", "av$62"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"av$61", "=", 
       RowBox[{"spins", ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"elements", "[", 
           RowBox[{"[", "av$g1", "]"}], "]"}], "/.", 
          RowBox[{"\[Gamma]", "->", "\[CapitalGamma]"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"av$62", "=", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"av$61", ",", 
          RowBox[{"spins", "[", 
           RowBox[{"[", "av$g2", "]"}], "]"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"av$61", "[", 
          RowBox[{"[", "av$62", "]"}], "]"}], ",", 
         RowBox[{"spins", "[", 
          RowBox[{"[", "av$g2", "]"}], "]"}]}], "]"}], " ", 
       RowBox[{"spins", "[", 
        RowBox[{"[", "av$62", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spintable", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Take", "[", 
      RowBox[{
       RowBox[{"algebra", "[", 
        RowBox[{"[", "i$1", "]"}], "]"}], ",", "omdim"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i$1", ",", "omdim"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"AppendTo", "[", 
     RowBox[{
      RowBox[{"spintable", "[", 
       RowBox[{"[", "i$1", "]"}], "]"}], ",", 
      RowBox[{"av$s61", "[", 
       RowBox[{"i$1", ",", "i$2"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i$1", ",", "omdim"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i$2", ",", "spdim"}], "}"}]}], "]"}], ";", 
  RowBox[{"av$63", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"av$s62", "[", 
       RowBox[{"i$1", ",", "i$2"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i$1", ",", "omdim"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i$2", ",", "spdim"}], "}"}]}], "]"}], "]"}]}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"AppendTo", "[", 
     RowBox[{
      RowBox[{"av$63", "[", 
       RowBox[{"[", "i$1", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalGamma]", "0"], "/.", 
         RowBox[{"{", 
          RowBox[{"0", "->", "av$0"}], "}"}]}], ")"}], "[", 
       RowBox[{"[", 
        RowBox[{"i$1", ",", "i$2"}], "]"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i$1", ",", "spdim"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i$2", ",", "spdim"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spintable", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"spintable", ",", "av$63"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"makeelements", "[", 
   RowBox[{"Join", "[", 
    RowBox[{"gammas", ",", "spins"}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"makealgebra", "[", "spintable", "]"}], ";", 
  RowBox[{"makepsihat", "[", "]"}], ";"}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Initialization procedures", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{
   "makematrices", ",", "makethetahat", ",", "makeomegahat", ",", 
    "makeeinstein", ",", "makecurvature", ",", "maketorsion", ",", "makeall", 
    ",", "grades", ",", "grade", ",", "zerotorsion", ",", "zerocurvature", 
    ",", "torsionidentity", ",", "curvatureidentity", ",", 
    "contractedidentity", ",", "av$s50", ",", "av$s51", ",", "av$s54", ",", 
    "av$s55", ",", "av$s56", ",", "av$s58", ",", "av$s59"}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"On", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Set", "::", "wrsym"}], ",", "\[IndentingNewLine]", 
    RowBox[{"SetDelayed", "::", "write"}], ",", "\[IndentingNewLine]", 
    RowBox[{"SetDelayed", "::", "wrsym"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Syntax", "::", "newl"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 Evaluatable->False]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other codes", "Section"],

Cell[CellGroupData[{

Cell["Orthonomal frames", "Subsection"],

Cell["\<\
This is a code that was supposed to be executed all at once by loading the .m \
file it was in. We now construct a single function makeorthonormalcurvature[] \
including the whole thing. The results are contained in expressions \
ONFvalue[string] for various strings, to avoid excessive proliferation of \
global variables:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeorthonormalcurvature", "[", 
    RowBox[{"signature_", ",", "tocoords_", ",", "output_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "dim", ",", "Rms", ",", "Rcs", ",", "torsions", ",", "riccis", ",", 
       "riemann2", ",", "riemanns", ",", "b2s", ",", "toB2s", ",", "tob2s", 
       ",", "fx$", ",", "fc$", ",", "id$", ",", "i$1", ",", "i$2", ",", "i$3",
        ",", "i$4", ",", "i$5", ",", "i$6", ",", "x\[Omega]"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dim", "=", 
       RowBox[{"Length", "[", "signature", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"sig", "[", "i$1", "]"}], "=", 
         RowBox[{"signature", "[", 
          RowBox[{"[", "i$1", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"makeforms", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "i$1"], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", "dim"}], "}"}]}], "]"}], "]"}], ";", 
      RowBox[{"b2s", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"b2", "[", 
            RowBox[{"i$1", ",", "i$2"}], "]"}], "=", 
           RowBox[{
            SubscriptBox["\[Theta]", "i"], "\[Wedge]", 
            SubscriptBox["\[Theta]", "j"]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"i$1", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", 
      RowBox[{"toB2s", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            SubscriptBox["\[Theta]", "i$1"], "\[Wedge]", 
            SubscriptBox["\[Theta]", "i$2"]}], "->", 
           RowBox[{"B2", "[", 
            RowBox[{"i$1", ",", "i$2"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"i$1", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", 
      RowBox[{"tob2s", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"B2", "[", 
            RowBox[{"i$1", ",", "i$2"}], "]"}], "->", 
           RowBox[{"b2", "[", 
            RowBox[{"i$1", ",", "i$2"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"i$1", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", 
      RowBox[{"riccis", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i$1", ",", "i$2", ",", "i$3"}]], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "dim"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", 
            RowBox[{"i$2", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i$1", ",", "i$2", ",", "i$3"}]], "=", 
         RowBox[{"-", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"i$1", ",", "i$3", ",", "i$2"}]]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "dim"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", 
          RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$3", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[CapitalGamma]", 
          RowBox[{"i$1", ",", "i$3", ",", "i$3"}]], "=", "0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "dim"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$3", ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["x\[Omega]", 
           RowBox[{"i$1", ",", "i$2"}]], "=", 
          RowBox[{"-", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"sig", "[", "i$3", "]"}], 
              SubscriptBox["\[CapitalGamma]", 
               RowBox[{"i$3", ",", "i$1", ",", "i$2"}]], 
              SubscriptBox["\[Theta]", "i$3"]}], ",", 
             RowBox[{"{", 
              RowBox[{"i$3", ",", "dim"}], "}"}]}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          SubscriptBox["x\[Omega]", 
           RowBox[{"i$2", ",", "i$1"}]], "=", 
          RowBox[{"-", 
           SubscriptBox["x\[Omega]", 
            RowBox[{"i$1", ",", "i$2"}]]}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", 
          RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", 
          RowBox[{"i$1", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         SubscriptBox["x\[Omega]", 
          RowBox[{"i$1", ",", "i$1"}]], "=", "0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Rms", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubscriptBox["R", 
           RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"i$1", "+", "1"}], ",", "dim"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$4", ",", 
            RowBox[{"i$3", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Rcs", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubscriptBox["R", 
           RowBox[{"i$1", ",", "i$2"}]], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "dim"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", "i$1", ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<stress\>\"", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<\[Rho]\>\"", "->", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["R", 
              RowBox[{"1", ",", "1"}]], "+", 
             SubscriptBox["R", 
              RowBox[{"2", ",", "2"}]], "+", 
             SubscriptBox["R", 
              RowBox[{"3", ",", "3"}]], "+", 
             SubscriptBox["R", 
              RowBox[{"4", ",", "4"}]]}], ")"}], "/", "4"}]}], ",", 
         RowBox[{"\"\<p\>\"", "->", 
          RowBox[{
           RowBox[{
            SubscriptBox["R", 
             RowBox[{"4", ",", "4"}]], "/", "4"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["R", 
               RowBox[{"1", ",", "1"}]], "+", 
              SubscriptBox["R", 
               RowBox[{"2", ",", "2"}]], "+", 
              SubscriptBox["R", 
               RowBox[{"3", ",", "3"}]]}], ")"}], "/", "12"}]}]}], ",", 
         RowBox[{"\"\<\[Mu]\>\"", "->", 
          SubscriptBox["R", 
           RowBox[{"4", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<t\>\"", "1"], "->", 
          RowBox[{
           SubscriptBox["R", 
            RowBox[{"1", ",", "4"}]], "/", "2"}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<t\>\"", "2"], "->", 
          RowBox[{
           SubscriptBox["R", 
            RowBox[{"2", ",", "4"}]], "/", "2"}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<t\>\"", "3"], "->", 
          RowBox[{
           SubscriptBox["R", 
            RowBox[{"3", ",", "4"}]], "/", "2"}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<M\>\"", 
           RowBox[{"1", ",", "1"}]], "->", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["R", 
              RowBox[{"1", ",", "1"}]]}], "/", "3"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["R", 
               RowBox[{"2", ",", "2"}]], "+", 
              SubscriptBox["R", 
               RowBox[{"3", ",", "3"}]]}], ")"}], "/", "6"}]}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<M\>\"", 
           RowBox[{"2", ",", "2"}]], "->", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["R", 
              RowBox[{"2", ",", "2"}]]}], "/", "3"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["R", 
               RowBox[{"1", ",", "1"}]], "+", 
              SubscriptBox["R", 
               RowBox[{"3", ",", "3"}]]}], ")"}], "/", "6"}]}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<M\>\"", 
           RowBox[{"3", ",", "3"}]], "->", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["R", 
              RowBox[{"3", ",", "3"}]]}], "/", "3"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["R", 
               RowBox[{"2", ",", "2"}]], "+", 
              SubscriptBox["R", 
               RowBox[{"1", ",", "1"}]]}], ")"}], "/", "6"}]}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<M\>\"", 
           RowBox[{"1", ",", "2"}]], "->", 
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["R", 
             RowBox[{"1", ",", "2"}]]}], "/", "2"}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<M\>\"", 
           RowBox[{"1", ",", "3"}]], "->", 
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["R", 
             RowBox[{"1", ",", "3"}]]}], "/", "2"}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<M\>\"", 
           RowBox[{"2", ",", "3"}]], "->", 
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["R", 
             RowBox[{"2", ",", "3"}]]}], "/", "2"}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<AB\>\"", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["\"\<A\>\"", 
           RowBox[{"1", ",", "1"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"1", ",", "4", ",", "1", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<A\>\"", 
           RowBox[{"2", ",", "2"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"2", ",", "4", ",", "2", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<A\>\"", 
           RowBox[{"3", ",", "3"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"3", ",", "4", ",", "3", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<A\>\"", 
           RowBox[{"1", ",", "2"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"1", ",", "4", ",", "2", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<A\>\"", 
           RowBox[{"1", ",", "3"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"1", ",", "4", ",", "3", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<A\>\"", 
           RowBox[{"2", ",", "3"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"2", ",", "4", ",", "3", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<B\>\"", 
           RowBox[{"1", ",", "1"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"1", ",", "4", ",", "2", ",", "3"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<B\>\"", 
           RowBox[{"2", ",", "2"}]], "->", 
          RowBox[{"-", 
           SubscriptBox["C", 
            RowBox[{"1", ",", "3", ",", "2", ",", "4"}]]}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<B\>\"", 
           RowBox[{"3", ",", "3"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"1", ",", "2", ",", "3", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<B\>\"", 
           RowBox[{"1", ",", "2"}]], "->", 
          RowBox[{"-", 
           SubscriptBox["C", 
            RowBox[{"1", ",", "3", ",", "1", ",", "4"}]]}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<B\>\"", 
           RowBox[{"1", ",", "3"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"1", ",", "2", ",", "1", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<B\>\"", 
           RowBox[{"2", ",", "3"}]], "->", 
          SubscriptBox["C", 
           RowBox[{"1", ",", "2", ",", "2", ",", "4"}]]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<dyadics\>\"", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["\"\<a\>\"", "1"], "\[Rule]", 
          RowBox[{"-", 
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{"4", ",", "1", ",", "4"}]]}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<a\>\"", "2"], "\[Rule]", 
          RowBox[{"-", 
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{"4", ",", "2", ",", "4"}]]}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<a\>\"", "3"], "\[Rule]", 
          RowBox[{"-", 
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{"4", ",", "3", ",", "4"}]]}]}], ",", 
         RowBox[{
          SubscriptBox["\"\<\[CapitalOmega]\>\"", "1"], "\[Rule]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"2", ",", "3", ",", "4"}]], "-", 
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"3", ",", "2", ",", "4"}]]}], ")"}], "/", "2"}]}], ",", 
         
         RowBox[{
          SubscriptBox["\"\<\[CapitalOmega]\>\"", "2"], "\[Rule]", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SubscriptBox["\[CapitalGamma]", 
               RowBox[{"1", ",", "3", ",", "4"}]]}], "+", 
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"3", ",", "1", ",", "4"}]]}], ")"}], "/", "2"}]}], ",", 
         
         RowBox[{
          SubscriptBox["\"\<\[CapitalOmega]\>\"", "3"], "\[Rule]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"1", ",", "2", ",", "4"}]], "-", 
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"2", ",", "1", ",", "4"}]]}], ")"}], "/", "2"}]}], ",", 
         
         RowBox[{
          SubscriptBox["\"\<S\>\"", 
           RowBox[{"1", ",", "1"}]], "\[Rule]", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"1", ",", "1", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<S\>\"", 
           RowBox[{"2", ",", "2"}]], "\[Rule]", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"2", ",", "2", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<S\>\"", 
           RowBox[{"3", ",", "3"}]], "\[Rule]", 
          SubscriptBox["\[CapitalGamma]", 
           RowBox[{"3", ",", "3", ",", "4"}]]}], ",", 
         RowBox[{
          SubscriptBox["\"\<S\>\"", 
           RowBox[{"1", ",", "2"}]], "\[Rule]", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"1", ",", "2", ",", "4"}]], "+", 
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"2", ",", "1", ",", "4"}]]}], ")"}], "/", "2"}]}], ",", 
         
         RowBox[{
          SubscriptBox["\"\<S\>\"", 
           RowBox[{"1", ",", "3"}]], "\[Rule]", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"1", ",", "3", ",", "4"}]], "+", 
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"3", ",", "1", ",", "4"}]]}], ")"}], "/", "2"}]}], ",", 
         
         RowBox[{
          SubscriptBox["\"\<S\>\"", 
           RowBox[{"2", ",", "3"}]], "\[Rule]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"2", ",", "3", ",", "4"}]], "+", 
             SubscriptBox["\[CapitalGamma]", 
              RowBox[{"3", ",", "2", ",", "4"}]]}], ")"}], "/", "2"}]}], ",", 
         
         RowBox[{"\"\<TrS\>\"", "->", 
          RowBox[{
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{"1", ",", "1", ",", "4"}]], "+", 
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{"2", ",", "2", ",", "4"}]], "+", 
           SubscriptBox["\[CapitalGamma]", 
            RowBox[{"3", ",", "3", ",", "4"}]]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<Q\>\"", "]"}], "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"i$2", ">", 
            RowBox[{"i$1", "-", "1"}]}], ",", 
           RowBox[{
            SubscriptBox["\"\<A\>\"", 
             RowBox[{"i$1", ",", "i$2"}]], "+", 
            RowBox[{"I", " ", 
             SubscriptBox["\"\<B\>\"", 
              RowBox[{"i$1", ",", "i$2"}]]}]}], ",", 
           RowBox[{
            SubscriptBox["\"\<A\>\"", 
             RowBox[{"i$2", ",", "i$1"}]], "+", 
            RowBox[{"I", " ", 
             SubscriptBox["\"\<B\>\"", 
              RowBox[{"i$2", ",", "i$1"}]]}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i$2", ",", "3"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
      "Print", "[", 
       "\"\<The inverse transformation back to orthoframe:'toortho'\>\"", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<toortho\>\"", "]"}], "=", 
       RowBox[{"Simplify", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Solve", "[", 
          RowBox[{
           RowBox[{"tocoords", "/.", 
            RowBox[{"Rule", "->", "Equal"}]}], ",", 
           RowBox[{"prune", "[", 
            RowBox[{"dscalars", ",", "tocoords"}], "]"}]}], "]"}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"output", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<toortho = \>\"", ",", 
          RowBox[{"ONFvalue", "[", "\"\<toortho\>\"", "]"}]}], "]"}]}], "]"}],
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
      "Print", "[", "\"\<Exterior derivatives of orthoframe:'dortho'\>\"", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<dortho\>\"", "]"}], "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          SubscriptBox["d\[Theta]", "i$1"], "->", 
          RowBox[{"Simplify", "[", 
           RowBox[{"expand", "[", 
            RowBox[{
             RowBox[{"d", "[", 
              RowBox[{
               SubscriptBox["\[Theta]", "i$1"], "/.", "tocoords"}], "]"}], "/.", 
             RowBox[{"ONFvalue", "[", "\"\<toortho\>\"", "]"}]}], "]"}], 
           "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i$1", ",", "dim"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"output", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<dortho = \>\"", ",", 
          RowBox[{"ONFvalue", "[", "\"\<dortho\>\"", "]"}]}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
      "Print", "[", 
       "\"\<The general matrix of connection 1-forms:'generalomegas'\>\"", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<generalomegas\>\"", "]"}], "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Omega]", 
            RowBox[{"i$1", ",", "i$2"}]], "->", 
           SubscriptBox["x\[Omega]", 
            RowBox[{"i$1", ",", "i$2"}]]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"i$1", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"output", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<generalomegas = \>\"", ",", 
          RowBox[{"ONFvalue", "[", "\"\<generalomegas\>\"", "]"}]}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
      "Print", "[", 
       "\"\<Ricci rotation coefficients for orthoframe:'rotationcomps'\>\"", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<torsion\>\"", "]"}], "=", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dforms", "[", 
              RowBox[{"[", "i$1", "]"}], "]"}], "/.", 
             RowBox[{"ONFvalue", "[", "\"\<dortho\>\"", "]"}]}], ")"}], "+", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"sig", "[", "i$3", "]"}], 
              RowBox[{
               SubscriptBox["x\[Omega]", 
                RowBox[{"i$1", ",", "i$3"}]], "**", 
               SubscriptBox["\[Theta]", "i$3"]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i$3", ",", "dim"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "dim"}], "}"}]}], "]"}], "/.", "toB2s"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"torsions", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ONFvalue", "[", "\"\<torsion\>\"", "]"}], "[", 
             RowBox[{"[", "i$1", "]"}], "]"}], ",", 
            RowBox[{"B2", "[", 
             RowBox[{"i$2", ",", "i$3"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "dim"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", 
            RowBox[{"i$2", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<rotationcomps\>\"", "]"}], "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{"setzero", "[", "torsions", "]"}], ",", "riccis"}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<rotationcomps\>\"", "]"}], "=", 
       RowBox[{"Simplify", "[", 
        RowBox[{"ONFvalue", "[", "\"\<rotationcomps\>\"", "]"}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"output", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<rotationcomps = \>\"", ",", 
          RowBox[{"ONFvalue", "[", "\"\<rotationcomps\>\"", "]"}]}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
      "Print", "[", 
       "\"\<The solved matrix of connection 1-forms:'omegas'\>\"", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<omegas\>\"", "]"}], "=", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"ONFvalue", "[", "\"\<generalomegas\>\"", "]"}], "/.", 
         RowBox[{"ONFvalue", "[", "\"\<rotationcomps\>\"", "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"output", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<omegas = \>\"", ",", 
          RowBox[{"ONFvalue", "[", "\"\<omegas\>\"", "]"}]}], "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
      "Print", "[", 
       "\"\<Orthonormal components of the Riemann tensor:'riemanncomps'\>\"", 
       "]"}], " ", ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["x\[Omega]", 
          RowBox[{"i$1", ",", "i$2"}]], "=", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["x\[Omega]", 
            RowBox[{"i$1", ",", "i$2"}]], "/.", 
           RowBox[{"ONFvalue", "[", "\"\<rotationcomps\>\"", "]"}]}], ")"}]}],
         ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "dim"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"riemann2", "=", 
       RowBox[{
        RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"sig", "[", "i$3", "]"}], " ", 
               RowBox[{"sig", "[", "i$4", "]"}], 
               SubscriptBox["R", 
                RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], 
               RowBox[{"B2", "[", 
                RowBox[{"i$3", ",", "i$4"}], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i$3", ",", 
                RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"i$4", ",", 
                RowBox[{"i$3", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "-", 
            "\[IndentingNewLine]", 
            RowBox[{"expand", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"d", "[", 
                SubscriptBox["x\[Omega]", 
                 RowBox[{"i$1", ",", "i$2"}]], "]"}], "/.", 
               RowBox[{"ONFvalue", "[", "\"\<dortho\>\"", "]"}]}], "/.", 
              RowBox[{"ONFvalue", "[", "\"\<toortho\>\"", "]"}]}], "]"}], "-",
             "\[IndentingNewLine]", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"sig", "[", "i$5", "]"}], 
               RowBox[{
                SubscriptBox["x\[Omega]", 
                 RowBox[{"i$1", ",", "i$5"}]], "**", 
                SubscriptBox["x\[Omega]", 
                 RowBox[{"i$5", ",", "i$2"}]]}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i$5", ",", "dim"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"i$1", ",", 
             RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i$2", ",", 
             RowBox[{"i$1", "+", "1"}], ",", "dim"}], "}"}]}], 
          "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}], "/.", 
        "toB2s"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"riemanns", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{"riemann2", "[", 
             RowBox[{"[", "i$1", "]"}], "]"}], ",", 
            RowBox[{"B2", "[", 
             RowBox[{"i$2", ",", "i$3"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", 
            RowBox[{"Length", "[", "riemann2", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$3", ",", 
            RowBox[{"i$2", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<riemanncomps\>\"", "]"}], "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{"setzero", "[", "riemanns", "]"}], ",", "Rms"}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<riemanncomps\>\"", "]"}], "=", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ONFvalue", "[", "\"\<riemanncomps\>\"", "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Cos", "[", "am$_", "]"}], "^", "2"}], "->", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"Sin", "[", "am$", "]"}], "^", "2"}]}]}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"Cot", "[", "an$_", "]"}], "^", "2"}], "->", 
             RowBox[{
              RowBox[{
               RowBox[{"Csc", "[", "an$", "]"}], "^", "2"}], "-", "1"}]}]}], 
           "}"}]}], ",", 
         RowBox[{"Trig", "->", "False"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"output", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<riemanncomps = \>\"", ",", 
          RowBox[{"ONFvalue", "[", "\"\<riemanncomps\>\"", "]"}]}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
      "Print", "[", 
       "\"\<Orthonormal components of the Ricci tensor:'riccicomps'\>\"", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"fx$", ":=", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"fc$", "=", 
          RowBox[{
           RowBox[{"Signature", "[", 
            RowBox[{"{", 
             RowBox[{"i$3", ",", "i$1"}], "}"}], "]"}], 
           RowBox[{"Signature", "[", 
            RowBox[{"{", 
             RowBox[{"i$3", ",", "i$2"}], "}"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"id$", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{"Join", "[", 
            RowBox[{
             RowBox[{"Sort", "[", 
              RowBox[{"{", 
               RowBox[{"i$3", ",", "i$1"}], "}"}], "]"}], ",", 
             RowBox[{"Sort", "[", 
              RowBox[{"{", 
               RowBox[{"i$3", ",", "i$2"}], "}"}], "]"}]}], "]"}], "]"}]}]}], 
        "\[IndentingNewLine]", ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<riccicomps\>\"", "]"}], ":=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["R", 
            RowBox[{"i$1", ",", "i$2"}]], "->", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{"fx$", ";", 
              RowBox[{"fc$", " ", 
               RowBox[{"sig", "[", "i$3", "]"}], " ", 
               SubscriptBox["R", 
                RowBox[{
                 RowBox[{"id$", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"id$", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ",", 
                 RowBox[{"id$", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], ",", 
                 RowBox[{"id$", "[", 
                  RowBox[{"[", "4", "]"}], "]"}]}]]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i$3", ",", "dim"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i$1", ",", "dim"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i$2", ",", "i$1", ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<riccicomps\>\"", "]"}], "=", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ONFvalue", "[", "\"\<riccicomps\>\"", "]"}], "/.", 
          RowBox[{"ONFvalue", "[", "\"\<riemanncomps\>\"", "]"}]}], ",", 
         RowBox[{"Trig", "->", "False"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["R", 
          RowBox[{"i$2", ",", "i$1"}]], "=", 
         SubscriptBox["R", 
          RowBox[{"i$1", ",", "i$2"}]]}], ",", 
        RowBox[{"{", 
         RowBox[{"i$1", ",", "dim"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i$2", ",", "i$1", ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"output", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<riccicomps = \>\"", ",", 
          RowBox[{"ONFvalue", "[", "\"\<riccicomps\>\"", "]"}]}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "\"\<The Ricci scalar:'ricciscalar'\>\"", "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ONFvalue", "[", "\"\<ricciscalar\>\"", "]"}], "=", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["R", "\"\<s\>\""], "->", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"sig", "[", "i$3", "]"}], " ", 
               SubscriptBox["R", 
                RowBox[{"i$3", ",", "i$3"}]]}], ",", 
              RowBox[{"{", 
               RowBox[{"i$3", ",", "dim"}], "}"}]}], "]"}]}], "}"}], "/.", 
          RowBox[{"ONFvalue", "[", "\"\<riccicomps\>\"", "]"}]}], ",", 
         RowBox[{"Trig", "->", "False"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"output", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<ricciscalar = \>\"", ",", 
          RowBox[{"ONFvalue", "[", "\"\<ricciscalar\>\"", "]"}]}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"dim", ">", "2"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
         "Print", "[", 
          "\"\<Orthonormal components of the Weyl tensor:'weylcomps'\>\"", 
          "]"}], ";", 
         RowBox[{
          RowBox[{"gx$s", "[", 
           RowBox[{"i$5_", ",", "i$6_"}], "]"}], ":=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"i$5", "==", "i$6"}], ",", 
            RowBox[{"sig", "[", "i$5", "]"}], ",", "0"}], "]"}]}], ";", 
         RowBox[{
          RowBox[{"ONFvalue", "[", "\"\<weylcomps\>\"", "]"}], ":=", 
          RowBox[{"Flatten", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{
              SubscriptBox["C", 
               RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], "->", 
              RowBox[{
               SubscriptBox["R", 
                RowBox[{"i$1", ",", "i$2", ",", "i$3", ",", "i$4"}]], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"gx$s", "[", 
                   RowBox[{"i$2", ",", "i$4"}], "]"}], " ", 
                  SubscriptBox["R", 
                   RowBox[{"i$1", ",", "i$3"}]]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"dim", "-", "2"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"gx$s", "[", 
                   RowBox[{"i$1", ",", "i$4"}], "]"}], " ", 
                  SubscriptBox["R", 
                   RowBox[{"i$2", ",", "i$3"}]]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"dim", "-", "2"}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"gx$s", "[", 
                   RowBox[{"i$1", ",", "i$3"}], "]"}], " ", 
                  SubscriptBox["R", 
                   RowBox[{"i$2", ",", "i$4"}]]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"dim", "-", "2"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"gx$s", "[", 
                   RowBox[{"i$2", ",", "i$3"}], "]"}], " ", 
                  SubscriptBox["R", 
                   RowBox[{"i$1", ",", "i$4"}]]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"dim", "-", "2"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"gx$s", "[", 
                    RowBox[{"i$1", ",", "i$3"}], "]"}], 
                   RowBox[{"gx$s", "[", 
                    RowBox[{"i$2", ",", "i$4"}], "]"}]}], "-", 
                  RowBox[{
                   RowBox[{"gx$s", "[", 
                    RowBox[{"i$1", ",", "i$4"}], "]"}], 
                   RowBox[{"gx$s", "[", 
                    RowBox[{"i$2", ",", "i$3"}], "]"}]}]}], ")"}], 
                RowBox[{
                 RowBox[{
                  SubscriptBox["R", "\"\<s\>\""], "/", 
                  RowBox[{"(", 
                   RowBox[{"dim", "-", "1"}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"dim", "-", "2"}], ")"}]}]}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i$1", ",", 
               RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i$2", ",", 
               RowBox[{"i$1", "+", "1"}], ",", "dim"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i$3", ",", "i$1", ",", 
               RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i$4", ",", 
               RowBox[{"i$3", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ONFvalue", "[", "\"\<weylcomps\>\"", "]"}], "=", 
          RowBox[{"Simplify", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"ONFvalue", "[", "\"\<weylcomps\>\"", "]"}], "/.", 
               RowBox[{"ONFvalue", "[", "\"\<riemanncomps\>\"", "]"}]}], "/.", 
              RowBox[{"ONFvalue", "[", "\"\<riccicomps\>\"", "]"}]}], "/.", 
             RowBox[{"ONFvalue", "[", "\"\<ricciscalar\>\"", "]"}]}], ",", 
            RowBox[{"Trig", "->", "False"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"output", ",", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<weylcomps = \>\"", ",", 
             RowBox[{"ONFvalue", "[", "\"\<weylcomps\>\"", "]"}]}], "]"}]}], 
          "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Embedings", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"embedsub", "[", 
     RowBox[{"av$g1_", ",", "av$g2_"}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"subdim", "=", "av$g1"}], ";", 
      RowBox[{"sigs", "=", "av$g2"}], ";", 
      RowBox[{"dim", "=", 
       RowBox[{"Length", "[", "sigs", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"sig", "[", "i", "]"}], "=", 
         RowBox[{"sigs", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"allthetas", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "i"], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "dim"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"allomegas", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubscriptBox["\[Omega]", 
           RowBox[{"j", ",", "i"}]], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "2", ",", "dim"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Omega]", 
          RowBox[{"i", ",", "j"}]], "=", 
         RowBox[{"-", 
          SubscriptBox["\[Omega]", 
           RowBox[{"j", ",", "i"}]]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "dim"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Omega]", 
          RowBox[{"i", ",", "i"}]], "=", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"makeforms", "[", 
       RowBox[{"Join", "[", 
        RowBox[{"allthetas", ",", "allomegas"}], "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"subthetas", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"allthetas", ",", "subdim"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"cothetas", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"allthetas", ",", 
         RowBox[{"subdim", "-", "dim"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"subomegas", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"allomegas", ",", 
         RowBox[{"subdim", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"subdim", "-", "1"}], ")"}], "/", "2"}]}]}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"cosubomegas", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubscriptBox["\[Omega]", 
           RowBox[{"i", ",", "k"}]], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "subdim"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"subdim", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"cocoomegas", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubscriptBox["\[Omega]", 
           RowBox[{"i", ",", "k"}]], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"subdim", "+", "1"}], ",", 
            RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"i", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"subspace", "[", "cothetas", "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"pforms", "[", "1", "]"}], "=", "cothetas"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"embeddingforms", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"sig", "[", "j", "]"}], 
            RowBox[{
             SubscriptBox["\[Omega]", 
              RowBox[{"j", ",", "i"}]], "**", 
             SubscriptBox["\[Theta]", "j"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "subdim"}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"subdim", "+", "1"}], ",", "dim"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"torsionforms", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"sig", "[", "j", "]"}], 
            RowBox[{
             SubscriptBox["\[Omega]", 
              RowBox[{"j", ",", "i"}]], "**", 
             SubscriptBox["\[Theta]", "j"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", 
             RowBox[{"subdim", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"i", ",", "subdim"}], "}"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ")"}]}], ";"}], "\t"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"alldrules", ":=", 
   RowBox[{"Join", "[", 
    RowBox[{"thetadrules", ",", "omegadrules"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thetadrules", ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["d\[Theta]", "i"], "->", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"sig", "[", "j", "]"}]}], 
         RowBox[{
          SubscriptBox["\[Omega]", 
           RowBox[{"i", ",", "j"}]], "**", 
          SubscriptBox["\[Theta]", "j"]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "dim"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "dim"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"omegadrules", ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["d\[Omega]", 
        RowBox[{"i", ",", "j"}]], "->", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"sig", "[", "k", "]"}]}], 
          RowBox[{
           RowBox[{"(", 
            SubscriptBox["\[Omega]", 
             RowBox[{"i", ",", "k"}]], ")"}], "**", 
           SubscriptBox["\[Omega]", 
            RowBox[{"k", ",", "j"}]]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "dim"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"dim", "-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"i", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"subR", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Rlist", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"sig", "[", "k", "]"}], 
           RowBox[{
            SubscriptBox["\[Omega]", 
             RowBox[{"i", ",", "k"}]], "**", 
            SubscriptBox["\[Omega]", 
             RowBox[{"j", ",", "k"}]]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"subdim", "+", "1"}], ",", "dim"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"i", "+", "1"}], ",", "subdim"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"subRcomps", "[", 
         RowBox[{"i", ",", "j"}], "]"}], "=", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"j", "-", "i"}], "==", "0"}], ",", "0", ",", 
          RowBox[{
           RowBox[{"j", "-", "i"}], ">", "0"}], ",", 
          RowBox[{"Rlist", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", 
             RowBox[{"j", "-", "i"}]}], "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"j", "-", "i"}], "<", "0"}], ",", 
          RowBox[{"-", 
           RowBox[{"Rlist", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", 
              RowBox[{"i", "-", "j"}]}], "]"}], "]"}]}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "subdim"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "subdim"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Flatten", "[", "Rlist", "]"}]}], "\[IndentingNewLine]", ")"}]}],
   ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"subR\[Theta]", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"subdim", ">", "5"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", "\"\<Not included.\>\"", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"subR", ";", "\[IndentingNewLine]", 
       RowBox[{"Switch", "[", 
        RowBox[{"subdim", ",", "\[IndentingNewLine]", "3", ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Signature", "[", 
               RowBox[{"{", 
                RowBox[{"i", ",", "j", ",", "k"}], "}"}], "]"}], 
              RowBox[{
               RowBox[{"subRcomps", "[", 
                RowBox[{"i", ",", "j"}], "]"}], "**", 
               SubscriptBox["\[Theta]", "k"]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", 
               RowBox[{"i", "+", "1"}], ",", "subdim"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "subdim"}], "}"}]}], "]"}], "]"}], "]"}], ",",
          "\[IndentingNewLine]", "4", ",", "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Signature", "[", 
                RowBox[{"{", 
                 RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "}"}], "]"}], 
               RowBox[{
                RowBox[{"subRcomps", "[", 
                 RowBox[{"i", ",", "j"}], "]"}], "**", 
                SubscriptBox["\[Theta]", "k"]}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"i", "+", "1"}], ",", "subdim"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "subdim"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "subdim"}], "}"}]}], "]"}], "]"}], ",", 
         "\[IndentingNewLine]", "5", ",", "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Signature", "[", 
                RowBox[{"{", 
                 RowBox[{"i", ",", "j", ",", "k", ",", "l", ",", "m"}], "}"}],
                 "]"}], 
               RowBox[{
                RowBox[{"subRcomps", "[", 
                 RowBox[{"i", ",", "j"}], "]"}], "**", 
                SubscriptBox["\[Theta]", "k"]}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"i", "+", "1"}], ",", "subdim"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "subdim"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", 
              RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"l", "+", "1"}], ",", "subdim"}], "}"}]}], "]"}], "]"}],
          ",", "\[IndentingNewLine]", "_", ",", "\[IndentingNewLine]", "0"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"subR\[Theta]\[Theta]", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"subdim", ">", "5"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", "\"\<Not included.\>\"", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"subR", ";", "\[IndentingNewLine]", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "subdim", ",", "\[IndentingNewLine]", "4", ",", "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Signature", "[", 
               RowBox[{"{", 
                RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "}"}], "]"}], 
              RowBox[{
               RowBox[{"subRcomps", "[", 
                RowBox[{"i", ",", "j"}], "]"}], "**", 
               SubscriptBox["\[Theta]", "k"], "**", 
               SubscriptBox["\[Theta]", "l"]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", 
               RowBox[{"i", "+", "1"}], ",", "subdim"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", 
               RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"l", ",", 
               RowBox[{"k", "+", "1"}], ",", "subdim"}], "}"}]}], "]"}], 
           "]"}], "]"}], ",", "\[IndentingNewLine]", "5", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Signature", "[", 
                RowBox[{"{", 
                 RowBox[{"i", ",", "j", ",", "k", ",", "l", ",", "m"}], "}"}],
                 "]"}], 
               RowBox[{
                RowBox[{"subRcomps", "[", 
                 RowBox[{"i", ",", "j"}], "]"}], "**", 
                SubscriptBox["\[Theta]", "k"], "**", 
                SubscriptBox["\[Theta]", "l"]}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"i", "+", "1"}], ",", "subdim"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", 
                RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"l", ",", 
                RowBox[{"k", "+", "1"}], ",", "subdim"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", "subdim"}], "}"}]}], "]"}], "]"}], ",", 
         "\[IndentingNewLine]", "_", ",", "\[IndentingNewLine]", "0"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"subR\[Theta]\[Theta]\[Theta]", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"subdim", ">", "5"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", "\"\<Not included.\>\"", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"subR", ";", "\[IndentingNewLine]", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "subdim", ",", "\[IndentingNewLine]", "5", ",", "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Signature", "[", 
               RowBox[{"{", 
                RowBox[{"i", ",", "j", ",", "k", ",", "l", ",", "m"}], "}"}], 
               "]"}], 
              RowBox[{
               RowBox[{"subRcomps", "[", 
                RowBox[{"i", ",", "j"}], "]"}], "**", 
               SubscriptBox["\[Theta]", "k"], "**", 
               SubscriptBox["\[Theta]", "l"], "**", 
               SubscriptBox["\[Theta]", "m"]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", 
               RowBox[{"i", "+", "1"}], ",", "subdim"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", 
               RowBox[{"subdim", "-", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"l", ",", 
               RowBox[{"k", "+", "1"}], ",", 
               RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"m", ",", 
               RowBox[{"l", "+", "1"}], ",", "subdim"}], "}"}]}], "]"}], 
           "]"}], "]"}], ",", "\[IndentingNewLine]", "_", ",", 
         "\[IndentingNewLine]", "0"}], "\[IndentingNewLine]", "]"}]}]}], 
     "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ")"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"subRR\[Theta]", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"subdim", ">", "5"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", "\"\<Not included.\>\"", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"subR", ";", "\[IndentingNewLine]", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "subdim", ",", "\[IndentingNewLine]", "5", ",", "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Signature", "[", 
               RowBox[{"{", 
                RowBox[{"i", ",", "j", ",", "k", ",", "l", ",", "m"}], "}"}], 
               "]"}], 
              RowBox[{
               RowBox[{"subRcomps", "[", 
                RowBox[{"i", ",", "j"}], "]"}], "**", 
               RowBox[{"subRcomps", "[", 
                RowBox[{"k", ",", "l"}], "]"}], "**", 
               RowBox[{"(", 
                RowBox[{
                 SubscriptBox["\[Theta]", "m"], "/", "2"}], ")"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", 
               RowBox[{"i", "+", "1"}], ",", "subdim"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", 
               RowBox[{"subdim", "-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"l", ",", 
               RowBox[{"k", "+", "1"}], ",", "subdim"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"m", ",", "subdim"}], "}"}]}], "]"}], "]"}], "]"}], ",",
          "\[IndentingNewLine]", "_", ",", "\[IndentingNewLine]", "0"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fieldforms", "[", "av$g3_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"makedrules", "[", "alldrules", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"pullback", "[", 
        RowBox[{"factor", "[", 
         RowBox[{
          RowBox[{"cothetas", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"da", "[", "av$g3", "]"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "cothetas", "]"}]}], "}"}]}], "]"}]}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Characters", "Subsection"],

Cell[TextData[{
 "Variables ",
 StyleBox["v", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["s", "Input",
  FontWeight->"Plain"],
 " have been respectively renamed ",
 StyleBox["charv", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["chars", "Input",
  FontWeight->"Plain"],
 ". A previous local ",
 StyleBox["chars", "Input",
  FontWeight->"Plain"],
 " has been renamed ",
 StyleBox["characs", "Input",
  FontWeight->"Plain"],
 ". There was a limitation of ",
 StyleBox["maxnum=5", "Input",
  FontWeight->"Plain"],
 " (6 characters); now maxnum is an external parameter, and the function ",
 StyleBox["makeones", "Input",
  FontWeight->"Plain"],
 " can handle any value. The variables ",
 StyleBox["oneforms", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["twoforms", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["threeforms", "Input",
  FontWeight->"Plain"],
 ", etc have been renamed ",
 StyleBox["pforms[1]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["pforms[2]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["pforms[3]", "Input",
  FontWeight->"Plain"],
 ", etc."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"characters", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"getideal", ";", "\[IndentingNewLine]", 
     RowBox[{"null", "=", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "fmdim"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"vs", "=", "null"}], ";", "\[IndentingNewLine]", 
     RowBox[{"newmat", "=", 
      RowBox[{"{", "null", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"characs", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"solutionvectors", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"allones", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sum", "=", "0"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Head", "[", "maxrandom", "]"}], "=!=", "Integer"}], "||", 
        RowBox[{"maxrandom", "<", "3"}]}], ",", 
       RowBox[{"max", "=", "3"}], ",", 
       RowBox[{"max", "=", "maxrandom"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"character", ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "vs", "]"}], "<=", 
           RowBox[{"num", "+", "1"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
           "Print", "[", "\"\<There are no more independent vectors.\>\"", 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Return", "[", "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"num", "===", "maxnum"}], ",", 
            RowBox[{
             RowBox[{
             "Print", "[", 
              "\"\<There may be more independent vectors, so the actual genus \
may be smaller than the printed value.\>\"", "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Return", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}]}],
          "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"num", ",", "0", ",", "maxnum"}], "}"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<dimension = \>\"", ",", "fmdim", ",", "\"\<    genus = \>\"", ",", 
       
       RowBox[{"fmdim", "-", "sum"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
    ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"getideal", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", 
           RowBox[{"pforms", "[", "num", "]"}], "]"}], "=!=", "List"}], ",", 
         RowBox[{
          RowBox[{"pforms", "[", "num", "]"}], "=", 
          RowBox[{"{", "}"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"num", ",", "1", ",", "maxnum"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ideal", " ", "=", 
      RowBox[{"Join", "@@", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"pforms", "[", "num", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"num", ",", "1", ",", "maxnum"}], "}"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"savedrules", "=", "drules"}], ";", "\[IndentingNewLine]", 
     RowBox[{"saveforms", "=", "forms"}], ";", "\[IndentingNewLine]", 
     RowBox[{"makeforms", "[", 
      RowBox[{"prune", "[", 
       RowBox[{"forms", ",", "ideal"}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"idealforms", "=", "forms"}], ";", "\[IndentingNewLine]", 
     RowBox[{"absentforms", "=", 
      RowBox[{"Complement", "[", 
       RowBox[{"saveforms", ",", "forms"}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"makeones", "[", 
    RowBox[{"0", ",", "charv_", ",", "pforms_"}], "]"}], ":=", 
   RowBox[{"pforms", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makeones", "[", 
    RowBox[{"num_", ",", "charv_", ",", "pforms_"}], "]"}], ":=", 
   RowBox[{"Join", "@@", 
    RowBox[{"Apply", "[", 
     RowBox[{"SmallCircle", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Append", "[", 
         RowBox[{"#", ",", 
          RowBox[{"pforms", "[", 
           RowBox[{
            RowBox[{"Length", "[", "#", "]"}], "+", "1"}], "]"}]}], "]"}], 
        "&"}], "/@", 
       RowBox[{"Map", "[", 
        RowBox[{"charv", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Prepend", "[", 
            RowBox[{"#", ",", "num"}], "]"}], "&"}], "/@", 
          RowBox[{"Reverse", "/@", 
           RowBox[{"Subsets", "[", 
            RowBox[{"Range", "[", 
             RowBox[{"num", "-", "1"}], "]"}], "]"}]}]}], ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ",", 
      RowBox[{"{", "1", "}"}]}], "]"}]}]}], ";"}]}], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"getvector", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"iv", "=", "0"}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"iv", "<", 
        RowBox[{"num", "+", "1"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"charv", "[", 
          RowBox[{"num", "+", "1"}], "]"}], "=", "newvector"}], ";", "\t", 
        RowBox[{"involutoryvectors", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{
           RowBox[{"RowReduce", "[", 
            RowBox[{"Join", "[", 
             RowBox[{"solutionvectors", ",", 
              RowBox[{"{", 
               RowBox[{"charv", "[", 
                RowBox[{"num", "+", "1"}], "]"}], "}"}]}], "]"}], "]"}], ",", 
           "null"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"iv", "=", 
         RowBox[{"Length", "[", "involutoryvectors", "]"}]}]}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"solutionvectors", " ", ",", 
       RowBox[{"charv", "[", 
        RowBox[{"num", "+", "1"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"newvector", ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"sum", "==", "0"}], ",", 
     RowBox[{"Return", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", 
          RowBox[{"Random", "[", "Integer", "]"}]}], " ", 
         RowBox[{"Random", "[", 
          RowBox[{"Integer", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "max"}], "}"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "fmdim"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"Return", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", 
           RowBox[{"Random", "[", "Integer", "]"}]}], " ", 
          RowBox[{"Random", "[", 
           RowBox[{"Integer", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "max"}], "}"}]}], "]"}], " ", 
          RowBox[{"vs", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "vs", "]"}]}], "}"}]}], "]"}], "]"}], 
      "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"character", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "vs", "]"}], ">", "num"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"newones", "=", 
        RowBox[{"makeones", "[", 
         RowBox[{"num", ",", "charv", ",", "pforms"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "newones", "]"}], "==", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"chars", "[", "num", "]"}], "=", "0"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"characs", ",", 
          RowBox[{"chars", "[", "num", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", "characs", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "vs", "]"}], ">", "num"}], ",", 
          "getvector"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"allones", "=", 
        RowBox[{"Join", "[", 
         RowBox[{"allones", ",", "newones"}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"mat", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"newones", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"forms", "[", 
           RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "newones", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "fmdim"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newmat", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"newmat", ",", "mat"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"newmat", "=", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{"RowReduce", "[", "newmat", "]"}], "]"}], ",", "null"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"chars", "[", "num", "]"}], "=", 
      RowBox[{
       RowBox[{"First", "[", 
        RowBox[{"Dimensions", "[", "newmat", "]"}], "]"}], "-", "sum"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"sum", "=", 
      RowBox[{"sum", "+", 
       RowBox[{"chars", "[", "num", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"characs", ",", 
       RowBox[{"chars", "[", "num", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "characs", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"vs", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"NullSpace", "[", "newmat", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "vs", "]"}], ">", "num"}], ",", "getvector", 
       ",", 
       RowBox[{"Return", "[", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"check", ":=", " ", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"invset", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        SubscriptBox["V", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"involutoryvectors", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "1"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "involutoryvectors", "]"}]}], "}"}]}], 
       "]"}]}], ";", 
     RowBox[{"genvec", "=", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"invset", "[", 
          RowBox[{"[", "i", "]"}], "]"}], 
         RowBox[{"involutoryvectors", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "involutoryvectors", "]"}]}], "}"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Simplify", "[", 
      RowBox[{"genvec", "\[SmallCircle]", "allones"}], "]"}]}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"completevectors", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"makeforms", "[", "saveforms", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"j", "=", "1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{"absentforms", ",", 
           RowBox[{"forms", "[", 
            RowBox[{"[", "k", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"vec1", "[", 
            RowBox[{"[", "k", "]"}], "]"}], "=", 
           RowBox[{"involutoryvectors", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "j"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"vec2", "[", 
            RowBox[{"[", "k", "]"}], "]"}], "=", 
           RowBox[{"involutoryvectors", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "j"}], "]"}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"vec3", "[", 
            RowBox[{"[", "k", "]"}], "]"}], "=", 
           RowBox[{"involutoryvectors", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "j"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"vec4", "[", 
            RowBox[{"[", "k", "]"}], "]"}], "=", 
           RowBox[{"involutoryvectors", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "j"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"j", "=", 
           RowBox[{"j", "+", "1"}]}]}]}], "\[IndentingNewLine]", "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"k", ",", "fmdim"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"cauchys", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"ccs", "[", "each_", "]"}], ":=", 
      RowBox[{"Coefficient", "[", 
       RowBox[{"each", ",", "forms"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vars", "=", "invset"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"pforms", "[", "1", "]"}], "]"}], ">", "0"}], ",", 
       RowBox[{
        RowBox[{"ks", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           SubscriptBox["k", 
            RowBox[{"i", ",", "j"}]], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", 
              RowBox[{"pforms", "[", "2", "]"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", 
             RowBox[{"Length", "[", 
              RowBox[{"pforms", "[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}], 
        ";", 
        RowBox[{"vars", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"invset", ",", 
           RowBox[{"Flatten", "[", "ks", "]"}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ks", "=", 
        RowBox[{"{", "}"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cauchyeqns", "=", 
      RowBox[{"setzero", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Map", "[", 
         RowBox[{"ccs", ",", 
          RowBox[{
           RowBox[{"genvec", "\[SmallCircle]", 
            RowBox[{"pforms", "[", "2", "]"}]}], "-", 
           RowBox[{"ks", ".", 
            RowBox[{"pforms", "[", "1", "]"}]}]}]}], "]"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"cauchysoln", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Solve", "[", 
        RowBox[{"cauchyeqns", ",", "vars"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cauchyvec", "=", 
      RowBox[{"genvec", "/.", "cauchysoln"}]}]}], "\[IndentingNewLine]", 
    ")"}]}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End package structure", "Section"],

Cell[BoxData[
 RowBox[{"End", "[", "]"}]], "Input",
 InitializationCell->True],

Cell["Store the initial values of the global variables:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AVFinitialstate", "=", "AVFstate"}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{"EndPackage", "[", "]"}]], "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1007, 769},
WindowMargins->{{133, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1,
FrontEndVersion->"10.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 6, \
2015)",
StyleDefinitions->"Default.nb"
]

