(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   3071769,      88401]
NotebookOptionsPosition[   2942818,      84379]
NotebookOutlinePosition[   2944305,      84434]
CellTagsIndexPosition[   2944199,      84428]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["AVF ",
  FontSlant->"Italic"],
 "Doc"
}], "Title",
 FontColor->RGBColor[1, 0, 0]],

Cell["Exterior calculus with algebra valued forms", "Subtitle",
 FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
 StyleBox["Hugo D. Wahlquist \[Copyright] 2003-2012",
  FontSize->18],
 "\n\n",
 StyleBox["Now mantained by Frank B. Estabrook and Jos\[EAcute] M. Mart\
\[IAcute]n-Garc\[IAcute]a after Hugo passed away in 2008.",
  FontSize->14]
}], "Subsubtitle"],

Cell[TextData[{
 StyleBox["AVF",
  FontSlant->"Italic"],
 " is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package for\n\t- exterior calculus with indexed (or algebra-valued) sets \
of basis forms,\n\t- Cartan moving frame theory in n-dimensional Riemannian \
geometry with arbitrary signature,\n\t- the exterior differential systems of \
Cartan-K\[ADoubleDot]hler theory and calculation of Cartan characters, and\n\t\
- embedding of Riemannian manifolds.\nThere are specific programs for \
generation and use of Clifford algebra valued forms with moving frames, and \
generalizations.  This package is a small modification of a suite of programs \
written by Hugo D. Wahlquist in 2003.\n\nFrank Estabrook, long-time \
collaborator of Hugo Wahlquist and first user of ",
 StyleBox["AVF, ",
  FontSlant->"Italic"],
 "has kindly authorized these programs to be included in the ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " suite of tensor computer algebra packages for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The original programs, as Hugo wrote them for him, can be downloaded from\
\n\n\t",
 ButtonBox["http://www.emis.de/journals/SIGMA/2008/063/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.emis.de/journals/SIGMA/2008/063/"], None},
  ButtonNote->"http://www.emis.de/journals/SIGMA/2008/063/"],
 "\n\nThe original programs were not structured as a single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package. There were actually two main codes, AVF (Algebra Valued Forms) \
and CAV (Clifford Algebra Valued forms), plus additional smaller utility \
programs. They have been merged and documented as a single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package, called ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 ", and adapted to the ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " hierarchy.\n\nThe ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " package is independent of the rest of the ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " packages except for ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 ", needed to access directory information. ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " is included in the ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " framework because it covers a complementary area. It does not yet talk to \
the other mathematical packages as it uses a different, mostly index-free, \
approach."
}], "Text"],

Cell[TextData[{
 "\nThis is the doc file AVFDoc.nb of version 1.0 of the ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " package. Last update on 17 December 2011.\n\nThis AVFDoc.nb file has been \
built by joining and editing nine different documentation files that Hugo \
wrote. At the beginning of each section we indicate the respective file used. \
It is divided in four parts:\n\t- Introduction: a general discussion of the \
capabilities of ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 ", with no executable code.\n\t- Basic computations\n\t- Examples: not so \
basic computations\n\t- Advanced computations"
}], "Text"],

Cell[TextData[{
 "Two relevant references:\n\nF. B. Estabrook and H. D. Wahlquist, \
\[OpenCurlyDoubleQuote]",
 StyleBox["Classical Geometries Defined by Exterior Differential Systems on \
Higher Frame Bundles",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote], Classical and Quantum Gravity, 6, 263-74 (1989) \
(for Clifford-algebra-valued forms, Cartan-K\[ADoubleDot]hler theory and \
Cartan characters)\n\nH.D. Wahlquist \[OpenCurlyDoubleQuote]",
 StyleBox["Monte Carlo calculation of Cartan characters",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote], in Proc. International Conference on Aspects of \
General Relativity  and Mathematical Physics, ed. N. Breton, R. Capovilla and \
T. Matos, Mexico City, CINVESTAV, 1993."
}], "Text"],

Cell[CellGroupData[{

Cell["I. Introduction", "Section",
 FontColor->RGBColor[0, 0, 1]],

Cell["This is taken from the file AVF_Introduction.nb.", "Text"],

Cell[CellGroupData[{

Cell["I.a. General comments", "Subsection"],

Cell[TextData[{
 "This section contains a general description of the structure and \
capabilities of ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 ". It covers the basic information and operations needed to understand the \
package, but will not serve as a detailed manual. All the operations \
described here, and many additional ones, are introduced, explained and used \
in the demonstration sections below.\n  \nSection I.g contains a summary of \
the complete set of variable and function names together with a brief \
description for each entry."
}], "Text",
 PageBreakBelow->Automatic,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["I.b. Basic structures", "Subsection"],

Cell["\<\
An  algebra-valued-form (AVF) is a multinomial, each term of which is a \
product of three types of factors:

\t( scalar coefficient ) ( exterior product of basis forms ) ( a single \
algebra element )\
\>", "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 TextJustification->0,
 FontWeight->"Plain"],

Cell["For example,", "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"sampleterm", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", 
     SuperscriptBox["z", "3"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], ")"}], 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "\[Wedge]", 
     SubscriptBox["\[Theta]", "4"], "\[Wedge]", 
     SubscriptBox["\[Theta]", "2"]}], ")"}], 
   RowBox[{"(", 
    SubscriptBox["e", "3"], ")"}], "         ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"parentheses", " ", "optional"}], ")"}], "                  ", 
    "[", "1", "]"}]}]}]], "Input",
 Evaluatable->False,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["\<\
Any of these factors may be omitted in any term of an AVF expression.\
\>", "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell["I.b.1. Fundamental lists", "Subsubsection"],

Cell[TextData[{
 "The algebraic categories of the variables involved are established by their \
membership in one of three fundamental lists of arbitrarily chosen symbols \
with the reserved names: ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "After calling up the ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " package with  ",
 StyleBox["<<xAct`AVF`", "Input",
  FontWeight->"Plain"],
 " and before starting a calculation, these lists may be defined (and can be \
changed at any later time) by the commands :\t"
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"makescalars", "[", 
   RowBox[{"{", 
    RowBox[{"list", " ", "of", " ", "scalar", " ", "symbols"}], "}"}], "]"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"makeforms", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"list", " ", "of", " ", "1"}], "-", 
      RowBox[{"form", " ", "symbols"}]}], "}"}], "]"}], 
   "                                                          ", "[", "2", 
   "]"}], "\n"}], "\n", 
 RowBox[{"makeelements", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"list", " ", "of", " ", "algebra"}], "-", 
    RowBox[{"element", " ", "symbols"}]}], "}"}], "]"}]}], "Input",
 Evaluatable->False,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "For instance, the following start-up commands (which can be executed in any \
order) would establish the properties of the symbols in the ",
 StyleBox["sampleterm", "Input",
  FontWeight->"Plain"],
 " used in [1] :"
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{"makeforms", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Theta]", "1"], ",", 
    SubscriptBox["\[Theta]", "2"], ",", 
    SubscriptBox["\[Theta]", "3"], ",", 
    SubscriptBox["\[Theta]", "4"]}], "}"}], "]"}], "\n", 
 RowBox[{
  StyleBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], ",", 
     SubscriptBox["\[Theta]", "2"], ",", 
     SubscriptBox["\[Theta]", "3"], ",", 
     SubscriptBox["\[Theta]", "4"]}], "}"}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"makescalars", "[", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], 
  "                                                                           \
             ", "[", "3", "]"}], "\n", 
 RowBox[{
  StyleBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], "\n"}], "\n", 
 RowBox[{"makeelements", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["e", "0"], ",", 
    SubscriptBox["e", "1"], ",", 
    SubscriptBox["e", "2"], ",", 
    SubscriptBox["e", "3"]}], "}"}], "]"}], "\n", 
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["e", "0"], ",", 
    SubscriptBox["e", "1"], ",", 
    SubscriptBox["e", "2"], ",", 
    SubscriptBox["e", "3"]}], "}"}],
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Outline"->False,
  "Shadow"->False,
  "Underline"->False}]}], "Input",
 Evaluatable->False,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "Since their names are protected, the lists cannot be defined by simple \
assignments; such as for example, ",
 StyleBox["scalars={x, y, z}", "Input",
  FontWeight->"Plain"],
 ", although their values may always be viewed by typing their names.\n  \t\t\
\nIf the ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " commands are not executed, the lists will have the default values: ",
 StyleBox["scalars={}", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["forms={}", "Input",
  FontWeight->"Plain"],
 ", and ",
 StyleBox["elements={identity}", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "The ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " commands are needed to perform  several essential chores in addition to \
defining the values of the respective lists. For instance, the ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " commands for ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " (0-forms) and  ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " (1-forms) automatically  generate lists of symbols for their exterior \
derivatives with reserved names, ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 "; e.g.,"
}], "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[{"dscalars", "\n", 
 StyleBox[
  RowBox[{"{", 
   RowBox[{"dx", ",", "dy", ",", "dz"}], "}"}],
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Outline"->False,
  "Shadow"->False,
  "Underline"->False}], "\n", 
 RowBox[{"                                                                    \
                                                                     ", 
  RowBox[{"[", "4", "]"}]}], "\n", "dforms", "\n", 
 RowBox[{
  StyleBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["d\[Theta]", "1"], ",", 
     SubscriptBox["d\[Theta]", "2"], ",", 
     SubscriptBox["d\[Theta]", "3"], ",", 
     SubscriptBox["d\[Theta]", "4"]}], "}"}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], "\t\t\t\t\t\t\t\t     \t  \t"}]}], "Input",
 Evaluatable->False,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "Furthermore, the ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 " list is automatically joined to the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list,"
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{"forms", 
  "                                                                           \
                                                   ", "[", "5", "]"}], "\n", 
 RowBox[{
  StyleBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], ",", 
     SubscriptBox["\[Theta]", "2"], ",", 
     SubscriptBox["\[Theta]", "3"], ",", 
     SubscriptBox["\[Theta]", "4"], ",", "dx", ",", "dy", ",", "dz"}], "}"}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], 
  "                                                                      \
"}]}], "Input",
 Evaluatable->False,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "and all members of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " are treated as independent 1-forms generating the Grassmann algebra based \
on them.\n\nThe algebra elements are assumed to be constant.\n  \t\t\nA ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " command creates a new list each time it is used; it does not extend the \
existing list. So, for example, ",
 StyleBox["makescalars[{}]", "Input",
  FontWeight->"Plain"],
 "  deletes all scalars, and ",
 StyleBox["makeforms[{}]", "Input",
  FontWeight->"Plain"],
 " deletes all 1-forms, except for the members of ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 " (if any), which can be removed only by deleting the scalars.\n  \t\t \n\
Extending a list can be accomplished by; e.g., :"
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"makescalars", "[", 
   RowBox[{"Join", "[", 
    RowBox[{"scalars", ",", 
     RowBox[{"{", 
      RowBox[{"list", " ", "of", " ", "additional", " ", "scalars"}], "}"}]}],
     "]"}], "]"}], "               ", "[", "6", "]"}]], "Input",
 Evaluatable->False,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "Many other lists (described below) are also generated automatically by \
these commands, or else created by their own ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " commands."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["I.b.2. Symbols", "Subsubsection"],

Cell[TextData[{
 "There is nothing special about the particular symbols used for the members \
of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ", and ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 "  in the examples displayed here. The symbols in these lists may be any \
variable names acceptable to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and may include multiple subscripts, overscripts, underscripts, etc., but \
not superscripts, which are always interpreted as exponents.\t"
}], "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "These symbols are the \"atoms\" out of which expressions will be built. \
They themselves must be elementary objects --simple names--, neither \
expressions nor functions, and must never have assigned values. For example, \
neither ",
 StyleBox["-x", "Input",
  FontWeight->"Plain"],
 "  nor ",
 StyleBox["f[x]", "Input",
  FontWeight->"Plain"],
 " is an acceptable candidate for membership in ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ", and ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", " ", "dz"}], " ", "-", " ", 
    RowBox[{"z", " ", "dy"}]}], ")"}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " is not a valid member of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ". "
}], "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "Any relations between the independent members of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " or ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " such as ",
 StyleBox["y\[Rule]y[x]", "Input",
  FontWeight->"Plain"],
 " or ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Theta]", "1"], "\[Rule]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"y", " ", "dz"}], " ", "-", " ", 
     RowBox[{"z", " ", "dy"}]}], ")"}]}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 "can (",
 StyleBox["and must",
  FontVariations->{"Underline"->True}],
 ") be handled by using replacement rules, not by assignments. Of course, \
nothing forbits defining a 1-form ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], "=", 
   RowBox[{
    RowBox[{"y", " ", "dz"}], "-", 
    RowBox[{"z", " ", "dy"}]}]}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " by assignment; it simply becomes an AVF. But ",
 Cell[BoxData[
  SubscriptBox["\[Sigma]", "1"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " is not then an independent generator, or \[OpenCurlyDoubleQuote]basis-form\
\[CloseCurlyDoubleQuote], and so is not eligible for membership in the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list."
}], "Text"],

Cell[TextData[{
 "The ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " functions perform a screening test of their argument lists. The test will  \
cause an Interrupt if it finds a problem and indicate where it is, but it \
will not detect all possible errors. Most often, errors occur because a name \
has had a prior assignment. The Interrupt can be handled by selecting ",
 StyleBox["Abort", "Input",
  FontWeight->"Plain"],
 " in the window, modifying the input argument (e.g., clearing any assigned \
values), and re-executing the ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " command. Sometimes the easiest fix may be to ",
 StyleBox["Quit", "Input",
  FontWeight->"Plain"],
 " and re-start the Kernel.\t"
}], "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "The different lists must have no members in common except for the automatic \
inclusion of ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 " in ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ". Any simple variable in an ",
 StyleBox["AVF",
  FontWeight->"Plain"],
 " expression which is not a member of any of these lists will be treated as \
a constant scalar parameter."
}], "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["I.b.3. Algebras", "Subsubsection"],

Cell[TextData[{
 "The algebras of scalars and differential forms are fixed, but the algebra \
of elements must be specified in a multiplication table defining the desired \
algebra. This is accomplished by inputting a matrix with the appropriate \
products. For example, for an algebra with four generators (say, ",
 Cell[BoxData[
  RowBox[{"elements", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["e", "0"], ",", 
     SubscriptBox["e", "1"], ",", 
     SubscriptBox["e", "2"], ",", 
     SubscriptBox["e", "3"]}], "}"}]}]],
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 "), the matrix (here called producttable), would have the following \
structure:"
}], "Text"],

Cell[BoxData[
 RowBox[{"producttable", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "0"], 
       SubscriptBox["e", "0"]}], ",", 
      RowBox[{
       SubscriptBox["e", "0"], 
       SubscriptBox["e", "1"]}], ",", 
      RowBox[{
       SubscriptBox["e", "0"], 
       SubscriptBox["e", "2"]}], ",", 
      RowBox[{
       SubscriptBox["e", "0"], 
       SubscriptBox["e", "3"]}]}], "}"}], ",", "\n", "\t\t                ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "1"], 
       SubscriptBox["e", "0"]}], ",", 
      RowBox[{
       SubscriptBox["e", "1"], 
       SubscriptBox["e", "1"]}], ",", 
      RowBox[{
       SubscriptBox["e", "1"], 
       SubscriptBox["e", "2"]}], ",", 
      RowBox[{
       SubscriptBox["e", "1"], 
       SubscriptBox["e", "3"]}]}], "}"}], ",", 
    "                                                ", 
    RowBox[{
     RowBox[{"[", "7", "]"}], "\n", "\t\t                ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["e", "2"], 
        SubscriptBox["e", "0"]}], ",", 
       RowBox[{
        SubscriptBox["e", "2"], 
        SubscriptBox["e", "1"]}], ",", 
       RowBox[{
        SubscriptBox["e", "2"], 
        SubscriptBox["e", "2"]}], ",", 
       RowBox[{
        SubscriptBox["e", "2"], 
        SubscriptBox["e", "3"]}]}], "}"}]}], ",", "\n", 
    "\t\t                ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "3"], 
       SubscriptBox["e", "0"]}], ",", 
      RowBox[{
       SubscriptBox["e", "3"], 
       SubscriptBox["e", "1"]}], ",", 
      RowBox[{
       SubscriptBox["e", "3"], 
       SubscriptBox["e", "2"]}], ",", 
      RowBox[{
       SubscriptBox["e", "3"], 
       SubscriptBox["e", "3"]}]}], "}"}]}], "}"}]}]], "Input",
 Evaluatable->False,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "where the indicated products are to be replaced by their linear values for \
a specific algebra. Note that the first member of ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " is always taken as the identity element of the algebra regardless of the \
symbol used for it. So in the above example, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["e", "0"], 
    SubscriptBox["e", "i"]}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     SubscriptBox["e", "i"], 
     SubscriptBox["e", "0"]}], " ", "=", " ", 
    SubscriptBox["e", "i"], " "}]}]],
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 ", and the top row and left column of the matrix will equal ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 "."
}], "Text"],

Cell["The algebra is then established by the command", "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"makealgebra", "[", "producttable", "]"}], 
  "                                                                           \
       ", "[", "8", "]"}]], "Input",
 Evaluatable->False,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "which sets the reserved variable ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " to ",
 StyleBox["producttable", "Input",
  FontWeight->"Plain"],
 ". The variable ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " constitutes the actual look-up table for products of elements during \
calculations. It can be displayed in MatrixForm by typing the the command : \
",
 StyleBox["mtx[]", "Input",
  FontWeight->"Plain"],
 ". The ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " can be changed at any time by executing [8] with a different argument."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "The ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " package requires an \"identity\" element, acting as a unital operator to \
serve as a  placeholder in many calculations. If the algebra defined by ",
 StyleBox["producttable", "Input",
  FontWeight->"Plain"],
 " does not include an identity element, one must be supplied by executing \
the command ",
 StyleBox["makealgebra[]", "Input",
  FontWeight->"Plain"],
 " with two arguments, ",
 StyleBox["makealgebra[producttable, symbol]", "Input",
  FontWeight->"Plain"],
 ", where the second (optional) argument, ",
 StyleBox["symbol", "Input",
  FontWeight->"Plain"],
 ", will be used as a new first member of ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 ", to function as the essential placeholder. This will have no effect on the \
products defined by ",
 StyleBox["producttable", "Input",
  FontWeight->"Plain"],
 ", nor on calculations with AVFs not involving the spurious ",
 StyleBox["identity", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "Note that the initial values: ",
 StyleBox["elements={identity}", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["algebra={{identity}}", "Input",
  FontWeight->"Plain"],
 " are set when the package AVF.m is  called. These values are appropriate \
for doing ordinary differential form analysis, and so for this purpose it is \
not necessary to input any algebra table."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "The particular case of Clifford algebras is implemented through special \
routines collectively referred to as \[OpenCurlyDoubleQuote]the ",
 StyleBox["CAV",
  FontSlant->"Italic"],
 " program\[CloseCurlyDoubleQuote], described below. Using ",
 StyleBox["CAV",
  FontSlant->"Italic"],
 ", setting up a Clifford algebra can be easily accomplished by defining a \
list containing the signature of the metric in an ",
 StyleBox["orthonormal",
  FontVariations->{"Underline"->True}],
 " basis. Many problems in metric spaces, for example, can be conveniently \
treated with the CAV orthonormal frame form ",
 Cell[BoxData[
  OverscriptBox["\[Theta]", "^"]],
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 " and associated CAV connection form ",
 Cell[BoxData[
  OverscriptBox["\[Omega]", "^"]],
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 ", which are constructed by the ",
 StyleBox["CAV",
  FontSlant->"Italic"],
 " program."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["I.c. AVF expressions", "Subsection"],

Cell["\<\
An AVF expression is just a sum of terms similar to the sample term in [1]; \
e.g., \
\>", "Text",
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"avf", "=", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"], " ", "y", " ", 
     SubscriptBox["e", "2"]}], "+", 
    RowBox[{"\[Lambda]", " ", "z", " ", 
     RowBox[{
      SubscriptBox["\[Theta]", "2"], "\[Wedge]", "dx"}], " ", 
     SubscriptBox["e", "0"]}], "-", " ", 
    RowBox[{
     SuperscriptBox["y", 
      RowBox[{"-", "3"}]], 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], "\[Wedge]", 
      SubscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox["\[Theta]", "2"]}], " ", 
     SubscriptBox["e", "1"]}], "+", 
    RowBox[{
     SubscriptBox["\[Theta]", "3"], "\[Wedge]", 
     SubscriptBox["d\[Theta]", "2"]}]}]}], 
  "                                          "}], "\n", 
 RowBox[{"                                                                    \
                                                                              \
 ", 
  RowBox[{"[", "9", "]"}]}], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"], " ", "y", " ", 
    SubscriptBox["e", "2"]}], "+", 
   RowBox[{"z", " ", "\[Lambda]", " ", 
    SubscriptBox["e", "0"], " ", 
    RowBox[{
     SubscriptBox["\[Theta]", "2"], "\[Wedge]", "dx"}]}], "+", 
   RowBox[{
    SubscriptBox["\[Theta]", "3"], "\[Wedge]", 
    SubscriptBox["d\[Theta]", "2"]}], "-", 
   FractionBox[
    RowBox[{
     SubscriptBox["e", "1"], " ", 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], "\[Wedge]", 
      SubscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox["\[Theta]", "2"]}]}], 
    SuperscriptBox["y", "3"]]}],
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Outline"->False,
  "Shadow"->False,
  "Underline"->False}]}], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "Any symbol in a wedge product must be a member of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " (which automatically includes ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 "), or of ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 " (which is also automatically constructed). Improper inputs would include \
e.g., ",
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox[
     SubscriptBox["\[Theta]", "1"],
     TraditionalForm], "\[Wedge]", 
    RowBox[{"(", 
     RowBox[{"-", 
      SubscriptBox["\[Theta]", "4"]}]}]}], TraditionalForm]], "Code",
  FontWeight->"Plain"], "Code"],
 StyleBox[") , (z ", "Code",
  FontWeight->"Plain"],
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[Theta]", "2"],
      TraditionalForm], ")"}], "\[Wedge]", " ", "dx"}], TraditionalForm]], 
  "Code",
  FontWeight->"Plain"], "Code"],
 StyleBox[" , ", "Code",
  FontWeight->"Plain"],
 StyleBox[Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "3"], TraditionalForm]], "Code",
  FontWeight->"Plain"], "Code"],
 StyleBox["\[Wedge] d ", "Code",
  FontWeight->"Plain"],
 StyleBox[Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "2"], TraditionalForm]], "Code",
  FontWeight->"Plain"], "Code"],
 StyleBox[" , y ", "Code",
  FontWeight->"Plain"],
 StyleBox[Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     FormBox[
      SubscriptBox["e", "2"],
      TraditionalForm], 
     RowBox[{
      SubscriptBox["e", "3"], "."}]}],
    FontSize->14], TraditionalForm]], "Code",
  FontWeight->"Plain"], "Code"],
 " Note that AVF expressions can be of inhomogeneous degree as differential \
forms.\n\nSince the symbol \[Lambda] is not a member of any list, it would be \
treated as a constant scalar. The missing algebra-element of the last input \
term defaults to the identity element of the algebra (the first member of ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 "). Thus, the algebra-element could also have been omitted in the second \
term. If the algebra-element were omitted from all terms, ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 " would become an ordinary differential form expression."
}], "Text"],

Cell[CellGroupData[{

Cell["I.c.1. Input", "Subsubsection"],

Cell[TextData[{
 "The expression ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 " could be typed in from the keyboard just as it appears in [9]. For longer \
expressions, or more complicated symbols, this can become sufficiently \
tedious that defining a symbol palette my be useful, although the BasicInput \
palette is usually sufficient. In the case of expressions with uniform \
structure, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 StyleBox["Sum", "Input",
  FontWeight->"Plain"],
 " function can be used, either with indexed symbols or with part \
specifications in the lists of variables; e.g.,"
}], "Text"],

Cell[BoxData[{
 RowBox[{"avf1", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Theta]", "i"], 
     SubscriptBox["e", "i"]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{
    SubscriptBox["e", "1"], " ", 
    SubscriptBox["\[Theta]", "1"]}], "+", 
   RowBox[{
    SubscriptBox["e", "2"], " ", 
    SubscriptBox["\[Theta]", "2"]}], "+", 
   RowBox[{
    SubscriptBox["e", "3"], " ", 
    SubscriptBox["\[Theta]", "3"]}]}],
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Outline"->False,
  "Shadow"->False,
  "Underline"->False}], "\n", 
 RowBox[{"                                                                    \
                                                                              \
 ", 
  RowBox[{"[", "10", "]"}]}], "\n", 
 RowBox[{"avf1", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"forms", "[", 
      RowBox[{"[", "i", "]"}], "]"}], " ", 
     RowBox[{"elements", "[", 
      RowBox[{"[", 
       RowBox[{"i", "+", "1"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{
    SubscriptBox["e", "1"], " ", 
    SubscriptBox["\[Theta]", "1"]}], "+", 
   RowBox[{
    SubscriptBox["e", "2"], " ", 
    SubscriptBox["\[Theta]", "2"]}], "+", 
   RowBox[{
    SubscriptBox["e", "3"], " ", 
    SubscriptBox["\[Theta]", "3"]}]}],
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Outline"->False,
  "Shadow"->False,
  "Underline"->False}]}], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "Whenever an AVF expression is used as an argument in an ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " function (such a multiplication), it is converted to an equivalent List \
expression adapted to the simplified structure of AVFs. The purpose is to \
allow writing efficient ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " procedures and to accomplish certain operations that are quite difficult \
to implement with the standard commands provided by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ".\n\nThese conversions happen \[OpenCurlyDoubleQuote]behind the scenes\
\[CloseCurlyDoubleQuote] and are generally invisible. The function ",
 StyleBox["in[avf]", "Input",
  FontWeight->"Plain"],
 " creates the equivalent List expression for the argument ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 " whenever it is required in a calculation. The List expression can be \
displayed by executing that command with any AVF argument. Caution: only a \
properly input ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 " will be converted correctly."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["I.c.2. Output", "Subsubsection"],

Cell[TextData[{
 "Upon completion of an ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " procedure, the final List expression is converted back to standard \
algebraic format by the function ",
 StyleBox["out[final]", "Input",
  FontWeight->"Plain"],
 ", essentially the inverse of ",
 StyleBox["in", "Input",
  FontWeight->"Plain"],
 ", except that all monomial wedge products are re-arranged into canonical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " order and the identity element of the algebra is suppressed. Any of the \
usual ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands can then be used on the output expression."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["I.d. Algebraic operations", "Subsection"],

Cell["\<\
There are three special algebraic functions on AVFs implemented in the \
program; multiplication, factoring out a basis form, and contraction with \
vectors.\
\>", "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell["I.d.1. Multiplication", "Subsubsection"],

Cell[TextData[{
 "The function, ",
 StyleBox["mult[avf1, avf2]", "Input",
  FontWeight->"Plain"],
 ", gives the expanded product of two AVFs. For each term in the result, it \
simultaneously performs the usual product of the scalar coefficients, the \
exterior product of the basis forms, and the algebraic product of the \
elements as determined by the ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " table.\n  \t\t\nThe same product results from using the ",
 StyleBox["NonCommutativeMultiply", "Input",
  FontWeight->"Plain"],
 " infix operator, ** . In this form, any number of AVFs can be multiplied \
together at once; e.g.,"
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"avf1", "**", "avf2", "**", "avf3", "**", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"etc", "."}], ")"}], 
   "                                                                       ", 
   "[", "11", "]"}]}]], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["\<\
If the algebra table defines a non-associative algebra, it may be necessary \
to use the appropriate parentheses to define the order of multiplications. \
Without parentheses, multiplication proceeds from right to left, as for \
composite functions.\
\>", "Text"],

Cell[TextData[{
 "The infix wedge symbol \[Wedge] appearing  between basis forms in input and \
output expressions has the usual significance of exterior product. It is \
important to note, however, that it is neither recognized nor used by the \
program as an operator. It is used purely symbolically to denote products of \
basis forms, and also serves to prevent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from incorrectly permuting the order of such products."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "Any wedge symbol in a properly input ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " can be replaced by the ** operator. This has little effect when the wedge \
is between basis forms, but in the case of non-basis-form factors (which must \
themselves be properly input AVFs in  parentheses), it will cause the product \
to be expanded out."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "The AVF function, ",
 StyleBox["expand[avf]", "Input",
  FontWeight->"Plain"],
 ", is included for just this purpose. It substitutes ** for all wedge \
symbols in the argument ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 ", and returns the expanded result. Its primary use is to facilitate \
replacements within wedge products."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"]
}, Open  ]],

Cell[CellGroupData[{

Cell["I.d.2. Factoring", "Subsubsection"],

Cell[TextData[{
 "The function ",
 StyleBox["factor[basisform, avf]", "Input",
  FontWeight->"Plain"],
 " returns the factor of ",
 StyleBox["basisform", "Input",
  FontWeight->"Plain"],
 " in ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 ", where ",
 StyleBox["basisform", "Input",
  FontWeight->"Plain"],
 " is any member of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " or ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 ", and ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 " is an AVF expression. The ",
 StyleBox["factor", "Input",
  FontWeight->"Plain"],
 " function does not require ",
 StyleBox["basisform", "Input",
  FontWeight->"Plain"],
 " to factor all of ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 "; it treats the terms separately and returns the factor of ",
 StyleBox["basisform", "Input",
  FontWeight->"Plain"],
 " in whatever subset of terms  contains it. For the sample ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 " given in [9], for instance, "
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"factor", "[", 
   RowBox[{
    SubscriptBox["\[Theta]", "2"], ",", "avf"}], "]"}], 
  "                                                                           \
               ", "[", "12", "]"}]], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["returns ", "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   StyleBox[
    RowBox[{"dx", " ", "z", " ", "\[Lambda]"}],
    FontWeight->"Plain"], 
   StyleBox["-",
    FontWeight->"Plain"], 
   RowBox[{
    StyleBox[
     FractionBox[
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       RowBox[{
        SubscriptBox["\[Theta]", "1"], "\[Wedge]", 
        SubscriptBox["\[Theta]", "4"]}]}], 
      SuperscriptBox["y", "3"]],
     FontWeight->"Plain"], 
    StyleBox[
     "                                                                        \
                 ",
     FontWeight->"Plain"], 
    StyleBox["[",
     FontWeight->"Bold"], 
    StyleBox["13",
     FontWeight->"Bold"], 
    StyleBox["]",
     FontWeight->"Bold"]}]}],
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Outline"->False,
  "Shadow"->False,
  "Underline"->False}]], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "where in standard AVF output the element ",
 Cell[BoxData[
  SubscriptBox["e", "0"]]],
 " has been suppressed. (The basisform is always factored to the left of ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 "). While this function may not be used very often, it is provided because \
it is not easily accomplished using standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " operations on wedge products."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"]
}, Open  ]],

Cell[CellGroupData[{

Cell["I.d.3. Vector contraction", "Subsubsection"],

Cell[TextData[{
 "In ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " a vector is a list of components, each component representing its \
contraction on the corresponding member of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " (which includes ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 "). In effect, the vector is expressed in the dual basis to ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ". For convenience, the procedure ",
 StyleBox["makevectors[]", "Input",
  FontWeight->"Plain"],
 " (no arguments) will generate four such vectors, ",
 StyleBox["{vec1, vec2, vec3, vec4}", "Input",
  FontWeight->"Plain"],
 ". Each of these is a list of the same length as ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ", having indexed components, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["v1", "i"], ",", 
    SubscriptBox["v2", "i"], ",", 
    SubscriptBox["v3", "i"], ",", 
    SubscriptBox["v4", "i"]}], "}"}]]],
 ", to represent its contraction on the  ith  member of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ". If needed  more vectors are easily constructed."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "Neither the names of the vectors nor the component symbols are reserved, so \
they can be given any variable names at will. A vector component should be \
defined for each member of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ", however, unless care is taken to avoid potential errors. Whenever ",
 StyleBox["makeforms", "Input",
  FontWeight->"Plain"],
 " is executed, it calls the ",
 StyleBox["makevectors", "Input",
  FontWeight->"Plain"],
 " routine automatically to create four new vectors agreeing in length and \
order with the new ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "Additional structures are necessary to implement the contraction of vectors \
on the 2-forms included in ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 ". This is accomplished by defining a list of replacements named ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " to express ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 " in terms of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ". The reserved variable ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " can be established in the standard way by ",
 StyleBox["makedrules[replacement_list]", "Input",
  FontWeight->"Plain"],
 ". For instance, a typical set of ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " might be:"
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{"makedrules", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["d\[Theta]", "1"], "->", 
     RowBox[{
      SubscriptBox["\[Theta]", "2"], "\[Wedge]", 
      SubscriptBox["\[Theta]", "3"]}]}], ",", 
    RowBox[{
     SubscriptBox["d\[Theta]", "2"], "->", 
     RowBox[{
      SubscriptBox["\[Theta]", "3"], "\[Wedge]", 
      SubscriptBox["\[Theta]", "1"]}]}], ",", 
    RowBox[{
     SubscriptBox["d\[Theta]", "3"], "->", 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], "\[Wedge]", 
      SubscriptBox["\[Theta]", "2"]}]}]}], "}"}], "]"}], "\n", 
 RowBox[{"                                                                    \
                                                                       ", 
  RowBox[{"[", "14", "]"}]}], "\n", 
 RowBox[{
  StyleBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["d\[Theta]", "1"], "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Theta]", "2"], "\[Wedge]", 
       SubscriptBox["\[Theta]", "3"]}]}], ",", 
     RowBox[{
      SubscriptBox["d\[Theta]", "2"], "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Theta]", "3"], "\[Wedge]", 
       SubscriptBox["\[Theta]", "1"]}]}], ",", 
     RowBox[{
      SubscriptBox["d\[Theta]", "3"], "\[Rule]", 
      RowBox[{
       SubscriptBox["\[Theta]", "1"], "\[Wedge]", 
       SubscriptBox["\[Theta]", "2"]}]}]}], "}"}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], "       "}]}], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "The initial default value for ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " is ",
 StyleBox["natural", "Input",
  FontWeight->"Plain"],
 ", {",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["d\[Theta]", "1"], "->", "0"}]]],
 ", etc}, i.e. specifying that all members of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " are closed. The ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " are invoked automatically for contractions where they are essential, but \
only then. The ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " are an extremely important and useful feature of ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " for many other purposes in addition to contraction. How the ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " are applied is illustrated in detail further down."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "Note that the vector components, ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["v1", "i"], ",", 
    SubscriptBox["v2", "i"], ",", 
    SubscriptBox["v3", "i"], ",", 
    SubscriptBox["v4", "i"]}], ")"}]]],
 ", are not automatically introduced into the ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " list, and so will not be differentiated. They can be added in by e.g.,"
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"makescalars", "[", 
    RowBox[{"Join", "[", 
     RowBox[{"scalars", ",", "vec1"}], "]"}], "]"}], 
   "                                                                  ", "[", 
   "15", "]"}]}]], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "so that the ",
 Cell[BoxData[
  SubscriptBox["v1", "i"]],
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " become independent scalars with their own exterior derivatives ",
 Cell[BoxData[
  SubscriptBox["dv1", "i"]],
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 ". Alternatively, the components could be given assigned values either as \
explicit, or unspecified, functions of the existing scalars. This should not \
be done, if they have been introduced as independent scalars by the ",
 StyleBox["makescalars", "Input",
  FontWeight->"Plain"],
 " command."
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "The function ",
 StyleBox["contract[vector,expression]", "Input",
  FontWeight->"Plain"],
 " returns the contraction of ",
 StyleBox["vector", "Input",
  FontWeight->"Plain"],
 " on ",
 StyleBox["expression", "Input",
  FontWeight->"Plain"],
 ", where ",
 StyleBox["expression", "Input",
  FontWeight->"Plain"],
 " can be either a single AVF or a list of AVFs. This operation also has an \
infix form using the \[OpenCurlyDoubleQuote]small-circle\" symbol, which is \
input by typing the sequence esc-sc-esc. And in this form multiple \
contractions can be performed; e.g.,"
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"vec1", "\[SmallCircle]", "vec2", "\[SmallCircle]", "vec3", 
  "\[SmallCircle]", 
  RowBox[{
  "avf1", "                                                                   \
                          ", "[", "16", "]"}]}]], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["or for a list of AVFs,", "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"vec4", "\[SmallCircle]", "vec1", "\[SmallCircle]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"avf1", ",", "avf2", ",", "avf3"}], "}"}], 
   "                                                                          \
 ", "[", "17", "]"}]}]], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["I.e. Exterior differentiation and Lie derivation", "Subsection"],

Cell[TextData[{
 "The operator ",
 StyleBox["d[expr]", "Input",
  FontWeight->"Plain"],
 " returns the exterior derivative of ",
 StyleBox["expr", "Input",
  FontWeight->"Plain"],
 " which may be either a single AVF, or a list of AVFs. The symbols used for \
the derivatives of all the fundamental variables are in ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 ". Their ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " commands also establish two additional replacement lists, ",
 StyleBox["sderiv", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["fderiv", "Input",
  FontWeight->"Plain"],
 ", to accomplish the derivations.\n\nA very simple example, for an ordinary \
1-form ",
 StyleBox["f", "Input",
  FontWeight->"Plain"],
 " is shown here:"
}], "Text",
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"x", " ", 
    SubscriptBox["\[Theta]", "1"]}], "+", 
   RowBox[{"y", " ", 
    SubscriptBox["\[Theta]", "2"]}], "+", 
   RowBox[{"z", " ", 
    SubscriptBox["\[Theta]", "3"]}]}]}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"x", " ", 
    SubscriptBox["\[Theta]", "1"]}], "+", 
   RowBox[{"y", " ", 
    SubscriptBox["\[Theta]", "2"]}], "+", 
   RowBox[{"z", " ", 
    SubscriptBox["\[Theta]", "3"]}]}],
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontVariations->{"Outline"->False,
  "Shadow"->False,
  "Underline"->False}], "\[IndentingNewLine]", 
 RowBox[{"                                                                    \
                                                          ", 
  RowBox[{"[", "18", "]"}]}], "\n", 
 RowBox[{"d", "[", "f", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  StyleBox[
   RowBox[{"x", " ", 
    SubscriptBox["d\[Theta]", "1"]}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], 
  StyleBox["+",
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], 
  StyleBox[
   RowBox[{"y", " ", 
    SubscriptBox["d\[Theta]", "2"]}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], 
  StyleBox["+",
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], 
  StyleBox[
   RowBox[{"z", " ", 
    SubscriptBox["d\[Theta]", "3"]}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], 
  StyleBox["+",
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], 
  StyleBox[
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Theta]", "1"]}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], 
  StyleBox["+",
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], 
  StyleBox[
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Theta]", "2"]}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}], "+", " ", 
  StyleBox[
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Theta]", "3"]}],
   FontWeight->"Plain",
   FontSlant->"Plain",
   FontTracking->"Plain",
   FontVariations->{"Outline"->False,
   "Shadow"->False,
   "Underline"->False}]}]}], "Input",
 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["The Lie derivative of AVFs is defined by the expansion:", "Text",
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"lie", "[", 
   RowBox[{"vec", ",", "avf"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"vec", "\[SmallCircle]", 
    RowBox[{"d", "[", "avf", "]"}]}], "+", 
   RowBox[{
    RowBox[{"d", "[", 
     RowBox[{"vec", "\[SmallCircle]", "avf"}], "]"}], 
    "                                        ", "[", "19", "]"}]}]}]], "Input",\

 Evaluatable->False,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "and since both ",
 StyleBox["d[]", "Input",
  FontWeight->"Plain"],
 " and \[SmallCircle] work with AVF lists, the ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 " argument here can be a list of AVFs. As explained in section I.d.3 on \
contractions, to execute this function on general objects, a set of ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " must be defined, and in order to be differentiated, the vector components \
must either be members of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " themselves, or expressed in terms of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageBreakBelow->Automatic,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["I.f. Clifford algebras", "Subsection"],

Cell[TextData[{
 "We now describe how to set up Clifford-Algebra-Valued forms within ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 ". This is done by executing the command ",
 StyleBox["makeclifford[{signature_list}]", "Input",
  FontWeight->"Plain"],
 ". The argument specifies the signatures of the diagonal metric, ",
 Cell[BoxData[
  SubscriptBox["g", "ij"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontFamily->"Courier",
  FontWeight->"Plain"],
 ", for a Clifford algebra defined with respect to an orthonormal basis, ",
 Cell[BoxData[
  SubscriptBox["\[Gamma]", "i"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontFamily->"Courier",
  FontWeight->"Plain"],
 "; i.e.,"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[Gamma]", "i"], 
    SubscriptBox["\[Gamma]", "j"]}], "+", 
   RowBox[{
    SubscriptBox["\[Gamma]", "j"], 
    SubscriptBox["\[Gamma]", "i"]}]}], "=", 
  RowBox[{"2", " ", 
   SubscriptBox["g", "ij"], 
   SubscriptBox["\[Gamma]", "0"], "        ", 
   RowBox[{"(", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["g", "ij"], "=", 
      RowBox[{"0", " ", 
       RowBox[{"{", 
        RowBox[{"i", "\[NotEqual]", "j"}], "}"}]}]}], ",", 
     RowBox[{
      SubscriptBox["g", "ii"], "=", 
      RowBox[{"\[PlusMinus]", "1"}]}]}], ")"}], "      ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "\[LessEqual]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "j"}], "}"}], "\[LessEqual]", "cadim"}], ")"}], 
    "         ", "[", "20", "]"}]}]}]], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  SubscriptBox["\[Gamma]", "0"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 " is the identity element and ",
 StyleBox["cadim", "Input",
  FontWeight->"Plain"],
 " is the number of generators. For example, a 4-dim Clifford algebra with \
Lorentzian metric would be obtained by:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"makeclifford", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}], "]"}], 
  "                                                              ", "[", "21",
   "]"}]], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["Another option would be:", "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"makeclifford", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], 
  "                                                         ", "[", "22", 
  "]"}]], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["\<\
but the two options actually give different Clifford algebras. The input\
\>", "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"makeclifford", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], "]"}], 
  "                                                                       ", 
  "[", "23", "]"}]], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["\<\
gives a Clifford algebra which is isomorphic to the algebra of quaternions.\
\>", "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell["I.f.1. Fundamental lists", "Subsubsection"],

Cell[TextData[{
 "The ",
 StyleBox["makeclifford[]", "Input",
  FontWeight->"Plain"],
 " command defines all the fundamental ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " lists for the chosen Clifford algebra, with the exception of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " which remains the null list ",
 StyleBox["{}", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "The program first checks the variable ",
 StyleBox["clifflist", "Input",
  FontWeight->"Plain"],
 " to see if this algebra has been encountered previously; if so, it will \
input the appropriate data file from the \
\[OpenCurlyDoubleQuote]CliffordAlgebras\[CloseCurlyDoubleQuote] folder. If \
not, it will proceed to construct the necessary quantities, save them in a \
file in that folder, and add the respective filename to ",
 StyleBox["clifflist", "Input",
  FontWeight->"Plain"],
 ", so it won't be necessary to repeat the calculation. Since the ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " matrix contains ",
 StyleBox["2^(2 cadim)", "Input",
  FontWeight->"Plain"],
 " entries, it is expensive in both time and memory to calculate for ",
 StyleBox["cadim > 6", "Input",
  FontWeight->"Plain"],
 " although the program is capable of ",
 StyleBox["cadim <= 11", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "If the command in [21] or [22] above were executed, the ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " list for either one would appear as :"
}], "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Gamma]", "0"], ",", 
    SubscriptBox["\[Gamma]", "1"], ",", 
    SubscriptBox["\[Gamma]", "2"], ",", 
    SubscriptBox["\[Gamma]", "3"], ",", 
    SubscriptBox["\[Gamma]", "4"], ",", 
    SubscriptBox["\[Gamma]", "12"], ",", 
    SubscriptBox["\[Gamma]", "13"], ",", 
    SubscriptBox["\[Gamma]", "14"], ",", 
    SubscriptBox["\[Gamma]", "23"], ",", 
    SubscriptBox["\[Gamma]", "24"], ",", 
    SubscriptBox["\[Gamma]", "34"], ",", 
    SubscriptBox["\[Gamma]", "15"], ",", 
    SubscriptBox["\[Gamma]", "25"], ",", 
    SubscriptBox["\[Gamma]", "35"], ",", 
    SubscriptBox["\[Gamma]", "45"], ",", 
    SubscriptBox["\[Gamma]", "5"]}], "}"}], "            ", "[", "24", 
  "]"}]], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "although the algebra tables would differ. Multiple indices indicate the \
corresponding products; e.g. ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "23"], "=", 
   RowBox[{
    SubscriptBox["\[Gamma]", "2"], 
    SubscriptBox["\[Gamma]", "3"]}]}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 ". The element ",
 Cell[BoxData[
  SubscriptBox["\[Gamma]", 
   RowBox[{"1", " ", "+", " ", "cadim"}]]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 " is always used to represent the complete product element; in this case ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "5"], "=", 
   RowBox[{
    SubscriptBox["\[Gamma]", "1"], 
    SubscriptBox["\[Gamma]", "2"], 
    SubscriptBox["\[Gamma]", "3"], 
    SubscriptBox["\[Gamma]", "4"]}]}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 ". And in order to minimize the amount of indices, a \
\[OpenCurlyDoubleQuote]dual\[CloseCurlyDoubleQuote] representation for higher \
products is employed; i.e., ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "15"], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "1"], 
     SubscriptBox["\[Gamma]", "5"]}], "=", 
    RowBox[{
     RowBox[{"sig", "[", "1", "]"}], 
     SubscriptBox["\[Gamma]", "234"]}]}]}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 ", etc."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["I.f.2. Variables and algebra-valued-forms", "Subsubsection"],

Cell[TextData[{
 "Two lists of graded symbols are generated by ",
 StyleBox["makeclifford[]", "Input",
  FontWeight->"Plain"],
 ": ",
 StyleBox["omegas", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["thetas", "Input",
  FontWeight->"Plain"],
 ". Both are established as basis 1-forms by ",
 StyleBox["makeforms", "Input",
  FontWeight->"Plain"],
 "; e.g., (in the ",
 StyleBox["cadim==4", "Input",
  FontWeight->"Plain"],
 " case)"
}], "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"forms", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      OverscriptBox["\[Theta]", "0"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "24"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "1"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "2"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "3"], ",", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "4"], ",", 
      OverscriptBox["\[Theta]", "4"], ",", "\n", "\t           ", 
      OverscriptBox["\[Omega]", "0"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "1"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "2"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "3"], ",", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "4"], ",", 
      OverscriptBox["\[Omega]", "4"]}], "  ", "}"}], "      ", "[", "25", 
    "]"}]}]}]], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "where the grades of the basis 1-forms are indicated by overscripts. These \
are used to create two graded CAV 1-forms, ",
 Cell[BoxData[
  OverscriptBox["\[Theta]", "^"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " and ",
 Cell[BoxData[
  OverscriptBox["\[Omega]", "^"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    OverscriptBox["\[Theta]", "^"], " ", "=", "  ", 
    RowBox[{
     RowBox[{
      OverscriptBox["\[Theta]", "0"], " ", 
      SubscriptBox["\[Gamma]", "0"]}], "+", "\n", "\t       ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "2"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "3"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "4"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"]}], "+", "\n", "\t       ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "12"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "13"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "14"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "23"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "24"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "34"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"]}], "+", 
     "                                         ", 
     RowBox[{"[", "26", "]"}]}]}], "\n", "\t       ", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "15"], " ", 
     SubscriptBox[
      OverscriptBox["\[Theta]", "3"], "1"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "25"], " ", 
     SubscriptBox[
      OverscriptBox["\[Theta]", "3"], "2"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "35"], " ", 
     SubscriptBox[
      OverscriptBox["\[Theta]", "3"], "3"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "45"], " ", 
     SubscriptBox[
      OverscriptBox["\[Theta]", "3"], "4"]}], "+", "\n", "\t       ", 
    RowBox[{
     OverscriptBox["\[Theta]", "4"], " ", 
     SubscriptBox["\[Gamma]", "5"]}]}], "\n", "\n", 
   RowBox[{
    OverscriptBox["\[Omega]", "^"], " ", "=", "  ", 
    RowBox[{
     RowBox[{
      OverscriptBox["\[Omega]", "0"], " ", 
      SubscriptBox["\[Gamma]", "0"]}], "+", "\n", "\t      ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "2"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "3"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "4"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}], "+", "\n", "\t      ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "12"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "13"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "14"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "23"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "24"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "34"], " ", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}], "+", 
     "                                         ", 
     RowBox[{"[", "27", "]"}]}]}], "\n", "\t      ", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "15"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "3"], "1"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "25"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "3"], "2"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "35"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "3"], "3"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "45"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "3"], "4"]}], " ", "+", "\n", 
    "                ", 
    RowBox[{
     OverscriptBox["\[Omega]", "4"], " ", 
     SubscriptBox["\[Gamma]", 
      RowBox[{"5", "\t\t\t"}]]}]}]}]}]], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["\<\
where the grades have been put on separate lines for clarity. Other CAV \
expressions with higher degree p-forms (not necessarily homogeneous) can also \
be defined. Examples are the homogeneous torsion and curvature 2-forms \
discussed next.\
\>", "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "In the particular case of metric geometry, the grade[1] part of ",
 Cell[BoxData[
  OverscriptBox["\[Theta]", "^"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " could represent an orthonormal co-frame with signature given by the \
Clifford algebra, and the grade[2] part of ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["\[Omega]", "^"], " "}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 "would represent Cartan\[CloseCurlyQuote]s skew-symmetric connection matrix. \
The commands ",
 Cell[BoxData[
  RowBox[{"grade", "[", 
   RowBox[{"1", ",", 
    OverscriptBox["\[Theta]", "^"]}], "]"}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " and ",
 Cell[BoxData[
  RowBox[{"and", " ", 
   RowBox[{"grade", "[", 
    RowBox[{"2", ",", 
     OverscriptBox["\[Omega]", "^"]}], "]"}]}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " will pick out these parts:"
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   OverscriptBox["\[Theta]", "^"], "=", " ", 
   RowBox[{
    RowBox[{"grade", "[", 
     RowBox[{"1", ",", 
      OverscriptBox["\[Theta]", "^"]}], "]"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "2"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "3"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"]}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "4"], " ", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"]}]}]}]}], "  "}], "\n", 
 RowBox[{"\t\t\t\t\t\t                                                        \
                                             ", 
  RowBox[{"[", "28", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  OverscriptBox["\[Omega]", "^"], "=", " ", 
  RowBox[{
   RowBox[{"grade", "[", 
    RowBox[{"2", ",", 
     OverscriptBox["\[Omega]", "^"]}], "]"}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "12"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "2"], "12"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "13"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "2"], "13"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "14"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "23"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "2"], "23"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "24"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
    RowBox[{
     SubscriptBox["\[Gamma]", "34"], " ", 
     SubscriptBox[
      OverscriptBox["\[Omega]", "2"], "34"], 
     "       \t                    "}]}]}]}]}], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["\<\
In this geometric situation, the components of the torsion 2-form, \
\[CapitalTheta], and the curvature 2-form, \[CapitalOmega], are defined by \
the Cartan structure equations:\
\>", "Text",
 PageBreakAbove->True,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{
  SubscriptBox["\[CapitalTheta]", "i"], "=", 
  RowBox[{
   SubscriptBox[
    OverscriptBox["d\[Theta]", "1"], "i"], "+", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "cadim"], 
    RowBox[{
     SubscriptBox["g", "kk"], 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "ik"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "k"]}]}]}]}]}], "\[IndentingNewLine]", 

 RowBox[{"\t\t\t\t\t\t\t\t\t\t\t                                    \t\t", 
  RowBox[{"[", "29", "]"}]}], "\n", 
 RowBox[{
  SubscriptBox["\[CapitalOmega]", "ij"], "=", " ", 
  RowBox[{
   SubscriptBox[
    OverscriptBox["d\[Omega]", "2"], "ij"], "+", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "cadim"], 
    RowBox[{
     SubscriptBox["g", "kk"], 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "ik"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "kj"]}]}]}]}]}]}], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "These can be combined into the CAV torsion 2-form",
 Cell[BoxData[
  RowBox[{
   OverscriptBox[
    RowBox[{" ", "\[CapitalTheta]"}], "^"], " ", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", "i", "cadim"], 
    RowBox[{
     SubscriptBox["\[CapitalTheta]", "i"], 
     SubscriptBox["\[Gamma]", "i"]}]}]}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 ", and the CAV curvature 2-form ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["\[CapitalOmega]", "^"], " ", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", ",", 
      RowBox[{"j", ">", "i"}]}], "cadim"], " ", 
    RowBox[{
     SubscriptBox["\[CapitalOmega]", "ij"], 
     SubscriptBox["\[Gamma]", "ij"]}]}]}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  FontWeight->"Plain"],
 ", which are then given by the AVF expressions"
}], "Text"],

Cell[BoxData[{
 RowBox[{
  OverscriptBox["\[CapitalTheta]", "^"], " ", "=", " ", 
  RowBox[{
   RowBox[{"d", "[", 
    OverscriptBox["\[Theta]", "^"], "]"}], "+", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       OverscriptBox["\[Omega]", "^"], "**", 
       OverscriptBox["\[Theta]", "^"]}], "+", 
      RowBox[{
       OverscriptBox["\[Theta]", "^"], "**", 
       OverscriptBox["\[Omega]", "^"]}]}], ")"}]}]}]}], "\n", 
 RowBox[{"\t\t\t\t\t\t\t\t\t                          \t\t\t\t\t", 
  RowBox[{"[", "30", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  OverscriptBox["\[CapitalOmega]", "^"], " ", "=", " ", 
  RowBox[{
   RowBox[{"d", "[", 
    OverscriptBox["\[Omega]", "^"], "]"}], "+", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      OverscriptBox["\[Omega]", "^"], "**", 
      OverscriptBox["\[Omega]", "^"]}], ")"}]}]}]}]}], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 "and these CAVs comprise all the Cartan structure equations for the manifold \
--which would be Riemannian for vanishing torsion, ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["\[CapitalTheta]", "^"], "=", "0"}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 ". The ",
 StyleBox["CAV",
  FontSlant->"Italic"],
 " commands ",
 StyleBox["maketorsion[]", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["makecurvature[]", "Input",
  FontWeight->"Plain"],
 StyleBox[" will use these definitions to evaluate them explicitly for any \
assigned ",
  FontWeight->"Plain"],
 Cell[BoxData[
  OverscriptBox["\[Theta]", "^"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " and ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["\[Omega]", "^"], " "}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 "."
}], "Text"],

Cell[TextData[{
 "The definitions [30] can also be used in the general case when ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["\[Theta]", "^"], " "}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 "and ",
 Cell[BoxData[
  OverscriptBox["\[Omega]", "^"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " incorporate all possible grades for the algebra. In this situation ",
 Cell[BoxData[
  OverscriptBox["\[Omega]", "^"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " can be interpreted as a non-Abelian CAV gauge potential and ",
 Cell[BoxData[
  OverscriptBox["\[CapitalOmega]", "^"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " as the corresponding CAV field 2-form. Note that the field ",
 Cell[BoxData[
  OverscriptBox["\[CapitalOmega]", "^"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 " will contain a mixture of the different grades of the CAV gauge potential ",
 Cell[BoxData[
  OverscriptBox["\[Omega]", "^"]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 ". In the ",
 StyleBox["cadim=4", "Input",
  FontWeight->"Plain"],
 " case, for instance, interactions are generated among the"
}], "Text"],

Cell["\<\
grade[1] : ( vector - valued),
grade[2] : ( tensor - valued),
grade[3] : ( pseudovector - valued), and   
grade[4] : ( pseudoscalar - valued) parts.

The exception is the grade[0] : (scalar-valued, or Abelian) part, which never \
mixes.\
\>", "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell["\<\
Both the torsion and curvature 2-forms satisfy differential identities by \
virtue of their definitions,\
\>", "Text",
 PageBreakAbove->True,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"torsionidentity", "[", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", 
      OverscriptBox["\[CapitalTheta]", "^"], "]"}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         OverscriptBox["\[Omega]", "^"], "**", 
         OverscriptBox["\[CapitalTheta]", "^"]}], "-", 
        RowBox[{
         OverscriptBox["\[CapitalTheta]", "^"], "**", 
         OverscriptBox["\[Omega]", "^"]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         OverscriptBox["\[Theta]", "^"], "**", 
         OverscriptBox["\[CapitalOmega]", "^"]}], "-", 
        RowBox[{
         OverscriptBox["\[CapitalOmega]", "^"], "**", 
         OverscriptBox["\[Theta]", "^"]}]}], ")"}]}]}], ")"}], "==", 
   "0"}]}], "\[IndentingNewLine]", 
 RowBox[{"\t\t\t\t\t\t\t\t\t\t\t\t\t\t       \t\t", 
  RowBox[{"[", "31", "]"}]}], "\n", 
 RowBox[{
  RowBox[{"curvatureidentity", "[", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", 
      OverscriptBox["\[CapitalOmega]", "^"], "]"}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         OverscriptBox["\[Omega]", "^"], "**", 
         OverscriptBox["\[CapitalOmega]", "^"]}], "-", 
        RowBox[{
         OverscriptBox["\[CapitalOmega]", "^"], "**", 
         OverscriptBox["\[Omega]", "^"]}]}], ")"}]}]}], ")"}], "==", 
   "0"}]}]}], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]],

Cell["\<\
and are known to the program by these names. They can be verified by explicit \
calculation, although in the completely general case with arbitrary basis \
forms and all grades included, it requires some time for a 4-dim, or higher, \
algebra.\
\>", "Text",
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 GroupPageBreakWithin->Automatic,
 FontWeight->"Plain"],

Cell[TextData[{
 "In the 4-dim Riemannian case with ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["\[CapitalTheta]", "^"], "=", "0"}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 ", only the last commutator in ",
 StyleBox["torsionidentity", "Input",
  FontWeight->"Plain"],
 " survives. It is a grade[1] 3-form which expresses the usual cyclic \
identity for the curvature components. The corresponding anticommutator, ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox["G", "^"], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       OverscriptBox["\[Theta]", "^"], "**", 
       OverscriptBox["\[CapitalOmega]", "^"]}], "+", 
      RowBox[{
       OverscriptBox["\[CapitalOmega]", "^"], "**", 
       OverscriptBox["\[Theta]", "^"]}]}], ")"}], "/", "2", " "}]}]],
  PageBreakAbove->Automatic,
  PageBreakWithin->Automatic,
  PageBreakBelow->Automatic,
  GroupPageBreakWithin->Automatic,
  FontWeight->"Plain"],
 "is a grade[3] 3-form which incorporates all four Ricci 3-forms expressing \
the Ricci, or actually Einstein, curvature tensor. It satisfais a contracted \
identity with the general form"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"contractedidentity", "[", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", 
      OverscriptBox["G", "^"], "]"}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         OverscriptBox["\[Omega]", "^"], "**", 
         OverscriptBox["G", "^"]}], "+", 
        RowBox[{
         OverscriptBox["G", "^"], "**", 
         OverscriptBox["\[Omega]", "^"]}]}], ")"}]}], "-", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         OverscriptBox["\[CapitalTheta]", "^"], "**", 
         OverscriptBox["\[CapitalOmega]", "^"]}], "+", 
        RowBox[{
         OverscriptBox["\[CapitalOmega]", "^"], "**", 
         OverscriptBox["\[CapitalTheta]", "^"]}]}], ")"}]}]}], ")"}], "==", 
   RowBox[{"0", "            ", "[", "32", "]"}]}]}]], "Input",
 Evaluatable->False,
 PageBreakAbove->Automatic,
 PageBreakWithin->Automatic,
 PageBreakBelow->Automatic,
 Background->GrayLevel[0.900008]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["I.g. AVF names of variables and functions", "Subsection"],

Cell[TextData[{
 "All ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " names are lower case to distinguish them from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " names. Most of the names on these lists are protected and so will refuse \
assignment. A large number of unlisted temporary variables and subroutines \
have names beginning with ",
 StyleBox["av$", "Input",
  FontWeight->"Plain"],
 ".  To avoid interference, this pattern should not be used when defining new \
names or symbols."
}], "Text"],

Cell[CellGroupData[{

Cell["I.g.1.Variables", "Subsubsection"],

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{
   RowBox[{
    RowBox[{"1.", "  ", "adjlist"}], " ", "-", " ", 
    RowBox[{
    "arbitrary", " ", "permutation", " ", "of", " ", "the", " ", "list", " ", 
     "in", " ", "\"\<elements\>\""}]}], "  ", "\n", "  ", 
   RowBox[{
    RowBox[{"2.", "  ", "algebra"}], " ", "-", " ", 
    RowBox[{
    "multiplication", " ", "table", " ", "for", " ", "the", " ", 
     "\"\<elements\>\"", " ", "of", " ", "an", "  ", "algebra"}]}], "\n", 
   "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"3.", "  ", "brackets"}], " ", "-", " ", 
     RowBox[{"Lie", " ", "brackets"}]}], ",", 
    RowBox[{"[", " ", 
     RowBox[{
      SubscriptBox["V", 
       RowBox[{"forms", "[", 
        RowBox[{"[", "i", "]"}], "]"}]], ",", 
      SubscriptBox["V", 
       RowBox[{"forms", "[", 
        RowBox[{"[", "j", "]"}], "]"}]]}], " ", "]"}], ",", 
    RowBox[{
     RowBox[{"for", " ", "non"}], "-", 
     RowBox[{"exact", " ", "dual", " ", "vectors"}]}]}], "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"4.", "  ", "cadim"}], " ", "-", " ", 
     RowBox[{"number", " ", "of", " ", "generators", 
      RowBox[{"(", " ", 
       SubscriptBox["\[Gamma]", "i"], ")"}]}]}], ",", 
    RowBox[{
    "in", " ", "the", " ", "orthonormal", " ", "basis", " ", "of", " ", "a", 
     " ", "Clifford", " ", "algebra"}]}], "\n", "  ", 
   RowBox[{
    RowBox[{"5.", "  ", "clifflist"}], " ", "-", 
    RowBox[{
    "list", " ", "of", " ", "the", " ", "filenames", " ", "in", " ", "the", 
     "\"\<CliffordAlgebras\>\"", " ", "folder"}]}], "\n", "  ", 
   RowBox[{
    RowBox[{"6.", "  ", "coords"}], "-", " ", 
    RowBox[{
    "list", " ", "of", " ", "scalars", " ", "designated", " ", "as", " ", 
     "independent", " ", "variables"}]}], "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"7.", "  ", "coordsdim"}], " ", "-", " ", 
      RowBox[{"number", " ", "of", " ", "independent", " ", "variables"}]}], 
     ";"}], " ", "=", " ", 
    RowBox[{"Length", "[", "coords", "]"}]}], "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"8.", "  ", "cosub"}], " ", "-", " ", 
     RowBox[{"the", " ", "list", " ", "of", " ", "basis", " ", "1"}], "-", 
     RowBox[{
     "forms", " ", "to", " ", "be", " ", "annulled", " ", "in", " ", "a", " ",
       "subspace"}]}], ";", "\"\<subspace[cosub]\>\""}], "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"9.", "  ", "depend"}], " ", "-", " ", 
     RowBox[{"\"\<coords\>\"", " ", "as", " ", "a", " ", "Sequence"}]}], ";", 
    " ", 
    RowBox[{"used", " ", "for", " ", "function", " ", "arguments"}]}], "\n", 
   RowBox[{
    RowBox[{"10.", "  ", "dforms"}], " ", "-", 
    RowBox[{
    "list", " ", "of", " ", "symbols", " ", "for", " ", "the", " ", 
     "exterior", " ", "derivatives", " ", "of", " ", "the", " ", "members", 
     " ", "of", " ", "\"\<forms\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"11.", " ", "drules"}], " ", "-", " ", 
    RowBox[{
    "list", " ", "of", " ", "replacement", " ", "rules", " ", "for", " ", 
     "the", " ", "exterior", " ", "derivatives", " ", "of", " ", 
     "\"\<forms\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"12.", " ", "dscalars"}], " ", "-", " ", 
    RowBox[{
    "list", " ", "of", " ", "symbols", " ", "for", " ", "the", " ", 
     "exterior", " ", "derivatives", " ", "of", " ", "\"\<scalars\>\""}]}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"13.", " ", "eldim"}], " ", "-", " ", 
      RowBox[{"number", " ", "of", " ", "algebra", " ", "elements"}]}], ";"}],
     " ", "=", " ", 
    RowBox[{"Length", "[", "elements", "]"}]}], "\n", 
   RowBox[{
    RowBox[{"14.", " ", "elements"}], " ", "-", " ", 
    RowBox[{
    "list", " ", "of", " ", "generators", " ", "of", " ", "the", " ", 
     "algebra", " ", "specified", " ", "by", " ", "\"\<algebra\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"15.", " ", "fderiv"}], " ", "-", " ", 
    RowBox[{
    "basic", " ", "rules", " ", "to", " ", "give", " ", "exterior", " ", 
     "derivatives", " ", "of", " ", "\"\<forms\>\"", " ", "and", " ", 
     "\"\<dforms\>\""}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"16.", " ", "fmdim"}], " ", "-", " ", 
      RowBox[{
      "number", " ", "of", " ", "independent", " ", "basis", " ", "1"}], "-", 
      "forms"}], ";"}], " ", "=", " ", 
    RowBox[{"Length", "[", "forms", "]"}]}], "\n", 
   RowBox[{
    RowBox[{"17.", " ", "forms"}], " ", "-", " ", 
    RowBox[{"list", " ", "of", " ", "basis", " ", "1"}], "-", 
    RowBox[{
    "forms", " ", "generating", " ", "the", " ", "exterior", " ", "algebra"}],
     " ", "-", 
    RowBox[{"includes", " ", "\"\<dscalars\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"18.", " ", "frame"}], " ", "-", " ", 
    RowBox[{
    "list", " ", "of", " ", "orthonormal", " ", "basis", " ", "forms"}]}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"19.", " ", "frdim"}], " ", "-", " ", 
      RowBox[{
      "number", " ", "of", " ", "orthonormal", " ", "basis", " ", "1"}], "-", 
      "forms"}], ";"}], " ", "=", " ", 
    RowBox[{"Length", "[", "frame", "]"}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"20.", " ", "gammas"}], " ", "-", 
     RowBox[{"all", "  ", "Clifford", " ", "\"\<elements\>\""}]}], ",", 
    RowBox[{
    "retrieved", " ", "from", " ", "a", " ", "file", " ", "in", "  ", 
     "\"\<CliffordAlgebras\>\""}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"21.", " ", "identity"}], " ", "-", " ", "elements"}], "=", 
    RowBox[{
     RowBox[{"{", "identity", "}"}], " ", "is", " ", "the", " ", "initial", 
     " ", "default", " ", "assignment", " ", "for", " ", 
     "\"\<elements\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"22.", " ", "names"}], " ", "-", " ", 
    RowBox[{
    "list", " ", "of", " ", "all", " ", "AVF", " ", "and", " ", "CAV", " ", 
     "variables", " ", "and", " ", "functions"}]}], "\n", 
   RowBox[{
    RowBox[{"23.", " ", "natural"}], " ", "-", " ", 
    RowBox[{
    "the", "\"\<drules\>\"", "specifying", " ", "\"\<closed\>\"", "  ", 
     "basis", " ", "1"}], "-", 
    RowBox[{"forms", 
     RowBox[{"(", " ", 
      RowBox[{"default", " ", "value"}], ")"}]}]}], " ", "\n", 
   RowBox[{
    RowBox[{"24.", " ", "omegas"}], " ", "-", " ", 
    RowBox[{
    "first", " ", "list", " ", "of", " ", "graded", " ", "symbols", " ", 
     "for", " ", "a", " ", "complete", " ", "set", " ", "of", " ", "CAV", "  ",
      "1"}], "-", "forms"}], "\n", 
   RowBox[{
    RowBox[{"25.", " ", "scalars"}], " ", "-", " ", 
    RowBox[{"list", " ", "of", " ", "0"}], "-", 
    RowBox[{
    "forms", " ", "which", " ", "will", " ", "have", " ", "exterior", " ", 
     "derivatives", " ", "given", " ", "by", " ", "\"\<dscalars\>\""}]}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"26.", " ", "scdim"}], " ", "-", " ", 
      RowBox[{"number", " ", "of", " ", "scalars"}]}], ";"}], " ", "=", 
    RowBox[{"Length", "[", "scalars", "]"}]}], "\n", 
   RowBox[{
    RowBox[{"27.", " ", "sderiv"}], " ", "-", "  ", 
    RowBox[{
    "basic", " ", "rules", " ", "to", "  ", "give", " ", "exterior", " ", 
     "derivatives", " ", "of", " ", "\"\<scalars\>\""}]}], " ", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"28.", " ", 
       RowBox[{"sig", "[", "i", "]"}]}], " ", "-", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SubscriptBox["\[Gamma]", "i"], ")"}], "2"]}], "=", 
     RowBox[{"\[PlusMinus]", "1"}]}], ",", 
    RowBox[{"the", " ", "ith", " ", "eigenvalue"}], ",", 
    SubscriptBox["g", "ii"], ",", 
    RowBox[{
    "of", " ", "the", " ", "diagonal", " ", "Clifford", " ", "metric"}]}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"29.", " ", "signature"}], " ", "-", 
     RowBox[{"list", " ", "of", " ", "all", " ", 
      RowBox[{"sig", "[", "i", "]"}]}]}], ";", " ", 
    RowBox[{
    "the", " ", "argument", " ", "for", "  ", 
     "\"\<makeclifford[signature]\>\""}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"30.", " ", "skew"}], " ", "-", " ", 
     RowBox[{"list", " ", "of", " ", "skew"}], "-", 
     RowBox[{"symmetric", " ", "structure", " ", 
      RowBox[{"constants", ":", "  ", 
       RowBox[{
        SubscriptBox["sk", 
         RowBox[{"i", ",", "j", ",", "k"}]], "+", 
        SubscriptBox["sk", 
         RowBox[{"i", ",", "k", ",", "j"}]]}]}]}]}], "=", "0"}], "\t", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"31.", " ", "sub"}], " ", "-", " ", 
      RowBox[{"list", " ", "of", " ", "basis", " ", "1"}], "-", 
      RowBox[{"forms", " ", "spanning", " ", "a", " ", "subspace"}]}], ";"}], 
    " ", "=", " ", 
    RowBox[{"Complement", "[", 
     RowBox[{"forms", ",", "cosub"}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"32.", " ", "symm"}], " ", "-", " ", 
     RowBox[{"list", " ", "of", " ", "symmetric", " ", "structure", " ", 
      RowBox[{"constants", ":", "  ", 
       RowBox[{
        SubscriptBox["sy", 
         RowBox[{"i", ",", "j", ",", "k"}]], "-", 
        SubscriptBox["sy", 
         RowBox[{"i", ",", "k", ",", "j"}]]}]}]}]}], "=", "0"}], "\t", "\n", 
   RowBox[{
    RowBox[{"33.", " ", "thetas"}], " ", "-", " ", 
    RowBox[{
    "second", " ", "list", " ", "of", " ", "graded", " ", "symbols", " ", 
     "for", " ", "a", " ", "complete", " ", "set", " ", "of", " ", "CAV", "  ",
      "1"}], "-", "forms"}], "\n", 
   RowBox[{
    RowBox[{"34.", " ", "topartials"}], " ", "-", " ", 
    RowBox[{
    "replacements", " ", "to", " ", "express", " ", "exterior", " ", 
     "derivatives", " ", "by", "  ", "partials", 
     RowBox[{"(", "subscripts", ")"}]}]}], "\n", 
   RowBox[{
    RowBox[{"35.", " ", "tosub"}], " ", "-", " ", 
    RowBox[{
    "replacements", " ", "to", " ", "annul", " ", "\"\<cosub\>\"", " ", "and",
      "  ", 
     RowBox[{"d", "[", "cosub", "]"}], " ", "in", " ", "a", " ", 
     "subspace"}]}], "\n", 
   RowBox[{
    RowBox[{"36.", " ", "trivial"}], " ", "-", " ", 
    RowBox[{
    "the", " ", "initial", " ", "default", " ", "value", " ", "of", " ", 
     "\"\<algebra\>\"", "  ", "having", " ", "\"\<identity\>\"", " ", "in", 
     " ", "most", " ", "positions"}]}], "\n", 
   RowBox[{
    RowBox[{"37.", " ", "vec1"}], ",", "vec2", ",", "vec3", ",", 
    RowBox[{"vec4", " ", "-", " ", 
     RowBox[{
     "four", " ", "independent", " ", "vectors", " ", "created", " ", "by", 
      " ", "\"\<makevectors\>\""}]}]}], "\n", 
   RowBox[{
    RowBox[{"38.", " ", 
     SubscriptBox["v1", "i"]}], ",", 
    SubscriptBox["v2", "i"], ",", 
    SubscriptBox["v3", "i"], ",", 
    RowBox[{
     SubscriptBox["v4", "i"], " ", "-", " ", 
     RowBox[{
     "the", " ", "components", " ", "of", " ", "the", " ", "above", " ", 
      "vectors", " ", "in", " ", "the", " ", "dual", " ", "basis", " ", "to", 
      " ", "\"\<forms\>\""}]}]}]}]}]], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["I.g.2. Functions", "Subsubsection"],

Cell[TextData[{
 "The  argument ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 " means a single  algebra-valued-form; ",
 StyleBox["avf or {avfs}", "Input",
  FontWeight->"Plain"],
 " means either a single avf, or a list of them. Functions with CAV arguments \
are defined only for those expressions. Empty brackets mean no arguments."
}], "Text"],

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1.", " ", 
      RowBox[{"adjmat", "[", 
       RowBox[{"list_of", "_elements"}], "]"}]}], " ", "-", " ", 
     RowBox[{"returns", " ", 
      RowBox[{"matrix", ":", 
       RowBox[{"adjmat", ".", "adjlist"}]}]}]}], " ", "=", " ", 
    "argument_list"}], "\n", "  ", 
   RowBox[{
    RowBox[{"2.", 
     RowBox[{"adL", "[", 
      RowBox[{"element", ",", 
       RowBox[{"list_of", "_elements"}]}], "]"}]}], " ", "-", " ", 
    RowBox[{"returns", " ", 
     RowBox[{
      RowBox[{"(", "element", ")"}], "**", 
      RowBox[{"{", 
       RowBox[{"any", " ", "list", " ", "of", " ", "the", " ", "elements"}], 
       "}"}]}]}]}], "\n", "  ", 
   RowBox[{
    RowBox[{"3.", " ", 
     RowBox[{"adR", "[", 
      RowBox[{
       RowBox[{"list_of", "_elements"}], ",", "element"}], "]"}]}], " ", "-", 
    " ", 
    RowBox[{"returns", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"any", " ", "list", " ", "of", " ", "the", " ", "elements"}], 
       "}"}], "**", 
      RowBox[{"(", "element", ")"}]}]}]}], "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"4.", " ", 
       RowBox[{"applydrules", "[", 
        RowBox[{"avf", " ", "or", " ", 
         RowBox[{"{", "avfs", "}"}]}], "]"}]}], " ", "-", " ", 
      RowBox[{"implements", " ", "\"\<drules\>\""}]}], ";"}], "=", " ", 
    RowBox[{"expand", "[", 
     RowBox[{
      RowBox[{"{", "avfs", "}"}], "/.", "drules"}], "]"}]}], "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"5.", " ", 
      RowBox[{"associators", "[", "n", "]"}]}], " ", "-", " ", 
     RowBox[{
     "returns", " ", "up", " ", "to", " ", "\"\<n\>\"", "  ", "associators", 
      " ", "for", " ", "\"\<algebra\>\""}]}], ";", 
    RowBox[{"prints", " ", "number", " ", "found"}]}], "\n", "  ", 
   RowBox[{
    RowBox[{"6.", " ", 
     RowBox[{"coeffs", "[", "avf", "]"}]}], " ", "-", " ", 
    RowBox[{
    "returns", " ", "a", " ", "list", " ", "of", " ", "the", " ", "non"}], 
    "-", 
    RowBox[{
    "zero", " ", "coefficients", " ", "of", " ", "\"\<elements\>\"", " ", 
     "in", " ", "\"\<avf\>\""}]}], "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"7.", " ", 
      RowBox[{"collect", "[", 
       RowBox[{"avf", " ", "or", " ", 
        RowBox[{"{", "avfs", "}"}]}], "]"}]}], " ", "-", " ", 
     RowBox[{
     "collects", " ", "the", " ", "factors", " ", "of", " ", 
      "\"\<elements\>\""}]}], ";", 
    RowBox[{"displays", "\"\<identity\>\""}]}], "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"8.", " ", 
        RowBox[{"contract", "[", 
         RowBox[{"vector", ",", 
          RowBox[{"avf", " ", "or", " ", 
           RowBox[{"{", "avfs", "}"}]}]}], "]"}]}], " ", "-", " ", 
       RowBox[{"contracts", " ", "\"\<vector\>\"", " ", "on", " ", 
        RowBox[{"{", "avfs", "}"}]}]}], ";"}], "\[SmallCircle]", " ", "is"}], 
    " ", "the", " ", "infix", " ", "form"}], "\n", "  ", 
   RowBox[{
    RowBox[{"9.", " ", 
     RowBox[{"contractedidentity", "[", "]"}]}], " ", "-", " ", 
    RowBox[{
    "differential", " ", "identity", " ", "for", " ", "the", " ", "Einstein", 
     " ", "3"}], "-", 
    RowBox[{"form", "  ", 
     OverscriptBox[
      OverscriptBox["G", "^"], " "]}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"10.", " ", 
      RowBox[{"curvatureidentity", "[", "]"}]}], " ", "-", " ", 
     RowBox[{"aka", " ", "Bianchi", " ", "identity"}]}], ";", 
    RowBox[{
    "general", " ", "identity", " ", "for", " ", "CAV", " ", "field", "  ", 
     OverscriptBox["\[CapitalOmega]", "^"]}]}], "\n", 
   RowBox[{
    RowBox[{"11.", " ", 
     RowBox[{"d", "[", 
      RowBox[{"avf", " ", "or", " ", 
       RowBox[{"{", "avfs", "}"}]}], "]"}]}], " ", "-", " ", 
    RowBox[{
    "returns", " ", "exterior", " ", "derivatives", " ", "of", " ", 
     "arguments"}]}], "\n", 
   RowBox[{
    RowBox[{"12.", " ", 
     RowBox[{"da", "[", 
      RowBox[{"avf", " ", "or", " ", 
       RowBox[{"{", "avfs", "}"}]}], "]"}]}], "-", " ", 
    RowBox[{"shortcut", " ", 
     RowBox[{"for", ":", "   ", 
      RowBox[{"applydrules", "[", 
       RowBox[{"d", "[", "arguments", "]"}], "]"}]}]}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"13.", " ", 
      RowBox[{"\[Delta]", "[", 
       RowBox[{"avf", " ", "or", " ", 
        RowBox[{"{", "avfs", "}"}]}], "]"}]}], " ", "-", 
     RowBox[{
     "coderivative", " ", "for", " ", "arguments", " ", "expressed", " ", 
      "in", " ", "\"\<frame\>\""}]}], "=", 
    RowBox[{"hs", "[", 
     RowBox[{"da", "[", 
      RowBox[{"hs", "[", "arg", "]"}], "]"}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"14.", " ", 
     RowBox[{
      SubscriptBox["D", "sub"], "[", 
      RowBox[{"avf", " ", "or", " ", 
       RowBox[{"{", "avfs", "}"}]}], "]"}]}], " ", "-", " ", 
    RowBox[{
    "coordinate", " ", "derivative", " ", "defined", " ", "by", " ", 
     "\"\<makecoords[]\>\"", " ", "command"}]}], "\n", 
   RowBox[{
    RowBox[{"15.", " ", 
     RowBox[{"dot", "[", 
      RowBox[{
       RowBox[{"p", "-", "form1"}], ",", 
       RowBox[{"p", "-", "form2"}]}], "]"}]}], " ", "-", " ", 
    RowBox[{
    "scalar", " ", "product", " ", "of", " ", "arguments", " ", "expressed", 
     " ", "in", " ", "\"\<frame\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"16.", " ", 
     RowBox[{"expand", "[", 
      RowBox[{"avf", " ", "or", " ", 
       RowBox[{"{", "avfs", "}"}]}], "]"}]}], " ", "-", " ", 
    RowBox[{"substitutes", " ", "infix", "  ", "multiplication", " ", 
     RowBox[{
      RowBox[{"operator", " ", "**", " ", "for"}], " ", "\[Wedge]", " ", "\n",
       "17."}], " ", 
     RowBox[{"factor", "[", 
      RowBox[{"basisform", ",", "avf"}], "]"}]}], " ", "-", " ", 
    RowBox[{
    "returns", " ", "the", " ", "righthand", " ", "factor", " ", "of", " ", 
     "\"\<basisform\>\"", " ", "in", " ", "\"\<avf\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"18.", " ", 
     RowBox[{"generic", "[", "]"}]}], " ", "-", 
    RowBox[{
    "constructs", " ", "a", " ", "general", " ", "\"\<algebra\>\"", " ", 
     "for", " ", "\"\<elements\>\"", "using", " ", "\"\<skew\>\"", " ", "and",
      "  ", "\"\<symm\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"19.", " ", 
     RowBox[{"grade", "[", 
      RowBox[{"integer", ",", "CAV"}], "]"}]}], " ", "-", " ", 
    RowBox[{
    "returns", " ", "the", " ", "specified", " ", "grade", " ", "of", " ", 
     "a", " ", "CAV", " ", "form"}]}], "\n", 
   RowBox[{
    RowBox[{"20.", " ", 
     RowBox[{"grades", "[", "CAV", "]"}]}], " ", "-", " ", 
    RowBox[{
    "returns", " ", "a", " ", "list", " ", "of", " ", "all", " ", "grades", 
     " ", "of", " ", "a", " ", "CAV", " ", "form"}]}], "\n", 
   RowBox[{
    RowBox[{"21.", " ", 
     RowBox[{"hs", "[", 
      RowBox[{"avf", " ", "or", " ", 
       RowBox[{"{", "avfs", "}"}]}], "]"}]}], " ", "-", " ", 
    RowBox[{
    "returns", " ", "the", " ", "Hodge", " ", "dual", " ", "for", " ", 
     "arguments", " ", "expressed", " ", "in", " ", "\"\<frame\>\""}]}], " ", 
   "\n", 
   RowBox[{
    RowBox[{"22.", " ", 
     RowBox[{"in", "[", "avf", "]"}]}], " ", "-", " ", 
    RowBox[{
    "converts", " ", "\"\<avf\>\"", " ", "to", " ", "equivalent", " ", "List",
      " ", "expression", " ", "for", " ", "AVF", " ", "operations"}]}], "\n", 
   
   RowBox[{
    RowBox[{"23.", " ", 
     RowBox[{"involute", "[", "CAV", "]"}]}], " ", "-", " ", 
    RowBox[{
    "changes", " ", "sign", " ", "of", " ", "all", " ", "odd", " ", "grades", 
     " ", "in", " ", "CAV"}]}], "\n", 
   RowBox[{
    RowBox[{"24.", " ", 
     RowBox[{"lie", "[", 
      RowBox[{"vector", ",", 
       RowBox[{"avf", " ", "or", " ", 
        RowBox[{"{", "avfs", "}"}]}]}], "]"}]}], " ", "-", " ", 
    RowBox[{
    "returns", "  ", "Lie", " ", "derivatives", " ", "of", " ", 
     "\"\<avfs\>\"", "  ", "wrt", " ", "\"\<vector\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"25.", " ", 
     RowBox[{"liealgebra", "[", "]"}]}], " ", "-", " ", 
    RowBox[{
    "returns", " ", "the", " ", "Lie", " ", "brackets", " ", "of", " ", "the",
      " ", "dual", " ", "vectors", " ", "to", " ", "non"}], "-", " ", 
    RowBox[{"exact", " ", "forms"}]}], "\n", 
   RowBox[{
    RowBox[{"26.", " ", 
     RowBox[{"makealgebra", "[", "product_matrix", "]"}]}], "-", " ", 
    RowBox[{
    "establishes", " ", "the", " ", "multiplication", " ", "table", " ", 
     "for", " ", "\"\<elements\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"27.", " ", 
     RowBox[{"makeall", "[", "]"}]}], " ", "-", " ", 
    RowBox[{"in", " ", "CAV", " ", "does", 
     RowBox[{"(", 
      RowBox[{
      "makethetahat", ";", "makeomegahat", ";", "maketorsion", ";", 
       "makecurvature"}], ")"}]}]}], "\n", 
   RowBox[{
    RowBox[{"28.", " ", 
     RowBox[{"makeclifford", "[", 
      RowBox[{"signature", "-", "list"}], "]"}]}], " ", "-", " ", 
    RowBox[{
    "makes", " ", "Clifford", " ", "algebra", " ", "with", " ", "specified", 
     " ", "signature"}]}], "\n", 
   RowBox[{
    RowBox[{"29.", " ", 
     RowBox[{"makecoords", "[", "symbol_list", "]"}]}], " ", "-", " ", 
    RowBox[{
    "defines", " ", "a", " ", "set", " ", "of", " ", "independent", " ", 
     "scalars", " ", "and", " ", "\"\<partials\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"30.", " ", 
     RowBox[{"makecurvature", "[", "]"}]}], "-", " ", 
    RowBox[{"calculates", " ", "the", " ", "CAV", "  ", "2"}], "-", 
    RowBox[{"form", "  ", 
     OverscriptBox["\[CapitalOmega]", "^"], "  ", "from", " ", "the", " ", 
     "connection", "  ", "1"}], "-", 
    RowBox[{"form", "  ", 
     OverscriptBox["\[Omega]", "^"]}]}], "\n", 
   RowBox[{
    RowBox[{"31.", " ", 
     RowBox[{"makedrules", "[", "replacement_list", "]"}]}], "-", " ", 
    RowBox[{
    "establishes", " ", "\"\<drules\>\"", " ", "for", " ", "\"\<dforms\>\"", 
     " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"+", " ", "optional"}], " ", "Rules"}], ")"}]}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"32.", " ", 
      RowBox[{"makeeinstein", "[", "]"}]}], " ", "-", " ", 
     RowBox[{"makes", " ", "a", " ", "CAV", "  ", "3"}], "-", 
     RowBox[{"form", "  ", 
      OverscriptBox["G", "^"]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         OverscriptBox["\[Theta]", "^"], " ", "**", 
         OverscriptBox["\[CapitalOmega]", "^"]}], "+", 
        RowBox[{
         OverscriptBox["\[CapitalOmega]", "^"], "**", 
         OverscriptBox["\[Theta]", "^"]}]}], " ", ")"}], "/", "2"}], "  ", 
     RowBox[{"(", 
      RowBox[{"4", "dim", " ", "Einstein", " ", "tensor"}], ")"}]}]}], "\n", 
   RowBox[{
    RowBox[{"33.", " ", 
     RowBox[{"makeelements", "[", "symbol_list", "]"}]}], " ", "-", " ", 
    RowBox[{
    "establishes", " ", "the", " ", "list", " ", "of", " ", "generators", " ",
      "for", " ", "an", " ", "algebra"}]}], "\n", 
   RowBox[{
    RowBox[{"34.", " ", 
     RowBox[{"makeforms", "[", "symbol_list", "]"}]}], " ", "-", " ", 
    RowBox[{
    "establishes", " ", "the", " ", "list", " ", "of", " ", "fundamental", 
     " ", "non"}], "-", 
    RowBox[{"exact", " ", "1"}], "-", "forms"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"35.", " ", 
      RowBox[{"makeframe", "[", "symbol_list", "]"}]}], " ", "-", " ", 
     RowBox[{
     "defines", " ", "a", " ", "set", " ", "of", " ", "orthonormal", " ", 
      "basis", " ", "forms"}]}], " ", "=", " ", "\"\<frame\>\""}], " ", "\n", 
   
   RowBox[{
    RowBox[{"36.", " ", 
     RowBox[{"makematrices", "[", "]"}]}], " ", "-", " ", 
    RowBox[{
    "constructs", " ", "a", " ", "matrix", " ", "representation", " ", "of", 
     " ", "the", " ", "chosen", "  ", "Clifford", " ", "algebra"}]}], " ", 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"37.", " ", 
      RowBox[{"makeomegahat", "[", "]"}]}], " ", "-", " ", 
     RowBox[{
     "makes", " ", "the", " ", "generalized", " ", "CAV", " ", "connection", "  ",
       "1"}], "-", " ", "form"}], ",", " ", 
    OverscriptBox[
     OverscriptBox["\[Omega]", "^"], " "]}], "\n", 
   RowBox[{
    RowBox[{"38.", " ", 
     RowBox[{"makescalars", "[", "symbol_list", "]"}]}], " ", "-", " ", 
    RowBox[{
    "establishes", " ", "the", " ", "list", " ", "of", " ", "fundamental", 
     " ", "scalars", 
     RowBox[{"(", 
      RowBox[{"0", "-", "forms"}], ")"}]}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"39.", " ", 
      RowBox[{"makethetahat", "[", "]"}]}], " ", "-", " ", 
     RowBox[{
     "makes", " ", "the", " ", "generalized", " ", "CAV", " ", 
      "\"\<co-frame\>\"", " ", "1"}], "-", "form"}], ",", " ", 
    OverscriptBox["\[Theta]", "^"]}], "\n", 
   RowBox[{
    RowBox[{"40.", " ", 
     RowBox[{"maketorsion", "[", "]"}]}], " ", "-", "  ", 
    RowBox[{"calculates", " ", "the", " ", "CAV", "  ", "2"}], "-", 
    RowBox[{"form", "  ", 
     OverscriptBox["\[CapitalTheta]", "^"], "  ", "from", " ", "the", " ", 
     "CAV", "  ", "1"}], "-", 
    RowBox[{"forms", "  ", 
     OverscriptBox["\[Theta]", "^"], "  ", "and", "  ", 
     OverscriptBox["\[Omega]", "^"]}]}], "\n", 
   RowBox[{
    RowBox[{"41.", " ", 
     RowBox[{"makevectors", "[", "]"}]}], " ", "-", " ", 
    RowBox[{
    "makes", " ", "a", " ", "set", " ", "of", " ", "four", " ", "lists", " ", 
     
     RowBox[{"named", ":", 
      RowBox[{"(", 
       RowBox[{"vec1", ",", "vec2", ",", "vec3", ",", "vec4"}], ")"}]}]}]}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"42.", " ", 
       RowBox[{"matmult", "[", 
        RowBox[{"m1", ",", "m2"}], "]"}]}], " ", "-", "  ", 
      RowBox[{"multiplication", " ", "of", " ", "AVF", "  ", "matrices"}]}], 
     ";", 
     RowBox[{"infix", " ", "operator"}]}], ",", " ", 
    RowBox[{"m1", "\[CircleTimes]", " ", "m2"}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"43.", " ", 
      RowBox[{"mtx", "[", 
       RowBox[{"avf_", " ", "array"}], "]"}]}], " ", "-", " ", 
     RowBox[{
     "outputs", " ", "the", " ", "argument", " ", "in", " ", "MatrixForm"}]}],
     ";", 
    RowBox[{"\"\<algebra\>\"", " ", "is", " ", "default", " ", "argument"}]}],
    "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"44.", " ", 
      RowBox[{"mult", "[", 
       RowBox[{"avf1", ",", "avf2"}], "]"}]}], " ", "-", " ", 
     RowBox[{"returns", " ", "the", " ", "product"}]}], ",", " ", 
    RowBox[{"avf1", "**", "avf2"}], ",", " ", 
    RowBox[{
     RowBox[{"where", " ", "**", " ", "is"}], " ", "the", " ", "infix", " ", 
     "form"}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"45.", " ", 
       RowBox[{"out", "[", 
        RowBox[{"List_form", "_of", "_avf"}], "]"}]}], " ", "-", " ", 
      RowBox[{"left", " ", "inverse", " ", "of", " ", 
       RowBox[{"in", "[", "avf", "]"}]}]}], ";", 
     RowBox[{"i", ".", "e", "."}]}], ",", 
    RowBox[{"avf", "==", 
     RowBox[{"out", "[", 
      RowBox[{"in", "[", "avf", "]"}], "]"}]}]}], "\n", 
   RowBox[{
    RowBox[{"46.", " ", 
     RowBox[{"prune", "[", 
      RowBox[{"list", ",", "exp"}], "]"}]}], " ", "-", " ", 
    RowBox[{
    "keeps", " ", "only", " ", "those", " ", "members", " ", "of", " ", 
     "\"\<list\>\"", "that", "  ", "appear", " ", "in", " ", 
     "\"\<exp\>\""}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"47.", " ", 
       RowBox[{"pullback", "[", 
        RowBox[{"avf", " ", "or", " ", 
         RowBox[{"{", "avfs", "}"}]}], "]"}]}], " ", "-", " ", 
      RowBox[{"pulls", " ", "back", " ", 
       RowBox[{"{", "avfs", "}"}], " ", "into", " ", "subspace", 
       "\"\<sub\>\""}]}], ";"}], "=", 
    RowBox[{
     RowBox[{"{", "avfs", "}"}], "/.", "tosub"}]}], "\n", 
   RowBox[{
    RowBox[{"48.", " ", 
     RowBox[{"reset", "[", "]"}]}], "-", " ", 
    RowBox[{"set", " ", "\"\<timer\>\"", " ", "to", " ", "zero"}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"49.", " ", 
      RowBox[{"reverse", "[", "CAV", "]"}]}], " ", "-", " ", 
     RowBox[{
     "returns", " ", "the", " ", "\"\<reversion\>\"", " ", "of", " ", 
      "CAV"}]}], ";", " ", 
    RowBox[{
     RowBox[{"equiv", ".", "to"}], " ", "reversing", " ", "all", " ", 
     SubscriptBox["\[Gamma]", "i"], " ", "products"}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"50.", " ", 
       RowBox[{"setzero", "[", 
        RowBox[{"list_of", "_expressions"}], "]"}]}], " ", "-", " ", 
      RowBox[{
      "turns", " ", "the", "  ", "arg", " ", "list", " ", "into", " ", "a", 
       " ", "list", " ", "of", " ", "equations"}]}], ";"}], "==", "0"}], "\n", 
   RowBox[{
    RowBox[{"51.", " ", 
     RowBox[{"subspace", "[", 
      RowBox[{
       RowBox[{"list_of", "_basis", "_", "1"}], "-", "forms"}], "]"}]}], " ", 
    "-", " ", 
    RowBox[{
    "make", " ", "replacement", " ", "list", " ", "\"\<tosub\>\"", " ", "for",
      " ", "\"\<pullback\>\""}]}], "\n", 
   RowBox[{
    RowBox[{"52.", " ", 
     RowBox[{"timer", "[", "]"}]}], " ", "-", " ", 
    RowBox[{
    "returns", " ", "elapsed", " ", "time", " ", "from", " ", "most", " ", 
     "recent", " ", "\"\<reset\>\""}]}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"53.", " ", 
      RowBox[{"torsionidentity", "[", "]"}]}], " ", "-", "  ", 
     RowBox[{
     "general", " ", "identity", " ", "for", " ", "CAV", " ", "field"}]}], 
    ",", 
    RowBox[{
     OverscriptBox["\[CapitalTheta]", "^"], " ", ";", 
     RowBox[{"aka", " ", "Cartan", " ", "identity"}]}]}], "  ", "\n", 
   RowBox[{
    RowBox[{"54.", 
     RowBox[{"zerocurvature", "[", "]"}]}], " ", "-", " ", 
    RowBox[{
    "constructs", " ", "a", " ", "list", " ", "of", " ", "\"\<drules\>\"", 
     " ", "giving", " ", "vanishing", " ", "CAV", " ", "curvature", "  ", 
     OverscriptBox["\[CapitalOmega]", "^"]}]}], "\n", 
   RowBox[{
    RowBox[{"55.", 
     RowBox[{"zerotorsion", "[", "]"}]}], " ", "-", " ", 
    RowBox[{
    "constructs", " ", "a", " ", "list", " ", "of", " ", "\"\<drules\>\"", 
     " ", "giving", " ", "vanishing", " ", "CAV", " ", "torsion", "  ", 
     OverscriptBox[
      OverscriptBox["\[CapitalTheta]", "^"], " "]}]}]}]}]], "Text",
 PageBreakAbove->False,
 PageBreakWithin->False,
 PageBreakBelow->Automatic,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["I.g.3. Jose: Additional comments on the choice of names", \
"Subsubsection"],

Cell[TextData[{
 "We have kept the original choices by Hugo Wahlquist on the naming \
conventions, though they are not standard in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It is hence important to be aware of them:\n\n\t1. Commands of the \
package start with lowercase letters\n\t2. The many global variables of the \
package also have names starting with lowercase, instead of the standard \
capitalized names starting with $.\n\t3. The ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " package already uses some frequent 1-character symbols, namely ",
 StyleBox["d", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["\[Delta]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["\[Omega]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["\[CapitalOmega]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["\[Theta]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["\[CapitalTheta]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["\[CapitalGamma]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["L", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["V", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["R", "Input",
  FontWeight->"Plain"],
 ". Also some 2- or 3- characters symbols: ",
 StyleBox["da", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["hs", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["dot", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["in", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["out", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["lie", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["mtx", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["sig", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["sk", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["sy", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["v1", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["v2", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["v3", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["v4", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["d\[Omega]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["d\[Theta]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["d\[CapitalOmega]", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["d\[CapitalTheta]", "Input",
  FontWeight->"Plain"],
 ". Those symbols can be used for computations, but only as long as values \
are not assigned to them."
}], "Text"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["II. Basic computations", "Section",
 FontColor->RGBColor[0, 0, 1]],

Cell["\<\
Sections II.a,b,c are taken from the file AVF_Demo.nb. Section II.d is taken \
from the file LieDerivative_Demo.nb.\
\>", "Text"],

Cell[TextData[{
 "Load the ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " package:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`AVF`"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData["\<\"Package xAct`AVF`  version 1.0, {2011, 12, 18}\"\>"], \
"Print"],

Cell[BoxData["\<\"CopyRight (C) 2003-2012, Hugo D. Wahlquist, under the \
General Public License.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["II.a. First examples", "Subsection"],

Cell[CellGroupData[{

Cell["II.a.1. Introducing the fundamental lists of variables", "Subsubsection"],

Cell["1) Declare a list of symbols to be scalars:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell["The information is stored in global variables:", "Text"],

Cell[CellGroupData[{

Cell[BoxData["scalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["scdim"], "Input"],

Cell[BoxData["3"], "Output"]
}, Open  ]],

Cell["\<\
The differentials of those scalars are automatically created:\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["dscalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dx", ",", "dy", ",", "dz"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "These exact 1-forms are also included in ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ":"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dx", ",", "dy", ",", "dz"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "2) To add in some non-exact basis 1-forms with derivative symbols in ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 " we can use ",
 StyleBox["makeforms", "Input",
  FontWeight->"Plain"],
 ". The non-exact forms always appear before the exact forms:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeforms", "[", 
  RowBox[{"{", 
   RowBox[{"\[Xi]", ",", "\[Eta]", ",", "\[Zeta]"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Xi]", ",", "\[Eta]", ",", "\[Zeta]", ",", "dx", ",", "dy", ",", "dz"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The global variable ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 " contains respective exact 2-forms which can be given additional properties \
using ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ". The sub-section on ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " appears below."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData["dforms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d\[Xi]", ",", "d\[Eta]", ",", "d\[Zeta]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["drules"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"d\[Xi]", "\[Rule]", "0"}], ",", 
   RowBox[{"d\[Eta]", "\[Rule]", "0"}], ",", 
   RowBox[{"d\[Zeta]", "\[Rule]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "3) ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " initializes the ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " list and the ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " matrix as follows:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["elements"], "Input"],

Cell[BoxData[
 RowBox[{"{", "identity", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["algebra"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "identity", "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
so it is ready to accomplish ordinary differential form analysis without \
further input. Since that case is treated simply as a special (trivial) \
algebra, all the commands for it are identical to the more general case with \
a non-trivial algebra to be used here.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeelements", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["m", "0"], ",", 
    SubscriptBox["m", "1"], ",", 
    SubscriptBox["m", "2"], ",", 
    SubscriptBox["m", "3"]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["m", "0"], ",", 
   SubscriptBox["m", "1"], ",", 
   SubscriptBox["m", "2"], ",", 
   SubscriptBox["m", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["elements"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["m", "0"], ",", 
   SubscriptBox["m", "1"], ",", 
   SubscriptBox["m", "2"], ",", 
   SubscriptBox["m", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["eldim"], "Input"],

Cell[BoxData["4"], "Output"]
}, Open  ]],

Cell[TextData[{
 "The three lists ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " may be introduced in any order and be changed at any time by executing new \
",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " commands. Note that ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " needs to be told that something is a variable (not constant) by being \
included in ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " or ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ", but not what it depends on. In fact, the members of these fundamental \
lists are always treated as independent variables, and can neither be \
functions nor have assigned values. Interdependence among them may be imposed \
by using replacement rules, however. See below."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"]
}, Closed]],

Cell[CellGroupData[{

Cell["II.a.2. Establishing the Algebra Table", "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell["\<\
The next statement defines the multiplication table of a 2-dimensional \
Clifford algebra which is isomorphic to the algebra of real 2\[Times]2 \
orthogonal matrices. Flipping a few of the signs would turn it into the \
quaternion algebra H.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["M", "2"], "[", "R", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"elements", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["m", "1"], ",", 
      SubscriptBox["m", "0"], ",", 
      SubscriptBox["m", "3"], ",", 
      SubscriptBox["m", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["m", "2"], ",", 
      RowBox[{"-", 
       SubscriptBox["m", "3"]}], ",", 
      SubscriptBox["m", "0"], ",", 
      RowBox[{"-", 
       SubscriptBox["m", "1"]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["m", "3"], ",", 
      RowBox[{"-", 
       SubscriptBox["m", "2"]}], ",", 
      SubscriptBox["m", "1"], ",", 
      RowBox[{"-", 
       SubscriptBox["m", "0"]}]}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", "0"], ",", 
     SubscriptBox["m", "1"], ",", 
     SubscriptBox["m", "2"], ",", 
     SubscriptBox["m", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", "1"], ",", 
     SubscriptBox["m", "0"], ",", 
     SubscriptBox["m", "3"], ",", 
     SubscriptBox["m", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", "2"], ",", 
     RowBox[{"-", 
      SubscriptBox["m", "3"]}], ",", 
     SubscriptBox["m", "0"], ",", 
     RowBox[{"-", 
      SubscriptBox["m", "1"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", "3"], ",", 
     RowBox[{"-", 
      SubscriptBox["m", "2"]}], ",", 
     SubscriptBox["m", "1"], ",", 
     RowBox[{"-", 
      SubscriptBox["m", "0"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["makealgebra", "Input",
  FontWeight->"Plain"],
 " command sets the global variable ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " to its argument, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", "2"], TraditionalForm]]],
 "[R],"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[BoxData[
 RowBox[{"makealgebra", "[", 
  RowBox[{
   SubscriptBox["M", "2"], "[", "R", "]"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["algebra"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", "0"], ",", 
     SubscriptBox["m", "1"], ",", 
     SubscriptBox["m", "2"], ",", 
     SubscriptBox["m", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", "1"], ",", 
     SubscriptBox["m", "0"], ",", 
     SubscriptBox["m", "3"], ",", 
     SubscriptBox["m", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", "2"], ",", 
     RowBox[{"-", 
      SubscriptBox["m", "3"]}], ",", 
     SubscriptBox["m", "0"], ",", 
     RowBox[{"-", 
      SubscriptBox["m", "1"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", "3"], ",", 
     RowBox[{"-", 
      SubscriptBox["m", "2"]}], ",", 
     SubscriptBox["m", "1"], ",", 
     RowBox[{"-", 
      SubscriptBox["m", "0"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["and this outputs the active algebra table as a matrix.", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input",
 PageBreakAbove->False],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["m", "0"], 
      SubscriptBox["m", "1"], 
      SubscriptBox["m", "2"], 
      SubscriptBox["m", "3"]},
     {
      SubscriptBox["m", "1"], 
      SubscriptBox["m", "0"], 
      SubscriptBox["m", "3"], 
      SubscriptBox["m", "2"]},
     {
      SubscriptBox["m", "2"], 
      RowBox[{"-", 
       SubscriptBox["m", "3"]}], 
      SubscriptBox["m", "0"], 
      RowBox[{"-", 
       SubscriptBox["m", "1"]}]},
     {
      SubscriptBox["m", "3"], 
      RowBox[{"-", 
       SubscriptBox["m", "2"]}], 
      SubscriptBox["m", "1"], 
      RowBox[{"-", 
       SubscriptBox["m", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The command ",
 StyleBox["mtx[]", "Input",
  FontWeight->"Plain"],
 " is just an abbreviation for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 StyleBox["MatrixForm[]", "Input",
  FontWeight->"Plain"],
 " and will accept the same arguments. ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " is the default argument."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"]
}, Closed]],

Cell[CellGroupData[{

Cell["II.a.3. Matrix Representations", "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[TextData[{
 "Calculations in ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " are accomplished using the algebra table for products of elements. \
Sometimes it is useful to have a matrix representation of the elements, even \
though the program never requires it. For example, a matrix representation of \
the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", "2"], TraditionalForm]]],
 "[R] generators is given by :"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["mat", "0"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["mat", "1"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["mat", "2"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["mat", "3"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}]}], "Input"],

Cell[TextData[{
 "and their matrix products agree with the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", "2"], TraditionalForm]]],
 "[R] algebra table; e.g. ,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    SubscriptBox["mat", "1"], ")"}], ".", 
   SubscriptBox["mat", "2"]}], "==", 
  SubscriptBox["mat", "3"]}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Since the indices of ",
 StyleBox["mat", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["m", "Input",
  FontWeight->"Plain"],
 " agree,  any ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " expression or list can be converted to matrix form by the kernel \
replacement rule, ",
 StyleBox[" /. m -> mat ", "Input",
  FontWeight->"Plain"],
 "; i.e. ,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["elements"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["m", "0"], ",", 
   SubscriptBox["m", "1"], ",", 
   SubscriptBox["m", "2"], ",", 
   SubscriptBox["m", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"elements", "/.", 
  RowBox[{"m", "->", "mat"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Another example is shown below, and the use of matrices is also developed \
further down .\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"]
}, Closed]],

Cell[CellGroupData[{

Cell["II.a.4. Sample input expressions", "Subsubsection",
 PageBreakAbove->True],

Cell[TextData[{
 "Here are two sample AVF expressions. The first, ",
 StyleBox["avf1", "Input",
  FontWeight->"Plain"],
 ", is an AVF 1-form; the second, ",
 StyleBox["avf2", "Input",
  FontWeight->"Plain"],
 ", has a different kind of factor omitted from each term and is a \
differential form of inhomogeneous degree. The ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " lists are output for reference."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"avf1", "=", 
  RowBox[{
   RowBox[{"2", "\[Lambda]", " ", "y", " ", "\[Zeta]", " ", 
    SubscriptBox["m", "2"]}], " ", "+", 
   RowBox[{
    SubscriptBox["m", "3"], " ", 
    SuperscriptBox["x", "3"], " ", "dz"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"]}], "+", 
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"avf2", "=", 
  RowBox[{
   RowBox[{"z", " ", 
    SubscriptBox["m", "2"]}], "+", 
   RowBox[{"3", " ", "\[Eta]", " ", "y"}], "+", 
   RowBox[{
    SubscriptBox["m", "1"], " ", 
    RowBox[{"dx", "\[Wedge]", "\[Xi]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "y", " ", "\[Eta]"}], "+", 
  RowBox[{"z", " ", 
   SubscriptBox["m", "2"]}], "+", 
  RowBox[{
   SubscriptBox["m", "1"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"scalars", "\n", "forms"}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Xi]", ",", "\[Eta]", ",", "\[Zeta]", ",", "dx", ",", "dy", ",", "dz"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The missing algebra element in the second input term of ",
 StyleBox["avf2", "Input",
  FontWeight->"Plain"],
 " defaults to the identity, ",
 Cell[BoxData[
  SubscriptBox["m", "0"]]],
 ". It never needs to be typed in input, and is generally suppressed in \
output. Note that, except inside a wedge product, the order of factors within \
a term is immaterial."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.b. Algebraic operations", "Subsection"],

Cell[CellGroupData[{

Cell["II.b.1. Multiplication", "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[TextData[{
 "The multiplication operator ",
 StyleBox["**", "Input",
  FontWeight->"Plain"],
 " simultaneously implements the Grassmann algebra of differential forms and \
the specified element algebra. Operator ",
 StyleBox["**", "Input",
  FontWeight->"Plain"],
 " has high precedence; its multiplicands will need parentheses if they're \
not single names, and also in multiple products if the algebra is \
non-associative."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[TextData[{
 "A first example using ordinary differential forms, where ",
 Cell[BoxData[
  SubscriptBox["m", "0"]]],
 " is the implicit algebra element:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", " ", "dy"}], "-", 
    RowBox[{"y", " ", "dx"}]}], ")"}], "**", 
  RowBox[{"(", 
   RowBox[{"\[Xi]", "-", "\[Eta]"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", " ", 
   RowBox[{"dx", "\[Wedge]", "\[Eta]"}]}], "-", 
  RowBox[{"y", " ", 
   RowBox[{"dx", "\[Wedge]", "\[Xi]"}]}], "-", 
  RowBox[{"x", " ", 
   RowBox[{"dy", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"dy", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Though ",
 StyleBox["avf1", "Input",
  FontWeight->"Plain"],
 " is a 1-form, its algebra-valued self product is non-zero:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"avf1", "**", "avf1"}]], "Input"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox["x", "3"], " ", "y", " ", "\[Lambda]", " ", 
  SubscriptBox["m", "1"], " ", 
  RowBox[{"dz", "\[Wedge]", "\[Zeta]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"avf3", "=", 
  RowBox[{"avf1", "**", "avf2"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]"}], "+", 
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", "z", " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
For this matrix algebra, AVF multiplication is associative, but generally \
non-commutative.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"avf1", "**", "avf3", "**", "avf2"}], "==", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"avf1", "**", "avf1"}], ")"}], "**", 
   RowBox[{"(", 
    RowBox[{"avf2", "**", "avf2"}], ")"}]}]}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"avf1", "**", "avf2"}], "===", 
  RowBox[{"avf2", "**", "avf1"}]}]], "Input"],

Cell[BoxData["False"], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.b.2. Formatting commands", "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell["\<\
The non-zero coefficients of the algebra elements in an AVF expression are \
given as a list of differential forms by:\
\>", "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "[", "avf3", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]"}], ",", 
   RowBox[{"dz", " ", 
    SuperscriptBox["x", "3"], " ", "z"}], ",", 
   RowBox[{
    RowBox[{"6", " ", 
     SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
     RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "+", 
    RowBox[{
     SuperscriptBox["x", "3"], " ", 
     RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", 
     SuperscriptBox["x", "3"], " ", "y", " ", 
     RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "+", 
    RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
     RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["and the expression is displayed in collected form by:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", "avf3", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "0"]}], "+", 
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", "z", " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{
   SubscriptBox["m", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"6", " ", 
      SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
      RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "+", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["m", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["x", "3"], " ", "y", " ", 
      RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "+", 
     RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
      RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}], 
    ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "This is the only ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " command that always outputs the identity element ",
 Cell[BoxData[
  SubscriptBox["m", "0"]]],
 " explicitly. It is required in the next statement to give the correct \
matrix representation of ",
 StyleBox["avf3", "Input",
  FontWeight->"Plain"],
 ":"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matavf3", "=", 
  RowBox[{
   RowBox[{"collect", "[", "avf3", "]"}], "/.", 
   RowBox[{"m", "->", "mat"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"dz", " ", 
       SuperscriptBox["x", "3"], " ", "z"}], "+", 
      RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]"}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["x", "3"], " ", "y", " ", 
       RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
       RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "-", 
      RowBox[{
       SuperscriptBox["x", "3"], " ", 
       RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}], "-", 
      RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "3"], " ", "y", " ", 
       RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
       RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "-", 
      RowBox[{
       SuperscriptBox["x", "3"], " ", 
       RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}], "+", 
      RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "dz"}], " ", 
       SuperscriptBox["x", "3"], " ", "z"}], "+", 
      RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]"}]}]}],
     "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "matavf3", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"dz", " ", 
        SuperscriptBox["x", "3"], " ", "z"}], "+", 
       RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]"}]}], 
      
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["x", "3"], " ", "y", " ", 
        RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "-", 
       RowBox[{"6", " ", 
        SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
        RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "-", 
       RowBox[{
        SuperscriptBox["x", "3"], " ", 
        RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}], "-", 
       RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
        RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}]},
     {
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "3"], " ", "y", " ", 
        RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "-", 
       RowBox[{"6", " ", 
        SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
        RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "-", 
       RowBox[{
        SuperscriptBox["x", "3"], " ", 
        RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}], "+", 
       RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
        RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "dz"}], " ", 
        SuperscriptBox["x", "3"], " ", "z"}], "+", 
       RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["collect[]", "Input",
  FontWeight->"Plain"],
 " command can be applied to arrays of AVFs, but ",
 StyleBox["coeffs[]", "Input",
  FontWeight->"Plain"],
 " must be Mapped onto them,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{"{", 
   RowBox[{"avf1", ",", "avf2"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
     SubscriptBox["m", "2"]}], "+", 
    RowBox[{"dz", " ", 
     SuperscriptBox["x", "3"], " ", 
     SubscriptBox["m", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "y", " ", "\[Eta]", " ", 
     SubscriptBox["m", "0"]}], "+", 
    RowBox[{"z", " ", 
     SubscriptBox["m", "2"]}], "+", 
    RowBox[{
     SubscriptBox["m", "1"], " ", 
     RowBox[{"dx", "\[Wedge]", "\[Xi]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"coeffs", ",", 
   RowBox[{"{", 
    RowBox[{"avf1", ",", "avf2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]"}], ",", 
     RowBox[{"dz", " ", 
      SuperscriptBox["x", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", " ", "y", " ", "\[Eta]"}], ",", 
     RowBox[{"dx", "\[Wedge]", "\[Xi]"}], ",", "z"}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.b.3. Vector contraction", "Subsubsection",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[TextData[{
 "The infix contraction operator is the small open circle, typed by the \
sequence esc-sc-esc. It is used to contract a vector either on a single AVF, \
or on a list of them. Whenever new 1-forms are defined, the ",
 StyleBox["makeforms", "Input",
  FontWeight->"Plain"],
 " command automatically generates four independent vectors {",
 StyleBox["vec1", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["vec2", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["vec3", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["vec4", "Input",
  FontWeight->"Plain"],
 "} just for convenience. Each vector is a symbol list of the same length as \
the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list. The first two vectors:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["vec1"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["v1", "1"], ",", 
   SubscriptBox["v1", "2"], ",", 
   SubscriptBox["v1", "3"], ",", 
   SubscriptBox["v1", "4"], ",", 
   SubscriptBox["v1", "5"], ",", 
   SubscriptBox["v1", "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["vec2"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["v2", "1"], ",", 
   SubscriptBox["v2", "2"], ",", 
   SubscriptBox["v2", "3"], ",", 
   SubscriptBox["v2", "4"], ",", 
   SubscriptBox["v2", "5"], ",", 
   SubscriptBox["v2", "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Since they are expressed in the dual basis to ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ", each component of a vector is its contraction on the corresponding member \
of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 "; i.e. ,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Xi]", ",", "\[Eta]", ",", "\[Zeta]", ",", "dx", ",", "dy", ",", "dz"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec1", "\[SmallCircle]", 
  RowBox[{"(", 
   RowBox[{"\[Eta]", "+", "dz"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["v1", "2"], "+", 
  SubscriptBox["v1", "6"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["avf2"], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "y", " ", "\[Eta]"}], "+", 
  RowBox[{"z", " ", 
   SubscriptBox["m", "2"]}], "+", 
  RowBox[{
   SubscriptBox["m", "1"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec1", "\[SmallCircle]", "avf2"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "dx"}], " ", 
   SubscriptBox["m", "1"], " ", 
   SubscriptBox["v1", "1"]}], "+", 
  RowBox[{"3", " ", "y", " ", 
   SubscriptBox["v1", "2"]}], "+", 
  RowBox[{"\[Xi]", " ", 
   SubscriptBox["m", "1"], " ", 
   SubscriptBox["v1", "4"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec1", "\[SmallCircle]", "%"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["A number of sequential contractions,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec2", "\[SmallCircle]", "vec1", "\[SmallCircle]", 
  "avf3"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "dx", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   SubscriptBox["v1", "3"], " ", 
   SubscriptBox["v2", "1"]}], "-", 
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   SubscriptBox["v1", "4"], " ", 
   SubscriptBox["v2", "1"]}], "-", 
  RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   SubscriptBox["v1", "4"], " ", 
   SubscriptBox["v2", "1"]}], "+", 
  RowBox[{"dx", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   SubscriptBox["v1", "6"], " ", 
   SubscriptBox["v2", "1"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   SubscriptBox["v1", "3"], " ", 
   SubscriptBox["v2", "2"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   SubscriptBox["v1", "6"], " ", 
   SubscriptBox["v2", "2"]}], "-", 
  RowBox[{"2", " ", "dx", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   SubscriptBox["v1", "1"], " ", 
   SubscriptBox["v2", "3"]}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   SubscriptBox["v1", "2"], " ", 
   SubscriptBox["v2", "3"]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", "\[Xi]", " ", 
   SubscriptBox["m", "3"], " ", 
   SubscriptBox["v1", "4"], " ", 
   SubscriptBox["v2", "3"]}], "+", 
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   SubscriptBox["v1", "1"], " ", 
   SubscriptBox["v2", "4"]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   SubscriptBox["v1", "1"], " ", 
   SubscriptBox["v2", "4"]}], "-", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", "\[Xi]", " ", 
   SubscriptBox["m", "3"], " ", 
   SubscriptBox["v1", "3"], " ", 
   SubscriptBox["v2", "4"]}], "-", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", "\[Xi]", " ", 
   SubscriptBox["m", "2"], " ", 
   SubscriptBox["v1", "6"], " ", 
   SubscriptBox["v2", "4"]}], "-", 
  RowBox[{"dx", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   SubscriptBox["v1", "1"], " ", 
   SubscriptBox["v2", "6"]}], "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   SubscriptBox["v1", "2"], " ", 
   SubscriptBox["v2", "6"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", "\[Xi]", " ", 
   SubscriptBox["m", "2"], " ", 
   SubscriptBox["v1", "4"], " ", 
   SubscriptBox["v2", "6"]}]}]], "Output"]
}, Open  ]],

Cell["and contraction on a list,", "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->Automatic,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec2", "\[SmallCircle]", "vec3", "\[SmallCircle]", 
  RowBox[{"{", 
   RowBox[{"avf1", ",", "avf2", ",", "avf3"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["m", "1"]}], " ", 
     SubscriptBox["v2", "4"], " ", 
     SubscriptBox["v3", "1"]}], "+", 
    RowBox[{
     SubscriptBox["m", "1"], " ", 
     SubscriptBox["v2", "1"], " ", 
     SubscriptBox["v3", "4"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "dx", " ", "y", " ", "\[Lambda]", " ", 
     SubscriptBox["m", "3"], " ", 
     SubscriptBox["v2", "3"], " ", 
     SubscriptBox["v3", "1"]}], "+", 
    RowBox[{"dz", " ", 
     SuperscriptBox["x", "3"], " ", 
     SubscriptBox["m", "2"], " ", 
     SubscriptBox["v2", "4"], " ", 
     SubscriptBox["v3", "1"]}], "+", 
    RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
     SubscriptBox["m", "3"], " ", 
     SubscriptBox["v2", "4"], " ", 
     SubscriptBox["v3", "1"]}], "-", 
    RowBox[{"dx", " ", 
     SuperscriptBox["x", "3"], " ", 
     SubscriptBox["m", "2"], " ", 
     SubscriptBox["v2", "6"], " ", 
     SubscriptBox["v3", "1"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
     SubscriptBox["m", "2"], " ", 
     SubscriptBox["v2", "3"], " ", 
     SubscriptBox["v3", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "3"], " ", "y", " ", 
     SubscriptBox["m", "3"], " ", 
     SubscriptBox["v2", "6"], " ", 
     SubscriptBox["v3", "2"]}], "+", 
    RowBox[{"2", " ", "dx", " ", "y", " ", "\[Lambda]", " ", 
     SubscriptBox["m", "3"], " ", 
     SubscriptBox["v2", "1"], " ", 
     SubscriptBox["v3", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
     SubscriptBox["m", "2"], " ", 
     SubscriptBox["v2", "2"], " ", 
     SubscriptBox["v3", "3"]}], "-", 
    RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", "\[Xi]", " ", 
     SubscriptBox["m", "3"], " ", 
     SubscriptBox["v2", "4"], " ", 
     SubscriptBox["v3", "3"]}], "-", 
    RowBox[{"dz", " ", 
     SuperscriptBox["x", "3"], " ", 
     SubscriptBox["m", "2"], " ", 
     SubscriptBox["v2", "1"], " ", 
     SubscriptBox["v3", "4"]}], "-", 
    RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
     SubscriptBox["m", "3"], " ", 
     SubscriptBox["v2", "1"], " ", 
     SubscriptBox["v3", "4"]}], "+", 
    RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", "\[Xi]", " ", 
     SubscriptBox["m", "3"], " ", 
     SubscriptBox["v2", "3"], " ", 
     SubscriptBox["v3", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["x", "3"], " ", "\[Xi]", " ", 
     SubscriptBox["m", "2"], " ", 
     SubscriptBox["v2", "6"], " ", 
     SubscriptBox["v3", "4"]}], "+", 
    RowBox[{"dx", " ", 
     SuperscriptBox["x", "3"], " ", 
     SubscriptBox["m", "2"], " ", 
     SubscriptBox["v2", "1"], " ", 
     SubscriptBox["v3", "6"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "3"], " ", "y", " ", 
     SubscriptBox["m", "3"], " ", 
     SubscriptBox["v2", "2"], " ", 
     SubscriptBox["v3", "6"]}], "-", 
    RowBox[{
     SuperscriptBox["x", "3"], " ", "\[Xi]", " ", 
     SubscriptBox["m", "2"], " ", 
     SubscriptBox["v2", "4"], " ", 
     SubscriptBox["v3", "6"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    SubscriptBox["m", "1"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["v2", "4"]}], " ", 
       SubscriptBox["v3", "1"]}], "+", 
      RowBox[{
       SubscriptBox["v2", "1"], " ", 
       SubscriptBox["v3", "4"]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{
     SubscriptBox["m", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "dx", " ", "y", " ", "\[Lambda]", " ", 
        SubscriptBox["v2", "3"], " ", 
        SubscriptBox["v3", "1"]}], "+", 
       RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
        SubscriptBox["v2", "4"], " ", 
        SubscriptBox["v3", "1"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "3"], " ", "y", " ", 
        SubscriptBox["v2", "6"], " ", 
        SubscriptBox["v3", "2"]}], "+", 
       RowBox[{"2", " ", "dx", " ", "y", " ", "\[Lambda]", " ", 
        SubscriptBox["v2", "1"], " ", 
        SubscriptBox["v3", "3"]}], "-", 
       RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", "\[Xi]", " ", 
        SubscriptBox["v2", "4"], " ", 
        SubscriptBox["v3", "3"]}], "-", 
       RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
        SubscriptBox["v2", "1"], " ", 
        SubscriptBox["v3", "4"]}], "+", 
       RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", "\[Xi]", " ", 
        SubscriptBox["v2", "3"], " ", 
        SubscriptBox["v3", "4"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "3"], " ", "y", " ", 
        SubscriptBox["v2", "2"], " ", 
        SubscriptBox["v3", "6"]}]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["m", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"dz", " ", 
        SuperscriptBox["x", "3"], " ", 
        SubscriptBox["v2", "4"], " ", 
        SubscriptBox["v3", "1"]}], "-", 
       RowBox[{"dx", " ", 
        SuperscriptBox["x", "3"], " ", 
        SubscriptBox["v2", "6"], " ", 
        SubscriptBox["v3", "1"]}], "-", 
       RowBox[{"6", " ", 
        SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
        SubscriptBox["v2", "3"], " ", 
        SubscriptBox["v3", "2"]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
        SubscriptBox["v2", "2"], " ", 
        SubscriptBox["v3", "3"]}], "-", 
       RowBox[{"dz", " ", 
        SuperscriptBox["x", "3"], " ", 
        SubscriptBox["v2", "1"], " ", 
        SubscriptBox["v3", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["x", "3"], " ", "\[Xi]", " ", 
        SubscriptBox["v2", "6"], " ", 
        SubscriptBox["v3", "4"]}], "+", 
       RowBox[{"dx", " ", 
        SuperscriptBox["x", "3"], " ", 
        SubscriptBox["v2", "1"], " ", 
        SubscriptBox["v3", "6"]}], "-", 
       RowBox[{
        SuperscriptBox["x", "3"], " ", "\[Xi]", " ", 
        SubscriptBox["v2", "4"], " ", 
        SubscriptBox["v3", "6"]}]}], ")"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec3", "\[SmallCircle]", "%"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "It is not necessary to use these convenience vectors. Any list of scalar \
variables, including specified or unspecified functions of the elements of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " may be used, so long as the list agrees in length with the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list. Any such list will be interpreted as a vector expressed in the dual \
basis to ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ". Components not in ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " (or functions thereof) will be constant parameters, as are the \
convenience-vector components."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell["\<\
A quick way to get a new vector of the correct length is by using a \
replacement,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pvec", "=", 
  RowBox[{"vec1", "/.", 
   RowBox[{"v1", "->", "p"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["p", "1"], ",", 
   SubscriptBox["p", "2"], ",", 
   SubscriptBox["p", "3"], ",", 
   SubscriptBox["p", "4"], ",", 
   SubscriptBox["p", "5"], ",", 
   SubscriptBox["p", "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "or by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pvec", "=", 
  RowBox[{"Array", "[", 
   RowBox[{"p", ",", "fmdim"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "1", "]"}], ",", 
   RowBox[{"p", "[", "2", "]"}], ",", 
   RowBox[{"p", "[", "3", "]"}], ",", 
   RowBox[{"p", "[", "4", "]"}], ",", 
   RowBox[{"p", "[", "5", "]"}], ",", 
   RowBox[{"p", "[", "6", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "where the global variable ",
 StyleBox["fmdim = Length[forms]", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"]
}, Closed]],

Cell[CellGroupData[{

Cell["II.b.4. Factoring an AVF", "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData["avf3"], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]"}], "+", 
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", "z", " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Any basis form in ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " or ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 " will be factored out (to the left) of an AVF by:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fac", "=", 
  RowBox[{"factor", "[", 
   RowBox[{"\[Zeta]", ",", "avf3"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y", " ", "z", " ", "\[Lambda]"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Eta]", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"]}], "-", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "All terms containing \[Zeta] are factored, so the following expression \
represents the part of ",
 StyleBox["avf3", "Input",
  FontWeight->"Plain"],
 " that is actually independent of ",
 Cell[BoxData[
  FormBox["\[Zeta]", TraditionalForm]]],
 ":"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"avf3", "-", 
  RowBox[{"\[Zeta]", "\[Wedge]", "fac"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]"}], "+", 
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", "z", " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "-", 
  RowBox[{"\[Zeta]", "\[Wedge]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "y", " ", "z", " ", "\[Lambda]"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["y", "2"], " ", "\[Eta]", " ", "\[Lambda]", " ", 
      SubscriptBox["m", "2"]}], "-", 
     RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
      SubscriptBox["m", "3"], " ", 
      RowBox[{"dx", "\[Wedge]", "\[Xi]"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "This will simplify using the ",
 StyleBox["expand", "Input",
  FontWeight->"Plain"],
 " operator (lower case \"e\"), which is similar to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s upper case ",
 StyleBox["Expand", "Input",
  FontWeight->"Plain"],
 ", except that it operates on wedge products ."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expand", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", "z", " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Jose:",
  FontColor->GrayLevel[0]],
 " The function ",
 StyleBox["factor", "Input",
  FontWeight->"Plain"],
 " actually does the equivalent of ",
 StyleBox["Coefficient", "Input",
  FontWeight->"Plain"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", not the equivalent of ",
 StyleBox["Factor", "Input",
  FontWeight->"Plain"],
 "."
}], "Text"],

Cell["\<\
An iterative subroutine to factor out any monomial product of basis forms \
from an AVF would be:\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"monomialfactor", "[", 
    RowBox[{"mono_", ",", "avf_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "fac", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"fac", "=", "avf"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Head", "[", "mono", "]"}], "=!=", "Wedge"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"fac", "=", 
         RowBox[{"factor", "[", 
          RowBox[{"mono", ",", "fac"}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"fac", "=", 
           RowBox[{"factor", "[", 
            RowBox[{
             RowBox[{"mono", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "fac"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "mono", "]"}]}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "fac"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input"],

Cell["For example,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"monomialfactor", "[", 
  RowBox[{
   RowBox[{"\[Xi]", "\[Wedge]", "dx"}], ",", "avf3"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "II.b.5. The ",
 StyleBox["expand", "Input",
  FontWeight->"Plain"],
 " function"
}], "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[TextData[{
 "The ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " function ",
 StyleBox["expand[expr]", "Input",
  FontWeight->"Plain"],
 " replaces all wedge products in ",
 StyleBox["expr", "Input",
  FontWeight->"Plain"],
 " with the actual multiplication operator ",
 StyleBox["**", "Input",
  FontWeight->"Plain"],
 ", and so re-calculates the entire expression. Any expression containing \
wedge products of AVF expressions can be expanded in this way. For instance,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"avf1", "\[Wedge]", "avf2"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
     SubscriptBox["m", "2"]}], "+", 
    RowBox[{"dz", " ", 
     SuperscriptBox["x", "3"], " ", 
     SubscriptBox["m", "3"]}]}], ")"}], "\[Wedge]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", "y", " ", "\[Eta]"}], "+", 
    RowBox[{"z", " ", 
     SubscriptBox["m", "2"]}], "+", 
    RowBox[{
     SubscriptBox["m", "1"], " ", 
     RowBox[{"dx", "\[Wedge]", "\[Xi]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Only the substitutions occurred because wedge is not recognized as an \
operator, and with the factors being algebra-valued-forms, it is a slight \
abuse of notation. Nevertheless, this re-derives ",
 StyleBox["avf3", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expand", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y", " ", "z", " ", "\[Zeta]", " ", "\[Lambda]"}], "+", 
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", "z", " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Note that an expression containing wedge products of factors which are not \
simple basis forms, such as ",
 StyleBox["avf1\[Wedge]avf2", "Input",
  FontWeight->"Plain"],
 ", is not an acceptable input for any ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " operations other than ",
 StyleBox["expand", "Input",
  FontWeight->"Plain"],
 ". The operator ",
 StyleBox["expand", "Input",
  FontWeight->"Plain"],
 " must be used to convert such expressions to correct input form for other \
",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " functions."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[TextData[{
 "Since every wedge product at all levels in the expressions will be \
calculated anew, using ",
 StyleBox["expand", "Input",
  FontWeight->"Plain"],
 " allows arbitrary replacements to be made within wedge products, and this \
is its primary function. For example, the \[Zeta]-independent part of ",
 StyleBox["avf3", "Input",
  FontWeight->"Plain"],
 " could also be obtained by"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"avf3", "/.", 
  RowBox[{"\[Zeta]", "->", "0"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", "z", " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"0", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "0", "\[Wedge]", "\[Xi]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expand", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", "z", " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Clearly, any wedge product in an input expression (even between basis \
forms) could just as well be typed using ",
 StyleBox["**", "Input",
  FontWeight->"Plain"],
 ". This has little real effect when used between basis forms (except perhaps \
to simplify and re-order a product into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s canonical order), but it constitutes a much larger abuse of standard \
nomenclature."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Xi]", "\[Wedge]", "dz"}], "+", 
  RowBox[{"\[Eta]", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Eta]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Xi]", "\[Wedge]", "dz"}], "+", 
  RowBox[{"\[Eta]", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Eta]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expand", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{"dz", "\[Wedge]", "\[Xi]"}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Xi]", "**", "dz"}], "+", 
  RowBox[{"\[Eta]", "**", "\[Zeta]", "**", "\[Eta]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{"dz", "\[Wedge]", "\[Xi]"}], ")"}]}]], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.c. Exterior calculus operations", "Subsection"],

Cell[CellGroupData[{

Cell["II.c.1. Exterior differentiation", "Subsubsection"],

Cell[TextData[{
 "The exterior derivative of an AVF is given by ",
 StyleBox["d[expr]", "Input",
  FontWeight->"Plain"],
 "; e.g. ,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["avf1"], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "y", " ", "\[Zeta]", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"]}], "+", 
  RowBox[{"dz", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "avf1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "d\[Zeta]", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"], " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}]}], "+", 
  RowBox[{"2", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dy", "\[Wedge]", "\[Zeta]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " are differentiated, but the algebra elements and parameter \[Lambda] are \
not. A more complicated example is:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "avf3", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "d\[Zeta]", " ", "y", " ", "z", " ", "\[Lambda]"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"], " ", "z", " ", 
   SubscriptBox["m", "1"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}]}], "+", 
  RowBox[{"2", " ", "z", " ", "\[Lambda]", " ", 
   RowBox[{"dy", "\[Wedge]", "\[Zeta]"}]}], "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", "d\[Eta]"}]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
   RowBox[{"dz", "\[Wedge]", "\[Zeta]"}]}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"\[Zeta]", "\[Wedge]", "d\[Eta]"}]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"\[Eta]", "\[Wedge]", "d\[Zeta]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "d\[Xi]"}]}], "+", 
  RowBox[{"9", " ", 
   SuperscriptBox["x", "2"], " ", "y", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "d\[Xi]"}]}], "-", 
  RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Xi]", "\[Wedge]", "d\[Zeta]"}]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"], " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dy", "\[Wedge]", "dz", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"12", " ", "y", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dy", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "-", 
  RowBox[{"2", " ", "\[Lambda]", " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{
   "dx", "\[Wedge]", "dy", "\[Wedge]", "\[Zeta]", "\[Wedge]", 
    "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The operator ",
 StyleBox["d[]", "Input",
  FontWeight->"Plain"],
 " also works on a list of AVF's,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"{", 
   RowBox[{"avf1", ",", "avf2"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "d\[Zeta]", " ", "y", " ", "\[Lambda]", " ", 
     SubscriptBox["m", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"], " ", 
     SubscriptBox["m", "3"], " ", 
     RowBox[{"dx", "\[Wedge]", "dz"}]}], "+", 
    RowBox[{"2", " ", "\[Lambda]", " ", 
     SubscriptBox["m", "2"], " ", 
     RowBox[{"dy", "\[Wedge]", "\[Zeta]"}]}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "d\[Eta]", " ", "y"}], "+", 
    RowBox[{"dz", " ", 
     SubscriptBox["m", "2"]}], "-", 
    RowBox[{
     SubscriptBox["m", "1"], " ", 
     RowBox[{"dx", "\[Wedge]", "d\[Xi]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"dy", "\[Wedge]", "\[Eta]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["as well as on a matrix of them,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "matavf3", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "d\[Zeta]", " ", "y", " ", "z", " ", "\[Lambda]"}], 
      "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"], " ", "z", " ", 
       RowBox[{"dx", "\[Wedge]", "dz"}]}], "+", 
      RowBox[{"2", " ", "z", " ", "\[Lambda]", " ", 
       RowBox[{"dy", "\[Wedge]", "\[Zeta]"}]}], "+", 
      RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dz", "\[Wedge]", "\[Zeta]"}]}]}], ",", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "3"], " ", "y", " ", 
       RowBox[{"dz", "\[Wedge]", "d\[Eta]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
       RowBox[{"\[Zeta]", "\[Wedge]", "d\[Eta]"}]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
       RowBox[{"\[Eta]", "\[Wedge]", "d\[Zeta]"}]}], "-", 
      RowBox[{
       SuperscriptBox["x", "3"], " ", 
       RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "d\[Xi]"}]}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["x", "2"], " ", "y", " ", 
       RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Eta]"}]}], "-", 
      RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "d\[Xi]"}]}], "+", 
      RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dx", "\[Wedge]", "\[Xi]", "\[Wedge]", "d\[Zeta]"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "3"], " ", 
       RowBox[{"dy", "\[Wedge]", "dz", "\[Wedge]", "\[Eta]"}]}], "-", 
      RowBox[{"12", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dy", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "+", 
      RowBox[{"2", " ", "\[Lambda]", " ", 
       RowBox[{
       "dx", "\[Wedge]", "dy", "\[Wedge]", "\[Zeta]", "\[Wedge]", 
        "\[Xi]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["x", "3"], " ", "y", " ", 
       RowBox[{"dz", "\[Wedge]", "d\[Eta]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
       RowBox[{"\[Zeta]", "\[Wedge]", "d\[Eta]"}]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["y", "2"], " ", "\[Lambda]", " ", 
       RowBox[{"\[Eta]", "\[Wedge]", "d\[Zeta]"}]}], "-", 
      RowBox[{
       SuperscriptBox["x", "3"], " ", 
       RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "d\[Xi]"}]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["x", "2"], " ", "y", " ", 
       RowBox[{"dx", "\[Wedge]", "dz", "\[Wedge]", "\[Eta]"}]}], "+", 
      RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "d\[Xi]"}]}], "-", 
      RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dx", "\[Wedge]", "\[Xi]", "\[Wedge]", "d\[Zeta]"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "3"], " ", 
       RowBox[{"dy", "\[Wedge]", "dz", "\[Wedge]", "\[Eta]"}]}], "-", 
      RowBox[{"12", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dy", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Eta]"}]}], "-", 
      RowBox[{"2", " ", "\[Lambda]", " ", 
       RowBox[{
       "dx", "\[Wedge]", "dy", "\[Wedge]", "\[Zeta]", "\[Wedge]", 
        "\[Xi]"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", "d\[Zeta]", " ", "y", " ", "z", " ", "\[Lambda]"}], 
      "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"], " ", "z", " ", 
       RowBox[{"dx", "\[Wedge]", "dz"}]}], "+", 
      RowBox[{"2", " ", "z", " ", "\[Lambda]", " ", 
       RowBox[{"dy", "\[Wedge]", "\[Zeta]"}]}], "+", 
      RowBox[{"2", " ", "y", " ", "\[Lambda]", " ", 
       RowBox[{"dz", "\[Wedge]", "\[Zeta]"}]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The non-commutativity coming from both the Grassmann and the element \
algebras generally forbids any simple application of the Leibnitz rule for \
derivations, unless the leading factors are of homogeneous degree as \
differential forms and the algebraic order of the factors is preserved. The \
following expansion works because ",
 StyleBox["avf1", "Input",
  FontWeight->"Plain"],
 " is a 1-form (note the minus sign)."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "[", 
   RowBox[{"avf1", "**", "avf2"}], "]"}], "==", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "[", "avf1", "]"}], "**", "avf2"}], "-", 
   RowBox[{"avf1", "**", 
    RowBox[{"d", "[", "avf2", "]"}]}]}]}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[TextData[{
 "For simplicity, the input samples, ",
 StyleBox["avf1", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["avf2", "Input",
  FontWeight->"Plain"],
 ", involved only algebraic functions of the scalars. Any functions known to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be used in an AVF, but any arguments not appearing in the ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " list will be treated as constant parameters;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"avf4", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"k", " ", "y"}], "]"}], "\[Xi]", " ", 
    SubscriptBox["m", "1"]}], "+", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"k", " ", "y"}], "]"}], "\[Eta]", " ", 
    SubscriptBox["m", "2"]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Xi]", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"k", " ", "y"}], "]"}], " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{"\[Eta]", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"k", " ", "y"}], "]"}], " ", 
   SubscriptBox["m", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "avf4", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d\[Xi]", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"k", " ", "y"}], "]"}], " ", 
   SubscriptBox["m", "1"]}], "+", 
  RowBox[{"d\[Eta]", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"k", " ", "y"}], "]"}], " ", 
   SubscriptBox["m", "2"]}], "+", 
  RowBox[{"k", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"k", " ", "y"}], "]"}], " ", 
   SubscriptBox["m", "2"], " ", 
   RowBox[{"dy", "\[Wedge]", "\[Eta]"}]}], "-", 
  RowBox[{"k", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"k", " ", "y"}], "]"}], " ", 
   SubscriptBox["m", "1"], " ", 
   RowBox[{"dy", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"avf4", "**", "avf4"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "k", " ", "y"}], "]"}]}], " ", 
  SubscriptBox["m", "3"], " ", 
  RowBox[{"\[Eta]", "\[Wedge]", "\[Xi]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "k", " ", "y"}], "]"}], " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"\[Eta]", "\[Wedge]", "d\[Xi]"}]}], "-", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "k", " ", "y"}], "]"}], " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"\[Xi]", "\[Wedge]", "d\[Eta]"}]}], "-", 
  RowBox[{"2", " ", "k", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "k", " ", "y"}], "]"}], " ", 
   SubscriptBox["m", "3"], " ", 
   RowBox[{"dy", "\[Wedge]", "\[Eta]", "\[Wedge]", "\[Xi]"}]}]}]], "Output"]
}, Open  ]],

Cell["and an unspecified function including a parameter gives,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", "z", ",", "k"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dz", " ", 
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "k"}], "]"}]}], "+", 
  RowBox[{"dy", " ", 
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "k"}], "]"}]}], "+", 
  RowBox[{"dx", " ", 
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z", ",", "k"}], "]"}]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "II.c.2. Defining ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"]
}], "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[TextData[{
 "An important feature of ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " involves the list of replacement rules for exterior derivatives called ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ". Their primary purpose is to establish properties for the derivatives of \
the non-exact basis forms (the members of ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 ") which can then be easily implemented in AVF expressions. They are not \
restricted to such replacements, however, and may include any other \
appropriate replacement rules.\n                             \nAdditional \
structure for the derivatives in ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 " is prescribed by defining a set of replacement rules which are given by \
expansions of the members of ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 " in terms of the members of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ". If all the non-exact 1-forms are closed, for example, the appropriate \
value for ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " is the global variable ",
 StyleBox["natural", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["natural"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"d\[Xi]", "\[Rule]", "0"}], ",", 
   RowBox[{"d\[Eta]", "\[Rule]", "0"}], ",", 
   RowBox[{"d\[Zeta]", "\[Rule]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and this is the default value of ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " established initially for all the non-exact members of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " introduced by the ",
 StyleBox["makeforms", "Input",
  FontWeight->"Plain"],
 " command; i.e., currently,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["drules"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"d\[Xi]", "\[Rule]", "0"}], ",", 
   RowBox[{"d\[Eta]", "\[Rule]", "0"}], ",", 
   RowBox[{"d\[Zeta]", "\[Rule]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["A different set of replacements can be defined; e.g.,", "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newdrules", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"d\[Xi]", "->", 
     RowBox[{"\[Eta]", "\[Wedge]", "\[Zeta]"}]}], ",", 
    RowBox[{"d\[Eta]", "->", 
     RowBox[{"\[Zeta]", "\[Wedge]", "\[Xi]"}]}], ",", 
    RowBox[{"d\[Zeta]", "->", 
     RowBox[{"\[Xi]", "\[Wedge]", "\[Eta]"}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"d\[Xi]", "\[Rule]", 
    RowBox[{"\[Eta]", "\[Wedge]", "\[Zeta]"}]}], ",", 
   RowBox[{"d\[Eta]", "\[Rule]", 
    RowBox[{"\[Zeta]", "\[Wedge]", "\[Xi]"}]}], ",", 
   RowBox[{"d\[Zeta]", "\[Rule]", 
    RowBox[{"\[Xi]", "\[Wedge]", "\[Eta]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and this becomes the reserved variable ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " using the ",
 StyleBox["makedrules", "Input",
  FontWeight->"Plain"],
 " command;"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->Automatic,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", "newdrules", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"d\[Xi]", "\[Rule]", 
    RowBox[{"\[Eta]", "\[Wedge]", "\[Zeta]"}]}], ",", 
   RowBox[{"d\[Eta]", "\[Rule]", 
    RowBox[{"\[Zeta]", "\[Wedge]", "\[Xi]"}]}], ",", 
   RowBox[{"d\[Zeta]", "\[Rule]", 
    RowBox[{"\[Xi]", "\[Wedge]", "\[Eta]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The current ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " can be implemented in any ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " expression with the command ",
 StyleBox["applydrules", "Input",
  FontWeight->"Plain"],
 ", which is defined by: ",
 StyleBox["applydrules[arg_]:=expand[arg/.drules]", "Input",
  FontWeight->"Plain"],
 "; e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "avf2", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "d\[Eta]", " ", "y"}], "+", 
  RowBox[{"dz", " ", 
   SubscriptBox["m", "2"]}], "-", 
  RowBox[{
   SubscriptBox["m", "1"], " ", 
   RowBox[{"dx", "\[Wedge]", "d\[Xi]"}]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"dy", "\[Wedge]", "\[Eta]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"applydrules", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dz", " ", 
   SubscriptBox["m", "2"]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"dy", "\[Wedge]", "\[Eta]"}]}], "+", 
  RowBox[{"3", " ", "y", " ", 
   RowBox[{"\[Zeta]", "\[Wedge]", "\[Xi]"}]}], "+", 
  RowBox[{
   SubscriptBox["m", "1"], " ", 
   RowBox[{"dx", "\[Wedge]", "\[Zeta]", "\[Wedge]", "\[Eta]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " can be changed at any time to a different set. As with other ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " commands, ",
 StyleBox["makedrules", "Input",
  FontWeight->"Plain"],
 " won't accumulate replacements, but different sets of rules may be combined \
using ",
 StyleBox["Join", "Input",
  FontWeight->"Plain"],
 " in the argument. The following command simply resets ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " to ",
 StyleBox["natural", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", 
  RowBox[{"{", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"d\[Xi]", "\[Rule]", "0"}], ",", 
   RowBox[{"d\[Eta]", "\[Rule]", "0"}], ",", 
   RowBox[{"d\[Zeta]", "\[Rule]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["so that now,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"applydrules", "[", 
  RowBox[{"d", "[", "avf2", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dz", " ", 
   SubscriptBox["m", "2"]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"dy", "\[Wedge]", "\[Eta]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Re-establish ",
 StyleBox["newdrules", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->Automatic,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", "newdrules", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"d\[Xi]", "\[Rule]", 
    RowBox[{"\[Eta]", "\[Wedge]", "\[Zeta]"}]}], ",", 
   RowBox[{"d\[Eta]", "\[Rule]", 
    RowBox[{"\[Zeta]", "\[Wedge]", "\[Xi]"}]}], ",", 
   RowBox[{"d\[Zeta]", "\[Rule]", 
    RowBox[{"\[Xi]", "\[Wedge]", "\[Eta]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The nested command just above, ",
 StyleBox["applydrules[d[arg]]", "Input",
  FontWeight->"Plain"],
 ", is actually used more often than ",
 StyleBox["d[arg]", "Input",
  FontWeight->"Plain"],
 " alone. An abbreviated differentiation operator ",
 StyleBox["da[arg]", "Input",
  FontWeight->"Plain"],
 " is defined for it; i.e.,"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->Automatic,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"\[Xi]", "+", "\[Eta]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"d\[Eta]", "+", "d\[Xi]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"applydrules", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}], ")"}]}], "+", 
  RowBox[{"\[Zeta]", "\[Wedge]", "\[Xi]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", 
  RowBox[{"\[Xi]", "+", "\[Eta]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}], ")"}]}], "+", 
  RowBox[{"\[Zeta]", "\[Wedge]", "\[Xi]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Note that in using ",
 StyleBox["da[]", "Input",
  FontWeight->"Plain"],
 ", differentiation occurs ",
 StyleBox["before",
  FontVariations->{"Underline"->True}],
 " the drules are applied, so they have no effect on the derivative of any \
exact form, which necessarily vanishes; e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["dforms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d\[Xi]", ",", "d\[Eta]", ",", "d\[Zeta]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "dforms", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", "dforms", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell["but,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Xi]", ",", "\[Eta]", ",", "\[Zeta]", ",", "dx", ",", "dy", ",", "dz"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "forms", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "d\[Xi]", ",", "d\[Eta]", ",", "d\[Zeta]", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", "forms", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}], ")"}]}], ",", 
   RowBox[{"\[Zeta]", "\[Wedge]", "\[Xi]"}], ",", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{"\[Eta]", "\[Wedge]", "\[Xi]"}], ")"}]}], ",", "0", ",", "0", 
   ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Generally, it is important to ensure consistency (closure) of the ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ", which is not verified automatically by the program; e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->Automatic,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", "\[Xi]", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{"\[Zeta]", "\[Wedge]", "\[Eta]"}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and differentiating without applying the ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " gives,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Zeta]", "\[Wedge]", "d\[Eta]"}], "-", 
  RowBox[{"\[Eta]", "\[Wedge]", "d\[Zeta]"}]}]], "Output"]
}, Open  ]],

Cell["but as required for consistency of the double derivative,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"applydrules", "[", "%", "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["Checking all of them", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"da", "[", 
   RowBox[{"da", "[", "\[Xi]", "]"}], "]"}], "==", 
  RowBox[{"da", "[", 
   RowBox[{"da", "[", "\[Eta]", "]"}], "]"}], "==", 
  RowBox[{"da", "[", 
   RowBox[{"da", "[", "\[Zeta]", "]"}], "]"}], "==", "0"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell["but again, this could be done in one step on the whole list;", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", 
  RowBox[{"da", "[", "forms", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "This ensures that both double derivatives will vanish identically for all \
",
 StyleBox["AVF",
  FontWeight->"Plain"],
 " expressions; e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"d", "[", "avf2", "]"}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", 
  RowBox[{"da", "[", "avf2", "]"}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Generally, the use of ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " is optional, but there is one situation in which they are mandatory, and \
is the reason for establishing a default value for them. The one place ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " are required is for vector contractions, which are defined on all members \
of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ", but not on their exterior derivative 2-forms. In the case of vector \
contraction, they are invoked automatically before doing the contraction; \
e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec1", "\[SmallCircle]", "dforms"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Zeta]", " ", 
     SubscriptBox["v1", "2"]}], "-", 
    RowBox[{"\[Eta]", " ", 
     SubscriptBox["v1", "3"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Zeta]"}], " ", 
     SubscriptBox["v1", "1"]}], "+", 
    RowBox[{"\[Xi]", " ", 
     SubscriptBox["v1", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"\[Eta]", " ", 
     SubscriptBox["v1", "1"]}], "-", 
    RowBox[{"\[Xi]", " ", 
     SubscriptBox["v1", "2"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 StyleBox["all",
  FontVariations->{"Underline"->True}],
 " the replacements that have been established as ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " are applied in a contraction, not just those involving ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[TextData[{
 "In summary, establishing a set of ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " is essential for most operations involving contractions, such as the Lie \
derivative of AVFs. In addition: they can be used to define anholonomic basis \
forms; to express derivatives of functions of coordinates in terms of an \
anholonomic basis; and to impose a group structure on the basis 1-forms using \
a set of Maurer-Cartan equations (as in ",
 StyleBox["newdrules", "Input",
  FontWeight->"Plain"],
 ")."
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["II.c.3. Transformations of coordinates", "Subsubsection"],

Cell[TextData[{
 "Call the current scalars ",
 StyleBox["cartesian", "Input",
  FontWeight->"Plain"],
 " and add in a new set, ",
 StyleBox["spherical", "Input",
  FontWeight->"Plain"]
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cartesian", "=", "scalars"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spherical", "=", 
  RowBox[{"{", 
   RowBox[{"r", ",", "\[Theta]", ",", "\[CurlyPhi]"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "\[Theta]", ",", "\[CurlyPhi]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"Join", "[", 
   RowBox[{"cartesian", ",", "spherical"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "y", ",", "z", ",", "r", ",", "\[Theta]", ",", "\[CurlyPhi]"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["dscalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "dx", ",", "dy", ",", "dz", ",", "dr", ",", "d\[Theta]", ",", 
   "d\[CurlyPhi]"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The transformation from cartesian to spherical coordinates is expressed by \
a list of replacement rules, ",
 StyleBox["not",
  FontVariations->{"Underline"->True}],
 " assignments. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 StyleBox["Thread", "Input",
  FontWeight->"Plain"],
 " command is convenient for distributing the ",
 StyleBox["Rule", "Input",
  FontWeight->"Plain"],
 " symbol,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"trans", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{"cartesian", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
      RowBox[{"r", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}], 
       RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", 
      RowBox[{"r", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"r", " ", 
     RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"r", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ",", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{"r", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and the transformation can be accomplished by ",
 StyleBox["ReplaceAll", "Input",
  FontWeight->"Plain"],
 " (",
 StyleBox["/.", "Input",
  FontWeight->"Plain"],
 ")."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cartesian", "/.", "trans"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"r", " ", 
    RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
   RowBox[{"r", " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", 
   RowBox[{"r", " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The operator ",
 StyleBox["d[]", "Input",
  FontWeight->"Plain"],
 " works on a list of AVFs --not on a list of Rules-- but the transformation \
of derivatives can be constructed quickly by;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dtrans", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"d", "[", "cartesian", "]"}], "->", 
    RowBox[{"d", "[", 
     RowBox[{"(", 
      RowBox[{"cartesian", "/.", "trans"}], ")"}], "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"dx", "\[Rule]", 
    RowBox[{
     RowBox[{"d\[Theta]", " ", "r", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], "+", 
     RowBox[{"dr", " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", 
     RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], ",", 
   RowBox[{"dy", "\[Rule]", 
    RowBox[{
     RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", 
     RowBox[{"d\[Theta]", " ", "r", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], "+", 
     RowBox[{"dr", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], ",", 
   RowBox[{"dz", "\[Rule]", 
    RowBox[{
     RowBox[{"dr", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
     RowBox[{"d\[Theta]", " ", "r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
and all of these can be joined into a single list of transformation rules;\
\>", "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->Automatic,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tospherical", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"trans", ",", "dtrans"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"r", " ", 
     RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"r", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ",", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{"r", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{"dx", "\[Rule]", 
    RowBox[{
     RowBox[{"d\[Theta]", " ", "r", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], "+", 
     RowBox[{"dr", " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", 
     RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], ",", 
   RowBox[{"dy", "\[Rule]", 
    RowBox[{
     RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", 
     RowBox[{"d\[Theta]", " ", "r", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], "+", 
     RowBox[{"dr", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], ",", 
   RowBox[{"dz", "\[Rule]", 
    RowBox[{
     RowBox[{"dr", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
     RowBox[{"d\[Theta]", " ", "r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "/.", "tospherical"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["r", "2"], " ", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]], "Output"]
}, Open  ]],

Cell["For the volume form,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vol", "=", 
  RowBox[{"dx", "\[Wedge]", "dy", "\[Wedge]", "dz"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"dx", "\[Wedge]", "dy", "\[Wedge]", "dz"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vol", "/.", "tospherical"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"d\[Theta]", " ", "r", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], "+", 
    RowBox[{"dr", " ", 
     RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", 
    RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}], "\[Wedge]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
     RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", 
    RowBox[{"d\[Theta]", " ", "r", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], "+", 
    RowBox[{"dr", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}], "\[Wedge]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"dr", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
    RowBox[{"d\[Theta]", " ", "r", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The substitutions were made, but the expression needs to be simplified. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 StyleBox["Expand", "Input",
  FontWeight->"Plain"],
 " has no effect on wedge products,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"d\[Theta]", " ", "r", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], "+", 
    RowBox[{"dr", " ", 
     RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", 
    RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}], "\[Wedge]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
     RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", 
    RowBox[{"d\[Theta]", " ", "r", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], "+", 
    RowBox[{"dr", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}], "\[Wedge]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"dr", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
    RowBox[{"d\[Theta]", " ", "r", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "but the analogous ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " command does the required expansion of the wedge products,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expand", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], "2"], " ", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
   RowBox[{"dr", "\[Wedge]", "d\[Theta]", "\[Wedge]", "d\[CurlyPhi]"}]}], "+", 
  RowBox[{
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "\[Theta]", "]"}], "3"], " ", 
   RowBox[{"dr", "\[Wedge]", "d\[Theta]", "\[Wedge]", "d\[CurlyPhi]"}]}], "+", 
  RowBox[{
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], " ", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], "2"], " ", 
   RowBox[{"dr", "\[Wedge]", "d\[Theta]", "\[Wedge]", "d\[CurlyPhi]"}]}], "+", 
  RowBox[{
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "\[Theta]", "]"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], "2"], " ", 
   RowBox[{
   "dr", "\[Wedge]", "d\[Theta]", "\[Wedge]", "d\[CurlyPhi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "after which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will simplify the coefficients,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
  RowBox[{
  "dr", "\[Wedge]", "d\[Theta]", "\[Wedge]", "d\[CurlyPhi]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "This could also be done with ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", "dtrans", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"dx", "\[Rule]", 
    RowBox[{
     RowBox[{"d\[Theta]", " ", "r", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], "+", 
     RowBox[{"dr", " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", 
     RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], ",", 
   RowBox[{"dy", "\[Rule]", 
    RowBox[{
     RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", 
     RowBox[{"d\[Theta]", " ", "r", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], "+", 
     RowBox[{"dr", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], ",", 
   RowBox[{"dz", "\[Rule]", 
    RowBox[{
     RowBox[{"dr", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
     RowBox[{"d\[Theta]", " ", "r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"applydrules", "[", "vol", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
  RowBox[{
  "dr", "\[Wedge]", "d\[Theta]", "\[Wedge]", "d\[CurlyPhi]"}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.c.4. Clean up", "Subsubsection"],

Cell[TextData[{
 "To avoid confusion among the variables of different problems, it is \
important to have a way of undeclaring the variables we have registered in \
the various fundamental lists. There are two sets of variables: the private \
global variables of the ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " package (in the ",
 StyleBox["xAct`AVF`", "Input",
  FontWeight->"Plain"],
 " or ",
 StyleBox["xAct`AVF`Private`", "Input",
  FontWeight->"Plain"],
 " contexts) and the user variables (in the ",
 StyleBox["Global`", "Input",
  FontWeight->"Plain"],
 " contex)."
}], "Text"],

Cell[TextData[{
 "a) Global variables of the ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " package."
}], "Text"],

Cell["\<\
Jose: To help keeping track of which variables are modified, I have added \
these:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData["ModifiedGlobalVariables"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"adjlist\"\>", ",", "\<\"algebra\"\>", ",", "\<\"dforms\"\>", 
   ",", "\<\"drules\"\>", ",", "\<\"dscalars\"\>", ",", "\<\"eldim\"\>", 
   ",", "\<\"elements\"\>", ",", "\<\"fderiv\"\>", ",", "\<\"fmdim\"\>", 
   ",", "\<\"forms\"\>", ",", "\<\"natural\"\>", ",", "\<\"scalars\"\>", 
   ",", "\<\"scdim\"\>", ",", "\<\"sderiv\"\>", ",", "\<\"vec1\"\>", 
   ",", "\<\"vec2\"\>", ",", "\<\"vec3\"\>", ",", "\<\"vec4\"\>", 
   ",", "\<\"av$44\"\>", ",", "\<\"av$cs\"\>"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", " ", "AVFinitialstate"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"{", "identity", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{"{", "identity", "}"}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox["1",
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "identity", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{"xAct`AVF`Private`av$fm", "\[Rule]", "0"}], "}"}],
    HoldForm], ",", 
   TagBox["0",
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox["0",
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{"{", 
      SubscriptBox["xAct`AVF`Private`av$49", 
       RowBox[{"1", ",", "1"}]], "}"}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", "}"}],
    HoldForm]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%%", "/.", "AVFstate"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["m", "0"], ",", 
      SubscriptBox["m", "1"], ",", 
      SubscriptBox["m", "2"], ",", 
      SubscriptBox["m", "3"]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["m", "0"], ",", 
        SubscriptBox["m", "1"], ",", 
        SubscriptBox["m", "2"], ",", 
        SubscriptBox["m", "3"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["m", "1"], ",", 
        SubscriptBox["m", "0"], ",", 
        SubscriptBox["m", "3"], ",", 
        SubscriptBox["m", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["m", "2"], ",", 
        RowBox[{"-", 
         SubscriptBox["m", "3"]}], ",", 
        SubscriptBox["m", "0"], ",", 
        RowBox[{"-", 
         SubscriptBox["m", "1"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["m", "3"], ",", 
        RowBox[{"-", 
         SubscriptBox["m", "2"]}], ",", 
        SubscriptBox["m", "1"], ",", 
        RowBox[{"-", 
         SubscriptBox["m", "0"]}]}], "}"}]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{"d\[Xi]", ",", "d\[Eta]", ",", "d\[Zeta]"}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"dx", "\[Rule]", 
       RowBox[{
        RowBox[{"d\[Theta]", " ", "r", " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
         RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], "+", 
        RowBox[{"dr", " ", 
         RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", 
        RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
         RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], ",", 
      RowBox[{"dy", "\[Rule]", 
       RowBox[{
        RowBox[{"d\[CurlyPhi]", " ", "r", " ", 
         RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", 
        RowBox[{"d\[Theta]", " ", "r", " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
         RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], "+", 
        RowBox[{"dr", " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
         RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], ",", 
      RowBox[{"dz", "\[Rule]", 
       RowBox[{
        RowBox[{"dr", " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
        RowBox[{"d\[Theta]", " ", "r", " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
     "dx", ",", "dy", ",", "dz", ",", "dr", ",", "d\[Theta]", ",", 
      "d\[CurlyPhi]"}], "}"}],
    HoldForm], ",", 
   TagBox["4",
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["m", "0"], ",", 
      SubscriptBox["m", "1"], ",", 
      SubscriptBox["m", "2"], ",", 
      SubscriptBox["m", "3"]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"xAct`AVF`Private`av$fm", "\[Rule]", "0"}], ",", 
      RowBox[{"d\[Xi]", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Xi]", "\[Rule]", "d\[Xi]"}], ",", 
      RowBox[{"d\[Eta]", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", "d\[Eta]"}], ",", 
      RowBox[{"d\[Zeta]", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", "d\[Zeta]"}], ",", 
      RowBox[{"dx", "\[Rule]", "0"}], ",", 
      RowBox[{"dy", "\[Rule]", "0"}], ",", 
      RowBox[{"dz", "\[Rule]", "0"}], ",", 
      RowBox[{"dr", "\[Rule]", "0"}], ",", 
      RowBox[{"d\[Theta]", "\[Rule]", "0"}], ",", 
      RowBox[{"d\[CurlyPhi]", "\[Rule]", "0"}]}], "}"}],
    HoldForm], ",", 
   TagBox["9",
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
     "\[Xi]", ",", "\[Eta]", ",", "\[Zeta]", ",", "dx", ",", "dy", ",", "dz", 
      ",", "dr", ",", "d\[Theta]", ",", "d\[CurlyPhi]"}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"d\[Xi]", "\[Rule]", "0"}], ",", 
      RowBox[{"d\[Eta]", "\[Rule]", "0"}], ",", 
      RowBox[{"d\[Zeta]", "\[Rule]", "0"}]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
     "x", ",", "y", ",", "z", ",", "r", ",", "\[Theta]", ",", "\[CurlyPhi]"}],
      "}"}],
    HoldForm], ",", 
   TagBox["6",
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Dt", "[", "x", "]"}], "\[Rule]", "dx"}], ",", 
      RowBox[{
       RowBox[{"Dt", "[", "y", "]"}], "\[Rule]", "dy"}], ",", 
      RowBox[{
       RowBox[{"Dt", "[", "z", "]"}], "\[Rule]", "dz"}], ",", 
      RowBox[{
       RowBox[{"Dt", "[", "r", "]"}], "\[Rule]", "dr"}], ",", 
      RowBox[{
       RowBox[{"Dt", "[", "\[Theta]", "]"}], "\[Rule]", "d\[Theta]"}], ",", 
      RowBox[{
       RowBox[{"Dt", "[", "\[CurlyPhi]", "]"}], "\[Rule]", "d\[CurlyPhi]"}]}],
      "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["v1", "1"], ",", 
      SubscriptBox["v1", "2"], ",", 
      SubscriptBox["v1", "3"], ",", 
      SubscriptBox["v1", "4"], ",", 
      SubscriptBox["v1", "5"], ",", 
      SubscriptBox["v1", "6"], ",", 
      SubscriptBox["v1", "7"], ",", 
      SubscriptBox["v1", "8"], ",", 
      SubscriptBox["v1", "9"]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["v2", "1"], ",", 
      SubscriptBox["v2", "2"], ",", 
      SubscriptBox["v2", "3"], ",", 
      SubscriptBox["v2", "4"], ",", 
      SubscriptBox["v2", "5"], ",", 
      SubscriptBox["v2", "6"], ",", 
      SubscriptBox["v2", "7"], ",", 
      SubscriptBox["v2", "8"], ",", 
      SubscriptBox["v2", "9"]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["v3", "1"], ",", 
      SubscriptBox["v3", "2"], ",", 
      SubscriptBox["v3", "3"], ",", 
      SubscriptBox["v3", "4"], ",", 
      SubscriptBox["v3", "5"], ",", 
      SubscriptBox["v3", "6"], ",", 
      SubscriptBox["v3", "7"], ",", 
      SubscriptBox["v3", "8"], ",", 
      SubscriptBox["v3", "9"]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["v4", "1"], ",", 
      SubscriptBox["v4", "2"], ",", 
      SubscriptBox["v4", "3"], ",", 
      SubscriptBox["v4", "4"], ",", 
      SubscriptBox["v4", "5"], ",", 
      SubscriptBox["v4", "6"], ",", 
      SubscriptBox["v4", "7"], ",", 
      SubscriptBox["v4", "8"], ",", 
      SubscriptBox["v4", "9"]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"1", ",", "1"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"1", ",", "2"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"1", ",", "3"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"1", ",", "4"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"2", ",", "1"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"2", ",", "2"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"2", ",", "3"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"2", ",", "4"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"3", ",", "1"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"3", ",", "2"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"3", ",", "3"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"3", ",", "4"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"4", ",", "1"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"4", ",", "2"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"4", ",", "3"}]], ",", 
        SubscriptBox["xAct`AVF`Private`av$49", 
         RowBox[{"4", ",", "4"}]]}], "}"}]}], "}"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["xAct`AVF`Private`av$c", "1"], ",", 
      SubscriptBox["xAct`AVF`Private`av$c", "2"], ",", 
      SubscriptBox["xAct`AVF`Private`av$c", "3"], ",", 
      SubscriptBox["xAct`AVF`Private`av$c", "4"], ",", 
      SubscriptBox["xAct`AVF`Private`av$c", "5"], ",", 
      SubscriptBox["xAct`AVF`Private`av$c", "6"], ",", 
      SubscriptBox["xAct`AVF`Private`av$c", "7"], ",", 
      SubscriptBox["xAct`AVF`Private`av$c", "8"], ",", 
      SubscriptBox["xAct`AVF`Private`av$c", "9"]}], "}"}],
    HoldForm]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "To restore the original state of the ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " variables we can do the following, in this order:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeelements", "[", 
  RowBox[{"{", "identity", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "identity", "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"makealgebra", "[", 
  RowBox[{"{", 
   RowBox[{"{", "identity", "}"}], "}"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeforms", "[", 
  RowBox[{"{", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "dx", ",", "dy", ",", "dz", ",", "dr", ",", "d\[Theta]", ",", 
   "d\[CurlyPhi]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"{", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell["Now:", "Text"],

Cell[CellGroupData[{

Cell[BoxData["ModifiedGlobalVariables"], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Jose: Those four commands (plus some others of the same type) have beeng \
grouped in the single action ",
 StyleBox["makeclear[]", "Input",
  FontWeight->"Plain"],
 ", which will be used from now on in this file for clearing the ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " state."
}], "Text"],

Cell[TextData[{
 "b) Then we also have our own variables, declared in the ",
 StyleBox["Global`", "Input",
  FontWeight->"Plain"],
 " context of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " :"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input"],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["Global`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["Global`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["a",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"a", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["dr",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"dr", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["fac",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"fac", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["newdrules",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"newdrules", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["vol",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"vol", "Global`"}},
          ButtonNote->"Global`"]},
        {
         ButtonBox["avf",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"avf", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["dtrans",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"dtrans", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["i",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"i", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["Option",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"Option", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["x",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"x", "Global`"}},
          ButtonNote->"Global`"]},
        {
         ButtonBox["avf1",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"avf1", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["dx",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"dx", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["k",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"k", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["p",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"p", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["y",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"y", "Global`"}},
          ButtonNote->"Global`"]},
        {
         ButtonBox["avf2",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"avf2", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["dy",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"dy", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["m",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"m", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["pvec",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"pvec", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["z",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"z", "Global`"}},
          ButtonNote->"Global`"]},
        {
         ButtonBox["avf3",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"avf3", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["dz",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"dz", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["M",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"M", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["r",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"r", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["\[Zeta]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"\[Zeta]", "Global`"}},
          ButtonNote->"Global`"]},
        {
         ButtonBox["avf4",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"avf4", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["d\[Zeta]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"d\[Zeta]", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["mat",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"mat", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["Shift",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"Shift", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["\[Eta]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"\[Eta]", "Global`"}},
          ButtonNote->"Global`"]},
        {
         ButtonBox["cartesian",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"cartesian", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["d\[Eta]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"d\[Eta]", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["matavf3",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"matavf3", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["spherical",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"spherical", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["\[Lambda]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"\[Lambda]", "Global`"}},
          ButtonNote->"Global`"]},
        {
         ButtonBox["Command",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"Command", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["d\[Xi]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"d\[Xi]", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["MenuKey",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"MenuKey", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["taggingrules",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"taggingrules", "Global`"}},
          
          ButtonNote->"Global`"], 
         ButtonBox["\[Xi]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"\[Xi]", "Global`"}},
          ButtonNote->"Global`"]},
        {
         ButtonBox["cs",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"cs", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["d\[CurlyPhi]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"d\[CurlyPhi]", "Global`"}},
          
          ButtonNote->"Global`"], 
         ButtonBox["mono",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"mono", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["tospherical",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"tospherical", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["\[CurlyPhi]",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"\[CurlyPhi]", "Global`"}},
          ButtonNote->"Global`"]},
        {
         ButtonBox["cs2",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"cs2", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["f",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"f", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["monomialfactor",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3533138458-7301182", {"monomialfactor", "Global`"}},
          ButtonNote->"Global`"], 
         ButtonBox["trans",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3533138458-7301182", {"trans", "Global`"}},
          ButtonNote->"Global`"], ""}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.19]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->Automatic]]], "Print", "InfoCell"]
}, Open  ]],

Cell["\<\
We can remove them individually, or can remove all of them using\
\>", "Text"],

Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[TextData[{
 "Now the ",
 StyleBox["Global`", "Input",
  FontWeight->"Plain"],
 " context is empty:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Information", "::", "nomatch"}], "MessageName"], ":", 
  " ", "\<\"No symbol matching \[NoBreak]\\!\\(\\\"Global`*\\\"\\)\[NoBreak] \
found. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Information/nomatch\\\", ButtonNote -> \
\\\"Information::nomatch\\\"]\\)\"\>"}]], "Message", "MSG"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.d. Lie differentiation", "Subsection"],

Cell[CellGroupData[{

Cell["II.d.1. Setting up some scalar variables", "Subsubsection",
 PageWidth->WindowWidth],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Introducing non-exact 1-forms will be delayed to a later section.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell["\<\
Since the algebra elements are constants, they are not actively involved in \
Lie differentiation. All the operations below can be applied to general \
AVF's, but for illustration we use ordinary differential forms; i.e., the \
trivial default algebra.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"identity"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.d.2. Lie derivative of AVFs, using a coordinate basis", \
"Subsubsection",
 PageWidth->WindowWidth],

Cell[TextData[{
 "The current ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list and the first convenience vector,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dx", ",", "dy", ",", "dz"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["vec1"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["v1", "1"], ",", 
   SubscriptBox["v1", "2"], ",", 
   SubscriptBox["v1", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 StyleBox["lie[vec, avf]", "Input",
  FontWeight->"Plain"],
 " calculates the Lie derivative of ",
 StyleBox["avf", "Input",
  FontWeight->"Plain"],
 " with respect to a vector ",
 StyleBox["vec", "Input",
  FontWeight->"Plain"],
 " using the expansion ",
 StyleBox["lie[vec_,avf_]:=vec\[SmallCircle]d[avf]+da[vec\[SmallCircle]avf]", 
  "Input",
  FontWeight->"Plain"],
 ". On a function of the scalars, ",
 StyleBox["lie", "Input",
  FontWeight->"Plain"],
 " just gives the directional derivative,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"vec1", ",", 
   RowBox[{"F", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["v1", "3"], " ", 
   RowBox[{
    SuperscriptBox["F", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   SubscriptBox["v1", "2"], " ", 
   RowBox[{
    SuperscriptBox["F", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   SubscriptBox["v1", "1"], " ", 
   RowBox[{
    SuperscriptBox["F", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell["But the convenience vector components are constants,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "vec1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and usually one wants a vector field. There are two ways to turn the \
components of ",
 StyleBox["V", "Input",
  FontWeight->"Plain"],
 " into field variables: either write them explicitly as specified or \
unspecified functions of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 "; or add the components into ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " as new independent variables. The problem with the first approach arises \
from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s output notation for derivatives of unspecified multi-variable functions, \
which is lengthy and not very readable. "
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[TextData[{
 "Consider the vector ",
 StyleBox["V", "Input",
  FontWeight->"Plain"],
 " having unspecified functional components dual to ",
 StyleBox["{dx,dy,dz}", "Input",
  FontWeight->"Plain"],
 ", operating on a general 2-form ",
 StyleBox["T", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"v1", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
    RowBox[{"v2", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
    RowBox[{"v3", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v1", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"v2", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"v3", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"X", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], 
    RowBox[{"dy", "\[Wedge]", "dz"}]}], "+", 
   RowBox[{
    RowBox[{"Y", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], 
    RowBox[{"dz", "\[Wedge]", "dx"}]}], "+", 
   RowBox[{
    RowBox[{"Z", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], 
    RowBox[{"dx", "\[Wedge]", "dy"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   RowBox[{"X", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", "dx"}], " ", 
   RowBox[{"Y", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   RowBox[{"Z", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"V", ",", "T"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{"dy", "\[Wedge]", "dz"}], ")"}]}], " ", 
   RowBox[{"Z", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   RowBox[{"Z", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v2", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   RowBox[{"X", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v3", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   RowBox[{"Y", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v3", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"v3", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   RowBox[{
    SuperscriptBox["X", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"v3", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   RowBox[{
    SuperscriptBox["Y", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"v3", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   RowBox[{
    SuperscriptBox["Z", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   RowBox[{"Y", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   RowBox[{"X", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v2", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   RowBox[{"Z", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v2", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   RowBox[{"Y", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v3", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"v2", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   RowBox[{
    SuperscriptBox["X", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"v2", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   RowBox[{
    SuperscriptBox["Y", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"v2", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   RowBox[{
    SuperscriptBox["Z", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   RowBox[{"Y", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   RowBox[{"Z", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v1", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   RowBox[{"X", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v2", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   RowBox[{"X", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["v3", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"v1", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   RowBox[{
    SuperscriptBox["X", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"v1", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   RowBox[{
    SuperscriptBox["Y", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"v1", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   RowBox[{
    SuperscriptBox["Z", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "II.d.3. Introducing coordinates with ",
 StyleBox["makecoords", "Input",
  FontWeight->"Plain"]
}], "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[TextData[{
 "Better output is provided in ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " by establishing a subset of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " as ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 ", using the ",
 StyleBox["makecoords[]", "Input",
  FontWeight->"Plain"],
 " command. More details about ",
 StyleBox["makecoords[]", "Input",
  FontWeight->"Plain"],
 " are given at the end of this section. Any pre-existing members of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " which are not designated as ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " will have subscript partial derivative expansions defined for them using \
Format output, and these are added into the ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ", which are invoked automatically for Lie derivatives."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[TextData[{
 "Using this approach, the scalar field variables in ",
 StyleBox["V", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["T", "Input",
  FontWeight->"Plain"],
 " are written without functional dependence, and are added into ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " before defining ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"V", "=", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}]}], "\n", 
 RowBox[{"T", "=", 
  RowBox[{
   RowBox[{"X", " ", 
    RowBox[{"dy", "\[Wedge]", "dz"}]}], "+", 
   RowBox[{"Y", " ", 
    RowBox[{"dz", "\[Wedge]", "dx"}]}], "+", 
   RowBox[{"Z", " ", 
    RowBox[{"dx", "\[Wedge]", "dy"}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Z", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}]}], "+", 
  RowBox[{"X", " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}]}], "+", 
  RowBox[{"Y", " ", 
   RowBox[{"dz", "\[Wedge]", "dx"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"Join", "[", 
   RowBox[{"scalars", ",", "V", ",", 
    RowBox[{"{", 
     RowBox[{"X", ",", "Y", ",", "Z"}], "}"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "y", ",", "z", ",", "v1", ",", "v2", ",", "v3", ",", "X", ",", 
   "Y", ",", "Z"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and then ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " is established,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["scalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "y", ",", "z", ",", "v1", ",", "v2", ",", "v3", ",", "X", ",", 
   "Y", ",", "Z"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["drules"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"dv1", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["v1", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["v1", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["v1", "x"]}]}]}], ",", 
   RowBox[{"dv2", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["v2", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["v2", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["v2", "x"]}]}]}], ",", 
   RowBox[{"dv3", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["v3", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["v3", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["v3", "x"]}]}]}], ",", 
   RowBox[{"dX", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["X", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["X", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["X", "x"]}]}]}], ",", 
   RowBox[{"dY", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["Y", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["Y", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["Y", "x"]}]}]}], ",", 
   RowBox[{"dZ", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["Z", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["Z", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["Z", "x"]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Now the same Lie derivative performed above is output in a more readable form:\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"V", ",", "T"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "Z"}], " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["v1", "z"]}], "+", 
  RowBox[{"Z", " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["v2", "z"]}], "-", 
  RowBox[{"Y", " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["v3", "z"]}], "+", 
  RowBox[{"X", " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["v3", "z"]}], "+", 
  RowBox[{"v3", " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["X", "z"]}], "-", 
  RowBox[{"v3", " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["Y", "z"]}], "+", 
  RowBox[{"v3", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox["Z", "z"]}], "-", 
  RowBox[{"Y", " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["v1", "y"]}], "+", 
  RowBox[{"Z", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox["v2", "y"]}], "+", 
  RowBox[{"X", " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["v2", "y"]}], "-", 
  RowBox[{"Y", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox["v3", "y"]}], "+", 
  RowBox[{"v2", " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["X", "y"]}], "-", 
  RowBox[{"v2", " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["Y", "y"]}], "+", 
  RowBox[{"v2", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox["Z", "y"]}], "+", 
  RowBox[{"Z", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox["v1", "x"]}], "-", 
  RowBox[{"Y", " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["v1", "x"]}], "+", 
  RowBox[{"X", " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["v2", "x"]}], "-", 
  RowBox[{"X", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox["v3", "x"]}], "+", 
  RowBox[{"v1", " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["X", "x"]}], "-", 
  RowBox[{"v1", " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox["Y", "x"]}], "+", 
  RowBox[{"v1", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox["Z", "x"]}]}]], "Output"]
}, Open  ]],

Cell["\<\
To sort that into independent bases, the canonical order of the basis 2-forms \
(as they appear there) must be used. This gives about the simplest possible \
output for general vectors and forms.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"dy", "\[Wedge]", "dz"}], ",", 
     RowBox[{"dx", "\[Wedge]", "dz"}], ",", 
     RowBox[{"dx", "\[Wedge]", "dy"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "Z"}], " ", 
      SubscriptBox["v1", "z"]}], "+", 
     RowBox[{"X", " ", 
      SubscriptBox["v3", "z"]}], "+", 
     RowBox[{"v3", " ", 
      SubscriptBox["X", "z"]}], "-", 
     RowBox[{"Y", " ", 
      SubscriptBox["v1", "y"]}], "+", 
     RowBox[{"X", " ", 
      SubscriptBox["v2", "y"]}], "+", 
     RowBox[{"v2", " ", 
      SubscriptBox["X", "y"]}], "+", 
     RowBox[{"v1", " ", 
      SubscriptBox["X", "x"]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Z", " ", 
      SubscriptBox["v2", "z"]}], "-", 
     RowBox[{"Y", " ", 
      SubscriptBox["v3", "z"]}], "-", 
     RowBox[{"v3", " ", 
      SubscriptBox["Y", "z"]}], "-", 
     RowBox[{"v2", " ", 
      SubscriptBox["Y", "y"]}], "-", 
     RowBox[{"Y", " ", 
      SubscriptBox["v1", "x"]}], "+", 
     RowBox[{"X", " ", 
      SubscriptBox["v2", "x"]}], "-", 
     RowBox[{"v1", " ", 
      SubscriptBox["Y", "x"]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"v3", " ", 
      SubscriptBox["Z", "z"]}], "+", 
     RowBox[{"Z", " ", 
      SubscriptBox["v2", "y"]}], "-", 
     RowBox[{"Y", " ", 
      SubscriptBox["v3", "y"]}], "+", 
     RowBox[{"v2", " ", 
      SubscriptBox["Z", "y"]}], "+", 
     RowBox[{"Z", " ", 
      SubscriptBox["v1", "x"]}], "-", 
     RowBox[{"X", " ", 
      SubscriptBox["v3", "x"]}], "+", 
     RowBox[{"v1", " ", 
      SubscriptBox["Z", "x"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Note that the current ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " are never invoked automatically in exterior differentiation; e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "Y", ",", "T"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dv1", ",", "dY", ",", 
   RowBox[{
    RowBox[{"dx", "\[Wedge]", "dy", "\[Wedge]", "dZ"}], "+", 
    RowBox[{"dx", "\[Wedge]", "dY", "\[Wedge]", "dz"}], "+", 
    RowBox[{"dX", "\[Wedge]", "dy", "\[Wedge]", "dz"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "but they will be applied using ",
 StyleBox["da[]", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "Y", ",", "T"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"dz", " ", 
     SubscriptBox["v1", "z"]}], "+", 
    RowBox[{"dy", " ", 
     SubscriptBox["v1", "y"]}], "+", 
    RowBox[{"dx", " ", 
     SubscriptBox["v1", "x"]}]}], ",", 
   RowBox[{
    RowBox[{"dz", " ", 
     SubscriptBox["Y", "z"]}], "+", 
    RowBox[{"dy", " ", 
     SubscriptBox["Y", "y"]}], "+", 
    RowBox[{"dx", " ", 
     SubscriptBox["Y", "x"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"dx", "\[Wedge]", "dy", "\[Wedge]", "dz"}], " ", 
     SubscriptBox["Z", "z"]}], "+", 
    RowBox[{
     RowBox[{"dx", "\[Wedge]", "dy", "\[Wedge]", "dz"}], " ", 
     SubscriptBox["Y", "y"]}], "+", 
    RowBox[{
     RowBox[{"dx", "\[Wedge]", "dy", "\[Wedge]", "dz"}], " ", 
     SubscriptBox["X", "x"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["and are automatic for all vector contractions,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "\[SmallCircle]", 
  RowBox[{"d", "[", 
   RowBox[{"{", 
    RowBox[{"v1", ",", "Y", ",", "T"}], "}"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"v3", " ", 
     SubscriptBox["v1", "z"]}], "+", 
    RowBox[{"v2", " ", 
     SubscriptBox["v1", "y"]}], "+", 
    RowBox[{"v1", " ", 
     SubscriptBox["v1", "x"]}]}], ",", 
   RowBox[{
    RowBox[{"v3", " ", 
     SubscriptBox["Y", "z"]}], "+", 
    RowBox[{"v2", " ", 
     SubscriptBox["Y", "y"]}], "+", 
    RowBox[{"v1", " ", 
     SubscriptBox["Y", "x"]}]}], ",", 
   RowBox[{
    RowBox[{"v3", " ", 
     RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
     SubscriptBox["Z", "z"]}], "-", 
    RowBox[{"v2", " ", 
     RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
     SubscriptBox["Z", "z"]}], "+", 
    RowBox[{"v1", " ", 
     RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
     SubscriptBox["Z", "z"]}], "+", 
    RowBox[{"v3", " ", 
     RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
     SubscriptBox["Y", "y"]}], "-", 
    RowBox[{"v2", " ", 
     RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
     SubscriptBox["Y", "y"]}], "+", 
    RowBox[{"v1", " ", 
     RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
     SubscriptBox["Y", "y"]}], "+", 
    RowBox[{"v3", " ", 
     RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
     SubscriptBox["X", "x"]}], "-", 
    RowBox[{"v2", " ", 
     RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
     SubscriptBox["X", "x"]}], "+", 
    RowBox[{"v1", " ", 
     RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
     SubscriptBox["X", "x"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Any variable not in ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " can have the same formatting of partial derivatives by writing it as a \
function of the reserved variable ",
 StyleBox["depend", "Input",
  FontWeight->"Plain"],
 ", which inserts the dependence on ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"F", "[", "depend", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"F", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "f", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dz", " ", 
   SubscriptBox["F", "z"]}], "+", 
  RowBox[{"dy", " ", 
   SubscriptBox["F", "y"]}], "+", 
  RowBox[{"dx", " ", 
   SubscriptBox["F", "x"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"V", ",", "f"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"v3", " ", 
   SubscriptBox["F", "z"]}], "+", 
  RowBox[{"v2", " ", 
   SubscriptBox["F", "y"]}], "+", 
  RowBox[{"v1", " ", 
   SubscriptBox["F", "x"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The operators ",
 StyleBox["d", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["lie", "Input",
  FontWeight->"Plain"],
 " must commute identically for an arbitrary vector field,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "[", 
   RowBox[{"lie", "[", 
    RowBox[{"V", ",", "f"}], "]"}], "]"}], "-", 
  RowBox[{"lie", "[", 
   RowBox[{"V", ",", 
    RowBox[{"d", "[", "f", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dv3", " ", 
   SubscriptBox["F", "z"]}], "-", 
  RowBox[{"dz", " ", 
   SubscriptBox["F", "z"], " ", 
   SubscriptBox["v3", "z"]}], "+", 
  RowBox[{"dv2", " ", 
   SubscriptBox["F", "y"]}], "-", 
  RowBox[{"dz", " ", 
   SubscriptBox["v2", "z"], " ", 
   SubscriptBox["F", "y"]}], "-", 
  RowBox[{"dy", " ", 
   SubscriptBox["F", "y"], " ", 
   SubscriptBox["v2", "y"]}], "-", 
  RowBox[{"dy", " ", 
   SubscriptBox["F", "z"], " ", 
   SubscriptBox["v3", "y"]}], "+", 
  RowBox[{"dv1", " ", 
   SubscriptBox["F", "x"]}], "-", 
  RowBox[{"dz", " ", 
   SubscriptBox["v1", "z"], " ", 
   SubscriptBox["F", "x"]}], "-", 
  RowBox[{"dy", " ", 
   SubscriptBox["v1", "y"], " ", 
   SubscriptBox["F", "x"]}], "-", 
  RowBox[{"dx", " ", 
   SubscriptBox["F", "x"], " ", 
   SubscriptBox["v1", "x"]}], "-", 
  RowBox[{"dx", " ", 
   SubscriptBox["F", "y"], " ", 
   SubscriptBox["v2", "x"]}], "-", 
  RowBox[{"dx", " ", 
   SubscriptBox["F", "z"], " ", 
   SubscriptBox["v3", "x"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "but the initial ",
 StyleBox["d[]", "Input",
  FontWeight->"Plain"],
 " derivative in that statement does ",
 StyleBox["not",
  FontVariations->{"Underline"->True}],
 " invoke the ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " required to give the correct result; i.e.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"applydrules", "[", "%", "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "and the identity should be written using ",
 StyleBox["da[]", "Input",
  FontWeight->"Plain"],
 " rather than ",
 StyleBox["d[]", "Input",
  FontWeight->"Plain"],
 "; for example, on the 2-form ",
 StyleBox["T", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"da", "[", 
   RowBox[{"lie", "[", 
    RowBox[{"V", ",", "T"}], "]"}], "]"}], "-", 
  RowBox[{"lie", "[", 
   RowBox[{"V", ",", 
    RowBox[{"da", "[", "T", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Clearly, this technique may not be helpful when some vector components and \
some ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " are independent of some ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 ". In such cases, it may be better to use the standard functional notation, \
although it might also be feasible to edit out any unwanted terms from the \
automatically constructed ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ", to use ",
 StyleBox["makedrules[]", "Input",
  FontWeight->"Plain"],
 " with the edited drules, and so preserve the brevity given by the Format \
notation."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"]
}, Closed]],

Cell[CellGroupData[{

Cell["II.d.4. Lie product of vectors", "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[TextData[{
 "Since both ",
 StyleBox["d[]", "Input",
  FontWeight->"Plain"],
 " and \[SmallCircle] extend to arrays of AVFs, so does the ",
 StyleBox["lie[]", "Input",
  FontWeight->"Plain"],
 " function. And since a vector is represented as a list of scalar \
components, ",
 StyleBox["lie[]", "Input",
  FontWeight->"Plain"],
 " can be applied to vectors as well. Introduce a new vector ",
 StyleBox["W", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"W", "=", 
  RowBox[{"{", 
   RowBox[{"w1", ",", "w2", ",", "w3"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"w1", ",", "w2", ",", "w3"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"Join", "[", 
   RowBox[{"scalars", ",", "W"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "y", ",", "z", ",", "v1", ",", "v2", ",", "v3", ",", "X", ",", 
   "Y", ",", "Z", ",", "w1", ",", "w2", ",", "w3"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "To avoid duplication of ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", 
  RowBox[{"{", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and now again make ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["drules"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"dv1", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["v1", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["v1", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["v1", "x"]}]}]}], ",", 
   RowBox[{"dv2", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["v2", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["v2", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["v2", "x"]}]}]}], ",", 
   RowBox[{"dv3", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["v3", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["v3", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["v3", "x"]}]}]}], ",", 
   RowBox[{"dw1", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["w1", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["w1", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["w1", "x"]}]}]}], ",", 
   RowBox[{"dw2", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["w2", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["w2", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["w2", "x"]}]}]}], ",", 
   RowBox[{"dw3", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["w3", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["w3", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["w3", "x"]}]}]}], ",", 
   RowBox[{"dX", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["X", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["X", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["X", "x"]}]}]}], ",", 
   RowBox[{"dY", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["Y", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["Y", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["Y", "x"]}]}]}], ",", 
   RowBox[{"dZ", "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox["Z", "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox["Z", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["Z", "x"]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"V", ",", "W"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"v3", " ", 
     SubscriptBox["w1", "z"]}], "+", 
    RowBox[{"v2", " ", 
     SubscriptBox["w1", "y"]}], "+", 
    RowBox[{"v1", " ", 
     SubscriptBox["w1", "x"]}]}], ",", 
   RowBox[{
    RowBox[{"v3", " ", 
     SubscriptBox["w2", "z"]}], "+", 
    RowBox[{"v2", " ", 
     SubscriptBox["w2", "y"]}], "+", 
    RowBox[{"v1", " ", 
     SubscriptBox["w2", "x"]}]}], ",", 
   RowBox[{
    RowBox[{"v3", " ", 
     SubscriptBox["w3", "z"]}], "+", 
    RowBox[{"v2", " ", 
     SubscriptBox["w3", "y"]}], "+", 
    RowBox[{"v1", " ", 
     SubscriptBox["w3", "x"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["but for the Lie product this must be anti-symmetrized,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VW", "=", 
  RowBox[{
   RowBox[{"lie", "[", 
    RowBox[{"V", ",", "W"}], "]"}], "-", 
   RowBox[{"lie", "[", 
    RowBox[{"W", ",", "V"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "w3"}], " ", 
     SubscriptBox["v1", "z"]}], "+", 
    RowBox[{"v3", " ", 
     SubscriptBox["w1", "z"]}], "-", 
    RowBox[{"w2", " ", 
     SubscriptBox["v1", "y"]}], "+", 
    RowBox[{"v2", " ", 
     SubscriptBox["w1", "y"]}], "-", 
    RowBox[{"w1", " ", 
     SubscriptBox["v1", "x"]}], "+", 
    RowBox[{"v1", " ", 
     SubscriptBox["w1", "x"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "w3"}], " ", 
     SubscriptBox["v2", "z"]}], "+", 
    RowBox[{"v3", " ", 
     SubscriptBox["w2", "z"]}], "-", 
    RowBox[{"w2", " ", 
     SubscriptBox["v2", "y"]}], "+", 
    RowBox[{"v2", " ", 
     SubscriptBox["w2", "y"]}], "-", 
    RowBox[{"w1", " ", 
     SubscriptBox["v2", "x"]}], "+", 
    RowBox[{"v1", " ", 
     SubscriptBox["w2", "x"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "w3"}], " ", 
     SubscriptBox["v3", "z"]}], "+", 
    RowBox[{"v3", " ", 
     SubscriptBox["w3", "z"]}], "-", 
    RowBox[{"w2", " ", 
     SubscriptBox["v3", "y"]}], "+", 
    RowBox[{"v2", " ", 
     SubscriptBox["w3", "y"]}], "-", 
    RowBox[{"w1", " ", 
     SubscriptBox["v3", "x"]}], "+", 
    RowBox[{"v1", " ", 
     SubscriptBox["w3", "x"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["The identity for Lie differentiation reads", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"lie", "[", 
    RowBox[{"VW", ",", "T"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lie", "[", 
      RowBox[{"V", ",", 
       RowBox[{"lie", "[", 
        RowBox[{"W", ",", "T"}], "]"}]}], "]"}], "-", 
     RowBox[{"lie", "[", 
      RowBox[{"W", ",", 
       RowBox[{"lie", "[", 
        RowBox[{"V", ",", "T"}], "]"}]}], "]"}]}], ")"}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.d.5. Anholonomic forms", "Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell["\<\
Coordinate and anholonomic basis forms can perfectly well be mixed together, \
but for the moment the scalar variables will be dropped,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"{", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeforms", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], ",", 
    SubscriptBox["\[Omega]", "2"], ",", 
    SubscriptBox["\[Omega]", "3"]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell["The first convenience vector is given a shorter name,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", "vec1"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["v1", "1"], ",", 
   SubscriptBox["v1", "2"], ",", 
   SubscriptBox["v1", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "By default, the ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " specify closed 1-forms, and ",
 StyleBox["lie", "Input",
  FontWeight->"Plain"],
 " invokes ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " automatically to perform the vector contractions involved. Furthermore, \
the vector ",
 StyleBox["V", "Input",
  FontWeight->"Plain"],
 " is constant,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["drules"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["d\[Omega]", "1"], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "2"], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "3"], "\[Rule]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "V", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "so the resulting Lie derivative of the 2-form, ",
 StyleBox["Q", "Input",
  FontWeight->"Plain"],
 " , vanishes."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Q", "=", 
  RowBox[{
   SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
   SubscriptBox["\[Omega]", "2"]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
  SubscriptBox["\[Omega]", "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"V", ",", "Q"}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["\<\
The anholonomic basis can be given the Maurer-Cartan structure relations:\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mcdrules", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["d\[Omega]", "1"], "\[Rule]", 
     RowBox[{
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], ",", 
    RowBox[{
     SubscriptBox["d\[Omega]", "2"], "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["d\[Omega]", "3"], "\[Rule]", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["d\[Omega]", "1"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "2"], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}], ")"}]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "3"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "2"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", "mcdrules", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["d\[Omega]", "1"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "2"], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}], ")"}]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "3"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "2"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["and checking closure,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", 
  RowBox[{"da", "[", "forms", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The vector ",
 StyleBox["V", "Input",
  FontWeight->"Plain"],
 " becomes a field by making its components into independent ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", "V", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["v1", "1"], ",", 
   SubscriptBox["v1", "2"], ",", 
   SubscriptBox["v1", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"], ",", 
   SubscriptBox["dv1", "1"], ",", 
   SubscriptBox["dv1", "2"], ",", 
   SubscriptBox["dv1", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
and now the Lie derivative and commutation property are non-trivial.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"V", ",", "Q"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["dv1", "1"], "\[Wedge]", 
   SubscriptBox["\[Omega]", "2"]}], "-", 
  RowBox[{
   SubscriptBox["dv1", "2"], "\[Wedge]", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "1"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "-", 
  RowBox[{
   SubscriptBox["v1", "2"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"da", "[", 
   RowBox[{"lie", "[", 
    RowBox[{"V", ",", "Q"}], "]"}], "]"}], "-", 
  RowBox[{"lie", "[", 
   RowBox[{"V", ",", 
    RowBox[{"da", "[", "Q", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "When new basis forms appear, as the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["dv1", "i"], TraditionalForm]]],
 " above, the convenience vectors will automatically expand to accommodate \
them,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["vec1"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["v1", "1"], ",", 
   SubscriptBox["v1", "2"], ",", 
   SubscriptBox["v1", "3"], ",", 
   SubscriptBox["v1", "4"], ",", 
   SubscriptBox["v1", "5"], ",", 
   SubscriptBox["v1", "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "but these 3 new components, representing contractions on the derivatives of \
the original vector components, are not in ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " and so are constant."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "vec1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["dv1", "1"], ",", 
   SubscriptBox["dv1", "2"], ",", 
   SubscriptBox["dv1", "3"], ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Taking higher Lie derivatives following this approach would require \
expanding the vectors and scalars at each new level. That is possible, but it \
gets out of hand rather quickly. However, the ",
 StyleBox["makecoords", "Input",
  FontWeight->"Plain"],
 " command can be used here to prevent the expansion; e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[TextData[{
 "If higher derivatives are to be calculated, it will be necessary to expand \
V just once to cover contractions on the coordinate basis used to expand all \
scalar variables, say ",
 StyleBox["{x,y,z}", "Input",
  FontWeight->"Plain"]
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"], ",", "dx", ",", "dy", ",", "dz"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Since all other ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " will be expanded on the coordinate basis, only these first 6 members of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " need to have vector components, and these components must appear in the \
final ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " list,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", "vec1"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["v1", "1"], ",", 
   SubscriptBox["v1", "2"], ",", 
   SubscriptBox["v1", "3"], ",", 
   SubscriptBox["v1", "4"], ",", 
   SubscriptBox["v1", "5"], ",", 
   SubscriptBox["v1", "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", "V", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["v1", "1"], ",", 
   SubscriptBox["v1", "2"], ",", 
   SubscriptBox["v1", "3"], ",", 
   SubscriptBox["v1", "4"], ",", 
   SubscriptBox["v1", "5"], ",", 
   SubscriptBox["v1", "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and now use ",
 StyleBox["makecoords", "Input",
  FontWeight->"Plain"],
 " to get a complete set of ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell["The final lists:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["scalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z", ",", 
   SubscriptBox["v1", "1"], ",", 
   SubscriptBox["v1", "2"], ",", 
   SubscriptBox["v1", "3"], ",", 
   SubscriptBox["v1", "4"], ",", 
   SubscriptBox["v1", "5"], ",", 
   SubscriptBox["v1", "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"], ",", "dx", ",", "dy", ",", "dz", ",", 
   SubscriptBox["dv1", "1"], ",", 
   SubscriptBox["dv1", "2"], ",", 
   SubscriptBox["dv1", "3"], ",", 
   SubscriptBox["dv1", "4"], ",", 
   SubscriptBox["dv1", "5"], ",", 
   SubscriptBox["dv1", "6"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["drules"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["d\[Omega]", "1"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "2"], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}], ")"}]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "3"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "2"]}]}], ",", 
   RowBox[{
    SubscriptBox["dv1", "1"], "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["v1", "1"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["v1", "1"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["v1", "1"], "x"]}]}]}], ",", 
   RowBox[{
    SubscriptBox["dv1", "2"], "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["v1", "2"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["v1", "2"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["v1", "2"], "x"]}]}]}], ",", 
   RowBox[{
    SubscriptBox["dv1", "3"], "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["v1", "3"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["v1", "3"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["v1", "3"], "x"]}]}]}], ",", 
   RowBox[{
    SubscriptBox["dv1", "4"], "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["v1", "4"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["v1", "4"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["v1", "4"], "x"]}]}]}], ",", 
   RowBox[{
    SubscriptBox["dv1", "5"], "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["v1", "5"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["v1", "5"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["v1", "5"], "x"]}]}]}], ",", 
   RowBox[{
    SubscriptBox["dv1", "6"], "\[Rule]", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["v1", "6"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["v1", "6"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["v1", "6"], "x"]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Repeating the same Lie derivative as calculated above,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VQ", "=", 
  RowBox[{"lie", "[", 
   RowBox[{"V", ",", "Q"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["v1", "1"]}], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "-", 
  RowBox[{
   SubscriptBox["v1", "2"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "+", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"]}], "-", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"]}], "-", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "y"]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "x"]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"da", "[", "VQ", "]"}], "-", 
  RowBox[{"lie", "[", 
   RowBox[{"V", ",", 
    RowBox[{"da", "[", "Q", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["and a second derivative can now be evaluated,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"V", ",", "VQ"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubsuperscriptBox["v1", "1", "2"]}], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}]}], "-", 
  RowBox[{
   SubsuperscriptBox["v1", "2", "2"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}]}], "-", 
  RowBox[{
   SubscriptBox["v1", "2"], " ", 
   SubscriptBox["v1", "3"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "+", 
  RowBox[{
   SubscriptBox["v1", "1"], " ", 
   SubscriptBox["v1", "3"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "+", 
  RowBox[{
   SubscriptBox["v1", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["v1", "1"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "6"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "3"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["v1", "2"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "6"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "1"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "3"], "z"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "2"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "3"], "z"]}], "+", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "6"], "z"]}], "-", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "6"], "z"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "6"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "\<\"zz\"\>"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "6"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "\<\"zz\"\>"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "3"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["v1", "1"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "5"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"]}], "+", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "5"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "3"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "y"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["v1", "2"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "y"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "5"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "y"]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "y"]}], "-", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "5"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "y"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "1"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "3"], "y"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "2"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "3"], "y"]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "5"], "y"]}], "-", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "y"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "5"], "y"]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "6"], "y"]}], "-", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "6"], "y"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "6"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "\<\"yz\"\>"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "5"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "\<\"yz\"\>"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "6"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "\<\"yz\"\>"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "5"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "\<\"yz\"\>"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "5"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "\<\"yy\"\>"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "5"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "\<\"yy\"\>"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "x"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["v1", "1"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "x"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "4"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "x"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "x"]}], "+", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "4"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "x"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "y"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "x"]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "4"], "y"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "x"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "3"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["v1", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "4"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"]}], "-", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "4"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"]}], "-", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "4"], "y"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "1"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "3"], "x"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "3"], "x"]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "x"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "4"], "x"]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "4"], "x"]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "5"], "x"]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "y"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "5"], "x"]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "6"], "x"]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"], " ", 
   SubscriptBox[
    SubscriptBox["v1", "6"], "x"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "6"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "\<\"xz\"\>"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "4"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "\<\"xz\"\>"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "6"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "\<\"xz\"\>"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "4"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "\<\"xz\"\>"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "5"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "\<\"xy\"\>"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "4"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "\<\"xy\"\>"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "5"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "\<\"xy\"\>"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "4"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "\<\"xy\"\>"]}], "+", 
  RowBox[{
   SubscriptBox["v1", "4"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "\<\"xx\"\>"]}], "-", 
  RowBox[{
   SubscriptBox["v1", "4"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "\<\"xx\"\>"]}]}]], "Output"]
}, Open  ]],

Cell["The coordinates can mix in with the anholonomic forms;", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "=", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], "+", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], "+", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dx", "\[Wedge]", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{"dy", "\[Wedge]", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{"dz", "\[Wedge]", 
   SubscriptBox["\[Omega]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VS", "=", 
  RowBox[{"lie", "[", 
   RowBox[{"V", ",", "S"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["v1", "3"]}], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}]}], "+", 
  RowBox[{
   SubscriptBox["v1", "2"], " ", 
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "+", 
  RowBox[{
   SubscriptBox["v1", "3"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}]}], "-", 
  RowBox[{
   SubscriptBox["v1", "1"], " ", 
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "-", 
  RowBox[{
   SubscriptBox["v1", "2"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}]}], "+", 
  RowBox[{
   SubscriptBox["v1", "1"], " ", 
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "z"]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "z"]}], "+", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "4"], "z"]}], "+", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "5"], "z"]}], "+", 
  RowBox[{
   RowBox[{"dz", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "6"], "z"]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "1"], "y"]}], "-", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", "dz"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "3"], "y"]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "4"], "y"]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "5"], "y"]}], "+", 
  RowBox[{
   RowBox[{"dy", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "6"], "y"]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dy"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "2"], "x"]}], "-", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", "dz"}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "3"], "x"]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "4"], "x"]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "5"], "x"]}], "+", 
  RowBox[{
   RowBox[{"dx", "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}], " ", 
   SubscriptBox[
    SubscriptBox["v1", "6"], "x"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"da", "[", "VS", "]"}], "-", 
  RowBox[{"lie", "[", 
   RowBox[{"V", ",", 
    RowBox[{"da", "[", "S", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["lie[]", "Input",
  FontWeight->"Plain"],
 " will operate on any array of AVFs"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], ",", 
      SubscriptBox["\[Omega]", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["d\[Omega]", "1"], ",", 
      SubscriptBox["d\[Omega]", "2"]}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], ",", 
     SubscriptBox["\[Omega]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["d\[Omega]", "1"], ",", 
     SubscriptBox["d\[Omega]", "2"]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"V", ",", "M"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["v1", "3"]}], " ", 
       SubscriptBox["\[Omega]", "2"]}], "+", 
      RowBox[{
       SubscriptBox["v1", "2"], " ", 
       SubscriptBox["\[Omega]", "3"]}], "+", 
      RowBox[{"dz", " ", 
       SubscriptBox[
        SubscriptBox["v1", "1"], "z"]}], "+", 
      RowBox[{"dy", " ", 
       SubscriptBox[
        SubscriptBox["v1", "1"], "y"]}], "+", 
      RowBox[{"dx", " ", 
       SubscriptBox[
        SubscriptBox["v1", "1"], "x"]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["v1", "3"], " ", 
       SubscriptBox["\[Omega]", "1"]}], "-", 
      RowBox[{
       SubscriptBox["v1", "1"], " ", 
       SubscriptBox["\[Omega]", "3"]}], "+", 
      RowBox[{"dz", " ", 
       SubscriptBox[
        SubscriptBox["v1", "2"], "z"]}], "+", 
      RowBox[{"dy", " ", 
       SubscriptBox[
        SubscriptBox["v1", "2"], "y"]}], "+", 
      RowBox[{"dx", " ", 
       SubscriptBox[
        SubscriptBox["v1", "2"], "x"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["v1", "2"], " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}]}], "+", 
      RowBox[{
       SubscriptBox["v1", "3"], " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}]}], "+", 
      RowBox[{
       RowBox[{"dz", "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "2"], "z"]}], "-", 
      RowBox[{
       RowBox[{"dz", "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "3"], "z"]}], "+", 
      RowBox[{
       RowBox[{"dy", "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "2"], "y"]}], "-", 
      RowBox[{
       RowBox[{"dy", "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "3"], "y"]}], "+", 
      RowBox[{
       RowBox[{"dx", "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "2"], "x"]}], "-", 
      RowBox[{
       RowBox[{"dx", "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "3"], "x"]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["v1", "1"]}], " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}]}], "+", 
      RowBox[{
       SubscriptBox["v1", "3"], " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}]}], "-", 
      RowBox[{
       RowBox[{"dz", "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "1"], "z"]}], "+", 
      RowBox[{
       RowBox[{"dz", "\[Wedge]", 
        SubscriptBox["\[Omega]", "1"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "3"], "z"]}], "-", 
      RowBox[{
       RowBox[{"dy", "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "1"], "y"]}], "+", 
      RowBox[{
       RowBox[{"dy", "\[Wedge]", 
        SubscriptBox["\[Omega]", "1"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "3"], "y"]}], "-", 
      RowBox[{
       RowBox[{"dx", "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "1"], "x"]}], "+", 
      RowBox[{
       RowBox[{"dx", "\[Wedge]", 
        SubscriptBox["\[Omega]", "1"]}], " ", 
       SubscriptBox[
        SubscriptBox["v1", "3"], "x"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"da", "[", 
   RowBox[{"lie", "[", 
    RowBox[{"V", ",", "M"}], "]"}], "]"}], "-", 
  RowBox[{"lie", "[", 
   RowBox[{"V", ",", 
    RowBox[{"da", "[", "M", "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.d.6. Lie products and the Lie algebra of non-exact forms", \
"Subsubsection",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[TextData[{
 "The \"dual\" basis vectors are given by the rows of the identity matrix, \
where ",
 StyleBox["fmdim", "Input",
  FontWeight->"Plain"],
 " is the length of the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list. The duals to the exact 1-forms in ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 " must commute, so can be eliminated,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"{", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"duals", "=", 
   RowBox[{"IdentityMatrix", "[", "fmdim", "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "A list of the Lie derivatives of the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list with respect to each of their 3 dual vectors:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lf", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"lie", "[", 
     RowBox[{
      RowBox[{"duals", "[", 
       RowBox[{"[", "m", "]"}], "]"}], ",", "forms"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "fmdim"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      SubscriptBox["\[Omega]", "3"]}], ",", 
     SubscriptBox["\[Omega]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Omega]", "3"], ",", "0", ",", 
     RowBox[{"-", 
      SubscriptBox["\[Omega]", "1"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Omega]", "2"]}], ",", 
     SubscriptBox["\[Omega]", "1"], ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "And next, a list of the anti-symmetrized derivatives of each of these with \
respect to the dual vectors; equivalent to the Lie derivative of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " with respect to the Lie brackets of the duals."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lie", "[", 
     RowBox[{
      RowBox[{"duals", "[", 
       RowBox[{"[", "m", "]"}], "]"}], ",", 
      RowBox[{"lf", "[", 
       RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "-", 
    RowBox[{"lie", "[", 
     RowBox[{
      RowBox[{"duals", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ",", 
      RowBox[{"lf", "[", 
       RowBox[{"[", "m", "]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"fmdim", "-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"m", "+", "1"}], ",", "fmdim"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Omega]", "2"], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Omega]", "1"]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Omega]", "3"], ",", "0", ",", 
       RowBox[{"-", 
        SubscriptBox["\[Omega]", "1"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      SubscriptBox["\[Omega]", "3"], ",", 
      RowBox[{"-", 
       SubscriptBox["\[Omega]", "2"]}]}], "}"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Comparing the two lists, which contain the same results up to signs and \
order, reveals the Lie algebra of ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[TextData[{
 "The function ",
 StyleBox["liealgebra[]", "Input",
  FontWeight->"Plain"],
 " will return a list of the Lie brackets, L[ ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["V", "m"], ",", 
    OverscriptBox["V", "n"]}], TraditionalForm]]],
 "] , for the full set of vectors dual to the current ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list (excluding any exact basis forms in ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 "), using the current ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " which must be defined for all the non-exact ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"liealgebra", "[", "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"order = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], ",", 
     SubscriptBox["\[Omega]", "2"], ",", 
     SubscriptBox["\[Omega]", "3"]}], "}"}]}],
  SequenceForm["order = ", {
    Subscript[xAct`AVF`\[Omega], 1], 
    Subscript[xAct`AVF`\[Omega], 2], 
    Subscript[xAct`AVF`\[Omega], 3]}],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"L", "[", 
     RowBox[{
      OverscriptBox["V", "1"], ",", 
      OverscriptBox["V", "2"]}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     OverscriptBox["V", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"L", "[", 
     RowBox[{
      OverscriptBox["V", "1"], ",", 
      OverscriptBox["V", "3"]}], "]"}], "\[Rule]", 
    OverscriptBox["V", "2"]}], ",", 
   RowBox[{
    RowBox[{"L", "[", 
     RowBox[{
      OverscriptBox["V", "2"], ",", 
      OverscriptBox["V", "3"]}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     OverscriptBox["V", "1"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The variable ",
 StyleBox["brackets", "Input",
  FontWeight->"Plain"],
 " contains the same thing, but with the numerical overscripts replaced by \
the corresponding dual 1-forms, which need not be indexed or ordered in the \
same way."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["brackets"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"L", "[", 
     RowBox[{
      OverscriptBox["V", 
       SubscriptBox["\[Omega]", "1"]], ",", 
      OverscriptBox["V", 
       SubscriptBox["\[Omega]", "2"]]}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     OverscriptBox["V", 
      SubscriptBox["\[Omega]", "3"]]}]}], ",", 
   RowBox[{
    RowBox[{"L", "[", 
     RowBox[{
      OverscriptBox["V", 
       SubscriptBox["\[Omega]", "1"]], ",", 
      OverscriptBox["V", 
       SubscriptBox["\[Omega]", "3"]]}], "]"}], "\[Rule]", 
    OverscriptBox["V", 
     SubscriptBox["\[Omega]", "2"]]}], ",", 
   RowBox[{
    RowBox[{"L", "[", 
     RowBox[{
      OverscriptBox["V", 
       SubscriptBox["\[Omega]", "2"]], ",", 
      OverscriptBox["V", 
       SubscriptBox["\[Omega]", "3"]]}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     OverscriptBox["V", 
      SubscriptBox["\[Omega]", "1"]]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "brackets", "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "II.d.7. ",
 StyleBox["makecoords", "Input",
  FontWeight->"Plain"],
 ": Format command for coordinates and partial derivatives"
}], "Subsubsection",
 PageWidth->WindowWidth],

Cell[TextData[{
 "Making a new ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " list:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"{", 
   RowBox[{"u", ",", "v", ",", "w"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"u", ",", "v", ",", "w"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "A special new set of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " (or a subset of the existing ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ") can be designated as ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " by the command:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Any new symbols introduced will be included automatically in ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 ", with ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " moving to the front."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["scalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "u", ",", "v", ",", "w"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["dscalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dx", ",", "dy", ",", "du", ",", "dv", ",", "dw"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Any pre-existing ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " which are not designated as ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " will have subscript partial derivative symbols defined for them using \
Format output. A set of replacement rules, ",
 StyleBox["topartials", "Input",
  FontWeight->"Plain"],
 ", is automatically generated to expand the exterior derivatives of these \
scalars in any AVF as follows:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["topartials"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"du", "\[Rule]", 
    RowBox[{
     RowBox[{"dy", " ", 
      SubscriptBox["u", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["u", "x"]}]}]}], ",", 
   RowBox[{"dv", "\[Rule]", 
    RowBox[{
     RowBox[{"dy", " ", 
      SubscriptBox["v", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["v", "x"]}]}]}], ",", 
   RowBox[{"dw", "\[Rule]", 
    RowBox[{
     RowBox[{"dy", " ", 
      SubscriptBox["w", "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox["w", "x"]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and the set ",
 StyleBox["topartials", "Input",
  FontWeight->"Plain"],
 " is automatically included in ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ", so that,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dscalars", "/.", "topartials"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dx", ",", "dy", ",", 
   RowBox[{
    RowBox[{"dy", " ", 
     SubscriptBox["u", "y"]}], "+", 
    RowBox[{"dx", " ", 
     SubscriptBox["u", "x"]}]}], ",", 
   RowBox[{
    RowBox[{"dy", " ", 
     SubscriptBox["v", "y"]}], "+", 
    RowBox[{"dx", " ", 
     SubscriptBox["v", "x"]}]}], ",", 
   RowBox[{
    RowBox[{"dy", " ", 
     SubscriptBox["w", "y"]}], "+", 
    RowBox[{"dx", " ", 
     SubscriptBox["w", "x"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["can also be accomplished by,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", "scalars", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dx", ",", "dy", ",", 
   RowBox[{
    RowBox[{"dy", " ", 
     SubscriptBox["u", "y"]}], "+", 
    RowBox[{"dx", " ", 
     SubscriptBox["u", "x"]}]}], ",", 
   RowBox[{
    RowBox[{"dy", " ", 
     SubscriptBox["v", "y"]}], "+", 
    RowBox[{"dx", " ", 
     SubscriptBox["v", "x"]}]}], ",", 
   RowBox[{
    RowBox[{"dy", " ", 
     SubscriptBox["w", "y"]}], "+", 
    RowBox[{"dx", " ", 
     SubscriptBox["w", "x"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["with appropriate closure of the second derivative.", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "These partial derivative expansions provide a more concise and readable \
notation for the output of some AVF expressions. Note that ",
 StyleBox["topartials", "Input",
  FontWeight->"Plain"],
 " is defined only for ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " introduced ",
 StyleBox["before",
  FontVariations->{"Underline"->True}],
 " the ",
 StyleBox["makecoords", "Input",
  FontWeight->"Plain"],
 " command is executed, and the transformations are implemented only for \
second partials. Furthermore, the subscript symbols are not recognized as \
derivatives by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for input."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[TextData[{
 "By using contraction with the vectors dual to the ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " basis forms, a particular partial derivative of an AVF (expressed in terms \
of ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 ") is selected by the operator ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", "sub"], TraditionalForm]]],
 ", where ",
 StyleBox["sub", "Input",
  FontWeight->"Plain"],
 " can be either the coordinate symbol, or an integer giving the position of \
the coordinate in the ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " list. This operator extends to arrays of AVFs as well. For instance,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["D", "x"], "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "^", "3"}], ",", " ", 
    RowBox[{"Sin", "[", "v", "]"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox["u", "2"], " ", 
    SubscriptBox["u", "x"]}], ",", 
   RowBox[{
    RowBox[{"Cos", "[", "v", "]"}], " ", 
    SubscriptBox["v", "x"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["D", "1"], "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"6", " ", "u", " ", 
     SubsuperscriptBox["u", "x", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["u", "2"], " ", 
     SubscriptBox["u", "\<\"xx\"\>"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sin", "[", "v", "]"}]}], " ", 
     SubsuperscriptBox["v", "x", "2"]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "v", "]"}], " ", 
     SubscriptBox["v", "\<\"xx\"\>"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["D", "y"], "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"6", " ", 
     SubscriptBox["u", "y"], " ", 
     SubsuperscriptBox["u", "x", "2"]}], "+", 
    RowBox[{"12", " ", "u", " ", 
     SubscriptBox["u", "x"], " ", 
     SubscriptBox["u", "\<\"xy\"\>"]}], "+", 
    RowBox[{"6", " ", "u", " ", 
     SubscriptBox["u", "y"], " ", 
     SubscriptBox["u", "\<\"xx\"\>"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["u", "2"], " ", 
     RowBox[{
      SuperscriptBox["u", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", "v", "]"}]}], " ", 
     SubscriptBox["v", "y"], " ", 
     SubsuperscriptBox["v", "x", "2"]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Sin", "[", "v", "]"}], " ", 
     SubscriptBox["v", "x"], " ", 
     SubscriptBox["v", "\<\"xy\"\>"]}], "-", 
    RowBox[{
     RowBox[{"Sin", "[", "v", "]"}], " ", 
     SubscriptBox["v", "y"], " ", 
     SubscriptBox["v", "\<\"xx\"\>"]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "v", "]"}], " ", 
     RowBox[{
      SuperscriptBox["v", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Because the D operator is generated by first taking an exterior derivative, \
it may not give the expected result on a differential form, especially an \
exact one,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["D", "x"], "[", 
  RowBox[{
   RowBox[{"u", " ", "dv"}], "+", 
   RowBox[{"v", " ", "du"}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["\<\
The selection of independent coordinates and dependent scalars can be changed \
at any time. For example, interchanging roles,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"u", ",", "v", ",", "w"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"u", ",", "v", ",", "w"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["scalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"u", ",", "v", ",", "w", ",", "x", ",", "y"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["dscalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"du", ",", "dv", ",", "dw", ",", "dx", ",", "dy"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dscalars", "/.", "topartials"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"du", ",", "dv", ",", "dw", ",", 
   RowBox[{
    RowBox[{"dw", " ", 
     SubscriptBox["x", "w"]}], "+", 
    RowBox[{"dv", " ", 
     SubscriptBox["x", "v"]}], "+", 
    RowBox[{"du", " ", 
     SubscriptBox["x", "u"]}]}], ",", 
   RowBox[{
    RowBox[{"dw", " ", 
     SubscriptBox["y", "w"]}], "+", 
    RowBox[{"dv", " ", 
     SubscriptBox["y", "v"]}], "+", 
    RowBox[{"du", " ", 
     SubscriptBox["y", "u"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The variable ",
 StyleBox["depend", "Input",
  FontWeight->"Plain"],
 " can be used to make any other variable into a function of ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " with a similar output representation for its first and second derivatives; \
e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G", "[", "depend", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"G", "[", 
  RowBox[{"u", ",", "v", ",", "w"}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dw", " ", 
   SubscriptBox["G", "w"]}], "+", 
  RowBox[{"dv", " ", 
   SubscriptBox["G", "v"]}], "+", 
  RowBox[{"du", " ", 
   SubscriptBox["G", "u"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "which is a bit easier to scan than standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"G", "[", 
   RowBox[{"u", ",", "v", ",", "w"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dw", " ", 
   RowBox[{
    SuperscriptBox["G", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"u", ",", "v", ",", "w"}], "]"}]}], "+", 
  RowBox[{"dv", " ", 
   RowBox[{
    SuperscriptBox["G", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"u", ",", "v", ",", "w"}], "]"}]}], "+", 
  RowBox[{"du", " ", 
   RowBox[{
    SuperscriptBox["G", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"u", ",", "v", ",", "w"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
and considerably improves the looks of the spherical Laplacian derived above\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lsph", "=", 
  FractionBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Psi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Psi]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ")"}]}], 
   SuperscriptBox["R", "2"]]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Psi]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ")"}]}], 
  SuperscriptBox["R", "2"]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Theta]", ",", "\[Phi]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Lsph"], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
      SubscriptBox["\[Psi]", "\<\"\[Phi]\[Phi]\"\>"]}], "+", 
     RowBox[{
      RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["\[Psi]", "\[Theta]"]}], "+", 
     SubscriptBox["\[Psi]", "\<\"\[Theta]\[Theta]\"\>"]}], ")"}]}], 
  SuperscriptBox["R", "2"]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "This format is especially useful for Lie differentiation when the vector \
components are expressed as functions of ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell["\<\
Recalling the curvature on the spheroid from section ?? above,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalOmega]", "\[Theta]\[Phi]"], "=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"k", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"3", "/", "2"}]]]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "we want its Lie derivative in the coordinate basis, with respect to a \
vector ",
 StyleBox["vec", "Input",
  FontWeight->"Plain"]
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", "=", 
  RowBox[{"{", 
   RowBox[{
    OverscriptBox["v", "\[Theta]"], ",", 
    OverscriptBox["v", "\[Phi]"]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["v", "\[Theta]"], ",", 
   OverscriptBox["v", "\[Phi]"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeforms", "[", 
  RowBox[{"{", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "d\[Theta]", ",", "d\[Phi]", ",", "du", ",", "dv", ",", "dw", ",", "dx", 
   ",", "dy"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<DifferentiationOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DifferentiateHeads\>\"", "\[Rule]", "False"}], "}"}]}], 
   "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"{", 
   RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
    OverscriptBox["v", "\[Theta]"], ",", 
    OverscriptBox["v", "\[Phi]"]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Theta]", ",", "\[Phi]", ",", 
   OverscriptBox["v", "\[Theta]"], ",", 
   OverscriptBox["v", "\[Phi]"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Theta]", ",", "\[Phi]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["drules"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    OverscriptBox["dv", "\[Theta]"], "\[Rule]", 
    RowBox[{
     RowBox[{"d\[Phi]", " ", 
      SubscriptBox[
       OverscriptBox["v", "\[Theta]"], "\[Phi]"]}], "+", 
     RowBox[{"d\[Theta]", " ", 
      SubscriptBox[
       OverscriptBox["v", "\[Theta]"], "\[Theta]"]}]}]}], ",", 
   RowBox[{
    OverscriptBox["dv", "\[Phi]"], "\[Rule]", 
    RowBox[{
     RowBox[{"d\[Phi]", " ", 
      SubscriptBox[
       OverscriptBox["v", "\[Phi]"], "\[Phi]"]}], "+", 
     RowBox[{"d\[Theta]", " ", 
      SubscriptBox[
       OverscriptBox["v", "\[Phi]"], "\[Theta]"]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lie", "[", 
  RowBox[{"vec", ",", 
   SubscriptBox["\[CapitalOmega]", "\[Theta]\[Phi]"]}], "]"}]], "Input",
 PageBreakAbove->False],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", "k", " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
    OverscriptBox["v", "\[Theta]"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"5", "/", "2"}]]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["k", "2"], " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
    OverscriptBox["v", "\[Theta]"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"5", "/", "2"}]]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
    OverscriptBox["v", "\[Theta]"], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"3", "/", "2"}]]], "-", 
  FractionBox[
   RowBox[{"k", " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
    OverscriptBox["v", "\[Theta]"], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"3", "/", "2"}]]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}], " ", 
    SubscriptBox[
     OverscriptBox["v", "\[Phi]"], "\[Phi]"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"3", "/", "2"}]]], "-", 
  FractionBox[
   RowBox[{"k", " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}], " ", 
    SubscriptBox[
     OverscriptBox["v", "\[Phi]"], "\[Phi]"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"3", "/", "2"}]]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}], " ", 
    SubscriptBox[
     OverscriptBox["v", "\[Theta]"], "\[Theta]"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"3", "/", "2"}]]], "-", 
  FractionBox[
   RowBox[{"k", " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}], " ", 
    SubscriptBox[
     OverscriptBox["v", "\[Theta]"], "\[Theta]"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"3", "/", "2"}]]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Trig", "->", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
       OverscriptBox["v", "\[Theta]"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "k", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"k", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["v", "\[Phi]"], "\[Phi]"], "+", 
         SubscriptBox[
          OverscriptBox["v", "\[Theta]"], "\[Theta]"]}], ")"}]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"5", "/", "2"}]]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sph", "=", 
  RowBox[{"%", "/.", 
   RowBox[{"k", "->", "0"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     OverscriptBox["v", "\[Theta]"]}], "+", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["v", "\[Phi]"], "\[Phi]"], "+", 
       SubscriptBox[
        OverscriptBox["v", "\[Theta]"], "\[Theta]"]}], ")"}]}]}], 
   ")"}]}]], "Output"]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", 
     RowBox[{"vector", 
      StyleBox[
       RowBox[{" ", 
        StyleBox[" ",
         FontSize->14]}]], "(", " ", 
      RowBox[{
       OverscriptBox["v", "\[Theta]"], 
       RowBox[{
        SubscriptBox["\[PartialD]", 
         RowBox[{"\[Theta]", " "}]], 
        RowBox[{"+", " ", 
         OverscriptBox["v", "\[Phi]"]}]}], 
       SubscriptBox["\[PartialD]", "\[Phi]"]}], ")"}], "  ", "making", " ", 
     "these", " ", "expressions", " ", "vanish", " ", "would", " ", "leave", 
     " ", 
     SubscriptBox["\[CapitalOmega]", "\[Theta]\[Phi]"], " ", 
     RowBox[{"unchanged", ".", "\n", "An"}], " ", "obvious", " ", "solution", 
     " ", "from", " ", "symmetry", " ", "in", " ", "both", " ", "cases", " ", 
     "is", " ", "the", " ", "Killing", " ", 
     RowBox[{"vector", ":", " ", 
      RowBox[{
       OverscriptBox["v", "\[Theta]"], 
       FormBox["",
        TraditionalForm]}]}]}], "=", " ", "0"}], " ", ",", " ", 
   RowBox[{
    RowBox[{
     OverscriptBox["v", "\[Phi]"], 
     FormBox["",
      TraditionalForm]}], "=", " ", "1.", " "}]}], TraditionalForm]], "Text"],

Cell[TextData[{
 "\nThe ",
 StyleBox["makecoords", "Input",
  FontWeight->"Plain"],
 " facility  can be useful also for Hamiltonian mechanics. For a simple \
example using canonical coordinates in two dimensions:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"canonical", "=", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", "canonical", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["dscalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dp1", ",", "dp2", ",", "dq1", ",", "dq2"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Jose: Variable \[Omega] changed to ",
 StyleBox["om", "Input",
  FontWeight->"Plain"],
 " to avoid loading values into the AVF variable \[Omega]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"om", "=", 
  RowBox[{
   RowBox[{"p1", " ", "dq1"}], "+", 
   RowBox[{"p2", " ", "dq2"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dq1", " ", "p1"}], "+", 
  RowBox[{"dq2", " ", "p2"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dom", "=", 
  RowBox[{"d", "[", "om", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dp1", "\[Wedge]", "dq1"}], "+", 
  RowBox[{"dp2", "\[Wedge]", "dq2"}]}]], "Output"]
}, Open  ]],

Cell["A convenience vector,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData["vec1"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["v1", "1"], ",", 
   SubscriptBox["v1", "2"], ",", 
   SubscriptBox["v1", "3"], ",", 
   SubscriptBox["v1", "4"]}], "}"}]], "Output"]
}, Open  ]],

Cell["can be edited to adapt it,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", "=", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["vp", "1"], ",", 
    SubscriptBox["vp", "2"], ",", 
    SubscriptBox["vq", "1"], ",", 
    SubscriptBox["vq", "2"]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["vp", "1"], ",", 
   SubscriptBox["vp", "2"], ",", 
   SubscriptBox["vq", "1"], ",", 
   SubscriptBox["vq", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", "\[SmallCircle]", "dscalars"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["vp", "1"], ",", 
   SubscriptBox["vp", "2"], ",", 
   SubscriptBox["vq", "1"], ",", 
   SubscriptBox["vq", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Adding in the vector components and an arbitrary Hamiltonian function to \
\"scalars\",\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"Join", "[", 
   RowBox[{"scalars", ",", "vec", ",", 
    RowBox[{"{", "H", "}"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2", ",", 
   SubscriptBox["vp", "1"], ",", 
   SubscriptBox["vp", "2"], ",", 
   SubscriptBox["vq", "1"], ",", 
   SubscriptBox["vq", "2"], ",", "H"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "To avoid including previous ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", 
  RowBox[{"{", "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and now introduce ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", "canonical", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["drules"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"dH", "\[Rule]", 
    RowBox[{
     RowBox[{"dq2", " ", 
      SubscriptBox["H", "q2"]}], "+", 
     RowBox[{"dq1", " ", 
      SubscriptBox["H", "q1"]}], "+", 
     RowBox[{"dp2", " ", 
      SubscriptBox["H", "p2"]}], "+", 
     RowBox[{"dp1", " ", 
      SubscriptBox["H", "p1"]}]}]}], ",", 
   RowBox[{
    SubscriptBox["dvp", "1"], "\[Rule]", 
    RowBox[{
     RowBox[{"dq2", " ", 
      SubscriptBox[
       SubscriptBox["vp", "1"], "q2"]}], "+", 
     RowBox[{"dq1", " ", 
      SubscriptBox[
       SubscriptBox["vp", "1"], "q1"]}], "+", 
     RowBox[{"dp2", " ", 
      SubscriptBox[
       SubscriptBox["vp", "1"], "p2"]}], "+", 
     RowBox[{"dp1", " ", 
      SubscriptBox[
       SubscriptBox["vp", "1"], "p1"]}]}]}], ",", 
   RowBox[{
    SubscriptBox["dvp", "2"], "\[Rule]", 
    RowBox[{
     RowBox[{"dq2", " ", 
      SubscriptBox[
       SubscriptBox["vp", "2"], "q2"]}], "+", 
     RowBox[{"dq1", " ", 
      SubscriptBox[
       SubscriptBox["vp", "2"], "q1"]}], "+", 
     RowBox[{"dp2", " ", 
      SubscriptBox[
       SubscriptBox["vp", "2"], "p2"]}], "+", 
     RowBox[{"dp1", " ", 
      SubscriptBox[
       SubscriptBox["vp", "2"], "p1"]}]}]}], ",", 
   RowBox[{
    SubscriptBox["dvq", "1"], "\[Rule]", 
    RowBox[{
     RowBox[{"dq2", " ", 
      SubscriptBox[
       SubscriptBox["vq", "1"], "q2"]}], "+", 
     RowBox[{"dq1", " ", 
      SubscriptBox[
       SubscriptBox["vq", "1"], "q1"]}], "+", 
     RowBox[{"dp2", " ", 
      SubscriptBox[
       SubscriptBox["vq", "1"], "p2"]}], "+", 
     RowBox[{"dp1", " ", 
      SubscriptBox[
       SubscriptBox["vq", "1"], "p1"]}]}]}], ",", 
   RowBox[{
    SubscriptBox["dvq", "2"], "\[Rule]", 
    RowBox[{
     RowBox[{"dq2", " ", 
      SubscriptBox[
       SubscriptBox["vq", "2"], "q2"]}], "+", 
     RowBox[{"dq1", " ", 
      SubscriptBox[
       SubscriptBox["vq", "2"], "q1"]}], "+", 
     RowBox[{"dp2", " ", 
      SubscriptBox[
       SubscriptBox["vq", "2"], "p2"]}], "+", 
     RowBox[{"dp1", " ", 
      SubscriptBox[
       SubscriptBox["vq", "2"], "p1"]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["The Hamiltonian flow equations read,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "\[SmallCircle]", "dom"}], "+", 
  RowBox[{"da", "[", "H", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dq1", " ", 
   SubscriptBox["vp", "1"]}], "+", 
  RowBox[{"dq2", " ", 
   SubscriptBox["vp", "2"]}], "-", 
  RowBox[{"dp1", " ", 
   SubscriptBox["vq", "1"]}], "-", 
  RowBox[{"dp2", " ", 
   SubscriptBox["vq", "2"]}], "+", 
  RowBox[{"dq2", " ", 
   SubscriptBox["H", "q2"]}], "+", 
  RowBox[{"dq1", " ", 
   SubscriptBox["H", "q1"]}], "+", 
  RowBox[{"dp2", " ", 
   SubscriptBox["H", "p2"]}], "+", 
  RowBox[{"dp1", " ", 
   SubscriptBox["H", "p1"]}]}]], "Output"]
}, Open  ]],

Cell["and taking the independent components,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "=", 
  RowBox[{"setzero", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"%", ",", "dscalars"}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["vq", "1"]}], "+", 
     SubscriptBox["H", "p1"]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["vq", "2"]}], "+", 
     SubscriptBox["H", "p2"]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SubscriptBox["vp", "1"], "+", 
     SubscriptBox["H", "q1"]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SubscriptBox["vp", "2"], "+", 
     SubscriptBox["H", "q2"]}], "\[Equal]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["The Hamiltonian for a pair of coupled oscillators could be,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"explicit", "=", 
  RowBox[{"{", 
   RowBox[{"H", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", " ", 
         RowBox[{
          SuperscriptBox["p1", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", "m"}], ")"}]}], "+", 
       RowBox[{"k", " ", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"q1", "-", "L"}], ")"}], "2"], "/", "2"}]}], "+", 
       RowBox[{"k", " ", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"q2", "+", "L"}], ")"}], "2"], "/", "2"}]}], "+", 
       RowBox[{
        RowBox[{"\[Epsilon]", "/", "2"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"q1", "-", "q2"}], ")"}], "2"]}]}]}], "]"}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"H", "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["p1", "2"], "+", 
        SuperscriptBox["p2", "2"]}], 
       RowBox[{"2", " ", "m"}]], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "k", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"q1", "-", "L"}], ")"}], "2"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "k", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"q2", "+", "L"}], ")"}], "2"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[Epsilon]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"q1", "-", "q2"}], ")"}], "2"]}]}]}], "]"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "=", 
  RowBox[{"eqns", "/.", "explicit"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["p1", "m"], "-", 
     SubscriptBox["vq", "1"]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["p2", "m"], "-", 
     SubscriptBox["vq", "2"]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"k", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "L"}], "+", "q1"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"q1", "-", "q2"}], ")"}], " ", "\[Epsilon]"}], "+", 
     SubscriptBox["vp", "1"]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"k", " ", 
      RowBox[{"(", 
       RowBox[{"L", "+", "q2"}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"q1", "-", "q2"}], ")"}], " ", "\[Epsilon]"}], "+", 
     SubscriptBox["vp", "2"]}], "\[Equal]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equilibrium", "=", 
  RowBox[{"eqns", "/.", 
   RowBox[{"Thread", "[", 
    RowBox[{"vec", "->", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["p1", "m"], "\[Equal]", "0"}], ",", 
   RowBox[{
    FractionBox["p2", "m"], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"k", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "L"}], "+", "q1"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"q1", "-", "q2"}], ")"}], " ", "\[Epsilon]"}]}], "\[Equal]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"k", " ", 
      RowBox[{"(", 
       RowBox[{"L", "+", "q2"}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"q1", "-", "q2"}], ")"}], " ", "\[Epsilon]"}]}], "\[Equal]", 
    "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{"%", ",", "canonical"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p1", "\[Rule]", "0"}], ",", 
   RowBox[{"p2", "\[Rule]", "0"}], ",", 
   RowBox[{"q1", "\[Rule]", 
    FractionBox[
     RowBox[{"k", " ", "L"}], 
     RowBox[{"k", "+", 
      RowBox[{"2", " ", "\[Epsilon]"}]}]]}], ",", 
   RowBox[{"q2", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"k", " ", "L"}], 
      RowBox[{"k", "+", 
       RowBox[{"2", " ", "\[Epsilon]"}]}]]}]}]}], "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["II.d.8. Clean up", "Subsubsection"],

Cell[BoxData[
 RowBox[{"makeclear", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["ModifiedGlobalVariables"], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["III. Examples", "Section",
 FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell["\<\
III.a. A toy geometry problem -- Almost trivial, but not quite\
\>", "Subsection",
 PageBreakAbove->True],

Cell["This is taken from the file AVF_Demo.nb.", "Text"],

Cell[TextData[{
 "This problem shows how ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands work together, and further illustrates the use of ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[TextData[{
 "In cylindrical coordinates {r,\[Phi],z}, put r = R sin(\[Theta]) and z = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"(", 
     RowBox[{"1", " ", "-", " ", "k"}], ")"}]], TraditionalForm]]],
 " R cos(\[Theta]), so that (1 - k) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox[
     SuperscriptBox["r", "2"],
     TraditionalForm], "+", 
    SuperscriptBox["z", "2"]}], TraditionalForm]]],
 "= (1 - k) ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["R", "2"], TraditionalForm]]],
 ",  a spheroid with equatorial radius R and polar radius ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"(", 
     RowBox[{"1", " ", "-", " ", "k"}], ")"}]], TraditionalForm]]],
 "R ; i.e., prolate for k < 0 , spherical for k=0, oblate for 0 < k < 1 , a \
disk of radius R for k = 1."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell["\<\
The independent coordinates will be \[Theta] and \[Phi], and we also \
introduce three non-exact basis forms for later use .\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"{", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Theta]", ",", "\[Phi]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeforms", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], ",", 
    SubscriptBox["\[Omega]", "2"], ",", 
    SubscriptBox["\[Omega]", "3"]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"], ",", "d\[Theta]", ",", "d\[Phi]"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Previously, the variables r and z were in ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ", but are not there now, so can be assigned values;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"r", "=", 
  RowBox[{"R", " ", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "\n", 
 RowBox[{"z", "=", 
  RowBox[{
   SqrtBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "k"}], ")"}]], "R", " ", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"R", " ", 
  RowBox[{"Sin", "[", "\[Theta]", "]"}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"1", "-", "k"}]], " ", "R", " ", 
  RowBox[{"Cos", "[", "\[Theta]", "]"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Since k and R are not members of any fundamental list, they are treated as \
constant parameters.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"dr", "=", 
  RowBox[{"d", "[", "r", "]"}]}], "\n", 
 RowBox[{"dz", "=", 
  RowBox[{"d", "[", "z", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"d\[Theta]", " ", "R", " ", 
  RowBox[{"Cos", "[", "\[Theta]", "]"}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "d\[Theta]"}], " ", 
  SqrtBox[
   RowBox[{"1", "-", "k"}]], " ", "R", " ", 
  RowBox[{"Sin", "[", "\[Theta]", "]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 StyleBox["AVF",
  FontSlant->"Italic"],
 " knows that d\[Theta] and d\[Phi] are 1-forms, but ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " doesn't, so the Euclidean line element in cylindrical coordinates can be \
input as:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["dr", "2"], "+", 
    SuperscriptBox["dz", "2"], "+", 
    RowBox[{
     SuperscriptBox["r", "2"], 
     SuperscriptBox["d\[Phi]", "2"]}]}], "/.", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], "->", 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["R", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d\[Theta]", "2"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d\[Phi]", "2"], "-", 
       RowBox[{
        SuperscriptBox["d\[Theta]", "2"], " ", "k"}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 StyleBox["Collect[]", "Input",
  FontWeight->"Plain"],
 " command,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["d\[Theta]", "2"], ",", 
     SuperscriptBox["d\[Phi]", "2"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["d\[Phi]", "2"], " ", 
   SuperscriptBox["R", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
  RowBox[{
   SuperscriptBox["d\[Theta]", "2"], " ", 
   SuperscriptBox["R", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"k", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "showing the induced metric on the spheroid has orthonormal basis forms,  \
R",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"k", " ", 
      FormBox[
       SuperscriptBox["sin", "2"],
       TraditionalForm], 
      RowBox[{"(", "\[Theta]", ")"}]}]}]], TraditionalForm]]],
 "d\[Theta]  and  R sin(\[Theta]) d\[Phi], which can be identified with the \
non-exact basis forms, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "1"], TraditionalForm]]],
 " and  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "2"], TraditionalForm]]],
 " . Here again we use replacement rules, not assignments, which are \
forbidden for the members of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ". It's actually much more useful to express the relations this way, so that \
transformations between the orthonormal and coordinate bases are easily made \
in both directions. "
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tocoords", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "->", 
     RowBox[{"R", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         RowBox[{
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "^", "2"}]}]}]], 
      "d\[Theta]"}]}], ",", 
    RowBox[{
     SubscriptBox["\[Omega]", 
      RowBox[{"2", " "}]], "->", 
     RowBox[{"R", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "d\[Phi]"}]}]}], 
   "}"}]}]], "Input",
 PageBreakAbove->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Rule]", 
    RowBox[{"d\[Theta]", " ", "R", " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"k", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], ",", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Rule]", 
    RowBox[{"d\[Phi]", " ", "R", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The rules can be turned into equations to solve for the inverse \
transformation. Writing equations does not involve assignments, nor does \
their solution.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "=", 
  RowBox[{"tocoords", "/.", 
   RowBox[{"Rule", "->", "Equal"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Equal]", 
    RowBox[{"d\[Theta]", " ", "R", " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"k", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]}], ",", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Equal]", 
    RowBox[{"d\[Phi]", " ", "R", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"toortho", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{"eqns", ",", "dscalars"}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"d\[Theta]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[Omega]", "1"], 
     RowBox[{"R", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}], ",", 
   RowBox[{"d\[Phi]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["\[Omega]", "2"]}], "R"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "In a 2-dim space, the only independent connection form is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "12"], TraditionalForm]]],
 ". Since ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", 
    RowBox[{"3", " "}]], TraditionalForm]]],
 "is already in the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list, that symbol will be used for it temporarily. The Cartan structure \
equations,  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["d\[Omega]", "i"], TraditionalForm]]],
 " + ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "ij"], TraditionalForm]]],
 "\[Wedge]",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "j"], TraditionalForm]]],
 " = 0 , then can be expressed by the replacement rules:"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->Automatic,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"structure", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["d\[Omega]", "1"], "->", 
     RowBox[{
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], ",", 
    RowBox[{
     SubscriptBox["d\[Omega]", "2"], "->", 
     RowBox[{
      SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "1"]}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["d\[Omega]", "1"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "2"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "1"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The transformations ",
 StyleBox["toortho", "Input",
  FontWeight->"Plain"],
 " can also be entered as ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ", so that everything, including derivatives of functions, will be converted \
automatically to the orthobasis."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", 
  RowBox[{"Join", "[", 
   RowBox[{"structure", ",", "toortho"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["d\[Omega]", "1"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "2"], "\[Rule]", 
    RowBox[{
     SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "1"]}]}], ",", 
   RowBox[{"d\[Theta]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[Omega]", "1"], 
     RowBox[{"R", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}], ",", 
   RowBox[{"d\[Phi]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["\[Omega]", "2"]}], "R"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Because no drule has been established for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "3"], TraditionalForm]]],
 ", these ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " are not properly closed. Imposing closure can be used to determine ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "3"], TraditionalForm]]],
 "; i.e., for consistency the following conditions must vanish,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conditions", "=", 
  RowBox[{"da", "[", 
   RowBox[{"da", "[", "scalars", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "3"]}], 
    RowBox[{"R", " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"k", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}]}], 
      RowBox[{
       SuperscriptBox["R", "2"], " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         RowBox[{"k", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}]}], "R"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Vanishing of the first condition requires ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", 
    RowBox[{"3", " "}]], TraditionalForm]]],
 "proportional to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "2"], TraditionalForm]]],
 "with no component on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "1"], TraditionalForm]]],
 ". So we can safely factor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "1"], TraditionalForm]]],
 " out of the second condition, and equate the result to zero."
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"factor", "[", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], ",", 
    RowBox[{"conditions", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "==", "0"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["\[Omega]", "2"]}], 
     RowBox[{
      SuperscriptBox["R", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
     SubscriptBox["\[Omega]", "3"]}], "R"]}], "\[Equal]", "0"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soln", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{"%", ",", 
     SubscriptBox["\[Omega]", "3"]}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "3"], "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["\[Omega]", "2"]}], 
     RowBox[{"R", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Put this into ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ":"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newdrules", "=", 
  RowBox[{"expand", "[", 
   RowBox[{"drules", "/.", "soln"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["d\[Omega]", "1"], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "2"], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "2"]}]}], 
     RowBox[{"R", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}], ",", 
   RowBox[{"d\[Theta]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[Omega]", "1"], 
     RowBox[{"R", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}], ",", 
   RowBox[{"d\[Phi]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["\[Omega]", "2"]}], "R"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and the obvious fact that  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "1"], TraditionalForm]]],
 " is closed appears explicitly. Now establish these as the ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", "newdrules", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["d\[Omega]", "1"], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "2"], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "2"]}]}], 
     RowBox[{"R", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}], ",", 
   RowBox[{"d\[Theta]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[Omega]", "1"], 
     RowBox[{"R", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}], ",", 
   RowBox[{"d\[Phi]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["\[Omega]", "2"]}], "R"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Note: the last two statements could be combined into one (without defining ",
 StyleBox["newdrules", "Input",
  FontWeight->"Plain"],
 "), but ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " is Protected, so it can't be accomplished just by assignment without using \
",
 StyleBox["makedrules[]", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell["Checking for consistency:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", 
  RowBox[{"da", "[", "scalars", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", 
  RowBox[{"da", "[", "forms", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Set the connection form equal to the solution for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "3"], TraditionalForm]]],
 ", and find the curvature 2-form expressed in orthobasis:"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Omega]", "12"], "=", 
  RowBox[{
   SubscriptBox["\[Omega]", "3"], "/.", "soln"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
    SubscriptBox["\[Omega]", "2"]}], 
   RowBox[{"R", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalOmega]", "12"], "=", 
  RowBox[{"da", "[", 
   SubscriptBox["\[Omega]", "12"], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"k", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}]}], 
    RowBox[{
     SuperscriptBox["R", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], "2"]}]]}], 
  "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cot", "[", "\[Theta]", "]"}], "2"], " ", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "2"]}]}], 
   RowBox[{
    SuperscriptBox["R", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "2"]}]}], 
   RowBox[{
    SuperscriptBox["R", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}]}]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalOmega]", "12"], "=", 
  RowBox[{"Simplify", "[", "%", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "2"]}]}], 
   RowBox[{
    SuperscriptBox["R", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"k", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
     "2"]}]]}]], "Output"]
}, Open  ]],

Cell["The same quantity in the coordinate basis:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalOmega]", "\[Theta]\[Phi]"], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"expand", "[", 
     RowBox[{
      SubscriptBox["\[CapitalOmega]", "12"], "/.", "tocoords"}], "]"}], ",", 
    RowBox[{"Trig", "->", "False"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], 
    RowBox[{"3", "/", "2"}]]]}]], "Output"]
}, Open  ]],

Cell["\<\
Interpretation of the following special values (as products of the Gaussian \
curvatures) is much simpler in the orthonormal basis than in the coordinate \
basis.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell["At the poles:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalOmega]", "12"], "/.", 
  RowBox[{"\[Theta]", "->", "0"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "2"]}]}], 
   SuperscriptBox["R", "2"]]}]], "Output"]
}, Open  ]],

Cell["At the equator:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalOmega]", "12"], "/.", 
  RowBox[{"\[Theta]", "->", 
   RowBox[{"Pi", "/", "2"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
    SuperscriptBox["R", "2"]}]]}]], "Output"]
}, Open  ]],

Cell["And for a sphere:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalOmega]", "12"], "/.", 
  RowBox[{"k", "->", "0"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
   SubscriptBox["\[Omega]", "2"]}], 
  SuperscriptBox["R", "2"]]], "Output"]
}, Open  ]],

Cell["In 2-dim the Bianchi identity is trivial:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", 
  SubscriptBox["\[CapitalOmega]", "12"], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "The surface element in the orthonormal basis ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox[
     RowBox[{"is", "  ", 
      SubscriptBox["\[Omega]", "1"]}],
     TraditionalForm], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], TraditionalForm]]],
 ", while in the coordinate basis:"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expand", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], "/.", "tocoords"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["R", "2"], " ", 
  RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
  SqrtBox[
   RowBox[{"1", "-", 
    RowBox[{"k", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]], " ", 
  RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The area of a polar cap, where ",
 StyleBox["pa", "Input",
  FontWeight->"Plain"],
 " is the polar angle or colatitude, is (Jose: The following few definitions \
have been deactivated because they take a long time and demonstrate nothing \
of ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 "):"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->Automatic,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"polarcap", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["R", "2"], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", "pa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", 
       RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 Evaluatable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"98.05741700000002`", ",", 
   RowBox[{"ConditionalExpression", "[", 
    RowBox[{
     RowBox[{"2", " ", "\[Pi]", " ", 
      SuperscriptBox["R", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox["k"]}], "-", 
           RowBox[{"Log", "[", "2", "]"}], "+", 
           RowBox[{"k", " ", 
            RowBox[{"Log", "[", "2", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"1", "+", 
              SqrtBox["k"]}], "]"}]}]}], 
          RowBox[{"4", " ", 
           SqrtBox["k"]}]]}], "+", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"4", " ", 
           SqrtBox["k"]}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SqrtBox["2"]}], " ", 
            SqrtBox["k"], " ", 
            RowBox[{"Cos", "[", "pa", "]"}], " ", 
            SqrtBox[
             RowBox[{"2", "-", "k", "+", 
              RowBox[{"k", " ", 
               RowBox[{"Cos", "[", 
                RowBox[{"2", " ", "pa"}], "]"}]}]}]]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{
               SqrtBox["2"], " ", 
               SqrtBox["k"], " ", 
               RowBox[{"Cos", "[", "pa", "]"}]}], "+", 
              SqrtBox[
               RowBox[{"2", "-", "k", "+", 
                RowBox[{"k", " ", 
                 RowBox[{"Cos", "[", 
                  RowBox[{"2", " ", "pa"}], "]"}]}]}]]}], "]"}]}]}], 
          ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"k", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "pa", "]"}], "2"]}], "\[NotElement]", 
         "Reals"}], "||", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"k", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "pa", "]"}], "2"]}], "]"}], "\[LessEqual]", 
         "1"}]}], ")"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", "k", "+", 
             RowBox[{"k", " ", 
              RowBox[{"Cos", "[", 
               RowBox[{"2", " ", "pa"}], "]"}]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"Csc", "[", "pa", "]"}], "2"]}], "k"], "\[NotElement]", 
         "Reals"}], "||", 
        RowBox[{
         RowBox[{"Re", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", "k", "+", 
              RowBox[{"k", " ", 
               RowBox[{"Cos", "[", 
                RowBox[{"2", " ", "pa"}], "]"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"Csc", "[", "pa", "]"}], "2"]}], "k"], "]"}], 
         "\[GreaterEqual]", "0"}], "||", 
        RowBox[{
         RowBox[{"Re", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "-", "k", "+", 
              RowBox[{"k", " ", 
               RowBox[{"Cos", "[", 
                RowBox[{"2", " ", "pa"}], "]"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"Csc", "[", "pa", "]"}], "2"]}], "k"], "]"}], 
         "\[LessEqual]", 
         RowBox[{"-", "2"}]}]}], ")"}], "&&", 
      RowBox[{
       RowBox[{"2", "+", 
        RowBox[{"k", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "pa"}], "]"}]}]}], "\[NotEqual]", "k"}]}]}], 
    "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["and this gives the familiar result for a sphere;", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"First", "@", "polarcap"}], ",", 
    RowBox[{"k", "->", "0"}]}], "]"}], "]"}]], "Input",
 Evaluatable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "\[Pi]", " ", 
  SuperscriptBox["R", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"Cos", "[", "pa", "]"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["The total surface area for any spheroid is,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"area", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"polarcap", "/.", 
    RowBox[{"pa", "->", "Pi"}]}], "]"}]}]], "Input",
 Evaluatable->False],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", " ", 
   SuperscriptBox["R", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SqrtBox["k"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        SqrtBox["k"]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        SqrtBox["k"]}], "]"}]}]}], ")"}]}], 
  SqrtBox["k"]]], "Output"]
}, Open  ]],

Cell["For the sphere:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"area", ",", 
   RowBox[{"k", "->", "0"}]}], "]"}]], "Input",
 Evaluatable->False],

Cell[BoxData[
 RowBox[{"4", " ", "\[Pi]", " ", 
  SuperscriptBox["R", "2"]}]], "Output"]
}, Open  ]],

Cell["For the flat disk:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"area", ",", 
   RowBox[{"k", "->", "1"}]}], "]"}]], "Input",
 Evaluatable->False],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]", " ", 
  SuperscriptBox["R", "2"]}]], "Output"]
}, Open  ]],

Cell["\<\
In this simple 2-dim. case, the Hodge star operation is easily defined in the \
orthonormal basis.\
\>", "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"toduals", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "->", 
     SubscriptBox["\[Omega]", "2"]}], ",", 
    RowBox[{
     SubscriptBox["\[Omega]", "2"], "->", 
     RowBox[{"-", 
      SubscriptBox["\[Omega]", "1"]}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Rule]", 
    SubscriptBox["\[Omega]", "2"]}], ",", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Rule]", 
    RowBox[{"-", 
     SubscriptBox["\[Omega]", "1"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "For a function, ",
 StyleBox["\[Psi][\[Theta],\[Phi]]", "Input",
  FontWeight->"Plain"],
 " , with exterior derivative in the coordinate basis,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"\[Psi]", "[", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d\[Phi]", " ", 
   RowBox[{
    SuperscriptBox["\[Psi]", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
  RowBox[{"d\[Theta]", " ", 
   RowBox[{
    SuperscriptBox["\[Psi]", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "the  ",
 StyleBox["*d[\[Psi]]", "Input",
  FontWeight->"Plain"],
 "  operation is given by"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->Automatic,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"da", "[", 
   RowBox[{"\[Psi]", "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "]"}], "/.", 
  "toduals"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
     SubscriptBox["\[Omega]", "1"], " ", 
     RowBox[{
      SuperscriptBox["\[Psi]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "R"]}], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["\[Omega]", "2"], " ", 
    RowBox[{
     SuperscriptBox["\[Psi]", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], 
   RowBox[{"R", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"k", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]}]]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and the Laplacian on the spheroid, ",
 StyleBox["d*d[\[Psi]]", "Input",
  FontWeight->"Plain"],
 ", is the factor of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", 
     RowBox[{"2", " "}]]}], TraditionalForm]]],
 "in the next expression,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"da", "[", "%", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["R", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"k", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], "2"]}]], 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], "+", 
        RowBox[{"k", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{"k", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}]}]}], 
       ")"}], " ", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["which becomes the usual expression for a sphere,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"k", "->", "0"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Psi]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Psi]", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ")"}]}], 
  SuperscriptBox["R", "2"]]], "Output"]
}, Open  ]],

Cell["Clean up:", "Text"],

Cell[BoxData[
 RowBox[{"makeclear", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["ModifiedGlobalVariables"], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.b. The quaternion algebra", "Subsection"],

Cell["This is taken from the file AVF_Commands.nb.", "Text"],

Cell[CellGroupData[{

Cell["III.b.1. Establishing the quaternion algebra H", "Subsubsection"],

Cell[TextData[{
 "Introduce a list of four elements, where the initial element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Sigma]", "0"], TraditionalForm]]],
 " is the identity."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeelements", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Sigma]", "0"], ",", 
    SubscriptBox["\[Sigma]", "1"], ",", 
    SubscriptBox["\[Sigma]", "2"], ",", 
    SubscriptBox["\[Sigma]", "3"]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], ",", 
   SubscriptBox["\[Sigma]", "1"], ",", 
   SubscriptBox["\[Sigma]", "2"], ",", 
   SubscriptBox["\[Sigma]", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell["The multiplication table defining H is entered,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"H", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "0"]}], ",", 
       SubscriptBox["\[Sigma]", "3"], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "3"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "0"]}], ",", 
       SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "1"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "0"]}]}], "}"}]}], "}"}]}], ";"}]], "Input"],

Cell[TextData[{
 "and this becomes the established ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " by,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"makealgebra", "[", "H", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["algebra"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     RowBox[{"-", 
      SubscriptBox["\[Sigma]", "0"]}], ",", 
     SubscriptBox["\[Sigma]", "3"], ",", 
     RowBox[{"-", 
      SubscriptBox["\[Sigma]", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "2"], ",", 
     RowBox[{"-", 
      SubscriptBox["\[Sigma]", "3"]}], ",", 
     RowBox[{"-", 
      SubscriptBox["\[Sigma]", "0"]}], ",", 
     SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "3"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     RowBox[{"-", 
      SubscriptBox["\[Sigma]", "1"]}], ",", 
     RowBox[{"-", 
      SubscriptBox["\[Sigma]", "0"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "With no argument, ",
 StyleBox["mtx[]", "Input",
  FontWeight->"Plain"],
 " outputs its default argument ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " as a matrix"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", "0"], 
      SubscriptBox["\[Sigma]", "1"], 
      SubscriptBox["\[Sigma]", "2"], 
      SubscriptBox["\[Sigma]", "3"]},
     {
      SubscriptBox["\[Sigma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}], 
      SubscriptBox["\[Sigma]", "3"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "2"]}]},
     {
      SubscriptBox["\[Sigma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}], 
      SubscriptBox["\[Sigma]", "1"]},
     {
      SubscriptBox["\[Sigma]", "3"], 
      SubscriptBox["\[Sigma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["Input a general quaternion,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "i"], 
     SubscriptBox["\[Sigma]", "i"]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["\[Sigma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell["and construct its conjugate,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  OverscriptBox["q", "_"], "=", 
  RowBox[{
   RowBox[{"-", "q"}], "/.", 
   RowBox[{
    SubscriptBox["x", "0"], "->", 
    RowBox[{"-", 
     SubscriptBox["x", "0"]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["\[Sigma]", "0"]}], "-", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "-", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "-", 
  RowBox[{
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.b.2. Multiplication", "Subsubsection"],

Cell[TextData[{
 StyleBox["AVF",
  FontSlant->"Italic"],
 " multiplication uses **, the ",
 StyleBox["NonCommutativeMultiply", "Input",
  FontWeight->"Plain"],
 " infix operator,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "**", 
  OverscriptBox["q", "_"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["x", "0", "2"], "+", 
  SubsuperscriptBox["x", "1", "2"], "+", 
  SubsuperscriptBox["x", "2", "2"], "+", 
  SubsuperscriptBox["x", "3", "2"]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The identity element generally is suppressed in output from ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " operations. An independent quaternion,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Q", "=", 
  RowBox[{"q", "/.", 
   RowBox[{"x", "->", "\[Omega]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "3"]}]}]], "Output"]
}, Open  ]],

Cell["with the non-commutative quaternion product,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"qQ", "=", 
  RowBox[{"q", "**", "Q"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "-", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "-", 
  RowBox[{
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "-", 
  RowBox[{
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "-", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "**", "Q"}], "-", 
  RowBox[{"Q", "**", "q"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "3"]}]}]], "Output"]
}, Open  ]],

Cell["Any number of AVFs can be multiplied together,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "**", "Q", "**", 
  OverscriptBox["q", "_"]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["x", "0", "2"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "+", 
  RowBox[{
   SubsuperscriptBox["x", "1", "2"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "+", 
  RowBox[{
   SubsuperscriptBox["x", "2", "2"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "+", 
  RowBox[{
   SubsuperscriptBox["x", "3", "2"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "+", 
  RowBox[{
   SubsuperscriptBox["x", "0", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{
   SubsuperscriptBox["x", "1", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{
   SubsuperscriptBox["x", "2", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{
   SubsuperscriptBox["x", "3", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{
   SubsuperscriptBox["x", "0", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "-", 
  RowBox[{
   SubsuperscriptBox["x", "1", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{
   SubsuperscriptBox["x", "2", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "-", 
  RowBox[{
   SubsuperscriptBox["x", "3", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "+", 
  RowBox[{
   SubsuperscriptBox["x", "0", "2"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "-", 
  RowBox[{
   SubsuperscriptBox["x", "1", "2"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "-", 
  RowBox[{
   SubsuperscriptBox["x", "2", "2"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "+", 
  RowBox[{
   SubsuperscriptBox["x", "3", "2"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and if the ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " table specifies a non-associative algebra, the order of performing triple \
products may be important. But for H it's not,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"q", "**", "Q"}], ")"}], "**", 
   OverscriptBox["q", "_"]}], "-", 
  RowBox[{"q", "**", 
   RowBox[{"(", 
    RowBox[{"Q", "**", 
     OverscriptBox["q", "_"]}], ")"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["\<\
All the commands used herein can be applied to non-associative cases, such as \
octonions and Lie algebras, with due regard for the ordering of triple \
products.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["III.b.3. Format commands", "Subsubsection"],

Cell[TextData[{
 "The non-zero coefficients of the algebra elements in an AVF, such as ",
 StyleBox["qQ", "Input",
  FontWeight->"Plain"],
 " , are returned in a list by"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "[", "qQ", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["x", "0"], " ", 
     SubscriptBox["\[Omega]", "0"]}], "-", 
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["\[Omega]", "1"]}], "-", 
    RowBox[{
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["\[Omega]", "2"]}], "-", 
    RowBox[{
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["\[Omega]", "0"]}], "+", 
    RowBox[{
     SubscriptBox["x", "0"], " ", 
     SubscriptBox["\[Omega]", "1"]}], "-", 
    RowBox[{
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["\[Omega]", "2"]}], "+", 
    RowBox[{
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["\[Omega]", "0"]}], "+", 
    RowBox[{
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["\[Omega]", "1"]}], "+", 
    RowBox[{
     SubscriptBox["x", "0"], " ", 
     SubscriptBox["\[Omega]", "2"]}], "-", 
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["\[Omega]", "0"]}], "-", 
    RowBox[{
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["\[Omega]", "1"]}], "+", 
    RowBox[{
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["\[Omega]", "2"]}], "+", 
    RowBox[{
     SubscriptBox["x", "0"], " ", 
     SubscriptBox["\[Omega]", "3"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["and the AVF expression is output in collected form by,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", "qQ", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "3"], " ", 
      SubscriptBox["\[Omega]", "0"]}], "-", 
     RowBox[{
      SubscriptBox["x", "2"], " ", 
      SubscriptBox["\[Omega]", "1"]}], "+", 
     RowBox[{
      SubscriptBox["x", "1"], " ", 
      SubscriptBox["\[Omega]", "2"]}], "+", 
     RowBox[{
      SubscriptBox["x", "0"], " ", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "2"], " ", 
      SubscriptBox["\[Omega]", "0"]}], "+", 
     RowBox[{
      SubscriptBox["x", "3"], " ", 
      SubscriptBox["\[Omega]", "1"]}], "+", 
     RowBox[{
      SubscriptBox["x", "0"], " ", 
      SubscriptBox["\[Omega]", "2"]}], "-", 
     RowBox[{
      SubscriptBox["x", "1"], " ", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "1"], " ", 
      SubscriptBox["\[Omega]", "0"]}], "+", 
     RowBox[{
      SubscriptBox["x", "0"], " ", 
      SubscriptBox["\[Omega]", "1"]}], "-", 
     RowBox[{
      SubscriptBox["x", "3"], " ", 
      SubscriptBox["\[Omega]", "2"]}], "+", 
     RowBox[{
      SubscriptBox["x", "2"], " ", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "0"], " ", 
      SubscriptBox["\[Omega]", "0"]}], "-", 
     RowBox[{
      SubscriptBox["x", "1"], " ", 
      SubscriptBox["\[Omega]", "1"]}], "-", 
     RowBox[{
      SubscriptBox["x", "2"], " ", 
      SubscriptBox["\[Omega]", "2"]}], "-", 
     RowBox[{
      SubscriptBox["x", "3"], " ", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "This is the only ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " command that always outputs the identity element explicitly. The result \
contains the usual scalar and vector products for 3-vectors,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "0"], "->", "0"}], ",", 
    RowBox[{
     SubscriptBox["\[Omega]", "0"], "->", "0"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["x", "2"]}], " ", 
      SubscriptBox["\[Omega]", "1"]}], "+", 
     RowBox[{
      SubscriptBox["x", "1"], " ", 
      SubscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "3"], " ", 
      SubscriptBox["\[Omega]", "1"]}], "-", 
     RowBox[{
      SubscriptBox["x", "1"], " ", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["x", "3"]}], " ", 
      SubscriptBox["\[Omega]", "2"]}], "+", 
     RowBox[{
      SubscriptBox["x", "2"], " ", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["x", "1"]}], " ", 
      SubscriptBox["\[Omega]", "1"]}], "-", 
     RowBox[{
      SubscriptBox["x", "2"], " ", 
      SubscriptBox["\[Omega]", "2"]}], "-", 
     RowBox[{
      SubscriptBox["x", "3"], " ", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.b.4. Differentiation", "Subsubsection"],

Cell[TextData[{
 "Exterior differentiation is accomplished with the operator ",
 StyleBox["d[]", "Input",
  FontWeight->"Plain"],
 " , but since no ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " or ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " lists have been established yet, all quantities are treated as constants,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "qQ", "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["The coefficients in q", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["q"], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["\[Sigma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell["can be made into independent scalar fields by,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"coeffs", "[", "q", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "0"], ",", 
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and the ",
 StyleBox["makescalars", "Input",
  FontWeight->"Plain"],
 " command also generates their 1-form derivative symbols, ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["dscalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["dx", "0"], ",", 
   SubscriptBox["dx", "1"], ",", 
   SubscriptBox["dx", "2"], ",", 
   SubscriptBox["dx", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " elements themselves are always constants, but ",
 StyleBox["q", "Input",
  FontWeight->"Plain"],
 " has become a quaternion field,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "q", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["dx", "0"], "+", 
  RowBox[{
   SubscriptBox["dx", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["dx", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["dx", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"q", "**", 
   OverscriptBox["q", "_"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["dx", "0"], " ", 
   SubscriptBox["x", "0"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["dx", "1"], " ", 
   SubscriptBox["x", "1"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["dx", "2"], " ", 
   SubscriptBox["x", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["dx", "3"], " ", 
   SubscriptBox["x", "3"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The coefficients in ",
 StyleBox["Q", "Input",
  FontWeight->"Plain"],
 " can be established as non-exact basis 1-forms by"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeforms", "[", 
  RowBox[{"coeffs", "[", "Q", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "0"], ",", 
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"], ",", 
   SubscriptBox["dx", "0"], ",", 
   SubscriptBox["dx", "1"], ",", 
   SubscriptBox["dx", "2"], ",", 
   SubscriptBox["dx", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "where the independent basis 1-forms will include ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 " automatically, and the non-exact forms have derivative symbols in ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["dforms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["d\[Omega]", "0"], ",", 
   SubscriptBox["d\[Omega]", "1"], ",", 
   SubscriptBox["d\[Omega]", "2"], ",", 
   SubscriptBox["d\[Omega]", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The quantity ",
 StyleBox["Q", "Input",
  FontWeight->"Plain"],
 " is now a quaternion-valued 1-form field with the 2-form derivative,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "Q", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["d\[Omega]", "0"], "+", 
  RowBox[{
   SubscriptBox["d\[Omega]", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["d\[Omega]", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["d\[Omega]", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell["and the AVF self-product,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QQ", "=", 
  RowBox[{"Q", "**", "Q"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The derivative of the previously defined variable ",
 StyleBox["qQ", "Input",
  FontWeight->"Plain"],
 " now gives the quaternion 2-form,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{"d", "[", "qQ", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["d\[Omega]", "3"], " ", 
      SubscriptBox["x", "0"]}], "+", 
     RowBox[{
      SubscriptBox["d\[Omega]", "2"], " ", 
      SubscriptBox["x", "1"]}], "-", 
     RowBox[{
      SubscriptBox["d\[Omega]", "1"], " ", 
      SubscriptBox["x", "2"]}], "+", 
     RowBox[{
      SubscriptBox["d\[Omega]", "0"], " ", 
      SubscriptBox["x", "3"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "0"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}], "-", 
     RowBox[{
      SubscriptBox["dx", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "1"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "3"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "0"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["d\[Omega]", "2"], " ", 
      SubscriptBox["x", "0"]}], "-", 
     RowBox[{
      SubscriptBox["d\[Omega]", "3"], " ", 
      SubscriptBox["x", "1"]}], "+", 
     RowBox[{
      SubscriptBox["d\[Omega]", "0"], " ", 
      SubscriptBox["x", "2"]}], "+", 
     RowBox[{
      SubscriptBox["d\[Omega]", "1"], " ", 
      SubscriptBox["x", "3"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "0"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}], "-", 
     RowBox[{
      SubscriptBox["dx", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "0"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "3"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "1"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["d\[Omega]", "1"], " ", 
      SubscriptBox["x", "0"]}], "+", 
     RowBox[{
      SubscriptBox["d\[Omega]", "0"], " ", 
      SubscriptBox["x", "1"]}], "+", 
     RowBox[{
      SubscriptBox["d\[Omega]", "3"], " ", 
      SubscriptBox["x", "2"]}], "-", 
     RowBox[{
      SubscriptBox["d\[Omega]", "2"], " ", 
      SubscriptBox["x", "3"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "0"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "1"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "0"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}], "-", 
     RowBox[{
      SubscriptBox["dx", "3"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["d\[Omega]", "0"], " ", 
      SubscriptBox["x", "0"]}], "-", 
     RowBox[{
      SubscriptBox["d\[Omega]", "1"], " ", 
      SubscriptBox["x", "1"]}], "-", 
     RowBox[{
      SubscriptBox["d\[Omega]", "2"], " ", 
      SubscriptBox["x", "2"]}], "-", 
     RowBox[{
      SubscriptBox["d\[Omega]", "3"], " ", 
      SubscriptBox["x", "3"]}], "+", 
     RowBox[{
      SubscriptBox["dx", "0"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "0"]}], "-", 
     RowBox[{
      SubscriptBox["dx", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "1"]}], "-", 
     RowBox[{
      SubscriptBox["dx", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}], "-", 
     RowBox[{
      SubscriptBox["dx", "3"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "In field theories, the AVF 2-form field ",
 StyleBox["F", "Input",
  FontWeight->"Plain"],
 " is important,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F", "=", 
  RowBox[{"collect", "[", 
   RowBox[{
    RowBox[{"d", "[", "Q", "]"}], "+", 
    RowBox[{"QQ", "/", "2"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["d\[Omega]", "0"], " ", 
   SubscriptBox["\[Sigma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["d\[Omega]", "3"], "+", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["d\[Omega]", "2"], "-", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["d\[Omega]", "1"], "+", 
     RowBox[{
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
where the coefficients have the structure of Maurer-Cartan forms for the \
quaternion algebra,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["d\[Omega]", "0"], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "1"], "+", 
    RowBox[{
     SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "2"], "-", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    SubscriptBox["d\[Omega]", "3"], "+", 
    RowBox[{
     SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
     SubscriptBox["\[Omega]", "2"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
and the quaternion-valued \[OpenCurlyDoubleQuote]curvature\
\[CloseCurlyDoubleQuote] 2-form satisfies the 3-form Bianchi identity,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "[", "F", "]"}], "+", 
  RowBox[{"Q", "**", 
   RowBox[{"(", 
    RowBox[{"F", "/", "2"}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"F", "/", "2"}], ")"}], "**", "Q"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["\<\
Similar AVF structures can be defined for other associative algebras (such as \
the geometric Clifford algebras, which include H), and for non-associative \
algebras (e.g., Lie or supersymmetric graded Lie algebras).\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell["\<\
The derivative operator can also be applied to a list of AVFs.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"q", "**", 
     OverscriptBox["q", "_"]}], ",", "QQ"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["dx", "0"], " ", 
     SubscriptBox["x", "0"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["dx", "1"], " ", 
     SubscriptBox["x", "1"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["dx", "2"], " ", 
     SubscriptBox["x", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["dx", "3"], " ", 
     SubscriptBox["x", "3"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SubscriptBox["\[Sigma]", "3"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "2"]}]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "2"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "3"]}]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "3"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "1"]}]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "1"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "3"]}]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "2"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "1"]}]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "1"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "2"]}]}]}]}], "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.b.5. Ordinary differential forms", "Subsubsection"],

Cell[TextData[{
 "Any ordinary differential form expression can be input simply by omitting \
the algebra elements. Absent elements default to the identity element of the \
algebra, which only appears with ",
 StyleBox["collect", "Input",
  FontWeight->"Plain"],
 "; e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "1"], 
      RowBox[{
       SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
       SubscriptBox["dx", "2"]}]}], "+", 
     RowBox[{
      SubscriptBox["x", "0"], 
      SubscriptBox["d\[Omega]", "3"]}]}], ")"}], "**", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Omega]", "3"], "+", 
     SubscriptBox["\[Omega]", "2"]}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"collect", "[", "f", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"df", "=", 
  RowBox[{"d", "[", "f", "]"}]}]], "Input"],

Cell[TextData[{
 "Since ordinary differential forms are treated as a trivial ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 ", all ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " commands will work equally well in either case."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "III.b.6. ",
 StyleBox["factor", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["expand", "Input",
  FontWeight->"Plain"]
}], "Subsubsection"],

Cell[TextData[{
 "Any member of ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " or ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 " can be factored out to the left of an AVF by the following command, where \
all terms containing the basis form will be factored."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fac", "=", 
  RowBox[{"factor", "[", 
   RowBox[{
    SubscriptBox["d\[Omega]", "3"], ",", "df"}], "]"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "and so the original ",
 StyleBox["df", "Input",
  FontWeight->"Plain"],
 " can be recovered by using ",
 StyleBox["expand", "Input",
  FontWeight->"Plain"],
 " on the next expression,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"df", "/.", 
    RowBox[{
     SubscriptBox["d\[Omega]", "3"], "->", "0"}]}], ")"}], "+", 
  RowBox[{
   SubscriptBox["d\[Omega]", "3"], "\[Wedge]", "fac"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"df", "+", 
  RowBox[{
   SubscriptBox["d\[Omega]", "3"], "\[Wedge]", "0"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expand", "[", "%", "]"}]], "Input"],

Cell[BoxData["df"], "Output"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " command ",
 StyleBox["expand", "Input",
  FontWeight->"Plain"],
 " is analogous to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 StyleBox["Expand", "Input",
  FontWeight->"Plain"],
 ", except that it also expands wedge products, and so allows arbitrary \
replacements within them at all levels of an AVF expression. Note that the \
wedge symbol has the usual meaning of exterior product between basis forms, \
but is neither recognized nor used as an operator."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Q", "\[Wedge]", "QQ"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], " ", 
     SubscriptBox["\[Omega]", "0"]}], "+", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], " ", 
     SubscriptBox["\[Omega]", "1"]}], "+", 
    RowBox[{
     SubscriptBox["\[Sigma]", "2"], " ", 
     SubscriptBox["\[Omega]", "2"]}], "+", 
    RowBox[{
     SubscriptBox["\[Sigma]", "3"], " ", 
     SubscriptBox["\[Omega]", "3"]}]}], ")"}], "\[Wedge]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "3"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "2"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "1"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   SubscriptBox["\[Omega]", "2"], "->", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["dx", "1"], "+", 
     SubscriptBox["dx", "3"]}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["dx", "1"], "+", 
       SubscriptBox["dx", "3"]}], ")"}], " ", 
     SubscriptBox["\[Sigma]", "2"]}], "+", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], " ", 
     SubscriptBox["\[Omega]", "0"]}], "+", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], " ", 
     SubscriptBox["\[Omega]", "1"]}], "+", 
    RowBox[{
     SubscriptBox["\[Sigma]", "3"], " ", 
     SubscriptBox["\[Omega]", "3"]}]}], ")"}], "\[Wedge]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "1"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["dx", "1"], "+", 
        SubscriptBox["dx", "3"]}], ")"}], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "3"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["dx", "1"], "+", 
        SubscriptBox["dx", "3"]}], ")"}]}]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Sigma]", "2"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expand", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{
    SubscriptBox["dx", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "0"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{
    SubscriptBox["dx", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "0"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "+", 
  RowBox[{"6", " ", 
   RowBox[{
    SubscriptBox["dx", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{
    SubscriptBox["dx", "3"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "0"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"]}]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{
    SubscriptBox["dx", "3"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "0"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "+", 
  RowBox[{"6", " ", 
   RowBox[{
    SubscriptBox["dx", "3"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "0"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.b.7. Vector contraction", "Subsubsection"],

Cell[TextData[{
 "A vector in ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " is a list of scalar variables with the same length as the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list. The list represents the components of the vector in the dual basis \
to ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ". The components will be constants, unless they are chosen from the ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " list, or are input as specified or unspecified functions of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ". Define two independent vectors, ",
 StyleBox["V1", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["V2", "Input",
  FontWeight->"Plain"],
 ",  with symbols adapted to the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "0"], ",", 
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"], ",", 
   SubscriptBox["dx", "0"], ",", 
   SubscriptBox["dx", "1"], ",", 
   SubscriptBox["dx", "2"], ",", 
   SubscriptBox["dx", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"V1", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["W1", "0"], ",", 
     SubscriptBox["W1", "1"], ",", 
     SubscriptBox["W1", "2"], ",", 
     SubscriptBox["W1", "3"], ",", 
     SubscriptBox["X1", "0"], ",", 
     SubscriptBox["X1", "1"], ",", 
     SubscriptBox["X1", "2"], ",", 
     SubscriptBox["X1", "3"]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"V2", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["W2", "0"], ",", 
     SubscriptBox["W2", "1"], ",", 
     SubscriptBox["W2", "2"], ",", 
     SubscriptBox["W2", "3"], ",", 
     SubscriptBox["X2", "0"], ",", 
     SubscriptBox["X2", "1"], ",", 
     SubscriptBox["X2", "2"], ",", 
     SubscriptBox["X2", "3"]}], "}"}]}], ";"}]}], "Input"],

Cell[TextData[{
 "Vector contractions are given by the ",
 StyleBox["SmallCircle", "Input",
  FontWeight->"Plain"],
 " infix operator, typed as esc-sc-esc; i.e., vector \[SmallCircle] AVF . \
Contraction can also be applied to a list of AVFs, and multiple contractions \
can be performed together. On the list of basis 1-forms, it simply returns \
the vector itself;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V1", "\[SmallCircle]", "forms"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["W1", "0"], ",", 
   SubscriptBox["W1", "1"], ",", 
   SubscriptBox["W1", "2"], ",", 
   SubscriptBox["W1", "3"], ",", 
   SubscriptBox["X1", "0"], ",", 
   SubscriptBox["X1", "1"], ",", 
   SubscriptBox["X1", "2"], ",", 
   SubscriptBox["X1", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V1", "\[SmallCircle]", 
  RowBox[{"{", 
   RowBox[{"QQ", ",", 
    RowBox[{"d", "[", "q", "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["W1", "3"], " ", 
     SubscriptBox["\[Sigma]", "2"], " ", 
     SubscriptBox["\[Omega]", "1"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["W1", "2"], " ", 
     SubscriptBox["\[Sigma]", "3"], " ", 
     SubscriptBox["\[Omega]", "1"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["W1", "3"], " ", 
     SubscriptBox["\[Sigma]", "1"], " ", 
     SubscriptBox["\[Omega]", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["W1", "1"], " ", 
     SubscriptBox["\[Sigma]", "3"], " ", 
     SubscriptBox["\[Omega]", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["W1", "2"], " ", 
     SubscriptBox["\[Sigma]", "1"], " ", 
     SubscriptBox["\[Omega]", "3"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["W1", "1"], " ", 
     SubscriptBox["\[Sigma]", "2"], " ", 
     SubscriptBox["\[Omega]", "3"]}]}], ",", 
   RowBox[{
    SubscriptBox["X1", "0"], "+", 
    RowBox[{
     SubscriptBox["X1", "1"], " ", 
     SubscriptBox["\[Sigma]", "1"]}], "+", 
    RowBox[{
     SubscriptBox["X1", "2"], " ", 
     SubscriptBox["\[Sigma]", "2"]}], "+", 
    RowBox[{
     SubscriptBox["X1", "3"], " ", 
     SubscriptBox["\[Sigma]", "3"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V1", "\[SmallCircle]", "V2", "\[SmallCircle]", "QQ"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["W1", "3"], " ", 
   SubscriptBox["W2", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["W1", "2"], " ", 
   SubscriptBox["W2", "3"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["W1", "3"], " ", 
   SubscriptBox["W2", "1"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["W1", "1"], " ", 
   SubscriptBox["W2", "3"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["W1", "2"], " ", 
   SubscriptBox["W2", "1"], " ", 
   SubscriptBox["\[Sigma]", "3"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["W1", "1"], " ", 
   SubscriptBox["W2", "2"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["W1", "3"], " ", 
      SubscriptBox["W2", "2"]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["W1", "2"], " ", 
      SubscriptBox["W2", "3"]}]}], ")"}], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SubscriptBox["W1", "3"], " ", 
      SubscriptBox["W2", "1"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["W1", "1"], " ", 
      SubscriptBox["W2", "3"]}]}], ")"}], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["W1", "2"], " ", 
      SubscriptBox["W2", "1"]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["W1", "1"], " ", 
      SubscriptBox["W2", "2"]}]}], ")"}], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell["These vectors are constant,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "V1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
   "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "but the components can be input as functions of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["W1", "0"], "[", 
     SubscriptBox["x", "0"], "]"}], ",", 
    RowBox[{
     SubscriptBox["W1", "1"], "[", 
     SubscriptBox["x", "1"], "]"}], ",", 
    RowBox[{
     SubscriptBox["W1", "2"], "[", 
     SubscriptBox["x", "2"], "]"}], ",", 
    RowBox[{
     SubscriptBox["W1", "3"], "[", 
     SubscriptBox["x", "3"], "]"}], ",", 
    SubscriptBox["X1", "0"], ",", 
    SubscriptBox["X1", "1"], ",", 
    SubscriptBox["X1", "2"], ",", 
    SubscriptBox["X1", "3"]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["W1", "0"], "[", 
    SubscriptBox["x", "0"], "]"}], ",", 
   RowBox[{
    SubscriptBox["W1", "1"], "[", 
    SubscriptBox["x", "1"], "]"}], ",", 
   RowBox[{
    SubscriptBox["W1", "2"], "[", 
    SubscriptBox["x", "2"], "]"}], ",", 
   RowBox[{
    SubscriptBox["W1", "3"], "[", 
    SubscriptBox["x", "3"], "]"}], ",", 
   SubscriptBox["X1", "0"], ",", 
   SubscriptBox["X1", "1"], ",", 
   SubscriptBox["X1", "2"], ",", 
   SubscriptBox["X1", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "V1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["dx", "0"], " ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["W1", "0"], "\[Prime]",
      MultilineFunction->None], "[", 
     SubscriptBox["x", "0"], "]"}]}], ",", 
   RowBox[{
    SubscriptBox["dx", "1"], " ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["W1", "1"], "\[Prime]",
      MultilineFunction->None], "[", 
     SubscriptBox["x", "1"], "]"}]}], ",", 
   RowBox[{
    SubscriptBox["dx", "2"], " ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["W1", "2"], "\[Prime]",
      MultilineFunction->None], "[", 
     SubscriptBox["x", "2"], "]"}]}], ",", 
   RowBox[{
    SubscriptBox["dx", "3"], " ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["W1", "3"], "\[Prime]",
      MultilineFunction->None], "[", 
     SubscriptBox["x", "3"], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
   "0"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V1", "\[SmallCircle]", "QQ"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "2"], " ", 
   RowBox[{
    SubscriptBox["W1", "1"], "[", 
    SubscriptBox["x", "1"], "]"}]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "3"], " ", 
   RowBox[{
    SubscriptBox["W1", "1"], "[", 
    SubscriptBox["x", "1"], "]"}]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "1"], " ", 
   RowBox[{
    SubscriptBox["W1", "2"], "[", 
    SubscriptBox["x", "2"], "]"}]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "3"], " ", 
   RowBox[{
    SubscriptBox["W1", "2"], "[", 
    SubscriptBox["x", "2"], "]"}]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "1"], " ", 
   RowBox[{
    SubscriptBox["W1", "3"], "[", 
    SubscriptBox["x", "3"], "]"}]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "2"], " ", 
   RowBox[{
    SubscriptBox["W1", "3"], "[", 
    SubscriptBox["x", "3"], "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{"d", "[", "%", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "2"], " ", 
      RowBox[{
       SubscriptBox["W1", "1"], "[", 
       SubscriptBox["x", "1"], "]"}]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "1"], " ", 
      RowBox[{
       SubscriptBox["W1", "2"], "[", 
       SubscriptBox["x", "2"], "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dx", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "2"]}], " ", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["W1", "1"], "\[Prime]",
        MultilineFunction->None], "[", 
       SubscriptBox["x", "1"], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dx", "2"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "1"]}], " ", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["W1", "2"], "\[Prime]",
        MultilineFunction->None], "[", 
       SubscriptBox["x", "2"], "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SubscriptBox["d\[Omega]", "3"], " ", 
      RowBox[{
       SubscriptBox["W1", "1"], "[", 
       SubscriptBox["x", "1"], "]"}]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "1"], " ", 
      RowBox[{
       SubscriptBox["W1", "3"], "[", 
       SubscriptBox["x", "3"], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dx", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}], " ", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["W1", "1"], "\[Prime]",
        MultilineFunction->None], "[", 
       SubscriptBox["x", "1"], "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dx", "3"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "1"]}], " ", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["W1", "3"], "\[Prime]",
        MultilineFunction->None], "[", 
       SubscriptBox["x", "3"], "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "3"], " ", 
      RowBox[{
       SubscriptBox["W1", "2"], "[", 
       SubscriptBox["x", "2"], "]"}]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "2"], " ", 
      RowBox[{
       SubscriptBox["W1", "3"], "[", 
       SubscriptBox["x", "3"], "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dx", "2"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}], " ", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["W1", "2"], "\[Prime]",
        MultilineFunction->None], "[", 
       SubscriptBox["x", "2"], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dx", "3"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "2"]}], " ", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["W1", "3"], "\[Prime]",
        MultilineFunction->None], "[", 
       SubscriptBox["x", "3"], "]"}]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "or even be entered into ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " themselves to make them independent fields with their own derivatives,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"Join", "[", 
   RowBox[{"scalars", ",", "V2"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "0"], ",", 
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["W2", "0"], ",", 
   SubscriptBox["W2", "1"], ",", 
   SubscriptBox["W2", "2"], ",", 
   SubscriptBox["W2", "3"], ",", 
   SubscriptBox["X2", "0"], ",", 
   SubscriptBox["X2", "1"], ",", 
   SubscriptBox["X2", "2"], ",", 
   SubscriptBox["X2", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "0"], ",", 
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"], ",", 
   SubscriptBox["dx", "0"], ",", 
   SubscriptBox["dx", "1"], ",", 
   SubscriptBox["dx", "2"], ",", 
   SubscriptBox["dx", "3"], ",", 
   SubscriptBox["dW2", "0"], ",", 
   SubscriptBox["dW2", "1"], ",", 
   SubscriptBox["dW2", "2"], ",", 
   SubscriptBox["dW2", "3"], ",", 
   SubscriptBox["dX2", "0"], ",", 
   SubscriptBox["dX2", "1"], ",", 
   SubscriptBox["dX2", "2"], ",", 
   SubscriptBox["dX2", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V2", "\[SmallCircle]", "QQ"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["W2", "3"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["W2", "2"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["W2", "3"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["W2", "1"], " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["W2", "2"], " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["\[Omega]", "3"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["W2", "1"], " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["\[Omega]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{"d", "[", "%", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "2"], " ", 
      SubscriptBox["W2", "1"]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "1"], " ", 
      SubscriptBox["W2", "2"]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dW2", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "2"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dW2", "2"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "1"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SubscriptBox["d\[Omega]", "3"], " ", 
      SubscriptBox["W2", "1"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "1"], " ", 
      SubscriptBox["W2", "3"]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dW2", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dW2", "3"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "1"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "3"], " ", 
      SubscriptBox["W2", "2"]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["d\[Omega]", "2"], " ", 
      SubscriptBox["W2", "3"]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dW2", "2"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["dW2", "3"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "2"]}]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Contraction on this last expression would require a longer vector to \
encompass the additional independent basis 1-forms created by extending the \
",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " list. It would also require defining contractions on the members of ",
 StyleBox["dforms", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[TextData[{
 "The ",
 StyleBox["makescalars", "Input",
  FontWeight->"Plain"],
 " command just above illustrates a general feature of ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 "; i.e., that the fundamental lists ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ", ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " can be changed at any time by executing the respective ",
 StyleBox["make", "Input",
  FontWeight->"Plain"],
 " command. For instance, the vector components can be deleted from ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " by"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"Complement", "[", 
   RowBox[{"scalars", ",", "V2"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "0"], ",", 
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "0"], ",", 
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"], ",", 
   SubscriptBox["dx", "0"], ",", 
   SubscriptBox["dx", "1"], ",", 
   SubscriptBox["dx", "2"], ",", 
   SubscriptBox["dx", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell["This doesn't delete them from memory,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["V2"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["W2", "0"], ",", 
   SubscriptBox["W2", "1"], ",", 
   SubscriptBox["W2", "2"], ",", 
   SubscriptBox["W2", "3"], ",", 
   SubscriptBox["X2", "0"], ",", 
   SubscriptBox["X2", "1"], ",", 
   SubscriptBox["X2", "2"], ",", 
   SubscriptBox["X2", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "but they do revert to being constant parameters in ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "V2", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
   "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.b.8. Matrix representations and operations", "Subsubsection"],

Cell["\<\
Sometimes it is useful to have a matrix representation of the algebra \
elements, even though the program never requires it. For example, the \
quaternion elements can be represented by Pauli-type matrices, which have the \
same multiplication table as H,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", "0"], 
      SubscriptBox["\[Sigma]", "1"], 
      SubscriptBox["\[Sigma]", "2"], 
      SubscriptBox["\[Sigma]", "3"]},
     {
      SubscriptBox["\[Sigma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}], 
      SubscriptBox["\[Sigma]", "3"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "2"]}]},
     {
      SubscriptBox["\[Sigma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}], 
      SubscriptBox["\[Sigma]", "1"]},
     {
      SubscriptBox["\[Sigma]", "3"], 
      SubscriptBox["\[Sigma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["for instance,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "1"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "I"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"I", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "2"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";", 
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "3"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"I", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "I"}]}], "}"}]}], "}"}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    SubscriptBox["\[CapitalSigma]", "1"], ")"}], ".", 
   SubscriptBox["\[CapitalSigma]", "1"]}], "==", 
  RowBox[{"-", 
   SubscriptBox["\[CapitalSigma]", "0"]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    SubscriptBox["\[CapitalSigma]", "1"], ")"}], ".", 
   SubscriptBox["\[CapitalSigma]", "2"]}], "==", 
  SubscriptBox["\[CapitalSigma]", "3"]}]}], "Input"],

Cell[BoxData["True"], "Output"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[TextData[{
 "and since the indices of these matrices agree with the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Sigma]", "i"], TraditionalForm]]],
 ", any quaternion expression or list can be converted to a matrix by \
replacement of the symbol kernel; i.e.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["elements"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], ",", 
   SubscriptBox["\[Sigma]", "1"], ",", 
   SubscriptBox["\[Sigma]", "2"], ",", 
   SubscriptBox["\[Sigma]", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"elements", "/.", 
  RowBox[{"\[Sigma]", "->", "\[CapitalSigma]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "\[ImaginaryI]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[ImaginaryI]", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[ImaginaryI]", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "\[ImaginaryI]"}]}], "}"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["q"], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["\[Sigma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mq", "=", 
  RowBox[{"q", "/.", 
   RowBox[{"\[Sigma]", "->", "\[CapitalSigma]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "0"], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["x", "3"]}]}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["x", "1"]}], "-", 
      SubscriptBox["x", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["x", "1"]}], "+", 
      SubscriptBox["x", "2"]}], ",", 
     RowBox[{
      SubscriptBox["x", "0"], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["x", "3"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubscriptBox["x", "0"], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["x", "3"]}]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"]}], "-", 
       SubscriptBox["x", "2"]}]},
     {
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"]}], "+", 
       SubscriptBox["x", "2"]}], 
      RowBox[{
       SubscriptBox["x", "0"], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["x", "3"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["QQ"], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "2"]}]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
    SubscriptBox["\[Omega]", "3"]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mQQ", "=", 
  RowBox[{"QQ", "/.", 
   RowBox[{"\[Sigma]", "->", "\[CapitalSigma]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "2"]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "3"]}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "2"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "When the AVF includes a suppressed identity element, it is necessary to \
make it explicit by using ",
 StyleBox["collect", "Input",
  FontWeight->"Plain"],
 " before conversion; e.g.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "**", "q"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["x", "0", "2"], "-", 
  SubsuperscriptBox["x", "1", "2"], "-", 
  SubsuperscriptBox["x", "2", "2"], "-", 
  SubsuperscriptBox["x", "3", "2"], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["x", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["x", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["x", "0"], " ", 
   SubscriptBox["x", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"collect", "[", 
   RowBox[{"q", "**", "q"}], "]"}], "/.", 
  RowBox[{"\[Sigma]", "->", "\[CapitalSigma]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["x", "0", "2"], "-", 
      SubsuperscriptBox["x", "1", "2"], "-", 
      SubsuperscriptBox["x", "2", "2"], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "3"]}], "-", 
      SubsuperscriptBox["x", "3", "2"]}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "1"]}], "-", 
      RowBox[{"2", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "1"]}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "2"]}]}], ",", 
     RowBox[{
      SubsuperscriptBox["x", "0", "2"], "-", 
      SubsuperscriptBox["x", "1", "2"], "-", 
      SubsuperscriptBox["x", "2", "2"], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "3"]}], "-", 
      SubsuperscriptBox["x", "3", "2"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Since the matrix mq has only scalar components, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s matrix product gives the same result,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"mq", ".", "mq"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["x", "0", "2"], "-", 
      SubsuperscriptBox["x", "1", "2"], "-", 
      SubsuperscriptBox["x", "2", "2"], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "3"]}], "-", 
      SubsuperscriptBox["x", "3", "2"]}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "1"]}], "-", 
      RowBox[{"2", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "1"]}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "2"]}]}], ",", 
     RowBox[{
      SubsuperscriptBox["x", "0", "2"], "-", 
      SubsuperscriptBox["x", "1", "2"], "-", 
      SubsuperscriptBox["x", "2", "2"], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["x", "0"], " ", 
       SubscriptBox["x", "3"]}], "-", 
      SubsuperscriptBox["x", "3", "2"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.b.9. AVF matrices", "Subsubsection"],

Cell[TextData[{
 "The ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " program includes an infix operator, denoted ",
 StyleBox["CircleTimes", "Input",
  FontWeight->"Plain"],
 " and typed by esc-c*-esc}, that can be used when the matrix elements are \
complete AVFs, such as quaternion-valued p-forms. For instance, the above \
matrix ",
 StyleBox["mQQ", "Input",
  FontWeight->"Plain"],
 " can be calculated using the matrix form of ",
 StyleBox["Q", "Input",
  FontWeight->"Plain"],
 " having 1-form elements,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mQ", "=", 
  RowBox[{"Q", "/.", 
   RowBox[{"\[Sigma]", "->", "\[CapitalSigma]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Omega]", "0"], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Omega]", "3"]}]}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Omega]", "1"]}], "-", 
      SubscriptBox["\[Omega]", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Omega]", "1"]}], "+", 
      SubscriptBox["\[Omega]", "2"]}], ",", 
     RowBox[{
      SubscriptBox["\[Omega]", "0"], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Omega]", "3"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", 
  RowBox[{"mQ", "\[CircleTimes]", "mQ"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
        SubscriptBox["\[Omega]", "2"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 StyleBox["BlockMatrix[]", "Input",
  FontWeight->"Plain"],
 " command, the matrices ",
 StyleBox["mq", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["mQ", "Input",
  FontWeight->"Plain"],
 " can be combined to give a graded matrix, ",
 StyleBox["GM", "Input",
  FontWeight->"Plain"],
 ", with diagonal blocks of even grade (0-forms) and off-diagonal blocks of \
odd grade (1-forms). Such matrices generate supergroups and their commutators \
generate the associated Lie superalgebras."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell["<< LinearAlgebra`MatrixManipulation`;", "Input",
 PageWidth->WindowWidth,
 CellTags->"S5.52.1"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"LinearAlgebra`MatrixManipulation`\\\"\\)\
\[NoBreak] is now obsolete. The legacy version being loaded may conflict with \
current Mathematica functionality. See the Compatibility Guide for updating \
information. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Compatibility/Tutorials/LinearAlgebra/\
MatrixManipulation\\\", ButtonNote -> \\\"General::obspkg\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellTags->"S5.52.1"]
}, Open  ]],

Cell["\<\
For brevity, the identity elements are deleted in this example,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"GM", "=", 
   RowBox[{
    RowBox[{"BlockMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"mq", ",", "mQ"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"mQ", ",", 
         RowBox[{"-", "mq"}]}], "}"}]}], "}"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "0"], "->", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Omega]", "0"], "->", "0"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mtx", "[", "GM", "]"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["x", "3"]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"]}], "-", 
       SubscriptBox["x", "2"]}], 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Omega]", "3"]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Omega]", "1"]}], "-", 
       SubscriptBox["\[Omega]", "2"]}]},
     {
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"]}], "+", 
       SubscriptBox["x", "2"]}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["x", "3"]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       SubscriptBox["\[Omega]", "2"]}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["\[Omega]", "3"]}]},
     {
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Omega]", "3"]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Omega]", "1"]}], "-", 
       SubscriptBox["\[Omega]", "2"]}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["x", "3"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SubscriptBox["x", "1"]}], "+", 
       SubscriptBox["x", "2"]}]},
     {
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       SubscriptBox["\[Omega]", "2"]}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["\[Omega]", "3"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SubscriptBox["x", "1"]}], "-", 
       SubscriptBox["x", "2"]}], 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["x", "3"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
The product is a graded matrix of the same general type; i.e., diagonal \
blocks of even grades in the Grassmann algebra and off-diagonal blocks of odd \
grade:\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", 
  RowBox[{"GM", "\[CircleTimes]", "GM"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["x", "1", "2"]}], "-", 
       SubsuperscriptBox["x", "2", "2"], "-", 
       SubsuperscriptBox["x", "3", "2"], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "2"]}]}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["\[Omega]", "2"]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["\[Omega]", "3"]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Omega]", "3"]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}], 
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["x", "1", "2"]}], "-", 
       SubsuperscriptBox["x", "2", "2"], "-", 
       SubsuperscriptBox["x", "3", "2"], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "2"]}]}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Omega]", "2"]}], "-", 
       RowBox[{"2", " ", 
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["\[Omega]", "3"]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Omega]", "3"]}]}], 
      RowBox[{
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["\[Omega]", "2"]}]}]},
     {
      RowBox[{
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["\[Omega]", "2"]}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Omega]", "2"]}], "-", 
       RowBox[{"2", " ", 
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["\[Omega]", "3"]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Omega]", "3"]}]}], 
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["x", "1", "2"]}], "-", 
       SubsuperscriptBox["x", "2", "2"], "-", 
       SubsuperscriptBox["x", "3", "2"], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "2"]}]}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["\[Omega]", "3"]}], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Omega]", "3"]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["\[Omega]", "2"]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}], 
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["x", "1", "2"]}], "-", 
       SubsuperscriptBox["x", "2", "2"], "-", 
       SubsuperscriptBox["x", "3", "2"], "-", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "2"]}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
A graded matrix equivalent to GM can be expressed more concisely with a 2\
\[Times]2 matrix of the quaternion-valued AVFs,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"QM", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q", ",", "Q"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", 
        RowBox[{"-", "q"}]}], "}"}]}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "0"], "->", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Omega]", "0"], "->", "0"}]}], "}"}]}]}], ";", 
  RowBox[{"mtx", "[", "QM", "]"}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubscriptBox["\[Sigma]", "1"]}], "+", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Sigma]", "2"]}], "+", 
       RowBox[{
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Sigma]", "3"]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        SubscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        SubscriptBox["\[Omega]", "3"]}]}]},
     {
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        SubscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        SubscriptBox["\[Omega]", "3"]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["x", "1"]}], " ", 
        SubscriptBox["\[Sigma]", "1"]}], "-", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubscriptBox["\[Sigma]", "2"]}], "-", 
       RowBox[{
        SubscriptBox["x", "3"], " ", 
        SubscriptBox["\[Sigma]", "3"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", 
  RowBox[{"BlockMatrix", "[", 
   RowBox[{"QM", "/.", 
    RowBox[{"\[Sigma]", "->", "\[CapitalSigma]"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["x", "3"]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"]}], "-", 
       SubscriptBox["x", "2"]}], 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Omega]", "3"]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Omega]", "1"]}], "-", 
       SubscriptBox["\[Omega]", "2"]}]},
     {
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["x", "1"]}], "+", 
       SubscriptBox["x", "2"]}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["x", "3"]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       SubscriptBox["\[Omega]", "2"]}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["\[Omega]", "3"]}]},
     {
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Omega]", "3"]}], 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Omega]", "1"]}], "-", 
       SubscriptBox["\[Omega]", "2"]}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["x", "3"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SubscriptBox["x", "1"]}], "+", 
       SubscriptBox["x", "2"]}]},
     {
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Omega]", "1"]}], "+", 
       SubscriptBox["\[Omega]", "2"]}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["\[Omega]", "3"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SubscriptBox["x", "1"]}], "-", 
       SubscriptBox["x", "2"]}], 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["x", "3"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and it can be multiplied directly with the ",
 StyleBox["CircleTimes", "Input",
  FontWeight->"Plain"],
 " operator, giving essentially the same result for the matrix product, but \
in a representation-independent and slightly more compact form,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"QM2", "=", 
   RowBox[{"collect", "[", 
    RowBox[{"QM", "\[CircleTimes]", "QM"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mtx", "[", "QM2", "]"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubsuperscriptBox["x", "1", "2"]}], "-", 
          SubsuperscriptBox["x", "2", "2"], "-", 
          SubsuperscriptBox["x", "3", "2"]}], ")"}], " ", 
        SubscriptBox["\[Sigma]", "0"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "2"]}]}], "-", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SubscriptBox["x", "2"], " ", 
           SubscriptBox["\[Omega]", "1"]}], "+", 
          RowBox[{"2", " ", 
           SubscriptBox["x", "1"], " ", 
           SubscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SubscriptBox["x", "3"], " ", 
           SubscriptBox["\[Omega]", "1"]}], "-", 
          RowBox[{"2", " ", 
           SubscriptBox["x", "1"], " ", 
           SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SubscriptBox["x", "3"], " ", 
           SubscriptBox["\[Omega]", "2"]}], "+", 
          RowBox[{"2", " ", 
           SubscriptBox["x", "2"], " ", 
           SubscriptBox["\[Omega]", "3"]}]}], ")"}]}]}]},
     {
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SubscriptBox["x", "2"], " ", 
           SubscriptBox["\[Omega]", "1"]}], "-", 
          RowBox[{"2", " ", 
           SubscriptBox["x", "1"], " ", 
           SubscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SubscriptBox["x", "3"], " ", 
           SubscriptBox["\[Omega]", "1"]}], "+", 
          RowBox[{"2", " ", 
           SubscriptBox["x", "1"], " ", 
           SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SubscriptBox["x", "3"], " ", 
           SubscriptBox["\[Omega]", "2"]}], "-", 
          RowBox[{"2", " ", 
           SubscriptBox["x", "2"], " ", 
           SubscriptBox["\[Omega]", "3"]}]}], ")"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubsuperscriptBox["x", "1", "2"]}], "-", 
          SubsuperscriptBox["x", "2", "2"], "-", 
          SubsuperscriptBox["x", "3", "2"]}], ")"}], " ", 
        SubscriptBox["\[Sigma]", "0"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "2"]}]}], "-", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Note that as a matrix ",
 StyleBox["QM", "Input",
  FontWeight->"Plain"],
 " is symmetric, but its expanded form ",
 StyleBox["GM", "Input",
  FontWeight->"Plain"],
 " is unsymmetric (anti-Hermitian), so matrix operations involving transposes \
and conjugates must be defined and handled differently."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[TextData[{
 "Since ",
 StyleBox["d[]", "Input",
  FontWeight->"Plain"],
 " maps recursively onto AVF lists, it also extends to AVF matrices,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{"d", "[", "QM2", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["dx", "1"], " ", 
          SubscriptBox["x", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["dx", "2"], " ", 
          SubscriptBox["x", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["dx", "3"], " ", 
          SubscriptBox["x", "3"]}]}], ")"}], " ", 
       SubscriptBox["\[Sigma]", "0"]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "2"]}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "1"]}]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "3"]}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "1"]}]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "3"]}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "2"]}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["d\[Omega]", "2"], " ", 
          SubscriptBox["x", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["d\[Omega]", "1"], " ", 
          SubscriptBox["x", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "1"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "2"]}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "2"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "1"]}]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["d\[Omega]", "3"], " ", 
          SubscriptBox["x", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["d\[Omega]", "1"], " ", 
          SubscriptBox["x", "3"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "1"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "3"]}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "3"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "1"]}]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["d\[Omega]", "3"], " ", 
          SubscriptBox["x", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["d\[Omega]", "2"], " ", 
          SubscriptBox["x", "3"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "2"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "3"]}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "3"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "2"]}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["d\[Omega]", "2"], " ", 
          SubscriptBox["x", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["d\[Omega]", "1"], " ", 
          SubscriptBox["x", "2"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "1"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "2"]}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "2"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "1"]}]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["d\[Omega]", "3"], " ", 
          SubscriptBox["x", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["d\[Omega]", "1"], " ", 
          SubscriptBox["x", "3"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "1"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "3"]}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "3"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "1"]}]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["d\[Omega]", "3"], " ", 
          SubscriptBox["x", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["d\[Omega]", "2"], " ", 
          SubscriptBox["x", "3"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "2"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "3"]}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["dx", "3"], "\[Wedge]", 
           SubscriptBox["\[Omega]", "2"]}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["dx", "1"], " ", 
          SubscriptBox["x", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["dx", "2"], " ", 
          SubscriptBox["x", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["dx", "3"], " ", 
          SubscriptBox["x", "3"]}]}], ")"}], " ", 
       SubscriptBox["\[Sigma]", "0"]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "2"]}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "1"]}]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "3"]}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "1"]}]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "3"]}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
           SubscriptBox["d\[Omega]", "2"]}]}]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["and the same is true for contractions,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{"V2", "\[SmallCircle]", "QM2"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W2", "2"], " ", 
          SubscriptBox["\[Omega]", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "1"], " ", 
          SubscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["W2", "3"], " ", 
          SubscriptBox["\[Omega]", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "1"], " ", 
          SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W2", "3"], " ", 
          SubscriptBox["\[Omega]", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "2"], " ", 
          SubscriptBox["\[Omega]", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["W2", "3"], " ", 
          SubscriptBox["x", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "2"], " ", 
          SubscriptBox["x", "3"]}]}], ")"}], " ", 
       SubscriptBox["\[Sigma]", "1"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W2", "3"], " ", 
          SubscriptBox["x", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "1"], " ", 
          SubscriptBox["x", "3"]}]}], ")"}], " ", 
       SubscriptBox["\[Sigma]", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["W2", "2"], " ", 
          SubscriptBox["x", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "1"], " ", 
          SubscriptBox["x", "2"]}]}], ")"}], " ", 
       SubscriptBox["\[Sigma]", "3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W2", "3"], " ", 
          SubscriptBox["x", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "2"], " ", 
          SubscriptBox["x", "3"]}]}], ")"}], " ", 
       SubscriptBox["\[Sigma]", "1"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["W2", "3"], " ", 
          SubscriptBox["x", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "1"], " ", 
          SubscriptBox["x", "3"]}]}], ")"}], " ", 
       SubscriptBox["\[Sigma]", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W2", "2"], " ", 
          SubscriptBox["x", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "1"], " ", 
          SubscriptBox["x", "2"]}]}], ")"}], " ", 
       SubscriptBox["\[Sigma]", "3"]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W2", "2"], " ", 
          SubscriptBox["\[Omega]", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "1"], " ", 
          SubscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["W2", "3"], " ", 
          SubscriptBox["\[Omega]", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "1"], " ", 
          SubscriptBox["\[Omega]", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W2", "3"], " ", 
          SubscriptBox["\[Omega]", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W2", "2"], " ", 
          SubscriptBox["\[Omega]", "3"]}]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["For a quaternion-valued, even-odd, column vector,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QV", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      OverscriptBox["q", "_"], "}"}], ",", 
     RowBox[{"{", "Q", "}"}]}], "}"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "0"], "->", "0"}], ",", 
     RowBox[{
      SubscriptBox["\[Omega]", "0"], "->", "0"}]}], "}"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["x", "1"]}], " ", 
      SubscriptBox["\[Sigma]", "1"]}], "-", 
     RowBox[{
      SubscriptBox["x", "2"], " ", 
      SubscriptBox["\[Sigma]", "2"]}], "-", 
     RowBox[{
      SubscriptBox["x", "3"], " ", 
      SubscriptBox["\[Sigma]", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], " ", 
      SubscriptBox["\[Omega]", "1"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], " ", 
      SubscriptBox["\[Omega]", "2"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "3"], " ", 
      SubscriptBox["\[Omega]", "3"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "the ",
 StyleBox["QM\[CircleTimes]QV", "Input",
  FontWeight->"Plain"],
 " product returns an even-odd column vector"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QM", "\[CircleTimes]", "QV"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubsuperscriptBox["x", "1", "2"], "+", 
     SubsuperscriptBox["x", "2", "2"], "+", 
     SubsuperscriptBox["x", "3", "2"], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["\[Sigma]", "3"], " ", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "2"]}]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["\[Sigma]", "2"], " ", 
      RowBox[{
       SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["\[Sigma]", "1"], " ", 
      RowBox[{
       SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
       SubscriptBox["\[Omega]", "3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["x", "1"], " ", 
      SubscriptBox["\[Omega]", "1"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["x", "2"], " ", 
      SubscriptBox["\[Omega]", "2"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["x", "3"], " ", 
      SubscriptBox["\[Omega]", "3"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
and finally, a single, quaternion-valued, even-grade, p-form,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "QV", "]"}], "\[CircleTimes]", "%"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["x", "1", "3"]}], "-", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubsuperscriptBox["x", "2", "2"]}], "-", 
       RowBox[{
        SubscriptBox["x", "1"], " ", 
        SubsuperscriptBox["x", "3", "2"]}]}], ")"}], " ", 
     SubscriptBox["\[Sigma]", "1"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubsuperscriptBox["x", "1", "2"]}], " ", 
        SubscriptBox["x", "2"]}], "-", 
       SubsuperscriptBox["x", "2", "3"], "-", 
       RowBox[{
        SubscriptBox["x", "2"], " ", 
        SubsuperscriptBox["x", "3", "2"]}]}], ")"}], " ", 
     SubscriptBox["\[Sigma]", "2"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubsuperscriptBox["x", "1", "2"]}], " ", 
        SubscriptBox["x", "3"]}], "-", 
       RowBox[{
        SubsuperscriptBox["x", "2", "2"], " ", 
        SubscriptBox["x", "3"]}], "-", 
       SubsuperscriptBox["x", "3", "3"]}], ")"}], " ", 
     SubscriptBox["\[Sigma]", "3"]}], "+", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SubscriptBox["x", "3"], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "2"]}]}], "-", 
       RowBox[{"2", " ", 
        SubscriptBox["x", "2"], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["x", "1"], " ", 
        RowBox[{
         SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
         SubscriptBox["\[Omega]", "3"]}]}]}], ")"}]}]}], "}"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", 
     SubscriptBox["dx", "1"], " ", 
     SubsuperscriptBox["x", "1", "2"], " ", 
     SubscriptBox["\[Sigma]", "1"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["dx", "2"], " ", 
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["\[Sigma]", "1"]}], "-", 
    RowBox[{
     SubscriptBox["dx", "1"], " ", 
     SubsuperscriptBox["x", "2", "2"], " ", 
     SubscriptBox["\[Sigma]", "1"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["dx", "3"], " ", 
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["\[Sigma]", "1"]}], "-", 
    RowBox[{
     SubscriptBox["dx", "1"], " ", 
     SubsuperscriptBox["x", "3", "2"], " ", 
     SubscriptBox["\[Sigma]", "1"]}], "-", 
    RowBox[{
     SubscriptBox["dx", "2"], " ", 
     SubsuperscriptBox["x", "1", "2"], " ", 
     SubscriptBox["\[Sigma]", "2"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["dx", "1"], " ", 
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["\[Sigma]", "2"]}], "-", 
    RowBox[{"3", " ", 
     SubscriptBox["dx", "2"], " ", 
     SubsuperscriptBox["x", "2", "2"], " ", 
     SubscriptBox["\[Sigma]", "2"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["dx", "3"], " ", 
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["\[Sigma]", "2"]}], "-", 
    RowBox[{
     SubscriptBox["dx", "2"], " ", 
     SubsuperscriptBox["x", "3", "2"], " ", 
     SubscriptBox["\[Sigma]", "2"]}], "-", 
    RowBox[{
     SubscriptBox["dx", "3"], " ", 
     SubsuperscriptBox["x", "1", "2"], " ", 
     SubscriptBox["\[Sigma]", "3"]}], "-", 
    RowBox[{
     SubscriptBox["dx", "3"], " ", 
     SubsuperscriptBox["x", "2", "2"], " ", 
     SubscriptBox["\[Sigma]", "3"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["dx", "1"], " ", 
     SubscriptBox["x", "1"], " ", 
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["\[Sigma]", "3"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["dx", "2"], " ", 
     SubscriptBox["x", "2"], " ", 
     SubscriptBox["x", "3"], " ", 
     SubscriptBox["\[Sigma]", "3"]}], "-", 
    RowBox[{"3", " ", 
     SubscriptBox["dx", "3"], " ", 
     SubsuperscriptBox["x", "3", "2"], " ", 
     SubscriptBox["\[Sigma]", "3"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["x", "3"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "2"]}]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["x", "2"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "3"]}]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["x", "3"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "1"]}]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["x", "1"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "3"]}]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["x", "2"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "1"]}]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["x", "1"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "3"], "\[Wedge]", 
      SubscriptBox["d\[Omega]", "2"]}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{
      SubscriptBox["dx", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{
      SubscriptBox["dx", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{
      SubscriptBox["dx", "3"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "0", "}"}], "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.b.10. Clean up", "Subsubsection"],

Cell[BoxData[
 RowBox[{"makeclear", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["ModifiedGlobalVariables"], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.c. More general algebras", "Subsection"],

Cell["This is taken from the file Miscellany_Demo.nb", "Text"],

Cell[CellGroupData[{

Cell["III.c.1. General comments", "Subsubsection"],

Cell[TextData[{
 "This section contains a miscellaneous collection of ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " calculations. Most of the operations used are introduced and explained in \
other sections. The first example treats the Dirac equation with quaternion \
matrices. The rest involve a variety of non-associative algebras.  Some of \
these exercises were suggested by the fine review book on non-associative \
algebras by Susumu Okubo:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[TextData[{
 StyleBox["Introduction to Octonion and Other Non-Associative Algebras in \
Physics",
  FontSlant->"Italic"],
 ", S. Okubo, Montroll Memorial Lecture Series in Mathematical Physics: 2, \
Cambridge University Press, 1995"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain",
 CellTags->"reference"]
}, Closed]],

Cell[CellGroupData[{

Cell["III.c.2. Quaternions", "Subsubsection"],

Cell["Setting up the quaternion algebra, H", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeelements", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Sigma]", "0"], ",", 
    SubscriptBox["\[Sigma]", "1"], ",", 
    SubscriptBox["\[Sigma]", "2"], ",", 
    SubscriptBox["\[Sigma]", "3"]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], ",", 
   SubscriptBox["\[Sigma]", "1"], ",", 
   SubscriptBox["\[Sigma]", "2"], ",", 
   SubscriptBox["\[Sigma]", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"H", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "0"]}], ",", 
       SubscriptBox["\[Sigma]", "3"], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "3"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "0"]}], ",", 
       SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "1"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "0"]}]}], "}"}]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"makealgebra", "[", "H", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", "0"], 
      SubscriptBox["\[Sigma]", "1"], 
      SubscriptBox["\[Sigma]", "2"], 
      SubscriptBox["\[Sigma]", "3"]},
     {
      SubscriptBox["\[Sigma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}], 
      SubscriptBox["\[Sigma]", "3"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "2"]}]},
     {
      SubscriptBox["\[Sigma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}], 
      SubscriptBox["\[Sigma]", "1"]},
     {
      SubscriptBox["\[Sigma]", "3"], 
      SubscriptBox["\[Sigma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["with three independent quaternions,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q1", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["X", "i"], 
     SubscriptBox["\[Sigma]", "i"]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["X", "0"], " ", 
   SubscriptBox["\[Sigma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["X", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["X", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["X", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q2", "=", 
  RowBox[{"q1", "/.", 
   RowBox[{"X", "->", "Y"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Y", "0"], " ", 
   SubscriptBox["\[Sigma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["Y", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["Y", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["Y", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q3", "=", 
  RowBox[{"q1", "/.", 
   RowBox[{"X", "->", "Z"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Z", "0"], " ", 
   SubscriptBox["\[Sigma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["Z", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["Z", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["Z", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.c.3. The Dirac equation using quaternions", "Subsubsection"],

Cell["\<\
A familiar 2\[Times]2 representation of Dirac matrices can be expressed by \
the quaternion elements, \[Sigma] ;\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "0"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", 
       SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
     RowBox[{"{", " ", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "1"], "=", 
   RowBox[{"I", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], ",", "0"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "2"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        SubscriptBox["\[Sigma]", "0"]}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "3"], "=", 
   RowBox[{"I", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], ",", "0"}], "}"}]}], "}"}]}]}], 
  ";"}]}], "Input"],

Cell[TextData[{
 "The operator ",
 StyleBox["CircleTimes", "Input",
  FontWeight->"Plain"],
 " multiplies matrices of ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " expressions, and for the squares of the \[CapitalGamma]'s gives the \
Lorentz signature, ",
 StyleBox["{-1,1,1,1}", "Input",
  FontWeight->"Plain"],
 "; i.e.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["\[CapitalGamma]", "0"]}], "\[CircleTimes]", 
   SubscriptBox["\[CapitalGamma]", "0"]}], "==", 
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "1"], "\[CircleTimes]", 
   SubscriptBox["\[CapitalGamma]", "1"]}], "==", 
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "2"], "\[CircleTimes]", 
   SubscriptBox["\[CapitalGamma]", "2"]}], "==", 
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "3"], "\[CircleTimes]", 
   SubscriptBox["\[CapitalGamma]", "3"]}], "==", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[TextData[{
 "where, as usual, the identity element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Sigma]", 
    RowBox[{"0", " "}]], TraditionalForm]]],
 "is suppressed in ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " results, but can be recovered using ",
 StyleBox["collect", "Input",
  FontWeight->"Plain"],
 ". They all anti-commute among themselves, and also with ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CapitalGamma]", "5"], TraditionalForm]]],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalGamma]", "5"], "=", 
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "0"], "\[CircleTimes]", 
   SubscriptBox["\[CapitalGamma]", "1"], "\[CircleTimes]", 
   SubscriptBox["\[CapitalGamma]", "2"], "\[CircleTimes]", 
   SubscriptBox["\[CapitalGamma]", "3"]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      SubscriptBox["\[Sigma]", "0"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalGamma]", "5"], "\[CircleTimes]", 
  SubscriptBox["\[CapitalGamma]", "5"]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Make the coefficients of ",
 StyleBox["q1", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["q2", "Input",
  FontWeight->"Plain"],
 " into scalar variables,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"coeffs", "[", "q1", "]"}], ",", 
    RowBox[{"coeffs", "[", "q2", "]"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["X", "0"], ",", 
   SubscriptBox["X", "1"], ",", 
   SubscriptBox["X", "2"], ",", 
   SubscriptBox["X", "3"], ",", 
   SubscriptBox["Y", "0"], ",", 
   SubscriptBox["Y", "1"], ",", 
   SubscriptBox["Y", "2"], ",", 
   SubscriptBox["Y", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and define a quaternion-valued 2-vector ",
 StyleBox["qV", "Input",
  FontWeight->"Plain"],
 " to represent the Dirac field,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"qV", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "q1", "}"}], ",", 
     RowBox[{"{", "q2", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"mtx", "[", "qV", "]"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        SubscriptBox["X", "0"], " ", 
        SubscriptBox["\[Sigma]", "0"]}], "+", 
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        SubscriptBox["\[Sigma]", "1"]}], "+", 
       RowBox[{
        SubscriptBox["X", "2"], " ", 
        SubscriptBox["\[Sigma]", "2"]}], "+", 
       RowBox[{
        SubscriptBox["X", "3"], " ", 
        SubscriptBox["\[Sigma]", "3"]}]}]},
     {
      RowBox[{
       RowBox[{
        SubscriptBox["Y", "0"], " ", 
        SubscriptBox["\[Sigma]", "0"]}], "+", 
       RowBox[{
        SubscriptBox["Y", "1"], " ", 
        SubscriptBox["\[Sigma]", "1"]}], "+", 
       RowBox[{
        SubscriptBox["Y", "2"], " ", 
        SubscriptBox["\[Sigma]", "2"]}], "+", 
       RowBox[{
        SubscriptBox["Y", "3"], " ", 
        SubscriptBox["\[Sigma]", "3"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Introducing a new set of ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 " called ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " will automatically construct partial derivative expansions for the \
exterior derivatives of ",
 StyleBox["q1", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["q2", "Input",
  FontWeight->"Plain"],
 ", and these expressions are incorporated in ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " by the ",
 StyleBox["makecoords", "Input",
  FontWeight->"Plain"],
 " command, as is described more fully in the sectioin on LieDerivative below."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["scalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "x", ",", "y", ",", "z", ",", 
   SubscriptBox["X", "0"], ",", 
   SubscriptBox["X", "1"], ",", 
   SubscriptBox["X", "2"], ",", 
   SubscriptBox["X", "3"], ",", 
   SubscriptBox["Y", "0"], ",", 
   SubscriptBox["Y", "1"], ",", 
   SubscriptBox["Y", "2"], ",", 
   SubscriptBox["Y", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell["Thus,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "q1", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["dX", "0"], "+", 
  RowBox[{
   SubscriptBox["dX", "1"], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["dX", "2"], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["dX", "3"], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{"applydrules", "[", "%", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["X", "0"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["X", "0"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["X", "0"], "x"]}], "+", 
     RowBox[{"dt", " ", 
      SubscriptBox[
       SubscriptBox["X", "0"], "t"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "x"]}], "+", 
     RowBox[{"dt", " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "t"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "x"]}], "+", 
     RowBox[{"dt", " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "t"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "x"]}], "+", 
     RowBox[{"dt", " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "t"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "or equivalently, using the compound operator, ",
 StyleBox["da[arg] = applydrules[d[arg]]", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{"da", "[", "q1", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["X", "0"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["X", "0"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["X", "0"], "x"]}], "+", 
     RowBox[{"dt", " ", 
      SubscriptBox[
       SubscriptBox["X", "0"], "t"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "x"]}], "+", 
     RowBox[{"dt", " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "t"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "x"]}], "+", 
     RowBox[{"dt", " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "t"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"dz", " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "z"]}], "+", 
     RowBox[{"dy", " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "y"]}], "+", 
     RowBox[{"dx", " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "x"]}], "+", 
     RowBox[{"dt", " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "t"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "A particular partial derivative of an ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " expression, or list, is given either by the coordinate name appearing as a \
subscript on D,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["D", "x"], "[", "qV", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      SubscriptBox["X", "0"], "x"], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "x"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "x"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "3"], " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "x"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      SubscriptBox["Y", "0"], "x"], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], " ", 
      SubscriptBox[
       SubscriptBox["Y", "1"], "x"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], " ", 
      SubscriptBox[
       SubscriptBox["Y", "2"], "x"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "3"], " ", 
      SubscriptBox[
       SubscriptBox["Y", "3"], "x"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "or by the position of the coordinate variable in the ",
 StyleBox["coords", "Input",
  FontWeight->"Plain"],
 " list,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["D", "1"], "[", "qV", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      SubscriptBox["X", "0"], "t"], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], " ", 
      SubscriptBox[
       SubscriptBox["X", "1"], "t"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], " ", 
      SubscriptBox[
       SubscriptBox["X", "2"], "t"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "3"], " ", 
      SubscriptBox[
       SubscriptBox["X", "3"], "t"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      SubscriptBox["Y", "0"], "t"], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], " ", 
      SubscriptBox[
       SubscriptBox["Y", "1"], "t"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], " ", 
      SubscriptBox[
       SubscriptBox["Y", "2"], "t"]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "3"], " ", 
      SubscriptBox[
       SubscriptBox["Y", "3"], "t"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The Dirac equation can then be written as the quaternion-valued 2-vector \
equation,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dirac", "=", 
  RowBox[{"collect", "[", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "3"], 
     RowBox[{"I", " ", 
      RowBox[{
       SubscriptBox["\[CapitalGamma]", "i"], "\[CircleTimes]", 
       RowBox[{
        SubscriptBox["D", 
         RowBox[{"i", "+", "1"}]], "[", "qV", "]"}]}]}]}], "+", 
    RowBox[{"I", " ", "m", " ", 
     RowBox[{
      SubscriptBox["\[CapitalGamma]", "5"], "\[CircleTimes]", "qV"}]}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", 
         SubscriptBox["Y", "2"]}], "-", 
        SubscriptBox[
         SubscriptBox["Y", "1"], "z"], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["X", "2"], "y"]}], "+", 
        SubscriptBox[
         SubscriptBox["Y", "3"], "x"], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["Y", "0"], "t"]}]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", 
         SubscriptBox["Y", "3"]}], "-", 
        SubscriptBox[
         SubscriptBox["Y", "0"], "z"], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["X", "3"], "y"]}], "-", 
        SubscriptBox[
         SubscriptBox["Y", "2"], "x"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["Y", "1"], "t"]}]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", 
         SubscriptBox["Y", "0"]}], "+", 
        SubscriptBox[
         SubscriptBox["Y", "3"], "z"], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["X", "0"], "y"]}], "+", 
        SubscriptBox[
         SubscriptBox["Y", "1"], "x"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["Y", "2"], "t"]}]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", 
         SubscriptBox["Y", "1"]}], "+", 
        SubscriptBox[
         SubscriptBox["Y", "2"], "z"], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["X", "1"], "y"]}], "-", 
        SubscriptBox[
         SubscriptBox["Y", "0"], "x"], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["Y", "3"], "t"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "m", " ", 
         SubscriptBox["X", "2"]}], "-", 
        SubscriptBox[
         SubscriptBox["X", "1"], "z"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["Y", "2"], "y"]}], "+", 
        SubscriptBox[
         SubscriptBox["X", "3"], "x"], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["X", "0"], "t"]}]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "m", " ", 
         SubscriptBox["X", "3"]}], "-", 
        SubscriptBox[
         SubscriptBox["X", "0"], "z"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["Y", "3"], "y"]}], "-", 
        SubscriptBox[
         SubscriptBox["X", "2"], "x"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["X", "1"], "t"]}]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "m", " ", 
         SubscriptBox["X", "0"]}], "+", 
        SubscriptBox[
         SubscriptBox["X", "3"], "z"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["Y", "0"], "y"]}], "+", 
        SubscriptBox[
         SubscriptBox["X", "1"], "x"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["X", "2"], "t"]}]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "m", " ", 
         SubscriptBox["X", "1"]}], "+", 
        SubscriptBox[
         SubscriptBox["X", "2"], "z"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["Y", "1"], "y"]}], "-", 
        SubscriptBox[
         SubscriptBox["X", "0"], "x"], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox[
          SubscriptBox["X", "3"], "t"]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell["\<\
and applying the same operator a second time returns the Klein-Gordon \
equation for each quaternion component,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KG", "=", 
  RowBox[{"collect", "[", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "3"], 
     RowBox[{"I", " ", 
      RowBox[{
       SubscriptBox["\[CapitalGamma]", "i"], "\[CircleTimes]", 
       RowBox[{
        SubscriptBox["D", 
         RowBox[{"i", "+", "1"}]], "[", "dirac", "]"}]}]}]}], "+", 
    RowBox[{"I", " ", "m", " ", 
     RowBox[{
      SubscriptBox["\[CapitalGamma]", "5"], "\[CircleTimes]", " ", 
      "dirac"}]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Sigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SubscriptBox["X", "0"]}], "-", 
        SubscriptBox[
         SubscriptBox["X", "0"], "\<\"zz\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["X", "0"], "\<\"yy\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["X", "0"], "\<\"xx\"\>"], "+", 
        SubscriptBox[
         SubscriptBox["X", "0"], "\<\"tt\"\>"]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SubscriptBox["X", "1"]}], "-", 
        SubscriptBox[
         SubscriptBox["X", "1"], "\<\"zz\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["X", "1"], "\<\"yy\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["X", "1"], "\<\"xx\"\>"], "+", 
        SubscriptBox[
         SubscriptBox["X", "1"], "\<\"tt\"\>"]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SubscriptBox["X", "2"]}], "-", 
        SubscriptBox[
         SubscriptBox["X", "2"], "\<\"zz\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["X", "2"], "\<\"yy\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["X", "2"], "\<\"xx\"\>"], "+", 
        SubscriptBox[
         SubscriptBox["X", "2"], "\<\"tt\"\>"]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SubscriptBox["X", "3"]}], "-", 
        SubscriptBox[
         SubscriptBox["X", "3"], "\<\"zz\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["X", "3"], "\<\"yy\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["X", "3"], "\<\"xx\"\>"], "+", 
        SubscriptBox[
         SubscriptBox["X", "3"], "\<\"tt\"\>"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Sigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SubscriptBox["Y", "0"]}], "-", 
        SubscriptBox[
         SubscriptBox["Y", "0"], "\<\"zz\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["Y", "0"], "\<\"yy\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["Y", "0"], "\<\"xx\"\>"], "+", 
        SubscriptBox[
         SubscriptBox["Y", "0"], "\<\"tt\"\>"]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SubscriptBox["Y", "1"]}], "-", 
        SubscriptBox[
         SubscriptBox["Y", "1"], "\<\"zz\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["Y", "1"], "\<\"yy\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["Y", "1"], "\<\"xx\"\>"], "+", 
        SubscriptBox[
         SubscriptBox["Y", "1"], "\<\"tt\"\>"]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SubscriptBox["Y", "2"]}], "-", 
        SubscriptBox[
         SubscriptBox["Y", "2"], "\<\"zz\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["Y", "2"], "\<\"yy\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["Y", "2"], "\<\"xx\"\>"], "+", 
        SubscriptBox[
         SubscriptBox["Y", "2"], "\<\"tt\"\>"]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Sigma]", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SubscriptBox["Y", "3"]}], "-", 
        SubscriptBox[
         SubscriptBox["Y", "3"], "\<\"zz\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["Y", "3"], "\<\"yy\"\>"], "-", 
        SubscriptBox[
         SubscriptBox["Y", "3"], "\<\"xx\"\>"], "+", 
        SubscriptBox[
         SubscriptBox["Y", "3"], "\<\"tt\"\>"]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.c.4. General algebras", "Subsubsection"],

Cell[TextData[{
 "The ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " table may contain unspecified parameters in the products. For example, the \
procedure ",
 StyleBox["generic[]", "Input",
  FontWeight->"Plain"],
 " constructs a completely general algebra for ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " using structure parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["sy", 
     RowBox[{"i", ",", "j", ",", "k"}]], "Input"], TraditionalForm]]],
 " which are symmetric in the {j,k} indices and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["sk", 
     RowBox[{"i", ",", "j", ",", "k"}]], "Input"], TraditionalForm]]],
 "which are skew-symmetric in {j,k}. The indices {i,j,k} start at (0,1,1) \
with 0 denoting the \"identity\" element. Only the independent parameters \
with j \[LessEqual] k are defined. The algebra can be established by:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"makealgebra", "[", 
  RowBox[{"generic", "[", "]"}], "]"}]], "Input"],

Cell[TextData[{
 "and so with the present ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " constructs the lists ",
 StyleBox["symm", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["skew", "Input",
  FontWeight->"Plain"],
 " and the generic algebra"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[TextData[{
 "                                              ",
 Cell[BoxData[
  FormBox[
   RowBox[{"      ", 
    RowBox[{
     FormBox[
      SubscriptBox["\[Sigma]", "j"],
      TraditionalForm], 
     SubscriptBox["\[Sigma]", "k"]}]}], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   UnderscriptBox["\[CapitalSigma]", "i"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"  ", 
     FormBox[
      RowBox[{
       FormBox[
        RowBox[{"(", " ", 
         SubscriptBox["sy", 
          RowBox[{"i", ",", "j", ",", "k"}]]}],
        TraditionalForm], "+", 
       SubscriptBox["sk", 
        RowBox[{"i", ",", "j", ",", "k"}]]}],
      TraditionalForm], ")"}], 
    SubscriptBox["\[Sigma]", "i"]}], TraditionalForm]]],
 "                     "
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["symm"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["sy", 
    RowBox[{"0", ",", "1", ",", "1"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"0", ",", "1", ",", "2"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"0", ",", "1", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"0", ",", "2", ",", "2"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"0", ",", "2", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"0", ",", "3", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"1", ",", "1", ",", "1"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"1", ",", "1", ",", "2"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"1", ",", "1", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"1", ",", "2", ",", "2"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"1", ",", "2", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"1", ",", "3", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"2", ",", "1", ",", "1"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"2", ",", "1", ",", "2"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"2", ",", "1", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"2", ",", "2", ",", "2"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"2", ",", "2", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"2", ",", "3", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"3", ",", "1", ",", "1"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"3", ",", "1", ",", "2"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"3", ",", "1", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"3", ",", "2", ",", "2"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"3", ",", "2", ",", "3"}]], ",", 
   SubscriptBox["sy", 
    RowBox[{"3", ",", "3", ",", "3"}]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["skew"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["sk", 
    RowBox[{"0", ",", "1", ",", "2"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"0", ",", "1", ",", "3"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"0", ",", "2", ",", "3"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"1", ",", "1", ",", "2"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"1", ",", "1", ",", "3"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"1", ",", "2", ",", "3"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"2", ",", "1", ",", "2"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"2", ",", "1", ",", "3"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"2", ",", "2", ",", "3"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"3", ",", "1", ",", "2"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"3", ",", "1", ",", "3"}]], ",", 
   SubscriptBox["sk", 
    RowBox[{"3", ",", "2", ",", "3"}]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", "0"], 
      SubscriptBox["\[Sigma]", "1"], 
      SubscriptBox["\[Sigma]", "2"], 
      SubscriptBox["\[Sigma]", "3"]},
     {
      SubscriptBox["\[Sigma]", "1"], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], " ", 
        SubscriptBox["sy", 
         RowBox[{"0", ",", "1", ",", "1"}]]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        SubscriptBox["sy", 
         RowBox[{"1", ",", "1", ",", "1"}]]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        SubscriptBox["sy", 
         RowBox[{"2", ",", "1", ",", "1"}]]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        SubscriptBox["sy", 
         RowBox[{"3", ",", "1", ",", "1"}]]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"0", ",", "1", ",", "2"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"0", ",", "1", ",", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"1", ",", "1", ",", "2"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"1", ",", "1", ",", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"2", ",", "1", ",", "2"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"2", ",", "1", ",", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"3", ",", "1", ",", "2"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"3", ",", "1", ",", "2"}]]}], ")"}]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"0", ",", "1", ",", "3"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"0", ",", "1", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"1", ",", "1", ",", "3"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"1", ",", "1", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"2", ",", "1", ",", "3"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"2", ",", "1", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"3", ",", "1", ",", "3"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"3", ",", "1", ",", "3"}]]}], ")"}]}]}]},
     {
      SubscriptBox["\[Sigma]", "2"], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"0", ",", "1", ",", "2"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"0", ",", "1", ",", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"1", ",", "1", ",", "2"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"1", ",", "1", ",", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"2", ",", "1", ",", "2"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"2", ",", "1", ",", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"3", ",", "1", ",", "2"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"3", ",", "1", ",", "2"}]]}], ")"}]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], " ", 
        SubscriptBox["sy", 
         RowBox[{"0", ",", "2", ",", "2"}]]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        SubscriptBox["sy", 
         RowBox[{"1", ",", "2", ",", "2"}]]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        SubscriptBox["sy", 
         RowBox[{"2", ",", "2", ",", "2"}]]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        SubscriptBox["sy", 
         RowBox[{"3", ",", "2", ",", "2"}]]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"0", ",", "2", ",", "3"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"0", ",", "2", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"1", ",", "2", ",", "3"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"1", ",", "2", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"2", ",", "2", ",", "3"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"2", ",", "2", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["sk", 
           RowBox[{"3", ",", "2", ",", "3"}]], "+", 
          SubscriptBox["sy", 
           RowBox[{"3", ",", "2", ",", "3"}]]}], ")"}]}]}]},
     {
      SubscriptBox["\[Sigma]", "3"], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"0", ",", "1", ",", "3"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"0", ",", "1", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"1", ",", "1", ",", "3"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"1", ",", "1", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"2", ",", "1", ",", "3"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"2", ",", "1", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"3", ",", "1", ",", "3"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"3", ",", "1", ",", "3"}]]}], ")"}]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"0", ",", "2", ",", "3"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"0", ",", "2", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"1", ",", "2", ",", "3"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"1", ",", "2", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"2", ",", "2", ",", "3"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"2", ",", "2", ",", "3"}]]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["sk", 
            RowBox[{"3", ",", "2", ",", "3"}]]}], "+", 
          SubscriptBox["sy", 
           RowBox[{"3", ",", "2", ",", "3"}]]}], ")"}]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], " ", 
        SubscriptBox["sy", 
         RowBox[{"0", ",", "3", ",", "3"}]]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "1"], " ", 
        SubscriptBox["sy", 
         RowBox[{"1", ",", "3", ",", "3"}]]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "2"], " ", 
        SubscriptBox["sy", 
         RowBox[{"2", ",", "3", ",", "3"}]]}], "+", 
       RowBox[{
        SubscriptBox["\[Sigma]", "3"], " ", 
        SubscriptBox["sy", 
         RowBox[{"3", ",", "3", ",", "3"}]]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Either ",
 StyleBox["Expand", "Input",
  FontWeight->"Plain"],
 " or ",
 StyleBox["collect", "Input",
  FontWeight->"Plain"],
 " can be used to obtain appropriate cancellations here;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"commutator", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], "**", 
     SubscriptBox["\[Sigma]", "2"]}], "-", 
    RowBox[{
     SubscriptBox["\[Sigma]", "2"], "**", 
     SubscriptBox["\[Sigma]", "1"]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["sk", 
    RowBox[{"0", ",", "1", ",", "2"}]]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["sk", 
    RowBox[{"1", ",", "1", ",", "2"}]]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["sk", 
    RowBox[{"2", ",", "1", ",", "2"}]]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["sk", 
    RowBox[{"3", ",", "1", ",", "2"}]]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"anticommutator", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], "**", 
     SubscriptBox["\[Sigma]", "2"]}], "+", 
    RowBox[{
     SubscriptBox["\[Sigma]", "2"], "**", 
     SubscriptBox["\[Sigma]", "1"]}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["sy", 
    RowBox[{"0", ",", "1", ",", "2"}]]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "1"], " ", 
   SubscriptBox["sy", 
    RowBox[{"1", ",", "1", ",", "2"}]]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "2"], " ", 
   SubscriptBox["sy", 
    RowBox[{"2", ",", "1", ",", "2"}]]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Sigma]", "3"], " ", 
   SubscriptBox["sy", 
    RowBox[{"3", ",", "1", ",", "2"}]]}]}]], "Output"]
}, Open  ]],

Cell["The arbitrary algebra is non-associative,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], "**", 
      SubscriptBox["\[Sigma]", "2"]}], ")"}], "**", 
    SubscriptBox["\[Sigma]", "1"]}], "-", 
   RowBox[{
    SubscriptBox["\[Sigma]", "1"], "**", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Sigma]", "2"], "**", 
      SubscriptBox["\[Sigma]", "1"]}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "1", ",", "1"}]]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "1", ",", "3"}]]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"0", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "2"}]]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"0", ",", "1", ",", "3"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "2"}]]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"0", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "1", ",", "1"}]]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "1", ",", "3"}]]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "2"}]]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "3"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "2"}]]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "1"}]]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "3"}]]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "1", ",", "3"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "2"}]]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "1"}]]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "2"}]]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "3"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "2"}]], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "3"}]]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["generic[]", "Input",
  FontWeight->"Plain"],
 " product of ",
 StyleBox["q1", "Input",
  FontWeight->"Plain"],
 " and ",
 StyleBox["q2", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{"q1", "**", "q2"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "0"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "0"], " ", 
      SubscriptBox["Y", "0"]}], "-", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sk", 
       RowBox[{"0", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sk", 
       RowBox[{"0", ",", "1", ",", "2"}]]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sk", 
       RowBox[{"0", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sk", 
       RowBox[{"0", ",", "1", ",", "3"}]]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sk", 
       RowBox[{"0", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sk", 
       RowBox[{"0", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "1", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "2", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"0", ",", "3", ",", "3"}]]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "0"]}], "+", 
     RowBox[{
      SubscriptBox["X", "0"], " ", 
      SubscriptBox["Y", "1"]}], "-", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "2"}]]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "1", ",", "3"}]]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sk", 
       RowBox[{"1", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "1", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "2", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"1", ",", "3", ",", "3"}]]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "0"]}], "+", 
     RowBox[{
      SubscriptBox["X", "0"], " ", 
      SubscriptBox["Y", "2"]}], "-", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "1", ",", "2"}]]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "1", ",", "3"}]]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sk", 
       RowBox[{"2", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "2", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"2", ",", "3", ",", "3"}]]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "0"]}], "+", 
     RowBox[{
      SubscriptBox["X", "0"], " ", 
      SubscriptBox["Y", "3"]}], "-", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "2"}]]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "1", ",", "3"}]]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sk", 
       RowBox[{"3", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "1"], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "2", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "2"], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "3"], " ", 
      SubscriptBox["sy", 
       RowBox[{"3", ",", "3", ",", "3"}]]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "One application of ",
 StyleBox["generic[]", "Input",
  FontWeight->"Plain"],
 " is simply to solve for the structure constants of a given algebra table. \
The subroutine, ",
 StyleBox["structure[]", "Input",
  FontWeight->"Plain"],
 ", gives the solution:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"structure", "[", "arg_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"diff", ",", "eqns"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"makealgebra", "[", 
       RowBox[{"generic", "[", "]"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"diff", "=", 
       RowBox[{"collect", "[", 
        RowBox[{"arg", "-", "algebra"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"eqns", "=", 
       RowBox[{"setzero", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Map", "[", 
          RowBox[{"coeffs", ",", 
           RowBox[{"Flatten", "[", "diff", "]"}]}], "]"}], "]"}], "]"}]}], 
      ";", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Solve", "[", 
        RowBox[{"eqns", ",", 
         RowBox[{"Join", "[", 
          RowBox[{"skew", ",", "symm"}], "]"}]}], "]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input"],

Cell["For H,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"constants", "=", 
  RowBox[{"structure", "[", "H", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"0", ",", "1", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"0", ",", "1", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"0", ",", "2", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"1", ",", "1", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"1", ",", "1", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"1", ",", "2", ",", "3"}]], "\[Rule]", "1"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"2", ",", "1", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"2", ",", "1", ",", "3"}]], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"2", ",", "2", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"3", ",", "1", ",", "2"}]], "\[Rule]", "1"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"3", ",", "1", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sk", 
     RowBox[{"3", ",", "2", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"0", ",", "1", ",", "1"}]], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"0", ",", "1", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"0", ",", "1", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"0", ",", "2", ",", "2"}]], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"0", ",", "2", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"0", ",", "3", ",", "3"}]], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"1", ",", "1", ",", "1"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"1", ",", "1", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"1", ",", "1", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"1", ",", "2", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"1", ",", "2", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"1", ",", "3", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"2", ",", "1", ",", "1"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"2", ",", "1", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"2", ",", "1", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"2", ",", "2", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"2", ",", "2", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"2", ",", "3", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"3", ",", "1", ",", "1"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"3", ",", "1", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"3", ",", "1", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"3", ",", "2", ",", "2"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"3", ",", "2", ",", "3"}]], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["sy", 
     RowBox[{"3", ",", "3", ",", "3"}]], "\[Rule]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["The quaternion product can be recovered by,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{
   RowBox[{"q1", "**", "q2"}], "/.", "constants"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "0"], " ", 
      SubscriptBox["Y", "0"]}], "-", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "1"]}], "-", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "2"]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "3"]}]}], ")"}], " ", 
   SubscriptBox["\[Sigma]", "0"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "0"]}], "+", 
     RowBox[{
      SubscriptBox["X", "0"], " ", 
      SubscriptBox["Y", "1"]}], "-", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "2"]}], "+", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "3"]}]}], ")"}], " ", 
   SubscriptBox["\[Sigma]", "1"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "0"]}], "+", 
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "1"]}], "+", 
     RowBox[{
      SubscriptBox["X", "0"], " ", 
      SubscriptBox["Y", "2"]}], "-", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "3"]}]}], ")"}], " ", 
   SubscriptBox["\[Sigma]", "2"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "3"], " ", 
      SubscriptBox["Y", "0"]}], "-", 
     RowBox[{
      SubscriptBox["X", "2"], " ", 
      SubscriptBox["Y", "1"]}], "+", 
     RowBox[{
      SubscriptBox["X", "1"], " ", 
      SubscriptBox["Y", "2"]}], "+", 
     RowBox[{
      SubscriptBox["X", "0"], " ", 
      SubscriptBox["Y", "3"]}]}], ")"}], " ", 
   SubscriptBox["\[Sigma]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and H is restored as the active ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " by replacing the constants in the current generic algebra,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"makealgebra", "[", 
  RowBox[{"algebra", "/.", "constants"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", "0"], 
      SubscriptBox["\[Sigma]", "1"], 
      SubscriptBox["\[Sigma]", "2"], 
      SubscriptBox["\[Sigma]", "3"]},
     {
      SubscriptBox["\[Sigma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}], 
      SubscriptBox["\[Sigma]", "3"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "2"]}]},
     {
      SubscriptBox["\[Sigma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}], 
      SubscriptBox["\[Sigma]", "1"]},
     {
      SubscriptBox["\[Sigma]", "3"], 
      SubscriptBox["\[Sigma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Sigma]", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
The generic algebra may not be of much use beyond demonstrating generality; \
i.e., one can use p-form AVFs defined over: Clifford, Lie, and Jordan \
algebras, other non-associative(e.g., octonion) algebras, gauge group \
algebras, and superalgebras.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"symm", ",", "skew"}], "]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["III.c.5. Derived algebras", "Subsubsection"],

Cell[TextData[{
 "The non-associative derived algebras, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "-"], TraditionalForm]]],
 "  and  ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "+"], TraditionalForm]]],
 ", for AVFs may also be defined: (",
 ButtonBox["see Okubo, p.19",
  BaseStyle->"Hyperlink",
  ButtonData:>"reference"],
 "). In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", they can be easily input using the following two infix operators:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell["The commutator function for AVFs, typed by esc- c- -esc;", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CircleMinus", "[", 
   RowBox[{"arg1_", ",", "arg2_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"arg1", "**", 
    RowBox[{"(", 
     RowBox[{"arg2", "/", "2"}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"arg2", "/", "2"}], ")"}], "**", "arg1"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "[", "q1", "]"}], "\[CircleMinus]", 
  RowBox[{"d", "[", "q2", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["dX", "0"], "\[Wedge]", 
   SubscriptBox["dY", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{
    SubscriptBox["dX", "0"], "\[Wedge]", 
    SubscriptBox["dY", "1"]}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{
    SubscriptBox["dX", "0"], "\[Wedge]", 
    SubscriptBox["dY", "2"]}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{
    SubscriptBox["dX", "0"], "\[Wedge]", 
    SubscriptBox["dY", "3"]}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{
    SubscriptBox["dX", "1"], "\[Wedge]", 
    SubscriptBox["dY", "0"]}]}], "-", 
  RowBox[{
   SubscriptBox["dX", "1"], "\[Wedge]", 
   SubscriptBox["dY", "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{
    SubscriptBox["dX", "2"], "\[Wedge]", 
    SubscriptBox["dY", "0"]}]}], "-", 
  RowBox[{
   SubscriptBox["dX", "2"], "\[Wedge]", 
   SubscriptBox["dY", "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{
    SubscriptBox["dX", "3"], "\[Wedge]", 
    SubscriptBox["dY", "0"]}]}], "-", 
  RowBox[{
   SubscriptBox["dX", "3"], "\[Wedge]", 
   SubscriptBox["dY", "3"]}]}]], "Output"]
}, Open  ]],

Cell["\<\
The anti-commutator function for AVFs, typed by esc- c+ -esc;\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CirclePlus", "[", 
   RowBox[{"arg1_", ",", "arg2_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"arg1", "**", 
    RowBox[{"(", 
     RowBox[{"arg2", "/", "2"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"arg2", "/", "2"}], ")"}], "**", "arg1"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "[", "q1", "]"}], "\[CirclePlus]", 
  RowBox[{"d", "[", "q2", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{
    SubscriptBox["dX", "1"], "\[Wedge]", 
    SubscriptBox["dY", "2"]}]}], "-", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{
    SubscriptBox["dX", "1"], "\[Wedge]", 
    SubscriptBox["dY", "3"]}]}], "-", 
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], " ", 
   RowBox[{
    SubscriptBox["dX", "2"], "\[Wedge]", 
    SubscriptBox["dY", "1"]}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{
    SubscriptBox["dX", "2"], "\[Wedge]", 
    SubscriptBox["dY", "3"]}]}], "+", 
  RowBox[{
   SubscriptBox["\[Sigma]", "2"], " ", 
   RowBox[{
    SubscriptBox["dX", "3"], "\[Wedge]", 
    SubscriptBox["dY", "1"]}]}], "-", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], " ", 
   RowBox[{
    SubscriptBox["dX", "3"], "\[Wedge]", 
    SubscriptBox["dY", "2"]}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "For an associative underlying algebra, such as H , operator \[CircleMinus] \
defines a Lie-algebra, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "-"], TraditionalForm]]],
 ", over AVFs with the Jacobi identity,"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "q1", "]"}], "\[CircleMinus]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", "q2", "]"}], "\[CircleMinus]", "q3"}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"d", "[", "q2", "]"}], "\[CircleMinus]", 
   RowBox[{"(", 
    RowBox[{"q3", "\[CircleMinus]", 
     RowBox[{"d", "[", "q1", "]"}]}], ")"}]}], "+", 
  RowBox[{"q3", "\[CircleMinus]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", "q1", "]"}], "\[CircleMinus]", 
     RowBox[{"d", "[", "q2", "]"}]}], ")"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "and the \[CirclePlus] operator gives a special Jordan algebra, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "+"], TraditionalForm]]],
 ", satisfying the Jordan identity,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d", "[", "q1", "]"}], "**", 
       RowBox[{"d", "[", "q1", "]"}]}], ")"}], "\[CirclePlus]", "q3"}], ")"}],
    "\[CirclePlus]", 
   RowBox[{"d", "[", "q1", "]"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", "q1", "]"}], "**", 
     RowBox[{"d", "[", "q1", "]"}]}], ")"}], "\[CirclePlus]", 
   RowBox[{"(", 
    RowBox[{"q3", "\[CirclePlus]", 
     RowBox[{"d", "[", "q1", "]"}]}], ")"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["\<\
The following joint identity also holds in the underlying associative case, \
as well as in some special non-associative cases,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "q1", "]"}], "\[CircleMinus]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", "q2", "]"}], "\[CirclePlus]", "q3"}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", "q1", "]"}], "\[CircleMinus]", 
     RowBox[{"d", "[", "q2", "]"}]}], ")"}], "\[CirclePlus]", "q3"}], "-", 
  RowBox[{
   RowBox[{"d", "[", "q2", "]"}], "\[CirclePlus]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", "q1", "]"}], "\[CircleMinus]", "q3"}], 
    ")"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["\<\
and that expression implies the cyclic super-Jacobi identity,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "q1", "]"}], "\[CircleMinus]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", "q2", "]"}], "\[CirclePlus]", "q3"}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"d", "[", "q2", "]"}], "\[CircleMinus]", 
   RowBox[{"(", 
    RowBox[{"q3", "\[CirclePlus]", 
     RowBox[{"d", "[", "q1", "]"}]}], ")"}]}], "+", 
  RowBox[{"q3", "\[CircleMinus]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d", "[", "q1", "]"}], "\[CirclePlus]", 
     RowBox[{"d", "[", "q2", "]"}]}], ")"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "These operations are not supplied in ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " as reserved functions, but can be introduced as above."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["III.c.6. Generating a Lie algebra", "Subsubsection",
 PageBreakAbove->True],

Cell[TextData[{
 "We start with the associative Clifford algebra, ",
 StyleBox["signature={-1,1,1,1}", "Input",
  FontWeight->"Plain"],
 ", but with the algebra table truncated to grade(2) products;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"makeclifford", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1"}], "}"}], ",", "2"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["elements"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Gamma]", "0"], ",", 
   SubscriptBox["\[Gamma]", "1"], ",", 
   SubscriptBox["\[Gamma]", "2"], ",", 
   SubscriptBox["\[Gamma]", "3"], ",", 
   SubscriptBox["\[Gamma]", "4"], ",", 
   SubscriptBox["\[Gamma]", "12"], ",", 
   SubscriptBox["\[Gamma]", "13"], ",", 
   SubscriptBox["\[Gamma]", "14"], ",", 
   SubscriptBox["\[Gamma]", "23"], ",", 
   SubscriptBox["\[Gamma]", "24"], ",", 
   SubscriptBox["\[Gamma]", "34"], ",", 
   SubscriptBox["\[Gamma]", "15"], ",", 
   SubscriptBox["\[Gamma]", "25"], ",", 
   SubscriptBox["\[Gamma]", "35"], ",", 
   SubscriptBox["\[Gamma]", "45"], ",", 
   SubscriptBox["\[Gamma]", "5"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The full ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " list must be retained, since they all appear in ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 ", though products of grades higher than grade(2) cannot be performed."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "1"], 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "4"], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "34"]},
     {
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      SubscriptBox["\[Gamma]", "35"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}]},
     {
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], 
      SubscriptBox["\[Gamma]", "45"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "35"]}], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}]},
     {
      SubscriptBox["\[Gamma]", "3"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], 
      SubscriptBox["\[Gamma]", "25"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      SubscriptBox["\[Gamma]", "15"], 
      SubscriptBox["\[Gamma]", "4"]},
     {
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "35"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}]},
     {
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      SubscriptBox["\[Gamma]", "35"], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      SubscriptBox["\[Gamma]", "5"]},
     {
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "45"], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "5"]}], 
      SubscriptBox["\[Gamma]", "14"]},
     {
      SubscriptBox["\[Gamma]", "14"], 
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "35"]}], 
      SubscriptBox["\[Gamma]", "25"], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}]},
     {
      SubscriptBox["\[Gamma]", "23"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "24"]},
     {
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "35"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      SubscriptBox["\[Gamma]", "15"], 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "5"]}], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}]},
     {
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      SubscriptBox["\[Gamma]", "13"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      SubscriptBox["\[Gamma]", "23"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The table of commutator products for the truncated ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " is given by"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"liealg", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"algebra", "-", 
      RowBox[{"Transpose", "[", "algebra", "]"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mtx", "[", "liealg", "]"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], "0", "0", "0"},
     {"0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], "0", 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], "0", "0", 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "4"], "0"},
     {"0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], "0", 
      SubscriptBox["\[Gamma]", "34"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], "0", 
      SubscriptBox["\[Gamma]", "4"]},
     {"0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], "0", "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}]},
     {"0", 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "1"], "0", "0", "0", 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], "0"},
     {"0", 
      SubscriptBox["\[Gamma]", "3"], "0", 
      SubscriptBox["\[Gamma]", "1"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], "0", 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], "0", 
      SubscriptBox["\[Gamma]", "14"]},
     {"0", 
      SubscriptBox["\[Gamma]", "4"], "0", "0", 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}]},
     {"0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      SubscriptBox["\[Gamma]", "2"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      SubscriptBox["\[Gamma]", "12"], "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "24"]},
     {"0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], "0", 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], "0", 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "34"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}]},
     {"0", "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      SubscriptBox["\[Gamma]", "3"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      SubscriptBox["\[Gamma]", "13"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      SubscriptBox["\[Gamma]", "23"], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and this closed 10-dimensional Lie algebra, isomorphic to so(3,2), can be \
the established ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[TextData[{
 "Some remarks are necessary here:\n\nThe Lie algebras are among those that \
do not include an ",
 StyleBox["identity", "Input",
  FontWeight->"Plain"],
 " element. However, ",
 StyleBox["identity", "Input",
  FontWeight->"Plain"],
 " serves as an essential placeholder in many ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " calculations, so the fundamental list ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " ",
 StyleBox["must always",
  FontVariations->{"Underline"->True}],
 " include an initial member to ",
 StyleBox["act",
  FontVariations->{"Underline"->True}],
 " as the ",
 StyleBox["identity", "Input",
  FontWeight->"Plain"],
 " element. If the algebra does not include an ",
 StyleBox["identity", "Input",
  FontWeight->"Plain"],
 ", it must be supplied as the first member of ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " and to preserve its \"unital\" action, the top row and left column of ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 " must equal ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " (or a truncated portion thereof).\n\nSince this is essential for correct \
operation of the program, the ",
 StyleBox["makealgebra[]", "Input",
  FontWeight->"Plain"],
 " command will always modify any multiplication table (supplied as its \
argument) so that this requirement is met; i.e., the top row and left column \
will be changed to ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " before being assigned to ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 ". If the algebra includes the ",
 StyleBox["identity", "Input",
  FontWeight->"Plain"],
 " in the first member of ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 ", this actually leaves it unchanged. If there is no identity element, a \
symbol for it may be entered as the second (optional) argument of ",
 StyleBox["makealgebra", "Input",
  FontWeight->"Plain"],
 " to become a new element in the first position of ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 ". The multiplication table entered in the mandatory first argument will \
appear unchanged, except for having the new ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " list prepended as the first row and column of ",
 StyleBox["algebra", "Input",
  FontWeight->"Plain"],
 ". Products with the spurious ",
 StyleBox["identity", "Input",
  FontWeight->"Plain"],
 " will not conform to the algebra, but products of all other elements (which \
do belong to the algebra) will be unchanged. The new row and column can be \
considered just as convenient headers for the others."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell["For example,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"makealgebra", "[", 
  RowBox[{"liealg", ",", "e"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"e", 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "1"], 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "4"], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "34"]},
     {
      SubscriptBox["\[Gamma]", "0"], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0"},
     {
      SubscriptBox["\[Gamma]", "1"], "0", "0", 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], "0", "0", "0"},
     {
      SubscriptBox["\[Gamma]", "2"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], "0", 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], "0", "0", 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "4"], "0"},
     {
      SubscriptBox["\[Gamma]", "3"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], "0", 
      SubscriptBox["\[Gamma]", "34"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], "0", 
      SubscriptBox["\[Gamma]", "4"]},
     {
      SubscriptBox["\[Gamma]", "4"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], "0", "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}]},
     {
      SubscriptBox["\[Gamma]", "12"], "0", 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "1"], "0", "0", "0", 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], "0"},
     {
      SubscriptBox["\[Gamma]", "13"], "0", 
      SubscriptBox["\[Gamma]", "3"], "0", 
      SubscriptBox["\[Gamma]", "1"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], "0", 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], "0", 
      SubscriptBox["\[Gamma]", "14"]},
     {
      SubscriptBox["\[Gamma]", "14"], "0", 
      SubscriptBox["\[Gamma]", "4"], "0", "0", 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}]},
     {
      SubscriptBox["\[Gamma]", "23"], "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      SubscriptBox["\[Gamma]", "2"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      SubscriptBox["\[Gamma]", "12"], "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "24"]},
     {
      SubscriptBox["\[Gamma]", "24"], "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], "0", 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], "0", 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "34"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}]},
     {
      SubscriptBox["\[Gamma]", "34"], "0", "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      SubscriptBox["\[Gamma]", "3"], "0", 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      SubscriptBox["\[Gamma]", "13"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      SubscriptBox["\[Gamma]", "23"], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["and the full list of elements is still retained,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["elements"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e", ",", 
   SubscriptBox["\[Gamma]", "0"], ",", 
   SubscriptBox["\[Gamma]", "1"], ",", 
   SubscriptBox["\[Gamma]", "2"], ",", 
   SubscriptBox["\[Gamma]", "3"], ",", 
   SubscriptBox["\[Gamma]", "4"], ",", 
   SubscriptBox["\[Gamma]", "12"], ",", 
   SubscriptBox["\[Gamma]", "13"], ",", 
   SubscriptBox["\[Gamma]", "14"], ",", 
   SubscriptBox["\[Gamma]", "23"], ",", 
   SubscriptBox["\[Gamma]", "24"], ",", 
   SubscriptBox["\[Gamma]", "34"], ",", 
   SubscriptBox["\[Gamma]", "15"], ",", 
   SubscriptBox["\[Gamma]", "25"], ",", 
   SubscriptBox["\[Gamma]", "35"], ",", 
   SubscriptBox["\[Gamma]", "45"], ",", 
   SubscriptBox["\[Gamma]", "5"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Basic ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " multiplication, ** , now gives the non-associative Lie product for all \
Lie-algebra-valued forms, which in standard notation is written as a bracket. \
The CAV defined 1-form, ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Omega]", "^"], TraditionalForm]]],
 " , becomes a Lie-algebra-valued gauge potential,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 OverscriptBox["\[Omega]", "^"]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["\[Omega]", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "3"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "4"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "4"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "12"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "12"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "13"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "13"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "14"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "23"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "23"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "24"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "34"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "34"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "where the expansion of the Lie bracket [",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Omega]", "^"], TraditionalForm]]],
 " ,",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    OverscriptBox["\[Omega]", "^"]}], TraditionalForm]]],
 "] is given directly by,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{
   OverscriptBox["\[Omega]", "^"], "**", 
   OverscriptBox["\[Omega]", "^"]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Gamma]", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "14"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "24"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "3"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "34"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "12"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "3"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "13"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "4"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "14"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "12"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "3"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "23"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "4"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "24"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "13"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "23"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "4"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "34"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "14"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "4"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "12"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "24"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "13"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "34"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "12"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "2"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "13"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "23"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "14"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "24"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "13"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "3"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "12"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "23"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "14"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "34"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "34"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "3"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "4"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "13"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "14"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "23"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "24"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "24"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "4"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "12"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "14"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "23"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "34"]}]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "23"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "1"], "3"]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "12"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "13"]}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "24"], "\[Wedge]", 
       SubscriptBox[
        OverscriptBox["\[Omega]", "2"], "34"]}]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "All the Jacobi identities of the structure constants of this Lie algebra \
are involved in the triple self-product of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Omega]", "^"], TraditionalForm]]],
 " , regardless of parentheses;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["\[Omega]", "^"], "**", 
     OverscriptBox["\[Omega]", "^"]}], ")"}], "**", 
   OverscriptBox["\[Omega]", "^"]}], "==", 
  RowBox[{
   OverscriptBox["\[Omega]", "^"], "**", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["\[Omega]", "^"], "**", 
     OverscriptBox["\[Omega]", "^"]}], ")"}]}], "==", 
  RowBox[{
   OverscriptBox["\[Omega]", "^"], "**", 
   OverscriptBox["\[Omega]", "^"], "**", 
   OverscriptBox["\[Omega]", "^"]}], "==", "0"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]],

Cell[TextData[{
 "The AVF form of the Yang-Mills equation includes the grades(0,1,2) \
curvature fields, ",
 StyleBox["F", "Input",
  FontWeight->"Plain"],
 ", for the gauge potential, ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Omega]", "^"], TraditionalForm]]],
 " ,"
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F", "=", 
  RowBox[{"collect", "[", 
   RowBox[{
    RowBox[{"d", "[", 
     OverscriptBox["\[Omega]", "^"], "]"}], "+", 
    RowBox[{
     RowBox[{
      OverscriptBox["\[Omega]", "^"], "**", 
      OverscriptBox["\[Omega]", "^"]}], "/", "2"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["d\[Omega]", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "1"], "4"], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "1"], "1"], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "1"], "2"], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "1"], "3"], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "14"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "2"], "14"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "12"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "2"], "12"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "13"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "2"], "13"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "34"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "2"], "34"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "24"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "2"], "24"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "23"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "2"], "23"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
In the Clifford algebra, the curvature identity is expressed by,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "[", "F", "]"}], "+", 
  RowBox[{
   OverscriptBox["\[Omega]", "^"], "**", 
   RowBox[{"(", 
    RowBox[{"F", "/", "2"}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"F", "/", "2"}], ")"}], "**", 
   OverscriptBox["\[Omega]", "^"]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "but in the Lie algebra, AVF 1-forms and 2-forms anti-commute and the Jacobi \
identities annul the triple ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Omega]", "^"], TraditionalForm]]],
 " product, so the curvature identity simplifies to,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d", "[", "F", "]"}], "+", 
   RowBox[{
    OverscriptBox["\[Omega]", "^"], "**", "F"}]}], "==", 
  RowBox[{
   RowBox[{"d", "[", "F", "]"}], "-", 
   RowBox[{"F", "**", 
    OverscriptBox["\[Omega]", "^"]}]}], "==", "0"}]], "Input"],

Cell[BoxData["True"], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.c.7. The non-associative octonions algebra", "Subsubsection",
 PageBreakAbove->True],

Cell[TextData[{
 "Introduce a new ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " list,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"octonionbasis", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["e", "0"], ",", 
     SubscriptBox["e", "1"], ",", 
     SubscriptBox["e", "2"], ",", 
     SubscriptBox["e", "3"], ",", 
     SubscriptBox["e", "4"], ",", 
     SubscriptBox["e", "5"], ",", 
     SubscriptBox["e", "6"], ",", 
     SubscriptBox["e", "7"]}], "}"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeelements", "[", "octonionbasis", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["e", "0"], ",", 
   SubscriptBox["e", "1"], ",", 
   SubscriptBox["e", "2"], ",", 
   SubscriptBox["e", "3"], ",", 
   SubscriptBox["e", "4"], ",", 
   SubscriptBox["e", "5"], ",", 
   SubscriptBox["e", "6"], ",", 
   SubscriptBox["e", "7"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "A particular representation, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["C", "+"], ","}], " "}], TraditionalForm]]],
 "of the octonion multiplication table is:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"octoniontable", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["e", "0"], ",", 
       SubscriptBox["e", "1"], ",", 
       SubscriptBox["e", "2"], ",", 
       SubscriptBox["e", "3"], ",", 
       SubscriptBox["e", "4"], ",", 
       SubscriptBox["e", "5"], ",", 
       SubscriptBox["e", "6"], ",", 
       SubscriptBox["e", "7"]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["e", "1"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "0"]}], ",", 
       SubscriptBox["e", "4"], ",", 
       SubscriptBox["e", "7"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "2"]}], ",", 
       SubscriptBox["e", "6"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "5"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "3"]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["e", "2"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "4"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "0"]}], ",", 
       SubscriptBox["e", "5"], ",", 
       SubscriptBox["e", "1"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "3"]}], ",", 
       SubscriptBox["e", "7"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "6"]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["e", "3"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "7"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "5"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "0"]}], ",", 
       SubscriptBox["e", "6"], ",", 
       SubscriptBox["e", "2"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "4"]}], ",", 
       SubscriptBox["e", "1"]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["e", "4"], ",", 
       SubscriptBox["e", "2"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "1"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "6"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "0"]}], ",", 
       SubscriptBox["e", "7"], ",", 
       SubscriptBox["e", "3"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "5"]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["e", "5"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "6"]}], ",", 
       SubscriptBox["e", "3"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "2"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "7"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "0"]}], ",", 
       SubscriptBox["e", "1"], ",", 
       SubscriptBox["e", "4"]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["e", "6"], ",", 
       SubscriptBox["e", "5"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "7"]}], ",", 
       SubscriptBox["e", "4"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "3"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "1"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "0"]}], ",", 
       SubscriptBox["e", "2"]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["e", "7"], ",", 
       SubscriptBox["e", "3"], ",", 
       SubscriptBox["e", "6"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "1"]}], ",", 
       SubscriptBox["e", "5"], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "4"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "2"]}], ",", 
       RowBox[{"-", 
        SubscriptBox["e", "0"]}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"makealgebra", "[", "octoniontable", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["e", "0"], 
      SubscriptBox["e", "1"], 
      SubscriptBox["e", "2"], 
      SubscriptBox["e", "3"], 
      SubscriptBox["e", "4"], 
      SubscriptBox["e", "5"], 
      SubscriptBox["e", "6"], 
      SubscriptBox["e", "7"]},
     {
      SubscriptBox["e", "1"], 
      RowBox[{"-", 
       SubscriptBox["e", "0"]}], 
      SubscriptBox["e", "4"], 
      SubscriptBox["e", "7"], 
      RowBox[{"-", 
       SubscriptBox["e", "2"]}], 
      SubscriptBox["e", "6"], 
      RowBox[{"-", 
       SubscriptBox["e", "5"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "3"]}]},
     {
      SubscriptBox["e", "2"], 
      RowBox[{"-", 
       SubscriptBox["e", "4"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "0"]}], 
      SubscriptBox["e", "5"], 
      SubscriptBox["e", "1"], 
      RowBox[{"-", 
       SubscriptBox["e", "3"]}], 
      SubscriptBox["e", "7"], 
      RowBox[{"-", 
       SubscriptBox["e", "6"]}]},
     {
      SubscriptBox["e", "3"], 
      RowBox[{"-", 
       SubscriptBox["e", "7"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "5"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "0"]}], 
      SubscriptBox["e", "6"], 
      SubscriptBox["e", "2"], 
      RowBox[{"-", 
       SubscriptBox["e", "4"]}], 
      SubscriptBox["e", "1"]},
     {
      SubscriptBox["e", "4"], 
      SubscriptBox["e", "2"], 
      RowBox[{"-", 
       SubscriptBox["e", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "6"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "0"]}], 
      SubscriptBox["e", "7"], 
      SubscriptBox["e", "3"], 
      RowBox[{"-", 
       SubscriptBox["e", "5"]}]},
     {
      SubscriptBox["e", "5"], 
      RowBox[{"-", 
       SubscriptBox["e", "6"]}], 
      SubscriptBox["e", "3"], 
      RowBox[{"-", 
       SubscriptBox["e", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "7"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "0"]}], 
      SubscriptBox["e", "1"], 
      SubscriptBox["e", "4"]},
     {
      SubscriptBox["e", "6"], 
      SubscriptBox["e", "5"], 
      RowBox[{"-", 
       SubscriptBox["e", "7"]}], 
      SubscriptBox["e", "4"], 
      RowBox[{"-", 
       SubscriptBox["e", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "0"]}], 
      SubscriptBox["e", "2"]},
     {
      SubscriptBox["e", "7"], 
      SubscriptBox["e", "3"], 
      SubscriptBox["e", "6"], 
      RowBox[{"-", 
       SubscriptBox["e", "1"]}], 
      SubscriptBox["e", "5"], 
      RowBox[{"-", 
       SubscriptBox["e", "4"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["e", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 StyleBox["associators[n]", "Input",
  FontWeight->"Plain"],
 " searches the algebra table for non-associative triple products and prints \
the first ",
 StyleBox["n", "Input",
  FontWeight->"Plain"],
 " it finds. If fewer than ",
 StyleBox["n", "Input",
  FontWeight->"Plain"],
 " are present, it prints ",
 StyleBox["Done", "Input",
  FontWeight->"Plain"],
 " and the number actually found, but in that case it could take a long time \
to search a high-dimension algebra."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"associators", "[", "9", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(\"\>", "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\" - \"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"(\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SubscriptBox["e", "6"]}]}],
  SequenceForm["(", 
   Subscript[$CellContext`e, 1], "", 
   Subscript[$CellContext`e, 2], ")", 
   Subscript[$CellContext`e, 3], " - ", 
   Subscript[$CellContext`e, 1], "(", 
   Subscript[$CellContext`e, 2], "", 
   Subscript[$CellContext`e, 3], ") = ", (-2) Subscript[$CellContext`e, 6]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(\"\>", "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "5"], "\[InvisibleSpace]", "\<\" - \"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"(\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "5"], "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"2", " ", 
    SubscriptBox["e", "7"]}]}],
  SequenceForm["(", 
   Subscript[$CellContext`e, 1], "", 
   Subscript[$CellContext`e, 2], ")", 
   Subscript[$CellContext`e, 5], " - ", 
   Subscript[$CellContext`e, 1], "(", 
   Subscript[$CellContext`e, 2], "", 
   Subscript[$CellContext`e, 5], ") = ", 2 Subscript[$CellContext`e, 7]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(\"\>", "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "6"], "\[InvisibleSpace]", "\<\" - \"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"(\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "6"], "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"2", " ", 
    SubscriptBox["e", "3"]}]}],
  SequenceForm["(", 
   Subscript[$CellContext`e, 1], "", 
   Subscript[$CellContext`e, 2], ")", 
   Subscript[$CellContext`e, 6], " - ", 
   Subscript[$CellContext`e, 1], "(", 
   Subscript[$CellContext`e, 2], "", 
   Subscript[$CellContext`e, 6], ") = ", 2 Subscript[$CellContext`e, 3]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(\"\>", "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "7"], "\[InvisibleSpace]", "\<\" - \"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"(\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "7"], "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SubscriptBox["e", "5"]}]}],
  SequenceForm["(", 
   Subscript[$CellContext`e, 1], "", 
   Subscript[$CellContext`e, 2], ")", 
   Subscript[$CellContext`e, 7], " - ", 
   Subscript[$CellContext`e, 1], "(", 
   Subscript[$CellContext`e, 2], "", 
   Subscript[$CellContext`e, 7], ") = ", (-2) Subscript[$CellContext`e, 5]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(\"\>", "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\" - \"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"(\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "2"], "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"2", " ", 
    SubscriptBox["e", "6"]}]}],
  SequenceForm["(", 
   Subscript[$CellContext`e, 1], "", 
   Subscript[$CellContext`e, 3], ")", 
   Subscript[$CellContext`e, 2], " - ", 
   Subscript[$CellContext`e, 1], "(", 
   Subscript[$CellContext`e, 3], "", 
   Subscript[$CellContext`e, 2], ") = ", 2 Subscript[$CellContext`e, 6]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(\"\>", "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "4"], "\[InvisibleSpace]", "\<\" - \"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"(\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "4"], "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"2", " ", 
    SubscriptBox["e", "5"]}]}],
  SequenceForm["(", 
   Subscript[$CellContext`e, 1], "", 
   Subscript[$CellContext`e, 3], ")", 
   Subscript[$CellContext`e, 4], " - ", 
   Subscript[$CellContext`e, 1], "(", 
   Subscript[$CellContext`e, 3], "", 
   Subscript[$CellContext`e, 4], ") = ", 2 Subscript[$CellContext`e, 5]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(\"\>", "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "5"], "\[InvisibleSpace]", "\<\" - \"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"(\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "5"], "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SubscriptBox["e", "4"]}]}],
  SequenceForm["(", 
   Subscript[$CellContext`e, 1], "", 
   Subscript[$CellContext`e, 3], ")", 
   Subscript[$CellContext`e, 5], " - ", 
   Subscript[$CellContext`e, 1], "(", 
   Subscript[$CellContext`e, 3], "", 
   Subscript[$CellContext`e, 5], ") = ", (-2) Subscript[$CellContext`e, 4]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(\"\>", "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "6"], "\[InvisibleSpace]", "\<\" - \"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"(\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "6"], "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SubscriptBox["e", "2"]}]}],
  SequenceForm["(", 
   Subscript[$CellContext`e, 1], "", 
   Subscript[$CellContext`e, 3], ")", 
   Subscript[$CellContext`e, 6], " - ", 
   Subscript[$CellContext`e, 1], "(", 
   Subscript[$CellContext`e, 3], "", 
   Subscript[$CellContext`e, 6], ") = ", (-2) Subscript[$CellContext`e, 2]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(\"\>", "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "4"], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\" - \"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "1"], "\[InvisibleSpace]", "\<\"(\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "4"], "\[InvisibleSpace]", "\<\"\"\>", 
   "\[InvisibleSpace]", 
   SubscriptBox["e", "3"], "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SubscriptBox["e", "5"]}]}],
  SequenceForm["(", 
   Subscript[$CellContext`e, 1], "", 
   Subscript[$CellContext`e, 4], ")", 
   Subscript[$CellContext`e, 3], " - ", 
   Subscript[$CellContext`e, 1], "(", 
   Subscript[$CellContext`e, 4], "", 
   Subscript[$CellContext`e, 3], ") = ", (-2) Subscript[$CellContext`e, 5]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Done. Found:\"\>", "\[InvisibleSpace]", "9"}],
  SequenceForm["Done. Found:", 9],
  Editable->False]], "Print"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The absence of the triple ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["e", "1"], ",", 
     SubscriptBox["e", "2"], ",", 
     SubscriptBox["e", "4"]}], "}"}], TraditionalForm]]],
 " implies that this is an associative quaternion subalgebra; i.e.,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["e", "1"], "**", 
     SubscriptBox["e", "2"]}], ")"}], "**", 
   SubscriptBox["e", "4"]}], "-", 
  RowBox[{
   SubscriptBox["e", "1"], "**", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["e", "2"], "**", 
     SubscriptBox["e", "4"]}], ")"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["e", "1"], ",", 
     SubscriptBox["e", "2"], ",", 
     SubscriptBox["e", "3"]}], "}"}], TraditionalForm]]],
 " do not associate, the 0-forms ",
 StyleBox["{q1,q2,q3}", "Input",
  FontWeight->"Plain"],
 " introduced at the start as quaternions, become truncated octonions by \
\[Sigma] \[Rule] e ,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"o1", "=", 
  RowBox[{"q1", "/.", 
   RowBox[{"\[Sigma]", "->", "e"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["e", "0"], " ", 
   SubscriptBox["X", "0"]}], "+", 
  RowBox[{
   SubscriptBox["e", "1"], " ", 
   SubscriptBox["X", "1"]}], "+", 
  RowBox[{
   SubscriptBox["e", "2"], " ", 
   SubscriptBox["X", "2"]}], "+", 
  RowBox[{
   SubscriptBox["e", "3"], " ", 
   SubscriptBox["X", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"o2", "=", 
  RowBox[{"q2", "/.", 
   RowBox[{"\[Sigma]", "->", "e"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["e", "0"], " ", 
   SubscriptBox["Y", "0"]}], "+", 
  RowBox[{
   SubscriptBox["e", "1"], " ", 
   SubscriptBox["Y", "1"]}], "+", 
  RowBox[{
   SubscriptBox["e", "2"], " ", 
   SubscriptBox["Y", "2"]}], "+", 
  RowBox[{
   SubscriptBox["e", "3"], " ", 
   SubscriptBox["Y", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"o3", "=", 
  RowBox[{"q3", "/.", 
   RowBox[{"\[Sigma]", "->", "e"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["e", "0"], " ", 
   SubscriptBox["Z", "0"]}], "+", 
  RowBox[{
   SubscriptBox["e", "1"], " ", 
   SubscriptBox["Z", "1"]}], "+", 
  RowBox[{
   SubscriptBox["e", "2"], " ", 
   SubscriptBox["Z", "2"]}], "+", 
  RowBox[{
   SubscriptBox["e", "3"], " ", 
   SubscriptBox["Z", "3"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and ",
 StyleBox["O1", "Input",
  FontWeight->"Plain"],
 " will be an octonion-valued 1-form,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"O1", "=", 
  RowBox[{"o1", "/.", 
   RowBox[{"X", "->", "\[Omega]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["e", "0"], " ", 
   SubscriptBox["\[Omega]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["e", "1"], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["e", "2"], " ", 
   SubscriptBox["\[Omega]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["e", "3"], " ", 
   SubscriptBox["\[Omega]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "when ",
 StyleBox["makeforms", "Input",
  FontWeight->"Plain"],
 " is used,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeforms", "[", 
  RowBox[{"coeffs", "[", "O1", "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Omega]", "0"], ",", 
   SubscriptBox["\[Omega]", "1"], ",", 
   SubscriptBox["\[Omega]", "2"], ",", 
   SubscriptBox["\[Omega]", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
A special property of octonions guarantees that any two octonion 0-forms are \
associative; e.g.,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"o1", "**", "o2"}], ")"}], "**", "o1"}], "-", 
  RowBox[{"o1", "**", 
   RowBox[{"(", 
    RowBox[{"o2", "**", "o1"}], ")"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"o1", "**", "o2"}], ")"}], "**", "o2"}], "-", 
  RowBox[{"o1", "**", 
   RowBox[{"(", 
    RowBox[{"o2", "**", "o2"}], ")"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["For three independent octonions, associativity is lost,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"o1", "**", "o2"}], ")"}], "**", "o3"}], "-", 
   RowBox[{"o1", "**", 
    RowBox[{"(", 
     RowBox[{"o2", "**", "o3"}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["e", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SubscriptBox["X", "3"], " ", 
     SubscriptBox["Y", "2"], " ", 
     SubscriptBox["Z", "1"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "2"], " ", 
     SubscriptBox["Y", "3"], " ", 
     SubscriptBox["Z", "1"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "3"], " ", 
     SubscriptBox["Y", "1"], " ", 
     SubscriptBox["Z", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "1"], " ", 
     SubscriptBox["Y", "3"], " ", 
     SubscriptBox["Z", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "2"], " ", 
     SubscriptBox["Y", "1"], " ", 
     SubscriptBox["Z", "3"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "1"], " ", 
     SubscriptBox["Y", "2"], " ", 
     SubscriptBox["Z", "3"]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["\<\
but the \"flexible\" property is demonstrated by the opposite signs of the \
next expression,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"o3", "**", "o2"}], ")"}], "**", "o1"}], "-", 
   RowBox[{"o3", "**", 
    RowBox[{"(", 
     RowBox[{"o2", "**", "o1"}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["e", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SubscriptBox["X", "3"], " ", 
     SubscriptBox["Y", "2"], " ", 
     SubscriptBox["Z", "1"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "2"], " ", 
     SubscriptBox["Y", "3"], " ", 
     SubscriptBox["Z", "1"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "3"], " ", 
     SubscriptBox["Y", "1"], " ", 
     SubscriptBox["Z", "2"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "1"], " ", 
     SubscriptBox["Y", "3"], " ", 
     SubscriptBox["Z", "2"]}], "-", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "2"], " ", 
     SubscriptBox["Y", "1"], " ", 
     SubscriptBox["Z", "3"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["X", "1"], " ", 
     SubscriptBox["Y", "2"], " ", 
     SubscriptBox["Z", "3"]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["\<\
The above associative property does not hold in general for octonion-valued \
1-forms, which are not even triply power associative,\
\>", "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"O1", "**", "O1"}], ")"}], "**", "O1"}], "-", 
  RowBox[{"O1", "**", 
   RowBox[{"(", 
    RowBox[{"O1", "**", "O1"}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "12"}], " ", 
  SubscriptBox["e", "6"], " ", 
  RowBox[{
   SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
   SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
   SubscriptBox["\[Omega]", "3"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"O1", "**", "O1"}], ")"}], "**", "o1"}], "-", 
   RowBox[{"O1", "**", 
    RowBox[{"(", 
     RowBox[{"O1", "**", "o1"}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["e", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     SubscriptBox["X", "3"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "2"]}]}], "+", 
    RowBox[{"4", " ", 
     SubscriptBox["X", "2"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "1"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}], "-", 
    RowBox[{"4", " ", 
     SubscriptBox["X", "1"], " ", 
     RowBox[{
      SubscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox["\[Omega]", "3"]}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["but with no exterior product involved,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"o1", "**", "O1"}], ")"}], "**", "o1"}], "-", 
  RowBox[{"o1", "**", 
   RowBox[{"(", 
    RowBox[{"O1", "**", "o1"}], ")"}]}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.c.8. The exceptional Jordan algebra", "Subsubsection",
 PageBreakAbove->True],

Cell[TextData[{
 "All the finite Jordan algebras with one exception can be obtained from the \
symmetric derived algebras using \[CirclePlus] with associative underlying \
algebras. As mentioned in ",
 ButtonBox["Okubo's book (p.81)",
  BaseStyle->"Hyperlink",
  ButtonData:>"reference"],
 ", octonion-valued matrices provide a representation for the single 27-dim. \
exceptional Jordan algebra. For brevity, we shall use the truncated octonion \
triplet ",
 StyleBox["{o1,o2,o3}", "Input",
  FontWeight->"Plain"],
 ", their conjugates, and 3 additional diagonal elements, to write a reduced \
15-dim. example,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   OverscriptBox["o1", "_"], "=", 
   RowBox[{
    RowBox[{"-", "o1"}], "/.", 
    RowBox[{
     SubscriptBox["X", "0"], "->", 
     RowBox[{"-", 
      SubscriptBox["X", "0"]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   OverscriptBox["o2", "_"], "=", 
   RowBox[{
    RowBox[{"-", "o2"}], "/.", 
    RowBox[{
     SubscriptBox["Y", "0"], "->", 
     RowBox[{"-", 
      SubscriptBox["Y", "0"]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  OverscriptBox["o3", "_"], "=", 
  RowBox[{
   RowBox[{"-", "o3"}], "/.", 
   RowBox[{
    SubscriptBox["Z", "0"], "->", 
    RowBox[{"-", 
     SubscriptBox["Z", "0"]}]}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["e", "0"], " ", 
   SubscriptBox["Z", "0"]}], "-", 
  RowBox[{
   SubscriptBox["e", "1"], " ", 
   SubscriptBox["Z", "1"]}], "-", 
  RowBox[{
   SubscriptBox["e", "2"], " ", 
   SubscriptBox["Z", "2"]}], "-", 
  RowBox[{
   SubscriptBox["e", "3"], " ", 
   SubscriptBox["Z", "3"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The matrix ",
 StyleBox["J1", "Input",
  FontWeight->"Plain"],
 " then represents a truncated element of the exceptional Jordan algebra,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"J1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", "1"], 
       SubscriptBox["e", "0"]}], ",", "o1", ",", "o2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      OverscriptBox["o1", "_"], ",", 
      RowBox[{
       SubscriptBox["a", "2"], 
       SubscriptBox["e", "0"]}], ",", "o3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      OverscriptBox["o2", "_"], ",", 
      OverscriptBox["o3", "_"], ",", 
      RowBox[{
       SubscriptBox["a", "3"], 
       SubscriptBox["e", "0"]}]}], "}"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], " ", 
      SubscriptBox["e", "0"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       SubscriptBox["X", "0"]}], "+", 
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       SubscriptBox["X", "1"]}], "+", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       SubscriptBox["X", "2"]}], "+", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       SubscriptBox["X", "3"]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       SubscriptBox["Y", "0"]}], "+", 
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       SubscriptBox["Y", "1"]}], "+", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       SubscriptBox["Y", "2"]}], "+", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       SubscriptBox["Y", "3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       SubscriptBox["X", "0"]}], "-", 
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       SubscriptBox["X", "1"]}], "-", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       SubscriptBox["X", "2"]}], "-", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       SubscriptBox["X", "3"]}]}], ",", 
     RowBox[{
      SubscriptBox["a", "2"], " ", 
      SubscriptBox["e", "0"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       SubscriptBox["Z", "0"]}], "+", 
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       SubscriptBox["Z", "1"]}], "+", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       SubscriptBox["Z", "2"]}], "+", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       SubscriptBox["Z", "3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       SubscriptBox["Y", "0"]}], "-", 
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       SubscriptBox["Y", "1"]}], "-", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       SubscriptBox["Y", "2"]}], "-", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       SubscriptBox["Y", "3"]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       SubscriptBox["Z", "0"]}], "-", 
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       SubscriptBox["Z", "1"]}], "-", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       SubscriptBox["Z", "2"]}], "-", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       SubscriptBox["Z", "3"]}]}], ",", 
     RowBox[{
      SubscriptBox["a", "3"], " ", 
      SubscriptBox["e", "0"]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubscriptBox["a", "1"], " ", 
       SubscriptBox["e", "0"]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["X", "0"]}], "+", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["X", "1"]}], "+", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["X", "2"]}], "+", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["X", "3"]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["Y", "0"]}], "+", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["Y", "1"]}], "+", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["Y", "2"]}], "+", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["Y", "3"]}]}]},
     {
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["X", "0"]}], "-", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["X", "1"]}], "-", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["X", "2"]}], "-", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["X", "3"]}]}], 
      RowBox[{
       SubscriptBox["a", "2"], " ", 
       SubscriptBox["e", "0"]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["Z", "0"]}], "+", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["Z", "1"]}], "+", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["Z", "2"]}], "+", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["Z", "3"]}]}]},
     {
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["Y", "0"]}], "-", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["Y", "1"]}], "-", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["Y", "2"]}], "-", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["Y", "3"]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["Z", "0"]}], "-", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["Z", "1"]}], "-", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["Z", "2"]}], "-", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["Z", "3"]}]}], 
      RowBox[{
       SubscriptBox["a", "3"], " ", 
       SubscriptBox["e", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["An independent matrix of the same form is given by,", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"J2", "=", 
   RowBox[{"J1", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "->", "b"}], ",", 
      RowBox[{"X", "->", "U"}], ",", 
      RowBox[{"Y", "->", "V"}], ",", 
      RowBox[{"Z", "->", "W"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"mtx", "[", "J2", "]"}]}], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["e", "0"]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["U", "0"]}], "+", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["U", "1"]}], "+", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["U", "2"]}], "+", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["U", "3"]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["V", "0"]}], "+", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["V", "1"]}], "+", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["V", "2"]}], "+", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["V", "3"]}]}]},
     {
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["U", "0"]}], "-", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["U", "1"]}], "-", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["U", "2"]}], "-", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["U", "3"]}]}], 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["e", "0"]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["W", "0"]}], "+", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["W", "1"]}], "+", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["W", "2"]}], "+", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["W", "3"]}]}]},
     {
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["V", "0"]}], "-", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["V", "1"]}], "-", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["V", "2"]}], "-", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["V", "3"]}]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["e", "0"], " ", 
        SubscriptBox["W", "0"]}], "-", 
       RowBox[{
        SubscriptBox["e", "1"], " ", 
        SubscriptBox["W", "1"]}], "-", 
       RowBox[{
        SubscriptBox["e", "2"], " ", 
        SubscriptBox["W", "2"]}], "-", 
       RowBox[{
        SubscriptBox["e", "3"], " ", 
        SubscriptBox["W", "3"]}]}], 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["e", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
and the symmetrized Jordan product \[CirclePlus] can be modified for matrix \
arguments to,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CirclePlus", "[", 
   RowBox[{"arg1_", ",", "arg2_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"arg1", "\[CircleTimes]", 
    RowBox[{"(", 
     RowBox[{"arg2", "/", "2"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"arg2", "/", "2"}], ")"}], "\[CircleTimes]", 
    "arg1"}]}]}]], "Input"],

Cell["For example,", "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->True,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"J3", "=", 
  RowBox[{"collect", "[", 
   RowBox[{"J1", "\[CirclePlus]", "J1"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["e", "0"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["a", "1", "2"], "+", 
        SubsuperscriptBox["X", "0", "2"], "+", 
        SubsuperscriptBox["X", "1", "2"], "+", 
        SubsuperscriptBox["X", "2", "2"], "+", 
        SubsuperscriptBox["X", "3", "2"], "+", 
        SubsuperscriptBox["Y", "0", "2"], "+", 
        SubsuperscriptBox["Y", "1", "2"], "+", 
        SubsuperscriptBox["Y", "2", "2"], "+", 
        SubsuperscriptBox["Y", "3", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["X", "1"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["X", "1"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["X", "2"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["X", "2"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["X", "3"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["X", "3"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["X", "0"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["X", "0"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Z", "1"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["X", "2"]}], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["X", "3"]}], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["X", "3"]}], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["Y", "0"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Y", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["a", "1"]}], " ", 
          SubscriptBox["X", "1"]}], "-", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["X", "1"]}], "-", 
         RowBox[{
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["a", "1"]}], " ", 
          SubscriptBox["X", "2"]}], "-", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["X", "2"]}], "-", 
         RowBox[{
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["Y", "2"]}], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["a", "1"]}], " ", 
          SubscriptBox["X", "3"]}], "-", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["X", "3"]}], "-", 
         RowBox[{
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["Y", "3"]}], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["Y", "3"]}], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["X", "0"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["X", "0"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SubscriptBox["e", "0"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["a", "2", "2"], "+", 
        SubsuperscriptBox["X", "0", "2"], "+", 
        SubsuperscriptBox["X", "1", "2"], "+", 
        SubsuperscriptBox["X", "2", "2"], "+", 
        SubsuperscriptBox["X", "3", "2"], "+", 
        SubsuperscriptBox["Z", "0", "2"], "+", 
        SubsuperscriptBox["Z", "1", "2"], "+", 
        SubsuperscriptBox["Z", "2", "2"], "+", 
        SubsuperscriptBox["Z", "3", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Z", "0"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["X", "1"]}], " ", 
          SubscriptBox["Y", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Z", "1"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["X", "2"]}], " ", 
          SubscriptBox["Y", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["X", "3"]}], " ", 
          SubscriptBox["Y", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["a", "1"]}], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Z", "1"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["a", "1"]}], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["a", "1"]}], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["Y", "0"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Y", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["X", "2"]}], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["X", "3"]}], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["X", "3"]}], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "0"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "0"]}], "+", 
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Z", "0"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"]}], "-", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Z", "1"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"]}], "-", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Z", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"]}], "-", 
         RowBox[{
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SubscriptBox["e", "0"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["a", "3", "2"], "+", 
        SubsuperscriptBox["Y", "0", "2"], "+", 
        SubsuperscriptBox["Y", "1", "2"], "+", 
        SubsuperscriptBox["Y", "2", "2"], "+", 
        SubsuperscriptBox["Y", "3", "2"], "+", 
        SubsuperscriptBox["Z", "0", "2"], "+", 
        SubsuperscriptBox["Z", "1", "2"], "+", 
        SubsuperscriptBox["Z", "2", "2"], "+", 
        SubsuperscriptBox["Z", "3", "2"]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Using matrix multiplication, the Jordan identity as introduced for the \
derived algebra ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "+"], TraditionalForm]]],
 " becomes,"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"J1", "\[CircleTimes]", "J1"}], ")"}], "\[CirclePlus]", "J2"}], 
    ")"}], "\[CirclePlus]", "J1"}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"J1", "\[CircleTimes]", "J1"}], ")"}], "\[CirclePlus]", 
   RowBox[{"(", 
    RowBox[{"J2", "\[CirclePlus]", "J1"}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
or equivalently, using J3 = J1\[CirclePlus]J1, just calculated,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"J3", "\[CirclePlus]", "J2"}], ")"}], "\[CirclePlus]", "J1"}], 
  "-", 
  RowBox[{"J3", "\[CirclePlus]", 
   RowBox[{"(", 
    RowBox[{"J2", "\[CirclePlus]", "J1"}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Executing the next statement confirms that the unsymmetrized matrix product \
is not associative.\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"J3", "\[CircleTimes]", "J2"}], ")"}], "\[CircleTimes]", "J1"}], 
   "-", 
   RowBox[{"J3", "\[CircleTimes]", 
    RowBox[{"(", 
     RowBox[{"J2", "\[CircleTimes]", "J1"}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["e", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubsuperscriptBox["Y", "1", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubsuperscriptBox["Y", "1", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W", "3"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubsuperscriptBox["Y", "2", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubsuperscriptBox["Y", "2", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubsuperscriptBox["Y", "3", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubsuperscriptBox["Y", "3", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubsuperscriptBox["Y", "1", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubsuperscriptBox["Y", "1", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubsuperscriptBox["Y", "2", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubsuperscriptBox["Y", "2", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubsuperscriptBox["Y", "3", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubsuperscriptBox["Y", "3", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["e", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubsuperscriptBox["Y", "1", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubsuperscriptBox["Y", "1", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubsuperscriptBox["Y", "2", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubsuperscriptBox["Y", "2", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubsuperscriptBox["Y", "3", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubsuperscriptBox["Y", "3", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["V", "3"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Y", "1", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Y", "1", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Y", "2", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Y", "2", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Y", "3", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Y", "3", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["e", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "0"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "0"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Y", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Y", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Y", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Y", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Y", "3", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Y", "3", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "0"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubsuperscriptBox["X", "1", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubsuperscriptBox["X", "2", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Y", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubsuperscriptBox["X", "3", "2"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["W", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["V", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["e", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "0"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "1"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "1"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "3"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"4", " ", 
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "0"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Y", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Y", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Z", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Y", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Y", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubsuperscriptBox["Z", "2", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SubscriptBox["e", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "1"], " ", 
          SubscriptBox["Y", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Y", "2"], " ", 
          SubscriptBox["Y", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Y", "3", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Y", "3", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "1"], " ", 
          SubscriptBox["Z", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "3"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "3"], " ", 
          SubscriptBox["Z", "2"], " ", 
          SubscriptBox["Z", "3"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "2"], " ", 
          SubscriptBox["X", "1"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["U", "1"], " ", 
          SubscriptBox["X", "2"], " ", 
          SubsuperscriptBox["Z", "3", "2"]}]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["III.c.9. Clean up", "Subsubsection"],

Cell[BoxData[
 RowBox[{"makeclear", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["ModifiedGlobalVariables"], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IV. Advanced computations", "Section",
 FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell["IV.a. Orthonormal frames and Hodge star operations", "Subsection",
 PageWidth->WindowWidth],

Cell["This is taken from the file HodgeStar_Demo.nb.", "Text"],

Cell[CellGroupData[{

Cell["IV.a.1. General comments", "Subsubsection"],

Cell[TextData[{
 "A set of up to 6 basis forms (which may include a subset of the existing ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ") can be designated as an ",
 StyleBox["orthonormal",
  FontVariations->{"Underline"->True}],
 " frame by the command ",
 StyleBox["makeframe[list]", "Input",
  FontWeight->"Plain"],
 ". The argument is just a list of form symbols, except that the symbol for \
any frame form with negative signature must be preceded by a minus sign.\n\n\
The basis forms may be input in any order, but will be re-arranged into \
canonical order (and the signs stripped off) before being assigned to the \
reserved variable ",
 StyleBox["frame", "Input",
  FontWeight->"Plain"],
 ". The signs are saved in the reserved variable ",
 StyleBox["signature", "Input",
  FontWeight->"Plain"],
 ". Any new symbols are added to ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 ", and the frame forms will be moved to the front of the ",
 StyleBox["forms", "Input",
  FontWeight->"Plain"],
 " list.  Existing ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " are left unchanged, so any new frame forms (even exact ones, if new) will \
require them."
}], "Text",
 PageWidth->WindowWidth,
 PageBreakAbove->False,
 FontFamily->"Times",
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["IV.a.2. Cartesian orthogonal frame", "Subsubsection",
 PageWidth->WindowWidth,
 FontWeight->"Bold"],

Cell[TextData[{
 "The first example sets up for Euclidean 3-space using Cartesian coordinates \
and the associated natural orthogonal basis. The ",
 StyleBox["makecoords", "Input",
  FontWeight->"Plain"],
 " command is described fully at the end of the Lie differentiation section."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["dscalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dx", ",", "dy", ",", "dz"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Using the argument ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 " in the next statement avoids introducing new basis forms, and obviates any \
need for ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeframe", "[", "dscalars", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dx", ",", "dy", ",", "dz"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["signature"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["scalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dx", ",", "dy", ",", "dz"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["dforms"], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["drules"], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["makeframe", "Input",
  FontWeight->"Plain"],
 " command implements the Hodge star operation for ",
 StyleBox["frame", "Input",
  FontWeight->"Plain"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not include an appropriate prefix operator for this, so it is written \
",
 StyleBox["hs[arg]", "Input",
  FontWeight->"Plain"],
 ", where ",
 StyleBox["arg", "Input",
  FontWeight->"Plain"],
 " is any AVF, or list of AVF's. "
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vol", "=", 
  RowBox[{"hs", "[", "1", "]"}]}], "\n", 
 RowBox[{"hs", "[", "vol", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"dx", "\[Wedge]", "dy", "\[Wedge]", "dz"}]], "Output"],

Cell[BoxData["1"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f", "=", 
  RowBox[{"Y", "[", "depend", "]"}]}], "\n", 
 RowBox[{"hs", "[", "f", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Y", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dx", "\[Wedge]", "dy", "\[Wedge]", "dz"}], " ", 
  RowBox[{"Y", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"A", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"A1", "[", "depend", "]"}], "dx"}], "+", 
   RowBox[{
    RowBox[{"A2", "[", "depend", "]"}], "dy"}], "+", 
   RowBox[{
    RowBox[{"A3", "[", "depend", "]"}], "dz"}]}]}], "\n", 
 RowBox[{"hs", "[", "A", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dx", " ", 
   RowBox[{"A1", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{"dy", " ", 
   RowBox[{"A2", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", 
  RowBox[{"dz", " ", 
   RowBox[{"A3", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A3", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dx", "\[Wedge]", "dy"}]}], "-", 
  RowBox[{
   RowBox[{"A2", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dx", "\[Wedge]", "dz"}]}], "+", 
  RowBox[{
   RowBox[{"A1", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], " ", 
   RowBox[{"dy", "\[Wedge]", "dz"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "A co-derivative operator, \[Delta] , is also defined:  ",
 StyleBox["\[Delta][arg] = hs[hs[1]] hs[d[hs[arg]]]", "Input",
  FontWeight->"Plain"],
 ". No universally accepted convention exists for the overall sign of Hodge \
star operations; the use of the factor ",
 StyleBox["hs[hs[1]]", "Input",
  FontWeight->"Plain"],
 " in \[Delta] generally gives results consistent with ",
 StyleBox["signature", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"df", "=", 
  RowBox[{"d", "[", "f", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dz", " ", 
   SubscriptBox["Y", "z"]}], "+", 
  RowBox[{"dy", " ", 
   SubscriptBox["Y", "y"]}], "+", 
  RowBox[{"dx", " ", 
   SubscriptBox["Y", "x"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"delsquaredf", "=", 
  RowBox[{"\[Delta]", "[", "df", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["Y", "\<\"zz\"\>"], "+", 
  SubscriptBox["Y", "\<\"yy\"\>"], "+", 
  SubscriptBox["Y", "\<\"xx\"\>"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"curlgradf", "=", 
  RowBox[{"\[Delta]", "[", 
   RowBox[{"hs", "[", "df", "]"}], "]"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"divA", "=", 
  RowBox[{"\[Delta]", "[", "A", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["A3", "z"], "+", 
  SubscriptBox["A2", "y"], "+", 
  SubscriptBox["A1", "x"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"curlA", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"hs", "[", 
     RowBox[{"d", "[", "A", "]"}], "]"}], ",", "frame"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dx", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["A2", "z"]}], "+", 
     SubscriptBox["A3", "y"]}], ")"}]}], "+", 
  RowBox[{"dz", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["A1", "y"]}], "+", 
     SubscriptBox["A2", "x"]}], ")"}]}], "+", 
  RowBox[{"dy", " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["A1", "z"], "-", 
     SubscriptBox["A3", "x"]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"divcurlA", "=", 
  RowBox[{"\[Delta]", "[", "curlA", "]"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[TextData[{
 "Note the use of ",
 StyleBox["da[]", "Input",
  FontWeight->"Plain"],
 " in the next statement which (with appropriate ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ", when necessary) ensures that the result of that derivative is expressed \
in terms of ",
 StyleBox["frame", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"delsquaredA", "=", " ", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"da", "[", 
      RowBox[{"\[Delta]", "[", "A", "]"}], "]"}], "-", 
     RowBox[{"\[Delta]", "[", 
      RowBox[{"d", "[", "A", "]"}], "]"}]}], ",", "frame"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dx", " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["A1", "\<\"zz\"\>"], "+", 
     SubscriptBox["A1", "\<\"yy\"\>"], "+", 
     SubscriptBox["A1", "\<\"xx\"\>"]}], ")"}]}], "+", 
  RowBox[{"dy", " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["A2", "\<\"zz\"\>"], "+", 
     SubscriptBox["A2", "\<\"yy\"\>"], "+", 
     SubscriptBox["A2", "\<\"xx\"\>"]}], ")"}]}], "+", 
  RowBox[{"dz", " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["A3", "\<\"zz\"\>"], "+", 
     SubscriptBox["A3", "\<\"yy\"\>"], "+", 
     SubscriptBox["A3", "\<\"xx\"\>"]}], ")"}]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["IV.a.3. A non-Cartesian orthogonal frame", "Subsubsection",
 PageWidth->WindowWidth,
 FontWeight->"Bold"],

Cell[TextData[{
 "Except in flat space with a Cartesian frame, the orthonormal frame forms \
will have unspecified exterior derivatives which need ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 " to be expressed back in terms of ",
 StyleBox["frame", "Input",
  FontWeight->"Plain"],
 " (unless they have been selected from the ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 " list, as was done above). \n\nFurthermore, if the frame forms are not in \
",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 ", the transformations ",
 StyleBox["dcoords", "Input",
  FontWeight->"Plain"],
 "->",
 StyleBox["frame", "Input",
  FontWeight->"Plain"],
 " must be provided in ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ", so that exterior differentiation of all frame forms and scalar functions \
of the coordinates can be accomplished using the ",
 StyleBox["da[]", "Input",
  FontWeight->"Plain"],
 " operator. All calculations are performed in the orthonormal frame. \
However, input expressions may be expressed in the coordinate frame, and the \
orthonormal output is convertible, as shown in the examples.\n\nThe example \
of spherical coordinates shows what is required."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecoords", "[", 
  RowBox[{"{", 
   RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeframe", "[", 
  RowBox[{"{", 
   RowBox[{
    OverscriptBox["r", "^"], ",", 
    OverscriptBox["\[Theta]", "^"], ",", 
    OverscriptBox["\[Phi]", "^"]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["r", "^"], ",", 
   OverscriptBox["\[Theta]", "^"], ",", 
   OverscriptBox["\[Phi]", "^"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["signature"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["scalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]", ",", "x", ",", "y", ",", "z"}],
   "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["dscalars"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "dr", ",", "d\[Theta]", ",", "d\[Phi]", ",", "dx", ",", "dy", ",", "dz"}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["r", "^"], ",", 
   OverscriptBox["\[Theta]", "^"], ",", 
   OverscriptBox["\[Phi]", "^"], ",", "dr", ",", "d\[Theta]", ",", "d\[Phi]", 
   ",", "dx", ",", "dy", ",", "dz"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["dforms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["dr", "^"], ",", 
   OverscriptBox["d\[Theta]", "^"], ",", 
   OverscriptBox["d\[Phi]", "^"]}], "}"}]], "Output"]
}, Open  ]],

Cell["Now the framedrules will be established:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tocoords", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"frame", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "->", "dr"}], ",", 
    RowBox[{
     RowBox[{"frame", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "->", 
     RowBox[{"r", " ", "d\[Theta]"}]}], ",", 
    RowBox[{
     RowBox[{"frame", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "->", 
     RowBox[{"r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", "d\[Phi]"}]}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    OverscriptBox["r", "^"], "\[Rule]", "dr"}], ",", 
   RowBox[{
    OverscriptBox["\[Theta]", "^"], "\[Rule]", 
    RowBox[{"d\[Theta]", " ", "r"}]}], ",", 
   RowBox[{
    OverscriptBox["\[Phi]", "^"], "\[Rule]", 
    RowBox[{"d\[Phi]", " ", "r", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["The shortcut for this is:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tocoords", " ", "=", " ", 
  RowBox[{"Thread", "[", 
   RowBox[{"frame", " ", "->", " ", 
    RowBox[{"{", 
     RowBox[{"dr", ",", " ", 
      RowBox[{"r", " ", "d\[Theta]"}], ",", " ", 
      RowBox[{"r", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", "d\[Phi]"}]}], "}"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    OverscriptBox["r", "^"], "\[Rule]", "dr"}], ",", 
   RowBox[{
    OverscriptBox["\[Theta]", "^"], "\[Rule]", 
    RowBox[{"d\[Theta]", " ", "r"}]}], ",", 
   RowBox[{
    OverscriptBox["\[Phi]", "^"], "\[Rule]", 
    RowBox[{"d\[Phi]", " ", "r", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["AVF",
  FontSlant->"Italic"],
 " command ",
 StyleBox["prune[list,expr]", "Input",
  FontWeight->"Plain"],
 " is useful to select the relevant part of a longer list. In this case, it \
returns a list containing the members of ",
 StyleBox["dscalars", "Input",
  FontWeight->"Plain"],
 " that appear in ",
 StyleBox["tocoords", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"prunedlist", "=", 
  RowBox[{"prune", "[", 
   RowBox[{"dscalars", ",", "tocoords"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dr", ",", "d\[Theta]", ",", "d\[Phi]"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"toframe", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"tocoords", "/.", 
       RowBox[{"Rule", "->", "Equal"}]}], ")"}], ",", "prunedlist"}], "]"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"dr", "\[Rule]", 
    OverscriptBox["r", "^"]}], ",", 
   RowBox[{"d\[Theta]", "\[Rule]", 
    FractionBox[
     OverscriptBox["\[Theta]", "^"], "r"]}], ",", 
   RowBox[{"d\[Phi]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      OverscriptBox["\[Phi]", "^"]}], "r"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The next command constructs the appropriate ",
 StyleBox["frame", "Input",
  FontWeight->"Plain"],
 " derivatives to be used in ",
 StyleBox["framedrules", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dframe", "=", 
  RowBox[{"expand", "[", 
   RowBox[{
    RowBox[{"d", "[", 
     RowBox[{"frame", "/.", "tocoords"}], "]"}], "/.", "toframe"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox[
    RowBox[{
     OverscriptBox["r", "^"], "\[Wedge]", 
     OverscriptBox["\[Theta]", "^"]}], "r"], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      OverscriptBox["r", "^"], "\[Wedge]", 
      OverscriptBox["\[Phi]", "^"]}], "r"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
      RowBox[{
       OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
       OverscriptBox["\[Phi]", "^"]}]}], "r"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"framedrules", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{"dforms", "->", "dframe"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    OverscriptBox["dr", "^"], "\[Rule]", "0"}], ",", 
   RowBox[{
    OverscriptBox["d\[Theta]", "^"], "\[Rule]", 
    FractionBox[
     RowBox[{
      OverscriptBox["r", "^"], "\[Wedge]", 
      OverscriptBox["\[Theta]", "^"]}], "r"]}], ",", 
   RowBox[{
    OverscriptBox["d\[Phi]", "^"], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       OverscriptBox["r", "^"], "\[Wedge]", 
       OverscriptBox["\[Phi]", "^"]}], "r"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       RowBox[{
        OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
        OverscriptBox["\[Phi]", "^"]}]}], "r"]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "And now these  are established as ",
 StyleBox["drules", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makedrules", "[", 
  RowBox[{"Join", "[", 
   RowBox[{"framedrules", ",", "toframe"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    OverscriptBox["dr", "^"], "\[Rule]", "0"}], ",", 
   RowBox[{
    OverscriptBox["d\[Theta]", "^"], "\[Rule]", 
    FractionBox[
     RowBox[{
      OverscriptBox["r", "^"], "\[Wedge]", 
      OverscriptBox["\[Theta]", "^"]}], "r"]}], ",", 
   RowBox[{
    OverscriptBox["d\[Phi]", "^"], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       OverscriptBox["r", "^"], "\[Wedge]", 
       OverscriptBox["\[Phi]", "^"]}], "r"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       RowBox[{
        OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
        OverscriptBox["\[Phi]", "^"]}]}], "r"]}]}], ",", 
   RowBox[{"dr", "\[Rule]", 
    OverscriptBox["r", "^"]}], ",", 
   RowBox[{"d\[Theta]", "\[Rule]", 
    FractionBox[
     OverscriptBox["\[Theta]", "^"], "r"]}], ",", 
   RowBox[{"d\[Phi]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      OverscriptBox["\[Phi]", "^"]}], "r"]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Of course, it would be convenient to collect these preparation commands \
into a subroutine. Problems may arise from using ",
 StyleBox["Solve", "Input",
  FontWeight->"Plain"],
 " to get the inverse transformation and the possible need at times for ",
 StyleBox["Simplify", "Input",
  FontWeight->"Plain"],
 ". A better approach for other cases is to copy the relevant parts of this \
program into a new Notebook and modify them as necessary."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vol", "=", 
  RowBox[{"hs", "[", "1", "]"}]}], "\n", 
 RowBox[{"expand", "[", 
  RowBox[{"vol", "/.", "tocoords"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  OverscriptBox["r", "^"], "\[Wedge]", 
  OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
  OverscriptBox["\[Phi]", "^"]}]], "Output"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
  RowBox[{"dr", "\[Wedge]", "d\[Theta]", "\[Wedge]", "d\[Phi]"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Using Hodge, an inner product, called ",
 StyleBox["dot", "Input",
  FontWeight->"Plain"],
 ", can be defined for any two p-forms (of the same degree). For the frame \
forms themselves, it exhibits the orthonormality;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"dot", "[", 
  RowBox[{
   OverscriptBox["\[Phi]", "^"], ",", 
   OverscriptBox["\[Phi]", "^"]}], "]"}], "\n", 
 RowBox[{"dot", "[", 
  RowBox[{
   OverscriptBox["r", "^"], ",", 
   OverscriptBox["\[Theta]", "^"]}], "]"}]}], "Input"],

Cell[BoxData["1"], "Output"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["\<\
and for the coordinate basis it will give the covariant metric,\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", 
  RowBox[{"Inverse", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"dot", "[", 
      RowBox[{
       RowBox[{"dscalars", "[", 
        RowBox[{"[", "j", "]"}], "]"}], ",", 
       RowBox[{"dscalars", "[", 
        RowBox[{"[", "k", "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "coordsdim"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "coordsdim"}], "}"}]}], "]"}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", 
      SuperscriptBox["r", "2"], "0"},
     {"0", "0", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f", "=", 
  RowBox[{"Y", "[", "depend", "]"}]}], "\n", 
 RowBox[{"hs", "[", "f", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"Y", "[", 
  RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["r", "^"], "\[Wedge]", 
   OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
   OverscriptBox["\[Phi]", "^"]}], " ", 
  RowBox[{"Y", "[", 
   RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"df", "=", 
  RowBox[{"d", "[", "f", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d\[Phi]", " ", 
   SubscriptBox["Y", "\[Phi]"]}], "+", 
  RowBox[{"d\[Theta]", " ", 
   SubscriptBox["Y", "\[Theta]"]}], "+", 
  RowBox[{"dr", " ", 
   SubscriptBox["Y", "r"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "[", "f", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
    OverscriptBox["\[Phi]", "^"], " ", 
    SubscriptBox["Y", "\[Phi]"]}], "r"], "+", 
  FractionBox[
   RowBox[{
    OverscriptBox["\[Theta]", "^"], " ", 
    SubscriptBox["Y", "\[Theta]"]}], "r"], "+", 
  RowBox[{
   OverscriptBox["r", "^"], " ", 
   SubscriptBox["Y", "r"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"divdf", "=", 
  RowBox[{"\[Delta]", "[", "df", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
    SubscriptBox["Y", "\<\"\[Phi]\[Phi]\"\>"]}], 
   SuperscriptBox["r", "2"]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
    SubscriptBox["Y", "\[Theta]"]}], 
   SuperscriptBox["r", "2"]], "+", 
  FractionBox[
   SubscriptBox["Y", "\<\"\[Theta]\[Theta]\"\>"], 
   SuperscriptBox["r", "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SubscriptBox["Y", "r"]}], "r"], "+", 
  SubscriptBox["Y", "\<\"rr\"\>"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"curldf", "=", 
  RowBox[{"\[Delta]", "[", 
   RowBox[{"hs", "[", "df", "]"}], "]"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"A", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"A1", "[", "depend", "]"}], " ", 
    OverscriptBox["r", "^"]}], "+", 
   RowBox[{
    RowBox[{"A2", "[", "depend", "]"}], " ", 
    OverscriptBox["\[Theta]", "^"]}], "+", 
   RowBox[{
    RowBox[{"A3", "[", "depend", "]"}], " ", 
    OverscriptBox["\[Phi]", "^"]}]}]}], "\n", 
 RowBox[{"hs", "[", "A", "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A1", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   OverscriptBox["r", "^"]}], "+", 
  RowBox[{
   RowBox[{"A2", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   OverscriptBox["\[Theta]", "^"]}], "+", 
  RowBox[{
   RowBox[{"A3", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   OverscriptBox["\[Phi]", "^"]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A3", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{
    OverscriptBox["r", "^"], "\[Wedge]", 
    OverscriptBox["\[Theta]", "^"]}]}], "-", 
  RowBox[{
   RowBox[{"A2", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{
    OverscriptBox["r", "^"], "\[Wedge]", 
    OverscriptBox["\[Phi]", "^"]}]}], "+", 
  RowBox[{
   RowBox[{"A1", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{
    OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
    OverscriptBox["\[Phi]", "^"]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"B", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"B1", "[", "depend", "]"}], " ", "dr"}], "+", 
   RowBox[{
    RowBox[{"B2", "[", "depend", "]"}], " ", "d\[Theta]"}], "+", 
   RowBox[{
    RowBox[{"B3", "[", "depend", "]"}], " ", "d\[Phi]"}]}]}], "\n", 
 RowBox[{"hs", "[", "B", "]"}], "\n", 
 RowBox[{"expand", "[", 
  RowBox[{"%", "/.", "tocoords"}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dr", " ", 
   RowBox[{"B1", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
  RowBox[{"d\[Theta]", " ", 
   RowBox[{"B2", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
  RowBox[{"d\[Phi]", " ", 
   RowBox[{"B3", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"B3", "[", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
    RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
    RowBox[{
     OverscriptBox["r", "^"], "\[Wedge]", 
     OverscriptBox["\[Theta]", "^"]}]}], "r"], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"B2", "[", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
    RowBox[{
     OverscriptBox["r", "^"], "\[Wedge]", 
     OverscriptBox["\[Phi]", "^"]}]}], "r"], "+", 
  RowBox[{
   RowBox[{"B1", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{
    OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
    OverscriptBox["\[Phi]", "^"]}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"B3", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
   RowBox[{"dr", "\[Wedge]", "d\[Theta]"}]}], "-", 
  RowBox[{
   RowBox[{"B2", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
   RowBox[{"dr", "\[Wedge]", "d\[Phi]"}]}], "+", 
  RowBox[{
   SuperscriptBox["r", "2"], " ", 
   RowBox[{"B1", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
   RowBox[{"d\[Theta]", "\[Wedge]", "d\[Phi]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The Hodge operator ",
 StyleBox["hs[]", "Input",
  FontWeight->"Plain"],
 " also can be applied to AVF arrays."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hs", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"df", ",", "A"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"B", ",", "df"}], "}"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
        RowBox[{
         OverscriptBox["r", "^"], "\[Wedge]", 
         OverscriptBox["\[Theta]", "^"]}], " ", 
        SubscriptBox["Y", "\[Phi]"]}], "r"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{
         OverscriptBox["r", "^"], "\[Wedge]", 
         OverscriptBox["\[Phi]", "^"]}], " ", 
        SubscriptBox["Y", "\[Theta]"]}], "r"], "+", 
      RowBox[{
       RowBox[{
        OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
        OverscriptBox["\[Phi]", "^"]}], " ", 
       SubscriptBox["Y", "r"]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"A3", "[", 
        RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
       RowBox[{
        OverscriptBox["r", "^"], "\[Wedge]", 
        OverscriptBox["\[Theta]", "^"]}]}], "-", 
      RowBox[{
       RowBox[{"A2", "[", 
        RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
       RowBox[{
        OverscriptBox["r", "^"], "\[Wedge]", 
        OverscriptBox["\[Phi]", "^"]}]}], "+", 
      RowBox[{
       RowBox[{"A1", "[", 
        RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
       RowBox[{
        OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
        OverscriptBox["\[Phi]", "^"]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"B3", "[", 
         RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
        RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
        RowBox[{
         OverscriptBox["r", "^"], "\[Wedge]", 
         OverscriptBox["\[Theta]", "^"]}]}], "r"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"B2", "[", 
         RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
        RowBox[{
         OverscriptBox["r", "^"], "\[Wedge]", 
         OverscriptBox["\[Phi]", "^"]}]}], "r"], "+", 
      RowBox[{
       RowBox[{"B1", "[", 
        RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
       RowBox[{
        OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
        OverscriptBox["\[Phi]", "^"]}]}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
        RowBox[{
         OverscriptBox["r", "^"], "\[Wedge]", 
         OverscriptBox["\[Theta]", "^"]}], " ", 
        SubscriptBox["Y", "\[Phi]"]}], "r"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{
         OverscriptBox["r", "^"], "\[Wedge]", 
         OverscriptBox["\[Phi]", "^"]}], " ", 
        SubscriptBox["Y", "\[Theta]"]}], "r"], "+", 
      RowBox[{
       RowBox[{
        OverscriptBox["\[Theta]", "^"], "\[Wedge]", 
        OverscriptBox["\[Phi]", "^"]}], " ", 
       SubscriptBox["Y", "r"]}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"divA", "=", 
  RowBox[{"\[Delta]", "[", "A", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"A1", "[", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], "r"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"A2", "[", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
    RowBox[{"Cot", "[", "\[Theta]", "]"}]}], "r"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
    SubscriptBox["A3", "\[Phi]"]}], "r"], "+", 
  FractionBox[
   SubscriptBox["A2", "\[Theta]"], "r"], "+", 
  SubscriptBox["A1", "r"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"curlA", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"hs", "[", 
     RowBox[{"d", "[", "A", "]"}], "]"}], ",", "frame"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["r", "^"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"A3", "[", 
        RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
       RowBox[{"Cot", "[", "\[Theta]", "]"}]}], "r"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["A2", "\[Phi]"]}], "r"], "+", 
     FractionBox[
      SubscriptBox["A3", "\[Theta]"], "r"]}], ")"}]}], "+", 
  RowBox[{
   OverscriptBox["\[Phi]", "^"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"A2", "[", 
       RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], "r"], "-", 
     FractionBox[
      SubscriptBox["A1", "\[Theta]"], "r"], "+", 
     SubscriptBox["A2", "r"]}], ")"}]}], "+", 
  RowBox[{
   OverscriptBox["\[Theta]", "^"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"A3", "[", 
        RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], "r"]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["A1", "\[Phi]"]}], "r"], "-", 
     SubscriptBox["A3", "r"]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"curlB", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"expand", "[", 
     RowBox[{
      RowBox[{"hs", "[", 
       RowBox[{"d", "[", "B", "]"}], "]"}], "/.", "tocoords"}], "]"}], ",", 
    "prunedlist"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dr", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
        SubscriptBox["B2", "\[Phi]"]}], 
       SuperscriptBox["r", "2"]]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["B3", "\[Theta]"]}], 
      SuperscriptBox["r", "2"]]}], ")"}]}], "+", 
  RowBox[{"d\[Phi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], " ", 
      SubscriptBox["B1", "\[Theta]"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["B2", "r"]}]}], ")"}]}], "+", 
  RowBox[{"d\[Theta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["B1", "\[Phi]"]}], "-", 
     RowBox[{
      RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
      SubscriptBox["B3", "r"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"divcurlA", "=", 
  RowBox[{"\[Delta]", "[", "curlA", "]"}]}], "\n", 
 RowBox[{"divcurlB", "=", 
  RowBox[{"\[Delta]", "[", "curlB", "]"}]}]}], "Input"],

Cell[BoxData["0"], "Output"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"delsquaredA", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"da", "[", 
      RowBox[{"\[Delta]", "[", "A", "]"}], "]"}], "-", 
     RowBox[{"\[Delta]", "[", 
      RowBox[{"d", "[", "A", "]"}], "]"}]}], ",", "frame"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["r", "^"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"A1", "[", 
         RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
       SuperscriptBox["r", "2"]]}], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"A2", "[", 
        RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
       RowBox[{"Cot", "[", "\[Theta]", "]"}]}], 
      SuperscriptBox["r", "2"]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["A3", "\[Phi]"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
       SubscriptBox["A1", "\<\"\[Phi]\[Phi]\"\>"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["A1", "\[Theta]"]}], 
      SuperscriptBox["r", "2"]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       SubscriptBox["A2", "\[Theta]"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      SubscriptBox["A1", "\<\"\[Theta]\[Theta]\"\>"], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SubscriptBox["A1", "r"]}], "r"], "+", 
     SubscriptBox["A1", "\<\"rr\"\>"]}], ")"}]}], "+", 
  RowBox[{
   OverscriptBox["\[Theta]", "^"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"A2", "[", 
         RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}], 
       SuperscriptBox["r", "2"]]}], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["A3", "\[Phi]"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
       SubscriptBox["A2", "\<\"\[Phi]\[Phi]\"\>"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SubscriptBox["A1", "\[Theta]"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["A2", "\[Theta]"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      SubscriptBox["A2", "\<\"\[Theta]\[Theta]\"\>"], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SubscriptBox["A2", "r"]}], "r"], "+", 
     SubscriptBox["A2", "\<\"rr\"\>"]}], ")"}]}], "+", 
  RowBox[{
   OverscriptBox["\[Phi]", "^"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"A3", "[", 
         RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}], 
       SuperscriptBox["r", "2"]]}], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["A1", "\[Phi]"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["A2", "\[Phi]"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
       SubscriptBox["A3", "\<\"\[Phi]\[Phi]\"\>"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       SubscriptBox["A3", "\[Theta]"]}], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      SubscriptBox["A3", "\<\"\[Theta]\[Theta]\"\>"], 
      SuperscriptBox["r", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SubscriptBox["A3", "r"]}], "r"], "+", 
     SubscriptBox["A3", "\<\"rr\"\>"]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Some inner products calculated by ",
 StyleBox["dot", "Input",
  FontWeight->"Plain"],
 ", where the second and third demonstrate its symmetry;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dot", "[", 
  RowBox[{"B", ",", "B"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"B1", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], "2"], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"B2", "[", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], "2"], 
   SuperscriptBox["r", "2"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"B3", "[", 
      RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}], 
   SuperscriptBox["r", "2"]]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dot", "[", 
  RowBox[{"A", ",", "df"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"A3", "[", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
    RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
    SubscriptBox["Y", "\[Phi]"]}], "r"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"A2", "[", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
    SubscriptBox["Y", "\[Theta]"]}], "r"], "+", 
  RowBox[{
   RowBox[{"A1", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   SubscriptBox["Y", "r"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dot", "[", 
  RowBox[{"df", ",", "A"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"A3", "[", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
    RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
    SubscriptBox["Y", "\[Phi]"]}], "r"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"A2", "[", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
    SubscriptBox["Y", "\[Theta]"]}], "r"], "+", 
  RowBox[{
   RowBox[{"A1", "[", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   SubscriptBox["Y", "r"]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["IV.a.4. Clean up", "Subsubsection"],

Cell[BoxData[
 RowBox[{"makeclear", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["ModifiedGlobalVariables"], "Input"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["IV.b. Implementing Clifford algebras", "Subsection"],

Cell["This is taken from the file CAV_Demo.nb.", "Text"],

Cell[CellGroupData[{

Cell["IV.b.1. Making a Clifford algebra", "Subsubsection"],

Cell[TextData[{
 "A Clifford algebra representation of quaternions will be used as the first \
example. The argument of ",
 StyleBox["makeclifford[arg]", "Input",
  FontWeight->"Plain"],
 " is the desired signature list; i.e., for quaternions, ",
 StyleBox["{-1,-1}", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"makeclifford", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}]}], "}"}], "]"}]], "Input"],

Cell[TextData[{
 "The dimension is given by ",
 StyleBox["cadim", "Input",
  FontWeight->"Plain"],
 ", and the ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 " list has length ",
 StyleBox["eldim=2^cadim", "Input",
  FontWeight->"Plain"],
 "."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["dforms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["d\[Theta]", "0"], ",", 
   SubscriptBox[
    OverscriptBox["d\[Theta]", "1"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["d\[Theta]", "1"], "2"], ",", 
   OverscriptBox["d\[Theta]", "2"], ",", 
   OverscriptBox["d\[Omega]", "0"], ",", 
   SubscriptBox[
    OverscriptBox["d\[Omega]", "1"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["d\[Omega]", "1"], "2"], ",", 
   OverscriptBox["d\[Omega]", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["cadim"], "Input"],

Cell[BoxData["2"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["elements"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Gamma]", "0"], ",", 
   SubscriptBox["\[Gamma]", "1"], ",", 
   SubscriptBox["\[Gamma]", "2"], ",", 
   SubscriptBox["\[Gamma]", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["eldim"], "Input"],

Cell[BoxData["4"], "Output"]
}, Open  ]],

Cell[TextData[{
 "The first element, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "0"], TraditionalForm]]],
 ", is the identity; ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "1"], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "2"], TraditionalForm]]],
 "are the orthonormal generators, both with negative signature; and the \
complete product element here is, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "3"], TraditionalForm]]],
 "= ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox[
     SubscriptBox["\[Gamma]", "1"],
     TraditionalForm], 
    SubscriptBox["\[Gamma]", "2"]}], TraditionalForm]]],
 ", which also has a negative square. The command ",
 StyleBox["mtx[]", "Input",
  FontWeight->"Plain"],
 " outputs the algebra table in MatrixForm."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "1"], 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "3"]},
     {
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      SubscriptBox["\[Gamma]", "3"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}]},
     {
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      SubscriptBox["\[Gamma]", "1"]},
     {
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
As described in the Introduction section, all the following graded symbol \
lists and CAV quantites are constructed:\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData["gammas"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Gamma]", "0"], ",", 
   SubscriptBox["\[Gamma]", "1"], ",", 
   SubscriptBox["\[Gamma]", "2"], ",", 
   SubscriptBox["\[Gamma]", "3"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["thetas"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["\[Theta]", "0"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "2"], ",", 
   OverscriptBox["\[Theta]", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["omegas"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["\[Omega]", "0"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "2"], ",", 
   OverscriptBox["\[Omega]", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["\[Theta]", "0"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "2"], ",", 
   OverscriptBox["\[Theta]", "2"], ",", 
   OverscriptBox["\[Omega]", "0"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "2"], ",", 
   OverscriptBox["\[Omega]", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 OverscriptBox["\[Theta]", "^"]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["\[Theta]", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   OverscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Gamma]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 OverscriptBox["\[Omega]", "^"]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["\[Omega]", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   OverscriptBox["\[Omega]", "2"], " ", 
   SubscriptBox["\[Gamma]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "2"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The generalized torsion and curvature 2-forms are defined by the CAV \
expressions;\n\n          ",
 Cell[BoxData[
  RowBox[{"  ", 
   RowBox[{
    OverscriptBox["\[CapitalTheta]", "^"], " ", "=", " ", 
    RowBox[{
     RowBox[{"d", "[", 
      OverscriptBox["\[Theta]", "^"], "]"}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         OverscriptBox["\[Omega]", "^"], "**", 
         OverscriptBox["\[Theta]", "^"]}], "+", 
        RowBox[{
         OverscriptBox["\[Theta]", "^"], "**", 
         OverscriptBox["\[Omega]", "^"]}]}], ")"}]}]}]}]}]], "Input"],
 "\n          \n           ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    OverscriptBox["\[CapitalOmega]", "^"], " ", "=", " ", 
    RowBox[{
     RowBox[{"d", "[", 
      OverscriptBox["\[Omega]", "^"], "]"}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        OverscriptBox["\[Omega]", "^"], "**", 
        OverscriptBox["\[Omega]", "^"]}], ")"}], " "}]}]}]}]], "Input"],
 "\n\nand can be evaluated for any assigned { ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Theta]", "^"], TraditionalForm]]],
 " , ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Omega]", "^"], TraditionalForm]]],
 " } with the functions;"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maketorsion", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["d\[Theta]", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "1"], "2"], "+", 
     RowBox[{
      OverscriptBox["\[Theta]", "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "+", 
     RowBox[{
      OverscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "1"], "1"], "-", 
     RowBox[{
      OverscriptBox["\[Theta]", "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "-", 
     RowBox[{
      OverscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["d\[Theta]", "2"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makecurvature", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["d\[Omega]", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "1"], "2"], "+", 
     RowBox[{
      OverscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Omega]", "1"], "1"], "-", 
     RowBox[{
      OverscriptBox["\[Omega]", "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["d\[Omega]", "2"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The identity element, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "0"], TraditionalForm]]],
 ", appears explicitly because the functions use the ",
 StyleBox["collect", "Input",
  FontWeight->"Plain"],
 " command to group the expressions into coefficients of ",
 StyleBox["elements", "Input",
  FontWeight->"Plain"],
 ". These expressions are assigned to the variable names, ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[CapitalTheta]", "^"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[CapitalOmega]", "^"], TraditionalForm]]],
 " . They satisfy the general differential identities given in the \
Introduction section."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"curvatureidentity", "[", "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"torsionidentity", "[", "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["\<\
A general 0-form quaternion with constant components can be constructed by\
\>", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  OverscriptBox["q", "^"], "=", 
  RowBox[{
   OverscriptBox["\[Omega]", "^"], "/.", 
   RowBox[{"\[Omega]", "->", "q"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["q", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   OverscriptBox["q", "2"], " ", 
   SubscriptBox["\[Gamma]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   SubscriptBox[
    OverscriptBox["q", "1"], "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   SubscriptBox[
    OverscriptBox["q", "1"], "2"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "and the components become scalar fields when established as ",
 StyleBox["scalars", "Input",
  FontWeight->"Plain"],
 ","
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makescalars", "[", 
  RowBox[{"coeffs", "[", 
   OverscriptBox["q", "^"], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["q", "0"], ",", 
   SubscriptBox[
    OverscriptBox["q", "1"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["q", "1"], "2"], ",", 
   OverscriptBox["q", "2"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collect", "[", 
  RowBox[{
   OverscriptBox["q", "^"], "**", 
   RowBox[{"d", "[", 
    OverscriptBox["q", "^"], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      OverscriptBox["q", "2"], " ", 
      SubscriptBox[
       OverscriptBox["dq", "1"], "1"]}], "+", 
     RowBox[{
      OverscriptBox["q", "0"], " ", 
      SubscriptBox[
       OverscriptBox["dq", "1"], "2"]}], "-", 
     RowBox[{
      OverscriptBox["dq", "2"], " ", 
      SubscriptBox[
       OverscriptBox["q", "1"], "1"]}], "+", 
     RowBox[{
      OverscriptBox["dq", "0"], " ", 
      SubscriptBox[
       OverscriptBox["q", "1"], "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      OverscriptBox["q", "0"], " ", 
      SubscriptBox[
       OverscriptBox["dq", "1"], "1"]}], "-", 
     RowBox[{
      OverscriptBox["q", "2"], " ", 
      SubscriptBox[
       OverscriptBox["dq", "1"], "2"]}], "+", 
     RowBox[{
      OverscriptBox["dq", "0"], " ", 
      SubscriptBox[
       OverscriptBox["q", "1"], "1"]}], "+", 
     RowBox[{
      OverscriptBox["dq", "2"], " ", 
      SubscriptBox[
       OverscriptBox["q", "1"], "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      OverscriptBox["dq", "2"], " ", 
      OverscriptBox["q", "0"]}], "+", 
     RowBox[{
      OverscriptBox["dq", "0"], " ", 
      OverscriptBox["q", "2"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["dq", "1"], "2"], " ", 
      SubscriptBox[
       OverscriptBox["q", "1"], "1"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["dq", "1"], "1"], " ", 
      SubscriptBox[
       OverscriptBox["q", "1"], "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "0"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      OverscriptBox["dq", "0"], " ", 
      OverscriptBox["q", "0"]}], "-", 
     RowBox[{
      OverscriptBox["dq", "2"], " ", 
      OverscriptBox["q", "2"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["dq", "1"], "1"], " ", 
      SubscriptBox[
       OverscriptBox["q", "1"], "1"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["dq", "1"], "2"], " ", 
      SubscriptBox[
       OverscriptBox["q", "1"], "2"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "[", "%", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["\[Gamma]", "2"], " ", 
   RowBox[{
    OverscriptBox["dq", "2"], "\[Wedge]", 
    SubscriptBox[
     OverscriptBox["dq", "1"], "1"]}]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Gamma]", "1"], " ", 
   RowBox[{
    OverscriptBox["dq", "2"], "\[Wedge]", 
    SubscriptBox[
     OverscriptBox["dq", "1"], "2"]}]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Gamma]", "3"], " ", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["dq", "1"], "1"], "\[Wedge]", 
    SubscriptBox[
     OverscriptBox["dq", "1"], "2"]}]}]}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["IV.b.2. Clifford algebra for a spacetime metric", "Subsubsection"],

Cell["Using a Lorentzian 4-space signature:", "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"makeclifford", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1"}], "}"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["elements"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Gamma]", "0"], ",", 
   SubscriptBox["\[Gamma]", "1"], ",", 
   SubscriptBox["\[Gamma]", "2"], ",", 
   SubscriptBox["\[Gamma]", "3"], ",", 
   SubscriptBox["\[Gamma]", "4"], ",", 
   SubscriptBox["\[Gamma]", "12"], ",", 
   SubscriptBox["\[Gamma]", "13"], ",", 
   SubscriptBox["\[Gamma]", "14"], ",", 
   SubscriptBox["\[Gamma]", "23"], ",", 
   SubscriptBox["\[Gamma]", "24"], ",", 
   SubscriptBox["\[Gamma]", "34"], ",", 
   SubscriptBox["\[Gamma]", "15"], ",", 
   SubscriptBox["\[Gamma]", "25"], ",", 
   SubscriptBox["\[Gamma]", "35"], ",", 
   SubscriptBox["\[Gamma]", "45"], ",", 
   SubscriptBox["\[Gamma]", "5"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["forms"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OverscriptBox["\[Theta]", "0"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "2"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "3"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "4"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "12"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "13"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "14"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "23"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "24"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "34"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "3"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "3"], "2"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "3"], "3"], ",", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "3"], "4"], ",", 
   OverscriptBox["\[Theta]", "4"], ",", 
   OverscriptBox["\[Omega]", "0"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "2"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "3"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "4"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "12"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "13"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "14"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "23"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "24"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "34"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "3"], "1"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "3"], "2"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "3"], "3"], ",", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "3"], "4"], ",", 
   OverscriptBox["\[Omega]", "4"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mtx", "[", "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "1"], 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "4"], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "34"], 
      SubscriptBox["\[Gamma]", "15"], 
      SubscriptBox["\[Gamma]", "25"], 
      SubscriptBox["\[Gamma]", "35"], 
      SubscriptBox["\[Gamma]", "45"], 
      SubscriptBox["\[Gamma]", "5"]},
     {
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      SubscriptBox["\[Gamma]", "35"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "5"]}], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "15"]},
     {
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], 
      SubscriptBox["\[Gamma]", "45"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "35"]}], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "25"]},
     {
      SubscriptBox["\[Gamma]", "3"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], 
      SubscriptBox["\[Gamma]", "25"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      SubscriptBox["\[Gamma]", "15"], 
      SubscriptBox["\[Gamma]", "4"], 
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "14"], 
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      SubscriptBox["\[Gamma]", "35"]},
     {
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "35"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "5"], 
      SubscriptBox["\[Gamma]", "45"]},
     {
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      SubscriptBox["\[Gamma]", "35"], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      SubscriptBox["\[Gamma]", "5"], 
      SubscriptBox["\[Gamma]", "25"], 
      SubscriptBox["\[Gamma]", "15"], 
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      SubscriptBox["\[Gamma]", "34"]},
     {
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "45"], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "5"]}], 
      SubscriptBox["\[Gamma]", "14"], 
      SubscriptBox["\[Gamma]", "35"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      SubscriptBox["\[Gamma]", "15"], 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}]},
     {
      SubscriptBox["\[Gamma]", "14"], 
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "35"]}], 
      SubscriptBox["\[Gamma]", "25"], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      SubscriptBox["\[Gamma]", "45"], 
      SubscriptBox["\[Gamma]", "3"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      SubscriptBox["\[Gamma]", "15"], 
      SubscriptBox["\[Gamma]", "23"]},
     {
      SubscriptBox["\[Gamma]", "23"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "35"]}], 
      SubscriptBox["\[Gamma]", "25"], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}]},
     {
      SubscriptBox["\[Gamma]", "24"], 
      SubscriptBox["\[Gamma]", "35"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      SubscriptBox["\[Gamma]", "15"], 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "5"]}], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], 
      SubscriptBox["\[Gamma]", "25"], 
      SubscriptBox["\[Gamma]", "13"]},
     {
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      SubscriptBox["\[Gamma]", "13"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      SubscriptBox["\[Gamma]", "23"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      SubscriptBox["\[Gamma]", "35"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}]},
     {
      SubscriptBox["\[Gamma]", "15"], 
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "24"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "35"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "13"], 
      SubscriptBox["\[Gamma]", "14"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}]},
     {
      SubscriptBox["\[Gamma]", "25"], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "5"]}], 
      SubscriptBox["\[Gamma]", "14"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "35"], 
      SubscriptBox["\[Gamma]", "45"], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "24"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}]},
     {
      SubscriptBox["\[Gamma]", "35"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "5"]}], 
      SubscriptBox["\[Gamma]", "12"], 
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "2"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "1"]}], 
      SubscriptBox["\[Gamma]", "45"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "13"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "23"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}]},
     {
      SubscriptBox["\[Gamma]", "45"], 
      SubscriptBox["\[Gamma]", "23"], 
      SubscriptBox["\[Gamma]", "13"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "5"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "3"]}], 
      SubscriptBox["\[Gamma]", "2"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      SubscriptBox["\[Gamma]", "1"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "35"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "34"]}], 
      SubscriptBox["\[Gamma]", "0"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "4"]}]},
     {
      SubscriptBox["\[Gamma]", "5"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "15"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "25"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "35"]}], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "45"]}], 
      SubscriptBox["\[Gamma]", "34"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "24"]}], 
      SubscriptBox["\[Gamma]", "23"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "14"]}], 
      SubscriptBox["\[Gamma]", "13"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "12"]}], 
      SubscriptBox["\[Gamma]", "1"], 
      SubscriptBox["\[Gamma]", "2"], 
      SubscriptBox["\[Gamma]", "3"], 
      SubscriptBox["\[Gamma]", "4"], 
      RowBox[{"-", 
       SubscriptBox["\[Gamma]", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The general values of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Theta]", "^"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Omega]", "^"], TraditionalForm]]],
 " , including all grades, are assigned by the ",
 StyleBox["makeclifford", "Input",
  FontWeight->"Plain"],
 " command."
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 OverscriptBox["\[Theta]", "^"]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["\[Theta]", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   OverscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Gamma]", "5"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "3"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "4"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "1"], "4"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "12"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "12"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "13"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "13"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "14"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "14"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "23"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "23"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "24"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "24"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "34"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "2"], "34"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "15"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "3"], "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "25"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "3"], "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "35"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "3"], "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "45"], " ", 
   SubscriptBox[
    OverscriptBox["\[Theta]", "3"], "4"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 OverscriptBox["\[Omega]", "^"]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["\[Omega]", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   OverscriptBox["\[Omega]", "4"], " ", 
   SubscriptBox["\[Gamma]", "5"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "3"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "4"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "1"], "4"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "12"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "12"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "13"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "13"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "14"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "23"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "23"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "24"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "34"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "2"], "34"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "15"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "3"], "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "25"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "3"], "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "35"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "3"], "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "45"], " ", 
   SubscriptBox[
    OverscriptBox["\[Omega]", "3"], "4"]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The CAV 2-forms of generalized torsion  ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[CapitalTheta]", "^"], TraditionalForm]]],
 "  and curvature  ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[CapitalOmega]", "^"], TraditionalForm]]],
 "  can be constructed using those values:"
}], "Text",
 PageWidth->WindowWidth,
 FontFamily->"Times",
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maketorsion", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   OverscriptBox["d\[Theta]", "0"], " ", 
   SubscriptBox["\[Gamma]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "1"], "1"], "+", 
     RowBox[{
      OverscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "1"]}], "+", 
     RowBox[{
      OverscriptBox["\[Omega]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "1"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "1"], "2"], "+", 
     RowBox[{
      OverscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "2"]}], "+", 
     RowBox[{
      OverscriptBox["\[Omega]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "2"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "24"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "1"], "4"], "+", 
     RowBox[{
      OverscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "4"]}], "+", 
     RowBox[{
      OverscriptBox["\[Omega]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "4"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "24"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "1"], "3"], "+", 
     RowBox[{
      OverscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "3"]}], "+", 
     RowBox[{
      OverscriptBox["\[Omega]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "3"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "12"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "2"], "12"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "24"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "2"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "1"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "45"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "3"], "4"], "-", 
     RowBox[{
      OverscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}], "-", 
     RowBox[{
      OverscriptBox["\[Omega]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "1"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "24"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "2"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "3"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "13"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "2"], "13"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "3"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "1"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "23"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "2"], "23"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "24"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "3"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "5"], " ", 
   RowBox[{"(", 
    RowBox[{
     OverscriptBox["d\[Theta]", "4"], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "1"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "2"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "3"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "4"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "15"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "3"], "1"], "-", 
     RowBox[{
      OverscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "-", 
     RowBox[{
      OverscriptBox["\[Omega]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "2"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "3"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "4"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "25"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "3"], "2"], "-", 
     RowBox[{
      OverscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "-", 
     RowBox[{
      OverscriptBox["\[Omega]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "1"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "3"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "24"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "4"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "35"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "3"], "3"], "-", 
     RowBox[{
      OverscriptBox["\[Theta]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "-", 
     RowBox[{
      OverscriptBox["\[Omega]", "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "1"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "2"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "4"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "14"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "2"], "14"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "1"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "24"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "24"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "1"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "4"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "1"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "24"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "2"], "24"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "2"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "12"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "12"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "34"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "34"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "23"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "2"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "4"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "3"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "3"], "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Gamma]", "34"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["d\[Theta]", "2"], "34"], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "3"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "4"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "1"], "4"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "1"], "3"]}], "+", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "13"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "14"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "14"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]", "2"], "13"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[Theta]", "2"], "23"], "\[Wedge]", 
      SubscriptBox[
       OverscriptBox["\[Omega]