(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    247486,       6974]*)
(*NotebookOutlinePosition[    248137,       6997]*)
(*  CellTagsIndexPosition[    248093,       6993]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["On Butler's book",
  FontColor->RGBColor[1, 0, 0]]], "Title"],

Cell[TextData[StyleBox["Fundamental algorithms for permutation groups\nG. \
Butler, Springer-Verlag, Heidelberg 1991",
  FontColor->RGBColor[0, 0, 1]]], "Subtitle"],

Cell[TextData[{
  "This notebook checks (or corrects) most of the examples given in that \
book.\n\n\tJ. M. Martin-Garcia\n\t(c) 2003-2008, under GPL\n\tInstituto de \
Estructura de la Materia, CSIC, Madrid (SPAIN)\n\tjmm@iem.cfmac.csic.es\n\t\n\
This notebook is part of the documentation of the package xAct`xPerm` for \
efficient manipulation of permutations under ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The package and its documentation are released under the GNU General \
Public License."
}], "Subsubtitle"],

Cell[CellGroupData[{

Cell["Load xPerm", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< xAct`xPerm`\)], "Input"],

Cell[BoxData[
    \("-----------------------------------------------------------------------\
---------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Package xAct`xCore`  version \
"\[InvisibleSpace]"0.5.0"\[InvisibleSpace]", "\[InvisibleSpace]{2008, 5, 
          16}\),
      SequenceForm[ 
      "Package xAct`xCore`  version ", "0.5.0", ", ", {2008, 5, 16}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("CopyRight (C) 2007-2008, Jose M. Martin-Garcia, under the General \
Public License."\)], "Print"],

Cell[BoxData[
    \("-----------------------------------------------------------------------\
---------"\)], "Print"],

Cell[BoxData[
    \("Package ExpressionManipulation`"\)], "Print"],

Cell[BoxData[
    \("CopyRight (C) 1999-2008, David J. M. Park and Ted Ersek"\)], "Print"],

Cell[BoxData[
    \("-----------------------------------------------------------------------\
---------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Package xAct`xPerm`  version \
"\[InvisibleSpace]"1.0.1"\[InvisibleSpace]", "\[InvisibleSpace]{2008, 5, 
          16}\),
      SequenceForm[ 
      "Package xAct`xPerm`  version ", "1.0.1", ", ", {2008, 5, 16}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("CopyRight (C) 2003-2008, Jose M. Martin-Garcia, under the General \
Public License."\)], "Print"],

Cell[BoxData[
    \("-----------------------------------------------------------------------\
---------"\)], "Print"],

Cell[BoxData[
    \("These packages come with ABSOLUTELY NO WARRANTY; for details type \
Disclaimer[]. This is free software, and you are welcome to redistribute it \
under certain conditions. See the General Public License for details."\)], \
"Print"],

Cell[BoxData[
    \("-----------------------------------------------------------------------\
---------"\)], "Print"],

Cell[BoxData[
    \("Connecting to external linux executable..."\)], "Print"],

Cell[BoxData[
    \("Connection established."\)], "Print"]
}, Open  ]],

Cell["Simple functions, only used in this notebook:", "Text"],

Cell[BoxData[
    \(PrintSchreier[Schreier[orbits__List, w_, nu_]] := 
      With[{points = Union[orbits]}, 
        TableForm[{points, w[\([points]\)] /. \((0 -> "\<Init\>")\), 
            nu[\([points]\)]}]]\)], "Input"],

Cell[BoxData[
    \(NameRules[symb_, n_, 
        not_] := \(Rule[
            TranslatePerm[ToExpression@#, 
              not], #] &\) /@ \((\(ToString@symb <> # &\) /@ \(ToString /@ 
              Range[n]\))\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NameRules[h, 0, Perm]\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\($PrePrint = ReplaceAll[#, $xPermRules] &;\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 0", "Section"],

Cell["Examples in chapter 7, pages 57-61.", "Text"],

Cell[BoxData[{
    \(\(a = Cycles[{1, 4, 5, 11, 6, 10, 3, 2}, {7, 8}];\)\), "\n", 
    \(\(b = Cycles[{1, 4, 5, 11, 6, 10, 3, 2}, {8, 9}];\)\), "\n", 
    \(\(c = Cycles[{1, 4, 2, 3}, {5, 11, 10, 6}];\)\)}], "Input"],

Cell[BoxData[
    \(\($xPermRules = {a \[Rule] "\<a\>", b \[Rule] "\<b\>", 
          c \[Rule] "\<c\>"};\)\)], "Input"],

Cell["Single orbits:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orbit[7, GenSet[a, b, c]]\)], "Input"],

Cell[BoxData[
    \({7, 8, 9}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orbit[1, GenSet[a, b, c]]\)], "Input"],

Cell[BoxData[
    \({1, 4, 5, 2, 11, 3, 6, 10}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierOrbit[7, GenSet[a, b, c], 11]\)], "Input"],

Cell[BoxData[
    \(Schreier[{7, 8, 9}, {0, 0, 0, 0, 0, 0, 0, "a", "b", 0, 0}, {0, 0, 0, 0, 
        0, 0, 0, 7, 8, 0, 0}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[%]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"7", "8", "9"},
          {"\<\"Init\"\>", "\<\"a\"\>", "\<\"b\"\>"},
          {"0", "7", "8"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierOrbit[1, GenSet[a, b, c], 11]\)], "Input"],

Cell[BoxData[
    \(Schreier[{1, 4, 5, 2, 11, 3, 6, 10}, {0, "c", "c", "a", "a", "a", 0, 0, 
        0, "c", "a"}, {0, 4, 2, 1, 4, 11, 0, 0, 0, 11, 5}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[%]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "10", "11"},
          {"\<\"Init\"\>", "\<\"c\"\>", "\<\"c\"\>", "\<\"a\"\>", \
"\<\"a\"\>", "\<\"a\"\>", "\<\"c\"\>", "\<\"a\"\>"},
          {"0", "4", "2", "1", "4", "11", "11", "5"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["All orbits:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orbits[GenSet[a, b, c], 11]\)], "Input"],

Cell[BoxData[
    \({{1, 4, 5, 2, 11, 3, 6, 10}, {7, 8, 9}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierOrbits[GenSet[a, b, c], 11]\)], "Input"],

Cell[BoxData[
    \(Schreier[{1, 4, 5, 2, 11, 3, 6, 10}, {7, 8, 9}, {0, "c", "c", "a", "a", 
        "a", 0, "a", "b", "c", "a"}, {0, 4, 2, 1, 4, 11, 0, 7, 8, 11, 
        5}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[%]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"},
          {"\<\"Init\"\>", "\<\"c\"\>", "\<\"c\"\>", "\<\"a\"\>", \
"\<\"a\"\>", "\<\"a\"\>", "\<\"Init\"\>", "\<\"a\"\>", "\<\"b\"\>", \
"\<\"c\"\>", "\<\"a\"\>"},
          {"0", "4", "2", "1", "4", "11", "0", "7", "8", "11", "5"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 1. Symmetries of the square", "Section"],

Cell["Example in page 80 of Butler.", "Text"],

Cell[BoxData[{
    \(\(a = Cycles[{1, 2, 3, 4}];\)\), "\n", 
    \(\(b = Cycles[{2, 4}];\)\)}], "Input"],

Cell[BoxData[
    \(\(SGS = StrongGenSet[{1, 2}, GenSet[a, b]];\)\)], "Input"],

Cell["We can test membership in G=G^(1):", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[ID, SGS]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Permute[a, b], SGS]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[{2, 1, 3, 4}], SGS]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell["And membership in G^(2):", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Stabilizer[{1}, GenSet[a, b]] \[Equal] GenSet[b]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[a, StrongGenSet[{4}, GenSet[b]]]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[b, StrongGenSet[{4}, GenSet[b]]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[ID, StrongGenSet[{4}, GenSet[b]]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["And membership in G^(3):", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[ID, StrongGenSet[{}, GenSet[]]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["Chain of stabilizers:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StabilizerChain[SGS] // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(StrongGenSet[{1, 2}, 
              GenSet[Cycles[{1, 2, 3, 4}], Cycles[{2, 4}]]]\)},
          {\(StrongGenSet[{2}, GenSet[Cycles[{2, 4}]]]\)},
          {\(StrongGenSet[{}, GenSet[]]\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        StrongGenSet[ {1, 2}, 
          GenSet[ 
            Cycles[ {1, 2, 3, 4}], 
            Cycles[ {2, 4}]]], 
        StrongGenSet[ {2}, 
          GenSet[ 
            Cycles[ {2, 4}]]], 
        StrongGenSet[ {}, 
          GenSet[ ]]}],
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\($xPermRules = {a \[Rule] "\<a\>", b \[Rule] "\<b\>"};\)\)], "Input"],

Cell["Schreier vectors:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[
      SchreierOrbit[1, \(StabilizerChain[SGS]\)[\([1, 2]\)], 4]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4"},
          {"\<\"Init\"\>", "\<\"a\"\>", "\<\"a\"\>", "\<\"b\"\>"},
          {"0", "1", "2", "2"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[
      SchreierOrbit[2, \(StabilizerChain[SGS]\)[\([2, 2]\)], 4]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"2", "4"},
          {"\<\"Init\"\>", "\<\"b\"\>"},
          {"0", "2"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["Construction of the pair (base,SGS) from scratch:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[{1}, GenSet[a, b], 4, 
      xPermVerbose \[Rule] True]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3, 4}], 
          Cycles[{2, 
              4}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{2, 4}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 3, 4}], 
          Cycles[ {2, 4}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {2, 4}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3, 4}], 
          Cycles[{2, 
              4}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]1\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3, 4}], Cycles[{2, 4}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 3, 4}], 
          Cycles[ {2, 4}]], ", i=", 1, ", T=", 
        GenSet[ 
          Cycles[ {1, 2, 3, 4}], 
          Cycles[ {2, 4}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]10\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]8\),
      SequenceForm[ 
      "Checked ", 10, " generators and obtained group of order ", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1, 2}, GenSet["a", "b"]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(8\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 2. Projective plane of order 2", "Section"],

Cell["Example in page 81 of Butler.", "Text"],

Cell["Generators:", "Text"],

Cell[BoxData[{
    \(\(a = Cycles[{1, 2, 4, 5, 7, 3, 6}];\)\), "\n", 
    \(\(b = Cycles[{2, 4}, {3, 5}];\)\)}], "Input"],

Cell["Strong generating set:", "Text"],

Cell[BoxData[{
    \(\(s1 = a;\)\), "\[IndentingNewLine]", 
    \(\(s2 = b;\)\), "\[IndentingNewLine]", 
    \(\(s3 = Cycles[{4, 5}, {6, 7}];\)\), "\[IndentingNewLine]", 
    \(\(s4 = Cycles[{4, 6}, {5, 7}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(B = {1, 2, 4};\)\), "\n", 
    \(\(S = GenSet[s1, s2, s3, s4];\)\), "\n", 
    \(\(SGS = StrongGenSet[B, S];\)\)}], "Input"],

Cell["Order of group:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(168\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(\(g1 = Perm[{1, 7, 6, 5, 4, 2, 3}];\)\), "\n", 
    \(\(g2 = Perm[{1, 2, 3, 7, 6, 5, 4}];\)\)}], "Input"],

Cell[BoxData[
    \(\($xPermRules = 
        Join[NameRules[s, 4, Cycles], NameRules[g, 2, Cycles]];\)\)], "Input"],

Cell["Chain of stabilizers:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((chain = StabilizerChain[SGS])\) // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(StrongGenSet[{1, 2, 4}, GenSet["s1", "s2", "s3", "s4"]]\)},
          {\(StrongGenSet[{2, 4}, GenSet["s2", "s3", "s4"]]\)},
          {\(StrongGenSet[{4}, GenSet["s3", "s4"]]\)},
          {\(StrongGenSet[{}, GenSet[]]\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        StrongGenSet[ {1, 2, 4}, 
          GenSet[ "s1", "s2", "s3", "s4"]], 
        StrongGenSet[ {2, 4}, 
          GenSet[ "s2", "s3", "s4"]], 
        StrongGenSet[ {4}, 
          GenSet[ "s3", "s4"]], 
        StrongGenSet[ {}, 
          GenSet[ ]]}],
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Let us analyze the structure of those subgroups, starting from below:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup /@ chain\)], "Input"],

Cell[BoxData[
    \({168, 24, 4, 1}\)], "Output"]
}, Open  ]],

Cell["\<\
The subgroup G^(4) is just {ID} and it is generated by the base {} and the GS \
{}:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[StrongGenSet[{}, GenSet[]]]\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell["\<\
Then we have G^(3), which is generated by the base {4} and the GS {s3, s4}:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[StrongGenSet[{4}, GenSet[s3, s4]]]\)], "Input"],

Cell[BoxData[
    \(4\)], "Output"]
}, Open  ]],

Cell["Elements of the group:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimino[GenSet[s3, s4]]\)], "Input"],

Cell[BoxData[
    \(Group[Cycles[], "s3", "s4", "g2"]\)], "Output"]
}, Open  ]],

Cell["There is just one orbit:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierOrbit[4, GenSet[s3, s4], 7]\)], "Input"],

Cell[BoxData[
    \(Schreier[{4, 5, 6, 7}, {0, 0, 0, 0, "s3", "s4", "s4"}, {0, 0, 0, 0, 4, 
        4, 5}]\)], "Output"]
}, Open  ]],

Cell["\<\
Then we have G^(2), which is generated by the base {2,4} and the GS {s2, s3, \
s4}:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[StrongGenSet[{2, 4}, GenSet[s2, s3, s4]]]\)], "Input"],

Cell[BoxData[
    \(24\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimino[GenSet[s2, s3, s4]]\)], "Input"],

Cell[BoxData[
    \(Group[Cycles[], "s2", "s3", Cycles[{2, 5, 3, 4}, {6, 7}], 
      Cycles[{2, 4, 3, 5}, {6, 7}], Cycles[{2, 3}, {6, 7}], 
      Cycles[{2, 5}, {3, 4}], Cycles[{2, 3}, {4, 5}], "s4", 
      Cycles[{2, 6, 4}, {3, 7, 5}], "g2", Cycles[{2, 7, 4}, {3, 6, 5}], 
      Cycles[{2, 6, 5}, {3, 7, 4}], Cycles[{2, 3}, {4, 6, 5, 7}], 
      Cycles[{2, 7, 5}, {3, 6, 4}], Cycles[{2, 3}, {4, 7, 5, 6}], 
      Cycles[{2, 4, 6}, {3, 5, 7}], Cycles[{2, 6}, {3, 7}], 
      Cycles[{2, 4, 7}, {3, 5, 6}], Cycles[{2, 7}, {3, 6}], "g1", 
      Cycles[{2, 5, 7}, {3, 4, 6}], Cycles[{2, 7, 3, 6}, {4, 5}], 
      Cycles[{2, 5, 6}, {3, 4, 7}]]\)], "Output"]
}, Open  ]],

Cell["The previous orbit is larger now:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierOrbit[4, GenSet[s2, s3, s4], 7]\)], "Input"],

Cell[BoxData[
    \(Schreier[{4, 2, 5, 6, 3, 7}, {0, "s2", "s2", 0, "s3", "s4", "s4"}, {0, 
        4, 5, 0, 4, 4, 5}]\)], "Output"]
}, Open  ]],

Cell["\<\
And finally we have G^(1), which is generated by the base {1,2,4} and the GS \
{s1, s2, s3, s4}:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[
      StrongGenSet[{1, 2, 4}, GenSet[s1, s2, s3, s4]]]\)], "Input"],

Cell[BoxData[
    \(168\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimino[GenSet[s1, s2, s3, s4]]\)], "Input"],

Cell[BoxData[
    \(Group[Cycles[], "s1", Cycles[{1, 4, 7, 6, 2, 5, 3}], 
      Cycles[{1, 5, 6, 4, 3, 2, 7}], Cycles[{1, 7, 2, 3, 4, 6, 5}], 
      Cycles[{1, 3, 5, 2, 6, 7, 4}], Cycles[{1, 6, 3, 7, 5, 4, 2}], "s2", 
      Cycles[{1, 4, 3, 6}, {5, 7}], Cycles[{1, 2, 3}, {4, 7, 6}], 
      Cycles[{1, 3, 4, 5, 6, 2, 7}], Cycles[{1, 7, 4, 6, 3, 2, 5}], 
      Cycles[{1, 5, 4}, {2, 6, 7}], Cycles[{1, 6, 5, 2}, {3, 7}], 
      Cycles[{1, 2, 5, 6}, {3, 7}], Cycles[{1, 5, 3}, {2, 4, 6}], 
      Cycles[{1, 4, 3, 2, 6, 5, 7}], Cycles[{1, 6, 4, 7, 2, 3, 5}], 
      Cycles[{1, 3, 4}, {2, 7, 5}], Cycles[{1, 7, 4, 2}, {3, 6}], "s3", 
      Cycles[{1, 4, 5}, {2, 7, 6}], Cycles[{1, 7, 3, 2, 5, 6, 4}], 
      Cycles[{1, 5, 3, 4, 6, 7, 2}], Cycles[{2, 6, 5}, {3, 7, 4}], 
      Cycles[{1, 6}, {2, 3, 5, 4}], Cycles[{1, 3}, {5, 7}], 
      Cycles[{1, 2, 4, 7}, {3, 6}], Cycles[{1, 4, 2, 3, 7, 5, 6}], 
      Cycles[{1, 3}, {4, 6}], Cycles[{1, 2, 6, 3, 4, 5, 7}], 
      Cycles[{1, 6, 2, 5}, {4, 7}], Cycles[{1, 5, 4}, {2, 7, 3}], 
      Cycles[{1, 7, 2}, {3, 6, 5}], Cycles[{2, 4, 3, 5}, {6, 7}], 
      Cycles[{1, 5, 2, 3, 6, 4, 7}], Cycles[{1, 3, 4, 2, 7, 6, 5}], 
      Cycles[{1, 7, 4}, {3, 5, 6}], Cycles[{1, 2}, {4, 6, 7, 5}], 
      Cycles[{2, 6}, {3, 7}], Cycles[{1, 6}, {2, 4, 5, 3}], 
      Cycles[{1, 4, 3}, {2, 5, 7}], Cycles[{1, 2, 7, 6, 4, 3, 5}], 
      Cycles[{1, 7, 5, 6, 2, 3, 4}], Cycles[{1, 3, 2}, {4, 6, 7}], "g1", 
      Cycles[{1, 6}, {2, 5}], Cycles[{1, 5, 7, 3}, {2, 4}], 
      Cycles[{1, 4, 7}, {3, 6, 5}], Cycles[{1, 5}, {2, 6}], 
      Cycles[{1, 6, 5, 7, 3, 2, 4}], Cycles[{1, 4, 7, 2}, {3, 5}], 
      Cycles[{2, 7, 5}, {3, 6, 4}], Cycles[{1, 7, 6}, {2, 3, 4}], 
      Cycles[{1, 3}, {4, 5, 6, 7}], Cycles[{1, 2, 5, 4, 6, 3, 7}], 
      Cycles[{1, 7, 2, 6, 5, 4, 3}], Cycles[{1, 6, 7}, {2, 3, 5}], 
      Cycles[{1, 3, 7, 5}, {2, 4}], Cycles[{1, 4}, {3, 6}], 
      Cycles[{1, 2}, {4, 5, 7, 6}], Cycles[{2, 5, 6}, {3, 4, 7}], 
      Cycles[{1, 5, 3, 2, 7, 4, 6}], Cycles[{1, 3, 6, 2, 5, 4, 7}], 
      Cycles[{1, 5}, {2, 7, 6, 3}], Cycles[{1, 7, 2, 4}, {5, 6}], 
      Cycles[{1, 4, 6, 7, 3, 5, 2}], Cycles[{2, 6, 4}, {3, 7, 5}], 
      Cycles[{1, 6}, {3, 4}], Cycles[{1, 2, 3}, {4, 5, 7}], 
      Cycles[{1, 4, 6, 5, 2, 3, 7}], Cycles[{1, 3, 5}, {2, 6, 4}], 
      Cycles[{1, 6, 3, 4}, {5, 7}], Cycles[{1, 2}, {4, 7}], 
      Cycles[{2, 7, 3, 6}, {4, 5}], Cycles[{1, 7, 6}, {2, 5, 3}], 
      Cycles[{1, 5, 6, 7, 2, 4, 3}], Cycles[{1, 7, 3, 6, 4, 5, 2}], 
      Cycles[{2, 5, 3, 4}, {6, 7}], Cycles[{1, 5, 6}, {3, 7, 4}], 
      Cycles[{1, 2, 3}, {4, 6, 5}], Cycles[{1, 3, 5, 7}, {2, 6}], 
      Cycles[{1, 6, 3, 2, 4, 7, 5}], Cycles[{1, 4}, {2, 7}], 
      Cycles[{1, 7, 4, 5, 2, 6, 3}], Cycles[{1, 6, 7}, {2, 5, 4}], 
      Cycles[{1, 5}, {3, 7}], Cycles[{1, 2, 4}, {3, 6, 5}], 
      Cycles[{1, 4, 3, 5, 7, 6, 2}], Cycles[{2, 3}, {4, 7, 5, 6}], 
      Cycles[{1, 3, 4, 6}, {2, 7}], Cycles[{1, 6, 4, 3}, {2, 7}], 
      Cycles[{1, 7}, {2, 3, 4, 5}], Cycles[{1, 3, 6, 7, 4, 2, 5}], 
      Cycles[{1, 5, 4}, {3, 7, 6}], Cycles[{1, 2}, {5, 6}], 
      Cycles[{2, 4, 6}, {3, 5, 7}], Cycles[{1, 4, 7, 5, 3, 2, 6}], 
      Cycles[{1, 3}, {4, 7, 6, 5}], Cycles[{1, 2, 7}, {3, 5, 6}], 
      Cycles[{1, 7, 5}, {2, 4, 6}], Cycles[{1, 4}, {2, 6, 7, 3}], 
      Cycles[{1, 6, 4, 5, 3, 7, 2}], Cycles[{2, 5}, {3, 4}], 
      Cycles[{1, 5, 7, 4, 2, 3, 6}], Cycles[{1, 7, 5, 4, 3, 6, 2}], 
      Cycles[{2, 3}, {6, 7}], Cycles[{1, 3, 7, 2, 4, 5, 6}], 
      Cycles[{1, 4, 6, 3}, {2, 5}], Cycles[{1, 5, 7}, {2, 6, 4}], 
      Cycles[{1, 6, 5}, {3, 4, 7}], Cycles[{1, 2, 7, 4}, {3, 5}], 
      Cycles[{1, 3, 2}, {4, 7, 5}], Cycles[{2, 7}, {3, 6}], 
      Cycles[{1, 7, 6}, {2, 4, 5}], Cycles[{1, 4, 2, 5, 6, 7, 3}], 
      Cycles[{1, 5, 3, 7}, {4, 6}], Cycles[{1, 2, 6, 5}, {3, 4}], 
      Cycles[{1, 6, 2, 3, 5, 7, 4}], Cycles[{2, 3}, {4, 6, 5, 7}], 
      Cycles[{1, 3, 5, 4, 7, 2, 6}], Cycles[{1, 6, 3}, {2, 7, 5}], 
      Cycles[{1, 7}, {2, 4}], Cycles[{1, 4, 5}, {3, 6, 7}], 
      Cycles[{1, 2, 5, 3, 7, 6, 4}], Cycles[{1, 5, 6, 2}, {3, 4}], 
      Cycles[{1, 6, 2, 7, 4, 5, 3}], Cycles[{1, 7}, {2, 5, 4, 3}], 
      Cycles[{1, 5}, {2, 3, 6, 7}], Cycles[{1, 3, 7, 6, 5, 2, 4}], 
      Cycles[{1, 4, 2}, {3, 5, 6}], "s4", Cycles[{1, 2, 6}, {3, 4, 7}], 
      Cycles[{1, 6, 7}, {2, 4, 3}], Cycles[{1, 4, 5}, {2, 3, 7}], 
      Cycles[{1, 3, 6, 4}, {2, 5}], Cycles[{1, 5, 7, 6, 3, 4, 2}], "g2", 
      Cycles[{1, 2, 7, 3, 5, 4, 6}], Cycles[{1, 7, 5, 3}, {2, 6}], 
      Cycles[{1, 5, 2, 4, 7, 6, 3}], Cycles[{1, 4, 2, 7}, {5, 6}], 
      Cycles[{1, 7, 3, 5}, {4, 6}], Cycles[{1, 2, 6, 7, 5, 3, 4}], 
      Cycles[{1, 6, 2}, {3, 7, 4}], Cycles[{2, 3}, {4, 5}], 
      Cycles[{1, 3, 6}, {2, 5, 7}], Cycles[{1, 5, 2}, {3, 4, 7}], 
      Cycles[{2, 7, 4}, {3, 6, 5}], Cycles[{1, 7, 6}, {3, 5, 4}], 
      Cycles[{1, 2, 3}, {5, 6, 7}], Cycles[{1, 3, 7}, {2, 4, 6}], 
      Cycles[{1, 4, 5}, {2, 6, 3}], Cycles[{1, 6, 4}, {2, 5, 7}], 
      Cycles[{2, 5, 7}, {3, 4, 6}], Cycles[{1, 5, 2, 6}, {4, 7}], 
      Cycles[{1, 6, 5, 4, 2, 7, 3}], Cycles[{1, 7}, {3, 5}], 
      Cycles[{1, 2, 4, 3, 6, 7, 5}], Cycles[{1, 4}, {2, 3, 7, 6}], 
      Cycles[{1, 3, 2}, {4, 5, 6}], Cycles[{1, 6, 7}, {3, 4, 5}], 
      Cycles[{1, 2, 5}, {3, 7, 4}], Cycles[{1, 5, 4}, {2, 3, 6}], 
      Cycles[{1, 3, 2}, {5, 7, 6}], Cycles[{2, 4, 7}, {3, 5, 6}], 
      Cycles[{1, 4, 6}, {2, 7, 5}], Cycles[{1, 7, 3}, {2, 6, 4}]]\)], "Output"]
}, Open  ]],

Cell["The orbit is even larger now. This group is regular.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierOrbit[4, GenSet[s1, s2, s3, s4], 7]\)], "Input"],

Cell[BoxData[
    \(Schreier[{4, 5, 2, 6, 7, 3, 1}, {"s1", "s2", "s2", 0, "s1", "s4", 
        "s1"}, {6, 4, 5, 0, 4, 4, 5}]\)], "Output"]
}, Open  ]],

Cell["\<\
Schreier vectors. Note that there are two wrong permutations in the first \
vector in Butler.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([1]\)], chain[\([1]\)], 7]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "7"},
          {"\<\"Init\"\>", "\<\"s1\"\>", "\<\"s2\"\>", "\<\"s1\"\>", \
"\<\"s1\"\>", "\<\"s4\"\>", "\<\"s1\"\>"},
          {"0", "1", "5", "2", "4", "4", "5"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([2]\)], chain[\([2]\)], 7]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"2", "3", "4", "5", "6", "7"},
          {"\<\"Init\"\>", "\<\"s2\"\>", "\<\"s2\"\>", "\<\"s3\"\>", \
"\<\"s4\"\>", "\<\"s4\"\>"},
          {"0", "5", "2", "4", "4", "5"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([3]\)], chain[\([3]\)], 7]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"4", "5", "6", "7"},
          {"\<\"Init\"\>", "\<\"s3\"\>", "\<\"s4\"\>", "\<\"s4\"\>"},
          {"0", "4", "4", "5"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["These are examples of membership on page 90 of Butler:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[{1, 2, 3, 4, 5, 6, 7}], SGS]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[{1, 4, 2, 3, 7, 5, 6}], SGS]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermWord[Cycles[{1, 4, 2, 3, 7, 5, 6}], SGS]\)], "Input"],

Cell[BoxData[
    \({Cycles[], "g2", Cycles[{2, 5, 3, 4}, {6, 7}], 
      Cycles[{1, 4, 7, 6, 2, 5, 3}]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Permute[s3, s4]\)], "Input"],

Cell[BoxData[
    \("g2"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[%, chain[\([3]\)]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Permute[s2, s3]\)], "Input"],

Cell[BoxData[
    \(Cycles[{2, 5, 3, 4}, {6, 7}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[%, chain[\([2]\)]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Permute[s1, s1]\)], "Input"],

Cell[BoxData[
    \(Cycles[{1, 4, 7, 6, 2, 5, 3}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[%, chain[\([1]\)]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["We know check the SGS:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[B, S, 7, xPermVerbose \[Rule] True, 
      UseRules \[Rule] $xPermRules]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "s3", 
          "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3", "s4"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4"], ", i=", 3, ", T=", 
        GenSet[ "s3", "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "s3", 
          "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2", "s3", "s4"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4"], ", i=", 2, ", T=", 
        GenSet[ "s2", "s3", "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "s3", 
          "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2", "s3", "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]54\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]168\),
      SequenceForm[ 
      "Checked ", 54, " generators and obtained group of order ", 168],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1, 2, 4}, GenSet["s1", "s2", "s3", "s4"]]\)], "Output"]
}, Open  ]],

Cell["And generate new SGS:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[{1}, GenSet[a, b], 7, xPermVerbose \[Rule] True, 
      UseRules \[Rule] $xPermRules]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2"]\[InvisibleSpace]", i="\[InvisibleSpace]2\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s2"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "s2"], ", i=", 2, ", T=", 
        GenSet[ "s2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2"]\[InvisibleSpace]", i="\[InvisibleSpace]1\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s1", "s2"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "s2"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]"g1"\),
      SequenceForm[ "Appended S[[", 3, "]]=", "g1"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", 
          "g1"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g1"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "s2", "g1"], ", i=", 2, ", T=", 
        GenSet[ "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]"s4"\),
      SequenceForm[ "Appended S[[", 4, "]]=", "s4"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]4\),
      SequenceForm[ "Appended B[[", 3, "]]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "g1", 
          "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s4"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", "g1", "s4"], ", i=", 3, ", T=", 
        GenSet[ "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s4"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {4}, " and SGS ", 
        GenSet[ "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]"g2"\),
      SequenceForm[ "Appended S[[", 5, "]]=", "g2"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "g1", "s4", 
          "g2"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g2"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", "g1", "s4", "g2"], ", i=", 3, ", T=", 
        GenSet[ "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s4", "g2"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {4}, " and SGS ", 
        GenSet[ "s4", "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s2", "g1", 
          "s4", "g2"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 4}, " and SGS ", 
        GenSet[ "s2", "g1", "s4", "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]34\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]168\),
      SequenceForm[ 
      "Checked ", 34, " generators and obtained group of order ", 168],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1, 2, 4}, 
      GenSet["s1", "s2", "g1", "s4", "g2"]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(newSGS = 
      SchreierSims[{1, 2, 3, 4, 5, 6, 7}, GenSet[a, b], 7, 
        xPermVerbose \[Rule] True]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], 
          Cycles[{2, 4}, {3, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]7\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}]], ", i=", 7, ", T=", 
        GenSet[ ]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], 
          Cycles[{2, 4}, {3, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]6\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}]], ", i=", 6, ", T=", 
        GenSet[ ]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], 
          Cycles[{2, 4}, {3, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]5\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}]], ", i=", 5, ", T=", 
        GenSet[ ]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], 
          Cycles[{2, 4}, {3, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}]], ", i=", 4, ", T=", 
        GenSet[ ]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], 
          Cycles[{2, 4}, {3, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]3\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}]], ", i=", 3, ", T=", 
        GenSet[ ]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], 
          Cycles[{2, 4}, {3, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{2, 4}, {3, 5}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {2, 4}, {3, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], 
          Cycles[{2, 4}, {3, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]1\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], Cycles[{2, 4}, {3, 5}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}]], ", i=", 1, ", T=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{2, 6, 3, 
            7}, {4, 5}]\),
      SequenceForm[ "Appended S[[", 3, "]]=", 
        Cycles[ {2, 6, 3, 7}, {4, 5}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], Cycles[{2, 4}, {3, 5}], 
          Cycles[{2, 6, 3, 7}, {4, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{2, 6, 3, 7}, {4, 5}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}], 
          Cycles[ {2, 6, 3, 7}, {4, 5}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {2, 6, 3, 7}, {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 
            6}, {5, 7}]\),
      SequenceForm[ "Appended S[[", 4, "]]=", 
        Cycles[ {4, 6}, {5, 7}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], Cycles[{2, 4}, {3, 5}], 
          Cycles[{2, 6, 3, 7}, {4, 5}], 
          Cycles[{4, 6}, {5, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 6}, {5, 7}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}], 
          Cycles[ {2, 6, 3, 7}, {4, 5}], 
          Cycles[ {4, 6}, {5, 7}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {4, 6}, {5, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], Cycles[{2, 4}, {3, 5}], 
          Cycles[{2, 6, 3, 7}, {4, 5}], 
          Cycles[{4, 6}, {5, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]3\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 6}, {5, 7}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}], 
          Cycles[ {2, 6, 3, 7}, {4, 5}], 
          Cycles[ {4, 6}, {5, 7}]], ", i=", 3, ", T=", 
        GenSet[ 
          Cycles[ {4, 6}, {5, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 4, 5, 6, 
          7}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{4, 6}, {5, 7}]]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 4, 5, 6, 7}, " and SGS ",
         
        GenSet[ 
          Cycles[ {4, 6}, {5, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 
            7}, {5, 6}]\),
      SequenceForm[ "Appended S[[", 5, "]]=", 
        Cycles[ {4, 7}, {5, 6}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], Cycles[{2, 4}, {3, 5}], 
          Cycles[{2, 6, 3, 7}, {4, 5}], Cycles[{4, 6}, {5, 7}], 
          Cycles[{4, 7}, {5, 
              6}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 7}, {5, 6}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}], 
          Cycles[ {2, 6, 3, 7}, {4, 5}], 
          Cycles[ {4, 6}, {5, 7}], 
          Cycles[ {4, 7}, {5, 6}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {4, 7}, {5, 6}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 4, 5, 7, 3, 6}], Cycles[{2, 4}, {3, 5}], 
          Cycles[{2, 6, 3, 7}, {4, 5}], Cycles[{4, 6}, {5, 7}], 
          Cycles[{4, 7}, {5, 
              6}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]3\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 7}, {5, 6}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6, 7}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 4, 5, 7, 3, 6}], 
          Cycles[ {2, 4}, {3, 5}], 
          Cycles[ {2, 6, 3, 7}, {4, 5}], 
          Cycles[ {4, 6}, {5, 7}], 
          Cycles[ {4, 7}, {5, 6}]], ", i=", 3, ", T=", 
        GenSet[ 
          Cycles[ {4, 7}, {5, 6}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 4, 5, 6, 
          7}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{4, 6}, {5, 7}], Cycles[{4, 7}, {5, 6}]]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 4, 5, 6, 7}, " and SGS ",
         
        GenSet[ 
          Cycles[ {4, 6}, {5, 7}], 
          Cycles[ {4, 7}, {5, 6}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 3, 4, 5, 6, 
          7}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{2, 4}, {3, 5}], Cycles[{2, 6, 3, 7}, {4, 5}], 
          Cycles[{4, 6}, {5, 7}], Cycles[{4, 7}, {5, 6}]]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 3, 4, 5, 6, 7}, 
        " and SGS ", 
        GenSet[ 
          Cycles[ {2, 4}, {3, 5}], 
          Cycles[ {2, 6, 3, 7}, {4, 5}], 
          Cycles[ {4, 6}, {5, 7}], 
          Cycles[ {4, 7}, {5, 6}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]36\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]168\),
      SequenceForm[ 
      "Checked ", 36, " generators and obtained group of order ", 168],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1, 2, 3, 4, 5, 6, 7}, 
      GenSet["s1", "s2", "g1", "s4", "g2"]]\)], "Output"]
}, Open  ]],

Cell["With the SGS we can test membership:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[], SGS]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[TranslatePerm[Perm[{6, 4, 2, 1, 7, 5, 3}], Cycles], 
      SGS]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[TranslatePerm[Perm[{7, 1, 2, 3, 4, 5, 6}], Cycles], 
      SGS]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell["Or with the new SGS:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[], newSGS]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[TranslatePerm[Perm[{6, 4, 2, 1, 7, 5, 3}], Cycles], 
      newSGS]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[TranslatePerm[Perm[{7, 1, 2, 3, 4, 5, 6}], Cycles], 
      newSGS]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 3. Mathieu", "Section"],

Cell["Example in page 82 of Butler.", "Text"],

Cell[BoxData[
    \(\(s1 = Cycles[{1, 2, 3}, {4, 5, 6}, {7, 8, 9}];\)\)], "Input"],

Cell[BoxData[
    \(\(s2 = Cycles[{2, 4, 3, 7}, {5, 6, 9, 8}];\)\)], "Input"],

Cell[BoxData[
    \(\(s3 = Cycles[{2, 5, 3, 9}, {4, 8, 7, 6}];\)\)], "Input"],

Cell[BoxData[
    \(\(s4 = Cycles[{1, 10}, {4, 5}, {6, 8}, {7, 9}];\)\)], "Input"],

Cell[BoxData[
    \(\(s5 = Cycles[{1, 11}, {4, 6}, {5, 9}, {7, 8}];\)\)], "Input"],

Cell[BoxData[{
    \(\(g1 = 
        TranslatePerm[Perm[{1, 2, 10, 6, 7, 4, 5, 9, 8, 3, 11}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g2 = 
        TranslatePerm[Perm[{1, 2, 4, 10, 9, 3, 8, 5, 7, 6, 11}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g3 = 
        TranslatePerm[Perm[{1, 2, 5, 8, 10, 9, 3, 6, 4, 7, 11}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g4 = 
        TranslatePerm[Perm[{1, 2, 11, 8, 6, 5, 9, 4, 7, 10, 3}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g5 = 
        TranslatePerm[Perm[{1, 2, 3, 7, 8, 9, 4, 5, 6, 11, 10}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g6 = 
        TranslatePerm[Perm[{1, 2, 3, 10, 6, 8, 11, 9, 5, 7, 4}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g7 = 
        TranslatePerm[Perm[{1, 2, 3, 9, 10, 4, 6, 11, 7, 8, 5}], 
          Cycles];\)\)}], "Input"],

Cell[BoxData[
    \(\($xPermRules = 
        Join[{Cycles[] \[Rule] "\<ID\>"}, NameRules[s, 5, Cycles], 
          NameRules[g, 7, Cycles]];\)\)], "Input"],

Cell[BoxData[{
    \(\(S = GenSet[s1, s2, s3, s4, s5];\)\), "\n", 
    \(\(B = {11, 10, 1, 2};\)\), "\[IndentingNewLine]", 
    \(\(SGS = StrongGenSet[B, S];\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(7920\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[%]\)], "Input"],

Cell[BoxData[
    \({{2, 4}, {3, 2}, {5, 1}, {11, 1}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((chain = StabilizerChain[SGS])\) // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(StrongGenSet[{11, 10, 1, 2}, 
              GenSet["s1", "s2", "s3", "s4", "s5"]]\)},
          {\(StrongGenSet[{10, 1, 2}, GenSet["s1", "s2", "s3", "s4"]]\)},
          {\(StrongGenSet[{1, 2}, GenSet["s1", "s2", "s3"]]\)},
          {\(StrongGenSet[{2}, GenSet["s2", "s3"]]\)},
          {\(StrongGenSet[{}, GenSet[]]\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        StrongGenSet[ {11, 10, 1, 2}, 
          GenSet[ "s1", "s2", "s3", "s4", "s5"]], 
        StrongGenSet[ {10, 1, 2}, 
          GenSet[ "s1", "s2", "s3", "s4"]], 
        StrongGenSet[ {1, 2}, 
          GenSet[ "s1", "s2", "s3"]], 
        StrongGenSet[ {2}, 
          GenSet[ "s2", "s3"]], 
        StrongGenSet[ {}, 
          GenSet[ ]]}],
      Editable->False]], "Output"]
}, Open  ]],

Cell["There is a wrong permutation in the first vector of Butler:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([1]\)], chain[\([1]\)], 11]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"},
          {"\<\"s5\"\>", "\<\"s1\"\>", "\<\"s1\"\>", "\<\"s2\"\>", \
"\<\"s3\"\>", "\<\"s5\"\>", "\<\"s2\"\>", "\<\"s3\"\>", "\<\"s3\"\>", "\<\"s4\
\"\>", "\<\"Init\"\>"},
          {"11", "1", "2", "2", "2", "4", "3", "4", "3", "1", "0"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([2]\)], chain[\([2]\)], 11]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"},
          {"\<\"s4\"\>", "\<\"s1\"\>", "\<\"s1\"\>", "\<\"s2\"\>", \
"\<\"s3\"\>", "\<\"s1\"\>", "\<\"s2\"\>", "\<\"s3\"\>", "\<\"s3\"\>", \
"\<\"Init\"\>"},
          {"10", "1", "2", "2", "2", "5", "3", "4", "3", "0"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([3]\)], chain[\([3]\)], 11]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "7", "8", "9"},
          {"\<\"Init\"\>", "\<\"s1\"\>", "\<\"s1\"\>", "\<\"s2\"\>", \
"\<\"s3\"\>", "\<\"s1\"\>", "\<\"s2\"\>", "\<\"s3\"\>", "\<\"s3\"\>"},
          {"0", "1", "2", "2", "2", "5", "3", "4", "3"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([4]\)], chain[\([4]\)], 11]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"2", "3", "4", "5", "6", "7", "8", "9"},
          {"\<\"Init\"\>", "\<\"s2\"\>", "\<\"s2\"\>", "\<\"s3\"\>", \
"\<\"s2\"\>", "\<\"s2\"\>", "\<\"s3\"\>", "\<\"s3\"\>"},
          {"0", "4", "2", "2", "5", "3", "4", "3"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["We can check that  {S, B} is actually a SGS:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[B, S, 11, xPermVerbose \[Rule] True, 
      UseRules \[Rule] $xPermRules]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{11, 10, 1, 
          2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]4\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s2", "s3"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {11, 10, 1, 2}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"], ", i=", 4, ", T=", 
        GenSet[ "s2", "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{11, 10, 1, 
          2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]3\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s1", "s2", "s3"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {11, 10, 1, 2}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"], ", i=", 3, ", T=", 
        GenSet[ "s1", "s2", "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{11, 10, 1, 
          2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]2\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {11, 10, 1, 2}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"], ", i=", 2, ", T=", 
        GenSet[ "s1", "s2", "s3", "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{11, 10, 1, 
          2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]1\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4", 
          "s5"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {11, 10, 1, 2}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]138\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]7920\),
      SequenceForm[ 
      "Checked ", 138, " generators and obtained group of order ", 7920],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{11, 10, 1, 2}, 
      GenSet["s1", "s2", "s3", "s4", "s5"]]\)], "Output"]
}, Open  ]],

Cell["Or we can give a different SGS:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({junk, newSGS} = Timing[SchreierSims[{}, S, 11]]\)], "Input"],

Cell[BoxData[
    \({0.420026`\ Second, 
      StrongGenSet[{4, 1, 2, 3}, 
        GenSet["s1", "s2", "s3", "s4", "s5", 
          Cycles[{1, 10, 3, 2}, {5, 6, 7, 8}], 
          Cycles[{1, 3, 2, 11}, {5, 6, 9, 7}], 
          Cycles[{2, 11, 3, 10}, {5, 8, 6, 9}], 
          Cycles[{1, 6, 3, 11}, {2, 8, 7, 9}], 
          Cycles[{2, 5, 10, 11}, {3, 7, 6, 9}], 
          Cycles[{3, 11, 7, 6}, {5, 8, 9, 10}], 
          Cycles[{3, 9, 7, 5}, {6, 10, 11, 8}]]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeleteRedundantGenerators[newSGS]\)], "Input"],

Cell[BoxData[
    \(StrongGenSet[{4, 1, 2, 3}, 
      GenSet[Cycles[{3, 9, 7, 5}, {6, 10, 11, 8}], 
        Cycles[{3, 11, 7, 6}, {5, 8, 9, 10}], 
        Cycles[{2, 5, 10, 11}, {3, 7, 6, 9}], 
        Cycles[{1, 3, 2, 11}, {5, 6, 9, 7}], "s2"]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({junk, newSGS} = 
      Timing[SchreierSims[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, S, 
          11]]\)], "Input"],

Cell[BoxData[
    \({0.5560349999999996`\ Second, 
      StrongGenSet[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, 
        GenSet["s1", "s2", "s3", "s4", "s5", "g1", 
          Cycles[{3, 4, 10, 6}, {5, 9, 7, 8}], 
          Cycles[{3, 5, 10, 7}, {4, 8, 6, 9}], "g4", "g5", 
          Cycles[{4, 8, 7, 5}, {6, 11, 9, 10}], 
          Cycles[{4, 10, 7, 11}, {5, 6, 8, 9}]]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(newSGS = DeleteRedundantGenerators[newSGS]\)], "Input"],

Cell[BoxData[
    \(StrongGenSet[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, 
      GenSet[Cycles[{4, 8, 7, 5}, {6, 11, 9, 10}], 
        Cycles[{4, 10, 7, 11}, {5, 6, 8, 9}], 
        Cycles[{3, 4, 10, 6}, {5, 9, 7, 8}], "s2", "s1"]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[newSGS]\)], "Input"],

Cell[BoxData[
    \(7920\)], "Output"]
}, Open  ]],

Cell["There are also many redundant points:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StabilizerChain[newSGS] // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(StrongGenSet[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, 
              GenSet[Cycles[{4, 8, 7, 5}, {6, 11, 9, 10}], 
                Cycles[{4, 10, 7, 11}, {5, 6, 8, 9}], 
                Cycles[{3, 4, 10, 6}, {5, 9, 7, 8}], "s2", "s1"]]\)},
          {\(StrongGenSet[{2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, 
              GenSet[Cycles[{4, 8, 7, 5}, {6, 11, 9, 10}], 
                Cycles[{4, 10, 7, 11}, {5, 6, 8, 9}], 
                Cycles[{3, 4, 10, 6}, {5, 9, 7, 8}], "s2"]]\)},
          {\(StrongGenSet[{3, 4, 5, 6, 7, 8, 9, 10, 11}, 
              GenSet[Cycles[{4, 8, 7, 5}, {6, 11, 9, 10}], 
                Cycles[{4, 10, 7, 11}, {5, 6, 8, 9}], 
                Cycles[{3, 4, 10, 6}, {5, 9, 7, 8}]]]\)},
          {\(StrongGenSet[{4, 5, 6, 7, 8, 9, 10, 11}, 
              GenSet[Cycles[{4, 8, 7, 5}, {6, 11, 9, 10}], 
                Cycles[{4, 10, 7, 11}, {5, 6, 8, 9}]]]\)},
          {\(StrongGenSet[{5, 6, 7, 8, 9, 10, 11}, GenSet[]]\)},
          {\(StrongGenSet[{6, 7, 8, 9, 10, 11}, GenSet[]]\)},
          {\(StrongGenSet[{7, 8, 9, 10, 11}, GenSet[]]\)},
          {\(StrongGenSet[{8, 9, 10, 11}, GenSet[]]\)},
          {\(StrongGenSet[{9, 10, 11}, GenSet[]]\)},
          {\(StrongGenSet[{10, 11}, GenSet[]]\)},
          {\(StrongGenSet[{11}, GenSet[]]\)},
          {\(StrongGenSet[{}, GenSet[]]\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        StrongGenSet[ {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, 
          GenSet[ 
            Cycles[ {4, 8, 7, 5}, {6, 11, 9, 10}], 
            Cycles[ {4, 10, 7, 11}, {5, 6, 8, 9}], 
            Cycles[ {3, 4, 10, 6}, {5, 9, 7, 8}], "s2", "s1"]], 
        StrongGenSet[ {2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, 
          GenSet[ 
            Cycles[ {4, 8, 7, 5}, {6, 11, 9, 10}], 
            Cycles[ {4, 10, 7, 11}, {5, 6, 8, 9}], 
            Cycles[ {3, 4, 10, 6}, {5, 9, 7, 8}], "s2"]], 
        StrongGenSet[ {3, 4, 5, 6, 7, 8, 9, 10, 11}, 
          GenSet[ 
            Cycles[ {4, 8, 7, 5}, {6, 11, 9, 10}], 
            Cycles[ {4, 10, 7, 11}, {5, 6, 8, 9}], 
            Cycles[ {3, 4, 10, 6}, {5, 9, 7, 8}]]], 
        StrongGenSet[ {4, 5, 6, 7, 8, 9, 10, 11}, 
          GenSet[ 
            Cycles[ {4, 8, 7, 5}, {6, 11, 9, 10}], 
            Cycles[ {4, 10, 7, 11}, {5, 6, 8, 9}]]], 
        StrongGenSet[ {5, 6, 7, 8, 9, 10, 11}, 
          GenSet[ ]], 
        StrongGenSet[ {6, 7, 8, 9, 10, 11}, 
          GenSet[ ]], 
        StrongGenSet[ {7, 8, 9, 10, 11}, 
          GenSet[ ]], 
        StrongGenSet[ {8, 9, 10, 11}, 
          GenSet[ ]], 
        StrongGenSet[ {9, 10, 11}, 
          GenSet[ ]], 
        StrongGenSet[ {10, 11}, 
          GenSet[ ]], 
        StrongGenSet[ {11}, 
          GenSet[ ]], 
        StrongGenSet[ {}, 
          GenSet[ ]]}],
      Editable->False]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 4", "Section"],

Cell["Example in page 82 of Butler.", "Text"],

Cell[BoxData[
    \(\(a = 
        Cycles[{1, 8, 9}, {2, 11, 15}, {3, 10, 12}, {4, 14, 19}, {5, 16, 
            17}, {6, 21, 20}, {7, 13, 18}];\)\)], "Input"],

Cell[BoxData[
    \(\(b = Cycles[{9, 18, 20}, {12, 19, 17}];\)\)], "Input"],

Cell[BoxData[
    \(\(c = Cycles[{10, 21, 11}, {13, 16, 14}];\)\)], "Input"],

Cell[BoxData[{
    \(\(s1 = a;\)\), "\[IndentingNewLine]", 
    \(\(s2 = b;\)\), "\[IndentingNewLine]", 
    \(\(s3 = c;\)\), "\[IndentingNewLine]", 
    \(\(s4 = Cycles[{8, 13, 21}, {10, 14, 16}];\)\), "\[IndentingNewLine]", 
    \(\(s5 = Cycles[{2, 6, 3}, {4, 5, 7}];\)\), "\[IndentingNewLine]", 
    \(\(s6 = Cycles[{12, 20, 15}, {17, 19, 18}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(g1 = Cycles[{8, 16, 11}, {13, 14, 21}];\)\), "\[IndentingNewLine]", 
    \(\(g2 = Cycles[{2, 3, 6}, {4, 7, 5}];\)\), "\[IndentingNewLine]", 
    \(\(g3 = Cycles[{1, 7, 6}, {3, 4, 5}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(B = {1, 9, 8, 10, 2, 12};\)\), "\n", 
    \(\(S = GenSet[s1, s2, s3, s4, s5, s6];\)\), "\[IndentingNewLine]", 
    \(\(SGS = StrongGenSet[B, S];\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermDeg[S]\)], "Input"],

Cell[BoxData[
    \(21\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\($xPermRules = 
        Join[{Cycles[] \[Rule] "\<ID\>"}, 
          NameRules[s, 6, Cycles], {g1 \[Rule] "\<g1\>", g2 \[Rule] "\<g2\>", 
            g3 -> "\<g3\>"}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(27783\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[%]\)], "Input"],

Cell[BoxData[
    \({{3, 4}, {7, 3}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((chain = StabilizerChain[SGS])\) // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(StrongGenSet[{1, 9, 8, 10, 2, 12}, 
              GenSet["s1", "s2", "s3", "s4", "s5", "s6"]]\)},
          {\(StrongGenSet[{9, 8, 10, 2, 12}, 
              GenSet["s2", "s3", "s4", "s5", "s6"]]\)},
          {\(StrongGenSet[{8, 10, 2, 12}, GenSet["s3", "s4", "s5", "s6"]]\)},
          {\(StrongGenSet[{10, 2, 12}, GenSet["s3", "s5", "s6"]]\)},
          {\(StrongGenSet[{2, 12}, GenSet["s5", "s6"]]\)},
          {\(StrongGenSet[{12}, GenSet["s6"]]\)},
          {\(StrongGenSet[{}, GenSet[]]\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        StrongGenSet[ {1, 9, 8, 10, 2, 12}, 
          GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"]], 
        StrongGenSet[ {9, 8, 10, 2, 12}, 
          GenSet[ "s2", "s3", "s4", "s5", "s6"]], 
        StrongGenSet[ {8, 10, 2, 12}, 
          GenSet[ "s3", "s4", "s5", "s6"]], 
        StrongGenSet[ {10, 2, 12}, 
          GenSet[ "s3", "s5", "s6"]], 
        StrongGenSet[ {2, 12}, 
          GenSet[ "s5", "s6"]], 
        StrongGenSet[ {12}, 
          GenSet[ "s6"]], 
        StrongGenSet[ {}, 
          GenSet[ ]]}],
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
There are only two discrepancies with respect to Butler's result, again in \
the first vector:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([1]\)], chain[\([1]\)], 21]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", 
            "13", "14", "15", "16", "17", "18", "19", "20", "21"},
          {"\<\"Init\"\>", "\<\"s1\"\>", "\<\"s5\"\>", "\<\"s5\"\>", \
"\<\"s1\"\>", "\<\"s1\"\>", "\<\"s1\"\>", "\<\"s1\"\>", "\<\"s1\"\>", "\<\"s4\
\"\>", "\<\"s3\"\>", "\<\"s2\"\>", "\<\"s4\"\>", "\<\"s3\"\>", "\<\"s6\"\>", \
"\<\"s3\"\>", "\<\"s6\"\>", "\<\"s2\"\>", "\<\"s6\"\>", "\<\"s2\"\>", "\<\"s4\
\"\>"},
          {"0", "15", "6", "7", "17", "20", "18", "1", "8", "16", "21", "17", 
            "8", "16", "20", "13", "18", "9", "17", "18", "13"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([2]\)], chain[\([2]\)], 21]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"9", "12", "15", "17", "18", "19", "20"},
          {"\<\"Init\"\>", "\<\"s2\"\>", "\<\"s6\"\>", "\<\"s6\"\>", \
"\<\"s2\"\>", "\<\"s6\"\>", "\<\"s2\"\>"},
          {"0", "17", "20", "18", "9", "17", "18"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([3]\)], chain[\([3]\)], 21]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"8", "10", "11", "13", "14", "16", "21"},
          {"\<\"Init\"\>", "\<\"s4\"\>", "\<\"s3\"\>", "\<\"s4\"\>", \
"\<\"s3\"\>", "\<\"s3\"\>", "\<\"s4\"\>"},
          {"0", "16", "21", "8", "16", "13", "13"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([4]\)], chain[\([4]\)], 21]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"10", "11", "21"},
          {"\<\"Init\"\>", "\<\"s3\"\>", "\<\"s3\"\>"},
          {"0", "21", "10"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([5]\)], chain[\([5]\)], 21]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"2", "3", "6"},
          {"\<\"Init\"\>", "\<\"s5\"\>", "\<\"s5\"\>"},
          {"0", "6", "2"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([6]\)], chain[\([6]\)], 21]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"12", "15", "20"},
          {"\<\"Init\"\>", "\<\"s6\"\>", "\<\"s6\"\>"},
          {"0", "20", "12"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["Check SGS.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[B, S, 21, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 9, 8, 10, 2, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]6\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 9, 8, 10, 2, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 6, ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 9, 8, 10, 2, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 9, 8, 10, 2, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 5, ", T=", 
        GenSet[ "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 9, 8, 10, 2, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 9, 8, 10, 2, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 4, ", T=", 
        GenSet[ "s3", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 9, 8, 10, 2, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 9, 8, 10, 2, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 3, ", T=", 
        GenSet[ "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 9, 8, 10, 2, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2", "s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 9, 8, 10, 2, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 2, ", T=", 
        GenSet[ "s2", "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 9, 8, 10, 2, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 9, 8, 10, 2, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]207\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]27783\),
      SequenceForm[ 
      "Checked ", 207, " generators and obtained group of order ", 27783],
      Editable->False]], "Print"],

Cell[BoxData[
    \({1.0640669999999997`\ Second, 
      StrongGenSet[{1, 9, 8, 10, 2, 12}, 
        GenSet["s1", "s2", "s3", "s4", "s5", "s6"]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[{}, GenSet[a, b, c], 21, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", 
          "s3"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {9, 10}, ", S=", 
        GenSet[ "s1", "s2", "s3"], ", i=", 2, ", T=", 
        GenSet[ "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", 
          "s3"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "s2", "s3"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {9, 10}, ", S=", 
        GenSet[ "s1", "s2", "s3"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2", "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]"s4"\),
      SequenceForm[ "Appended S[[", 4, "]]=", "s4"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "s3", 
          "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s4"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {9, 10}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4"], ", i=", 2, ", T=", 
        GenSet[ "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]"g1"\),
      SequenceForm[ "Appended S[[", 5, "]]=", "g1"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]8\),
      SequenceForm[ "Appended B[[", 3, "]]=", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "s3", "s4", 
          "g1"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g1"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {9, 10, 8}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1"], ", i=", 3, ", T=", 
        GenSet[ "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{8}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["g1"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {8}, " and SGS ", 
        GenSet[ "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{10, 
          8}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s3", "s4", 
          "g1"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {10, 8}, " and SGS ", 
        GenSet[ "s3", "s4", "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]"g2"\),
      SequenceForm[ "Appended S[[", 6, "]]=", "g2"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]2\),
      SequenceForm[ "Appended B[[", 4, "]]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 
          2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", 
          "g2"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g2"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2"], ", i=", 4, ", T=", 
        GenSet[ "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 
          2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", 
          "g2"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g2"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2"], ", i=", 3, ", T=", 
        GenSet[ "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 
          2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", 
          "g2"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g2"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2"], ", i=", 2, ", T=", 
        GenSet[ "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{10, 8, 
          2}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s3", "s4", 
          "g1", "g2"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {10, 8, 2}, " and SGS ", 
        GenSet[ "s3", "s4", "g1", "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]7\[InvisibleSpace]"]]="\[InvisibleSpace]"g3"\),
      SequenceForm[ "Appended S[[", 7, "]]=", "g3"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]1\),
      SequenceForm[ "Appended B[[", 5, "]]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 2, 
          1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", "g2", 
          "g3"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g3"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2", "g3"], ", i=", 5, ", T=", 
        
        GenSet[ "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 2, 
          1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", "g2", 
          "g3"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g3"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2", "g3"], ", i=", 4, ", T=", 
        
        GenSet[ "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 2, 
          1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", "g2", 
          "g3"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g3"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2", "g3"], ", i=", 3, ", T=", 
        
        GenSet[ "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 2, 
          1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", "g2", 
          "g3"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g3"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2", "g3"], ", i=", 2, ", T=", 
        
        GenSet[ "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{10, 8, 2, 
          1}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s3", "s4", 
          "g1", "g2", "g3"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {10, 8, 2, 1}, " and SGS ", 
        GenSet[ "s3", "s4", "g1", "g2", "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]8\[InvisibleSpace]"]]="\[InvisibleSpace]"s6"\),
      SequenceForm[ "Appended S[[", 8, "]]=", "s6"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]12\),
      SequenceForm[ "Appended B[[", 6, "]]=", 12],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 2, 1, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", "g2", "g3", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]6\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2", "g3", "s6"], ", i=", 6, 
        ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 2, 1, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", "g2", "g3", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2", "g3", "s6"], ", i=", 5, 
        ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 2, 1, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", "g2", "g3", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2", "g3", "s6"], ", i=", 4, 
        ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 2, 1, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", "g2", "g3", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2", "g3", "s6"], ", i=", 3, 
        ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{9, 10, 8, 2, 1, 
          12}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "g1", "g2", "g3", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "g1", "g2", "g3", "s6"], ", i=", 2, 
        ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{10, 8, 2, 1, 
          12}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s3", "s4", 
          "g1", "g2", "g3", "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {10, 8, 2, 1, 12}, 
        " and SGS ", 
        GenSet[ "s3", "s4", "g1", "g2", "g3", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]140\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]27783\),
      SequenceForm[ 
      "Checked ", 140, " generators and obtained group of order ", 27783],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0.6080379999999996`\ Second, 
      StrongGenSet[{9, 10, 8, 2, 1, 12}, 
        GenSet["s1", "s2", "s3", "s4", "g1", "g2", "g3", "s6"]]}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 5. Rubik", "Section"],

Cell["Example in page 83 of Butler.", "Text"],

Cell["\<\
There are 6 basic generators, given by the rotation of each of the faces:\
\>", "Text"],

Cell[BoxData[
    \(\(RubikA = 
        Cycles[{1, 3, 8, 6}, {2, 5, 7, 4}, {9, 48, 15, 12}, {10, 47, 16, 
            13}, {11, 46, 17, 14}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StablePoints[RubikA]\)], "Input"],

Cell[BoxData[
    \({18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
      35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(RubikB = 
        Cycles[{6, 15, 35, 26}, {7, 22, 34, 19}, {8, 30, 33, 11}, {12, 14, 
            29, 27}, {13, 21, 28, 20}];\)\)], "Input"],

Cell[BoxData[
    \(\(RubikC = 
        Cycles[{1, 12, 33, 41}, {4, 20, 36, 44}, {6, 27, 38, 46}, {9, 11, 26, 
            24}, {10, 19, 25, 18}];\)\)], "Input"],

Cell[BoxData[
    \(\(RubikD = 
        Cycles[{1, 24, 40, 17}, {2, 18, 39, 23}, {3, 9, 38, 32}, {41, 43, 48, 
            46}, {42, 45, 47, 44}];\)\)], "Input"],

Cell[BoxData[
    \(\(RubikE = 
        Cycles[{3, 43, 35, 14}, {5, 45, 37, 21}, {8, 48, 40, 29}, {15, 17, 
            32, 30}, {16, 23, 31, 22}];\)\)], "Input"],

Cell[BoxData[
    \(\(RubikF = 
        Cycles[{24, 27, 30, 43}, {25, 28, 31, 42}, {26, 29, 32, 41}, {33, 35, 
            40, 38}, {34, 37, 39, 36}];\)\)], "Input"],

Cell[BoxData[
    \(\(RubikGS = 
        GenSet[RubikA, RubikB, RubikC, RubikD, RubikE, RubikF];\)\)], "Input"],

Cell["Actually they are all permutations of order 4:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(PowerPermute[#, 4] &\) /@ RubikGS\)], "Input"],

Cell[BoxData[
    \(GenSet["ID", "ID", "ID", "ID", "ID", "ID"]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(And @@ \((\(\((Cycles[] == PowerPermute[#, 4])\) &\) /@ 
          RubikGS)\)\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["\<\
There are two 24-points orbits, corresponding to \"corners\" and \"sides\":\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orbits[RubikGS, 48]\)], "Input"],

Cell[BoxData[
    \({{1, 3, 12, 24, 8, 9, 43, 14, 33, 40, 27, 6, 30, 48, 11, 38, 35, 29, 
        41, 17, 15, 46, 26, 32}, {2, 5, 18, 7, 45, 10, 39, 4, 22, 47, 37, 19, 
        23, 36, 20, 34, 16, 44, 21, 25, 31, 13, 42, 28}}\)], "Output"]
}, Open  ]],

Cell["There are no fully stable points:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Intersection @@ \(StablePoints /@ RubikGS\)\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell["\<\
For example, assuming that 1 and 2 are next to each other, it is simple to \
understand why there are 3 rotations that do not move them:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Stabilizer[{1, 2}, RubikGS] === 
      GenSet[RubikB, RubikE, RubikF]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["Strong generating set:", "Text"],

Cell[BoxData[
    \(\(RubikBase = {1, 6, 3, 8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 
          18, 4, 2};\)\)], "Input"],

Cell[BoxData[{
    \(\(s1 = RubikA;\)\), "\[IndentingNewLine]", 
    \(\(s2 = RubikB;\)\), "\[IndentingNewLine]", 
    \(\(s3 = RubikE;\)\), "\[IndentingNewLine]", 
    \(\(s4 = 
        Cycles[{5, 37, 28, 21}, {8, 26, 29, 32}, {14, 33, 35, 40}, {15, 27, 
            30, 43}, {16, 31, 34, 22}];\)\), "\[IndentingNewLine]", 
    \(\(s5 = 
        Cycles[{5, 45, 13, 37, 21}, {7, 31, 22, 16, 23}, {26, 27, 33}, {29, 
            35, 30}];\)\), "\[IndentingNewLine]", 
    \(\(s6 = Cycles[{19, 23, 34}, {20, 45, 28}];\)\), "\[IndentingNewLine]", 
    \(\(s7 = RubikF;\)\), "\[IndentingNewLine]", 
    \(\(s8 = Cycles[{5, 28, 37}, {16, 34, 31}];\)\), "\[IndentingNewLine]", 
    \(\(s9 = 
        Cycles[{2, 28, 47, 34}, {24, 41, 38}, {25, 39, 31, 36, 42, 37}, {29, 
            43, 30, 40, 35, 32}];\)\), "\[IndentingNewLine]", 
    \(\(s10 = 
        Cycles[{19, 31, 34}, {20, 37, 28}];\)\), "\[IndentingNewLine]", 
    \(\(s11 = Cycles[{7, 31, 34}, {13, 37, 28}];\)\), "\[IndentingNewLine]", 
    \(\(s12 = 
        Cycles[{24, 41, 38}, {32, 43, 40}];\)\), "\[IndentingNewLine]", 
    \(\(s13 = 
        Cycles[{24, 40}, {25, 39, 34, 37}, {28, 31, 36, 42}, {32, 38}, {41, 
            43}];\)\), "\[IndentingNewLine]", 
    \(\(s14 = 
        Cycles[{25, 28, 31}, {34, 37, 36}];\)\), "\[IndentingNewLine]", 
    \(\(s15 = Cycles[{2, 31, 34}, {28, 47, 37}];\)\), "\[IndentingNewLine]", 
    \(\(s16 = Cycles[{2, 31, 39}, {37, 42, 47}];\)\), "\[IndentingNewLine]", 
    \(\(s17 = Cycles[{2, 18, 39}, {42, 47, 44}];\)\), "\[IndentingNewLine]", 
    \(\(s18 = Cycles[{2, 10, 39}, {4, 42, 47}];\)\), "\[IndentingNewLine]", 
    \(\(s19 = Cycles[{2, 47}, {39, 42}];\)\)}], "Input"],

Cell[BoxData[
    \(\(RubikS = 
        GenSet[s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, 
          s15, s16, s17, s18, s19];\)\)], "Input"],

Cell[BoxData[
    \(\(SGS = StrongGenSet[RubikBase, RubikS];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(43252003274489856000\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(4.325200327448986`*^19\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[%%]\)], "Input"],

Cell[BoxData[
    \({{2, 27}, {3, 14}, {5, 3}, {7, 2}, {11, 1}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\($xPermRules = 
        Join[{Cycles[] \[Rule] "\<ID\>"}, 
          NameRules[s, 19, Cycles]];\)\)], "Input"],

Cell["There are no redundant points in the base:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((chain = StabilizerChain[SGS])\) // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(StrongGenSet[{1, 6, 3, 8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 
                31, 18, 4, 2}, 
              GenSet["s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8", "s9", 
                "s10", "s11", "s12", "s13", "s14", "s15", "s16", "s17", 
                "s18", "s19"]]\)},
          {\(StrongGenSet[{6, 3, 8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 
                18, 4, 2}, 
              GenSet["s2", "s3", "s4", "s5", "s6", "s7", "s8", "s9", "s10", 
                "s11", "s12", "s13", "s14", "s15", "s16", "s17", "s18", 
                "s19"]]\)},
          {\(StrongGenSet[{3, 8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 
                18, 4, 2}, 
              GenSet["s3", "s4", "s5", "s6", "s7", "s8", "s9", "s10", "s11", 
                "s12", "s13", "s14", "s15", "s16", "s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 
                4, 2}, GenSet["s4", "s5", "s6", "s7", "s8", "s9", "s10", 
                "s11", "s12", "s13", "s14", "s15", "s16", "s17", "s18", 
                "s19"]]\)},
          {\(StrongGenSet[{21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 
                2}, GenSet["s5", "s6", "s7", "s8", "s9", "s10", "s11", "s12", 
                "s13", "s14", "s15", "s16", "s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 2}, 
              GenSet["s6", "s7", "s8", "s9", "s10", "s11", "s12", "s13", 
                "s14", "s15", "s16", "s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 2}, 
              GenSet["s7", "s8", "s9", "s10", "s11", "s12", "s13", "s14", 
                "s15", "s16", "s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 2}, 
              GenSet["s8", "s9", "s10", "s11", "s12", "s13", "s14", "s15", 
                "s16", "s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{29, 19, 7, 24, 25, 28, 31, 18, 4, 2}, 
              GenSet["s9", "s10", "s11", "s12", "s13", "s14", "s15", "s16", 
                "s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{19, 7, 24, 25, 28, 31, 18, 4, 2}, 
              GenSet["s10", "s11", "s12", "s13", "s14", "s15", "s16", "s17", 
                "s18", "s19"]]\)},
          {\(StrongGenSet[{7, 24, 25, 28, 31, 18, 4, 2}, 
              GenSet["s11", "s12", "s13", "s14", "s15", "s16", "s17", "s18", 
                "s19"]]\)},
          {\(StrongGenSet[{24, 25, 28, 31, 18, 4, 2}, 
              GenSet["s12", "s13", "s14", "s15", "s16", "s17", "s18", 
                "s19"]]\)},
          {\(StrongGenSet[{25, 28, 31, 18, 4, 2}, 
              GenSet["s14", "s15", "s16", "s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{28, 31, 18, 4, 2}, 
              GenSet["s15", "s16", "s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{31, 18, 4, 2}, 
              GenSet["s16", "s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{18, 4, 2}, GenSet["s17", "s18", "s19"]]\)},
          {\(StrongGenSet[{4, 2}, GenSet["s18", "s19"]]\)},
          {\(StrongGenSet[{2}, GenSet["s19"]]\)},
          {\(StrongGenSet[{}, GenSet[]]\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        StrongGenSet[ {1, 6, 3, 8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 
          18, 4, 2}, 
          GenSet[ 
          "s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8", "s9", "s10", "s11", 
            "s12", "s13", "s14", "s15", "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {6, 3, 8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 
          4, 2}, 
          GenSet[ 
          "s2", "s3", "s4", "s5", "s6", "s7", "s8", "s9", "s10", "s11", "s12",
             "s13", "s14", "s15", "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {3, 8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 
          2}, 
          GenSet[ 
          "s3", "s4", "s5", "s6", "s7", "s8", "s9", "s10", "s11", "s12", 
            "s13", "s14", "s15", "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 2},
           
          GenSet[ 
          "s4", "s5", "s6", "s7", "s8", "s9", "s10", "s11", "s12", "s13", 
            "s14", "s15", "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 2}, 
          GenSet[ 
          "s5", "s6", "s7", "s8", "s9", "s10", "s11", "s12", "s13", "s14", 
            "s15", "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 2}, 
          GenSet[ 
          "s6", "s7", "s8", "s9", "s10", "s11", "s12", "s13", "s14", "s15", 
            "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 2}, 
          GenSet[ 
          "s7", "s8", "s9", "s10", "s11", "s12", "s13", "s14", "s15", "s16", 
            "s17", "s18", "s19"]], 
        StrongGenSet[ {5, 29, 19, 7, 24, 25, 28, 31, 18, 4, 2}, 
          GenSet[ 
          "s8", "s9", "s10", "s11", "s12", "s13", "s14", "s15", "s16", "s17", 
            "s18", "s19"]], 
        StrongGenSet[ {29, 19, 7, 24, 25, 28, 31, 18, 4, 2}, 
          GenSet[ 
          "s9", "s10", "s11", "s12", "s13", "s14", "s15", "s16", "s17", "s18",
             "s19"]], 
        StrongGenSet[ {19, 7, 24, 25, 28, 31, 18, 4, 2}, 
          GenSet[ 
          "s10", "s11", "s12", "s13", "s14", "s15", "s16", "s17", "s18", 
            "s19"]], 
        StrongGenSet[ {7, 24, 25, 28, 31, 18, 4, 2}, 
          GenSet[ 
          "s11", "s12", "s13", "s14", "s15", "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {24, 25, 28, 31, 18, 4, 2}, 
          GenSet[ "s12", "s13", "s14", "s15", "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {25, 28, 31, 18, 4, 2}, 
          GenSet[ "s14", "s15", "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {28, 31, 18, 4, 2}, 
          GenSet[ "s15", "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {31, 18, 4, 2}, 
          GenSet[ "s16", "s17", "s18", "s19"]], 
        StrongGenSet[ {18, 4, 2}, 
          GenSet[ "s17", "s18", "s19"]], 
        StrongGenSet[ {4, 2}, 
          GenSet[ "s18", "s19"]], 
        StrongGenSet[ {2}, 
          GenSet[ "s19"]], 
        StrongGenSet[ {}, 
          GenSet[ ]]}],
      Editable->False]], "Output"]
}, Open  ]],

Cell["Check that it is a SGS:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AbsoluteTiming[
      TranslatePerm[
        SchreierSims[RubikBase, RubikS, 48, MathLink \[Rule] True], 
        Cycles]]\)], "Input"],

Cell[BoxData[
    \({1.112674`6.49791293344642\ Second, 
      StrongGenSet[{1, 6, 3, 8, 21, 23, 26, 5, 29, 19, 7, 24, 25, 28, 31, 18, 
          4, 2}, GenSet["s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8", "s9", 
          "s10", "s11", "s12", "s13", "s14", "s15", "s16", "s17", "s18", 
          "s19"]]}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 6", "Section"],

Cell["Example in page 84 of Butler.", "Text"],

Cell[BoxData[
    \(\(a = 
        Cycles[{1, 2}, {3, 4}, {5, 6}, {7, 8}, {9, 10}, {11, 
            12}];\)\)], "Input"],

Cell[BoxData[
    \(\(b = 
        Cycles[{1, 13}, {2, 3, 7, 5}, {6, 9, 11, 8}, {10, 14}];\)\)], "Input"],

Cell[BoxData[{
    \(\(s1 = a;\)\), "\[IndentingNewLine]", 
    \(\(s2 = 
        Cycles[{2, 7}, {3, 5}, {6, 11}, {8, 9}];\)\), "\[IndentingNewLine]", 
    \(\(s3 = 
        Cycles[{3, 7, 11, 8}, {4, 14}, {5, 6}, {12, 
            13}];\)\), "\[IndentingNewLine]", 
    \(\(s4 = 
        Cycles[{3, 13, 11, 14}, {4, 8}, {5, 6}, {7, 
            12}];\)\), "\[IndentingNewLine]", 
    \(\(s5 = Cycles[{4, 12}, {13, 14}];\)\), "\[IndentingNewLine]", 
    \(\(s6 = Cycles[{7, 8}, {13, 14}];\)\), "\[IndentingNewLine]", 
    \(\(s7 = Cycles[{5, 6}, {13, 14}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(g1 = 
        TranslatePerm[Perm[{13, 5, 2, 4, 7, 8, 3, 11, 6, 14, 9, 12, 1, 10}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g2 = 
        TranslatePerm[Perm[{1, 4, 11, 2, 13, 14, 8, 7, 12, 10, 3, 9, 5, 6}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g3 = 
        TranslatePerm[Perm[{1, 2, 14, 8, 5, 6, 12, 4, 9, 10, 13, 7, 11, 3}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g4 = 
        TranslatePerm[Perm[{1, 6, 13, 11, 9, 2, 12, 4, 5, 10, 14, 3, 7, 8}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g5 = 
        TranslatePerm[Perm[{1, 2, 3, 12, 5, 6, 8, 7, 9, 10, 11, 4, 13, 14}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g6 = 
        TranslatePerm[Perm[{1, 2, 12, 11, 5, 6, 14, 13, 9, 10, 4, 3, 8, 7}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g7 = 
        TranslatePerm[Perm[{1, 2, 3, 12, 6, 5, 8, 7, 9, 10, 11, 4, 14, 13}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g8 = 
        TranslatePerm[Perm[{1, 2, 3, 4, 6, 5, 8, 7, 9, 10, 11, 12, 13, 14}], 
          Cycles];\)\)}], "Input"],

Cell[BoxData[{
    \(\(B = {1, 2, 3, 4, 7, 5};\)\), "\n", 
    \(\(S = GenSet[s1, s2, s3, s4, s5, s6, s7];\)\), "\[IndentingNewLine]", 
    \(\(SGS = StrongGenSet[B, S];\)\)}], "Input"],

Cell[BoxData[
    \(\($xPermRules = 
        Join[{Cycles[] \[Rule] "\<ID\>"}, NameRules[s, 7, Cycles], 
          NameRules[g, 8, Cycles]];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(10752\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((chain = StabilizerChain[SGS])\) // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(StrongGenSet[{1, 2, 3, 4, 7, 5}, 
              GenSet["s1", "s2", "s3", "s4", "s5", "s6", "s7"]]\)},
          {\(StrongGenSet[{2, 3, 4, 7, 5}, 
              GenSet["s2", "s3", "s4", "s5", "s6", "s7"]]\)},
          {\(StrongGenSet[{3, 4, 7, 5}, 
              GenSet["s3", "s4", "s5", "s6", "s7"]]\)},
          {\(StrongGenSet[{4, 7, 5}, GenSet["s5", "s6", "s7"]]\)},
          {\(StrongGenSet[{7, 5}, GenSet["s6", "s7"]]\)},
          {\(StrongGenSet[{5}, GenSet["s7"]]\)},
          {\(StrongGenSet[{}, GenSet[]]\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        StrongGenSet[ {1, 2, 3, 4, 7, 5}, 
          GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7"]], 
        StrongGenSet[ {2, 3, 4, 7, 5}, 
          GenSet[ "s2", "s3", "s4", "s5", "s6", "s7"]], 
        StrongGenSet[ {3, 4, 7, 5}, 
          GenSet[ "s3", "s4", "s5", "s6", "s7"]], 
        StrongGenSet[ {4, 7, 5}, 
          GenSet[ "s5", "s6", "s7"]], 
        StrongGenSet[ {7, 5}, 
          GenSet[ "s6", "s7"]], 
        StrongGenSet[ {5}, 
          GenSet[ "s7"]], 
        StrongGenSet[ {}, 
          GenSet[ ]]}],
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Note that we obtain mostly different vectors compared to those of Butler. His \
solution is a tree of 8 levels, while the solution given here has 5 levels \
only:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([1]\)], chain[\([1]\)], 14]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", 
            "13", "14"},
          {"\<\"Init\"\>", "\<\"s1\"\>", "\<\"s3\"\>", "\<\"s4\"\>", \
"\<\"s2\"\>", "\<\"s2\"\>", "\<\"s2\"\>", "\<\"s1\"\>", "\<\"s2\"\>", "\<\"s1\
\"\>", "\<\"s3\"\>", "\<\"s4\"\>", "\<\"s3\"\>", "\<\"s4\"\>"},
          {"0", "1", "8", "8", "3", "11", "2", "7", "8", "9", "7", "7", "12", 
            "11"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([2]\)], chain[\([2]\)], 14]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"2", "3", "4", "5", "6", "7", "8", "9", "11", "12", "13", "14"},
          {"\<\"Init\"\>", "\<\"s3\"\>", "\<\"s5\"\>", "\<\"s3\"\>", \
"\<\"s2\"\>", "\<\"s2\"\>", "\<\"s6\"\>", "\<\"s2\"\>", "\<\"s3\"\>", "\<\"s4\
\"\>", "\<\"s3\"\>", "\<\"s4\"\>"},
          {"0", "8", "12", "6", "11", "2", "7", "8", "7", "7", "12", "11"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([3]\)], chain[\([3]\)], 14]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"3", "4", "7", "8", "11", "12", "13", "14"},
          {"\<\"Init\"\>", "\<\"s5\"\>", "\<\"s3\"\>", "\<\"s6\"\>", \
"\<\"s3\"\>", "\<\"s4\"\>", "\<\"s4\"\>", "\<\"s5\"\>"},
          {"0", "12", "3", "7", "7", "7", "3", "13"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([4]\)], chain[\([4]\)], 14]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"4", "12"},
          {"\<\"Init\"\>", "\<\"s5\"\>"},
          {"0", "4"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([5]\)], chain[\([5]\)], 14]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"7", "8"},
          {"\<\"Init\"\>", "\<\"s6\"\>"},
          {"0", "7"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintSchreier[SchreierOrbit[B[\([6]\)], chain[\([6]\)], 14]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"5", "6"},
          {"\<\"Init\"\>", "\<\"s7\"\>"},
          {"0", "5"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["Example in page 91 of Butler. It's wrong.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Permute[a, b]\)], "Input"],

Cell[BoxData[
    \(Cycles[{1, 3, 4, 7, 6, 2, 13}, {5, 9, 14, 10, 11, 12, 8}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Permute @@ PermWord[Permute[a, b], SGS]\)], "Input"],

Cell[BoxData[
    \(Cycles[{1, 3, 4, 7, 6, 2, 13}, {5, 9, 14, 10, 11, 12, 8}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Permute @@ {s6, Permute[s4, s3], Permute[s2, s3, s4, s4], 
        Permute[s1, s2, s3]}\)], "Input"],

Cell[BoxData[
    \(Cycles[{1, 11, 12, 8, 5, 9, 13}, {2, 14, 10, 3, 4, 7, 6}]\)], "Output"]
}, Open  ]],

Cell["Check SGS.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[B, S, 14, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 7, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", 
          "s7"]\[InvisibleSpace]", i="\[InvisibleSpace]6\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s7"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7, 5}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7"], ", i=", 6, ", T=", 
        
        GenSet[ "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 7, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", 
          "s7"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6", "s7"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7, 5}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7"], ", i=", 5, ", T=", 
        
        GenSet[ "s6", "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 7, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", 
          "s7"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s5", "s6", "s7"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7, 5}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7"], ", i=", 4, ", T=", 
        
        GenSet[ "s5", "s6", "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 7, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", 
          "s7"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3", "s4", "s5", "s6", "s7"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7, 5}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7"], ", i=", 3, ", T=", 
        
        GenSet[ "s3", "s4", "s5", "s6", "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 7, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", 
          "s7"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2", "s3", "s4", "s5", "s6", "s7"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7, 5}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7"], ", i=", 2, ", T=", 
        
        GenSet[ "s2", "s3", "s4", "s5", "s6", "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 7, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", 
          "s7"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4", "s5", "s6", "s7"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7, 5}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7"], ", i=", 1, ", T=", 
        
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]222\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]10752\),
      SequenceForm[ 
      "Checked ", 222, " generators and obtained group of order ", 10752],
      Editable->False]], "Print"],

Cell[BoxData[
    \({1.0840680000000003`\ Second, 
      StrongGenSet[{1, 2, 3, 4, 7, 5}, 
        GenSet["s1", "s2", "s3", "s4", "s5", "s6", "s7"]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[{}, GenSet[a, b], 14, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", 
          "g1"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "g1"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1}, ", S=", 
        GenSet[ "s1", "g1"], ", i=", 1, ", T=", 
        GenSet[ "s1", "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]"g2"\),
      SequenceForm[ "Appended S[[", 3, "]]=", "g2"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]2\),
      SequenceForm[ "Appended B[[", 2, "]]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "g1", 
          "g2"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g2"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "g1", "g2"], ", i=", 2, ", T=", 
        GenSet[ "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["g2"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2}, " and SGS ", 
        GenSet[ "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]"s2"\),
      SequenceForm[ "Appended S[[", 4, "]]=", "s2"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "g1", "g2", 
          "s2"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "g1", "g2", "s2"], ", i=", 2, ", T=", 
        GenSet[ "s2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]"g3"\),
      SequenceForm[ "Appended S[[", 5, "]]=", "g3"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]3\),
      SequenceForm[ "Appended B[[", 3, "]]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "g1", "g2", "s2", 
          "g3"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g3"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 3}, ", S=", 
        GenSet[ "s1", "g1", "g2", "s2", "g3"], ", i=", 3, ", T=", 
        GenSet[ "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["g3"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3}, " and SGS ", 
        GenSet[ "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 
          3}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["g2", "s2", 
          "g3"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 3}, " and SGS ", 
        GenSet[ "g2", "s2", "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]"g4"\),
      SequenceForm[ "Appended S[[", 6, "]]=", "g4"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "g1", "g2", "s2", "g3", 
          "g4"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g4"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 3}, ", S=", 
        GenSet[ "s1", "g1", "g2", "s2", "g3", "g4"], ", i=", 2, ", T=", 
        GenSet[ "g4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]7\[InvisibleSpace]"]]="\[InvisibleSpace]"s3"\),
      SequenceForm[ "Appended S[[", 7, "]]=", "s3"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "g1", "g2", "s2", "g3", "g4", 
          "s3"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 3}, ", S=", 
        GenSet[ "s1", "g1", "g2", "s2", "g3", "g4", "s3"], ", i=", 3, ", T=", 
        
        GenSet[ "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]8\[InvisibleSpace]"]]="\[InvisibleSpace]"s5"\),
      SequenceForm[ "Appended S[[", 8, "]]=", "s5"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]4\),
      SequenceForm[ "Appended B[[", 4, "]]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "g1", "g2", 
          "s2", "g3", "g4", "s3", 
          "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s5"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "g1", "g2", "s2", "g3", "g4", "s3", "s5"], ", i=", 4, 
        ", T=", 
        GenSet[ "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s5"]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {4}, " and SGS ", 
        GenSet[ "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]9\[InvisibleSpace]"]]="\[InvisibleSpace]"g5"\),
      SequenceForm[ "Appended S[[", 9, "]]=", "g5"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "g1", "g2", 
          "s2", "g3", "g4", "s3", "s5", 
          "g5"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g5"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "g1", "g2", "s2", "g3", "g4", "s3", "s5", "g5"], ", i=",
         4, ", T=", 
        GenSet[ "g5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]10\[InvisibleSpace]"]]="\[InvisibleSpace]"s6"\),
      SequenceForm[ "Appended S[[", 10, "]]=", "s6"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]7\),
      SequenceForm[ "Appended B[[", 5, "]]=", 7],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "g1", "g2", 
          "s2", "g3", "g4", "s3", "s5", "g5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7}, ", S=", 
        GenSet[ "s1", "g1", "g2", "s2", "g3", "g4", "s3", "s5", "g5", "s6"], 
        ", i=", 5, ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]5\
\[InvisibleSpace]") with base "\[InvisibleSpace]{7}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Finished check of H(", 5, ") with base ", {7}, " and SGS ", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4, 
          7}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s5", "g5", 
          "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {4, 7}, " and SGS ", 
        GenSet[ "s5", "g5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 4, 
          7}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["g3", "s3", 
          "s5", "g5", "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 4, 7}, " and SGS ", 
        GenSet[ "g3", "s3", "s5", "g5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]11\[InvisibleSpace]"]]="\[InvisibleSpace]"g6"\),
      SequenceForm[ "Appended S[[", 11, "]]=", "g6"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "g1", "g2", 
          "s2", "g3", "g4", "s3", "s5", "g5", "s6", 
          "g6"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7}, ", S=", 
        GenSet[ 
        "s1", "g1", "g2", "s2", "g3", "g4", "s3", "s5", "g5", "s6", "g6"], 
        ", i=", 3, ", T=", 
        GenSet[ "g6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]12\[InvisibleSpace]"]]="\[InvisibleSpace]"g7"\),
      SequenceForm[ "Appended S[[", 12, "]]=", "g7"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 
          7}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "g1", "g2", 
          "s2", "g3", "g4", "s3", "s5", "g5", "s6", "g6", 
          "g7"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g7"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7}, ", S=", 
        GenSet[ 
        "s1", "g1", "g2", "s2", "g3", "g4", "s3", "s5", "g5", "s6", "g6", 
          "g7"], ", i=", 4, ", T=", 
        GenSet[ "g7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]13\[InvisibleSpace]"]]="\[InvisibleSpace]"s7"\),
      SequenceForm[ "Appended S[[", 13, "]]=", "s7"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]5\),
      SequenceForm[ "Appended B[[", 6, "]]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 7, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "g1", "g2", 
          "s2", "g3", "g4", "s3", "s5", "g5", "s6", "g6", "g7", 
          "s7"]\[InvisibleSpace]", i="\[InvisibleSpace]6\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s7"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7, 5}, ", S=", 
        GenSet[ 
        "s1", "g1", "g2", "s2", "g3", "g4", "s3", "s5", "g5", "s6", "g6", 
          "g7", "s7"], ", i=", 6, ", T=", 
        GenSet[ "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 7, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "g1", "g2", 
          "s2", "g3", "g4", "s3", "s5", "g5", "s6", "g6", "g7", 
          "s7"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s7"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 7, 5}, ", S=", 
        GenSet[ 
        "s1", "g1", "g2", "s2", "g3", "g4", "s3", "s5", "g5", "s6", "g6", 
          "g7", "s7"], ", i=", 5, ", T=", 
        GenSet[ "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]5\
\[InvisibleSpace]") with base "\[InvisibleSpace]{7, 
          5}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s6", "s7"]\),
      
      SequenceForm[ 
      "Finished check of H(", 5, ") with base ", {7, 5}, " and SGS ", 
        GenSet[ "s6", "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4, 7, 
          5}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s5", "g5", 
          "s6", "g7", "s7"]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {4, 7, 5}, " and SGS ", 
        GenSet[ "s5", "g5", "s6", "g7", "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 4, 7, 
          5}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["g3", "s3", 
          "s5", "g5", "s6", "g6", "g7", "s7"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 4, 7, 5}, " and SGS ", 
        GenSet[ "g3", "s3", "s5", "g5", "s6", "g6", "g7", "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 3, 4, 7, 
          5}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["g2", "s2", 
          "g3", "g4", "s3", "s5", "g5", "s6", "g6", "g7", "s7"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 3, 4, 7, 5}, " and SGS ",
         
        GenSet[ 
        "g2", "s2", "g3", "g4", "s3", "s5", "g5", "s6", "g6", "g7", "s7"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]106\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]10752\),
      SequenceForm[ 
      "Checked ", 106, " generators and obtained group of order ", 10752],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0.48402999999999974`\ Second, 
      StrongGenSet[{1, 2, 3, 4, 7, 5}, 
        GenSet["s1", "g1", "g2", "s2", "g3", "g4", "s3", "s5", "g5", "s6", 
          "g6", "g7", "s7"]]}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 7", "Section"],

Cell["Example in page 85 of Butler:", "Text"],

Cell[BoxData[
    \(\(a = 
        Cycles[{1, 2}, {3, 4}, {5, 6}, {7, 8}, {9, 10}, {11, 12}, {13, 
            14}, {15, 16}];\)\)], "Input"],

Cell[BoxData[
    \(\(b = 
        Cycles[{1, 2, 5, 3}, {4, 7}, {6, 9}, {8, 11}, {10, 13, 16, 15}, {12, 
            14}];\)\)], "Input"],

Cell[BoxData[{
    \(\(s1 = a;\)\), "\[IndentingNewLine]", 
    \(\(s2 = 
        Cycles[{3, 14, 10, 6}, {4, 5, 9, 13}, {7, 11}, {8, 
            12}];\)\), "\[IndentingNewLine]", 
    \(\(s3 = 
        Cycles[{2, 6, 10, 14, 11, 7, 3}, {4, 8, 12, 13, 15, 9, 
            5}];\)\), "\[IndentingNewLine]", 
    \(\(s4 = 
        Cycles[{4, 12}, {6, 11}, {7, 14}, {8, 
            9}];\)\), "\[IndentingNewLine]", 
    \(\(s5 = Cycles[{4, 8}, {6, 7}, {9, 12}, {11, 14}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(g1 = 
        TranslatePerm[
          Perm[{1, 10, 3, 8, 15, 6, 7, 4, 9, 2, 14, 12, 13, 11, 5, 16}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g2 = 
        TranslatePerm[
          Perm[{1, 2, 11, 5, 12, 3, 14, 9, 13, 7, 6, 4, 8, 10, 15, 16}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g3 = 
        TranslatePerm[
          Perm[{1, 2, 6, 5, 4, 3, 7, 8, 13, 14, 11, 12, 9, 10, 15, 16}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g4 = 
        TranslatePerm[
          Perm[{1, 2, 10, 12, 13, 11, 6, 4, 8, 3, 14, 9, 5, 7, 15, 16}], 
          Cycles];\)\)}], "Input"],

Cell[BoxData[{
    \(\(B = {1, 2, 3, 4};\)\), "\[IndentingNewLine]", 
    \(\(S = GenSet[s1, s2, s3, s4, s5];\)\), "\[IndentingNewLine]", 
    \(\(SGS = StrongGenSet[B, S];\)\)}], "Input"],

Cell[BoxData[
    \(\($xPermRules = 
        Join[{Cycles[] \[Rule] "\<ID\>", b \[Rule] "\<b\>"}, 
          NameRules[s, 5, Cycles], NameRules[g, 4, Cycles]];\)\)], "Input"],

Cell["Butler quotes a result which is 8 times larger:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(2688\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[%]\)], "Input"],

Cell[BoxData[
    \({{2, 7}, {3, 1}, {7, 1}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimino[S] // Length\)], "Input"],

Cell[BoxData[
    \(2688\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[B, S, 16, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]4\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s4", "s5"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"], ", i=", 4, ", T=", 
        GenSet[ "s4", "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]3\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s2", "s4", "s5"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"], ", i=", 3, ", T=", 
        GenSet[ "s2", "s4", "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]2\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s2", "s3", "s4", "s5"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"], ", i=", 2, ", T=", 
        GenSet[ "s2", "s3", "s4", "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]1\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4", 
          "s5"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]134\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]2688\),
      SequenceForm[ 
      "Checked ", 134, " generators and obtained group of order ", 2688],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0.5720349999999996`\ Second, 
      StrongGenSet[{1, 2, 3, 4}, 
        GenSet["s1", "s2", "s3", "s4", "s5"]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[{}, GenSet[a, b], 16, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", 
          "b"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "b"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1}, ", S=", 
        GenSet[ "s1", "b"], ", i=", 1, ", T=", 
        GenSet[ "s1", "b"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]"s3"\),
      SequenceForm[ "Appended S[[", 3, "]]=", "s3"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]2\),
      SequenceForm[ "Appended B[[", 2, "]]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", 
          "s3"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "b", "s3"], ", i=", 2, ", T=", 
        GenSet[ "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s3"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2}, " and SGS ", 
        GenSet[ "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]"g1"\),
      SequenceForm[ "Appended S[[", 4, "]]=", "g1"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "s3", 
          "g1"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g1"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "b", "s3", "g1"], ", i=", 2, ", T=", 
        GenSet[ "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{3, 11, 
            6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}]\),
      SequenceForm[ "Appended S[[", 5, "]]=", 
        Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]3\),
      SequenceForm[ "Appended B[[", 3, "]]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "s3", "g1", 
          Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 
              13}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]3\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 3}, ", S=", 
        GenSet[ "s1", "b", "s3", "g1", 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}]], ", i=", 
        3, ", T=", 
        GenSet[ 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[
          Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}]]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3}, " and SGS ", 
        GenSet[ 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]"g3"\),
      SequenceForm[ "Appended S[[", 6, "]]=", "g3"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "s3", "g1", 
          Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], 
          "g3"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g3"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 3}, ", S=", 
        GenSet[ "s1", "b", "s3", "g1", 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3"], 
        ", i=", 3, ", T=", 
        GenSet[ "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]7\[InvisibleSpace]"]]="\[InvisibleSpace]"s4"\),
      SequenceForm[ "Appended S[[", 7, "]]=", "s4"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]4\),
      SequenceForm[ "Appended B[[", 4, "]]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "s3", 
          "g1", Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], 
          "g3", "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]4\
\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s4"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "b", "s3", "g1", 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4"], ", i=", 4, ", T=", 
        GenSet[ "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s4"]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {4}, " and SGS ", 
        GenSet[ "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 4}, " and SGS ", 
        GenSet[ 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]8\[InvisibleSpace]"]]="\[InvisibleSpace]"s2"\),
      SequenceForm[ "Appended S[[", 8, "]]=", "s2"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "s3", 
          "g1", Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], 
          "g3", "s4", 
          "s2"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "b", "s3", "g1", 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4", "s2"], ", i=", 3, ", T=", 
        GenSet[ "s2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]9\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 
            9}, {6, 14}, {7, 11}, {8, 12}]\),
      SequenceForm[ "Appended S[[", 9, "]]=", 
        Cycles[ {4, 9}, {6, 14}, {7, 11}, {8, 12}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "s3", 
          "g1", Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], 
          "g3", "s4", "s2", 
          Cycles[{4, 9}, {6, 14}, {7, 11}, {8, 
              12}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 9}, {6, 14}, {7, 11}, {8, 12}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "b", "s3", "g1", 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4", "s2", 
          Cycles[ {4, 9}, {6, 14}, {7, 11}, {8, 12}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {4, 9}, {6, 14}, {7, 11}, {8, 12}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s4", Cycles[{4, 9}, {6, 14}, {7, 11}, {8, 12}]]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {4}, " and SGS ", 
        GenSet[ "s4", 
          Cycles[ {4, 9}, {6, 14}, {7, 11}, {8, 12}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4", "s2", Cycles[{4, 9}, {6, 14}, {7, 11}, {8, 12}]]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 4}, " and SGS ", 
        GenSet[ 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4", "s2", 
          Cycles[ {4, 9}, {6, 14}, {7, 11}, {8, 12}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 3, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s3", "g1", 
          Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4", "s2", Cycles[{4, 9}, {6, 14}, {7, 11}, {8, 12}]]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 3, 4}, " and SGS ", 
        GenSet[ "s3", "g1", 
          Cycles[ {3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4", "s2", 
          Cycles[ {4, 9}, {6, 14}, {7, 11}, {8, 12}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]75\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]2688\),
      SequenceForm[ 
      "Checked ", 75, " generators and obtained group of order ", 2688],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0.3080199999999991`\ Second, 
      StrongGenSet[{1, 2, 3, 4}, 
        GenSet["s1", "b", "s3", "g1", 
          Cycles[{3, 11, 6}, {4, 5, 12}, {7, 14, 10}, {8, 9, 13}], "g3", 
          "s4", "s2", 
          Cycles[{4, 9}, {6, 14}, {7, 11}, {8, 12}]]]}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 8", "Section"],

Cell["Example in page 86 of Butler.", "Text"],

Cell[BoxData[
    \(\(a = 
        Cycles[{1, 2}, {3, 4}, {5, 6}, {7, 8}, {9, 10}, {11, 12}, {13, 
            14}, {15, 16}, {17, 18}];\)\)], "Input"],

Cell[BoxData[
    \(\(b = 
        Cycles[{1, 2, 5, 3}, {4, 7}, {6, 9, 12, 11}, {8, 13, 16, 15}, {10, 
            14, 18, 17}];\)\)], "Input"],

Cell[BoxData[{
    \(\(s1 = a;\)\), "\[IndentingNewLine]", 
    \(\(s2 = 
        Cycles[{2, 10}, {3, 6}, {4, 11}, {5, 17}, {7, 18}, {8, 14}, {9, 
            16}, {12, 13}];\)\), "\[IndentingNewLine]", 
    \(\(s3 = 
        Cycles[{3, 15, 7, 10, 6, 18, 13}, {4, 8}, {5, 9}, {11, 14}, {16, 
            17}];\)\), "\[IndentingNewLine]", 
    \(\(s4 = Cycles[{4, 16, 5, 8, 14, 11, 17}];\)\), "\[IndentingNewLine]", 
    \(\(s5 = Cycles[{5, 14, 8, 16, 11, 17, 9}];\)\), "\[IndentingNewLine]", 
    \(\(s6 = Cycles[{6, 15, 10, 7, 18, 13, 12}];\)\)}], "Input"],

Cell[BoxData[{
    \(g1 = 
      TranslatePerm[
        Perm[{1, 3, 7, 5, 11, 2, 15, 4, 17, 6, 9, 12, 10, 8, 13, 16, 14, 
            18}], Cycles]; 
    g2 = TranslatePerm[
        Perm[{1, 18, 3, 16, 5, 2, 13, 4, 14, 7, 8, 12, 15, 17, 6, 9, 11, 
            10}], Cycles]; 
    g3 = TranslatePerm[
        Perm[{1, 2, 18, 4, 16, 7, 3, 17, 8, 15, 5, 12, 6, 11, 13, 9, 14, 
            10}], Cycles]; 
    g4 = TranslatePerm[
        Perm[{1, 2, 15, 8, 9, 18, 10, 4, 5, 6, 14, 12, 3, 11, 7, 17, 16, 
            13}], Cycles]; 
    g5 = TranslatePerm[
        Perm[{1, 2, 3, 16, 14, 6, 7, 17, 11, 10, 9, 12, 13, 5, 15, 4, 8, 
            18}], Cycles];\), "\[IndentingNewLine]", 
    \(g6 = 
      TranslatePerm[
        Perm[{1, 2, 3, 11, 14, 6, 7, 4, 8, 10, 16, 12, 13, 9, 15, 5, 17, 
            18}], Cycles]; 
    g7 = TranslatePerm[
        Perm[{1, 2, 3, 4, 17, 6, 7, 5, 11, 10, 8, 12, 13, 9, 15, 14, 16, 
            18}], Cycles]; 
    g8 = TranslatePerm[
        Perm[{1, 2, 3, 17, 8, 15, 18, 4, 16, 7, 11, 6, 12, 5, 10, 14, 9, 
            13}], Cycles]; 
    g9 = TranslatePerm[
        Perm[{1, 2, 3, 4, 14, 15, 18, 16, 5, 7, 17, 6, 12, 8, 10, 11, 9, 
            13}], Cycles];\)}], "Input"],

Cell[BoxData[{
    \(\(B = {1, 2, 3, 4, 5, 6};\)\), "\[IndentingNewLine]", 
    \(\(S = GenSet[s1, s2, s3, s4, s5, s6];\)\), "\[IndentingNewLine]", 
    \(\(SGS = StrongGenSet[B, S];\)\)}], "Input"],

Cell[BoxData[
    \(\($xPermRules = 
        Join[{Cycles[] \[Rule] "\<ID\>", b \[Rule] "\<b\>"}, 
          NameRules[s, 6, Cycles], NameRules[g, 9, Cycles]];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(508032\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[%]\)], "Input"],

Cell[BoxData[
    \({{2, 7}, {3, 4}, {7, 2}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[B, S, 18, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]6\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 6, ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 5, ", T=", 
        GenSet[ "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 4, ", T=", 
        GenSet[ "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 3, ", T=", 
        GenSet[ "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2", "s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 2, ", T=", 
        GenSet[ "s2", "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]230\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]508032\),
      SequenceForm[ 
      "Checked ", 230, " generators and obtained group of order ", 508032],
      Editable->False]], "Print"],

Cell[BoxData[
    \({1.7041059999999995`\ Second, 
      StrongGenSet[{1, 2, 3, 4, 5, 6}, 
        GenSet["s1", "s2", "s3", "s4", "s5", "s6"]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[{}, GenSet[a, b], 18, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", 
          "b"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "b"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1}, ", S=", 
        GenSet[ "s1", "b"], ", i=", 1, ", T=", 
        GenSet[ "s1", "b"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]"g1"\),
      SequenceForm[ "Appended S[[", 3, "]]=", "g1"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]2\),
      SequenceForm[ "Appended B[[", 2, "]]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", 
          "g1"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g1"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "b", "g1"], ", i=", 2, ", T=", 
        GenSet[ "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["g1"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2}, " and SGS ", 
        GenSet[ "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]"g2"\),
      SequenceForm[ "Appended S[[", 4, "]]=", "g2"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "g1", 
          "g2"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g2"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2"], ", i=", 2, ", T=", 
        GenSet[ "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]"g3"\),
      SequenceForm[ "Appended S[[", 5, "]]=", "g3"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]3\),
      SequenceForm[ "Appended B[[", 3, "]]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "g1", "g2", 
          "g3"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g3"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 3}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3"], ", i=", 3, ", T=", 
        GenSet[ "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["g3"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3}, " and SGS ", 
        GenSet[ "g3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]"s3"\),
      SequenceForm[ "Appended S[[", 6, "]]=", "s3"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "g1", "g2", "g3", 
          "s3"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 3}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3", "s3"], ", i=", 3, ", T=", 
        GenSet[ "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]7\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 5, 
            11, 9, 17, 14, 8}]\),
      SequenceForm[ "Appended S[[", 7, "]]=", 
        Cycles[ {4, 5, 11, 9, 17, 14, 8}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]4\),
      SequenceForm[ "Appended B[[", 4, "]]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "g1", 
          "g2", "g3", "s3", 
          Cycles[{4, 5, 11, 9, 17, 14, 
              8}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 5, 11, 9, 17, 14, 8}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{4, 5, 11, 9, 17, 14, 8}]]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {4}, " and SGS ", 
        GenSet[ 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]8\[InvisibleSpace]"]]="\[InvisibleSpace]"s4"\),
      SequenceForm[ "Appended S[[", 8, "]]=", "s4"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "g1", 
          "g2", "g3", "s3", Cycles[{4, 5, 11, 9, 17, 14, 8}], 
          "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s4"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4"], ", i=", 4, ", T=", 
        GenSet[ "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]9\[InvisibleSpace]"]]="\[InvisibleSpace]"s5"\),
      SequenceForm[ "Appended S[[", 9, "]]=", "s5"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]5\),
      SequenceForm[ "Appended B[[", 5, "]]=", 5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "g1", 
          "g2", "g3", "s3", Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", 
          "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s5"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5"], ", i=", 5, ", T=", 
        GenSet[ "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]5\
\[InvisibleSpace]") with base "\[InvisibleSpace]{5}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s5"]\),
      SequenceForm[ 
      "Finished check of H(", 5, ") with base ", {5}, " and SGS ", 
        GenSet[ "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4, 
          5}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5"]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {4, 5}, " and SGS ", 
        GenSet[ 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 4, 
          5}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["g3", "s3", 
          Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 4, 5}, " and SGS ", 
        GenSet[ "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 3, 4, 
          5}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["g1", "g2", 
          "g3", "s3", Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 3, 4, 5}, " and SGS ", 
        GenSet[ "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]10\[InvisibleSpace]"]]="\[InvisibleSpace]"s2"\),
      SequenceForm[ "Appended S[[", 10, "]]=", "s2"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "g1", 
          "g2", "g3", "s3", Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5", 
          "s2"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5", "s2"], ", i=", 2, 
        ", T=", 
        GenSet[ "s2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]11\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 17, 
            9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}]\),
      SequenceForm[ "Appended S[[", 11, "]]=", 
        Cycles[ {4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "g1", 
          "g2", "g3", "s3", Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5", 
          "s2", Cycles[{4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 
              12}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5", "s2", 
          Cycles[ {4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}]], 
        ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]12\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{5, 8, 
            11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}]\),
      SequenceForm[ "Appended S[[", 12, "]]=", 
        Cycles[ {5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 
          5}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "g1", 
          "g2", "g3", "s3", Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5", 
          "s2", Cycles[{4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[{5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 
              12}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]5\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5", "s2", 
          Cycles[ {4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[ {5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}]], 
        ", i=", 5, ", T=", 
        GenSet[ 
          Cycles[ {5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]13\[InvisibleSpace]"]]="\[InvisibleSpace]"s6"\),
      SequenceForm[ "Appended S[[", 13, "]]=", "s6"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]6\),
      SequenceForm[ "Appended B[[", 6, "]]=", 6],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "g1", 
          "g2", "g3", "s3", Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5", 
          "s2", Cycles[{4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[{5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]6\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5", "s2", 
          Cycles[ {4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[ {5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"], ", i=", 6, ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]6\
\[InvisibleSpace]") with base "\[InvisibleSpace]{6}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Finished check of H(", 6, ") with base ", {6}, " and SGS ", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]5\
\[InvisibleSpace]") with base "\[InvisibleSpace]{5, 
          6}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s5", 
          Cycles[{5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 5, ") with base ", {5, 6}, " and SGS ", 
        GenSet[ "s5", 
          Cycles[ {5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 4, 5, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "g1", 
          "g2", "g3", "s3", Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5", 
          "s2", Cycles[{4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[{5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet[
          Cycles[{4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 4, 5, 6}, ", S=", 
        GenSet[ "s1", "b", "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5", "s2", 
          Cycles[ {4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[ {5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"], ", i=", 3, ", T=", 
        GenSet[ 
          Cycles[ {4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 4, 5, 
          6}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["g3", "s3", 
          Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5", 
          Cycles[{4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[{5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 4, 5, 6}, " and SGS ", 
        GenSet[ "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5", 
          Cycles[ {4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[ {5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 3, 4, 5, 
          6}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["g1", "g2", 
          "g3", "s3", Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5", "s2", 
          Cycles[{4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[{5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 3, 4, 5, 6}, " and SGS ",
         
        GenSet[ "g1", "g2", "g3", "s3", 
          Cycles[ {4, 5, 11, 9, 17, 14, 8}], "s4", "s5", "s2", 
          Cycles[ {4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[ {5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]135\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]508032\),
      SequenceForm[ 
      "Checked ", 135, " generators and obtained group of order ", 508032],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0.824050999999999`\ Second, 
      StrongGenSet[{1, 2, 3, 4, 5, 6}, 
        GenSet["s1", "b", "g1", "g2", "g3", "s3", 
          Cycles[{4, 5, 11, 9, 17, 14, 8}], "s4", "s5", "s2", 
          Cycles[{4, 17, 9, 16, 14, 5, 8}, {6, 15, 10, 7, 18, 13, 12}], 
          Cycles[{5, 8, 11, 9, 14, 16, 17}, {6, 15, 10, 7, 18, 13, 12}], 
          "s6"]]}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 9", "Section"],

Cell["Example in page 86 of Butler.", "Text"],

Cell[BoxData[
    \(\(a = 
        Cycles[{1, 15, 7, 5, 12}, {2, 9, 13, 14, 8}, {3, 6, 10, 11, 
            4}];\)\)], "Input"],

Cell[BoxData[
    \(\(b = 
        Cycles[{1, 7}, {2, 11}, {3, 12}, {4, 13}, {5, 10}, {8, 
            14}];\)\)], "Input"],

Cell[BoxData[
    \(\(c = 
        Cycles[{1, 16}, {2, 3}, {4, 5}, {6, 7}, {8, 9}, {10, 11}, {12, 
            13}, {14, 15}];\)\)], "Input"],

Cell[BoxData[{
    \(\(s1 = a;\)\), "\[IndentingNewLine]", 
    \(\(s2 = 
        Cycles[{2, 4, 6}, {3, 5, 7}, {8, 9}, {10, 13, 14, 11, 12, 
            15}];\)\), "\[IndentingNewLine]", 
    \(\(s3 = 
        Cycles[{8, 9}, {10, 11}, {12, 13}, {14, 
            15}];\)\), "\[IndentingNewLine]", 
    \(\(s4 = 
        Cycles[{3, 12, 14}, {4, 10, 6, 7, 9, 5}, {8, 11}, {13, 16, 
            15}];\)\), "\[IndentingNewLine]", 
    \(\(s5 = 
        Cycles[{3, 12, 14}, {4, 9, 6}, {5, 7, 10}, {13, 16, 
            15}];\)\), "\[IndentingNewLine]", 
    \(\(s6 = Cycles[{4, 6}, {5, 7}, {12, 14}, {13, 15}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(g1 = 
        TranslatePerm[
          Perm[{1, 2, 3, 5, 4, 7, 6, 10, 11, 8, 9, 15, 14, 13, 12, 16}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g2 = 
        TranslatePerm[
          Perm[{1, 5, 9, 6, 10, 14, 2, 3, 15, 11, 7, 8, 4, 16, 12, 13}], 
          Cycles];\)\), "\[IndentingNewLine]", 
    \(\(g3 = 
        TranslatePerm[
          Perm[{1, 2, 15, 8, 5, 6, 11, 4, 9, 10, 7, 16, 13, 14, 3, 12}], 
          Cycles];\)\)}], "Input"],

Cell[BoxData[{
    \(\(B = {1, 2, 8, 3, 4};\)\), "\[IndentingNewLine]", 
    \(\(S = GenSet[s1, s2, s3, s4, s5, s6];\)\), "\[IndentingNewLine]", 
    \(\(SGS = StrongGenSet[B, S];\)\)}], "Input"],

Cell[BoxData[
    \(\($xPermRules = 
        Join[{Cycles[] \[Rule] "\<ID\>", b \[Rule] "\<b\>", 
            c \[Rule] "\<c\>"}, NameRules[s, 6, Cycles], 
          NameRules[g, 3, Cycles]];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(11520\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[%]\)], "Input"],

Cell[BoxData[
    \({{2, 8}, {3, 2}, {5, 1}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[B, S, 16, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 8, 3, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 5, ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 8, 3, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 4, ", T=", 
        GenSet[ "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 8, 3, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 3, ", T=", 
        GenSet[ "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2", "s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 8, 3, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 2, ", T=", 
        GenSet[ "s2", "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 8, 3, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]211\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]11520\),
      SequenceForm[ 
      "Checked ", 211, " generators and obtained group of order ", 11520],
      Editable->False]], "Print"],

Cell[BoxData[
    \({1.1720729999999993`\ Second, 
      StrongGenSet[{1, 2, 8, 3, 4}, 
        GenSet["s1", "s2", "s3", "s4", "s5", "s6"]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[{}, GenSet[a, b, c], 16, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", 
          "b", "c"]\[InvisibleSpace]", \
i="\[InvisibleSpace]1\[InvisibleSpace]", T="\[InvisibleSpace]GenSet["s1", 
          "b", "c"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1}, ", S=", 
        GenSet[ "s1", "b", "c"], ", i=", 1, ", T=", 
        GenSet[ "s1", "b", "c"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]"s2"\),
      SequenceForm[ "Appended S[[", 4, "]]=", "s2"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]2\),
      SequenceForm[ "Appended B[[", 2, "]]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "c", 
          "s2"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "s1", "b", "c", "s2"], ", i=", 2, ", T=", 
        GenSet[ "s2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]"s3"\),
      SequenceForm[ "Appended S[[", 5, "]]=", "s3"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]8\),
      SequenceForm[ "Appended B[[", 3, "]]=", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "c", "s2", 
          "s3"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 8}, ", S=", 
        GenSet[ "s1", "b", "c", "s2", "s3"], ", i=", 3, ", T=", 
        GenSet[ "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{8}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s3"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {8}, " and SGS ", 
        GenSet[ "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 
          8}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s2", "s3"]\),
      
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 8}, " and SGS ", 
        GenSet[ "s2", "s3"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]"g1"\),
      SequenceForm[ "Appended S[[", 6, "]]=", "g1"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "c", "s2", "s3", 
          "g1"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g1"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 8}, ", S=", 
        GenSet[ "s1", "b", "c", "s2", "s3", "g1"], ", i=", 3, ", T=", 
        GenSet[ "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "c", "s2", "s3", 
          "g1"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g1"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 8}, ", S=", 
        GenSet[ "s1", "b", "c", "s2", "s3", "g1"], ", i=", 2, ", T=", 
        GenSet[ "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 
          8}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s2", "s3", 
          "g1"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 8}, " and SGS ", 
        GenSet[ "s2", "s3", "g1"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]7\[InvisibleSpace]"]]="\[InvisibleSpace]"g2"\),
      SequenceForm[ "Appended S[[", 7, "]]=", "g2"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "c", "s2", "s3", "g1", 
          "g2"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["g2"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 8}, ", S=", 
        GenSet[ "s1", "b", "c", "s2", "s3", "g1", "g2"], ", i=", 2, ", T=", 
        GenSet[ "g2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]8\[InvisibleSpace]"]]="\[InvisibleSpace]"s4"\),
      SequenceForm[ "Appended S[[", 8, "]]=", "s4"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "b", "c", "s2", "s3", "g1", "g2", 
          "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s4"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 8}, ", S=", 
        GenSet[ "s1", "b", "c", "s2", "s3", "g1", "g2", "s4"], ", i=", 3, 
        ", T=", 
        GenSet[ "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]9\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{3, 
            14}, {4, 9}, {7, 10}, {13, 16}]\),
      SequenceForm[ "Appended S[[", 9, "]]=", 
        Cycles[ {3, 14}, {4, 9}, {7, 10}, {13, 16}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]3\),
      SequenceForm[ "Appended B[[", 4, "]]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8, 
          3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "c", 
          "s2", "s3", "g1", "g2", "s4", 
          Cycles[{3, 14}, {4, 9}, {7, 10}, {13, 
              16}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{3, 14}, {4, 9}, {7, 10}, {13, 16}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 8, 3}, ", S=", 
        GenSet[ "s1", "b", "c", "s2", "s3", "g1", "g2", "s4", 
          Cycles[ {3, 14}, {4, 9}, {7, 10}, {13, 16}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {3, 14}, {4, 9}, {7, 10}, {13, 16}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{3, 14}, {4, 9}, {7, 10}, {13, 16}]]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {3}, " and SGS ", 
        GenSet[ 
          Cycles[ {3, 14}, {4, 9}, {7, 10}, {13, 16}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]10\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{3, 
            12}, {5, 10}, {6, 9}, {15, 16}]\),
      SequenceForm[ "Appended S[[", 10, "]]=", 
        Cycles[ {3, 12}, {5, 10}, {6, 9}, {15, 16}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8, 
          3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "c", 
          "s2", "s3", "g1", "g2", "s4", 
          Cycles[{3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[{3, 12}, {5, 10}, {6, 9}, {15, 
              16}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{3, 12}, {5, 10}, {6, 9}, {15, 16}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 8, 3}, ", S=", 
        GenSet[ "s1", "b", "c", "s2", "s3", "g1", "g2", "s4", 
          Cycles[ {3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[ {3, 12}, {5, 10}, {6, 9}, {15, 16}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {3, 12}, {5, 10}, {6, 9}, {15, 16}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]11\[InvisibleSpace]"]]="\[InvisibleSpace]"s6"\),
      SequenceForm[ "Appended S[[", 11, "]]=", "s6"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]4\),
      SequenceForm[ "Appended B[[", 5, "]]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 8, 3, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "b", "c", 
          "s2", "s3", "g1", "g2", "s4", 
          Cycles[{3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[{3, 12}, {5, 10}, {6, 9}, {15, 16}], 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 8, 3, 4}, ", S=", 
        GenSet[ "s1", "b", "c", "s2", "s3", "g1", "g2", "s4", 
          Cycles[ {3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[ {3, 12}, {5, 10}, {6, 9}, {15, 16}], "s6"], ", i=", 5, 
        ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]5\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Finished check of H(", 5, ") with base ", {4}, " and SGS ", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[{3, 12}, {5, 10}, {6, 9}, {15, 16}], "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {3, 4}, " and SGS ", 
        GenSet[ 
          Cycles[ {3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[ {3, 12}, {5, 10}, {6, 9}, {15, 16}], "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{8, 3, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s3", "g1", 
          "s4", Cycles[{3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[{3, 12}, {5, 10}, {6, 9}, {15, 16}], "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {8, 3, 4}, " and SGS ", 
        GenSet[ "s3", "g1", "s4", 
          Cycles[ {3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[ {3, 12}, {5, 10}, {6, 9}, {15, 16}], "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 8, 3, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s2", "s3", 
          "g1", "g2", "s4", Cycles[{3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[{3, 12}, {5, 10}, {6, 9}, {15, 16}], "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 8, 3, 4}, " and SGS ", 
        GenSet[ "s2", "s3", "g1", "g2", "s4", 
          Cycles[ {3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[ {3, 12}, {5, 10}, {6, 9}, {15, 16}], "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]137\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]11520\),
      SequenceForm[ 
      "Checked ", 137, " generators and obtained group of order ", 11520],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0.7480469999999997`\ Second, 
      StrongGenSet[{1, 2, 8, 3, 4}, 
        GenSet["s1", "b", "c", "s2", "s3", "g1", "g2", "s4", 
          Cycles[{3, 14}, {4, 9}, {7, 10}, {13, 16}], 
          Cycles[{3, 12}, {5, 10}, {6, 9}, {15, 16}], "s6"]]}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 10", "Section"],

Cell["Example in page 86 of Butler.", "Text"],

Cell[BoxData[
    \(\(a = 
        Cycles[{4, 5}, {6, 8}, {7, 9}, {10, 12}, {13, 16}, {15, 19}, {18, 
            22}, {20, 24}, {23, 27}, {25, 29}, {26, 30}, {28, 
            31}];\)\)], "Input"],

Cell[BoxData[
    \(\(b = 
        Cycles[{1, 2, 3, 4, 6}, {5, 7, 10, 13, 17}, {8, 11, 14, 18, 23}, {9, 
            12, 15, 20, 25}, {16, 21, 22, 26, 29}, {19, 24, 28, 31, 
            27}];\)\)], "Input"],

Cell[BoxData[{
    \(\(s1 = b;\)\), "\[IndentingNewLine]", 
    \(\(s2 = 
        Cycles[{2, 13}, {3, 18}, {5, 25}, {7, 26}, {9, 31}, {11, 16}, {12, 
            27}, {14, 28}, {15, 22}, {17, 20}, {19, 24}, {21, 
            30}];\)\), "\[IndentingNewLine]", 
    \(\(s3 = 
        Cycles[{1, 8}, {3, 30, 7, 24}, {9, 28, 17, 22}, {10, 29}, {11, 
            16}, {12, 27}, {14, 31, 15, 20}, {18, 19, 26, 
            21}];\)\), "\[IndentingNewLine]", 
    \(\(s4 = 
        Cycles[{1, 29}, {8, 10}, {9, 20}, {11, 27}, {12, 16}, {17, 31}, {19, 
            24}, {21, 30}];\)\), "\[IndentingNewLine]", 
    \(\(s5 = 
        Cycles[{6, 8}, {7, 9}, {13, 16}, {15, 19}, {23, 29}, {25, 27}, {26, 
            31}, {28, 30}];\)\), "\[IndentingNewLine]", 
    \(\(s6 = 
        Cycles[{6, 29}, {7, 31}, {8, 23}, {9, 26}, {13, 27}, {15, 30}, {16, 
            25}, {19, 28}];\)\), "\[IndentingNewLine]", 
    \(\(s7 = 
        Cycles[{6, 16}, {7, 19}, {8, 13}, {9, 15}, {23, 27}, {25, 29}, {26, 
            30}, {28, 31}];\)\), "\[IndentingNewLine]", 
    \(\(s8 = 
        Cycles[{6, 19}, {7, 16}, {8, 15}, {9, 13}, {23, 30}, {25, 31}, {26, 
            27}, {28, 29}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(B = {4, 2, 3, 1, 6};\)\), "\[IndentingNewLine]", 
    \(\(S = 
        GenSet[s1, s2, s3, s4, s5, s6, s7, s8];\)\), "\[IndentingNewLine]", 
    \(\(SGS = StrongGenSet[B, S];\)\)}], "Input"],

Cell[BoxData[
    \(\($xPermRules = 
        Join[{Cycles[] \[Rule] "\<ID\>", a \[Rule] "\<a\>"}, 
          NameRules[s, 8, Cycles]];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[SGS]\)], "Input"],

Cell[BoxData[
    \(9999360\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[%]\)], "Input"],

Cell[BoxData[
    \({{2, 10}, {3, 2}, {5, 1}, {7, 1}, {31, 1}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      SchreierSims[B, S, 31, xPermVerbose \[Rule] True, 
        UseRules \[Rule] $xPermRules]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{4, 2, 3, 1, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", "s7", 
          "s8"]\[InvisibleSpace]", i="\[InvisibleSpace]5\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s5", "s6", "s7", "s8"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {4, 2, 3, 1, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8"], ", i=", 5, 
        ", T=", 
        GenSet[ "s5", "s6", "s7", "s8"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{4, 2, 3, 1, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", "s7", 
          "s8"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s4", "s5", "s6", "s7", "s8"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {4, 2, 3, 1, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8"], ", i=", 4, 
        ", T=", 
        GenSet[ "s4", "s5", "s6", "s7", "s8"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{4, 2, 3, 1, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", "s7", 
          "s8"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3", "s4", "s5", "s6", "s7", "s8"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {4, 2, 3, 1, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8"], ", i=", 3, 
        ", T=", 
        GenSet[ "s3", "s4", "s5", "s6", "s7", "s8"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{4, 2, 3, 1, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", "s7", 
          "s8"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2", "s3", "s4", "s5", "s6", "s7", "s8"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {4, 2, 3, 1, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8"], ", i=", 2, 
        ", T=", 
        GenSet[ "s2", "s3", "s4", "s5", "s6", "s7", "s8"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{4, 2, 3, 1, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", "s6", "s7", 
          "s8"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {4, 2, 3, 1, 6}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8"], ", i=", 1, 
        ", T=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]810\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]9999360\),
      SequenceForm[ 
      "Checked ", 810, " generators and obtained group of order ", 9999360],
      Editable->False]], "Print"],

Cell[BoxData[
    \({14.07688`\ Second, 
      StrongGenSet[{4, 2, 3, 1, 6}, 
        GenSet["s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8"]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[SchreierSims[{}, GenSet[a, b], 31]]\)], "Input"],

Cell[BoxData[
    \({6.952435000000001`\ Second, 
      StrongGenSet[{4, 2, 3, 1, 6}, 
        GenSet["a", "s1", "s2", 
          Cycles[{2, 16}, {3, 28, 9, 24}, {5, 27}, {7, 22, 17, 30}, {11, 
              13}, {12, 25}, {14, 20, 19, 26}, {15, 31, 21, 18}], 
          Cycles[{3, 7}, {9, 17}, {14, 15}, {18, 26}, {19, 21}, {20, 
              31}, {22, 28}, {24, 30}], 
          Cycles[{3, 9}, {7, 17}, {14, 19}, {15, 21}, {18, 31}, {20, 
              26}, {22, 30}, {24, 28}], 
          Cycles[{1, 10}, {2, 14}, {5, 22}, {8, 29}, {9, 31}, {11, 24}, {12, 
              21}, {13, 15}, {16, 30}, {17, 20}, {19, 27}, {25, 28}], 
          Cycles[{3, 26}, {7, 18}, {9, 20}, {14, 28}, {15, 22}, {17, 
              31}, {19, 24}, {21, 30}], 
          Cycles[{3, 15}, {7, 14}, {9, 21}, {17, 19}, {18, 28}, {20, 
              30}, {22, 26}, {24, 31}], 
          Cycles[{1, 10}, {3, 19, 18, 30}, {7, 21, 26, 24}, {8, 29}, {9, 22, 
              31, 14}, {11, 12}, {15, 17, 28, 20}, {16, 27}], 
          Cycles[{1, 10}, {8, 29}, {9, 31}, {11, 12}, {16, 27}, {17, 
              20}, {19, 30}, {21, 24}], 
          Cycles[{1, 29}, {2, 21}, {3, 26}, {5, 24}, {7, 18}, {8, 10}, {11, 
              28}, {12, 15}, {13, 19}, {14, 27}, {16, 22}, {25, 30}], 
          Cycles[{1, 8}, {3, 24, 7, 30}, {9, 22, 17, 28}, {10, 29}, {11, 
              16}, {12, 27}, {14, 20, 15, 31}, {18, 21, 26, 19}], "s4", 
          Cycles[{1, 11}, {6, 7}, {8, 19}, {9, 16}, {10, 12}, {13, 15}, {17, 
              21}, {20, 24}, {23, 26}, {25, 28}, {27, 31}, {29, 30}], 
          Cycles[{1, 28, 12, 7}, {6, 17, 25, 24}, {8, 27}, {9, 30}, {10, 15, 
              11, 26}, {13, 21, 23, 20}, {16, 29}, {19, 31}], "s7", 
          Cycles[{6, 23}, {7, 26}, {8, 29}, {9, 31}, {13, 25}, {15, 28}, {16, 
              27}, {19, 30}], "s8", 
          Cycles[{6, 28}, {7, 25}, {8, 30}, {9, 27}, {13, 26}, {15, 23}, {16, 
              31}, {19, 29}]]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[Last[%], MathLink \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(9999360\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 11. Symmetries of the square. Signatures", "Section"],

Cell[BoxData[
    \(\(a = Cycles[{1, 2, 3, 4}, {5, 6}];\)\)], "Input"],

Cell[BoxData[
    \(\(b = Cycles[{2, 4}, {5, 6}];\)\)], "Input"],

Cell[BoxData[
    \(\($xPermRules = {Cycles[] \[Rule] "\<ID\>", a \[Rule] "\<a\>", 
          b \[Rule] "\<b\>"};\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimino[GenSet[a, b]]\)], "Input"],

Cell[BoxData[
    \(Group["ID", "a", Cycles[{1, 3}, {2, 4}], Cycles[{1, 4, 3, 2}, {5, 6}], 
      "b", Cycles[{1, 4}, {2, 3}], Cycles[{1, 3}, {5, 6}], 
      Cycles[{1, 2}, {3, 4}]]\)], "Output"]
}, Open  ]],

Cell["We can test membership in G=G^(1):", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[ID, StrongGenSet[{1, 2}, GenSet[a, b]]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[{5, 6}], 
      StrongGenSet[{1, 2}, GenSet[a, b]]]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Permute[a, b], 
      StrongGenSet[{1, 2}, GenSet[a, b]]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[{1, 2}], 
      StrongGenSet[{1, 2}, GenSet[a, b]]]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell["And membership in G^(2):", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Stabilizer[{1}, GenSet[a, b]] \[Equal] GenSet[b]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[a, StrongGenSet[{4}, GenSet[b]]]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[b, StrongGenSet[{4}, GenSet[b]]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[ID, StrongGenSet[{4}, GenSet[b]]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["And membership in G^(3):", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[ID, StrongGenSet[{}, GenSet[]]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["Construction of the pair (base,SGS) from scratch:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[{1}, GenSet[a, b], xPermVerbose \[Rule] True, 
      UseRules \[Rule] $xPermRules]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["a", 
          "b"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["b"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "a", "b"], ", i=", 2, ", T=", 
        GenSet[ "b"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["a", 
          "b"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["a", "b"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ "a", "b"], ", i=", 1, ", T=", 
        GenSet[ "a", "b"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]10\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]8\),
      SequenceForm[ 
      "Checked ", 10, " generators and obtained group of order ", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1, 2}, GenSet["a", "b"]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[StrongGenSet[{1, 2}, GenSet[a, b]]]\)], "Input"],

Cell[BoxData[
    \(8\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 11b", "Section"],

Cell["With positive signature:", "Text"],

Cell[BoxData[
    \(\(a = Cycles[{1, 2, 3}];\)\)], "Input"],

Cell["Construction of the pair (base,SGS) from scratch:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[{1}, GenSet[a], xPermVerbose \[Rule] True]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 
              3}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]1\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 3}]], ", i=", 1, ", T=", 
        GenSet[ 
          Cycles[ {1, 2, 3}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]3\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]3\),
      SequenceForm[ 
      "Checked ", 3, " generators and obtained group of order ", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1}, GenSet[Cycles[{1, 2, 3}]]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimino[GenSet[a]]\)], "Input"],

Cell[BoxData[
    \(Group["ID", Cycles[{1, 2, 3}], Cycles[{1, 3, 2}]]\)], "Output"]
}, Open  ]],

Cell["With negative signature:", "Text"],

Cell[BoxData[
    \(\(a = Cycles[{1, 2, 3}, {4, 5}];\)\)], "Input"],

Cell["Construction of the pair (base,SGS) from scratch:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[{1}, GenSet[a], xPermVerbose \[Rule] True]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3}, {4, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]1\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3}, {4, 5}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 3}, {4, 5}]], ", i=", 1, ", T=", 
        GenSet[ 
          Cycles[ {1, 2, 3}, {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 5}]\),
      
      SequenceForm[ "Appended S[[", 2, "]]=", 
        Cycles[ {4, 5}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]4\),
      SequenceForm[ "Appended B[[", 2, "]]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3}, {4, 5}], 
          Cycles[{4, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 5}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 4}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 3}, {4, 5}], 
          Cycles[ {4, 5}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{4, 5}]]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {4}, " and SGS ", 
        GenSet[ 
          Cycles[ {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]5\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]6\),
      SequenceForm[ 
      "Checked ", 5, " generators and obtained group of order ", 6],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1, 4}, 
      GenSet[Cycles[{1, 2, 3}, {4, 5}], Cycles[{4, 5}]]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimino[GenSet[a]]\)], "Input"],

Cell[BoxData[
    \(Group["ID", Cycles[{1, 2, 3}, {4, 5}], Cycles[{1, 3, 2}], 
      Cycles[{4, 5}], Cycles[{1, 2, 3}], 
      Cycles[{1, 3, 2}, {4, 5}]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[{4}, GenSet[a], xPermVerbose \[Rule] True]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3}, {4, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]1\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3}, {4, 5}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {4}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 3}, {4, 5}]], ", i=", 1, ", T=", 
        GenSet[ 
          Cycles[ {1, 2, 3}, {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{1, 3, 
            2}]\),
      SequenceForm[ "Appended S[[", 2, "]]=", 
        Cycles[ {1, 3, 2}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]1\),
      SequenceForm[ "Appended B[[", 2, "]]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{4, 1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2, 3}, {4, 5}], 
          Cycles[{1, 3, 
              2}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 3, 2}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {4, 1}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2, 3}, {4, 5}], 
          Cycles[ {1, 3, 2}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {1, 3, 2}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{1}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{1, 3, 2}]]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {1}, " and SGS ", 
        GenSet[ 
          Cycles[ {1, 3, 2}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]5\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]6\),
      SequenceForm[ 
      "Checked ", 5, " generators and obtained group of order ", 6],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{4, 1}, 
      GenSet[Cycles[{1, 2, 3}, {4, 5}], Cycles[{1, 3, 2}]]]\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 12. Projective plane of order 2. Signatures", "Section"],

Cell["We assign negative signature to our generators:", "Text"],

Cell[BoxData[
    \(\(a = Cycles[{1, 2, 4, 5, 7, 3, 6}, {8, 9}];\)\)], "Input"],

Cell[BoxData[
    \(\(b = Cycles[{2, 4}, {3, 5}, {8, 9}];\)\)], "Input"],

Cell["Now there are two orbits, rather than just one:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orbits[GenSet[a, b]]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 4, 5, 7, 3, 6}, {8, 9}}\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(\(s1 = a;\)\), "\[IndentingNewLine]", 
    \(\(s2 = b;\)\), "\[IndentingNewLine]", 
    \(\(s3 = Cycles[{4, 5}, {6, 7}, {8, 9}];\)\), "\[IndentingNewLine]", 
    \(\(s4 = Cycles[{4, 6}, {5, 7}, {8, 9}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(s5 = Cycles[{4, 7}, {5, 6}, {8, 9}];\)\), "\[IndentingNewLine]", 
    \(\(s6 = Cycles[{8, 9}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(B = {1, 2, 4};\)\), "\[IndentingNewLine]", 
    \(\(S = GenSet[s1, s2, s3, s4];\)\), "\[IndentingNewLine]", 
    \(\(BB = {1, 2, 4, 8};\)\), "\[IndentingNewLine]", 
    \(\(SS = GenSet[s1, s2, s3, s4, s5, s6];\)\)}], "Input"],

Cell["Order of group:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[StrongGenSet[B, S]]\)], "Input"],

Cell[BoxData[
    \(168\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[Dimino[S]]\)], "Input"],

Cell[BoxData[
    \(336\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfGroup[StrongGenSet[BB, SS]]\)], "Input"],

Cell[BoxData[
    \(336\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\($xPermRules = 
        Join[{ID[a] \[Rule] "\<ID\>"}, NameRules[s, 6, Cycles]];\)\)], "Input"],

Cell["We know check the SGS:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[B, S, xPermVerbose \[Rule] True, 
      UseRules \[Rule] $xPermRules]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "s3", 
          "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s3", "s4"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4"], ", i=", 3, ", T=", 
        GenSet[ "s3", "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "s3", 
          "s4"]\[InvisibleSpace]", i="\[InvisibleSpace]2\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s2", "s3", "s4"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4"], ", i=", 2, ", T=", 
        GenSet[ "s2", "s3", "s4"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]"s5"\),
      SequenceForm[ "Appended S[[", 5, "]]=", "s5"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", "s3", "s4", 
          "s5"]\[InvisibleSpace]", i="\[InvisibleSpace]3\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s5"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5"], ", i=", 3, ", T=", 
        GenSet[ "s5"]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]"s6"\),
      SequenceForm[ "Appended S[[", 6, "]]=", "s6"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]8\),
      SequenceForm[ "Appended B[[", 4, "]]=", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4, 
          8}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]4\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 4, 8}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 4, ", T=", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{8}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet["s6"]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {8}, " and SGS ", 
        GenSet[ "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4, 
          8}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet["s3", "s4", 
          "s5", "s6"]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {4, 8}, " and SGS ", 
        GenSet[ "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 4, 
          8}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", "s3", 
          "s4", "s5", 
          "s6"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "s2", "s3", "s4", "s5", "s6"]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 4, 8}, ", S=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2", "s3", "s4", "s5", "s6"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]74\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]336\),
      SequenceForm[ 
      "Checked ", 74, " generators and obtained group of order ", 336],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1, 2, 4, 8}, 
      GenSet["s1", "s2", "s3", "s4", "s5", "s6"]]\)], "Output"]
}, Open  ]],

Cell["And generate new SGS:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[{8}, GenSet[a, b], xPermVerbose \[Rule] True, 
      UseRules \[Rule] $xPermRules]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{8}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", 
          "s2"]\[InvisibleSpace]", i="\[InvisibleSpace]1\[InvisibleSpace]", \
T="\[InvisibleSpace]GenSet["s1", "s2"]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {8}, ", S=", 
        GenSet[ "s1", "s2"], ", i=", 1, ", T=", 
        GenSet[ "s1", "s2"]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{1, 6, 3, 
            4}, {5, 7}]\),
      SequenceForm[ "Appended S[[", 3, "]]=", 
        Cycles[ {1, 6, 3, 4}, {5, 7}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]1\),
      SequenceForm[ "Appended B[[", 2, "]]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{8, 1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", 
          Cycles[{1, 6, 3, 4}, {5, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 6, 3, 4}, {5, 7}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {8, 1}, ", S=", 
        GenSet[ "s1", "s2", 
          Cycles[ {1, 6, 3, 4}, {5, 7}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {1, 6, 3, 4}, {5, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{1}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{1, 6, 3, 4}, {5, 7}]]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {1}, " and SGS ", 
        GenSet[ 
          Cycles[ {1, 6, 3, 4}, {5, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{1, 4, 7, 
            6, 2, 5, 3}]\),
      SequenceForm[ "Appended S[[", 4, "]]=", 
        Cycles[ {1, 4, 7, 6, 2, 5, 3}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{8, 1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", Cycles[{1, 6, 3, 4}, {5, 7}], 
          Cycles[{1, 4, 7, 6, 2, 5, 
              3}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 4, 7, 6, 2, 5, 3}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {8, 1}, ", S=", 
        GenSet[ "s1", "s2", 
          Cycles[ {1, 6, 3, 4}, {5, 7}], 
          Cycles[ {1, 4, 7, 6, 2, 5, 3}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {1, 4, 7, 6, 2, 5, 3}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{2, 7, 3, 
            6}, {4, 5}]\),
      SequenceForm[ "Appended S[[", 5, "]]=", 
        Cycles[ {2, 7, 3, 6}, {4, 5}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]2\),
      SequenceForm[ "Appended B[[", 3, "]]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{8, 1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", Cycles[{1, 6, 3, 4}, {5, 7}], 
          Cycles[{1, 4, 7, 6, 2, 5, 3}], 
          Cycles[{2, 7, 3, 6}, {4, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]3\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{2, 7, 3, 6}, {4, 5}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {8, 1, 2}, ", S=", 
        GenSet[ "s1", "s2", 
          Cycles[ {1, 6, 3, 4}, {5, 7}], 
          Cycles[ {1, 4, 7, 6, 2, 5, 3}], 
          Cycles[ {2, 7, 3, 6}, {4, 5}]], ", i=", 3, ", T=", 
        GenSet[ 
          Cycles[ {2, 7, 3, 6}, {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{2, 7, 3, 6}, {4, 5}]]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {2}, " and SGS ", 
        GenSet[ 
          Cycles[ {2, 7, 3, 6}, {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{2, 5, 3, 
            4}, {6, 7}]\),
      SequenceForm[ "Appended S[[", 6, "]]=", 
        Cycles[ {2, 5, 3, 4}, {6, 7}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{8, 1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          "s1", "s2", Cycles[{1, 6, 3, 4}, {5, 7}], 
          Cycles[{1, 4, 7, 6, 2, 5, 3}], Cycles[{2, 7, 3, 6}, {4, 5}], 
          Cycles[{2, 5, 3, 4}, {6, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]3\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{2, 5, 3, 4}, {6, 7}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {8, 1, 2}, ", S=", 
        GenSet[ "s1", "s2", 
          Cycles[ {1, 6, 3, 4}, {5, 7}], 
          Cycles[ {1, 4, 7, 6, 2, 5, 3}], 
          Cycles[ {2, 7, 3, 6}, {4, 5}], 
          Cycles[ {2, 5, 3, 4}, {6, 7}]], ", i=", 3, ", T=", 
        GenSet[ 
          Cycles[ {2, 5, 3, 4}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]7\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 
            6}, {5, 7}]\),
      SequenceForm[ "Appended S[[", 7, "]]=", 
        Cycles[ {4, 6}, {5, 7}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]4\),
      SequenceForm[ "Appended B[[", 4, "]]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{8, 1, 2, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", 
          Cycles[{1, 6, 3, 4}, {5, 7}], Cycles[{1, 4, 7, 6, 2, 5, 3}], 
          Cycles[{2, 7, 3, 6}, {4, 5}], Cycles[{2, 5, 3, 4}, {6, 7}], 
          Cycles[{4, 6}, {5, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 6}, {5, 7}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {8, 1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", 
          Cycles[ {1, 6, 3, 4}, {5, 7}], 
          Cycles[ {1, 4, 7, 6, 2, 5, 3}], 
          Cycles[ {2, 7, 3, 6}, {4, 5}], 
          Cycles[ {2, 5, 3, 4}, {6, 7}], 
          Cycles[ {4, 6}, {5, 7}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {4, 6}, {5, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{4, 6}, {5, 7}]]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {4}, " and SGS ", 
        GenSet[ 
          Cycles[ {4, 6}, {5, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]8\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 
            5}, {6, 7}]\),
      SequenceForm[ "Appended S[[", 8, "]]=", 
        Cycles[ {4, 5}, {6, 7}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{8, 1, 2, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet["s1", "s2", 
          Cycles[{1, 6, 3, 4}, {5, 7}], Cycles[{1, 4, 7, 6, 2, 5, 3}], 
          Cycles[{2, 7, 3, 6}, {4, 5}], Cycles[{2, 5, 3, 4}, {6, 7}], 
          Cycles[{4, 6}, {5, 7}], 
          Cycles[{4, 5}, {6, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 5}, {6, 7}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {8, 1, 2, 4}, ", S=", 
        GenSet[ "s1", "s2", 
          Cycles[ {1, 6, 3, 4}, {5, 7}], 
          Cycles[ {1, 4, 7, 6, 2, 5, 3}], 
          Cycles[ {2, 7, 3, 6}, {4, 5}], 
          Cycles[ {2, 5, 3, 4}, {6, 7}], 
          Cycles[ {4, 6}, {5, 7}], 
          Cycles[ {4, 5}, {6, 7}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {4, 5}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{4, 6}, {5, 7}], Cycles[{4, 5}, {6, 7}]]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {4}, " and SGS ", 
        GenSet[ 
          Cycles[ {4, 6}, {5, 7}], 
          Cycles[ {4, 5}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{2, 7, 3, 6}, {4, 5}], Cycles[{2, 5, 3, 4}, {6, 7}], 
          Cycles[{4, 6}, {5, 7}], Cycles[{4, 5}, {6, 7}]]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {2, 4}, " and SGS ", 
        GenSet[ 
          Cycles[ {2, 7, 3, 6}, {4, 5}], 
          Cycles[ {2, 5, 3, 4}, {6, 7}], 
          Cycles[ {4, 6}, {5, 7}], 
          Cycles[ {4, 5}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{1, 2, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{1, 6, 3, 4}, {5, 7}], Cycles[{1, 4, 7, 6, 2, 5, 3}], 
          Cycles[{2, 7, 3, 6}, {4, 5}], Cycles[{2, 5, 3, 4}, {6, 7}], 
          Cycles[{4, 6}, {5, 7}], Cycles[{4, 5}, {6, 7}]]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {1, 2, 4}, " and SGS ", 
        GenSet[ 
          Cycles[ {1, 6, 3, 4}, {5, 7}], 
          Cycles[ {1, 4, 7, 6, 2, 5, 3}], 
          Cycles[ {2, 7, 3, 6}, {4, 5}], 
          Cycles[ {2, 5, 3, 4}, {6, 7}], 
          Cycles[ {4, 6}, {5, 7}], 
          Cycles[ {4, 5}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]38\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]336\),
      SequenceForm[ 
      "Checked ", 38, " generators and obtained group of order ", 336],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{8, 1, 2, 4}, 
      GenSet["s1", "s2", Cycles[{1, 6, 3, 4}, {5, 7}], 
        Cycles[{1, 4, 7, 6, 2, 5, 3}], Cycles[{2, 7, 3, 6}, {4, 5}], 
        Cycles[{2, 5, 3, 4}, {6, 7}], Cycles[{4, 6}, {5, 7}], 
        Cycles[{4, 5}, {6, 7}]]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[], StrongGenSet[BB, SS]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[{8, 9}], StrongGenSet[BB, SS]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 13. Riemann", "Section"],

Cell[BoxData[{
    \(\(a = Cycles[{1, 2}, {5, 6}];\)\), "\[IndentingNewLine]", 
    \(\(b = Cycles[{1, 3}, {2, 4}];\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orbits[GenSet[a, b]]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 3, 4}, {5, 6}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimino[GenSet[a, b]]\)], "Input"],

Cell[BoxData[
    \(Group["ID", Cycles[{1, 2}, {5, 6}], Cycles[{1, 3}, {2, 4}], 
      Cycles[{1, 4, 2, 3}, {5, 6}], Cycles[{1, 3, 2, 4}, {5, 6}], 
      Cycles[{1, 4}, {2, 3}], Cycles[{3, 4}, {5, 6}], 
      Cycles[{1, 2}, {3, 4}]]\)], "Output"]
}, Open  ]],

Cell["Construction of the pair (base,SGS) from scratch:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SGS = 
      SchreierSims[{1}, GenSet[a, b], xPermVerbose \[Rule] True]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {5, 6}], 
          Cycles[{1, 3}, {2, 
              4}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]1\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {5, 6}], Cycles[{1, 3}, {2, 4}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {5, 6}], 
          Cycles[ {1, 3}, {2, 4}]], ", i=", 1, ", T=", 
        GenSet[ 
          Cycles[ {1, 2}, {5, 6}], 
          Cycles[ {1, 3}, {2, 4}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{3, 
            4}, {5, 6}]\),
      SequenceForm[ "Appended S[[", 3, "]]=", 
        Cycles[ {3, 4}, {5, 6}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]3\),
      SequenceForm[ "Appended B[[", 2, "]]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {5, 6}], Cycles[{1, 3}, {2, 4}], 
          Cycles[{3, 4}, {5, 
              6}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{3, 4}, {5, 6}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 3}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {5, 6}], 
          Cycles[ {1, 3}, {2, 4}], 
          Cycles[ {3, 4}, {5, 6}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {3, 4}, {5, 6}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{3, 4}, {5, 6}]]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {3}, " and SGS ", 
        GenSet[ 
          Cycles[ {3, 4}, {5, 6}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]10\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]8\),
      SequenceForm[ 
      "Checked ", 10, " generators and obtained group of order ", 8],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1, 3}, 
      GenSet[Cycles[{1, 2}, {5, 6}], Cycles[{1, 3}, {2, 4}], 
        Cycles[{3, 4}, {5, 6}]]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[ID, SGS]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermMemberQ[Cycles[{5, 6}], SGS]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(SGS = 
        StrongGenSet[{1, 3}, 
          GenSet[Cycles[{1, 2}, {5, 6}], Cycles[{1, 3}, {2, 4}], 
            Cycles[{3, 4}, {5, 6}]]];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TranslatePerm[
      First@RightCosetRepresentative[Cycles[{1, 3, 2}], 6, SGS], 
      Perm]\)], "Input"],

Cell[BoxData[
    \(Perm[{1, 3, 2, 4, 6, 5}]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(SGS = 
        StrongGenSet[{1, 2, 3, 4}, 
          GenSet[Cycles[{1, 2}, {5, 6}], Cycles[{1, 3}, {2, 4}], 
            Cycles[{3, 4}, {5, 6}]]];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TranslatePerm[
      First@RightCosetRepresentative[Cycles[{1, 3, 2}], 6, SGS], 
      Perm]\)], "Input"],

Cell[BoxData[
    \(Perm[{1, 3, 2, 4, 6, 5}]\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 14", "Section"],

Cell[BoxData[{
    \(\(a = Cycles[{1, 2}, {6, 7}];\)\), "\[IndentingNewLine]", 
    \(\(b = Cycles[{1, 2, 3, 4, 5}, {6, 7}];\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orbits[GenSet[a, b]]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 3, 4, 5}, {6, 7}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchreierSims[{}, GenSet[a, b], xPermVerbose \[Rule] True]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {6, 7}], 
          Cycles[{1, 2, 3, 4, 5}, {6, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]1\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {6, 7}], Cycles[{1, 2, 3, 4, 5}, {6, 7}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {6, 7}], 
          Cycles[ {1, 2, 3, 4, 5}, {6, 7}]], ", i=", 1, ", T=", 
        GenSet[ 
          Cycles[ {1, 2}, {6, 7}], 
          Cycles[ {1, 2, 3, 4, 5}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{2, 3, 4, 
            5}]\),
      SequenceForm[ "Appended S[[", 3, "]]=", 
        Cycles[ {2, 3, 4, 5}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]2\[InvisibleSpace]"]]="\[InvisibleSpace]2\),
      SequenceForm[ "Appended B[[", 2, "]]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {6, 7}], Cycles[{1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[{2, 3, 4, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{2, 3, 4, 5}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {6, 7}], 
          Cycles[ {1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[ {2, 3, 4, 5}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {2, 3, 4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{2, 3, 4, 5}]]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2}, " and SGS ", 
        GenSet[ 
          Cycles[ {2, 3, 4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{2, 
            5}, {6, 7}]\),
      SequenceForm[ "Appended S[[", 4, "]]=", 
        Cycles[ {2, 5}, {6, 7}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {6, 7}], Cycles[{1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[{2, 3, 4, 5}], 
          Cycles[{2, 5}, {6, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]2\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{2, 5}, {6, 7}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {6, 7}], 
          Cycles[ {1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[ {2, 3, 4, 5}], 
          Cycles[ {2, 5}, {6, 7}]], ", i=", 2, ", T=", 
        GenSet[ 
          Cycles[ {2, 5}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{3, 4, 
            5}, {6, 7}]\),
      SequenceForm[ "Appended S[[", 5, "]]=", 
        Cycles[ {3, 4, 5}, {6, 7}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]3\[InvisibleSpace]"]]="\[InvisibleSpace]3\),
      SequenceForm[ "Appended B[[", 3, "]]=", 3],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {6, 7}], Cycles[{1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[{2, 3, 4, 5}], Cycles[{2, 5}, {6, 7}], 
          Cycles[{3, 4, 5}, {6, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]3\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{3, 4, 5}, {6, 7}]]\),
      SequenceForm[ "Schreier-Sims-Step called with B=", {1, 2, 3}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {6, 7}], 
          Cycles[ {1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[ {2, 3, 4, 5}], 
          Cycles[ {2, 5}, {6, 7}], 
          Cycles[ {3, 4, 5}, {6, 7}]], ", i=", 3, ", T=", 
        GenSet[ 
          Cycles[ {3, 4, 5}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]6\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{6, 7}]\),
      
      SequenceForm[ "Appended S[[", 6, "]]=", 
        Cycles[ {6, 7}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]4\[InvisibleSpace]"]]="\[InvisibleSpace]6\),
      SequenceForm[ "Appended B[[", 4, "]]=", 6],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {6, 7}], Cycles[{1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[{2, 3, 4, 5}], Cycles[{2, 5}, {6, 7}], 
          Cycles[{3, 4, 5}, {6, 7}], 
          Cycles[{6, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{6, 7}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 6}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {6, 7}], 
          Cycles[ {1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[ {2, 3, 4, 5}], 
          Cycles[ {2, 5}, {6, 7}], 
          Cycles[ {3, 4, 5}, {6, 7}], 
          Cycles[ {6, 7}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]4\
\[InvisibleSpace]") with base "\[InvisibleSpace]{6}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{6, 7}]]\),
      SequenceForm[ 
      "Finished check of H(", 4, ") with base ", {6}, " and SGS ", 
        GenSet[ 
          Cycles[ {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 
          6}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{3, 4, 5}, {6, 7}], Cycles[{6, 7}]]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 6}, " and SGS ", 
        GenSet[ 
          Cycles[ {3, 4, 5}, {6, 7}], 
          Cycles[ {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]7\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 
            5}, {6, 7}]\),
      SequenceForm[ "Appended S[[", 7, "]]=", 
        Cycles[ {4, 5}, {6, 7}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 
          6}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {6, 7}], Cycles[{1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[{2, 3, 4, 5}], Cycles[{2, 5}, {6, 7}], 
          Cycles[{3, 4, 5}, {6, 7}], Cycles[{6, 7}], 
          Cycles[{4, 5}, {6, 
              7}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]4\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 5}, {6, 7}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 6}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {6, 7}], 
          Cycles[ {1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[ {2, 3, 4, 5}], 
          Cycles[ {2, 5}, {6, 7}], 
          Cycles[ {3, 4, 5}, {6, 7}], 
          Cycles[ {6, 7}], 
          Cycles[ {4, 5}, {6, 7}]], ", i=", 4, ", T=", 
        GenSet[ 
          Cycles[ {4, 5}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
S[["\[InvisibleSpace]8\[InvisibleSpace]"]]="\[InvisibleSpace]Cycles[{4, 5}]\),
      
      SequenceForm[ "Appended S[[", 8, "]]=", 
        Cycles[ {4, 5}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Appended \
B[["\[InvisibleSpace]5\[InvisibleSpace]"]]="\[InvisibleSpace]4\),
      SequenceForm[ "Appended B[[", 5, "]]=", 4],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 6, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {6, 7}], Cycles[{1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[{2, 3, 4, 5}], Cycles[{2, 5}, {6, 7}], 
          Cycles[{3, 4, 5}, {6, 7}], Cycles[{6, 7}], Cycles[{4, 5}, {6, 7}], 
          Cycles[{4, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]5\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 5}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 6, 4}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {6, 7}], 
          Cycles[ {1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[ {2, 3, 4, 5}], 
          Cycles[ {2, 5}, {6, 7}], 
          Cycles[ {3, 4, 5}, {6, 7}], 
          Cycles[ {6, 7}], 
          Cycles[ {4, 5}, {6, 7}], 
          Cycles[ {4, 5}]], ", i=", 5, ", T=", 
        GenSet[ 
          Cycles[ {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]5\
\[InvisibleSpace]") with base "\[InvisibleSpace]{4}\[InvisibleSpace]" and SGS \
"\[InvisibleSpace]GenSet[Cycles[{4, 5}]]\),
      SequenceForm[ 
      "Finished check of H(", 5, ") with base ", {4}, " and SGS ", 
        GenSet[ 
          Cycles[ {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Schreier-Sims-Step called with \
B="\[InvisibleSpace]{1, 2, 3, 6, 
          4}\[InvisibleSpace]", S="\[InvisibleSpace]GenSet[
          Cycles[{1, 2}, {6, 7}], Cycles[{1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[{2, 3, 4, 5}], Cycles[{2, 5}, {6, 7}], 
          Cycles[{3, 4, 5}, {6, 7}], Cycles[{6, 7}], Cycles[{4, 5}, {6, 7}], 
          Cycles[{4, 
              5}]]\[InvisibleSpace]", \
i="\[InvisibleSpace]3\[InvisibleSpace]", T="\[InvisibleSpace]GenSet[
          Cycles[{4, 5}, {6, 7}]]\),
      SequenceForm[ 
      "Schreier-Sims-Step called with B=", {1, 2, 3, 6, 4}, ", S=", 
        GenSet[ 
          Cycles[ {1, 2}, {6, 7}], 
          Cycles[ {1, 2, 3, 4, 5}, {6, 7}], 
          Cycles[ {2, 3, 4, 5}], 
          Cycles[ {2, 5}, {6, 7}], 
          Cycles[ {3, 4, 5}, {6, 7}], 
          Cycles[ {6, 7}], 
          Cycles[ {4, 5}, {6, 7}], 
          Cycles[ {4, 5}]], ", i=", 3, ", T=", 
        GenSet[ 
          Cycles[ {4, 5}, {6, 7}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Modifying orbit Delta to extend previous value."\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]3\
\[InvisibleSpace]") with base "\[InvisibleSpace]{3, 6, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{3, 4, 5}, {6, 7}], Cycles[{6, 7}], Cycles[{4, 5}, {6, 7}], 
          Cycles[{4, 5}]]\),
      SequenceForm[ 
      "Finished check of H(", 3, ") with base ", {3, 6, 4}, " and SGS ", 
        GenSet[ 
          Cycles[ {3, 4, 5}, {6, 7}], 
          Cycles[ {6, 7}], 
          Cycles[ {4, 5}, {6, 7}], 
          Cycles[ {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished check of H("\[InvisibleSpace]2\
\[InvisibleSpace]") with base "\[InvisibleSpace]{2, 3, 6, 
          4}\[InvisibleSpace]" and SGS "\[InvisibleSpace]GenSet[
          Cycles[{2, 3, 4, 5}], Cycles[{2, 5}, {6, 7}], 
          Cycles[{3, 4, 5}, {6, 7}], Cycles[{6, 7}], Cycles[{4, 5}, {6, 7}], 
          Cycles[{4, 5}]]\),
      SequenceForm[ 
      "Finished check of H(", 2, ") with base ", {2, 3, 6, 4}, " and SGS ", 
        GenSet[ 
          Cycles[ {2, 3, 4, 5}], 
          Cycles[ {2, 5}, {6, 7}], 
          Cycles[ {3, 4, 5}, {6, 7}], 
          Cycles[ {6, 7}], 
          Cycles[ {4, 5}, {6, 7}], 
          Cycles[ {4, 5}]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Checked "\[InvisibleSpace]30\[InvisibleSpace]" \
generators and obtained group of order "\[InvisibleSpace]240\),
      SequenceForm[ 
      "Checked ", 30, " generators and obtained group of order ", 240],
      Editable->False]], "Print"],

Cell[BoxData[
    \(StrongGenSet[{1, 2, 3, 6, 4}, 
      GenSet[Cycles[{1, 2}, {6, 7}], Cycles[{1, 2, 3, 4, 5}, {6, 7}], 
        Cycles[{2, 3, 4, 5}], Cycles[{2, 5}, {6, 7}], 
        Cycles[{3, 4, 5}, {6, 7}], Cycles[{6, 7}], Cycles[{4, 5}, {6, 7}], 
        Cycles[{4, 5}]]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[Dimino[GenSet[a, b]]]\)], "Input"],

Cell[BoxData[
    \(240\)], "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{872, 613},
WindowMargins->{{0, Automatic}, {Automatic, 119}},
ShowSelection->True
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 85, 1, 98, "Title"],
Cell[1864, 56, 164, 2, 80, "Subtitle"],
Cell[2031, 60, 534, 10, 240, "Subsubtitle"],

Cell[CellGroupData[{
Cell[2590, 74, 29, 0, 74, "Section"],

Cell[CellGroupData[{
Cell[2644, 78, 47, 1, 27, "Input"],
Cell[2694, 81, 117, 2, 23, "Print"],
Cell[2814, 85, 285, 6, 23, "Print"],
Cell[3102, 93, 118, 2, 23, "Print"],
Cell[3223, 97, 117, 2, 23, "Print"],
Cell[3343, 101, 66, 1, 23, "Print"],
Cell[3412, 104, 90, 1, 23, "Print"],
Cell[3505, 107, 117, 2, 23, "Print"],
Cell[3625, 111, 285, 6, 23, "Print"],
Cell[3913, 119, 118, 2, 23, "Print"],
Cell[4034, 123, 117, 2, 23, "Print"],
Cell[4154, 127, 252, 4, 55, "Print"],
Cell[4409, 133, 117, 2, 23, "Print"],
Cell[4529, 137, 77, 1, 23, "Print"],
Cell[4609, 140, 58, 1, 23, "Print"]
}, Open  ]],
Cell[4682, 144, 61, 0, 32, "Text"],
Cell[4746, 146, 223, 4, 43, "Input"],
Cell[4972, 152, 226, 5, 43, "Input"],

Cell[CellGroupData[{
Cell[5223, 161, 54, 1, 27, "Input"],
Cell[5280, 164, 36, 1, 27, "Output"]
}, Open  ]],
Cell[5331, 168, 78, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5446, 174, 28, 0, 44, "Section"],
Cell[5477, 176, 51, 0, 32, "Text"],
Cell[5531, 178, 216, 3, 59, "Input"],
Cell[5750, 183, 120, 2, 27, "Input"],
Cell[5873, 187, 30, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[5928, 191, 58, 1, 27, "Input"],
Cell[5989, 194, 43, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6069, 200, 58, 1, 27, "Input"],
Cell[6130, 203, 60, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6227, 209, 70, 1, 27, "Input"],
Cell[6300, 212, 136, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6473, 219, 49, 1, 27, "Input"],
Cell[6525, 222, 347, 11, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6909, 238, 70, 1, 27, "Input"],
Cell[6982, 241, 165, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7184, 248, 49, 1, 27, "Input"],
Cell[7236, 251, 468, 12, 76, "Output"]
}, Open  ]],
Cell[7719, 266, 27, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[7771, 270, 60, 1, 27, "Input"],
Cell[7834, 273, 73, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7944, 279, 68, 1, 27, "Input"],
Cell[8015, 282, 189, 3, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8241, 290, 49, 1, 27, "Input"],
Cell[8293, 293, 542, 13, 76, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[8884, 312, 54, 0, 44, "Section"],
Cell[8941, 314, 45, 0, 32, "Text"],
Cell[8989, 316, 104, 2, 43, "Input"],
Cell[9096, 320, 78, 1, 27, "Input"],
Cell[9177, 323, 50, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[9252, 327, 53, 1, 27, "Input"],
Cell[9308, 330, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9383, 336, 64, 1, 27, "Input"],
Cell[9450, 339, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9525, 345, 71, 1, 27, "Input"],
Cell[9599, 348, 39, 1, 27, "Output"]
}, Open  ]],
Cell[9653, 352, 40, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[9718, 356, 81, 1, 27, "Input"],
Cell[9802, 359, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9877, 365, 77, 1, 27, "Input"],
Cell[9957, 368, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10033, 374, 77, 1, 27, "Input"],
Cell[10113, 377, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10188, 383, 78, 1, 27, "Input"],
Cell[10269, 386, 38, 1, 27, "Output"]
}, Open  ]],
Cell[10322, 390, 40, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[10387, 394, 76, 1, 27, "Input"],
Cell[10466, 397, 38, 1, 27, "Output"]
}, Open  ]],
Cell[10519, 401, 37, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[10581, 405, 67, 1, 27, "Input"],
Cell[10651, 408, 639, 19, 63, "Output"]
}, Open  ]],
Cell[11305, 430, 90, 1, 27, "Input"],
Cell[11398, 433, 33, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[11456, 437, 112, 2, 27, "Input"],
Cell[11571, 441, 370, 11, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11978, 457, 112, 2, 27, "Input"],
Cell[12093, 461, 324, 11, 76, "Output"]
}, Open  ]],
Cell[12432, 475, 65, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[12522, 479, 101, 2, 27, "Input"],
Cell[12626, 483, 591, 14, 39, "Print"],
Cell[13220, 499, 647, 15, 39, "Print"],
Cell[13870, 516, 274, 5, 23, "Print"],
Cell[14147, 523, 72, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14256, 529, 50, 1, 27, "Input"],
Cell[14309, 532, 35, 1, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[14393, 539, 57, 0, 44, "Section"],
Cell[14453, 541, 45, 0, 32, "Text"],
Cell[14501, 543, 27, 0, 32, "Text"],
Cell[14531, 545, 121, 2, 43, "Input"],
Cell[14655, 549, 38, 0, 32, "Text"],
Cell[14696, 551, 223, 4, 75, "Input"],
Cell[14922, 557, 147, 3, 59, "Input"],
Cell[15072, 562, 31, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[15128, 566, 50, 1, 27, "Input"],
Cell[15181, 569, 37, 1, 27, "Output"]
}, Open  ]],
Cell[15233, 573, 126, 2, 43, "Input"],
Cell[15362, 577, 115, 2, 27, "Input"],
Cell[15480, 581, 37, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[15542, 585, 81, 1, 27, "Input"],
Cell[15626, 588, 686, 18, 81, "Output"]
}, Open  ]],
Cell[16327, 609, 93, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[16445, 615, 54, 1, 27, "Input"],
Cell[16502, 618, 49, 1, 27, "Output"]
}, Open  ]],
Cell[16566, 622, 107, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[16698, 629, 73, 1, 27, "Input"],
Cell[16774, 632, 35, 1, 27, "Output"]
}, Open  ]],
Cell[16824, 636, 99, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[16948, 642, 80, 1, 27, "Input"],
Cell[17031, 645, 35, 1, 27, "Output"]
}, Open  ]],
Cell[17081, 649, 38, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[17144, 653, 55, 1, 27, "Input"],
Cell[17202, 656, 67, 1, 27, "Output"]
}, Open  ]],
Cell[17284, 660, 40, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[17349, 664, 68, 1, 27, "Input"],
Cell[17420, 667, 120, 2, 27, "Output"]
}, Open  ]],
Cell[17555, 672, 107, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[17687, 679, 87, 1, 27, "Input"],
Cell[17777, 682, 36, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17850, 688, 59, 1, 27, "Input"],
Cell[17912, 691, 652, 10, 107, "Output"]
}, Open  ]],
Cell[18579, 704, 49, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[18653, 708, 72, 1, 27, "Input"],
Cell[18728, 711, 132, 2, 27, "Output"]
}, Open  ]],
Cell[18875, 716, 120, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[19020, 723, 101, 2, 27, "Input"],
Cell[19124, 727, 37, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19198, 733, 63, 1, 27, "Input"],
Cell[19264, 736, 5420, 81, 859, "Output"]
}, Open  ]],
Cell[24699, 820, 68, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[24792, 824, 76, 1, 27, "Input"],
Cell[24871, 827, 138, 2, 27, "Output"]
}, Open  ]],
Cell[25024, 832, 117, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[25166, 839, 92, 1, 27, "Input"],
Cell[25261, 842, 447, 12, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25745, 859, 92, 1, 27, "Input"],
Cell[25840, 862, 423, 12, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26300, 879, 92, 1, 27, "Input"],
Cell[26395, 882, 373, 11, 76, "Output"]
}, Open  ]],
Cell[26783, 896, 70, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[26878, 900, 80, 1, 27, "Input"],
Cell[26961, 903, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27037, 909, 80, 1, 27, "Input"],
Cell[27120, 912, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27195, 918, 77, 1, 27, "Input"],
Cell[27275, 921, 118, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27430, 928, 48, 1, 27, "Input"],
Cell[27481, 931, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27556, 937, 63, 1, 27, "Input"],
Cell[27622, 940, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27697, 946, 48, 1, 27, "Input"],
Cell[27748, 949, 62, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27847, 955, 63, 1, 27, "Input"],
Cell[27913, 958, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27988, 964, 48, 1, 27, "Input"],
Cell[28039, 967, 63, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28139, 973, 63, 1, 27, "Input"],
Cell[28205, 976, 38, 1, 27, "Output"]
}, Open  ]],
Cell[28258, 980, 38, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[28321, 984, 118, 2, 27, "Input"],
Cell[28442, 988, 499, 9, 23, "Print"],
Cell[28944, 999, 511, 9, 23, "Print"],
Cell[29458, 1010, 523, 9, 23, "Print"],
Cell[29984, 1021, 278, 5, 23, "Print"],
Cell[30265, 1028, 89, 1, 27, "Output"]
}, Open  ]],
Cell[30369, 1032, 37, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[30431, 1036, 131, 2, 27, "Input"],
Cell[30565, 1040, 446, 8, 23, "Print"],
Cell[31014, 1050, 458, 8, 23, "Print"],
Cell[31475, 1060, 205, 4, 23, "Print"],
Cell[31683, 1066, 469, 9, 23, "Print"],
Cell[32155, 1077, 205, 4, 23, "Print"],
Cell[32363, 1083, 199, 4, 23, "Print"],
Cell[32565, 1089, 487, 9, 23, "Print"],
Cell[33055, 1100, 340, 7, 23, "Print"],
Cell[33398, 1109, 205, 4, 23, "Print"],
Cell[33606, 1115, 499, 9, 23, "Print"],
Cell[34108, 1126, 352, 7, 23, "Print"],
Cell[34463, 1135, 402, 8, 23, "Print"],
Cell[34868, 1145, 278, 5, 23, "Print"],
Cell[35149, 1152, 102, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35288, 1159, 137, 3, 27, "Input"],
Cell[35428, 1164, 622, 14, 39, "Print"],
Cell[36053, 1180, 622, 14, 39, "Print"],
Cell[36678, 1196, 622, 14, 39, "Print"],
Cell[37303, 1212, 622, 14, 39, "Print"],
Cell[37928, 1228, 622, 14, 39, "Print"],
Cell[38553, 1244, 689, 16, 39, "Print"],
Cell[39245, 1262, 763, 17, 55, "Print"],
Cell[40011, 1281, 276, 6, 23, "Print"],
Cell[40290, 1289, 773, 17, 55, "Print"],
Cell[41066, 1308, 264, 6, 23, "Print"],
Cell[41333, 1316, 832, 19, 55, "Print"],
Cell[42168, 1337, 832, 19, 55, "Print"],
Cell[43003, 1358, 441, 10, 23, "Print"],
Cell[43447, 1370, 264, 6, 23, "Print"],
Cell[43714, 1378, 892, 20, 55, "Print"],
Cell[44609, 1400, 892, 20, 55, "Print"],
Cell[45504, 1422, 501, 11, 23, "Print"],
Cell[46008, 1435, 650, 14, 39, "Print"],
Cell[46661, 1451, 278, 5, 23, "Print"],
Cell[46942, 1458, 114, 2, 27, "Output"]
}, Open  ]],
Cell[47071, 1463, 52, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[47148, 1467, 59, 1, 27, "Input"],
Cell[47210, 1470, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47285, 1476, 108, 2, 27, "Input"],
Cell[47396, 1480, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47471, 1486, 108, 2, 27, "Input"],
Cell[47582, 1490, 39, 1, 27, "Output"]
}, Open  ]],
Cell[47636, 1494, 36, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[47697, 1498, 62, 1, 27, "Input"],
Cell[47762, 1501, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47837, 1507, 111, 2, 27, "Input"],
Cell[47951, 1511, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48026, 1517, 111, 2, 27, "Input"],
Cell[48140, 1521, 39, 1, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[48228, 1528, 37, 0, 44, "Section"],
Cell[48268, 1530, 45, 0, 32, "Text"],
Cell[48316, 1532, 82, 1, 27, "Input"],
Cell[48401, 1535, 77, 1, 27, "Input"],
Cell[48481, 1538, 77, 1, 27, "Input"],
Cell[48561, 1541, 82, 1, 27, "Input"],
Cell[48646, 1544, 82, 1, 27, "Input"],
Cell[48731, 1547, 897, 21, 123, "Input"],
Cell[49631, 1570, 155, 3, 27, "Input"],
Cell[49789, 1575, 173, 3, 59, "Input"],

Cell[CellGroupData[{
Cell[49987, 1582, 50, 1, 27, "Input"],
Cell[50040, 1585, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50115, 1591, 49, 1, 27, "Input"],
Cell[50167, 1594, 67, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50271, 1600, 81, 1, 27, "Input"],
Cell[50355, 1603, 877, 22, 99, "Output"]
}, Open  ]],
Cell[51247, 1628, 75, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[51347, 1632, 93, 1, 27, "Input"],
Cell[51443, 1635, 548, 13, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52028, 1653, 93, 1, 27, "Input"],
Cell[52124, 1656, 523, 13, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52684, 1674, 93, 1, 27, "Input"],
Cell[52780, 1677, 495, 12, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53312, 1694, 93, 1, 27, "Input"],
Cell[53408, 1697, 471, 12, 76, "Output"]
}, Open  ]],
Cell[53894, 1712, 60, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[53979, 1716, 119, 2, 27, "Input"],
Cell[54101, 1720, 528, 10, 23, "Print"],
Cell[54632, 1732, 540, 10, 23, "Print"],
Cell[55175, 1744, 552, 10, 23, "Print"],
Cell[55730, 1756, 575, 11, 39, "Print"],
Cell[56308, 1769, 282, 5, 23, "Print"],
Cell[56593, 1776, 107, 2, 27, "Output"]
}, Open  ]],
Cell[56715, 1781, 47, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[56787, 1785, 81, 1, 27, "Input"],
Cell[56871, 1788, 475, 10, 75, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57383, 1803, 66, 1, 27, "Input"],
Cell[57452, 1806, 259, 5, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57748, 1816, 132, 3, 27, "Input"],
Cell[57883, 1821, 380, 7, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58300, 1833, 75, 1, 27, "Input"],
Cell[58378, 1836, 241, 4, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58656, 1845, 53, 1, 27, "Input"],
Cell[58712, 1848, 38, 1, 27, "Output"]
}, Open  ]],
Cell[58765, 1852, 53, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[58843, 1856, 70, 1, 27, "Input"],
Cell[58916, 1859, 2895, 64, 225, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[61860, 1929, 28, 0, 44, "Section"],
Cell[61891, 1931, 45, 0, 32, "Text"],
Cell[61939, 1933, 159, 3, 27, "Input"],
Cell[62101, 1938, 75, 1, 27, "Input"],
Cell[62179, 1941, 76, 1, 27, "Input"],
Cell[62258, 1944, 363, 6, 107, "Input"],
Cell[62624, 1952, 222, 3, 59, "Input"],
Cell[62849, 1957, 183, 3, 59, "Input"],

Cell[CellGroupData[{
Cell[63057, 1964, 43, 1, 27, "Input"],
Cell[63103, 1967, 36, 1, 27, "Output"]
}, Open  ]],
Cell[63154, 1971, 203, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[63382, 1979, 50, 1, 27, "Input"],
Cell[63435, 1982, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[63511, 1988, 49, 1, 27, "Input"],
Cell[63563, 1991, 50, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[63650, 1997, 81, 1, 27, "Input"],
Cell[63734, 2000, 1228, 29, 135, "Output"]
}, Open  ]],
Cell[64977, 2032, 118, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[65120, 2039, 93, 1, 27, "Input"],
Cell[65216, 2042, 841, 17, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66094, 2064, 93, 1, 27, "Input"],
Cell[66190, 2067, 458, 12, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66685, 2084, 93, 1, 27, "Input"],
Cell[66781, 2087, 458, 12, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[67276, 2104, 93, 1, 27, "Input"],
Cell[67372, 2107, 354, 11, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[67763, 2123, 93, 1, 27, "Input"],
Cell[67859, 2126, 349, 11, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[68245, 2142, 93, 1, 27, "Input"],
Cell[68341, 2145, 354, 11, 76, "Output"]
}, Open  ]],
Cell[68710, 2159, 26, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[68761, 2163, 136, 3, 27, "Input"],
Cell[68900, 2168, 551, 11, 23, "Print"],
Cell[69454, 2181, 563, 11, 39, "Print"],
Cell[70020, 2194, 575, 11, 39, "Print"],
Cell[70598, 2207, 587, 11, 39, "Print"],
Cell[71188, 2220, 599, 11, 39, "Print"],
Cell[71790, 2233, 611, 11, 39, "Print"],
Cell[72404, 2246, 284, 5, 23, "Print"],
Cell[72691, 2253, 159, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[72887, 2261, 151, 3, 27, "Input"],
Cell[73041, 2266, 471, 9, 23, "Print"],
Cell[73515, 2277, 495, 9, 23, "Print"],
Cell[74013, 2288, 205, 4, 23, "Print"],
Cell[74221, 2294, 483, 9, 23, "Print"],
Cell[74707, 2305, 205, 4, 23, "Print"],
Cell[74915, 2311, 199, 4, 23, "Print"],
Cell[75117, 2317, 501, 9, 23, "Print"],
Cell[75621, 2328, 340, 7, 23, "Print"],
Cell[75964, 2337, 392, 8, 23, "Print"],
Cell[76359, 2347, 205, 4, 23, "Print"],
Cell[76567, 2353, 199, 4, 23, "Print"],
Cell[76769, 2359, 537, 11, 23, "Print"],
Cell[77309, 2372, 537, 11, 23, "Print"],
Cell[77849, 2385, 537, 11, 23, "Print"],
Cell[78389, 2398, 82, 1, 23, "Print"],
Cell[78474, 2401, 410, 8, 23, "Print"],
Cell[78887, 2411, 205, 4, 23, "Print"],
Cell[79095, 2417, 199, 4, 23, "Print"],
Cell[79297, 2423, 564, 12, 23, "Print"],
Cell[79864, 2437, 564, 12, 23, "Print"],
Cell[80431, 2451, 564, 12, 23, "Print"],
Cell[80998, 2465, 564, 12, 23, "Print"],
Cell[81565, 2479, 82, 1, 23, "Print"],
Cell[81650, 2482, 428, 8, 23, "Print"],
Cell[82081, 2492, 205, 4, 23, "Print"],
Cell[82289, 2498, 201, 4, 23, "Print"],
Cell[82493, 2504, 584, 12, 39, "Print"],
Cell[83080, 2518, 584, 12, 39, "Print"],
Cell[83667, 2532, 584, 12, 39, "Print"],
Cell[84254, 2546, 584, 12, 39, "Print"],
Cell[84841, 2560, 584, 12, 39, "Print"],
Cell[85428, 2574, 82, 1, 23, "Print"],
Cell[85513, 2577, 457, 9, 23, "Print"],
Cell[85973, 2588, 284, 5, 23, "Print"],
Cell[86260, 2595, 171, 3, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[86480, 2604, 35, 0, 44, "Section"],
Cell[86518, 2606, 45, 0, 32, "Text"],
Cell[86566, 2608, 97, 2, 32, "Text"],
Cell[86666, 2612, 156, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[86847, 2619, 53, 1, 27, "Input"],
Cell[86903, 2622, 153, 2, 27, "Output"]
}, Open  ]],
Cell[87071, 2627, 162, 3, 27, "Input"],
Cell[87236, 2632, 161, 3, 27, "Input"],
Cell[87400, 2637, 161, 3, 27, "Input"],
Cell[87564, 2642, 162, 3, 27, "Input"],
Cell[87729, 2647, 165, 3, 27, "Input"],
Cell[87897, 2652, 111, 2, 27, "Input"],
Cell[88011, 2656, 62, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[88098, 2660, 68, 1, 27, "Input"],
Cell[88169, 2663, 76, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88282, 2669, 110, 2, 27, "Input"],
Cell[88395, 2673, 38, 1, 27, "Output"]
}, Open  ]],
Cell[88448, 2677, 99, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[88572, 2683, 52, 1, 27, "Input"],
Cell[88627, 2686, 239, 3, 43, "Output"]
}, Open  ]],
Cell[88881, 2692, 49, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[88955, 2696, 76, 1, 27, "Input"],
Cell[89034, 2699, 36, 1, 27, "Output"]
}, Open  ]],
Cell[89085, 2703, 160, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[89270, 2710, 102, 2, 27, "Input"],
Cell[89375, 2714, 38, 1, 27, "Output"]
}, Open  ]],
Cell[89428, 2718, 38, 0, 32, "Text"],
Cell[89469, 2720, 125, 2, 27, "Input"],
Cell[89597, 2724, 1675, 30, 315, "Input"],
Cell[91275, 2756, 159, 3, 27, "Input"],
Cell[91437, 2761, 75, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[91537, 2766, 50, 1, 27, "Input"],
Cell[91590, 2769, 54, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[91681, 2775, 37, 1, 27, "Input"],
Cell[91721, 2778, 56, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[91814, 2784, 50, 1, 27, "Input"],
Cell[91867, 2787, 77, 1, 27, "Output"]
}, Open  ]],
Cell[91959, 2791, 131, 3, 27, "Input"],
Cell[92093, 2796, 58, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[92176, 2800, 81, 1, 27, "Input"],
Cell[92260, 2803, 6374, 121, 351, "Output"]
}, Open  ]],
Cell[98649, 2927, 39, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[98713, 2931, 155, 4, 27, "Input"],
Cell[98871, 2937, 321, 5, 43, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[99241, 2948, 28, 0, 44, "Section"],
Cell[99272, 2950, 45, 0, 32, "Text"],
Cell[99320, 2952, 121, 3, 27, "Input"],
Cell[99444, 2957, 105, 2, 27, "Input"],
Cell[99552, 2961, 571, 12, 123, "Input"],
Cell[100126, 2975, 1121, 24, 139, "Input"],
Cell[101250, 3001, 185, 3, 59, "Input"],
Cell[101438, 3006, 155, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[101618, 3013, 50, 1, 27, "Input"],
Cell[101671, 3016, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[101747, 3022, 81, 1, 27, "Input"],
Cell[101831, 3025, 1259, 30, 135, "Output"]
}, Open  ]],
Cell[103105, 3058, 186, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[103316, 3066, 93, 1, 27, "Input"],
Cell[103412, 3069, 651, 15, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[104100, 3089, 93, 1, 27, "Input"],
Cell[104196, 3092, 577, 13, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[104810, 3110, 93, 1, 27, "Input"],
Cell[104906, 3113, 477, 12, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[105420, 3130, 93, 1, 27, "Input"],
Cell[105516, 3133, 326, 11, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[105879, 3149, 93, 1, 27, "Input"],
Cell[105975, 3152, 325, 11, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[106337, 3168, 93, 1, 27, "Input"],
Cell[106433, 3171, 325, 11, 76, "Output"]
}, Open  ]],
Cell[106773, 3185, 57, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[106855, 3189, 46, 1, 27, "Input"],
Cell[106904, 3192, 91, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[107032, 3198, 72, 1, 27, "Input"],
Cell[107107, 3201, 91, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[107235, 3207, 120, 2, 27, "Input"],
Cell[107358, 3211, 91, 1, 27, "Output"]
}, Open  ]],
Cell[107464, 3215, 26, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[107515, 3219, 136, 3, 27, "Input"],
Cell[107654, 3224, 568, 12, 23, "Print"],
Cell[108225, 3238, 580, 12, 39, "Print"],
Cell[108808, 3252, 592, 12, 39, "Print"],
Cell[109403, 3266, 616, 12, 39, "Print"],
Cell[110022, 3280, 628, 12, 39, "Print"],
Cell[110653, 3294, 640, 12, 39, "Print"],
Cell[111296, 3308, 284, 5, 23, "Print"],
Cell[111583, 3315, 163, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[111783, 3323, 148, 3, 27, "Input"],
Cell[111934, 3328, 452, 8, 23, "Print"],
Cell[112389, 3338, 205, 4, 23, "Print"],
Cell[112597, 3344, 199, 4, 23, "Print"],
Cell[112799, 3350, 469, 9, 23, "Print"],
Cell[113271, 3361, 340, 7, 23, "Print"],
Cell[113614, 3370, 205, 4, 23, "Print"],
Cell[113822, 3376, 481, 9, 23, "Print"],
Cell[114306, 3387, 205, 4, 23, "Print"],
Cell[114514, 3393, 199, 4, 23, "Print"],
Cell[114716, 3399, 499, 9, 23, "Print"],
Cell[115218, 3410, 340, 7, 23, "Print"],
Cell[115561, 3419, 390, 8, 23, "Print"],
Cell[115954, 3429, 205, 4, 23, "Print"],
Cell[116162, 3435, 511, 9, 23, "Print"],
Cell[116676, 3446, 82, 1, 23, "Print"],
Cell[116761, 3449, 82, 1, 23, "Print"],
Cell[116846, 3452, 205, 4, 23, "Print"],
Cell[117054, 3458, 532, 10, 23, "Print"],
Cell[117589, 3470, 205, 4, 23, "Print"],
Cell[117797, 3476, 199, 4, 23, "Print"],
Cell[117999, 3482, 568, 12, 23, "Print"],
Cell[118570, 3496, 340, 7, 23, "Print"],
Cell[118913, 3505, 205, 4, 23, "Print"],
Cell[119121, 3511, 580, 12, 39, "Print"],
Cell[119704, 3525, 207, 4, 23, "Print"],
Cell[119914, 3531, 199, 4, 23, "Print"],
Cell[120116, 3537, 598, 12, 39, "Print"],
Cell[120717, 3551, 340, 7, 23, "Print"],
Cell[121060, 3560, 390, 8, 23, "Print"],
Cell[121453, 3570, 420, 8, 23, "Print"],
Cell[121876, 3580, 207, 4, 23, "Print"],
Cell[122086, 3586, 619, 13, 39, "Print"],
Cell[122708, 3601, 82, 1, 23, "Print"],
Cell[122793, 3604, 207, 4, 23, "Print"],
Cell[123003, 3610, 633, 13, 39, "Print"],
Cell[123639, 3625, 82, 1, 23, "Print"],
Cell[123724, 3628, 207, 4, 23, "Print"],
Cell[123934, 3634, 199, 4, 23, "Print"],
Cell[124136, 3640, 651, 13, 39, "Print"],
Cell[124790, 3655, 651, 13, 39, "Print"],
Cell[125444, 3670, 374, 8, 23, "Print"],
Cell[125821, 3680, 420, 8, 23, "Print"],
Cell[126244, 3690, 462, 8, 23, "Print"],
Cell[126709, 3700, 522, 10, 23, "Print"],
Cell[127234, 3712, 284, 5, 23, "Print"],
Cell[127521, 3719, 211, 4, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[127781, 3729, 28, 0, 44, "Section"],
Cell[127812, 3731, 45, 0, 32, "Text"],
Cell[127860, 3733, 141, 3, 27, "Input"],
Cell[128004, 3738, 137, 3, 27, "Input"],
Cell[128144, 3743, 483, 11, 91, "Input"],
Cell[128630, 3756, 637, 16, 75, "Input"],
Cell[129270, 3774, 188, 3, 59, "Input"],
Cell[129461, 3779, 174, 3, 27, "Input"],
Cell[129638, 3784, 63, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[129726, 3788, 50, 1, 27, "Input"],
Cell[129779, 3791, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[129854, 3797, 49, 1, 27, "Input"],
Cell[129906, 3800, 58, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[130001, 3806, 52, 1, 27, "Input"],
Cell[130056, 3809, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[130131, 3815, 136, 3, 27, "Input"],
Cell[130270, 3820, 524, 10, 23, "Print"],
Cell[130797, 3832, 536, 10, 23, "Print"],
Cell[131336, 3844, 548, 10, 23, "Print"],
Cell[131887, 3856, 571, 11, 39, "Print"],
Cell[132461, 3869, 282, 5, 23, "Print"],
Cell[132746, 3876, 145, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[132928, 3884, 148, 3, 27, "Input"],
Cell[133079, 3889, 448, 8, 23, "Print"],
Cell[133530, 3899, 205, 4, 23, "Print"],
Cell[133738, 3905, 199, 4, 23, "Print"],
Cell[133940, 3911, 467, 9, 23, "Print"],
Cell[134410, 3922, 340, 7, 23, "Print"],
Cell[134753, 3931, 205, 4, 23, "Print"],
Cell[134961, 3937, 479, 9, 23, "Print"],
Cell[135443, 3948, 82, 1, 23, "Print"],
Cell[135528, 3951, 330, 6, 23, "Print"],
Cell[135861, 3959, 199, 4, 23, "Print"],
Cell[136063, 3965, 760, 14, 55, "Print"],
Cell[136826, 3981, 465, 9, 23, "Print"],
Cell[137294, 3992, 205, 4, 23, "Print"],
Cell[137502, 3998, 643, 12, 39, "Print"],
Cell[138148, 4012, 82, 1, 23, "Print"],
Cell[138233, 4015, 205, 4, 23, "Print"],
Cell[138441, 4021, 199, 4, 23, "Print"],
Cell[138643, 4027, 670, 13, 39, "Print"],
Cell[139316, 4042, 340, 7, 23, "Print"],
Cell[139659, 4051, 526, 11, 39, "Print"],
Cell[140188, 4064, 205, 4, 23, "Print"],
Cell[140396, 4070, 693, 14, 39, "Print"],
Cell[141092, 4086, 302, 6, 23, "Print"],
Cell[141397, 4094, 903, 18, 55, "Print"],
Cell[142303, 4114, 438, 8, 23, "Print"],
Cell[142744, 4124, 636, 12, 39, "Print"],
Cell[143383, 4138, 666, 12, 39, "Print"],
Cell[144052, 4152, 280, 5, 23, "Print"],
Cell[144335, 4159, 289, 6, 59, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[144673, 4171, 28, 0, 44, "Section"],
Cell[144704, 4173, 45, 0, 32, "Text"],
Cell[144752, 4175, 151, 3, 27, "Input"],
Cell[144906, 4180, 143, 3, 27, "Input"],
Cell[145052, 4185, 557, 10, 107, "Input"],
Cell[145612, 4197, 1205, 29, 155, "Input"],
Cell[146820, 4228, 198, 3, 59, "Input"],
Cell[147021, 4233, 174, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[147220, 4240, 50, 1, 27, "Input"],
Cell[147273, 4243, 40, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[147350, 4249, 49, 1, 27, "Input"],
Cell[147402, 4252, 58, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[147497, 4258, 136, 3, 27, "Input"],
Cell[147636, 4263, 547, 11, 23, "Print"],
Cell[148186, 4276, 559, 11, 23, "Print"],
Cell[148748, 4289, 571, 11, 39, "Print"],
Cell[149322, 4302, 583, 11, 39, "Print"],
Cell[149908, 4315, 595, 11, 39, "Print"],
Cell[150506, 4328, 607, 11, 39, "Print"],
Cell[151116, 4341, 286, 5, 23, "Print"],
Cell[151405, 4348, 157, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[151599, 4356, 148, 3, 27, "Input"],
Cell[151750, 4361, 448, 8, 23, "Print"],
Cell[152201, 4371, 205, 4, 23, "Print"],
Cell[152409, 4377, 199, 4, 23, "Print"],
Cell[152611, 4383, 467, 9, 23, "Print"],
Cell[153081, 4394, 340, 7, 23, "Print"],
Cell[153424, 4403, 205, 4, 23, "Print"],
Cell[153632, 4409, 479, 9, 23, "Print"],
Cell[154114, 4420, 82, 1, 23, "Print"],
Cell[154199, 4423, 205, 4, 23, "Print"],
Cell[154407, 4429, 199, 4, 23, "Print"],
Cell[154609, 4435, 497, 9, 23, "Print"],
Cell[155109, 4446, 340, 7, 23, "Print"],
Cell[155452, 4455, 205, 4, 23, "Print"],
Cell[155660, 4461, 509, 9, 23, "Print"],
Cell[156172, 4472, 82, 1, 23, "Print"],
Cell[156257, 4475, 82, 1, 23, "Print"],
Cell[156342, 4478, 82, 1, 23, "Print"],
Cell[156427, 4481, 284, 6, 23, "Print"],
Cell[156714, 4489, 199, 4, 23, "Print"],
Cell[156916, 4495, 707, 15, 39, "Print"],
Cell[157626, 4512, 408, 8, 23, "Print"],
Cell[158037, 4522, 205, 4, 23, "Print"],
Cell[158245, 4528, 625, 12, 39, "Print"],
Cell[158873, 4542, 82, 1, 23, "Print"],
Cell[158958, 4545, 82, 1, 23, "Print"],
Cell[159043, 4548, 82, 1, 23, "Print"],
Cell[159128, 4551, 205, 4, 23, "Print"],
Cell[159336, 4557, 199, 4, 23, "Print"],
Cell[159538, 4563, 643, 12, 39, "Print"],
Cell[160184, 4577, 340, 7, 23, "Print"],
Cell[160527, 4586, 458, 9, 23, "Print"],
Cell[160988, 4597, 488, 9, 23, "Print"],
Cell[161479, 4608, 518, 9, 39, "Print"],
Cell[162000, 4619, 207, 4, 23, "Print"],
Cell[162210, 4625, 664, 13, 39, "Print"],
Cell[162877, 4640, 82, 1, 23, "Print"],
Cell[162962, 4643, 82, 1, 23, "Print"],
Cell[163047, 4646, 342, 6, 23, "Print"],
Cell[163392, 4654, 950, 17, 55, "Print"],
Cell[164345, 4673, 82, 1, 23, "Print"],
Cell[164430, 4676, 82, 1, 23, "Print"],
Cell[164515, 4679, 344, 6, 23, "Print"],
Cell[164862, 4687, 1101, 19, 71, "Print"],
Cell[165966, 4708, 82, 1, 23, "Print"],
Cell[166051, 4711, 82, 1, 23, "Print"],
Cell[166136, 4714, 82, 1, 23, "Print"],
Cell[166221, 4717, 82, 1, 23, "Print"],
Cell[166306, 4720, 82, 1, 23, "Print"],
Cell[166391, 4723, 207, 4, 23, "Print"],
Cell[166601, 4729, 199, 4, 23, "Print"],
Cell[166803, 4735, 980, 17, 55, "Print"],
Cell[167786, 4754, 340, 7, 23, "Print"],
Cell[168129, 4763, 538, 11, 39, "Print"],
Cell[168670, 4776, 1115, 19, 71, "Print"],
Cell[169788, 4797, 82, 1, 23, "Print"],
Cell[169873, 4800, 82, 1, 23, "Print"],
Cell[169958, 4803, 82, 1, 23, "Print"],
Cell[170043, 4806, 824, 15, 55, "Print"],
Cell[170870, 4823, 875, 16, 55, "Print"],
Cell[171748, 4841, 286, 5, 23, "Print"],
Cell[172037, 4848, 382, 7, 59, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[172468, 4861, 28, 0, 44, "Section"],
Cell[172499, 4863, 45, 0, 32, "Text"],
Cell[172547, 4865, 127, 3, 27, "Input"],
Cell[172677, 4870, 123, 3, 27, "Input"],
Cell[172803, 4875, 141, 3, 27, "Input"],
Cell[172947, 4880, 621, 14, 107, "Input"],
Cell[173571, 4896, 478, 12, 59, "Input"],
Cell[174052, 4910, 195, 3, 59, "Input"],
Cell[174250, 4915, 206, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[174481, 4923, 50, 1, 27, "Input"],
Cell[174534, 4926, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[174610, 4932, 49, 1, 27, "Input"],
Cell[174662, 4935, 58, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[174757, 4941, 136, 3, 27, "Input"],
Cell[174896, 4946, 541, 11, 23, "Print"],
Cell[175440, 4959, 553, 11, 23, "Print"],
Cell[175996, 4972, 577, 11, 39, "Print"],
Cell[176576, 4985, 589, 11, 39, "Print"],
Cell[177168, 4998, 601, 11, 39, "Print"],
Cell[177772, 5011, 284, 5, 23, "Print"],
Cell[178059, 5018, 154, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[178250, 5026, 151, 3, 27, "Input"],
Cell[178404, 5031, 479, 9, 23, "Print"],
Cell[178886, 5042, 205, 4, 23, "Print"],
Cell[179094, 5048, 199, 4, 23, "Print"],
Cell[179296, 5054, 477, 9, 23, "Print"],
Cell[179776, 5065, 205, 4, 23, "Print"],
Cell[179984, 5071, 199, 4, 23, "Print"],
Cell[180186, 5077, 495, 9, 23, "Print"],
Cell[180684, 5088, 340, 7, 23, "Print"],
Cell[181027, 5097, 374, 8, 23, "Print"],
Cell[181404, 5107, 205, 4, 23, "Print"],
Cell[181612, 5113, 507, 9, 23, "Print"],
Cell[182122, 5124, 507, 9, 23, "Print"],
Cell[182632, 5135, 390, 8, 23, "Print"],
Cell[183025, 5145, 205, 4, 23, "Print"],
Cell[183233, 5151, 519, 9, 23, "Print"],
Cell[183755, 5162, 82, 1, 23, "Print"],
Cell[183840, 5165, 205, 4, 23, "Print"],
Cell[184048, 5171, 540, 10, 23, "Print"],
Cell[184591, 5183, 82, 1, 23, "Print"],
Cell[184676, 5186, 304, 6, 23, "Print"],
Cell[184983, 5194, 199, 4, 23, "Print"],
Cell[185185, 5200, 769, 15, 55, "Print"],
Cell[185957, 5217, 428, 8, 23, "Print"],
Cell[186388, 5227, 306, 6, 23, "Print"],
Cell[186697, 5235, 880, 17, 55, "Print"],
Cell[187580, 5254, 207, 4, 23, "Print"],
Cell[187790, 5260, 199, 4, 23, "Print"],
Cell[187992, 5266, 804, 16, 39, "Print"],
Cell[188799, 5284, 340, 7, 23, "Print"],
Cell[189142, 5293, 577, 11, 39, "Print"],
Cell[189722, 5306, 619, 11, 39, "Print"],
Cell[190344, 5319, 649, 11, 39, "Print"],
Cell[190996, 5332, 284, 5, 23, "Print"],
Cell[191283, 5339, 280, 5, 43, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[191612, 5350, 29, 0, 44, "Section"],
Cell[191644, 5352, 45, 0, 32, "Text"],
Cell[191692, 5354, 197, 4, 43, "Input"],
Cell[191892, 5360, 206, 4, 43, "Input"],
Cell[192101, 5366, 1179, 24, 171, "Input"],
Cell[193283, 5392, 212, 4, 59, "Input"],
Cell[193498, 5398, 149, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[193672, 5405, 50, 1, 27, "Input"],
Cell[193725, 5408, 41, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[193803, 5414, 49, 1, 27, "Input"],
Cell[193855, 5417, 76, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[193968, 5423, 136, 3, 27, "Input"],
Cell[194107, 5428, 610, 12, 39, "Print"],
Cell[194720, 5442, 622, 12, 39, "Print"],
Cell[195345, 5456, 634, 12, 39, "Print"],
Cell[195982, 5470, 646, 12, 39, "Print"],
Cell[196631, 5484, 658, 12, 39, "Print"],
Cell[197292, 5498, 288, 5, 23, "Print"],
Cell[197583, 5505, 156, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[197776, 5513, 75, 1, 27, "Input"],
Cell[197854, 5516, 1937, 31, 283, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[199828, 5552, 77, 1, 27, "Input"],
Cell[199908, 5555, 41, 1, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[199998, 5562, 67, 0, 44, "Section"],
Cell[200068, 5564, 70, 1, 27, "Input"],
Cell[200141, 5567, 64, 1, 27, "Input"],
Cell[200208, 5570, 128, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[200361, 5576, 53, 1, 27, "Input"],
Cell[200417, 5579, 195, 3, 43, "Output"]
}, Open  ]],
Cell[200627, 5585, 50, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[200702, 5589, 84, 1, 27, "Input"],
Cell[200789, 5592, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[200864, 5598, 103, 2, 27, "Input"],
Cell[200970, 5602, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[201046, 5608, 102, 2, 27, "Input"],
Cell[201151, 5612, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[201226, 5618, 103, 2, 27, "Input"],
Cell[201332, 5622, 39, 1, 27, "Output"]
}, Open  ]],
Cell[201386, 5626, 40, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[201451, 5630, 81, 1, 27, "Input"],
Cell[201535, 5633, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[201610, 5639, 77, 1, 27, "Input"],
Cell[201690, 5642, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[201766, 5648, 77, 1, 27, "Input"],
Cell[201846, 5651, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[201921, 5657, 78, 1, 27, "Input"],
Cell[202002, 5660, 38, 1, 27, "Output"]
}, Open  ]],
Cell[202055, 5664, 40, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[202120, 5668, 76, 1, 27, "Input"],
Cell[202199, 5671, 38, 1, 27, "Output"]
}, Open  ]],
Cell[202252, 5675, 65, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[202342, 5679, 128, 2, 27, "Input"],
Cell[202473, 5683, 440, 8, 23, "Print"],
Cell[202916, 5693, 450, 8, 23, "Print"],
Cell[203369, 5703, 274, 5, 23, "Print"],
Cell[203646, 5710, 72, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[203755, 5716, 81, 1, 27, "Input"],
Cell[203839, 5719, 35, 1, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[203923, 5726, 30, 0, 44, "Section"],
Cell[203956, 5728, 40, 0, 32, "Text"],
Cell[203999, 5730, 59, 1, 27, "Input"],
Cell[204061, 5733, 65, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[204151, 5737, 88, 1, 27, "Input"],
Cell[204242, 5740, 530, 12, 23, "Print"],
Cell[204775, 5754, 272, 5, 23, "Print"],
Cell[205050, 5761, 78, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[205165, 5767, 50, 1, 27, "Input"],
Cell[205218, 5770, 83, 1, 27, "Output"]
}, Open  ]],
Cell[205316, 5774, 40, 0, 32, "Text"],
Cell[205359, 5776, 67, 1, 27, "Input"],
Cell[205429, 5779, 65, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[205519, 5783, 88, 1, 27, "Input"],
Cell[205610, 5786, 562, 12, 39, "Print"],
Cell[206175, 5800, 242, 6, 23, "Print"],
Cell[206420, 5808, 199, 4, 23, "Print"],
Cell[206622, 5814, 601, 14, 39, "Print"],
Cell[207226, 5830, 372, 8, 23, "Print"],
Cell[207601, 5840, 272, 5, 23, "Print"],
Cell[207876, 5847, 112, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[208025, 5854, 50, 1, 27, "Input"],
Cell[208078, 5857, 167, 3, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[208282, 5865, 88, 1, 27, "Input"],
Cell[208373, 5868, 562, 12, 39, "Print"],
Cell[208938, 5882, 254, 6, 23, "Print"],
Cell[209195, 5890, 199, 4, 23, "Print"],
Cell[209397, 5896, 613, 14, 39, "Print"],
Cell[210013, 5912, 378, 8, 23, "Print"],
Cell[210394, 5922, 272, 5, 23, "Print"],
Cell[210669, 5929, 115, 2, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[210833, 5937, 70, 0, 44, "Section"],
Cell[210906, 5939, 63, 0, 32, "Text"],
Cell[210972, 5941, 79, 1, 27, "Input"],
Cell[211054, 5944, 72, 1, 27, "Input"],
Cell[211129, 5947, 63, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[211217, 5951, 53, 1, 27, "Input"],
Cell[211273, 5954, 65, 1, 27, "Output"]
}, Open  ]],
Cell[211353, 5958, 239, 4, 75, "Input"],
Cell[211595, 5964, 133, 2, 43, "Input"],
Cell[211731, 5968, 248, 4, 75, "Input"],
Cell[211982, 5974, 31, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[212038, 5978, 65, 1, 27, "Input"],
Cell[212106, 5981, 37, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212180, 5987, 50, 1, 27, "Input"],
Cell[212233, 5990, 37, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212307, 5996, 67, 1, 27, "Input"],
Cell[212377, 5999, 37, 1, 27, "Output"]
}, Open  ]],
Cell[212429, 6003, 116, 2, 27, "Input"],
Cell[212548, 6007, 38, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[212611, 6011, 115, 2, 27, "Input"],
Cell[212729, 6015, 499, 9, 23, "Print"],
Cell[213231, 6026, 511, 9, 23, "Print"],
Cell[213745, 6037, 205, 4, 23, "Print"],
Cell[213953, 6043, 499, 9, 23, "Print"],
Cell[214455, 6054, 82, 1, 23, "Print"],
Cell[214540, 6057, 205, 4, 23, "Print"],
Cell[214748, 6063, 199, 4, 23, "Print"],
Cell[214950, 6069, 535, 11, 23, "Print"],
Cell[215488, 6082, 340, 7, 23, "Print"],
Cell[215831, 6091, 402, 8, 23, "Print"],
Cell[216236, 6101, 595, 11, 39, "Print"],
Cell[216834, 6114, 278, 5, 23, "Print"],
Cell[217115, 6121, 111, 2, 27, "Output"]
}, Open  ]],
Cell[217241, 6126, 37, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[217303, 6130, 128, 2, 27, "Input"],
Cell[217434, 6134, 452, 8, 23, "Print"],
Cell[217889, 6144, 276, 6, 23, "Print"],
Cell[218168, 6152, 199, 4, 23, "Print"],
Cell[218370, 6158, 615, 13, 39, "Print"],
Cell[218988, 6173, 400, 8, 23, "Print"],
Cell[219391, 6183, 278, 6, 23, "Print"],
Cell[219672, 6191, 691, 14, 55, "Print"],
Cell[220366, 6207, 82, 1, 23, "Print"],
Cell[220451, 6210, 276, 6, 23, "Print"],
Cell[220730, 6218, 199, 4, 23, "Print"],
Cell[220932, 6224, 778, 16, 55, "Print"],
Cell[221713, 6242, 400, 8, 23, "Print"],
Cell[222116, 6252, 276, 6, 23, "Print"],
Cell[222395, 6260, 850, 17, 55, "Print"],
Cell[223248, 6279, 82, 1, 23, "Print"],
Cell[223333, 6282, 264, 6, 23, "Print"],
Cell[223600, 6290, 199, 4, 23, "Print"],
Cell[223802, 6296, 922, 20, 55, "Print"],
Cell[224727, 6318, 388, 8, 23, "Print"],
Cell[225118, 6328, 264, 6, 23, "Print"],
Cell[225385, 6336, 993, 22, 55, "Print"],
Cell[226381, 6360, 448, 9, 23, "Print"],
Cell[226832, 6371, 629, 13, 39, "Print"],
Cell[227464, 6386, 792, 16, 55, "Print"],
Cell[228259, 6404, 278, 5, 23, "Print"],
Cell[228540, 6411, 283, 5, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[228860, 6421, 76, 1, 27, "Input"],
Cell[228939, 6424, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[229014, 6430, 82, 1, 27, "Input"],
Cell[229099, 6433, 38, 1, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[229186, 6440, 38, 0, 44, "Section"],
Cell[229227, 6442, 131, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[229383, 6448, 53, 1, 27, "Input"],
Cell[229439, 6451, 56, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[229532, 6457, 53, 1, 27, "Input"],
Cell[229588, 6460, 246, 4, 43, "Output"]
}, Open  ]],
Cell[229849, 6467, 65, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[229939, 6471, 104, 2, 27, "Input"],
Cell[230046, 6475, 681, 15, 39, "Print"],
Cell[230730, 6492, 264, 6, 23, "Print"],
Cell[230997, 6500, 199, 4, 23, "Print"],
Cell[231199, 6506, 687, 15, 55, "Print"],
Cell[231889, 6523, 388, 8, 23, "Print"],
Cell[232280, 6533, 274, 5, 23, "Print"],
Cell[232557, 6540, 150, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[232744, 6548, 53, 1, 27, "Input"],
Cell[232800, 6551, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[232875, 6557, 65, 1, 27, "Input"],
Cell[232943, 6560, 39, 1, 27, "Output"]
}, Open  ]],
Cell[232997, 6564, 177, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[233199, 6572, 125, 3, 27, "Input"],
Cell[233327, 6577, 58, 1, 27, "Output"]
}, Open  ]],
Cell[233400, 6581, 183, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[233608, 6589, 125, 3, 27, "Input"],
Cell[233736, 6594, 58, 1, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[233843, 6601, 29, 0, 44, "Section"],
Cell[233875, 6603, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[234040, 6609, 53, 1, 27, "Input"],
Cell[234096, 6612, 59, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[234192, 6618, 90, 1, 27, "Input"],
Cell[234285, 6621, 717, 15, 39, "Print"],
Cell[235005, 6638, 260, 6, 23, "Print"],
Cell[235268, 6646, 199, 4, 23, "Print"],
Cell[235470, 6652, 697, 15, 55, "Print"],
Cell[236170, 6669, 384, 8, 23, "Print"],
Cell[236557, 6679, 264, 6, 23, "Print"],
Cell[236824, 6687, 772, 17, 55, "Print"],
Cell[237599, 6706, 82, 1, 23, "Print"],
Cell[237684, 6709, 270, 6, 23, "Print"],
Cell[237957, 6717, 199, 4, 23, "Print"],
Cell[238159, 6723, 850, 18, 55, "Print"],
Cell[239012, 6743, 242, 6, 23, "Print"],
Cell[239257, 6751, 199, 4, 23, "Print"],
Cell[239459, 6757, 907, 22, 55, "Print"],
Cell[240369, 6781, 372, 8, 23, "Print"],
Cell[240744, 6791, 464, 10, 23, "Print"],
Cell[241211, 6803, 264, 6, 23, "Print"],
Cell[241478, 6811, 983, 23, 55, "Print"],
Cell[242464, 6836, 242, 6, 23, "Print"],
Cell[242709, 6844, 199, 4, 23, "Print"],
Cell[242911, 6850, 1017, 24, 71, "Print"],
Cell[243931, 6876, 372, 8, 23, "Print"],
Cell[244306, 6886, 1033, 24, 71, "Print"],
Cell[245342, 6912, 82, 1, 23, "Print"],
Cell[245427, 6915, 585, 13, 39, "Print"],
Cell[246015, 6930, 718, 16, 39, "Print"],
Cell[246736, 6948, 278, 5, 23, "Print"],
Cell[247017, 6955, 291, 5, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[247345, 6965, 61, 1, 27, "Input"],
Cell[247409, 6968, 37, 1, 27, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

