(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   3034321,      82970]
NotebookOptionsPosition[   2936078,      81544]
NotebookOutlinePosition[   2940916,      81656]
CellTagsIndexPosition[   2940666,      81645]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xAct`Invar`",
 FontSize->18]], "Section",
 CellTags->{
  "S5.18.1", "1.1"},ExpressionUUID->"95229f0a-4f2c-4f6c-85de-2f332c3b53da"],

Cell[CellGroupData[{

Cell["Intro", "SubsubsectionIcon",ExpressionUUID->"9f4e909a-56cc-4bb0-baaa-7f7b711b0aa1"],

Cell[TextData[{
 StyleBox["Invar`", "MR"],
 " ",
 StyleBox["is currently a package for efficient simplification of the \
algebraic and differential polynomial scalars (usually known as ", "TI",
  FontSlant->"Plain"],
 StyleBox["invariants", "TI"],
 StyleBox[") of the Riemann tensor of a metric-compatible connection. The \
medium term goal is generalizing ", "TI",
  FontSlant->"Plain"],
 StyleBox["Invar`", "MR"],
 " ",
 StyleBox["to simplify generic polynomial expressions (with free indices) of \
the Riemann tensor.", "TI",
  FontSlant->"Plain"],
 "\n",
 StyleBox["Invar`", "MR"],
 " requires the tensor computer algebra system ",
 StyleBox["xTensor`", "MR"],
 " when running on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". There is a twin version for Maple, based on the tensor system ",
 StyleBox["Canon",
  FontFamily->"Courier"],
 ". It can be downloaded, under the General Public Licence, from\n\t\
http://www.xact.es/\n\thttp://www.lncc.br/~portugal/\t\t(Maple version)"
}], "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"5e561de9-6cba-46d4-8e6e-5138239bae61"],

Cell[TextData[{
 "For further information, see the articles\n\t ",
 StyleBox["The Invar tensor package",
  FontSlant->"Italic"],
 ", J.M. Mart\[IAcute]n-Garc\[IAcute]a, R. Portugal and L.R.U. Manssur, Comp. \
Phys. Comm. ",
 StyleBox["177",
  FontWeight->"Bold"],
 ", 640",
 StyleBox[" (",
  FontWeight->"Bold"],
 "2007)\n\t ",
 StyleBox["The Invar tensor package: Differential invariants of Riemann, ",
  FontSlant->"Italic"],
 "J.M. Mart\[IAcute]n-Garc\[IAcute]a, D. Yllanes and R. Portugal, Comp. Phys. \
Comm. (2008)"
}], "Text",ExpressionUUID->"15715c74-9900-4b79-9591-2e99c07a4e4d"],

Cell[TextData[{
 "Subsection 6.3 contains a number of tests designed to check most \
capabilities of ",
 StyleBox["Invar`",
  FontFamily->"Courier"],
 ". They all should give zero."
}], "Text",ExpressionUUID->"0d55cbae-f2d6-41b2-b2c5-97d663515206"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load the package and configure", "SubsubsectionIcon",ExpressionUUID->"52cdd88b-6efe-41b9-808f-8afcbbbaef54"],

Cell[TextData[{
 StyleBox["Invar`",
  FontFamily->"Courier"],
 " can be downloaded as part of the xAct distribution in\n\t\
http://www.xact.es/\nFor a single-user installation under Linux the file \
xAct_<version>.tar.gz must be unpacked in the directory $Home/.",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "/Applications giving a directory xAct. The ",
 StyleBox["Invar`",
  FontFamily->"Courier"],
 " package will be a subdirectory then. We assume that configuration in the \
following. See the Readme file for more information, including installation \
instructions for other operating systems."
}], "Text",ExpressionUUID->"069af325-2531-4bc6-8aff-8801010d1049"],

Cell[TextData[{
 "We first load the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, and the ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " package from the default directory"
}], "MathCaption",
 CellTags->{
  "S5.18.1", "1.3"},ExpressionUUID->"4cb05a38-c464-4d2a-b6a7-c23587bd2184"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mathRAM", "=", 
  RowBox[{"MemoryInUse", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"784d1685-a2f4-4adc-b4f9-052858a9f3bf"],

Cell[BoxData["40372912"], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"d5b1d761-b62f-49e8-b160-374ec7ac0567"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`xTensor`"}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"604cb0c5-5fe5-40e1-b9c9-ee74a0923384"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"b6246ca2-c176-470f-bb16-0d2f93c99ceb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"3dba33df-531f-4b4d-ac21-6ba068402f3c"],

Cell[BoxData["\<\"CopyRight (C) 2003-2018, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"f7e0df2b-8802-434b-95a4-a42dafe72b1a"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"380edefa-4585-4186-b3bf-05db781d60ce"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"7bf7dedf-e8c1-47d8-b7a3-255a7378e03b"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"76e8a793-fbb9-4cf4-a9d1-a4b01ce1fcbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.3", ", ", {2018, 2, 28}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"15e20eec-a38f-4016-8fe7-61093ed847b5"],

Cell[BoxData["\<\"CopyRight (C) 2002-2018, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"bb5a37c5-62f8-4389-8c10-f2fbdff58b30"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"083bdf50-7093-4094-91ad-9dc0e0a3bf74"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"049e6141-c613-4a47-98ac-dab2bc29755a"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"53fcaba1-1ab7-4daa-929e-35a135921e79"]
}, Open  ]],

Cell[TextData[{
 "Note: When loading ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " inside a Windows environment, a black DOS-like window may appear. This is \
caused by the C link used to speed computations and should not be closed."
}], "MathCaption",ExpressionUUID->"9ae54793-d687-47d1-9189-8ac0c66cedcd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xtensorRAM", "=", 
  RowBox[{
   RowBox[{"MemoryInUse", "[", "]"}], "-", "mathRAM"}]}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"dc7b813d-79ab-45fd-9bc7-62d2512feeb5"],

Cell[BoxData["23873112"], "Output",
 CellLabel->"Out[3]=",ExpressionUUID->"6ea5872b-2489-4a0d-8900-7a45f5b9289c"]
}, Open  ]],

Cell[TextData[{
 "Then we read the ",
 StyleBox["Invar`",
  FontFamily->"Courier"],
 " package. "
}], "MathCaption",ExpressionUUID->"5b62c56e-118e-4f06-a502-65090e38a50a"],

Cell[CellGroupData[{

Cell["<<xAct`Invar`", "Input",
 CellTags->"S5.18.1",
 CellLabel->"In[4]:=",ExpressionUUID->"b5a5bcf3-4925-425b-bacb-c552f4aaa752"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"253105a7-7558-4f8c-a459-f81a4d3b8782"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Invar`  version \"\>", 
   "\[InvisibleSpace]", "\<\"2.0.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2013", ",", "7", ",", "1"}], "}"}]}],
  SequenceForm["Package xAct`Invar`  version ", "2.0.5", ", ", {2013, 7, 1}],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"f82bbbb8-78ff-4eb9-b834-ecf3273e2312"],

Cell[BoxData["\<\"CopyRight (C) 2006-2018, J. M. Martin-Garcia, D. Yllanes \
and R. Portugal, under the General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ee493300-3d7d-42ff-9554-84906ca3a025"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"8d4f3817-aa58-41e8-b671-37151fc41f9c"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"0f33d0e1-db2d-42d3-b3cf-89918afad497"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"b090c1f6-fbbf-46eb-8613-9b7592a8241e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "sigma", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", "constant symbol ", 
   xAct`Invar`sigma, ". ", ""],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"6fc64047-0241-44ec-940c-c7621a339aa6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "dim", "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", "constant symbol ", 
   xAct`Invar`dim, ". ", ""],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"def51e1e-577e-47b1-a311-2aaa2e7b778b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9d6d4e3d-616a-4652-93fd-5f905a6755dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$PrePrint", 
   "\[InvisibleSpace]", "\<\" assigned value \"\>", "\[InvisibleSpace]", 
   "ScreenDollarIndices"}],
  SequenceForm[
  "** Variable ", $PrePrint, " assigned value ", 
   xAct`xTensor`ScreenDollarIndices],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"4de44ac2-299c-4940-8d8e-a258efaa977b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$CovDFormat", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", 
   "\[InvisibleSpace]", "\<\"Prefix\"\>", "\[InvisibleSpace]", "\<\" to \"\>",
    "\[InvisibleSpace]", "\<\"Postfix\"\>"}],
  SequenceForm[
  "** Variable ", xAct`xTensor`$CovDFormat, " changed from ", "Prefix", 
   " to ", "Postfix"],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1a946cab-d97c-444e-b1df-3c80e5e7ba20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "CurvatureRelations", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "True",
    "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "** Option ", xAct`xTensor`CurvatureRelations, " of ", xAct`xTensor`DefCovD,
    " changed from ", True, " to ", False],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"e8d54501-e47d-41f6-a3bf-aff6df42f7c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", 
   "$CommuteCovDsOnScalars", "\[InvisibleSpace]", "\<\" changed from \"\>", 
   "\[InvisibleSpace]", "True", "\[InvisibleSpace]", "\<\" to \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "** Variable ", xAct`xTensor`$CommuteCovDsOnScalars, " changed from ", True,
    " to ", False],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"00c2447d-7a27-490c-bf74-ccbac90cae6d"]
}, Open  ]],

Cell[TextData[{
 "We see that, in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5, the ",
 StyleBox["MathKernel",
  FontSlant->"Italic"],
 " takes only 2 Mbytes, ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " takes 9 Mbytes, and ",
 StyleBox["Invar`",
  FontFamily->"Courier"],
 " takes 41 Mbytes:"
}], "MathCaption",ExpressionUUID->"e2beab05-b809-4d45-9ea2-093825b280e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"invarRAM", "=", 
  RowBox[{
   RowBox[{"MemoryInUse", "[", "]"}], "-", "mathRAM", "-", 
   "xtensorRAM"}]}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"dcb521a3-5b94-4906-98da-e8dbbc7e7c23"],

Cell[BoxData["677048"], "Output",
 CellLabel->"Out[5]=",ExpressionUUID->"8cb34e5c-b385-483c-a597-b9c2df7b1d5a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"mathRAM", ",", "xtensorRAM", ",", "invarRAM"}], "]"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"ce55949b-b9fd-448d-81d2-15cba0b319df"],

Cell[TextData[{
 "Note the structure of the ContextPath. There are six contexts: ",
 Cell[BoxData["\<\"xAct`Invar`\"\>"], "Output",ExpressionUUID->
  "3e3e2d99-1cd7-4a55-bc9c-a428c31c930a"],
 ", ",
 StyleBox["xAct`xTensor`",
  FontFamily->"Courier"],
 ", ",
 StyleBox["xAct`xPerm`",
  FontFamily->"Courier"],
 " and ",
 StyleBox["xAct`ExpressionManipulation`",
  FontFamily->"Courier"],
 " contain the respective reserved words. ",
 StyleBox["System`",
  FontFamily->"Courier"],
 " contains ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s reserved words. The current context ",
 StyleBox["Global`",
  FontFamily->"Courier"],
 " will contain your definitions and right now it is empty."
}], "MathCaption",ExpressionUUID->"b5ca50c6-ba6d-4178-8078-62bfd63367a9"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"317d9b93-a8c1-4433-9a8a-d7d330b5e871"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`Invar`\"\>", ",", "\<\"xAct`ExpressionManipulation`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"PacletManager`\"\>", 
   ",", "\<\"QuantityUnits`\"\>", ",", "\<\"WebServices`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[7]=",ExpressionUUID->"5adb3047-78b1-47dc-8840-63dad6c53969"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "]"}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"081a521e-d661-4469-b8cc-5bef2ecbcc0e"],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellLabel->"Out[8]=",ExpressionUUID->"9738940e-f994-4ef0-ba4c-7028f89ab71e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"899f4a32-65cc-44f0-bc0a-58f02d29409c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Information", "::", "nomatch"}], "MessageName"], ":", 
  " ", "\<\"No symbol matching \[NoBreak]\\!\\(\\\"Global`*\\\"\\)\[NoBreak] \
found. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Information/nomatch\\\", ButtonNote -> \
\\\"Information::nomatch\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"4c205121-3b7e-47c9-8279-846bc545c1ab"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1. Example session",
 FontSize->14]], "SubsectionIcon",ExpressionUUID->"64939b34-1365-492f-bf40-277bfb58132e"],

Cell[TextData[{
 "This is a simple example of the use of ",
 StyleBox["Invar`",
  FontFamily->"Courier"],
 ". The package is very easy to use: all its capabilities can be controlled \
through 10 basic commands. In addition, you will have to setup a basic",
 StyleBox[" xTensor`",
  FontFamily->"Courier New"],
 " session, which we proceed to do now. We need to start by defining the \
manifold and metric of the Riemann tensor. For information on ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " see the file xTensorDoc.nb."
}], "Text",ExpressionUUID->"cd0a8455-aba8-4dd0-85f8-6ce604515409"],

Cell[TextData[{
 "Define a 4d manifold ",
 StyleBox["M",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"23fc96e9-397d-418d-a158-0b523b5ff486"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h",
      ",", "i", ",", "j", ",", "k", ",", "l", ",", "m", ",", "n"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"4137353b-a384-4857-b07b-9dfee130e11f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"6e742740-2bc4-4ffe-966e-968731fc2fd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"44eabc8c-15cb-4170-afd9-5047e2f515b2"]
}, Open  ]],

Cell["\<\
Define a metric with negative determinant, with associated Levi-Civita \
connection CD:\
\>", "MathCaption",ExpressionUUID->"a4d3e3ee-15eb-401a-afee-f940ad9b97ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"metric", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}], ",", 
   RowBox[{"CurvatureRelations", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"cbaaab2b-6cc8-412b-b74e-dce089c2067e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"metric", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`metric[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"27b86e8c-e998-4c35-836c-7991dd693ecf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilonmetric", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilonmetric[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"616fe641-9a69-40df-b8e5-83b4710797d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrametric", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrametric[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"414cb4c5-333c-44e4-a6de-3ee93605f904"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrametric\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrametric\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"6357b510-9877-4b1a-ac26-432abb9e7e24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"65311fe7-477e-48f3-b2e5-f3d63cb9af5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"a73b3d60-5d06-4eb4-a700-a0a53e4be862"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"9ecafd1c-7b7b-44c1-8c25-05ecdbdae58d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"216f4798-0e35-47ac-b093-980ed4a6a54d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"1c1202da-209e-47e2-a1de-d212fcd1951b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"c5e21d11-a119-4bf4-b4fb-f76c2e696342"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"b55969f7-e3ef-4f68-8a3f-adec15f15cc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"9a647be1-f665-4a76-81db-1bf0336c61f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"a273d736-b87d-45b8-bd53-a5f217df24ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"b5e785b2-26eb-4095-9cfb-60241be4906b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"286e5d53-1298-403c-9476-75a47502949c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"c3d64c3c-c6bf-4f9e-b8cc-2276f73b0de0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"408e52a0-459d-4846-9304-309d6a30ebc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detmetric", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detmetric[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"abf1ab15-8fe7-4d6a-babd-6eeb73fde205"]
}, Open  ]],

Cell["\<\
We included the option CurvatureRelations -> False so contractions of \
Riemanns will not be converted into Riccis. This is essential for the proper \
use of Invar, and in fact Invar automatically changes the default value for \
that option, so it was not really necessary to specify it in the latter \
command. A number of tensors have been automatically defined. In particular \
there are the three curvature tensor fields\
\>", "MathCaption",ExpressionUUID->"2dc7298c-0e68-4db7-9acc-e5955834fd4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"95b0cc2d-ef77-4cc4-9447-469c36e2bd36"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[12]=",ExpressionUUID->"102c79aa-34dc-4db1-832e-a414fa509af3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RicciCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"d9d54ae2-8047-4057-9627-7a8ce52c4763"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RicciCD[-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[13]=",ExpressionUUID->"133bf7db-48d4-499d-8e15-f302d7f7b562"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RicciScalarCD", "[", "]"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"3bd4e09f-493d-44ff-843e-f2bf421184cb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RicciScalarCD[],
  Editable->False]], "Output",
 CellLabel->"Out[14]=",ExpressionUUID->"73f6ac6d-1e10-44e7-a8dd-9891e3525401"]
}, Open  ]],

Cell["and their traceless counterparts:", "MathCaption",ExpressionUUID->"35fa1181-86b5-48df-9e70-c7e9543726ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeylCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"3a209fc9-15d5-4943-8a41-06bac7f507e6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[15]=",ExpressionUUID->"23fe7d80-48f9-4339-b1cf-36be9203f648"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TFRicciCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"6338e72e-6433-48d1-bf88-de5b513ce244"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"S", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[16]=",ExpressionUUID->"fb3d322c-c471-4a19-9825-3c9c12a313ac"]
}, Open  ]],

Cell["with their expected trace properties:", "MathCaption",ExpressionUUID->"f4867f36-e361-480e-8a7e-2c0c6b9d725f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeylCD", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "a"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"b3afdd56-0b0d-4eaf-a357-5335e05213b3"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[17]=",ExpressionUUID->"19ddafbd-c799-4aef-a134-4bf600127464"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TFRicciCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", "a"}], "]"}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"974c607a-8398-4f56-b1fa-1e0e747c9099"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[18]=",ExpressionUUID->"6c92d3e8-6929-4498-bbd0-d9814890be4f"]
}, Open  ]],

Cell[TextData[{
 "The Riemann and Ricci tensors are not automatically replaced when they have \
contracted indices. Use ",
 StyleBox["ContractCurvature",
  FontWeight->"Bold"],
 " to do that:"
}], "MathCaption",ExpressionUUID->"2a4721ca-0136-4a4e-9c58-4a830764f0d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannCD", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "a"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"0a3abd8b-4a6e-436b-a512-7d6d94e8111b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {"a", " ", " ", " "},
         {" ", "b", "c", "a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`a],
  Editable->False]], "Output",
 CellLabel->"Out[19]=",ExpressionUUID->"52bec6dd-94f2-4a7b-b8d8-7f84fb5c73d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractCurvature", "[", "%", "]"}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"10842212-131c-43f6-96e5-4ba4c971bce2"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"b", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCD[-$CellContext`b, -$CellContext`c],
   Editable->False]}]], "Output",
 CellLabel->"Out[20]=",ExpressionUUID->"dae0da6a-4368-40f6-a821-ac9e11a258b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RicciCD", "[", 
  RowBox[{
   RowBox[{"-", "b"}], ",", "b"}], "]"}]], "Input",
 CellLabel->"In[21]:=",ExpressionUUID->"43e2e608-46d4-4584-a3bf-a88e8407737a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", "b"},
         {"b", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RicciCD[-$CellContext`b, $CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[21]=",ExpressionUUID->"99b42f62-a6b8-4b3f-b6f2-962c6cbd06fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractCurvature", "[", "%", "]"}]], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"cb8bd7f8-c5a5-4a3f-b8c0-b251257e89c0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RicciScalarCD[],
  Editable->False]], "Output",
 CellLabel->"Out[22]=",ExpressionUUID->"cb74b783-380f-4ada-b5fe-a773e088f03c"]
}, Open  ]],

Cell[TextData[{
 "We can change the output form of the tensors (note the use of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " downvalues ^= )"
}], "MathCaption",ExpressionUUID->"03e11c8d-4089-4291-aa98-d8de7629d48e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "metric", "]"}], "^=", "\"\<g\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "epsilonmetric", "]"}], "^=", 
   "\"\<\[Epsilon]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RiemannCD", "]"}], "^=", "\"\<R\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RicciCD", "]"}], "^=", "\"\<R\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RicciScalarCD", "]"}], "^=", "\"\<R\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "WeylCD", "]"}], "^=", "\"\<W\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "TFRicciCD", "]"}], "^=", "\"\<S\>\""}], 
  ";"}]}], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"a3dde2d9-f2b0-4098-affc-a7feb86f73d7"],

Cell[TextData[{
 "So much for ",
 StyleBox["xTensor`",
  FontFamily->"Courier New"],
 ". You will not need many more ",
 StyleBox["xTensor`",
  FontFamily->"Courier New"],
 " functions to work with ",
 StyleBox["Invar`",
  FontFamily->"Courier"],
 ", but you will be able to do it more efficiently if you read the specific \
documentation for that package. Now we can start using the commands added by \
the package ",
 StyleBox["Invar`:",
  FontFamily->"Courier"]
}], "Text",ExpressionUUID->"27688bab-8825-45b2-8364-8da58d1c4367"],

Cell["A typical algebraic Riemann scalar could be", "MathCaption",ExpressionUUID->"0f43269c-46cc-4b9b-861f-d8390e3fec04"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannCD", "[", 
   RowBox[{"a", ",", "b", ",", 
    RowBox[{"-", "c"}], ",", "e"}], "]"}], 
  RowBox[{"RiemannCD", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "e"}], ",", 
    RowBox[{"-", "f"}], ",", "d"}], "]"}], 
  RowBox[{"RiemannCD", "[", 
   RowBox[{"c", ",", "f", ",", 
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "d"}]}], "]"}]}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"b895ebf1-9750-46f5-8f96-2ee1ae7c55d2"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"R", 
       StyleBox[GridBox[{
          {"a", "b", " ", "e"},
          {" ", " ", "c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`c, \
$CellContext`e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"R", 
       StyleBox[GridBox[{
          {" ", " ", " ", "d"},
          {"b", "e", "f", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`b, -$CellContext`e, -$CellContext`f, \
$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"R", 
       StyleBox[GridBox[{
          {"c", "f", " ", " "},
          {" ", " ", "a", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[$CellContext`c, $CellContext`f, -$CellContext`a, \
-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[30]=",ExpressionUUID->"84325f27-5b61-43dd-8d57-0a5af2917c51"]
}, Open  ]],

Cell["which simplifies to", "MathCaption",ExpressionUUID->"7b17c912-7c97-4a1d-8605-00f48def8cf0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannSimplify", "[", "%", "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"d8c87418-56c8-4d43-b24a-c13a4714af95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"12d1428c-526a-4b07-988d-08b4b842ea3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"09abe4d0-eab5-46ce-95ca-2299f8180e09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"97758453-7d8c-479a-8725-defd7efae4cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"ecd6ed36-02b2-4e93-a4c2-f8d7602fa59c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"2f8b19b6-3cf5-4244-8ff4-f6f403ae2f95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"4756af68-d609-469c-8133-af2f7c7d6ef3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.30105599999999999027977537480182945728`5.4992472003315935", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", " ", "e", "f"},
                {"a", "b", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", "b", "c", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", " ", " ", " "},
                {"c", "d", "e", "f"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, $CellContext`e, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f]],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->"Out[31]=",ExpressionUUID->"52a8e3d1-23d8-4e64-ae6a-48c23bd43cdb"]
}, Open  ]],

Cell["\<\
Notice how the different rules are read on the fly. We do not read them \
automatically because they would need several GB of memory.  They are read \
only once (note the shorter timing now):\
\>", "MathCaption",ExpressionUUID->"19c915d1-3edf-40f0-bd4a-66198405c3ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannSimplify", "[", "%%", "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"2e5f0474-7bc0-4389-a76f-ea05a73b69ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.02199800000000000019251267247000214411`4.362983110990579", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", " ", "e", "f"},
                {"a", "b", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", "b", "c", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", " ", " ", " "},
                {"c", "d", "e", "f"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, $CellContext`e, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f]],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->"Out[32]=",ExpressionUUID->"2b779652-5afa-4cc7-89fa-ca0f671d163c"]
}, Open  ]],

Cell[TextData[{
 "The head ",
 StyleBox["Scalar",
  FontFamily->"Courier"],
 " is introduced to avoid problems of index collisions.It can be removed \
using ",
 StyleBox["NoScalar",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"52d13694-433f-47e0-b16e-1c6db67b230e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Last", "[", "%", "]"}], "//", "NoScalar"}]], "Input",
 CellLabel->"In[33]:=",ExpressionUUID->"1b1363f4-e6e4-44de-b292-88bd0bdbf39f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"R", 
       StyleBox[GridBox[{
          {" ", " ", "e", "f"},
          {"a", "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, $CellContext`e, \
$CellContext`f],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"R", 
       StyleBox[GridBox[{
          {"a", "b", "c", "d"},
          {" ", " ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"R", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"c", "d", "e", "f"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, -$CellContext`e, \
-$CellContext`f],
   Editable->False]}]], "Output",
 CellLabel->"Out[33]=",ExpressionUUID->"34e071c4-1661-41f0-ae68-da455be619f8"]
}, Open  ]],

Cell[TextData[{
 "We can generate random Riemann invariants using the command ",
 StyleBox["RandomRiemannMonomial",
  FontFamily->"Courier New"],
 ", having as argument the case (see Section 2), in this example {0,4}, \
meaning one Riemann with no derivatives and another with a fourth \
derivative:"
}], "MathCaption",ExpressionUUID->"28052648-ba31-4a2e-a8da-69d830f82f2b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"RandomRiemannMonomial", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}], "]"}], "//", "NoScalar"}]}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"21b756e8-963b-4a22-b00f-163604f4681c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"R", 
       StyleBox[GridBox[{
          {"f", "a", " ", " "},
          {" ", " ", "a", "e"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[$CellContext`f, $CellContext`a, -$CellContext`a, \
-$CellContext`e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"R", 
       StyleBox[GridBox[{
          {" ", "b", " ", " ", "  ", 
           RowBox[{";", "c"}], 
           RowBox[{";", "d"}], 
           RowBox[{";", "e"}]},
          {"f", " ", "b", "c", 
           RowBox[{";", "d"}], "  ", "  ", "  "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[$CellContext`e][
    $CellContext`CD[$CellContext`d][
     $CellContext`CD[$CellContext`c][
      $CellContext`CD[-$CellContext`d][
       $CellContext`RiemannCD[-$CellContext`f, $CellContext`b, \
-$CellContext`b, -$CellContext`c]]]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[34]=",ExpressionUUID->"4e0517fc-b3a5-4ea0-8621-86001b48abc9"]
}, Open  ]],

Cell["\<\
Any monomial can be canonicalized into one of a predefined list of canonical \
invariants. For the case {0,4} the list contains 126 canonical invariants, \
apart from the trivial canonical 0. \
\>", "MathCaption",ExpressionUUID->"eb09d9ff-435d-4b16-afbd-605557e7519f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaxIndex", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"3d3e0a8d-a1a2-429f-b859-bb06a420dcbf"],

Cell[BoxData["126"], "Output",
 CellLabel->"Out[35]=",ExpressionUUID->"e8b973b0-3f38-4954-b7dc-470563f7fa25"]
}, Open  ]],

Cell["In particular, the previous object canonicalizes to", "MathCaption",ExpressionUUID->"34466f62-c4ba-4757-94a0-e52c772d9f3e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", "expr", "]"}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"71a0ed77-6ac9-4808-a309-23fcb5a073ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"08624004-1044-4d8b-b9e3-3670fb231b9c"],

Cell[BoxData[
 RowBox[{"-", 
  SubscriptBox["\<\"I\"\>", "\<\"04,21\"\>"]}]], "Output",
 CellLabel->"Out[36]=",ExpressionUUID->"76e05e2c-5411-4c68-a4ed-88ac28e58c9e"]
}, Open  ]],

Cell["\<\
Many of the invariants actually do canonicalize to 0 so we iterate those two \
commands until we get something different from zero:\
\>", "MathCaption",ExpressionUUID->"d986c5a4-683b-4bed-809a-9bfb7efd5de3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"inv", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"inv", "===", "0"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"expr", "=", 
      RowBox[{
       RowBox[{"RandomRiemannMonomial", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}], "]"}], "//", "NoScalar"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"inv", "=", 
      RowBox[{"RiemannToInv", "[", "expr", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"ScreenDollarIndices", "[", "expr", "]"}], ",", "\"\< -> \>\"",
        ",", "inv"}], "]"}]}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[37]:=",ExpressionUUID->"e3f641ba-26f1-4ed7-9856-f78beb151eaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"b", "a", "f", "e"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RiemannCD[$CellContext`b, $CellContext`a, $CellContext`f, \
$CellContext`e],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"c", " ", " ", " ", "  ", "  ", "  ", 
             RowBox[{";", "d"}]},
            {" ", "c", "d", "f", 
             RowBox[{";", "b"}], 
             RowBox[{";", "a"}], 
             RowBox[{";", "e"}], "  "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`d][
      $CellContext`CD[-$CellContext`e][
       $CellContext`CD[-$CellContext`a][
        $CellContext`CD[-$CellContext`b][
         $CellContext`RiemannCD[$CellContext`c, -$CellContext`c, \
-$CellContext`d, -$CellContext`f]]]]],
     Editable->False]}], "\[InvisibleSpace]", "\<\" -> \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm[$CellContext`RiemannCD[$CellContext`b, $CellContext`a, \
$CellContext`f, $CellContext`e] $CellContext`CD[$CellContext`d][
     $CellContext`CD[-$CellContext`e][
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[$CellContext`c, -$CellContext`c, \
-$CellContext`d, -$CellContext`f]]]]], " -> ", 0],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"a8310cc4-235b-4dbc-989a-669c3375b651"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {" ", "d", " ", " "},
            {"a", " ", "f", "e"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RiemannCD[-$CellContext`a, $CellContext`d, -$CellContext`f, \
-$CellContext`e],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"e", "a", "c", " ", 
             RowBox[{";", "b"}], "  ", 
             RowBox[{";", "f"}], "  "},
            {" ", " ", " ", "d", "  ", 
             RowBox[{";", "c"}], "  ", 
             RowBox[{";", "b"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`b][
      $CellContext`CD[$CellContext`f][
       $CellContext`CD[-$CellContext`c][
        $CellContext`CD[$CellContext`b][
         $CellContext`RiemannCD[$CellContext`e, $CellContext`a, \
$CellContext`c, -$CellContext`d]]]]],
     Editable->False]}], "\[InvisibleSpace]", "\<\" -> \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    SubscriptBox["\<\"I\"\>", "\<\"04,95\"\>"]}]}],
  SequenceForm[$CellContext`RiemannCD[-$CellContext`a, $CellContext`d, \
-$CellContext`f, -$CellContext`e] $CellContext`CD[-$CellContext`b][
     $CellContext`CD[$CellContext`f][
      $CellContext`CD[-$CellContext`c][
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`e, $CellContext`a, \
$CellContext`c, -$CellContext`d]]]]], " -> ", -
   xAct`Invar`RInv[$CellContext`metric][{0, 4}, 95]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"276eca9c-7058-4818-a388-87df9884a8a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", "expr", "]"}]], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"4b022a1a-090f-4f8f-9023-6e4f8b773d25"],

Cell[BoxData[
 RowBox[{"-", 
  SubscriptBox["\<\"I\"\>", "\<\"04,95\"\>"]}]], "Output",
 CellLabel->"Out[39]=",ExpressionUUID->"2bb4bd85-7f30-4002-8477-61b47566d474"]
}, Open  ]],

Cell["\<\
The canonical invariants can be expressed as a polynomial in a basis of \
indepent invariants, taking into account all the symmetries of the problem. \
This implies reading rules for additional `steps' \
\>", "MathCaption",ExpressionUUID->"65488d81-ae14-43a6-b4e4-7d057b6aa19d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"0ca5c180-7ce6-42cd-a730-b645cb554c6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"fe44b99c-73b3-4c60-8d66-cf72770dfdd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"f5f50591-c663-47d9-883f-54198452a2b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"7d38a008-d0d8-4b95-a724-c30f761b3b46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 4}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"eeb77296-5fef-41b7-8601-10d3b4f6ffaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 4}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"3759b3fa-82a7-4574-8e83-95f1130992dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"8536b9d0-ac58-4520-a3c6-b0844b229af0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 1, 1}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"104ab1f1-91eb-4e04-9958-43b94966dac8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"000f5eb3-0482-4122-9625-c5dd2e2370fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"58befee3-5802-4e16-9a14-d911119be28e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"d1c71faf-1582-4622-b4dc-0f105c08c5a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 1}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"f0119d67-480d-449a-b244-78e9e5206c67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"9823500a-7dfb-4514-8547-d6c1a9a60b66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"76300f45-8b27-4eec-92b1-40a528a34a3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"3ac55075-714f-418f-ba13-ed9504389a3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 1, 1}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"2d4e756f-bba5-44ce-bbd0-6ef889ce1222"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"a8849357-a114-4eb2-8756-b4b013ed9af6"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"9", " ", 
    SubsuperscriptBox["\<\"D\"\>", "\<\"00,2\"\>", "2"]}], "256"], "-", 
  FractionBox[
   RowBox[{"17", " ", 
    SubsuperscriptBox["\<\"I\"\>", "\<\"0,1\"\>", "4"]}], "24"], "-", 
  RowBox[{
   FractionBox["1", "16"], " ", 
   SubsuperscriptBox["\<\"I\"\>", "\<\"0,1\"\>", "2"], " ", 
   SubscriptBox["\<\"I\"\>", "\<\"2,1\"\>"]}], "+", 
  RowBox[{
   FractionBox["171", "32"], " ", 
   SubsuperscriptBox["\<\"I\"\>", "\<\"0,1\"\>", "2"], " ", 
   SubscriptBox["\<\"I\"\>", "\<\"00,1\"\>"]}], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"2,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"00,1\"\>"]}], "4"], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    SubsuperscriptBox["\<\"I\"\>", "\<\"00,1\"\>", "2"]}], "8"], "-", 
  RowBox[{
   FractionBox["23", "64"], " ", 
   SubsuperscriptBox["\<\"I\"\>", "\<\"0,1\"\>", "2"], " ", 
   SubscriptBox["\<\"I\"\>", "\<\"00,2\"\>"]}], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"2,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"00,2\"\>"]}], "16"], "+", 
  FractionBox[
   RowBox[{"7", " ", 
    SubscriptBox["\<\"I\"\>", "\<\"00,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"00,2\"\>"]}], "32"], "-", 
  FractionBox[
   RowBox[{"9", " ", 
    SubsuperscriptBox["\<\"I\"\>", "\<\"00,2\"\>", "2"]}], "64"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"02,1\"\>"]}], "8"], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"02,6\"\>"]}], "4"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"04,34\"\>"], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"11,1\"\>"]}], "8"], "-", 
  FractionBox[
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"11,4\"\>"]}], "4"], "+", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], " ", 
   SubscriptBox["\<\"I\"\>", "\<\"11,5\"\>"]}], "+", 
  FractionBox[
   RowBox[{"14", " ", 
    SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"000,1\"\>"]}], "3"], "-", 
  FractionBox[
   RowBox[{"35", " ", 
    SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"000,2\"\>"]}], "8"], "+", 
  FractionBox[
   RowBox[{"15", " ", 
    SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"000,5\"\>"]}], "32"], "+", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"002,1\"\>"], "2"], "-", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"002,5\"\>"], "2"], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SubscriptBox["\<\"I\"\>", "\<\"002,7\"\>"]}], "4"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"002,14\"\>"], "+", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"002,55\"\>"], "2"], "-", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"011,1\"\>"], "4"], "+", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"011,2\"\>"], "4"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"011,3\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"011,8\"\>"], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"I\"\>", "\<\"011,9\"\>"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"I\"\>", "\<\"011,10\"\>"]}], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"011,11\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"011,13\"\>"], "+", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"011,17\"\>"], "2"], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"I\"\>", "\<\"011,18\"\>"]}], "-", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"011,23\"\>"], "2"], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["\<\"I\"\>", "\<\"011,25\"\>"]}], "-", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"011,28\"\>"], "4"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"011,44\"\>"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SubscriptBox["\<\"I\"\>", "\<\"011,89\"\>"]}], "8"], "+", 
  FractionBox[
   RowBox[{"11", " ", 
    SubscriptBox["\<\"I\"\>", "\<\"0000,5\"\>"]}], "8"], "+", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"0000,7\"\>"], "4"]}]], "Output",
 CellLabel->"Out[40]=",ExpressionUUID->"2da44b33-101e-407f-8358-1e0f83bc6c86"]
}, Open  ]],

Cell["\<\
Finally this expression can be translated back into Riemann invariants. \
\>", "MathCaption",ExpressionUUID->"8fe61eac-72ed-4e73-a228-899e0d9c8a00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvToRiemann", "[", "%", "]"}]], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"c80c10ad-d72d-4226-a445-30f1ab5ea30d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"04cfb714-8656-4784-926a-180f29bc861c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"b672f4ab-db70-4bea-8c72-f179e028fea1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"17fbd1c5-f451-4778-b473-2b086b86f48c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"4b136d71-5ea5-4e6b-a940-15edf3b6792b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"c65c8426-ef4d-4cb6-ba66-44983b136bfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"b016f15e-4003-4e4f-aa85-fa144ebe8b1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"4936ad6e-b7e3-4371-8f6c-3941259d1670"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"2a644f09-7d33-437a-9588-5d003eddd362"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["17", "24"]}], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " "},
               {" ", " ", "a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
     Editable->False], "4"]}], "-", 
  RowBox[{
   FractionBox["23", "64"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " "},
               {" ", " ", "a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " "},
               {"a", "b", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["9", "64"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", " ", " ", " "},
                {"a", "b", "c", "d"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", "b", "c", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]],
     Editable->False], "2"]}], "+", 
  RowBox[{
   FractionBox["9", "256"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]", 
             StyleBox[GridBox[{
                {" ", " ", " ", " "},
                {"c", "d", "e", "f"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`epsilonmetric[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", " ", "e", "f"},
                {"a", "b", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", "b", "c", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[($CellContext`epsilonmetric[-$CellContext`c, \
-$CellContext`d, -$CellContext`e, -$CellContext`f] \
$CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, $CellContext`e, \
$CellContext`f]) $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]],
     Editable->False], "2"]}], "+", 
  RowBox[{
   FractionBox["171", "32"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " "},
               {" ", " ", "a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", " "},
               {"b", " ", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
-$CellContext`d]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["7", "32"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " "},
               {"a", "b", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", " "},
               {"b", " ", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
-$CellContext`d]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["5", "8"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", "b", " ", "c"},
                {" ", " ", "a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", "d", " ", " "},
                {"b", " ", "c", "d"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
-$CellContext`d]],
     Editable->False], "2"]}], "+", 
  RowBox[{
   FractionBox["15", "32"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", "e", "f"},
               {"a", "b", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " "},
               {"c", "d", "e", "f"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, $CellContext`e, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["14", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "f", " ", " "},
               {"c", " ", "e", "f"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["35", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "f", " ", " "},
               {"d", " ", "e", "f"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["11", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", "e", "f"},
               {"b", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " "},
               {"c", " ", "e", "f"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "h", " ", " "},
               {"d", " ", "g", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`h, \
-$CellContext`g, -$CellContext`h],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[(($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`f]) $CellContext`RiemannCD[-$CellContext`d, \
$CellContext`h, -$CellContext`g, -$CellContext`h]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "f", " ", "g"},
               {"d", " ", "e", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "h", " ", " "},
               {"f", " ", "g", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`f, $CellContext`h, \
-$CellContext`g, -$CellContext`h],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[(($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`f, \
$CellContext`h, -$CellContext`g, -$CellContext`h]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"d", "e", " ", "f", "  "},
              {" ", " ", "d", " ", 
               RowBox[{";", "b"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "g", " ", " ", "  "},
              {"e", " ", "f", "g", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[-$CellContext`e, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`b][
       $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f]]) $CellContext`CD[-$CellContext`c][
      $CellContext`RiemannCD[-$CellContext`e, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", " ", "  "},
               {" ", " ", "d", "e", 
                RowBox[{";", "b"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`b][
         $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]]) $CellContext`CD[-$CellContext`c][
       $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["3", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", " ", "  ", "  "},
               {" ", " ", "d", "e", 
                RowBox[{";", "b"}], 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`CD[-$CellContext`b][
          $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`c][
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "16"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " "},
               {" ", " ", "a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " ", 
               RowBox[{";", "c"}], "  "},
              {" ", " ", "a", "b", "  ", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`CD[$CellContext`c][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "16"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " "},
               {"a", "b", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " ", 
               RowBox[{";", "c"}], "  "},
              {" ", " ", "a", "b", "  ", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`CD[$CellContext`c][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", " "},
               {"b", " ", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
-$CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " ", 
               RowBox[{";", "c"}], "  "},
              {" ", " ", "a", "b", "  ", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`CD[$CellContext`c][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", " ", "  "},
               {" ", " ", "d", "e", 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " ", 
                RowBox[{";", "c"}]},
               {" ", " ", "a", "b", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`c][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`CD[-$CellContext`c][
       $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]] $CellContext`CD[$CellContext`c][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", "f", "  "},
               {"a", " ", "e", " ", 
                RowBox[{";", "b"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`b][
         $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`e, $CellContext`f]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"c", " ", "f", "g", 
                RowBox[{";", "d"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`d][
         $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`e, $CellContext`f]]) $CellContext`CD[-$CellContext`d][
       $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", "c", "d"},
              {" ", " ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "e", " ", " ", "  "},
              {"a", " ", "c", "e", 
               RowBox[{";", "b"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"f", "g", " ", " ", "  "},
              {" ", " ", "f", "g", 
               RowBox[{";", "d"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`d][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`b][
       $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]) $CellContext`CD[-$CellContext`d][
      $CellContext`RiemannCD[$CellContext`f, $CellContext`g, -$CellContext`f, \
-$CellContext`g]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", " ", "  ", "  "},
               {"a", " ", "c", "e", 
                RowBox[{";", "b"}], 
                RowBox[{";", "d"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`d][
         $CellContext`CD[-$CellContext`b][
          $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`d][
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", " ", "  "},
               {"b", " ", "d", "e", 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`e, \
-$CellContext`d, -$CellContext`e]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c", 
                RowBox[{";", "d"}]},
               {" ", " ", "a", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`d][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`CD[-$CellContext`c][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`e, \
-$CellContext`d, -$CellContext`e]] $CellContext`CD[$CellContext`d][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", " ", "  "},
               {"b", " ", "c", "e", 
                RowBox[{";", "d"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`d][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`e, \
-$CellContext`c, -$CellContext`e]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c", 
                RowBox[{";", "d"}]},
               {" ", " ", "a", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`d][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`CD[-$CellContext`d][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`e, \
-$CellContext`c, -$CellContext`e]] $CellContext`CD[$CellContext`d][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c]]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "d", " ", "e", "  "},
              {"b", " ", "d", " ", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"f", "g", " ", " ", "  "},
              {" ", " ", "f", "g", 
               RowBox[{";", "e"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`c][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]]) $CellContext`CD[-$CellContext`e][
      $CellContext`RiemannCD[$CellContext`f, $CellContext`g, -$CellContext`f, \
-$CellContext`g]]],
   Editable->False], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "c"}], 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`CD[-$CellContext`c][
          $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`CD[-$CellContext`e][
       $CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["3", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "d"}], 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`CD[-$CellContext`e][
       $CellContext`CD[-$CellContext`d][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " ", 
                RowBox[{";", "e"}]},
               {"a", "b", "c", "d", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`e][
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`e][
       $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", " ", 
                RowBox[{";", "e"}]},
               {"b", " ", "c", "d", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`e][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`e][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d]]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "d", "e", "f"},
              {"b", " ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "g", " ", " ", "  ", "  "},
              {"c", " ", "e", "g", 
               RowBox[{";", "d"}], 
               RowBox[{";", "f"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`f][
        $CellContext`CD[-$CellContext`d][
         $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
      $CellContext`CD[-$CellContext`d][
       $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", "f"},
               {" ", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  ", "  "},
               {"b", " ", "c", "g", 
                RowBox[{";", "e"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`c, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[$CellContext`d, $CellContext`e, -$CellContext`d, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`c, -$CellContext`g]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", "f"},
               {"a", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  ", "  "},
               {"b", " ", "d", "g", 
                RowBox[{";", "e"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
$CellContext`e, -$CellContext`c, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", "c", "d"},
              {" ", " ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "e", " ", " ", "  ", "  ", 
               RowBox[{";", "f"}], "  "},
              {"a", " ", "c", "e", 
               RowBox[{";", "b"}], 
               RowBox[{";", "d"}], "  ", 
               RowBox[{";", "f"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`f][
        $CellContext`CD[$CellContext`f][
         $CellContext`CD[-$CellContext`d][
          $CellContext`CD[-$CellContext`b][
           $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]]]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d] $CellContext`CD[-$CellContext`f][
      $CellContext`CD[$CellContext`f][
       $CellContext`CD[-$CellContext`d][
        $CellContext`CD[-$CellContext`b][
         $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]]]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"b", " ", "d", "g", 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", " ", 
                RowBox[{";", "f"}]},
               {"a", " ", "c", "e", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"d", " ", "f", "g", 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`RiemannCD[-$CellContext`d, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e", 
                RowBox[{";", "f"}]},
               {"b", " ", "c", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"d", " ", "e", "g", 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`d, $CellContext`g, \
-$CellContext`e, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e", 
                RowBox[{";", "f"}]},
               {"b", " ", "c", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"e", " ", "f", "g", 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`RiemannCD[-$CellContext`e, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e", 
                RowBox[{";", "f"}]},
               {"b", " ", "d", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[-$CellContext`e, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"c", " ", "f", "g", 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e", 
                RowBox[{";", "f"}]},
               {"b", " ", "d", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "g", " ", " ", "  "},
              {"c", " ", "e", "g", 
               RowBox[{";", "f"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "d", " ", "e", 
               RowBox[{";", "f"}]},
              {"b", " ", "d", " ", "  "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
      $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]]],
   Editable->False], "+", 
  RowBox[{
   FractionBox["3", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " ", "  "},
               {"c", "d", "e", "f", 
                RowBox[{";", "g"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`g][
         $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", "e", "f", 
                RowBox[{";", "g"}]},
               {"a", "b", " ", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`g][
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`g][
        $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f]]) $CellContext`CD[$CellContext`g][
       $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f]]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " ", " ", " ", "  "},
              {"c", "e", "d", "g", 
               RowBox[{";", "f"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`c, -$CellContext`e, \
-$CellContext`d, -$CellContext`g]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "d", "e", "f", 
               RowBox[{";", "g"}]},
              {"b", " ", " ", " ", "  "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`g][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`c, -$CellContext`e, \
-$CellContext`d, -$CellContext`g]]) $CellContext`CD[$CellContext`g][
      $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[41]=",ExpressionUUID->"8cbb2ddc-b67e-4212-ab66-9fab71d17c46"]
}, Open  ]],

Cell["\<\
The whole process can be done in a single step using the command \
RiemannSimplify:\
\>", "MathCaption",ExpressionUUID->"920e4d2e-4d99-4f28-b013-93b6052b9154"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSimplify", "[", "expr", "]"}]], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"37dabfff-a477-413c-8467-6c2de3f89bdd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["17", "24"]}], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " "},
               {" ", " ", "a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
     Editable->False], "4"]}], "-", 
  RowBox[{
   FractionBox["23", "64"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " "},
               {" ", " ", "a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " "},
               {"a", "b", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["9", "64"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", " ", " ", " "},
                {"a", "b", "c", "d"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", "b", "c", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]],
     Editable->False], "2"]}], "+", 
  RowBox[{
   FractionBox["9", "256"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]", 
             StyleBox[GridBox[{
                {" ", " ", " ", " "},
                {"c", "d", "e", "f"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`epsilonmetric[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", " ", "e", "f"},
                {"a", "b", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", "b", "c", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[($CellContext`epsilonmetric[-$CellContext`c, \
-$CellContext`d, -$CellContext`e, -$CellContext`f] \
$CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, $CellContext`e, \
$CellContext`f]) $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]],
     Editable->False], "2"]}], "+", 
  RowBox[{
   FractionBox["171", "32"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " "},
               {" ", " ", "a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", " "},
               {"b", " ", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
-$CellContext`d]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["7", "32"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " "},
               {"a", "b", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", " "},
               {"b", " ", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
-$CellContext`d]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["5", "8"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", "b", " ", "c"},
                {" ", " ", "a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", "d", " ", " "},
                {"b", " ", "c", "d"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
-$CellContext`d]],
     Editable->False], "2"]}], "+", 
  RowBox[{
   FractionBox["15", "32"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", "e", "f"},
               {"a", "b", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " "},
               {"c", "d", "e", "f"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, $CellContext`e, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["14", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "f", " ", " "},
               {"c", " ", "e", "f"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["35", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "f", " ", " "},
               {"d", " ", "e", "f"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["11", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", "e", "f"},
               {"b", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " "},
               {"c", " ", "e", "f"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "h", " ", " "},
               {"d", " ", "g", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`h, \
-$CellContext`g, -$CellContext`h],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[(($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`f]) $CellContext`RiemannCD[-$CellContext`d, \
$CellContext`h, -$CellContext`g, -$CellContext`h]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "f", " ", "g"},
               {"d", " ", "e", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "h", " ", " "},
               {"f", " ", "g", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`f, $CellContext`h, \
-$CellContext`g, -$CellContext`h],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[(($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`f, \
$CellContext`h, -$CellContext`g, -$CellContext`h]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"d", "e", " ", "f", "  "},
              {" ", " ", "d", " ", 
               RowBox[{";", "b"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "g", " ", " ", "  "},
              {"e", " ", "f", "g", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[-$CellContext`e, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`b][
       $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f]]) $CellContext`CD[-$CellContext`c][
      $CellContext`RiemannCD[-$CellContext`e, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", " ", "  "},
               {" ", " ", "d", "e", 
                RowBox[{";", "b"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`b][
         $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]]) $CellContext`CD[-$CellContext`c][
       $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["3", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", " ", "  ", "  "},
               {" ", " ", "d", "e", 
                RowBox[{";", "b"}], 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`CD[-$CellContext`b][
          $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`c][
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "16"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " "},
               {" ", " ", "a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " ", 
               RowBox[{";", "c"}], "  "},
              {" ", " ", "a", "b", "  ", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`CD[$CellContext`c][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "16"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " "},
               {"a", "b", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " ", 
               RowBox[{";", "c"}], "  "},
              {" ", " ", "a", "b", "  ", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`CD[$CellContext`c][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", " "},
               {"b", " ", "c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
-$CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " ", 
               RowBox[{";", "c"}], "  "},
              {" ", " ", "a", "b", "  ", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`CD[$CellContext`c][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", " ", "  "},
               {" ", " ", "d", "e", 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", " ", 
                RowBox[{";", "c"}]},
               {" ", " ", "a", "b", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`c][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`CD[-$CellContext`c][
       $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, -$CellContext`e]] $CellContext`CD[$CellContext`c][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]]],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", "f", "  "},
               {"a", " ", "e", " ", 
                RowBox[{";", "b"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`b][
         $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`e, $CellContext`f]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"c", " ", "f", "g", 
                RowBox[{";", "d"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`d][
         $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`e, $CellContext`f]]) $CellContext`CD[-$CellContext`d][
       $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", "c", "d"},
              {" ", " ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "e", " ", " ", "  "},
              {"a", " ", "c", "e", 
               RowBox[{";", "b"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"f", "g", " ", " ", "  "},
              {" ", " ", "f", "g", 
               RowBox[{";", "d"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`d][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`b][
       $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]) $CellContext`CD[-$CellContext`d][
      $CellContext`RiemannCD[$CellContext`f, $CellContext`g, -$CellContext`f, \
-$CellContext`g]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", " ", "  ", "  "},
               {"a", " ", "c", "e", 
                RowBox[{";", "b"}], 
                RowBox[{";", "d"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`d][
         $CellContext`CD[-$CellContext`b][
          $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`d][
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", " ", "  "},
               {"b", " ", "d", "e", 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`e, \
-$CellContext`d, -$CellContext`e]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c", 
                RowBox[{";", "d"}]},
               {" ", " ", "a", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`d][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`CD[-$CellContext`c][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`e, \
-$CellContext`d, -$CellContext`e]] $CellContext`CD[$CellContext`d][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", " "},
              {" ", " ", "a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
       Editable->False], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[
     $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
-$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", " ", "  "},
               {"b", " ", "c", "e", 
                RowBox[{";", "d"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`d][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`e, \
-$CellContext`c, -$CellContext`e]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c", 
                RowBox[{";", "d"}]},
               {" ", " ", "a", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`d][
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`CD[-$CellContext`d][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`e, \
-$CellContext`c, -$CellContext`e]] $CellContext`CD[$CellContext`d][
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c]]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "d", " ", "e", "  "},
              {"b", " ", "d", " ", 
               RowBox[{";", "c"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"f", "g", " ", " ", "  "},
              {" ", " ", "f", "g", 
               RowBox[{";", "e"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`c][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]]) $CellContext`CD[-$CellContext`e][
      $CellContext`RiemannCD[$CellContext`f, $CellContext`g, -$CellContext`f, \
-$CellContext`g]]],
   Editable->False], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "c"}], 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`CD[-$CellContext`c][
          $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`CD[-$CellContext`e][
       $CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["3", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "d"}], 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`CD[-$CellContext`e][
       $CellContext`CD[-$CellContext`d][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " ", 
                RowBox[{";", "e"}]},
               {"a", "b", "c", "d", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`e][
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`e][
       $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", " ", 
                RowBox[{";", "e"}]},
               {"b", " ", "c", "d", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`e][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`e][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d]]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "d", "e", "f"},
              {"b", " ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "g", " ", " ", "  ", "  "},
              {"c", " ", "e", "g", 
               RowBox[{";", "d"}], 
               RowBox[{";", "f"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`f][
        $CellContext`CD[-$CellContext`d][
         $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
      $CellContext`CD[-$CellContext`d][
       $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", "f"},
               {" ", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  ", "  "},
               {"b", " ", "c", "g", 
                RowBox[{";", "e"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`c, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[$CellContext`d, $CellContext`e, -$CellContext`d, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`c, -$CellContext`g]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", "f"},
               {"a", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  ", "  "},
               {"b", " ", "d", "g", 
                RowBox[{";", "e"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
$CellContext`e, -$CellContext`c, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", "c", "d"},
              {" ", " ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "e", " ", " ", "  ", "  ", 
               RowBox[{";", "f"}], "  "},
              {"a", " ", "c", "e", 
               RowBox[{";", "b"}], 
               RowBox[{";", "d"}], "  ", 
               RowBox[{";", "f"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`f][
        $CellContext`CD[$CellContext`f][
         $CellContext`CD[-$CellContext`d][
          $CellContext`CD[-$CellContext`b][
           $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]]]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d] $CellContext`CD[-$CellContext`f][
      $CellContext`CD[$CellContext`f][
       $CellContext`CD[-$CellContext`d][
        $CellContext`CD[-$CellContext`b][
         $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]]]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"b", " ", "d", "g", 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", " ", 
                RowBox[{";", "f"}]},
               {"a", " ", "c", "e", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, -$CellContext`e]]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"d", " ", "f", "g", 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`RiemannCD[-$CellContext`d, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e", 
                RowBox[{";", "f"}]},
               {"b", " ", "c", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"d", " ", "e", "g", 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`d, $CellContext`g, \
-$CellContext`e, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e", 
                RowBox[{";", "f"}]},
               {"b", " ", "c", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"e", " ", "f", "g", 
                RowBox[{";", "c"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`c][
         $CellContext`RiemannCD[-$CellContext`e, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e", 
                RowBox[{";", "f"}]},
               {"b", " ", "d", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[-$CellContext`e, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  "},
               {"c", " ", "f", "g", 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`f, -$CellContext`g]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e", 
                RowBox[{";", "f"}]},
               {"b", " ", "d", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`f][
         $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "g", " ", " ", "  "},
              {"c", " ", "e", "g", 
               RowBox[{";", "f"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "d", " ", "e", 
               RowBox[{";", "f"}]},
              {"b", " ", "d", " ", "  "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]) $CellContext`CD[$CellContext`f][
      $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]]],
   Editable->False], "+", 
  RowBox[{
   FractionBox["3", "8"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " ", "  "},
               {"c", "d", "e", "f", 
                RowBox[{";", "g"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`g][
         $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", "e", "f", 
                RowBox[{";", "g"}]},
               {"a", "b", " ", " ", "  "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[$CellContext`g][
         $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d] \
$CellContext`CD[-$CellContext`g][
        $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f]]) $CellContext`CD[$CellContext`g][
       $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f]]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "b", " ", "c"},
              {" ", " ", "a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " ", " ", " ", "  "},
              {"c", "e", "d", "g", 
               RowBox[{";", "f"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`f][
        $CellContext`RiemannCD[-$CellContext`c, -$CellContext`e, \
-$CellContext`d, -$CellContext`g]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", "d", "e", "f", 
               RowBox[{";", "g"}]},
              {"b", " ", " ", " ", "  "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`g][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f]],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`CD[-$CellContext`f][
       $CellContext`RiemannCD[-$CellContext`c, -$CellContext`e, \
-$CellContext`d, -$CellContext`g]]) $CellContext`CD[$CellContext`g][
      $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[42]=",ExpressionUUID->"a589b0b3-aa1b-45f7-9815-67625fc1d3e6"]
}, Open  ]],

Cell["This is the example expression shown in the first paper:", "MathCaption",ExpressionUUID->"58974902-c3eb-4377-a252-6128539ff51d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"epsilonmetric", "[", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "e", ",", "f"}], "]"}], 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "f"}], ",", "g"}], "]"}], 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", "h", ",", "i", ",", "j"}], "]"}], 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "g"}], ",", 
      RowBox[{"-", "i"}]}], "]"}], 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "h"}], ",", 
      RowBox[{"-", "j"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"1", "/", "8"}], 
    RowBox[{"epsilonmetric", "[", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "e", ",", "f"}], "]"}], 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "f"}]}], "]"}], 
    RowBox[{"RiemannCD", "[", 
     RowBox[{"g", ",", "h", ",", "i", ",", "j"}], "]"}], 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "g"}], ",", 
      RowBox[{"-", "i"}]}], "]"}], 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "h"}], ",", 
      RowBox[{"-", "j"}]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"f8bb7a82-d6ad-446f-8172-61cc4a7d7259"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"a", "b", "c", "d"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilonmetric[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"g", "i"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`g, -$CellContext`i],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"h", "j"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`h, -$CellContext`j],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " ", "e", "f"},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, $CellContext`e, \
$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " ", " ", "g"},
           {"c", "e", "f", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[-$CellContext`c, -$CellContext`e, -$CellContext`f, \
$CellContext`g],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", "h", "i", "j"},
           {"d", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[-$CellContext`d, $CellContext`h, $CellContext`i, \
$CellContext`j],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"a", "b", "c", "d"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilonmetric[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"g", "i"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`g, -$CellContext`i],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"h", "j"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`h, -$CellContext`j],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " ", "e", "f"},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, $CellContext`e, \
$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "d", "e", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, -$CellContext`e, \
-$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {"g", "h", "i", "j"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[$CellContext`g, $CellContext`h, $CellContext`i, \
$CellContext`j],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[43]=",ExpressionUUID->"006064e7-bf16-4e23-9eab-653ea0f2b465"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannSimplify", "[", "expr", "]"}], " ", "//", 
  "Timing"}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"8fe4c219-187a-4fe7-9df8-1b80b113ecc5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"daae05a2-8974-45e9-85a8-955aaf8882c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"fc0dbffe-4c3f-4338-ba1f-275e9fe6117c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"e5cb6cdc-7d05-4690-ba37-366e50bb22bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"003f9725-b275-4df9-94f0-5a4cd53fe33d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"5d2943f5-0eec-4262-880e-e5b1de0473a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"3a673b28-0c40-46fd-87bf-8af4273bfb27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"0d19e970-467f-4aea-b813-68b1971643a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"16a75943-a82b-4cc9-bdcf-4dc72997b92b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"1aaea3e1-63c4-4d8e-8e77-18dce8be335d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.78697700000000003761613243113970384002`5.916561953238375", ",", "0"}], 
  "}"}]], "Output",
 CellLabel->"Out[44]=",ExpressionUUID->"1d494a82-1c0d-45b6-8065-7aabe9fbe0c3"]
}, Open  ]],

Cell["\<\
And this is the example expression shown in the second paper:\
\>", "MathCaption",ExpressionUUID->"6dc68e2a-0ffa-425e-a824-63ae015824ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "a"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", "e", "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}]}], 
    RowBox[{
     RowBox[{"CD", "[", "i", "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", "h", "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "e"}], ",", "f", ",", "g"}], "]"}]}]}], 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "h"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "f"}], ",", 
        RowBox[{"-", "g"}], ",", 
        RowBox[{"-", "i"}]}], "]"}]}]}]}], "-", 
   RowBox[{
    RowBox[{"1", "/", "8"}], 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "e"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", "e", "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}]}], 
    RowBox[{
     RowBox[{"CD", "[", "i", "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", "h", "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", "f", ",", "g"}], "]"}]}]}], 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "h"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "i"}], "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "f"}], ",", 
        RowBox[{"-", "g"}]}], "]"}]}]}]}]}]}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"65e7f0f9-25a8-47eb-a18f-708d8e227b48"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "8"]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {"a", "b", "c", "d", 
            RowBox[{";", "e"}], "  "},
           {" ", " ", " ", " ", "  ", 
            RowBox[{";", "e"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`e][
     $CellContext`CD[$CellContext`e][
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " ", " ", " ", "  ", "  "},
           {"c", "d", "f", "g", 
            RowBox[{";", "i"}], 
            RowBox[{";", "h"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`h][
     $CellContext`CD[-$CellContext`i][
      $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`f, -$CellContext`g]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " ", "f", "g", 
            RowBox[{";", "h"}], 
            RowBox[{";", "i"}]},
           {"a", "b", " ", " ", "  ", "  "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`i][
     $CellContext`CD[$CellContext`h][
      $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`f, $CellContext`g]]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {"a", "b", "c", "d", 
            RowBox[{";", "e"}], "  "},
           {" ", " ", " ", " ", "  ", 
            RowBox[{";", "a"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`a][
     $CellContext`CD[$CellContext`e][
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " ", " ", " ", "  ", "  "},
           {"c", "f", "g", "i", 
            RowBox[{";", "d"}], 
            RowBox[{";", "h"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`h][
     $CellContext`CD[-$CellContext`d][
      $CellContext`RiemannCD[-$CellContext`c, -$CellContext`f, \
-$CellContext`g, -$CellContext`i]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " ", "f", "g", 
            RowBox[{";", "h"}], 
            RowBox[{";", "i"}]},
           {"b", "e", " ", " ", "  ", "  "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`i][
     $CellContext`CD[$CellContext`h][
      $CellContext`RiemannCD[-$CellContext`b, -$CellContext`e, \
$CellContext`f, $CellContext`g]]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[45]=",ExpressionUUID->"9939c4ce-0d44-4d05-953d-85b9e8112699"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannSimplify", "[", "expr", "]"}], " ", "//", 
  "Timing"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"c15a250d-121c-46cb-bafd-6193e2a0bda5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2, 2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"ac31d6a4-0a33-45c1-8591-dda9bc7d47a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"d86c4941-6067-491f-b4bd-581ce3233a6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"765f9cfe-e0ac-4ce0-abf8-8b5ceab5a8a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {2, 2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"d88f20f6-7874-4fb5-a6e5-260aadd7be8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {2, 2, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"78ab256c-d9d8-4bc0-9588-4e016276c611"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {2, 2, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"9c6cded0-1526-4a2d-a3ad-98aa5d96deab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 2, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"ea02d0e3-7e35-4c71-8103-d37f740bbc9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 2, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"57077635-e2f7-4997-8790-f72cbad5f06b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.34193199999999990268406691029667854309`6.3901741940870584", ",", "0"}], 
  "}"}]], "Output",
 CellLabel->"Out[46]=",ExpressionUUID->"32372f59-4580-48b2-92b3-7dc667a334b0"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2. General concepts and definitions",
 FontSize->14]], "SubsectionIcon",
 CellTags->{
  "S5.18.1", "1.4"},ExpressionUUID->"b0a5188a-1ace-4c4f-bef4-3443ad3fca4d"],

Cell[TextData[{
 "The Riemann tensor obeys two types of symmetries. The first type are ",
 StyleBox["permutation",
  FontSlant->"Italic"],
 " (or ",
 StyleBox["monoterm",
  FontSlant->"Italic"],
 ") symmetries, for example,\n\t\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", "bacd"], " ", "=", " ", 
    RowBox[{"-", 
     SubscriptBox["R", "abcd"]}]}], TraditionalForm]],ExpressionUUID->
  "cfc0440a-5d4b-45a5-b00c-a0879f803a98"],
 "\tand\t\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", "cdab"], " ", "=", " ", 
    SubscriptBox["R", "abcd"]}], TraditionalForm]],ExpressionUUID->
  "911b91b2-520c-46e2-ae0b-50067e8fdd1e"],
 "\t.\nThe second type is the ",
 StyleBox["cyclic",
  FontSlant->"Italic"],
 " (or ",
 StyleBox["multiterm",
  FontSlant->"Italic"],
 ") symmetry:\n\t\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["R", "abcd"], " ", "+", " ", 
     SubscriptBox["R", "acdb"], " ", "+", " ", 
     SubscriptBox["R", "adbc"]}], " ", "=", " ", "0"}], TraditionalForm]],
  ExpressionUUID->"d05e530b-5f3e-41f6-84bb-bbe1acd32ea1"],
 " .\nIn order to simplify any polynomial of the Riemann tensor, it is \
necessary to use both kinds. It is possible to use efficient algorithms of \
computational group theory to manipulate the former, but there are no known \
efficient algorithms to manipulate the latter.\nIf we include covariant \
derivatives, we have to consider two new classes of relations. We have the \
Bianchi identity:\n\t\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", 
     RowBox[{
      StyleBox["ab",
       FontSlant->"Italic"], 
      StyleBox["[",
       FontSlant->"Italic"], 
      StyleBox[
       RowBox[{"cd", ";", " ", "e"}],
       FontSlant->"Italic"], "]"}]], "=", "0"}], TraditionalForm]],
  ExpressionUUID->"d7bb25aa-d8e2-4b4c-904f-c52eb3f51158"],
 "\nand the effect of non commutatity of covariant derivatives:\n\t\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[Del]", "d"], 
      RowBox[{
       SubscriptBox["\[Del]", "c"], 
       SubscriptBox[
        SuperscriptBox["T", 
         RowBox[{
          RowBox[{
           SubscriptBox["a", "1"], "..."}], " ", 
          SubscriptBox["a", "n"]}]], 
        RowBox[{
         RowBox[{
          SubscriptBox["b", "1"], "..."}], 
         SubscriptBox["b", "n"]}]]}]}], " ", "-", " ", 
     RowBox[{
      SubscriptBox["\[Del]", "c"], 
      RowBox[{
       SubscriptBox["\[Del]", "d"], 
       SubscriptBox[
        SuperscriptBox["T", 
         RowBox[{
          RowBox[{
           SubscriptBox["a", "1"], "..."}], " ", 
          SubscriptBox["a", "n"]}]], 
        RowBox[{
         RowBox[{
          SubscriptBox["b", "1"], "..."}], 
         SubscriptBox["b", "m"]}]]}]}]}], " ", "=", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "n"], 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["R", 
         StyleBox["cde",
          FontSlant->"Italic"]], 
        SubscriptBox["a", "k"]], 
       SubscriptBox[
        SuperscriptBox["T", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             SubscriptBox["a", "1"], "..."}], "e"}], "..."}], 
          SubscriptBox["a", "n"]}]], 
        RowBox[{
         RowBox[{
          SubscriptBox["b", "1"], "..."}], 
         SubscriptBox["b", "m"]}]]}]}], "-", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "n"], 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["R", 
         SubscriptBox[
          StyleBox["cdb",
           FontSlant->"Italic"], "k"]], "e"], 
       SubscriptBox[
        SuperscriptBox["T", 
         RowBox[{
          RowBox[{
           SubscriptBox["a", "1"], "..."}], 
          SubscriptBox["a", "n"]}]], 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            SubscriptBox["b", "1"], "..."}], "e"}], "..."}], 
         SubscriptBox["b", "m"]}]]}]}]}]}], TraditionalForm]],ExpressionUUID->
  "a284e7ea-9b25-42bf-b244-b9be7d308108"],
 "\nAn additional problem is that there are more identities to consider, \
coming from the fact that some of the polynomial invariants are zero in \
low-enough dimension. It is possible to show that all these dimension \
dependent identities are of Lovelock type, that is, they all come from the \
idea that, on a manifold of dimension ",
 StyleBox["dim",
  FontSlant->"Italic"],
 ", antisymmetrizing in ",
 StyleBox["dim ",
  FontSlant->"Italic"],
 "+ 1 indices gives zero. Unfortunately, these last three types of identities \
cannot be manipulated efficiently either.\nThe main idea behind ",
 StyleBox["Invar`",
  FontFamily->"Courier"],
 " is using the fast canonicalizers of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " and ",
 StyleBox["Canon",
  FontFamily->"Courier"],
 " to deal with the permutation symmetries, and then using prestored files of \
solutions for the other types of identities."
}], "Text",ExpressionUUID->"6033834d-4e9b-4b0f-8921-3c62d9db33dd"],

Cell[TextData[{
 "The package is structured as follows:\n\t1. We shall work with two types of \
invariants:\n\t\t- (",
 StyleBox["non-dual",
  FontSlant->"Italic"],
 ") invariants: fully contracted products of ",
 StyleBox["n",
  FontSlant->"Italic"],
 " Riemann tensors (where ",
 StyleBox["n",
  FontSlant->"Italic"],
 " will be called the ",
 StyleBox["degree",
  FontSlant->"Italic"],
 " of the invariant), possibly including covariant derivatives . \n\t\t- ",
 StyleBox["dual",
  FontSlant->"Italic"],
 " invariants: fully contracted products of ",
 StyleBox["n",
  FontSlant->"Italic"],
 " Riemann tensors with or without derivatives and one epsilon tensor (",
 StyleBox["n",
  FontSlant->"Italic"],
 " is again called the ",
 StyleBox["degree",
  FontSlant->"Italic"],
 " of the dual invariant). There is no need to work with more than one \
epsilon, because products of two epsilons can be converted into delta \
tensors. \nWe shall separate the set of all monomial invariants of degree ",
 StyleBox["n ",
  FontSlant->"Italic"],
 "in subsets ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalR]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Lambda]", "1"], ",", " ", "...", " ", ",", " ", 
       SubscriptBox["\[Lambda]", "n"]}], "}"}], " "}]], TraditionalForm]],
  ExpressionUUID->"740b1ed5-f5be-4da7-aa10-0e66e46e9146"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "i"], TraditionalForm]],ExpressionUUID->
  "49d801cb-96cb-4b3b-b718-914586ae0f96"],
 "is the differentiation order of the ",
 StyleBox["i",
  FontSlant->"Italic"],
 "-th Riemann tensor, assuming the tensors have sorted such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Lambda]", "i"], "\[LessEqual]", " ", 
    SubscriptBox["\[Lambda]", 
     RowBox[{"i", "+"}]]}], TraditionalForm]],ExpressionUUID->
  "a0aa2028-3cc3-4ece-908f-af0e3f39863a"],
 ". An ",
 StyleBox["n-",
  FontSlant->"Italic"],
 "tuple {",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Lambda]", "1"], ",", " ", "..."}], TraditionalForm]],
  ExpressionUUID->"5ff26945-09ac-4792-b55f-374bc9f0ba48"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "n"], TraditionalForm]],ExpressionUUID->
  "dd3c2213-491b-4a78-8a6b-f939f3e7dd7f"],
 "} will be referred to as a ",
 StyleBox["case",
  FontSlant->"Italic"],
 ", with the corresponding invariants having ",
 StyleBox["N = ",
  FontSlant->"Italic"],
 "4",
 StyleBox["n +",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"i", "=", "1"}], "n"], TraditionalForm]],ExpressionUUID->
  "6d44feb1-a756-408e-8591-50191ecdf535"],
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "i"], TraditionalForm]],ExpressionUUID->
  "a73fc1de-5b0b-4257-b96e-d4f7e18e4f9e"],
 " indices and order ",
 StyleBox["\[CapitalLambda]",
  FontSlant->"Italic"],
 " = 2",
 StyleBox["n",
  FontSlant->"Italic"],
 " + ",
 Cell[BoxData[
  FormBox[
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"i", "=", "1"}], "n"], TraditionalForm]],ExpressionUUID->
  "4bfb41ab-2d43-4592-bfb4-e8a00561a982"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "i"], TraditionalForm]],ExpressionUUID->
  "38b2d9d4-054e-427e-8590-ab8b5687d48c"],
 ". ",
 StyleBox["\[CapitalLambda]",
  FontSlant->"Italic"],
 " is the number of derivatives of the metric, not to be confused with the \
total number of derivatives of the Riemann tensors (the sum of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "i"], TraditionalForm]],ExpressionUUID->
  "b76f9777-3951-4a8c-aba3-f20f5137e575"],
 "'s). Both ",
 StyleBox["N ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["\[CapitalLambda]",
  FontSlant->"Italic"],
 " are always even numbers because we only consider scalar expressions. For \
example, an invariant of the case {0,1,3}, hence with ",
 StyleBox["N = ",
  FontSlant->"Italic"],
 "16 indices and order ",
 StyleBox["\[CapitalLambda]",
  FontSlant->"Italic"],
 " = 10, is\n\t\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", 
     StyleBox["abcd",
      FontSlant->"Italic"]], 
    RowBox[{
     SubscriptBox["\[Del]", "e"], 
     SuperscriptBox["R", 
      StyleBox[
       RowBox[{" ", "ecfg"}],
       FontSlant->"Italic"]]}], 
    RowBox[{
     SuperscriptBox["\[Del]", "a"], 
     RowBox[{
      SubscriptBox["\[Del]", "f"], 
      RowBox[{
       SubscriptBox["\[Del]", "h"], 
       SubscriptBox[
        SuperscriptBox["R", 
         RowBox[{" ", 
          StyleBox["bdh",
           FontSlant->"Italic"]}]], "g"]}]}]}]}], TraditionalForm]],
  ExpressionUUID->"c28b583f-3c13-4fc9-a349-8fd52b0b83cb"],
 ".\n\t2. We shall distinguish six steps or levels of simplification:\n\t\t\
1.- Canonicalization with respect to permutation symmetries.\n\t\t2.- \
Canonicalization with respect to the cyclic symmetry.\n\t\t3.- \
Canonicalization with respect to the Bianchi symmetry.\n\t\t4.- \
Canonicalization with respect to commutation of derivatives.\n\t\t5.- Use of \
all possible dimensionally-dependent identities.\n\t\t6.- Conversion of \
invariants into products of two dual invariants (metric-signature dependent).\
\n\t3. Each Riemann monomial can be represented in one of three forms \
(examples will be given below):\n\t\t- As an explicit tensor expression.\n\t\t\
- As a permutation of the indices in canonical order.\n\t\t- As an expression",
 StyleBox[" RInv[metric][case, index]",
  FontFamily->"Courier New"],
 " or ",
 StyleBox["DualRInv[metric][case, index]",
  FontFamily->"Courier New"],
 " which represents the equivalent canonical monomial after canonicalization \
with respect to the permutation symmetries. The integer index identifies each \
particular invariant in the list of invariants, sorted according to some \
predefined ordering.\n\t4. Commands are given to change among those three \
representations, and to simplify the invariants up to some particular level. \
They are all listed below. Their mutual structure is schematically given by"
}], "Text",ExpressionUUID->"48155a1d-eaa9-4ea3-aaba-7ceb1436cbd2"],

Cell[BoxData[
 RowBox[{"<<", "Graphics`Arrow`"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"ae6793c1-3480-4673-8147-57c409a14a3f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Arrow", ",", 
    RowBox[{"HeadLength", "\[Rule]", "0.02"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"os", "=", "0.15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0", "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Riemann\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Perm\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Inv\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"\"\<RiemannToPerm\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.15"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<PermToInv\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "0.15"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<InvToPerm\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", 
          RowBox[{"-", "0.16"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<PermToRiemann\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.16"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"os", ",", "0.1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "-", "os"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "+", "os"}], ",", "0.1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "-", "os"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "-", "os"}], ",", 
          RowBox[{"-", "0.1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"os", ",", 
          RowBox[{"-", "0.1"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "-", "os"}], ",", 
          RowBox[{"-", "0.1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "+", "os"}], ",", 
          RowBox[{"-", "0.1"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0.55", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"2", "+", "os"}], ",", "0.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.4", ",", "0.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.4", ",", 
           RowBox[{"-", "0.1"}]}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2.4", ",", 
          RowBox[{"-", "0.1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "+", "os"}], ",", 
          RowBox[{"-", "0.1"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<InvSimplify\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"2.4", ",", "0.15"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0.7", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"os", ",", "0.3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.8", ",", "0.3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.8", ",", 
           RowBox[{"-", "0.3"}]}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2.8", ",", 
          RowBox[{"-", "0.3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"os", ",", 
          RowBox[{"-", "0.3"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<RiemannSimplify\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"2.2", ",", "0.35"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"fda65cd8-0b3f-4868-8b57-95ff32101267"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .30303 
%%ImageSize: 400 121.212 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0909091 0.30303 0.151515 0.30303 [
[ 0 0 0 0 ]
[ 1 .30303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .30303 L
0 .30303 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 0 0 r
gsave
.09091 .15152 -84 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(Riemann) show
105.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39394 .15152 -75 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(Perm) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.69697 .15152 -72 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(Inv) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 g
gsave
.24242 .19697 -102 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(RiemannToPerm) show
141.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.54545 .19697 -90 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(PermToInv) show
117.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.54545 .10303 -90 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(InvToPerm) show
117.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.24242 .10303 -102 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(PermToRiemann) show
141.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.13636 .18182 m
.34848 .18182 L
s
% Start of user PostScript
0.15 0.1 0.85 0.1 MAarrowhead1
% End of user PostScript
.43939 .18182 m
.65152 .18182 L
s
% Start of user PostScript
1.15 0.1 1.85 0.1 MAarrowhead1
% End of user PostScript
.34848 .12121 m
.13636 .12121 L
s
% Start of user PostScript
0.85 -0.1 0.15 -0.1 MAarrowhead1
% End of user PostScript
.65152 .12121 m
.43939 .12121 L
s
% Start of user PostScript
1.85 -0.1 1.15 -0.1 MAarrowhead1
% End of user PostScript
0 .7 1 r
.74242 .18182 m
.81818 .18182 L
.81818 .12121 L
s
.81818 .12121 m
.74242 .12121 L
s
% Start of user PostScript
2.4 -0.1 2.15 -0.1 MAarrowhead1
% End of user PostScript
gsave
.81818 .19697 -96 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.700 1.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.700 1.000 setrgbcolor
(InvSimplify) show
129.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.700 1.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2 0 1 r
.13636 .24242 m
.93939 .24242 L
.93939 .06061 L
s
.93939 .06061 m
.13636 .06061 L
s
% Start of user PostScript
2.8 -0.3 0.15 -0.3 MAarrowhead1
% End of user PostScript
gsave
.75758 .25758 -108 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.200 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.200 0.000 1.000 setrgbcolor
(RiemannSimplify) show
153.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.200 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{400, 121.188},
 CellLabel->"From In[48]:=",ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztGstu00DQ8dppQaK0AirgQiUkWiEhEEVtWhSEBBQo4sABVSAuUQVqDwgo
bYEDB+AH4MCX5Os4Ge9rdnc8a2fzqgO1Yu9kdt4z+/AmTzv7O6/fdvZ3tzsL
D/c673d2tz8ubLzby1GsEUWNn1EUfVmIOJzloHpk+Sf7xR8c8//Cbd6waFlF
5JnErvFmCmNXeZNx7F3+uEjSrgiskCggfp8ndZVQii+Hx/117V+XmcyvFKCY
Q0kEyEiOM9PGAkoApy6BiEGCkRUxR0TikpQpiUFkLsNWR+EYgROlmSI1+gI1
kicBpLqZz6vQWH3zJ+A2CpD8VsTJaJ/AJhb0GXdc/phwEfJTQEttKakN99lt
mBYPeq1387GnfXk/3OB/r8g1AxtNeY0or6ZWPbUdl6SSIaqaZm+AcFZlqmeX
WW3GpmSZIjXrliqIqiy79q6G+lBm7CChGEI+wotASLeWDWJxy3XbekprwbsA
OQRoFcLLn7TDIbGkqcuDFluAqOmLFlJqrdsJdijAH3/oXKdK0iPsFjxnOSRq
bApwrwB3iuj97RfbBgcXifp8Ar0HCupmD/zC1JY6vz4UoFJGMcSec/LLLnSJ
M17vV+M57VLXMF7rJRYHhN+BwsSXjWOeuvLMysRmZmLOdOHLwQ6Dn39Pocdu
Y6ASkBrMolfOHQUcI3BboCZ1bUqqVG9zMMVU+tZUDPuX34thwZoTTeKIyMza
7KBNBN0+q41pcWHoF4RblKt6j0QZids3BL9HfUFV3i71EVWTeKzDKU86kAxR
BcWOgRvMJLO2cQqrPr0zpIzXLRn0iki6Lm8FSdD7tCEHuFAfltjhDHO1j8lg
X+ad9fQQjMkwyInJg35ZpZsqpIQwQIau6Qszst5AgbES64fQ/xWgTxwSmbgV
JuwCkW7xvBomp5+FsM48P2R28usQoEd9iBDb/T2A7oeJ6Ht3SuneD/P2c0VA
H/OH2Z/GHDpTwbNJuD9P4Gb9csxB6viPPN2T2GyIB5crfXNWHg/3eCjrvn7d
UJzdTHN2za04uxm8fVqp00XBVN119d7I4dRWG6nMaGROHyNwRruA5vzl4jlb
ONJz1yM+OG2NQGaASwOQ8muZmC6A3cJBeRpSWTkkqfR1GqNxW8rt2oSVGzt7
sr1kBjSn2+M+ch7jmXFrQP6JKcjUyz5B1ViPw/Oy6XyMJ92tkUkeTVGXBe9m
7zUCYtzNgJl1xVKdTn5pj+XHgsrpe7jH/56aHcVPMDKHQT+DxKYUm2R96eqK
CQhtP1OKpOmQYKneKdpsQxNiU6sJql5mRBivcAj9eLIJEPrhRUBtBXWz0xwS
5lHvUtMEbt5v0j2UaH7/IUTMlIbH7M1LVIkvNf7Pzr/eT/87TZD4/gNn/pCm
XvpzaN3qv0Nooypg1eJpgMwYUfI2gQ6JT6HHbmOgEpAa8xziN4VjSrqN00rU
u6vLBGoQk6ZPvUoIYxiY2rIiodcCO1I5rPdSNtqEx+2zW4+4oaD1CxNC47aU
2y0JRuBwQRhcQaRdUaZcUoLYrTY6dAxR9RqW1GtwnUMVVnJ6+07FTbdU3MOC
qceH3jBOUvTM6E4AIicnMCemfFAzhgdNuUGqazrqLNiKL+G5macSeqqMcTQa
QLwEw4ea/KcJXNuSc5LoXyRwM6VOmLjasmv0R3Ibjhp/AZfilmQ=\
\>"],ImageRangeCache->{{{0., 399.}, {120.188, 0.}} -> {-0.309905, -0.5, \
0.00832033, \
0.00832033}},ExpressionUUID->"00dca30c-16e8-400e-b637-bea206405a63"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[50]=",ExpressionUUID->"c38aa28a-1609-4a78-b0c8-f67a555f24d3"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Invar`",
  FontFamily->"Courier New"],
 " currently handles invariants up to and including ",
 StyleBox["\[CapitalLambda]",
  FontSlant->"Italic"],
 " = 12, plus the single case {0, 0, 0, 0, 0, 0, 0} of order 14. The full \
list of cases can be generated with the following command,"
}], "Text",ExpressionUUID->"efb207c6-6ffd-467b-a4ba-8057a5c48479"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvarCases", "[", "]"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"c1e7f6cc-d85a-4db6-927d-1def7f0003be"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", "8", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "10", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}], "}"}]], "Output",
 CellLabel->"Out[48]=",ExpressionUUID->"2dece67a-d33b-4ada-81b7-5932820ee7c2"]
}, Open  ]],

Cell["\<\
This function admits two additional arguments. The first specifies the order\
\>", "MathCaption",ExpressionUUID->"4f53fc50-3c7b-43a3-8e8b-daf8e7d46807"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvarCases", "[", "8", "]"}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"a346fab9-758c-4a5d-a5e0-1fd646691deb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "6", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[49]=",ExpressionUUID->"8ffe7183-90b8-4472-8c28-f32758e960d0"]
}, Open  ]],

Cell["and the second specifies the degree", "MathCaption",ExpressionUUID->"ad73d4b3-2c39-45cb-b826-fcbfdbd48278"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvarCases", "[", 
  RowBox[{"8", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"b293f738-b600-4d17-a8b4-f950e3d28481"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[50]=",ExpressionUUID->"a941cee1-a2ba-43e1-a1b0-488b371a9826"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3. Canonical invariants",
 FontSize->14]], "SubsectionIcon",ExpressionUUID->"57995aab-b7cd-4fa7-900e-\
a4485083fbc7"],

Cell[TextData[{
 StyleBox["RInv\t\t\t\t", "DisplayMath"],
 StyleBox["Non-dual invariant \n", "Text"],
 StyleBox["DualRInv\t\t\t", "DisplayMath"],
 StyleBox["Dual invariant", "Text"],
 StyleBox["\nRInvs\t\t\t\t", "DisplayMath"],
 StyleBox["List of all non-dual invariants after a given step\n", "Text"],
 StyleBox["DualRInvs\t\t\t", "DisplayMath"],
 StyleBox["List of all dual invariants after a given step\n", "Text"],
 StyleBox["MaxIndex\t\t\t", "DisplayMath"],
 StyleBox["Maximum value of the index for the list of non-dual invariant \
after a given step\n", "Text"],
 StyleBox["MaxDualIndex\t\t", "DisplayMath"],
 StyleBox["Maximum value of the index for the list of dual invariants after a \
given step\n", "Text"],
 StyleBox["RInvRules\t\t\t", "DisplayMath"],
 StyleBox["List of all independent invariants for a given step and case\n", 
  "Text"],
 StyleBox["RemoveRInvRules\t\t", "DisplayMath"],
 StyleBox["Remove rules for invariants of a given step and case", "Text"]
}], "DefinitionBox",ExpressionUUID->"7819ccd0-8c64-4f23-afe0-be05f2ca0f6b"],

Cell["Canonical invariants", "SmallText",ExpressionUUID->"2af38f03-567a-401c-acde-8da289478671"],

Cell[TextData[{
 "For a given case ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Lambda]", "1"], ",", " ", "...", ",", " ", 
     SubscriptBox["\[Lambda]", "n"]}], "}"}], TraditionalForm]],
  ExpressionUUID->"30a47592-0c9a-41c2-8f6d-af0a9abc0374"],
 ", there will be ",
 StyleBox["N",
  FontSlant->"Italic"],
 "! different monomials, where ",
 StyleBox["N = ",
  FontSlant->"Italic"],
 "4",
 StyleBox["n +",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"i", "=", "1"}], "n"], TraditionalForm]],ExpressionUUID->
  "5d77e3bc-142d-455d-8286-7cc7c05fa5da"],
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "i"], TraditionalForm]],ExpressionUUID->
  "8242d7e0-7bc3-4abc-8314-dc2e7c5d8867"],
 ", as we saw in the previous section. It is obviously impossible to store \
them all. "
}], "Text",ExpressionUUID->"9293bfcf-7aac-4590-a2a6-77085cd307a7"],

Cell["\<\
Consider, for example, the numbers of possible permutations taking into \
acount only algebraic invariants, for wich the number of indices is N = 4n:\
\>", "MathCaption",ExpressionUUID->"c31dd39b-c18d-48f3-94de-fa388c7f4d9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "n"}], ")"}], "!"}], ",", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "n"}], ")"}], "!"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "7"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<degree\>\"", ",", "\"\<number of monomials\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"8b45ffa1-e664-49f6-ab86-b8130b37428d"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox["\<\"degree\"\>",
       HoldForm], 
      TagBox["\<\"number of monomials\"\>",
       HoldForm], 
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ]},
     {"1", "24", "24.`"},
     {"2", "40320", "40320.`"},
     {"3", "479001600", "4.790016`*^8"},
     {"4", "20922789888000", "2.0922789888`*^13"},
     {"5", "2432902008176640000", "2.43290200817664`*^18"},
     {"6", "620448401733239439360000", "6.204484017332394`*^23"},
     {"7", "304888344611713860501504000000", "3.0488834461171387`*^29"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {None, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {None, {"degree", "number of monomials"}}]]]], "Output",
 CellLabel->
  "Out[47]//TableForm=",ExpressionUUID->"94dbc338-97f3-48ff-b9c2-\
ce52827b21b8"]
}, Open  ]],

Cell[TextData[{
 "We can, however, store the corresponding canonical invariants with respect \
to permutation symmetries. The numbers of canonical invariants for each case \
are stored in the functions ",
 StyleBox["MaxIndex",
  FontFamily->"Courier New"],
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["and",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["MaxDualIndex",
  FontFamily->"Courier New"],
 StyleBox[",",
  FontWeight->"Bold"]
}], "MathCaption",ExpressionUUID->"eb00865e-a7e7-4f71-be5b-e986ff8addfd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaxIndex", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"8e2f432f-a662-470b-a837-0feac0d007d0"],

Cell[BoxData["1622"], "Output",
 CellLabel->"Out[48]=",ExpressionUUID->"1eabbd3f-966f-4ad6-b9e0-c0e6a7ba190f"]
}, Open  ]],

Cell["For example, the values up to order 10 are", "MathCaption",ExpressionUUID->"5db1e199-c628-47c0-91e5-e09d1c6a0142"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"InvarCases", "[", "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"Range", "[", "26", "]"}], "]"}], "]"}], ",", " ", 
     RowBox[{"MaxIndex", "/@", 
      RowBox[{
       RowBox[{"InvarCases", "[", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"Range", "[", "26", "]"}], "]"}], "]"}]}]}], "}"}], "//", 
   "Transpose"}], "]"}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"09e42229-1289-40fe-a394-4c43ff053580"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", "0", "}"}], "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "3"},
     {
      RowBox[{"{", "2", "}"}], "2"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "9"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], "12"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "12"},
     {
      RowBox[{"{", "4", "}"}], "12"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "38"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2"}], "}"}], "99"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], "125"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], "126"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "138"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], "86"},
     {
      RowBox[{"{", "6", "}"}], "105"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "204"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], "1020"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], "1749"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "4"}], "}"}], "1473"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "3"}], "}"}], "3099"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "2"}], "}"}], "1622"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "2"}], "}"}], "1617"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}], "1665"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "1770"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "1746"},
     {
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "962"},
     {
      RowBox[{"{", "8", "}"}], "1155"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[49]//MatrixForm=",ExpressionUUID->"0a5cd1bb-9912-4a7a-be91-\
429d4b8930be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaxDualIndex", "/@", 
  RowBox[{"InvarDualCases", "[", "]"}]}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"5959faed-3712-45d9-aa96-14103091f62b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "3", ",", "27", ",", "58", ",", "36", ",", "32", ",", 
   "232", ",", "967", ",", "1047", ",", "876", ",", "920", ",", "478", ",", 
   "435", ",", "2582"}], "}"}]], "Output",
 CellLabel->"Out[50]=",ExpressionUUID->"9aa70ef7-a3ff-4d54-bec8-feed5d5e067a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"MaxDualIndex", ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"cfaeb364-08af-48c8-a2c7-d223c4e3eed9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "27", ",", "232", ",", "2582"}], 
  "}"}]], "Output",
 CellLabel->"Out[51]=",ExpressionUUID->"5dd5eb9a-93bd-4aaa-83b9-6bb887b3800c"]
}, Open  ]],

Cell[TextData[{
 "Within each case, the canonical invariants are labeled ",
 StyleBox["(Dual)RInv[metric][case, index]",
  FontFamily->"Courier New"],
 ", where ",
 StyleBox["index",
  FontFamily->"Courier New"],
 " is an integer ranging from 1 to ",
 StyleBox["Max(Dual)Index[case]",
  FontFamily->"Courier New"],
 ". Non dual invariants are output as ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", 
    RowBox[{"case", ",", " ", "index"}]], TraditionalForm]],ExpressionUUID->
  "c88cb4d8-ee81-423e-b78b-55741869a524"],
 ", where case, for brevity and clarity, is not the list ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Lambda]", "1"], ",", " ", "...", ",", " ", 
      SubscriptBox["\[Lambda]", "n"]}], "}"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "but", " ", "simply", " ", "the", " ", "concatenation", " ", "of", " ", 
       "its", " ", "elements", " ", 
       SubscriptBox["\[Lambda]", "1"], 
       SubscriptBox["\[Lambda]", "2"]}], "..."}], 
     SubscriptBox["\[Lambda]", "n"]}]}], TraditionalForm]],ExpressionUUID->
  "f2c0df7f-d71e-44be-aed7-262d6cd19eba"],
 ". Notice that there is no confusion because the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "i"], TraditionalForm]],ExpressionUUID->
  "f0823e2b-1263-47fd-9214-94ec708eaadf"],
 "are always single digit integers, except for the case {10}, but even then \
there is no problem, because we always write the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Lambda]", "i"], TraditionalForm]],ExpressionUUID->
  "c4eb889d-af0a-489f-8762-06b941d04af8"],
 " in increasing order. Dual invariants are represented by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", 
    RowBox[{"case", ",", " ", "index"}]], TraditionalForm]],ExpressionUUID->
  "946598c2-f9f2-446d-b029-4c9abcb1afab"],
 ". "
}], "Text",ExpressionUUID->"850029e2-2446-4d02-a0f0-0b4ec0e86d59"],

Cell["Examples:", "MathCaption",ExpressionUUID->"ac280aed-5d3a-4941-8555-d5f6350809fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RInv", "[", "metric", "]"}], "[", 
   RowBox[{
    RowBox[{"{", "10", "}"}], ",", "100"}], "]"}], "+", 
  RowBox[{
   RowBox[{"RInv", "[", "metric", "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[52]:=",ExpressionUUID->"dd584438-6aee-42f9-bd9f-3b055864de6f"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"10,100\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,1\"\>"]}]], "Output",
 CellLabel->"Out[52]=",ExpressionUUID->"cacd1e66-db2a-44f1-921d-6ed5f72a779a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RInv", "[", "metric", "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", "12"}], "]"}], "-", 
  RowBox[{
   RowBox[{"DualRInv", "[", "metric", "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"0dfe2743-506f-400f-9bc8-2011461e6a41"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SubscriptBox["\<\"D\"\>", "\<\"000,1\"\>"]}], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"012,12\"\>"]}]], "Output",
 CellLabel->"Out[53]=",ExpressionUUID->"ab0cc157-9105-460a-927c-a66cf7c1943a"]
}, Open  ]],

Cell[TextData[{
 "As we apply more symmetries, the lists of independent (Dual)RInvs get \
smaller. We can produce the independent invariant at each simplification step \
with the command ",
 StyleBox["(Dual)RInvs[metric][step, case]",
  FontFamily->"Courier New"],
 ". The first step produces a list of length ",
 StyleBox["MaxIndex[case]",
  FontFamily->"Courier New"]
}], "Text",ExpressionUUID->"84cba17d-c602-45cb-87c7-d803fcc02810"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", "metric", "]"}], "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"e0d8d843-3ee0-4bfc-b749-1f73aa9c12d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"22,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,3\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,4\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,5\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,6\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,7\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,9\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,10\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,11\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,12\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,13\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,14\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,15\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,16\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,17\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,18\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,19\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,20\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,21\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,22\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,23\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,24\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,25\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,26\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,27\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,28\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,29\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,30\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,31\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,32\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,33\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,34\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,35\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,36\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,37\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,38\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,39\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,40\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,41\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,42\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,43\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,44\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,45\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,46\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,47\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,48\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,49\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,50\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,51\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,52\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,53\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,54\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,55\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,56\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,57\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,58\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,59\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,60\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,61\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,62\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,63\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,64\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,65\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,66\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,67\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,68\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,69\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,70\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,71\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,72\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,73\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,74\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,75\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,76\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,77\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,78\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,79\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,80\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,81\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,82\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,83\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,84\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,85\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,86\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[54]=",ExpressionUUID->"087ebdc3-dc08-47a1-a058-c4aa1968fd68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RInv", "[", "metric", "]"}], "[", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", 
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"07b8ed95-4264-4ebd-b16a-19fa61c90d58"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"2,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,3\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,4\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,5\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,6\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,7\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,9\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,10\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,11\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,12\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,13\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,14\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,15\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,16\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,17\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,18\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,19\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,20\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,21\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,22\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,23\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,24\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,25\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,26\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,27\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,28\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,29\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,30\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,31\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,32\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,33\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,34\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,35\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,36\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,37\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,38\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,39\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,40\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,41\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,42\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,43\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,44\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,45\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,46\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,47\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,48\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,49\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,50\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,51\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,52\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,53\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,54\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,55\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,56\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,57\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,58\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,59\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,60\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,61\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,62\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,63\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,64\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,65\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,66\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,67\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,68\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,69\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,70\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,71\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,72\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,73\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,74\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,75\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,76\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,77\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,78\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,79\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,80\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,81\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,82\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,83\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,84\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,85\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"2,86\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[55]=",ExpressionUUID->"79011893-31b1-459d-84b9-d183ab6d866b"]
}, Open  ]],

Cell["After applying the cyclic identity we get ", "MathCaption",ExpressionUUID->"ca8cfcab-265b-4856-889c-c0167be8975f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", "metric", "]"}], "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[56]:=",ExpressionUUID->"60c69047-d0c0-4fd0-836d-1231bfd691ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[56]:=",ExpressionUUID->"20ddef81-82f1-4ef6-823f-456b2cca40ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"22,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,3\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,4\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,5\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,6\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,7\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,9\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,10\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,11\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,12\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,13\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,14\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,15\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,16\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,17\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,18\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,19\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,20\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,21\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,22\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,23\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,24\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,26\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,27\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,28\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,29\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,31\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,32\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,34\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,35\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,36\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,37\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,38\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,39\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,40\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,41\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,44\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,46\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,48\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,50\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,52\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,54\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,55\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,56\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,57\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,58\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,59\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,67\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,68\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,69\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,73\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,74\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,75\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,76\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,77\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,78\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,85\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[56]=",ExpressionUUID->"87ab4916-b5dc-4c56-9ec9-81c0814d3e8f"]
}, Open  ]],

Cell["After the Bianchi identity", "MathCaption",ExpressionUUID->"800a1704-e110-4726-aab1-cd1d6ec99c06"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", "metric", "]"}], "[", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"63a6b138-95d1-4e0a-a931-ef8d233c02cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"8c4f2e02-a437-4b38-b656-68a66f735f44"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"22,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,3\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,4\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,6\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,10\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,15\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,16\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,17\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,18\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,19\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,20\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,21\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,22\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,27\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,34\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,38\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,44\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,67\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,73\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,74\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,77\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[57]=",ExpressionUUID->"b20d456b-38a1-40e9-ae90-8bc63f726aea"]
}, Open  ]],

Cell["After reordering derivatives", "MathCaption",ExpressionUUID->"1ddbde54-016e-45fe-a1a0-ba5b3a6ca0ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", "metric", "]"}], "[", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"82a7aa91-3e70-44e5-8edf-0e6592c1fc7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"22d8e4a5-00e9-45dc-ab36-c818f5bc3d32"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"22,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,3\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,17\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,19\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,22\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,73\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[58]=",ExpressionUUID->"3a14b151-f4bf-4b17-86cb-0ca286951356"]
}, Open  ]],

Cell["After the dimensionally dependent identities", "MathCaption",ExpressionUUID->"efda4394-fb26-46e7-bd31-5ecd9b088306"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", "metric", "]"}], "[", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"75835581-4bd4-4555-9a7f-bd484186d026"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {2, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"6384a671-d483-40d0-8da4-c35f0e96471a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"22,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,3\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,17\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,19\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,22\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,73\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[59]=",ExpressionUUID->"e7501260-2198-4e2c-886f-64c12df403e1"]
}, Open  ]],

Cell["\<\
In this case there are no signature dependent relations (= relations arising \
from products of dual invariants)\
\>", "MathCaption",ExpressionUUID->"25836a0e-565c-45b1-8d57-25b5ad215bf1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", "metric", "]"}], "[", 
  RowBox[{"6", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[60]:=",ExpressionUUID->"1c20829b-1a44-4c58-820a-2d948ff2c350"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {2, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"ed891a9c-0c01-4193-a4bf-4ad4d721ea9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"22,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,3\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,17\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,19\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,22\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"22,73\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[60]=",ExpressionUUID->"5fef6f82-1f30-4628-ad72-573864da6e91"]
}, Open  ]],

Cell["\<\
The following table reproduces the one in the paper listing the numbers of \
invariants after each step for all cases up to order 10\
\>", "MathCaption",ExpressionUUID->"b414dded-5307-4c55-91c1-1aa6ac87f58a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"step", ",", 
       RowBox[{
        RowBox[{"InvarCases", "[", "]"}], "[", 
        RowBox[{"[", "case", "]"}], "]"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"step", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"case", ",", "26"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"69d7048d-66e3-496d-a9f6-97acddebb4ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"2c80c951-ac7a-45e4-8d70-3c045730ba54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"1aadf7c7-090d-46a9-8993-d6ca49e330a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"8e80f3b5-ec90-48ba-a93b-e9e511c5ebe2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"84b8644d-99f3-444d-820e-632340d11642"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"68c46bac-ca7c-4aac-9483-6e0c7f82014a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"dc36f06a-ce6c-43d5-a46b-af34db45b3bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ab9a80dd-d4b8-4bcd-a994-34ceb832d61e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"0613966e-9df4-439b-9492-0b81819f9a25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"897735f0-b54b-4fc9-984d-ae9287b69d78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ca36c981-54fa-4fe9-84bf-f5f7cba40e1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {6}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"6ba024a2-47cc-478d-abd3-3b9513093a7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"8149777e-be9c-4142-8b44-01e8a7a44332"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"281ca7fc-9603-4ba5-948e-d01d0482c05e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"04e31df0-b581-4b34-a458-7335e6e4c85f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"92731c80-f98d-4526-8b0c-42a8a161f69a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 1, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"8d2afbc9-db2c-4e09-9c17-d9fd7ba7a0cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"b5cb3543-6da8-42c0-b64a-daf59c067c1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"0b79da20-c467-4dcc-94c0-17f8a96771b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 6}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"85759602-cbe7-489b-948e-ea2c7daa60b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 5}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"e2b001af-6594-42d6-bd52-acd446dfab7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"38380e7b-4816-4de5-bf86-6c03862772d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {3, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"a79ecdb5-048e-45a4-ba76-803ea64aa2b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {8}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"a1c5db51-772b-44cb-96a7-b8d5655713cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"f4bd477e-b623-47a6-b49f-07efb60e98ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"59777bcf-dc91-478d-9936-d01fbd346ee0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"78eee3db-6986-416a-8424-474f532deff3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"3af58777-e3ef-4f29-88ba-27e3c304ebff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"9792c635-2a11-4054-a8a5-f4c8662c9511"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"138a1b51-0cb7-4903-a820-bc824259e1fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"4a1b253c-424a-4dcb-a6ce-ba3fbb8b7439"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"070840d8-23f8-4008-8fa9-93547961ff68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"f618f2df-ff79-4f83-b3e3-3c7668f86bf5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"a8883d6d-25e5-4771-937c-5a6eb1b9679e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {6}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"17628799-a2c7-4f02-96fb-396c794f09ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"f15920fc-ac17-4574-959b-3ba38cb6ac39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"44c105e5-3e1e-449c-86f3-e89ab437d716"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"3268ddf4-3ee2-4a85-886c-b17190bfc1ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"45b2de31-5b84-4924-83f5-65072759c365"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 1, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"41d79f2e-e03b-4e9f-891f-ce4153038757"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"083b419a-d289-41d4-bc3d-01b0c9e2fdfd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"bc7aef20-abdb-44d4-8859-76f2355c6b4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 6}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"7eaa89d1-7336-4a53-bc77-916fdcce58fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 5}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"9a3f0b9b-e25d-45cc-9fe4-28901a072517"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"1dd9683e-2c26-4f4d-9549-e587db3573f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {3, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"f75eb552-de25-4b4d-adfa-7035e824d67b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {8}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"8db8dded-a0ed-4ad7-9970-c30ebd06e5bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"db5256cb-d906-4c8a-b924-027d05144405"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"846ab487-281e-4aab-8971-c5981e5030c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"d5883696-f621-4cff-9e57-0c88410b0c76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ee34f507-dc47-480d-a25b-19f273b5ec05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"e93b3e07-1db7-4ab5-acb5-b3335d0eadcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"8d1c693e-1da0-48a6-873e-8136762db554"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"9e902e60-1e00-4dd3-ae77-b491096e4a93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"28650878-8dbc-4497-8c5f-bb3b94b51dc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"e8a0f6d6-b110-4385-b6ae-075a1bc86a15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"b8d80ebc-e557-410d-8d99-2fedbb243af6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {6}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"f4581c64-1cac-4c84-aeda-9a620e9f46ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"613c29f0-b303-4c21-800c-4ad1cf0d38fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"8959554a-9cdc-4e44-aff9-598010b9244c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 1, 1}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"1b8957ab-994c-4f7a-b876-deb59d9196ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"aa88aefa-926f-4fb1-872a-f263fa80e08d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 1, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"7a25ca2b-53f5-47a3-905f-f4cf0934c402"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 2, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"0e95622a-2bbb-4071-9600-febd78a7949e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 1, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"97491c3e-2570-4c04-a499-0aadb82ff754"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 6}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"dee52d4a-005a-4c40-aad6-d60a20d3f992"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 5}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"89eacb41-af7c-4bd0-b317-fb000c0f0ec4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {2, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"7449133c-39f4-4c9a-a0ee-b9aeb485d023"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {3, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"2753dd92-0d98-4068-9af1-639b89065f75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {8}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"d0d58e72-e4b3-4d74-941f-5ea9648e1681"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"0ff1df2d-25db-4c4c-861f-23d742154043"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"9f7554df-efc5-41c1-9958-6c8957d7cfd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"6e715551-2149-476a-a7dd-a98ac88a9d42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"4b5fb320-ab16-4840-a997-db4ff972e20a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 1}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"348edb88-1aac-4221-a16a-d08fbd1e0ad8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {4}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ddf971a6-c0a5-472b-85d7-f26b6004a47a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 3}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"6e2edf5e-0ead-46d9-a94b-6c529a41cf98"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {6}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ee355b46-0a23-4cbc-ac48-cadbe732f5a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 0, 0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"2495f1b4-2588-4c2a-af82-7cd31dc5b59d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"6198c07d-ccf1-450d-80c2-a9b8ae0f8757"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 1, 1}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"c8124240-351a-4d7a-b8f5-a69d7501f60a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 4}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"0c92afd4-e15e-4024-95f9-6e1044a54be5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 1, 3}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"3bea3691-a55d-4ffe-a949-a391cfa056df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 2, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"a4e0c772-cdb2-4330-a88d-869cdfe75775"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 1, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"b43821ae-0722-4c00-a342-035e4cbb7583"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 6}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"01f7f454-751b-4b1f-8c61-509886991758"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 5}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"9dc6d929-0178-4d6f-8ad3-9320b620bd01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {2, 4}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"c2504352-45ac-460d-8a74-31c1a0228695"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {3, 3}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"22a88aa8-9f7a-4495-bf69-73c973d18cfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {8}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"0e6bae74-7742-48e2-b4de-c92f2c8daa3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {4}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"b1e8a66f-0334-4a6b-94bf-73d3154f41e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 3}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"bd094e5e-52a5-4db8-9ea6-177a6fea3e83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {6}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"b6023163-36b7-4c74-98ac-ab4fc16a12cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 0, 0}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"e4e8669a-1279-4bba-b5c6-91e007360eb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"b268f1a2-2a10-4143-a5dc-0ff9b914f7d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 1, 1}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ea9aaf78-d1c5-4f52-86c1-0e6ba497c66c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 4}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ee6b59da-9651-4aee-ac18-b5657b186caa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 1, 3}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"2ade7425-a113-4064-b37b-897468fe7025"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 2, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"b68221d7-a797-4f38-9f35-d8da1be79bef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 1, 2}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"3e5f459c-5bda-46d6-b6dd-b4cde4312041"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 6}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"60af7a9d-32b1-47d2-9674-00c989e67eb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 5}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ba6b421d-a08f-4920-bf8d-9048b4d54d08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {2, 4}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"a03e1fec-c847-4366-a347-842f20ef3eed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {3, 3}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"70faad0f-250a-46ba-96f6-4173d363e74c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {8}, " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"d08cc5f6-a5de-429a-a581-0b654ce76303"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InvarCases", "[", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"Range", "[", "26", "]"}], "]"}], "]"}], "}"}], ",", "%"}], 
    "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[62]:=",ExpressionUUID->"2903df34-1cf8-4fae-9a96-2cbc86f1b242"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", "0", "}"}], "1", "1", "1", "1", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "3", "2", "2", "2", "2", "2"},
     {
      RowBox[{"{", "2", "}"}], "2", "2", "1", "1", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "9", "5", "5", "5", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], "12", "9", "5", "3", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "12", "9", "4", "4", "4", "4"},
     {
      RowBox[{"{", "4", "}"}], "12", "11", "6", "1", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "38", "15", "15", 
      "15", "4", "3"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2"}], "}"}], "99", "48", "27", "15", "10",
       "10"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], "125", "63", "23", "23", 
      "17", "17"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], "126", "84", "47", "3", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "138", "95", "32", "5", "5", "5"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], "86", "59", "23", "7", "7", "7"},
     {
      RowBox[{"{", "6", "}"}], "105", "90", "50", "1", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "204", 
      "54", "54", "54", "5", "3"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], "1020", "313", 
      "175", "79", "26", "25"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], "1749", "564", 
      "194", "194", "76", "74"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "4"}], "}"}], "1473", "648", "361", "17", 
      "12", "12"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "3"}], "}"}], "3099", "1387", "442", "53", 
      "42", "42"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "2"}], "}"}], "1622", "727", "244", "46", 
      "34", "34"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "2"}], "}"}], "1617", "741", "143", "67", 
      "52", "52"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}], "1665", "1025", "570", "3", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "1770", "1115", "362", "5", "5", "5"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "1746", "1093", "356", "9", "9", "9"},
     {
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "962", "612", "211", "9", "9", "9"},
     {
      RowBox[{"{", "8", "}"}], "1155", "945", "525", "1", "1", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[62]//MatrixForm=",ExpressionUUID->"94555457-9d33-4d5e-8b09-\
24c2705665bc"]
}, Open  ]],

Cell[TextData[{
 "The simplified notation",
 StyleBox[" RInvs[metric][step, n]",
  FontFamily->"Courier New"],
 " is automatically translated into ",
 StyleBox["RInvs[metric][step, {0, ",
  FontFamily->"Courier New"],
 Cell[BoxData[
  FormBox[
   OverscriptBox["...", "n"], TraditionalForm]],
  FontFamily->"Courier New",ExpressionUUID->
  "7993d0d7-30a8-4a90-9944-f32ac0ecaa28"],
 StyleBox[", 0}]",
  FontFamily->"Courier New"],
 ", for backwards compatibility with Invar 1.  For instance, these are all \
the algebraic invariants after step 3 with degree 6 (case {0,0,0,0,0,0}):"
}], "MathCaption",ExpressionUUID->"e4946c7b-6812-4878-b9f2-a8ea3ad205b1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", "metric", "]"}], "[", 
  RowBox[{"3", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"4831b08d-7b71-4c8b-937b-b7081bf09ba3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"868904a1-830e-4625-bd5e-3b1fbb3eea26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"4752d68e-747e-42dd-8820-a9dea69de5a9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"000000,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,3\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,4\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,6\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,9\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,11\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,13\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,14\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,16\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,17\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,18\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,19\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,22\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,23\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,25\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,27\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,32\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,34\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,36\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,38\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,40\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,45\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,47\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,49\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,50\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,52\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,57\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,60\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,65\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,66\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,69\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,71\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,74\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,76\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,77\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,84\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,86\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,87\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,88\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,91\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,94\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,95\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,97\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,101\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,103\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,108\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,110\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,112\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,114\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,117\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,119\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,136\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,140\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,143\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,147\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,149\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,151\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,156\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,165\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,167\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,174\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,176\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,178\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,180\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,183\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,187\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,189\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,191\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,196\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,208\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,213\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,216\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,221\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,223\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,229\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,231\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,233\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,235\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,240\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,242\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,244\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,245\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,247\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,252\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,255\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,260\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,261\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,264\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,266\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,268\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,270\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,275\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,292\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,296\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,298\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,304\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,309\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,312\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,331\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,334\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,342\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,344\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,346\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,348\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,349\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,353\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,359\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,362\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,372\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,374\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,379\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,381\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,383\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,385\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,393\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,395\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,400\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,402\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,404\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,406\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,409\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,411\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,428\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,432\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,435\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,439\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,441\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,443\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,448\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,457\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,459\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,464\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,466\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,468\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,470\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,474\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,478\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,480\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,484\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,492\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,497\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,499\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,503\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,505\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,510\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,533\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,535\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,539\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,544\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,561\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,569\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,625\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,627\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,629\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,633\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,650\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,655\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,658\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,665\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,670\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,672\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,701\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,703\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,708\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,712\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,714\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,716\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,719\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,725\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,732\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,738\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,740\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,742\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,749\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,751\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,754\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,765\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,767\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,772\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,782\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,791\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,797\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,802\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,828\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,829\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,839\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,864\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,869\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,898\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,928\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,930\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,935\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,937\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,939\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,941\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,944\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,946\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,963\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,967\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,970\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,974\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,976\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,978\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,983\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,993\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,998\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1001\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1003\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1006\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1009\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1011\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1015\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1023\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1028\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1030\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1045\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1048\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1053\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1058\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1068\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1073\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1076\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1081\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1083\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1131\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1142\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1146\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1148\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1153\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1158\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1161\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1179\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1182\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1190\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1192\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1194\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1201\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1203\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1204\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1213\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1219\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1221\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1223\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1478\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1480\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1482\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1486\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1488\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1502\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1504\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1508\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1510\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1519\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1523\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1530\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1541\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1542\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1548\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1561\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1563\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1572\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1576\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1577\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1579\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1582\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1586\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1588\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,1596\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[63]=",ExpressionUUID->"99a4fc9f-b1f7-4146-82cc-d29b485c448e"]
}, Open  ]],

Cell[TextData[{
 "Similar shorthands are available for other commands, such as ",
 StyleBox["MaxIndex",
  FontFamily->"Courier New"],
 " or ",
 StyleBox["RInv",
  FontFamily->"Courier New"]
}], "MathCaption",ExpressionUUID->"460cee84-40d2-4c59-96f4-8ddd51e3826a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MaxIndex", "[", "7", "]"}], ",", " ", 
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}],
     "]"}]}], "}"}]], "Input",
 CellLabel->"In[64]:=",ExpressionUUID->"a04afb3e-0af4-4712-a99b-800e4b2fc74e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16532", ",", "16532"}], "}"}]], "Output",
 CellLabel->"Out[64]=",ExpressionUUID->"711b6483-9333-4f9a-b06d-43c92206bd87"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInv", "[", "metric", "]"}], "[", 
  RowBox[{"4", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"130afe70-3f3c-4c5d-ac2a-d7509d3ceef8"],

Cell[BoxData[
 SubscriptBox["\<\"I\"\>", "\<\"0000,1\"\>"]], "Output",
 CellLabel->"Out[65]=",ExpressionUUID->"94997bd7-e3fb-4e24-905f-fc7d88287499"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DualRInvs", "[", 
  RowBox[{"2", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"8a2458b3-4a57-42cf-83db-7da0747528df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[66]:=",ExpressionUUID->"5d780106-f341-4b75-aeee-567a8f3f4620"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"D\"\>", "\<\"0000,2\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,7\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,10\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,13\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,17\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,18\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,23\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,26\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,27\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,29\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,35\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,38\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,43\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,44\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,51\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,60\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,68\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,70\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,80\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,82\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,85\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,94\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,96\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,100\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,113\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,116\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,121\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,122\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,127\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,128\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,131\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,138\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,145\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,148\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,149\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,201\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,202\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,210\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,215\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,227\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[66]=",ExpressionUUID->"a5bc6632-dc88-4703-8b01-4322dd165dfe"]
}, Open  ]],

Cell["\<\
If we restrict ourselves to algebraic invariants we can give a basis of only \
25 invariants (notice that there is no step 6 for dual invariants)\
\>", "Text",ExpressionUUID->"0b7b236c-e094-4393-8ffd-49c25bfbe2fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RInvs", "[", "metric", "]"}], "[", 
       RowBox[{"6", ",", "#"}], "]"}], "&"}], "/@", 
     RowBox[{"Range", "[", "7", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"DualRInvs", "[", "metric", "]"}], "[", 
       RowBox[{"5", ",", "#"}], "]"}], "&"}], "/@", 
     RowBox[{"Range", "[", "5", "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[67]:=",ExpressionUUID->"9ee629d2-37b1-43f8-bbd7-0a0ff54d10be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"178f5165-ed4f-4d9a-8840-58b2ebe47cdb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 0, 0, 0}, " and dimension ",
    4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"9649c76a-7845-46eb-86ef-2b1c914e96c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 0, 0, 0}, " and dimension ",
    4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"a7614682-9ce5-40be-8725-b546b328af1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"6acf8e50-f671-4dbc-afaa-ad348fdee1fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"e774ae30-8afa-4c0d-b84f-55dfe9c3cab7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"57bc23c6-8070-4c0a-9dae-49d29cfced0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 0, 0, 0, 0}, 
   " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"032c284a-833c-4fbd-9cdb-e74373cab782"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 0, 0, 0, 0}, 
   " and dimension ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"b2e5e511-1a86-467e-aa38-9dfdb0756feb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"dc7e39e1-7efd-4de4-bcb7-0482a3ab4e04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"4feaea3b-99d1-48c4-9d51-7cc20c0c6adc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"80b6cea7-f58a-4d05-9c55-46170f3a153b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"1b89b346-a6ec-4158-b725-3b215b8dab5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"33e7497e-6e63-4d55-a14f-55644be63489"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"7b6c21c0-d80a-481d-84ae-6b68144e6f85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"4bad3698-23e6-476a-9a14-5b1fe918b611"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"285fd60a-3ef5-45d0-9b29-e918ed103b46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"a6b461f2-e00a-418a-b370-7e620c7c2a69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"4f6d060d-63c8-4f5d-890b-9bda5d96ec26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[67]:=",ExpressionUUID->"813bf0dd-d0b6-4432-a033-450f9f6f56d3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"00,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"00,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000,5\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"0000,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"0000,5\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"0000,7\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"00000,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"00000,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"00000,33\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,6\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,47\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"000000,242\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"0000000,14\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"0000000,55\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"0000000,391\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"00,2\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"000,2\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"000,13\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"0000,7\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"00000,2\"\>"], ",", 
   SubscriptBox["\<\"D\"\>", "\<\"00000,76\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[67]=",ExpressionUUID->"bcc3fff8-00f2-4091-8375-2e00fe900628"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"%", ",", 
     RowBox[{"InvToRiemann", "[", 
      RowBox[{"%", ",", "False"}], "]"}]}], "}"}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[68]:=",ExpressionUUID->"5388cf2c-e93f-4ab6-b394-075c0b16e3bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[68]:=",ExpressionUUID->"d1fe1b65-e2cf-4e1c-8e72-08fd648973d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[68]:=",ExpressionUUID->"dfd331c0-31f6-4b27-8831-8293ef552bad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[68]:=",ExpressionUUID->"f51f8e0d-0598-410f-9655-abce779a71a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[68]:=",ExpressionUUID->"c04d484a-5aa8-492f-8f38-954ff1141731"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0, 0, 0}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[68]:=",ExpressionUUID->"91ec41da-28de-45a4-b75b-f1aea514db6d"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", "b", " ", " "},
                {" ", " ", "a", "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b],
         Editable->False], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[
       $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, -$CellContext`b]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"00,1\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", " "},
                 {"b", " ", "c", "d"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
-$CellContext`d]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"00,2\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", " ", " "},
                 {"a", "b", "c", "d"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", "c", "d"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"000,1\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", " "},
                 {"c", " ", "e", "f"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"000,2\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", " "},
                 {"d", " ", "e", "f"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"000,5\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", "e", "f"},
                 {"a", "b", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", "c", "d"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", " ", " "},
                 {"c", "d", "e", "f"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, $CellContext`e, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"0000,1\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"c", " ", "f", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`f, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", " ", " "},
                 {"e", " ", "g", "h"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`e, $CellContext`h, \
-$CellContext`g, -$CellContext`h],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`f, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`e, \
$CellContext`h, -$CellContext`g, -$CellContext`h]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"0000,5\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", "e", "f"},
                 {"b", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "g", " ", " "},
                 {"c", " ", "e", "f"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", " ", " "},
                 {"d", " ", "g", "h"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`h, \
-$CellContext`g, -$CellContext`h],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`f]) $CellContext`RiemannCD[-$CellContext`d, \
$CellContext`h, -$CellContext`g, -$CellContext`h]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"0000,7\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"d", " ", "e", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", " ", " "},
                 {"f", " ", "g", "h"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`h, \
-$CellContext`g, -$CellContext`h],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`f, \
$CellContext`h, -$CellContext`g, -$CellContext`h]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"00000,2\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"d", " ", "f", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`f, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", " ", "i"},
                 {"e", " ", "h", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`e, $CellContext`h, \
-$CellContext`h, $CellContext`i],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "j", " ", " "},
                 {"g", " ", "i", "j"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`g, $CellContext`j, \
-$CellContext`i, -$CellContext`j],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`f, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`e, \
$CellContext`h, -$CellContext`h, $CellContext`i]) \
$CellContext`RiemannCD[-$CellContext`g, $CellContext`j, -$CellContext`i, \
-$CellContext`j]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"00000,8\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"d", " ", "e", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", " ", "i"},
                 {"f", " ", "h", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`h, \
-$CellContext`h, $CellContext`i],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "j", " ", " "},
                 {"g", " ", "i", "j"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`g, $CellContext`j, \
-$CellContext`i, -$CellContext`j],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`f, \
$CellContext`h, -$CellContext`h, $CellContext`i]) \
$CellContext`RiemannCD[-$CellContext`g, $CellContext`j, -$CellContext`i, \
-$CellContext`j]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"00000,33\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", "g", "h"},
                 {"d", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
$CellContext`g, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "i", " ", " "},
                 {"e", " ", "g", "h"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`e, $CellContext`i, \
-$CellContext`g, -$CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "j", " ", " "},
                 {"f", " ", "i", "j"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`j, \
-$CellContext`i, -$CellContext`j],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
$CellContext`g, $CellContext`h]) $CellContext`RiemannCD[-$CellContext`e, \
$CellContext`i, -$CellContext`g, -$CellContext`h]) \
$CellContext`RiemannCD[-$CellContext`f, $CellContext`j, -$CellContext`i, \
-$CellContext`j]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"000000,6\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"c", " ", "f", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`f, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", "i", "j"},
                 {"e", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`e, $CellContext`h, \
$CellContext`i, $CellContext`j],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "k", " ", " "},
                 {"g", " ", "i", "j"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`g, $CellContext`k, \
-$CellContext`i, -$CellContext`j],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "l", " ", " "},
                 {"h", " ", "k", "l"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`h, $CellContext`l, \
-$CellContext`k, -$CellContext`l],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`f, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`e, \
$CellContext`h, $CellContext`i, $CellContext`j]) \
$CellContext`RiemannCD[-$CellContext`g, $CellContext`k, -$CellContext`i, \
-$CellContext`j]) $CellContext`RiemannCD[-$CellContext`h, $CellContext`l, \
-$CellContext`k, -$CellContext`l]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"000000,8\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"d", " ", "e", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", " ", "i"},
                 {"f", " ", "h", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`h, \
-$CellContext`h, $CellContext`i],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "j", " ", "k"},
                 {"g", " ", "j", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`g, $CellContext`j, \
-$CellContext`j, $CellContext`k],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "l", " ", " "},
                 {"i", " ", "k", "l"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`i, $CellContext`l, \
-$CellContext`k, -$CellContext`l],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`f, \
$CellContext`h, -$CellContext`h, $CellContext`i]) \
$CellContext`RiemannCD[-$CellContext`g, $CellContext`j, -$CellContext`j, \
$CellContext`k]) $CellContext`RiemannCD[-$CellContext`i, $CellContext`l, \
-$CellContext`k, -$CellContext`l]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"000000,47\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"c", " ", "e", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", "i", "j"},
                 {"f", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`h, \
$CellContext`i, $CellContext`j],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "k", " ", " "},
                 {"g", " ", "i", "j"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`g, $CellContext`k, \
-$CellContext`i, -$CellContext`j],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "l", " ", " "},
                 {"h", " ", "k", "l"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`h, $CellContext`l, \
-$CellContext`k, -$CellContext`l],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`f, \
$CellContext`h, $CellContext`i, $CellContext`j]) \
$CellContext`RiemannCD[-$CellContext`g, $CellContext`k, -$CellContext`i, \
-$CellContext`j]) $CellContext`RiemannCD[-$CellContext`h, $CellContext`l, \
-$CellContext`k, -$CellContext`l]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"000000,242\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", "g", "h"},
                 {"d", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
$CellContext`g, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "i", " ", " "},
                 {"e", " ", "g", "h"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`e, $CellContext`i, \
-$CellContext`g, -$CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "j", " ", "k"},
                 {"f", " ", "i", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`j, \
-$CellContext`i, $CellContext`k],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "l", " ", " "},
                 {"j", " ", "k", "l"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`j, $CellContext`l, \
-$CellContext`k, -$CellContext`l],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
$CellContext`g, $CellContext`h]) $CellContext`RiemannCD[-$CellContext`e, \
$CellContext`i, -$CellContext`g, -$CellContext`h]) \
$CellContext`RiemannCD[-$CellContext`f, $CellContext`j, -$CellContext`i, \
$CellContext`k]) $CellContext`RiemannCD[-$CellContext`j, $CellContext`l, \
-$CellContext`k, -$CellContext`l]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"0000000,14\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"c", " ", "e", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", " ", "i"},
                 {"f", " ", "g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`h, \
-$CellContext`g, $CellContext`i],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "j", " ", "k"},
                 {"h", " ", "j", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`h, $CellContext`j, \
-$CellContext`j, $CellContext`k],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "l", " ", "m"},
                 {"i", " ", "l", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`i, $CellContext`l, \
-$CellContext`l, $CellContext`m],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "n", " ", " "},
                 {"k", " ", "m", "n"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`k, $CellContext`n, \
-$CellContext`m, -$CellContext`n],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[((((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`f, \
$CellContext`h, -$CellContext`g, $CellContext`i]) \
$CellContext`RiemannCD[-$CellContext`h, $CellContext`j, -$CellContext`j, \
$CellContext`k]) $CellContext`RiemannCD[-$CellContext`i, $CellContext`l, \
-$CellContext`l, $CellContext`m]) $CellContext`RiemannCD[-$CellContext`k, \
$CellContext`n, -$CellContext`m, -$CellContext`n]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"0000000,55\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"c", " ", "f", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`f, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", " ", "i"},
                 {"e", " ", "g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`e, $CellContext`h, \
-$CellContext`g, $CellContext`i],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "j", "k", "l"},
                 {"h", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`h, $CellContext`j, \
$CellContext`k, $CellContext`l],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "m", " ", " "},
                 {"i", " ", "k", "l"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`i, $CellContext`m, \
-$CellContext`k, -$CellContext`l],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "n", " ", " "},
                 {"j", " ", "m", "n"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`j, $CellContext`n, \
-$CellContext`m, -$CellContext`n],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[((((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`f, $CellContext`g]) $CellContext`RiemannCD[-$CellContext`e, \
$CellContext`h, -$CellContext`g, $CellContext`i]) \
$CellContext`RiemannCD[-$CellContext`h, $CellContext`j, $CellContext`k, \
$CellContext`l]) $CellContext`RiemannCD[-$CellContext`i, $CellContext`m, \
-$CellContext`k, -$CellContext`l]) $CellContext`RiemannCD[-$CellContext`j, \
$CellContext`n, -$CellContext`m, -$CellContext`n]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"0000000,391\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", "g", "h"},
                 {"d", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
$CellContext`g, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "i", " ", " "},
                 {"e", " ", "g", "h"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`e, $CellContext`i, \
-$CellContext`g, -$CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "j", " ", "k"},
                 {"f", " ", "i", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`j, \
-$CellContext`i, $CellContext`k],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "l", " ", "m"},
                 {"j", " ", "l", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`j, $CellContext`l, \
-$CellContext`l, $CellContext`m],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "n", " ", " "},
                 {"k", " ", "m", "n"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`k, $CellContext`n, \
-$CellContext`m, -$CellContext`n],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[((((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
$CellContext`g, $CellContext`h]) $CellContext`RiemannCD[-$CellContext`e, \
$CellContext`i, -$CellContext`g, -$CellContext`h]) \
$CellContext`RiemannCD[-$CellContext`f, $CellContext`j, -$CellContext`i, \
$CellContext`k]) $CellContext`RiemannCD[-$CellContext`j, $CellContext`l, \
-$CellContext`l, $CellContext`m]) $CellContext`RiemannCD[-$CellContext`k, \
$CellContext`n, -$CellContext`m, -$CellContext`n]],
      Editable->False]},
    {
     SubscriptBox["\<\"D\"\>", "\<\"00,2\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " ", " ", " "},
                 {"c", "d", "e", "f"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`epsilonmetric[-$CellContext`c, -$CellContext`d, \
-$CellContext`e, -$CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", "e", "f"},
                 {"a", "b", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", "c", "d"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`epsilonmetric[-$CellContext`c, \
-$CellContext`d, -$CellContext`e, -$CellContext`f] \
$CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, $CellContext`e, \
$CellContext`f]) $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]],
      Editable->False]},
    {
     SubscriptBox["\<\"D\"\>", "\<\"000,2\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " ", " ", " "},
                 {"c", "e", "f", "h"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`epsilonmetric[-$CellContext`c, -$CellContext`e, \
-$CellContext`f, -$CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", "e", "f"},
                 {"b", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "g", " ", "h"},
                 {"d", " ", "g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`g, \
-$CellContext`g, $CellContext`h],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(($CellContext`epsilonmetric[-$CellContext`c, \
-$CellContext`e, -$CellContext`f, -$CellContext`h] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
$CellContext`c]) $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f]) $CellContext`RiemannCD[-$CellContext`d, \
$CellContext`g, -$CellContext`g, $CellContext`h]],
      Editable->False]},
    {
     SubscriptBox["\<\"D\"\>", "\<\"000,13\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " ", " ", " "},
                 {"e", "f", "g", "h"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`epsilonmetric[-$CellContext`e, -$CellContext`f, \
-$CellContext`g, -$CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", "e", "f"},
                 {"a", "b", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", "c", "d"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", "g", "h"},
                 {"c", "d", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
$CellContext`g, $CellContext`h],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(($CellContext`epsilonmetric[-$CellContext`e, \
-$CellContext`f, -$CellContext`g, -$CellContext`h] \
$CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, $CellContext`e, \
$CellContext`f]) $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]) $CellContext`RiemannCD[-$CellContext`c, \
-$CellContext`d, $CellContext`g, $CellContext`h]],
      Editable->False]},
    {
     SubscriptBox["\<\"D\"\>", "\<\"0000,7\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " ", " ", " "},
                 {"e", "g", "h", "j"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`epsilonmetric[-$CellContext`e, -$CellContext`g, \
-$CellContext`h, -$CellContext`j],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", "g", "h"},
                 {"d", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
$CellContext`g, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "i", " ", "j"},
                 {"f", " ", "i", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`i, \
-$CellContext`i, $CellContext`j],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[((($CellContext`epsilonmetric[-$CellContext`e, \
-$CellContext`g, -$CellContext`h, -$CellContext`j] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
$CellContext`c]) $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, \
$CellContext`f, $CellContext`g, $CellContext`h]) \
$CellContext`RiemannCD[-$CellContext`f, $CellContext`i, -$CellContext`i, \
$CellContext`j]],
      Editable->False]},
    {
     SubscriptBox["\<\"D\"\>", "\<\"00000,2\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " ", " ", " "},
                 {"g", "i", "j", "l"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`epsilonmetric[-$CellContext`g, -$CellContext`i, \
-$CellContext`j, -$CellContext`l],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"c", " ", "f", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`f, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", "i", "j"},
                 {"e", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`e, $CellContext`h, \
$CellContext`i, $CellContext`j],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "k", " ", "l"},
                 {"h", " ", "k", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`h, $CellContext`k, \
-$CellContext`k, $CellContext`l],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(((($CellContext`epsilonmetric[-$CellContext`g, \
-$CellContext`i, -$CellContext`j, -$CellContext`l] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
$CellContext`c]) $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e]) $CellContext`RiemannCD[-$CellContext`c, \
$CellContext`f, -$CellContext`f, $CellContext`g]) \
$CellContext`RiemannCD[-$CellContext`e, $CellContext`h, $CellContext`i, \
$CellContext`j]) $CellContext`RiemannCD[-$CellContext`h, $CellContext`k, \
-$CellContext`k, $CellContext`l]],
      Editable->False]},
    {
     SubscriptBox["\<\"D\"\>", "\<\"00000,76\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " ", " ", " "},
                 {"g", "i", "j", "l"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`epsilonmetric[-$CellContext`g, -$CellContext`i, \
-$CellContext`j, -$CellContext`l],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", "g"},
                 {"d", " ", "e", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "h", "i", "j"},
                 {"f", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`f, $CellContext`h, \
$CellContext`i, $CellContext`j],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "k", " ", "l"},
                 {"h", " ", "k", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`h, $CellContext`k, \
-$CellContext`k, $CellContext`l],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[(((($CellContext`epsilonmetric[-$CellContext`g, \
-$CellContext`i, -$CellContext`j, -$CellContext`l] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
$CellContext`c]) $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e]) $CellContext`RiemannCD[-$CellContext`d, \
$CellContext`f, -$CellContext`e, $CellContext`g]) \
$CellContext`RiemannCD[-$CellContext`f, $CellContext`h, $CellContext`i, \
$CellContext`j]) $CellContext`RiemannCD[-$CellContext`h, $CellContext`k, \
-$CellContext`k, $CellContext`l]],
      Editable->False]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[68]//TableForm=",ExpressionUUID->"937d3b23-5c5e-40b1-beb1-\
f8ce38ebaf6a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["4. Inv -> Permutation -> Riemann",
 FontSize->14]], "SubsectionIcon",ExpressionUUID->"cd32bcf9-2d98-4231-bcf9-\
5a6ea92c66ca"],

Cell[TextData[{
 StyleBox["InvToPerm\t\t\t", "DisplayMath"],
 StyleBox["Conversion form invariants (RInv) to permutations (RPerm)", "Text"],
 StyleBox["\nPermToRiemann\t\t", "DisplayMath"],
 StyleBox["Conversion from permutations (RPerm) to Riemann tensor expressions\
\n", "Text"],
 StyleBox["InvToRiemann\t\t", "DisplayMath"],
 StyleBox["Direct conversion from invariants (RInv) to Riemann tensor \
expressions", "Text"]
}], "DefinitionBox",ExpressionUUID->"4b073743-ae5a-4780-ae68-7ed8b4e8f47c"],

Cell["From invariants to Riemann expressions.", "SmallText",ExpressionUUID->"ede56685-06d8-45bb-9dd6-416319e9c239"],

Cell[CellGroupData[{

Cell["4.1. InvToPerm", "SubsubsectionIcon",ExpressionUUID->"cd18b10e-6b59-4e51-818a-909d662906ee"],

Cell[TextData[{
 "Given an invariant, it is possible to know the permutation it represents \
using ",
 StyleBox["InvToPerm",
  FontFamily->"Courier New"],
 ". The result is returned using the head ",
 StyleBox["RPerm",
  FontFamily->"Courier New"],
 ", which stands for permutation of Riemann invariant. "
}], "Text",ExpressionUUID->"2e0d7830-a6db-42e4-9a10-56e72edf8dbf"],

Cell["This is a typical example of a canonical invariant:", "MathCaption",ExpressionUUID->"db1433ee-054c-4a2c-91f5-b5e97cc18444"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rinv", "=", 
  RowBox[{"7", 
   RowBox[{
    RowBox[{"RInv", "[", "metric", "]"}], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "4"}], "}"}], ",", "100"}], "]"}]}]}]], "Input",
 CellLabel->"In[69]:=",ExpressionUUID->"1caf9b6c-d940-4218-a5fd-9dff34a579d0"],

Cell[BoxData[
 RowBox[{"7", " ", 
  SubscriptBox["\<\"I\"\>", "\<\"04,100\"\>"]}]], "Output",
 CellLabel->"Out[69]=",ExpressionUUID->"acc5a616-ef7d-4aa0-8921-bfe121b2522f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dualrinv", "=", 
  RowBox[{"3", 
   RowBox[{
    RowBox[{"DualRInv", "[", "metric", "]"}], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", "1"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[70]:=",ExpressionUUID->"dc9828f7-6b49-44c1-adf8-d8e252494fbd"],

Cell[BoxData[
 RowBox[{"3", " ", 
  SubscriptBox["\<\"D\"\>", "\<\"002,1\"\>"]}]], "Output",
 CellLabel->"Out[70]=",ExpressionUUID->"52e4a467-b1a9-4bde-b101-7e830da4f529"]
}, Open  ]],

Cell["\<\
And this is the permutation it represents. It is given in cyclic form. The \
first list identifies the case and whether it contains an epsilon ({case, 1}) \
or not ({case, 0})\
\>", "MathCaption",ExpressionUUID->"b4292b0f-430b-4360-b2b0-384dd461bbf4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rperm", "=", 
  RowBox[{"InvToPerm", "[", "rinv", "]"}]}]], "Input",
 CellLabel->"In[71]:=",ExpressionUUID->"e10833e6-063c-4368-ba92-a50ea81a2ea9"],

Cell[BoxData[
 RowBox[{"7", " ", 
  RowBox[{
   RowBox[{"RPerm", "[", "metric", "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], ",", "0"}], "}"}], ",", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{"(", "2", ",", "3", ",", "5", ")"}], 
       RowBox[{"(", "4", ",", "7", ",", "9", ",", "10", ",", "6", ")"}], 
       RowBox[{"(", "8", ",", "11", ")"}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPerm`Cycles[{2, 3, 5}, {4, 7, 9, 10, 6}, {8, 11}],
     Editable->False]}], "]"}]}]], "Output",
 CellLabel->"Out[71]=",ExpressionUUID->"f663e72f-de44-45f4-8bc9-d6500155b3cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dperm", "=", 
  RowBox[{"InvToPerm", "[", "dualrinv", "]"}]}]], "Input",
 CellLabel->"In[72]:=",ExpressionUUID->"76a8bd98-b885-4ba5-9a16-32af3558f032"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0, 2}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[72]:=",ExpressionUUID->"85a2fa4d-f9cd-478c-8af8-bc9b6620c51a"],

Cell[BoxData[
 RowBox[{"3", " ", 
  RowBox[{
   RowBox[{"RPerm", "[", "metric", "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{"(", "2", ",", "3", ")"}], 
       RowBox[{"(", "4", ",", "5", ")"}], 
       RowBox[{"(", "6", ",", "7", ",", "8", ",", "9", ")"}], 
       RowBox[{"(", "10", ",", "11", ",", "12", ",", "13", ",", "15", ")"}], 
       RowBox[{"(", "14", ",", "17", ",", "16", ")"}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPerm`Cycles[{2, 3}, {4, 5}, {6, 7, 8, 9}, {10, 11, 12, 13, 15}, {
      14, 17, 16}],
     Editable->False]}], "]"}]}]], "Output",
 CellLabel->"Out[72]=",ExpressionUUID->"aa5c8f1d-5db7-4d6f-b875-8aa2b54e760d"]
}, Open  ]],

Cell["\<\
The command also works with polynomials, giving one RPerm for each monomial\
\>", "MathCaption",ExpressionUUID->"b42c9227-9e9f-441d-b816-965328c5d48a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvToPerm", "[", 
  RowBox[{"rinv", "+", "dualrinv"}], "]"}]], "Input",
 CellLabel->"In[73]:=",ExpressionUUID->"c783eb66-25a9-4261-9f1b-b2a31ad590fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"7", " ", 
   RowBox[{
    RowBox[{"RPerm", "[", "metric", "]"}], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "4"}], "}"}], ",", "0"}], "}"}], ",", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"(", "2", ",", "3", ",", "5", ")"}], 
        RowBox[{"(", "4", ",", "7", ",", "9", ",", "10", ",", "6", ")"}], 
        RowBox[{"(", "8", ",", "11", ")"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xPerm`Cycles[{2, 3, 5}, {4, 7, 9, 10, 6}, {8, 11}],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{
    RowBox[{"RPerm", "[", "metric", "]"}], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"(", "2", ",", "3", ")"}], 
        RowBox[{"(", "4", ",", "5", ")"}], 
        RowBox[{"(", "6", ",", "7", ",", "8", ",", "9", ")"}], 
        RowBox[{"(", "10", ",", "11", ",", "12", ",", "13", ",", "15", ")"}], 
        
        RowBox[{"(", "14", ",", "17", ",", "16", ")"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xPerm`Cycles[{2, 3}, {4, 5}, {6, 7, 8, 9}, {10, 11, 12, 13, 15}, {
       14, 17, 16}],
      Editable->False]}], "]"}]}]}]], "Output",
 CellLabel->"Out[73]=",ExpressionUUID->"acdcdcb7-4ce3-439c-b1ec-dec9dce70192"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.2. PermToRiemann", "SubsubsectionIcon",ExpressionUUID->"221b6d24-69f1-460f-ab7f-cda0e8998f74"],

Cell[TextData[{
 "Any permutation of ",
 StyleBox["N",
  FontSlant->"Italic"],
 " indices can be converted into a Riemann monomial of the appropiate case \
with the function ",
 StyleBox["PermToRiemann",
  FontFamily->"Courier New"],
 ". There is a second argument to specify whether we want the contracted \
Riemann tensors to be automatically transformed into Ricci or not."
}], "Text",ExpressionUUID->"e4e47de7-830f-4903-937b-e1d0fb751818"],

Cell["\<\
The default value of the argument for conversion into Ricci is stored in the \
global variable\
\>", "MathCaption",ExpressionUUID->"098c40fe-ac01-4ac6-95fd-e72f7142deb6"],

Cell[CellGroupData[{

Cell[BoxData["$CurvatureRelations"], "Input",
 CellLabel->"In[74]:=",ExpressionUUID->"9888265a-47e2-4528-87a6-ba98898f0130"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[74]=",ExpressionUUID->"651714c3-8e4a-45f8-9e17-4681003aa270"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rinv2", " ", "=", " ", 
  RowBox[{
   RowBox[{"RInv", "[", "metric", "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], " "}]], "Input",
 CellLabel->"In[75]:=",ExpressionUUID->"1628f9be-f0f5-4950-976b-6acb09e7c203"],

Cell[BoxData[
 SubscriptBox["\<\"I\"\>", "\<\"00,1\"\>"]], "Output",
 CellLabel->"Out[75]=",ExpressionUUID->"705266c6-8918-4121-92d9-774aa9a967df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rperm2", "=", 
  RowBox[{"InvToPerm", "[", "rinv2", "]"}]}]], "Input",
 CellLabel->"In[76]:=",ExpressionUUID->"6e761725-7f1f-4347-8841-58bf771b2cc9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RPerm", "[", "metric", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "0"}], "}"}], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      RowBox[{"(", "2", ",", "3", ")"}], 
      RowBox[{"(", "4", ",", "5", ")"}], 
      RowBox[{"(", "6", ",", "7", ")"}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPerm`Cycles[{2, 3}, {4, 5}, {6, 7}],
    Editable->False]}], "]"}]], "Output",
 CellLabel->"Out[76]=",ExpressionUUID->"d615048d-0f41-474f-81ea-4746f284bb65"]
}, Open  ]],

Cell["\<\
If we set that variable to True, we get a product of Ricci tensors:\
\>", "MathCaption",ExpressionUUID->"85d4f879-3f2d-4995-b1bd-d88f16d36cca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermToRiemann", "[", 
  RowBox[{"rperm2", ",", "True"}], "]"}]], "Input",
 CellLabel->"In[77]:=",ExpressionUUID->"cb17a0fd-d192-40ed-998e-99dad485f62a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["(",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciCD[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciCD[$CellContext`a, $CellContext`b],
      Editable->False]}], 
    StyleBox[")",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Scalar[$CellContext`RicciCD[-$CellContext`a, -$CellContext`b] \
$CellContext`RicciCD[$CellContext`a, $CellContext`b]],
  Editable->False]], "Output",
 CellLabel->"Out[77]=",ExpressionUUID->"48ffc1de-96c3-4ea2-84da-749f42d2767e"]
}, Open  ]],

Cell["\<\
If we set that argument to False or use the default, no Riccis appear\
\>", "MathCaption",ExpressionUUID->"895bd6ed-da3d-428d-9a18-211d96cdac00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermToRiemann", "[", 
  RowBox[{"rperm2", ",", "False"}], "]"}]], "Input",
 CellLabel->"In[78]:=",ExpressionUUID->"83baec37-b7fc-4519-9562-bbeb6aaff1f0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["(",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {"a", "b", " ", "c"},
             {" ", " ", "a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {" ", "d", " ", " "},
             {"b", " ", "c", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
      Editable->False]}], 
    StyleBox[")",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c] $CellContext`RiemannCD[-$CellContext`b, \
$CellContext`d, -$CellContext`c, -$CellContext`d]],
  Editable->False]], "Output",
 CellLabel->"Out[78]=",ExpressionUUID->"e7091671-647a-4294-8270-717d5f330413"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermToRiemann", "[", "rperm2", "]"}]], "Input",
 CellLabel->"In[79]:=",ExpressionUUID->"39ddd1d2-739d-4668-84fe-409543b17524"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["(",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {"a", "b", " ", "c"},
             {" ", " ", "a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {" ", "d", " ", " "},
             {"b", " ", "c", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, -$CellContext`d],
      Editable->False]}], 
    StyleBox[")",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Scalar[$CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c] $CellContext`RiemannCD[-$CellContext`b, \
$CellContext`d, -$CellContext`c, -$CellContext`d]],
  Editable->False]], "Output",
 CellLabel->"Out[79]=",ExpressionUUID->"93e59e7d-aaf9-4553-ad62-7aae7059a8d4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.3. InvToRiemann", "SubsubsectionIcon",ExpressionUUID->"7c1ef214-0c1b-4cf2-822b-cc15d1e18598"],

Cell["\<\
There is a simple function which combines the action of the previous two. It \
also has a second argument:\
\>", "Text",ExpressionUUID->"50014ad5-f60c-44b1-a0e3-a2a0d476d305"],

Cell["In a single line:", "MathCaption",ExpressionUUID->"b232b250-1ec2-4bd1-9fd9-5997b72d910d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvToRiemann", "[", 
  RowBox[{
   RowBox[{"RInv", "[", "metric", "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}],
     ",", "1000"}], "]"}], "]"}]], "Input",
 CellLabel->"In[80]:=",ExpressionUUID->"6b560878-b8ca-4b09-a192-348dd570cd02"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["(",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {"a", "b", " ", "c"},
             {" ", " ", "a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, -$CellContext`a, \
$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {" ", "d", "e", "f"},
             {"b", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {" ", " ", "g", "h"},
             {"c", "d", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
$CellContext`g, $CellContext`h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {" ", " ", "i", "j"},
             {"e", "g", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[-$CellContext`e, -$CellContext`g, \
$CellContext`i, $CellContext`j],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {" ", "k", " ", "l"},
             {"f", " ", "i", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[-$CellContext`f, $CellContext`k, \
-$CellContext`i, $CellContext`l],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {" ", "m", " ", " "},
             {"h", " ", "l", "m"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[-$CellContext`h, $CellContext`m, \
-$CellContext`l, -$CellContext`m],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"R", 
          StyleBox[GridBox[{
             {" ", "n", " ", " "},
             {"j", " ", "k", "n"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[-$CellContext`j, $CellContext`n, \
-$CellContext`k, -$CellContext`n],
      Editable->False]}], 
    StyleBox[")",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Scalar[((((($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]) $CellContext`RiemannCD[-$CellContext`c, -$CellContext`d, \
$CellContext`g, $CellContext`h]) $CellContext`RiemannCD[-$CellContext`e, \
-$CellContext`g, $CellContext`i, $CellContext`j]) \
$CellContext`RiemannCD[-$CellContext`f, $CellContext`k, -$CellContext`i, \
$CellContext`l]) $CellContext`RiemannCD[-$CellContext`h, $CellContext`m, \
-$CellContext`l, -$CellContext`m]) $CellContext`RiemannCD[-$CellContext`j, \
$CellContext`n, -$CellContext`k, -$CellContext`n]],
  Editable->False]], "Output",
 CellLabel->"Out[80]=",ExpressionUUID->"887dc769-ab0b-4461-b576-b495cfb47769"]
}, Open  ]],

Cell["It is possible to give a list of invariants:", "MathCaption",ExpressionUUID->"623c1883-78b7-4548-aef6-ad8e4ed69f4d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", "metric", "]"}], "[", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[81]:=",ExpressionUUID->"03b2b489-de77-4bb0-80fd-18ccddcdf7df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"002,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,5\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,6\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,7\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,14\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,41\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,52\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,55\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[81]=",ExpressionUUID->"23679ccf-6896-46b9-a9c8-d1e57a96c0a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"InvToRiemann", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[82]:=",ExpressionUUID->"b518216f-6c34-4235-a1e3-f61015351e79"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "c"}], 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`CD[-$CellContext`c][
          $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`CD[-$CellContext`e][
       $CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "f", " ", " ", 
                RowBox[{";", "g"}], "  "},
               {"c", " ", "e", "f", "  ", 
                RowBox[{";", "g"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`g][
         $CellContext`CD[$CellContext`g][
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`CD[-$CellContext`g][
       $CellContext`CD[$CellContext`g][
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", "f"},
               {" ", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  ", "  "},
               {"b", " ", "c", "g", 
                RowBox[{";", "e"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`c, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[$CellContext`d, $CellContext`e, -$CellContext`d, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`c, -$CellContext`g]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", " ", "f"},
               {" ", " ", "d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  ", "  "},
               {"b", " ", "e", "g", 
                RowBox[{";", "c"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`c][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[$CellContext`d, $CellContext`e, -$CellContext`d, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`c][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"f", "g", " ", " ", "  ", "  "},
               {" ", " ", "f", "g", 
                RowBox[{";", "d"}], 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`CD[-$CellContext`e][
       $CellContext`CD[-$CellContext`d][
        $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", " ", "e"},
               {"b", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "f", " ", " ", 
                RowBox[{";", "g"}], "  "},
               {"d", " ", "e", "f", "  ", 
                RowBox[{";", "g"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`g][
         $CellContext`CD[$CellContext`g][
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`CD[-$CellContext`g][
       $CellContext`CD[$CellContext`g][
        $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "d", "e", "f"},
               {"b", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  ", "  "},
               {"c", " ", "e", "g", 
                RowBox[{";", "d"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`d][
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", " ", "c"},
               {" ", " ", "a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"d", "e", "f", "g"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", " ", " ", "  ", "  "},
               {"b", "d", "c", "f", 
                RowBox[{";", "e"}], 
                RowBox[{";", "g"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`g][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, -$CellContext`d, \
-$CellContext`c, -$CellContext`f]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`g]) $CellContext`CD[-$CellContext`g][
       $CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`b, -$CellContext`d, \
-$CellContext`c, -$CellContext`f]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", "e", "f"},
               {"a", "b", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  ", "  "},
               {"c", " ", "e", "g", 
                RowBox[{";", "d"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, $CellContext`e, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`d][
        $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", "f"},
               {"a", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "g", " ", " ", "  ", "  "},
               {"b", " ", "d", "g", 
                RowBox[{";", "e"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
$CellContext`e, -$CellContext`c, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`e][
        $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]]],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[82]=",ExpressionUUID->"4dc40522-f891-464e-a9fd-d6cc7bfafd14"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"%%", ",", "%"}], "}"}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[83]:=",ExpressionUUID->"c85e8a42-5b59-4777-abb6-707e43ebb8ac"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,1\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"f", "g", " ", " ", "  ", "  "},
                 {" ", " ", "f", "g", 
                  RowBox[{";", "c"}], 
                  RowBox[{";", "e"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`e][
           $CellContext`CD[-$CellContext`c][
            $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`CD[-$CellContext`e][
         $CellContext`CD[-$CellContext`c][
          $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,2\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`d, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", " ", 
                  RowBox[{";", "g"}], "  "},
                 {"c", " ", "e", "f", "  ", 
                  RowBox[{";", "g"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`g][
           $CellContext`CD[$CellContext`g][
            $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`d, \
$CellContext`e]) $CellContext`CD[-$CellContext`g][
         $CellContext`CD[$CellContext`g][
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`f, \
-$CellContext`e, -$CellContext`f]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,5\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"d", "e", " ", "f"},
                 {" ", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "g", " ", " ", "  ", "  "},
                 {"b", " ", "c", "g", 
                  RowBox[{";", "e"}], 
                  RowBox[{";", "f"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`f][
           $CellContext`CD[-$CellContext`e][
            $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`c, -$CellContext`g]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[$CellContext`d, $CellContext`e, -$CellContext`d, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`c, -$CellContext`g]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,6\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"d", "e", " ", "f"},
                 {" ", " ", "d", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
-$CellContext`d, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "g", " ", " ", "  ", "  "},
                 {"b", " ", "e", "g", 
                  RowBox[{";", "c"}], 
                  RowBox[{";", "f"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`f][
           $CellContext`CD[-$CellContext`c][
            $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[$CellContext`d, $CellContext`e, -$CellContext`d, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`c][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,7\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"f", "g", " ", " ", "  ", "  "},
                 {" ", " ", "f", "g", 
                  RowBox[{";", "d"}], 
                  RowBox[{";", "e"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`e][
           $CellContext`CD[-$CellContext`d][
            $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`CD[-$CellContext`e][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RiemannCD[$CellContext`f, $CellContext`g, \
-$CellContext`f, -$CellContext`g]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,8\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", " ", "e"},
                 {"b", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
-$CellContext`c, $CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "f", " ", " ", 
                  RowBox[{";", "g"}], "  "},
                 {"d", " ", "e", "f", "  ", 
                  RowBox[{";", "g"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`g][
           $CellContext`CD[$CellContext`g][
            $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, -$CellContext`c, \
$CellContext`e]) $CellContext`CD[-$CellContext`g][
         $CellContext`CD[$CellContext`g][
          $CellContext`RiemannCD[-$CellContext`d, $CellContext`f, \
-$CellContext`e, -$CellContext`f]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,14\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "d", "e", "f"},
                 {"b", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "g", " ", " ", "  ", "  "},
                 {"c", " ", "e", "g", 
                  RowBox[{";", "d"}], 
                  RowBox[{";", "f"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`f][
           $CellContext`CD[-$CellContext`d][
            $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[-$CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f]) $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,41\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", " ", "c"},
                 {" ", " ", "a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
-$CellContext`a, $CellContext`c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"d", "e", "f", "g"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", " ", " ", "  ", "  "},
                 {"b", "d", "c", "f", 
                  RowBox[{";", "e"}], 
                  RowBox[{";", "g"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`g][
           $CellContext`CD[-$CellContext`e][
            $CellContext`RiemannCD[-$CellContext`b, -$CellContext`d, \
-$CellContext`c, -$CellContext`f]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[$CellContext`a, \
$CellContext`b, -$CellContext`a, $CellContext`c] \
$CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`g]) $CellContext`CD[-$CellContext`g][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, -$CellContext`d, \
-$CellContext`c, -$CellContext`f]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,52\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", "e", "f"},
                 {"a", "b", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", "c", "d"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "g", " ", " ", "  ", "  "},
                 {"c", " ", "e", "g", 
                  RowBox[{";", "d"}], 
                  RowBox[{";", "f"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`f][
           $CellContext`CD[-$CellContext`d][
            $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, $CellContext`e, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RiemannCD[-$CellContext`c, $CellContext`g, \
-$CellContext`e, -$CellContext`g]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,55\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "e", " ", "f"},
                 {"a", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", "c", "d"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "g", " ", " ", "  ", "  "},
                 {"b", " ", "d", "g", 
                  RowBox[{";", "e"}], 
                  RowBox[{";", "f"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`f][
           $CellContext`CD[-$CellContext`e][
            $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
$CellContext`e, -$CellContext`c, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RiemannCD[-$CellContext`b, $CellContext`g, \
-$CellContext`d, -$CellContext`g]]]],
      Editable->False]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[83]//TableForm=",ExpressionUUID->"28a71baa-a256-4658-a262-\
04dc4aa08d8b"]
}, Open  ]],

Cell["With contracted Riemanns substituted by Riccis,", "MathCaption",ExpressionUUID->"5bfeeb8e-7bed-4475-9249-3524e79c7569"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", "metric", "]"}], "[", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[84]:=",ExpressionUUID->"8a54886e-f5bb-4743-b285-205ac2dfa9f5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\<\"I\"\>", "\<\"002,1\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,2\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,5\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,6\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,7\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,8\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,14\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,41\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,52\"\>"], ",", 
   SubscriptBox["\<\"I\"\>", "\<\"002,55\"\>"]}], "}"}]], "Output",
 CellLabel->"Out[84]=",ExpressionUUID->"143ba22f-4eb4-4aed-8e59-51cf49e19a5a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"InvToRiemann", "[", 
     RowBox[{"#", ",", "True"}], "]"}], "&"}], ",", "%"}], "]"}]], "Input",
 CellLabel->"In[85]:=",ExpressionUUID->"1a8fb739-3553-43c4-808c-df8216d7fcab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", "b"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RicciCD[-$CellContext`a, $CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", " "},
                {" ", "c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RicciCD[$CellContext`a, -$CellContext`c],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[EmptyDownTriangle]", "b"], 
            SuperscriptBox["\[EmptyDownTriangle]", "c"], "R"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`b][
           $CellContext`CD[$CellContext`c][
            $CellContext`RicciScalarCD[]]],
          Editable->False], ")"}]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`a, \
$CellContext`b] $CellContext`RicciCD[$CellContext`a, -$CellContext`c]) \
$CellContext`CD[-$CellContext`b][
        $CellContext`CD[$CellContext`c][
         $CellContext`RicciScalarCD[]]]],
     Editable->False]}], ",", 
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {" ", " "},
                {"a", "c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"a", " "},
                {" ", "d"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RicciCD[$CellContext`a, -$CellContext`d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"R", 
             StyleBox[GridBox[{
                {"d", "c", 
                 RowBox[{";", "b"}], "  "},
                {" ", " ", "  ", 
                 RowBox[{";", "b"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`b][
          $CellContext`CD[$CellContext`b][
           $CellContext`RicciCD[$CellContext`d, $CellContext`c]]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`a, \
-$CellContext`c] $CellContext`RicciCD[$CellContext`a, -$CellContext`d]) \
$CellContext`CD[-$CellContext`b][
        $CellContext`CD[$CellContext`b][
         $CellContext`RicciCD[$CellContext`d, $CellContext`c]]]],
     Editable->False]}], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " "},
               {"b", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciCD[-$CellContext`b, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "a"},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciCD[-$CellContext`c, $CellContext`a],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"b", "d", 
                RowBox[{";", "c"}], "  "},
               {" ", " ", "  ", 
                RowBox[{";", "a"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`a][
         $CellContext`CD[$CellContext`c][
          $CellContext`RicciCD[$CellContext`b, $CellContext`d]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`b, \
-$CellContext`d] $CellContext`RicciCD[-$CellContext`c, $CellContext`a]) \
$CellContext`CD[-$CellContext`a][
       $CellContext`CD[$CellContext`c][
        $CellContext`RicciCD[$CellContext`b, $CellContext`d]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " "},
               {"b", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciCD[-$CellContext`b, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "a"},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciCD[-$CellContext`c, $CellContext`a],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"b", "c", 
                RowBox[{";", "d"}], "  "},
               {" ", " ", "  ", 
                RowBox[{";", "a"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`a][
         $CellContext`CD[$CellContext`d][
          $CellContext`RicciCD[$CellContext`b, $CellContext`c]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`b, \
-$CellContext`d] $CellContext`RicciCD[-$CellContext`c, $CellContext`a]) \
$CellContext`CD[-$CellContext`a][
       $CellContext`CD[$CellContext`d][
        $CellContext`RicciCD[$CellContext`b, $CellContext`c]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciCD[$CellContext`a, $CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "c", " ", "d"},
               {"a", " ", "b", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`c, \
-$CellContext`b, $CellContext`d],
        Editable->False], " ", 
       RowBox[{"(", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[EmptyDownTriangle]", "d"], 
           SubscriptBox["\[EmptyDownTriangle]", "c"], "R"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`d][
          $CellContext`CD[-$CellContext`c][
           $CellContext`RicciScalarCD[]]],
         Editable->False], ")"}]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RicciCD[$CellContext`a, $CellContext`b] \
$CellContext`RiemannCD[-$CellContext`a, $CellContext`c, -$CellContext`b, \
$CellContext`d]) $CellContext`CD[-$CellContext`d][
       $CellContext`CD[-$CellContext`c][
        $CellContext`RicciScalarCD[]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciCD[$CellContext`a, $CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "c", " ", "d"},
               {"a", " ", "b", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`c, \
-$CellContext`b, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", 
                RowBox[{";", "e"}], "  "},
               {"c", "d", "  ", 
                RowBox[{";", "e"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`e][
         $CellContext`CD[$CellContext`e][
          $CellContext`RicciCD[-$CellContext`c, -$CellContext`d]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RicciCD[$CellContext`a, $CellContext`b] \
$CellContext`RiemannCD[-$CellContext`a, $CellContext`c, -$CellContext`b, \
$CellContext`d]) $CellContext`CD[-$CellContext`e][
       $CellContext`CD[$CellContext`e][
        $CellContext`RicciCD[-$CellContext`c, -$CellContext`d]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", " "},
               {" ", "e"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciCD[$CellContext`a, -$CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "b", "c", "d"},
               {"a", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"e", " ", "  ", "  "},
               {" ", "c", 
                RowBox[{";", "b"}], 
                RowBox[{";", "d"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`d][
         $CellContext`CD[-$CellContext`b][
          $CellContext`RicciCD[$CellContext`e, -$CellContext`c]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RicciCD[$CellContext`a, \
-$CellContext`e] $CellContext`RiemannCD[-$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]) $CellContext`CD[-$CellContext`d][
       $CellContext`CD[-$CellContext`b][
        $CellContext`RicciCD[$CellContext`e, -$CellContext`c]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " "},
               {"e", "f"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciCD[-$CellContext`e, -$CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"e", " ", "f", " ", "  ", "  "},
               {" ", "a", " ", "c", 
                RowBox[{";", "b"}], 
                RowBox[{";", "d"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`d][
         $CellContext`CD[-$CellContext`b][
          $CellContext`RiemannCD[$CellContext`e, -$CellContext`a, \
$CellContext`f, -$CellContext`c]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`e, \
-$CellContext`f] $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]) $CellContext`CD[-$CellContext`d][
       $CellContext`CD[-$CellContext`b][
        $CellContext`RiemannCD[$CellContext`e, -$CellContext`a, \
$CellContext`f, -$CellContext`c]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", "e", "f"},
               {"a", "b", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", "  ", "  "},
               {"c", "e", 
                RowBox[{";", "d"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RicciCD[-$CellContext`c, -$CellContext`e]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, $CellContext`e, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`d][
        $CellContext`RicciCD[-$CellContext`c, -$CellContext`e]]]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", "e", " ", "f"},
               {"a", " ", "c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {"a", "b", "c", "d"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " ", "  ", "  "},
               {"b", "d", 
                RowBox[{";", "e"}], 
                RowBox[{";", "f"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`e][
          $CellContext`RicciCD[-$CellContext`b, -$CellContext`d]]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
$CellContext`e, -$CellContext`c, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`CD[-$CellContext`f][
       $CellContext`CD[-$CellContext`e][
        $CellContext`RicciCD[-$CellContext`b, -$CellContext`d]]]],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[85]=",ExpressionUUID->"561377a2-9286-4f9d-977f-53dda35f3e3a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"%%", ",", "%"}], "}"}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[86]:=",ExpressionUUID->"30471668-b767-4545-8227-5bfd1a9d753d"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,1\"\>"], 
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["(",
          FontColor->RGBColor[1, 0, 0]], 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"R", 
               StyleBox[GridBox[{
                  {" ", "b"},
                  {"a", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`RicciCD[-$CellContext`a, $CellContext`b],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"R", 
               StyleBox[GridBox[{
                  {"a", " "},
                  {" ", "c"}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`RicciCD[$CellContext`a, -$CellContext`c],
           Editable->False], " ", 
          RowBox[{"(", 
           InterpretationBox[
            StyleBox[
             RowBox[{
              SubscriptBox["\[EmptyDownTriangle]", "b"], 
              SuperscriptBox["\[EmptyDownTriangle]", "c"], "R"}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`CD[-$CellContext`b][
             $CellContext`CD[$CellContext`c][
              $CellContext`RicciScalarCD[]]],
            Editable->False], ")"}]}], 
         StyleBox[")",
          FontColor->RGBColor[1, 0, 0]]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`a, \
$CellContext`b] $CellContext`RicciCD[$CellContext`a, -$CellContext`c]) \
$CellContext`CD[-$CellContext`b][
          $CellContext`CD[$CellContext`c][
           $CellContext`RicciScalarCD[]]]],
       Editable->False]}]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,2\"\>"], 
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["(",
          FontColor->RGBColor[1, 0, 0]], 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"R", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {"a", "c"}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"R", 
               StyleBox[GridBox[{
                  {"a", " "},
                  {" ", "d"}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`RicciCD[$CellContext`a, -$CellContext`d],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"R", 
               StyleBox[GridBox[{
                  {"d", "c", 
                   RowBox[{";", "b"}], "  "},
                  {" ", " ", "  ", 
                   RowBox[{";", "b"}]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CD[-$CellContext`b][
            $CellContext`CD[$CellContext`b][
             $CellContext`RicciCD[$CellContext`d, $CellContext`c]]],
           Editable->False]}], 
         StyleBox[")",
          FontColor->RGBColor[1, 0, 0]]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`a, \
-$CellContext`c] $CellContext`RicciCD[$CellContext`a, -$CellContext`d]) \
$CellContext`CD[-$CellContext`b][
          $CellContext`CD[$CellContext`b][
           $CellContext`RicciCD[$CellContext`d, $CellContext`c]]]],
       Editable->False]}]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,5\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {"b", "d"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RicciCD[-$CellContext`b, -$CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "a"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RicciCD[-$CellContext`c, $CellContext`a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"b", "d", 
                  RowBox[{";", "c"}], "  "},
                 {" ", " ", "  ", 
                  RowBox[{";", "a"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`a][
           $CellContext`CD[$CellContext`c][
            $CellContext`RicciCD[$CellContext`b, $CellContext`d]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`b, \
-$CellContext`d] $CellContext`RicciCD[-$CellContext`c, $CellContext`a]) \
$CellContext`CD[-$CellContext`a][
         $CellContext`CD[$CellContext`c][
          $CellContext`RicciCD[$CellContext`b, $CellContext`d]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,6\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {"b", "d"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RicciCD[-$CellContext`b, -$CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "a"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RicciCD[-$CellContext`c, $CellContext`a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"b", "c", 
                  RowBox[{";", "d"}], "  "},
                 {" ", " ", "  ", 
                  RowBox[{";", "a"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`a][
           $CellContext`CD[$CellContext`d][
            $CellContext`RicciCD[$CellContext`b, $CellContext`c]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`b, \
-$CellContext`d] $CellContext`RicciCD[-$CellContext`c, $CellContext`a]) \
$CellContext`CD[-$CellContext`a][
         $CellContext`CD[$CellContext`d][
          $CellContext`RicciCD[$CellContext`b, $CellContext`c]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,7\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RicciCD[$CellContext`a, $CellContext`b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "c", " ", "d"},
                 {"a", " ", "b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, $CellContext`c, \
-$CellContext`b, $CellContext`d],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[EmptyDownTriangle]", "d"], 
             SubscriptBox["\[EmptyDownTriangle]", "c"], "R"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CD[-$CellContext`d][
            $CellContext`CD[-$CellContext`c][
             $CellContext`RicciScalarCD[]]],
           Editable->False], ")"}]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RicciCD[$CellContext`a, \
$CellContext`b] $CellContext`RiemannCD[-$CellContext`a, $CellContext`c, \
-$CellContext`b, $CellContext`d]) $CellContext`CD[-$CellContext`d][
         $CellContext`CD[-$CellContext`c][
          $CellContext`RicciScalarCD[]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,8\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RicciCD[$CellContext`a, $CellContext`b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "c", " ", "d"},
                 {"a", " ", "b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, $CellContext`c, \
-$CellContext`b, $CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", 
                  RowBox[{";", "e"}], "  "},
                 {"c", "d", "  ", 
                  RowBox[{";", "e"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`e][
           $CellContext`CD[$CellContext`e][
            $CellContext`RicciCD[-$CellContext`c, -$CellContext`d]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RicciCD[$CellContext`a, \
$CellContext`b] $CellContext`RiemannCD[-$CellContext`a, $CellContext`c, \
-$CellContext`b, $CellContext`d]) $CellContext`CD[-$CellContext`e][
         $CellContext`CD[$CellContext`e][
          $CellContext`RicciCD[-$CellContext`c, -$CellContext`d]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,14\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", " "},
                 {" ", "e"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RicciCD[$CellContext`a, -$CellContext`e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "b", "c", "d"},
                 {"a", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"e", " ", "  ", "  "},
                 {" ", "c", 
                  RowBox[{";", "b"}], 
                  RowBox[{";", "d"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`d][
           $CellContext`CD[-$CellContext`b][
            $CellContext`RicciCD[$CellContext`e, -$CellContext`c]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RicciCD[$CellContext`a, \
-$CellContext`e] $CellContext`RiemannCD[-$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]) $CellContext`CD[-$CellContext`d][
         $CellContext`CD[-$CellContext`b][
          $CellContext`RicciCD[$CellContext`e, -$CellContext`c]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,41\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {"e", "f"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RicciCD[-$CellContext`e, -$CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", "c", "d"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"e", " ", "f", " ", "  ", "  "},
                 {" ", "a", " ", "c", 
                  RowBox[{";", "b"}], 
                  RowBox[{";", "d"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`d][
           $CellContext`CD[-$CellContext`b][
            $CellContext`RiemannCD[$CellContext`e, -$CellContext`a, \
$CellContext`f, -$CellContext`c]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RicciCD[-$CellContext`e, \
-$CellContext`f] $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]) $CellContext`CD[-$CellContext`d][
         $CellContext`CD[-$CellContext`b][
          $CellContext`RiemannCD[$CellContext`e, -$CellContext`a, \
$CellContext`f, -$CellContext`c]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,52\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", "e", "f"},
                 {"a", "b", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, \
$CellContext`e, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", "c", "d"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", "  ", "  "},
                 {"c", "e", 
                  RowBox[{";", "d"}], 
                  RowBox[{";", "f"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`f][
           $CellContext`CD[-$CellContext`d][
            $CellContext`RicciCD[-$CellContext`c, -$CellContext`e]]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[($CellContext`RiemannCD[-$CellContext`a, \
-$CellContext`b, $CellContext`e, $CellContext`f] \
$CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d]) $CellContext`CD[-$CellContext`f][
         $CellContext`CD[-$CellContext`d][
          $CellContext`RicciCD[-$CellContext`c, -$CellContext`e]]]],
      Editable->False]},
    {
     SubscriptBox["\<\"I\"\>", "\<\"002,55\"\>"], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", "e", " ", "f"},
                 {"a", " ", "c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[-$CellContext`a, $CellContext`e, \
-$CellContext`c, $CellContext`f],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {"a", "b", "c", "d"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"R", 
              StyleBox[GridBox[{
                 {" ", " ", "  ", "  "},
                 {"b", "d", 
                  RowBox[{";", "e"}], 
                  RowBox[{";", "f"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
         