(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   5521568,     161906]
NotebookOptionsPosition[   5474154,     160518]
NotebookOutlinePosition[   5474716,     160542]
CellTagsIndexPosition[   5474626,     160537]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["The N.P. and G.H.P. formalisms. ",
 FontColor->RGBColor[1, 0, 0]]], "Title"],

Cell[TextData[{
 StyleBox["An application of ",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Spinors",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[" and ",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["xCoba.",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]]
}], "Subtitle"],

Cell["\<\
Alfonso Garc\[IAcute]a-Parrado G\[OAcute]mez-Lobo
Universidade do Minho, Portugal
September 2009\
\>", "Subsubtitle"],

Cell["\<\
In this notebook we derive all the equations of the Newman-Penrose formalism \
from scratch, by using spinor calculus. We use the equations obtained to \
introduce the essentials of the GHP formalism (GHP operators, weighted \
quantities, etc) and then we obtain the set of GHP equations. This notebook \
can be used as starting point for any computation involving the N.P. and \
G.H.P. formalisms.\
\>", "Text",
 TextJustification->1.],

Cell["\<\
For a quick start, execute sections 1, 2 and 3 and then proceed to section 4 \
where the essential explanations about how to use this notebook are provided. \
\>", "Text",
 TextJustification->1.],

Cell[CellGroupData[{

Cell["1. Spin structure on the spacetime manifold ", "Subsection"],

Cell[TextData[{
 "We start by loading  ",
 StyleBox["Spinors`", "Output"],
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`Spinors`"}]], "Input"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2013", ",", "7", ",", "1"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.1", ", ", {2013, 7, 1}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CopyRight (C) 2003-2013, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2013", ",", "7", ",", "1"}], "}"}]}],
  SequenceForm["Package xAct`xTensor`  version ", "1.1.0", ", ", {2013, 7, 1}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CopyRight (C) 2002-2013, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Spinors`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2013", ",", "7", ",", "1"}], "}"}]}],
  SequenceForm["Package xAct`Spinors`  version ", "1.0.5", ", ", {2013, 7, 1}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CopyRight (C) 2006-2012, Alfonso Garcia-Parrado Gomez-Lobo \
and Jose M. Martin-Garcia, under the General Public License.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"]
}, Open  ]],

Cell[TextData[{
 "Definition of a four dimensional  manifold ",
 StyleBox["M4",
  FontFamily->"Courier"],
 ":"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M4", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p", ",", "q", ",", "r",
      ",", "m", ",", "l", ",", "h", ",", "j", ",", "n", ",", "t", ",", "s"}], 
    "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M4, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM4, ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[TextData[{
 "Definition of a Lorentzian metric on the manifold ",
 StyleBox["M4",
  FontFamily->"Courier"],
 ":"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print"]
}, Open  ]],

Cell[TextData[{
 "We define a spin structure comprising the complex vector bundle ",
 StyleBox["Spin", "Input",
  FontWeight->"Plain"],
 " whose abstract indices are ",
 StyleBox["{A, B, C, D, F, H, L, P, Q}", "Input",
  FontWeight->"Plain"],
 StyleBox[".", "Input"],
 " We need to supply as arguments the name of the metric tensor of the \
background Lorentzian manifold",
 StyleBox[" ", "Input"],
 StyleBox["g[-a,-b]", "Input",
  FontWeight->"Plain"],
 ", the name of the antisymmetric spin metric",
 StyleBox[" ", "Input"],
 StyleBox["\[Epsilon][-A,-B]", "Input",
  FontWeight->"Plain"],
 StyleBox[",", "Input"],
 " the name of the soldering form ",
 StyleBox["\[Sigma][a,-A,-A\[Dagger]]", "Input",
  FontWeight->"Plain"],
 " and the name of the spin covariant derivative ",
 StyleBox["CDe[-a].", "Input",
  FontWeight->"Plain"],
 "The option ",
 StyleBox["SpinorPrefix", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["is used to introduce a tag which will be  prepended automatically \
to  any spinor related to a spacetime tensor and t", "Text",
  FontWeight->"Plain"],
 "he option ",
 StyleBox["SpinorMark", "Input",
  FontWeight->"Plain"],
 StyleBox[" introduces a formatting of the tag ", "Text",
  FontWeight->"Plain"],
 StyleBox["SP", "Input",
  FontWeight->"Plain"],
 StyleBox[" different to the default one. The long output of ", "Text",
  FontWeight->"Plain"],
 StyleBox["DefSpinStructure", "Input",
  FontWeight->"Plain"],
 StyleBox[" can be suppressed  by adding the option ", "Text",
  FontWeight->"Plain"],
 StyleBox["Info->False", "Text",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 StyleBox[" which deactivates the information of the definition commands .", 
  "Text",
  FontWeight->"Plain"]
}], "Text",
 TextJustification->1.],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{
    "A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "H", ",", "L", ",", "P",
      ",", "Q"}], "}"}], ",", "\[Epsilon]", ",", "\[Sigma]", ",", "CDe", ",", 
   
   RowBox[{"SpinorPrefix", "->", "SP"}], ",", 
   RowBox[{"SpinorMark", "->", "\"\<S\>\""}], ",", 
   RowBox[{"Info", "->", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "Spin", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`Spin, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"System name \[NoBreak]\\!\\(\\\"C\\\"\\)\[NoBreak] is \
overloaded as an abstract index.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"System name \[NoBreak]\\!\\(\\\"D\\\"\\)\[NoBreak] is \
overloaded as an abstract index.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "Spin\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between Spin and \
Spin\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`Spin\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between Spin and Spin\[Dagger]"],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Sigma][$CellContext`a, -C, -$CellContext`D\[Dagger]], ". ", 
   ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[Dagger]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Sigma]\[Dagger][$CellContext`a, -$CellContext`C\[Dagger], -
    D], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[Sigma]", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[Sigma][$CellContext`a, $CellContext`b, \
-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[Sigma]\[Dagger]", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[Sigma]\[Dagger][$CellContext`a, $CellContext`b, \
-$CellContext`A\[Dagger], -$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]g", "[", 
    RowBox[{"A", ",", "C\[Dagger]", ",", "B", ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]g[$CellContext`A, $CellContext`C\[Dagger], \
$CellContext`B, $CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]g\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "C", ",", "B\[Dagger]", ",", "D"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]g\[Dagger][$CellContext`A\[Dagger], 
    C, $CellContext`B\[Dagger], D], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]epsilong", "[", 
    RowBox[{
    "A", ",", "A\[Dagger]", ",", "B", ",", "B\[Dagger]", ",", "C", ",", 
     "C\[Dagger]", ",", "D", ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]epsilong[$CellContext`A, $CellContext`A\
\[Dagger], $CellContext`B, $CellContext`B\[Dagger], 
    C, $CellContext`C\[Dagger], D, $CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]epsilong\[Dagger]", "[", 
    RowBox[{
    "A\[Dagger]", ",", "A", ",", "B\[Dagger]", ",", "B", ",", "C\[Dagger]", 
     ",", "C", ",", "D\[Dagger]", ",", "D"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]epsilong\[Dagger][$CellContext`A\[Dagger], \
$CellContext`A, $CellContext`B\[Dagger], $CellContext`B, $CellContext`C\
\[Dagger], C, $CellContext`D\[Dagger], D], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDe", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDe[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDe", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`ChristoffelCDCDe[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCDe", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelCDe[$CellContext`A, -$CellContext`b, -C], ". ", 
   ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCDe\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelCDe\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannCDe", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannCDe[-$CellContext`a, -$CellContext`b, -C, D], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannCDe\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]FRiemannCDe[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -C, -D], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]FRiemannCDe\[Dagger][-$CellContext`A\[Dagger]\
, -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChiCDe[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChiCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PhiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PhiCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`PhiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -C, -D], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"LambdaCDe", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`LambdaCDe[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PsiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PsiCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]RiemannCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RiemannCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]RiemannCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]RicciCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RicciCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]RicciCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]WeylCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]WeylCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]WeylCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]TFRicciCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]TFRicciCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]TFRicciCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
Pretty printing options for the spinor indices and the spin metric.\
\>", "MathCaption"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAs", "[", "A\[Dagger]", "]"}], "^=", "\"\<A'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "B\[Dagger]", "]"}], "^=", "\"\<B'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "C\[Dagger]", "]"}], "^=", "\"\<C'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "D\[Dagger]", "]"}], "^=", "\"\<D'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "F\[Dagger]", "]"}], "^=", "\"\<F'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "H\[Dagger]", "]"}], "^=", "\"\<H'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "L\[Dagger]", "]"}], "^=", "\"\<L'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "M\[Dagger]", "]"}], "^=", "\"\<M'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "P\[Dagger]", "]"}], "^=", "\"\<P'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "Q\[Dagger]", "]"}], "^=", "\"\<Q'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "\[Epsilon]\[Dagger]", "]"}], "^=", 
     "\"\<\!\(\*OverscriptBox[\(\[Epsilon]\), \(__\)]\)\>\""}]}], "}"}], 
  ";"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["2. The Newman-Penrose formalism", "Subsection"],

Cell[TextData[{
 "The Newman-Penrose formalism can be regarded as an application of the \
spinor calculus. In this section we show how all the equations of this \
formalism can be derived sytematically and efficiently using ",
 StyleBox["Spinors`", "Output"],
 "  in conjuntion with the package ",
 StyleBox["xCoba`", "Output"],
 ". Full explanations about the usage of ",
 StyleBox["xCoba`", "Output"],
 "  can be found in the package documentation. "
}], "Text",
 TextJustification->1.,
 FontWeight->"Plain"],

Cell[TextData[{
 "We load ",
 StyleBox["xCoba`", "Output"],
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`xCoba`"}]], "Input"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2013", ",", "7", ",", "1"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.1", ", ", {2013, 7, 1}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CopyRight (C) 2005-2013, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"]
}, Open  ]],

Cell[TextData[{
 "We turn off the verbose messages issued by ",
 StyleBox["ComponentValue", "Output"],
 StyleBox[".", "Input"]
}], "MathCaption"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CVVerbose", "=", "False"}], ";"}]], "Input"],

Cell[TextData[{
 "In the following subsections we introduce the spin dyad and its associated \
null tetrad. We will use  ",
 StyleBox["xCoba`",
  FontFamily->"Adobe Courier"],
 " to introduce two frames (basis), called ",
 StyleBox["Dyad",
  FontFamily->"Adobe Courier"],
 " and ",
 StyleBox["NP ",
  FontFamily->"Adobe Courier"],
 "and we shall create a parallel set of vectors for the elements in each \
basis. See the corresponding subsections for full details."
}], "Text",
 TextJustification->1.],

Cell[CellGroupData[{

Cell["Spin dyad", "Subsubsection"],

Cell["First of all, we define the elements of a spin dyad.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DefSpinor", "[", 
     RowBox[{"#", ",", "M4"}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"o", "[", "A", "]"}], ",", 
     RowBox[{"\[Iota]", "[", "A", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "o\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(o\), \(__\)]\)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Iota]\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Iota]\), \(__\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"o", "[", "A", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`o[$CellContext`A], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"o\[Dagger]", "[", "A\[Dagger]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`o\[Dagger][$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Iota]", "[", "A", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Iota][$CellContext`A], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Iota]\[Dagger]", "[", "A\[Dagger]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Iota]\[Dagger][$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell["These spinors belong to a spin basis which we define next.", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"Dyad", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "Dyad", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`Dyad, 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDDyad", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDDyad[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDDyad", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDDyad[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDDyad", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDDyad[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDDyad", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDDyad[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDDyad", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDDyad[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDDyad", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDDyad[$CellContext`A, -$CellContext`b, -C], ". ",
    ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDDyad\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDDyad\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDDyad", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDDyad[-$CellContext`a, -$CellContext`b, -C, D], ". ",
    ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDDyad\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDDyad\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", 
   "Dyad\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", 
   "basis ", $CellContext`Dyad\[Dagger], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpDyad", "[", 
    RowBox[{"A", ",", "B"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpDyad[$CellContext`A, $CellContext`B], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpDyad\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "B\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpDyad\[Dagger][$CellContext`A\[Dagger], $CellContext`B\
\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownDyad", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownDyad[-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownDyad\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownDyad\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
Component indices in the conjugated basis will be also primed :\
\>", "MathCaption"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dyad\[Dagger]", "/:", 
   RowBox[{"CIndexForm", "[", 
    RowBox[{"i_Integer", ",", "Dyad\[Dagger]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"ToString", "[", "i", "]"}], ",", "\"\<'\>\""}], "]"}]}], 
  ";"}]], "Input"],

Cell["\<\
By definition, these are the equations relating both sets of objects:\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqs", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"o", "[", "A", "]"}], "\[Equal]", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "Dyad"}]}], "}"}], ",", "A"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"\[Iota]", "[", "A", "]"}], "\[Equal]", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "Dyad"}]}], "}"}], ",", "A"}], "]"}]}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {"A"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[$CellContext`A],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "A"},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{0, -$CellContext`Dyad}, $CellContext`A],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {"A"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][$CellContext`A],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "A"},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{1, -$CellContext`Dyad}, $CellContext`A],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "From them, we read and store the components of the spinors ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["o", " ", "A"],
    AutoSpacing->False],
   $CellContext`o[$CellContext`A],
   Editable->False]], "Output",
  CellChangeTimes->{3.4238257047278767`*^9, 3.423825778247744*^9, 
   3.423825861535986*^9}],
 ", ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Iota]", " ", "A"],
    AutoSpacing->False],
   $CellContext`\[Iota][$CellContext`A],
   Editable->False]], "Output",
  CellChangeTimes->{3.4238257047278767`*^9, 3.423825778247744*^9, 
   3.423825861535986*^9}],
 " ."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad", "]"}], ",", "eqs", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Det\[Epsilon]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Det\[Epsilon][], ". ", "Determinant."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Det\[Epsilon]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Det\[Epsilon]Dyad[], ". ", "Determinant."],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{
      0, -$CellContext`Dyad}, {$CellContext`A, $CellContext`Dyad}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{
      1, -$CellContext`Dyad}, {$CellContext`A, $CellContext`Dyad}],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["We now do the same for the conjugated equations:", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad\[Dagger]", "]"}], ",", 
   RowBox[{"Dagger", "[", "eqs", "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Det\[Epsilon]\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Det\[Epsilon]\[Dagger][], ". ", "Determinant."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Det\[Epsilon]\[Dagger]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Det\[Epsilon]\[Dagger]Dyad\[Dagger][], ". ", "Determinant."],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "__"], 
         StyleBox[GridBox[{
            {
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{
      0, -$CellContext`Dyad\[Dagger]}, {$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "__"], 
         StyleBox[GridBox[{
            {
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{
      1, -$CellContext`Dyad\[Dagger]}, {$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentArray", "@", 
  RowBox[{"Join", "[", 
   RowBox[{"%%", ",", "%"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{0, $CellContext`Dyad}],
       Editable->False], "\[Equal]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{1, $CellContext`Dyad}],
       Editable->False], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{0, $CellContext`Dyad}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{1, $CellContext`Dyad}],
       Editable->False], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["o", "__"], 
           StyleBox[GridBox[{
              {
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o\[Dagger][{0, $CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["o", "__"], 
           StyleBox[GridBox[{
              {
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o\[Dagger][{1, $CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Iota]", "__"], 
           StyleBox[GridBox[{
              {
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]\[Dagger][{0, $CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Iota]", "__"], 
           StyleBox[GridBox[{
              {
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]\[Dagger][{1, $CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "1"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"Equal", "->", "ComponentValue"}]}], ";"}]], "Input"],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox[
    RowBox[{
     SubsuperscriptBox["o", " ", "A"], ","}],
    AutoSpacing->False]}]], "Output",
  CellChangeTimes->{{3.423826323021446*^9, 3.423826346868227*^9}, 
    3.423826487957116*^9, {3.423826557584194*^9, 3.42382657235732*^9}, 
    3.423826805717166*^9, 3.4238273982616997`*^9, 3.423903800260459*^9, 
    3.4239043784188433`*^9, 3.4239046714212503`*^9, 3.42392536234076*^9, 
    3.42397833572017*^9, 3.4239934551341877`*^9, 3.4240051077502537`*^9, 
    3.4240611902849293`*^9, 3.424061340660375*^9, 3.4240708360967007`*^9, 
    3.4240760648380957`*^9, 3.424076474325555*^9, 3.424415057111891*^9, 
    3.424430450536281*^9, 3.4244468338964863`*^9, 3.42444740893721*^9, 
    3.4245794840971746`*^9, 3.424595355535811*^9, 3.424596536942671*^9, 
    3.424599108414694*^9, 3.424668078687495*^9, 3.424776230261053*^9, 
    3.424780974004918*^9, 3.424791882204584*^9, 3.424963735863695*^9, 
    3.425017466626889*^9, 3.425381932441518*^9, 3.425460126841139*^9, 
    3.425460884149899*^9, 3.4254685798737793`*^9, 3.4254737073383636`*^9, 
    3.425496991712772*^9, 3.425550852667362*^9, 3.4255793867147217`*^9, 
    3.4256217205863113`*^9, 3.4257077110767193`*^9, 3.42579024440254*^9, 
    3.4258789930781193`*^9, 3.426274866355981*^9, 3.426796529786223*^9, 
    3.426796830331471*^9, 3.426797048510157*^9, 3.426798569075074*^9, 
    3.426798700887356*^9, 3.426798824952031*^9, 3.4267988794887877`*^9, 
    3.4267989522929487`*^9, 3.426799131075737*^9, 3.426800596828487*^9, 
    3.427087625511497*^9, 3.4270954501415253`*^9, 3.427174249661171*^9}],
 Cell[BoxData[
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Iota]", " ", "A"],
     AutoSpacing->False],
    $CellContext`\[Iota][$CellContext`A],
    Editable->False], "}"}]], "Output",
  CellChangeTimes->{{3.423826323021446*^9, 3.423826346868227*^9}, 
    3.423826487957116*^9, {3.423826557584194*^9, 3.42382657235732*^9}, 
    3.423826805717166*^9, 3.4238273982616997`*^9, 3.423903800260459*^9, 
    3.4239043784188433`*^9, 3.4239046714212503`*^9, 3.42392536234076*^9, 
    3.42397833572017*^9, 3.4239934551341877`*^9, 3.4240051077502537`*^9, 
    3.4240611902849293`*^9, 3.424061340660375*^9, 3.4240708360967007`*^9, 
    3.4240760648380957`*^9, 3.424076474325555*^9, 3.424415057111891*^9, 
    3.424430450536281*^9, 3.4244468338964863`*^9, 3.42444740893721*^9, 
    3.4245794840971746`*^9, 3.424595355535811*^9, 3.424596536942671*^9, 
    3.424599108414694*^9, 3.424668078687495*^9, 3.424776230261053*^9, 
    3.424780974004918*^9, 3.424791882204584*^9, 3.424963735863695*^9, 
    3.425017466626889*^9, 3.425381932441518*^9, 3.425460126841139*^9, 
    3.425460884149899*^9, 3.4254685798737793`*^9, 3.4254737073383636`*^9, 
    3.425496991712772*^9, 3.425550852667362*^9, 3.4255793867147217`*^9, 
    3.4256217205863113`*^9, 3.4257077110767193`*^9, 3.42579024440254*^9, 
    3.4258789930781193`*^9, 3.426274866355981*^9, 3.426796529786223*^9, 
    3.426796830331471*^9, 3.426797048510157*^9, 3.426798569075074*^9, 
    3.426798700887356*^9, 3.426798824952031*^9, 3.4267988794887877`*^9, 
    3.4267989522929487`*^9, 3.426799131075737*^9, 3.426800596828487*^9, 
    3.427087625511497*^9, 3.4270954501415253`*^9, 3.427174249661171*^9}],
 " is a spin dyad, the spin metric can be written in the form"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqs", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Epsilon]", "[", 
     RowBox[{"A", ",", "B"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"o", "[", "A", "]"}], " ", 
      RowBox[{"\[Iota]", "[", "B", "]"}]}], "-", 
     RowBox[{
      RowBox[{"o", "[", "B", "]"}], " ", 
      RowBox[{"\[Iota]", "[", "A", "]"}]}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"A", "B"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][$CellContext`A, $CellContext`B],
    Editable->False], "\[Equal]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {"B"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[$CellContext`B],
       Editable->False]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][$CellContext`A],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[$CellContext`A],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {"B"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][$CellContext`B],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The components of the spin metric and its complex conjugate can now be \
computed and stored.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad", "]"}], ",", "eqs", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {
            StyleBox["A",
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox["B",
             FontColor->RGBColor[1., 0., 0.]]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][{$CellContext`A, $CellContext`Dyad}, \
{$CellContext`B, $CellContext`Dyad}],
    Editable->False], "\[Equal]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {
               StyleBox["B",
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{$CellContext`B, $CellContext`Dyad}],
       Editable->False]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["B",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`B, $CellContext`Dyad}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad\[Dagger]", "]"}], ",", 
   RowBox[{"Dagger", "[", "eqs", "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {
            StyleBox[
             RowBox[{"A", "'"}],
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox[
             RowBox[{"B", "'"}],
             FontColor->RGBColor[1., 0., 0.]]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}, {$CellContext`B\[Dagger], $CellContext`Dyad\
\[Dagger]}],
    Editable->False], "\[Equal]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["o", "__"], 
           StyleBox[GridBox[{
              {
               StyleBox[
                RowBox[{"B", "'"}],
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o\[Dagger][{$CellContext`B\[Dagger], $CellContext`Dyad\
\[Dagger]}],
       Editable->False]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"B", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`B\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToValues", "@", 
  RowBox[{"ComponentArray", "@", 
   RowBox[{"Join", "[", 
    RowBox[{"%%", ",", "%"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]", 
             StyleBox[GridBox[{
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon][{0, $CellContext`Dyad}, {
          0, $CellContext`Dyad}],
         Editable->False], "\[Equal]", "0"}], ",", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]", 
             StyleBox[GridBox[{
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon][{0, $CellContext`Dyad}, {
          1, $CellContext`Dyad}],
         Editable->False], "\[Equal]", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon][{1, $CellContext`Dyad}, {
          0, $CellContext`Dyad}],
         Editable->False], "\[Equal]", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon][{1, $CellContext`Dyad}, {
          1, $CellContext`Dyad}],
         Editable->False], "\[Equal]", "0"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             OverscriptBox["\[Epsilon]", "__"], 
             StyleBox[GridBox[{
                {
                 StyleBox[
                  RowBox[{"0", "'"}],
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox[
                  RowBox[{"0", "'"}],
                  FontColor->RGBColor[1., 0., 0.]]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon]\[Dagger][{0, $CellContext`Dyad\[Dagger]}, {
          0, $CellContext`Dyad\[Dagger]}],
         Editable->False], "\[Equal]", "0"}], ",", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             OverscriptBox["\[Epsilon]", "__"], 
             StyleBox[GridBox[{
                {
                 StyleBox[
                  RowBox[{"0", "'"}],
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox[
                  RowBox[{"1", "'"}],
                  FontColor->RGBColor[1., 0., 0.]]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon]\[Dagger][{0, $CellContext`Dyad\[Dagger]}, {
          1, $CellContext`Dyad\[Dagger]}],
         Editable->False], "\[Equal]", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             OverscriptBox["\[Epsilon]", "__"], 
             StyleBox[GridBox[{
                {
                 StyleBox[
                  RowBox[{"1", "'"}],
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox[
                  RowBox[{"0", "'"}],
                  FontColor->RGBColor[1., 0., 0.]]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon]\[Dagger][{1, $CellContext`Dyad\[Dagger]}, {
          0, $CellContext`Dyad\[Dagger]}],
         Editable->False], "\[Equal]", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             OverscriptBox["\[Epsilon]", "__"], 
             StyleBox[GridBox[{
                {
                 StyleBox[
                  RowBox[{"1", "'"}],
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox[
                  RowBox[{"1", "'"}],
                  FontColor->RGBColor[1., 0., 0.]]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon]\[Dagger][{1, $CellContext`Dyad\[Dagger]}, {
          1, $CellContext`Dyad\[Dagger]}],
         Editable->False], "\[Equal]", "0"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"Equal", "->", "ComponentValue"}]}], ";"}]], "Input"],

Cell[TextData[{
 "We deduce from here the components of ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Epsilon]", "AB", "  "],
    AutoSpacing->False],
   $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
   Editable->False]], "Output",
  CellChangeTimes->{3.423827499169783*^9}],
 " by means of the relation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Epsilon]", "AB", "  "],
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Epsilon]", "  ", "CB"],
      AutoSpacing->False],
     $CellContext`\[Epsilon][C, $CellContext`B],
     Editable->False]}], "=", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Delta]", 
      RowBox[{"A", " "}], 
      RowBox[{" ", "C"}]],
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`A, C],
    Editable->False]}]], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellChangeTimes->{3.423827609425281*^9}],
 ".  To that end we need to find the inverse of the transposed of the matrix \
representation of the components of ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Epsilon]", "  ", "AB"],
    AutoSpacing->False],
   $CellContext`\[Epsilon][$CellContext`A, $CellContext`B],
   Editable->False]], "Output",
  CellChangeTimes->{3.427175671011052*^9}],
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EP", "=", 
  RowBox[{"ToValues", "@", 
   RowBox[{"TableOfComponents", "[", 
    RowBox[{
     RowBox[{"\[Epsilon]", "[", 
      RowBox[{"A", ",", "B"}], "]"}], ",", "Dyad"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "@", 
  RowBox[{"Transpose", "@", "EP"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Storage of the components of  ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Epsilon]", "  ", "AB"],
    AutoSpacing->False],
   $CellContext`\[Epsilon][$CellContext`A, $CellContext`B],
   Editable->False]], "Output",
  CellChangeTimes->{3.427175671011052*^9}],
 " and its complex conjugate."
}], "MathCaption"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"MetricInBasis", "[", 
   RowBox[{"\[Epsilon]", ",", 
    RowBox[{"-", "Dyad"}], ",", "%"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MetricInBasis", "[", 
   RowBox[{"\[Epsilon]\[Dagger]", ",", 
    RowBox[{"-", "Dyad\[Dagger]"}], ",", "%%"}], "]"}], ";"}]}], "Input"],

Cell[TextData[{
 "We now compute and store the components of ",
 Cell[BoxData[
  StyleBox[
   SubsuperscriptBox["o", "A", " "],
   AutoSpacing->False]], "Output",
  CellChangeTimes->{
   3.423826079206477*^9, 3.4238261160657682`*^9, {3.423826160205621*^9, 
    3.423826186371304*^9}, 3.423827098750963*^9, 3.423827411291833*^9}],
 ", ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Iota]", "A", " "],
    AutoSpacing->False],
   $CellContext`\[Iota][-$CellContext`A],
   Editable->False]], "Output",
  CellChangeTimes->{
   3.423826079206477*^9, 3.4238261160657682`*^9, {3.423826160205621*^9, 
    3.423826186371304*^9}, 3.423827098750963*^9, 3.423827411291833*^9}],
 " and their complex conjugate."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqs", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"o", "[", 
      RowBox[{"-", "A"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"\[Epsilon]", "[", 
       RowBox[{
        RowBox[{"-", "B"}], ",", 
        RowBox[{"-", "A"}]}], "]"}], " ", 
      RowBox[{"o", "[", "B", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"\[Iota]", "[", 
      RowBox[{"-", "A"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"\[Epsilon]", "[", 
       RowBox[{
        RowBox[{"-", "B"}], ",", 
        RowBox[{"-", "A"}]}], "]"}], " ", 
      RowBox[{"\[Iota]", "[", "B", "]"}]}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {"B"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[$CellContext`B],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"B", "A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`A],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"B", "A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`A],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {"B"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][$CellContext`B],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad", "]"}], ",", "eqs", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["B",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`B, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["B",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][{-$CellContext`B, -$CellContext`Dyad}, \
{-$CellContext`A, -$CellContext`Dyad}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["B",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][{-$CellContext`B, -$CellContext`Dyad}, \
{-$CellContext`A, -$CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["B",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`B, $CellContext`Dyad}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad\[Dagger]", "]"}], ",", 
   RowBox[{"Dagger", "[", "eqs", "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "__"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][{-$CellContext`A\[Dagger], -$CellContext`Dyad\
\[Dagger]}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"B", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`B\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Epsilon]", "__"], 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox[
               RowBox[{"B", "'"}],
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][{-$CellContext`B\[Dagger], \
-$CellContext`Dyad\[Dagger]}, {-$CellContext`A\[Dagger], -$CellContext`Dyad\
\[Dagger]}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "__"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][{-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Epsilon]", "__"], 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox[
               RowBox[{"B", "'"}],
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][{-$CellContext`B\[Dagger], \
-$CellContext`Dyad\[Dagger]}, {-$CellContext`A\[Dagger], -$CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"B", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`B\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"TraceBasisDummy", ",", 
   RowBox[{"Join", "[", 
    RowBox[{"%%", ",", "%"}], "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{0, $CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][{
        0, -$CellContext`Dyad}, {-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{1, $CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][{
        1, -$CellContext`Dyad}, {-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][{
        0, -$CellContext`Dyad}, {-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{0, $CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][{
        1, -$CellContext`Dyad}, {-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{1, $CellContext`Dyad}],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "__"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][{-$CellContext`A\[Dagger], -$CellContext`Dyad\
\[Dagger]}],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["o", "__"], 
           StyleBox[GridBox[{
              {
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o\[Dagger][{0, $CellContext`Dyad\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "__"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"A", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][{
        0, -$CellContext`Dyad\[Dagger]}, {-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["o", "__"], 
           StyleBox[GridBox[{
              {
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o\[Dagger][{1, $CellContext`Dyad\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "__"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"A", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][{
        1, -$CellContext`Dyad\[Dagger]}, {-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "__"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][{-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "__"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"A", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][{
        0, -$CellContext`Dyad\[Dagger]}, {-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Iota]", "__"], 
           StyleBox[GridBox[{
              {
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]\[Dagger][{0, $CellContext`Dyad\[Dagger]}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "__"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"A", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][{
        1, -$CellContext`Dyad\[Dagger]}, {-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Iota]", "__"], 
           StyleBox[GridBox[{
              {
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]\[Dagger][{1, $CellContext`Dyad\[Dagger]}],
       Editable->False]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToValues", "@", 
  RowBox[{"ComponentArray", "@", "%"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{0, -$CellContext`Dyad}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{1, -$CellContext`Dyad}],
       Editable->False], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{0, -$CellContext`Dyad}],
       Editable->False], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{1, -$CellContext`Dyad}],
       Editable->False], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["o", "__"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o\[Dagger][{0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["o", "__"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o\[Dagger][{1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Iota]", "__"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]\[Dagger][{0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Iota]", "__"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]\[Dagger][{1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"Equal", "->", "ComponentValue"}]}], ";"}]], "Input"],

Cell[TextData[{
 "We change the ",
 StyleBox["Rule", "Output"],
 " assignment to the ",
 StyleBox["Set", "Output"],
 " assignment in each ",
 StyleBox["FoldedRule", "Output"],
 " storing the components computed so far"
}], "MathCaption"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RuleToSet", "/@", 
   RowBox[{"{", 
    RowBox[{
    "\[Epsilon]", ",", "\[Epsilon]\[Dagger]", ",", "o", ",", "o\[Dagger]", 
     ",", "\[Iota]", ",", "\[Iota]\[Dagger]"}], "}"}]}], ";"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Null tetrad", "Subsubsection"],

Cell["\<\
We define now four vectors which will represent the null tetrad basis \
elements.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"lNP", "[", "a", "]"}], ",", "M4", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<l\>\""}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"lNP", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`lNP[$CellContext`a], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"nNP", "[", "a", "]"}], ",", "M4", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<n\>\""}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"nNP", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`nNP[$CellContext`a], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"mNP", "[", "a", "]"}], ",", "M4", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<m\>\""}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"mNP", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`mNP[$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"mNP\[Dagger]", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`mNP\[Dagger][$CellContext`a], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "@", "mNP\[Dagger]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(m\), \(_\)]\)\>\""}], ";"}]], "Input"],

Cell["\<\
These vectors belong to a basis (null  tetrad) which we define next.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"NP", ",", "TangentM4", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"BasisColor", "->", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "NP", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`NP, ". ", 
   ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDNP", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDNP[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDNP", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDNP[$CellContext`a, -$CellContext`b, -$CellContext`c],
    ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDNP", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDNP[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDNP", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDNP[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDNP", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDNP[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpNP", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpNP[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownNP", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownNP[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[TextData[{
 "We specify the behaviour of the elements of this basis under complex \
conjugation. This is achieved with the command ",
 StyleBox["SetDaggerMatrix", "Input"],
 "."
}], "MathCaption"],

Cell[BoxData[
 RowBox[{"SetDaggerMatrix", "[", 
  RowBox[{"NP", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
  "]"}]], "Input"],

Cell[TextData[{
 "We format a number of objects according to standard conventions. Due to the \
new way of sorting definitions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "  6.0, we need to stop the formatting engine and start it again after \
defining these new rules."
}], "Text",
 FontWeight->"Plain"],

Cell["Stop formatting engine.", "MathCaption"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xTensorFormStop", "[", "]"}], ";"}]], "Input"],

Cell["\<\
Formatting of the directional derivatives with the standard NP symbols.\
\>", "MathCaption"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FormatBasis", "[", 
   RowBox[{
    RowBox[{"PDNP", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "NP"}]}], "}"}], "]"}], ",", "\"\<D\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FormatBasis", "[", 
   RowBox[{
    RowBox[{"PDNP", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "NP"}]}], "}"}], "]"}], ",", "\"\<\[CapitalDelta]\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FormatBasis", "[", 
   RowBox[{
    RowBox[{"PDNP", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "NP"}]}], "}"}], "]"}], ",", "\"\<\[Delta]\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FormatBasis", "[", 
   RowBox[{
    RowBox[{"PDNP", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "NP"}]}], "}"}], "]"}], ",", 
    "\"\<\!\(\*OverscriptBox[\(\[Delta]\), \(_\)]\)\>\""}], "]"}], 
  ";"}]}], "Input"],

Cell[TextData[{
 "The Newman-Penrose directional derivatives can also act on spinors. For \
that case we need to use the covariant derivative ",
 StyleBox["CDe", "Output"],
 " rather than ",
 StyleBox["PDNP", "Output"],
 ".  Therefore we need to set a formatting for the directional derivatives \
taken with respect to ",
 StyleBox["CDe", "Output"],
 " (note that when ",
 StyleBox["CDe", "Output"],
 " and ",
 StyleBox["PDNP", "Output"],
 " act on scalars or tensors they coincide)."
}], "MathCaption",
 TextJustification->1.],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FormatBasis", "[", 
   RowBox[{
    RowBox[{"CDe", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "NP"}]}], "}"}], "]"}], ",", "\"\<D\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FormatBasis", "[", 
   RowBox[{
    RowBox[{"CDe", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "NP"}]}], "}"}], "]"}], ",", "\"\<\[CapitalDelta]\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FormatBasis", "[", 
   RowBox[{
    RowBox[{"CDe", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "NP"}]}], "}"}], "]"}], ",", "\"\<\[Delta]\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FormatBasis", "[", 
   RowBox[{
    RowBox[{"CDe", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "NP"}]}], "}"}], "]"}], ",", 
    "\"\<\!\(\*OverscriptBox[\(\[Delta]\), \(_\)]\)\>\""}], "]"}], 
  ";"}]}], "Input"],

Cell["Restart formatting  engine:", "MathCaption"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xTensorFormStart", "[", "]"}], ";"}]], "Input"],

Cell[TextData[{
 "These are the relations between the elements of the null tetrad  and the \
elements of the basis ",
 StyleBox["NP", "Output"],
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"lNP", "[", "a", "]"}], "\[Equal]", 
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "NP"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"nNP", "[", "a", "]"}], "\[Equal]", 
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "NP"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"mNP", "[", "a", "]"}], "\[Equal]", 
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "NP"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"mNP\[Dagger]", "[", "a", "]"}], "\[Equal]", 
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", 
        RowBox[{"-", "NP"}]}], "}"}]}], "]"}]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{1, -$CellContext`NP}, $CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{2, -$CellContext`NP}, $CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{3, -$CellContext`NP}, $CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{4, -$CellContext`NP}, $CellContext`a],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "From this relation we compute the components of ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["l", " ", "a"],
    AutoSpacing->False],
   $CellContext`lNP[$CellContext`a],
   Editable->False]], "Output",
  CellChangeTimes->{3.443600000373357*^9, 3.443600614034006*^9, 
   3.44360110601153*^9, 3.4444578983998013`*^9, 3.444971906279531*^9, 
   3.4450800572925777`*^9, 3.445238951063208*^9, 3.44523920656565*^9, 
   3.447147750178196*^9, 3.447148302618504*^9, 3.4471593828182697`*^9, 
   3.447998369063972*^9, 3.448171329884437*^9, 3.448271854453495*^9, 
   3.448341708076147*^9, 3.449288679662628*^9, 3.449816979737742*^9, 
   3.4504101371642933`*^9, 3.450417087980618*^9, 3.4518175014621572`*^9, 
   3.452242362453743*^9, 3.4524082882882566`*^9, 3.45724482695157*^9}],
 ",  ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["n", " ", "a"],
    AutoSpacing->False],
   $CellContext`nNP[$CellContext`a],
   Editable->False]], "Output",
  CellChangeTimes->{3.443600000373357*^9, 3.443600614034006*^9, 
   3.44360110601153*^9, 3.4444578983998013`*^9, 3.444971906279531*^9, 
   3.4450800572925777`*^9, 3.445238951063208*^9, 3.44523920656565*^9, 
   3.447147750178196*^9, 3.447148302618504*^9, 3.4471593828182697`*^9, 
   3.447998369063972*^9, 3.448171329884437*^9, 3.448271854453495*^9, 
   3.448341708076147*^9, 3.449288679662628*^9, 3.449816979737742*^9, 
   3.4504101371642933`*^9, 3.450417087980618*^9, 3.4518175014621572`*^9, 
   3.452242362453743*^9, 3.4524082882882566`*^9, 3.45724482695157*^9}],
 ",  ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["m", " ", "a"],
    AutoSpacing->False],
   $CellContext`mNP[$CellContext`a],
   Editable->False]], "Output",
  CellChangeTimes->{3.443600000373357*^9, 3.443600614034006*^9, 
   3.44360110601153*^9, 3.4444578983998013`*^9, 3.444971906279531*^9, 
   3.4450800572925777`*^9, 3.445238951063208*^9, 3.44523920656565*^9, 
   3.447147750178196*^9, 3.447148302618504*^9, 3.4471593828182697`*^9, 
   3.447998369063972*^9, 3.448171329884437*^9, 3.448271854453495*^9, 
   3.448341708076147*^9, 3.449288679662628*^9, 3.449816979737742*^9, 
   3.4504101371642933`*^9, 3.450417087980618*^9, 3.4518175014621572`*^9, 
   3.452242362453743*^9, 3.4524082882882566`*^9, 3.45724482695157*^9}],
 ",  ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     OverscriptBox["m", "_"], " ", "a"],
    AutoSpacing->False],
   $CellContext`mNP\[Dagger][$CellContext`a],
   Editable->False]], "Output",
  CellChangeTimes->{3.443600000373357*^9, 3.443600614034006*^9, 
   3.44360110601153*^9, 3.4444578983998013`*^9, 3.444971906279531*^9, 
   3.4450800572925777`*^9, 3.445238951063208*^9, 3.44523920656565*^9, 
   3.447147750178196*^9, 3.447148302618504*^9, 3.4471593828182697`*^9, 
   3.447998369063972*^9, 3.448171329884437*^9, 3.448271854453495*^9, 
   3.448341708076147*^9, 3.449288679662628*^9, 3.449816979737742*^9, 
   3.4504101371642933`*^9, 3.450417087980618*^9, 3.4518175014621572`*^9, 
   3.452242362453743*^9, 3.4524082882882566`*^9, 3.45724482695157*^9}],
 " in the basis ",
 StyleBox["NP", "Output"],
 " ."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "NP", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetgNP", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetgNP[], ". ", "Determinant."],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{$CellContext`a, $CellContext`NP}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{
      1, -$CellContext`NP}, {$CellContext`a, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{$CellContext`a, $CellContext`NP}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{
      2, -$CellContext`NP}, {$CellContext`a, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{$CellContext`a, $CellContext`NP}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{
      3, -$CellContext`NP}, {$CellContext`a, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{$CellContext`a, $CellContext`NP}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{
      4, -$CellContext`NP}, {$CellContext`a, $CellContext`NP}],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "@", 
  RowBox[{"ComponentArray", "@", "%"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{1, $CellContext`NP}],
     Editable->False], "\[Equal]", "1"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{2, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{3, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{4, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{1, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{2, $CellContext`NP}],
     Editable->False], "\[Equal]", "1"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{3, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{4, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{1, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{2, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{3, $CellContext`NP}],
     Editable->False], "\[Equal]", "1"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{4, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{1, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{2, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{3, $CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{4, $CellContext`NP}],
     Editable->False], "\[Equal]", "1"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"Equal", "\[Rule]", "ComponentValue"}]}], ";"}]], "Input"],

Cell["\<\
As is well known, in the null tetrad the metric takes the form\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"lNP", "[", "a", "]"}], 
    RowBox[{"nNP", "[", "b", "]"}]}], "+", 
   RowBox[{
    RowBox[{"lNP", "[", "b", "]"}], 
    RowBox[{"nNP", "[", "a", "]"}]}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"mNP", "[", "a", "]"}], 
      RowBox[{"mNP\[Dagger]", "[", "b", "]"}]}], "+", 
     RowBox[{
      RowBox[{"mNP", "[", "b", "]"}], 
      RowBox[{"mNP\[Dagger]", "[", "a", "]"}]}]}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`a, $CellContext`b],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[$CellContext`b],
      Editable->False]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][$CellContext`a],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][$CellContext`b],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[$CellContext`a],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[$CellContext`b],
     Editable->False]}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "We compute and store the components of ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["g", "  ", "ab"],
    AutoSpacing->False],
   $CellContext`g[$CellContext`a, $CellContext`b],
   Editable->False]], "Output",
  CellChangeTimes->{{3.457247975119607*^9, 3.457247985098529*^9}, {
    3.4572480842554502`*^9, 3.457248099409466*^9}, 3.457248317855564*^9}],
 " in the basis ",
 StyleBox["NP", "Output"],
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBasis", "[", "NP", "]"}], "/@", "%"}]], "Input"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {
           StyleBox["a",
            FontColor->RGBColor[0., 0., 1.]], 
           StyleBox["b",
            FontColor->RGBColor[0., 0., 1.]]},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[{$CellContext`a, $CellContext`NP}, {$CellContext`b, \
$CellContext`NP}],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[{$CellContext`b, $CellContext`NP}],
      Editable->False]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{$CellContext`a, $CellContext`NP}],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{$CellContext`a, $CellContext`NP}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {
             StyleBox["b",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{$CellContext`b, $CellContext`NP}],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {
             StyleBox["b",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{$CellContext`b, $CellContext`NP}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{$CellContext`a, $CellContext`NP}],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{$CellContext`a, $CellContext`NP}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {
             StyleBox["b",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{$CellContext`b, $CellContext`NP}],
     Editable->False]}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToValues", "@", 
  RowBox[{"ComponentArray", "@", "%"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, $CellContext`NP}, {1, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, $CellContext`NP}, {2, $CellContext`NP}],
       Editable->False], "\[Equal]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, $CellContext`NP}, {3, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, $CellContext`NP}, {4, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, $CellContext`NP}, {1, $CellContext`NP}],
       Editable->False], "\[Equal]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, $CellContext`NP}, {2, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, $CellContext`NP}, {3, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, $CellContext`NP}, {4, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, $CellContext`NP}, {1, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, $CellContext`NP}, {2, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, $CellContext`NP}, {3, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, $CellContext`NP}, {4, $CellContext`NP}],
       Editable->False], "\[Equal]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, $CellContext`NP}, {1, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, $CellContext`NP}, {2, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, $CellContext`NP}, {3, $CellContext`NP}],
       Editable->False], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, $CellContext`NP}, {4, $CellContext`NP}],
       Editable->False], "\[Equal]", "0"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["We store the components of the metric tensor", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"Equal", "->", "ComponentValue"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, $CellContext`NP}, {1, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, $CellContext`NP}, {2, $CellContext`NP}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, $CellContext`NP}, {3, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, $CellContext`NP}, {4, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, $CellContext`NP}, {1, $CellContext`NP}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, $CellContext`NP}, {2, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, $CellContext`NP}, {3, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, $CellContext`NP}, {4, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, $CellContext`NP}, {1, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, $CellContext`NP}, {2, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, $CellContext`NP}, {3, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, $CellContext`NP}, {4, $CellContext`NP}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, $CellContext`NP}, {1, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, $CellContext`NP}, {2, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, $CellContext`NP}, {3, $CellContext`NP}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, $CellContext`NP}, {4, $CellContext`NP}],
       Editable->False], "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "We compute the components of ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["g", "ab", "  "],
    AutoSpacing->False],
   $CellContext`g[-$CellContext`a, -$CellContext`b],
   Editable->False]], "Output",
  CellChangeTimes->{3.4572484089309483`*^9}],
 "  and store their values."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "@", 
  RowBox[{"ToValues", "@", 
   RowBox[{"TableOfComponents", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", "NP"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "1", "0", "0"},
     {"1", "0", "0", "0"},
     {"0", "0", "0", 
      RowBox[{"-", "1"}]},
     {"0", "0", 
      RowBox[{"-", "1"}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "@", 
  RowBox[{"Inverse", "@", "%"}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "1", "0", "0"},
     {"1", "0", "0", "0"},
     {"0", "0", "0", 
      RowBox[{"-", "1"}]},
     {"0", "0", 
      RowBox[{"-", "1"}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetricInBasis", "[", 
  RowBox[{"g", ",", 
   RowBox[{"-", "NP"}], ",", "%"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, -$CellContext`NP}, {1, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, -$CellContext`NP}, {2, -$CellContext`NP}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, -$CellContext`NP}, {3, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{1, -$CellContext`NP}, {4, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, -$CellContext`NP}, {1, -$CellContext`NP}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, -$CellContext`NP}, {2, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, -$CellContext`NP}, {3, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{2, -$CellContext`NP}, {4, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, -$CellContext`NP}, {1, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, -$CellContext`NP}, {2, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, -$CellContext`NP}, {3, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{3, -$CellContext`NP}, {4, -$CellContext`NP}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, -$CellContext`NP}, {1, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, -$CellContext`NP}, {2, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, -$CellContext`NP}, {3, -$CellContext`NP}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{4, -$CellContext`NP}, {4, -$CellContext`NP}],
       Editable->False], "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Finally we change the ",
 StyleBox["Rule", "Output"],
 " assignment to the ",
 StyleBox["Set", "Output"],
 " assignment in the ",
 StyleBox["FoldedRule", "Output"],
 " storing all the components of the metric tensor."
}], "MathCaption",
 TextJustification->1.],

Cell[BoxData[
 RowBox[{"RuleToSet", "@", "g"}]], "Input"],

Cell["\<\
We also need the components for the elements of the null tetrad with the \
indices downstairs. They are computed from those with the indices upstairs. \
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"lNP", "[", 
     RowBox[{"-", "a"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"lNP", "[", "b", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"nNP", "[", 
     RowBox[{"-", "a"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"nNP", "[", "b", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"mNP", "[", 
     RowBox[{"-", "a"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"mNP", "[", "b", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"mNP\[Dagger]", "[", 
     RowBox[{"-", "a"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"mNP\[Dagger]", "[", "b", "]"}]}]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"l", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`lNP[$CellContext`b],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"n", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`nNP[$CellContext`b],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[$CellContext`b],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["m", "_"], 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP\[Dagger][$CellContext`b],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "NP", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{-$CellContext`a, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {-$CellContext`b, \
-$CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"l", 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`lNP[{$CellContext`b, $CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{-$CellContext`a, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {-$CellContext`b, \
-$CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"n", 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`nNP[{$CellContext`b, $CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{-$CellContext`a, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {-$CellContext`b, \
-$CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[{$CellContext`b, $CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{-$CellContext`a, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {-$CellContext`b, \
-$CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["m", "_"], 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP\[Dagger][{$CellContext`b, $CellContext`NP}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"TraceBasisDummy", ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{-$CellContext`a, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        1, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"l", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`lNP[{1, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        2, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"l", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`lNP[{2, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        3, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"l", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`lNP[{3, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        4, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"l", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`lNP[{4, $CellContext`NP}],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{-$CellContext`a, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        1, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"n", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`nNP[{1, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        2, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"n", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`nNP[{2, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        3, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"n", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`nNP[{3, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        4, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"n", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`nNP[{4, $CellContext`NP}],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{-$CellContext`a, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        1, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"m", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP[{1, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        2, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"m", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP[{2, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        3, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"m", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP[{3, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        4, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"m", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP[{4, $CellContext`NP}],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{-$CellContext`a, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        1, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["m", "_"], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP\[Dagger][{1, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        2, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["m", "_"], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP\[Dagger][{2, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        3, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["m", "_"], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP\[Dagger][{3, $CellContext`NP}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["a",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[{-$CellContext`a, -$CellContext`NP}, {
        4, -$CellContext`NP}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["m", "_"], 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP\[Dagger][{4, $CellContext`NP}],
       Editable->False]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToValues", "@", 
  RowBox[{"Flatten", "@", 
   RowBox[{"ComponentArray", "@", "%"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{1, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{2, -$CellContext`NP}],
     Editable->False], "\[Equal]", "1"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{3, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{4, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{1, -$CellContext`NP}],
     Editable->False], "\[Equal]", "1"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{2, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{3, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{4, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{1, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{2, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{3, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{4, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{1, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{2, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{3, -$CellContext`NP}],
     Editable->False], "\[Equal]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{4, -$CellContext`NP}],
     Editable->False], "\[Equal]", "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"Equal", "\[Rule]", "ComponentValue"}]}], ";"}]], "Input"],

Cell["\<\
Automatic replacement of the values of the components of the elements of the \
null tetrad.\
\>", "MathCaption"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RuleToSet", "/@", 
   RowBox[{"{", 
    RowBox[{"lNP", ",", "nNP", ",", "mNP", ",", "mNP\[Dagger]"}], "}"}]}], 
  ";"}]], "Input"],

Cell[TextData[{
 "It is convenient to have a rule which relates  ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["l", " ", "a"],
    AutoSpacing->False],
   $CellContext`lNP[$CellContext`a],
   Editable->False]], "Output",
  CellChangeTimes->{3.443600000373357*^9, 3.443600614034006*^9, 
   3.44360110601153*^9, 3.4444578983998013`*^9, 3.444971906279531*^9, 
   3.4450800572925777`*^9, 3.445238951063208*^9, 3.44523920656565*^9, 
   3.447147750178196*^9, 3.447148302618504*^9, 3.4471593828182697`*^9, 
   3.447998369063972*^9, 3.448171329884437*^9, 3.448271854453495*^9, 
   3.448341708076147*^9, 3.449288679662628*^9, 3.449816979737742*^9, 
   3.4504101371642933`*^9, 3.450417087980618*^9, 3.4518175014621572`*^9, 
   3.452242362453743*^9, 3.4524082882882566`*^9, 3.45724482695157*^9}],
 ",  ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["n", " ", "a"],
    AutoSpacing->False],
   $CellContext`nNP[$CellContext`a],
   Editable->False]], "Output",
  CellChangeTimes->{3.443600000373357*^9, 3.443600614034006*^9, 
   3.44360110601153*^9, 3.4444578983998013`*^9, 3.444971906279531*^9, 
   3.4450800572925777`*^9, 3.445238951063208*^9, 3.44523920656565*^9, 
   3.447147750178196*^9, 3.447148302618504*^9, 3.4471593828182697`*^9, 
   3.447998369063972*^9, 3.448171329884437*^9, 3.448271854453495*^9, 
   3.448341708076147*^9, 3.449288679662628*^9, 3.449816979737742*^9, 
   3.4504101371642933`*^9, 3.450417087980618*^9, 3.4518175014621572`*^9, 
   3.452242362453743*^9, 3.4524082882882566`*^9, 3.45724482695157*^9}],
 ",  ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["m", " ", "a"],
    AutoSpacing->False],
   $CellContext`mNP[$CellContext`a],
   Editable->False]], "Output",
  CellChangeTimes->{3.443600000373357*^9, 3.443600614034006*^9, 
   3.44360110601153*^9, 3.4444578983998013`*^9, 3.444971906279531*^9, 
   3.4450800572925777`*^9, 3.445238951063208*^9, 3.44523920656565*^9, 
   3.447147750178196*^9, 3.447148302618504*^9, 3.4471593828182697`*^9, 
   3.447998369063972*^9, 3.448171329884437*^9, 3.448271854453495*^9, 
   3.448341708076147*^9, 3.449288679662628*^9, 3.449816979737742*^9, 
   3.4504101371642933`*^9, 3.450417087980618*^9, 3.4518175014621572`*^9, 
   3.452242362453743*^9, 3.4524082882882566`*^9, 3.45724482695157*^9}],
 ",  ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     OverscriptBox["m", "_"], " ", "a"],
    AutoSpacing->False],
   $CellContext`mNP\[Dagger][$CellContext`a],
   Editable->False]], "Output",
  CellChangeTimes->{3.443600000373357*^9, 3.443600614034006*^9, 
   3.44360110601153*^9, 3.4444578983998013`*^9, 3.444971906279531*^9, 
   3.4450800572925777`*^9, 3.445238951063208*^9, 3.44523920656565*^9, 
   3.447147750178196*^9, 3.447148302618504*^9, 3.4471593828182697`*^9, 
   3.447998369063972*^9, 3.448171329884437*^9, 3.448271854453495*^9, 
   3.448341708076147*^9, 3.449288679662628*^9, 3.449816979737742*^9, 
   3.4504101371642933`*^9, 3.450417087980618*^9, 3.4518175014621572`*^9, 
   3.452242362453743*^9, 3.4524082882882566`*^9, 3.45724482695157*^9}],
 " and the elements of the basis ",
 StyleBox["NP", "Output"],
 ". We compute such a rule next."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"lNP", "[", "a", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"SeparateBasis", "[", "NP", "]"}], "@", 
     RowBox[{"lNP", "[", "a", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"nNP", "[", "a", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"SeparateBasis", "[", "NP", "]"}], "@", 
     RowBox[{"nNP", "[", "a", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"mNP", "[", "a", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"SeparateBasis", "[", "NP", "]"}], "@", 
     RowBox[{"mNP", "[", "a", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"mNP\[Dagger]", "[", "a", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"SeparateBasis", "[", "NP", "]"}], "@", 
     RowBox[{"mNP\[Dagger]", "[", "a", "]"}]}]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "a"},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`NP}, $CellContext`a],
      
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"l", 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`lNP[{$CellContext`b, $CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "a"},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`NP}, $CellContext`a],
      
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"n", 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`nNP[{$CellContext`b, $CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "a"},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`NP}, $CellContext`a],
      
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[{$CellContext`b, $CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "a"},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`NP}, $CellContext`a],
      
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["m", "_"], 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP\[Dagger][{$CellContext`b, $CellContext`NP}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"TraceBasisDummy", ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{1, -$CellContext`NP}, $CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{2, -$CellContext`NP}, $CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{3, -$CellContext`NP}, $CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{4, -$CellContext`NP}, $CellContext`a],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{"%", ",", 
    RowBox[{"Cases", "[", 
     RowBox[{"%", ",", 
      RowBox[{"Basis", "[", 
       RowBox[{
        RowBox[{"{", "__", "}"}], ",", "a_"}], "]"}], ",", "Infinity"}], 
     "]"}]}], "]"}], "//", "Flatten"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{1, -$CellContext`NP}, $CellContext`a],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{2, -$CellContext`NP}, $CellContext`a],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{3, -$CellContext`NP}, $CellContext`a],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{4, -$CellContext`NP}, $CellContext`a],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][$CellContext`a],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{
     RowBox[{"HoldPattern", "@", 
      RowBox[{"Rule", "[", 
       RowBox[{"X_", ",", "Y_"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{"MakeRule", "[", 
      RowBox[{"{", 
       RowBox[{"X", ",", "Y"}], "}"}], "]"}]}]}], "//", "Flatten"}], "//", 
  "Union"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{1, -$CellContext`NP}, 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"l", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`lNP[$CellContext`a],
       Editable->False]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{2, -$CellContext`NP}, 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"n", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`nNP[$CellContext`a],
       Editable->False]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{3, -$CellContext`NP}, 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"m", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP[$CellContext`a],
       Editable->False]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{4, -$CellContext`NP}, 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["m", "_"], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP\[Dagger][$CellContext`a],
       Editable->False]}], "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisToVectors", "=", "%"}], ";"}]], "Input"],

Cell["We need the same rule with the indices downstairs.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"lNP", "[", 
     RowBox[{"-", "a"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"SeparateBasis", "[", "NP", "]"}], "@", 
     RowBox[{"lNP", "[", 
      RowBox[{"-", "a"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"nNP", "[", 
     RowBox[{"-", "a"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"SeparateBasis", "[", "NP", "]"}], "@", 
     RowBox[{"nNP", "[", 
      RowBox[{"-", "a"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"mNP", "[", 
     RowBox[{"-", "a"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"SeparateBasis", "[", "NP", "]"}], "@", 
     RowBox[{"mNP", "[", 
      RowBox[{"-", "a"}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"mNP\[Dagger]", "[", 
     RowBox[{"-", "a"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"SeparateBasis", "[", "NP", "]"}], "@", 
     RowBox[{"mNP\[Dagger]", "[", 
      RowBox[{"-", "a"}], "]"}]}]}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`a, {$CellContext`b, $CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"l", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`lNP[{-$CellContext`b, -$CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`a, {$CellContext`b, $CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"n", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`nNP[{-$CellContext`b, -$CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`a, {$CellContext`b, $CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[{-$CellContext`b, -$CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`a, {$CellContext`b, $CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["m", "_"], 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP\[Dagger][{-$CellContext`b, -$CellContext`NP}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"TraceBasisDummy", ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[-$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[-$CellContext`a],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]]},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`a, {4, $CellContext`NP}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][-$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]]},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`a, {3, $CellContext`NP}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{"%", ",", 
    RowBox[{"Cases", "[", 
     RowBox[{"%", ",", 
      RowBox[{"Basis", "[", "__", "]"}], ",", "Infinity"}], "]"}]}], "]"}], "//",
   "Flatten"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`NP}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[-$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`NP}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[-$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]]},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[-$CellContext`a, {4, $CellContext`NP}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[-$CellContext`a],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[-$CellContext`a, {3, $CellContext`NP}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["m", "_"], 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP\[Dagger][-$CellContext`a],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{
     RowBox[{"HoldPattern", "@", 
      RowBox[{"Rule", "[", 
       RowBox[{"X_", ",", "Y_"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{"MakeRule", "[", 
      RowBox[{"{", 
       RowBox[{"X", ",", "Y"}], "}"}], "]"}]}]}], "//", "Flatten"}], "//", 
  "Union"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ], {1, $CellContext`NP}],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"n", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`nNP[$CellContext`a],
       Editable->False]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ], {2, $CellContext`NP}],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"l", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`lNP[$CellContext`a],
       Editable->False]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ], {3, $CellContext`NP}],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            OverscriptBox["m", "_"], 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`mNP\[Dagger][$CellContext`a],
        Editable->False]}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ], {4, $CellContext`NP}],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"m", 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`mNP[$CellContext`a],
        Editable->False]}]}], "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
We combine these relations with the relations found above for the indices \
upstairs.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"BasisToVectors", ",", "%"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{1, -$CellContext`NP}, 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"l", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`lNP[$CellContext`a],
       Editable->False]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{2, -$CellContext`NP}, 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"n", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`nNP[$CellContext`a],
       Editable->False]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{3, -$CellContext`NP}, 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"m", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP[$CellContext`a],
       Editable->False]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{4, -$CellContext`NP}, 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM4`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["m", "_"], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`mNP\[Dagger][$CellContext`a],
       Editable->False]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {
                UnderscriptBox[
                 UnderscriptBox["a", "_"], "_"], 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[
         PatternTest[
          Pattern[$CellContext`a, 
           Blank[]], TangentM4`pmQ], {1, $CellContext`NP}],
        Editable->False], "]"}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"n", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`nNP[$CellContext`a],
         Editable->False]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {
                UnderscriptBox[
                 UnderscriptBox["a", "_"], "_"], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[
         PatternTest[
          Pattern[$CellContext`a, 
           Blank[]], TangentM4`pmQ], {2, $CellContext`NP}],
        Editable->False], "]"}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"l", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`lNP[$CellContext`a],
         Editable->False]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {
                UnderscriptBox[
                 UnderscriptBox["a", "_"], "_"], 
                StyleBox["3",
                 FontColor->RGBColor[0., 0., 1.]]},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[
         PatternTest[
          Pattern[$CellContext`a, 
           Blank[]], TangentM4`pmQ], {3, $CellContext`NP}],
        Editable->False], "]"}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              OverscriptBox["m", "_"], 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`mNP\[Dagger][$CellContext`a],
          Editable->False]}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {
                UnderscriptBox[
                 UnderscriptBox["a", "_"], "_"], 
                StyleBox["4",
                 FontColor->RGBColor[0., 0., 1.]]},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[
         PatternTest[
          Pattern[$CellContext`a, 
           Blank[]], TangentM4`pmQ], {4, $CellContext`NP}],
        Editable->False], "]"}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"m", 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`mNP[$CellContext`a],
          Editable->False]}]}], "]"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Relation between the spin dyad and the null tetrad", "Subsubsection"],

Cell["\<\
The relation between the elements of the spinor dyad and the elements of the \
null tetrad is as follows\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinDyadToNullTetrad", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Sigma]", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
      RowBox[{"o", "[", "A", "]"}], 
      RowBox[{"Dagger", "@", 
       RowBox[{"o", "[", "A", "]"}]}]}], "\[Equal]", 
     RowBox[{"lNP", "[", "a", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Sigma]", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
      RowBox[{"\[Iota]", "[", "A", "]"}], 
      RowBox[{"Dagger", "@", 
       RowBox[{"\[Iota]", "[", "A", "]"}]}]}], "\[Equal]", 
     RowBox[{"nNP", "[", "a", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Sigma]", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
      RowBox[{"o", "[", "A", "]"}], 
      RowBox[{"Dagger", "@", 
       RowBox[{"\[Iota]", "[", "A", "]"}]}]}], "\[Equal]", 
     RowBox[{"mNP", "[", "a", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Sigma]", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
      RowBox[{"Dagger", "[", 
       RowBox[{
        RowBox[{"o", "[", "A", "]"}], 
        RowBox[{"Dagger", "@", 
         RowBox[{"\[Iota]", "[", "A", "]"}]}]}], "]"}]}], "\[Equal]", 
     RowBox[{"mNP\[Dagger]", "[", "a", "]"}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[$CellContext`A],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", "A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][$CellContext`A],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", "A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[$CellContext`A],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", "A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][$CellContext`A],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", "A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][$CellContext`a],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Using this relation we find and store the components of the soldering form ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Sigma]", 
     RowBox[{" ", 
      RowBox[{"AA", "'"}]}], 
     RowBox[{"a", "   "}]],
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False]], "Output",
  CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBuL7Enb/kha/dGRhcdFJAdKPpmr76S556Vj9wioeRCeb
z54SAaTD/u3wbgHSXYJue3YC6Se2Dv9BtLCrw6UDQHrSRZnLMcteOj7QKttf
AaRDX/2+CKKPvRZ/UQOkaw5tKaoD0ttiol41A+k2KdHWC0B6gg0DX9nyl44H
plYdaADSTh/2Mi4B0ixrWuwYV7x09HI9c1AVSJvFxN8C0eFv0k1PrHzpeEor
xeDwqpeOAVLO/78DaXmBP1NcV7905P/7eguI9vvwcs7LdS8dN/G9ewiiHZ4b
er8H0to5Nl86Nrx0fJ+cknEXSPf5P6/l2/jSsSd2xUwDIP0lRvfvv00vHb8/
X/GJYctLx9/rbCcrbX3peC1I6ocqkJ5Rc/zwxe0vHRluZpgv3PHS0e2Rms0n
IP1Suuei7iGgvsir2duBNADncb9o
   "]],
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, {-$CellContext`A, \
-$CellContext`Dyad}, -$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, {-$CellContext`A, \
-$CellContext`Dyad}, -$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, {-$CellContext`A, \
-$CellContext`Dyad}, -$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, {-$CellContext`A, \
-$CellContext`Dyad}, -$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][$CellContext`a],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad\[Dagger]", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, {-$CellContext`A, \
-$CellContext`Dyad}, {-$CellContext`A\[Dagger], -$CellContext`Dyad\[Dagger]}],
      
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, {-$CellContext`A, \
-$CellContext`Dyad}, {-$CellContext`A\[Dagger], -$CellContext`Dyad\[Dagger]}],
      
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, {-$CellContext`A, \
-$CellContext`Dyad}, {-$CellContext`A\[Dagger], -$CellContext`Dyad\[Dagger]}],
      
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, {-$CellContext`A, \
-$CellContext`Dyad}, {-$CellContext`A\[Dagger], -$CellContext`Dyad\[Dagger]}],
      
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][$CellContext`a],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "NP", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{$CellContext`a, $CellContext`NP}, \
{-$CellContext`A, -$CellContext`Dyad}, {-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{$CellContext`a, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{$CellContext`a, $CellContext`NP}, \
{-$CellContext`A, -$CellContext`Dyad}, {-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{$CellContext`a, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{$CellContext`a, $CellContext`NP}, \
{-$CellContext`A, -$CellContext`Dyad}, {-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{$CellContext`a, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " ", " "},
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{$CellContext`a, $CellContext`NP}, \
{-$CellContext`A, -$CellContext`Dyad}, {-$CellContext`A\[Dagger], \
-$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{$CellContext`a, $CellContext`NP}],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"TraceBasisDummy", ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]], " ", " "},
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{$CellContext`a, $CellContext`NP}, {
      0, -$CellContext`Dyad}, {0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"l", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`lNP[{$CellContext`a, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]], " ", " "},
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{$CellContext`a, $CellContext`NP}, {
      1, -$CellContext`Dyad}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"n", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nNP[{$CellContext`a, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]], " ", " "},
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{$CellContext`a, $CellContext`NP}, {
      0, -$CellContext`Dyad}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"m", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP[{$CellContext`a, $CellContext`NP}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]], " ", " "},
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{$CellContext`a, $CellContext`NP}, {
      1, -$CellContext`Dyad}, {0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["m", "_"], 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`mNP\[Dagger][{$CellContext`a, $CellContext`NP}],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentArray", "@", "%"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{1, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{2, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{3, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{4, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{1, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{2, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{3, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{4, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{1, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{2, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{3, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> 
           {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{4, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{1, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{2, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{3, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{4, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Equal]", "1"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"Equal", "\[Rule]", "ComponentValue"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{1, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{2, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{3, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{4, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{1, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{2, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{3, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{4, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{1, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{2, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{3, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"1", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{4, $CellContext`NP}, {0, -$CellContext`Dyad}, {
        1, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{1, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{2, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{3, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox[
                RowBox[{"0", "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][{4, $CellContext`NP}, {1, -$CellContext`Dyad}, {
        0, -$CellContext`Dyad\[Dagger]}],
       Editable->False], "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
We also need the components of the soldering form with the spacetime index \
downstairs and the spin indices upstairs.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullTetradToSpinDyad", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{"PutSolderingForm", ",", "SpinDyadToNullTetrad", ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], "/.", 
    RowBox[{"B", "->", "A"}]}], "/.", 
   RowBox[{"B\[Dagger]", "->", "A\[Dagger]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[$CellContext`A],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"l", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`lNP[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", "A", 
              RowBox[{"A", "'"}]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][$CellContext`A],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"n", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`nNP[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", "A", 
              RowBox[{"A", "'"}]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[$CellContext`A],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", "A", 
              RowBox[{"A", "'"}]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {"A"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][$CellContext`A],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["m", "_"], 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP\[Dagger][$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", "A", 
              RowBox[{"A", "'"}]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"l", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`lNP[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              RowBox[{"A", "'"}]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, {$CellContext`A, \
$CellContext`Dyad}, $CellContext`A\[Dagger]],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"n", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`nNP[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              RowBox[{"A", "'"}]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, {$CellContext`A, \
$CellContext`Dyad}, $CellContext`A\[Dagger]],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][$CellContext`A\[Dagger]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              RowBox[{"A", "'"}]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, {$CellContext`A, \
$CellContext`Dyad}, $CellContext`A\[Dagger]],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              RowBox[{"A", "'"}]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][$CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["m", "_"], 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP\[Dagger][$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              RowBox[{"A", "'"}]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, {$CellContext`A, \
$CellContext`Dyad}, $CellContext`A\[Dagger]],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad\[Dagger]", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"l", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`lNP[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, {$CellContext`A, \
$CellContext`Dyad}, {$CellContext`A\[Dagger], $CellContext`Dyad\[Dagger]}],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"n", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`nNP[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, {$CellContext`A, \
$CellContext`Dyad}, {$CellContext`A\[Dagger], $CellContext`Dyad\[Dagger]}],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, {$CellContext`A, \
$CellContext`Dyad}, {$CellContext`A\[Dagger], $CellContext`Dyad\[Dagger]}],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["m", "_"], 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP\[Dagger][$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, {$CellContext`A, \
$CellContext`Dyad}, {$CellContext`A\[Dagger], $CellContext`Dyad\[Dagger]}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "NP", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"l", 
          StyleBox[GridBox[{
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`lNP[{$CellContext`a, $CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{-$CellContext`a, -$CellContext`NP}, \
{$CellContext`A, $CellContext`Dyad}, {$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"n", 
          StyleBox[GridBox[{
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`nNP[{$CellContext`a, $CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{-$CellContext`a, -$CellContext`NP}, \
{$CellContext`A, $CellContext`Dyad}, {$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"m", 
          StyleBox[GridBox[{
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP[{$CellContext`a, $CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{-$CellContext`a, -$CellContext`NP}, \
{$CellContext`A, $CellContext`Dyad}, {$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["m", "_"], 
          StyleBox[GridBox[{
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mNP\[Dagger][{$CellContext`a, $CellContext`NP}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{-$CellContext`a, -$CellContext`NP}, \
{$CellContext`A, $CellContext`Dyad}, {$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"TraceBasisDummy", ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{
      1, -$CellContext`NP}, {$CellContext`A, $CellContext`Dyad}, \
{$CellContext`A\[Dagger], $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{
      2, -$CellContext`NP}, {$CellContext`A, $CellContext`Dyad}, \
{$CellContext`A\[Dagger], $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o[{$CellContext`A, $CellContext`Dyad}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Iota]", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota]\[Dagger][{$CellContext`A\[Dagger], \
$CellContext`Dyad\[Dagger]}],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{
      3, -$CellContext`NP}, {$CellContext`A, $CellContext`Dyad}, \
{$CellContext`A\[Dagger], $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["o", "__"], 
          StyleBox[GridBox[{
             {
              StyleBox[
               RowBox[{"A", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`o\[Dagger][{$CellContext`A\[Dagger], $CellContext`Dyad\
\[Dagger]}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Iota][{$CellContext`A, $CellContext`Dyad}],
      Editable->False]}], "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["A",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"A", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{
      4, -$CellContext`NP}, {$CellContext`A, $CellContext`Dyad}, \
{$CellContext`A\[Dagger], $CellContext`Dyad\[Dagger]}],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "@", 
  RowBox[{"ComponentArray", "@", "%"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{1, -$CellContext`NP}, {0, $CellContext`Dyad}, {
      0, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{1, -$CellContext`NP}, {0, $CellContext`Dyad}, {
      1, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{1, -$CellContext`NP}, {1, $CellContext`Dyad}, {
      0, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{1, -$CellContext`NP}, {1, $CellContext`Dyad}, {
      1, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{2, -$CellContext`NP}, {0, $CellContext`Dyad}, {
      0, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{2, -$CellContext`NP}, {0, $CellContext`Dyad}, {
      1, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{2, -$CellContext`NP}, {1, $CellContext`Dyad}, {
      0, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"1", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{2, -$CellContext`NP}, {1, $CellContext`Dyad}, {
      1, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{3, -$CellContext`NP}, {0, $CellContext`Dyad}, {
      0, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"1", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{3, -$CellContext`NP}, {0, $CellContext`Dyad}, {
      1, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{3, -$CellContext`NP}, {1, $CellContext`Dyad}, {
      0, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{3, -$CellContext`NP}, {1, $CellContext`Dyad}, {
      1, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{4, -$CellContext`NP}, {0, $CellContext`Dyad}, {
      0, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{4, -$CellContext`NP}, {0, $CellContext`Dyad}, {
      1, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"1", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"0", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{4, -$CellContext`NP}, {1, $CellContext`Dyad}, {
      0, $CellContext`Dyad\[Dagger]}],
     Editable->False]}], ",", 
   RowBox[{"0", "\[Equal]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox[
              RowBox[{"1", "'"}],
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["4",
              FontColor->RGBColor[0., 0., 1.]], " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][{4, -$CellContext`NP}, {1, $CellContext`Dyad}, {
      1, $CellContext`Dyad\[Dagger]}],
     Editable->False]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Cases", "[", 
    RowBox[{"%", ",", "_\[Sigma]", ",", "Infinity"}], "]"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{1, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "1"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{1, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{1, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{1, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{2, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{2, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{2, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{2, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "1"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{3, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{3, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "1"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{3, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{3, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{4, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{4, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{4, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "1"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{4, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["We store these values.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"Rule", "\[Rule]", "ComponentValue"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{1, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "1"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{1, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{1, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{1, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{2, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{2, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{2, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{2, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "1"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{3, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{3, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "1"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{3, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{3, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{4, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{4, -$CellContext`NP}, {0, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"0", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{4, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       0, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "1"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox[
               RowBox[{"1", "'"}],
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]], " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][{4, -$CellContext`NP}, {1, $CellContext`Dyad}, {
       1, $CellContext`Dyad\[Dagger]}],
      Editable->False], "\[Rule]", "0"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Change of the ",
 StyleBox["Rule", "Output"],
 " assignment to the ",
 StyleBox["Set", "Output"],
 " assignment in the folded rule."
}], "MathCaption"],

Cell[BoxData[
 RowBox[{"RuleToSet", "@", "\[Sigma]"}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Newman-Penrose spin coefficients", "Subsubsection"],

Cell["\<\
 We define the 12 Newmann-Penrose spin coefficients, and their complex \
conjugates:\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Kappa]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Kappa]Dyad", "]"}], "^=", "\"\<\[Kappa]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Kappa]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Kappa]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Kappa]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Kappa]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Epsilon]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Epsilon]Dyad", "]"}], "^=", 
   "\"\<\[Epsilon]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Epsilon]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Epsilon]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Epsilon]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Epsilon]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Pi]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Pi]Dyad", "]"}], "^=", "\"\<\[Pi]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Pi]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Pi]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Pi]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Pi]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Pi]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Pi]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Tau]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Tau]Dyad", "]"}], "^=", "\"\<\[Tau]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Tau]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Tau]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Tau]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Tau]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Tau]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Tau]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Gamma]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Gamma]Dyad", "]"}], "^=", "\"\<\[Gamma]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Gamma]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Gamma]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Gamma]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Gamma]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Gamma]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Gamma]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Nu]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Nu]Dyad", "]"}], "^=", "\"\<\[Nu]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Nu]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Nu]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Nu]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Nu]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Nu]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Nu]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Sigma]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Sigma]Dyad", "]"}], "^=", "\"\<\[Sigma]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Sigma]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Sigma]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Sigma]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Sigma]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Beta]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Beta]Dyad", "]"}], "^=", "\"\<\[Beta]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Beta]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Beta]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Beta]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Beta]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Beta]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Mu]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Mu]Dyad", "]"}], "^=", "\"\<\[Mu]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Mu]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Mu]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Mu]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Mu]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Mu]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Mu]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Rho]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Rho]Dyad", "]"}], "^=", "\"\<\[Rho]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Rho]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Rho]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Rho]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Rho]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Rho]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Rho]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Alpha]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Alpha]Dyad", "]"}], "^=", "\"\<\[Alpha]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Alpha]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Alpha]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Alpha]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Alpha]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Alpha]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Alpha]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"\[Lambda]Dyad", "[", "]"}], ",", "M4"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Lambda]Dyad", "]"}], "^=", 
   "\"\<\[Lambda]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "\[Lambda]Dyad\[Dagger]", "]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Lambda]\), \(_\)]\)\>\""}], ";"}]}], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Lambda]Dyad", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Lambda]Dyad[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Lambda]Dyad\[Dagger]", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Lambda]Dyad\[Dagger][], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell["This is full the list of Newman-Penrose spin coefficients.", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NPSpinCoefficients", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Beta]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Gamma]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Epsilon]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Kappa]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Lambda]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Mu]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Nu]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Pi]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Rho]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Sigma]Dyad", "[", "]"}], ",", 
    RowBox[{"\[Tau]Dyad", "[", "]"}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Alpha]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Alpha]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Beta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Beta]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Gamma]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Gamma]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Epsilon]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Lambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Lambda]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Mu]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Mu]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Nu]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Nu]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Pi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Pi]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Rho]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Rho]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Sigma]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma]Dyad[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Tau]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau]Dyad[],
    Editable->False]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Length"}]], "Input"],

Cell[BoxData["12"], "Output"]
}, Open  ]],

Cell["\<\
The spin coefficients are defined through the derivations of the elements of \
the spin tetrad by means of the following relations.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DyadDerivatives", "=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", 
      RowBox[{"o", "[", 
       RowBox[{"-", "A"}], "]"}], "]"}], "\[Equal]", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"o", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Epsilon]Dyad", "[", "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Iota]", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Kappa]Dyad", "[", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", 
      RowBox[{"\[Iota]", "[", 
       RowBox[{"-", "A"}], "]"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"\[Iota]", "[", 
         RowBox[{"-", "A"}], "]"}]}], 
       RowBox[{"\[Epsilon]Dyad", "[", "]"}]}], "+", 
      RowBox[{
       RowBox[{"o", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Pi]Dyad", "[", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", 
      RowBox[{"o", "[", 
       RowBox[{"-", "A"}], "]"}], "]"}], "\[Equal]", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"o", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Gamma]Dyad", "[", "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Iota]", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Tau]Dyad", "[", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", 
      RowBox[{"\[Iota]", "[", 
       RowBox[{"-", "A"}], "]"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"\[Iota]", "[", 
         RowBox[{"-", "A"}], "]"}]}], 
       RowBox[{"\[Gamma]Dyad", "[", "]"}]}], "+", 
      RowBox[{
       RowBox[{"o", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Nu]Dyad", "[", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", 
      RowBox[{"o", "[", 
       RowBox[{"-", "A"}], "]"}], "]"}], "\[Equal]", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"o", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Beta]Dyad", "[", "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Iota]", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Sigma]Dyad", "[", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", 
      RowBox[{"\[Iota]", "[", 
       RowBox[{"-", "A"}], "]"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"\[Iota]", "[", 
         RowBox[{"-", "A"}], "]"}]}], 
       RowBox[{"\[Beta]Dyad", "[", "]"}]}], "+", 
      RowBox[{
       RowBox[{"o", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Mu]Dyad", "[", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", 
         RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", 
      RowBox[{"o", "[", 
       RowBox[{"-", "A"}], "]"}], "]"}], "\[Equal]", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"o", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Alpha]Dyad", "[", "]"}]}], "-", 
      RowBox[{
       RowBox[{"\[Iota]", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Rho]Dyad", "[", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", 
         RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", 
      RowBox[{"\[Iota]", "[", 
       RowBox[{"-", "A"}], "]"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"\[Iota]", "[", 
         RowBox[{"-", "A"}], "]"}]}], 
       RowBox[{"\[Alpha]Dyad", "[", "]"}]}], "+", 
      RowBox[{
       RowBox[{"o", "[", 
        RowBox[{"-", "A"}], "]"}], 
       RowBox[{"\[Lambda]Dyad", "[", "]"}]}]}]}]}], "\[IndentingNewLine]", 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"D", GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {" "},
             {"A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[{1, -$CellContext`NP}][
      $CellContext`o[-$CellContext`A]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Epsilon]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Kappa]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"D", GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {" "},
             {"A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[{1, -$CellContext`NP}][
      $CellContext`\[Iota][-$CellContext`A]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Epsilon]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Epsilon]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][-$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Pi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Pi]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"\[CapitalDelta]", GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {" "},
             {"A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[{2, -$CellContext`NP}][
      $CellContext`o[-$CellContext`A]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Gamma]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Gamma]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"\[CapitalDelta]", GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {" "},
             {"A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[{2, -$CellContext`NP}][
      $CellContext`\[Iota][-$CellContext`A]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Gamma]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Gamma]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][-$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Nu]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Nu]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Delta]", GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {" "},
             {"A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[{3, -$CellContext`NP}][
      $CellContext`o[-$CellContext`A]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Beta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Beta]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Sigma]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Delta]", GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {" "},
             {"A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[{3, -$CellContext`NP}][
      $CellContext`\[Iota][-$CellContext`A]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Beta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Beta]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][-$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Mu]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Mu]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Delta]", "_"], GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {" "},
             {"A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[{4, -$CellContext`NP}][
      $CellContext`o[-$CellContext`A]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Alpha]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Alpha]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Delta]", "_"], GridBox[{
         {"\[Iota]", 
          StyleBox[GridBox[{
             {" "},
             {"A"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[{4, -$CellContext`NP}][
      $CellContext`\[Iota][-$CellContext`A]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Alpha]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Alpha]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][-$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {"A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[-$CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Lambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Lambda]Dyad[],
       Editable->False]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
 "From this expression we compute and store the components of the spin \
covariant derivative \"intrinsic\" connection (these are the components of \
the \"inner\" Christoffel symbols of the covariant derivative ",
 StyleBox["CDe", "Output"],
 "). "
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "B"},
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`A, -$CellContext`Dyad}, \
$CellContext`B],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{"D", GridBox[{
           {"o", 
            StyleBox[GridBox[{
               {" "},
               {"B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[{1, -$CellContext`NP}][
        $CellContext`o[-$CellContext`B]],
       Editable->False], ")"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Epsilon]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Kappa]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "B"},
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`A, -$CellContext`Dyad}, \
$CellContext`B],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{"D", GridBox[{
           {"\[Iota]", 
            StyleBox[GridBox[{
               {" "},
               {"B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[{1, -$CellContext`NP}][
        $CellContext`\[Iota][-$CellContext`B]],
       Editable->False], ")"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Epsilon]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Epsilon]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Pi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Pi]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "B"},
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`A, -$CellContext`Dyad}, \
$CellContext`B],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[CapitalDelta]", GridBox[{
           {"o", 
            StyleBox[GridBox[{
               {" "},
               {"B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[{2, -$CellContext`NP}][
        $CellContext`o[-$CellContext`B]],
       Editable->False], ")"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Gamma]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Gamma]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "B"},
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`A, -$CellContext`Dyad}, \
$CellContext`B],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[CapitalDelta]", GridBox[{
           {"\[Iota]", 
            StyleBox[GridBox[{
               {" "},
               {"B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[{2, -$CellContext`NP}][
        $CellContext`\[Iota][-$CellContext`B]],
       Editable->False], ")"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Gamma]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Gamma]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Nu]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Nu]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "B"},
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`A, -$CellContext`Dyad}, \
$CellContext`B],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[Delta]", GridBox[{
           {"o", 
            StyleBox[GridBox[{
               {" "},
               {"B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[{3, -$CellContext`NP}][
        $CellContext`o[-$CellContext`B]],
       Editable->False], ")"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Beta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Beta]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Sigma]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "B"},
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`A, -$CellContext`Dyad}, \
$CellContext`B],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[Delta]", GridBox[{
           {"\[Iota]", 
            StyleBox[GridBox[{
               {" "},
               {"B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[{3, -$CellContext`NP}][
        $CellContext`\[Iota][-$CellContext`B]],
       Editable->False], ")"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Beta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Beta]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Mu]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Mu]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "B"},
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`A, -$CellContext`Dyad}, \
$CellContext`B],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Delta]", "_"], GridBox[{
           {"o", 
            StyleBox[GridBox[{
               {" "},
               {"B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[{4, -$CellContext`NP}][
        $CellContext`o[-$CellContext`B]],
       Editable->False], ")"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Alpha]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Alpha]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "B"},
             {
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`A, -$CellContext`Dyad}, \
$CellContext`B],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Delta]", "_"], GridBox[{
           {"\[Iota]", 
            StyleBox[GridBox[{
               {" "},
               {"B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[{4, -$CellContext`NP}][
        $CellContext`\[Iota][-$CellContext`B]],
       Editable->False], ")"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Alpha]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Alpha]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Lambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Lambda]Dyad[],
       Editable->False]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"ToBasis", "[", "Dyad", "]"}], ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCDePDDyad", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`AChristoffelCDePDDyad[$CellContext`A, -$CellContext`b, -C], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCDePDDyad\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`AChristoffelCDePDDyad\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"A", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["B",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["A",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`AChristoffelCDePDDyad[{$CellContext`B, \
$CellContext`Dyad}, {
         1, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["B",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`B, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"D", GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{1, -$CellContext`NP}][
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Epsilon]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Kappa]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"A", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["B",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["A",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`AChristoffelCDePDDyad[{$CellContext`B, \
$CellContext`Dyad}, {
         1, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["B",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`B, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"D", GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{1, -$CellContext`NP}][
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Epsilon]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Epsilon]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Pi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Pi]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"A", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["B",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["A",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`AChristoffelCDePDDyad[{$CellContext`B, \
$CellContext`Dyad}, {
         2, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["B",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`B, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[CapitalDelta]", GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{2, -$CellContext`NP}][
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Gamma]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Gamma]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"A", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["B",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["A",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`AChristoffelCDePDDyad[{$CellContext`B, \
$CellContext`Dyad}, {
         2, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["B",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`B, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[CapitalDelta]", GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{2, -$CellContext`NP}][
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Gamma]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Gamma]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Nu]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Nu]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"A", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["B",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["3",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["A",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`AChristoffelCDePDDyad[{$CellContext`B, \
$CellContext`Dyad}, {
         3, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["B",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`B, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Delta]", GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{3, -$CellContext`NP}][
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Beta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Beta]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Sigma]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"A", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["B",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["3",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["A",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`AChristoffelCDePDDyad[{$CellContext`B, \
$CellContext`Dyad}, {
         3, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["B",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`B, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Delta]", GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{3, -$CellContext`NP}][
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Beta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Beta]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Mu]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Mu]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"A", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["B",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["4",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["A",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`AChristoffelCDePDDyad[{$CellContext`B, \
$CellContext`Dyad}, {
         4, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["B",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`B, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Delta]", "_"], GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{4, -$CellContext`NP}][
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Alpha]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Alpha]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"A", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["B",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["4",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["A",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`AChristoffelCDePDDyad[{$CellContext`B, \
$CellContext`Dyad}, {
         4, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["B",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`B, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Delta]", "_"], GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{4, -$CellContext`NP}][
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Alpha]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Alpha]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Lambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Lambda]Dyad[],
       Editable->False]}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"TraceBasisDummy", ",", "%", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`AChristoffelCDePDDyad[{1, $CellContext`Dyad}, {
        1, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"D", GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{1, -$CellContext`NP}][
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Epsilon]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Kappa]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"A", "[", 
           RowBox[{"\[EmptyDownTriangle]", ",", 
            StyleBox["\[ScriptCapitalD]",
             FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
          StyleBox[GridBox[{
             {
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], " ", " "},
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`AChristoffelCDePDDyad[{0, $CellContext`Dyad}, {
       1, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"D", GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{1, -$CellContext`NP}][
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Epsilon]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Epsilon]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Pi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Pi]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`AChristoffelCDePDDyad[{1, $CellContext`Dyad}, {
        2, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[CapitalDelta]", GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{2, -$CellContext`NP}][
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Gamma]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Gamma]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"A", "[", 
           RowBox[{"\[EmptyDownTriangle]", ",", 
            StyleBox["\[ScriptCapitalD]",
             FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
          StyleBox[GridBox[{
             {
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], " ", " "},
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`AChristoffelCDePDDyad[{0, $CellContext`Dyad}, {
       2, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[CapitalDelta]", GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{2, -$CellContext`NP}][
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox["\[Gamma]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Gamma]Dyad[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Nu]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Nu]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`AChristoffelCDePDDyad[{1, $CellContext`Dyad}, {
        3, -$CellContext`NP}, {-$CellContext`A, -$CellContext`Dyad}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Delta]", GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[{3, -$CellContext`NP}][
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"o", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`o[{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Beta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Beta]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Iota]", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["A",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota][{-$CellContext`A, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Sigma]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyad[],
       Editable->False]}]}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"A", "[", 
           RowBox[{"\[EmptyDownTriangle]", ",", 
            StyleBox["\[ScriptCapitalD]",
             FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
          StyleBox[GridBox[{
             {
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], " ", " "},
             {" ", 
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["A",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignme