(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   2633493,      67301]
NotebookOptionsPosition[   2152721,      58271]
NotebookOutlinePosition[   2511443,      65553]
CellTagsIndexPosition[   2511181,      65543]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xAct`Spinors`",
 FontSize->18]], "Section",
 CellTags->{
  "S5.18.1", "1.1"},ExpressionUUID->"c2649595-e5f2-4ab3-8b78-fbb8d0782e34"],

Cell[TextData[{
 "This is the doc file SpinorsDoc.nb of version 1.0.5 of ",
 StyleBox["Spinors`",
  FontFamily->"Courier"],
 ". Last update on 15 February 2014."
}], "Text",
 CellChangeTimes->{{3.598190693287037*^9, 3.598190702614317*^9}, {
  3.601026199849782*^9, 3.601026206585483*^9}},
 FontFamily->"Arial",
 FontWeight->"Plain",ExpressionUUID->"8f02c495-1333-4a16-ab4b-53225a585de3"],

Cell[TextData[{
 StyleBox["Web:",
  FontWeight->"Bold"],
 "   ",
 StyleBox[ButtonBox["http://www.xact.es/Spinors/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.xact.es/Spinors/"], None},
  ButtonNote->"http://www.xact.es/Spinors/"],
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[ButtonBox["\n     ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.xact.es/Spinors/"], None},
  ButtonNote->"http://www.xact.es/Spinors/"],
  FontFamily->"Courier"],
 StyleBox["https://github.com/xAct-contrib/Spinors", "DisplayMath",
  FontColor->RGBColor[0, 0, 1]],
 "\n",
 StyleBox["Article:",
  FontWeight->"Bold"],
 "   ",
 StyleBox["Spinors: A Mathematica package for doing spinor calculus in \
General Relativity, ",
  FontSlant->"Italic"],
 ButtonBox["Comp. Phys. Commun. 183 (2012) 2214-2225",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.sciencedirect.com/science/article/pii/S0010465512001634"],
     None},
  ButtonNote->
   "http://www.sciencedirect.com/science/article/pii/S0010465512001634"],
 ", ",
 ButtonBox["arXiv: 1110.2662 [gr-qc]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://arxiv.org/abs/1110.2662"], None},
  ButtonNote->"http://arxiv.org/abs/1110.2662"],
 "."
}], "Text",
 CellChangeTimes->{{3.598190523611005*^9, 3.59819060277975*^9}, {
  3.598190633561267*^9, 3.598190639063458*^9}},
 FontFamily->"Arial",
 FontWeight->"Plain",ExpressionUUID->"c7fc6a98-dfe2-449b-9118-08addc1d4e9b"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Authors",
 FontSize->14]], "SubsectionIcon",
 CellChangeTimes->{{3.424426880141967*^9, 3.424426883047801*^9}, {
  3.424426923913391*^9, 3.4244269247484827`*^9}, {3.424426974893358*^9, 
  3.424426975865028*^9}},ExpressionUUID->"6c28cb65-4c65-4a92-a9fd-\
0439b996ef1a"],

Cell[TextData[{
 "\[Copyright] 2006-2018, under the GNU General Public License (GPL)\n    ",
 StyleBox[" Alfonso Garc\[IAcute]a-Parrado G\[OAcute]mez-Lobo\n",
  FontWeight->"Bold"],
 "\tCentro de Matematica\n\tUniversidade do Minho, Portugal",
 StyleBox["\n",
  FontWeight->"Bold"],
 "\t",
 StyleBox["alfonso@math.uminho.pt",
  FontFamily->"Courier"],
 "\n     and\n     ",
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a",
  FontWeight->"Bold"],
 "\n\t",
 StyleBox["jose@xact.es",
  FontFamily->"Courier"],
 "\n\t",
 StyleBox[ButtonBox["http://www.xact.es/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.xact.es/"], None},
  ButtonNote->"http://www.xact.es/"],
  FontFamily->"Courier"]
}], "Text",
 FontFamily->"Arial",
 FontWeight->"Plain",ExpressionUUID->"caaf990d-b57c-4b81-8280-67f87908e1c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Intro",
 FontSize->14]], "SubsectionIcon",
 CellChangeTimes->{{3.424426880141967*^9, 3.424426883047801*^9}, {
  3.424426923913391*^9, 
  3.4244269247484827`*^9}},ExpressionUUID->"455b688c-378d-48d0-b6db-\
33cd3ad52dec"],

Cell[TextData[{
 StyleBox["Spinors`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 " ",
 StyleBox["is the",
  FontWeight->"Plain"],
 " ",
 StyleBox["xAct`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 StyleBox[" package for computations with spinors in four dimensional \
Lorentzian manifolds. The conventions adopted in the standard formulae of the \
spinor calculus are those of Penrose & Rindler, ",
  FontWeight->"Plain"],
 StyleBox["Spinors and Space-Time, ",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["Cambridge University Press (Vols. 1, 2). We assume that the user \
is already familiar with spinor calculus and therefore we will not explain \
the terminology or symbols related to this subject unless necessary to \
clarify the workings of the package. ",
  FontWeight->"Plain"]
}], "Text",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"689114d4-cfee-4c65-84e9-bf59b820c584"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Load the package",
 FontSize->14]], "SubsectionIcon",
 CellChangeTimes->{{3.424426880141967*^9, 
  3.424426913936936*^9}},ExpressionUUID->"92f5d04f-c4ad-4f1c-b666-\
c53813f6ce8d"],

Cell[TextData[{
 "This loads the package from the default directory, for example $Home/.",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "/Applications/xAct/ for a single-user installation under Linux.  "
}], "MathCaption",
 CellTags->{
  "S5.18.1", "1.3"},ExpressionUUID->"b408a892-8afc-4c91-8751-ecbc2af6d27d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"8c2575e0-8352-487e-a556-597b3ca33d7d"],

Cell[BoxData["40372136"], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"f6d59e3b-21a4-4f41-856a-426db81c219f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["<<xAct`Spinors`", "Input",
 CellTags->"S5.18.1",
 CellLabel->"In[2]:=",ExpressionUUID->"c63fdf46-4b4b-425d-93c6-160b6228e3c1"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"ebe51552-f5dc-4d58-a246-8d55615ebcda"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"3f1949ee-d9a8-4f0a-92bd-1ee3b80b592a"],

Cell[BoxData["\<\"CopyRight (C) 2003-2018, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"0dcc3230-0c22-479d-8e75-9d158563afcc"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"83158a8f-d550-4cb5-9165-5edce5c62018"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"24979cbd-589e-419c-836c-f96ab3192a28"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"93ce003e-c707-4497-a3fc-500cfcc8ee78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.3", ", ", {2018, 2, 28}],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"cae4d160-b459-4af2-a1d8-a37294c716c8"],

Cell[BoxData["\<\"CopyRight (C) 2002-2018, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"00fb2bed-bbc6-44f7-b3c7-b2a98e769303"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"961db239-cf5a-4e07-809b-10a5a2e9be48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Spinors`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2014", ",", "9", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`Spinors`  version ", "1.0.6", ", ", {2014, 9, 28}],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"2bf9ea30-ce31-4742-9b76-21f1c868c1ec"],

Cell[BoxData["\<\"CopyRight (C) 2006-2018, Alfonso Garcia-Parrado Gomez-Lobo \
and Jose M. Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"b9b12525-b499-4823-ba36-f0c92a91c4c4"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"a0bd6e8d-f9eb-4628-b393-2b8922cca97f"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"e9d0928b-d221-42d1-8d17-7fc6d487b8c8"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"c4829204-1a30-446f-b81e-ec2347f3ccd9"]
}, Open  ]],

Cell[TextData[{
 "Comparing, we see that all packages take about 20 Mb  in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 9.0:"
}], "MathCaption",ExpressionUUID->"6b21861d-db8c-4ac0-9005-b2688e3ba17f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellChangeTimes->{{3.426849249129299*^9, 3.4268492521518297`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"75f23c4d-17b4-43f6-97ae-f0fabba3ea13"],

Cell[BoxData["50685008"], "Output",
 CellLabel->"Out[3]=",ExpressionUUID->"14c59935-95c0-4edc-ac9b-27c8fd71cb8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Out", "[", "3", "]"}], "-", 
     RowBox[{"Out", "[", "1", "]"}]}], ")"}], "/", 
   RowBox[{"2", "^", "20"}]}], "//", "N"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"0771b461-a6bd-40a1-8bc2-f3394975b297"],

Cell[BoxData["9.835121154785156`"], "Output",
 CellLabel->"Out[4]=",ExpressionUUID->"dd1ef51a-0046-4b0f-9056-70ffbbcda71c"]
}, Open  ]],

Cell[TextData[{
 "There are several contexts: ",
 StyleBox["xAct`Spinors`, xAct`xTensor`",
  FontFamily->"Courier"],
 ", ",
 StyleBox["xAct`xPerm`",
  FontFamily->"Courier"],
 " and ",
 StyleBox["xAct`xCore`",
  FontFamily->"Courier"],
 " contain the respective reserved words. ",
 StyleBox["System`",
  FontFamily->"Courier"],
 " contains ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s reserved words.  The current context ",
 StyleBox["Global`",
  FontFamily->"Courier"],
 " will contain your definitions and right now is empty. "
}], "MathCaption",ExpressionUUID->"06454669-84dc-4c96-ac4b-3f36cab73bd5"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"3ed29f84-093b-4ec4-be5a-2ea3e62ffc7c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`Spinors`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"InterpreterLoader`\"\>", ",", "\<\"IconizeLoader`\"\>", 
   ",", "\<\"HTTPHandlingLoader`\"\>", ",", "\<\"AuthenticationLoader`\"\>", 
   ",", "\<\"SystemTools`\"\>", ",", "\<\"StreamingLoader`\"\>", 
   ",", "\<\"IntegratedServicesLoader`\"\>", 
   ",", "\<\"GeneralUtilitiesLoader`\"\>", ",", "\<\"CloudObjectLoader`\"\>", 
   ",", "\<\"PacletManager`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[5]=",ExpressionUUID->"15e7c651-d122-4b76-9999-7265c0efbcfc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "]"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"a5007bf6-a88d-4c7c-8ed6-4a1d00cb2b15"],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellLabel->"Out[6]=",ExpressionUUID->"6170ab96-569a-4267-bef2-022e55df1368"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"a0468b15-b617-4eb4-a459-d12b35cb799c"],

Cell["Global`$UseTextSearchQ", "Print", "PrintUsage",
 CellTags->
  "Info73729026427-8997654",ExpressionUUID->"52f44503-16ed-478e-ba69-\
5a70941304cb"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1. Example session", "SubsectionIcon",
 CellChangeTimes->{{3.424426880141967*^9, 3.424426883047801*^9}, {
  3.4244274844846907`*^9, 3.424427485004201*^9}, {3.42685892327719*^9, 
  3.426858926725419*^9}},ExpressionUUID->"31bfec87-d775-486a-a1be-\
af4c5f5a942c"],

Cell[TextData[{
 StyleBox["Spinors are elements of a complex vector bundle (spin bundle) \
whose base space is a four dimensional Lorentzian manifold (spacetime). \
Therefore we need to define first a four dimensional differentiable manifold \
and a Lorentzian metric, which will be kept fixed in all this notebook. See",
  FontWeight->"Plain"],
 StyleBox[" xTensor`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 StyleBox[" doc file for details about how to carry this out. Note also that \
all the tools and notation developed in ",
  FontWeight->"Plain"],
 StyleBox["xAct`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 StyleBox[" to work with generic complex vector bundles apply in the \
particular case of a spin bundle, so the user will be assumed familiar with \
them. We refer again to the  ",
  FontWeight->"Plain"],
 StyleBox["xTensor`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 StyleBox[" doc file for detailed documentation about this point.",
  FontWeight->"Plain"]
}], "Text",
 TextJustification->1.,ExpressionUUID->"3cf340e3-386d-4ccf-8df3-74af03e6e71f"],

Cell[TextData[{
 "Definition of a four dimensional  manifold ",
 StyleBox["M4",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",
 CellChangeTimes->{{3.42166720033285*^9, 
  3.421667203989368*^9}},ExpressionUUID->"31cc7fc7-0e75-4ce7-a753-\
265f7b2f0001"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M4", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p", ",", "q", ",", "r",
      ",", "m", ",", "l", ",", "h", ",", "j", ",", "n", ",", "t", ",", "s"}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.422186457176779*^9, 3.42218645874576*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"a461d235-9725-4f22-aa34-a66c96dcc8eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M4, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"faf6b26f-19f3-475d-b307-043c653ba0ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM4, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"83621dce-1c06-4264-b7a4-9f783db9c7e2"]
}, Open  ]],

Cell["\<\
Definition of a Lorentzian metric on the manifold, with signature having +1 \
once, -1 thrice and zero times 0:\
\>", "MathCaption",ExpressionUUID->"d778b254-fcbb-46f7-8510-495bd5dd7f0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD"}], "]"}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"8f9ee7e2-4fce-4a1f-9bf4-1c9827e24049"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"9c8dc85b-bfe8-496f-83ad-2926f9b9592c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"2558c780-6d6e-4e93-8321-72e8996ab2e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"79403221-f196-4b0a-abcf-ce78fc99e22f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"70aac5cb-0acf-41d4-b42b-59f367a06a0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"365882be-16b6-49bf-b6d6-e2201ea4a002"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"8e8fc697-3721-4d41-af75-51a926981fb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"6dd070ec-a3e7-4656-9950-6eb16b54dd3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"8d6da047-877e-4308-8a2f-4d8348c14be0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e50d346d-bbb9-4cb4-9fd7-31358d93725c"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"d09c2541-078b-4c1a-9cea-5f2f814e5adf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"0961f255-7fde-4a13-bfc2-91e412f5bed5"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"6a133f76-0ab1-47f5-9e43-3af8ed9de10d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e229bfe9-ba82-4234-b00b-990691eb3ad3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"bbecb6e6-22b8-4a08-b877-54794b7620ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"22c9ce45-814d-4125-8093-489ac3eaf78d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"8f13f673-7400-4b51-9259-47f39d3f0a8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"39ae5a8a-53f5-4aa5-8987-b8ea0e57b12d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"cae34b50-596d-45d2-aae9-8588a70fae2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"4fc150af-2a38-4516-8e5e-d8625c725ae5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"659ce335-7836-49f4-a594-b2002518aa68"]
}, Open  ]],

Cell[TextData[{
 "The command ",
 StyleBox["DefSpinStructure", "Input",
  FontWeight->"Plain"],
 " defines a complex spin bundle named ",
 StyleBox["Spin", "Input",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 " comprising the spin metric ",
 StyleBox["\[Epsilon][-A,-B]", "Input",
  FontWeight->"Plain"],
 ", the soldering form ",
 StyleBox["\[Sigma][a,-A,-A\[Dagger]]", "Input",
  FontWeight->"Plain"],
 "and the extension of the Levi-Civita covariant derivative ",
 StyleBox["CD", "Input",
  FontWeight->"Plain"],
 " to the unique covariant derivative ",
 StyleBox["CDe", "Input",
  FontWeight->"Plain"],
 " which is compatible with the soldering form and the spin metric (spin \
covariant derivative).  The option ",
 StyleBox["SpinorPrefix", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["is used to introduce a tag which will be prepended automatically \
to  any spinor related to a spacetime tensor.", "Text",
  FontWeight->"Plain"],
 StyleBox[" ", "Text"]
}], "MathCaption",
 TextJustification->1.,ExpressionUUID->"8d7fa4c3-012f-4782-9649-7b26ca7d2e7b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{
    "A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "H", ",", "L", ",", "P",
      ",", "Q"}], "}"}], ",", "\[Epsilon]", ",", "\[Sigma]", ",", "CDe", ",", 
   
   RowBox[{"SpinorPrefix", "->", "SP"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"325e66d9-5a29-4d6b-b50e-b90d82bd9aea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "Spin", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`Spin, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"2e36cb97-be32-413e-b6b0-03b04572448a"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], ":", 
  " ", "\<\"System name \[NoBreak]\\!\\(\\\"C\\\"\\)\[NoBreak] is overloaded \
as an abstract index.\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"cff747c1-5bdd-475a-a91c-e3362b576b56"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], ":", 
  " ", "\<\"System name \[NoBreak]\\!\\(\\\"D\\\"\\)\[NoBreak] is overloaded \
as an abstract index.\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"96ef90d6-c824-4b13-99b1-72d0172d6672"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "Spin\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between Spin and \
Spin\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`Spin\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between Spin and Spin\[Dagger]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"5b19e367-3fab-4938-aa23-b7ff65f4ec6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma][$CellContext`a, -C, -$CellContext`D\[Dagger]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"0285c226-35ae-42ad-bfba-d25e8fdfe4de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[Dagger]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma]\[Dagger][$CellContext`a, -$CellContext`C\[Dagger], -
    D], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"c76bcdde-b490-4c70-9289-945903d2aab2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"8aacf3e8-617d-451a-9ddf-548de009072b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"5955a5c7-b621-4769-8931-92ae38fa8065"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[Sigma]", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[Sigma][$CellContext`a, $CellContext`b, \
-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"c4b9179e-733d-459d-aba1-5a918d5e5764"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[Sigma]\[Dagger]", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[Sigma]\[Dagger][$CellContext`a, $CellContext`b, \
-$CellContext`A\[Dagger], -$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"70c373b3-d41e-4940-b1fd-3db65e395a0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]g", "[", 
    RowBox[{"A", ",", "C\[Dagger]", ",", "B", ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor g\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]g[$CellContext`A, $CellContext`C\[Dagger], \
$CellContext`B, $CellContext`D\[Dagger]], ". ", "Equivalent of tensor g"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"e6df0f21-5933-4066-8442-322c993a2ab7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]g\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "C", ",", "B\[Dagger]", ",", "D"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor g\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]g\[Dagger][$CellContext`A\[Dagger], 
    C, $CellContext`B\[Dagger], D], ". ", "Equivalent of tensor g"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"15b63e08-bcc2-4a18-b2ab-21807b86d324"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]epsilong", "[", 
    RowBox[{
    "A", ",", "A\[Dagger]", ",", "B", ",", "B\[Dagger]", ",", "C", ",", 
     "C\[Dagger]", ",", "D", ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor epsilong\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]epsilong[$CellContext`A, $CellContext`A\
\[Dagger], $CellContext`B, $CellContext`B\[Dagger], 
    C, $CellContext`C\[Dagger], D, $CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor epsilong"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"b36cc01a-5814-44d5-af68-26f1e81457f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]epsilong\[Dagger]", "[", 
    RowBox[{
    "A\[Dagger]", ",", "A", ",", "B\[Dagger]", ",", "B", ",", "C\[Dagger]", 
     ",", "C", ",", "D\[Dagger]", ",", "D"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor epsilong\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]epsilong\[Dagger][$CellContext`A\[Dagger], \
$CellContext`A, $CellContext`B\[Dagger], $CellContext`B, $CellContext`C\
\[Dagger], C, $CellContext`D\[Dagger], D], ". ", 
   "Equivalent of tensor epsilong"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"06bb96bf-172c-4e0b-ba12-2871c353c2db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDe", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDe[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"668b970b-9399-46d1-a1b8-70029d172b6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDe", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`ChristoffelCDCDe[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"4d25095c-981a-4f87-bb48-27b1d73b06da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCDe", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelCDe[$CellContext`A, -$CellContext`b, -C], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"8695899a-d2c5-472f-9e5e-c847fb81ce05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCDe\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelCDe\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"fd18366d-15e0-45e5-9f64-616bbdf196d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannCDe", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannCDe[-$CellContext`a, -$CellContext`b, -C, D], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"2423f7ab-5930-46dc-be24-d7712ff08b63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannCDe\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"33906687-00b1-40df-be1f-a8c50cb5e77a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemannCDe\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]FRiemannCDe[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -C, -D], ". ", 
   "Equivalent of tensor FRiemannCDe"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"a314a987-d9a7-437d-925d-fc3e63bb415b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemannCDe\[Dagger]\"\>"}],
  
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]FRiemannCDe\[Dagger][-$CellContext`A\[Dagger]\
, -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor FRiemannCDe\[Dagger]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"511b270f-8da6-4026-b6e3-b2897f50cf8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`ChiCDe[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"b1998b14-7c46-4819-8e09-ab31cae68847"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChiCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`ChiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"0590d6a5-b91b-4795-bc6e-57e0000ee13f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PhiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"efe3dc45-2685-404d-8e97-3e873459b7a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PhiCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`PhiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"3f620abb-36fd-4cd1-ac43-bd18298c5606"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor scalar curvature \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"LambdaCDe", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "spinor scalar curvature ", 
   $CellContext`LambdaCDe[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"a0aedf87-e892-47e9-a67d-e72507e3d551"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PsiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl spinor ", 
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"34fdbfdb-1b34-4efc-a26d-eacdfa77e700"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PsiCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl spinor ", 
   $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"ccdfd7cf-90fe-42e7-96f5-812c8c777b04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RiemannCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]RiemannCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor RiemannCD"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"4a04eb1e-a1e1-42cf-a5e4-e22590955cf0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RiemannCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RiemannCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]RiemannCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", 
   "Equivalent of tensor RiemannCD"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"a43a6eb2-1a94-4a43-96bd-83fcec8956e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]RicciCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", 
   "Equivalent of tensor RicciCD"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"8581ab53-ad14-4eb9-9923-2334fb63ba61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RicciCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]RicciCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor RicciCD"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"e396c205-f50a-4536-8cab-5fe66f8e7e37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor WeylCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]WeylCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor WeylCD"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"5de6b8ec-cf78-46ce-bade-196256faee18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]WeylCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor WeylCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]WeylCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", 
   "Equivalent of tensor WeylCD"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"b381974d-67f4-49bb-ab0d-b6f93a65de58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor TFRicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]TFRicciCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", 
   "Equivalent of tensor TFRicciCD"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"a2118ba0-2b03-4edc-9dfb-249968306961"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]TFRicciCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor TFRicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]TFRicciCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor TFRicciCD"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"865e4776-46dc-4956-bc7f-9d73e3aa1c5e"]
}, Open  ]],

Cell[TextData[{
 "When a spin structure is defined, several new objects are defined \
automatically. These are the spinor equivalents of the Riemann, the Ricci, \
the traceless Ricci and the Weyl tensors. Note the character ",
 StyleBox["\[Sigma]", "DisplayMath"],
 " prepended to each head in the output . This is the default output form of \
the tag mentioned above. This output form can be changed with the option ",
 StyleBox["SpinorMark", "Input",
  FontWeight->"Plain"],
 StyleBox[" in the command ", "Text",
  FontWeight->"Plain"],
 StyleBox["DefSpinStructure", "Input",
  FontWeight->"Plain"],
 StyleBox[".", "Input"]
}], "MathCaption",
 TextJustification->1.,ExpressionUUID->"77ca228d-6058-42b5-a788-3d661382e615"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SP\[UnderBracket]RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "F"}], ",", 
     RowBox[{"-", "F\[Dagger]"}]}], "]"}], ",", 
   RowBox[{"SP\[UnderBracket]RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", 
   RowBox[{"SP\[UnderBracket]TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", 
   RowBox[{"SP\[UnderBracket]WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "F"}], ",", 
     RowBox[{"-", "F\[Dagger]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"1d3eee8a-aed2-4672-a075-5bedd9da89cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[Sigma]R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " ", " ", " ", " ", " "},
           {"A", "A\[Dagger]", "B", "B\[Dagger]", "C", "C\[Dagger]", "F", 
            "F\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`SP\[UnderBracket]RiemannCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
     C, -$CellContext`C\[Dagger], -$CellContext`F, -$CellContext`F\[Dagger]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[Sigma]R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "A\[Dagger]", "B", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`SP\[UnderBracket]RicciCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[Sigma]S", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "A\[Dagger]", "B", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`SP\[UnderBracket]TFRicciCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[Sigma]W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " ", " ", " ", " ", " "},
           {"A", "A\[Dagger]", "B", "B\[Dagger]", "C", "C\[Dagger]", "F", 
            "F\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`SP\[UnderBracket]WeylCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
     C, -$CellContext`C\[Dagger], -$CellContext`F, -$CellContext`F\[Dagger]],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[11]=",ExpressionUUID->"2faf5acc-0480-45aa-905a-74e589a96445"]
}, Open  ]],

Cell["The curvature spinors are also automatically defined. ", "MathCaption",
 CellChangeTimes->{
  3.407866628317771*^9, {3.407866936403089*^9, 3.407866994173277*^9}, {
   3.40786711899345*^9, 3.407867139720908*^9}, {3.407867771975953*^9, 
   3.4078678153605843`*^9}, {3.407868843671587*^9, 3.40786890495704*^9}, {
   3.407868955907063*^9, 3.4078689722678747`*^9}, {3.407869139909814*^9, 
   3.4078691538233137`*^9}, {3.407869301196363*^9, 3.407869302218423*^9}, {
   3.407870595603923*^9, 3.407870617356441*^9}, {3.4078707081166153`*^9, 
   3.407870710094352*^9}},ExpressionUUID->"adba3620-0e07-4df8-a4e5-\
40af762a1a35"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ChiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], ",", 
   RowBox[{"PhiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.407870712437128*^9, 3.4078708052113657`*^9}, {
  3.408426449163241*^9, 3.408426470486109*^9}, {3.4084265065973377`*^9, 
  3.4084265101976347`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"d0619042-f821-44e7-95a4-10da0dfa0830"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalChi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`A\
\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[12]=",ExpressionUUID->"729b60ec-6585-431e-b73f-e17c1a2b820a"]
}, Open  ]],

Cell[TextData[{
 "Each of the above spinors can be decomposed into irreducible parts by means \
of the command ",
 StyleBox["Decomposition", "Input",
  FontWeight->"Plain"],
 ".  ",
 StyleBox["Let us see some examples.", "Text",
  FontWeight->"Plain"],
 "  "
}], "MathCaption",
 CellChangeTimes->{
  3.407866628317771*^9, {3.407866936403089*^9, 3.407866994173277*^9}, {
   3.40786711899345*^9, 3.407867139720908*^9}, {3.407867771975953*^9, 
   3.4078678153605843`*^9}, {3.407868843671587*^9, 3.40786890495704*^9}, {
   3.407868955907063*^9, 3.4078689722678747`*^9}, {3.407869139909814*^9, 
   3.4078691538233137`*^9}, {3.407869301196363*^9, 3.407869302218423*^9}, {
   3.407870595603923*^9, 3.407870617356441*^9}, {3.4078707081166153`*^9, 
   3.407870710094352*^9}, {3.407871251019449*^9, 3.4078713224146023`*^9}, {
   3.4078713695281897`*^9, 3.407871388472761*^9}, {3.42166887198412*^9, 
   3.421668901309334*^9}, {3.423656355335417*^9, 3.423656425761856*^9}, {
   3.426997370576182*^9, 
   3.426997408904698*^9}},ExpressionUUID->"2211435b-36e2-4f08-88ce-\
1e4f0cb58006"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", 
  RowBox[{"SP\[UnderBracket]RiemannCD", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "C\[Dagger]"}], ",", 
    RowBox[{"-", "D"}], ",", 
    RowBox[{"-", "D\[Dagger]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.407871705643991*^9, 3.407871706605205*^9}, {
  3.407942398854137*^9, 3.407942415586502*^9}, {3.421668913418995*^9, 
  3.421668913737664*^9}, {3.423635438487563*^9, 3.423635445889124*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"33372a37-ce9c-48ff-9e6f-7212c2460a12"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          "\[Dagger]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A\[Dagger]", "B\[Dagger]", "D\[Dagger]", "C\[Dagger]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`D\[Dagger], -$CellContext`C\[Dagger]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-D, -C],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "D\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`D\
\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-D, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LambdaCDe[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False]}]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"D", "C", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-D, -
     C, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -D, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[13]=",ExpressionUUID->"56710154-f5a8-4f81-b2bb-d5d3596f3909"]
}, Open  ]],

Cell["\<\
The decomposition of the spinor equivalent of the Ricci tensor is\
\>", "MathCaption",
 CellChangeTimes->{
  3.407866628317771*^9, {3.407866936403089*^9, 3.407866994173277*^9}, {
   3.40786711899345*^9, 3.407867139720908*^9}, {3.407867771975953*^9, 
   3.4078678153605843`*^9}, {3.407868843671587*^9, 3.40786890495704*^9}, {
   3.407868955907063*^9, 3.4078689722678747`*^9}, {3.407869139909814*^9, 
   3.4078691538233137`*^9}, {3.407869301196363*^9, 3.407869302218423*^9}, {
   3.407870595603923*^9, 3.407870617356441*^9}, {3.4078707081166153`*^9, 
   3.407870710094352*^9}, {3.407871251019449*^9, 3.4078713224146023`*^9}, {
   3.4078713695281897`*^9, 3.407871388472761*^9}, {3.42166887198412*^9, 
   3.421668901309334*^9}, {3.421669343239017*^9, 
   3.421669359869225*^9}},ExpressionUUID->"0b38cdb2-7038-4e46-ad6e-\
0311ca6513aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", 
  RowBox[{"SP\[UnderBracket]RicciCD", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4078719213210573`*^9, 3.407871928328722*^9}, {
  3.4079424194267817`*^9, 3.4079424211122704`*^9}, {3.408426579791802*^9, 
  3.408426583726717*^9}, {3.423635533078236*^9, 3.4236355366598*^9}, {
  3.423635567547018*^9, 3.423635568717198*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"57727d93-db98-49b8-b172-1dd3fe3d5ecc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`A\
\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{"6", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LambdaCDe[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[14]=",ExpressionUUID->"bac95e30-a928-484f-adfc-e4f3f1665ffe"]
}, Open  ]],

Cell["\<\
The decomposition of the spinor equivalent of the Weyl tensor is\
\>", "MathCaption",
 CellChangeTimes->{
  3.407866628317771*^9, {3.407866936403089*^9, 3.407866994173277*^9}, {
   3.40786711899345*^9, 3.407867139720908*^9}, {3.407867771975953*^9, 
   3.4078678153605843`*^9}, {3.407868843671587*^9, 3.40786890495704*^9}, {
   3.407868955907063*^9, 3.4078689722678747`*^9}, {3.407869139909814*^9, 
   3.4078691538233137`*^9}, {3.407869301196363*^9, 3.407869302218423*^9}, {
   3.407870595603923*^9, 3.407870617356441*^9}, {3.4078707081166153`*^9, 
   3.407870710094352*^9}, {3.407871251019449*^9, 3.4078713224146023`*^9}, {
   3.4078713695281897`*^9, 3.407871388472761*^9}, {3.42166887198412*^9, 
   3.421668901309334*^9}, {3.421669343239017*^9, 
   3.421669380878779*^9}},ExpressionUUID->"fc93c5ba-87d4-483f-b286-\
0238d3fa0d6f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", 
  RowBox[{"SP\[UnderBracket]WeylCD", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "C\[Dagger]"}], ",", 
    RowBox[{"-", "D"}], ",", 
    RowBox[{"-", "D\[Dagger]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.407872432398676*^9, 3.407872455724689*^9}, {
  3.40794242552621*^9, 3.407942427348132*^9}, {3.408426589739798*^9, 
  3.4084265923478527`*^9}, {3.4236355769269753`*^9, 3.423635585461504*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"8e6038b7-960d-4489-80c9-55253c358a2a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          "\[Dagger]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A\[Dagger]", "B\[Dagger]", "D\[Dagger]", "C\[Dagger]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`D\[Dagger], -$CellContext`C\[Dagger]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-D, -C],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -D, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[15]=",ExpressionUUID->"dd4ba17e-e97d-4af6-ada1-d4091e1e84c5"]
}, Open  ]],

Cell["\<\
The inner curvature of the spin bundle can be also decomposed according to \
standard rules . \
\>", "MathCaption",
 CellChangeTimes->{
  3.407866628317771*^9, {3.407866936403089*^9, 3.407866994173277*^9}, {
   3.40786711899345*^9, 3.407867139720908*^9}, {3.407867771975953*^9, 
   3.4078678153605843`*^9}, {3.407868843671587*^9, 3.40786890495704*^9}, {
   3.407868955907063*^9, 3.4078689722678747`*^9}, {3.407869139909814*^9, 
   3.4078691538233137`*^9}, {3.407869301196363*^9, 3.407869302218423*^9}, {
   3.407870595603923*^9, 3.407870617356441*^9}, {3.4078707081166153`*^9, 
   3.407870710094352*^9}, {3.407871251019449*^9, 3.4078713224146023`*^9}, {
   3.4078713695281897`*^9, 3.407871388472761*^9}, {3.42166887198412*^9, 
   3.421668901309334*^9}, {3.421669343239017*^9, 3.421669380878779*^9}, {
   3.421670093461862*^9, 3.421670119156918*^9}, 3.421670310624237*^9, {
   3.423212676194989*^9, 3.423212709483774*^9}, {3.423635624208394*^9, 
   3.423635640852252*^9}, {3.426997697663147*^9, 
   3.4269977455188093`*^9}},ExpressionUUID->"30ed9e7e-530b-4a38-8740-\
15d6d72ddf2a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", 
  RowBox[{"SP\[UnderBracket]FRiemannCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.408218693787928*^9, 3.408218707965897*^9}, {
   3.40842660769834*^9, 3.408426620228633*^9}, 3.408454489313922*^9, {
   3.408455011382678*^9, 3.408455038185923*^9}, {3.4236356758816338`*^9, 
   3.423635683047102*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"85d03725-4f9f-44c5-a379-3b1062943f78"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"C", "D", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-C, -
     D, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalChi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"C", "D", "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChiCDe[-C, -D, -$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[16]=",ExpressionUUID->"3b557e3c-39ad-4e64-923c-2c68f047af1d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", 
  RowBox[{"%", ",", "Chi"}], "]"}]], "Input",
 CellChangeTimes->{{3.4084555342118998`*^9, 3.408455535520384*^9}, {
  3.423635693229887*^9, 3.42363570597509*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"0e7370b8-27ea-466b-bd33-02c685feeb76"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"C", "D", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-C, -
     D, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"C", "D", "A", "B"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PsiCDe[-C, -D, -$CellContext`A, -$CellContext`B],
      Editable->False], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LambdaCDe[],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {"C", "B"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Epsilon][-C, -$CellContext`B],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {"D", "A"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Epsilon][-D, -$CellContext`A],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {"C", "A"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Epsilon][-C, -$CellContext`A],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {"D", "B"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Epsilon][-D, -$CellContext`B],
          Editable->False]}]}], ")"}]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[17]=",ExpressionUUID->"ef943374-e901-4f1b-ad88-b350ee0e3d62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChiCDe", "[", 
  RowBox[{
   RowBox[{"-", "A"}], ",", 
   RowBox[{"-", "B"}], ",", 
   RowBox[{"-", "C"}], ",", 
   RowBox[{"-", "D"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.426958809955307*^9, 3.426958820890551*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"346ea973-c7a6-4e18-9337-77e77c12e5c8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"\[CapitalChi]", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"A", "B", "C", "D"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`ChiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
  Editable->False]], "Output",
 CellLabel->"Out[18]=",ExpressionUUID->"258461ee-68c1-49d9-be09-5d6e1dab8276"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", 
  RowBox[{"%", ",", "Chi"}], "]"}]], "Input",
 CellChangeTimes->{{3.4269588234825687`*^9, 3.426958838491891*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"55a3d330-c0aa-46fe-a367-0b623bd8a0d2"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LambdaCDe[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -C],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -D],
       Editable->False]}]}], ")"}]}]}]], "Output",
 CellLabel->"Out[19]=",ExpressionUUID->"2e90bd41-44a5-4c7a-957b-fe7d8ff0fb9f"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Spinors`", "Input",
  FontWeight->"Plain"],
 " is able to work with the 2-index derivatives used in spinor calculus."
}], "MathCaption",ExpressionUUID->"694f73aa-13a3-41fe-b113-203344d54f04"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDe", "[", 
   RowBox[{
    RowBox[{"-", "F"}], ",", 
    RowBox[{"-", "F\[Dagger]"}]}], "]"}], "@", 
  RowBox[{"PsiCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.421670434828978*^9, 3.421670463706352*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"c92689a7-8649-4dc8-8ed0-2ff4eb319e84"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "FF\[Dagger]", "  "], GridBox[{
      {
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[-$CellContext`F, -$CellContext`F\[Dagger]][
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D]],
  Editable->False]], "Output",
 CellLabel->"Out[20]=",ExpressionUUID->"11ad76b0-fcac-4d67-bc0d-86133e52fc31"]
}, Open  ]],

Cell["As is well-known this is nothing but a shorthand for", "MathCaption",
 CellChangeTimes->{
  3.407866628317771*^9, {3.407866936403089*^9, 3.407866994173277*^9}, {
   3.40786711899345*^9, 3.407867139720908*^9}, {3.407867771975953*^9, 
   3.4078678153605843`*^9}, {3.407868843671587*^9, 3.40786890495704*^9}, {
   3.407868955907063*^9, 3.4078689722678747`*^9}, {3.407869139909814*^9, 
   3.4078691538233137`*^9}, {3.407869301196363*^9, 3.407869302218423*^9}, {
   3.407870595603923*^9, 3.407870617356441*^9}, {3.4078707081166153`*^9, 
   3.407870710094352*^9}, {3.407871251019449*^9, 3.4078713224146023`*^9}, {
   3.4078713695281897`*^9, 3.407871388472761*^9}, {3.42166887198412*^9, 
   3.421668901309334*^9}, {3.421669343239017*^9, 3.421669380878779*^9}, {
   3.421670093461862*^9, 3.421670119156918*^9}, 3.421670310624237*^9, {
   3.421670477681736*^9, 3.421670528274399*^9}, {3.421671035727024*^9, 
   3.421671051557603*^9}},ExpressionUUID->"b8a6c1f4-a548-47a3-a994-\
3b00b2dd3a1b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", 
  RowBox[{"%", ",", "CDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.421671053180512*^9, 3.4216710848825083`*^9}, {
  3.426274008984023*^9, 3.4262740091801567`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"b75a2c07-c873-4dd4-970f-fb72bec70b5c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "F", "F\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`F, -$CellContext`F\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
        {
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A", "B", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`a][
     $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[21]=",ExpressionUUID->"2bcc78cf-76fa-45d9-9a5d-b187b86fb50b"]
}, Open  ]],

Cell["\<\
We can also transform one-index covariant derivatives back into their two \
index form by means of the soldering form. \
\>", "MathCaption",
 CellChangeTimes->{
  3.407866628317771*^9, {3.407866936403089*^9, 3.407866994173277*^9}, {
   3.40786711899345*^9, 3.407867139720908*^9}, {3.407867771975953*^9, 
   3.4078678153605843`*^9}, {3.407868843671587*^9, 3.40786890495704*^9}, {
   3.407868955907063*^9, 3.4078689722678747`*^9}, {3.407869139909814*^9, 
   3.4078691538233137`*^9}, {3.407869301196363*^9, 3.407869302218423*^9}, {
   3.407870595603923*^9, 3.407870617356441*^9}, {3.4078707081166153`*^9, 
   3.407870710094352*^9}, {3.407871251019449*^9, 3.4078713224146023`*^9}, {
   3.4078713695281897`*^9, 3.407871388472761*^9}, {3.42166887198412*^9, 
   3.421668901309334*^9}, {3.421669343239017*^9, 3.421669380878779*^9}, {
   3.421670093461862*^9, 3.421670119156918*^9}, 3.421670310624237*^9, {
   3.421670477681736*^9, 3.421670528274399*^9}, {3.421671035727024*^9, 
   3.421671051557603*^9}, {3.422591696535112*^9, 3.422591720998292*^9}, {
   3.423639162436761*^9, 3.42363920544827*^9}, {3.423639470539205*^9, 
   3.423639471669394*^9}, {3.4270817948497868`*^9, 
   3.427081803706955*^9}},ExpressionUUID->"e758dbd6-4b95-4a77-a2f2-\
ca5192b2f536"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDe", "[", 
   RowBox[{"-", "b"}], "]"}], "@", 
  RowBox[{"PsiCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.423212959118867*^9, 3.423213000226057*^9}, 
   3.427081775726433*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"d2ee1be2-e20c-46bb-91e5-367065fdf2d2"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
      {
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[-$CellContext`b][
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D]],
  Editable->False]], "Output",
 CellLabel->"Out[22]=",ExpressionUUID->"32598574-8804-438d-a81f-fa6dd8289a01"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4270817786194983`*^9, 3.427081784202198*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"1e5df9a8-bec7-4760-b6e9-095f4164a73e"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "F", "F\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`F, -$CellContext`F\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
        {
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A", "B", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`a][
     $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[23]=",ExpressionUUID->"9893d385-7d28-473a-b8a9-b755310c181c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.423637619361644*^9, 3.423637624868133*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"cb269347-df8b-49fc-871d-6aa23a6e49bb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "FF\[Dagger]", "  "], GridBox[{
      {
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[-$CellContext`F, -$CellContext`F\[Dagger]][
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D]],
  Editable->False]], "Output",
 CellLabel->"Out[24]=",ExpressionUUID->"4c2f66f9-cf14-403c-93c2-c88e429585bc"]
}, Open  ]],

Cell[TextData[{
 "Spinors are defined using the command ",
 StyleBox["DefSpinor",
  FontFamily->"Courier"],
 ", which is nothing but a renaming of standard ",
 StyleBox["xAct`",
  FontFamily->"Courier"],
 " command ",
 StyleBox["DefTensor ",
  FontFamily->"Courier"],
 "(by default the option ",
 StyleBox["Dagger->Complex", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["is assumed).", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.407872497874693*^9, 3.4078725139051332`*^9}, {
   3.407998334769004*^9, 3.407998349005952*^9}, {3.407998409528253*^9, 
   3.407998450868231*^9}, {3.407998497033436*^9, 3.407998590628295*^9}, {
   3.407998934878738*^9, 3.407998981938609*^9}, 3.421671572866338*^9, 
   3.423657762989641*^9, {3.42442732321021*^9, 3.4244273499466047`*^9}, {
   3.424427392765546*^9, 3.42442741345674*^9}, {3.4244280435348*^9, 
   3.424428051215495*^9}, {3.42444929574883*^9, 3.424449307500284*^9}, {
   3.426998026761388*^9, 3.426998171602697*^9}, 
   3.4270859488926697`*^9},ExpressionUUID->"8ad32ed0-9b22-4f92-8bb4-\
ad0e100fc11b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Kappa]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.407998593517461*^9, 3.4079986658847933`*^9}, {
   3.4244274272848*^9, 3.4244274295135593`*^9}, 3.426997999082817*^9},
 CellLabel->"In[25]:=",ExpressionUUID->"80a21545-724d-48f6-a301-47736ee96c00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[25]:=",ExpressionUUID->"7cbc2acf-e8b4-4276-b435-c5d967d1bd8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Kappa]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[25]:=",ExpressionUUID->"6bc9bf2e-9de7-4ff7-abae-f5269595731a"]
}, Open  ]],

Cell["\<\
In this case the spinor just defined can be related to a tensor in the \
spacetime tangent bundle.  This vector is given by\
\>", "MathCaption",
 CellChangeTimes->{{3.407872497874693*^9, 3.4078725139051332`*^9}, {
   3.407998334769004*^9, 3.407998349005952*^9}, {3.407998409528253*^9, 
   3.407998450868231*^9}, {3.407998497033436*^9, 3.407998590628295*^9}, {
   3.407998934878738*^9, 3.407998981938609*^9}, 3.421671572866338*^9, {
   3.421671627270052*^9, 3.421671630582344*^9}, {3.421910490496245*^9, 
   3.421910497423296*^9}, {3.421910737403976*^9, 
   3.421910739212068*^9}},ExpressionUUID->"fc2deb74-a060-405e-aaee-\
99ae490b642c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"\[Kappa]", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4216716364252*^9, 3.421671725396346*^9}, 
   3.4219105619596767`*^9, {3.4267951037064238`*^9, 3.426795107425696*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"dd2583d8-b3d9-4732-bcb9-51becbd1aff8"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Kappa]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[26]=",ExpressionUUID->"dd6b47f5-f039-4ba5-9ab7-7eb4576ca001"]
}, Open  ]],

Cell[TextData[{
 "The soldering form can be absorbed into the spinor ",
 StyleBox["\[Kappa]", "Output"],
 ". In this case a new tensor is automatically defined."
}], "MathCaption",
 CellChangeTimes->{{3.407872497874693*^9, 3.4078725139051332`*^9}, {
   3.407998334769004*^9, 3.407998349005952*^9}, {3.407998409528253*^9, 
   3.407998450868231*^9}, {3.407998497033436*^9, 3.407998590628295*^9}, {
   3.407998934878738*^9, 3.407998981938609*^9}, 3.421671572866338*^9, {
   3.421671627270052*^9, 3.421671630582344*^9}, {3.421910490496245*^9, 
   3.421910497423296*^9}, {3.421910672652439*^9, 3.42191074777911*^9}, {
   3.4236398174293137`*^9, 3.4236398232791433`*^9}, {3.427081840679085*^9, 
   3.427081854519992*^9}},ExpressionUUID->"17ae6da6-299f-42a8-9bde-\
c74201ba1e5b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.4079987148462687`*^9, 3.407998723706513*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"e52091de-2c5b-4a52-866e-a5fd261b5682"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"TensorOfSpinor", "::", "name"}], "MessageName"], ":", 
  " ", "\<\"Tensor of \[NoBreak]\\!\\(\[Kappa]\\)\[NoBreak] not defined. \
Prepending \[NoBreak]\\!\\(SP\\)\[NoBreak].\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"56ac9fc7-3401-412a-9c48-6bf80d36d29c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]\[Kappa]", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of spinor \[Kappa]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]\[Kappa][-$CellContext`a], ". ", 
   "Equivalent of spinor \[Kappa]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"3f65c10e-e4c6-4f10-86ed-ed04e6ae48ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]\[Kappa]\[Dagger]", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of spinor \[Kappa]\[Dagger]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]\[Kappa]\[Dagger][-$CellContext`a], ". ", 
   "Equivalent of spinor \[Kappa]\[Dagger]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[27]:=",ExpressionUUID->"a8f86dbf-b4a9-4ce0-bec0-49fa6c43256d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Sigma]\[Kappa]", 
      StyleBox[GridBox[{
         {" "},
         {"a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP\[UnderBracket]\[Kappa][-$CellContext`a],
  Editable->False]], "Output",
 CellLabel->"Out[27]=",ExpressionUUID->"bbc211f9-2b1f-407d-abc4-aa2cf72e9114"]
}, Open  ]],

Cell[TextData[{
 "The original spinor may be also recovered from ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Sigma]\[Kappa]", "a", " "],
    AutoSpacing->False],
   $CellContext`SP\[UnderBracket]\[Kappa][-$CellContext`a],
   Editable->False]], "Output",
  CellChangeTimes->{3.407998724290182*^9, 3.407998814931306*^9, 
   3.4082181090628643`*^9, 3.408427303672966*^9, 3.408427821321097*^9, 
   3.421671790054944*^9, 3.421672106076583*^9, 3.422338889675572*^9, 
   3.4225917395784388`*^9, 3.423213118938373*^9, 3.423639228133896*^9, 
   3.423639778785857*^9, 3.423657788548175*^9},ExpressionUUID->
  "9c8a3af0-1e1b-45ff-aed2-da416a2940eb"],
 "."
}], "MathCaption",
 CellChangeTimes->{{3.407872497874693*^9, 3.4078725139051332`*^9}, {
   3.407998334769004*^9, 3.407998349005952*^9}, {3.407998409528253*^9, 
   3.407998450868231*^9}, {3.407998497033436*^9, 3.407998590628295*^9}, {
   3.407998934878738*^9, 3.407998981938609*^9}, 3.421671572866338*^9, {
   3.421671627270052*^9, 3.421671630582344*^9}, {3.4216720541404552`*^9, 
   3.421672066442607*^9}, {3.423657794984571*^9, 
   3.4236578028700447`*^9}},ExpressionUUID->"67b7fe19-a33d-481b-8a12-\
4e7d4f0373b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.421672086519113*^9, 3.421672099714431*^9}, {
  3.426795199777626*^9, 3.4267952095648737`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"e9c36a03-9056-4392-be68-31f27840ac2f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]\[Kappa]", 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SP\[UnderBracket]\[Kappa][-$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[28]=",ExpressionUUID->"efa4afd9-35b6-409e-9fff-f30fff77a90f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"ae21c4c1-6b5e-4d0b-b151-51bf9e9e5e37"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Kappa]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"A", "A\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
  Editable->False]], "Output",
 CellLabel->"Out[29]=",ExpressionUUID->"0b6a2ad8-d8f5-473d-bff8-bb1b126e8cb5"]
}, Open  ]],

Cell[TextData[{
 "An interesting feature is the possibility of working with Hermitian \
spinors. These are defined by supplying the option ",
 StyleBox["Dagger->Hermitian", "Output"],
 " to ",
 StyleBox["DefSpinor", "Output"],
 "."
}], "MathCaption",
 TextJustification->1.,ExpressionUUID->"0b11ac82-7469-4111-9f0d-2e3898133cdb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Mu]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"Dagger", "->", "Hermitian"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.427085985430316*^9, 3.4270860171067038`*^9}, {
  3.4270862132868433`*^9, 3.427086217381256*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"1272db4a-405d-4d63-92bf-acff25851316"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Mu]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Mu][-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[30]:=",ExpressionUUID->"d37ce0e1-fd34-4620-afc0-5ed97d07e2d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Mu]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Mu]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A, \
-$CellContext`B\[Dagger], -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[30]:=",ExpressionUUID->"500258ba-c9ae-4ed6-8e21-5cb4c2dd2ce6"]
}, Open  ]],

Cell[TextData[{
 "We check that the new spinor ",
 StyleBox["\[Mu]", "Output"],
 " is hermitian."
}], "MathCaption",
 CellChangeTimes->{{3.407872497874693*^9, 3.4078725139051332`*^9}, {
   3.407998334769004*^9, 3.407998349005952*^9}, {3.407998409528253*^9, 
   3.407998450868231*^9}, {3.407998497033436*^9, 3.407998590628295*^9}, {
   3.407998934878738*^9, 3.407998981938609*^9}, 3.421671572866338*^9, {
   3.421671627270052*^9, 3.421671630582344*^9}, {3.4216720541404552`*^9, 
   3.421672066442607*^9}, {3.423657794984571*^9, 3.4236578028700447`*^9}, {
   3.427086159423438*^9, 3.427086171926608*^9}, {3.427086247487555*^9, 
   3.427086334273181*^9}, {3.427086373977705*^9, 3.427086393343368*^9}},
 TextJustification->1.,ExpressionUUID->"7479e49b-50fe-44ab-aad7-9ae9e3e06bd5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Mu]", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}]}], "]"}], "//", "Dagger"}]], "Input",
 CellChangeTimes->{{3.427086032714902*^9, 3.4270860418230553`*^9}, {
  3.427086226320509*^9, 3.42708623233148*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"6c1c2a51-a082-4318-9549-09279b182da8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Mu]", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"A", "A\[Dagger]", "B", "B\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Mu][-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]],
  Editable->False]], "Output",
 CellLabel->"Out[31]=",ExpressionUUID->"54e6972a-0f83-439b-bfbb-a9910e87ff2a"]
}, Open  ]],

Cell[TextData[{
 "Any Hermitian spinor has a tensor counterpart which is real. We compute the \
tensor counterpart of ",
 StyleBox["\[Mu]", "Output"],
 " and check that the result is a real rank-2 spacetime tensor."
}], "MathCaption",
 TextJustification->1.,ExpressionUUID->"10f32019-6ebf-4057-81cb-2735a53a967e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "PutSolderingForm"}], "//", 
  "ContractSolderingForm"}]], "Input",
 CellChangeTimes->{{3.4270860766423693`*^9, 3.427086098185977*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"02576d81-ef5d-48ea-b43c-8a6f2536fc45"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"TensorOfSpinor", "::", "name"}], "MessageName"], ":", 
  " ", "\<\"Tensor of \[NoBreak]\\!\\(\[Mu]\\)\[NoBreak] not defined. \
Prepending \[NoBreak]\\!\\(SP\\)\[NoBreak].\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"9509f39a-93cd-41bf-91e2-71936e7c4f35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]\[Mu]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of spinor \[Mu]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`SP\[UnderBracket]\[Mu][-$CellContext`a, -$CellContext`b], 
   ". ", "Equivalent of spinor \[Mu]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"28209962-9c30-4228-810a-3b250f96920b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Sigma]\[Mu]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP\[UnderBracket]\[Mu][-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[32]=",ExpressionUUID->"b13626fd-52d5-48d8-bc1a-2b8cbaa93f99"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Dagger"}]], "Input",
 CellChangeTimes->{{3.427086139497506*^9, 3.427086142759153*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"e2815f7f-47a9-42f4-9d86-00e402ef5214"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Sigma]\[Mu]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP\[UnderBracket]\[Mu][-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[33]=",ExpressionUUID->"7b2b1fbe-ba98-432d-be28-f362c5d78216"]
}, Open  ]],

Cell[TextData[{
 StyleBox["The ", "Text",
  FontWeight->"Plain"],
 StyleBox[" ", "Text"],
 StyleBox["xAct`", "Output"],
 " command ",
 StyleBox["ContractMetric", "Output"],
 " is aware of the standard index raising and lowering conventions for the \
spinor indices and therefore it can act on spinor expressions without further \
options. We present some examples:"
}], "MathCaption",ExpressionUUID->"83561dcc-9fc2-416b-bbd9-931d3ffad507"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Xi]", "[", "A", "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.426998336691737*^9, 3.426998356506386*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"bfbea130-4e33-4d7f-bd72-a78f7da8e530"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Xi]", "[", "A", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Xi][$CellContext`A], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"b8e9dac9-45bb-4057-9cb0-e97e62922cf2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Xi]\[Dagger]", "[", "A\[Dagger]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Xi]\[Dagger][$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"d6519fcc-eb9e-42c1-8525-a8027e3d0605"]
}, Open  ]],

Cell[TextData[StyleBox["We consider the following list of quantities.", "Text",
 FontWeight->"Plain"]], "MathCaption",
 CellChangeTimes->{{3.45827327730165*^9, 
  3.458273294313871*^9}},ExpressionUUID->"b574c663-4968-4ea1-889d-\
f069ba68dea2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Xi]", "[", 
     RowBox[{"-", "B"}], "]"}], 
    RowBox[{"\[Epsilon]", "[", 
     RowBox[{"A", ",", "B"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"\[Xi]", "[", "B", "]"}], 
    RowBox[{"\[Epsilon]", "[", 
     RowBox[{
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "A"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"\[Epsilon]\[Dagger]", "[", 
     RowBox[{"C\[Dagger]", ",", "A\[Dagger]"}], "]"}], 
    RowBox[{
     RowBox[{"CDe", "[", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "A\[Dagger]"}]}], "]"}], "@", 
     RowBox[{"\[Xi]", "[", 
      RowBox[{"-", "B"}], "]"}]}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.426998362122426*^9, 3.426998382780382*^9}, {
  3.426998416158865*^9, 3.42699849577859*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"ae380828-c2ae-4786-92fc-0d9f09088654"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {"A", "B"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][$CellContext`A, $CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi][-$CellContext`B],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"B"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi][$CellContext`B],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]\[Dagger]", 
         StyleBox[GridBox[{
            {"C\[Dagger]", "A\[Dagger]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][$CellContext`C\[Dagger], $CellContext`A\
\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubsuperscriptBox["\[EmptyDownTriangle]", "AA\[Dagger]", "  "], 
        GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {" "},
              {"B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
       $CellContext`\[Xi][-$CellContext`B]],
      Editable->False], ")"}]}]}], "}"}]], "Output",
 CellLabel->"Out[35]=",ExpressionUUID->"0ed01757-2ed4-4fc6-a8fb-96f953385067"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "/@", "%"}]], "Input",
 CellChangeTimes->{{3.4269983866133204`*^9, 3.42699839092733*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"65630c6e-3fad-4f48-a737-3be23efd0805"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Xi]", 
        StyleBox[GridBox[{
           {"A"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Xi][$CellContext`A],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Xi]", 
        StyleBox[GridBox[{
           {" "},
           {"A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Xi][-$CellContext`A],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubsuperscriptBox["\[EmptyDownTriangle]", 
       RowBox[{"A", " "}], 
       RowBox[{" ", "C\[Dagger]"}]], GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`A, $CellContext`C\[Dagger]][
     $CellContext`\[Xi][-$CellContext`B]],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[36]=",ExpressionUUID->"674abcc0-e55c-4fe4-a941-699652438d97"]
}, Open  ]],

Cell[TextData[{
 StyleBox["The same goes for the remaining", "Text",
  FontWeight->"Plain"],
 StyleBox[" ", "Text"],
 StyleBox["xAct`", "Output"],
 " commands. For example ",
 StyleBox["ToCanonical", "Output"],
 " takes into account the \"see-saw\" rule when canonicalising spinor \
expressions and adds the suitable signs.  Also it works with any kind of \
spinor expression without any further option. To see this let us canonicalise \
the following list of spinor expressions."
}], "MathCaption",ExpressionUUID->"601243bc-4087-4b07-bcf9-a8ee8afc3c0e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Xi]", "[", "A", "]"}], 
    RowBox[{"\[Xi]", "[", 
     RowBox[{"-", "A"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"\[Kappa]", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B\[Dagger]"}]}], "]"}], 
    RowBox[{"\[Xi]\[Dagger]", "[", "B\[Dagger]", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"CDe", "[", 
      RowBox[{
       RowBox[{"-", "F"}], ",", 
       RowBox[{"-", "F\[Dagger]"}]}], "]"}], "@", 
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{
        RowBox[{"-", "A"}], ",", "F\[Dagger]"}], "]"}], "@", 
      RowBox[{"PsiCDe", "[", 
       RowBox[{
        RowBox[{"-", "B"}], ",", 
        RowBox[{"-", "C"}], ",", 
        RowBox[{"-", "D"}], ",", 
        RowBox[{"-", "P"}]}], "]"}]}]}], "+", 
    RowBox[{
     RowBox[{"CDe", "[", 
      RowBox[{
       RowBox[{"-", "F"}], ",", "F\[Dagger]"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "F\[Dagger]"}]}], "]"}], "@", 
      RowBox[{"PsiCDe", "[", 
       RowBox[{
        RowBox[{"-", "B"}], ",", 
        RowBox[{"-", "C"}], ",", 
        RowBox[{"-", "D"}], ",", 
        RowBox[{"-", "P"}]}], "]"}]}]}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.4269988388540792`*^9, 3.4269988989735823`*^9}, {
  3.426999673694687*^9, 3.426999674201056*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"f187ff97-91dd-4b3b-ae5c-3f661425d9ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"A"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi][$CellContext`A],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Kappa]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B\[Dagger]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa][-$CellContext`A, -$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]\[Dagger]", 
         StyleBox[GridBox[{
            {"B\[Dagger]"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi]\[Dagger][$CellContext`B\[Dagger]],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", "FF\[Dagger]", "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"A", " "}], 
        RowBox[{" ", "F\[Dagger]"}]], GridBox[{
         {
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"B", "C", "D", "P"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`F, -$CellContext`F\[Dagger]][
      $CellContext`CDe[-$CellContext`A, $CellContext`F\[Dagger]][
       $CellContext`PsiCDe[-$CellContext`B, -C, -D, -$CellContext`P]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"F", " "}], 
        RowBox[{" ", "F\[Dagger]"}]], 
       SubsuperscriptBox["\[EmptyDownTriangle]", "AF\[Dagger]", "  "], 
       GridBox[{
         {
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"B", "C", "D", "P"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`F, $CellContext`F\[Dagger]][
      $CellContext`CDe[-$CellContext`A, -$CellContext`F\[Dagger]][
       $CellContext`PsiCDe[-$CellContext`B, -C, -D, -$CellContext`P]]],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->"Out[37]=",ExpressionUUID->"32e20486-240e-43f7-8af3-db4eec9eae1b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "/@", "%"}]], "Input",
 CellChangeTimes->{{3.4269989006945057`*^9, 3.42699890461005*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"5f38f59b-5ff8-409c-9a4b-387c226799b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Kappa]", 
          StyleBox[GridBox[{
             {" ", "B\[Dagger]"},
             {"A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Kappa][-$CellContext`A, $CellContext`B\[Dagger]],
      Editable->False]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]\[Dagger]", 
         StyleBox[GridBox[{
            {" "},
            {"B\[Dagger]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[38]=",ExpressionUUID->"21b06a1e-0b6b-4fb5-ad66-550258dfe8eb"]
}, Open  ]],

Cell[TextData[{
 "A spin structure can be undefined and all its dependent symbols are thus \
removed from the session. To accomplish this we remove first all the visitors \
of the soldering form ",
 StyleBox["\[Sigma]:", "Input",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.407872497874693*^9, 3.4078725139051332`*^9}, {
   3.4216723262584953`*^9, 3.4216723292199802`*^9}, {3.4216723991341467`*^9, 
   3.421672446206367*^9}, {3.4216727004057827`*^9, 3.4216727416539097`*^9}, {
   3.423659405584269*^9, 3.423659472045809*^9}, 3.424428250334961*^9, {
   3.426998952480644*^9, 3.426999029363946*^9}},
 TextJustification->1.,ExpressionUUID->"39cfbca4-f533-4454-93d6-5cbb51f6dfc0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Undef", "/@", 
   RowBox[{"VisitorsOf", "[", "\[Sigma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.426274094095079*^9, {3.426274360309009*^9, 3.426274362433446*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"93cccdc8-3b7b-4285-a947-1d6ce6326885"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]g\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]g\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"669ae457-eb8e-4477-9dde-802b1e047a18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]g"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]g],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"afa9763d-9516-47aa-8796-a124a57b58c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]epsilong\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]epsilong\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"248519a7-1931-426f-937c-627f6f6e1788"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]epsilong"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]epsilong],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"68d14a09-2856-435f-b71b-f0556a54891b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]FRiemannCDe\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]FRiemannCDe\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"fe007a7a-5737-4844-b849-abb75cdcb5ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]FRiemannCDe"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]FRiemannCDe],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"7eb012fb-61d1-4d5a-baf8-3b48cb6c438e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]RiemannCD\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]RiemannCD\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"bed4ea82-11bc-4baa-b1ee-305d283aaae7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]RiemannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]RiemannCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"556ebd67-9384-4693-927e-839934859f17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]RicciCD\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]RicciCD\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"cf5f57f5-9c80-40c1-b94b-e93fa38189ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]RicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]RicciCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"6df8b4cc-67be-4097-a0b3-73786b5c9b69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]WeylCD\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]WeylCD\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"33c8764c-639c-4c6c-ac36-c4ce13332360"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]WeylCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]WeylCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"399043c4-9c22-4963-abfa-161e24090bd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]TFRicciCD\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]TFRicciCD\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"0853b560-15ce-4e99-8c72-8ee596f831c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]TFRicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]TFRicciCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"edbfcf05-6646-4899-babb-a17dba72b5d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]\[Kappa]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`SP\[UnderBracket]\[Kappa]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"84429b65-ada0-4606-8d11-1495460e0783"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]\[Kappa]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`SP\[UnderBracket]\[Kappa]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"34d1b805-255d-47af-91f3-326e71691bbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]\[Mu]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`SP\[UnderBracket]\[Mu]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"26502d94-a093-4e48-ae77-981d2b9299a2"]
}, Open  ]],

Cell[TextData[{
 "and all the objects defined on the ",
 StyleBox["Spin",
  FontFamily->"Courier"],
 " vbundle :"
}], "MathCaption",
 CellChangeTimes->{{3.424428086208927*^9, 3.4244280954235973`*^9}, {
  3.424428189665428*^9, 3.424428194185422*^9}, {3.4582734069661283`*^9, 
  3.4582734075375977`*^9}},ExpressionUUID->"7d223e75-5462-4cb0-a68e-\
25b754f9bd59"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VisitorsOf", "@", "Spin"}]], "Input",
 CellChangeTimes->{{3.427003146607655*^9, 3.427003155157398*^9}, {
  3.4270043713193398`*^9, 3.42700438140557*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"5047e7ce-7df3-427f-9acb-9f2d6a1a3c27"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Kappa]", ",", "\[Kappa]\[Dagger]", ",", "\[Mu]", ",", "\[Mu]\[Dagger]", 
   ",", "\[Xi]"}], "}"}]], "Output",
 CellLabel->"Out[40]=",ExpressionUUID->"519810fe-8742-48d6-8a2b-3e0065628d13"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Undef", "/@", 
   RowBox[{"{", 
    RowBox[{"\[Kappa]", ",", "\[Xi]", ",", "\[Mu]"}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[41]:=",ExpressionUUID->"edd9ef46-e5b8-4471-b56c-7d2857a5ffe2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[Kappa]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[Kappa]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"c341b33b-5e52-468f-8616-11afcb78636f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[Kappa]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[Kappa]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"4b7dfba4-f3da-4b0a-93b1-da6c3d02e418"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[Xi]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[Xi]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"44855d2a-c3ec-4e02-960a-db09951845aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[Xi]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[Xi]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"21a1855e-c718-4e75-85c4-3a0272e1f5e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[Mu]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[Mu]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"338301b4-1085-4ce5-a360-0fb8b4c74b4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[Mu]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[Mu]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"aac7d7c4-6b5f-4b73-bec2-a174d00977b3"]
}, Open  ]],

Cell["\<\
Finally the spin structure and all its dependent objects are removed.\
\>", "MathCaption",
 CellChangeTimes->{{3.407872497874693*^9, 3.4078725139051332`*^9}, {
  3.4216723262584953`*^9, 3.4216723292199802`*^9}, {3.4216723991341467`*^9, 
  3.421672446206367*^9}, {3.4216727004057827`*^9, 3.4216727416539097`*^9}, {
  3.423659405584269*^9, 3.423659502129924*^9}, {3.423659833161021*^9, 
  3.423659844933424*^9}, {3.423801603342259*^9, 3.423801614911148*^9}, {
  3.427081960561952*^9, 
  3.42708196277032*^9}},ExpressionUUID->"143110b8-654a-45ff-b4f0-\
a1cc9b194de9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefSpinStructure", "[", "\[Sigma]", "]"}]], "Input",
 CellChangeTimes->{{3.423659282357909*^9, 3.423659335815239*^9}, {
   3.423671328957761*^9, 3.423671334212201*^9}, {3.424428563650785*^9, 
   3.4244285839828787`*^9}, {3.424430054678544*^9, 3.424430060211166*^9}, 
   3.4244494258905067`*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"03d6a670-0467-43a5-b5cd-fd815f1c5e8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "AChristoffelCDe\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", 
   " ", $CellContext`AChristoffelCDe\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"c63b6d08-dbdd-423f-afc4-39bb3d2615fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "AChristoffelCDe"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", " ", $CellContext`AChristoffelCDe],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"d0c4331d-2113-4047-96e4-6978649d28eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChiCDe\[Dagger]"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "curvature spinor", 
   " ", $CellContext`ChiCDe\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"8366b4bc-d1d7-403b-bf4a-83e27eb5be89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChiCDe"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "curvature spinor", 
   " ", $CellContext`ChiCDe],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"dca03051-cd68-470f-b080-d3c450b3a3a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ChristoffelCDCDe"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`ChristoffelCDCDe],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"ae1b38d9-5cb1-4405-b1b6-0920e66a57c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "FRiemannCDe\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemannCDe\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"649438b5-f63b-4824-b6e1-831992c98c02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "FRiemannCDe"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemannCDe],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"a1d119c0-b893-4824-9cb0-698d704f54c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor scalar curvature\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "LambdaCDe"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor scalar curvature", 
   " ", $CellContext`LambdaCDe],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"d87d924d-841f-45f8-ad24-9f76c0a1b80a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PhiCDe\[Dagger]"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "curvature spinor", 
   " ", $CellContext`PhiCDe\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"f7f52146-bcad-4369-9ef8-70d839825633"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PhiCDe"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "curvature spinor", 
   " ", $CellContext`PhiCDe],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"c70a0e7b-1534-4c70-a371-5e9d3547e48e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PsiCDe\[Dagger]"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl spinor", 
   " ", $CellContext`PsiCDe\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"e16141fe-4515-4ffd-b1e7-a114fc956610"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PsiCDe"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl spinor", 
   " ", $CellContext`PsiCDe],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"543f03d3-feb3-43a2-be38-1ff97fb4b833"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CDe"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CDe],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"904cc2c5-0c5a-4015-806d-6198100eba85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Sigma\[Sigma]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Sigma\[Sigma]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"288d9da5-d2d7-4d5f-b083-dde981aab916"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Sigma\[Sigma]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Sigma\[Sigma]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"d7f17eca-bcf3-4804-8eaa-721985261dc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "\[Epsilon]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spin metric", 
   " ", $CellContext`\[Epsilon]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"95d047cd-8148-40a7-88fe-99922b6d8749"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\[Epsilon]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spin metric", 
   " ", $CellContext`\[Epsilon]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"3fd689d0-fb0f-453c-bd2d-efa57710b0dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "\[Sigma]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "soldering form", 
   " ", $CellContext`\[Sigma]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"10756495-19fe-41f1-b3ed-784fde1d624a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\[Sigma]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "soldering form", 
   " ", $CellContext`\[Sigma]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"f1bf83bc-7a94-4d23-ab64-a8769ee25f5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["Spin\[Dagger]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Spin\[Dagger],
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "conjugated vbundle", 
   " ", $CellContext`Spin\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"560fd6de-d5e5-44a6-9235-a40e96fbabf6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["Spin",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Spin,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`Spin],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"eb2f3c41-2369-4af0-a981-5c095941674b"]
}, Open  ]],

Cell["Now, we are only left with spacetime quantities.", "MathCaption",
 CellChangeTimes->{{3.407872497874693*^9, 3.4078725139051332`*^9}, {
  3.4216723262584953`*^9, 3.4216723292199802`*^9}, {3.4216723991341467`*^9, 
  3.421672446206367*^9}, {3.4216727004057827`*^9, 3.4216727416539097`*^9}, {
  3.423659405584269*^9, 3.42365954242131*^9}, {3.423802187151116*^9, 
  3.423802189957775*^9}},ExpressionUUID->"e8830fc0-16b6-477d-a3d5-\
3a1fbc8909ea"],

Cell[CellGroupData[{

Cell[BoxData["$Tensors"], "Input",
 CellChangeTimes->{{3.421672753458947*^9, 3.4216727550362*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"7b5d56d1-2a96-47b7-9f4f-321a20f5baf6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "g", ",", "epsilong", ",", "Tetrag", ",", "Tetrag\[Dagger]", ",", 
   "TorsionCD", ",", "ChristoffelCD", ",", "RiemannCD", ",", "RicciCD", ",", 
   "RicciScalarCD", ",", "EinsteinCD", ",", "WeylCD", ",", "TFRicciCD", ",", 
   "KretschmannCD", ",", "Detg"}], "}"}]], "Output",
 CellLabel->"Out[43]=",ExpressionUUID->"186a5329-87ad-4a90-adef-82b40e8713bd"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2. Definition of a spin structure", "SubsectionIcon",
 CellChangeTimes->{{3.425973652310829*^9, 3.4259736524283648`*^9}, {
  3.425973736932426*^9, 3.425973750585252*^9}, {3.4259770424375963`*^9, 
  3.4259770436686907`*^9}, {3.426858921333981*^9, 
  3.4268589283254642`*^9}},ExpressionUUID->"381eb5f9-de6b-4a91-8e12-\
65b111fa6c4f"],

Cell[TextData[{
 StyleBox["In our present context we need the following ingredients to \
introduce a spin structure on a Lorentzian manifold: a 2-dimensional complex \
vector bundle (the spin bundle), the antisymmetric spin metric and the ",
  FontWeight->"Plain"],
 StyleBox["soldering form.",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[" This last quantity is a mixed object having indices in the spin \
bundle and the tangent bundle and serves to relate space-time quantities to \
spinor quantities and back (see e. g. appendix A of A. Ashtekar ",
  FontWeight->"Plain"],
 StyleBox["Lectures on non-perturbative canonical gravity",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[" World Scientific, Singapore, 1991). The explicit components of \
the soldering form in a basis are known as the ",
  FontWeight->"Plain"],
 StyleBox["Infeld-Van der Waerden symbols.",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[" It can be shown that there exists a unique covariant derivative \
(spin covariant derivative) which is compatible with both the spin metric and \
the soldering form. The restriction of the spin covariant derivative to \
tensors defined on the tangent bundle coincides with the Levi-Civita \
covariant derivative.\n\nIt is possible to introduce a spin structure both in \
a spacetime with or without torsion. We separate those two cases:",
  FontWeight->"Plain"]
}], "Text",
 TextJustification->1.,ExpressionUUID->"1e059b81-2666-4384-8671-c494e4fc2536"],

Cell[CellGroupData[{

Cell["2.1. Spin structures on spacetimes without torsion", "SubsubsectionIcon",ExpressionUUID->"c58ea939-f421-43ed-b945-51e309960b6a"],

Cell["\<\
To define a spin structure we need first a four dimensional Lorentzian \
manifold \
\>", "MathCaption",
 CellChangeTimes->{{3.422592015031691*^9, 3.4225920436791553`*^9}, {
  3.423659911246599*^9, 3.423659920924469*^9}, {3.4238033577306767`*^9, 
  3.423803461072209*^9}, {3.423903706656168*^9, 3.4239037084819403`*^9}, {
  3.424430170212186*^9, 3.424430179440365*^9}, {3.424435475457535*^9, 
  3.424435513476344*^9}, {3.425977728478373*^9, 3.42597774910154*^9}, {
  3.425977783660974*^9, 3.4259777879811983`*^9}, {3.4259778703897543`*^9, 
  3.425977871380618*^9}},ExpressionUUID->"c1dbca0d-5506-4766-87fe-\
2c67243087d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$Manifolds", ",", "$Metrics", ",", 
   RowBox[{"DimOfManifold", "/@", "$Manifolds"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.4259777918037*^9, 3.425977858912298*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"903a90c9-a15f-4499-a97c-aec55ca8fbe3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "M4", "}"}], ",", 
   RowBox[{"{", "g", "}"}], ",", 
   RowBox[{"{", "4", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[44]=",ExpressionUUID->"93ab3af9-5815-48d2-ac18-957dec7841bb"]
}, Open  ]],

Cell[TextData[{
 StyleBox["DefSpinStructure", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 "                        Define a spin structure on a four dimensional \
Lorentzian manifold.\n",
 StyleBox["UndefSpinStructure", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["                   Undefine a spin structure.", "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["  \n$SolderingForms", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["                           List of soldering forms (a.k.a. spin \
structures).", "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}], "FramedBox",
 CellChangeTimes->{{3.4582735151296263`*^9, 
  3.458273520940234*^9}},ExpressionUUID->"7c796279-3b4f-4560-8804-\
e0390ee38c21"],

Cell[TextData[{
 "We define a spin structure comprising the complex vector bundle ",
 StyleBox["Spin", "Input",
  FontWeight->"Plain"],
 " whose abstract indices are ",
 StyleBox["{A, B, C, D, F, H, L, P, Q}", "Input",
  FontWeight->"Plain"],
 StyleBox[".", "Input"],
 " We need to supply as arguments the name of the metric tensor of the \
background Lorentzian manifold",
 StyleBox[" ", "Input"],
 StyleBox["g[-a,-b]", "Input",
  FontWeight->"Plain"],
 ", the name of the antisymmetric spin metric",
 StyleBox[" ", "Input"],
 StyleBox["\[Epsilon][-A,-B]", "Input",
  FontWeight->"Plain"],
 StyleBox[",", "Input"],
 " the name of the soldering form ",
 StyleBox["\[Sigma][a,-A,-A\[Dagger]]", "Input",
  FontWeight->"Plain"],
 " and the name of the spin covariant derivative ",
 StyleBox["CDe[-a].", "Input",
  FontWeight->"Plain"],
 "The option ",
 StyleBox["SpinorPrefix", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["is used to introduce a tag which will be  prepended automatically \
to  any spinor related to a spacetime tensor and t", "Text",
  FontWeight->"Plain"],
 "he option ",
 StyleBox["SpinorMark", "Input",
  FontWeight->"Plain"],
 StyleBox[" introduces a formatting of the tag ", "Text",
  FontWeight->"Plain"],
 StyleBox["SP", "Input",
  FontWeight->"Plain"],
 StyleBox[" different to the default one. The long output of ", "Text",
  FontWeight->"Plain"],
 StyleBox["DefSpinStructure", "Input",
  FontWeight->"Plain"],
 StyleBox[" can be suppressed  by adding the option ", "Text",
  FontWeight->"Plain"],
 StyleBox["Info->False", "Text",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 StyleBox[" which deactivates the information of the definition commands .", 
  "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.422592015031691*^9, 3.4225920436791553`*^9}, {
  3.423659911246599*^9, 3.423659920924469*^9}, {3.4238033577306767`*^9, 
  3.423803461072209*^9}, {3.423903706656168*^9, 3.4239037084819403`*^9}, {
  3.424430170212186*^9, 3.424430179440365*^9}, {3.424435475457535*^9, 
  3.424435513476344*^9}, {3.425978223906472*^9, 3.4259782885675507`*^9}, {
  3.425978322684931*^9, 3.425978480847075*^9}, {3.425978535164961*^9, 
  3.425978551420761*^9}, {3.425978712995872*^9, 3.425978738857109*^9}, {
  3.425978823279792*^9, 3.4259788432405987`*^9}, {3.425978874689502*^9, 
  3.425978972286923*^9}, {3.425979461962414*^9, 3.4259794971533117`*^9}, {
  3.4262743972229977`*^9, 3.426274410570972*^9}, {3.427005863463368*^9, 
  3.427005864782279*^9}, {3.427005903846085*^9, 3.427005927664051*^9}, {
  3.4270059766540213`*^9, 3.427005981174581*^9}, {3.427084033378055*^9, 
  3.4270840564568443`*^9}},
 TextJustification->1.,ExpressionUUID->"e5c0883e-1f9e-4cd1-8668-3ab5a29b4597"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{
    "A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "H", ",", "L", ",", "P",
      ",", "Q"}], "}"}], ",", "\[Epsilon]", ",", "\[Sigma]", ",", "CDe", ",", 
   
   RowBox[{"SpinorPrefix", "->", "SP"}], ",", 
   RowBox[{"SpinorMark", "->", "\"\<S\>\""}], ",", 
   RowBox[{"DefInfo", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"e57392d3-37e4-4fc3-b020-661c5e8a81b1"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], ":", 
  " ", "\<\"System name \[NoBreak]\\!\\(\\\"C\\\"\\)\[NoBreak] is overloaded \
as an abstract index.\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"58292851-29ac-48b7-b0f9-7b1347e6ec2f"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], ":", 
  " ", "\<\"System name \[NoBreak]\\!\\(\\\"D\\\"\\)\[NoBreak] is overloaded \
as an abstract index.\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"3573b920-ce50-4907-8f1a-8d44d7f3b898"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma][$CellContext`a, -C, -$CellContext`D\[Dagger]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"c7067db9-1fff-42cc-b7c4-0bc61b2d831d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[Dagger]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma]\[Dagger][$CellContext`a, -$CellContext`C\[Dagger], -
    D], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"48b2eb65-1f41-447c-9373-91277904da8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"5d38e85d-2814-4f33-ac11-296a2784b557"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"4fb9b063-a88b-4541-8ead-06ad60c50b16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDe", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`ChristoffelCDCDe[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"a0aae67a-b0b0-4cc6-9d52-d72efd20a8f7"]
}, Open  ]],

Cell["\<\
We choose a formatting for the \"primed\" spinor indices according to the \
standard conventions used in the literature. \
\>", "MathCaption",
 CellChangeTimes->{
  3.407866628317771*^9, {3.407866936403089*^9, 3.407866994173277*^9}, {
   3.40786711899345*^9, 3.407867139720908*^9}, {3.407867771975953*^9, 
   3.4078678153605843`*^9}, {3.407868843671587*^9, 3.40786890495704*^9}, {
   3.407868955907063*^9, 3.4078689722678747`*^9}, {3.407869139909814*^9, 
   3.4078691538233137`*^9}, {3.407869301196363*^9, 3.407869302218423*^9}, {
   3.40794030844033*^9, 3.407940335240353*^9}, {3.407943056220756*^9, 
   3.407943067078417*^9}, {3.407943224304532*^9, 3.407943264822106*^9}, {
   3.421668727325492*^9, 3.4216687602706137`*^9}, {3.4216689522590857`*^9, 
   3.421668975057513*^9}, {3.421996138967409*^9, 3.421996226553336*^9}, 
   3.426956420364349*^9, 3.427084082827977*^9, {3.427109381109776*^9, 
   3.42710939725222*^9}, {3.427274936516885*^9, 3.427274938219595*^9}, {
   3.4582735672110863`*^9, 3.458273651019367*^9}},
 TextJustification->1.,ExpressionUUID->"0d901442-45c6-4126-869f-89b24faca6e2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAs", "[", "A\[Dagger]", "]"}], "^=", "\"\<A'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "B\[Dagger]", "]"}], "^=", "\"\<B'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "C\[Dagger]", "]"}], "^=", "\"\<C'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "D\[Dagger]", "]"}], "^=", "\"\<D'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "F\[Dagger]", "]"}], "^=", "\"\<F'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "H\[Dagger]", "]"}], "^=", "\"\<H'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "L\[Dagger]", "]"}], "^=", "\"\<L'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "M\[Dagger]", "]"}], "^=", "\"\<M'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "P\[Dagger]", "]"}], "^=", "\"\<P'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "Q\[Dagger]", "]"}], "^=", "\"\<Q'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "\[Epsilon]\[Dagger]", "]"}], "^=", 
     "\"\<\!\(\*OverscriptBox[\(\[Epsilon]\), \(__\)]\)\>\""}]}], "}"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.421669006990326*^9, 3.4216690979643993`*^9}, {
  3.421669142640335*^9, 3.4216692111872253`*^9}, {3.427013981707185*^9, 
  3.427013985803987*^9}, {3.4270247559011383`*^9, 3.427024770094125*^9}, {
  3.427024812025331*^9, 3.427024813464142*^9}, {3.42726282558427*^9, 
  3.4272628308394337`*^9}, {3.427263239103531*^9, 3.427263258811751*^9}, {
  3.427263297247272*^9, 3.427263401161145*^9}, {3.4272748584478416`*^9, 
  3.427274933143834*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"83ffd7d4-100e-47f7-8989-159005060449"],

Cell[TextData[{
 StyleBox["By convention we choose the  symbol ", "Text",
  FontWeight->"Plain"],
 StyleBox["\[Sigma] ", "Input",
  FontWeight->"Plain"],
 StyleBox["as the representative of all the elements which comprise the spin \
structure. Hence it will sometimes be referred to as \"the spin structure\". \
In particular this means that it is the host of the spinor counterparts of \
the metric tensor, the volume element and all the curvature spinors \
associated to the covariant derivative ", "Text",
  FontWeight->"Plain"],
 StyleBox["CDe", "Input",
  FontWeight->"Plain"],
 StyleBox[" .", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.4259789828283978`*^9, 3.425979043214308*^9}, {
  3.425979142358512*^9, 3.4259791755022297`*^9}, {3.425979597062771*^9, 
  3.425979707743182*^9}, {3.425979796310693*^9, 3.4259798398067503`*^9}, {
  3.425980769959943*^9, 3.425980774431723*^9}, {3.4270136000233717`*^9, 
  3.427013608865385*^9}, {3.427014368741612*^9, 3.427014379576563*^9}, {
  3.427084293538821*^9, 3.427084456124735*^9}, {3.427084649071929*^9, 
  3.42708466602608*^9}, {3.4273510968724546`*^9, 3.427351119663622*^9}},
 TextJustification->1.,ExpressionUUID->"dd537edd-5d03-48ca-b408-caf2c4ef0461"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VisitorsOf", "@", "\[Sigma]"}]], "Input",
 CellChangeTimes->{{3.427014417527832*^9, 3.427014421349196*^9}, {
  3.4270146139563303`*^9, 3.427014663593747*^9}, {3.427014711858138*^9, 
  3.427014714427032*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"eb32f4af-6191-4221-aa6b-90d52083f4b8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "SP\[UnderBracket]g", ",", "SP\[UnderBracket]epsilong", ",", 
   "SP\[UnderBracket]FRiemannCDe", ",", "SP\[UnderBracket]RiemannCD", ",", 
   "SP\[UnderBracket]RicciCD", ",", "SP\[UnderBracket]WeylCD", ",", 
   "SP\[UnderBracket]TFRicciCD"}], "}"}]], "Output",
 CellLabel->"Out[47]=",ExpressionUUID->"57d34c23-0a1e-4b11-a463-112c15aa6447"]
}, Open  ]],

Cell[TextData[{
 StyleBox["The set of soldering forms is kept in the global variable ", "Text",
  FontWeight->"Plain"],
 StyleBox["$SolderingForms.", "Output",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.4259789828283978`*^9, 3.425979043214308*^9}, {
  3.425979142358512*^9, 3.4259791755022297`*^9}, {3.425979597062771*^9, 
  3.425979707743182*^9}, {3.425979796310693*^9, 3.4259798398067503`*^9}, {
  3.425979871150588*^9, 3.4259798973486633`*^9}, {3.425979931268716*^9, 
  3.425979940398102*^9}, {3.425980067756447*^9, 3.425980116908681*^9}, {
  3.426795259745358*^9, 3.42679529859709*^9}, {3.427014306800693*^9, 
  3.42701431351892*^9}, {3.427014752615773*^9, 3.427014771103253*^9}, {
  3.427014982903729*^9, 
  3.427015051191009*^9}},ExpressionUUID->"480c84a1-effd-4826-b0b8-\
96c4e261348a"],

Cell[CellGroupData[{

Cell[BoxData["$SolderingForms"], "Input",
 CellChangeTimes->{{3.4270149992728853`*^9, 3.427015014714425*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"65bbd018-8cd1-408c-8c07-2b55da2ddb71"],

Cell[BoxData[
 RowBox[{"{", "\[Sigma]", "}"}]], "Output",
 CellLabel->"Out[48]=",ExpressionUUID->"badf5e57-60d6-41d1-b9bd-b2b429df47d8"]
}, Open  ]],

Cell[TextData[StyleBox["All the essential algebraic properties of the \
soldering form are included as automatic rules. Example:", "Text",
 FontWeight->"Plain"]], "MathCaption",
 CellChangeTimes->{{3.4259789828283978`*^9, 3.425979043214308*^9}, {
  3.425979142358512*^9, 3.4259791755022297`*^9}, {3.425979597062771*^9, 
  3.425979707743182*^9}, {3.425979796310693*^9, 3.4259798398067503`*^9}, {
  3.425979871150588*^9, 3.4259798973486633`*^9}, {3.425979931268716*^9, 
  3.425979940398102*^9}, {3.425980067756447*^9, 3.425980116908681*^9}, {
  3.426795259745358*^9, 3.42679529859709*^9}, {3.427014306800693*^9, 
  3.42701431351892*^9}, {3.427014752615773*^9, 3.427014771103253*^9}, {
  3.427014982903729*^9, 3.427015051191009*^9}, {3.427085076037836*^9, 
  3.427085100637289*^9}, {3.458273680550215*^9, 
  3.458273682572407*^9}},ExpressionUUID->"51416d3c-30ae-442b-9ff2-\
5ee4bd950e0a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Sigma]", "[", 
     RowBox[{"a", ",", 
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
    RowBox[{"\[Sigma]", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "B\[Dagger]"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"\[Sigma]", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "A", ",", "A\[Dagger]"}], "]"}], 
    RowBox[{"\[Sigma]", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "A\[Dagger]"}]}], "]"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.4270851017428627`*^9, 3.4270851505022573`*^9}, {
  3.427085371647419*^9, 3.427085420012269*^9}, {3.427085457453208*^9, 
  3.4270854582599993`*^9}, {3.42735113387024*^9, 3.427351135107834*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"5f13e6a2-32b7-40cc-9eea-921b98ee4243"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "__"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
     Editable->False]}], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[49]=",ExpressionUUID->"bdf73568-eb92-4d46-b507-ed28ad2909b6"]
}, Open  ]],

Cell[TextData[{
 StyleBox["It is possible to define a second spin structure on the manifold ",
   "Text",
  FontWeight->"Plain"],
 StyleBox["M4", "Output",
  FontWeight->"Plain"],
 StyleBox[". ", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.4259789828283978`*^9, 3.425979043214308*^9}, {
   3.425979142358512*^9, 3.4259791755022297`*^9}, {3.425979597062771*^9, 
   3.425979707743182*^9}, {3.425979796310693*^9, 3.4259798398067503`*^9}, {
   3.425979871150588*^9, 3.4259798973486633`*^9}, {3.425979931268716*^9, 
   3.425979940398102*^9}, {3.425980067756447*^9, 3.425980116908681*^9}, {
   3.426795259745358*^9, 3.42679529859709*^9}, {3.427014306800693*^9, 
   3.42701431351892*^9}, {3.427014752615773*^9, 3.427014771103253*^9}, {
   3.427014982903729*^9, 3.427015073341551*^9}, {3.427015157047844*^9, 
   3.4270151695032167`*^9}, {3.4270152175997334`*^9, 
   3.4270152291514606`*^9}, {3.427015293663567*^9, 3.427015304159947*^9}, 
   3.427015346121428*^9},ExpressionUUID->"d9163bd0-a6d8-4764-ac94-\
14dfaf4de9c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin2", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Delta]", ",", 
     "\[Mu]", ",", "\[Nu]"}], "}"}], ",", "\[Epsilon]2", ",", "\[Sigma]2", 
   ",", "CDe2", ",", 
   RowBox[{"SpinorPrefix", "->", "SP2"}], ",", 
   RowBox[{"SpinorMark", "->", "\"\<S2\>\""}], ",", 
   RowBox[{"DefInfo", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"b98f2a60-0329-464f-b558-a1866c6f480e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]2", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Delta]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma]2[$CellContext`a, -$CellContext`\[Gamma], \
-$CellContext`\[Delta]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[50]:=",ExpressionUUID->"811de110-e51c-4b06-b936-39c8b8aba940"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]2\[Dagger]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "\[Gamma]\[Dagger]"}], ",", 
     RowBox[{"-", "\[Delta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma]2\[Dagger][$CellContext`a, -$CellContext`\[Gamma]\
\[Dagger], -$CellContext`\[Delta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[50]:=",ExpressionUUID->"6e992fb6-cb52-4b59-8cb8-85b13588729e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon]2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[50]:=",ExpressionUUID->"1359a20f-4e91-43b2-81b6-3b846cf3d31d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]2\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]\[Dagger]"}], ",", 
     RowBox[{"-", "\[Beta]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon]2\[Dagger][-$CellContext`\[Alpha]\[Dagger], \
-$CellContext`\[Beta]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[50]:=",ExpressionUUID->"043c6d17-7137-4f3e-bce4-0b037d147e2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDe2", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`ChristoffelCDCDe2[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[50]:=",ExpressionUUID->"05638a04-3b53-4c03-845f-97a119f99f3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$SolderingForms"], "Input",
 CellChangeTimes->{{3.4270149992728853`*^9, 3.427015014714425*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"fab01041-b0ed-4e7d-8b81-2d8e4414f19d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Sigma]", ",", "\[Sigma]2"}], "}"}]], "Output",
 CellLabel->"Out[51]=",ExpressionUUID->"8d33adea-9348-4e35-8b0d-57be073f3730"]
}, Open  ]],

Cell[TextData[{
 StyleBox["If we have more than one spin structure in the session then we \
need to specify which one are we working with in some of the ", "Text",
  FontWeight->"Plain"],
 StyleBox["Spinors`", "Output",
  FontWeight->"Plain"],
 StyleBox[" commands. Otherwise it is automatically assumed that we work with \
the default spin structure which is the first element of the list ", "Text",
  FontWeight->"Plain"],
 StyleBox["$SolderingForms.", "Output"],
 StyleBox["Examples:", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.4259789828283978`*^9, 3.425979043214308*^9}, {
   3.425979142358512*^9, 3.4259791755022297`*^9}, {3.425979597062771*^9, 
   3.425979707743182*^9}, {3.425979796310693*^9, 3.4259798398067503`*^9}, {
   3.425979871150588*^9, 3.4259798973486633`*^9}, {3.425979931268716*^9, 
   3.425979940398102*^9}, {3.425980067756447*^9, 3.425980116908681*^9}, {
   3.426795259745358*^9, 3.42679529859709*^9}, {3.427014306800693*^9, 
   3.42701431351892*^9}, {3.427014752615773*^9, 3.427014771103253*^9}, {
   3.427014982903729*^9, 3.427015073341551*^9}, {3.427015157047844*^9, 
   3.4270151695032167`*^9}, {3.4270152175997334`*^9, 
   3.4270152291514606`*^9}, {3.427015293663567*^9, 3.427015304159947*^9}, {
   3.427015346121428*^9, 3.427015489543153*^9}, {3.427018628328649*^9, 
   3.427018644935361*^9}, 3.427018841769825*^9},
 TextJustification->1.,ExpressionUUID->"774cc060-fa62-46db-8ef5-1bf198e90541"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.427015427897019*^9, 3.4270154352853003`*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"2ca981a8-2532-4b6b-b1a4-d42b6a4fb5e5"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[52]=",ExpressionUUID->"c74342ad-b642-4dc9-8783-d21a741affc2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"IndicesOf", "[", "]"}], ",", "\[Sigma]2"}], "]"}]], "Input",
 CellChangeTimes->{{3.4270154924747257`*^9, 3.427015544145859*^9}, {
   3.427015711882571*^9, 3.427015713186002*^9}, {3.427015745627071*^9, 
   3.427015757146021*^9}, {3.427016375507308*^9, 3.4270163963721247`*^9}, 
   3.42701682495389*^9, {3.427017398219408*^9, 3.427017399386217*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"2247c68b-6f33-4215-ab69-8e4adf0ce52c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]2", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "\[Alpha]", "\[Alpha]\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]2[$CellContext`a, -$CellContext`\[Alpha], \
-$CellContext`\[Alpha]\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]2", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "\[Beta]", "\[Beta]\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]2[$CellContext`b, -$CellContext`\[Beta], \
-$CellContext`\[Beta]\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]2", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "\[Gamma]", "\[Gamma]\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]2[$CellContext`c, -$CellContext`\[Gamma], \
-$CellContext`\[Gamma]\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]2", 
       StyleBox[GridBox[{
          {"d", " ", " "},
          {" ", "\[Delta]", "\[Delta]\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]2[$CellContext`d, -$CellContext`\[Delta], \
-$CellContext`\[Delta]\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[53]=",ExpressionUUID->"53676cd7-746d-40e5-be18-11759bc82bd2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4270157867368937`*^9, 3.42701579157337*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"eb4e0b96-079f-4d01-b59a-e2768bb91835"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"S2R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"\[Alpha]", "\[Alpha]\[Dagger]", "\[Beta]", "\[Beta]\[Dagger]", 
          "\[Gamma]", "\[Gamma]\[Dagger]", "\[Delta]", "\[Delta]\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP2\[UnderBracket]RiemannCD[-$CellContext`\[Alpha], \
-$CellContext`\[Alpha]\[Dagger], -$CellContext`\[Beta], -$CellContext`\[Beta]\
\[Dagger], -$CellContext`\[Gamma], -$CellContext`\[Gamma]\[Dagger], \
-$CellContext`\[Delta], -$CellContext`\[Delta]\[Dagger]],
  Editable->False]], "Output",
 CellLabel->"Out[54]=",ExpressionUUID->"4f752c52-6e06-428c-ad68-1e9e183042b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.427015797348269*^9, 3.4270158029169483`*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"46a990f3-46d3-4b1a-8b28-b348ebc75cab"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          "\[Dagger]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"\[Alpha]\[Dagger]", "\[Beta]\[Dagger]", "\[Delta]\[Dagger]", 
             "\[Gamma]\[Dagger]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe2\[Dagger][-$CellContext`\[Alpha]\[Dagger], \
-$CellContext`\[Beta]\[Dagger], -$CellContext`\[Delta]\[Dagger], \
-$CellContext`\[Gamma]\[Dagger]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]2", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Beta]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]2[-$CellContext`\[Alpha], -$CellContext`\[Beta]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]2", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Delta]", "\[Gamma]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]2[-$CellContext`\[Delta], -$CellContext`\[Gamma]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"\[Alpha]", "\[Beta]", "\[Delta]\[Dagger]", "\[Gamma]\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Delta]\[Dagger], -$CellContext`\[Gamma]\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]2", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Delta]", "\[Gamma]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]2[-$CellContext`\[Delta], -$CellContext`\[Gamma]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]2\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]\[Dagger]", "\[Beta]\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]2\[Dagger][-$CellContext`\[Alpha]\[Dagger], \
-$CellContext`\[Beta]\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LambdaCDe2[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]2", 
           StyleBox[GridBox[{
              {" ", " "},
              {"\[Alpha]", "\[Delta]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]2[-$CellContext`\[Alpha], \
-$CellContext`\[Delta]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]2", 
           StyleBox[GridBox[{
              {" ", " "},
              {"\[Beta]", "\[Gamma]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]2[-$CellContext`\[Beta], -$CellContext`\[Gamma]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]2\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"\[Alpha]\[Dagger]", "\[Delta]\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]2\[Dagger][-$CellContext`\[Alpha]\[Dagger], \
-$CellContext`\[Delta]\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]2\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"\[Beta]\[Dagger]", "\[Gamma]\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]2\[Dagger][-$CellContext`\[Beta]\[Dagger], \
-$CellContext`\[Gamma]\[Dagger]],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]2", 
           StyleBox[GridBox[{
              {" ", " "},
              {"\[Alpha]", "\[Gamma]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]2[-$CellContext`\[Alpha], \
-$CellContext`\[Gamma]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]2", 
           StyleBox[GridBox[{
              {" ", " "},
              {"\[Beta]", "\[Delta]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]2[-$CellContext`\[Beta], -$CellContext`\[Delta]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]2\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"\[Alpha]\[Dagger]", "\[Gamma]\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]2\[Dagger][-$CellContext`\[Alpha]\[Dagger], \
-$CellContext`\[Gamma]\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]2\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"\[Beta]\[Dagger]", "\[Delta]\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]2\[Dagger][-$CellContext`\[Beta]\[Dagger], \
-$CellContext`\[Delta]\[Dagger]],
       Editable->False]}]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"\[Delta]", "\[Gamma]", "\[Alpha]\[Dagger]", "\[Beta]\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe2[-$CellContext`\[Delta], -$CellContext`\[Gamma], \
-$CellContext`\[Alpha]\[Dagger], -$CellContext`\[Beta]\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]2", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Beta]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]2[-$CellContext`\[Alpha], -$CellContext`\[Beta]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]2\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Delta]\[Dagger]", "\[Gamma]\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]2\[Dagger][-$CellContext`\[Delta]\[Dagger], \
-$CellContext`\[Gamma]\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"\[Alpha]", "\[Beta]", "\[Delta]", "\[Gamma]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PsiCDe2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Delta], -$CellContext`\[Gamma]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]2\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]\[Dagger]", "\[Beta]\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]2\[Dagger][-$CellContext`\[Alpha]\[Dagger], \
-$CellContext`\[Beta]\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]2\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Delta]\[Dagger]", "\[Gamma]\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]2\[Dagger][-$CellContext`\[Delta]\[Dagger], \
-$CellContext`\[Gamma]\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[55]=",ExpressionUUID->"282fbec3-4bed-40f0-9107-906aa9360c88"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.427015427897019*^9, 3.4270154352853003`*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"35fe085e-4835-4fd4-a7d9-244722d22071"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[56]=",ExpressionUUID->"316fe558-b836-4f7c-80bc-1f2d7a888b84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "\[Sigma]2", "]"}], "[", "%", 
  "]"}]], "Input",
 CellChangeTimes->{{3.427015838328945*^9, 3.4270158613139763`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"30896fcd-3df9-47e3-a11a-3bd562626914"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"S2R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " ", " ", " ", " ", " "},
          {"\[Alpha]", "\[Alpha]\[Dagger]", "\[Beta]", "\[Beta]\[Dagger]", 
           "\[Gamma]", "\[Gamma]\[Dagger]", "\[Delta]", "\[Delta]\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SP2\[UnderBracket]RiemannCD[-$CellContext`\[Alpha], \
-$CellContext`\[Alpha]\[Dagger], -$CellContext`\[Beta], -$CellContext`\[Beta]\
\[Dagger], -$CellContext`\[Gamma], -$CellContext`\[Gamma]\[Dagger], \
-$CellContext`\[Delta], -$CellContext`\[Delta]\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]2", 
       StyleBox[GridBox[{
          {" ", "\[Alpha]", "\[Alpha]\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]2[-$CellContext`a, $CellContext`\[Alpha], \
$CellContext`\[Alpha]\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]2", 
       StyleBox[GridBox[{
          {" ", "\[Beta]", "\[Beta]\[Dagger]"},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]2[-$CellContext`b, $CellContext`\[Beta], \
$CellContext`\[Beta]\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]2", 
       StyleBox[GridBox[{
          {" ", "\[Gamma]", "\[Gamma]\[Dagger]"},
          {"c", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]2[-$CellContext`c, $CellContext`\[Gamma], \
$CellContext`\[Gamma]\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]2", 
       StyleBox[GridBox[{
          {" ", "\[Delta]", "\[Delta]\[Dagger]"},
          {"d", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]2[-$CellContext`d, $CellContext`\[Delta], \
$CellContext`\[Delta]\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[57]=",ExpressionUUID->"93fc9d5e-7ea6-4ccb-98f1-ebc30d9075e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"IndicesOf", "[", "]"}], ",", "\[Sigma]2"}], "]"}]], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"e8fe1655-255d-4f21-b936-a5afe20a04fe"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"S2R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"\[Alpha]", "\[Alpha]\[Dagger]", "\[Beta]", "\[Beta]\[Dagger]", 
          "\[Gamma]", "\[Gamma]\[Dagger]", "\[Delta]", "\[Delta]\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP2\[UnderBracket]RiemannCD[-$CellContext`\[Alpha], \
-$CellContext`\[Alpha]\[Dagger], -$CellContext`\[Beta], -$CellContext`\[Beta]\
\[Dagger], -$CellContext`\[Gamma], -$CellContext`\[Gamma]\[Dagger], \
-$CellContext`\[Delta], -$CellContext`\[Delta]\[Dagger]],
  Editable->False]], "Output",
 CellLabel->"Out[58]=",ExpressionUUID->"d30efedb-ef7b-4437-9a09-4a6c22b3b85f"]
}, Open  ]],

Cell[TextData[{
 StyleBox["We remove the spin structure ", "Text",
  FontWeight->"Plain"],
 StyleBox["\[Sigma]2.", "Output",
  FontWeight->"Plain"],
 StyleBox[" As usual, we start with the visitors of ", "Text",
  FontWeight->"Plain"],
 StyleBox["\[Sigma]2", "Output",
  FontWeight->"Plain"],
 StyleBox[" and then we proceed to erase the spin structure itself. ", "Text",
  
  FontWeight->"Plain"]
}], "MathCaption",ExpressionUUID->"6effe3a0-4aa7-4be1-9ab4-fd7709855aa3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Undef", "/@", 
   RowBox[{"VisitorsOf", "@", "\[Sigma]2"}]}], ";"}]], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"86bc500b-14e5-4a87-bc13-da9b0bccbe81"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefSpinStructure", "@", "\[Sigma]2"}]], "Input",
 CellChangeTimes->{{3.427017594960556*^9, 3.427017603645615*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"99871086-4cb4-4343-8375-8d1b929d258b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ChristoffelCDCDe2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`ChristoffelCDCDe2],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"26e08b5b-45b6-4bb1-8b62-82fecca9f233"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "\[Epsilon]2\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spin metric", 
   " ", $CellContext`\[Epsilon]2\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"a9c8ead8-43c4-4cdf-ad16-f5d61d561cb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\[Epsilon]2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spin metric", 
   " ", $CellContext`\[Epsilon]2],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"2a099f30-685f-49c4-b102-0661fd2a4182"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "\[Sigma]2\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "soldering form", 
   " ", $CellContext`\[Sigma]2\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"3fc95c6a-f7a7-4449-bfa7-c2efd6cb22ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\[Sigma]2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "soldering form", 
   " ", $CellContext`\[Sigma]2],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"c7f6ffc5-4c6e-4891-b02b-e1fca751329d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. Spin structures on spacetimes with torsion", "SubsubsectionIcon",ExpressionUUID->"0dc2e54d-f2ff-4eba-a552-ac088c97724d"],

Cell["\<\
It is possible to define a spin structure on a spacetime in which the \
connection compatible with the metric tensor is assumed to have torsion. In \
this section we illustrate this.\
\>", "Text",
 CellChangeTimes->{{3.4346485852112617`*^9, 3.434648677577577*^9}},
 FontWeight->"Plain",ExpressionUUID->"b0846056-0a25-468a-aa72-c43e4556c9e0"],

Cell["\<\
 We need to define a new 4-dimensional manifold and a new metric. Note the \
non-standard symmetry properties of the curvature tensors:\
\>", "MathCaption",ExpressionUUID->"71b4441f-e8bf-4918-ad85-8874be018dbf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"MT", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Delta]", ",", 
     "\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Lambda]"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.422186457176779*^9, 3.42218645874576*^9}, {
  3.434649339453578*^9, 3.4346494027757397`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"09ec0c48-c37f-485a-bddf-e96aa0e5a4be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "MT", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`MT, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"e4387b64-5db0-4c41-be7b-59dbad20a60f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentMT", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentMT, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"1269d273-60b6-4bde-aca6-e123170d92d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"G", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], ",", "cd", ",", 
   RowBox[{"Torsion", "->", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.527405001927771*^9, 3.527405003467515*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"30681871-9ed9-42fb-9c7f-282d00942970"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"G", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`G[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"ac7e0c80-5658-42fd-b9bc-2277e061a740"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilonG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Delta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilonG[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Delta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"d755e4d2-c998-4859-93db-ea23b471fe1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetraG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Delta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetraG[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Delta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"b57a3ea8-e6dd-4310-95ad-c32545a07123"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetraG\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Delta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetraG\[Dagger][-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Delta]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"396d46f9-7a58-4b87-9750-5cc0da416236"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"cd", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`cd[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"a5895d31-cf1d-4a4e-b90e-d2db24e94b9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Torsioncd", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`Torsioncd[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"93396d92-20cc-48b0-84c6-7793b07c7f49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Christoffelcd", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`Christoffelcd[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"62ebafeb-8aaf-413d-8503-8b204d0aa58b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Riemanncd", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Delta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric pairs cannot be exchanged.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`Riemanncd[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Delta]], ". ", 
   "Antisymmetric pairs cannot be exchanged."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"fb22195c-ee07-4e04-904d-3386d6927f3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Riccicd", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`Riccicd[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"e7cbcdb2-22ed-4e7b-804a-573adc3c1e70"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"0cbe9377-9d59-46e5-8dca-11c294b666fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarcd", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarcd[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"4d660c6d-1e11-43c9-aace-0d26a6b53270"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"eff584ea-f2f1-4c39-9244-c7ba950a02f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Einsteincd", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Einstein tensor ", 
   $CellContext`Einsteincd[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"a674ef6d-16cf-4ae3-940d-bb26526c190b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Weylcd", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Delta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric pairs cannot be exchanged.\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`Weylcd[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Delta]], ". ", 
   "Antisymmetric pairs cannot be exchanged."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"eded20fe-0455-4d54-b61b-887d6a725072"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRiccicd", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric TFRicci tensor ", 
   $CellContext`TFRiccicd[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"fa2247f2-43cf-47c9-b33a-3f427ab0c87d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"Kretschmanncd", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`Kretschmanncd[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"eb35b2e3-3022-4723-9071-1e758ec8861d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"28dcd680-fdf0-44f9-bedf-b369eea8db3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"b5a9dc49-7c0c-4324-ab8b-de26676f2e7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"60aaa3d6-6492-4ba7-9b5b-e92dcbce602d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"LCG", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`LCG[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"cb3e869a-82c0-4c94-945e-4566ba8acdb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionLCG", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionLCG[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"60d2bd2b-adee-4951-9731-0763044888ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelLCG", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelLCG[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"ec2eeb20-109c-49b9-a8d0-40b12d758d89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannLCG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Delta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannLCG[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Delta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"293a75a2-a73d-42e6-aac2-3f0465966c65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciLCG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciLCG[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"ac6f9f6a-232a-417f-8855-53e0ef86fa0e"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"057703d9-feb8-444c-acdf-93cfdf02688a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarLCG", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarLCG[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"92619303-50c4-49cb-954d-651f5fa2f0d0"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"7246409b-922d-41c7-af7a-3ade44edad20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinLCG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinLCG[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"e8637acc-69c3-4797-9dc8-033f610dad1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylLCG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Delta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylLCG[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Delta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"c3ff7fdb-7792-4ed8-a7ea-1e79b70ba47e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciLCG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciLCG[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"5f8c4bbc-7719-4921-bee3-000624aef51d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannLCG", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannLCG[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"a68fa978-5ac8-4b55-a621-c07aa71be1d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"5721ee2d-800d-42e6-8d1c-8ea52bbc8b96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"f3493ffc-b379-4e6b-ba06-447040d6bbc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"74ee7dc0-f408-46b4-ac4f-7d1a47048ef6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetG", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetG[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"0666f598-dcf1-47c6-a3d0-c16d8617f590"]
}, Open  ]],

Cell["Definition of the spin structure", "MathCaption",
 CellChangeTimes->{{3.4346488109210663`*^9, 3.434648816925152*^9}},
 TextJustification->1.,ExpressionUUID->"502730d3-20af-4bc4-863c-c82cf14e32a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"G", ",", "SpinT", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[ScriptCapitalA]", ",", "\[ScriptCapitalB]", ",", "\[ScriptCapitalC]", 
     ",", "\[ScriptCapitalD]", ",", "\[ScriptCapitalF]", ",", 
     "\[ScriptCapitalG]", ",", "\[ScriptCapitalH]", ",", 
     "\[ScriptCapitalM]"}], "}"}], ",", "\[ScriptCapitalE]", ",", 
   "\[CapitalSigma]", ",", "cde", ",", 
   RowBox[{"SpinorPrefix", "->", "S"}]}], "]"}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"01fd4fef-5679-4daf-9f23-cce9469d94b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "SpinT", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`SpinT, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"879d40a1-56ad-4cf9-a746-ddbaa230c243"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "SpinT\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between SpinT \
and SpinT\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`SpinT\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between SpinT and SpinT\[Dagger]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"2be337cd-5462-44f6-baea-fd063ffd2c98"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[CapitalSigma]", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[CapitalSigma][$CellContext`\[Alpha], -$CellContext`\
\[ScriptCapitalC], -$CellContext`\[ScriptCapitalD]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"b2cb7e83-7be4-4d04-8687-17968d94b2d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[CapitalSigma]\[Dagger]", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[CapitalSigma]\[Dagger][$CellContext`\[Alpha], \
-$CellContext`\[ScriptCapitalC]\[Dagger], -$CellContext`\[ScriptCapitalD]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"381332f0-a459-4e5d-8a5e-79caf853656f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[ScriptCapitalE][-$CellContext`\[ScriptCapitalA], \
-$CellContext`\[ScriptCapitalB]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"b647506d-a5ad-4339-8faf-28940e8f3e5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[ScriptCapitalE]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[ScriptCapitalE]\[Dagger][-$CellContext`\[ScriptCapitalA]\
\[Dagger], -$CellContext`\[ScriptCapitalB]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"08bfeac8-7ae0-4923-8813-94d4db48f4d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[CapitalSigma]", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", 
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[CapitalSigma][$CellContext`\[Alpha], $CellContext`\
\[Beta], -$CellContext`\[ScriptCapitalA], -$CellContext`\[ScriptCapitalB]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"0856068a-b19d-4dbe-ac5e-6ed484dafbb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[CapitalSigma]\[Dagger]", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", 
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[CapitalSigma]\[Dagger][$CellContext`\[Alpha], \
$CellContext`\[Beta], -$CellContext`\[ScriptCapitalA]\[Dagger], \
-$CellContext`\[ScriptCapitalB]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"a2568256-af71-447e-940b-c36d7e1df11a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]G", "[", 
    RowBox[{
    "\[ScriptCapitalA]", ",", "\[ScriptCapitalC]\[Dagger]", ",", 
     "\[ScriptCapitalB]", ",", "\[ScriptCapitalD]\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor G\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]G[$CellContext`\[ScriptCapitalA], \
$CellContext`\[ScriptCapitalC]\[Dagger], $CellContext`\[ScriptCapitalB], \
$CellContext`\[ScriptCapitalD]\[Dagger]], ". ", "Equivalent of tensor G"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"c479d162-6489-49cd-9e5e-53f2507762a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]G\[Dagger]", "[", 
    RowBox[{
    "\[ScriptCapitalA]\[Dagger]", ",", "\[ScriptCapitalC]", ",", 
     "\[ScriptCapitalB]\[Dagger]", ",", "\[ScriptCapitalD]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor G\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]G\[Dagger][$CellContext`\[ScriptCapitalA]\
\[Dagger], $CellContext`\[ScriptCapitalC], $CellContext`\[ScriptCapitalB]\
\[Dagger], $CellContext`\[ScriptCapitalD]], ". ", "Equivalent of tensor G"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"fb400d85-34d3-4f2f-84e6-b8c5504f69c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]epsilonG", "[", 
    RowBox[{
    "\[ScriptCapitalA]", ",", "\[ScriptCapitalA]\[Dagger]", ",", 
     "\[ScriptCapitalB]", ",", "\[ScriptCapitalB]\[Dagger]", ",", 
     "\[ScriptCapitalC]", ",", "\[ScriptCapitalC]\[Dagger]", ",", 
     "\[ScriptCapitalD]", ",", "\[ScriptCapitalD]\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor epsilonG\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]epsilonG[$CellContext`\[ScriptCapitalA], \
$CellContext`\[ScriptCapitalA]\[Dagger], $CellContext`\[ScriptCapitalB], \
$CellContext`\[ScriptCapitalB]\[Dagger], $CellContext`\[ScriptCapitalC], \
$CellContext`\[ScriptCapitalC]\[Dagger], $CellContext`\[ScriptCapitalD], \
$CellContext`\[ScriptCapitalD]\[Dagger]], ". ", 
   "Equivalent of tensor epsilonG"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"7abb596d-46ab-4270-a81c-aa98f33fae8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]epsilonG\[Dagger]", "[", 
    RowBox[{
    "\[ScriptCapitalA]\[Dagger]", ",", "\[ScriptCapitalA]", ",", 
     "\[ScriptCapitalB]\[Dagger]", ",", "\[ScriptCapitalB]", ",", 
     "\[ScriptCapitalC]\[Dagger]", ",", "\[ScriptCapitalC]", ",", 
     "\[ScriptCapitalD]\[Dagger]", ",", "\[ScriptCapitalD]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor epsilonG\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]epsilonG\[Dagger][$CellContext`\
\[ScriptCapitalA]\[Dagger], $CellContext`\[ScriptCapitalA], $CellContext`\
\[ScriptCapitalB]\[Dagger], $CellContext`\[ScriptCapitalB], $CellContext`\
\[ScriptCapitalC]\[Dagger], $CellContext`\[ScriptCapitalC], $CellContext`\
\[ScriptCapitalD]\[Dagger], $CellContext`\[ScriptCapitalD]], ". ", 
   "Equivalent of tensor epsilonG"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"78cde31b-8994-4d9a-bc07-7e3a15ae3d84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"cde", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`cde[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"6d207c79-15c1-43d8-b8ac-cc20d0035b3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Christoffelcdcde", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`Christoffelcdcde[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"5abbea64-7709-4bda-944c-44fe3b213cb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelcde", "[", 
    RowBox[{"\[ScriptCapitalA]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelcde[$CellContext`\[ScriptCapitalA], \
-$CellContext`\[Beta], -$CellContext`\[ScriptCapitalC]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"8e6b2132-c1e3-4d8b-9a2a-4173ca6d34dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelcde\[Dagger]", "[", 
    RowBox[{"\[ScriptCapitalA]\[Dagger]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelcde\[Dagger][$CellContext`\[ScriptCapitalA]\
\[Dagger], -$CellContext`\[Beta], -$CellContext`\[ScriptCapitalC]\[Dagger]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"5d2533fa-c541-4bc0-b724-2d09ebc255cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemanncde", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}], ",", "\[ScriptCapitalD]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemanncde[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[ScriptCapitalC], $CellContext`\[ScriptCapitalD]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"7542eb06-b5f1-4f77-a554-524e89189fa2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemanncde\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}], ",", 
     "\[ScriptCapitalD]\[Dagger]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemanncde\[Dagger][-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[ScriptCapitalC]\[Dagger], $CellContext`\
\[ScriptCapitalD]\[Dagger]], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"8d64da7e-78f5-490e-95c1-b13b2d63bd85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]FRiemanncde", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemanncde\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]FRiemanncde[-$CellContext`\[ScriptCapitalA], \
-$CellContext`\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalC], \
-$CellContext`\[ScriptCapitalD]], ". ", "Equivalent of tensor FRiemanncde"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"5af939b4-5b74-4fc4-9f63-27af329ff9d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]FRiemanncde\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemanncde\[Dagger]\"\>"}],
  
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]FRiemanncde\[Dagger][-$CellContext`\
\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalA], -$CellContext`\
\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalB], -$CellContext`\
\[ScriptCapitalC]\[Dagger], -$CellContext`\[ScriptCapitalD]\[Dagger]], ". ", 
   "Equivalent of tensor FRiemanncde\[Dagger]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"9f4e2527-721f-4eab-9086-d9abd73e282e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Chicde", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Chicde[-$CellContext`\[ScriptCapitalA], -$CellContext`\
\[ScriptCapitalB], -$CellContext`\[ScriptCapitalC], -$CellContext`\
\[ScriptCapitalD]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"5dba15de-52cd-4fba-8303-99d48c6ff905"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Chicde\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Chicde\[Dagger][-$CellContext`\[ScriptCapitalA]\[Dagger], \
-$CellContext`\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalC]\
\[Dagger], -$CellContext`\[ScriptCapitalD]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"82ddcb80-68c8-45a7-81ce-f519fa1fe60f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Phicde", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Phicde[-$CellContext`\[ScriptCapitalA], -$CellContext`\
\[ScriptCapitalB], -$CellContext`\[ScriptCapitalC]\[Dagger], -$CellContext`\
\[ScriptCapitalD]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"47488f34-128c-40c0-8145-c3a0ad437e8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Phicde\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Phicde\[Dagger][-$CellContext`\[ScriptCapitalA]\[Dagger], \
-$CellContext`\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalC], \
-$CellContext`\[ScriptCapitalD]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"a3efcf65-6633-4710-8475-f0c70d985668"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]Torsioncd", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Torsioncd\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]Torsioncd[-$CellContext`\[ScriptCapitalA], \
-$CellContext`\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalC], \
-$CellContext`\[ScriptCapitalC]\[Dagger]], ". ", 
   "Equivalent of tensor Torsioncd"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"3b895e72-ec2d-470e-b5cf-97b237510ec0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]Torsioncd\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Torsioncd\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]Torsioncd\[Dagger][-$CellContext`\
\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalA], -$CellContext`\
\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalB], -$CellContext`\
\[ScriptCapitalC]\[Dagger], -$CellContext`\[ScriptCapitalC]], ". ", 
   "Equivalent of tensor Torsioncd"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"85b40605-5447-4e25-b6aa-6191887b6c7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Omegacde", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion spinor ", 
   $CellContext`Omegacde[-$CellContext`\[ScriptCapitalA]\[Dagger], \
-$CellContext`\[ScriptCapitalA], -$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalC]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"c05aaa14-8ef1-4cfd-b484-03c6b15fa327"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Omegacde\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion spinor ", 
   $CellContext`Omegacde\[Dagger][-$CellContext`\[ScriptCapitalA], \
-$CellContext`\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalB]\
\[Dagger], -$CellContext`\[ScriptCapitalC]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"1adad33d-0181-4ba9-b620-0e45ec94f5da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]Riemanncd", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riemanncd\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]Riemanncd[-$CellContext`\[ScriptCapitalA], \
-$CellContext`\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalC], \
-$CellContext`\[ScriptCapitalC]\[Dagger], -$CellContext`\[ScriptCapitalD], \
-$CellContext`\[ScriptCapitalD]\[Dagger]], ". ", 
   "Equivalent of tensor Riemanncd"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"0a7b62a5-4cda-4af4-9354-c800e694a69f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]Riemanncd\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalC]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalD]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riemanncd\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]Riemanncd\[Dagger][-$CellContext`\
\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalA], -$CellContext`\
\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalB], -$CellContext`\
\[ScriptCapitalC]\[Dagger], -$CellContext`\[ScriptCapitalC], -$CellContext`\
\[ScriptCapitalD]\[Dagger], -$CellContext`\[ScriptCapitalD]], ". ", 
   "Equivalent of tensor Riemanncd"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"8a59c82c-3483-43a8-917a-d19027a22b0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]Riccicd", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riccicd\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]Riccicd[-$CellContext`\[ScriptCapitalA], \
-$CellContext`\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalB]\[Dagger]], ". ", 
   "Equivalent of tensor Riccicd"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"96536b05-62d0-4b27-bb3c-2ae5445e0a36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[UnderBracket]Riccicd\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalA]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]\[Dagger]"}], ",", 
     RowBox[{"-", "\[ScriptCapitalB]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riccicd\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`S\[UnderBracket]Riccicd\[Dagger][-$CellContext`\
\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalA], -$CellContext`\
\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalB]], ". ", 
   "Equivalent of tensor Riccicd"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[63]:=",ExpressionUUID->"0554a845-e785-49bd-b6f5-40e8a2ee3776"]
}, Open  ]],

Cell["This is the torsion tensor.", "MathCaption",
 CellChangeTimes->{{3.4346488109210663`*^9, 3.434648816925152*^9}, {
   3.4346497925861797`*^9, 3.4346497969480457`*^9}, 3.43464994025495*^9, {
   3.4582737774723167`*^9, 3.458273779259447*^9}},
 TextJustification->1.,ExpressionUUID->"8d193a07-c660-4ff9-9fd7-1ea125937928"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Torsioncd", "[", 
  RowBox[{"\[Alpha]", ",", 
   RowBox[{"-", "\[Beta]"}], ",", 
   RowBox[{"-", "\[Gamma]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.434649803649375*^9, 3.434649819293214*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"828833e5-8aa2-4dc5-b427-09e1efab2b58"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"T", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {"\[Alpha]", " ", " "},
         {" ", "\[Beta]", "\[Gamma]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Torsioncd[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]],
  Editable->False]], "Output",
 CellLabel->"Out[64]=",ExpressionUUID->"08797c20-a2f7-42cb-af11-aec12107c0e7"]
}, Open  ]],

Cell["We compute next the spinor equivalent of the torsion.", "MathCaption",
 CellChangeTimes->{{3.4346488109210663`*^9, 3.434648816925152*^9}, {
  3.4346497925861797`*^9, 3.4346497969480457`*^9}, {3.434649928350045*^9, 
  3.434649938183371*^9}},
 TextJustification->1.,ExpressionUUID->"92a666ce-f059-4536-b990-6b813d1be15e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], ",", "\[CapitalSigma]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.434649821565971*^9, 3.434649879440894*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"e223b1b4-fe6d-4ec5-ad21-92071c163c3c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"T", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {"\[Alpha]", " ", " "},
          {" ", "\[Beta]", "\[Gamma]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Torsioncd[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[CapitalSigma]", 
       StyleBox[GridBox[{
          {" ", "\[ScriptCapitalA]", "\[ScriptCapitalA]\[Dagger]"},
          {"\[Alpha]", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[CapitalSigma][-$CellContext`\[Alpha], $CellContext`\
\[ScriptCapitalA], $CellContext`\[ScriptCapitalA]\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[CapitalSigma]", 
       StyleBox[GridBox[{
          {"\[Beta]", " ", " "},
          {" ", "\[ScriptCapitalB]", "\[ScriptCapitalB]\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[CapitalSigma][$CellContext`\[Beta], -$CellContext`\
\[ScriptCapitalB], -$CellContext`\[ScriptCapitalB]\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[CapitalSigma]", 
       StyleBox[GridBox[{
          {"\[Gamma]", " ", " "},
          {" ", "\[ScriptCapitalC]", "\[ScriptCapitalC]\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[CapitalSigma][$CellContext`\[Gamma], -$CellContext`\
\[ScriptCapitalC], -$CellContext`\[ScriptCapitalC]\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[65]=",ExpressionUUID->"96035124-8909-438a-ac8a-7c1c6b1d4f6c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.434649890532796*^9, 3.434649897081938*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"9d9beb83-380f-43ac-81d7-6cc464e63408"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"\[CapitalSigma]T", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {"\[ScriptCapitalA]", "\[ScriptCapitalA]\[Dagger]", " ", " ", " ", 
          " "},
         {" ", " ", "\[ScriptCapitalB]", "\[ScriptCapitalB]\[Dagger]", 
          "\[ScriptCapitalC]", "\[ScriptCapitalC]\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S\[UnderBracket]Torsioncd[$CellContext`\[ScriptCapitalA], \
$CellContext`\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalB]\[Dagger], -$CellContext`\[ScriptCapitalC], \
-$CellContext`\[ScriptCapitalC]\[Dagger]],
  Editable->False]], "Output",
 CellLabel->"Out[66]=",ExpressionUUID->"4c29b549-341b-4756-8977-aea23098e0c7"]
}, Open  ]],

Cell["This can be decomposed as follows.", "MathCaption",
 CellChangeTimes->{{3.4346488109210663`*^9, 3.434648816925152*^9}, {
  3.4346497925861797`*^9, 3.4346497969480457`*^9}, {3.434649928350045*^9, 
  3.434649964764443*^9}},
 TextJustification->1.,ExpressionUUID->"e5d85738-c7c9-4d17-8449-0a0954acbbf6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.4346499018402843`*^9, 3.4346499053796873`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"62603130-cb55-40c1-8220-eac281d0b96d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[ScriptCapitalE]", 
       StyleBox[GridBox[{
          {"\[ScriptCapitalA]", "\[ScriptCapitalD]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[ScriptCapitalE][$CellContext`\[ScriptCapitalA], \
$CellContext`\[ScriptCapitalD]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[ScriptCapitalE]\[Dagger]", 
       StyleBox[GridBox[{
          {"\[ScriptCapitalA]\[Dagger]", "\[ScriptCapitalD]\[Dagger]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[ScriptCapitalE]\[Dagger][$CellContext`\[ScriptCapitalA]\
\[Dagger], $CellContext`\[ScriptCapitalD]\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{
           RowBox[{"\[CapitalOmega]", "[", "\[EmptyDownTriangle]", "]"}], 
           "\[Dagger]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"\[ScriptCapitalD]", "\[ScriptCapitalD]\[Dagger]", 
              "\[ScriptCapitalB]\[Dagger]", "\[ScriptCapitalC]\[Dagger]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Omegacde\[Dagger][-$CellContext`\[ScriptCapitalD], \
-$CellContext`\[ScriptCapitalD]\[Dagger], -$CellContext`\[ScriptCapitalB]\
\[Dagger], -$CellContext`\[ScriptCapitalC]\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[ScriptCapitalE]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[ScriptCapitalB]", "\[ScriptCapitalC]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[ScriptCapitalE][-$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalC]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"\[CapitalOmega]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"\[ScriptCapitalD]\[Dagger]", "\[ScriptCapitalD]", 
              "\[ScriptCapitalB]", "\[ScriptCapitalC]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Omegacde[-$CellContext`\[ScriptCapitalD]\[Dagger], \
-$CellContext`\[ScriptCapitalD], -$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalC]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[ScriptCapitalE]\[Dagger]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[ScriptCapitalB]\[Dagger]", "\[ScriptCapitalC]\[Dagger]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[ScriptCapitalE]\[Dagger][-$CellContext`\[ScriptCapitalB]\
\[Dagger], -$CellContext`\[ScriptCapitalC]\[Dagger]],
      Editable->False]}]}], ")"}]}]], "Output",
 CellLabel->"Out[67]=",ExpressionUUID->"9773a19d-5a6b-4f67-b0a4-b85bc5d4fb80"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4346499123812532`*^9, 3.434649915514044*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"4a8256fa-7344-417f-904e-51536a0af1da"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalOmega]", "[", "\[EmptyDownTriangle]", "]"}], 
         "\[Dagger]"}], 
        StyleBox[GridBox[{
           {"\[ScriptCapitalA]", "\[ScriptCapitalA]\[Dagger]", " ", " "},
           {" ", " ", "\[ScriptCapitalB]\[Dagger]", 
            "\[ScriptCapitalC]\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Omegacde\[Dagger][$CellContext`\[ScriptCapitalA], \
$CellContext`\[ScriptCapitalA]\[Dagger], -$CellContext`\[ScriptCapitalB]\
\[Dagger], -$CellContext`\[ScriptCapitalC]\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalE]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[ScriptCapitalB]", "\[ScriptCapitalC]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalE][-$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalC]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalOmega]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"\[ScriptCapitalA]\[Dagger]", "\[ScriptCapitalA]", " ", " "},
           {" ", " ", "\[ScriptCapitalB]", "\[ScriptCapitalC]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Omegacde[$CellContext`\[ScriptCapitalA]\[Dagger], \
$CellContext`\[ScriptCapitalA], -$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalC]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalE]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[ScriptCapitalB]\[Dagger]", "\[ScriptCapitalC]\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalE]\[Dagger][-$CellContext`\[ScriptCapitalB]\
\[Dagger], -$CellContext`\[ScriptCapitalC]\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[68]=",ExpressionUUID->"7bfd43fd-f21d-4c04-9af7-70d0b1a47476"]
}, Open  ]],

Cell[TextData[{
 "The spinor ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     RowBox[{"\[CapitalOmega]", "[", "\[EmptyDownTriangle]", "]"}], 
     RowBox[{"   ", "\[ScriptCapitalB]\[ScriptCapitalC]"}], 
     RowBox[{"\[ScriptCapitalA]\[Dagger]\[ScriptCapitalA]", "  "}]],
    AutoSpacing->False],
   $CellContext`Omegacde[$CellContext`\[ScriptCapitalA]\[Dagger], \
$CellContext`\[ScriptCapitalA], -$CellContext`\[ScriptCapitalB], \
-$CellContext`\[ScriptCapitalC]],
   Editable->False]], "Output",
  CellChangeTimes->{3.434649916393949*^9},ExpressionUUID->
  "539a57e9-50e7-4e70-9a8c-dafda8060974"],
 " is called the \"torsion spinor\" of the covariant derivative. It is \
symmetric in the last pair of indices."
}], "MathCaption",
 CellChangeTimes->{{3.4346488109210663`*^9, 3.434648816925152*^9}, {
   3.4346497925861797`*^9, 3.4346497969480457`*^9}, {3.434649928350045*^9, 
   3.434650002803195*^9}, {3.434694850060829*^9, 3.434694860530814*^9}, {
   3.4346950736276503`*^9, 3.4346950841199923`*^9}, 3.4346951383865623`*^9},
 TextJustification->1.,ExpressionUUID->"6b7f1693-ce1a-4ee4-9206-3325e654bfcf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "@", "Omegacde"}]], "Input",
 CellChangeTimes->{{3.434650005661306*^9, 3.434650039971096*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"b4c9daa3-1a38-452b-807c-c3c0ec84ca01"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    InterpretationBox[
     StyleBox[
      RowBox[{"(", "3", ",", "4", ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPerm`Cycles[{3, 4}],
     Editable->False], "]"}]}], "]"}]], "Output",
 CellLabel->"Out[69]=",ExpressionUUID->"2c95cefe-f3b0-4848-bab3-53743836d944"]
}, Open  ]],

Cell["\<\
That spinor appears in all standard expressions involving the torsion. Let us \
see an example:\
\>", "MathCaption",
 TextJustification->1.,ExpressionUUID->"f81295d3-c549-4c5d-8825-bec2539cd6ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"T", "[", "\[ScriptCapitalA]", "]"}], ",", "MT"}], "]"}]], "Input",\

 CellChangeTimes->{{3.434650382209078*^9, 3.434650399415821*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"0abbab43-8827-412a-ae30-b22d3f40121a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", "\[ScriptCapitalA]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[$CellContext`\[ScriptCapitalA]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[70]:=",ExpressionUUID->"903e166e-e078-458c-9eaf-b325954a67c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T\[Dagger]", "[", "\[ScriptCapitalA]\[Dagger]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T\[Dagger][$CellContext`\[ScriptCapitalA]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[70]:=",ExpressionUUID->"899c156c-1fb9-4ffc-9176-8af9a1824ca7"]
}, Open  ]],

Cell[TextData[{
 "This is the spinor form of the Ricci identity associated to the covariant \
derivative ",
 StyleBox["cde", "DisplayMath",
  FontWeight->"Plain"],
 StyleBox[". As is well known this spinor form contains the \"box operator\" \
whose expansion contains explicitly the torsion spinor.", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.458273890748248*^9, 3.458273903588743*^9}, {
  3.458273938882916*^9, 3.458273957704179*^9}, {3.4582740050407887`*^9, 
  3.458274085142345*^9}},
 TextJustification->1.,ExpressionUUID->"2b3b193d-3a3d-4203-b390-410d5a27317d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Boxcde", "[", 
   RowBox[{
    RowBox[{"-", "\[ScriptCapitalA]"}], ",", 
    RowBox[{"-", "\[ScriptCapitalB]"}]}], "]"}], "@", 
  RowBox[{"T", "[", "\[ScriptCapitalC]", "]"}]}]], "Input",
 CellChangeTimes->{{3.4346503112559843`*^9, 3.434650328359386*^9}, {
  3.4346504045571938`*^9, 3.434650408978689*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"a20992b7-0e4b-4460-9ee4-58c61f23a783"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], 
     "\[ScriptCapitalA]\[ScriptCapitalB]", "  "], GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {"\[ScriptCapitalC]"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Boxcde[-$CellContext`\[ScriptCapitalA], -$CellContext`\
\[ScriptCapitalB]][
   $CellContext`T[$CellContext`\[ScriptCapitalC]]],
  Editable->False]], "Output",
 CellLabel->"Out[71]=",ExpressionUUID->"870d2eb8-2f7c-455c-b6d4-90adea67c716"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCurvature", "[", 
  RowBox[{"%", ",", "Boxcde"}], "]"}]], "Input",
 CellChangeTimes->{{3.434650411977785*^9, 3.434650427376101*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"c6b83d42-8fd3-44d5-9e23-b9713de07d82"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalChi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"\[ScriptCapitalC]", " ", " ", " "},
            {" ", "\[ScriptCapitalD]", "\[ScriptCapitalA]", 
             "\[ScriptCapitalB]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Chicde[$CellContext`\[ScriptCapitalC], -$CellContext`\
\[ScriptCapitalD], -$CellContext`\[ScriptCapitalA], -$CellContext`\
\[ScriptCapitalB]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {"\[ScriptCapitalD]"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[$CellContext`\[ScriptCapitalD]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalOmega]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"\[ScriptCapitalA]\[Dagger]", "\[ScriptCapitalD]", " ", " "},
           {" ", " ", "\[ScriptCapitalA]", "\[ScriptCapitalB]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Omegacde[$CellContext`\[ScriptCapitalA]\[Dagger], \
$CellContext`\[ScriptCapitalD], -$CellContext`\[ScriptCapitalA], \
-$CellContext`\[ScriptCapitalB]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        "\[ScriptCapitalD]\[ScriptCapitalA]\[Dagger]", "  "], GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {"\[ScriptCapitalC]"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`cde[-$CellContext`\[ScriptCapitalD], -$CellContext`\
\[ScriptCapitalA]\[Dagger]][
      $CellContext`T[$CellContext`\[ScriptCapitalC]]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->"Out[72]=",ExpressionUUID->"bc2fc585-69e6-45e2-af4b-0b93cfd2a265"]
}, Open  ]],

Cell["We remove all the symbols used in this subsection.", "MathCaption",
 CellChangeTimes->{{3.4346488109210663`*^9, 3.434648816925152*^9}, {
  3.4346497925861797`*^9, 3.4346497969480457`*^9}, {3.434649928350045*^9, 
  3.434650002803195*^9}, {3.4346502820151*^9, 3.434650307646223*^9}, {
  3.434650479621744*^9, 3.4346504891697083`*^9}},
 TextJustification->1.,ExpressionUUID->"56b54088-876b-4e27-88a7-ff2d55281077"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Undef", "/@", 
   RowBox[{"VisitorsOf", "@", "\[CapitalSigma]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.434650490687606*^9, 3.434650522066297*^9}, 
   3.43469555411559*^9},
 CellLabel->"In[73]:=",ExpressionUUID->"26d92e02-6f31-4cdb-88fa-557bc9c61911"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]G\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]G\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"458e98ef-89b0-4e33-b63c-93832f245e78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]G"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]G],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"beced53a-0c9b-4fda-8b02-99eca51e7eb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]epsilonG\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]epsilonG\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"ba93bc88-9b82-4799-b39c-16df2a759993"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]epsilonG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]epsilonG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"167f9727-41af-4a4b-b58e-993dc6c6277e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]FRiemanncde\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]FRiemanncde\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"4b0fb981-386a-47e9-870d-2a60a7ebf555"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]FRiemanncde"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]FRiemanncde],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"bf906593-2605-4b3a-a8c4-fc97281cabda"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]Torsioncd\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]Torsioncd\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"aa0fb4bd-d09f-4237-89e8-05d07f113ff3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]Torsioncd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]Torsioncd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"a3a2b54a-34ff-43ec-a024-de37adf29863"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]Riemanncd\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]Riemanncd\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"1526e3b2-5785-4b89-bd7a-a679e47bb451"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]Riemanncd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]Riemanncd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"8aebea79-e818-4f9a-95f7-feaecd2528aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]Riccicd\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]Riccicd\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"d5ea4262-2031-4ec4-a511-df40e0f1e758"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S\[UnderBracket]Riccicd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`S\[UnderBracket]Riccicd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[73]:=",ExpressionUUID->"20c205eb-81c0-43c6-a38b-3a1c66ffd44a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Undef", "/@", 
   RowBox[{"VisitorsOf", "@", "SpinT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.434650548962536*^9, 3.434650558191928*^9}, 
   3.434695558091555*^9},
 CellLabel->"In[74]:=",ExpressionUUID->"3d2a6cfa-c694-4da1-9236-ce251a30b4c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "T\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[74]:=",ExpressionUUID->"a31cee8a-ab05-4305-961c-f1a6dda3ff3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[74]:=",ExpressionUUID->"3571d4f1-5b97-4d2e-8191-b7a887d2994b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefSpinStructure", "@", "\[CapitalSigma]"}]], "Input",
 CellChangeTimes->{{3.434650531092408*^9, 3.434650537388558*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"4655c55c-892a-435d-b6c5-57e44395510a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "AChristoffelcde\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", 
   " ", $CellContext`AChristoffelcde\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"313da5af-d386-436d-aa51-ff84aa03c824"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "AChristoffelcde"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", " ", $CellContext`AChristoffelcde],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"0fa72aa0-96d8-45d5-b1dc-da7afe9ed2cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Chicde\[Dagger]"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "curvature spinor", 
   " ", $CellContext`Chicde\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"03f86f42-7697-4ddc-9407-fbf38c6321c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Chicde"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "curvature spinor", 
   " ", $CellContext`Chicde],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"e5ac7fcc-8ab4-48ec-8ba0-87ab2be7c719"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Christoffelcdcde"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Christoffelcdcde],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"d37739c3-1117-458b-a270-90cb0b1282ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "FRiemanncde\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemanncde\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"c08d4b2d-1b56-46bc-ac44-f47383c02c32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "FRiemanncde"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemanncde],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"6adac1d6-e47b-49d1-b164-06b48ef64c1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "Omegacde\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion spinor", 
   " ", $CellContext`Omegacde\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"b56fbd42-119c-488d-84dd-22591c1ba7a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Omegacde"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion spinor", 
   " ", $CellContext`Omegacde],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"a2caa869-6513-4c49-b4d1-92dc98dc50e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Phicde\[Dagger]"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "curvature spinor", 
   " ", $CellContext`Phicde\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"1d372735-47ba-47e1-ba60-e790beda227c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Phicde"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "curvature spinor", 
   " ", $CellContext`Phicde],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"8fec0d72-3d50-4b9d-9332-bec6a702c7d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "cde"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`cde],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"ab0d1f94-aaa1-4a20-99de-12f42979530d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Sigma\[CapitalSigma]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Sigma\[CapitalSigma]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"3289432a-2b76-4520-8671-b66f63fbd244"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Sigma\[CapitalSigma]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Sigma\[CapitalSigma]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"8902e404-2d3c-462f-926b-e596e1ef6384"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "\[ScriptCapitalE]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spin metric", 
   " ", $CellContext`\[ScriptCapitalE]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"876888fe-5ae8-4f20-9a35-352e1a507c61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "\[ScriptCapitalE]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spin metric", 
   " ", $CellContext`\[ScriptCapitalE]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"c89bfc8a-c02a-415e-916b-bb2d7f6725b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "\[CapitalSigma]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "soldering form", 
   " ", $CellContext`\[CapitalSigma]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"8a7af5de-93dd-4f8e-85ff-1e9eb53581aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "\[CapitalSigma]"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "soldering form", 
   " ", $CellContext`\[CapitalSigma]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"c29be2db-6ab9-43e6-b91d-5cfe51f7ff26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["SpinT\[Dagger]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`SpinT\[Dagger],
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "conjugated vbundle", 
   " ", $CellContext`SpinT\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"1693bfa8-c0c8-43ea-b28c-32146cbbed47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["SpinT",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`SpinT,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`SpinT],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"97799108-d2fa-48c5-a129-0aadc8d594d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefMetric", "@", "G"}]], "Input",
 CellChangeTimes->{{3.434650565805607*^9, 3.434650573018524*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"4e68f8d0-dd82-4f07-b5d8-c47cedc5eec6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "DetG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "weight +2 density", 
   " ", $CellContext`DetG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"98f4d31f-456c-42fc-926e-a39e4178b525"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelLCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelLCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"a750a3ed-d98e-4080-8290-0b5ebb81b642"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "EinsteinLCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Einstein tensor", " ", $CellContext`EinsteinLCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"85561abd-7bf0-4a66-bb41-704220699361"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "KretschmannLCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Kretschmann scalar", 
   " ", $CellContext`KretschmannLCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"c39df41f-86a9-488a-a543-7fcc42607ca0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciLCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric Ricci tensor", 
   " ", $CellContext`RicciLCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"3635ead4-ecca-4b76-a866-b097ebf429a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciScalarLCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci scalar", 
   " ", $CellContext`RicciScalarLCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"5d7b82ff-ba56-4651-95f2-ca1197566130"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannLCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannLCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"a1f3591e-a614-4259-97a9-647ad61c34c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TFRicciLCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric TFRicci tensor",
    " ", $CellContext`TFRicciLCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"28e53044-fc4b-462c-8622-f2d2da03cd38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionLCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionLCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"478847bf-c404-47a2-a856-445696666fd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "WeylLCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl tensor", 
   " ", $CellContext`WeylLCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"a92dfec6-11f3-465a-99fe-c49ee2cd5eb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "LCG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`LCG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"ca60e144-63bc-4e51-b69e-02c538e4160d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Christoffelcd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`Christoffelcd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"47dcc71f-849d-4596-b8df-0a17a706d749"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Einstein tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Einsteincd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Einstein tensor", " ", $CellContext`Einsteincd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"b1eebe47-be5d-4554-a613-cbf76d25c29d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Kretschmanncd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Kretschmann scalar", 
   " ", $CellContext`Kretschmanncd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"bda333ca-d475-4de6-925c-6fadb9068f1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Riccicd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Ricci tensor", " ", $CellContext`Riccicd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"d59dccda-e44f-4c43-bb93-561f254e7955"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciScalarcd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci scalar", 
   " ", $CellContext`RicciScalarcd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"0fd92068-c65b-44c1-941d-bd0713f2c9d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Riemanncd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`Riemanncd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"3a615f93-d85e-4d2d-be61-418f98b8ad71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric TFRicci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TFRiccicd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric TFRicci tensor", " ", $CellContext`TFRiccicd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"b2a86a68-4cde-4988-9792-dc896ad2cc97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Torsioncd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`Torsioncd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"560bdd88-2bfb-4e26-98f0-ad0d2a475fdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Weylcd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl tensor", 
   " ", $CellContext`Weylcd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"d61972e4-ee03-4832-b446-e61d5941a646"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "cd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`cd],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"cd8ab874-d940-4c0f-8b94-c6f86a4fbf84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TetraG\[Dagger]"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tetrametric", 
   " ", $CellContext`TetraG\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"9e4ee177-290b-49db-9de0-9d6742211595"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TetraG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tetrametric", 
   " ", $CellContext`TetraG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"43ed9043-26d0-4c74-9d6e-dc70be1b6a32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "epsilonG"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric tensor", 
   " ", $CellContext`epsilonG],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"db205dad-c0b7-4364-8d41-279f158184fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "G"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric metric tensor", 
   " ", $CellContext`G],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[76]:=",ExpressionUUID->"4156c8b4-2a3e-4c35-a26a-c8898b8ffd3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefManifold", "@", "MT"}]], "Input",
 CellChangeTimes->{{3.43465057725613*^9, 3.4346505821757812`*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"b9e5bc30-41a3-49c6-b14c-5ae53cfdb910"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]MT",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentMT,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentMT],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[77]:=",ExpressionUUID->"11d0225a-46f8-4fa3-8d1b-76f2860274e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "MT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`MT],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[77]:=",ExpressionUUID->"303fb4b9-4616-4ff4-8acb-8943ef068bcd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Manifolds"], "Input",
 CellChangeTimes->{{3.434650606518901*^9, 3.434650608260358*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"8f43d315-b0d8-4725-97c4-4a2b95c2fb1f"],

Cell[BoxData[
 RowBox[{"{", "M4", "}"}]], "Output",
 CellLabel->"Out[78]=",ExpressionUUID->"4f9c7eba-af29-4b0e-93f8-cb757a89f2c2"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3. Transformation between spinor and tensor expressions", \
"SubsectionIcon",
 CellChangeTimes->{{3.423802864738564*^9, 3.423802893202237*^9}, {
  3.423803242749405*^9, 3.423803265238841*^9}, {3.424427489494719*^9, 
  3.4244274898674593`*^9}, {3.4259675657127857`*^9, 3.425967566073875*^9}, {
  3.425977047372518*^9, 3.4259770479163017`*^9}, {3.426858929813401*^9, 
  3.426858930397501*^9}},ExpressionUUID->"797ff82a-bb37-4d07-9dfe-\
896a9ab17c60"],

Cell[TextData[{
 StyleBox["Being able to transform spinor expressions into tensor ones and \
back is an important issue. Sometimes this is a trivial task but there are \
cases in which more efforts are required.  ",
  FontWeight->"Plain"],
 StyleBox["Spinors`", "Output",
  FontWeight->"Plain"],
 StyleBox[" has a complete suite of commands which enable us to handle any \
case as we show below.",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.423802897829471*^9, 3.423803111101532*^9}, {
   3.4238065803091793`*^9, 3.423806642054345*^9}, {3.423806906374263*^9, 
   3.423806992832329*^9}, {3.4244302711158857`*^9, 3.424430297160489*^9}, {
   3.426795371379714*^9, 3.4267954069679747`*^9}, 3.426929821818864*^9, {
   3.426933245814588*^9, 3.4269332850783663`*^9}, {3.427086681415041*^9, 
   3.4270866839544163`*^9}, 3.427275105119259*^9},
 TextJustification->1.,ExpressionUUID->"de02c792-4ee4-48db-bb46-c0fc32072c9a"],

Cell[CellGroupData[{

Cell["\<\
3.1. Insertion and removal of soldering forms in an expression\
\>", "SubsubsectionIcon",ExpressionUUID->"71c06ba3-5a4f-4472-a3c7-\
77557fb15fb8"],

Cell[TextData[{
 StyleBox["When transforming a spinor expression into a tensor one (or \
vice-versa) we may need to insert or eliminate a number of soldering forms.  ",
  FontWeight->"Plain"],
 StyleBox["Spinors`", "Output",
  FontWeight->"Plain"],
 StyleBox["  ",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["provides commands to perform this task in an efficient fashion.",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.426859126891885*^9, 3.426859193331826*^9}, {
  3.4268593178295517`*^9, 3.426859460775679*^9}, {3.427019187895873*^9, 
  3.427019210248584*^9}},ExpressionUUID->"ab23a2c9-a728-4b70-85f3-\
dae1ed22ce65"],

Cell[TextData[{
 StyleBox["PutSolderingForm         ", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Contraction of spinor/tensor indices with a suitable number of \
soldering forms", "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["\n", "Input"],
 StyleBox["ContractSolderingForm    ", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Transformation of contracted products of soldering forms into \
tensor/spinor expressions ", "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["\n", "Input"],
 StyleBox["SeparateSolderingForm    ", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Extraction of spinor/tensor indices by means of soldering forms", 
  "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}], "FramedBox",
 CellChangeTimes->{{3.4268594623153753`*^9, 3.426859529476479*^9}, {
  3.426859575445551*^9, 3.4268597120140877`*^9}, {3.426861162280094*^9, 
  3.426861225567773*^9}, {3.4268613146242027`*^9, 3.426861389237152*^9}, {
  3.42686143550228*^9, 3.426861449870749*^9}, {3.4268757182188253`*^9, 
  3.426875726192522*^9}, {3.426911881578763*^9, 
  3.426911929401544*^9}},ExpressionUUID->"4fa1a625-ac41-4c8c-96ac-\
d003fd8bddc8"],

Cell["\<\
Simple application: we start with the Riemann tensor and finish with its \
spinor counterpart\
\>", "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 
  3.4269212477993717`*^9}},ExpressionUUID->"1c0dcf40-efcc-492e-94b4-\
68c972673ed3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4269211712184057`*^9, 3.4269211780936213`*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"5559f7e4-35b0-4b07-a98a-07a0de1ca743"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[79]=",ExpressionUUID->"bdf92a17-a165-4699-80f3-fad0a3d2b5cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.426921107102701*^9, 3.426921113221074*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"1c6a6e61-7885-44d1-83b0-2303c0378c47"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", " ", " "},
          {" ", "D", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[80]=",ExpressionUUID->"77005947-c1f5-4d56-bc44-b78303557970"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4269211176234922`*^9, 3.4269211221175337`*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"c5891a97-7238-45e2-bf16-3ff1b4871320"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"SR", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"A", 
          RowBox[{"A", "'"}], "B", 
          RowBox[{"B", "'"}], "C", 
          RowBox[{"C", "'"}], "D", 
          RowBox[{"D", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP\[UnderBracket]RiemannCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
   C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]],
  Editable->False]], "Output",
 CellLabel->"Out[81]=",ExpressionUUID->"15b26579-551f-4881-a143-7085d0b09bef"]
}, Open  ]],

Cell["\<\
We can now follow previous procedure backwards and end up in the spacetime \
Riemann tensor.\
\>", "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
  3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
  3.426921522575389*^9}, {3.426921846857856*^9, 
  3.4269218569360228`*^9}},ExpressionUUID->"46b483b3-6f00-4404-b077-\
40bb582116f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "\[Sigma]", "]"}], "[", "%", 
  "]"}]], "Input",
 CellChangeTimes->{{3.426921314092822*^9, 3.426921319869419*^9}, {
  3.4269275929890623`*^9, 3.426927631582386*^9}, {3.426929049397834*^9, 
  3.426929050381413*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"5ef9d245-7b4c-4ff3-967a-47b6b516ce92"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", " ", " "},
          {" ", "D", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[82]=",ExpressionUUID->"93e7ce8c-eafb-4092-ad92-15049ad616cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", "%"}]], "Input",
 CellLabel->"In[83]:=",ExpressionUUID->"bb0b1359-eac1-420e-b723-d4bf6134d4cc"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[83]=",ExpressionUUID->"c33e35da-ec60-44fa-b41a-5261c4e922ce"]
}, Open  ]],

Cell["\<\
Sometimes intermediate objects need to be created  in a computation like the \
one just shown. This is done by the system in an automatic way. \
\>", "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
  3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
  3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
  3.4269224358159657`*^9, 3.426922492240142*^9}, {3.427086733902673*^9, 
  3.427086736386551*^9}},ExpressionUUID->"dda56b2c-581f-4ea0-ac7d-\
3ad23ff8c17e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"M", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.426921948581978*^9, 3.426921990399653*^9}, {
  3.426922296100553*^9, 3.426922297292939*^9}, {3.426923267908286*^9, 
  3.426923268842993*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"c3ab866b-2f23-411a-b629-63cd96f8b472"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"M", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`M[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[84]:=",ExpressionUUID->"a13eab35-6853-4a31-936e-c86831448143"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", 
  RowBox[{"M", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.426922000201456*^9, 3.4269220111659517`*^9}, {
  3.426922506283984*^9, 3.426922513171131*^9}, {3.426923286356811*^9, 
  3.426923286778791*^9}, {3.4269303136237183`*^9, 3.4269303322361193`*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"681dd250-e74d-4f4b-9a8b-dd7ab5cdc63d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"M", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`M[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[85]=",ExpressionUUID->"7234f76b-7f32-47e6-8d3c-d2c04d3090b2"]
}, Open  ]],

Cell[TextData[{
 "Here, the contraction of the soldering forms results in the spinor \
counterpart of the tensor ",
 StyleBox["M[-a, -b]", "Input",
  FontWeight->"Plain"],
 StyleBox[". The former has not been defined previously and thus the system \
must introduce this new object (a message informing about this is issued). \
The definition of spinor counterparts of tensor objects can be performed by \
the user independently (see next section).", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
  3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
  3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
  3.4269224358159657`*^9, 3.426922492240142*^9}, {3.42692259818603*^9, 
  3.426922757438169*^9}, {3.426922789239768*^9, 3.4269228882798758`*^9}, {
  3.426925624288653*^9, 3.426925640122044*^9}, {3.427351788654846*^9, 
  3.427351800921323*^9}},
 TextJustification->1.,ExpressionUUID->"98434b20-d257-4736-b575-614869158b62"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.426922043881568*^9, 3.42692204989389*^9}, 
   3.426922519180365*^9},
 CellLabel->"In[86]:=",ExpressionUUID->"fa4923dd-2149-4041-a285-6e96de73c7d5"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"SpinorOfTensor", "::", "name"}], "MessageName"], ":", 
  " ", "\<\"Spinor of \[NoBreak]\\!\\(M\\)\[NoBreak] not defined. Prepending \
\[NoBreak]\\!\\(SP\\)\[NoBreak].\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[86]:=",ExpressionUUID->"3284a4b1-4d8f-41b5-aba0-43d2f6667c8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]M", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor M\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]M[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]], ". ", "Equivalent of tensor M"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[86]:=",ExpressionUUID->"8abba4b5-2b17-4f19-8370-5d4b7d16a415"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]M\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor M\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]M\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor M"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[86]:=",ExpressionUUID->"ea212873-8c06-492c-a9e6-3ade8cd94423"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"SM", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"A", 
          RowBox[{"A", "'"}], "B", 
          RowBox[{"B", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP\[UnderBracket]M[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]],
  Editable->False]], "Output",
 CellLabel->"Out[86]=",ExpressionUUID->"d40ee127-d44d-4659-a39f-a9f639c42d3a"]
}, Open  ]],

Cell[TextData[{
 "The separation of the soldering form gets us back to the original tensor ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["M", "ab", "  "],
    AutoSpacing->False],
   $CellContext`M[-$CellContext`a, -$CellContext`b],
   Editable->False]], "Output",
  CellChangeTimes->{
   3.426922011577175*^9, 3.426922090502357*^9, 3.426922514122879*^9, 
    3.426923036576747*^9, 3.426923202214507*^9, {3.426923280218905*^9, 
    3.426923287325327*^9}, {3.426930314114965*^9, 3.426930332629694*^9}, 
    3.427019240560185*^9, 3.427024605392352*^9, 3.4270481903028717`*^9, 
    3.427086740692708*^9, 3.4270951720751038`*^9, 3.427108160419085*^9, 
    3.4271723133708887`*^9, 3.4272592993403063`*^9, 3.4272605272995453`*^9, 
    3.427263499967355*^9, 3.427276968827422*^9, 3.427351770360093*^9},
  ExpressionUUID->"77d08469-0553-4828-b8a7-e58e674e253d"],
 "."
}], "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
  3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
  3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
  3.4269224358159657`*^9, 3.426922492240142*^9}, {3.42692259818603*^9, 
  3.426922757438169*^9}, {3.426922789239768*^9, 3.4269228882798758`*^9}, {
  3.426925624288653*^9, 3.426925640122044*^9}, {3.427351788654846*^9, 
  3.42735186421553*^9}},
 TextJustification->1.,ExpressionUUID->"c7bc8ca4-9b91-458b-9222-49bb93fa4fb0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "@", "%"}]], "Input",
 CellChangeTimes->{{3.4269220795331793`*^9, 3.426922106986513*^9}, {
  3.426922533932102*^9, 3.4269225546347027`*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"feffddf1-3266-4ed2-b82b-806f0a0ea550"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"M", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`M[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[87]=",ExpressionUUID->"eded6c2d-d50b-4c9a-a2f3-90da669d3264"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{3.4269225701292877`*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"4a9e0cb0-2f45-4ef0-8b00-e177d4b04a6d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"M", 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`M[-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[88]=",ExpressionUUID->"e8638b0a-2032-441b-b24d-0c47610c7592"]
}, Open  ]],

Cell[TextData[{
 "The spinors ",
 StyleBox["SP\[UnderBracket]M", "Output"],
 " and ",
 StyleBox["SP\[UnderBracket]M\[Dagger]", "Output"],
 " are visitors of ",
 StyleBox["M", "Output"],
 ". Therefore if we wish to remove ",
 StyleBox["M", "Output"],
 ", we need to remove first its visitors."
}], "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
  3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
  3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
  3.4269224358159657`*^9, 3.426922492240142*^9}, {3.42692259818603*^9, 
  3.426922757438169*^9}, {3.426922789239768*^9, 3.4269228882798758`*^9}, {
  3.426925624288653*^9, 3.426925640122044*^9}, {3.427351788654846*^9, 
  3.42735186421553*^9}, {3.431331329955173*^9, 3.431331422406329*^9}},
 TextJustification->1.,ExpressionUUID->"66852d83-1965-46df-9af2-4d070708d12e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Undef", "/@", 
   RowBox[{"VisitorsOf", "@", "M"}]}], ";"}]], "Input",
 CellLabel->"In[89]:=",ExpressionUUID->"932d991b-22eb-4d43-85be-9924e4c03735"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]M\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]M\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[89]:=",ExpressionUUID->"19ccc865-bcb0-47a7-8827-7ef3f5044948"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "SP\[UnderBracket]M"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`SP\[UnderBracket]M],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[89]:=",ExpressionUUID->"2f653378-05f5-40a0-98d4-850ecac778fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "@", "M"}]], "Input",
 CellChangeTimes->{{3.4313313068229723`*^9, 3.431331311107401*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"3cce459b-7621-40b2-8444-ffc870861e09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`M],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[90]:=",ExpressionUUID->"55f09497-7873-4a6b-903c-c440121546b5"]
}, Open  ]],

Cell["\<\
There are cases in which we need to tell explicitly how the indices of the \
soldering forms should be contracted when they act on an expression.  This is \
achieved by means of extra options in the commands just ilustrated.\
\>", "Text",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
  3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
  3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
  3.4269224358159657`*^9, 3.426922492240142*^9}, {3.42692259818603*^9, 
  3.426922757438169*^9}, {3.426922789239768*^9, 3.4269228882798758`*^9}, {
  3.426925624288653*^9, 3.426925640122044*^9}, {3.426927371052204*^9, 
  3.426927388705284*^9}, {3.426927496809456*^9, 3.426927532353343*^9}, {
  3.426927693242045*^9, 3.426927786833659*^9}, {3.426927852034513*^9, 
  3.42692787739345*^9}},
 FontWeight->"Plain",ExpressionUUID->"cbfe8cef-1d50-456e-8426-e91ca42e0728"],

Cell[TextData[StyleBox["Consider an expression containing spacetime and \
spinor indices.", "Text",
 FontWeight->"Plain"]], "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
   3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
   3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
   3.4269224358159657`*^9, 3.426922492240142*^9}, {3.42692259818603*^9, 
   3.426922757438169*^9}, {3.426922789239768*^9, 3.4269228882798758`*^9}, {
   3.426925624288653*^9, 3.426925640122044*^9}, {3.426927915876411*^9, 
   3.426927939297722*^9}, {3.426928064913649*^9, 3.4269281905216837`*^9}, 
   3.426928823563572*^9, {3.426928956514123*^9, 
   3.426929003705145*^9}},ExpressionUUID->"1c4e9f5d-deee-4ccf-a02f-\
5a172238356d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"CDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}], "@", 
   RowBox[{"FRiemannCDe", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.426928827188755*^9, 3.4269288609015417`*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"4136a048-bd4c-4c4b-ab04-1eaa35c0e975"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", 
     RowBox[{"AA", "'"}], "  "], GridBox[{
      {
       RowBox[{"F", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
   $CellContext`FRiemannCDe[-$CellContext`a, -$CellContext`b, -C, -D]],
  Editable->False]], "Output",
 CellLabel->"Out[91]=",ExpressionUUID->"23e9ce1b-bbfa-431a-b7e9-8805674a929d"]
}, Open  ]],

Cell[TextData[{
 StyleBox["By default ", "Text",
  FontWeight->"Plain"],
 StyleBox["SeparateSolderingForm", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["will extract soldering forms from all the tensor indices and all \
the complex conjugated pairs of spinor indices.", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
   3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
   3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
   3.4269224358159657`*^9, 3.426922492240142*^9}, {3.42692259818603*^9, 
   3.426922757438169*^9}, {3.426922789239768*^9, 3.4269228882798758`*^9}, {
   3.426925624288653*^9, 3.426925640122044*^9}, {3.426927915876411*^9, 
   3.426927939297722*^9}, {3.426928064913649*^9, 3.4269281905216837`*^9}, 
   3.426928823563572*^9, {3.426928956514123*^9, 3.426929020425641*^9}, {
   3.4269291041673717`*^9, 3.426929174345974*^9}, {3.426929245489614*^9, 
   3.426929251601804*^9}, {3.426929307401781*^9, 3.4269293504800367`*^9}, {
   3.4269294881622877`*^9, 
   3.426929518177541*^9}},ExpressionUUID->"b18291db-6ce7-458b-be9b-\
77ae92cddd0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "\[Sigma]", "]"}], "[", "expr", 
  "]"}]], "Input",
 CellChangeTimes->{{3.426928850126348*^9, 3.426928877471731*^9}, {
  3.42701929127768*^9, 3.4270193029081993`*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"91116afc-1f4f-4e79-903f-d9784d94c6eb"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", 
           RowBox[{"B", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "F", 
           RowBox[{"C", "'"}]},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`F, $CellContext`C\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
        {
         RowBox[{"SF", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " ", " ", " "},
            {"B", 
             RowBox[{"B", "'"}], "F", 
             RowBox[{"C", "'"}], "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`c][
     $CellContext`SP\[UnderBracket]FRiemannCDe[-$CellContext`B, \
-$CellContext`B\[Dagger], -$CellContext`F, -$CellContext`C\[Dagger], -C, -D]],
    
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[92]=",ExpressionUUID->"8bb3b320-2c2e-4d39-bc73-946fa270dfa4"]
}, Open  ]],

Cell[TextData[{
 StyleBox["We may control with extra options the vector bundles whose indices \
will be pulled out by ", "Text",
  FontWeight->"Plain"],
 StyleBox["SeparateSolderingForm", "Input",
  FontWeight->"Plain"],
 StyleBox[".", "Input"]
}], "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
   3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
   3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
   3.4269224358159657`*^9, 3.426922492240142*^9}, {3.42692259818603*^9, 
   3.426922757438169*^9}, {3.426922789239768*^9, 3.4269228882798758`*^9}, {
   3.426925624288653*^9, 3.426925640122044*^9}, {3.426927915876411*^9, 
   3.426927939297722*^9}, {3.426928064913649*^9, 3.4269281905216837`*^9}, 
   3.426928823563572*^9, {3.426928956514123*^9, 3.426929020425641*^9}, {
   3.4269291041673717`*^9, 3.426929174345974*^9}, {3.426929245489614*^9, 
   3.426929251601804*^9}, {3.426929307401781*^9, 3.4269293504800367`*^9}, {
   3.4269294881622877`*^9, 
   3.426929621329809*^9}},ExpressionUUID->"552f30bb-8c63-4d88-aa76-\
d9289360b7ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "\[Sigma]", "]"}], "[", 
  RowBox[{"expr", ",", "Spin"}], "]"}]], "Input",
 CellChangeTimes->{{3.4269288853755713`*^9, 3.426928889559857*^9}, {
  3.427019305121331*^9, 3.4270193056937933`*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"916be486-1c82-4797-877c-8abd31291720"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
        {
         RowBox[{"F", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`c][
     $CellContext`FRiemannCDe[-$CellContext`a, -$CellContext`b, -C, -D]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[93]=",ExpressionUUID->"997711bd-b3d1-4e05-8b94-2b5cb8cce735"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "\[Sigma]", "]"}], "[", 
  RowBox[{"expr", ",", "TangentM4"}], "]"}]], "Input",
 CellChangeTimes->{{3.426928920993394*^9, 3.426928924056203*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"8dd7125e-61de-4a22-bd4c-64f2d4873ca3"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", 
           RowBox[{"B", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "F", 
           RowBox[{"C", "'"}]},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`F, $CellContext`C\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubsuperscriptBox["\[EmptyDownTriangle]", 
       RowBox[{"AA", "'"}], "  "], GridBox[{
        {
         RowBox[{"SF", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " ", " ", " "},
            {"B", 
             RowBox[{"B", "'"}], "F", 
             RowBox[{"C", "'"}], "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
     $CellContext`SP\[UnderBracket]FRiemannCDe[-$CellContext`B, \
-$CellContext`B\[Dagger], -$CellContext`F, -$CellContext`C\[Dagger], -C, -D]],
    
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[94]=",ExpressionUUID->"677f45f0-c01b-4b98-b441-eb397de9c044"]
}, Open  ]],

Cell[TextData[{
 StyleBox["A similar index-selection is also available for ", "Text",
  FontWeight->"Plain"],
 StyleBox["PutSolderingForm", "Output",
  FontWeight->"Plain"],
 StyleBox[". ", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
   3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
   3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
   3.4269224358159657`*^9, 3.426922492240142*^9}, {3.42692259818603*^9, 
   3.426922757438169*^9}, {3.426922789239768*^9, 3.4269228882798758`*^9}, {
   3.426925624288653*^9, 3.426925640122044*^9}, {3.426927915876411*^9, 
   3.426927939297722*^9}, {3.426928064913649*^9, 3.4269281905216837`*^9}, 
   3.426928823563572*^9, {3.426928956514123*^9, 3.426929020425641*^9}, {
   3.4269291041673717`*^9, 3.426929174345974*^9}, {3.426929245489614*^9, 
   3.426929251601804*^9}, {3.426929307401781*^9, 3.4269293504800367`*^9}, {
   3.4269294881622877`*^9, 3.426929621329809*^9}, {3.427439396967119*^9, 
   3.4274394302058363`*^9}, {3.427439481389924*^9, 
   3.427439481933072*^9}},ExpressionUUID->"1d3508ad-b510-4a37-803f-\
79ba09e0f790"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"expr", ",", "Spin"}], "]"}]], "Input",
 CellLabel->"In[95]:=",ExpressionUUID->"eb0e664f-ac54-4d4c-bb0d-d63ddf0d59d8"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"c", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`c, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubsuperscriptBox["\[EmptyDownTriangle]", 
       RowBox[{"AA", "'"}], "  "], GridBox[{
        {
         RowBox[{"F", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
     $CellContext`FRiemannCDe[-$CellContext`a, -$CellContext`b, -C, -D]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[95]=",ExpressionUUID->"21c1b5f5-513e-40a5-82b2-a17159c45696"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"expr", ",", "TangentM4"}], "]"}]], "Input",
 CellLabel->"In[96]:=",ExpressionUUID->"7072b370-bc5a-4bfe-91b3-b5ce815e84df"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "F", 
           RowBox[{"F", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`F, -$CellContext`F\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubsuperscriptBox["\[EmptyDownTriangle]", 
       RowBox[{"AA", "'"}], "  "], GridBox[{
        {
         RowBox[{"F", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
     $CellContext`FRiemannCDe[-$CellContext`a, -$CellContext`b, -C, -D]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[96]=",ExpressionUUID->"c95a1ab6-3a44-42f6-949d-c9d939be413c"]
}, Open  ]],

Cell[TextData[{
 StyleBox["The following expression is the spinor form of a tensor \
(Bel-Robinson tensor). If we wish to use ", "Text",
  FontWeight->"Plain"],
 StyleBox["PutSolderingForm", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["to find its tensor equivalent we need to pass an argument stating \
how the spinor indices are grouped into tensor ones as there is not a unique \
way of doing it.  This is achieved by means of the head  ", "Text",
  FontWeight->"Plain"],
 StyleBox["Pair", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["which represents conjugated pairs of spinor indices.", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.4269211396276608`*^9, 3.426921307695565*^9}, {
   3.4269214200640993`*^9, 3.4269214252400627`*^9}, {3.426921480024281*^9, 
   3.426921522575389*^9}, {3.426922278441744*^9, 3.426922372127878*^9}, {
   3.4269224358159657`*^9, 3.426922492240142*^9}, {3.42692259818603*^9, 
   3.426922757438169*^9}, {3.426922789239768*^9, 3.4269228882798758`*^9}, {
   3.426925624288653*^9, 3.426925640122044*^9}, {3.426927915876411*^9, 
   3.426927939297722*^9}, {3.426928064913649*^9, 3.4269281905216837`*^9}, 
   3.426929358561805*^9, {3.4269331664276123`*^9, 3.4269332081590633`*^9}, {
   3.427351914617689*^9, 
   3.427351925795732*^9}},ExpressionUUID->"f51ce2c6-be16-434c-b11a-\
99cf61c18fc1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PsiCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}]}], "]"}], 
  RowBox[{"Dagger", "[", 
   RowBox[{"PsiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.426926108509042*^9, 3.426926124119577*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"9053b194-3710-4189-aa2b-f4e27924ad71"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        "\[Dagger]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {
           RowBox[{"A", "'"}], 
           RowBox[{"B", "'"}], 
           RowBox[{"C", "'"}], 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[97]=",ExpressionUUID->"e7bb15a8-5ed0-40d6-9f7a-6b0dba899e18"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Pair", "[", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "A\[Dagger]"}]}], "]"}], ",", 
     RowBox[{"Pair", "[", 
      RowBox[{
       RowBox[{"-", "B"}], ",", 
       RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", 
     RowBox[{"Pair", "[", 
      RowBox[{
       RowBox[{"-", "C"}], ",", 
       RowBox[{"-", "C\[Dagger]"}]}], "]"}], ",", 
     RowBox[{"Pair", "[", 
      RowBox[{
       RowBox[{"-", "D"}], ",", 
       RowBox[{"-", "D\[Dagger]"}]}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.426926318622169*^9, 3.426926334252363*^9}, {
   3.426926489038221*^9, 3.4269265134535713`*^9}, {3.426927276062265*^9, 
   3.426927314021167*^9}, {3.4269297783822107`*^9, 3.426929783558899*^9}, 
   3.4269300989032*^9, {3.4269301996538887`*^9, 3.4269302356138887`*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"3abf5bf8-dc53-4d3a-9495-e18f659491a8"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        "\[Dagger]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {
           RowBox[{"A", "'"}], 
           RowBox[{"B", "'"}], 
           RowBox[{"C", "'"}], 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", 
           RowBox[{"B", "'"}]},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "C", 
           RowBox[{"C", "'"}]},
          {"c", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "D", 
           RowBox[{"D", "'"}]},
          {"d", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`d, D, $CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->"Out[98]=",ExpressionUUID->"c03714d8-69e2-4cac-8fd7-6071e2b64087"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. Relations between spinors and tensors", "SubsubsectionIcon",ExpressionUUID->"14abc78a-2ee2-4dfd-88bf-4c42b6e82220"],

Cell[TextData[{
 StyleBox["There are spinors which can be put into relation with tensors and \
tensors which can be put into relation with spinors. In both cases the \
relation is carried out by means of the soldering form. Whenever one of these \
relations apply, ", "Text",
  FontWeight->"Plain"],
 StyleBox["Spinors`", "Output",
  FontWeight->"Plain"],
 StyleBox[" enables the user to define the spinor (resp. tensor) counterpart \
of a tensor (resp. spinor).   ", "Text",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.422592015031691*^9, 3.4225920436791553`*^9}, {
   3.423659911246599*^9, 3.423659920924469*^9}, {3.4238033577306767`*^9, 
   3.423803461072209*^9}, {3.423903706656168*^9, 3.4239037084819403`*^9}, {
   3.424430170212186*^9, 3.424430179440365*^9}, {3.424435475457535*^9, 
   3.424435513476344*^9}, {3.4259677499948*^9, 3.425967795352283*^9}, {
   3.4259678657363977`*^9, 3.4259678879130507`*^9}, {3.4259679320413933`*^9, 
   3.425967981712957*^9}, {3.4259681495490713`*^9, 3.425968292137138*^9}, {
   3.425968430417287*^9, 3.425968515905218*^9}, 
   3.427019373560174*^9},ExpressionUUID->"6deb9c33-f605-40ce-8032-\
b51433554fea"],

Cell[TextData[{
 StyleBox["DefSpinorOfTensor", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["          ", "Input",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Defines the spinor counterpart of a tensor (when applicable)\n", 
  "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["DefTensorOfSpinor", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["          ", "Input",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Defines the tensor counterpart of a spinor (when applicable)", 
  "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}], "DefinitionBox",
 CellChangeTimes->{{3.425968615264347*^9, 3.4259686940667763`*^9}, {
  3.42596873084892*^9, 3.425968812377137*^9}, {3.425969041049263*^9, 
  3.425969044601117*^9}, {3.426274518397209*^9, 
  3.426274524343195*^9}},ExpressionUUID->"a18dabd4-bc0d-4dd1-91c6-\
8bc17886e752"],

Cell[TextData[StyleBox["Let us define a spinor. ", "Text",
 FontWeight->"Plain"]], "MathCaption",
 CellChangeTimes->{{3.422592015031691*^9, 3.4225920436791553`*^9}, {
  3.423659911246599*^9, 3.423659920924469*^9}, {3.4238033577306767`*^9, 
  3.423803461072209*^9}, {3.423903706656168*^9, 3.4239037084819403`*^9}, {
  3.424430170212186*^9, 3.424430179440365*^9}, {3.424435475457535*^9, 
  3.424435513476344*^9}, {3.4259677499948*^9, 3.425967795352283*^9}, {
  3.4259678657363977`*^9, 3.4259678879130507`*^9}, {3.4259679320413933`*^9, 
  3.425967981712957*^9}, {3.4259681495490713`*^9, 3.425968292137138*^9}, {
  3.425968430417287*^9, 3.425968515905218*^9}, {3.425968896259141*^9, 
  3.4259689208090973`*^9}, {3.425968991386305*^9, 
  3.42596899256115*^9}},ExpressionUUID->"eca53415-758a-49ee-ba2b-\
92a44d9b06ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Kappa]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.425968941688896*^9, 3.425968959791359*^9}, {
   3.42596899467135*^9, 3.425969014148177*^9}, 3.426795420791072*^9},
 CellLabel->"In[99]:=",ExpressionUUID->"e3664d99-bf86-4261-b415-0af20b5c1845"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"da7d1f35-a937-4a43-846b-a9113cd7bc00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Kappa]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"c6a06589-e6bf-44f7-8a30-d3c85be1799f"]
}, Open  ]],

Cell[TextData[{
 StyleBox["This spinor has a tensor counterpart. To introduce it into the \
session we use the command ", "Text",
  FontWeight->"Plain"],
 StyleBox["DefTensorOfSpinor ", "Input",
  FontWeight->"Plain"],
 StyleBox["in the following way:", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.422592015031691*^9, 3.4225920436791553`*^9}, {
  3.423659911246599*^9, 3.423659920924469*^9}, {3.4238033577306767`*^9, 
  3.423803461072209*^9}, {3.423903706656168*^9, 3.4239037084819403`*^9}, {
  3.424430170212186*^9, 3.424430179440365*^9}, {3.424435475457535*^9, 
  3.424435513476344*^9}, {3.4259677499948*^9, 3.425967795352283*^9}, {
  3.4259678657363977`*^9, 3.4259678879130507`*^9}, {3.4259679320413933`*^9, 
  3.425967981712957*^9}, {3.4259681495490713`*^9, 3.425968292137138*^9}, {
  3.425968430417287*^9, 3.425968515905218*^9}, {3.425968896259141*^9, 
  3.4259689208090973`*^9}, {3.425968991386305*^9, 3.42596899256115*^9}, {
  3.425969027698783*^9, 3.4259690366487923`*^9}, {3.425969127941152*^9, 
  3.425969275856983*^9}},ExpressionUUID->"ea8c4543-9494-4ee6-85d0-\
7c1079d7e68c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensorOfSpinor", "[", 
  RowBox[{
   RowBox[{"KT", "[", "a", "]"}], ",", 
   RowBox[{"\[Kappa]", "[", 
    RowBox[{"A", ",", "A\[Dagger]"}], "]"}], ",", "\[Sigma]"}], 
  "]"}]], "Input",
 CellLabel->
  "In[100]:=",ExpressionUUID->"fa0d462b-8361-42ec-9044-485849e5a1d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"KT", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of spinor \[Kappa]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`KT[$CellContext`a], ". ", "Equivalent of spinor \[Kappa]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[100]:=",ExpressionUUID->"c709f135-5a14-472b-9a1b-65e6295b3603"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"KT\[Dagger]", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of spinor \[Kappa]\[Dagger]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`KT\[Dagger][$CellContext`a], ". ", 
   "Equivalent of spinor \[Kappa]\[Dagger]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[100]:=",ExpressionUUID->"f3f7c7f4-d59b-43f9-be93-3353d9a172d7"]
}, Open  ]],

Cell["\<\
The output form of the tensor is actually constructed from that of the spinor:\
\>", "MathCaption",ExpressionUUID->"05ed7bd1-28a2-4ace-b12e-5a19ee76555c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KT", "[", "a", "]"}]], "Input",
 CellLabel->
  "In[101]:=",ExpressionUUID->"407dd261-4d19-462c-81f4-c0432fc0d988"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S\[Kappa]", 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`KT[$CellContext`a],
  Editable->False]], "Output",
 CellLabel->
  "Out[101]=",ExpressionUUID->"e6a4dcdc-dc18-4920-9bdd-df87eb3ff337"]
}, Open  ]],

Cell[TextData[{
 StyleBox["The symbol ", "Text",
  FontWeight->"Plain"],
 StyleBox["KT", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Text"],
 StyleBox["represents the tensor counterpart of the spinor ", "Text",
  FontWeight->"Plain"],
 StyleBox["\[Kappa]", "Output"],
 StyleBox[".", "Output",
  FontWeight->"Bold"],
 StyleBox["This must be a symbol which does not correspond to any object \
defined previously in the session.  From this point on, the system stores  ", 
  "Text",
  FontWeight->"Plain"],
 StyleBox["KT", "Input",
  FontWeight->"Plain"],
 StyleBox[" as the tensor counterpart of ", "Text",
  FontWeight->"Plain"],
 StyleBox[" ", "Text"],
 StyleBox["\[Kappa]", "Output"],
 StyleBox[". Any of the commands which relate spinors to tensors are now \
aware of this binding between ", "Text",
  FontWeight->"Plain"],
 StyleBox["\[Kappa]", "Output"],
 StyleBox[" and ", "Text",
  FontWeight->"Plain"],
 StyleBox["KT", "Input",
  FontWeight->"Plain"],
 StyleBox[".", "Input"],
 StyleBox["Let us see some examples:", "Text",
  FontWeight->"Plain"]
}], "MathCaption",ExpressionUUID->"642dcc3a-995c-4966-9a40-abf86e97dc61"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TensorOfSpinor", "[", 
  RowBox[{"\[Kappa]", ",", "\[Sigma]"}], "]"}]], "Input",
 CellChangeTimes->{{3.425969580726883*^9, 3.425969625526478*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"c13a0a97-d3af-4c55-aa3a-74bed1416fc6"],

Cell[BoxData["KT"], "Output",
 CellLabel->
  "Out[102]=",ExpressionUUID->"0485a136-6af0-4d26-999f-fbe5262807e9"]
}, Open  ]],

Cell[TextData[{
 StyleBox["We start from the spinor ", "Text",
  FontWeight->"Plain"],
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Kappa]", 
     RowBox[{"AA", "'"}], "   "],
    AutoSpacing->False],
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
   Editable->False]], "Output",
  CellChangeTimes->{3.441104872885298*^9, 3.441107288336762*^9, 
   3.441519208481247*^9, 3.441519344651574*^9, 3.441607835042262*^9, 
   3.4416973650115957`*^9, 3.441806808304585*^9, 3.441807345276888*^9, 
   3.4418213202098093`*^9, 3.458277104119226*^9},ExpressionUUID->
  "75a09423-4282-464c-b557-3daef629ccb7"],
 StyleBox[" transform it into a tensor and then back to the same spinor all \
by using ", "Text",
  FontWeight->"Plain"],
 StyleBox["PutSolderingForm", "DisplayMath",
  FontWeight->"Plain"],
 StyleBox["/", "Text",
  FontWeight->"Plain"],
 StyleBox["ContractSolderingForm", "DisplayMath",
  FontWeight->"Plain"],
 StyleBox[".", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQA2IQPZf5YaNww0vHJbtLW0G0ypPnH2SaXjo6TJX9BKK3
JG7/nQSkO/0XcSQD6ZD/Ib8nA2m+nH4wbXXKjXtq80vHCvE8HhCtsCRv0XQg
bWanvxxEp1/df6G57aXjc9fsayB60gTz+yB6m/nfhyBaIrjxOYjuvrDtLYj+
N3EjUwuQzk9uEQHRWVFnVUF0z/caAxD9yIsjAUQrPJFMBtFzYt5kg+iPXwRz
QHReTFkBiH5xaEohiH4t+68GRGfkVPeD6AkiD6aA6InmPRtB9J0gTu1WIP13
/U9dEJ1t9TIQRDMknIsF0QfYTiWD6EtXLVNAdKDPlgwQXRUUVgSizZJ91oBo
ob17wfQ7FufPykdeOkpFr/kLogEJR7qr
  "],
 TextJustification->1.,ExpressionUUID->"75dc5883-745f-4cb9-ac95-6bc0aea75320"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Kappa]", "[", 
  RowBox[{
   RowBox[{"-", "A"}], ",", 
   RowBox[{"-", "A\[Dagger]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.425970337424562*^9, 3.4259703562149563`*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"da120478-2e98-4ee1-9c02-e9df5d71508c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Kappa]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"A", 
          RowBox[{"A", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
  Editable->False]], "Output",
 CellLabel->
  "Out[103]=",ExpressionUUID->"2f4211af-d778-4358-bb50-b66bce6108ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.425970359409957*^9, 3.4259703900237293`*^9}, {
  3.426795434222005*^9, 3.426795437259094*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"da3f44da-a88e-4ed9-837b-d3f3b27ff2fe"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Kappa]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[104]=",ExpressionUUID->"7e6fda8c-972d-48de-b992-f543c4b944f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.425970395892438*^9, 3.425970402398652*^9}, {
  3.426795440161738*^9, 3.426795441648342*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"1ea7aaee-5d8c-48e2-a731-9ac89b009742"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S\[Kappa]", 
      StyleBox[GridBox[{
         {" "},
         {"a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`KT[-$CellContext`a],
  Editable->False]], "Output",
 CellLabel->
  "Out[105]=",ExpressionUUID->"db18d0b9-bdab-4dc6-a8df-61439ffa4ddd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.4259704191190653`*^9, 3.425970419550926*^9}, {
  3.4259705646866703`*^9, 3.425970574014608*^9}, {3.426795446407441*^9, 
  3.426795448423862*^9}},
 CellLabel->
  "In[106]:=",ExpressionUUID->"88cb999a-9b83-44e6-a025-a6d738b40d6f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S\[Kappa]", 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`KT[-$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[106]=",ExpressionUUID->"d8c20e62-1f76-45dc-8fd4-cb7f66e72c5c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.425970576173709*^9, 3.425970582095077*^9}, {
  3.426795450513101*^9, 3.426795451584601*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"3e2fc2d9-2ac0-4036-95f0-4681bd015ba9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Kappa]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"A", 
          RowBox[{"A", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
  Editable->False]], "Output",
 CellLabel->
  "Out[107]=",ExpressionUUID->"7a125ccb-a605-4a24-af56-bda1b963b45f"]
}, Open  ]],

Cell[TextData[StyleBox["Similarly we can introduce the spinor counterpart of \
any tensor already defined in the sesssion. For example:", "Text",
 FontWeight->"Plain"]], "MathCaption",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQPZf5YaNww0vHJbtLW0G0ypPnH2SaXjo6TJX9BKK3
JG7/nQSkO/0XcSQD6ZD/Ib8nA2m+nH4wbXXKjXtq80vHCvE8HhCtsCRv0XQg
bWanvxxEp1/df6G57aXjc9fsayB60gTz+yB6m/nfhyBaIrjxOYjuvrDtLYj+
N3EjUwuQzk9uEQHRWVFnVUF0z/caAxD9yIsjAUQrPJFMBtFzYt5kg+iPXwRz
QHReTFkBiH5xaEohiH4t+68GRGfkVPeD6AkiD6aA6InmPRtB9J0gTu1WIP13
/U9dEJ1t9TIQRDMknIsF0QfYTiWD6EtXLVNAdKDPlgwQXRUUVgSizZJ91oBo
ob17wTQAnUqyQg==
  "],ExpressionUUID->"512e5125-de16-4418-9975-6d768e4da388"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.425968883401659*^9, 3.4259688875782824`*^9}, {
  3.425968933950334*^9, 3.4259689344522142`*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"051e5d8e-0a0d-4f6b-a777-952ea4ef56c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"41304e91-33dc-49cc-9c8d-9867f3174474"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T\[Dagger][-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"6a0633b2-d81b-4629-9967-6c57446ff4e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinorOfTensor", "[", 
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "\[Sigma]"}], "]"}]], "Input",
 CellChangeTimes->{{3.425971117141612*^9, 3.42597113862037*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"9f4b4fd6-5568-4e09-b44d-b663aa837c29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ST", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor T\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`ST[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]], ". ", "Equivalent of tensor T"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[109]:=",ExpressionUUID->"7e2700a4-aa3d-45f1-accc-25103ded5451"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ST\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor T\[Dagger]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`ST\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A, \
-$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor T\[Dagger]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[109]:=",ExpressionUUID->"31814e7c-5834-4e05-b6cc-e8ddeca68ec1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["As above the symbol ", "Text",
  FontWeight->"Plain"],
 StyleBox["ST", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["should not correspond to any of the symbols defined previously in \
the session. Note carefully the index arrangement in the spinor  ", "Text",
  FontWeight->"Plain"],
 StyleBox["ST", "Input",
  FontWeight->"Plain"],
 StyleBox[". This is fixed by convention and cannot be altered by the user. \
We will come back to this important point below.  For now we present some \
manipulation examples.", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->CompressedData["
1:eJwdzU0ogwEAh/GFNJHIalZbUXOSjyTLDngL2VLLLErU2GTZmlGk2cE+yMey
DcvFHNbkNq3mK8qSlMlaQg6KzWp7Y2VSYm3z/nd4+h2fypEJ8WgOjUZjU0FH
bkhfNk8SrtPpBciNRD/ZBpJos3O+oHf4KDlCuSxy0mWUkowkuUFZrLJk5fs7
C+1GkphlqotghUvt3KJsaqnbg2MP50HjIklEO5SPcN3Ke4GHvFQIlvfqo3A1
eBiHaZsnx0Q5ITMx4PjAbRU0/+jqYVhIl8KKCEsGtwc/lDDxXaqC6sEZDYxd
bE7Cd05aBxWqOQu0Ml43oY1n9sBncUH1AmVq/7cGKvlkD6RJA0PQl++XwbuH
Zjns6fYqoFbcNwXlomstjK8JjLArVWuGksyKFZYYdG4YexIcwIb+xhOYbNVk
ld7k+WDihHkFz9YPAtmvu/0e7hCOL3hcz/qD4eMlOveSJIS7b1n/AYUR8FY=

  "],
 TextJustification->1.,ExpressionUUID->"e66a3575-2dc9-468a-828a-9c6ca3e0da8e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], "//", "PutSolderingForm"}]], "Input",
 CellChangeTimes->{{3.425971884815585*^9, 3.425971901604768*^9}, {
  3.426795467974736*^9, 3.426795468802492*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"d9afb67e-553a-4799-925f-d146e6694bc7"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[110]=",ExpressionUUID->"1d8d9d53-1c8f-42fa-874c-eb6bac5258c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.425971907934911*^9, 3.425971911991536*^9}, {
  3.4267954716304007`*^9, 3.4267954728308*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"9364db8b-ef5c-4112-b564-a5377f5ba605"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"ST", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"A", 
          RowBox[{"A", "'"}], "B", 
          RowBox[{"B", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`ST[-$CellContext`A, -$CellContext`A\[Dagger], -$CellContext`B, \
-$CellContext`B\[Dagger]],
  Editable->False]], "Output",
 CellLabel->
  "Out[111]=",ExpressionUUID->"6eb46372-a5e3-4f55-b946-a12f32897822"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T\[Dagger]", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], "//", "PutSolderingForm"}]], "Input",
 CellChangeTimes->{{3.425971884815585*^9, 3.42597192796939*^9}, {
  3.4267954748050413`*^9, 3.426795475324115*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"46555cd6-d0b9-4249-87ce-87e09407a4c5"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T\[Dagger]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T\[Dagger][-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[112]=",ExpressionUUID->"f5143e46-53e9-48e5-b519-be59519730e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.425971907934911*^9, 3.425971911991536*^9}, {
  3.426795479337904*^9, 3.426795483956058*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"1ef318d5-5ab0-435f-b388-0ee54036dd09"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"ST\[Dagger]", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {
          RowBox[{"A", "'"}], "A", 
          RowBox[{"B", "'"}], "B"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`ST\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A, \
-$CellContext`B\[Dagger], -$CellContext`B],
  Editable->False]], "Output",
 CellLabel->
  "Out[113]=",ExpressionUUID->"5da65cc8-999f-4f77-9f94-a06ee1d299ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.4259721859262457`*^9, 3.4259722174707413`*^9}, {
  3.42597262735775*^9, 3.425972653620799*^9}, {3.426795486921021*^9, 
  3.426795489986434*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"42ff8197-d674-4619-bfb5-04d294a0b70b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"ST\[Dagger]", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {
           RowBox[{"A", "'"}], "A", 
           RowBox[{"B", "'"}], "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ST\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A, \
-$CellContext`B\[Dagger], -$CellContext`B],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", 
           RowBox[{"B", "'"}]},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[114]=",ExpressionUUID->"a280ddda-6935-42f3-aa41-375a4a8df132"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.4259722201095963`*^9, 3.425972224471628*^9}, {
  3.4267954935269737`*^9, 3.4267954948411818`*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"e85a0999-3611-47d9-abb5-79020d67f0db"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"T\[Dagger]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`T\[Dagger][-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->
  "Out[115]=",ExpressionUUID->"9ae8e9b9-88f3-42b6-81eb-baae118d7e49"]
}, Open  ]],

Cell[TextData[{
 StyleBox["The above examples can be generalized to tensors and spinors with \
a higher number of indices with the following provision: in the commands ", 
  "Text",
  FontWeight->"Plain"],
 StyleBox["DefSpinorOfTensor", "Input",
  FontWeight->"Plain"],
 StyleBox[" and ", "Text",
  FontWeight->"Plain"],
 StyleBox["DefTensorOfSpinor", "Input",
  FontWeight->"Plain"],
 StyleBox[" spinor indices must be always arranged according to the pattern \
index-Dagger[index]. Otherwise an error message is thrown.", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->CompressedData["
1:eJwdzUsowwEAx/E1YvKIrFh5jDgJy2vZAf9imdQyi/Icm8jWNisSO2C2wtjM
xgUHrdxIeUZZDspkSZscVkxq/tkKKbE2/r8dvn2O37x+lWiATqPRcqjgRoxv
On2KJOyno3pY8OJ/z5ohiTpb9ifc7zsK9VPOCbcYUkrxnzi0QpmiMEXlOfmJ
Nh1JjGcokyDbrtxao6yqKd2Gg57zW52BJPwN8ntoMXMf4SE37IOZrdN+uHB7
GISR5T36LKVKOsuEwx03hdD4reXA5yaGBLJfWFK43hWQw4+vNAVUdo2p4euF
dQS+ZUe0cEgxaYJm5pMVLnONe9ArSijSU4Z3f4qhnEe2QJrE1Q0dcU4pvPNU
y2BL8/4QnBC1aaBMeDUBg0sCHWwMlxih+G/eDFNntDvw9UFwAMvaK05gqFYd
VXId64AfJxmX8Mxy4Ip+d+rdcJPY+ITHHNYvZHT2thso3RpzD8yv7JiC3uS0
RTiaG7BCfnz5KvwHZ1L+ow==
  "],
 TextJustification->1.,ExpressionUUID->"2cf64511-13cf-46bc-9186-a544c235ddea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinorOfTensor", "[", 
  RowBox[{
   RowBox[{"TST", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], ",", 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "\[Sigma]"}], "]"}]], "Input",
 CellLabel->
  "In[116]:=",ExpressionUUID->"8fed9c76-6a87-4a56-a61b-df91f003a2e0"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"DefSpinorOfTensor", "::", "incomp"}], "MessageName"], ":", 
  " ", "\<\"Indices \
\[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\(\\*StyleBox[\\\"{\\\", \
Rule[FontColor, RGBColor[0, 0, 1]]]\\(\\(-A\[Dagger]\\)\\),\[ThinSpace] \
\\(\\(-A\\)\\),\[ThinSpace] \\(\\(-B\[Dagger]\\)\\),\[ThinSpace] \
\\(\\(-B\\)\\)\\*StyleBox[\\\"}\\\", Rule[FontColor, RGBColor[0, 0, 1]]]\\), \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], IndexList[Times[-1, A\
\\\\[Dagger]], Times[-1, A], Times[-1, B\\\\[Dagger]], Times[-1, B]], \
Rule[Editable, False]]\\)\[NoBreak] and \
\[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\(\\*StyleBox[\\\"{\\\", \
Rule[FontColor, RGBColor[0, 0, 1]]]\\(\\(-a\\)\\),\[ThinSpace] \\(\\(-b\\)\\)\
\\*StyleBox[\\\"}\\\", Rule[FontColor, RGBColor[0, 0, 1]]]\\), \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], IndexList[Times[-1, \
a], Times[-1, b]], Rule[Editable, False]]\\)\[NoBreak] are \
incompatible.\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[116]:=",ExpressionUUID->"4af051a2-e4d6-4317-a0cd-271cd2ae185b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[CapitalPhi]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.425972988394376*^9, 3.425973033256374*^9}, {
  3.426795511794889*^9, 3.426795512853903*^9}},
 CellLabel->
  "In[117]:=",ExpressionUUID->"ebedcf67-3722-4387-a873-a7cc330b33be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[CapitalPhi]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[CapitalPhi][-$CellContext`A, -$CellContext`B, \
-$CellContext`A\[Dagger], -$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[117]:=",ExpressionUUID->"b30eb7d1-6728-4590-83fd-022be309f60b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[CapitalPhi]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[CapitalPhi]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger], -$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[117]:=",ExpressionUUID->"8fd1c13f-1cd2-421a-98d1-7d3c7cda7428"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensorOfSpinor", "[", 
  RowBox[{
   RowBox[{"\[CapitalPhi]T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", 
   RowBox[{"\[CapitalPhi]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", "\[Sigma]"}], "]"}]], "Input",\

 CellLabel->
  "In[118]:=",ExpressionUUID->"306388d7-b653-4fd7-8f21-93cc3e028eb3"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"DefTensorOfSpinor", "::", "incomp"}], "MessageName"], ":", 
  " ", "\<\"Indices \
\[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\(\\*StyleBox[\\\"{\\\", \
Rule[FontColor, RGBColor[0, 0, 1]]]\\(\\(-a\\)\\),\[ThinSpace] \\(\\(-b\\)\\)\
\\*StyleBox[\\\"}\\\", Rule[FontColor, RGBColor[0, 0, 1]]]\\), \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], IndexList[Times[-1, \
a], Times[-1, b]], Rule[Editable, False]]\\)\[NoBreak] and \
\[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\(\\*StyleBox[\\\"{\\\", \
Rule[FontColor, RGBColor[0, 0, 1]]]\\(\\(-A\\)\\),\[ThinSpace] \
\\(\\(-B\\)\\),\[ThinSpace] \\(\\(-A\[Dagger]\\)\\),\[ThinSpace] \\(\\(-B\
\[Dagger]\\)\\)\\*StyleBox[\\\"}\\\", Rule[FontColor, RGBColor[0, 0, 1]]]\\), \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], IndexList[Times[-1, \
A], Times[-1, B], Times[-1, A\\\\[Dagger]], Times[-1, B\\\\[Dagger]]], \
Rule[Editable, False]]\\)\[NoBreak] are incompatible.\"\>"}]], "Message", \
"MSG",
 CellLabel->
  "During evaluation of \
In[118]:=",ExpressionUUID->"fdf01f72-bda1-4a61-813f-b323a796b80a"]
}, Open  ]],

Cell[TextData[StyleBox["We undefine the objects used in this subsection. Note \
that whenever we wish to undefine a spinor (tensor) quantity with a tensor \
(spinor) counterpart we must erase first the latter, which is a visitor of \
the former.", "Text",
 FontWeight->"Plain"]], "MathCaption",
 TextJustification->1.,ExpressionUUID->"1e5feaaf-a3ec-4c49-b939-e792aa16a30e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefSpinor", "[", "\[CapitalPhi]", "]"}]], "Input",
 CellChangeTimes->{{3.425976799975485*^9, 3.4259768083876953`*^9}, {
  3.426795527350986*^9, 3.4267955286612377`*^9}},
 CellLabel->
  "In[119]:=",ExpressionUUID->"d74209be-76c9-4d09-a7ac-6f083237c368"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[CapitalPhi]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[CapitalPhi]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[119]:=",ExpressionUUID->"af64df70-bf9d-485f-872e-44ca915b93bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[CapitalPhi]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[CapitalPhi]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[119]:=",ExpressionUUID->"7ef48c53-5940-4436-8b99-f1ee74a7c0a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Undef", "/@", 
   RowBox[{"VisitorsOf", "@", "T"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.425976811229866*^9, 3.425976839646784*^9}, 
   3.42627473822832*^9},
 CellLabel->
  "In[120]:=",ExpressionUUID->"2f268ff2-ae2e-41b5-b468-c2c253751dbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ST\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`ST\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"23160f0b-a8f3-4f45-b606-523b5c326994"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ST"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`ST],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"3dee20af-e6cf-4476-af78-f9a2de96220c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Undef", "[", "T", "]"}]], "Input",
 CellChangeTimes->{{3.42597684887396*^9, 3.4259768542107477`*^9}, {
  3.4267955346463137`*^9, 3.4267955367124577`*^9}},
 CellLabel->
  "In[121]:=",ExpressionUUID->"77b7ced8-518b-4094-80d6-c6900e6e098b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "T\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[121]:=",ExpressionUUID->"3d84518b-2ed3-4ef0-9707-ca1add160b0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[121]:=",ExpressionUUID->"b513582a-953a-46d4-8cb1-0c7ee537ad12"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Undef", "/@", 
   RowBox[{"VisitorsOf", "@", "\[Kappa]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.425976870445168*^9, 3.425976883543598*^9}, 
   3.4262747491600246`*^9},
 CellLabel->
  "In[122]:=",ExpressionUUID->"6b4f7b52-cfa3-4e16-90a3-44e652a65a8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "KT\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`KT\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[122]:=",ExpressionUUID->"b5f788e8-6ead-4390-a0ab-c6a8016deeff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "KT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`KT],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[122]:=",ExpressionUUID->"2a5e2b20-778d-43d4-8f9f-b5c789d1061f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Undef", "[", "\[Kappa]", "]"}]], "Input",
 CellChangeTimes->{{3.425976886368922*^9, 3.4259768899075108`*^9}, {
  3.4267955413007097`*^9, 3.426795543862095*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"99451d2e-e656-4d1f-8eab-586d34a996e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[Kappa]\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[Kappa]\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[123]:=",ExpressionUUID->"6c81e4de-5596-46c4-8b66-395c5b70a0ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[Kappa]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[Kappa]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[123]:=",ExpressionUUID->"1765cb24-dd81-424a-819c-98f72759bc8d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. Products of soldering forms", "SubsubsectionIcon",ExpressionUUID->"cc74067d-2487-417e-a409-2d9ac99de3ea"],

Cell[TextData[{
 StyleBox["Contracted products of soldering forms appear in a natural way \
when transforming spinor expressions into tensor ones and back. Therefore it \
is important to be able to work with such products. In this subsection we \
show how ",
  FontWeight->"Plain"],
 StyleBox["Spinors`", "Output",
  FontWeight->"Plain"],
 StyleBox[" deals with such quantities.",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.42704824999963*^9, 3.4270483342689743`*^9}, {
   3.427048414670754*^9, 3.427048503267373*^9}, {3.42704858416602*^9, 
   3.4270485879375763`*^9}, 3.427048665567644*^9},
 TextJustification->1.,ExpressionUUID->"32ae4b6a-576f-41f6-ab2b-100211686ad0"],

Cell["\<\
The simplest case is the product of 2 soldering forms which gives rise to an \
auxiliary quantity which is needed when going from spinor expressions to \
tensor expressions.\
\>", "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
  3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
  3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
  3.423803287664819*^9, 3.4238033248885202`*^9}, {3.4238071601471043`*^9, 
  3.4238071768419743`*^9}, {3.423807232132647*^9, 3.423807286232327*^9}, {
  3.427048680016914*^9, 
  3.4270486889111032`*^9}},ExpressionUUID->"2fa634b8-43e6-4b84-88de-\
5c4af96635b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
   RowBox[{"\[Sigma]", "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "B"}], ",", "A\[Dagger]"}], "]"}]}], "//", 
  "ContractSolderingForm"}]], "Input",
 CellChangeTimes->{{3.423807304183983*^9, 3.423807348398188*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"dd10041d-f180-4b21-83c4-e489bdcbcaa6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[CapitalSigma]\[Sigma]", 
      StyleBox[GridBox[{
         {"a", "b", " ", " "},
         {" ", " ", "A", "B"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Sigma\[Sigma][$CellContext`a, $CellContext`b, -$CellContext`A, \
-$CellContext`B],
  Editable->False]], "Output",
 CellLabel->
  "Out[124]=",ExpressionUUID->"0dc6153d-63b8-4b02-8870-240983e72279"]
}, Open  ]],

Cell[TextData[{
 "The algebraic properties of  ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[CapitalSigma]\[Sigma]", 
     RowBox[{"  ", "AB"}], 
     RowBox[{"ab", "  "}]],
    AutoSpacing->False],
   $CellContext`Sigma\[Sigma][$CellContext`a, $CellContext`b, \
-$CellContext`A, -$CellContext`B],
   Editable->False]], "Output",
  CellChangeTimes->{{3.423807332457913*^9, 3.423807349028883*^9}, 
    3.424413503434722*^9, 3.424430312775785*^9, 3.4244369879927063`*^9, 
    3.424437533213141*^9, 3.424495181209428*^9, 3.424498247972381*^9, 
    3.424500729991308*^9, 3.4245089497738733`*^9, 3.4245108391697283`*^9, 
    3.424515591305625*^9, 3.424515991162468*^9, 3.424521109422051*^9, 
    3.424521228165186*^9, 3.424579482255805*^9, 3.42459535354397*^9, 
    3.424596535204871*^9, 3.424599106843363*^9, 3.424668076839469*^9, 
    3.424776228584858*^9, 3.42478097218967*^9, 3.424791880132147*^9, 
    3.424963733128112*^9, 3.42501746496142*^9, 3.425379197211711*^9, 
    3.425381733814398*^9, 3.425460124973112*^9, 3.425460882527132*^9, 
    3.425468578218762*^9, 3.425473705760754*^9, 3.425496986792183*^9, 
    3.4255508508828382`*^9, 3.4255793851560497`*^9, 3.425621719106542*^9, 
    3.4257077094185762`*^9, 3.425790242745607*^9, 3.425878991076784*^9, 
    3.4262747656154213`*^9, 3.426795555316658*^9, 3.426796828315444*^9, 
    3.4267970464063*^9, 3.426798566996687*^9, 3.42679869857265*^9, 
    3.426798822688547*^9, 3.426798877222987*^9, 3.4267989501137867`*^9, 
    3.426799128824698*^9, 3.4268005948189173`*^9, 3.427019517268364*^9, 
    3.42702461012038*^9},ExpressionUUID->
  "f00a77e0-323a-42a7-9129-864fb66d6c91"],
 " are stored as automatic rules."
}], "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
   3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
   3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
   3.423803287664819*^9, 3.4238033248885202`*^9}, {3.4238071601471043`*^9, 
   3.4238071768419743`*^9}, {3.423807232132647*^9, 3.423807286232327*^9}, {
   3.42380737535887*^9, 3.423807472289825*^9}, {3.4238075279701357`*^9, 
   3.423807551469267*^9}, {3.423808191954126*^9, 3.423808192521597*^9}, 
   3.4244303150106697`*^9, {3.427025947475355*^9, 3.4270259485692453`*^9}, {
   3.427031207810258*^9, 3.427031229377945*^9}, {3.427031275297689*^9, 
   3.427031378337268*^9}, {3.42703160108997*^9, 3.427031626882362*^9}, {
   3.427049286576015*^9, 
   3.427049297181466*^9}},ExpressionUUID->"1e174230-6049-4597-a049-\
ea2870179ceb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sigma", "[", "\[Sigma]", "]"}]], "Input",
 CellLabel->
  "In[125]:=",ExpressionUUID->"431baf04-a607-4957-822c-15095f195a1b"],

Cell[BoxData["Sigma\[Sigma]"], "Output",
 CellLabel->
  "Out[125]=",ExpressionUUID->"34c7b03a-3925-4237-89b5-650d5f2cab1b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Sigma\[Sigma]"}]], "Input",
 CellChangeTimes->{{3.4270247140904818`*^9, 3.4270247211192827`*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"ae103039-45df-4ef5-8e7b-fe60c2f6bcf9"],

Cell["Global`Sigma\[Sigma]", "Print", "PrintUsage",
 CellTags->
  "Info3587968228-4559134",ExpressionUUID->"2642fd49-aeb5-41bb-a6b4-\
1283e5f37524"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "Sigma\[Sigma]", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`Sigma\[Sigma]],
          Editable->False], "^:=", "Sigma\[Sigma]\[Dagger]"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "Sigma\[Sigma]", "]"}], "^:=", "False"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "Sigma\[Sigma]", "]"}], "^:=", 
         RowBox[{"{", "M4", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "Sigma\[Sigma]", "]"}], "^:=", 
         RowBox[{"{", 
          RowBox[{"M4", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M4",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM4,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MasterOf", "[", "Sigma\[Sigma]", "]"}], "^:=", "\[Sigma]"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "Sigma\[Sigma]", "]"}], 
         "^:=", "\<\"\[CapitalSigma]\[Sigma]\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ServantsOf", "[", "Sigma\[Sigma]", "]"}], "^:=", 
         RowBox[{"{", "Sigma\[Sigma]\[Dagger]", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "Sigma\[Sigma]", "]"}], "^:=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M4",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM4,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M4",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM4,
            Editable->False], ",", 
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["Spin",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Spin,
             Editable->False]}], ",", 
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["Spin",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Spin,
             Editable->False]}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "Sigma\[Sigma]", "]"}], "^:=", 
         
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", "1", "}"}], ",", 
           RowBox[{"GenSet", "[", 
            InterpretationBox[
             StyleBox[
              RowBox[{"-", 
               RowBox[{"(", "1", ",", "2", ")"}], 
               RowBox[{"(", "3", ",", "4", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             -xAct`xPerm`Cycles[{1, 2}, {3, 4}],
             Editable->False], "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "Sigma\[Sigma]", "]"}], "^:=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "Sigma\[Sigma]", "]"}], "^:=", "True"}]},
       {" "},
       {
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox[
                    UnderscriptBox["a", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["b", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["A", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["B", "_"], "_"]},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            PatternTest[
             Pattern[$CellContext`a, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`b, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`A, 
              Blank[]], Spin`pmQ], 
            PatternTest[
             Pattern[$CellContext`B, 
              Blank[Symbol]], Spin`Q]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox[
                    UnderscriptBox["c", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["d", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["C", "_"], "_"], " "},
                  {" ", " ", " ", 
                   UnderscriptBox[
                    UnderscriptBox["B", "_"], "_"]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            PatternTest[
             Pattern[$CellContext`c, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`d, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[C, 
              Blank[]], Spin`pmQ], -PatternTest[
              Pattern[$CellContext`B, 
               Blank[Symbol]], Spin`Q]],
           Editable->False]}], "^:=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", "s$8930", "}"}], ",", 
           RowBox[{
            RowBox[{"-", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"\[CapitalSigma]\[Sigma]", 
                  StyleBox[GridBox[{
                    {"s$8930", "c", "A", "C"},
                    {" ", " ", " ", " "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                   FontSize->9]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Center}}, "RowsIndexed" -> {}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Sigma\[Sigma][$CellContext`s$8930, $CellContext`c, \
$CellContext`A, C],
              Editable->False]}], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"Gg", 
                 StyleBox[GridBox[{
                    {"b", "d", " ", "a"},
                    {" ", " ", "s$8930", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Tetrag[$CellContext`b, $CellContext`d, \
-$CellContext`s$8930, $CellContext`a],
             Editable->False]}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox[
                    UnderscriptBox["d", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["c", "_"], "_"], " ", 
                   UnderscriptBox[
                    UnderscriptBox["C", "_"], "_"]},
                  {" ", " ", 
                   UnderscriptBox[
                    UnderscriptBox["B", "_"], "_"], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            PatternTest[
             Pattern[$CellContext`d, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`c, 
              Blank[]], TangentM4`pmQ], -PatternTest[
              Pattern[$CellContext`B, 
               Blank[Symbol]], Spin`Q], 
            PatternTest[
             Pattern[C, 
              Blank[]], Spin`pmQ]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox[
                    UnderscriptBox["a", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["b", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["A", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["B", "_"], "_"]},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            PatternTest[
             Pattern[$CellContext`a, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`b, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`A, 
              Blank[]], Spin`pmQ], 
            PatternTest[
             Pattern[$CellContext`B, 
              Blank[Symbol]], Spin`Q]],
           Editable->False]}], "^:=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", "s$8930", "}"}], ",", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"\[CapitalSigma]\[Sigma]", 
                 StyleBox[GridBox[{
                    {"s$8930", "c", "A", "C"},
                    {" ", " ", " ", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Sigma\[Sigma][$CellContext`s$8930, $CellContext`c, \
$CellContext`A, C],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"Gg", 
                 StyleBox[GridBox[{
                    {"b", "d", " ", "a"},
                    {" ", " ", "s$8930", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Tetrag[$CellContext`b, $CellContext`d, \
-$CellContext`s$8930, $CellContext`a],
             Editable->False]}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox[
                    UnderscriptBox["b", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["a", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["B", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["A", "_"], "_"]},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            PatternTest[
             Pattern[$CellContext`b, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`a, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`B, 
              Blank[Symbol]], Spin`Q], 
            PatternTest[
             Pattern[$CellContext`A, 
              Blank[]], Spin`pmQ]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox[
                    UnderscriptBox["c", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["d", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["C", "_"], "_"], " "},
                  {" ", " ", " ", 
                   UnderscriptBox[
                    UnderscriptBox["B", "_"], "_"]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            PatternTest[
             Pattern[$CellContext`c, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`d, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[C, 
              Blank[]], Spin`pmQ], -PatternTest[
              Pattern[$CellContext`B, 
               Blank[Symbol]], Spin`Q]],
           Editable->False]}], "^:=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", "s$8930", "}"}], ",", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"\[CapitalSigma]\[Sigma]", 
                 StyleBox[GridBox[{
                    {"s$8930", "c", "A", "C"},
                    {" ", " ", " ", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Sigma\[Sigma][$CellContext`s$8930, $CellContext`c, \
$CellContext`A, C],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"Gg", 
                 StyleBox[GridBox[{
                    {"b", "d", " ", "a"},
                    {" ", " ", "s$8930", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Tetrag[$CellContext`b, $CellContext`d, \
-$CellContext`s$8930, $CellContext`a],
             Editable->False]}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox[
                    UnderscriptBox["d", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["c", "_"], "_"], " ", 
                   UnderscriptBox[
                    UnderscriptBox["C", "_"], "_"]},
                  {" ", " ", 
                   UnderscriptBox[
                    UnderscriptBox["B", "_"], "_"], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            PatternTest[
             Pattern[$CellContext`d, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`c, 
              Blank[]], TangentM4`pmQ], -PatternTest[
              Pattern[$CellContext`B, 
               Blank[Symbol]], Spin`Q], 
            PatternTest[
             Pattern[C, 
              Blank[]], Spin`pmQ]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox[
                    UnderscriptBox["b", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["a", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["B", "_"], "_"], 
                   UnderscriptBox[
                    UnderscriptBox["A", "_"], "_"]},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            PatternTest[
             Pattern[$CellContext`b, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`a, 
              Blank[]], TangentM4`pmQ], 
            PatternTest[
             Pattern[$CellContext`B, 
              Blank[Symbol]], Spin`Q], 
            PatternTest[
             Pattern[$CellContext`A, 
              Blank[]], Spin`pmQ]],
           Editable->False]}], "^:=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", "s$8930", "}"}], ",", 
           RowBox[{
            RowBox[{"-", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"\[CapitalSigma]\[Sigma]", 
                  StyleBox[GridBox[{
                    {"s$8930", "c", "A", "C"},
                    {" ", " ", " ", " "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                   FontSize->9]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Center}}, "RowsIndexed" -> {}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Sigma\[Sigma][$CellContext`s$8930, $CellContext`c, \
$CellContext`A, C],
              Editable->False]}], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"Gg", 
                 StyleBox[GridBox[{
                    {"b", "d", " ", "a"},
                    {" ", " ", "s$8930", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Tetrag[$CellContext`b, $CellContext`d, \
-$CellContext`s$8930, $CellContext`a],
             Editable->False]}]}], "]"}]}]},
       {" "},
       {
        RowBox[{"Sigma\[Sigma]", "/:", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox["f", "_"], 
                   UnderscriptBox["h", "_"], 
                   UnderscriptBox["C", "_"], 
                   UnderscriptBox["D", "_"]},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            Pattern[$CellContext`f, 
             Blank[]], 
            Pattern[$CellContext`h, 
             Blank[]], 
            Pattern[C, 
             Blank[]], 
            Pattern[D, 
             Blank[]]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"Gg", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox["a", "_"], 
                   UnderscriptBox["b", "_"], 
                   UnderscriptBox["c", "_"], 
                   UnderscriptBox["d", "_"]},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Tetrag[
            Pattern[$CellContext`a, 
             Blank[]], 
            Pattern[$CellContext`b, 
             Blank[]], 
            Pattern[$CellContext`c, 
             Blank[]], 
            Pattern[$CellContext`d, 
             Blank[]]],
           Editable->False]}], ":=", 
         RowBox[{
          RowBox[{
           InterpretationBox[
            StyleBox[GridBox[{
               {"g", 
                StyleBox[GridBox[{
                   {"a", "b"},
                   {" ", " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`g[$CellContext`a, $CellContext`b],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Epsilon]", 
                StyleBox[GridBox[{
                   {"C", "D"},
                   {" ", " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Epsilon][C, D],
            Editable->False]}], "/;", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"PairQ", "[", 
              RowBox[{"c", ",", "f"}], "]"}], "&&", 
             RowBox[{"PairQ", "[", 
              RowBox[{"d", ",", "h"}], "]"}]}], ")"}], "||", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"PairQ", "[", 
              RowBox[{"c", ",", "h"}], "]"}], "&&", 
             RowBox[{"PairQ", "[", 
              RowBox[{"d", ",", "f"}], "]"}]}], ")"}]}]}]}]},
       {" "},
       {
        RowBox[{"Sigma\[Sigma]", "/:", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[CapitalSigma]\[Sigma]", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox["f", "_"], 
                   UnderscriptBox["h", "_"], 
                   UnderscriptBox["C", "_"], 
                   UnderscriptBox["D", "_"]},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Sigma\[Sigma][
            Pattern[$CellContext`f, 
             Blank[]], 
            Pattern[$CellContext`h, 
             Blank[]], 
            Pattern[C, 
             Blank[]], 
            Pattern[D, 
             Blank[]]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"Gg", 
               StyleBox[GridBox[{
                  {
                   UnderscriptBox["c", "_"], 
                   UnderscriptBox["d", "_"], 
                   UnderscriptBox["a", "_"], 
                   UnderscriptBox["b", "_"]},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Tetrag[
            Pattern[$CellContext`c, 
             Blank[]], 
            Pattern[$CellContext`d, 
             Blank[]], 
            Pattern[$CellContext`a, 
             Blank[]], 
            Pattern[$CellContext`b, 
             Blank[]]],
           Editable->False]}], ":=", 
         RowBox[{
          RowBox[{
           InterpretationBox[
            StyleBox[GridBox[{
               {"g", 
                StyleBox[GridBox[{
                   {"a", "b"},
                   {" ", " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`g[$CellContext`a, $CellContext`b],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Epsilon]", 
                StyleBox[GridBox[{
                   {"C", "D"},
                   {" ", " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Epsilon][C, D],
            Editable->False]}], "/;", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"PairQ", "[", 
              RowBox[{"c", ",", "f"}], "]"}], "&&", 
             RowBox[{"PairQ", "[", 
              RowBox[{"d", ",", "h"}], "]"}]}], ")"}], "||", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"PairQ", "[", 
              RowBox[{"c", ",", "h"}], "]"}], "&&", 
             RowBox[{"PairQ", "[", 
              RowBox[{"d", ",", "f"}], "]"}]}], ")"}]}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[CapitalSigma]\[Sigma]", 
              StyleBox[GridBox[{
                 {
                  UnderscriptBox["xAct`Spinors`Private`a$", "_"], 
                  UnderscriptBox["xAct`Spinors`Private`b$", "_"], 
                  UnderscriptBox["C$", "_"], " "},
                 {" ", " ", " ", 
                  UnderscriptBox["C$", "_"]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Sigma\[Sigma][
           Pattern[xAct`Spinors`Private`a$, 
            Blank[]], 
           Pattern[xAct`Spinors`Private`b$, 
            Blank[]], 
           Pattern[C$, 
            Blank[]], -Pattern[C$, 
             Blank[]]],
          Editable->False], ":=", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"g", 
               StyleBox[GridBox[{
                  {"xAct`Spinors`Private`a$", "xAct`Spinors`Private`b$"},
                  {" ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`g[xAct`Spinors`Private`a$, xAct`Spinors`Private`b$],
           Editable->False]}]}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[CapitalSigma]\[Sigma]", 
              StyleBox[GridBox[{
                 {
                  UnderscriptBox["xAct`Spinors`Private`a$", "_"], 
                  UnderscriptBox["xAct`Spinors`Private`b$", "_"], " ", 
                  UnderscriptBox["C$", "_"]},
                 {" ", " ", 
                  UnderscriptBox["C$", "_"], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Sigma\[Sigma][
           Pattern[xAct`Spinors`Private`a$, 
            Blank[]], 
           Pattern[xAct`Spinors`Private`b$, 
            Blank[]], -Pattern[C$, 
             Blank[]], 
           Pattern[C$, 
            Blank[]]],
          Editable->False], ":=", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"xAct`Spinors`Private`a$", "xAct`Spinors`Private`b$"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[xAct`Spinors`Private`a$, xAct`Spinors`Private`b$],
          Editable->False]}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[CapitalSigma]\[Sigma]", 
              StyleBox[GridBox[{
                 {
                  UnderscriptBox["xAct`Spinors`Private`a$", "_"], " ", 
                  UnderscriptBox["C$", "_"], 
                  UnderscriptBox["D$", "_"]},
                 {" ", 
                  UnderscriptBox["xAct`Spinors`Private`a$", "_"], " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Sigma\[Sigma][
           Pattern[xAct`Spinors`Private`a$, 
            Blank[]], -Pattern[xAct`Spinors`Private`a$, 
             Blank[]], 
           Pattern[C$, 
            Blank[]], 
           Pattern[D$, 
            Blank[]]],
          Editable->False], ":=", 
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Epsilon]", 
               StyleBox[GridBox[{
                  {"C$", "D$"},
                  {" ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Epsilon][C$, D$],
           Editable->False]}]}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[CapitalSigma]\[Sigma]", 
              StyleBox[GridBox[{
                 {" ", 
                  UnderscriptBox["xAct`Spinors`Private`a$", "_"], 
                  UnderscriptBox["C$", "_"], 
                  UnderscriptBox["D$", "_"]},
                 {
                  UnderscriptBox["xAct`Spinors`Private`a$", "_"], " ", " ", 
                  " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Sigma\[Sigma][-Pattern[xAct`Spinors`Private`a$, 
             Blank[]], 
           Pattern[xAct`Spinors`Private`a$, 
            Blank[]], 
           Pattern[C$, 
            Blank[]], 
           Pattern[D$, 
            Blank[]]],
          Editable->False], ":=", 
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Epsilon]", 
               StyleBox[GridBox[{
                  {"C$", "D$"},
                  {" ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Epsilon][C$, D$],
           Editable->False]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`Sigma\[Sigma]],
  Editable->False]], "Print",
 CellTags->
  "Info3587968228-4559134",ExpressionUUID->"3206cdc5-c6c4-43a0-afe3-\
bd9c6d2e47e9"]
}, Open  ]],

Cell[TextData[{
 "One of the previous properties is that the \"square\" of ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[CapitalSigma]\[Sigma]", 
     RowBox[{"  ", "AB"}], 
     RowBox[{"ab", "  "}]],
    AutoSpacing->False],
   $CellContext`Sigma\[Sigma][$CellContext`a, $CellContext`b, \
-$CellContext`A, -$CellContext`B],
   Editable->False]], "Output",
  CellChangeTimes->{{3.423807332457913*^9, 3.423807349028883*^9}, 
    3.424413503434722*^9, 3.424430312775785*^9, 3.4244369879927063`*^9, 
    3.424437533213141*^9, 3.424495181209428*^9, 3.424498247972381*^9, 
    3.424500729991308*^9, 3.4245089497738733`*^9, 3.4245108391697283`*^9, 
    3.424515591305625*^9, 3.424515991162468*^9, 3.424521109422051*^9, 
    3.424521228165186*^9, 3.424579482255805*^9, 3.42459535354397*^9, 
    3.424596535204871*^9, 3.424599106843363*^9, 3.424668076839469*^9, 
    3.424776228584858*^9, 3.42478097218967*^9, 3.424791880132147*^9, 
    3.424963733128112*^9, 3.42501746496142*^9, 3.425379197211711*^9, 
    3.425381733814398*^9, 3.425460124973112*^9, 3.425460882527132*^9, 
    3.425468578218762*^9, 3.425473705760754*^9, 3.425496986792183*^9, 
    3.4255508508828382`*^9, 3.4255793851560497`*^9, 3.425621719106542*^9, 
    3.4257077094185762`*^9, 3.425790242745607*^9, 3.425878991076784*^9, 
    3.4262747656154213`*^9, 3.426795555316658*^9, 3.426796828315444*^9, 
    3.4267970464063*^9, 3.426798566996687*^9, 3.42679869857265*^9, 
    3.426798822688547*^9, 3.426798877222987*^9, 3.4267989501137867`*^9, 
    3.426799128824698*^9, 3.4268005948189173`*^9, 3.427019517268364*^9, 
    3.42702461012038*^9},ExpressionUUID->
  "27b48134-14a1-4b6f-86f4-218368abdb83"],
 " gives rise to the \"tetra-metric\".  The latter is a four rank spacetime \
tensor which is defined in eq. (3.4.57) of vol. 1 of Penrose & Rindler (note \
that they use the name ",
 StyleBox["U", "Output"],
 " for it, and that it has a different index configuration: \
U[a,b,c,d]==Tetra[a,d,b,c]). "
}], "MathCaption",
 TextJustification->1.,ExpressionUUID->"485cb605-72f7-4574-8876-25944e9b8faa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sigma\[Sigma]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], 
   RowBox[{"Sigma\[Sigma]", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}], ",", "A", ",", "B"}], "]"}]}], "//", 
  "InputForm"}]], "Input",
 CellChangeTimes->{{3.427031115981347*^9, 3.427031138002*^9}, {
  3.4270494051920977`*^9, 3.4270494078557377`*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"44b88f63-4a77-4fd6-bc8c-e7e22e752c7c"],

Cell["Tetrag[-d, -b, -a, -c]", "Output",
 CellLabel->
  "Out[127]//InputForm=",ExpressionUUID->"5b50ddf2-11fe-4646-ad1a-\
620980b64c20"]
}, Open  ]],

Cell["This is the explicit definition of the tetra-metric:", "MathCaption",
 TextJustification->1.,ExpressionUUID->"05c34047-b3ce-4875-81f4-69b19d2b453b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Tetrag", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}]}], "]"}], "/.", 
  RowBox[{"TetraRule", "[", "g", "]"}]}]], "Input",
 CellChangeTimes->{{3.42704895522583*^9, 3.42704900254813*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"e803558e-d3ab-4f3c-bea6-4176817d5fe3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]g", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`c, -$CellContext`d],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[128]=",ExpressionUUID->"6f122cb3-7f06-4e9d-a327-5e9c70bdbed7"]
}, Open  ]],

Cell["\<\
As we can see the tetra-metric only depends on spacetime quantities. \
Therefore the tetra-metric is always automatically defined whenever a \
Lorentzian four dimensional metric is introduced regardless to whether a spin \
structure has been defined. Also automatic rules implementing the algebraic \
properties of the tetra-metric are stored.\
\>", "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
   3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
   3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
   3.423803287664819*^9, 3.4238033248885202`*^9}, {3.4238071601471043`*^9, 
   3.4238071768419743`*^9}, {3.423807232132647*^9, 3.423807286232327*^9}, {
   3.42380737535887*^9, 3.423807472289825*^9}, {3.4238075279701357`*^9, 
   3.423807551469267*^9}, {3.423808191954126*^9, 3.423808192521597*^9}, 
   3.4244303150106697`*^9, {3.427025947475355*^9, 3.4270259485692453`*^9}, {
   3.427031207810258*^9, 3.427031229377945*^9}, {3.427031275297689*^9, 
   3.427031378337268*^9}, {3.427048707790669*^9, 3.4270487767507553`*^9}, {
   3.427048810464593*^9, 3.427048877807991*^9}, {3.4270494255584393`*^9, 
   3.427049456602113*^9}, {3.427049541991062*^9, 3.4270495655195217`*^9}},
 TextJustification->1.,ExpressionUUID->"9543d8f1-f891-4ef8-b0cc-1fe917fafe61"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Tetrag"}]], "Input",
 CellChangeTimes->{{3.427048884465642*^9, 3.42704889903224*^9}, {
  3.4270870842877913`*^9, 3.4270870853266077`*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"3be99fa7-d290-4418-b3e2-c5c14308bc52"],

Cell["Global`Tetrag", "Print", "PrintUsage",
 CellTags->
  "Info3587968229-4559134",ExpressionUUID->"b53c70f4-d8ce-43c1-b524-\
73f7b9bfaddc"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "Tetrag", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`Tetrag],
          Editable->False], "^=", "Tetrag\[Dagger]"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "Tetrag", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tetrametric\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "Tetrag", "]"}], "^=", 
         RowBox[{"{", "M4", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "Tetrag", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"M4", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M4",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM4,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MasterOf", "[", "Tetrag", "]"}], "^=", "g"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "Tetrag", "]"}], "^=", "\<\"Gg\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ServantsOf", "[", "Tetrag", "]"}], "^=", 
         RowBox[{"{", "Tetrag\[Dagger]", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "Tetrag", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]M4",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentM4,
             Editable->False]}], ",", 
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]M4",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentM4,
             Editable->False]}], ",", 
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]M4",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentM4,
             Editable->False]}], ",", 
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]M4",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentM4,
             Editable->False]}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "Tetrag", "]"}], "^=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
           RowBox[{"GenSet", "[", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{
                RowBox[{"(", "1", ",", "2", ")"}], 
                RowBox[{"(", "3", ",", "4", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              xAct`xPerm`Cycles[{1, 2}, {3, 4}],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox[
               RowBox[{
                RowBox[{"(", "1", ",", "3", ")"}], 
                RowBox[{"(", "2", ",", "4", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              xAct`xPerm`Cycles[{1, 3}, {2, 4}],
              Editable->False]}], "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "Tetrag", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "Tetrag", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`Tetrag],
  Editable->False]], "Print",
 CellTags->
  "Info3587968229-4559134",ExpressionUUID->"70eff874-72f4-4ff4-bc03-\
a5623f6d7456"]
}, Open  ]],

Cell["\<\
A typical problem is the computation of a product of soldering forms with no \
free spinor indices. These always give rise to contracted products of tetra \
metrics. Let us see some examples.\
\>", "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
  3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
  3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
  3.423803287664819*^9, 3.4238033248885202`*^9}, {3.42380759445795*^9, 
  3.4238076487304707`*^9}, {3.423807740808672*^9, 
  3.4238077784249773`*^9}},ExpressionUUID->"2030c47b-a245-4647-bad4-\
6ab3cf514fea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B\[Dagger]"}]}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"b", ",", "C", ",", "B\[Dagger]"}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"c", ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D\[Dagger]"}]}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"d", ",", "A", ",", "D\[Dagger]"}], "]"}]}]], "Input",
 CellLabel->
  "In[130]:=",ExpressionUUID->"967780ca-34b8-477a-892d-1ecfa07fd5e6"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", "C", 
           RowBox[{"B", "'"}]},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, C, $CellContext`B\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`D\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", "A", 
           RowBox[{"D", "'"}]},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, $CellContext`A, $CellContext`D\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[130]=",ExpressionUUID->"262962dc-3334-4c79-bfde-f06b302c5342"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "ContractSolderingForm"}], "//", 
  "ContractMetric"}]], "Input",
 CellChangeTimes->{{3.4238077234469976`*^9, 3.423807728204278*^9}, {
  3.4238078264310226`*^9, 3.4238078312469788`*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"c23a9266-90db-4bad-82d1-31e09e4f0b84"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"Gg", 
      StyleBox[GridBox[{
         {"d", "a", "b", "c"},
         {" ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Tetrag[$CellContext`d, $CellContext`a, $CellContext`b, \
$CellContext`c],
  Editable->False]], "Output",
 CellLabel->
  "Out[131]=",ExpressionUUID->"8d22fd49-3660-4a6f-85dc-d5a52ed7ad96"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B\[Dagger]"}]}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"b", ",", "C", ",", "B\[Dagger]"}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"c", ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D\[Dagger]"}]}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"d", ",", "P", ",", "D\[Dagger]"}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"f", ",", 
    RowBox[{"-", "P"}], ",", 
    RowBox[{"-", "Q\[Dagger]"}]}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"p", ",", "A", ",", "Q\[Dagger]"}], "]"}]}]], "Input",
 CellLabel->
  "In[132]:=",ExpressionUUID->"01a10fbc-9a50-423a-9713-d4def8471f21"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", "C", 
           RowBox[{"B", "'"}]},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, C, $CellContext`B\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`D\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", "P", 
           RowBox[{"D", "'"}]},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, $CellContext`P, $CellContext`D\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"f", " ", " "},
          {" ", "P", 
           RowBox[{"Q", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`f, -$CellContext`P, -$CellContext`Q\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"p", "A", 
           RowBox[{"Q", "'"}]},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`p, $CellContext`A, $CellContext`Q\
\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[132]=",ExpressionUUID->"069c70b5-1892-4f74-962b-a703121966b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "ContractSolderingForm"}], "//", 
  "ContractMetric"}]], "Input",
 CellLabel->
  "In[133]:=",ExpressionUUID->"1e1c1b61-7b23-4afc-86e8-6ec81b66a93b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"Gg", 
       StyleBox[GridBox[{
          {"b", "c", " ", "a"},
          {" ", " ", "h", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Tetrag[$CellContext`b, $CellContext`c, -$CellContext`h, \
$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"Gg", 
       StyleBox[GridBox[{
          {"d", "f", "p", "h"},
          {" ", " ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Tetrag[$CellContext`d, $CellContext`f, $CellContext`p, \
$CellContext`h],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[133]=",ExpressionUUID->"bd1bfda8-42eb-40c4-8dc6-9b5a7adbfb42"]
}, Open  ]],

Cell["\<\
Expressions of the sort just found are frequent in computations involving the \
transformation of spinor expressions into tensor ones. Let us see an example\
\>", "Text",
 FontWeight->"Plain",ExpressionUUID->"a09c35f8-6bc0-4164-bd38-49f6469160db"],

Cell["\<\
Transformation of the Weyl tensor into its spinor counterpart\
\>", "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
  3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
  3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
  3.423803287664819*^9, 
  3.4238033248885202`*^9}},ExpressionUUID->"c7803353-a079-4a30-8c0b-\
a811d865ef0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"weyl", "=", 
  RowBox[{"WeylCD", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.423377812139955*^9, 3.4233778517424383`*^9}, {
   3.4253795461192303`*^9, 3.425379553389907*^9}, {3.426795575146862*^9, 
   3.426795575799021*^9}, 3.426795795102214*^9, {3.4267960336696463`*^9, 
   3.4267960406508923`*^9}},
 CellLabel->
  "In[134]:=",ExpressionUUID->"0cd6fd48-e260-4222-9480-a06c26e68fcd"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->
  "Out[134]=",ExpressionUUID->"a6edaf62-7962-45c8-8298-38bdd9d680bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.426795799692713*^9, 3.42679581074545*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"4460239c-63d2-43a5-b92e-cdbf73abea72"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"SW", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " ", " ", " ", " ", " "},
          {"A", 
           RowBox[{"A", "'"}], "B", 
           RowBox[{"B", "'"}], "C", 
           RowBox[{"C", "'"}], "D", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SP\[UnderBracket]WeylCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", 
           RowBox[{"B", "'"}]},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "C", 
           RowBox[{"C", "'"}]},
          {"c", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "D", 
           RowBox[{"D", "'"}]},
          {"d", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`d, D, $CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[135]=",ExpressionUUID->"d12db2f5-6f27-4446-a7a2-ccbaf9244c93"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", 
  RowBox[{"%", ",", "Weyl"}], "]"}]], "Input",
 CellChangeTimes->{{3.4233778607846327`*^9, 3.423377867853755*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"45694c45-1685-4e8d-bcf3-a2f0aebe0623"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
            "\[Dagger]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {
               RowBox[{"A", "'"}], 
               RowBox[{"B", "'"}], 
               RowBox[{"D", "'"}], 
               RowBox[{"C", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`D\[Dagger], -$CellContext`C\[Dagger]],
       Editable->False]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A", "B"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"D", "C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-D, -C],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"A", "B", "D", "C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -D, -C],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Epsilon]", "__"], 
          StyleBox[GridBox[{
             {" ", " "},
             {
              RowBox[{"A", "'"}], 
              RowBox[{"B", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Epsilon]", "__"], 
          StyleBox[GridBox[{
             {" ", " "},
             {
              RowBox[{"D", "'"}], 
              RowBox[{"C", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
      Editable->False]}]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", 
           RowBox[{"B", "'"}]},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "C", 
           RowBox[{"C", "'"}]},
          {"c", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "D", 
           RowBox[{"D", "'"}]},
          {"d", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`d, D, $CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[136]=",ExpressionUUID->"0efd7df7-a026-48b2-a1a1-74afccdce314"]
}, Open  ]],

Cell["\<\
This spinor expression can be transformed back into the Weyl tensor\
\>", "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
  3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
  3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
  3.423803287664819*^9, 3.4238033248885202`*^9}, {3.423803579233574*^9, 
  3.423803600061902*^9}},ExpressionUUID->"77960ecb-9f51-4cac-be3b-\
93d74fd314c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"weyl", "==", 
  RowBox[{"ToCanonical", "[", 
   RowBox[{"ContractMetric", "[", "%", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.423803644290246*^9, 3.423803652767372*^9}, {
  3.426795853743287*^9, 3.426795863180438*^9}, {3.426795944280658*^9, 
  3.426795970015768*^9}, {3.426796047177511*^9, 3.426796050160164*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"5d3fd2ab-888b-4dbb-a955-faa37cb87945"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          "\[Dagger]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"B", "'"}], 
             RowBox[{"C", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", "A", 
             RowBox[{"A", "'"}]},
            {"a", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", " ", 
             RowBox[{"B", "'"}]},
            {"b", "A", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`b, -$CellContext`A, $CellContext`B\
\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", "B", 
             RowBox[{"C", "'"}]},
            {"c", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`c, $CellContext`B, $CellContext`C\
\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", " ", 
             RowBox[{"D", "'"}]},
            {"d", "B", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`d, -$CellContext`B, $CellContext`D\
\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A", "B", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", "A", 
             RowBox[{"A", "'"}]},
            {"a", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", "B", " "},
            {"b", " ", 
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, -$CellContext`A\
\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", "C", 
             RowBox[{"B", "'"}]},
            {"c", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", "D", " "},
            {"d", " ", 
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`d, D, -$CellContext`B\[Dagger]],
     Editable->False]}]}]}]], "Output",
 CellLabel->
  "Out[137]=",ExpressionUUID->"9d9627d9-04c4-4c0e-b7a8-c1587094a8a6"]
}, Open  ]],

Cell[TextData[{
 "We use this expression to write the Weyl spinor ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], "ABCD", 
     "    "],
    AutoSpacing->False],
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False]], "Output",
  CellChangeTimes->{3.4238036534985313`*^9},ExpressionUUID->
  "b91dfd3e-d8d9-4639-be00-31f57bf66ac9"],
 " in terms of the Weyl tensor ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     RowBox[{"W", "[", "\[Del]", "]"}], "abcd", "    "],
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False]], "Output",
  CellChangeTimes->{3.4238036534985313`*^9},ExpressionUUID->
  "b1fd9d67-6e3d-425a-8d16-5bacf1c39c1f"],
 "."
}], "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
  3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
  3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
  3.423803287664819*^9, 3.4238033248885202`*^9}, {3.423803579233574*^9, 
  3.423803600061902*^9}, {3.423803677933648*^9, 
  3.4238037165531054`*^9}},ExpressionUUID->"0b574a88-197e-4d1a-90b0-\
ce34be075ccb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "/@", 
  RowBox[{"PutSolderingForm", "/@", "%"}]}]], "Input",
 CellChangeTimes->{
  3.423803731606065*^9, {3.4267960551744328`*^9, 3.426796068889069*^9}},
 CellLabel->
  "In[138]:=",ExpressionUUID->"edc2ec53-74c4-4c1e-aba9-243de90f0013"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "A", 
            RowBox[{"A", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "B", 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"c", " ", " "},
           {" ", "C", 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"d", " ", " "},
           {" ", "D", 
            RowBox[{"D", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`D\[Dagger]],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          "\[Dagger]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"B", "'"}], 
             RowBox[{"C", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -C],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A", "B", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "__"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"B", "'"}], 
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "__"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"D", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
     Editable->False]}]}]}]], "Output",
 CellLabel->
  "Out[138]=",ExpressionUUID->"465f7c13-2353-4661-a779-be191a9d3cb3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{
    RowBox[{"-", "B\[Dagger]"}], "->", "A\[Dagger]"}]}], "/.", 
  RowBox[{
   RowBox[{"-", "D\[Dagger]"}], "->", "C\[Dagger]"}]}]], "Input",
 CellChangeTimes->{{3.4238037377863092`*^9, 3.423803753561318*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"b326dc47-cf33-44c7-84fa-bbd030be9d57"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "A", 
            RowBox[{"A", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", 
            RowBox[{"A", "'"}]},
           {" ", "B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"c", " ", " "},
           {" ", "C", 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"d", " ", 
            RowBox[{"C", "'"}]},
           {" ", "D", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`d, -D, $CellContext`C\[Dagger]],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A", "B", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          "\[Dagger]"}], 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"A", "'"}], " ", 
             RowBox[{"C", "'"}]},
            {
             RowBox[{"A", "'"}], " ", 
             RowBox[{"C", "'"}], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], $CellContext`A\
\[Dagger], -$CellContext`C\[Dagger], $CellContext`C\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -C],
     Editable->False]}]}]}]], "Output",
 CellLabel->
  "Out[139]=",ExpressionUUID->"2ea8199d-d40f-47a4-9777-4c0f31f6ae0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "/@", "%"}]], "Input",
 CellChangeTimes->{3.423803765017593*^9},
 CellLabel->
  "In[140]:=",ExpressionUUID->"75b997b4-3e8e-469e-8775-155c9ad6f969"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", 
            RowBox[{"A", "'"}]},
           {" ", "A", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "B", 
            RowBox[{"A", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"c", " ", 
            RowBox[{"C", "'"}]},
           {" ", "C", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`c, -C, $CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"d", " ", " "},
           {" ", "D", 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`C\[Dagger]],
    Editable->False]}], "\[Equal]", 
  RowBox[{"4", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[140]=",ExpressionUUID->"a51ffaa8-7bdb-4c01-9f8c-828a8a8655d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeylSpinorToWeylTensor", "=", 
  RowBox[{"IndexSolve", "[", 
   RowBox[{"%", ",", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], "ABCD", 
       "    "],
      AutoSpacing->False],
     $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
     Editable->False]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.423803786798452*^9, 3.423803822094782*^9}, {
  3.423803885648774*^9, 3.423803896841852*^9}, {3.423804159010627*^9, 
  3.423804164400165*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"6a7cb2d9-6a2b-4595-aac8-5e2142211894"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["A", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["B", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["C", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["D", "_"], "_"]},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe[
      PatternTest[
       Pattern[$CellContext`A, 
        Blank[]], Spin`pmQ], 
      PatternTest[
       Pattern[$CellContext`B, 
        Blank[]], Spin`pmQ], 
      PatternTest[
       Pattern[C, 
        Blank[]], Spin`pmQ], 
      PatternTest[
       Pattern[D, 
        Blank[]], Spin`pmQ]],
     Editable->False], "]"}], "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "A\[Dagger]", ",", "b", ",", "c", ",", "B\[Dagger]", ",", 
       "d"}], "}"}], ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {"a", "b", "c", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {"a", "A", 
               RowBox[{"A", "'"}]},
              {" ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {"b", "B", " "},
              {" ", " ", 
               RowBox[{"A", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][$CellContext`b, $CellContext`B, -$CellContext`A\
\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {"c", "C", 
               RowBox[{"B", "'"}]},
              {" ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][$CellContext`c, C, $CellContext`B\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {"d", "D", " "},
              {" ", " ", 
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][$CellContext`d, D, -$CellContext`B\[Dagger]],
       Editable->False]}]}], "]"}]}], "}"}]], "Output",
 CellLabel->
  "Out[141]=",ExpressionUUID->"c792c223-4206-4de2-b1fb-1b237866343a"]
}, Open  ]],

Cell["\<\
Now we can use previous rule to find the tensor expression of any invariant \
written in terms of the Weyl spinor. For example consider\
\>", "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
  3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
  3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
  3.423803287664819*^9, 3.4238033248885202`*^9}, {3.423803579233574*^9, 
  3.423803600061902*^9}, {3.423803677933648*^9, 3.4238037165531054`*^9}, {
  3.4238039262188396`*^9, 3.4238039442332077`*^9}, {3.4238040621032*^9, 
  3.423804117905795*^9}},ExpressionUUID->"16357e1b-39ff-45b4-a81f-\
aad0bcc6a35b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"PsiCDe", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "C"}], ",", 
      RowBox[{"-", "D"}]}], "]"}], 
    RowBox[{"PsiCDe", "[", 
     RowBox[{"A", ",", "B", ",", "C", ",", "D"}], "]"}]}], "/.", 
   "WeylSpinorToWeylTensor"}]}]], "Input",
 CellLabel->
  "In[142]:=",ExpressionUUID->"96e6d378-1e38-4183-b2d7-a24ae3f5fedd"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "c", "f", "j"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`c, -$CellContext`f, \
-$CellContext`j],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"b", "d", "h", "l"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`b, -$CellContext`d, -$CellContext`h, \
-$CellContext`l],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", 
           RowBox[{"A", "'"}]},
          {" ", "A", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", "A", 
           RowBox[{"B", "'"}]},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, $CellContext`A, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "B", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -$CellContext`B, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", "B", " "},
          {" ", " ", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, $CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"f", " ", 
           RowBox[{"C", "'"}]},
          {" ", "C", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`f, -C, $CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"h", "C", 
           RowBox[{"D", "'"}]},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`h, C, $CellContext`D\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"j", " ", " "},
          {" ", "D", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`j, -D, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"l", "D", " "},
          {" ", " ", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`l, D, -$CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[142]=",ExpressionUUID->"ff72a67f-4a32-4eba-b31f-3e420891fd21"]
}, Open  ]],

Cell[TextData[{
 "A direct use of",
 StyleBox[" ", "Text",
  FontWeight->"Plain"],
 StyleBox["ContractSolderingForm", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["would contract the soldering forms with the Weyl tensor, yielding \
an undesired result:", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
  3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
  3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
  3.423803287664819*^9, 3.4238033248885202`*^9}, {3.423803579233574*^9, 
  3.423803600061902*^9}, {3.423803677933648*^9, 3.4238037165531054`*^9}, {
  3.4238039262188396`*^9, 3.4238039442332077`*^9}, {3.4238040621032*^9, 
  3.423804117905795*^9}, {3.423805621587295*^9, 3.423805681283782*^9}, {
  3.423806204265271*^9, 3.423806240928957*^9}, {3.423806322015538*^9, 
  3.42380639664952*^9}, {3.427201088264461*^9, 3.427201100267846*^9}, {
  3.4272038644441833`*^9, 
  3.427203882252337*^9}},ExpressionUUID->"75170ada-fc0d-43e9-a52d-\
784d2a0181be"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.423806418090362*^9, 3.423806422287922*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"83ecf2cb-6106-4ef7-b02c-8c02b24714dc"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"SW", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", 
           RowBox[{"A", "'"}], " ", " ", " ", 
           RowBox[{"C", "'"}], " ", " "},
          {"A", " ", "B", 
           RowBox[{"A", "'"}], "C", " ", "D", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SP\[UnderBracket]WeylCD[-$CellContext`A, $CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`A\[Dagger], -
    C, $CellContext`C\[Dagger], -D, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"SW", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {"A", 
           RowBox[{"B", "'"}], "B", " ", "C", 
           RowBox[{"D", "'"}], "D", " "},
          {" ", " ", " ", 
           RowBox[{"B", "'"}], " ", " ", " ", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SP\[UnderBracket]WeylCD[$CellContext`A, $CellContext`B\
\[Dagger], $CellContext`B, -$CellContext`B\[Dagger], 
    C, $CellContext`D\[Dagger], D, -$CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[143]=",ExpressionUUID->"b70ba624-6a10-43e2-957b-d1e7b2bd9777"]
}, Open  ]],

Cell["\<\
Instead we specify contraction of the indices on the soldering form which are \
dummies, generating a product of \"tetra-metrics\".\
\>", "MathCaption",
 CellChangeTimes->{{3.427203931158626*^9, 3.4272039551047487`*^9}, {
  3.4272040137541113`*^9, 3.427204014310869*^9}, {3.4272041023521957`*^9, 
  3.4272041171617813`*^9}},
 FontWeight->"Plain",ExpressionUUID->"733fc633-7c28-4479-be7e-52915b029aed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", 
  RowBox[{"expr", ",", 
   RowBox[{
    RowBox[{"IndicesOf", "[", "Dummy", "]"}], "[", "expr", "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.427203891357258*^9, 3.427203923126768*^9}, {
  3.4272040303233643`*^9, 3.427204040025522*^9}, {3.427204092005843*^9, 
  3.427204094067621*^9}, {3.427439787809957*^9, 3.427439791704444*^9}, {
  3.427440137256942*^9, 3.4274401423812647`*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"df852b4f-32ba-4239-acd1-76b138052889"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"m", "c"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`m, $CellContext`c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"n", "j"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`n, $CellContext`j],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"Gg", 
       StyleBox[GridBox[{
          {"b", "a", " ", "d"},
          {" ", " ", "m", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Tetrag[$CellContext`b, $CellContext`a, -$CellContext`m, \
$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"Gg", 
       StyleBox[GridBox[{
          {"h", "f", " ", "l"},
          {" ", " ", "n", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Tetrag[$CellContext`h, $CellContext`f, -$CellContext`n, \
$CellContext`l],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "c", "f", "j"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`c, -$CellContext`f, \
-$CellContext`j],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"b", "d", "h", "l"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`b, -$CellContext`d, -$CellContext`h, \
-$CellContext`l],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[144]=",ExpressionUUID->"7b39bc4a-10af-4fc3-9794-3e5131bbbcb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.4238053014955807`*^9, 3.4238053118387012`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"572c9be9-218d-4aad-836c-fb9485f048cb"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"Gg", 
       StyleBox[GridBox[{
          {"a", "b", "c", "d"},
          {" ", " ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Tetrag[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"Gg", 
       StyleBox[GridBox[{
          {"f", "h", "j", "l"},
          {" ", " ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Tetrag[$CellContext`f, $CellContext`h, $CellContext`j, \
$CellContext`l],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "d", "f", "l"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`d, -$CellContext`f, \
-$CellContext`l],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"b", "c", "h", "j"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`b, -$CellContext`c, -$CellContext`h, \
-$CellContext`j],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[145]=",ExpressionUUID->"0d667ca6-2624-42ab-9040-419281cea5ef"]
}, Open  ]],

Cell["\<\
Finally we expand the tetra-metrics into ordinary metrics and volume \
elements. The simplification of the resulting expression provides the final \
answer. \
\>", "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
   3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
   3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
   3.423803287664819*^9, 3.4238033248885202`*^9}, {3.423803579233574*^9, 
   3.423803600061902*^9}, {3.423803677933648*^9, 3.4238037165531054`*^9}, {
   3.4238039262188396`*^9, 3.4238039442332077`*^9}, {3.4238040621032*^9, 
   3.423804117905795*^9}, {3.423805621587295*^9, 3.423805730566597*^9}, {
   3.4238060193901157`*^9, 3.4238061833184843`*^9}, 
   3.423808372626258*^9},ExpressionUUID->"81d85eaa-bdfa-42ce-9a69-\
da68a9b18836"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"TetraRule", "[", "g", "]"}]}]], "Input",
 CellChangeTimes->{{3.423805365477293*^9, 3.423805400232662*^9}, {
  3.42744026390875*^9, 3.427440264562801*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"972d1633-1dd5-4d3b-903f-ec8b189eb38f"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]g", 
          StyleBox[GridBox[{
             {"a", "b", "c", "d"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`epsilong[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "d"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`a, $CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`c],
      Editable->False]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`a, $CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "d"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`d],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`a, $CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"c", "d"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`c, $CellContext`d],
      Editable->False]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]g", 
          StyleBox[GridBox[{
             {"f", "h", "j", "l"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`epsilong[$CellContext`f, $CellContext`h, $CellContext`j, \
$CellContext`l],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"f", "l"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`f, $CellContext`l],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"h", "j"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`h, $CellContext`j],
      Editable->False]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"f", "j"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`f, $CellContext`j],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"h", "l"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`h, $CellContext`l],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"f", "h"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`f, $CellContext`h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"j", "l"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`j, $CellContext`l],
      Editable->False]}]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "d", "f", "l"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`d, -$CellContext`f, \
-$CellContext`l],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"b", "c", "h", "j"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`b, -$CellContext`c, -$CellContext`h, \
-$CellContext`j],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[146]=",ExpressionUUID->"0bfdd6ed-b76a-40ae-9c51-255569aa758c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.423805405794909*^9, 3.423805413491289*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"1007ca5d-a939-4992-8bcb-5e92bd1ae1f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "8"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", "b", "c", "d"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "16"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]g", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "d", "f", "h"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilong[-$CellContext`c, -$CellContext`d, -$CellContext`f, \
-$CellContext`h],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "f", "h"},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, $CellContext`f, \
$CellContext`h],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", "b", "c", "d"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[147]=",ExpressionUUID->"ec1835ac-826d-44cd-88d7-b1a5bbe436ab"]
}, Open  ]],

Cell["Clean up :", "MathCaption",
 CellChangeTimes->{{3.427201119392927*^9, 
  3.427201121688209*^9}},ExpressionUUID->"500062dc-bee9-40e7-8f75-\
dedec7d9f664"],

Cell[BoxData[
 RowBox[{"Remove", "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.4272011227787657`*^9, 3.427201124821005*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"659ffe52-f924-4b0b-9184-9c564b8ada6a"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["4. Decomposition of a spinor into irreducible parts", "SubsectionIcon",
 CellChangeTimes->{{3.433137295386077*^9, 3.433137317075715*^9}, {
  3.433175795071856*^9, 3.433175797760632*^9}, {3.4339376606526527`*^9, 
  3.433937660818185*^9}},ExpressionUUID->"d83e8954-2e1b-4896-8ca1-\
1d0a5599752b"],

Cell[TextData[{
 StyleBox["A classical result of the spinor algebra is the posibility of \
decomposing any spinor into a sum which consists of a totally symmetric \
spinor of the same rank as the given spinor plus other terms which are outer \
products of the antisymmetric metric with totally symmetric spinors of lower \
rank (see proposition 3.3.54 of Penrose & Rindler vol. I for full details). \
In ",
  FontWeight->"Plain"],
 StyleBox["Spinors`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 StyleBox[" there is an automated procedure to find such a decomposition as \
we explain below.",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.458279063152042*^9, 3.458279069936096*^9}},
 TextJustification->1.,ExpressionUUID->"64da2d61-96d7-4ed4-bf1e-922e7e76fbd7"],

Cell[TextData[{
 StyleBox["IrreducibleDecomposition                     ", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[" Finds the decomposition of any spinor into irreducible parts", 
  "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}], "FramedBox",
 CellChangeTimes->{{3.433137807374275*^9, 3.433137859049822*^9}, {
  3.43313791968937*^9, 3.433137992521351*^9}, {3.434375827373789*^9, 
  3.434375832873658*^9}},ExpressionUUID->"8933ff35-2633-4cd1-8c09-\
c2c31dabb0c4"],

Cell[TextData[{
 "We show how ",
 StyleBox["IrreducibleDecomposition",
  FontFamily->"Courier"],
 " works by means of some simple examples. Let us start by defining a spinor"
}], "MathCaption",
 CellChangeTimes->{{3.433138004717531*^9, 3.433138056006613*^9}, 
   3.434375866348021*^9},ExpressionUUID->"a9180a01-614b-4883-a789-\
47bbe5cbfe0f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"Kh", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "B"}]}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "C"}], ",", 
        RowBox[{"-", "D"}]}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<K\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.433138059823163*^9, 3.433138077334042*^9}, {
  3.4331381194676657`*^9, 3.433138120528975*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"ed6c2a81-e23f-48f1-b18b-0951b5f2781a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Kh", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Kh[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[149]:=",ExpressionUUID->"502c767e-7076-456a-b963-e1018666f112"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Kh\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Kh\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[149]:=",ExpressionUUID->"505b0db1-c917-474e-8e74-c89e59d950f1"]
}, Open  ]],

Cell["\<\
The decomposition of the spinor just introduced into irreducible parts is \
given by\
\>", "MathCaption",
 CellChangeTimes->{{3.433138004717531*^9, 3.433138056006613*^9}, {
  3.4331381504544783`*^9, 
  3.433138175539147*^9}},ExpressionUUID->"5d9afa15-0fd4-41eb-b280-\
f5a6442b22b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exprA", "=", 
  RowBox[{"IrreducibleDecomposition", "[", 
   RowBox[{"Kh", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", "B", ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.433138177277233*^9, 3.433138189216111*^9}, {
   3.433159728241037*^9, 3.4331597295998983`*^9}, {3.433159872710124*^9, 
   3.433159883780526*^9}, 3.433162141484152*^9, 3.433670044281561*^9, {
   3.434375842365355*^9, 3.4343758457290287`*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"2824800f-8ef8-4b50-b694-25dbda6a3b02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TFKh", "[", 
    RowBox[{
     RowBox[{"LI", "[", "\<\"TF\"\>", "]"}], ",", 
     RowBox[{"AnyIndices", "[", 
      InterpretationBox[
       StyleBox["Spin",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Spin,
       Editable->False], "]"}], ",", 
     RowBox[{"AnyIndices", "[", 
      InterpretationBox[
       StyleBox["Spin\[Dagger]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Spin\[Dagger],
       Editable->False], "]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TFKh[
    xAct`xTensor`LI["TF"], 
    xAct`xTensor`AnyIndices[$CellContext`Spin], 
    xAct`xTensor`AnyIndices[$CellContext`Spin\[Dagger]]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[150]:=",ExpressionUUID->"ce592089-76d5-4f57-95d2-9628609e3d8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TFKh\[Dagger]", "[", 
    RowBox[{
     RowBox[{"LI", "[", "\<\"TF\"\>", "]"}], ",", 
     RowBox[{"AnyIndices", "[", 
      InterpretationBox[
       StyleBox["Spin\[Dagger]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Spin\[Dagger],
       Editable->False], "]"}], ",", 
     RowBox[{"AnyIndices", "[", 
      InterpretationBox[
       StyleBox["Spin",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Spin,
       Editable->False], "]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TFKh\[Dagger][
    xAct`xTensor`LI["TF"], 
    xAct`xTensor`AnyIndices[$CellContext`Spin\[Dagger]], 
    xAct`xTensor`AnyIndices[$CellContext`Spin]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[150]:=",ExpressionUUID->"237f0608-e9fc-4757-89aa-39e515ff760f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "B"},
           {"A", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`A, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"1", ",", " ", "2"}], "}"}], "}"}], " ", " "},
           {" ", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 2}}], -C, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"2", ",", " ", "3"}], "}"}], "}"}], " ", " "},
           {" ", "A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{2, 3}}], -$CellContext`A, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"2", ",", " ", "4"}], "}"}], "}"}], " ", " "},
           {" ", "A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{2, 4}}], -$CellContext`A, -C],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"TFKh", 
       StyleBox[GridBox[{
          {
           RowBox[{"{", "}"}], " ", "B", " ", " "},
          {" ", "A", " ", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TFKh[
    xAct`xTensor`LI[{}], -$CellContext`A, $CellContext`B, -C, -D],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", " ", "3"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"2", ",", " ", "4"}], "}"}]}], "}"}]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 3}, {2, 4}}]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"1", ",", " ", "3"}], "}"}], "}"}], "B", " "},
           {" ", " ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 3}}], $CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", " ", "4"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"2", ",", " ", "3"}], "}"}]}], "}"}]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 4}, {2, 3}}]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"1", ",", " ", "4"}], "}"}], "}"}], "B", " "},
           {" ", " ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 4}}], $CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "B"},
           {"A", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`A, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"3", ",", " ", "4"}], "}"}]}], "}"}]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 2}, {3, 4}}]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", "4"}], "}"}], "}"}], " ", "B"},
           {" ", "A", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{3, 4}}], -$CellContext`A, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[150]=",ExpressionUUID->"5bd3b62f-206f-47d1-816d-eac713a8737f"]
}, Open  ]],

Cell[TextData[{
 "The command ",
 StyleBox["IrreducibleDecomposition",
  FontFamily->"Courier"],
 " defines first the totally symmetric spinors intervening in the \
decomposition (irreducible spinors). The actual decomposition is found in a \
second step and displayed in the output. In order to represent the \
irreducible spinors, we introduce an indexed quantity with a variable number \
of slots (see the documentation of the package ",
 StyleBox["xTensor`", "Output"],
 " for further details about this). Note the labels on each of the totally \
symmetric spinors: these are label indices which are used to distinguish each \
of the irreducible spinors. The pairs of numbers which appear inside the list \
indicate which slots of the tensor being decomposed have been picked to \
\"pull out\" factors of the antisymmetric metric.    "
}], "Text",
 CellChangeTimes->{{3.433138004717531*^9, 3.433138056006613*^9}, {
   3.4331381504544783`*^9, 3.433138175539147*^9}, {3.433138218967546*^9, 
   3.433138365900296*^9}, {3.4331384213819304`*^9, 3.433138562298864*^9}, {
   3.433138611628398*^9, 3.433138815925012*^9}, {3.433160270077146*^9, 
   3.4331602817732687`*^9}, 3.434375861017103*^9},
 TextJustification->1.,
 FontWeight->"Plain",ExpressionUUID->"207f14e1-7d9e-4520-84f9-cd4ecb16a513"],

Cell[TextData[{
 "This is the list of all the irreducible spinors resulting from the \
decomposition of ",
 StyleBox["Kh[-A, -B, -C, -D]", "Output"],
 "."
}], "MathCaption",
 CellChangeTimes->{{3.433138004717531*^9, 3.433138056006613*^9}, {
  3.4331381504544783`*^9, 3.433138175539147*^9}, {3.433138218967546*^9, 
  3.433138365900296*^9}, {3.4331384213819304`*^9, 3.433138562298864*^9}, {
  3.433138611628398*^9, 3.433138815925012*^9}, {3.4331600347411613`*^9, 
  3.433160095791729*^9}},
 TextJustification->1.,ExpressionUUID->"e5b65a81-eb7f-4ea1-ad8c-4e9f375448cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"exprA", ",", "_TFKh", ",", "Infinity"}], "]"}]], "Input",
 CellChangeTimes->{{3.433159929104686*^9, 3.433159991778771*^9}, {
   3.433595571712347*^9, 3.4335955723687153`*^9}, 3.4336685715246897`*^9},
 CellLabel->
  "In[151]:=",ExpressionUUID->"5cfc4ad1-ccca-43ba-8df3-5cf539c5b662"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"1", ",", " ", "2"}], "}"}], "}"}], " ", " "},
           {" ", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 2}}], -C, -D],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"2", ",", " ", "3"}], "}"}], "}"}], " ", " "},
           {" ", "A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{2, 3}}], -$CellContext`A, -D],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"2", ",", " ", "4"}], "}"}], "}"}], " ", " "},
           {" ", "A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{2, 4}}], -$CellContext`A, -C],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", "}"}], " ", "B", " ", " "},
           {" ", "A", " ", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{}], -$CellContext`A, $CellContext`B, -C, -D],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", " ", "3"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"2", ",", " ", "4"}], "}"}]}], "}"}]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 3}, {2, 4}}]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"1", ",", " ", "3"}], "}"}], "}"}], "B", " "},
           {" ", " ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 3}}], $CellContext`B, -D],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", " ", "4"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"2", ",", " ", "3"}], "}"}]}], "}"}]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 4}, {2, 3}}]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"1", ",", " ", "4"}], "}"}], "}"}], "B", " "},
           {" ", " ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 4}}], $CellContext`B, -C],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"3", ",", " ", "4"}], "}"}]}], "}"}]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{1, 2}, {3, 4}}]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFKh", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", "4"}], "}"}], "}"}], " ", "B"},
           {" ", "A", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFKh[
     xAct`xTensor`LI[{{3, 4}}], -$CellContext`A, $CellContext`B],
    Editable->False]}], "}"}]], "Output",
 CellLabel->
  "Out[151]=",ExpressionUUID->"7c575491-0872-4a50-8a82-7aded036774a"]
}, Open  ]],

Cell[TextData[{
 "The symbol ",
 StyleBox["TF", "Output"],
 " (trace free) is prepended to the symbol ",
 StyleBox["Kh", "Output"],
 ".  All the quantities of the previous list which are not scalars are \
totally symmetric."
}], "MathCaption",
 CellChangeTimes->{{3.433138004717531*^9, 3.433138056006613*^9}, {
  3.4331381504544783`*^9, 3.433138175539147*^9}, {3.433138218967546*^9, 
  3.433138365900296*^9}, {3.4331384213819304`*^9, 3.433138562298864*^9}, {
  3.433138611628398*^9, 3.433138815925012*^9}, {3.4331600347411613`*^9, 
  3.433160146613595*^9}, {3.4331601977748623`*^9, 3.433160213648467*^9}, {
  3.43317596386404*^9, 3.433176018494379*^9}, {3.433176053700102*^9, 
  3.433176057898512*^9}, {3.433668583304654*^9, 3.4336685842935877`*^9}},
 TextJustification->1.,ExpressionUUID->"d3d2e39e-d8f4-415b-ad8a-8a83f432c2f2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "/@", "%"}]], "Input",
 CellChangeTimes->{{3.433160147824582*^9, 3.433160155902742*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"3520572c-17dd-431e-8d08-a7d07d1e80fa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      InterpretationBox[
       StyleBox[
        RowBox[{"(", "2", ",", "3", ")"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xPerm`Cycles[{2, 3}],
       Editable->False], "]"}]}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      InterpretationBox[
       StyleBox[
        RowBox[{"(", "2", ",", "3", ")"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xPerm`Cycles[{2, 3}],
       Editable->False], "]"}]}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      InterpretationBox[
       StyleBox[
        RowBox[{"(", "2", ",", "3", ")"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xPerm`Cycles[{2, 3}],
       Editable->False], "]"}]}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       InterpretationBox[
        StyleBox[
         RowBox[{"(", "2", ",", "3", ")"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPerm`Cycles[{2, 3}],
        Editable->False], ",", 
       InterpretationBox[
        StyleBox[
         RowBox[{"(", "3", ",", "4", ")"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPerm`Cycles[{3, 4}],
        Editable->False], ",", 
       InterpretationBox[
        StyleBox[
         RowBox[{"(", "4", ",", "5", ")"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPerm`Cycles[{4, 5}],
        Editable->False]}], "]"}]}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      InterpretationBox[
       StyleBox[
        RowBox[{"(", "2", ",", "3", ")"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xPerm`Cycles[{2, 3}],
       Editable->False], "]"}]}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      InterpretationBox[
       StyleBox[
        RowBox[{"(", "2", ",", "3", ")"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xPerm`Cycles[{2, 3}],
       Editable->False], "]"}]}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      InterpretationBox[
       StyleBox[
        RowBox[{"(", "2", ",", "3", ")"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xPerm`Cycles[{2, 3}],
       Editable->False], "]"}]}], "]"}]}], "}"}]], "Output",
 CellLabel->
  "Out[152]=",ExpressionUUID->"20d4a64d-8e57-4a68-a0ee-53bba88fe57e"]
}, Open  ]],

Cell["\<\
The irreducible spinors are servants of the spinor they decompose. Therefore \
they are removed if the latter is erased.\
\>", "MathCaption",
 CellChangeTimes->{{3.433138004717531*^9, 3.433138056006613*^9}, {
  3.4331381504544783`*^9, 3.433138175539147*^9}, {3.433138218967546*^9, 
  3.433138365900296*^9}, {3.4331384213819304`*^9, 3.433138562298864*^9}, {
  3.433138611628398*^9, 3.433138815925012*^9}, {3.4331600347411613`*^9, 
  3.433160146613595*^9}, {3.4331601977748623`*^9, 3.433160213648467*^9}, {
  3.4331680043769693`*^9, 3.433168072470883*^9}},
 TextJustification->1.,ExpressionUUID->"6ccdfd2e-0f76-46cb-9b48-72a31e83cd50"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefSpinor", "@", "Kh"}]], "Input",
 CellChangeTimes->{{3.433168078070013*^9, 3.433168081717841*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"736b1efd-9eaa-4763-b216-754acc95b404"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "TFKh\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`TFKh\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"bcd63778-4bb6-4f3c-b0b0-556a71290c79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "TFKh"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`TFKh],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"706b7b26-2d96-4b42-a069-0d341d2f65b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Kh\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Kh\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"7d5a9943-9488-4339-8889-a451eae416e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Kh"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Kh],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[153]:=",ExpressionUUID->"f321cb62-f901-40e1-93a8-14a04dd3a927"]
}, Open  ]],

Cell["Example of the decomposition of a mixed spinor.", "MathCaption",
 CellChangeTimes->{{3.433138004717531*^9, 3.433138056006613*^9}, {
  3.4331381504544783`*^9, 3.433138175539147*^9}, {3.433138218967546*^9, 
  3.433138365900296*^9}, {3.4331384213819304`*^9, 3.433138562298864*^9}, {
  3.433138611628398*^9, 3.433138815925012*^9}, {3.4331600347411613`*^9, 
  3.433160146613595*^9}, {3.4331601977748623`*^9, 3.433160213648467*^9}, {
  3.4331680043769693`*^9, 3.433168104342819*^9}},
 TextJustification->1.,ExpressionUUID->"f1daba5a-fad2-4729-8e4c-9a4258725a86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrreducibleDecomposition", "[", 
  RowBox[{"SP\[UnderBracket]RicciCD", "[", 
   RowBox[{"A", ",", 
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.433167950798962*^9, 3.4331679767515*^9}, 
   3.433168114006209*^9, 3.433168144414772*^9, 3.433670016328936*^9, 
   3.4343758635811043`*^9},
 CellLabel->
  "In[154]:=",ExpressionUUID->"c8e40095-ebbe-4aee-a7c8-fbe43727e044"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TFSP\[UnderBracket]RicciCD", "[", 
    RowBox[{
     RowBox[{"LI", "[", "\<\"TF\"\>", "]"}], ",", 
     RowBox[{"AnyIndices", "[", 
      InterpretationBox[
       StyleBox["Spin",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Spin,
       Editable->False], "]"}], ",", 
     RowBox[{"AnyIndices", "[", 
      InterpretationBox[
       StyleBox["Spin\[Dagger]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Spin\[Dagger],
       Editable->False], "]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TFSP\[UnderBracket]RicciCD[
    xAct`xTensor`LI["TF"], 
    xAct`xTensor`AnyIndices[$CellContext`Spin], 
    xAct`xTensor`AnyIndices[$CellContext`Spin\[Dagger]]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[154]:=",ExpressionUUID->"2df71aaf-a394-4a0b-b970-2ee3797febcc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TFSP\[UnderBracket]RicciCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"LI", "[", "\<\"TF\"\>", "]"}], ",", 
     RowBox[{"AnyIndices", "[", 
      InterpretationBox[
       StyleBox["Spin\[Dagger]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Spin\[Dagger],
       Editable->False], "]"}], ",", 
     RowBox[{"AnyIndices", "[", 
      InterpretationBox[
       StyleBox["Spin",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Spin,
       Editable->False], "]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TFSP\[UnderBracket]RicciCD\[Dagger][
    xAct`xTensor`LI["TF"], 
    xAct`xTensor`AnyIndices[$CellContext`Spin\[Dagger]], 
    xAct`xTensor`AnyIndices[$CellContext`Spin]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[154]:=",ExpressionUUID->"d1832550-caa2-4cc0-b7b8-af9f06006ee4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFSP\[UnderBracket]RicciCD", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"1", ",", " ", "3"}], "}"}], "}"}], " ", " "},
           {" ", 
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFSP\[UnderBracket]RicciCD[
     xAct`xTensor`LI[{{1, 
      3}}], -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"TFSP\[UnderBracket]RicciCD", 
       StyleBox[GridBox[{
          {
           RowBox[{"{", "}"}], "A", " ", " ", " "},
          {" ", " ", 
           RowBox[{"A", "'"}], "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TFSP\[UnderBracket]RicciCD[
    xAct`xTensor`LI[{}], $CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFSP\[UnderBracket]RicciCD", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", " ", "3"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"2", ",", " ", "4"}], "}"}]}], "}"}]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFSP\[UnderBracket]RicciCD[
     xAct`xTensor`LI[{{1, 3}, {2, 4}}]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"TFSP\[UnderBracket]RicciCD", 
        StyleBox[GridBox[{
           {
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"2", ",", " ", "4"}], "}"}], "}"}], "A", " "},
           {" ", " ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TFSP\[UnderBracket]RicciCD[
     xAct`xTensor`LI[{{2, 4}}], $CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[154]=",ExpressionUUID->"08120638-5b04-4d7c-b610-9f6327ec8a96"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["5. Spin-compatible covariant derivatives", "SubsectionIcon",
 CellChangeTimes->{{3.4244274872183104`*^9, 3.4244274875711308`*^9}, {
  3.425967568225154*^9, 3.425967568384986*^9}, {3.425977066820468*^9, 
  3.4259770671884212`*^9}, {3.427031717262093*^9, 3.4270317294581203`*^9}, {
  3.4339376627085447`*^9, 
  3.433937663058872*^9}},ExpressionUUID->"8a271195-4175-446e-bd72-\
b1ad68d20245"],

Cell[TextData[{
 StyleBox["Spinors`", "Output"],
 "  includes the concept of spin-compatible covariant derivative.",
 StyleBox[" ",
  FontSlant->"Italic"],
 "A covariant derivative is spin-compatible if it yields zero when acting \
upon a soldering form. The spin covariant derivative which extends the \
Levi-Civita covariant derivative is an example of it.  "
}], "Text",
 CellChangeTimes->{{3.424430127477404*^9, 3.424430162871279*^9}, {
  3.424435610400633*^9, 3.42443561626604*^9}, {3.4270275705645103`*^9, 
  3.427027603857093*^9}, {3.427027781305114*^9, 3.427027892049419*^9}, {
  3.427028245573927*^9, 3.4270282586413317`*^9}, {3.4270317341630297`*^9, 
  3.427031765810156*^9}, {3.427031809825923*^9, 3.427031810601832*^9}},
 FontWeight->"Plain",ExpressionUUID->"6767032e-419d-445a-bf37-f3c43ad6b5ce"],

Cell[TextData[{
 StyleBox["DefSpinCovD               ", "Output",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Defines a  spin-compatible covariant derivative \n", "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["UndefSpinCovD             ", "Output",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Undefines  a spin-compatible covariant derivative", "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}], "FramedBox",
 CellChangeTimes->{{3.4270279064015503`*^9, 3.427027979848695*^9}, {
  3.427031782915889*^9, 3.427031790681849*^9}, {3.4270874473912897`*^9, 
  3.4270875014162807`*^9}, {3.427441899648602*^9, 
  3.427441914758012*^9}},ExpressionUUID->"e6fefbc0-7eac-44c2-98f9-\
3c279331c627"],

Cell[TextData[{
 "We define a covariant derivative which is spin-compatible with the \
soldering form ",
 StyleBox["\[Sigma]", "Output"],
 ". Note that the syntax of ",
 StyleBox["DefSpinCovD", "Output"],
 " is similar to the ",
 StyleBox["xAct`", "Output"],
 " command ",
 StyleBox["DefCovD", "Output"],
 " used to define covariant derivatives.  We use non-standard symbols to \
denote the derivative:"
}], "MathCaption",
 TextJustification->1.,ExpressionUUID->"9e8f3b52-3449-4d3b-98a3-9d5e73201cb7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinCovD", "[", 
  RowBox[{
   RowBox[{"nb", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "\[Sigma]", ",", 
   RowBox[{"SymbolOfCovD", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<|\>\"", ",", "\"\<D\>\""}], "}"}]}], ",", 
   RowBox[{"Torsion", "->", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[155]:=",ExpressionUUID->"4ee5dcde-a19d-4d0c-9b92-9a31b62f75a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"nb", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`nb[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"94a18de6-8490-4ca6-844e-339298e8fcf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Torsionnb", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`Torsionnb[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"8a78bff7-2e19-4bd0-b3e6-0fdc39eba8fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Christoffelnb", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`Christoffelnb[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"dd67fe4e-02eb-4a21-adf5-4bc24d81ef7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Riemannnb", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`Riemannnb[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"af7d5b26-992e-4ef0-aeb5-a7956da805de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Riccinb", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`Riccinb[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"95d23aa2-d305-4534-a516-957ccb5eef41"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"ca66d470-330a-4406-8525-177cf70ec5f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelnb", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelnb[$CellContext`A, -$CellContext`b, -C], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"ce4b7b7e-1f56-4ff7-b820-c054fdf7ec50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelnb\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelnb\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"de7bb93c-8355-495f-8fed-084cad5486cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannnb", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannnb[-$CellContext`a, -$CellContext`b, -C, D], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"f645739e-9be6-44a9-a704-9f8071a3648d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannnb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannnb\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"8384af53-cc69-4f56-baee-0b1283d45fab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannnb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemannnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]FRiemannnb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -C, -D], ". ", 
   "Equivalent of tensor FRiemannnb"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"0868bc13-7e9b-4c3e-837c-4ca4387b5abf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannnb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemannnb\[Dagger]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]FRiemannnb\[Dagger][-$CellContext`A\[Dagger],\
 -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor FRiemannnb\[Dagger]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"536cc0f6-5e65-44df-88f7-35dda0fd4dad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Chinb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Chinb[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"55e0885a-46ec-48bc-b574-68ba05dd023c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Chinb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Chinb\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"e0dfb99f-13ea-48f1-8a59-cc81b98f0429"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Phinb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Phinb[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"92dba0d8-cbcf-460f-8540-5253cedacfb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Phinb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Phinb\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"7f8efde7-a70f-44cf-a81c-1f69a63c40ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Torsionnb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Torsionnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Torsionnb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger]], ". ", "Equivalent of tensor Torsionnb"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"f397cfde-cc02-4851-bcf3-dd0ec9e24901"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Torsionnb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Torsionnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Torsionnb\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C], ". ", "Equivalent of tensor Torsionnb"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"2c6fc76b-39cc-4ec1-9b77-d05250af4f22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Omeganb", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion spinor ", 
   $CellContext`Omeganb[-$CellContext`A\[Dagger], -$CellContext`A, \
-$CellContext`B, -C], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"3b90ef77-f003-4513-bb62-3d63dae331b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Omeganb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion spinor ", 
   $CellContext`Omeganb\[Dagger][-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger], -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"6e546861-d6a9-4f4f-b5c7-c86c74a587d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Riemannnb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riemannnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Riemannnb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor Riemannnb"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"5fcece88-9abd-477f-b34b-bc96791fc40d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Riemannnb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riemannnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Riemannnb\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", 
   "Equivalent of tensor Riemannnb"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"138f824a-3263-49bb-bb77-f4d4fc6a0592"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Riccinb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riccinb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Riccinb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", 
   "Equivalent of tensor Riccinb"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"0ddf0d31-a423-4cb7-b5d8-419025e9480c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Riccinb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riccinb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Riccinb\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor Riccinb"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"5ca089d5-1726-421e-8ed8-c41f03d12fb5"]
}, Open  ]],

Cell[TextData[{
 "Several new objects are defined along with the covariant derivative. These \
are the same which are introduced by ",
 StyleBox["DefCovD", "Output"],
 " plus the spinor equivalents of all the curvature quantities. By definition \
the compatibility of the covariant derivative ",
 StyleBox["nb", "Output"],
 " with the spin structure associated to ",
 StyleBox["\[Sigma]", "Output"],
 " means that"
}], "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, 
   3.423661370949039*^9, 3.4238022480753937`*^9, {3.423802457060837*^9, 
   3.423802467876277*^9}, {3.4238027725499153`*^9, 3.4238027944132223`*^9}, {
   3.424430218133699*^9, 3.424430222567498*^9}, {3.427028555914888*^9, 
   3.427028635483898*^9}, {3.427028723648019*^9, 3.42702873689205*^9}, {
   3.427028817771842*^9, 3.4270288717560043`*^9}, {3.427049748883502*^9, 
   3.427049765619173*^9}},
 TextJustification->1.,ExpressionUUID->"79621081-b609-4013-bcc7-04fe7123d645"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "[", 
   RowBox[{"-", "a"}], "]"}], "@", 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"b", ",", 
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[156]:=",ExpressionUUID->"fc2c5f38-7e4e-4007-af93-9b69eaaa3a8a"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[156]=",ExpressionUUID->"52a3db4f-48a0-4285-b08e-6c7bce096d61"]
}, Open  ]],

Cell[TextData[{
 "Rules to decompose the curvature spinors into irreducible parts are also \
available. For example, let us compute the full decomposition of the spinor \
counterpart of the Riemann tensor of the covariant derivative ",
 StyleBox["nb", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["in irreducible parts.", "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
   3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
   3.42259307079659*^9}, 3.422593363484221*^9, {3.4270288830659103`*^9, 
   3.427028908449699*^9}, {3.42702898860177*^9, 3.4270290037477694`*^9}, {
   3.4270290539164877`*^9, 3.427029055179262*^9}, {3.4270497877135677`*^9, 
   3.427049791853217*^9}},
 TextJustification->1.,ExpressionUUID->"8885a40a-e565-4cd6-a5b2-1fc40c7f241c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", 
  RowBox[{"Riemannnb", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4270290101690207`*^9, 3.4270290283648252`*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"8a91dbd9-6299-4a93-9c9d-0264df319ac7"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "D", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Riemannnb[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", " ", " "},
          {" ", "D", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[157]=",ExpressionUUID->"124b5297-eb81-4a57-bc3f-7c6ac66633d4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4270290355960712`*^9, 3.427029041055059*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"511f00b9-33ec-4b77-adb5-689d8d739f25"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"SR", "[", "D", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"A", 
          RowBox[{"A", "'"}], "B", 
          RowBox[{"B", "'"}], "C", 
          RowBox[{"C", "'"}], "D", 
          RowBox[{"D", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP\[UnderBracket]Riemannnb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
   C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]],
  Editable->False]], "Output",
 CellLabel->
  "Out[158]=",ExpressionUUID->"cfbe712d-4331-46d8-8832-2145ce8af2b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", 
  RowBox[{"SP\[UnderBracket]Riemannnb", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "C\[Dagger]"}], ",", 
    RowBox[{"-", "D"}], ",", 
    RowBox[{"-", "D\[Dagger]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.422592233078432*^9, 3.422592235140602*^9}, {
   3.42259228584725*^9, 3.4225922876074247`*^9}, {3.422592334556916*^9, 
   3.422592390941977*^9}, {3.422592428257379*^9, 3.42259243080678*^9}, 
   3.423660076774312*^9, {3.423660144092894*^9, 3.423660145912932*^9}, {
   3.423661211711639*^9, 3.4236612386296177`*^9}, {3.423661865663981*^9, 
   3.423661866354659*^9}, {3.423662010449459*^9, 3.423662015207943*^9}, {
   3.423671637024252*^9, 3.423671638209605*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"2afd58db-a029-4186-877c-f16c123a9ee4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"SF", "[", "D", "]"}], "\[Dagger]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " ", " ", " "},
           {
            RowBox[{"A", "'"}], "A", 
            RowBox[{"B", "'"}], "B", 
            RowBox[{"D", "'"}], 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`SP\[UnderBracket]FRiemannnb\[Dagger][-$CellContext`A\[Dagger]\
, -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`D\
\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"SF", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " ", " ", " "},
           {"A", 
            RowBox[{"A", "'"}], "B", 
            RowBox[{"B", "'"}], "D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`SP\[UnderBracket]FRiemannnb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -D, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"C", "'"}], 
            RowBox[{"D", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[159]=",ExpressionUUID->"beeeae1f-59a1-4c9c-9ca1-c299d77c47b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.423662047044632*^9, 3.42366204910975*^9}, {
  3.42367163218327*^9, 3.423671632978463*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"07752b33-0164-402f-9ad6-fdc47d6c8ea4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            RowBox[{"\[CapitalChi]", "[", "D", "]"}], "\[Dagger]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {
               RowBox[{"D", "'"}], 
               RowBox[{"C", "'"}], 
               RowBox[{"A", "'"}], 
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Chinb\[Dagger][-$CellContext`D\[Dagger], -$CellContext`C\
\[Dagger], -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            RowBox[{"\[CapitalPhi]", "[", "D", "]"}], "\[Dagger]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {
               RowBox[{"D", "'"}], 
               RowBox[{"C", "'"}], "A", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Phinb\[Dagger][-$CellContext`D\[Dagger], -$CellContext`C\
\[Dagger], -$CellContext`A, -$CellContext`B],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "__"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               RowBox[{"A", "'"}], 
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalPhi]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {"D", "C", 
               RowBox[{"A", "'"}], 
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Phinb[-D, -
        C, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalChi]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {"D", "C", "A", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Chinb[-D, -C, -$CellContext`A, -$CellContext`B],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "__"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               RowBox[{"A", "'"}], 
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"C", "'"}], 
            RowBox[{"D", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[160]=",ExpressionUUID->"df1ad014-e9cc-41b3-925a-55fcc920bc44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4270292038406687`*^9, 3.427029230470693*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"2abde3d2-ddf5-4803-9a25-7afffdaac071"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalChi]", "[", "D", "]"}], "\[Dagger]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {
            RowBox[{"D", "'"}], 
            RowBox[{"C", "'"}], 
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Chinb\[Dagger][-$CellContext`D\[Dagger], -$CellContext`C\
\[Dagger], -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalPhi]", "[", "D", "]"}], "\[Dagger]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {
            RowBox[{"D", "'"}], 
            RowBox[{"C", "'"}], "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phinb\[Dagger][-$CellContext`D\[Dagger], -$CellContext`C\
\[Dagger], -$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"D", "C", 
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phinb[-D, -
     C, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"C", "'"}], 
            RowBox[{"D", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalChi]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"D", "C", "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Chinb[-D, -C, -$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"C", "'"}], 
            RowBox[{"D", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[161]=",ExpressionUUID->"8b45e421-b939-4322-8a21-ff94e263a83f"]
}, Open  ]],

Cell["\<\
Note that the curvature spinors associated to a generic spin-compatible \
covariant derivative do not have the same symmetries as those of the spin \
covariant derivative.\
\>", "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
  3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
  3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
  3.42443023656312*^9, 3.424430242894526*^9}, {3.427028663953743*^9, 
  3.427028671297625*^9}, {3.427108641742231*^9, 3.4271086639958878`*^9}, {
  3.4271087388760767`*^9, 3.427108748236384*^9}, {3.427108865276163*^9, 
  3.427108884396138*^9}},ExpressionUUID->"449d07ce-e012-419b-8e17-\
706db2edb75f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SymmetryGroupOfTensor", "@", "Chinb"}], ",", 
     RowBox[{"SymmetryGroupOfTensor", "@", "ChiCDe"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SymmetryGroupOfTensor", "@", "Phinb"}], ",", 
     RowBox[{"SymmetryGroupOfTensor", "@", "PhiCDe"}]}], "}"}]}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.427108886018963*^9, 3.427108902702991*^9}, {
  3.42710895643118*^9, 3.427108968511455*^9}, {3.427109012001109*^9, 
  3.427109089479343*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"a929cc4b-1ed0-4572-886e-960a9479fe6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        InterpretationBox[
         StyleBox[
          RowBox[{"(", "3", ",", "4", ")"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPerm`Cycles[{3, 4}],
         Editable->False], "]"}]}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"(", "1", ",", "2", ")"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xPerm`Cycles[{1, 2}],
          Editable->False], ",", 
         InterpretationBox[
          StyleBox[
           RowBox[{"(", "3", ",", "4", ")"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xPerm`Cycles[{3, 4}],
          Editable->False], ",", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            RowBox[{"(", "1", ",", "3", ")"}], 
            RowBox[{"(", "2", ",", "4", ")"}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xPerm`Cycles[{1, 3}, {2, 4}],
          Editable->False]}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        InterpretationBox[
         StyleBox[
          RowBox[{"(", "3", ",", "4", ")"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPerm`Cycles[{3, 4}],
         Editable->False], "]"}]}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"(", "1", ",", "2", ")"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xPerm`Cycles[{1, 2}],
          Editable->False], ",", 
         InterpretationBox[
          StyleBox[
           RowBox[{"(", "3", ",", "4", ")"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xPerm`Cycles[{3, 4}],
          Editable->False]}], "]"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->
  "Out[162]=",ExpressionUUID->"7eb1152b-1170-48fb-b961-ac545cab1908"]
}, Open  ]],

Cell["There are also decomposition rules for the torsion spinor.", \
"MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
   3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
   3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
   3.42443023656312*^9, 3.424430242894526*^9}, {3.427028663953743*^9, 
   3.427028671297625*^9}, {3.427108641742231*^9, 3.4271086639958878`*^9}, {
   3.4271087388760767`*^9, 3.427108748236384*^9}, {3.427108865276163*^9, 
   3.427108884396138*^9}, 3.434695851515336*^9, {3.434695943257594*^9, 
   3.43469597631287*^9}},ExpressionUUID->"61a3dcf4-c039-4e57-b6d2-\
68be80055aa0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Torsionnb", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}], "==", 
  RowBox[{
   RowBox[{"SeparateSolderingForm", "[", "]"}], "@", 
   RowBox[{"Torsionnb", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.434695977584753*^9, 3.43469605890443*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"2e8b6cfa-e897-4e1d-95a3-d112f0b29a18"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"T", "[", "D", "]"}], 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "b", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Torsionnb[$CellContext`a, -$CellContext`b, -$CellContext`c],
   Editable->False], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"ST", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"A", 
            RowBox[{"A", "'"}], " ", " ", " ", " "},
           {" ", " ", "B", 
            RowBox[{"B", "'"}], "C", 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`SP\[UnderBracket]Torsionnb[$CellContext`A, $CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
     C, -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "A", 
            RowBox[{"A", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "B", 
            RowBox[{"B", "'"}]},
           {"b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "C", 
            RowBox[{"C", "'"}]},
           {"c", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[163]=",ExpressionUUID->"f851c0f5-0ec0-4f05-962c-8ef7ebada0b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "/@", "%"}]], "Input",
 CellChangeTimes->{{3.4346960630435123`*^9, 3.4346960712786703`*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"5e3f35d7-efe9-42dd-adfa-41e60ecb6b9b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"T", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Torsionnb[$CellContext`a, -$CellContext`b, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "A", 
            RowBox[{"A", "'"}]},
           {"a", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "B", 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"c", " ", " "},
           {" ", "C", 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
    Editable->False]}], "\[Equal]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"ST", "[", "D", "]"}], 
       StyleBox[GridBox[{
          {"A", 
           RowBox[{"A", "'"}], " ", " ", " ", " "},
          {" ", " ", "B", 
           RowBox[{"B", "'"}], "C", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SP\[UnderBracket]Torsionnb[$CellContext`A, $CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[164]=",ExpressionUUID->"f31b05ec-ccf3-4810-a160-4a9b56dbe6c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "/@", "%"}]], "Input",
 CellChangeTimes->{{3.434696077736904*^9, 3.4346960843022633`*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"2f6f4032-3129-4d7c-a205-84b53a03674b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"T", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Torsionnb[$CellContext`a, -$CellContext`b, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "A", 
            RowBox[{"A", "'"}]},
           {"a", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "B", 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"c", " ", " "},
           {" ", "C", 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"A", "D"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][$CellContext`A, D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "__"], 
        StyleBox[GridBox[{
           {
            RowBox[{"A", "'"}], 
            RowBox[{"D", "'"}]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][$CellContext`A\[Dagger], $CellContext`D\
\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            RowBox[{"\[CapitalOmega]", "[", "D", "]"}], "\[Dagger]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {"D", 
               RowBox[{"D", "'"}], 
               RowBox[{"B", "'"}], 
               RowBox[{"C", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Omeganb\[Dagger][-
        D, -$CellContext`D\[Dagger], -$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -C],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalOmega]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {
               RowBox[{"D", "'"}], "D", "B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Omeganb[-$CellContext`D\[Dagger], -D, -$CellContext`B, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "__"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               RowBox[{"B", "'"}], 
               RowBox[{"C", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False]}]}], ")"}]}]}]], "Output",
 CellLabel->
  "Out[165]=",ExpressionUUID->"fe2c614e-a1d8-4d05-b18c-0fb6be46e1f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "/@", "%"}]], "Input",
 CellChangeTimes->{{3.434696088151607*^9, 3.4346960935660753`*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"8698f1f3-57a6-46ca-87cb-b79ed3adca9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"T", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Torsionnb[$CellContext`a, -$CellContext`b, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "A", 
            RowBox[{"A", "'"}]},
           {"a", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "B", 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"c", " ", " "},
           {" ", "C", 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalOmega]", "[", "D", "]"}], "\[Dagger]"}], 
         StyleBox[GridBox[{
            {"A", 
             RowBox[{"A", "'"}], " ", " "},
            {" ", " ", 
             RowBox[{"B", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Omeganb\[Dagger][$CellContext`A, $CellContext`A\[Dagger], \
-$CellContext`B\[Dagger], -$CellContext`C\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalOmega]", "[", "D", "]"}], 
         StyleBox[GridBox[{
            {
             RowBox[{"A", "'"}], "A", " ", " "},
            {" ", " ", "B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Omeganb[$CellContext`A\[Dagger], $CellContext`A, \
-$CellContext`B, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "__"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"B", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
     Editable->False]}]}]}]], "Output",
 CellLabel->
  "Out[166]=",ExpressionUUID->"51ef4f35-3693-40a0-ad21-0155c5bdd251"]
}, Open  ]],

Cell[TextData[{
 "The covariant derivative ",
 StyleBox["nb", "Input",
  FontWeight->"Plain"],
 StyleBox[" can be manipulated in 2-index or in single index notation.", 
  "Text",
  FontWeight->"Plain"]
}], "MathCaption",
 CellChangeTimes->{{3.422592840547114*^9, 3.422592896771524*^9}, {
  3.4225929428403177`*^9, 3.422592980888042*^9}, {3.422593067317882*^9, 
  3.42259307079659*^9}, {3.4225932685694103`*^9, 3.422593361596933*^9}, {
  3.42443023656312*^9, 3.424430242894526*^9}, {3.427028663953743*^9, 
  3.427028671297625*^9}},ExpressionUUID->"2b25297b-6049-4547-9a24-\
0ab9f96d153f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "@", 
  RowBox[{"Chinb", "[", 
   RowBox[{
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}], ",", 
    RowBox[{"-", "F"}], ",", 
    RowBox[{"-", "P"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.422592551275885*^9, 3.4225925849939623`*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"6aa6c559-d277-4a68-b8e6-107a6793b8c3"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["D", 
     RowBox[{"AA", "'"}], "  "], GridBox[{
      {
       RowBox[{"\[CapitalChi]", "[", "D", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"C", "D", "F", "P"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`nb[-$CellContext`A, -$CellContext`A\[Dagger]][
   $CellContext`Chinb[-C, -D, -$CellContext`F, -$CellContext`P]],
  Editable->False]], "Output",
 CellLabel->
  "Out[167]=",ExpressionUUID->"cde4c93c-3a6d-4b6a-8e20-7120bcf40855"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", 
  RowBox[{"%", ",", "nb"}], "]"}]], "Input",
 CellChangeTimes->{{3.422592713721136*^9, 3.422592714967881*^9}, {
  3.4262748299128847`*^9, 3.4262748300928993`*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"8e7fb762-72f4-4195-b0bb-fd7417c0af4e"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["D", "a"], GridBox[{
        {
         RowBox[{"\[CapitalChi]", "[", "D", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"C", "D", "F", "P"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`nb[-$CellContext`a][
     $CellContext`Chinb[-C, -D, -$CellContext`F, -$CellContext`P]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->
  "Out[168]=",ExpressionUUID->"af06ec92-8913-4dd9-9382-5ae0bcd0d0c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4270291544957323`*^9, 3.427029158839253*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"25c4382c-3977-4c47-84ec-1b1a7aa83a16"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["D", "a"], GridBox[{
      {
       RowBox[{"\[CapitalChi]", "[", "D", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"C", "D", "F", "P"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`nb[-$CellContext`a][
   $CellContext`Chinb[-C, -D, -$CellContext`F, -$CellContext`P]],
  Editable->False]], "Output",
 CellLabel->
  "Out[169]=",ExpressionUUID->"e8959c73-d467-40da-ab05-209d28108d2b"]
}, Open  ]],

Cell["In postfix notation :", "MathCaption",
 CellChangeTimes->{{3.427160621221078*^9, 
  3.427160627912965*^9}},ExpressionUUID->"80b54ce2-aa18-40dc-9f4d-\
3835ecd65145"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CovDFormat", "=", "\"\<Postfix\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.427160633887158*^9, 3.427160640697361*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"4dc313aa-36dc-45d4-abab-88df98d5b28d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "@", 
  RowBox[{"Chinb", "[", 
   RowBox[{
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}], ",", 
    RowBox[{"-", "F"}], ",", 
    RowBox[{"-", "P"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.422592551275885*^9, 3.4225925849939623`*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"2d4a1f2b-cc9b-4b19-a409-2dff9f4cc5f8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"\[CapitalChi]", "[", "D", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", "  ", " "},
         {"C", "D", "F", "P", 
          RowBox[{"|", "A"}], 
          RowBox[{"A", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`nb[-$CellContext`A, -$CellContext`A\[Dagger]][
   $CellContext`Chinb[-C, -D, -$CellContext`F, -$CellContext`P]],
  Editable->False]], "Output",
 CellLabel->
  "Out[171]=",ExpressionUUID->"3a919bf1-ea6d-4959-8995-fd71be6ed274"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CovDFormat", "=", "\"\<Prefix\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.42716065249047*^9, 3.427160658454707*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"cae32261-a9df-4c58-ab40-c12ac31ba1f4"],

Cell[TextData[{
 StyleBox["The spinor expression of the Ricci identities of any \
spin-compatible covariant derivative is neatly rendered in terms of the ", 
  "Text",
  FontWeight->"Plain"],
 StyleBox["box operator.", "Text",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[" This is a linear differential operator and ", "Text",
  FontWeight->"Plain"],
 StyleBox[" ", "Text",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["Spinors`", "Output",
  FontWeight->"Plain"],
 StyleBox["  is able to work with it. The box operator is represented by the \
head ", "Text",
  FontWeight->"Plain"],
 StyleBox["BoxCovDname", "Input",
  FontWeight->"Plain"],
 StyleBox[" ", "Input"],
 StyleBox["where the symbol ",
  FontWeight->"Plain"],
 StyleBox["CovDname", "Output",
  FontWeight->"Plain"],
 StyleBox[" represents the spin-compatible covariant derivative.",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.4259789828283978`*^9, 3.425979043214308*^9}, {
   3.425979142358512*^9, 3.4259791755022297`*^9}, {3.425979597062771*^9, 
   3.425979707743182*^9}, {3.425979796310693*^9, 3.4259798398067503`*^9}, {
   3.425979871150588*^9, 3.4259798973486633`*^9}, {3.425979931268716*^9, 
   3.425979940398102*^9}, {3.425980067756447*^9, 3.425980116908681*^9}, {
   3.425980181406547*^9, 3.4259802579094353`*^9}, {3.425980390013236*^9, 
   3.425980495610824*^9}, {3.425980552374029*^9, 3.42598059069726*^9}, {
   3.425980662477886*^9, 3.4259807389829063`*^9}, {3.425980805536109*^9, 
   3.4259808153845167`*^9}, {3.427029495350716*^9, 3.4270295237616653`*^9}, {
   3.4270295648257637`*^9, 3.4270296276178493`*^9}, {3.427029811074642*^9, 
   3.4270300502099*^9}, 3.427030390175356*^9, {3.427049824145842*^9, 
   3.4270498263210773`*^9}, {3.427109228630039*^9, 3.427109269908774*^9}},
 TextJustification->1.,ExpressionUUID->"9c812c63-8081-4c3a-a968-1fcb079ca33a"],

Cell[TextData[StyleBox["Action of the box  operator on a spinor and some \
simple manipulations involving it.", "Text",
 FontWeight->"Plain"]], "MathCaption",
 CellChangeTimes->{{3.4259789828283978`*^9, 3.425979043214308*^9}, {
  3.425979142358512*^9, 3.4259791755022297`*^9}, {3.425979597062771*^9, 
  3.425979707743182*^9}, {3.425979796310693*^9, 3.4259798398067503`*^9}, {
  3.425979871150588*^9, 3.4259798973486633`*^9}, {3.425979931268716*^9, 
  3.425979940398102*^9}, {3.425980067756447*^9, 3.425980116908681*^9}, {
  3.4259808311828327`*^9, 3.42598083924446*^9}, {3.426849556420577*^9, 
  3.426849559770712*^9}, {3.427029649131514*^9, 3.4270296609369993`*^9}, {
  3.427030400346909*^9, 3.427030415865768*^9}, {3.427049844102872*^9, 
  3.427049846061817*^9}},ExpressionUUID->"7afc0105-8b46-45e4-b6f7-\
7f5dbbfc8273"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Xi]", "[", 
    RowBox[{"-", "A"}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.425128375189958*^9, 3.425128425852763*^9}, {
  3.42679525689433*^9, 3.4267952576123753`*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"44f94663-ca90-4afb-86b4-17ce2df5d758"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Xi]", "[", 
    RowBox[{"-", "A"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Xi][-$CellContext`A], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"bf808ab0-02b3-4783-9177-a8440e93f89d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Xi]\[Dagger]", "[", 
    RowBox[{"-", "A\[Dagger]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Xi]\[Dagger][-$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[173]:=",ExpressionUUID->"7ce558d4-4fb7-41bf-a235-bf218d4a4541"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BoxCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}], "@", 
  RowBox[{"\[Xi]", "[", 
   RowBox[{"-", "C"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.425132671855446*^9, 3.425132679710946*^9}, {
  3.4251946061345053`*^9, 3.425194607340399*^9}, {3.425980374783931*^9, 
  3.425980380264168*^9}, {3.427030102839238*^9, 3.42703010623494*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"0631e8c2-9458-46eb-93fd-7fa1122e5599"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], "AB", 
     "  "], GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {" "},
          {"C"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`BoxCDe[-$CellContext`A, -$CellContext`B][
   $CellContext`\[Xi][-C]],
  Editable->False]], "Output",
 CellLabel->
  "Out[174]=",ExpressionUUID->"71db4628-bf7c-4e4f-84b0-88bfbae908e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Epsilon]", "[", 
   RowBox[{"A", ",", "B"}], "]"}], 
  RowBox[{
   RowBox[{"BoxCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "@", 
   RowBox[{"\[Xi]", "[", 
    RowBox[{"-", "C"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.426850147168165*^9, 3.426850160067294*^9}},
 CellLabel->
  "In[175]:=",ExpressionUUID->"a061b3f6-1db4-44f5-9a7f-dfb46dd653e8"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]", 
       StyleBox[GridBox[{
          {"A", "B"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon][$CellContext`A, $CellContext`B],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubsuperscriptBox[
       RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], "AB", 
       "  "], GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {" "},
            {"C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`BoxCDe[-$CellContext`A, -$CellContext`B][
     $CellContext`\[Xi][-C]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->
  "Out[175]=",ExpressionUUID->"41356413-dd47-4002-86f0-87a6dbb7c7b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4268501635684566`*^9, 3.426850169170368*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"ab7bd7b9-1398-4afd-8252-414fc351f737"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], 
     RowBox[{"A", " "}], 
     RowBox[{" ", "A"}]], GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {" "},
          {"C"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`BoxCDe[-$CellContext`A, $CellContext`A][
   $CellContext`\[Xi][-C]],
  Editable->False]], "Output",
 CellLabel->
  "Out[176]=",ExpressionUUID->"981baf9f-345c-4390-86f2-2a5f8aad4020"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.426850171152903*^9, 3.426850173946322*^9}},
 CellLabel->
  "In[177]:=",ExpressionUUID->"81a9ef27-bc3d-4982-b3dd-4ef42e9155a9"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[177]=",ExpressionUUID->"00fa8d3c-3733-4ff9-9e41-dbcb89409986"]
}, Open  ]],

Cell[TextData[{
 StyleBox["The box operator can be expanded into spin covariant derivatives \
or into curvature spinors plus the torsion, according to known formulae (see \
eqs. (4.9.8)-(4.9.17) of Penrose & Rindler Vol. 2). ", "Text",
  FontWeight->"Plain"],
 StyleBox["Spinors ", "Text",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["has built-in rules to perform these expansions.", "Text",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.4259789828283978`*^9, 3.425979043214308*^9}, {
   3.425979142358512*^9, 3.4259791755022297`*^9}, {3.425979597062771*^9, 
   3.425979707743182*^9}, {3.425979796310693*^9, 3.4259798398067503`*^9}, {
   3.425979871150588*^9, 3.4259798973486633`*^9}, {3.425979931268716*^9, 
   3.425979940398102*^9}, {3.425980067756447*^9, 3.425980116908681*^9}, {
   3.4259808311828327`*^9, 3.425980905276863*^9}, 3.425980995648839*^9, {
   3.425981123758246*^9, 3.4259811247823*^9}, {3.425981179638534*^9, 
   3.425981202750051*^9}, {3.426852737165269*^9, 3.426852790428603*^9}, {
   3.426852910380934*^9, 3.4268529192204514`*^9}, {3.434695763906081*^9, 
   3.4346957701131973`*^9}},ExpressionUUID->"92d58e22-ef05-4bf3-b26d-\
7ea23f912877"],

Cell[TextData[{
 StyleBox["BoxToCovD", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["                     ", "Input",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Expand the box operator into covariant derivatives", "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["\n", "Input",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["BoxToCurvature", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["                ", "Input",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Expand the box operator into curvature spinors", "Text",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox[" ", "Input",
  FontColor->RGBColor[0, 0, 1]]
}], "FramedBox",
 CellChangeTimes->{{3.426849914102318*^9, 3.426849914505766*^9}, {
  3.4268499554043703`*^9, 3.426850108172727*^9}, {3.427049881283436*^9, 
  3.427049882301939*^9}},ExpressionUUID->"5640349d-41ff-4c1f-8940-\
fe9452605b0a"],

Cell["Examples of the expansion of the Box operator.", "MathCaption",
 CellChangeTimes->{{3.4268529441229477`*^9, 
  3.4268529650843687`*^9}},ExpressionUUID->"352ed195-9ea5-4d81-9c6e-\
6e2aaff6f75d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BoxCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}], "@", 
  RowBox[{"\[Xi]", "[", 
   RowBox[{"-", "C"}], "]"}]}]], "Input",
 CellLabel->
  "In[178]:=",ExpressionUUID->"8ce329db-163e-4d6a-b43d-3673826076ec"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], "AB", 
     "  "], GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {" "},
          {"C"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`BoxCDe[-$CellContext`A, -$CellContext`B][
   $CellContext`\[Xi][-C]],
  Editable->False]], "Output",
 CellLabel->
  "Out[178]=",ExpressionUUID->"002f701a-a5f6-43a0-ba6e-5154c90eb51b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCovD", "[", 
  RowBox[{"%", ",", "BoxCDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.425966961057304*^9, 3.425966988750458*^9}, {
  3.42598092268195*^9, 3.425980924088032*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"d1cd20c5-f4ce-48ad-b607-e245acee6780"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"AA", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"B", " "}], 
        RowBox[{" ", 
         RowBox[{"A", "'"}]}]], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
      $CellContext`CDe[-$CellContext`B, $CellContext`A\[Dagger]][
       $CellContext`\[Xi][-C]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"BA", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"A", " "}], 
        RowBox[{" ", 
         RowBox[{"A", "'"}]}]], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`B, -$CellContext`A\[Dagger]][
      $CellContext`CDe[-$CellContext`A, $CellContext`A\[Dagger]][
       $CellContext`\[Xi][-C]]],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[179]=",ExpressionUUID->"ee8ce26a-ad80-4519-83ec-a7302629eaa2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCurvature", "[", 
  RowBox[{"%%", ",", "BoxCDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.425967001719009*^9, 3.425967014123554*^9}, {
  3.425980927481868*^9, 3.425980929903776*^9}},
 CellLabel->
  "In[180]:=",ExpressionUUID->"c58b1486-af80-435d-921b-7bcc1e92c850"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalChi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"D", "C", "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChiCDe[-D, -C, -$CellContext`A, -$CellContext`B],
    Editable->False]}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {"D"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Xi][D],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[180]=",ExpressionUUID->"b2fa1856-ad7c-46c9-95f3-c269b1cdbea8"]
}, Open  ]],

Cell[TextData[{
 "Similar computations for the box operator arising from the covariant \
derivative ",
 StyleBox["nb", "Output"],
 ". Note the presence of an extra term due to the fact that the covariant \
derivative ",
 StyleBox["nb", "Output"],
 " has torsion."
}], "MathCaption",
 CellChangeTimes->{{3.4268529441229477`*^9, 3.4268529650843687`*^9}, {
  3.4270306695234737`*^9, 3.4270306949129877`*^9}, {3.434650782299618*^9, 
  3.434650804942648*^9}},ExpressionUUID->"3bb6bea9-6e47-49fc-82aa-\
936a1e7799e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Boxnb", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}], "@", 
  RowBox[{"\[Xi]", "[", 
   RowBox[{"-", "C"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4270306303935328`*^9, 3.4270306316318607`*^9}},
 CellLabel->
  "In[181]:=",ExpressionUUID->"62bf9c77-1076-4734-8216-0cee44f526f5"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"\[EmptySquare]", "[", "D", "]"}], "AB", "  "], GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {" "},
          {"C"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Boxnb[-$CellContext`A, -$CellContext`B][
   $CellContext`\[Xi][-C]],
  Editable->False]], "Output",
 CellLabel->
  "Out[181]=",ExpressionUUID->"62dc873b-f428-421f-9503-c911906532ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCovD", "[", 
  RowBox[{"%", ",", "Boxnb"}], "]"}]], "Input",
 CellChangeTimes->{{3.425966961057304*^9, 3.425966988750458*^9}, {
  3.42598092268195*^9, 3.425980924088032*^9}, {3.427030642775097*^9, 
  3.427030643747663*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"90623823-2987-4f84-8792-ef6fcc6008d5"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["D", 
        RowBox[{"AA", "'"}], "  "], 
       SubsuperscriptBox["D", 
        RowBox[{"B", " "}], 
        RowBox[{" ", 
         RowBox[{"A", "'"}]}]], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nb[-$CellContext`A, -$CellContext`A\[Dagger]][
      $CellContext`nb[-$CellContext`B, $CellContext`A\[Dagger]][
       $CellContext`\[Xi][-C]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["D", 
        RowBox[{"BA", "'"}], "  "], 
       SubsuperscriptBox["D", 
        RowBox[{"A", " "}], 
        RowBox[{" ", 
         RowBox[{"A", "'"}]}]], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nb[-$CellContext`B, -$CellContext`A\[Dagger]][
      $CellContext`nb[-$CellContext`A, $CellContext`A\[Dagger]][
       $CellContext`\[Xi][-C]]],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[182]=",ExpressionUUID->"7fe58777-15cb-482e-822e-3485793a1e07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCurvature", "[", 
  RowBox[{"%%", ",", "Boxnb"}], "]"}]], "Input",
 CellChangeTimes->{{3.425967001719009*^9, 3.425967014123554*^9}, {
  3.425980927481868*^9, 3.425980929903776*^9}, {3.427030647207251*^9, 
  3.427030648525056*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"6d1bc68d-726a-423f-9697-2f285fa93403"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalChi]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"D", " ", " ", " "},
           {" ", "C", "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Chinb[D, -C, -$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Xi]", 
        StyleBox[GridBox[{
           {" "},
           {"D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Xi][-D],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalOmega]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {
            RowBox[{"A", "'"}], "D", " ", " "},
           {" ", " ", "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Omeganb[$CellContext`A\[Dagger], 
     D, -$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["D", 
        RowBox[{"DA", "'"}], "  "], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`nb[-D, -$CellContext`A\[Dagger]][
      $CellContext`\[Xi][-C]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->
  "Out[183]=",ExpressionUUID->"fa1babc7-eb90-4f7b-a5b2-cd4215ee7171"]
}, Open  ]],

Cell[TextData[StyleBox["Other computations involving the box operator.", \
"Text",
 FontWeight->"Plain"]], "MathCaption",
 CellChangeTimes->{{3.4259789828283978`*^9, 3.425979043214308*^9}, {
  3.425979142358512*^9, 3.4259791755022297`*^9}, {3.425979597062771*^9, 
  3.425979707743182*^9}, {3.425979796310693*^9, 3.4259798398067503`*^9}, {
  3.425979871150588*^9, 3.4259798973486633`*^9}, {3.425979931268716*^9, 
  3.425979940398102*^9}, {3.425980067756447*^9, 3.425980116908681*^9}, {
  3.4259808311828327`*^9, 3.425980905276863*^9}, {3.4259809418384867`*^9, 
  3.425980945068602*^9}, {3.427049904008113*^9, 
  3.427049910612441*^9}},ExpressionUUID->"c0d1ded4-a788-4fc0-bbdb-\
b3d6039c3c21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BoxCDe", "[", 
   RowBox[{
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B\[Dagger]"}]}], "]"}], "@", 
  RowBox[{"\[Xi]", "[", 
   RowBox[{"-", "C"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.425967025647011*^9, 3.425967037427985*^9}, {
  3.425980971312251*^9, 3.425980972503941*^9}},
 CellLabel->
  "In[184]:=",ExpressionUUID->"10e4b42d-ff5b-4f58-b9de-5bc63e38d850"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], 
     RowBox[{
      RowBox[{"A", "'"}], 
      RowBox[{"B", "'"}]}], "  "], GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {" "},
          {"C"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`BoxCDe[-$CellContext`A\[Dagger], -$CellContext`B\[Dagger]][
   $CellContext`\[Xi][-C]],
  Editable->False]], "Output",
 CellLabel->
  "Out[184]=",ExpressionUUID->"16446c30-4d0f-4842-abd5-ff859764fcf7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCovD", "[", 
  RowBox[{"%", ",", "BoxCDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.425966961057304*^9, 3.425966988750458*^9}, {
  3.425980975953199*^9, 3.425980976919517*^9}},
 CellLabel->
  "In[185]:=",ExpressionUUID->"2d3f2ac6-3305-4c02-a59c-b1db2cd55826"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"AA", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{" ", 
         RowBox[{"B", "'"}]}], 
        RowBox[{"A", " "}]], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
      $CellContext`CDe[$CellContext`A, -$CellContext`B\[Dagger]][
       $CellContext`\[Xi][-C]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"AB", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{" ", 
         RowBox[{"A", "'"}]}], 
        RowBox[{"A", " "}]], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`A, -$CellContext`B\[Dagger]][
      $CellContext`CDe[$CellContext`A, -$CellContext`A\[Dagger]][
       $CellContext`\[Xi][-C]]],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[185]=",ExpressionUUID->"b82f41de-fdc6-45b1-8fd0-a6a0204aa5db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCurvature", "[", 
  RowBox[{"%%", ",", "BoxCDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.425967001719009*^9, 3.425967014123554*^9}, {
  3.4259809800497026`*^9, 3.425980981295596*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"e7683e81-5ff2-44ec-8463-744bb5a9debf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "C", 
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-$CellContext`A, -
     C, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False]}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {"A"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Xi][$CellContext`A],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[186]=",ExpressionUUID->"8ad716a3-0a1e-41ca-a17e-21b619a6d144"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BoxCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}], "@", 
  RowBox[{"PhiCDe", "[", 
   RowBox[{
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}], ",", 
    RowBox[{"-", "C\[Dagger]"}], ",", 
    RowBox[{"-", "D\[Dagger]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.425981292281371*^9, 3.425981298539475*^9}, {
  3.425981330491221*^9, 3.425981362800077*^9}},
 CellLabel->
  "In[187]:=",ExpressionUUID->"4f48b2eb-f743-43e9-9325-d65e548ed079"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], "AB", 
     "  "], GridBox[{
      {
       RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"C", "D", 
           RowBox[{"C", "'"}], 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`BoxCDe[-$CellContext`A, -$CellContext`B][
   $CellContext`PhiCDe[-C, -
    D, -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[187]=",ExpressionUUID->"b49e4b6b-3d5b-49d2-be4d-a42e5cdbbcbf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCovD", "[", 
  RowBox[{"%", ",", "BoxCDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.425966961057304*^9, 3.425966988750458*^9}, {
  3.425980975953199*^9, 3.425980976919517*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"877bf0b0-69be-4bec-9c75-1c676c68862b"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"AA", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"B", " "}], 
        RowBox[{" ", 
         RowBox[{"A", "'"}]}]], GridBox[{
         {
          RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"C", "D", 
              RowBox[{"C", "'"}], 
              RowBox[{"D", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
      $CellContext`CDe[-$CellContext`B, $CellContext`A\[Dagger]][
       $CellContext`PhiCDe[-C, -
        D, -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"BA", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"A", " "}], 
        RowBox[{" ", 
         RowBox[{"A", "'"}]}]], GridBox[{
         {
          RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"C", "D", 
              RowBox[{"C", "'"}], 
              RowBox[{"D", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`B, -$CellContext`A\[Dagger]][
      $CellContext`CDe[-$CellContext`A, $CellContext`A\[Dagger]][
       $CellContext`PhiCDe[-C, -
        D, -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]]]],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[188]=",ExpressionUUID->"99d032a9-ab1a-4e01-a708-63d4f8434038"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCurvature", "[", 
  RowBox[{"%%", ",", "BoxCDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.425967001719009*^9, 3.425967014123554*^9}, {
  3.4259809800497026`*^9, 3.425980981295596*^9}},
 CellLabel->
  "In[189]:=",ExpressionUUID->"f3234a62-6429-44d4-868d-e048ac25d2be"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A", "B", 
             RowBox[{"A", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`A\
\[Dagger], -$CellContext`C\[Dagger]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", 
            RowBox[{"A", "'"}], " "},
           {"C", "D", " ", 
            RowBox[{"D", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-C, -
     D, $CellContext`A\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", 
            RowBox[{"A", "'"}], 
            RowBox[{"D", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`A\
\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", 
            RowBox[{"A", "'"}]},
           {"C", "D", 
            RowBox[{"C", "'"}], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-C, -
     D, -$CellContext`C\[Dagger], $CellContext`A\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   Inte