(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   2215969,      58574]
NotebookOptionsPosition[   1800961,      50416]
NotebookOutlinePosition[   2158080,      57668]
CellTagsIndexPosition[   2157954,      57661]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xAct`SymManipulator`",
 FontSize->18]], "Section",
 CellChangeTimes->{{3.517827498714615*^9, 3.5178275026778417`*^9}, 
   3.5449509676140966`*^9, 3.545113834839494*^9},
 CellTags->{
  "S5.18.1", "1.1"},ExpressionUUID->"d1490cc5-1a35-4d9b-ae44-866766efe2cc"],

Cell[TextData[{
 "This is the doc file SymManipulatorDoc.nb of version 0.9.6 of ",
 StyleBox["SymManipulator`",
  FontFamily->"Courier"],
 ". Last update on 30 April 2024."
}], "Text",
 CellChangeTimes->{{3.5440980457424126`*^9, 3.5440980572864323`*^9}, 
   3.5441069826921096`*^9, 3.5446249232861347`*^9, 3.5446737839793463`*^9, {
   3.544936359805831*^9, 3.544936362847836*^9}, 3.5449509676140966`*^9, 
   3.545113834839494*^9, {3.567936294507034*^9, 3.567936305536253*^9}, 
   3.5681239033455863`*^9, {3.5921201450158834`*^9, 3.5921201644159102`*^9}, {
   3.5921272361708107`*^9, 3.592127236310811*^9}, 3.5922248920355754`*^9, {
   3.5981797977473946`*^9, 3.5981798088174105`*^9}, {3.5981904726583953`*^9, 
   3.5981904730483956`*^9}, {3.59955059954128*^9, 3.599550602130884*^9}, {
   3.620804314241604*^9, 3.6208043255816193`*^9}, {3.6801022937272253`*^9, 
   3.6801023059272428`*^9}, {3.7290602306727047`*^9, 3.729060237344714*^9}, {
   3.838805761286821*^9, 3.8388057716850023`*^9}, {3.8396735623753076`*^9, 
   3.8396735666831646`*^9}, {3.956191108090376*^9, 3.95619114249387*^9}},
 FontWeight->"Plain",ExpressionUUID->"b64ffabd-0926-45f7-a133-8b55e41e5440"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Author",
 FontSize->14]], "SubsectionIcon",
 CellChangeTimes->{{3.424426880141967*^9, 3.424426883047801*^9}, {
   3.424426923913391*^9, 3.4244269247484827`*^9}, {3.424426974893358*^9, 
   3.424426975865028*^9}, 3.517834341487999*^9, 3.5449509676140966`*^9, 
   3.545113834839494*^9},ExpressionUUID->"4e288bbd-8b80-4499-9a65-\
9c129a70ca40"],

Cell[TextData[{
 "\[Copyright] 2011-2024, under the GNU General Public License (GPL)\n    ",
 StyleBox[" Thomas B\[ADoubleDot]ckdahl\n     ",
  FontWeight->"Bold"],
 StyleBox["thomas.backdahl@chalmers.se",
  FontFamily->"Courier"]
}], "Text",
 CellChangeTimes->{{3.4244266920915747`*^9, 3.424426737145401*^9}, 
   3.424426994904422*^9, {3.461419841463036*^9, 3.461419912409233*^9}, {
   3.517827549204503*^9, 3.517827688134449*^9}, {3.5440980610616393`*^9, 
   3.5440980622940416`*^9}, 3.5449509676140966`*^9, 3.545113834839494*^9, 
   3.5679363086562586`*^9, {3.59212019288595*^9, 3.5921202419560184`*^9}, 
   3.598179811907415*^9, 3.680102309937248*^9, {3.6801023477406216`*^9, 
   3.6801023749506598`*^9}, {3.7290602710307617`*^9, 3.729060276261769*^9}, {
   3.8388057775453267`*^9, 3.8388057777727394`*^9}, {3.839673615827207*^9, 
   3.8396736177331114`*^9}, {3.956191164201212*^9, 3.9561911772657566`*^9}},
 FontWeight->"Plain",ExpressionUUID->"85b1df6a-4a12-4d5a-ac96-ae370f219434"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Intro",
 FontSize->14]], "SubsectionIcon",
 CellChangeTimes->{{3.424426880141967*^9, 3.424426883047801*^9}, {
   3.424426923913391*^9, 3.4244269247484827`*^9}, 3.5449509676140966`*^9, 
   3.545113834839494*^9},ExpressionUUID->"83c25893-400a-4bd6-81be-\
51f6dcde46da"],

Cell[TextData[{
 StyleBox["SymManipulator`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 " ",
 StyleBox["is the",
  FontWeight->"Plain"],
 " ",
 StyleBox["xAct`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 StyleBox[" package for computations with ",
  FontWeight->"Plain"],
 StyleBox["symmetrized tensor expressions",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[". By a symmetrized tensor expression we mean a sum of tensors \
where each term is the original expression with the indices permuted. We \
require the set of permutations to form a group. We call this group the ",
  FontWeight->"Plain"],
 StyleBox["imposed symmetry group",
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[". It is a group of signed permutations. The sign of the \
permutation gives the sign of the corresponding term. ",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.5178276960158997`*^9, 3.517827849718691*^9}, {
   3.5178286257860794`*^9, 3.517828762730912*^9}, {3.5178287990619907`*^9, 
   3.517828799244001*^9}, {3.51782889223532*^9, 3.5178289163476987`*^9}, {
   3.517828947014453*^9, 3.517828991143977*^9}, {3.5178290241838665`*^9, 
   3.517829101733302*^9}, {3.517829146960889*^9, 3.5178291681291*^9}, 
   3.5449509676140966`*^9, 3.545113834839494*^9},
 TextJustification->1.,ExpressionUUID->"7e857980-1976-46fa-8717-a401b038368b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Load the package",
 FontSize->14]], "SubsectionIcon",
 CellChangeTimes->{{3.424426880141967*^9, 3.424426913936936*^9}, 
   3.5449509676140966`*^9, 
   3.545113834839494*^9},ExpressionUUID->"01700a4c-c95d-4cb3-8c67-\
98628ed1ddf0"],

Cell[TextData[{
 "This loads the package from the default directory, for example $Home/.",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "/Applications/xAct/ for a single-user installation under Linux.  "
}], "MathCaption",
 CellChangeTimes->{3.5449509676140966`*^9, 3.545113834839494*^9},
 CellTags->{
  "S5.18.1", "1.3"},ExpressionUUID->"c7458626-e8fe-4506-bc28-fd0660a1d718"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellChangeTimes->{3.5449509676140966`*^9, 3.545113834839494*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"653ee98d-7fd0-4157-af3b-1c4f60c8cbdd"],

Cell[BoxData["67959792"], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"a9ee7f31-1562-4f1d-a349-c33c37ed8709"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`SymManipulator`"}]], "Input",
 CellChangeTimes->{{3.544950610216469*^9, 3.544950614194476*^9}, 
   3.5449509676140966`*^9, 3.545113834839494*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"d373a952-8d0e-4869-9df2-a64ed00bca8d"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"73c3be8b-d89e-48a5-99cd-45a370222184"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"b41ff7f6-5276-4688-aabf-821fc423bdc3"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"7abc496c-8340-4199-b68b-9f817883e05a"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"cd24fa5a-965a-4979-86ed-6bcedec340d7"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"e0fe7365-f69e-495e-9d94-c73df0fd0d67"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"675db0fe-528d-4bf9-b564-17502cab92cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.3.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "7", ",", "26"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.3.0", ", ", {2025, 7, 26}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"24155d14-fb63-4ddf-8745-68407e79c4f9"],

Cell[BoxData["\<\"CopyRight (C) 2002-2025, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"549341b7-0d28-424d-9ded-c0c5bcfb7e44"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"2713343f-12c3-4224-8b69-79fd5555641e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SymManipulator`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.9.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2024", ",", "4", ",", "30"}], "}"}]}],
  SequenceForm[
  "Package xAct`SymManipulator`  version ", "0.9.6", ", ", {2024, 4, 30}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"ef2b1523-1b3e-491c-a48a-a2c8bedd8f06"],

Cell[BoxData["\<\"CopyRight (C) 2011-2021, Thomas B\[ADoubleDot]ckdahl, under \
the General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"63bc2278-5c2d-41d2-a02b-d41162e17346"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"c2689ef3-83f2-4efd-a1fd-7fd7a4c8e333"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"b201d9d5-cd12-4b63-98cf-4ce93986aa15"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"b13fbcd7-f2a1-4f7d-b584-db67988bef28"]
}, Open  ]],

Cell["\<\
To be able to export latex code, we load also load the TexAct package.\
\>", "MathCaption",
 CellChangeTimes->{
  3.5449509676140966`*^9, 3.545113834839494*^9, {3.5921203261361365`*^9, 
   3.5921203596061835`*^9}, {3.592120416266263*^9, 3.592120441976299*^9}},
 CellTags->{
  "S5.18.1", "1.3"},ExpressionUUID->"032eb43e-d121-4bd0-a721-02047f5d0a18"],

Cell[CellGroupData[{

Cell["<<xAct`TexAct`", "Input",
 CellChangeTimes->{{3.5178291908844013`*^9, 3.5178291961047*^9}, {
   3.5449506193580847`*^9, 3.5449506212456884`*^9}, 3.544950967629697*^9, 
   3.545113834870694*^9},
 CellTags->"S5.18.1",
 CellLabel->"In[3]:=",ExpressionUUID->"a5dbcc3d-fe22-4d84-85d4-5cc582d14d3f"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"e7e82a0f-39c2-40e1-97da-7257c3a38623"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`TexAct`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.4.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`TexAct`  version ", "0.4.3", ", ", {2021, 10, 28}],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"2556fc1a-4176-4ff5-afcf-a2fc62fdc374"],

Cell[BoxData["\<\"CopyRight (C) 2008-2021, Thomas B\[ADoubleDot]ckdahl, Jose \
M. Martin-Garcia and Barry Wardell, under the General Public License.\"\>"], \
"Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"567da1cc-d7c2-49f9-9c90-906e1909aa02"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"735faad6-2664-4584-a154-1dfaa0018b5c"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"6e595d63-4538-4905-b9eb-cb71f057c5f2"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"a20c701a-5b05-496c-90fe-402ec8f494bf"]
}, Open  ]],

Cell[TextData[{
 "Comparing, we see what the packages take in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 15.0:"
}], "MathCaption",ExpressionUUID->"b4df1f99-9fba-4325-8861-66c88298afb3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellChangeTimes->{{3.426849249129299*^9, 3.4268492521518297`*^9}, 
   3.544950967629697*^9, 3.545113834870694*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"1f3eff7c-33ac-430c-821f-3306d8446a52"],

Cell[BoxData["120426016"], "Output",
 CellLabel->"Out[4]=",ExpressionUUID->"ccf89cdc-cad5-4a9e-a976-6898d1e716aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Out", "[", "4", "]"}], "-", 
     RowBox[{"Out", "[", "1", "]"}]}], ")"}], "/", 
   RowBox[{"2", "^", "20"}]}], "//", "N"}]], "Input",
 CellChangeTimes->{3.544946898297149*^9, 3.544950967645297*^9, 
  3.545113834870694*^9},
 CellLabel->"In[5]:=",ExpressionUUID->"af76cabb-115a-43c3-8092-b59a322f5eb4"],

Cell[BoxData["50.03569030761719`"], "Output",
 CellLabel->"Out[5]=",ExpressionUUID->"dcb594f3-28c7-4dd7-982e-06b4c1986edf"]
}, Open  ]],

Cell[TextData[{
 "There are several contexts: ",
 StyleBox["xAct`SymManipulator`, xAct`xTensor`",
  FontFamily->"Courier"],
 ", ",
 StyleBox["xAct`xPerm`",
  FontFamily->"Courier"],
 " and ",
 StyleBox["xAct`xCore`",
  FontFamily->"Courier"],
 " contain the respective reserved words. ",
 StyleBox["System`",
  FontFamily->"Courier"],
 " contains ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s reserved words.  The current context ",
 StyleBox["Global`",
  FontFamily->"Courier"],
 " will contain your definitions and right now is empty. "
}], "MathCaption",
 CellChangeTimes->{{3.5178292973604918`*^9, 3.5178293016187353`*^9}, 
   3.544950967645297*^9, 
   3.545113834870694*^9},ExpressionUUID->"0961df1a-5bb9-488e-8130-\
51a58a20e216"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellChangeTimes->{3.544950967645297*^9, 3.545113834870694*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"54844bee-24cc-488e-ae63-7425f601cd9b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`TexAct`\"\>", ",", "\<\"xAct`SymManipulator`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[6]=",ExpressionUUID->"90416584-ee51-4948-87b6-1cd8df730ab7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "]"}]], "Input",
 CellChangeTimes->{3.544950967645297*^9, 3.545113834870694*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"43ae60b6-29e8-4bd0-a6cf-8b71abfca1ea"],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellLabel->"Out[7]=",ExpressionUUID->"719b0178-0cb8-4a0a-a2bd-76c7b712d5f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellChangeTimes->{
  3.544950967645297*^9, 3.5451138348862944`*^9, {3.956191196794567*^9, 
   3.9561911991592407`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"45e5f222-8477-4f2d-be23-1406c27f6609"],

Cell[BoxData[
 RowBox[{"Missing", "[", 
  RowBox[{"\<\"UnknownSymbol\"\>", ",", "\<\"Global`*\"\>"}], "]"}]], "Output",\

 CellLabel->"Out[8]=",ExpressionUUID->"8b5406c3-1c89-4070-8eca-48df273305e9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1. Example session", "SubsectionIcon",
 CellChangeTimes->{{3.424426880141967*^9, 3.424426883047801*^9}, {
   3.4244274844846907`*^9, 3.424427485004201*^9}, {3.42685892327719*^9, 
   3.426858926725419*^9}, 3.544950967645297*^9, 
   3.5451138348862944`*^9},ExpressionUUID->"95c64344-11de-404a-8408-\
9d4f98f2fc68"],

Cell["\<\
All parts of the package, except the spinor tools works for all dimensions. \
At the moment only abstract indices can be used.\
\>", "Text",
 CellChangeTimes->{
  3.544950967645297*^9, 3.5451138348862944`*^9, {3.5921205425164394`*^9, 
   3.592120570116478*^9}},
 FontWeight->"Plain",ExpressionUUID->"eb02aaee-4bba-4580-8578-4af5db509335"],

Cell[CellGroupData[{

Cell["Basic examples", "SubsubsectionIcon",
 CellChangeTimes->{{3.5178337823220167`*^9, 3.5178338140128293`*^9}, 
   3.544950967645297*^9, 
   3.5451138348862944`*^9},ExpressionUUID->"0524233a-6be7-4cc1-9bff-\
da11673a1440"],

Cell["\<\
To avoid long messages we turn off all messages about definitions.\
\>", "MathCaption",
 CellChangeTimes->{{3.42166720033285*^9, 3.421667203989368*^9}, 
   3.544950967645297*^9, 3.5451138348862944`*^9, {3.5921208689668965`*^9, 
   3.592120898596938*^9}, {3.5921209566970196`*^9, 
   3.5921210034170847`*^9}},ExpressionUUID->"7dfb4027-0666-4349-9515-\
a2fc67152caf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.5921209640570297`*^9, 3.5921209709970393`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"efca1720-defa-42a6-aa8f-e3c0b2701008"],

Cell[TextData[{
 "Definition of a four dimensional  manifold ",
 StyleBox["M4",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",
 CellChangeTimes->{{3.42166720033285*^9, 3.421667203989368*^9}, 
   3.544950967645297*^9, 
   3.5451138348862944`*^9},ExpressionUUID->"74bf8d58-a63f-42f9-91ab-\
9968eb55355b"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M4", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p", ",", "q", ",", "r",
      ",", "m", ",", "l", ",", "h", ",", "j", ",", "n", ",", "t", ",", "s"}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.422186457176779*^9, 3.42218645874576*^9}, 
   3.544950967645297*^9, 3.5451138348862944`*^9},
 CellLabel->"In[10]:=",ExpressionUUID->"b93659fb-7488-4e69-82f0-34b8aa088f45"],

Cell["\<\
For most things we don\[CloseCurlyQuote]t need a metric so we do not need to \
define one now.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829939759235*^9}, 
   3.544950967645297*^9, 3.5451138348862944`*^9},
 TextJustification->1.,ExpressionUUID->"547aa1ec-267b-40f7-8137-65564700dc02"],

Cell["We define a tensor without symmetries:", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, 3.544950967645297*^9, 
   3.5451138349018946`*^9},
 TextJustification->1.,ExpressionUUID->"46698fa1-15ed-49cf-ad00-180fba7a411f"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.517830145598008*^9, 3.517830156454629*^9}, 
   3.544950967660897*^9, 3.5451138349018946`*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"b5070528-c4a8-41d4-9aee-d33cbf60af9b"],

Cell["\<\
If we want to completely symmetrize T, we can do it using just xTensor:\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, 3.544950967660897*^9, 3.5451138349018946`*^9},
 TextJustification->1.,ExpressionUUID->"8b9e986e-1639-4149-b8f1-1cd1af2953a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymTexpr1", "=", 
  RowBox[{"ImposeSymmetry", "[", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], ",", 
    RowBox[{"IndexList", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], ",", 
    RowBox[{"Symmetric", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5178302753504295`*^9, 3.517830296747653*^9}, {
   3.5178303818725224`*^9, 3.5178303921431093`*^9}, {3.5178305056676025`*^9, 
   3.5178305278678727`*^9}, 3.544950967660897*^9, 3.5451138349018946`*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"46e8c773-8513-4a10-816c-4977335101f0"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`c, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`c, -$CellContext`d, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "c", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`c, -$CellContext`a, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "c", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`c, -$CellContext`d, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "d", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`d, -$CellContext`a, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "d", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`d, -$CellContext`c, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`b, -$CellContext`a, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`b, -$CellContext`d, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`d, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`a, -$CellContext`c, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`b, -$CellContext`a, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`b, -$CellContext`c, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`c, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`c, -$CellContext`b, \
-$CellContext`a],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[12]=",ExpressionUUID->"655eaa36-e70d-4030-be8c-b9c8653ca12d"]
}, Open  ]],

Cell["\<\
This representation is often inconvenient to use so we can impose the \
symmetry abstractly instead using ImposeSym:\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, 3.5449509676764965`*^9, 
   3.5451138349174943`*^9},
 TextJustification->1.,ExpressionUUID->"95ed5afc-565f-4ca9-8cc8-14f64ba61d78"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymTexpr2", "=", 
  RowBox[{"ImposeSym", "[", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], ",", 
    RowBox[{"IndexList", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], ",", 
    RowBox[{"Symmetric", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5178302753504295`*^9, 3.517830296747653*^9}, {
   3.517830446582223*^9, 3.5178304535116196`*^9}, {3.5178305354503064`*^9, 
   3.5178305380234537`*^9}, 3.5449509676764965`*^9, 3.5451138349174943`*^9},
 CellLabel->"In[13]:=",ExpressionUUID->"1887b011-f020-4f84-b83c-71515b04427f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "1234", ")"}],
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   Symmetric[{1, 2, 3, 4}], 
   "(1234)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[13]=",ExpressionUUID->"12525705-f44b-480e-a143-28f0aa03be61"]
}, Open  ]],

Cell["\<\
The label (1234) means that the symmetrization is taken over the slots 1, 2, \
3 and 4. \
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.5178308827841725`*^9, 
   3.5178309453837533`*^9}, 3.5449509676920967`*^9, 3.5451138349174943`*^9},
 TextJustification->1.,ExpressionUUID->"446a3d6b-9da3-4870-b2e0-c0361d8ca25d"],

Cell["\<\
We can manipulate this expression, and only expand it when we need to. We \
expand it with ExpandSym:\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.5178305713463593`*^9, 
   3.517830639631265*^9}, 3.5449509676920967`*^9, 3.5451138349174943`*^9},
 TextJustification->1.,ExpressionUUID->"879c4c21-f8e1-4497-b461-262ef647ad5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandSym", "@", "SymTexpr2"}]], "Input",
 CellChangeTimes->{{3.5178302753504295`*^9, 3.517830296747653*^9}, {
   3.517830446582223*^9, 3.5178304535116196`*^9}, {3.5178305354503064`*^9, 
   3.5178305380234537`*^9}, {3.51783064601263*^9, 3.51783066436368*^9}, 
   3.5449509676920967`*^9, 3.5451138349330945`*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"167a8b56-d81d-47ba-af1f-46dcf5d1edd5"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`c, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`c, -$CellContext`d, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "c", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`c, -$CellContext`a, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "c", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`c, -$CellContext`d, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "d", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`d, -$CellContext`a, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "d", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`d, -$CellContext`c, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`b, -$CellContext`a, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`b, -$CellContext`d, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`d, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`a, -$CellContext`c, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`b, -$CellContext`a, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`b, -$CellContext`c, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`c, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`c, -$CellContext`b, \
-$CellContext`a],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[14]=",ExpressionUUID->"7d6ad728-edfa-4c79-bf2b-db5c5fcfdac9"]
}, Open  ]],

Cell["We can check that this is the same as ImposeSymmetry:", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.5178305713463593`*^9, 
   3.517830639631265*^9}, {3.5178306933393373`*^9, 3.5178307306944733`*^9}, 
   3.544950967707697*^9, 3.5451138349330945`*^9},
 TextJustification->1.,ExpressionUUID->"2c61b648-ff7c-490d-98a1-6a7054fae5ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"%", "-", "SymTexpr1"}], "]"}]], "Input",
 CellChangeTimes->{{3.5178302753504295`*^9, 3.517830296747653*^9}, {
   3.517830446582223*^9, 3.5178304535116196`*^9}, {3.5178305354503064`*^9, 
   3.5178305380234537`*^9}, {3.51783064601263*^9, 3.51783066436368*^9}, {
   3.517830734279679*^9, 3.5178307568609705`*^9}, 3.544950967707697*^9, 
   3.5451138349330945`*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"3b9e6e6e-d392-4e99-b4ea-0c90a4094440"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[15]=",ExpressionUUID->"bf922529-932e-4c3a-94cb-1ca664ecf8aa"]
}, Open  ]],

Cell["\<\
The symmetrized expression is treated as a tensor. That is most xTensor tools \
will work on it. A new tensor is not defined, so all information is carried \
in the head of the symmetrized object.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.5178305713463593`*^9, 
   3.517830639631265*^9}, {3.517831027514451*^9, 3.517831099615575*^9}, {
   3.5178311697245846`*^9, 3.51783122471173*^9}, 3.544950967707697*^9, 
   3.545113834948694*^9},
 TextJustification->1.,ExpressionUUID->"4ba074c3-9dd7-4e9c-95d6-db3c3ce8dd17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "@", "SymTexpr2"}]], "Input",
 CellChangeTimes->{{3.517831134829589*^9, 3.5178311356616364`*^9}, 
   3.544950967707697*^9, 3.545113834948694*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"221f0b15-80d5-45a7-b161-a1a0761adbc9"],

Cell[BoxData[
 RowBox[{"SymH", "[", 
  RowBox[{
   RowBox[{"{", "T", "}"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
   ",", "\<\"(1234)\"\>"}], "]"}]], "Output",
 CellLabel->"Out[16]=",ExpressionUUID->"1adbc31e-3867-4260-b334-a90646510acb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTensorQ", "@", "%"}]], "Input",
 CellChangeTimes->{{3.517831230044035*^9, 3.5178312342762766`*^9}, 
   3.544950967707697*^9, 3.545113834948694*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"ec78961e-d1bb-4632-9a0b-2eaddb03120d"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[17]=",ExpressionUUID->"f0e9bfed-fd2a-42d2-9d94-a62425d33af9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "@", "%%"}]], "Input",
 CellChangeTimes->{{3.517831246532978*^9, 3.5178312604467735`*^9}, 
   3.544950967707697*^9, 3.545113834948694*^9},
 CellLabel->"In[18]:=",ExpressionUUID->"5878b98c-8c4d-4a9f-9963-8d7b4b636121"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"(", "1", ",", "2", ")"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xPerm`Cycles[{1, 2}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[
       RowBox[{"(", "2", ",", "3", ")"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xPerm`Cycles[{2, 3}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[
       RowBox[{"(", "3", ",", "4", ")"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xPerm`Cycles[{3, 4}],
      Editable->False]}], "]"}]}], "]"}]], "Output",
 CellLabel->"Out[18]=",ExpressionUUID->"9c20d5b0-c1f1-44ef-82a3-c05a7a1ef5e8"]
}, Open  ]],

Cell["The canonicalizer can therefore work on SymH objects:", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.5178305713463593`*^9, 
   3.517830639631265*^9}, {3.517831027514451*^9, 3.517831099615575*^9}, {
   3.5178311697245846`*^9, 3.51783122471173*^9}, {3.517831308149502*^9, 
   3.5178313477497673`*^9}, 3.544950967707697*^9, 3.545113834948694*^9},
 TextJustification->1.,ExpressionUUID->"ff78c961-4810-42a8-850e-a7f0198faa4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymTexpr2", "+", 
  RowBox[{"(", 
   RowBox[{"SymTexpr2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], "->", 
       RowBox[{"-", "b"}]}], ",", 
      RowBox[{
       RowBox[{"-", "b"}], "->", 
       RowBox[{"-", "a"}]}]}], "}"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.5178313571183033`*^9, 3.5178313820687304`*^9}, 
   3.544950967707697*^9, 3.545113834948694*^9},
 CellLabel->"In[19]:=",ExpressionUUID->"8b6331ae-b54a-43c1-9130-70a7ddf01eca"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "1234", ")"}],
          FontSize->Tiny]], "[", "T", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`T}, 
    Symmetric[{1, 2, 3, 4}], 
    "(1234)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "1234", ")"}],
          FontSize->Tiny]], "[", "T", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"b", "a", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`T}, 
    Symmetric[{1, 2, 3, 4}], 
    "(1234)"][-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[19]=",ExpressionUUID->"7083faf6-2403-41ca-8555-5e027b90c53a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5178313845948744`*^9, 3.517831389029128*^9}, 
   3.544950967707697*^9, 3.5451138349642944`*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"a3461cab-3c77-44c8-8041-febdb3d9067e"],

Cell[BoxData[
 RowBox[{"2", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "1234", ")"}],
          FontSize->Tiny]], "[", "T", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`T}, 
    Symmetric[{1, 2, 3, 4}], 
    "(1234)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[20]=",ExpressionUUID->"7cb8eeed-92ae-4fe0-9138-a25548c17830"]
}, Open  ]],

Cell["\<\
Other groups can also be imposed. For instance symmetrize over -a,-c and \
antisymmetrize over -b,-d:\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 3.5178317378400793`*^9}, 
   3.544950967707697*^9, 3.5451138349642944`*^9},
 TextJustification->1.,ExpressionUUID->"3474bf7b-6d5e-460c-b79e-eea13e68eb4e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}], "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5178302753504295`*^9, 3.517830296747653*^9}, {
   3.517830446582223*^9, 3.5178304535116196`*^9}, {3.5178305354503064`*^9, 
   3.5178305380234537`*^9}, {3.5178314775681925`*^9, 3.5178315505203648`*^9}, 
   3.5178317119595985`*^9, {3.5178317427483597`*^9, 3.517831744897483*^9}, {
   3.519299889460953*^9, 3.5192998918477573`*^9}, 3.544950967723297*^9, 
   3.5451138349642944`*^9},
 CellLabel->"In[21]:=",ExpressionUUID->"441dd05e-7bb8-49b0-81af-801612c0ba71"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{
          RowBox[{"(", "13", ")"}], "[", "24", "]"}],
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   xAct`xPerm`StrongGenSet[{1, 2, 3, 4}, 
    xAct`xPerm`GenSet[-xAct`xPerm`Cycles[{2, 4}], 
     xAct`xPerm`Cycles[{1, 3}]]], 
   "(13)[24]"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[21]=",ExpressionUUID->"d00ec78b-8141-4cea-8b2e-ef98fbb12824"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5178316837109833`*^9, 3.5178317093654504`*^9}, 
   3.544950967723297*^9, 3.5451138349642944`*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"9c23149b-f3dd-44a9-8962-fc88600d7749"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`b, -$CellContext`a, \
-$CellContext`d],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`d, -$CellContext`a, \
-$CellContext`b],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[22]=",ExpressionUUID->"2ceb2e14-bbac-46ea-ae78-6af6169443ec"]
}, Open  ]],

Cell["\<\
If the group has more complicaed structure, the label only shows the slots \
involved.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.5178305713463593`*^9, 
   3.517830639631265*^9}, {3.5178306933393373`*^9, 3.5178307306944733`*^9}, {
   3.5178328895359526`*^9, 3.5178329125692697`*^9}, {3.5178329568368015`*^9, 
   3.5178330083567486`*^9}, 3.544950967723297*^9, 3.5451138349642944`*^9},
 TextJustification->1.,ExpressionUUID->"6bbcf599-fad9-4756-bb46-18e21ad4ad07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"RiemannSymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{3.5178328782313056`*^9, 3.544950967723297*^9, 
  3.5451138349642944`*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"3a22a24d-7920-4d06-a912-41befed9c737"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox["1234",
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   xAct`xPerm`StrongGenSet[{1, 2, 3, 4}, 
    xAct`xPerm`GenSet[-xAct`xPerm`Cycles[{3, 4}], -xAct`xPerm`Cycles[{1, 2}], 
     
     xAct`xPerm`Cycles[{1, 3}, {2, 4}]]], 
   "1234"][-$CellContext`a, -$CellContext`b, -$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[23]=",ExpressionUUID->"f7e70325-9913-4967-a768-182a60bd6b00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5178316837109833`*^9, 3.5178317093654504`*^9}, 
   3.544950967723297*^9, 3.5451138349642944`*^9},
 CellLabel->"In[24]:=",ExpressionUUID->"6c4426d3-9601-4ffe-8849-dd6f32c963f3"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`d, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
-$CellContext`a],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`c, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`d, -$CellContext`c, -$CellContext`b, \
-$CellContext`a],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[24]=",ExpressionUUID->"fcca9e84-77c2-4239-a0b5-b7b8ee854ced"]
}, Open  ]],

Cell["\<\
TexAct package can produce a nice TeX code output if the symmetrized object \
is possible to write in a nice way. \
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.5187562894931974`*^9, 
   3.5187563484301014`*^9}, 3.544950967723297*^9, {3.545112677924862*^9, 
   3.545112754817397*^9}, 3.5451138349798946`*^9},
 TextJustification->1.,ExpressionUUID->"88d1581d-acf7-4a2c-9036-0009f44f6081"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5187563760421495`*^9, 3.5187563889277725`*^9}, {
   3.518756431359847*^9, 3.5187564486914773`*^9}, 3.544950967723297*^9, 
   3.5451138349798946`*^9},
 CellLabel->"In[25]:=",ExpressionUUID->"f530befc-c180-4399-a044-960ac1bfac68"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"[", "123", "]"}],
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   Antisymmetric[{1, 2, 3}], 
   "[123]"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[25]=",ExpressionUUID->"817c93fe-ecdd-475a-a6e6-679659f24292"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.518756394309782*^9, 3.518756396072585*^9}, 
   3.5449509677388973`*^9, 3.5451138349798946`*^9},
 CellLabel->"In[26]:=",ExpressionUUID->"cba20955-960e-4bb5-be19-fb23c83299c5"],

Cell[BoxData["\<\"T_{[abc]d}\"\>"], "Output",
 CellLabel->"Out[26]=",ExpressionUUID->"e286de69-3d0b-401f-afbe-c4e27e2e0ba5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5187563760421495`*^9, 3.5187563889277725`*^9}, 
   3.5449509677388973`*^9, 3.5451138349798946`*^9},
 CellLabel->"In[27]:=",ExpressionUUID->"84996ac7-91fe-4445-a978-1eec32d73585"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "24", ")"}],
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {"a", " ", " ", " "},
         {" ", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   Symmetric[{2, 4}], 
   "(24)"][$CellContext`a, -$CellContext`b, -$CellContext`c, -$CellContext`d],
  
  Editable->False]], "Output",
 CellLabel->"Out[27]=",ExpressionUUID->"fafc8b6a-7f81-4e92-a71a-d75034d5bdba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.518756394309782*^9, 3.518756396072585*^9}, 
   3.5449509677388973`*^9, 3.5451138349798946`*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"dcd9b31e-d45d-443e-9c75-1fb82e7652e4"],

Cell[BoxData["\<\"T^{a}{}_{(b|c|d)}\"\>"], "Output",
 CellLabel->"Out[28]=",ExpressionUUID->"ba898a80-7a29-437d-99bd-2cc9c1c37f4d"]
}, Open  ]],

Cell["The internal tensor can also have symmetries. ", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, 3.5449509677388973`*^9, 
   3.5451138349798946`*^9},
 TextJustification->1.,ExpressionUUID->"e8b8c587-fc14-4a5d-9f19-32a739212e46"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", "M4", ",", " ", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5178318487984257`*^9, 3.517831914460181*^9}, 
   3.5449509677388973`*^9, 3.5451138349798946`*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"5e979bcb-ec5b-4ef3-b9b7-7b9e06f6b9c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymSexpr1", "=", 
  RowBox[{"ImposeSym", "[", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], ",", 
    RowBox[{"IndexList", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], ",", 
    RowBox[{"Symmetric", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5178319643780365`*^9, 3.5178319757886887`*^9}, {
   3.5440985564093094`*^9, 3.5440985583905125`*^9}, 3.5449509677388973`*^9, 
   3.5451138349798946`*^9},
 CellLabel->"In[30]:=",ExpressionUUID->"3a863d63-e5f7-4d27-81f0-6080949a77bd"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "12", ")"}],
         FontSize->Tiny]], "[", "S", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S}, 
   Symmetric[{1, 2}], 
   "(12)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[30]=",ExpressionUUID->"3efcaa2f-1ba2-47cd-8b79-c0e9e5571707"]
}, Open  ]],

Cell["\<\
Now the total symmetry is a mixture of the symmetry of S and the imposed \
symmetry.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.517832211768186*^9}, 
   3.5440981278141565`*^9, 3.5449509677388973`*^9, 3.5451138349798946`*^9},
 TextJustification->1.,ExpressionUUID->"33aafa9c-b28b-4700-a5eb-cfaa002952fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "@", 
  RowBox[{"Head", "@", "SymSexpr1"}]}]], "Input",
 CellChangeTimes->{{3.5178320511860013`*^9, 3.517832063111684*^9}, 
   3.5441070677278585`*^9, 3.5449509677388973`*^9, 3.5451138349798946`*^9},
 CellLabel->"In[31]:=",ExpressionUUID->"efea47a1-02a3-4cc2-8802-06f7d4ff7bbc"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"(", "3", ",", "4", ")"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xPerm`Cycles[{3, 4}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[
       RowBox[{"(", "1", ",", "2", ")"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xPerm`Cycles[{1, 2}],
      Editable->False]}], "]"}]}], "]"}]], "Output",
 CellLabel->"Out[31]=",ExpressionUUID->"9c182663-1a98-4e28-b7e7-aaf869d8e5fa"]
}, Open  ]],

Cell["\<\
The calculation of this symmetry has special codes for the cases when the \
imposed symmetry is the symmetric or antisymmetric group on some indices. In \
all other cases, a more time consuming code is used to compute the mixed \
symmetry.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.544098159482212*^9, 
   3.5440982318351393`*^9}, 3.5449509677388973`*^9, 3.5451138349954944`*^9},
 TextJustification->1.,ExpressionUUID->"db5220a6-d133-4728-8c72-8ecc44b341e0"],

Cell["\<\
If the tensor already has the the imposed symmetry, it is automatically \
simplified.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.517833333716358*^9, 3.517833384402257*^9}, 3.5449509677388973`*^9, 
   3.5451138349954944`*^9},
 TextJustification->1.,ExpressionUUID->"33c447b2-25e0-4ce6-bfca-00411cba12a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5178327021112323`*^9, 3.517832729051773*^9}, {
   3.517833324228815*^9, 3.517833326794962*^9}, 3.5449509677388973`*^9, 
   3.5451138349954944`*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"2816f737-2485-4626-bcb3-f31209559f5f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[32]=",ExpressionUUID->"88bdbb9b-1a3f-4fd4-93bb-ab22e71c7c0e"]
}, Open  ]],

Cell["\<\
If one antisymmetrizes over a pair of symmetric slots, one will get zero. \
This idea have been generalized, and this is checked automatically by \
ImposeSym. This check works for any combination of groups.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, 
   3.544950967754497*^9, 3.5451138349954944`*^9},
 TextJustification->1.,ExpressionUUID->"f06cd2f5-30c1-4b91-b75e-f19ae8997055"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5178327021112323`*^9, 3.517832729051773*^9}, 
   3.544950967754497*^9, 3.5451138349954944`*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"56ad814a-b2c0-41f3-bce7-f27185260904"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[33]=",ExpressionUUID->"ff620079-8bee-4878-844e-286a44ad5819"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"RiemannSymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.517832795399568*^9, 3.517832830647584*^9}, 
   3.544950967754497*^9, 3.5451138349954944`*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"d35d644a-61f4-4eb8-b49f-a74982891d25"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[34]=",ExpressionUUID->"d9058096-07ba-41d6-953f-a9c02e351635"]
}, Open  ]],

Cell["\<\
Sometimes the expansion of a symmetry gives many more terms than need due to \
the internal symmetry. \
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.5440985929445734`*^9, 3.5440986233490267`*^9}, {3.544098751113251*^9, 
   3.5440987706600857`*^9}, 3.544950967754497*^9, 3.5451138349954944`*^9},
 TextJustification->1.,ExpressionUUID->"5cdcc708-ed24-455a-86cd-4325d60f9c52"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymSexpr2", "=", 
  RowBox[{"ImposeSym", "[", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], ",", 
    RowBox[{"IndexList", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5440985098120275`*^9, 3.544098515443637*^9}, {
   3.544098578608148*^9, 3.544098584161758*^9}, 3.544950967754497*^9, 
   3.5451138349954944`*^9},
 CellLabel->"In[35]:=",ExpressionUUID->"b3a949bf-fd98-47d4-834e-aa672d1c2b19"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "1234", ")"}],
         FontSize->Tiny]], "[", "S", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S}, 
   Symmetric[{1, 2, 3, 4}], 
   "(1234)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[35]=",ExpressionUUID->"ca2888ad-7d71-47f0-8652-a344d2d448d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandSym", "@", "SymSexpr2"}]], "Input",
 CellChangeTimes->{3.5440985877809644`*^9, 3.544950967754497*^9, 
  3.5451138349954944`*^9},
 CellLabel->"In[36]:=",ExpressionUUID->"2623a0a4-4532-4f5c-bb8d-f95fe809af7c"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`c, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`c, -$CellContext`d, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "c", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`c, -$CellContext`a, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "c", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`c, -$CellContext`d, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "d", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`d, -$CellContext`a, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "d", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`d, -$CellContext`c, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`b, -$CellContext`a, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`b, -$CellContext`d, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`d, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`a, -$CellContext`c, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`b, -$CellContext`a, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`b, -$CellContext`c, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`c, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`c, -$CellContext`b, \
-$CellContext`a],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[36]=",ExpressionUUID->"7ea6c12d-3a21-4256-b033-aded7c7771bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5440986619902945`*^9, 3.544098663784298*^9}, 
   3.544950967770097*^9, 3.545113835011094*^9},
 CellLabel->"In[37]:=",ExpressionUUID->"866de3d6-aa3c-4f22-ba55-004aec16edc9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "a", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "a", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "a", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[37]=",ExpressionUUID->"51f8d548-94f8-45e7-a29f-9fb532ebe0dd"]
}, Open  ]],

Cell[TextData[{
 "Then one can give the option SmartExpand->True. Instead of computing all \
elements of the imposed symmetry group, only a transversal is computed. This \
is a ",
 StyleBox["new feature",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " in release 0.8.3 and not very well tested."
}], "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.5440985929445734`*^9, 3.5440986233490267`*^9}, {3.5440987114735813`*^9, 
   3.544098727120409*^9}, {3.5440987889589176`*^9, 3.5440989277679615`*^9}, {
   3.5440989617448215`*^9, 3.544098975940846*^9}, 3.5441070773686757`*^9, 
   3.544950967770097*^9, 3.545113835011094*^9, {3.5921206354065695`*^9, 
   3.592120636196571*^9}},
 TextJustification->1.,ExpressionUUID->"613be5c8-34f5-4535-b32e-3364ba83dc49"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandSym", "[", 
  RowBox[{"SymSexpr2", ",", 
   RowBox[{"SmartExpand", "->", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544098672005512*^9, 3.5440986795091257`*^9}, 
   3.544950967770097*^9, 3.545113835011094*^9},
 CellLabel->"In[38]:=",ExpressionUUID->"28543147-61c3-45fa-9e2a-a9418d0ec6c9"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[38]=",ExpressionUUID->"e2b3ae30-0c05-48ee-8940-4fe4ec34e92f"]
}, Open  ]],

Cell[TextData[{
 "This idea is used in the new commands SmartSymmetrize and \
SmartAntisymmetrize. They do the same thing as Symmetrize and Antisymmetrize, \
but number of terms is reduced by taking the internal symmetry into \
consideration. Observe that this is a ",
 StyleBox["new feature",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " in release 0.8.3 and not very well tested."
}], "MathCaption",
 CellChangeTimes->{{3.5446738462399073`*^9, 3.5446738536943336`*^9}, {
   3.544673888203307*^9, 3.544674055018849*^9}, {3.5446743003648815`*^9, 
   3.5446743282454767`*^9}, 3.544950967770097*^9, 
   3.545113835011094*^9},ExpressionUUID->"f04af80e-63eb-4013-b60f-\
8b4f38da4a40"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SmartSymmetrize", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5446738379264317`*^9, 3.5446738438257694`*^9}, 
   3.544950967770097*^9, 3.545113835011094*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"2356db80-0922-4cbc-b7a6-8e5a613b84c0"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[39]=",ExpressionUUID->"949a44b1-d18a-4aaf-a212-c96134d097f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symmetrize", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5446740915629387`*^9, 3.544674098835355*^9}, 
   3.544950967770097*^9, 3.545113835011094*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"05899448-8d41-4da2-bb29-a332b415c688"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`c, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`c, -$CellContext`d, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "c", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`c, -$CellContext`a, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "c", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`c, -$CellContext`d, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "d", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`d, -$CellContext`a, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "d", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`b, -$CellContext`d, -$CellContext`c, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`b, -$CellContext`a, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`b, -$CellContext`d, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`d, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`a, -$CellContext`c, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`b, -$CellContext`a, \
-$CellContext`c],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`b, -$CellContext`c, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`c, -$CellContext`a, \
-$CellContext`b],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[-$CellContext`d, -$CellContext`c, -$CellContext`b, \
-$CellContext`a],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[40]=",ExpressionUUID->"5d910a02-8e44-4361-8b8e-108792d1b304"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{3.5446741001954327`*^9, 3.544950967785697*^9, 
  3.5451138350266943`*^9},
 CellLabel->"In[41]:=",ExpressionUUID->"0d5efc1a-93db-47dd-9b04-09a24cee72e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "a", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "a", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "a", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[41]=",ExpressionUUID->"3aca9a6f-2cc7-439e-b5b2-cab0977eb1b8"]
}, Open  ]],

Cell["\<\
Product of tensors can be handled. In this case, interchange symmetries etc \
will be considered as usual.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.517833105376298*^9, 3.517833111672658*^9}, {3.517834123199514*^9, 
   3.517834149186*^9}, {3.517836297986904*^9, 3.5178363700010233`*^9}, {
   3.5178364014328213`*^9, 3.517836411976424*^9}, 3.544950967785697*^9, 
   3.5451138350266943`*^9},
 TextJustification->1.,ExpressionUUID->"be8ee72d-e2bd-42d7-84d9-aad8fa06e354"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "f"}], ",", 
      RowBox[{"-", "h"}], ",", 
      RowBox[{"-", "l"}], ",", 
      RowBox[{"-", "m"}]}], "]"}]}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "m"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.517833122076253*^9, 3.5178331383721848`*^9}, {
   3.517834155723374*^9, 3.5178342295635977`*^9}, 3.517834458238677*^9, 
   3.5178345181141014`*^9, 3.517836007177271*^9, {3.5178362532273445`*^9, 
   3.517836259859724*^9}, {3.5186735112723913`*^9, 3.518673539867242*^9}, 
   3.544950967785697*^9, 3.5451138350266943`*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"4df4378f-66e9-4711-b9ae-d476c5721f16"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "48", ")"}],
         FontSize->Tiny]], "[", "T", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"a", "b", "c", "d", "f", "h", "l", "m"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T, $CellContext`T}, 
   Symmetric[{4, 8}], 
   "(48)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d, -$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m],
  Editable->False]], "Output",
 CellLabel->"Out[42]=",ExpressionUUID->"83eea3a7-fc6c-4ac5-9bc9-ab8ad458b9fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "@", 
  RowBox[{"Head", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.5178342500077667`*^9, 3.517834264073571*^9}, 
   3.544950967785697*^9, 3.5451138350266943`*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"2d3e4fab-aa93-40e4-8b2d-a17fa3ce44b1"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"(", "4", ",", "8", ")"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xPerm`Cycles[{4, 8}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"(", "1", ",", "5", ")"}], 
        RowBox[{"(", "2", ",", "6", ")"}], 
        RowBox[{"(", "3", ",", "7", ")"}], 
        RowBox[{"(", "4", ",", "8", ")"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xPerm`Cycles[{1, 5}, {2, 6}, {3, 7}, {4, 8}],
      Editable->False]}], "]"}]}], "]"}]], "Output",
 CellLabel->"Out[43]=",ExpressionUUID->"a56b3bbf-4823-4e7d-8634-6b3888ce1a6a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "f"}], ",", 
      RowBox[{"-", "h"}], ",", 
      RowBox[{"-", "l"}], ",", 
      RowBox[{"-", "m"}]}], "]"}]}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "f"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{3.5178364518517056`*^9, 3.5186735042055793`*^9, 
  3.544950967801297*^9, 3.5451138350422945`*^9},
 CellLabel->"In[44]:=",ExpressionUUID->"427b47c0-72d4-49e6-84f7-4e88d067181f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "45", ")"}],
         FontSize->Tiny]], "[", "S", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"a", "b", "c", "d", "f", "h", "l", "m"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
   Symmetric[{4, 5}], 
   "(45)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d, -$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m],
  Editable->False]], "Output",
 CellLabel->"Out[44]=",ExpressionUUID->"a2e0251a-1b7d-4bd8-8a6f-66f7bc103ffc"]
}, Open  ]],

Cell["\<\
The order of the tensors is automatically sorted by ImposeSym.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178373698152094`*^9, 3.5178374100295095`*^9}, {
   3.5178381482817354`*^9, 3.5178381498278236`*^9}, {3.5180236708256216`*^9, 
   3.518023702197277*^9}, 3.544950967801297*^9, 
   3.5451138350422945`*^9},ExpressionUUID->"cc05cff7-f4de-4241-ab84-\
7491ac84ad94"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "f"}], ",", 
      RowBox[{"-", "h"}], ",", 
      RowBox[{"-", "l"}], ",", 
      RowBox[{"-", "m"}]}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "f"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.518023710714892*^9, 3.518023712056494*^9}, 
   3.5186735530336647`*^9, 3.544950967801297*^9, 3.5451138350422945`*^9},
 CellLabel->"In[45]:=",ExpressionUUID->"7bf63f45-9d50-4f82-a20e-8fb4421042af"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "45", ")"}],
         FontSize->Tiny]], "[", "S", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"a", "b", "c", "d", "f", "h", "l", "m"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
   Symmetric[{4, 5}], 
   "(45)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d, -$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m],
  Editable->False]], "Output",
 CellLabel->"Out[45]=",ExpressionUUID->"e21ebb7e-070f-4f88-9bf6-e565e0c54fa5"]
}, Open  ]],

Cell["\<\
If one would like to sort them alphabetically at any ther time one can use \
SortTensorsInSym\
\>", "MathCaption",
 CellChangeTimes->{{3.5178373698152094`*^9, 3.5178374492427526`*^9}, {
   3.5180237327109303`*^9, 3.5180237382801404`*^9}, 3.544950967801297*^9, 
   3.5451138350422945`*^9},ExpressionUUID->"ed9f756c-1663-4bc0-807c-\
d503d2583c2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"T", "->", "S"}], ",", 
    RowBox[{"S", "->", "T"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5180237461737537`*^9, 3.5180237571405735`*^9}, 
   3.544950967801297*^9, 3.5451138350422945`*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"b9a3e3d5-30e6-4407-82d1-0e638a60bf22"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "45", ")"}],
         FontSize->Tiny]], "[", "T", "S", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"a", "b", "c", "d", "f", "h", "l", "m"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T, $CellContext`S}, 
   Symmetric[{4, 5}], 
   "(45)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d, -$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m],
  Editable->False]], "Output",
 CellLabel->"Out[46]=",ExpressionUUID->"9f29ff3e-1d76-40b5-929b-62a0b7166ee0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortTensorsInSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.51783646015018*^9, 3.5178364712338133`*^9}, 
   3.517837416431876*^9, 3.5186735777285085`*^9, 3.544950967801297*^9, 
   3.5451138350422945`*^9},
 CellLabel->"In[47]:=",ExpressionUUID->"ed17dd7c-16ec-4ece-8e03-400d861127ec"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "18", ")"}],
         FontSize->Tiny]], "[", "S", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"f", "h", "l", "m", "a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
   Symmetric[{1, 8}], 
   "(18)"][-$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m, -$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[47]=",ExpressionUUID->"5346aae1-0678-49d3-b510-ea9d58007f5a"]
}, Open  ]],

Cell["\<\
If a tensor is inside the SymH object, but the symmetrization is not acting \
on its indices, one can move it outside the SymH object. \
\>", "MathCaption",
 CellChangeTimes->{{3.5178373698152094`*^9, 3.5178374492427526`*^9}, {
   3.5178379662863255`*^9, 3.517838033738184*^9}, {3.517838069985257*^9, 
   3.517838076827648*^9}, 3.5178382116923623`*^9, 3.544950967801297*^9, 
   3.5451138350422945`*^9},ExpressionUUID->"13ec1928-f301-44ea-bf88-\
eafa5ccdcc31"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "f"}], ",", 
      RowBox[{"-", "h"}], ",", 
      RowBox[{"-", "l"}], ",", 
      RowBox[{"-", "m"}]}], "]"}]}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5178379537506084`*^9, 3.517837955814727*^9}, 
   3.544950967801297*^9, 3.5451138350422945`*^9},
 CellLabel->"In[48]:=",ExpressionUUID->"d7d4d8e7-53b5-4dda-8525-d1b45745d224"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "12", ")"}],
         FontSize->Tiny]], "[", "S", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"a", "b", "c", "d", "f", "h", "l", "m"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
   Symmetric[{1, 2}], 
   "(12)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d, -$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m],
  Editable->False]], "Output",
 CellLabel->"Out[48]=",ExpressionUUID->"201cc258-d5b8-4dd0-989f-efde5ec27402"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoveTensorsOutsideSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.51783803839345*^9, 3.5178380509201665`*^9}, 
   3.544950967801297*^9, 3.5451138350422945`*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"53f51a95-5ebe-4804-9a09-a4a62fd01010"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"f", "h", "l", "m"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[-$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "12", ")"}],
          FontSize->Tiny]], "[", "S", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`S}, 
    Symmetric[{1, 2}], 
    "(12)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[49]=",ExpressionUUID->"b028ad60-ef8b-40e2-a52e-305147367900"]
}, Open  ]],

Cell["One can also move tensors inside the SymH object. ", "MathCaption",
 CellChangeTimes->{{3.5178373698152094`*^9, 3.5178374492427526`*^9}, {
   3.5178379662863255`*^9, 3.517838033738184*^9}, {3.517838069985257*^9, 
   3.517838076827648*^9}, {3.5178382116923623`*^9, 3.517838243932206*^9}, 
   3.5449509678168974`*^9, 
   3.5451138350422945`*^9},ExpressionUUID->"e6b7443e-5b11-4fa6-8187-\
3579464b4aec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoveTensorsInsideSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.517838089562377*^9, 3.5178380897153854`*^9}, 
   3.5449509678168974`*^9, 3.5451138350578947`*^9},
 CellLabel->"In[50]:=",ExpressionUUID->"7ec34cac-5757-4b54-a363-99ce5ce8ff8b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "12", ")"}],
         FontSize->Tiny]], "[", "S", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"a", "b", "c", "d", "f", "h", "l", "m"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
   Symmetric[{1, 2}], 
   "(12)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d, -$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m],
  Editable->False]], "Output",
 CellLabel->"Out[50]=",ExpressionUUID->"14c237cc-b885-4c0c-bb1d-6fb674670031"]
}, Open  ]],

Cell["Symmetrizations can be nested", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.517833105376298*^9, 3.517833111672658*^9}, 3.5449509678168974`*^9, 
   3.5451138350578947`*^9},
 TextJustification->1.,ExpressionUUID->"61ad08f4-ef62-4dc2-8345-ef3861aae280"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.517833122076253*^9, 3.5178331383721848`*^9}, 
   3.5449509678168974`*^9, 3.5451138350578947`*^9},
 CellLabel->"In[51]:=",ExpressionUUID->"5e8a1e47-caaf-47ee-a285-96941ab1b034"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "123", ")"}],
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   Symmetric[{1, 2, 3}], 
   "(123)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[51]=",ExpressionUUID->"fb81fde4-dcf4-4c03-bddc-56e38fe01560"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{"%", ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.517833122076253*^9, 3.5178331709710493`*^9}, 
   3.5449509678168974`*^9, 3.5451138350578947`*^9},
 CellLabel->"In[52]:=",ExpressionUUID->"efcf0015-2ab6-42be-ad47-1df5880be2f8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "34", ")"}],
         FontSize->Tiny]], "[", 
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "123", ")"}],
          FontSize->Tiny]], "[", "T", "]"}], "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{
    xAct`SymManipulator`SymH[{$CellContext`T}, 
     Symmetric[{1, 2, 3}], "(123)"]}, 
   Symmetric[{3, 4}], 
   "(34)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[52]=",ExpressionUUID->"e7fa7192-3e03-4ccc-aff3-f369345fd032"]
}, Open  ]],

Cell["ExpandSym only expands the outermost SymH object", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.517833105376298*^9, 3.517833111672658*^9}, {3.517833257110976*^9, 
   3.5178332739279385`*^9}, 3.5449509678168974`*^9, 3.5451138350578947`*^9},
 TextJustification->1.,ExpressionUUID->"db3b0180-2b56-4b81-b932-8d5b76c9083f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "@", 
  RowBox[{"ExpandSym", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.5178331981036015`*^9, 3.5178332285573435`*^9}, 
   3.5449509678168974`*^9, 3.5451138350578947`*^9},
 CellLabel->"In[53]:=",ExpressionUUID->"3a91ce5f-08c1-42b8-9891-a5d661e69919"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "123", ")"}],
           FontSize->Tiny]], "[", "T", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`T}, 
     Symmetric[{1, 2, 3}], 
     "(123)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "123", ")"}],
           FontSize->Tiny]], "[", "T", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`T}, 
     Symmetric[{1, 2, 3}], 
     "(123)"][-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[53]=",ExpressionUUID->"17e48b63-2c3d-42cc-b3a5-4e9c12e85bbd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "@", 
  RowBox[{"ExpandSym", "@", "%"}]}]], "Input",
 CellChangeTimes->{3.5178332323565607`*^9, 3.5449509678168974`*^9, 
  3.5451138350578947`*^9},
 CellLabel->"In[54]:=",ExpressionUUID->"b2caf6a7-abf5-4dba-a9f0-fd3af6c88cde"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "c", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`a, -$CellContext`c, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "d", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "a", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "a", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "c", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`b, -$CellContext`c, -$CellContext`a, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "d", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`b, -$CellContext`d, -$CellContext`a, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "a", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "b", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`c, -$CellContext`b, -$CellContext`a, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "a", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "b", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`d, -$CellContext`b, -$CellContext`a, \
-$CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[54]=",ExpressionUUID->"6f9c7e33-1ac1-40c4-9bff-d15432a2e885"]
}, Open  ]],

Cell["\<\
Sometimes, when nesting symmetries the inner symmetrization might not be \
needed because of the outer symmetrization. Then this can be removed by \
RemoveSuperfluousInnerSym\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.517833105376298*^9, 3.517833111672658*^9}, {3.517833294444112*^9, 
   3.5178332977142987`*^9}, {3.51783341697612*^9, 3.5178334889572372`*^9}, 
   3.517833534519843*^9, 3.544950967832497*^9, 3.545113835073495*^9, 
   3.956191587583252*^9},
 TextJustification->1.,ExpressionUUID->"59c97195-3c10-43f2-a2b3-5e13ba2312d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.517833122076253*^9, 3.5178331383721848`*^9}, 
   3.544950967832497*^9, 3.545113835073495*^9},
 CellLabel->"In[55]:=",ExpressionUUID->"06a0189d-a50e-4c20-8ee0-57970bee24b0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "123", ")"}],
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   Symmetric[{1, 2, 3}], 
   "(123)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[55]=",ExpressionUUID->"19f640b7-cf9d-42ab-a8f8-f96105a2f50d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{"%", ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.517833122076253*^9, 3.5178331709710493`*^9}, {
   3.5178335036300764`*^9, 3.5178335064092355`*^9}, 3.544950967832497*^9, 
   3.545113835073495*^9},
 CellLabel->"In[56]:=",ExpressionUUID->"731212ff-90bb-4d34-b98c-d3011fc2f0cd"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "1234", ")"}],
         FontSize->Tiny]], "[", 
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "123", ")"}],
          FontSize->Tiny]], "[", "T", "]"}], "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{
    xAct`SymManipulator`SymH[{$CellContext`T}, 
     Symmetric[{1, 2, 3}], "(123)"]}, 
   Symmetric[{1, 2, 3, 4}], 
   "(1234)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[56]=",ExpressionUUID->"ac0564dd-833e-4158-8664-d6975320af49"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RemoveSuperfluousInnerSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.517833509505412*^9, 3.5178335245242715`*^9}, 
   3.544950967832497*^9, 3.545113835073495*^9},
 CellLabel->"In[57]:=",ExpressionUUID->"1a6451fb-96cc-45ac-acba-57a073daf444"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "1234", ")"}],
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   Symmetric[{1, 2, 3, 4}], 
   "(1234)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[57]=",ExpressionUUID->"a6fccc6a-ed83-488b-968d-48b140aad4c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"ExpandSym", "[", "%", "]"}], "-", 
   RowBox[{"ExpandSym", "@", 
    RowBox[{"ExpandSym", "[", "%%", "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5178335515678186`*^9, 3.5178335918401217`*^9}, 
   3.544950967832497*^9, 3.545113835073495*^9},
 CellLabel->"In[58]:=",ExpressionUUID->"b0b96ee5-7f89-48e4-ac61-51f08afa8f86"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[58]=",ExpressionUUID->"448a084e-a689-4353-bc7b-c25d7d8c1355"]
}, Open  ]],

Cell["\<\
The functions for dealing with nested SymH objects work best when all tensors \
are innermost. To get that, use MoveTensorsInsideSym before you apply the \
second ImposeSym.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.517833105376298*^9, 3.517833111672658*^9}, {3.517833294444112*^9, 
   3.5178332977142987`*^9}, {3.51783341697612*^9, 3.5178334889572372`*^9}, 
   3.517833534519843*^9, {3.5178382736429057`*^9, 3.5178382879837255`*^9}, {
   3.517838327436982*^9, 3.5178384993828173`*^9}, 3.544950967832497*^9, 
   3.545113835073495*^9},
 TextJustification->1.,ExpressionUUID->"af3c0c6d-2fd0-45d0-a4bc-db8de77f2d98"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymTSexpr1", "=", 
  RowBox[{
   RowBox[{"ImposeSym", "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], ",", 
     RowBox[{"IndexList", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], ",", 
     RowBox[{"Symmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}], 
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "f"}], ",", 
     RowBox[{"-", "h"}], ",", 
     RowBox[{"-", "l"}], ",", 
     RowBox[{"-", "m"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5178379537506084`*^9, 3.517837955814727*^9}, {
   3.5178385603403034`*^9, 3.5178385850017147`*^9}, {3.517838648114324*^9, 
   3.517838654126668*^9}, 3.544950967832497*^9, 3.545113835073495*^9},
 CellLabel->"In[59]:=",ExpressionUUID->"19ff761a-413c-4257-a881-b48fa9aecf76"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"f", "h", "l", "m"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[-$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "123", ")"}],
          FontSize->Tiny]], "[", "T", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`T}, 
    Symmetric[{1, 2, 3}], 
    "(123)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[59]=",ExpressionUUID->"82b13c5a-6137-471e-ac47-eed19fbe9485"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{"SymTSexpr1", ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{3.517838660128011*^9, 3.544950967848097*^9, 
  3.545113835073495*^9},
 CellLabel->"In[60]:=",ExpressionUUID->"8624cc86-f0b5-4341-bcdc-3cd585dd3466"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "5678", ")"}],
         FontSize->Tiny]], "[", "S", 
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "123", ")"}],
          FontSize->Tiny]], "[", "T", "]"}], "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"f", "h", "l", "m", "a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, 
    xAct`SymManipulator`SymH[{$CellContext`T}, 
     Symmetric[{1, 2, 3}], "(123)"]}, 
   Symmetric[{5, 6, 7, 8}], 
   "(5678)"][-$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m, -$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[60]=",ExpressionUUID->"6f5102dd-716f-4ee7-a272-f89ea577c4e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RemoveSuperfluousInnerSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.517833509505412*^9, 3.5178335245242715`*^9}, 
   3.544950967848097*^9, 3.545113835073495*^9},
 CellLabel->"In[61]:=",ExpressionUUID->"d029d9b6-f403-4b54-a93c-ca894961ac68"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "5678", ")"}],
         FontSize->Tiny]], "[", "S", 
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "123", ")"}],
          FontSize->Tiny]], "[", "T", "]"}], "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"f", "h", "l", "m", "a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, 
    xAct`SymManipulator`SymH[{$CellContext`T}, 
     Symmetric[{1, 2, 3}], "(123)"]}, 
   Symmetric[{5, 6, 7, 8}], 
   "(5678)"][-$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m, -$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[61]=",ExpressionUUID->"f504102b-8957-4163-867b-3f17e40ce7b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoveTensorsInsideSym", "@", "SymTSexpr1"}]], "Input",
 CellChangeTimes->{{3.5178386678294516`*^9, 3.517838678915086*^9}, 
   3.544950967848097*^9, 3.5451138350890946`*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"add78fb6-f621-4021-a7a1-5f5946fecf7a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "567", ")"}],
         FontSize->Tiny]], "[", "S", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"f", "h", "l", "m", "a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
   Symmetric[{5, 6, 7}], 
   "(567)"][-$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m, -$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[62]=",ExpressionUUID->"9552d208-37f5-4a58-b29a-ccefa0158f42"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{"%", ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{3.544950967848097*^9, 3.5451138350890946`*^9},
 CellLabel->"In[63]:=",ExpressionUUID->"213ccf3e-499c-450a-a2fd-7728a5f22ea6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "5678", ")"}],
         FontSize->Tiny]], "[", 
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "567", ")"}],
          FontSize->Tiny]], "[", "S", "T", "]"}], "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"f", "h", "l", "m", "a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{
    xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
     Symmetric[{5, 6, 7}], "(567)"]}, 
   Symmetric[{5, 6, 7, 8}], 
   "(5678)"][-$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m, -$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[63]=",ExpressionUUID->"1979adda-8b33-4026-a0b3-279433e73b45"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RemoveSuperfluousInnerSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.517833509505412*^9, 3.5178335245242715`*^9}, 
   3.544950967848097*^9, 3.5451138350890946`*^9},
 CellLabel->"In[64]:=",ExpressionUUID->"a59a97e2-ddbc-4c92-a2df-cd7da85885d0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "5678", ")"}],
         FontSize->Tiny]], "[", "S", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"f", "h", "l", "m", "a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
   Symmetric[{5, 6, 7, 8}], 
   "(5678)"][-$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m, -$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[64]=",ExpressionUUID->"59f6c6fa-006c-4c3b-81cd-9eee2425b4a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoveTensorsOutsideSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.517838696224076*^9, 3.517838698812224*^9}, 
   3.544950967848097*^9, 3.5451138350890946`*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"a744acb7-cbf5-4a54-8578-7b59d6c0534b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"f", "h", "l", "m"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[-$CellContext`f, -$CellContext`h, -$CellContext`l, \
-$CellContext`m],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "1234", ")"}],
          FontSize->Tiny]], "[", "T", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`T}, 
    Symmetric[{1, 2, 3, 4}], 
    "(1234)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[65]=",ExpressionUUID->"d91c55ae-2947-43eb-9f33-e0289da4e1f1"]
}, Open  ]],

Cell["\<\
Replacement rules that involve indices will not have any effect on tensors \
inside the SymH object. The function RuleInSym can be used. This function is \
not extensively tested so use it with care. In this case it is important to \
remember that contractions are taken after symmetrization, and are therefore \
not visible to the the rule used in RuleInSym. Observe that all SymH objects \
might need to be canonicalized after the use of RuleInSym.\
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.517833105376298*^9, 3.517833111672658*^9}, {3.517833294444112*^9, 
   3.5178332977142987`*^9}, {3.51783341697612*^9, 3.5178334889572372`*^9}, 
   3.517833534519843*^9, {3.5178382736429057`*^9, 3.5178382879837255`*^9}, {
   3.517838327436982*^9, 3.5178384993828173`*^9}, 3.544950967832497*^9, 
   3.545113835073495*^9, {3.5921241073344307`*^9, 3.5921242376546125`*^9}, {
   3.592124307944711*^9, 3.5921243103047147`*^9}, {3.592124340344757*^9, 
   3.5921244151848617`*^9}, {3.59212481395642*^9, 3.5921248702464986`*^9}, {
   3.592124998296678*^9, 3.592125086976802*^9}, {3.5921252159469824`*^9, 
   3.592125216716984*^9}, {3.5921253865672216`*^9, 3.5921254093472533`*^9}, {
   3.5921254623973274`*^9, 3.5921255358174305`*^9}, 3.7290603303298454`*^9},
 TextJustification->1.,ExpressionUUID->"e73c1a26-9dc8-42e7-9e04-4e54c1a45d8f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"replacementrules1", "=", 
   RowBox[{"MakeRule", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}], ",", "f", ",", "h"}], "]"}], 
       RowBox[{"S", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "f"}], ",", 
         RowBox[{"-", "h"}]}], "]"}]}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.592124702075263*^9, 3.592124711305276*^9}, {
   3.5921248052864075`*^9, 3.592124808206412*^9}, 3.5921249128765583`*^9, {
   3.59212524968703*^9, 3.592125320817129*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"0f18ac83-0b1e-409b-ad2f-1e29d73ca4ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.592124489184965*^9, 3.5921245077049913`*^9}, {
  3.592124546975046*^9, 3.592124555515058*^9}, {3.5921253557171783`*^9, 
  3.5921253576771812`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"aa331ca7-0451-471a-ba8c-ae23d319e344"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "13", ")"}],
         FontSize->Tiny]], "[", "S", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "c", "b", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S}, 
   Symmetric[{1, 3}], 
   "(13)"][-$CellContext`a, -$CellContext`c, -$CellContext`b, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[67]=",ExpressionUUID->"64220452-bada-46be-9cdf-0c47c582d088"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RuleInSym", "[", 
  RowBox[{"%", ",", "replacementrules1"}], "]"}]], "Input",
 CellChangeTimes->{{3.5921245609850655`*^9, 3.5921245857951*^9}, {
   3.5921246735152235`*^9, 3.5921246986452584`*^9}, 3.5921247408963175`*^9, 
   3.5921249187065663`*^9},
 CellLabel->"In[68]:=",ExpressionUUID->"80455ad8-0add-4740-9a66-534dffda3cb2"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "15", ")"}],
         FontSize->Tiny]], "[", "S", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", "f", "h"},
         {"b", "d", "f", "h", "a", "c", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
   Symmetric[{1, 5}], 
   "(15)"][-$CellContext`b, -$CellContext`d, -$CellContext`f, \
-$CellContext`h, -$CellContext`a, -$CellContext`c, $CellContext`f, \
$CellContext`h],
  Editable->False]], "Output",
 CellLabel->"Out[68]=",ExpressionUUID->"96eee295-5f3c-49b8-86e7-6b960a7baa48"]
}, Open  ]],

Cell["\<\
The same thing can be done with FunctionInSym. This is more flexible because \
any function can be used. \
\>", "MathCaption",
 CellChangeTimes->{{3.5178298908554373`*^9, 3.517829977149373*^9}, {
   3.517830101909509*^9, 3.517830140257703*^9}, {3.5178302199832625`*^9, 
   3.517830272775282*^9}, {3.5178303265113554`*^9, 3.5178303476225634`*^9}, {
   3.5178304105951653`*^9, 3.5178304784350452`*^9}, {3.517831483145511*^9, 
   3.5178314945131617`*^9}, {3.5178316130059385`*^9, 
   3.5178316506070895`*^9}, {3.5178317341018653`*^9, 
   3.5178317378400793`*^9}, {3.5178318012077036`*^9, 3.517831845515238*^9}, {
   3.517831884599473*^9, 3.5178318929299498`*^9}, {3.517832010860695*^9, 
   3.517832038973303*^9}, {3.517832099168746*^9, 3.5178322279451113`*^9}, {
   3.517832269480487*^9, 3.517832439351203*^9}, {3.5178324772493706`*^9, 
   3.5178326757687254`*^9}, {3.5178327517900734`*^9, 3.517832770065119*^9}, {
   3.517833105376298*^9, 3.517833111672658*^9}, {3.517833294444112*^9, 
   3.5178332977142987`*^9}, {3.51783341697612*^9, 3.5178334889572372`*^9}, 
   3.517833534519843*^9, {3.5178382736429057`*^9, 3.5178382879837255`*^9}, {
   3.517838327436982*^9, 3.5178384993828173`*^9}, 3.544950967832497*^9, 
   3.545113835073495*^9, {3.5921241073344307`*^9, 3.5921242376546125`*^9}, {
   3.592124307944711*^9, 3.5921243103047147`*^9}, {3.592124340344757*^9, 
   3.5921244151848617`*^9}, {3.59212481395642*^9, 3.5921248702464986`*^9}, {
   3.592124998296678*^9, 3.592125086976802*^9}, {3.5921252159469824`*^9, 
   3.592125216716984*^9}, {3.5921253865672216`*^9, 3.5921254093472533`*^9}, {
   3.5921254623973274`*^9, 3.5921255358174305`*^9}, 3.59212560729753*^9, {
   3.5921256729476223`*^9, 3.592125746897726*^9}, {3.5921257880177836`*^9, 
   3.592125794447792*^9}},
 TextJustification->1.,ExpressionUUID->"ba618bf2-8969-4ea4-8d89-624212a9dd36"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionInSym", "[", 
  RowBox[{"%%", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "/.", "replacementrules1"}], ")"}], "&"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.5921245609850655`*^9, 3.5921245857951*^9}, {
   3.5921246735152235`*^9, 3.5921246986452584`*^9}, 3.5921247408963175`*^9, 
   3.5921249187065663`*^9, {3.59212562107755*^9, 3.592125631967565*^9}, 
   3.592125682327636*^9},
 CellLabel->"In[69]:=",ExpressionUUID->"1e93fdf4-34a8-4c93-9ba7-25f6ed5ee5fe"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "15", ")"}],
         FontSize->Tiny]], "[", "S", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", "f", "h"},
         {"b", "d", "f", "h", "a", "c", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`S, $CellContext`T}, 
   Symmetric[{1, 5}], 
   "(15)"][-$CellContext`b, -$CellContext`d, -$CellContext`f, \
-$CellContext`h, -$CellContext`a, -$CellContext`c, $CellContext`f, \
$CellContext`h],
  Editable->False]], "Output",
 CellLabel->"Out[69]=",ExpressionUUID->"5f0b1e63-0552-4eb1-8894-97f5126b6aec"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples with a metric", "SubsubsectionIcon",
 CellChangeTimes->{{3.517833850323906*^9, 3.5178338624536*^9}, 
   3.544950967848097*^9, 
   3.5451138350890946`*^9},ExpressionUUID->"8079965d-e726-4c46-9391-\
99f9201e640d"],

Cell["Definition of a Lorentzian metric on the manifold:", "MathCaption",
 CellChangeTimes->{{3.4216673341741343`*^9, 3.421667338156288*^9}, 
   3.544950967848097*^9, 
   3.5451138350890946`*^9},ExpressionUUID->"7e70cf3b-d8ac-45e0-846b-\
5fba478e2dcb"],

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD"}], "]"}]], "Input",
 CellChangeTimes->{{3.544100301881775*^9, 3.544100302942577*^9}, 
   3.544950967848097*^9, 3.5451138350890946`*^9},
 CellLabel->"In[70]:=",ExpressionUUID->"0f7b2d72-4e6f-4210-8503-054b79803c5e"],

Cell["\<\
If you contract indices of a SymH object, this is means that the \
symmetrization is done first and then the contraction. \
\>", "MathCaption",
 CellChangeTimes->{{3.4216673341741343`*^9, 3.421667338156288*^9}, {
   3.517838845628621*^9, 3.5178389039779587`*^9}, 3.5449509678792973`*^9, 
   3.5451138351046944`*^9},ExpressionUUID->"30baf805-19c8-4085-a198-\
689b9d57ab23"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1a", "=", 
  RowBox[{"ImposeSym", "[", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], ",", 
    RowBox[{"IndexList", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], ",", 
    RowBox[{"Symmetric", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.518623885181972*^9, 3.518623907396411*^9}, {
   3.518673884659047*^9, 3.5186738857822495`*^9}, 3.5449509678792973`*^9, 
   3.5451138351046944`*^9},
 CellLabel->"In[71]:=",ExpressionUUID->"3e08dcad-6b64-438a-8a10-ab1a993015b7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "12", ")"}],
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   Symmetric[{1, 2}], 
   "(12)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[71]=",ExpressionUUID->"75e25085-b66d-43af-b4d2-00dc23bd2efd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1b", "=", 
  RowBox[{"ContractMetric", "[", 
   RowBox[{"expr1a", "*", 
    RowBox[{"g", "[", 
     RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.518623917489629*^9, 3.5186239278480473`*^9}, 
   3.518624022509013*^9, {3.5186738471097813`*^9, 3.518673890711858*^9}, 
   3.5449509678792973`*^9, 3.5451138351046944`*^9},
 CellLabel->"In[72]:=",ExpressionUUID->"2438512b-247b-420b-b67a-6eff7beddc2a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "12", ")"}],
         FontSize->Tiny]], "[", "T", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", "b", " "},
         {"a", "b", " ", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T}, 
   Symmetric[{1, 2}], 
   "(12)"][-$CellContext`a, -$CellContext`b, $CellContext`b, -$CellContext`d],
  
  Editable->False]], "Output",
 CellLabel->"Out[72]=",ExpressionUUID->"9997f3f7-ed86-491f-9096-1913c0829711"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "[", 
  RowBox[{
   RowBox[{"ExpandSym", "@", "expr1a"}], "*", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5186739120214953`*^9, 3.5186739122242956`*^9}, 
   3.5449509678792973`*^9, 3.5451138351202946`*^9},
 CellLabel->"In[73]:=",ExpressionUUID->"b8f3661a-8024-4034-aaee-eecbcdf9db0d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", "b", " "},
           {"a", "b", " ", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`a, -$CellContext`b, $CellContext`b, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", "b", " "},
           {"b", "a", " ", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`b, -$CellContext`a, $CellContext`b, \
-$CellContext`d],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[73]=",ExpressionUUID->"a5d9d3c1-b73e-4234-a00a-58071d1cc97b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandSym", "@", "expr1b"}]], "Input",
 CellChangeTimes->{{3.518673923674716*^9, 3.5186739303671274`*^9}, 
   3.5449509678792973`*^9, 3.5451138351202946`*^9},
 CellLabel->"In[74]:=",ExpressionUUID->"fda076f6-2dad-4920-81f7-8f180ecff096"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", "b", " "},
            {"a", "b", " ", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`b, $CellContext`b, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", "b", " "},
            {"b", "a", " ", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`b, -$CellContext`a, $CellContext`b, \
-$CellContext`d],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[74]=",ExpressionUUID->"05886a39-a104-4fe0-91a8-3cdf5ab84af4"]
}, Open  ]],

Cell["\<\
Observe that the symmetrization and trace operations do not commute in \
general as seen by this example:\
\>", "MathCaption",
 CellChangeTimes->{{3.4216673341741343`*^9, 3.421667338156288*^9}, {
   3.517838845628621*^9, 3.5178389039779587`*^9}, {3.5186747870894327`*^9, 
   3.5186748215342927`*^9}, {3.518674893185219*^9, 3.518674900189631*^9}, {
   3.5186749515917215`*^9, 3.5186749620749397`*^9}, 3.5449509678792973`*^9, 
   3.5451138351202946`*^9},ExpressionUUID->"126050e9-ceff-4603-9a25-\
d1493cb09196"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5186754929438725`*^9, 3.518675552036776*^9}, {
   3.518675775382368*^9, 3.5186757808423777`*^9}, 3.5449509678948975`*^9, 
   3.5451138351202946`*^9},
 CellLabel->"In[75]:=",ExpressionUUID->"42be80cb-0253-4d32-a253-61e88440aee1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.518675569696007*^9, 3.5186755783852224`*^9}, {
   3.518675794617202*^9, 3.5186757949604025`*^9}, 3.5449509678948975`*^9, 
   3.5451138351202946`*^9},
 CellLabel->"In[76]:=",ExpressionUUID->"86f6d73c-0ccf-441d-b920-7a3ac0058424"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"V", 
      StyleBox[GridBox[{
         {" ", " ", "b", " "},
         {"a", "b", " ", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`V[-$CellContext`a, -$CellContext`b, $CellContext`b, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[76]=",ExpressionUUID->"dd7a1142-845a-4144-a337-ab26e10fcd50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5186743554834747`*^9, 3.5186743572774773`*^9}, 
   3.5449509678948975`*^9, 3.5451138351202946`*^9},
 CellLabel->"In[77]:=",ExpressionUUID->"f0f0a18f-e386-480f-a250-2eed37585aa5"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[77]=",ExpressionUUID->"79d5ba36-3b42-43d6-9d00-a1bc8c3b9d3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1a", "=", 
  RowBox[{"ToCanonical", "@", 
   RowBox[{"Symmetrize", "[", 
    RowBox[{"%", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.518674249528088*^9, 3.5186742571877017`*^9}, {
   3.5186743675890956`*^9, 3.5186743701475*^9}, {3.5186744717972784`*^9, 
   3.5186744977869244`*^9}, {3.518674543775805*^9, 3.5186745969562984`*^9}, 
   3.5186747124121013`*^9, {3.518675066439123*^9, 3.5186750680927258`*^9}, {
   3.518675608368475*^9, 3.5186756106148787`*^9}, 3.5449509678948975`*^9, 
   3.5451138351202946`*^9},
 CellLabel->"In[78]:=",ExpressionUUID->"bc6edd29-853d-4bc9-95da-74f16068faab"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[78]=",ExpressionUUID->"651d8f7d-de21-4c76-a9f2-022a69ddc86e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symmetrize", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.518674249528088*^9, 3.5186742571877017`*^9}, 
   3.518674329883829*^9, {3.518674486632905*^9, 3.5186744942925177`*^9}, {
   3.5186745470830107`*^9, 3.518674565881044*^9}, {3.5186746010903053`*^9, 
   3.518674602260308*^9}, 3.518674724876523*^9, {3.5186756270417075`*^9, 
   3.5186756369477253`*^9}, {3.518675801668414*^9, 3.5186758020584154`*^9}, 
   3.5449509678948975`*^9, 3.5451138351202946`*^9},
 CellLabel->"In[79]:=",ExpressionUUID->"2f7dc807-5284-47d3-b612-541d81855329"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"V", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`V[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"V", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"b", "a", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`V[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[79]=",ExpressionUUID->"2515058b-c562-48b7-bdd1-2fbe932314b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.518674377463913*^9, 3.518674379226716*^9}, 
   3.5449509678948975`*^9, 3.545113835135895*^9},
 CellLabel->"In[80]:=",ExpressionUUID->"f883d2e8-dd73-4218-b9b9-1d98935ce42b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"V", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`V[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"V", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "a", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`V[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[80]=",ExpressionUUID->"6e8d75ba-96fb-4bc6-a844-fa457d028350"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1b", "=", 
  RowBox[{"ToCanonical", "@", 
   RowBox[{"ContractMetric", "[", 
    RowBox[{"%", 
     RowBox[{"g", "[", 
      RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.518674230542855*^9, 3.5186742371416664`*^9}, 
   3.5186742682637215`*^9, {3.518674327980626*^9, 3.518674335078638*^9}, {
   3.5186743865587287`*^9, 3.518674388149932*^9}, {3.518674730601733*^9, 
   3.518674731802935*^9}, {3.518675078139144*^9, 3.5186750796523466`*^9}, 
   3.518675657274561*^9, 3.5449509678948975`*^9, 3.545113835135895*^9},
 CellLabel->"In[81]:=",ExpressionUUID->"fc2e8411-c724-4109-ab1b-40581f1194b5"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"V", 
       StyleBox[GridBox[{
          {"b", " ", " ", " "},
          {" ", "a", "b", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`V[$CellContext`b, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[81]=",ExpressionUUID->"0c133f4c-b94e-42db-a1c6-cc705d17f84e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{"expr1a", "-", "expr1b"}], "]"}]], "Input",
 CellChangeTimes->{{3.51867439295474*^9, 3.5186744034067583`*^9}, 
   3.5449509678948975`*^9, 3.545113835135895*^9},
 CellLabel->"In[82]:=",ExpressionUUID->"147955e3-12ec-4299-833b-75441ed9226b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"V", 
       StyleBox[GridBox[{
          {"b", " ", " ", " "},
          {" ", "a", "b", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`V[$CellContext`b, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[82]=",ExpressionUUID->"bc1bbe0d-0d09-40b2-b8bc-da4ca5df80d9"]
}, Open  ]],

Cell["The same example with SymH objects:", "MathCaption",
 CellChangeTimes->{{3.5186749654757457`*^9, 3.518674983680978*^9}, 
   3.5449509678948975`*^9, 
   3.545113835135895*^9},ExpressionUUID->"bbfd7d6a-4be8-44f7-8fa9-\
f6e4ec1ce68a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.518674230542855*^9, 3.5186742371416664`*^9}, 
   3.5186742682637215`*^9, {3.5186744794100924`*^9, 3.5186745005637293`*^9}, {
   3.5186746721328306`*^9, 3.518674690618863*^9}, 3.5186756766965947`*^9, {
   3.5186758115120316`*^9, 3.5186758120268326`*^9}, 3.544950967910497*^9, 
   3.545113835135895*^9},
 CellLabel->"In[83]:=",ExpressionUUID->"428359f7-bb5e-476b-82d6-6f4a1f34b7fb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"V", 
      StyleBox[GridBox[{
         {" ", " ", "b", " "},
         {"a", "b", " ", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`V[-$CellContext`a, -$CellContext`b, $CellContext`b, \
-$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[83]=",ExpressionUUID->"3ea96369-d493-4949-8f3b-ae73da875b8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5186743554834747`*^9, 3.5186743572774773`*^9}, 
   3.544950967910497*^9, 3.545113835135895*^9},
 CellLabel->"In[84]:=",ExpressionUUID->"5ec895ff-dc62-43bc-991b-950db91860f4"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[84]=",ExpressionUUID->"efcec046-4ae3-4faf-bf71-e233ac62e5df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1a", "=", 
  RowBox[{"ImposeSym", "[", 
   RowBox[{"%", ",", 
    RowBox[{"IndexList", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.518674249528088*^9, 3.5186742571877017`*^9}, {
   3.5186743675890956`*^9, 3.5186743701475*^9}, {3.5186744717972784`*^9, 
   3.5186744977869244`*^9}, {3.518674543775805*^9, 3.5186745969562984`*^9}, 
   3.5186747124121013`*^9, {3.518675004273014*^9, 3.5186750297010584`*^9}, {
   3.518675688771016*^9, 3.518675691391821*^9}, 3.544950967910497*^9, 
   3.545113835135895*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"35324fc6-e76c-40e8-ba7c-d5a3b33b71dc"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[85]=",ExpressionUUID->"e335ff4f-b45f-46f3-9fd6-c3a43bc4a772"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.518674249528088*^9, 3.5186742571877017`*^9}, 
   3.518674329883829*^9, {3.518674486632905*^9, 3.5186744942925177`*^9}, {
   3.5186745470830107`*^9, 3.518674565881044*^9}, {3.5186746010903053`*^9, 
   3.518674602260308*^9}, 3.518674724876523*^9, {3.518675117685213*^9, 
   3.518675124720825*^9}, {3.51867570245224*^9, 3.5186757157590637`*^9}, {
   3.518675817268442*^9, 3.518675817970443*^9}, 3.544950967910497*^9, 
   3.545113835135895*^9},
 CellLabel->"In[86]:=",ExpressionUUID->"2673f5e2-34be-4933-847b-b493deef094e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "12", ")"}],
         FontSize->Tiny]], "[", "V", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`V}, 
   Symmetric[{1, 2}], 
   "(12)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[86]=",ExpressionUUID->"569ac9a8-92b5-4601-9069-0fc5b0ede6dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1b", "=", 
  RowBox[{"ToCanonical", "@", 
   RowBox[{"ContractMetric", "[", 
    RowBox[{"%", 
     RowBox[{"g", "[", 
      RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.518674230542855*^9, 3.5186742371416664`*^9}, 
   3.5186742682637215`*^9, {3.518674327980626*^9, 3.518674335078638*^9}, {
   3.5186743865587287`*^9, 3.518674388149932*^9}, {3.518674730601733*^9, 
   3.518674731802935*^9}, {3.518675078139144*^9, 3.5186750796523466`*^9}, {
   3.518675722654276*^9, 3.518675723590277*^9}, 3.544950967910497*^9, 
   3.545113835135895*^9},
 CellLabel->"In[87]:=",ExpressionUUID->"583f9455-e9f0-480c-811d-c982709693b4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "12", ")"}],
         FontSize->Tiny]], "[", "V", "]"}], 
      StyleBox[GridBox[{
         {" ", "b", " ", " "},
         {"a", " ", "b", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`V}, 
   Symmetric[{1, 2}], 
   "(12)"][-$CellContext`a, $CellContext`b, -$CellContext`b, -$CellContext`d],
  
  Editable->False]], "Output",
 CellLabel->"Out[87]=",ExpressionUUID->"98e6692f-1f23-46f8-80b3-43ff6ec70266"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ExpandSym", "[", 
   RowBox[{"expr1a", "-", "expr1b"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.51867439295474*^9, 3.5186744034067583`*^9}, {
   3.518675163299693*^9, 3.5186751663260984`*^9}, 3.544950967910497*^9, 
   3.545113835151495*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"53c9edac-6bdd-4cf3-a417-607cf36e65f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"V", 
       StyleBox[GridBox[{
          {"b", " ", " ", " "},
          {" ", "a", "b", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`V[$CellContext`b, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[88]=",ExpressionUUID->"f100b41c-9d80-413c-b625-7106755f8a59"]
}, Open  ]],

Cell["\<\
However, symmetrization and traces do commute if the traces and \
symmetrizations are taken over disjoint sets of indices.\
\>", "MathCaption",
 CellChangeTimes->{{3.5186749654757457`*^9, 3.518674983680978*^9}, {
   3.518675187276935*^9, 3.518675267242676*^9}, 3.544950967910497*^9, 
   3.545113835151495*^9},ExpressionUUID->"9c9b849b-94da-4113-b44c-\
d71ac862f943"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", "d"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.518674230542855*^9, 3.5186742371416664`*^9}, 
   3.5186742682637215`*^9, {3.5186744794100924`*^9, 3.5186745005637293`*^9}, {
   3.5186746721328306`*^9, 3.518674690618863*^9}, 3.5186756766965947`*^9, {
   3.5186758115120316`*^9, 3.5186758120268326`*^9}, 3.5186773484965315`*^9, 
   3.544950967910497*^9, 3.545113835151495*^9},
 CellLabel->"In[89]:=",ExpressionUUID->"0e43d3b2-8492-4662-9b45-f99e8939bcf0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"V", 
      StyleBox[GridBox[{
         {" ", " ", " ", "b"},
         {"a", "b", "c", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`V[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[89]=",ExpressionUUID->"42a4d5d4-aa42-48d4-8331-b77a24f25dd7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5186743554834747`*^9, 3.5186743572774773`*^9}, 
   3.544950967910497*^9, 3.545113835151495*^9},
 CellLabel->"In[90]:=",ExpressionUUID->"0e7c23f4-898a-451f-9f2d-fb31aed4130f"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"V", 
       StyleBox[GridBox[{
          {" ", " ", "b", " "},
          {"a", "c", " ", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`V[-$CellContext`a, -$CellContext`c, $CellContext`b, \
-$CellContext`b],
   Editable->False]}]], "Output",
 CellLabel->"Out[90]=",ExpressionUUID->"170963dd-676c-4215-a7ca-4d575073b1f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1a", "=", 
  RowBox[{"ImposeSym", "[", 
   RowBox[{"%", ",", 
    RowBox[{"IndexList", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.518674249528088*^9, 3.5186742571877017`*^9}, {
   3.5186743675890956`*^9, 3.5186743701475*^9}, {3.5186744717972784`*^9, 
   3.5186744977869244`*^9}, {3.518674543775805*^9, 3.5186745969562984`*^9}, 
   3.5186747124121013`*^9, {3.518675004273014*^9, 3.5186750297010584`*^9}, {
   3.518675688771016*^9, 3.518675691391821*^9}, 3.5186758439444885`*^9, 
   3.518677354674143*^9, 3.544950967926097*^9, 3.545113835151495*^9},
 CellLabel->"In[91]:=",ExpressionUUID->"bb80f1be-c5fd-44c4-b708-b8993ea84957"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "12", ")"}],
          FontSize->Tiny]], "[", "V", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", "b", " "},
          {"a", "c", " ", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`V}, 
    Symmetric[{1, 2}], 
    "(12)"][-$CellContext`a, -$CellContext`c, $CellContext`b, -$CellContext`b],
   Editable->False]}]], "Output",
 CellLabel->"Out[91]=",ExpressionUUID->"c8bddf4f-bc2d-40ef-872b-2c22e4ef1c47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "c"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.518674249528088*^9, 3.5186742571877017`*^9}, 
   3.518674329883829*^9, {3.518674486632905*^9, 3.5186744942925177`*^9}, {
   3.5186745470830107`*^9, 3.518674565881044*^9}, {3.5186746010903053`*^9, 
   3.518674602260308*^9}, 3.518674724876523*^9, {3.518675117685213*^9, 
   3.518675124720825*^9}, {3.51867570245224*^9, 3.5186757157590637`*^9}, {
   3.518675817268442*^9, 3.518675817970443*^9}, 3.5186758573605123`*^9, 
   3.51867735893295*^9, 3.544950967926097*^9, 3.545113835151495*^9},
 CellLabel->"In[92]:=",ExpressionUUID->"37c23d3f-94dd-492b-adec-bc927a73c726"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "13", ")"}],
         FontSize->Tiny]], "[", "V", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`V}, 
   Symmetric[{1, 3}], 
   "(13)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[92]=",ExpressionUUID->"1c21ca5a-4485-4ab5-823e-66d140832b2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1b", "=", 
  RowBox[{"ToCanonical", "@", 
   RowBox[{"ContractMetric", "[", 
    RowBox[{"%", 
     RowBox[{"g", "[", 
      RowBox[{"b", ",", "d"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.518674230542855*^9, 3.5186742371416664`*^9}, 
   3.5186742682637215`*^9, {3.518674327980626*^9, 3.518674335078638*^9}, {
   3.5186743865587287`*^9, 3.518674388149932*^9}, {3.518674730601733*^9, 
   3.518674731802935*^9}, {3.518675078139144*^9, 3.5186750796523466`*^9}, {
   3.518675722654276*^9, 3.518675723590277*^9}, 3.518677361007754*^9, 
   3.544950967926097*^9, 3.545113835151495*^9},
 CellLabel->"In[93]:=",ExpressionUUID->"d17732bc-2c57-47a4-b82c-75ff04416f0c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "13", ")"}],
         FontSize->Tiny]], "[", "V", "]"}], 
      StyleBox[GridBox[{
         {" ", "b", " ", " "},
         {"a", " ", "c", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`V}, 
   Symmetric[{1, 3}], 
   "(13)"][-$CellContext`a, $CellContext`b, -$CellContext`c, -$CellContext`b],
  
  Editable->False]], "Output",
 CellLabel->"Out[93]=",ExpressionUUID->"cac60b26-6fc3-4ec3-ac25-72ac9127d9fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1b", "-", "expr1a"}]], "Input",
 CellChangeTimes->{{3.518677430178275*^9, 3.5186774372138877`*^9}, 
   3.544950967926097*^9, 3.545113835151495*^9},
 CellLabel->"In[94]:=",ExpressionUUID->"a419c5aa-7714-4933-bbdc-399f64de3fa4"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "12", ")"}],
          FontSize->Tiny]], "[", "V", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", "b", " "},
          {"a", "c", " ", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`V}, 
    Symmetric[{1, 2}], 
    "(12)"][-$CellContext`a, -$CellContext`c, $CellContext`b, -$CellContext`b],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "13", ")"}],
          FontSize->Tiny]], "[", "V", "]"}], 
       StyleBox[GridBox[{
          {" ", "b", " ", " "},
          {"a", " ", "c", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`V}, 
    Symmetric[{1, 3}], 
    "(13)"][-$CellContext`a, $CellContext`b, -$CellContext`c, -$CellContext`b],
   Editable->False]}]], "Output",
 CellLabel->"Out[94]=",ExpressionUUID->"0bd3b277-e3e0-4e83-a02c-723f44943c69"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandSym", "[", 
  RowBox[{"expr1b", "-", "expr1a"}], "]"}]], "Input",
 CellChangeTimes->{{3.5186775317500534`*^9, 3.51867756382371*^9}, 
   3.544950967926097*^9, 3.545113835151495*^9},
 CellLabel->"In[95]:=",ExpressionUUID->"7c4fa5e1-4b7a-4a8f-9179-024601214e6b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"V", 
          StyleBox[GridBox[{
             {" ", " ", "b", " "},
             {"a", "c", " ", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`V[-$CellContext`a, -$CellContext`c, $CellContext`b, \
-$CellContext`b],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"V", 
          StyleBox[GridBox[{
             {" ", " ", "b", " "},
             {"c", "a", " ", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`V[-$CellContext`c, -$CellContext`a, $CellContext`b, \
-$CellContext`b],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"V", 
          StyleBox[GridBox[{
             {" ", "b", " ", " "},
             {"a", " ", "c", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`V[-$CellContext`a, $CellContext`b, -$CellContext`c, \
-$CellContext`b],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"V", 
          StyleBox[GridBox[{
             {" ", "b", " ", " "},
             {"c", " ", "a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`V[-$CellContext`c, $CellContext`b, -$CellContext`a, \
-$CellContext`b],
      Editable->False]}], ")"}]}]}]], "Output",
 CellLabel->"Out[95]=",ExpressionUUID->"4dfb7acd-b7b6-4d18-ae0f-ecf33685d1fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5186775538552923`*^9, 3.5186775555556955`*^9}, 
   3.544950967926097*^9, 3.5451138351670947`*^9},
 CellLabel->"In[96]:=",ExpressionUUID->"1cdc3832-e805-4208-8572-455618c1f8e4"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[96]=",ExpressionUUID->"fe302000-fc68-4952-911f-f3749d4d4381"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"CanonicalizeGroupInSym", "[", 
   RowBox[{"expr1b", "-", "expr1a"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5186774394446917`*^9, 3.5186774490543084`*^9}, 
   3.5186775746501293`*^9, 3.544950967926097*^9, 3.5451138351670947`*^9},
 CellLabel->"In[97]:=",ExpressionUUID->"4d33cad1-dc39-43ef-a539-a2b414282993"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[97]=",ExpressionUUID->"20269757-3f2c-4a65-872a-3a1a72925dd0"]
}, Open  ]],

Cell[TextData[{
 "Sometimes there is a metric inside the SymH object that later can be \
contracted. The code for ContractMetricsInsideSym is ",
 StyleBox["new",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " in release 0.8.3 and is not well tested."
}], "MathCaption",
 CellChangeTimes->{{3.5186749654757457`*^9, 3.518674983680978*^9}, {
   3.518675187276935*^9, 3.518675267242676*^9}, {3.544099088729044*^9, 
   3.544099091459049*^9}, {3.5440991850904136`*^9, 3.544099238177307*^9}, 
   3.5440998159565215`*^9, {3.5440998474841766`*^9, 3.544099898527467*^9}, 
   3.5441070312705946`*^9, 3.544950967941697*^9, 
   3.5451138351670947`*^9},ExpressionUUID->"578e5b24-032f-411d-a967-\
b351860bc20b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"V", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "f"}], ",", 
      RowBox[{"-", "h"}]}], "]"}]}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "f"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544099151909155*^9, 3.5440991764635983`*^9}, {
   3.544099213872464*^9, 3.544099214371665*^9}, {3.5440992618581486`*^9, 
   3.5440992976758113`*^9}, 3.544950967941697*^9, 3.5451138351670947`*^9},
 CellLabel->"In[98]:=",ExpressionUUID->"23d537fd-6da9-478a-9c2b-b79ada702e34"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "13", ")"}],
         FontSize->Tiny]], "[", "g", "V", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " "},
         {"f", "h", "a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`g, $CellContext`V}, 
   Symmetric[{1, 3}], 
   "(13)"][-$CellContext`f, -$CellContext`h, -$CellContext`a, \
-$CellContext`b, -$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[98]=",ExpressionUUID->"5995956c-d9e8-4b58-babe-4d0b0c25cf3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"h", ",", "b"}], "]"}], "%"}], "]"}]], "Input",
 CellChangeTimes->{{3.5440992745877705`*^9, 3.5440993013106174`*^9}, 
   3.544950967941697*^9, 3.5451138351670947`*^9},
 CellLabel->"In[99]:=",ExpressionUUID->"48c146e3-63d9-4726-bf1b-bcb337549ba3"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "13", ")"}],
         FontSize->Tiny]], "[", "g", "V", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", "h", " ", " "},
         {"f", "h", "a", " ", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`g, $CellContext`V}, 
   Symmetric[{1, 3}], 
   "(13)"][-$CellContext`f, -$CellContext`h, -$CellContext`a, $CellContext`h, \
-$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[99]=",ExpressionUUID->"6667e5a0-e6d7-4e44-a3ea-e620d8fe88ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetricsInsideSym", "@", "%"}]], "Input",
 CellChangeTimes->{{3.544099313073038*^9, 3.544099335724278*^9}, 
   3.544950967941697*^9, 3.5451138351670947`*^9},
 CellLabel->
  "In[100]:=",ExpressionUUID->"c1915e9d-664e-46e7-b4b8-13bc9d0b0aab"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "12", ")"}],
         FontSize->Tiny]], "[", "V", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "f", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`V}, 
   Symmetric[{1, 2}], 
   "(12)"][-$CellContext`a, -$CellContext`f, -$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",
 CellLabel->
  "Out[100]=",ExpressionUUID->"aeabdbc3-135e-4af7-aa18-b8f6272625ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{
   RowBox[{"ExpandSym", "@", "%"}], "-", 
   RowBox[{"ContractMetric", "@", 
    RowBox[{"ExpandSym", "@", "%%"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5440999364199333`*^9, 3.5440999648431835`*^9}, 
   3.544950967941697*^9, 3.5451138351670947`*^9},
 CellLabel->
  "In[101]:=",ExpressionUUID->"f583e5e2-4ff8-48cb-9769-6bb011f5f405"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[101]=",ExpressionUUID->"29184b67-6fce-4749-9a38-4e1f04978537"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Collecting tensors", "SubsubsectionIcon",
 CellChangeTimes->{{3.518749770615905*^9, 3.518749781317524*^9}, 
   3.544950967941697*^9, 3.5451138351670947`*^9, {3.5921430523211017`*^9, 
   3.592143054911105*^9}},ExpressionUUID->"ed628378-343f-4287-9add-\
e56269c94e22"],

Cell["For scalar expressions, tensors can be collected with ", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, 
   3.544950967941697*^9, 3.5451138351670947`*^9, {3.5921431430412283`*^9, 
   3.5921431667512617`*^9}},ExpressionUUID->"cd16943e-ffb9-4d15-ad3c-\
de187efacc5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", "a", ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "f"}]}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "d", ",", "f", ",", "c"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "f"}]}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{"f", ",", "d", ",", "a", ",", "c"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5921431779412775`*^9, 3.592143274111412*^9}, {
  3.592143523591761*^9, 3.5921435519518013`*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"1a1a290e-72bb-4f5d-8d75-cf028dee44ea"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {"f", "d", "a", "c"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[$CellContext`f, $CellContext`d, $CellContext`a, \
$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "a", "d", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`f],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "d", "f", "c"},
           {"a", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`a, $CellContext`d, $CellContext`f, \
$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", "a", " ", " "},
           {"d", " ", "c", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`d, $CellContext`a, -$CellContext`c, \
-$CellContext`f],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[102]=",ExpressionUUID->"f8be1cb1-8926-457d-975c-3f663d467778"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindTensorCoefficients", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5921431690012646`*^9, 3.5921431752112737`*^9}, {
  3.5921432788914185`*^9, 3.5921432868214297`*^9}, {3.5921434502816586`*^9, 
  3.592143456981668*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"3f3cae51-8737-450a-aaab-7e1f7f612b6a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            UnderscriptBox["Sym", 
             StyleBox[
              RowBox[{"(", "123", ")"}],
              FontSize->Tiny]], "[", "T", "]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {"c", "d", "f", "a"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`SymManipulator`SymH[{$CellContext`T}, 
        Symmetric[{1, 2, 3}], 
        "(123)"][-$CellContext`c, -$CellContext`d, -$CellContext`f, \
-$CellContext`a],
       Editable->False], "+", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            UnderscriptBox["Sym", 
             StyleBox[
              RowBox[{"(", "134", ")"}],
              FontSize->Tiny]], "[", "T", "]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {"c", "a", "d", "f"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`SymManipulator`SymH[{$CellContext`T}, 
        Symmetric[{1, 3, 4}], 
        "(134)"][-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`f],
       Editable->False]}], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"S", 
          StyleBox[GridBox[{
             {"a", "c", "d", "f"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[$CellContext`a, $CellContext`c, $CellContext`d, \
$CellContext`f],
      Editable->False]}], "}"}]}], "}"}]], "Output",
 CellLabel->
  "Out[103]=",ExpressionUUID->"c69b7b6c-12ed-48f8-8c3b-fbb320a87a53"]
}, Open  ]],

Cell["This means that the original expression can be written as", \
"MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, 
   3.544950967941697*^9, 3.5451138351670947`*^9, {3.5921431430412283`*^9, 
   3.5921431667512617`*^9}, {3.592143416891612*^9, 
   3.592143428531628*^9}},ExpressionUUID->"04bfa93a-0da7-4a04-bdf5-\
a47ee073b23c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  RowBox[{"Times", "@@@", "%"}]}]], "Input",
 CellChangeTimes->{{3.592143364631539*^9, 3.5921433690115447`*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"4948e4e0-c7e2-47ad-9097-f31fddf01826"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {"a", "c", "d", "f"},
          {" ", " ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[$CellContext`a, $CellContext`c, $CellContext`d, \
$CellContext`f],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "123", ")"}],
            FontSize->Tiny]], "[", "T", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "f", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T}, 
      Symmetric[{1, 2, 3}], 
      "(123)"][-$CellContext`c, -$CellContext`d, -$CellContext`f, \
-$CellContext`a],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "134", ")"}],
            FontSize->Tiny]], "[", "T", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "d", "f"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T}, 
      Symmetric[{1, 3, 4}], 
      "(134)"][-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`f],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[104]=",ExpressionUUID->"10a9b1dd-d453-42a1-9646-6ab507186b0e"]
}, Open  ]],

Cell["\<\
The symmetry imposed on T is the one from S. This symmetry is important when \
one tries to solve tensor equations.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, 
   3.544950967941697*^9, 3.5451138351670947`*^9, {3.5921431430412283`*^9, 
   3.5921431667512617`*^9}, {3.592143416891612*^9, 3.5921435193717556`*^9}, {
   3.592143558961811*^9, 
   3.592143662051955*^9}},ExpressionUUID->"50e455a0-0af3-4090-9e4b-\
829fd58ba3e1"],

Cell["\<\
The list of tensors can have contractions, and products of tensors.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, 
   3.544950967941697*^9, 3.5451138351670947`*^9, {3.5921431430412283`*^9, 
   3.5921431667512617`*^9}, {3.592143416891612*^9, 3.5921435193717556`*^9}, {
   3.592143558961811*^9, 3.592143662051955*^9}, {3.592143754102084*^9, 
   3.592143774492112*^9}},ExpressionUUID->"13cde548-8246-49cd-967f-\
68d189375001"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "d"}], ",", "a", ",", 
     RowBox[{"-", "c"}], ",", "c"}], "]"}], 
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "d", ",", "f", ",", 
     RowBox[{"-", "f"}]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "f"}]}], "]"}], 
   RowBox[{"S", "[", 
    RowBox[{"f", ",", "d", ",", "a", ",", "c"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5921437057320166`*^9, 3.59214370821202*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"7cf15fc2-6066-4aa5-ab33-37e8776c3d65"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {"f", "d", "a", "c"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[$CellContext`f, $CellContext`d, $CellContext`a, \
$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "a", "d", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`f],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "d", "f", " "},
           {"a", " ", " ", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`a, $CellContext`d, $CellContext`f, \
-$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", "a", " ", "c"},
           {"d", " ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`d, $CellContext`a, -$CellContext`c, \
$CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[105]=",ExpressionUUID->"e027e4de-f0f1-429b-ba14-7d6f37d65bf5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindTensorCoefficients", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b", ",", 
       RowBox[{"-", "d"}], ",", "d"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5921437261220446`*^9, 3.592143744522071*^9}},
 CellLabel->
  "In[106]:=",ExpressionUUID->"65705ff7-07db-4934-a7fd-8d91108619ab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " ", "f", " "},
             {"d", "a", " ", "f"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[-$CellContext`d, -$CellContext`a, $CellContext`f, \
-$CellContext`f],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"S", 
          StyleBox[GridBox[{
             {"a", "c", " ", "d"},
             {" ", " ", "c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[$CellContext`a, $CellContext`c, -$CellContext`c, \
$CellContext`d],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{
           UnderscriptBox["Sym", 
            StyleBox[
             RowBox[{"(", "123", ")"}],
             FontSize->Tiny]], "[", "T", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"c", "d", "f", "a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`SymManipulator`SymH[{$CellContext`T}, 
       Symmetric[{1, 2, 3}], 
       "(123)"][-$CellContext`c, -$CellContext`d, -$CellContext`f, \
-$CellContext`a],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"S", 
          StyleBox[GridBox[{
             {"a", "c", "d", "f"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[$CellContext`a, $CellContext`c, $CellContext`d, \
$CellContext`f],
      Editable->False]}], "}"}]}], "}"}]], "Output",
 CellLabel->
  "Out[106]=",ExpressionUUID->"f8db81f1-f51f-4be0-b249-798538a7b729"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples with a derivative", "SubsubsectionIcon",
 CellChangeTimes->{{3.518749770615905*^9, 3.518749781317524*^9}, 
   3.544950967941697*^9, 
   3.5451138351670947`*^9},ExpressionUUID->"93443280-9b8d-48c5-a7dc-\
39a4f3d46540"],

Cell["\<\
This far only derivatives compatible with the metric are handled. Prefix \
notation is used.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, 
   3.544950967941697*^9, 
   3.5451138351670947`*^9},ExpressionUUID->"4b0a985c-a806-4a34-a1f7-\
40fc41e7e606"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CD", "[", 
   RowBox[{"-", "a"}], "]"}], "@", 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}], ",", 
    RowBox[{"-", "f"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5187498847613053`*^9, 3.5187498979589286`*^9}, {
   3.518750568167306*^9, 3.5187505802261267`*^9}, 3.544950967941697*^9, 
   3.5451138351670947`*^9},
 CellLabel->
  "In[107]:=",ExpressionUUID->"4dc67c3c-d7bc-470b-a1d6-093b13bb4337"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"b", "c", "d", "f"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[-$CellContext`a][
   $CellContext`T[-$CellContext`b, -$CellContext`c, -$CellContext`d, \
-$CellContext`f]],
  Editable->False]], "Output",
 CellLabel->
  "Out[107]=",ExpressionUUID->"9a00719a-0474-4949-abb2-3ee7116d6876"]
}, Open  ]],

Cell["\<\
The derivative index is the first index of the SymH object. That is, we keep \
the order of the indices when we use prefix notation.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5187503095812516`*^9, 3.5187503966606045`*^9}, 3.5449509679572973`*^9, 
   3.545113835182695*^9},ExpressionUUID->"25c396d8-5e1e-4eb7-a34d-\
550ecd1ae75b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1a", "=", 
  RowBox[{"ImposeSym", "[", 
   RowBox[{"%", ",", 
    RowBox[{"IndexList", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5187499667862496`*^9, 3.518749989250289*^9}, {
   3.518750070370432*^9, 3.518750072944436*^9}, 3.518750323324876*^9, 
   3.5187505232704268`*^9, {3.518750565265701*^9, 3.5187505848905354`*^9}, 
   3.5449509679572973`*^9, 3.545113835182695*^9},
 CellLabel->
  "In[108]:=",ExpressionUUID->"bf83e40b-c818-4965-87ac-10e39676e72a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "124", ")"}],
         FontSize->Tiny]], "[", 
       RowBox[{"\[EmptyDownTriangle]", "T"}], "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " "},
         {"a", "b", "c", "d", "f"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{
    xAct`SymManipulator`CovarD[$CellContext`CD, $CellContext`T, \
{-$CellContext`TangentM4}]}, 
   Symmetric[{1, 2, 4}], 
   "(124)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d, -$CellContext`f],
  Editable->False]], "Output",
 CellLabel->
  "Out[108]=",ExpressionUUID->"255e8bcf-456a-4680-8f44-b8602bc74955"]
}, Open  ]],

Cell["\<\
In many cases the TexAct package can produce the correct TeX code for the \
expression.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5187503095812516`*^9, 3.5187505119604073`*^9}, 3.5449509679572973`*^9, {
   3.545112917183482*^9, 3.545112929117503*^9}, {3.5451132162360077`*^9, 
   3.545113221540017*^9}, 
   3.545113835182695*^9},ExpressionUUID->"fc995010-238c-472e-93ca-\
b1cbe418b0bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "expr1a"}]], "Input",
 CellChangeTimes->{{3.518750031651163*^9, 3.5187500341471677`*^9}, 
   3.518750422977851*^9, 3.5449509679572973`*^9, 3.545113835182695*^9},
 CellLabel->
  "In[109]:=",ExpressionUUID->"0a7cb033-0268-4945-95cf-aeb95562ca19"],

Cell[BoxData["\<\"\\\\nabla_{(a}T_{b|c|d)f}\"\>"], "Output",
 CellLabel->
  "Out[109]=",ExpressionUUID->"9f30e672-3770-43be-958a-a65bb137122a"]
}, Open  ]],

Cell["\<\
The derivative is internally represented by CovarD[CD,T,{-TangentM4}]. The \
list {-TangentM4} gives VBundle for the derivative index.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5187500954552755`*^9, 3.518750179601823*^9}, {3.5187502522979507`*^9, 
   3.51875029719483*^9}, {3.5441000211280823`*^9, 3.5441000510177345`*^9}, 
   3.5449509679572973`*^9, 
   3.545113835182695*^9},ExpressionUUID->"7d7adff2-74ee-47ce-b122-\
6dccd9ff9f00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "@", "expr1a"}]], "Input",
 CellChangeTimes->{{3.5187500804480495`*^9, 3.5187500822264524`*^9}, 
   3.5449509679572973`*^9, 3.545113835182695*^9},
 CellLabel->
  "In[110]:=",ExpressionUUID->"c4937e71-68bb-480e-b678-26b87c77aaef"],

Cell["\<\
SymH[{CovarD[CD, T, {-TangentM4}]}, Symmetric[{1, 2, 4}], 
  \"(124)\"][-a, -b, -c, -d, -f]\
\>", "Output",
 CellLabel->
  "Out[110]//InputForm=",ExpressionUUID->"d938b633-e39e-457f-b573-\
91c9c657c836"]
}, Open  ]],

Cell["Higher order derivatives also work", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5187565926017303`*^9, 3.5187565997933426`*^9}, {3.518756681818287*^9, 
   3.5187566850474925`*^9}, 3.5449509679572973`*^9, 
   3.545113835182695*^9},ExpressionUUID->"fc490830-7c16-4897-a0a6-\
504ee2d4267e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CD", "[", 
   RowBox[{"-", "a"}], "]"}], "@", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "b"}], "]"}], "@", 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "f"}], ",", 
     RowBox[{"-", "h"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5187498847613053`*^9, 3.5187498979589286`*^9}, {
   3.518750568167306*^9, 3.5187505802261267`*^9}, {3.5187566042393503`*^9, 
   3.5187566162045717`*^9}, 3.5449509679572973`*^9, 3.545113835182695*^9},
 CellLabel->
  "In[111]:=",ExpressionUUID->"b8674c69-d38a-447a-882d-0cce5a1d7649"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[EmptyDownTriangle]", "a"], 
    SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"c", "d", "f", "h"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[-$CellContext`a][
   $CellContext`CD[-$CellContext`b][
    $CellContext`T[-$CellContext`c, -$CellContext`d, -$CellContext`f, \
-$CellContext`h]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[111]=",ExpressionUUID->"d54e4ce8-ff44-477d-b9bb-ec7185f13965"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{"%", ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5187499667862496`*^9, 3.518749989250289*^9}, {
   3.518750070370432*^9, 3.518750072944436*^9}, 3.518750323324876*^9, 
   3.5187505232704268`*^9, {3.518750565265701*^9, 3.5187505848905354`*^9}, {
   3.5187566252681875`*^9, 3.5187566383566103`*^9}, {3.5187566981515155`*^9, 
   3.5187566998207183`*^9}, 3.5187567386803865`*^9, 3.5449509679572973`*^9, 
   3.545113835182695*^9},
 CellLabel->
  "In[112]:=",ExpressionUUID->"8223a5a9-f7a9-46f0-bdf4-4b6d399d2f42"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{"(", "1234", ")"}],
         FontSize->Tiny]], "[", 
       RowBox[{"\[EmptyDownTriangle]", 
        RowBox[{"\[EmptyDownTriangle]", "T"}]}], "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " "},
         {"a", "b", "c", "d", "f", "h"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{
    xAct`SymManipulator`CovarD[$CellContext`CD, 
     xAct`SymManipulator`CovarD[$CellContext`CD, $CellContext`T, \
{-$CellContext`TangentM4}], {-$CellContext`TangentM4}]}, 
   Symmetric[{1, 2, 3, 4}], 
   "(1234)"][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d, -$CellContext`f, -$CellContext`h],
  Editable->False]], "Output",
 CellLabel->
  "Out[112]=",ExpressionUUID->"63fe14dd-4da4-4c3f-876c-c322d681e355"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.518750031651163*^9, 3.5187500341471677`*^9}, 
   3.518750422977851*^9, {3.5187566452518225`*^9, 3.518756646671425*^9}, 
   3.518756705826729*^9, 3.5187567361375823`*^9, 3.5449509679572973`*^9, 
   3.545113835182695*^9},
 CellLabel->
  "In[113]:=",ExpressionUUID->"21773448-81c3-45c2-aa80-b11586de5698"],

Cell[BoxData["\<\"\\\\nabla_{(a}\\\\nabla_{b}T_{cd)fh}\"\>"], "Output",
 CellLabel->
  "Out[113]=",ExpressionUUID->"87d15988-e3a2-49ef-b066-8474117f256a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples with irreducible decompositions of Spinors", \
"SubsubsectionIcon",
 CellChangeTimes->{{3.518749770615905*^9, 3.518749781317524*^9}, {
   3.5441000811725874`*^9, 3.54410009418301*^9}, 3.5449509679572973`*^9, {
   3.545113058582131*^9, 3.5451130709997525`*^9}, 3.545113835182695*^9, {
   3.5681238965127745`*^9, 
   3.568123898384777*^9}},ExpressionUUID->"b574cebd-126e-4422-8595-\
528ec0910c30"],

Cell["\<\
The IrrDecompose code needs spinors so we begin by loading it.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, 3.5449509679728975`*^9, 
   3.545113835182695*^9, {3.59212073596671*^9, 
   3.592120744176722*^9}},ExpressionUUID->"b0f9c8d8-83f3-4018-982e-\
a8b9e5c61cab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`Spinors`"}]], "Input",
 CellChangeTimes->{{3.5921207460267243`*^9, 3.592120754856737*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"0e9b00e1-5c83-4897-9c84-c1b089a782e2"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVz11IU3EcxvGzsixJPOSsIHDlSzORyrGtcDX41zTSripBcqtpeAzmclPw
BUm9SIpiNxbUpmwup4UaQZCJiCLSWF3MXC1ZLZF2U+ds0HZRUS77PRcPn6vn
4nuwsfVCk4zjuHO09V671rokslBmsRkK+QYH5JmovEHue3u0Dwq1+TOtZNxi
DEI+k2+ykRXzigCs8sQ+w+fHtCl4t/pDmZ00NsxvtpHfIlJtO+l4cG8ARhZW
u7pIfSJrykOOvg7OwgM9fQGo6HxTMIK/a/sluJytvO4lhyfs1lFSp1P3wJJE
7hisP7v0BQp50zt8pC3skkPJ8XPnGOnbrSqHFbahhb9BkS2qBsNwLmMze4NM
dm4chlse81ro01WdTpOCYaUfRlOKJLdMXZxnj4zUrMZKoMn0Ks+5IjJVW80R
F/niSvNl2Huy8hrUS6aHsHlm2AtDN79Pw6L+q+twvMETlb8XmXqrd63gj8j2
m2VpKLSYcwtJ/1Rd4SmLxMr8dwbgLeviJLR81X6C/G9NGpbvepmjJw1mjRJm
pRIn3AGJdZTurYTPYvXSD2echayT40ly7X5ORoo8f7ymGk5EW9phwN04CDsi
pX6oPvT0yaOhOBtxyn+FuxOs6Pa2f/Cd+2LxR3Ku23gG/geVNT8j
  "],
 CellLabel->
  "During evaluation of \
In[114]:=",ExpressionUUID->"841686fe-741c-2245-ac06-f8c6315c34ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Spinors`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`Spinors`  version ", "1.0.6", ", ", {2021, 2, 28}],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVz11IU3EcxvGzsixJPOSsIHDlSzORyrGtcDX41zTSripBcqtpeAzmclNQ
Q1KDpCh2Y0FtyuZyWqgRBKlEKCKN1cXM1ZLVEmld1DkbtF1UlMt+z8XD5+q5
+O5tbD3TJOM47hRttceutS6ILJRZbIZCvsEBeSYqr5C73hzshUJt/kwrGbcY
g5DP5JtsZMWsIgCrPLFP8OkhbQrern5fZieNDbPrbeS3iFTbTjru3emHkbnl
ri5Sn8ia9JAjr4Iv4J7u3gBUdL4uGMbftfkcXMxWXvaSQ+N26wip06m7YUki
dxTWn1z4DIW8qS0+0hZ2yaHk+Ll1lPRtV5XDCtvg3N+gyOZVA2H4MmM9e41M
dq7thxse8lro01UdT5OCYakPRlOKJLdIXZxnh4zULMdKoMk0nedcEpmqreaA
i3x2ofk87DlaeQnqJdN92Dwz5IWha9+nYFHfxVU41uCJyt+JTL3Ru1LwR2S7
zbI0FFrMuYWkf7Ku8JhFYmX+W/3whnV+Alq+aD9C/rcmDcu3Pc/RkwazRgmz
Uokj7oDEOkp3VsInsXrphzPOQtaJsSS5cjcnI0WePlxTDcejLe0w4G4cgB2R
Uj9U73v86MFgnA075b/CVxOs6Oamf/Ct+2zxB/LrdeMJ+B+WrT9T
  "],
 CellLabel->
  "During evaluation of \
In[114]:=",ExpressionUUID->"57189996-95e0-d745-b368-fd02b337f13a"],

Cell[BoxData["\<\"CopyRight (C) 2006-2018, Alfonso Garcia-Parrado Gomez-Lobo \
and Jose M. Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVz09Ik3Ecx/FnZVmi+JCzgsCVf5qJVI5thavBr6aRdqoEya2m4WMwl5uC
GpJ6SApjFwtqUzaX00KNIMhEQhFprA4zV0tWS6Rd6nk2aDtUlMu+n8OH1+lz
eB9oajvfLOM47ixtvdeutS6JLJRZYoZCgcEBeSYqr5N73x7pg0JdwWwbGbcY
g5DP5JttZOW8IgCrPbHP8NlRbQoO1nwot5PGxvnNdvJbRKrrIB337w7AyMJq
dzepT2RNe8ix18E5uL+nLwAVXW8KR/F3bb8Il3OU17zkyKTdOkbqdOoeWJrI
G4cNZ5a+QCF/ZoePtIVdcig5fu4cJ327VBWw0ja88DcoskXVUBi+ytjM2SCT
XRuH4JZHvBb6dNWn0qRgWOmH0ZQiyS1TF+fZLSM1q7FSaDK9zHeuiEzVXnvY
RT6/3HIJ9p6ougr1kukBbJkd8cLQze8zsLj/yjqcaPRE5e9Fpt7qXSv8I7J9
ZlkaCq3mvCLSP11fdNIisXL/nQF4y7o4BS1ftZ8g/1uThhXZL3L1pMGsUcKs
VOK4OyCxzrI9VfBprEH64YyzkHVqIkmu3cvNSJHnjtXWwMloawcMuJuGYGek
zA/VB588fjgcZ6NO+a/wjQQrvr3tH3znvlDykcweNJ6G/wGQLD6E
  "],
 CellLabel->
  "During evaluation of \
In[114]:=",ExpressionUUID->"6711bbe3-3246-844a-9aca-9a21c01f1a1a"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVz11IU3EcxvGzsixJPOSsIHDlSzORyrGtcDX41zTSrkwhcqtpeAzmclNQ
Q1IvkqLYjQW1KZvLaaFGIGQSoYg0VhczV0tWS6Td1DkbtBEV5bLfc/HwuXou
vvub2mqbZRzHnaGt9dq11kWRhTKLzVDINzggz0TlVXLPm8N9UKjPn20j4xZj
EPKZfLONrJhTBGCVJ/YJPj2iTcHb1e/L7KSxcW6jnfwakeo7SMe9OwMwMr/S
3U3qE1lTHnL0VfAF3NfTF4CKrtcFI/i7ttbBpWzlFS85PGG3jpI6nboHliRy
x2DD6cXPUMib2eYjbWGXHEqOn9vHSN9OVTmssA3N/w2KbEE1GIYvMzay18lk
1/pBuOkhr4U+XdXJNCkYlvthNKVIckvUxXl2yUjNSqwEmkzP85zLIlO11xxy
kdMXWy7A3uOVl6FeMt2HLbPDXhi6/m0GFvVfWoPjjZ6o/J3I1Ju9qwV/RLbX
LEtDodWcW0j6p84XnrBIrMx/awDesC5MQssX7UfI/9akYfmOZzl60mDWKGFW
KnHMHZBYZ+nuSvgk1iB9d8ZZyDo5niRX7+ZkpMizR2uq4US0tQMG3E2DsDNS
6ofqA48fPRiKsxGn/Ff4WoIV3dzyD751nyv+QKp/GE/B/5RSPxY=
  "],
 CellLabel->
  "During evaluation of \
In[114]:=",ExpressionUUID->"27fff6e1-7cd7-7343-9e80-d86a76691542"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. \\n\\tThis is free software, and you are welcome \
to redistribute it under certain conditions. \\n\\tSee the General Public \
License for details.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVz09Ik3Ecx/FnZVmS+JCzgsCVf5qJVI5thavBr6aRdqqEyK2m4WOwLTcF
NST1kBTFLhbUpmwup4UaQZBJhCLSWB1mrpaslki71PNs0HaoqC37fg4fXqfP
4b23pf1Mq4zjuFO0tT6H1rYosnBuuRkKxQYn5JmovEruenuwHwqNxbPtZMJi
DEE+l2+1kzVziiCs88Y/w6eHtGl4u/5DlYM0Ns+td5DfolJjJ+m8d2cQRudX
enpIfTJv2kuOvQ69hHt6+4NQ0f2mZBR/9+ZzcClfecVHjkw6bGOkTqfuhRXJ
wnHYdHLxCxSKZrb4SXvELYeS8+fWcdK/XVUNa+zD839DIltQDUXgq5z1/AyZ
6s7shxse8lro19Udz5KCYXkAxtKKFLdEXZx3h4zUrMQroMn0osi1LDJVR8MB
N/nsYtsF2He09jLUS6b7sG12xAfD17/PwLKBS2twotkbk78XmXqjb7Xkj8h2
m2VZKFjNhaVkYPp86TGLxKoCtwbhDdvCFLR81X6C/G9NFlZve16gJw1mjRLm
pZNHPEGJdVXurIVP4k3SD1eChW1TEyly9W5BTpo8fbihHk7GrJ0w6GkZgl3R
ygBU73v86MFwgo265L8i15Ks7Oamf/Cd52z5R9KaMZ6A/wGWSj9W
  "],
 CellLabel->
  "During evaluation of \
In[114]:=",ExpressionUUID->"80d1ba70-03d6-e840-b89a-f726025667f2"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVz09Ik3Ecx/FntbIk8SFnBYEr/zQTqRzbCleDX00j7WQKka6m4WMwl5uC
GpJ6SIpiFxNqUzaX00KNQMgkQhFprA4zV0tWS6Rd6nk2aDtUlMu+n8OH1+lz
eB9saqtplnEcd4623mvXWZdEFsooMkMhz+iAPBNV18l9b4/2QaEub66NjFsa
gpDP4JttZPm8MgArPbHP8NkxXQrerfpQaicbGuc328lvEamug3QM3RuAkYXV
7m7SkMic9pBjr4Mv4YGevgBUdr3JH8Xftb0WLmeprnnJkUm7dYzU6zU9sDiR
Mw7rzy59gULu7A4faQu7FFBy/Nw5Tvp2q8tguW144W9QZIvqwTB8Jd/M2iCT
XRuH4ZZHvA769JWn06RgXOmH0ZQyyS1TF+fZIyO1q7FiaDK9yHWuiEzdXn3E
Rc5cbrkEe09WXIUGyfQAtsyNeGHo5vdZWNh/ZR1ONHqiivci02z1ruX/Edl+
sywNhVZzTgHpn75YcMoisVL/nQF4y7o4BS1fdZ8g/1ubhmW7nmcbSKNZq4KZ
qcQJd0BinSV7K+DTWL30wxlnIevURJJcu58tT5Hnj1dXwcloawcMuJsGYWek
xA81h548fjgcZ6NOxa/wjQQrvL3tH3znvlD0kRySm87A/5DIPoc=
  "],
 CellLabel->
  "During evaluation of \
In[114]:=",ExpressionUUID->"976adf73-aeaf-f34a-8c16-b6e0df5c9a46"]
}, Open  ]],

Cell["\<\
Pretty printing options for the spinor indices and complex conjugates.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100402189951*^9}, 3.5449509679728975`*^9, 3.5451138351982946`*^9, 
   3.592123271893261*^9, {3.592123344123362*^9, 3.5921233529033747`*^9}, {
   3.6208045139128833`*^9, 3.6208045257629004`*^9}, 
   3.9561914159575043`*^9},ExpressionUUID->"5452baee-0fa7-49c1-a888-\
ef2560f276d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"DefAbstractIndex", ",", 
    RowBox[{"PrintAs", "\[Rule]", "PrimeDagger"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{3.620804541592922*^9},
 CellLabel->
  "In[115]:=",ExpressionUUID->"a1f5c4cb-a4e6-44fd-a57a-9317fcaaa6af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"DefSpinor", ",", 
    RowBox[{"PrintDaggerAs", "\[Rule]", "AddBar"}]}], "]"}], ";"}]], "Input",
 CellLabel->
  "In[116]:=",ExpressionUUID->"9f22bfb7-7c1c-401e-8519-fede431c2659"],

Cell["\<\
Make sure that ValidateSymbol will not complain about C and D as abstract \
indices.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100402189951*^9}, 3.5449509679728975`*^9, 3.5451138351982946`*^9, 
   3.592123271893261*^9, {3.592123344123362*^9, 3.5921233529033747`*^9}, {
   3.6208045139128833`*^9, 3.6208045257629004`*^9}, {3.9561914061017113`*^9, 
   3.9561914695085793`*^9}},ExpressionUUID->"a3c1d4f9-eaac-5741-90bb-\
b416eca09156"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"ValidateSymbol", "::", "\"\<capital\>\""}], "]"}]], "Input",
 CellLabel->
  "In[117]:=",ExpressionUUID->"578ab58d-a666-3447-be0d-225b40dd6bd6"],

Cell["Define the spin structure", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100402189951*^9}, 3.5449509679728975`*^9, 
   3.5451138351982946`*^9},ExpressionUUID->"2a35389a-23e7-4a64-8e54-\
ad1eec7f2463"],

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{
    "A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "H", ",", "L", ",", "M",
      ",", "P", ",", "Q", ",", "R"}], "}"}], ",", "\[Epsilon]", ",", 
   "\[Sigma]", ",", "CDe", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}], ",", 
   RowBox[{"SpinorPrefix", "->", "SP"}], ",", 
   RowBox[{"SpinorMark", "->", "\"\<S\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.407866554979206*^9, 3.407866586238164*^9}, 
   3.408425880542036*^9, {3.4084260079033623`*^9, 3.408426038845344*^9}, {
   3.408426089082528*^9, 3.408426107463478*^9}, {3.408453764737714*^9, 
   3.4084537674144773`*^9}, {3.421667624496517*^9, 3.421667625727592*^9}, {
   3.421667716270419*^9, 3.42166771702915*^9}, {3.4216680527013597`*^9, 
   3.4216680569515944`*^9}, 3.421668695000222*^9, {3.423212068025587*^9, 
   3.4232120699323883`*^9}, {3.423633317096388*^9, 3.423633389438792*^9}, {
   3.4236335400219803`*^9, 3.423633557440196*^9}, {3.424427147851179*^9, 
   3.4244271491189537`*^9}, {3.424431598863091*^9, 3.4244316019472733`*^9}, {
   3.424432451110235*^9, 3.4244324671689463`*^9}, {3.424432987065413*^9, 
   3.424432995643202*^9}, {3.42443497940292*^9, 3.424434979773384*^9}, {
   3.431753932599469*^9, 3.4317539333941393`*^9}, {3.4646123031197996`*^9, 
   3.4646123511053996`*^9}, {3.4697965543914003`*^9, 
   3.4697965549686003`*^9}, {3.5039936484834003`*^9, 3.503993649981*^9}, 
   3.5039936974518003`*^9, {3.5340689308796234`*^9, 3.534068931160424*^9}, 
   3.5449509679728975`*^9, 3.5451138351982946`*^9},
 CellLabel->
  "In[118]:=",ExpressionUUID->"be0b5afa-27f3-4ea7-8e4b-158f10f534fa"],

Cell["\<\
Pretty printing options for the spinor indices and some predefined spinors.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100402189951*^9}, 3.5449509679728975`*^9, 3.5451138351982946`*^9, 
   3.592123271893261*^9, {3.592123344123362*^9, 
   3.5921233529033747`*^9}},ExpressionUUID->"db367906-b39b-459b-9021-\
1fa00cd1d17c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAs", "[", "\[Epsilon]\[Dagger]", "]"}], "^=", 
     "\"\<\!\(\*OverscriptBox[\(\[Epsilon]\), \(_\)]\)\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "PsiCDe", "]"}], "^=", "\"\<\[CapitalPsi]\>\""}],
     ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "PsiCDe\[Dagger]", "]"}], "^=", 
     "\"\<\!\(\*OverscriptBox[\(\[CapitalPsi]\), \(_\)]\)\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "PhiCDe", "]"}], "^=", "\"\<\[CapitalPhi]\>\""}],
     ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "LambdaCDe", "]"}], "^=", 
     "\"\<\[CapitalLambda]\>\""}]}], "}"}], ";"}]], "Input",
 CellChangeTimes->{{3.421669006990326*^9, 3.4216690979643993`*^9}, {
   3.421669142640335*^9, 3.4216692111872253`*^9}, {3.427013981707185*^9, 
   3.427013985803987*^9}, {3.4270247559011383`*^9, 3.427024770094125*^9}, {
   3.427024812025331*^9, 3.427024813464142*^9}, {3.42726282558427*^9, 
   3.4272628308394337`*^9}, {3.427263239103531*^9, 3.427263258811751*^9}, {
   3.427263297247272*^9, 3.427263401161145*^9}, {3.4272748584478416`*^9, 
   3.427274933143834*^9}, 3.431754571478716*^9, {3.4761137492115*^9, 
   3.4761138847443*^9}, 3.4761139581267*^9, {3.5170318917443523`*^9, 
   3.517031909446365*^9}, {3.537795432400798*^9, 3.537795445641556*^9}, {
   3.5849629335659957`*^9, 3.5849629756080694`*^9}, {3.592123311333316*^9, 
   3.592123312133317*^9}, {3.62080455458294*^9, 3.620804565692956*^9}},
 CellLabel->
  "In[119]:=",ExpressionUUID->"4709d190-ab4b-4ec8-a721-6a1be6631496"],

Cell["Define some spinors", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, 3.5449509679884977`*^9, 
   3.545113835213895*^9},ExpressionUUID->"3bbe6e78-8b19-4387-8c7a-\
3b970e1bcaf8"],

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"T1", "[", 
    RowBox[{"-", "A"}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.529232641420917*^9, 3.529232650515733*^9}, 
   3.5449509679884977`*^9, 3.545113835213895*^9},
 CellLabel->
  "In[120]:=",ExpressionUUID->"f2791636-3d75-4243-b541-b52d93c3c663"],

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"T2", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.529232653027337*^9, 3.529232657114545*^9}, 
   3.5449509679884977`*^9, 3.545113835213895*^9},
 CellLabel->
  "In[121]:=",ExpressionUUID->"d2ec269d-1a4d-4472-b149-052cdde0ad83"],

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"T3", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.529232653027337*^9, 3.529232657114545*^9}, {
   3.544100644536377*^9, 3.5441006469231815`*^9}, 3.5449509679884977`*^9, 
   3.545113835213895*^9},
 CellLabel->
  "In[122]:=",ExpressionUUID->"c21293ae-53b8-422b-934d-12880bca88de"],

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"T4", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.529236597904866*^9, 3.5292366169369*^9}, 
   3.5441007526601667`*^9, 3.5449509679884977`*^9, 3.545113835213895*^9},
 CellLabel->
  "In[123]:=",ExpressionUUID->"3f4f750c-d43a-4012-ae84-a5de861ba74d"],

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"S4", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "C"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.529236597904866*^9, 3.5292366169369*^9}, 
   3.544100745749355*^9, 3.5449509679884977`*^9, 3.545113835213895*^9},
 CellLabel->
  "In[124]:=",ExpressionUUID->"0d57f030-226b-491a-8c52-b7b89fa706c7"],

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[CapitalOmega]4", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "C"}], ",", 
      RowBox[{"-", "D"}]}], "}"}], "]"}], ",", 
   RowBox[{"PrintAs", "->", "\"\<\[CapitalOmega]\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.529236597904866*^9, 3.5292366169369*^9}, 
   3.544100745749355*^9, {3.5441041452479258`*^9, 3.5441041584611487`*^9}, 
   3.5449509679884977`*^9, 3.545113835213895*^9, {3.5921210945872126`*^9, 
   3.5921210974172163`*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"e3c6604c-7f69-4411-b83b-e35d8f1163f6"],

Cell["The basic example is ", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, 
   3.5449509679884977`*^9, 
   3.545113835213895*^9},ExpressionUUID->"a83bca33-5a69-4116-8ea6-\
0aa48577dac9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrrDecompose", "[", 
  RowBox[{"T2", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.592224771975407*^9},
 CellLabel->
  "In[126]:=",ExpressionUUID->"4f1dda90-bca9-422b-a308-30dcc359e24b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T2", 
        StyleBox[GridBox[{
           {"C", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T2[C, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        UnderscriptBox["Sym", 
         StyleBox[
          RowBox[{"(", "12", ")"}],
          FontSize->Tiny]], "[", "T2", "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`SymManipulator`SymH[{$CellContext`T2}, 
    Symmetric[{1, 2}], "(12)"][-$CellContext`A, -$CellContext`B],
   Editable->False]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwBuKPc3oZFhx+5cj06a4SiK6RlwoB0befWGUsBNJhJ9ty
FwPpoJfe1SD6bKzmUhC9Qe76XRB9o/AkxxIgveriBhEQzW7Aw7UUSPPluhmC
6AcPNuz/fe6V44T/y66C6K6Lwnx/gLTaan4tEK2krmIGoju2RTn9BdKmgs8a
QPSfcuOPDOdfOZ7k2ibGCKR1GH5ogOhfV06Lzrz4yjHtZYLeLCB9O6loOoiO
rSh6AKLndW2+I3L5lePud5vuKf165Vj5XvgviL6xskhYGUgL9GUr22a/duRz
nNsKoie4XF0Noq3We98C0ZE3Pf6CaIabJ/ntgHSfo4c6iH6T88ti3onXjo2M
yq4g2qAy6/WHmW8cyyq2LfsIpPVUpFg+gfh+kV4g+t7DymIQ/UUsbxKIjhI1
OwaiJes3L58x+43jj1uy369WvnX8cFboH4jWEYxVvQakK/hTnUE0AHi34Oc=

  "],
 CellLabel->
  "Out[126]=",ExpressionUUID->"c96f56b5-cbdb-2548-a6a9-bf82ed4fc048"]
}, Open  ]],

Cell["\<\
For convenience we can also get a rule or an equation  as output.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, 
   3.5449509679884977`*^9, 3.545113835213895*^9, {3.5922247827154226`*^9, 
   3.5922248416555047`*^9}},ExpressionUUID->"9804605b-8984-4599-aa94-\
940404ddb765"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrrDecompose", "[", 
  RowBox[{
   RowBox[{"T2", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], ",", 
   RowBox[{"ResultType", "->", "\"\<Rule\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5922248476955132`*^9, 3.5922248481955137`*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"c8535047-c435-4d4b-91df-7f45ddbec82b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T2", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["A", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["B", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T2[
      PatternTest[
       Pattern[$CellContext`A, 
        Blank[]], Spin`pmQ], 
      PatternTest[
       Pattern[$CellContext`B, 
        Blank[]], Spin`pmQ]],
     Editable->False], "]"}], "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "C", "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T2", 
            StyleBox[GridBox[{
               {"C", " "},
               {" ", "C"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T2[C, -C],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Epsilon]", 
            StyleBox[GridBox[{
               {"B", "A"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Epsilon][$CellContext`B, $CellContext`A],
        Editable->False]}], "+", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            UnderscriptBox["Sym", 
             StyleBox[
              RowBox[{"(", "12", ")"}],
              FontSize->Tiny]], "[", "T2", "]"}], 
           StyleBox[GridBox[{
              {"A", "B"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`SymManipulator`SymH[{$CellContext`T2}, 
        Symmetric[{1, 2}], "(12)"][$CellContext`A, $CellContext`B],
       Editable->False]}]}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwBuKGp2JcCw6/ctxoeV8JRIvtlA4B0SV1NhkLgTSLYEfu
YiAtet+nGkRPCNZaCqLP+d64C6K5/E9xLAGpe7BRBER/DePlWgqkD2xxNwTR
i69t3P/73CtHO/cVV0G073ERvj9A+sonAS0QfTFP1QxEe62JdvoLpH+wPW8A
0av2m3xkOP/KsYdhuxgjkH7/9YcGiD4WckZ05sVXjn9eJOrNAtJFScXTQfSX
8uIHINrn0pY7IpdfOU6atPme0q9XjgGTRf6C6PW+xcLKQPq5YY6ybfZrx0tm
81pBdLDVtdUg+s8Sn1sgWua8518QfejcKX47IJ321EMdRG9I+m0x78RrR5fv
yq4g+uH67NcfZr5xVFu/fdlHIC12VJrlE5CW2xflBaLbA6uLQfSh2PxJIDpO
2/wYiGYo2bJ8xuw3jn9K5b5frXzruKFR+B+I3rMnVvUakO5ZlOoMogEnBeRF

  "],
 CellLabel->
  "Out[127]=",ExpressionUUID->"d034b04a-576f-ff44-ac1b-a10f1c3b7557"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrrDecT2", "=", 
  RowBox[{"IrrDecompose", "[", 
   RowBox[{
    RowBox[{"T2", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}]}], "]"}], ",", 
    RowBox[{"ResultType", "->", "\"\<Equation\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5441004724212747`*^9, 3.544100483169694*^9}, {
   3.544100567082241*^9, 3.5441005701086464`*^9}, 3.5449509679884977`*^9, 
   3.545113835213895*^9, {3.5922241000614653`*^9, 3.5922241158914876`*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"56550e6f-b86b-47e0-bf42-9bd20ad9cec5"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T2", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T2[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T2", 
         StyleBox[GridBox[{
            {"C", " "},
            {" ", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T2[C, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "12", ")"}],
           FontSize->Tiny]], "[", "T2", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`T2}, 
     Symmetric[{1, 2}], "(12)"][-$CellContext`A, -$CellContext`B],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{{3.5441004780060844`*^9, 3.544100483606494*^9}, 
   3.5441005707638474`*^9, 3.5441041371047115`*^9, 3.544105190013961*^9, {
   3.5441058060278425`*^9, 3.544105835355894*^9}, 3.5441060017145863`*^9, 
   3.544106048842269*^9, 3.5441066852307873`*^9, 3.5441068214190264`*^9, 
   3.5441072107801104`*^9, 3.5446249466754723`*^9, 3.544674115585313*^9, 
   3.5446741840132265`*^9, 3.544674240121436*^9, 3.5449364260903473`*^9, 
   3.5449397957232714`*^9, 3.544946799034175*^9, 3.5449468480338607`*^9, 
   3.54495064489533*^9, 3.5449509679884977`*^9, 3.5449517379628515`*^9, 
   3.5451131348974648`*^9, 3.5451134570848308`*^9, 3.545113566441023*^9, 
   3.545113835213895*^9, 3.5679361731232204`*^9, 3.5681237292180805`*^9, 
   3.5681249931645*^9, 3.59212111458724*^9, 3.592121450768711*^9, 
   3.5921226879504433`*^9, 3.592123386333421*^9, 3.5921258895779257`*^9, 
   3.5921260675381746`*^9, 3.5921272730908623`*^9, 3.592128065621972*^9, 
   3.5921282237831936`*^9, 3.5921284031634445`*^9, 3.592128872184101*^9, 
   3.592132606629386*^9, 3.5921332960203505`*^9, 3.5921336769818845`*^9, 
   3.5921438153521695`*^9, 3.592224118441491*^9, 3.5922243329137926`*^9, 
   3.5922250470057926`*^9, 3.5922254409163437`*^9, 3.592227649930436*^9, 
   3.5922317882820773`*^9, 3.592231898432232*^9, 3.5922322333527*^9, 
   3.5922326867924995`*^9, 3.5922330303481503`*^9, 3.5922331255865974`*^9, 
   3.592235088448867*^9, 3.5922354022768164`*^9, 3.5981798375974507`*^9, 
   3.598180013288697*^9, 3.598180464679329*^9, 3.598180688559642*^9, 
   3.5981807851897774`*^9, 3.5981829308947816`*^9, 3.5981834312496004`*^9, 
   3.5981904736783967`*^9, 3.5981907737488165`*^9, 3.5981909198100214`*^9, 
   3.5995506384165483`*^9, 3.599552883090891*^9, 3.599553723636967*^9, 
   3.599554307639593*^9, 3.6003284216806707`*^9, 3.620804341641642*^9, 
   3.6208045846629825`*^9, 3.620804763623233*^9, 3.6801026834010916`*^9, 
   3.6801034689641914`*^9, 3.6801037747146196`*^9, 3.68010414641514*^9, 
   3.680104426326532*^9, 3.6801045743577394`*^9, 3.6801047622980022`*^9, 
   3.7290602958757963`*^9, 3.729060393143934*^9, 3.838805851419074*^9, 
   3.838807349775038*^9, 3.8388080969007273`*^9, 3.8388086588835793`*^9, 
   3.838808987888609*^9, 3.838809235516098*^9, 3.838809649759948*^9, 
   3.839673661669118*^9, 3.9561911609708786`*^9, 3.956191216628557*^9, 
   3.956191530951231*^9, 3.956191771192047*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"11624b11-8db1-dc48-b43a-c33a3e395eee"]
}, Open  ]],

Cell["\<\
That the decomposition is correct can be tested by making all possible \
contractions and symmetrizations\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, {
   3.5441005285189734`*^9, 3.54410056096703*^9}, 3.5449509679884977`*^9, 
   3.545113835213895*^9, {3.592224865405538*^9, 
   3.5922248784455566`*^9}},ExpressionUUID->"2dcdb5ca-9fc1-4128-8a1b-\
f9f4261bf6bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"\[Epsilon]", "[", 
      RowBox[{"A", ",", "B"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
  "IrrDecT2"}]], "Input",
 CellChangeTimes->{{3.5441005777214594`*^9, 3.544100588532278*^9}, 
   3.5449509679884977`*^9, 3.545113835213895*^9},
 CellLabel->
  "In[129]:=",ExpressionUUID->"704ffd40-4e7d-489d-adce-63228dd6646d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T2", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T2[-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"A", "B"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][$CellContext`A, $CellContext`B],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"A", "B"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][$CellContext`A, $CellContext`B],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T2", 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T2[C, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{
           UnderscriptBox["Sym", 
            StyleBox[
             RowBox[{"(", "12", ")"}],
             FontSize->Tiny]], "[", "T2", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"A", "B"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`SymManipulator`SymH[{$CellContext`T2}, 
       Symmetric[{1, 2}], "(12)"][-$CellContext`A, -$CellContext`B],
      Editable->False]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.5441005889534793`*^9, 3.544104137135912*^9, 3.544105190045161*^9, {
   3.544105806059043*^9, 3.5441058353714943`*^9}, 3.5441060017457867`*^9, 
   3.5441060488890696`*^9, 3.544106685261987*^9, 3.5441068214346266`*^9, 
   3.54410721079571*^9, 3.544624946698474*^9, 3.5446741156113143`*^9, 
   3.544674184037228*^9, 3.5446742401484375`*^9, 3.544936426105947*^9, 
   3.5449397958012714`*^9, 3.544946799049775*^9, 3.544946848065061*^9, 
   3.54495064492653*^9, 3.5449509680040975`*^9, 3.544951737994052*^9, 
   3.545113134913065*^9, 3.545113457147231*^9, 3.545113566519023*^9, 
   3.545113835229495*^9, 3.5679361731388206`*^9, 3.5681237292336807`*^9, 
   3.5681249931957006`*^9, 3.5921211185172462`*^9, 3.5921214507787113`*^9, 
   3.5921226879704432`*^9, 3.592123386433421*^9, 3.592125889587926*^9, 
   3.592126067548175*^9, 3.5921272731008625`*^9, 3.5921280656419725`*^9, 
   3.5921282238031936`*^9, 3.5921284038334455`*^9, 3.5921288722341013`*^9, 
   3.5921326066493855`*^9, 3.5921332960303507`*^9, 3.5921336770018845`*^9, 
   3.5921438153721695`*^9, 3.5922243419038053`*^9, 3.592225047025792*^9, 
   3.592225440946344*^9, 3.5922276499504366`*^9, 3.5922317883020773`*^9, 
   3.5922318984522314`*^9, 3.5922322333727007`*^9, 3.5922326868115005`*^9, 
   3.592233030378152*^9, 3.5922331256035986`*^9, 3.592235088467868*^9, 
   3.592235402300818*^9, 3.5981798376174507`*^9, 3.5981800133086967`*^9, 
   3.598180464689329*^9, 3.598180688569642*^9, 3.5981807852097774`*^9, 
   3.5981829309147816`*^9, 3.5981834312696004`*^9, 3.5981904736883965`*^9, 
   3.5981907737588167`*^9, 3.598190919830021*^9, 3.5995506384321485`*^9, 
   3.599552883106491*^9, 3.5995537237149677`*^9, 3.5995543076551933`*^9, 
   3.6003284217006707`*^9, 3.620804341651642*^9, 3.620804584672982*^9, 
   3.620804763633233*^9, 3.6801026834210916`*^9, 3.680103468984192*^9, 
   3.68010377472462*^9, 3.6801041464351397`*^9, 3.680104426346532*^9, 
   3.680104574377739*^9, 3.6801047623180027`*^9, 3.729060295895797*^9, 
   3.7290603931639338`*^9, 3.8388058514569464`*^9, 3.838807349806954*^9, 
   3.8388080969346285`*^9, 3.838808658933446*^9, 3.8388089879374776`*^9, 
   3.838809235552002*^9, 3.838809649793855*^9, 3.8396736617030168`*^9, 
   3.956191160988804*^9, 3.9561912166484756`*^9, 3.9561915309721737`*^9, 
   3.956191771197035*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"92de8875-02f6-624c-887c-b9c995aeae80"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.544100596847093*^9, 3.544100601807902*^9}, 
   3.5449509680040975`*^9, 3.545113835229495*^9},
 CellLabel->
  "In[130]:=",ExpressionUUID->"e8158b4f-4f7c-4dcf-8911-edd76dabc351"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.544100602010702*^9, 3.5441041371515117`*^9, 3.5441051900607605`*^9, {
   3.544105806074643*^9, 3.5441058354026947`*^9}, 3.544106001761387*^9, 
   3.5441060489202695`*^9, 3.5441066853087873`*^9, 3.5441068214658265`*^9, 
   3.5441072108113103`*^9, 3.5446249467184753`*^9, 3.5446741156343155`*^9, 
   3.5446741840602293`*^9, 3.5446742401834393`*^9, 3.544936426137147*^9, 
   3.5449397958168716`*^9, 3.5449467990809746`*^9, 3.544946848080661*^9, 
   3.54495064494213*^9, 3.5449509680040975`*^9, 3.544951738009652*^9, 
   3.5451131349286647`*^9, 3.545113457162831*^9, 3.545113566534623*^9, 
   3.545113835229495*^9, 3.567936173154421*^9, 3.5681237292492805`*^9, 
   3.5681249932113004`*^9, 3.5921211197372475`*^9, 3.5921214507987113`*^9, 
   3.592122687990443*^9, 3.592123386463421*^9, 3.5921258896079254`*^9, 
   3.592126067568175*^9, 3.592127273120863*^9, 3.592128065661972*^9, 
   3.5921282238231936`*^9, 3.5921284039034457`*^9, 3.5921288722641015`*^9, 
   3.592132606679386*^9, 3.592133296050351*^9, 3.5921336770118847`*^9, 
   3.59214381539217*^9, 3.5922243434338074`*^9, 3.5922250470457926`*^9, 
   3.592225441036344*^9, 3.5922276499804363`*^9, 3.5922317883220773`*^9, 
   3.592231898472232*^9, 3.5922322333827004`*^9, 3.592232686832502*^9, 
   3.59223303052316*^9, 3.5922331256245995`*^9, 3.592235088486869*^9, 
   3.5922354023258195`*^9, 3.5981798376374507`*^9, 3.5981800133286967`*^9, 
   3.5981804647093287`*^9, 3.5981806885896425`*^9, 3.5981807852297773`*^9, 
   3.598182930924782*^9, 3.5981834312996006`*^9, 3.598190473708397*^9, 
   3.5981907737788167`*^9, 3.5981909198500214`*^9, 3.599550638588148*^9, 
   3.5995528831220913`*^9, 3.5995543076707935`*^9, 3.6003284217206707`*^9, 
   3.620804341661642*^9, 3.6208045846829824`*^9, 3.6208047636432333`*^9, 
   3.6801026834310913`*^9, 3.6801034689941916`*^9, 3.6801037747346196`*^9, 
   3.68010414644514*^9, 3.680104426356532*^9, 3.680104574387739*^9, 
   3.6801047623280025`*^9, 3.7290602959157968`*^9, 3.7290603931839337`*^9, 
   3.8388058514868903`*^9, 3.8388073498378687`*^9, 3.83880809696455*^9, 
   3.838808658966358*^9, 3.838808987969392*^9, 3.838809235587906*^9, 
   3.838809649824773*^9, 3.8396736617229652`*^9, 3.9561911610057583`*^9, 
   3.956191216662472*^9, 3.956191530992094*^9, 3.95619177121097*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"e07ab605-a6d9-6e45-9bed-ebae7f55f99d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ImposeSym", "[", 
    RowBox[{"#", ",", 
     RowBox[{"IndexList", "[", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "B"}]}], "]"}]}], "]"}], "&"}], "/@", 
  "IrrDecT2"}]], "Input",
 CellChangeTimes->{{3.544100615036725*^9, 3.544100629809951*^9}, 
   3.5449509680040975`*^9, 3.545113835229495*^9},
 CellLabel->
  "In[131]:=",ExpressionUUID->"ac0a1dc8-ef18-4486-840f-dd31cb9f7549"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.5441006266275454`*^9, 3.544100630106352*^9}, 
   3.5441041371827116`*^9, 3.544105190091961*^9, {3.5441058061058426`*^9, 
   3.544105835433894*^9}, 3.5441060017925863`*^9, 3.5441060489670696`*^9, 
   3.544106685355587*^9, 3.5441068214970264`*^9, 3.54410721084251*^9, 
   3.544624946751477*^9, 3.5446741156693172`*^9, 3.544674184095231*^9, 
   3.5446742402314425`*^9, 3.544936426183947*^9, 3.5449397958480716`*^9, 
   3.544946799112175*^9, 3.544946848111861*^9, 3.5449506449889297`*^9, 
   3.5449509680040975`*^9, 3.544951738056452*^9, 3.5451131349598646`*^9, 
   3.545113457209631*^9, 3.545113566565823*^9, 3.545113835229495*^9, 
   3.567936173170021*^9, 3.56812372926488*^9, 3.5681249932269*^9, 
   3.592121120467249*^9, 3.592121450808711*^9, 3.592122688010443*^9, 
   3.5921233864834213`*^9, 3.592125889627926*^9, 3.592126067588175*^9, 
   3.5921272731308627`*^9, 3.5921280656719723`*^9, 3.592128223843194*^9, 
   3.592128403933446*^9, 3.5921288722941017`*^9, 3.592132606709386*^9, 
   3.592133296060351*^9, 3.592133677031884*^9, 3.5921438154121695`*^9, 
   3.592224346053811*^9, 3.592225047065792*^9, 3.5922254410663443`*^9, 
   3.5922276500104365`*^9, 3.5922317883320775`*^9, 3.5922318984822316`*^9, 
   3.5922322334027004`*^9, 3.5922326868515034`*^9, 3.592233030551162*^9, 
   3.5922331256345997`*^9, 3.5922350885078697`*^9, 3.5922354023508205`*^9, 
   3.5981798376574507`*^9, 3.5981800133486967`*^9, 3.598180464719329*^9, 
   3.598180688609642*^9, 3.5981807852597775`*^9, 3.5981829309447813`*^9, 
   3.5981834313396006`*^9, 3.598190473728397*^9, 3.5981907737988167`*^9, 
   3.598190919870021*^9, 3.5995506386037483`*^9, 3.599552883137691*^9, 
   3.5995543076863933`*^9, 3.600328421740671*^9, 3.620804341661642*^9, 
   3.6208045846929827`*^9, 3.620804763653233*^9, 3.6801026834310913`*^9, 
   3.6801034690041914`*^9, 3.6801037747446194`*^9, 3.68010414645514*^9, 
   3.6801044263665323`*^9, 3.6801045743977394`*^9, 3.680104762338002*^9, 
   3.7290602959157968`*^9, 3.729060393193934*^9, 3.838805851520776*^9, 
   3.8388073498697567`*^9, 3.838808097020373*^9, 3.83880865899927*^9, 
   3.838808987999339*^9, 3.838809235626802*^9, 3.838809649837739*^9, 
   3.839673661748893*^9, 3.9561911610227127`*^9, 3.9561912166794205`*^9, 
   3.9561915310110435`*^9, 3.956191771226927*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"5e51e6d6-e010-fd49-ab4c-a3a25e23340a"]
}, Open  ]],

Cell["A slightly more complicated case", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, {
   3.5441006869840517`*^9, 3.544100710805293*^9}, 3.5449509680040975`*^9, 
   3.545113835229495*^9, 
   3.8396737268683496`*^9},ExpressionUUID->"37835621-c9eb-4050-ba50-\
922230e8b808"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrrDecT3", "=", 
  RowBox[{"IrrDecompose", "[", 
   RowBox[{
    RowBox[{"T3", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "C"}]}], "]"}], ",", 
    RowBox[{"UseSym", "->", "False"}], ",", 
    RowBox[{"ResultType", "->", "\"\<Equation\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5441004724212747`*^9, 3.544100483169694*^9}, {
   3.544100567082241*^9, 3.5441005701086464`*^9}, {3.544100658654402*^9, 
   3.5441006665480156`*^9}, 3.5449509680040975`*^9, 3.545113835229495*^9, {
   3.5922243506838174`*^9, 3.592224361963833*^9}, {3.5922244420039454`*^9, 
   3.592224447353953*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"db4f0c8d-09e6-4bdf-aa09-b0a65c678b37"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T3", 
       StyleBox[GridBox[{
          {" ", " ", " "},
          {"A", "B", "C"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T3[-$CellContext`A, -$CellContext`B, -C],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "6"]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T3", 
         StyleBox[GridBox[{
            {"D", " ", " "},
            {" ", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T3[D, -C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T3", 
         StyleBox[GridBox[{
            {"D", " ", " "},
            {" ", "D", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T3[D, -D, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T3", 
         StyleBox[GridBox[{
            {"D", " ", " "},
            {" ", "B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T3[D, -$CellContext`B, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T3", 
         StyleBox[GridBox[{
            {"D", " ", " "},
            {" ", "D", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T3[D, -D, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T3", 
         StyleBox[GridBox[{
            {" ", "D", " "},
            {"A", " ", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T3[-$CellContext`A, D, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "123", ")"}],
           FontSize->Tiny]], "[", "T3", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"A", "B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`T3}, 
     Symmetric[{1, 2, 3}], "(123)"][-$CellContext`A, -$CellContext`B, -C],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{{3.5441004780060844`*^9, 3.544100483606494*^9}, 
   3.5441005707638474`*^9, 3.5441006669692163`*^9, 3.5441041372451115`*^9, 
   3.5441051901543612`*^9, {3.544105806215043*^9, 3.5441058354962945`*^9}, 
   3.544106001854987*^9, 3.5441060490450697`*^9, 3.544106685433587*^9, 
   3.5441068215594263`*^9, 3.54410721090491*^9, 3.544624946819481*^9, 
   3.5446741157393217`*^9, 3.5446741841622353`*^9, 3.544674240309447*^9, 
   3.5449364262463474`*^9, 3.5449397959260716`*^9, 3.544946799174575*^9, 
   3.544946848174261*^9, 3.5449506450669303`*^9, 3.5449509680040975`*^9, 
   3.5449517381968517`*^9, 3.545113135022265*^9, 3.545113457272031*^9, 
   3.545113566643823*^9, 3.545113835229495*^9, 3.5679361732168207`*^9, 
   3.5681237293116803`*^9, 3.5681249932737007`*^9, 3.5921211226672516`*^9, 
   3.5921214508687115`*^9, 3.5921226880604434`*^9, 3.5921233872734222`*^9, 
   3.592125889677926*^9, 3.592126067638175*^9, 3.5921272731908627`*^9, 
   3.5921280657319727`*^9, 3.5921282239031935`*^9, 3.592128404823447*^9, 
   3.5921288723641014`*^9, 3.592132606779386*^9, 3.5921332961203513`*^9, 
   3.5921336770818844`*^9, 3.5921438154621696`*^9, 3.592224362363834*^9, 
   3.592224448233954*^9, 3.5922250471257925`*^9, 3.592225441136344*^9, 
   3.5922276500704365`*^9, 3.5922317883920774`*^9, 3.5922318985722313`*^9, 
   3.5922322334527006`*^9, 3.5922326869105062`*^9, 3.592233030642167*^9, 
   3.5922331256976037`*^9, 3.5922350885708733`*^9, 3.592235402460827*^9, 
   3.598179837727451*^9, 3.598180013408697*^9, 3.598180464779329*^9, 
   3.5981806886696424`*^9, 3.5981807853097773`*^9, 3.5981829310047817`*^9, 
   3.5981834314096007`*^9, 3.598190473788397*^9, 3.598190773848817*^9, 
   3.5981909199300213`*^9, 3.5995506386193485`*^9, 3.5995528832000914`*^9, 
   3.599554307748793*^9, 3.600328421800671*^9, 3.6208043417116423`*^9, 
   3.6208045847329826`*^9, 3.6208047637032332`*^9, 3.6801026834810915`*^9, 
   3.6801034690441914`*^9, 3.6801037747846193`*^9, 3.68010414649514*^9, 
   3.6801044264065323`*^9, 3.680104574447739*^9, 3.680104762378002*^9, 
   3.7290602959757967`*^9, 3.7290603932439337`*^9, 3.8388058515726614`*^9, 
   3.838807349908679*^9, 3.8388080970582714`*^9, 3.83880865904016*^9, 
   3.838808988037211*^9, 3.8388092356686897`*^9, 3.838809649880621*^9, 
   3.8396736617917795`*^9, 3.9561911610626335`*^9, 3.9561912167142982`*^9, 
   3.9561915310619335`*^9, 3.956191771260868*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"cc37b4df-435a-0140-89af-e8f4011b3aa5"]
}, Open  ]],

Cell["\<\
The IrrDecompose code uses the symmetries of the expression to simplify it\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, {
   3.5441006869840517`*^9, 3.544100710805293*^9}, {3.544100786278226*^9, 
   3.544100848570135*^9}, 3.5449509680040975`*^9, 
   3.545113835229495*^9},ExpressionUUID->"4b39b2e7-b3b3-455a-85f9-\
6309dc13d5c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrrDecT4", "=", 
  RowBox[{"IrrDecompose", "[", 
   RowBox[{
    RowBox[{"T4", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "C"}], ",", 
      RowBox[{"-", "D"}]}], "]"}], ",", 
    RowBox[{"UseSym", "->", "False"}], ",", 
    RowBox[{"ResultType", "->", "\"\<Equation\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.529236634502531*^9, 3.529236642162144*^9}, {
   3.5292370130401955`*^9, 3.5292370146625986`*^9}, {3.544100866213766*^9, 
   3.5441008678517694`*^9}, 3.5449509680040975`*^9, 3.545113835229495*^9, {
   3.59222437411385*^9, 3.592224379023857*^9}, 3.5922244527239604`*^9},
 CellLabel->
  "In[133]:=",ExpressionUUID->"e4cd3936-eb13-4540-8db2-91f839fcf95c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T4", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T4[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T4", 
         StyleBox[GridBox[{
            {"F", "H", " ", " "},
            {" ", " ", "F", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[$CellContext`F, $CellContext`H, -$CellContext`F, \
-$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T4", 
         StyleBox[GridBox[{
            {"F", "H", " ", " "},
            {" ", " ", "H", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[$CellContext`F, $CellContext`H, -$CellContext`H, \
-$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T4", 
         StyleBox[GridBox[{
            {"F", "H", " ", " "},
            {" ", " ", "F", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[$CellContext`F, $CellContext`H, -$CellContext`F, \
-$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T4", 
         StyleBox[GridBox[{
            {"F", "H", " ", " "},
            {" ", " ", "H", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[$CellContext`F, $CellContext`H, -$CellContext`H, \
-$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T4", 
         StyleBox[GridBox[{
            {"F", " ", "H", " "},
            {" ", "F", " ", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[$CellContext`F, -$CellContext`F, $CellContext`H, \
-$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "12", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "B", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{1, 2}], 
      "(12)"][-$CellContext`A, -$CellContext`B, $CellContext`F, \
-$CellContext`F],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "13", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {" ", "F", " ", " "},
            {"A", " ", "C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{1, 3}], "(13)"][-$CellContext`A, $CellContext`F, -
      C, -$CellContext`F],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "13", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {" ", "F", " ", " "},
            {"A", " ", "D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{1, 3}], "(13)"][-$CellContext`A, $CellContext`F, -
      D, -$CellContext`F],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "14", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {" ", "F", " ", " "},
            {"A", " ", "F", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{1, 4}], 
      "(14)"][-$CellContext`A, $CellContext`F, -$CellContext`F, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "14", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {" ", "F", " ", " "},
            {"A", " ", "F", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{1, 4}], 
      "(14)"][-$CellContext`A, $CellContext`F, -$CellContext`F, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "23", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {"F", " ", " ", " "},
            {" ", "B", "C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{2, 3}], "(23)"][$CellContext`F, -$CellContext`B, -
      C, -$CellContext`F],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "23", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {"F", " ", " ", " "},
            {" ", "B", "D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{2, 3}], "(23)"][$CellContext`F, -$CellContext`B, -
      D, -$CellContext`F],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "23", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {"F", " ", " ", " "},
            {" ", "C", "D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{2, 3}], "(23)"][$CellContext`F, -C, -D, -$CellContext`F],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "24", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {"F", " ", " ", " "},
            {" ", "B", "F", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{2, 4}], 
      "(24)"][$CellContext`F, -$CellContext`B, -$CellContext`F, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "24", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {"F", " ", " ", " "},
            {" ", "B", "F", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{2, 4}], 
      "(24)"][$CellContext`F, -$CellContext`B, -$CellContext`F, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "24", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {"F", " ", " ", " "},
            {" ", "C", "F", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{2, 4}], "(24)"][$CellContext`F, -C, -$CellContext`F, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "34", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {"F", " ", " ", " "},
            {" ", "F", "B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{3, 4}], 
      "(34)"][$CellContext`F, -$CellContext`F, -$CellContext`B, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "34", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {"F", " ", " ", " "},
            {" ", "F", "B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{3, 4}], 
      "(34)"][$CellContext`F, -$CellContext`F, -$CellContext`B, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "34", ")"}],
            FontSize->Tiny]], "[", "T4", "]"}], 
         StyleBox[GridBox[{
            {"F", " ", " ", " "},
            {" ", "F", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`T4}, 
      Symmetric[{3, 4}], "(34)"][$CellContext`F, -$CellContext`F, -C, -D],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "1234", ")"}],
           FontSize->Tiny]], "[", "T4", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`T4}, 
     Symmetric[{1, 2, 3, 4}], "(1234)"][-$CellContext`A, -$CellContext`B, -
     C, -D],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.529236667309388*^9, 3.5292367282772956`*^9, 3.529236976629732*^9, 
   3.5292370152865996`*^9, 3.529237067031891*^9, 3.5340685801598077`*^9, 
   3.534068964248082*^9, 3.5340701874306307`*^9, 3.5342496460017786`*^9, 
   3.5376215121350203`*^9, 3.5376216366232395`*^9, 3.5376228667643995`*^9, 
   3.537622986057809*^9, 3.537623198639383*^9, 3.537623383780508*^9, 
   3.5376254536409435`*^9, 3.537628800629094*^9, 3.5376947138674946`*^9, 
   3.5376948869497986`*^9, 3.537695520794512*^9, 3.537695608607066*^9, 
   3.537695931856234*^9, 3.5376964091546726`*^9, 3.5376971178493176`*^9, 
   3.537697471143138*^9, {3.5376979777540274`*^9, 3.5376980020900707`*^9}, 
   3.5377005816678057`*^9, 3.5377010017297435`*^9, 3.537701160990423*^9, 
   3.5377050868027186`*^9, 3.537767661745109*^9, 3.5377801968139267`*^9, 
   3.5377805967986293`*^9, 3.537780934977023*^9, 3.537781092209699*^9, 
   3.537781262359198*^9, 3.5377813961762333`*^9, 3.5377815450472946`*^9, 
   3.5377817403596373`*^9, 3.5377824103350143`*^9, 3.5377827509460125`*^9, 
   3.5377829416875477`*^9, 3.5377832097750187`*^9, 3.537783458299055*^9, 
   3.5377835844564767`*^9, 3.53778412148742*^9, 3.537784257020458*^9, 
   3.544092220811981*^9, 3.5440972521056185`*^9, 3.5440973814454455`*^9, 
   3.5440979635302677`*^9, 3.5440997647416315`*^9, {3.544100850535739*^9, 
   3.544100868694171*^9}, 3.5441041374791117`*^9, 3.544105190388362*^9, {
   3.5441058063398433`*^9, 3.544105835745895*^9}, 3.5441060021045876`*^9, 
   3.54410604929467*^9, 3.544106685667588*^9, 3.5441068218090267`*^9, 
   3.544107211138911*^9, 3.544624947099497*^9, 3.5446741159923363`*^9, 
   3.544674184399249*^9, 3.544674240559461*^9, 3.5449364265583477`*^9, 
   3.544939796206872*^9, 3.5449467994241753`*^9, 3.5449468484238615`*^9, 
   3.5449506453165307`*^9, 3.5449509680196977`*^9, 3.5449517384620523`*^9, 
   3.5451131352718654`*^9, 3.5451134575060315`*^9, 3.5451135668934236`*^9, 
   3.545113835245095*^9, 3.5679361734040213`*^9, 3.5681237295144806`*^9, 
   3.568124993460901*^9, 3.5921211273172584`*^9, 3.5921214510687113`*^9, 
   3.592122688270444*^9, 3.5921233889634247`*^9, 3.592125889887926*^9, 
   3.5921260678581753`*^9, 3.5921272733908634`*^9, 3.5921280659319725`*^9, 
   3.5921282241231937`*^9, 3.5921284069734497`*^9, 3.592128872604102*^9, 
   3.5921326070193863`*^9, 3.5921332963303514`*^9, 3.592133677291885*^9, 
   3.59214381568217*^9, 3.592224379663858*^9, {3.5922244241739206`*^9, 
   3.592224453853962*^9}, 3.5922250473357925`*^9, 3.5922254413663445`*^9, 
   3.5922276502904367`*^9, 3.5922317886120777`*^9, 3.592231898792232*^9, 
   3.5922322336627007`*^9, 3.592232687194523*^9, 3.5922330306691685`*^9, 
   3.592233125908616*^9, 3.592235088788886*^9, 3.59223540268184*^9, 
   3.598179837967451*^9, 3.598180013618697*^9, 3.5981804649893293`*^9, 
   3.5981806888796425`*^9, 3.5981807855197783`*^9, 3.598182931204782*^9, 
   3.5981834316696014`*^9, 3.598190474008397*^9, 3.598190774098817*^9, 
   3.5981909201400213`*^9, 3.5995506386349487`*^9, 3.599552883402891*^9, 
   3.5995543079515934`*^9, 3.6003284220506716`*^9, 3.620804341911642*^9, 
   3.6208045849029827`*^9, 3.6208047638732333`*^9, 3.680102683661092*^9, 
   3.6801034692241917`*^9, 3.68010377496462*^9, 3.6801041466851406`*^9, 
   3.6801044265965323`*^9, 3.68010457462774*^9, 3.6801047625680027`*^9, 
   3.729060296205797*^9, 3.729060393423934*^9, 3.83880585176116*^9, 
   3.838807350052295*^9, 3.8388080971999197`*^9, 3.838808659183777*^9, 
   3.8388089881848164`*^9, 3.8388092358103123`*^9, 3.8388096500681257`*^9, 
   3.839673661942384*^9, 3.9561911612052536`*^9, 3.95619121685495*^9, 
   3.9561915312005672`*^9, 3.956191771395502*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"5cea9513-9d2d-7140-a623-f4f221deb9bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrrDecS4", "=", 
  RowBox[{"IrrDecompose", "[", 
   RowBox[{
    RowBox[{"S4", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "C"}], ",", 
      RowBox[{"-", "D"}]}], "]"}], ",", 
    RowBox[{"UseSym", "->", "False"}], ",", 
    RowBox[{"ResultType", "->", "\"\<Equation\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.529236634502531*^9, 3.529236642162144*^9}, {
   3.5292370130401955`*^9, 3.5292370146625986`*^9}, {3.544100866213766*^9, 
   3.5441008809869924`*^9}, 3.5449509680196977`*^9, 3.545113835245095*^9, {
   3.592224385863867*^9, 3.592224391393874*^9}, 3.5922244559639645`*^9},
 CellLabel->
  "In[134]:=",ExpressionUUID->"e2685d2b-c9af-4c8a-8402-2933254d9bfd"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S4", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S4[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "12"]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"C", "D", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-C, -D, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"B", "D", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`B, -D, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"B", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`B, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "D", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -D, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "B", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -$CellContext`B, $CellContext`F, \
-$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "1234", ")"}],
           FontSize->Tiny]], "[", "S4", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`S4}, 
     Symmetric[{1, 2, 3, 4}], "(1234)"][-$CellContext`A, -$CellContext`B, -
     C, -D],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.529236667309388*^9, 3.5292367282772956`*^9, 3.529236976629732*^9, 
   3.5292370152865996`*^9, 3.529237067031891*^9, 3.5340685801598077`*^9, 
   3.534068964248082*^9, 3.5340701874306307`*^9, 3.5342496460017786`*^9, 
   3.5376215121350203`*^9, 3.5376216366232395`*^9, 3.5376228667643995`*^9, 
   3.537622986057809*^9, 3.537623198639383*^9, 3.537623383780508*^9, 
   3.5376254536409435`*^9, 3.537628800629094*^9, 3.5376947138674946`*^9, 
   3.5376948869497986`*^9, 3.537695520794512*^9, 3.537695608607066*^9, 
   3.537695931856234*^9, 3.5376964091546726`*^9, 3.5376971178493176`*^9, 
   3.537697471143138*^9, {3.5376979777540274`*^9, 3.5376980020900707`*^9}, 
   3.5377005816678057`*^9, 3.5377010017297435`*^9, 3.537701160990423*^9, 
   3.5377050868027186`*^9, 3.537767661745109*^9, 3.5377801968139267`*^9, 
   3.5377805967986293`*^9, 3.537780934977023*^9, 3.537781092209699*^9, 
   3.537781262359198*^9, 3.5377813961762333`*^9, 3.5377815450472946`*^9, 
   3.5377817403596373`*^9, 3.5377824103350143`*^9, 3.5377827509460125`*^9, 
   3.5377829416875477`*^9, 3.5377832097750187`*^9, 3.537783458299055*^9, 
   3.5377835844564767`*^9, 3.53778412148742*^9, 3.537784257020458*^9, 
   3.544092220811981*^9, 3.5440972521056185`*^9, 3.5440973814454455`*^9, 
   3.5440979635302677`*^9, 3.5440997647416315`*^9, {3.544100850535739*^9, 
   3.5441008817669935`*^9}, 3.5441041376195126`*^9, 3.544105190528762*^9, {
   3.5441058064802437`*^9, 3.544105835870695*^9}, 3.5441060022449875`*^9, 
   3.5441060494818707`*^9, 3.544106685839188*^9, 3.544106821965027*^9, 
   3.544107211263711*^9, 3.5446249472355046`*^9, 3.544674116133344*^9, 
   3.5446741845352564`*^9, 3.5446742407394714`*^9, 3.5449364267455482`*^9, 
   3.5449397963784723`*^9, 3.544946799564576*^9, 3.5449468485486617`*^9, 
   3.544950645456931*^9, 3.5449509680352974`*^9, 3.5449517386336527`*^9, 
   3.5451131353966656`*^9, 3.545113457646432*^9, 3.545113567033824*^9, 
   3.5451138352606945`*^9, 3.5679361735288215`*^9, 3.568123729623681*^9, 
   3.568124993585701*^9, 3.592121137187272*^9, 3.592121451188712*^9, 
   3.592122688390444*^9, 3.592123389643426*^9, 3.5921258899979267`*^9, 
   3.5921260679681754`*^9, 3.592127273540863*^9, 3.592128066051973*^9, 
   3.5921282242431946`*^9, 3.592128407563451*^9, 3.5921288727341022`*^9, 
   3.5921326071493864`*^9, 3.592133296880352*^9, 3.592133677411885*^9, 
   3.5921438158421707`*^9, {3.592224387173868*^9, 3.592224391893875*^9}, 
   3.592224456803966*^9, 3.592225047455793*^9, 3.5922254414963446`*^9, 
   3.592227650470437*^9, 3.592231788732078*^9, 3.5922318989122324`*^9, 
   3.592232233802701*^9, 3.5922326873215303`*^9, 3.59223303069617*^9, 
   3.5922331260256224`*^9, 3.5922350889108934`*^9, 3.5922354028058467`*^9, 
   3.5981798380874515`*^9, 3.598180013738697*^9, 3.598180465099329*^9, 
   3.598180689029643*^9, 3.598180785669778*^9, 3.598182931324782*^9, 
   3.5981834317996016`*^9, 3.598190474168397*^9, 3.5981907742088175`*^9, 
   3.598190920320022*^9, 3.599550638650549*^9, 3.599552883527692*^9, 
   3.599554308107594*^9, 3.6003284223006716`*^9, 3.6208043420116425`*^9, 
   3.620804585002983*^9, 3.6208047639632335`*^9, 3.6801026837410917`*^9, 
   3.680103469314192*^9, 3.68010377504462*^9, 3.6801041467751403`*^9, 
   3.6801044267465324`*^9, 3.6801045747177396`*^9, 3.6801047626480026`*^9, 
   3.729060296305797*^9, 3.7290603935439343`*^9, 3.838805851842938*^9, 
   3.838807350167983*^9, 3.838808097263747*^9, 3.8388086592535896`*^9, 
   3.838808988257622*^9, 3.838809235941959*^9, 3.8388096501349435`*^9, 
   3.8396736620550756`*^9, 3.956191161274069*^9, 3.9561912169217453`*^9, 
   3.9561915312713757`*^9, 3.9561917715111656`*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"16bba67b-a1a2-2c45-ba3e-86ab7346f703"]
}, Open  ]],

Cell["One can also simplify it afterwards", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, {
   3.5441006869840517`*^9, 3.544100710805293*^9}, {3.544100786278226*^9, 
   3.544100848570135*^9}, {3.544101063023712*^9, 3.544101108154591*^9}, 
   3.5449509680352974`*^9, 
   3.5451138352606945`*^9},ExpressionUUID->"7c1eab4f-e273-4736-9f67-\
534e7c27cd8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonicalSym", "@", 
  RowBox[{"RemoveSuperfluousSym", "[", 
   RowBox[{"IrrDecT4", "/.", 
    RowBox[{"T4", "->", "S4"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544100899145424*^9, 3.5441009246826687`*^9}, {
   3.5441009593147297`*^9, 3.544100978065963*^9}, 3.5449509680352974`*^9, 
   3.5451138352606945`*^9, {3.592121143987282*^9, 3.5921211510572915`*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"a34ae2b3-845b-4dfd-bea3-679d374cb882"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S4", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S4[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "12"]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"C", "D", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-C, -D, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"B", "D", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`B, -D, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"B", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`B, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "D", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -D, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "B", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -$CellContext`B, $CellContext`F, \
-$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "1234", ")"}],
           FontSize->Tiny]], "[", "S4", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`S4}, 
     Symmetric[{1, 2, 3, 4}], "(1234)"][-$CellContext`A, -$CellContext`B, -
     C, -D],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{{3.544100905167035*^9, 3.54410092525987*^9}, {
   3.5441009669899435`*^9, 3.5441009786431637`*^9}, 3.544101029920454*^9, 
   3.5441041377443123`*^9, 3.544105190653562*^9, {3.5441058065270433`*^9, 
   3.5441058359954953`*^9}, 3.5441060023697877`*^9, 3.5441060496222706`*^9, 
   3.5441066860107884`*^9, 3.544106822292628*^9, 3.544107211388511*^9, 
   3.544624947367512*^9, 3.544674116269352*^9, 3.544674184665264*^9, 
   3.5446742408724785`*^9, 3.544936426948348*^9, 3.5449397965344725`*^9, 
   3.544946799704976*^9, 3.544946848689062*^9, 3.5449506456129313`*^9, 
   3.5449509680352974`*^9, 3.544951738774053*^9, 3.5451131355214663`*^9, 
   3.5451134577712317`*^9, 3.5451135671586237`*^9, 3.5451138352606945`*^9, 
   3.5679361736536217`*^9, 3.5681237297484813`*^9, 3.5681249936949015`*^9, {
   3.5921211523672934`*^9, 3.5921211687173166`*^9}, 3.5921214513387117`*^9, 
   3.592122688530444*^9, 3.5921233905534267`*^9, 3.5921258901479263`*^9, 
   3.5921260681181755`*^9, 3.5921272736808634`*^9, 3.592128066201973*^9, 
   3.5921282244031944`*^9, 3.592128408623452*^9, 3.592128872894102*^9, 
   3.5921326073193865`*^9, 3.5921332979903536`*^9, 3.592133677551885*^9, 
   3.5921438159921703`*^9, 3.592224396313881*^9, 3.59222445964397*^9, 
   3.592225047615793*^9, 3.592225441656345*^9, 3.592227650630438*^9, 
   3.592231788882078*^9, 3.5922318990522327`*^9, 3.592232233952701*^9, 
   3.592232687477539*^9, 3.5922330307231717`*^9, 3.5922331261786313`*^9, 
   3.5922350890659018`*^9, 3.592235402966856*^9, 3.598179838247452*^9, 
   3.5981800138886976`*^9, 3.5981804652493296`*^9, 3.5981806891796427`*^9, 
   3.5981807858197784`*^9, 3.5981829314647827`*^9, 3.5981834319696016`*^9, 
   3.5981904743283978`*^9, 3.5981907743588176`*^9, 3.5981909204800224`*^9, 
   3.599550638666149*^9, 3.599552883683692*^9, 3.599554308247994*^9, 
   3.600328422460672*^9, 3.6208043421916428`*^9, 3.620804585122983*^9, 
   3.6208047640732336`*^9, 3.6801026839610925`*^9, 3.680103469434192*^9, 
   3.6801037751646204`*^9, 3.6801041468851404`*^9, 3.680104426856533*^9, 
   3.68010457488774*^9, 3.680104762838003*^9, 3.7290602964357977`*^9, 
   3.7290603936639347`*^9, 3.838805851932701*^9, 3.8388073502557497`*^9, 
   3.838808097349517*^9, 3.8388086593463416`*^9, 3.8388089883453865`*^9, 
   3.8388092360287266`*^9, 3.838809650220711*^9, 3.8396736621468306`*^9, 
   3.9561911613947163`*^9, 3.956191217009535*^9, 3.956191531396042*^9, 
   3.9561917715999527`*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"ffd8329b-76c8-164c-93b6-08b140ec8cf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IrrDecS4", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "-", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544100998611199*^9, 3.5441010277676497`*^9}, 
   3.5449509680352974`*^9, 3.5451138352606945`*^9},
 CellLabel->
  "In[136]:=",ExpressionUUID->"db62f8cb-ff03-46b9-8be1-bbf0ac240e43"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.544101030435255*^9, 3.5441041377755127`*^9, 3.544105190684762*^9, {
   3.5441058065582438`*^9, 3.5441058360266953`*^9}, 3.5441060024009876`*^9, 
   3.544106049637871*^9, 3.544106686026388*^9, 3.5441068223238277`*^9, 
   3.544107211404111*^9, 3.544624947386513*^9, 3.544674116291353*^9, 
   3.5446741846892653`*^9, 3.5446742408974805`*^9, 3.5449364269639482`*^9, 
   3.544939796565673*^9, 3.5449467997205763`*^9, 3.5449468487046623`*^9, 
   3.5449506456285315`*^9, 3.5449509680352974`*^9, 3.5449517387896533`*^9, 
   3.5451131355526657`*^9, 3.545113457786832*^9, 3.545113567189824*^9, 
   3.5451138352606945`*^9, 3.567936173669222*^9, 3.568123729764081*^9, 
   3.5681249937261014`*^9, {3.5921211554972973`*^9, 3.5921211695173173`*^9}, 
   3.592121451358712*^9, 3.5921226885504436`*^9, 3.592123390693427*^9, 
   3.5921258901679263`*^9, 3.5921260681381755`*^9, 3.592127273700864*^9, 
   3.592128066211973*^9, 3.592128224423195*^9, 3.5921284087434525`*^9, 
   3.5921288729241023`*^9, 3.5921326073493867`*^9, 3.592133298050354*^9, 
   3.592133677561885*^9, 3.592143816012171*^9, 3.5922243970138826`*^9, 
   3.5922244603439713`*^9, 3.592225047635793*^9, 3.592225441686345*^9, 
   3.5922276506604376`*^9, 3.592231788902078*^9, 3.5922318990722322`*^9, 
   3.592232233972701*^9, 3.59223268749754*^9, 3.5922330308041763`*^9, 
   3.592233126194632*^9, 3.592235089085903*^9, 3.5922354029918575`*^9, 
   3.5981798382674513`*^9, 3.5981800139086976`*^9, 3.5981804652693295`*^9, 
   3.598180689199643*^9, 3.5981807858297787`*^9, 3.598182931484782*^9, 
   3.5981834319896016`*^9, 3.5981904743383975`*^9, 3.5981907744588175`*^9, 
   3.598190920500022*^9, 3.599550638728549*^9, 3.599552883699292*^9, 
   3.599554308279194*^9, 3.600328422480672*^9, 3.620804342201643*^9, 
   3.620804585132983*^9, 3.620804764083234*^9, 3.6801026839810925`*^9, 
   3.680103469444192*^9, 3.6801037751646204`*^9, 3.6801041468951406`*^9, 
   3.680104426866533*^9, 3.68010457489774*^9, 3.6801047628480034`*^9, 
   3.729060296455797*^9, 3.7290603936739345`*^9, 3.838805852000492*^9, 
   3.8388073502866683`*^9, 3.8388080973784437`*^9, 3.838808659375264*^9, 
   3.8388089883743086`*^9, 3.8388092360596743`*^9, 3.8388096502496376`*^9, 
   3.8396736621727343`*^9, 3.956191161410675*^9, 3.956191217024494*^9, 
   3.9561915314149895`*^9, 3.956191771614887*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"9948bb72-b632-db45-aca7-fca089bf994e"]
}, Open  ]],

Cell["\<\
The decomposition can be simplified further. We see that the left hand side \
of IrrDecS4 is symmetric in {-A,-B,-C}, but this is not obvoius on the right \
hand side.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, {
   3.5441006869840517`*^9, 3.544100710805293*^9}, {3.544100786278226*^9, 
   3.544100848570135*^9}, {3.544101063023712*^9, 3.54410126136246*^9}, 
   3.5449509680352974`*^9, 
   3.5451138352606945`*^9},ExpressionUUID->"4a187d18-f2a7-4ef5-b02d-\
daf39e866877"],

Cell[CellGroupData[{

Cell[BoxData["IrrDecS4"], "Input",
 CellChangeTimes->{3.5449509680352974`*^9, 3.5451138352606945`*^9},
 CellLabel->
  "In[137]:=",ExpressionUUID->"905b0247-c03d-430f-afd4-9678b39de213"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S4", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S4[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "12"]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"C", "D", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-C, -D, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"B", "D", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`B, -D, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"B", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`B, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "D", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -D, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "B", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -$CellContext`B, $CellContext`F, \
-$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "1234", ")"}],
           FontSize->Tiny]], "[", "S4", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`S4}, 
     Symmetric[{1, 2, 3, 4}], "(1234)"][-$CellContext`A, -$CellContext`B, -
     C, -D],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.544101126079023*^9, 3.544101266448069*^9, 3.544104137806713*^9, 
   3.544104248956908*^9, 3.544105190700362*^9, {3.544105806573844*^9, 
   3.5441058360422955`*^9}, 3.544106002432188*^9, 3.5441060496690707`*^9, 
   3.5441066860575886`*^9, 3.544106822355028*^9, 3.5441072114353113`*^9, 
   3.5446249474145145`*^9, 3.5446741163223553`*^9, 3.544674184713267*^9, 
   3.5446742409394827`*^9, 3.5449364269951487`*^9, 3.544939796596873*^9, 
   3.5449467997517757`*^9, 3.5449468487358623`*^9, 3.544950645659731*^9, 
   3.5449509680508976`*^9, 3.544951738820853*^9, 3.545113135568266*^9, 
   3.5451134578180323`*^9, 3.5451135672054243`*^9, 3.5451138352762947`*^9, 
   3.5679361736848216`*^9, 3.5681237297952814`*^9, 3.568124993741701*^9, 
   3.5921211718873205`*^9, 3.5921214513787117`*^9, 3.592122688570444*^9, 
   3.592123391253428*^9, 3.5921258901879263`*^9, 3.5921260681581755`*^9, 
   3.5921272737208633`*^9, 3.5921280662319727`*^9, 3.5921282244531946`*^9, 
   3.592128408993453*^9, 3.5921288729641027`*^9, 3.592132607379387*^9, 
   3.592133298260354*^9, 3.5921336775818853`*^9, 3.592143816032171*^9, 
   3.592224475283992*^9, 3.592225047655793*^9, 3.592225441726345*^9, 
   3.5922276506904373`*^9, 3.592231788922078*^9, 3.5922318990922327`*^9, 
   3.5922322339927015`*^9, 3.5922326875215416`*^9, 3.5922330308321776`*^9, 
   3.5922331262106333`*^9, 3.5922350891099043`*^9, 3.5922354030208592`*^9, 
   3.5981798382874517`*^9, 3.5981800139286976`*^9, 3.5981804652893295`*^9, 
   3.598180689219643*^9, 3.598180785849778*^9, 3.5981829315047827`*^9, 
   3.5981834320096016`*^9, 3.5981904743683977`*^9, 3.598190774478818*^9, 
   3.5981909205200224`*^9, 3.5995506387441487`*^9, 3.599552883714892*^9, 
   3.599554308294794*^9, 3.6003284225006723`*^9, 3.6208043422216425`*^9, 
   3.6208045851429834`*^9, 3.6208047641032333`*^9, 3.6801026840410924`*^9, 
   3.6801034694641924`*^9, 3.68010377519462*^9, 3.680104146925141*^9, 
   3.680104426896533*^9, 3.68010457492774*^9, 3.680104762868003*^9, 
   3.729060296485798*^9, 3.7290603937039347`*^9, 3.8388058520852923`*^9, 
   3.8388073503435183`*^9, 3.8388080974213276`*^9, 3.8388086594191465`*^9, 
   3.8388089884142027`*^9, 3.838809236103527*^9, 3.8388096502905245`*^9, 
   3.839673662208665*^9, 3.9561911614405956`*^9, 3.956191217044443*^9, 
   3.9561915314399223`*^9, 3.9561917716388493`*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"b741f20c-2d37-a54e-9160-a4f1e038a4c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IrrDecS4", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "==", 
  RowBox[{"ToCanonical", "@", 
   RowBox[{"ImposeSymmetry", "[", 
    RowBox[{
     RowBox[{"IrrDecS4", "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"IndexList", "[", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "B"}], ",", 
       RowBox[{"-", "C"}]}], "]"}], ",", 
     RowBox[{"Symmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}]}]}]], "Input",\

 CellChangeTimes->{{3.544104333321856*^9, 3.5441043392498665`*^9}, {
   3.5441065951874285`*^9, 3.5441066057174473`*^9}, 3.5449509680508976`*^9, 
   3.5451138352762947`*^9},
 CellLabel->
  "In[138]:=",ExpressionUUID->"5662c251-33e6-45f2-89be-c475d3c6676d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S4", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S4[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"B", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`B, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "B", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -$CellContext`B, $CellContext`F, \
-$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "1234", ")"}],
           FontSize->Tiny]], "[", "S4", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`S4}, 
     Symmetric[{1, 2, 3, 4}], "(1234)"][-$CellContext`A, -$CellContext`B, -
     C, -D],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.544104339702267*^9, 3.5441051907783623`*^9, {3.544105806651844*^9, 
   3.5441058361202955`*^9}, 3.544106002510188*^9, 3.5441060497626705`*^9, 
   3.5441066861355886`*^9, 3.5441068225266285`*^9, 3.544107211497711*^9, 
   3.544624947491519*^9, 3.5446741164033594`*^9, 3.544674184793271*^9, 
   3.544674241021487*^9, 3.544936427104349*^9, 3.544939796690473*^9, 
   3.5449467998297763`*^9, 3.5449468488138623`*^9, 3.544950645753331*^9, 
   3.5449509680508976`*^9, 3.5449517388988533`*^9, 3.545113135646266*^9, 
   3.5451134578960323`*^9, 3.5451135672834244`*^9, 3.5451138352762947`*^9, 
   3.567936173762822*^9, 3.5681237298732815`*^9, 3.5681249938197017`*^9, 
   3.5921211807173333`*^9, 3.592121451458712*^9, 3.5921226886604443`*^9, 
   3.5921233914834285`*^9, 3.5921258902779264`*^9, 3.5921260682481756`*^9, 
   3.5921272738008633`*^9, 3.592128066321973*^9, 3.592128224543195*^9, 
   3.5921284100134544`*^9, 3.592128873064103*^9, 3.5921326074793873`*^9, 
   3.5921332992103553`*^9, 3.5921336776718855`*^9, 3.5921438161321707`*^9, 
   3.592224480223999*^9, 3.5922250477457933`*^9, 3.5922254418263454`*^9, 
   3.5922276507804375`*^9, 3.5922317890120783`*^9, 3.5922318991822324`*^9, 
   3.5922322340927014`*^9, 3.592232687613547*^9, 3.5922330308591795`*^9, 
   3.592233126299638*^9, 3.5922350892029095`*^9, 3.592235403120865*^9, 
   3.598179838387452*^9, 3.5981800140186977`*^9, 3.5981804653793297`*^9, 
   3.5981806893096433`*^9, 3.5981807859497786`*^9, 3.5981829315947824`*^9, 
   3.5981834321196012`*^9, 3.598190474458398*^9, 3.598190774568818*^9, 
   3.5981909206100225`*^9, 3.5995506387597485`*^9, 3.599552888691301*^9, 
   3.5995543083883944`*^9, 3.6003284225906725`*^9, 3.620804342291643*^9, 
   3.6208045852229834`*^9, 3.6208047641732335`*^9, 3.6801026841110926`*^9, 
   3.680103469534192*^9, 3.6801037752646203`*^9, 3.680104146995141*^9, 
   3.6801044269665327`*^9, 3.68010457498774*^9, 3.6801047629480033`*^9, 
   3.729060296565798*^9, 3.729060393773935*^9, 3.8388058521431413`*^9, 
   3.83880735039837*^9, 3.8388080974791727`*^9, 3.8388086594769917`*^9, 
   3.838808988469079*^9, 3.8388092361594048`*^9, 3.838809650345381*^9, 
   3.839673662263517*^9, 3.9561911614984646`*^9, 3.956191217096306*^9, 
   3.9561915314957714`*^9, 3.9561917716937065`*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"d9c4518b-37a2-084e-945e-aa6e6534b083"]
}, Open  ]],

Cell["\<\
If we use the option UseSym, the function will automatically finds this \
symmetry and imposes it\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, {
   3.5441006869840517`*^9, 3.544100710805293*^9}, {3.544100786278226*^9, 
   3.544100848570135*^9}, {3.544101063023712*^9, 3.54410126136246*^9}, {
   3.544106619523472*^9, 3.544106657946339*^9}, 3.5449509680508976`*^9, 
   3.5451138352762947`*^9, {3.5922244959640207`*^9, 
   3.5922245603541107`*^9}},ExpressionUUID->"6fbf6c81-85a2-4033-ad29-\
488f3e618816"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrrDecS4b", "=", 
  RowBox[{"IrrDecompose", "[", 
   RowBox[{
    RowBox[{"S4", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "C"}], ",", 
      RowBox[{"-", "D"}]}], "]"}], ",", 
    RowBox[{"UseSym", "->", "True"}], ",", 
    RowBox[{"ResultType", "->", "\"\<Equation\>\""}], ",", 
    RowBox[{"TimeVerbose", "->", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544105212852401*^9, 3.544105234630039*^9}, 
   3.5441053005245547`*^9, 3.5449509680508976`*^9, 3.5451138352762947`*^9, {
   3.5922245859241467`*^9, 3.5922246101841807`*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"ad8d1791-abea-4c48-b8ee-2e6c0dbda794"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IrrDecompose step 1 timing:\"\>", "\[InvisibleSpace]", 
   "0.050929`"}],
  SequenceForm["IrrDecompose step 1 timing:", 0.050929],
  Editable->False]], "Print",
 CellChangeTimes->{3.599552888800501*^9, 3.5995543084819946`*^9, 
  3.6003284226906724`*^9, 3.620804342371643*^9, 3.620804585292983*^9, 
  3.6208047642432337`*^9, 3.6801026841810927`*^9, 3.6801034696041927`*^9, 
  3.6801037753246202`*^9, 3.6801041470651407`*^9, 3.680104427036533*^9, 
  3.68010457505774*^9, 3.6801047630180035`*^9, 3.7290602966457977`*^9, 
  3.729060393843935*^9, 3.8388058522019773`*^9, 3.838807350454219*^9, 
  3.838808097532031*^9, 3.8388086595288534`*^9, 3.8388089885687885`*^9, 
  3.838809236215228*^9, 3.8388096504022017`*^9, 3.839673662319366*^9, 
  3.9561911615572834`*^9, 3.9561912171491623`*^9, 3.9561915315486317`*^9, 
  3.956191771748562*^9},
 CellLabel->
  "During evaluation of \
In[139]:=",ExpressionUUID->"b0bb5384-963d-4c4f-89ef-8e6116c97b83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IrrDecompose step 2 timing:\"\>", "\[InvisibleSpace]", 
   "0.0422774`"}],
  SequenceForm["IrrDecompose step 2 timing:", 0.0422774],
  Editable->False]], "Print",
 CellChangeTimes->{3.599552888800501*^9, 3.5995543084819946`*^9, 
  3.6003284226906724`*^9, 3.620804342371643*^9, 3.620804585292983*^9, 
  3.6208047642432337`*^9, 3.6801026841810927`*^9, 3.6801034696041927`*^9, 
  3.6801037753246202`*^9, 3.6801041470651407`*^9, 3.680104427036533*^9, 
  3.68010457505774*^9, 3.6801047630180035`*^9, 3.7290602966457977`*^9, 
  3.729060393843935*^9, 3.8388058522019773`*^9, 3.838807350454219*^9, 
  3.838808097532031*^9, 3.8388086595288534`*^9, 3.8388089885687885`*^9, 
  3.838809236215228*^9, 3.8388096504022017`*^9, 3.839673662319366*^9, 
  3.9561911615572834`*^9, 3.9561912171491623`*^9, 3.9561915315486317`*^9, 
  3.956191771790447*^9},
 CellLabel->
  "During evaluation of \
In[139]:=",ExpressionUUID->"fd258a1d-206a-5c4f-855a-20db8cdb3a02"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S4", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S4[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"B", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`B, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "C", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -C, $CellContext`F, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S4", 
         StyleBox[GridBox[{
            {" ", " ", "F", " "},
            {"A", "B", " ", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S4[-$CellContext`A, -$CellContext`B, $CellContext`F, \
-$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "1234", ")"}],
           FontSize->Tiny]], "[", "S4", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`S4}, 
     Symmetric[{1, 2, 3, 4}], "(1234)"][-$CellContext`A, -$CellContext`B, -
     C, -D],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{{3.5441052195136127`*^9, 3.5441052354568405`*^9}, 
   3.544105302817759*^9, {3.544105806807844*^9, 3.544105836260696*^9}, 
   3.544106002650588*^9, 3.5441060499654713`*^9, 3.544106686338389*^9, 
   3.544106823072629*^9, 3.544107211700512*^9, 3.54462494768053*^9, 
   3.5446741165933704`*^9, 3.5446741849892826`*^9, 3.5446742412415*^9, 
   3.544936427307149*^9, 3.5449397969244733`*^9, 3.5449468000169764`*^9, 
   3.5449468490010624`*^9, 3.5449506459405317`*^9, 3.544950968066498*^9, 
   3.5449517391016536`*^9, 3.5451131358334665`*^9, 3.5451134580832324`*^9, 
   3.5451135674862247`*^9, 3.545113835291895*^9, 3.567936173903222*^9, 
   3.5681237300136814`*^9, 3.568124993960102*^9, 3.59212118584734*^9, 
   3.5921214516387124`*^9, 3.5921226888404446`*^9, 3.592123394293432*^9, 
   3.5921258904579268`*^9, 3.592126068428176*^9, 3.5921272739708643`*^9, 
   3.592128066501973*^9, 3.5921282247331953`*^9, 3.5921284103534546`*^9, 
   3.592128873264103*^9, 3.592132607679387*^9, 3.5921332998803563`*^9, 
   3.592133677851886*^9, 3.592143816312171*^9, {3.5922245901041527`*^9, 
   3.592224611684183*^9}, 3.592225047935794*^9, 3.5922254420363455`*^9, 
   3.592227650980438*^9, 3.592231789202079*^9, 3.5922318993622327`*^9, 
   3.5922322342827015`*^9, 3.5922326878035574`*^9, 3.592233030886181*^9, 
   3.592233126475648*^9, 3.59223508938992*^9, 3.592235403315876*^9, 
   3.598179838567452*^9, 3.5981800142086983`*^9, 3.59818046555933*^9, 
   3.598180689489643*^9, 3.598180786129779*^9, 3.598182931774783*^9, 
   3.598183432319602*^9, 3.598190474638398*^9, 3.598190774748818*^9, 
   3.598190920790023*^9, 3.599550638790949*^9, 3.599552888878501*^9, 
   3.5995543085599947`*^9, 3.6003284227706723`*^9, 3.620804342441643*^9, 
   3.6208045853629837`*^9, 3.6208047643132343`*^9, 3.680102684271093*^9, 
   3.6801034696741924`*^9, 3.6801037754046206`*^9, 3.6801041471451406`*^9, 
   3.680104427106533*^9, 3.68010457513774*^9, 3.680104763088003*^9, 
   3.729060296715798*^9, 3.7290603939139347`*^9, 3.838805852296727*^9, 
   3.8388073505370016`*^9, 3.838808097606804*^9, 3.8388086596096373`*^9, 
   3.838808988648576*^9, 3.838809236296013*^9, 3.8388096504829855`*^9, 
   3.8396736623841686`*^9, 3.9561911616151543`*^9, 3.9561912172089767`*^9, 
   3.9561915316164246`*^9, 3.956191771806402*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"b85b30ff-748a-8543-95b7-22d80158afa4"]
}, Open  ]],

Cell["Larger cases can be handled", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, {
   3.5441006869840517`*^9, 3.544100710805293*^9}, {3.544100786278226*^9, 
   3.544100848570135*^9}, {3.544101063023712*^9, 3.54410126136246*^9}, {
   3.544106619523472*^9, 3.544106657946339*^9}, {3.5441067214228506`*^9, 
   3.544106730829667*^9}, 3.544950968066498*^9, 
   3.545113835291895*^9},ExpressionUUID->"9d79f6b0-7166-48e1-bf60-\
5c44b34e4bef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrrDecompose", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalOmega]4", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "C"}], ",", "L"}], "]"}], 
    RowBox[{"\[CapitalOmega]4", "[", 
     RowBox[{
      RowBox[{"-", "D"}], ",", 
      RowBox[{"-", "F"}], ",", 
      RowBox[{"-", "H"}], ",", 
      RowBox[{"-", "L"}]}], "]"}]}], ",", 
   RowBox[{"ResultType", "->", "\"\<Equation\>\""}], ",", 
   RowBox[{"TimeVerbose", "->", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544105370147477*^9, 3.544105419162763*^9}, {
   3.544105773626586*^9, 3.544105774094587*^9}, 3.5441067094264297`*^9, 
   3.544950968066498*^9, 3.545113835291895*^9, {3.5922246283642063`*^9, 
   3.5922246369342184`*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"9bf2b29f-a719-4376-ab75-4d3c9814dd21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IrrDecompose step 1 timing:\"\>", "\[InvisibleSpace]", 
   "1.265883`"}],
  SequenceForm["IrrDecompose step 1 timing:", 1.265883],
  Editable->False]], "Print",
 CellChangeTimes->{3.599552891436906*^9, 3.599554311149599*^9, 
  3.6003284255206766`*^9, 3.6208043443616457`*^9, 3.620804587162986*^9, 
  3.620804766183236*^9, 3.680102685931095*^9, 3.6801034712641945`*^9, 
  3.680103777024623*^9, 3.680104148745143*^9, 3.6801044287465353`*^9, 
  3.6801045767877426`*^9, 3.6801047647280054`*^9, 3.7290602982868*^9, 
  3.729060395463937*^9, 3.838805853533416*^9, 3.83880735175574*^9, 
  3.8388080988365145`*^9, 3.838808660850319*^9, 3.8388089898852673`*^9, 
  3.838809237510763*^9, 3.8388096517236915`*^9, 3.8396736636308365`*^9, 
  3.956191162877779*^9, 3.9561912184716263`*^9, 3.9561915328770523`*^9, 
  3.956191773075983*^9},
 CellLabel->
  "During evaluation of \
In[140]:=",ExpressionUUID->"0e39547c-2696-1b43-861d-ef987213d35f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IrrDecompose step 2 timing:\"\>", "\[InvisibleSpace]", 
   "0.3744835`"}],
  SequenceForm["IrrDecompose step 2 timing:", 0.3744835],
  Editable->False]], "Print",
 CellChangeTimes->{3.599552891436906*^9, 3.599554311149599*^9, 
  3.6003284255206766`*^9, 3.6208043443616457`*^9, 3.620804587162986*^9, 
  3.620804766183236*^9, 3.680102685931095*^9, 3.6801034712641945`*^9, 
  3.680103777024623*^9, 3.680104148745143*^9, 3.6801044287465353`*^9, 
  3.6801045767877426`*^9, 3.6801047647280054`*^9, 3.7290602982868*^9, 
  3.729060395463937*^9, 3.838805853533416*^9, 3.83880735175574*^9, 
  3.8388080988365145`*^9, 3.838808660850319*^9, 3.8388089898852673`*^9, 
  3.838809237510763*^9, 3.8388096517236915`*^9, 3.8396736636308365`*^9, 
  3.956191162877779*^9, 3.9561912184716263`*^9, 3.9561915328770523`*^9, 
  3.9561917734599857`*^9},
 CellLabel->
  "During evaluation of \
In[140]:=",ExpressionUUID->"d0773b22-81f8-7b47-bad0-1891c61d8e08"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalOmega]", 
        StyleBox[GridBox[{
           {" ", " ", " ", "L"},
           {"A", "B", "C", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega]4[-$CellContext`A, -$CellContext`B, -
     C, $CellContext`L],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalOmega]", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"D", "F", "H", "L"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega]4[-
     D, -$CellContext`F, -$CellContext`H, -$CellContext`L],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "24"]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"L", "M", "P", "Q"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`L, $CellContext`M, \
$CellContext`P, $CellContext`Q],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"L", "M", "P", "Q"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`L, $CellContext`M, \
$CellContext`P, $CellContext`Q],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"L", "M", "P", "Q"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`L, $CellContext`M, \
$CellContext`P, $CellContext`Q],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"L", "M", "P", "Q"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`L, $CellContext`M, \
$CellContext`P, $CellContext`Q],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"L", "M", "P", "Q"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`L, $CellContext`M, \
$CellContext`P, $CellContext`Q],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"L", "M", "P", "Q"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`L, $CellContext`M, \
$CellContext`P, $CellContext`Q],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "L", "M", " ", " ", " ", " "},
            {"A", "B", " ", " ", "D", "F", "L", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`L, \
$CellContext`M, -D, -$CellContext`F, -$CellContext`L, -$CellContext`M],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "L", "M", " ", " ", " ", " "},
            {"A", "B", " ", " ", "D", "H", "L", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`L, \
$CellContext`M, -D, -$CellContext`H, -$CellContext`L, -$CellContext`M],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "L", "M", " ", " ", " ", " "},
            {"A", "B", " ", " ", "F", "H", "L", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`L, \
$CellContext`M, -$CellContext`F, -$CellContext`H, -$CellContext`L, \
-$CellContext`M],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "L", "M", " ", " ", " ", " "},
            {"A", "C", " ", " ", "D", "F", "L", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`L, $CellContext`M, -
      D, -$CellContext`F, -$CellContext`L, -$CellContext`M],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "L", "M", " ", " ", " ", " "},
            {"A", "C", " ", " ", "D", "H", "L", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`L, $CellContext`M, -
      D, -$CellContext`H, -$CellContext`L, -$CellContext`M],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "L", "M", " ", " ", " ", " "},
            {"A", "C", " ", " ", "F", "H", "L", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`L, $CellContext`M, -$CellContext`F, -$CellContext`H, \
-$CellContext`L, -$CellContext`M],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "L", "M", " ", " ", " ", " "},
            {"B", "C", " ", " ", "D", "F", "L", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`L, $CellContext`M, -
      D, -$CellContext`F, -$CellContext`L, -$CellContext`M],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "L", "M", " ", " ", " ", " "},
            {"B", "C", " ", " ", "D", "H", "L", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`L, $CellContext`M, -
      D, -$CellContext`H, -$CellContext`L, -$CellContext`M],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "L", "M", " ", " ", " ", " "},
            {"B", "C", " ", " ", "F", "H", "L", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`L, $CellContext`M, -$CellContext`F, -$CellContext`H, \
-$CellContext`L, -$CellContext`M],
     Editable->False]}]}]}]], "Output",
 CellChangeTimes->{{3.5441053932043176`*^9, 3.54410542303157*^9}, 
   3.5441058568215322`*^9, 3.544106109229975*^9, 3.544106825631034*^9, 
   3.544107214180916*^9, 3.544624950152672*^9, 3.544674119104514*^9, 
   3.544674187479425*^9, 3.5446742437566442`*^9, 3.5449364301151543`*^9, 
   3.5449397998260784`*^9, 3.544946802512981*^9, 3.5449468514814672`*^9, 
   3.544950648452136*^9, 3.5449509680820975`*^9, 3.544951741597658*^9, 
   3.545113138282671*^9, 3.545113460579237*^9, 3.5451135700134287`*^9, 
   3.545113835307495*^9, 3.5679361872568455`*^9, 3.568123743429705*^9, 
   3.568125007329325*^9, 3.5921211953673534`*^9, 3.5921214560987186`*^9, 
   3.5921226921304493`*^9, 3.592123397873437*^9, 3.5921258937479315`*^9, 
   3.592126071728181*^9, 3.5921272773508687`*^9, 3.5921280698119783`*^9, 
   3.5921282280931997`*^9, 3.592128415293462*^9, 3.5921288785141106`*^9, 
   3.5921326110893917`*^9, 3.592133304980364*^9, 3.59213368111189*^9, 
   3.592143819612176*^9, 3.5922246423742256`*^9, 3.5922250512957983`*^9, 
   3.59222544542635*^9, 3.5922276543204427`*^9, 3.5922317925620832`*^9, 
   3.592231902662237*^9, 3.592232237652706*^9, 3.59223269116775*^9, 
   3.592233030896181*^9, 3.5922331298318405`*^9, 3.5922350927831144`*^9, 
   3.5922354066650677`*^9, 3.598179841977457*^9, 3.5981800175287027`*^9, 
   3.5981804689093347`*^9, 3.598180692809648*^9, 3.598180789429783*^9, 
   3.5981829351047873`*^9, 3.598183442889617*^9, 3.598190477988403*^9, 
   3.598190778078823*^9, 3.598190924100027*^9, 3.599550638790949*^9, 
   3.5995528920765066`*^9, 3.5995543118204*^9, 3.600328426170677*^9, 
   3.620804344891647*^9, 3.620804587712987*^9, 3.6208047667332373`*^9, 
   3.680102686461096*^9, 3.6801034718041954`*^9, 3.6801037775546236`*^9, 
   3.680104149275144*^9, 3.680104429276536*^9, 3.6801045773277435`*^9, 
   3.680104765258006*^9, 3.729060298806801*^9, 3.7290603959939375`*^9, 
   3.838805854054027*^9, 3.8388073521796074`*^9, 3.8388080992683873`*^9, 
   3.838808661295129*^9, 3.838808990319107*^9, 3.8388092379386177`*^9, 
   3.838809652149555*^9, 3.839673664038775*^9, 3.9561911632767124`*^9, 
   3.956191218889509*^9, 3.9561915333019447`*^9, 3.9561917734919033`*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"2306631f-0fba-a849-af23-70ee0a16b8f8"]
}, Open  ]],

Cell["\<\
For even larger cases we can save some time by using the option \
IrrDecImposeNewMethod\[Rule]True.\
\>", "MathCaption",
 CellChangeTimes->{{3.518749805372766*^9, 3.518749875448089*^9}, {
   3.5441001053214297`*^9, 3.544100145725501*^9}, {3.5441003968235416`*^9, 
   3.544100417197178*^9}, {3.544100455339245*^9, 3.5441004666960645`*^9}, {
   3.5441006869840517`*^9, 3.544100710805293*^9}, {3.544100786278226*^9, 
   3.544100848570135*^9}, {3.544101063023712*^9, 3.54410126136246*^9}, {
   3.544106619523472*^9, 3.544106657946339*^9}, {3.5441067214228506`*^9, 
   3.544106769330535*^9}, 3.5449509680820975`*^9, 3.545113835307495*^9, {
   3.5921213167385235`*^9, 3.5921213212185297`*^9}, {3.5921213855686197`*^9, 
   3.5921214245786743`*^9}, {3.592224653915242*^9, 
   3.5922246549452434`*^9}},ExpressionUUID->"c8bf42f3-a9e8-4c93-bbea-\
c6df7f584a84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IrrDecompose", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalOmega]4", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "C"}], ",", 
      RowBox[{"-", "D"}]}], "]"}], 
    RowBox[{"\[CapitalOmega]4", "[", 
     RowBox[{
      RowBox[{"-", "F"}], ",", 
      RowBox[{"-", "H"}], ",", 
      RowBox[{"-", "L"}], ",", 
      RowBox[{"-", "M"}]}], "]"}]}], ",", 
   RowBox[{"ResultType", "->", "\"\<Equation\>\""}], ",", 
   RowBox[{"TimeVerbose", "->", "True"}], ",", 
   RowBox[{"IrrDecImposeNewMethod", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5441067408916845`*^9, 3.544106751889704*^9}, 
   3.5449509680820975`*^9, 3.545113835307495*^9, {3.59212130698851*^9, 
   3.5921213108085155`*^9}, {3.5922246579252477`*^9, 3.5922246727052684`*^9}},
 
 CellLabel->
  "In[141]:=",ExpressionUUID->"add5c861-080f-4cbf-af27-7d070989d452"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IrrDecompose step 1 timing:\"\>", "\[InvisibleSpace]", 
   "4.326062`"}],
  SequenceForm["IrrDecompose step 1 timing:", 4.326062],
  Editable->False]], "Print",
 CellChangeTimes->{3.5995529000481205`*^9, 3.599554319916815*^9, 
  3.6003284343006887`*^9, 3.6208043509826555`*^9, 3.6208045935029945`*^9, 
  3.6208047726332455`*^9, 3.6801026921411037`*^9, 3.6801034775442038`*^9, 
  3.6801037832546315`*^9, 3.6801041549851522`*^9, 3.6801044348165436`*^9, 
  3.680104582857751*^9, 3.680104770808014*^9, 3.729060304407809*^9, 
  3.7290604014249454`*^9, 3.8388058583974075`*^9, 3.838807356504035*^9, 
  3.8388081035768657`*^9, 3.8388086657185726`*^9, 3.8388089946584997`*^9, 
  3.8388092422281446`*^9, 3.8388096565457945`*^9, 3.839673668421032*^9, 
  3.9561911676420364`*^9, 3.9561912232508736`*^9, 3.956191537657295*^9, 
  3.95619177784124*^9},
 CellLabel->
  "During evaluation of \
In[141]:=",ExpressionUUID->"e107955a-3748-d741-aba9-9a802e621e00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IrrDecompose step 2 timing:\"\>", "\[InvisibleSpace]", 
   "22.3347428`"}],
  SequenceForm["IrrDecompose step 2 timing:", 22.3347428],
  Editable->False]], "Print",
 CellChangeTimes->{3.5995529000481205`*^9, 3.599554319916815*^9, 
  3.6003284343006887`*^9, 3.6208043509826555`*^9, 3.6208045935029945`*^9, 
  3.6208047726332455`*^9, 3.6801026921411037`*^9, 3.6801034775442038`*^9, 
  3.6801037832546315`*^9, 3.6801041549851522`*^9, 3.6801044348165436`*^9, 
  3.680104582857751*^9, 3.680104770808014*^9, 3.729060304407809*^9, 
  3.7290604014249454`*^9, 3.8388058583974075`*^9, 3.838807356504035*^9, 
  3.8388081035768657`*^9, 3.8388086657185726`*^9, 3.8388089946584997`*^9, 
  3.8388092422281446`*^9, 3.8388096565457945`*^9, 3.839673668421032*^9, 
  3.9561911676420364`*^9, 3.9561912232508736`*^9, 3.956191537657295*^9, 
  3.9561918001765137`*^9},
 CellLabel->
  "During evaluation of \
In[141]:=",ExpressionUUID->"546e93d8-d5a0-354d-8492-38217287e04c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalOmega]", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega]4[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalOmega]", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"F", "H", "L", "M"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega]4[-$CellContext`F, -$CellContext`H, \
-$CellContext`L, -$CellContext`M],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"P", "Q", "R", "R1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[-$CellContext`P, -$CellContext`Q, \
-$CellContext`R, -$CellContext`R1],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalOmega]", 
         StyleBox[GridBox[{
            {"P", "Q", "R", "R1"},
            {" ", " ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalOmega]4[$CellContext`P, $CellContext`Q, \
$CellContext`R, $CellContext`R1],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`F, -$CellContext`H, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`F, -$CellContext`H, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`F, -$CellContext`L, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`F, -$CellContext`L, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`F, -$CellContext`M, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`F, -$CellContext`M, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`H, -$CellContext`L, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`H, -$CellContext`L, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`H, -$CellContext`M, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`H, -$CellContext`M, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`L, -$CellContext`M, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "B", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], 
      "(1256)"][-$CellContext`A, -$CellContext`B, $CellContext`P, \
$CellContext`Q, -$CellContext`L, -$CellContext`M, -$CellContext`P, \
-$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "C", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"A", "D", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`A, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"D", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-D, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "C", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      C, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"B", "D", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-$CellContext`B, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "F", "H", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`H, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "F", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "F", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`F, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "M"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`M],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "H", "L", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`L, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "L"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`L],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "H", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`H, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "F"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`F],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "H"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`H],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{"(", "1256", ")"}],
            FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", 
          "]"}], 
         StyleBox[GridBox[{
            {" ", " ", "P", "Q", " ", " ", " ", " "},
            {"C", "D", " ", " ", "L", "M", "P", "Q"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
      Symmetric[{1, 2, 5, 6}], "(1256)"][-C, -
      D, $CellContext`P, $CellContext`Q, -$CellContext`L, -$CellContext`M, \
-$CellContext`P, -$CellContext`Q],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{"(", "12345678", ")"}],
           FontSize->Tiny]], "[", "\[CapitalOmega]", "\[CapitalOmega]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " ", " ", " ", " ", " "},
           {"A", "B", "C", "D", "F", "H", "L", "M"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`\[CapitalOmega]4, $CellContext`\
\[CapitalOmega]4}, 
     Symmetric[{1, 2, 3, 4, 5, 6, 7, 8}], 
     "(12345678)"][-$CellContext`A, -$CellContext`B, -C, -
     D, -$CellContext`F, -$CellContext`H, -$CellContext`L, -$CellContext`M],
    Editable->False]}]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwV0F1IU3EYBvBzkHXEooat9eWGzYsWo0UYZLBVf5aV6DYQUxgmGAqZuiln
zhqyqFaGkQwqTSNrpU00yotRUiCDtPRC58ecsamJHmwdnbMFC6dp73vx8rt4
nouH99AVU24pTVGUHm48y7cVvsoTscUpMJbx5H6ZocsERm7WH2RB25Y2Zgbd
UmZvDZjeM2NDLY/vavvBfpPMghZvK7iDFk5WPkcbfOainCeQBzajLjD/+LSj
E6z4o6+t/MITrsr+CA3JBEojWJF86h7qiJzpM4GbBUU+tHM2rbwKexrFCNqn
cc+jOsO1NVRszkivBimhX8CC1a7QZXSDcz9A64w/bddBu9ez9gK0nvPLX4Ly
DokBfff1qNEJfo9a2ddgtFlzC/2Vq+1GUxXcAvqKmUlsB0e9ngMoN5Qq7ADb
prQnUUtv+8D6CE+aRA+DaF1GfPcGKE6OHUOT5qwqNJNXX/wHtjLf6lGb8/Bf
ysuTQMyVQoNzhT+U6HZ9YE/LGOzNHD/RCnoaLy2i54XN86IJnkjD7IIsDn8L
DtNp4Fvh/n1oQCKVq8uXSG+2qgH1hWp60BXH4iyaPcDTp0GGZUXo4M6wAk1p
vK1uG1wi6pL3WWgxJ4qstiyTqTc5Xb/BVfYDEwXFu2gdWpInqUU/5Sc1oUHl
xBCq0uV1P322TM6uf45P3ggT+8pH2g8mJiQcQae5HRfQ/9fWXFg=
  "],
 CellLabel->
  "Out[141]=",ExpressionUUID->"552df65a-20c7-724b-86d5-25a8c36d1352"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
More examples with irreducible decompositions of Spinors (New in 0.9.4)\
\>", "SubsubsectionIcon",
 CellChangeTimes->{{3.518749770615905*^9, 3.518749781317524*^9}, {
   3.5441000811725874`*^9, 3.54410009418301*^9}, 3.5449509679572973`*^9, {
   3.545113058582131*^9, 3.5451130709997525`*^9}, 3.545113835182695*^9, {
   3.5681238965127745`*^9, 3.568123898384777*^9}, {3.680102178937065*^9, 
   3.6801021823870697`*^9}, {3.680104859528138*^9, 
   3.680104869598152*^9}},ExpressionUUID->"9feca1a1-8f89-455d-b6e4-\
3d1ca7127338"],

Cell["\<\
When dealing with more advanced cases it can happen that the different \
irreducible pieces can be dependent of each other. In this section we see how \
one can eliminate dependent parts.\
\>", "Text",
 CellChangeTimes->{
  3.544950967645297*^9, 3.5451138348862944`*^9, {3.5921205425164394`*^9, 
   3.592120570116478*^9}, {3.6801024246307297`*^9, 3.680102472940797*^9}, 
   3.6801025895409603`*^9},
 FontWeight->"Plain",ExpressionUUID->"30c1f5dc-283a-46a9-80b8-de9a22fad874"],

Cell["\<\
We begin with a tensor with Riemann symmetries, but not the first Bianchi \
identity.\
\>", "Text",
 CellChangeTimes->{
  3.544950967645297*^9, 3.5451138348862944`*^9, {3.5921205425164394`*^9, 
   3.592120570116478*^9}, {3.6801024246307297`*^9, 3.680102472940797*^9}, {
   3.6801025895409603`*^9, 3.6801026625810623`*^9}, 3.839673737348335*^9},
 FontWeight->"Plain",ExpressionUUID->"b21deff7-1f01-4348-a43f-eb797e0a779e"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"RT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"RiemannSymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<R\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.679109993902308*^9, 3.679110027762355*^9}, {
  3.6791100635624056`*^9, 3.679110063832406*^9}, {3.679110119992484*^9, 
  3.679110124452491*^9}, {3.6791103670028305`*^9, 3.6791103813028507`*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"6f7596aa-e772-4f7e-8624-eea3e5312b87"],

Cell["Next, we define a spinor version of the tensor.", "Text",
 CellChangeTimes->{
  3.544950967645297*^9, 3.5451138348862944`*^9, {3.5921205425164394`*^9, 
   3.592120570116478*^9}, {3.6801024246307297`*^9, 3.680102472940797*^9}, {
   3.6801025895409603`*^9, 3.6801027034611197`*^9}},
 FontWeight->"Plain",ExpressionUUID->"6810d885-b96e-4f6f-9ba2-40880fed08fa"],

Cell[BoxData[
 RowBox[{"DefSpinorOfTensor", "[", 
  RowBox[{
   RowBox[{"RS", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], ",", 
   RowBox[{"RT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", "\[Sigma]", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<R\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6791100366523676`*^9, 3.679110096622452*^9}, {
  3.6791103861928573`*^9, 3.6791104169729004`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"c4e7b677-325c-41c5-bf3a-b9a6b507db66"],

Cell["We can decompose it with IrrDecompose.", "Text",
 CellChangeTimes->{
  3.544950967645297*^9, 3.5451138348862944`*^9, {3.5921205425164394`*^9, 
   3.592120570116478*^9}, {3.6801024246307297`*^9, 3.680102472940797*^9}, {
   3.6801025895409603`*^9, 3.6801027034611197`*^9}, {3.680102734441163*^9, 
   3.6801027439211764`*^9}},
 FontWeight->"Plain",ExpressionUUID->"32f81fc4-d4d5-4e30-adf2-7e953edd2ca0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"irrdec1", "=", 
  RowBox[{"IrrDecompose", "[", 
   RowBox[{
    RowBox[{"GiveIndicesToTensor", "@", "RS"}], ",", 
    RowBox[{"ResultType", "\[Rule]", "\"\<Equation\>\""}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.6801027126411324`*^9, 3.6801027228411465`*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"67d2cc35-d94d-4b97-b874-38cb1e12d48b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"R", 
       StyleBox[GridBox[{
          {" ", " ", " ", " ", " ", " ", " ", " "},
          {"A", 
           RowBox[{"A", "'"}], "B", 
           RowBox[{"B", "'"}], "C", 
           RowBox[{"C", "'"}], "D", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RS[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger], -C, -$CellContext`C\[Dagger], -
    D, -$CellContext`D\[Dagger]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"F", 
             RowBox[{"F", "'"}], " ", 
             RowBox[{"H", "'"}], "H", " ", " ", " "},
            {" ", " ", "F", " ", " ", 
             RowBox[{"F", "'"}], "H", 
             RowBox[{"H", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RS[$CellContext`F, $CellContext`F\[Dagger], \
-$CellContext`F, $CellContext`H\[Dagger], $CellContext`H, -$CellContext`F\
\[Dagger], -$CellContext`H, -$CellContext`H\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"B", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"F", 
             RowBox[{"F", "'"}], " ", 
             RowBox[{"H", "'"}], "H", " ", " ", " "},
            {" ", " ", "F", " ", " ", 
             RowBox[{"F", "'"}], "H", 
             RowBox[{"H", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RS[$CellContext`F, $CellContext`F\[Dagger], \
-$CellContext`F, $CellContext`H\[Dagger], $CellContext`H, -$CellContext`F\
\[Dagger], -$CellContext`H, -$CellContext`H\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"B", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"F", 
             RowBox[{"F", "'"}], "H", " ", " ", 
             RowBox[{"H", "'"}], " ", " "},
            {" ", " ", " ", 
             RowBox[{"F", "'"}], "F", " ", "H", 
             RowBox[{"H", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RS[$CellContext`F, $CellContext`F\[Dagger], $CellContext`H, \
-$CellContext`F\[Dagger], -$CellContext`F, $CellContext`H\[Dagger], \
-$CellContext`H, -$CellContext`H\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"C", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"F", 
             RowBox[{"F", "'"}], "H", " ", " ", 
             RowBox[{"H", "'"}], " ", " "},
            {" ", " ", " ", 
             RowBox[{"F", "'"}], "F", " ", "H", 
             RowBox[{"H", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RS[$CellContext`F, $CellContext`F\[Dagger], $CellContext`H, \
-$CellContext`F\[Dagger], -$CellContext`F, $CellContext`H\[Dagger], \
-$CellContext`H, -$CellContext`H\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -C],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"C", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"B", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{
             RowBox[{"(", "13", ")"}], 
             RowBox[{"(", "46", ")"}]}],
            FontSize->Tiny]], "[", "R", "]"}], 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"F", "'"}], " ", " ", "F", " ", " ", " "},
            {"A", " ", "B", 
             RowBox[{"A", "'"}], " ", 
             RowBox[{"C", "'"}], "F", 
             RowBox[{"F", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`RS}, 
      xAct`xPerm`StrongGenSet[{1, 4, 3, 6}, 
       xAct`xPerm`GenSet[
        xAct`xPerm`Cycles[{1, 3}], 
        xAct`xPerm`Cycles[{4, 6}]]], 
      "(13)(46)"][-$CellContext`A, $CellContext`F\[Dagger], -$CellContext`B, \
-$CellContext`A\[Dagger], $CellContext`F, -$CellContext`C\[Dagger], \
-$CellContext`F, -$CellContext`F\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"B", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{
             RowBox[{"(", "13", ")"}], 
             RowBox[{"(", "46", ")"}]}],
            FontSize->Tiny]], "[", "R", "]"}], 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"F", "'"}], " ", " ", "F", " ", " ", " "},
            {"A", " ", "B", 
             RowBox[{"A", "'"}], " ", 
             RowBox[{"D", "'"}], "F", 
             RowBox[{"F", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`RS}, 
      xAct`xPerm`StrongGenSet[{1, 4, 3, 6}, 
       xAct`xPerm`GenSet[
        xAct`xPerm`Cycles[{1, 3}], 
        xAct`xPerm`Cycles[{4, 6}]]], 
      "(13)(46)"][-$CellContext`A, $CellContext`F\[Dagger], -$CellContext`B, \
-$CellContext`A\[Dagger], $CellContext`F, -$CellContext`D\[Dagger], \
-$CellContext`F, -$CellContext`F\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{
             RowBox[{"(", "13", ")"}], 
             RowBox[{"(", "46", ")"}]}],
            FontSize->Tiny]], "[", "R", "]"}], 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"F", "'"}], " ", " ", "F", " ", " ", " "},
            {"A", " ", "B", 
             RowBox[{"B", "'"}], " ", 
             RowBox[{"C", "'"}], "F", 
             RowBox[{"F", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`RS}, 
      xAct`xPerm`StrongGenSet[{1, 4, 3, 6}, 
       xAct`xPerm`GenSet[
        xAct`xPerm`Cycles[{1, 3}], 
        xAct`xPerm`Cycles[{4, 6}]]], 
      "(13)(46)"][-$CellContext`A, $CellContext`F\[Dagger], -$CellContext`B, \
-$CellContext`B\[Dagger], $CellContext`F, -$CellContext`C\[Dagger], \
-$CellContext`F, -$CellContext`F\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{
             RowBox[{"(", "13", ")"}], 
             RowBox[{"(", "46", ")"}]}],
            FontSize->Tiny]], "[", "R", "]"}], 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"F", "'"}], " ", " ", "F", " ", " ", " "},
            {"A", " ", "B", 
             RowBox[{"B", "'"}], " ", 
             RowBox[{"D", "'"}], "F", 
             RowBox[{"F", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`RS}, 
      xAct`xPerm`StrongGenSet[{1, 4, 3, 6}, 
       xAct`xPerm`GenSet[
        xAct`xPerm`Cycles[{1, 3}], 
        xAct`xPerm`Cycles[{4, 6}]]], 
      "(13)(46)"][-$CellContext`A, $CellContext`F\[Dagger], -$CellContext`B, \
-$CellContext`B\[Dagger], $CellContext`F, -$CellContext`D\[Dagger], \
-$CellContext`F, -$CellContext`F\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-C, -D],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{
             RowBox[{"(", "13", ")"}], 
             RowBox[{"(", "46", ")"}]}],
            FontSize->Tiny]], "[", "R", "]"}], 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"F", "'"}], " ", " ", "F", " ", " ", " "},
            {"A", " ", "B", 
             RowBox[{"C", "'"}], " ", 
             RowBox[{"D", "'"}], "F", 
             RowBox[{"F", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`RS}, 
      xAct`xPerm`StrongGenSet[{1, 4, 3, 6}, 
       xAct`xPerm`GenSet[
        xAct`xPerm`Cycles[{1, 3}], 
        xAct`xPerm`Cycles[{4, 6}]]], 
      "(13)(46)"][-$CellContext`A, $CellContext`F\[Dagger], -$CellContext`B, \
-$CellContext`C\[Dagger], $CellContext`F, -$CellContext`D\[Dagger], \
-$CellContext`F, -$CellContext`F\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"C", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{
             RowBox[{"(", "13", ")"}], 
             RowBox[{"(", "46", ")"}]}],
            FontSize->Tiny]], "[", "R", "]"}], 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"F", "'"}], " ", " ", "F", " ", " ", " "},
            {"C", " ", "D", 
             RowBox[{"A", "'"}], " ", 
             RowBox[{"B", "'"}], "F", 
             RowBox[{"F", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`RS}, 
      xAct`xPerm`StrongGenSet[{1, 4, 3, 6}, 
       xAct`xPerm`GenSet[
        xAct`xPerm`Cycles[{1, 3}], 
        xAct`xPerm`Cycles[{4, 6}]]], "(13)(46)"][-
      C, $CellContext`F\[Dagger], -
      D, -$CellContext`A\[Dagger], $CellContext`F, -$CellContext`B\[Dagger], \
-$CellContext`F, -$CellContext`F\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"B", "'"}], 
             RowBox[{"D", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{
             RowBox[{"(", "13", ")"}], 
             RowBox[{"(", "46", ")"}]}],
            FontSize->Tiny]], "[", "R", "]"}], 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"F", "'"}], " ", " ", "F", " ", " ", " "},
            {"C", " ", "D", 
             RowBox[{"A", "'"}], " ", 
             RowBox[{"C", "'"}], "F", 
             RowBox[{"F", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`RS}, 
      xAct`xPerm`StrongGenSet[{1, 4, 3, 6}, 
       xAct`xPerm`GenSet[
        xAct`xPerm`Cycles[{1, 3}], 
        xAct`xPerm`Cycles[{4, 6}]]], "(13)(46)"][-
      C, $CellContext`F\[Dagger], -
      D, -$CellContext`A\[Dagger], $CellContext`F, -$CellContext`C\[Dagger], \
-$CellContext`F, -$CellContext`F\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"B", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          UnderscriptBox["Sym", 
           StyleBox[
            RowBox[{
             RowBox[{"(", "13", ")"}], 
             RowBox[{"(", "46", ")"}]}],
            FontSize->Tiny]], "[", "R", "]"}], 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"F", "'"}], " ", " ", "F", " ", " ", " "},
            {"C", " ", "D", 
             RowBox[{"A", "'"}], " ", 
             RowBox[{"D", "'"}], "F", 
             RowBox[{"F", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SymManipulator`SymH[{$CellContext`RS}, 
      xAct`xPerm`StrongGenSet[{1, 4, 3, 6}, 
       xAct`xPerm`GenSet[
        xAct`xPerm`Cycles[{1, 3}], 
        xAct`xPerm`Cycles[{4, 6}]]], "(13)(46)"][-
      C, $CellContext`F\[Dagger], -
      D, -$CellContext`A\[Dagger], $CellContext`F, -$CellContext`D\[Dagger], \
-$CellContext`F, -$CellContext`F\[Dagger]],
     Editable->False]}], "+", 
