(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5202,        174]*)
(*NotebookOutlinePosition[      5870,        197]*)
(*  CellTagsIndexPosition[      5826,        193]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SeparateBasis", "ObjectName"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SeparateBasis[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["i",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " expands the basis index ",
  StyleBox["i",
    FontSlant->"Italic"],
  " into a tensor product of a tensor and the corresponding basis vector (or \
covector).\n\[FilledSmallSquare] ",
  StyleBox["SeparateBasis[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["list",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " expands the basis indices in list into tensor products with basis vectors \
(or covectors).\n\[FilledSmallSquare] ",
  StyleBox["SeparateBasis[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["manifold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " expands the basis indices belonging to ",
  StyleBox["manifold",
    FontSlant->"Italic"],
  " into tensor products with basis vectors (or covectors).\n\
\[FilledSmallSquare] ",
  StyleBox["SeparateBasis[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["basis",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " expands the basis indices of basis vectors of ",
  StyleBox["basis",
    FontSlant->"Italic"],
  " into tensor products with those basis vectors (or covectors).\n\
\[FilledSmallSquare] ",
  StyleBox["SeparateBasis[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " expands all basis indices of ",
  StyleBox["exp",
    FontSlant->"Italic"],
  StyleBox["r",
    FontSlant->"Italic"],
  " into tensor products."
}], "Usage"],

Cell[TextData[{
  "\[FilledSmallSquare] Separation means introducetion of abstract indices. \
For example ",
  Cell[BoxData[
      FormBox[Cell["SeparateBasis[ v[{a}] ]"], TraditionalForm]]],
  " returns ",
  Cell[BoxData[
      \(TraditionalForm\`v[b]\ Basis[\(-b\), {a}]\)]],
  Cell[BoxData[
      FormBox[Cell[""], TraditionalForm]]],
  ".\n\[FilledSmallSquare] Indices, manifolds and bases in the second \
argument are recognized using the functions ",
  StyleBox["AIndexQ",
    FontFamily->"Courier"],
  ", ",
  StyleBox["ManifoldQ",
    FontFamily->"Courier"],
  " and ",
  StyleBox["BasisQ",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See: ",
  ButtonBox["Section 4.7",
    ButtonData:>{
      FrontEnd`FileName[ {
        ParentDirectory[ ]}, "xTensorRefGuide.nb", CharacterEncoding -> 
        "iso8859-1"], "Bases and charts"},
    ButtonStyle->"Hyperlink"],
  ".",
  ButtonBox["\n",
    ButtonData:>{
      FrontEnd`FileName[ {
        ParentDirectory[ ]}, "xTensorRefGuide.nb", CharacterEncoding -> 
        "iso8859-1"], None},
    ButtonStyle->"Hyperlink"],
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ContractBasis",
    ButtonData:>{"ContractBasis.nb", None},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["ExpandInBasis",
    ButtonData:>{"ExpandInBasis.nb", None},
    ButtonStyle->"Hyperlink"],
  ".\n\[FilledSmallSquare] New in version 0."
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{123, Automatic}, {Automatic, 51}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 35, 0, 38, "ObjectName"],
Cell[1814, 55, 1975, 71, 184, "Usage"],
Cell[3792, 128, 1394, 43, 154, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

