(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[  25590354,     561573]
NotebookOptionsPosition[  25422990,     559105]
NotebookOutlinePosition[  25423369,     559122]
CellTagsIndexPosition[  25423326,     559119]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData["Exit"], "Input",ExpressionUUID->"dd850679-1c42-4d05-9c90-343324dcc8aa"],

Cell[CellGroupData[{

Cell[TextData[{
 "The CTensor notation in ",
 StyleBox["xCoba",
  FontSlant->"Italic"]
}], "Section",ExpressionUUID->"fb98dd1d-7f42-4647-b073-c027d32c6c22"],

Cell[CellGroupData[{

Cell["1. Basic ideas", "Subsection",ExpressionUUID->"12900e24-d9d5-48b0-9dce-c94a7ffa32b4"],

Cell[CellGroupData[{

Cell["1.1. Setup", "Subsubsection",ExpressionUUID->"a56c5381-8ed5-4256-bbee-3319327c8384"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`xCoba`"}]], "Input",ExpressionUUID->"6e86452c-cc64-43e8-b934-bda791638f3a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"adc1681e-18b7-4770-8d68-b5a3a53deb16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",ExpressionUUID->"cfee9b16-b9d0-4a8c-89ce-\
cab6e2d20ccb"],

Cell[BoxData["\<\"CopyRight (C) 2003-2015, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",ExpressionUUID->"13d439ad-cbd6-4730-\
a2a7-62ee81a2c5ca"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",ExpressionUUID->"0626933e-9138-46b0-aca0-053f41fb9a2e"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",ExpressionUUID->"ef2369c1-243d-43a1-9e2d-d96398ebc70d"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"b6d74b84-e63c-45de-88d4-5215bd07ca69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.3", ", ", {2018, 2, 28}],
  Editable->False]], "Print",ExpressionUUID->"f013c6cd-22df-41f0-a832-\
32f4b6ded85e"],

Cell[BoxData["\<\"CopyRight (C) 2002-2018, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",ExpressionUUID->"62cb4867-5282-4fbf-\
8de9-4e50764fabd1"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"499a9353-3774-41b1-9fd9-b9f74acd0cd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.4", ", ", {2018, 2, 28}],
  
  Editable->False]], "Print",ExpressionUUID->"dc0ac610-ebee-4a47-ab09-\
d0ade2d41bc9"],

Cell[BoxData["\<\"CopyRight (C) 2005-2018, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",ExpressionUUID\
->"622ddad7-04b3-4635-87d1-cbc6968af3a9"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"d1e3d131-6ec4-42e4-aa85-0cd45cdd2159"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",ExpressionUUID->"f6539115-d966-4246-9222-\
a7ff76c69bd8"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"0b1b0af5-f42d-411a-882b-711a21d0f1f3"]
}, Open  ]]
}, Open  ]],

Cell["Deactivate def/undef messages:", "Text",ExpressionUUID->"ef27e68e-55fc-4439-91a9-337e63abf187"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$UndefInfoQ", "=", "False"}], ";"}]}], "Input",ExpressionUUID->\
"1a27909d-1cf5-4278-9469-de67d4f21aa9"],

Cell["Prepare a manifold:", "Text",ExpressionUUID->"9c988b6d-d275-4e76-93c2-3b78fa777615"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"IndexRange", "[", 
    RowBox[{"a", ",", "n"}], "]"}]}], "]"}]], "Input",ExpressionUUID->\
"c536ee93-a30c-4216-bfde-7c89f05cb095"],

Cell["and two bases in its tangent bundle:", "Text",ExpressionUUID->"66978966-457a-426e-b645-7ada3da199f1"],

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"red", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", "Red"}]}], "]"}]], "Input",ExpressionUUID-\
>"0b2eb4cf-ce0c-43d9-a4fc-f714e1c8260e"],

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"blue", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", "Blue"}]}], "]"}]], "Input",ExpressionUUID\
->"6d7c186a-4771-4b52-b62a-c1e031c2874d"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Algebra", "Subsubsection",ExpressionUUID->"c4e4573b-4cae-4f75-9ad2-cc259b048c21"],

Cell[TextData[{
 "The basic construction in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " is a tensor field of the form head[indices]. ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " now accepts the same structure, but the head can be an expression \
containing a tensor described by an array of components in a given list of \
bases."
}], "Text",ExpressionUUID->"0ab38c02-d133-42d2-81e2-892a3be7b10f"],

Cell[TextData[{
 "\[Bullet] This a vector field. An additional argument is automatically \
added, the ",
 StyleBox["added tensor weight",
  FontSlant->"Italic"],
 ", zero by default:"
}], "Text",ExpressionUUID->"e495e735-c64e-4d38-88be-244c6b8435df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", "red", "}"}]}], "]"}]}]], "Input",ExpressionUUID->"165aa8d2-\
a0f7-40f6-b84e-9cc85e29a34a"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "red", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"86956409-94b0-4fe0-bc60-4a7d20cac73a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTensorQ", "[", "v", "]"}]], "Input",ExpressionUUID->"f790bbb3-72ef-4dae-8465-09c362c3076a"],

Cell[BoxData["True"], "Output",ExpressionUUID->"f01609bf-e095-4f19-8d2e-453b8c00dc15"]
}, Open  ]],

Cell[TextData[{
 "\[Bullet] By default the object is not formatted. It is typeset when we add \
the index, as usual in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"d81b14e8-5d28-4ee5-9475-2276cecf92ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", "a", "]"}]], "Input",ExpressionUUID->"b9d92507-cdeb-426b-8df1-2575f3b11090"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", "2"}]],
           Annotation[#, {2} -> 2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", "3"}]],
           Annotation[#, {3} -> 3, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", "4"}]],
           Annotation[#, {4} -> 4, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{1, 2, 3, 4}, {$CellContext`red}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"4349b7ad-32b4-4c8c-ba64-\
4d1dd38a6880"]
}, Open  ]],

Cell["\<\
The red vertical bars indicate that components correspond to the red basis, \
whose color is Red:\
\>", "Text",ExpressionUUID->"df7121e4-1b51-4e1e-adf3-d78cd50d431a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BasisColor", "[", "red", "]"}]], "Input",ExpressionUUID->"a1317791-f4be-4474-bd65-9c1d18f2f3f6"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     DefaultBaseStyle->"ColorSwatchGraphics",
     Frame->True,
     FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
        AbsoluteCurrentValue[Magnification]}],
     PlotRangePadding->None],
    StyleBox[
     RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> False]],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[1, 0, 0],
  Editable->False,
  Selectable->False]], "Output",ExpressionUUID->"ab93432c-0b0d-4d52-9a86-\
d4faa11aa320"]
}, Open  ]],

Cell["\[Bullet] This is a 2-tensor:", "Text",ExpressionUUID->"b0f0bf3e-b3f1-4807-b397-26ff28e9b412"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "100", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"S", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{"10", ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"red", ",", " ", 
      RowBox[{"-", "red"}]}], "}"}]}], "]"}]}]}], "Input",ExpressionUUID->\
"8b88f491-919a-4fe0-843b-8d0f622b34c8"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "4", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "10", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "8", ",", "9", ",", "10"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"red", ",", 
     RowBox[{"-", "red"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUI\
D->"e12c5cd7-11fb-4030-b5dd-bdbb8079dad4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",ExpressionUUID->"83a116af-ed79-41e9-\
bdeb-fbc192e06dfe"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "3"}]],
           Annotation[#, {1, 2} -> 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "4"}]],
           Annotation[#, {1, 3} -> 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox["7",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "7"}]],
           Annotation[#, {1, 4} -> 7, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "3"}]],
           Annotation[#, {2, 1} -> 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox["10",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "10"}]],
           Annotation[#, {2, 2} -> 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {2, 3} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "3"}]],
           Annotation[#, {2, 4} -> 3, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "4"}]],
           Annotation[#, {3, 1} -> 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox["5",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "5"}]],
           Annotation[#, {3, 2} -> 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox["6",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "6"}]],
           Annotation[#, {3, 3} -> 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "2"}]],
           Annotation[#, {3, 4} -> 2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {4, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["8",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "8"}]],
           Annotation[#, {4, 2} -> 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox["9",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "9"}]],
           Annotation[#, {4, 3} -> 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox["10",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "10"}]],
           Annotation[#, {4, 4} -> 10, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", " "},
         {" ", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{0, 3, 4, 7}, {3, 10, 1, 3}, {4, 5, 6, 2}, {1, 8, 9, 
   10}}, {$CellContext`red, -$CellContext`red}, 
   0][$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"f0622e5b-b807-418d-b70b-\
1c1900628a9b"]
}, Open  ]],

Cell["\<\
Note that the standard representation of a matrix {{1}, {2}} and a vector {1, \
2} coincide in MatrixForm, but not in this CTensor formatting:\
\>", "Text",ExpressionUUID->"1d98bb43-9a01-4748-9f0c-119d244eca19"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatrixForm", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "2", "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"MatrixForm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "}"}]], "Input",ExpressionUUID->\
"88da6a6c-61ff-4d5a-91ea-d9786a95aa63"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"},
       {"2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"2"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",ExpressionUUID->"847f52f9-\
01ca-46e6-8988-e9346d7b3c6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "2", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"red", ",", "blue"}], "}"}]}], "]"}], "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", "red", "}"}]}], "]"}], "[", "a", "]"}]}], "}"}]], "Input",E\
xpressionUUID->"5b9b092b-4cc1-4337-9fc3-0b263c457f6c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        StyleBox[GridBox[{
           {
            TagBox[
             TooltipBox["1",
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
             Annotation[#, {1, 1} -> 1, "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox["2",
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "2"}]],
             Annotation[#, {2, 1} -> 2, "Tooltip"]& ]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[0, 0, 1], 3 -> RGBColor[0, 0, 1]}}],
         FontSize->Small], 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCoba`CTensor[{{1}, {2}}, {$CellContext`red, $CellContext`blue}, 
     0][$CellContext`a, $CellContext`b],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        StyleBox[GridBox[{
           {
            TagBox[
             TooltipBox["1",
              RowBox[{
                RowBox[{"{", "1", "}"}], "\[Rule]", "1"}]],
             Annotation[#, {1} -> 1, "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox["2",
              RowBox[{
                RowBox[{"{", "2", "}"}], "\[Rule]", "2"}]],
             Annotation[#, {2} -> 2, "Tooltip"]& ]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
         FontSize->Small], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCoba`CTensor[{1, 2}, {$CellContext`red}, 0][$CellContext`a],
    Editable->False]}], "}"}]], "Output",ExpressionUUID->"2a8ac984-15e4-48fe-\
a40e-31eaf09d6f48"]
}, Open  ]],

Cell["\<\
The vertical bars correspond to the first index and the horizontal bars \
correspond to the second index. If more indices are present then we nest the \
colored bars, as MatrixForm does. Use the variable $CTensorRepresentation to \
switch between typesetting forms:\
\>", "Text",ExpressionUUID->"41297a39-c4e3-4cbb-bd55-bc7aa80b2452"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CTensorRepresentation", "=", "\"\<MatrixForm\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "2", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", "4", "}"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"red", ",", "red", ",", "blue"}], "}"}]}], "]"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "Input",ExpressionUUID->\
"b5f3ee3a-5b12-4224-8f02-dad888ce28f7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[
       TagBox[
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {
            RowBox[{"(", "\[NoBreak]", 
             TagBox[GridBox[{
                {
                 TagBox[
                  TooltipBox["1",
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                    "1"}]],
                  Annotation[#, {1, 1, 1} -> 1, "Tooltip"]& ]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              Column], "\[NoBreak]", ")"}], 
            RowBox[{"(", "\[NoBreak]", 
             TagBox[GridBox[{
                {
                 TagBox[
                  TooltipBox["2",
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                    "2"}]],
                  Annotation[#, {1, 2, 1} -> 2, "Tooltip"]& ]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              Column], "\[NoBreak]", ")"}]},
           {
            RowBox[{"(", "\[NoBreak]", 
             TagBox[GridBox[{
                {
                 TagBox[
                  TooltipBox["3",
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                    "3"}]],
                  Annotation[#, {2, 1, 1} -> 3, "Tooltip"]& ]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              Column], "\[NoBreak]", ")"}], 
            RowBox[{"(", "\[NoBreak]", 
             TagBox[GridBox[{
                {
                 TagBox[
                  TooltipBox["4",
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                    "4"}]],
                  Annotation[#, {2, 2, 1} -> 4, "Tooltip"]& ]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              Column], "\[NoBreak]", ")"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.7]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
        Function[BoxForm`e$, 
         MatrixForm[BoxForm`e$]]],
       StripOnInput->False,
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", "b", "c"},
         {" ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{{1}, {2}}, {{3}, {
   4}}}, {$CellContext`red, $CellContext`red, $CellContext`blue}, 
   0][$CellContext`a, $CellContext`b, $CellContext`c],
  Editable->False]], "Output",ExpressionUUID->"ea89b720-49ea-4643-8094-\
81df6ef5c9fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CTensorRepresentation", "=", "\"\<ColorBasisForm\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "2", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", "4", "}"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"red", ",", "red", ",", "blue"}], "}"}]}], "]"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "Input",ExpressionUUID->\
"f8bedb07-6b34-4b90-916d-9db4f0658a71"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {GridBox[{
            {
             TagBox[
              TooltipBox["1",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
              Annotation[#, {1, 1, 1} -> 1, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0, 0, 1], 2 -> RGBColor[0, 0, 1]}}], GridBox[{
            {
             TagBox[
              TooltipBox["2",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", "2"}]],
              Annotation[#, {1, 2, 1} -> 2, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0, 0, 1], 2 -> RGBColor[0, 0, 1]}}]},
         {GridBox[{
            {
             TagBox[
              TooltipBox["3",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", "3"}]],
              Annotation[#, {2, 1, 1} -> 3, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0, 0, 1], 2 -> RGBColor[0, 0, 1]}}], GridBox[{
            {
             TagBox[
              TooltipBox["4",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "4"}]],
              Annotation[#, {2, 2, 1} -> 4, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0, 0, 1], 2 -> RGBColor[0, 0, 1]}}]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", "b", "c"},
         {" ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{{1}, {2}}, {{3}, {
   4}}}, {$CellContext`red, $CellContext`red, $CellContext`blue}, 
   0][$CellContext`a, $CellContext`b, $CellContext`c],
  Editable->False]], "Output",ExpressionUUID->"d155d30f-31c2-4378-a1e5-\
e96029e39999"]
}, Open  ]],

Cell[TextData[{
 "Operations with c-tensors proceed as usual in ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 ", using indices to indicate contractions or transpositions."
}], "Text",ExpressionUUID->"66bdda0e-6c2d-41e3-9f96-02190149acf5"],

Cell["\[Bullet] Compute the trace of a tensor:", "Text",ExpressionUUID->"0929df7b-a1bf-4548-9768-2ddd981640e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "a"}]}], "]"}]], "Input",ExpressionUUID->"5bdedb97-e7d8-497a-\
b7ed-51b9c59761bb"],

Cell[BoxData["26"], "Output",ExpressionUUID->"cf7a6dd5-f59d-471f-8a37-be9d4e2495f6"]
}, Open  ]],

Cell["\[Bullet] Contract two tensors:", "Text",ExpressionUUID->"47620db7-1479-4f32-bc6f-dc1ba9b9c4d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "b"}]}], "]"}], 
  RowBox[{"v", "[", "b", "]"}]}]], "Input",ExpressionUUID->"13828dec-67cb-\
4996-9aa3-6e0aa80e592c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["46",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "46"}]],
           Annotation[#, {1} -> 46, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["38",
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", "38"}]],
           Annotation[#, {2} -> 38, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["40",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", "40"}]],
           Annotation[#, {3} -> 40, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["84",
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", "84"}]],
           Annotation[#, {4} -> 84, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{46, 38, 40, 84}, {$CellContext`red}, 0][$CellContext`a],
  
  Editable->False]], "Output",ExpressionUUID->"a9c048af-417c-4510-a2b6-\
cf02e6af19ca"]
}, Open  ]],

Cell["\[Bullet] Multiply two tensors (their tensor product):", "Text",ExpressionUUID->"7676e574-c9b6-4bf6-9796-0ff4e64d7adc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], 
   RowBox[{"v", "[", "b", "]"}]}]}]], "Input",ExpressionUUID->"96b37544-729a-\
4500-a5bc-672e8f94751e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "2"}]],
           Annotation[#, {1, 2} -> 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "3"}]],
           Annotation[#, {1, 3} -> 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "4"}]],
           Annotation[#, {1, 4} -> 4, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "2"}]],
           Annotation[#, {2, 1} -> 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "4"}]],
           Annotation[#, {2, 2} -> 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox["6",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "6"}]],
           Annotation[#, {2, 3} -> 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox["8",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "8"}]],
           Annotation[#, {2, 4} -> 8, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "3"}]],
           Annotation[#, {3, 1} -> 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox["6",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "6"}]],
           Annotation[#, {3, 2} -> 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox["9",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "9"}]],
           Annotation[#, {3, 3} -> 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox["12",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "12"}]],
           Annotation[#, {3, 4} -> 12, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "4"}]],
           Annotation[#, {4, 1} -> 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox["8",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "8"}]],
           Annotation[#, {4, 2} -> 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox["12",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "12"}]],
           Annotation[#, {4, 3} -> 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox["16",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "16"}]],
           Annotation[#, {4, 4} -> 16, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", "b"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{1, 2, 3, 4}, {2, 4, 6, 8}, {3, 6, 9, 12}, {4, 8, 12, 
   16}}, {$CellContext`red, $CellContext`red}, 
   0][$CellContext`a, $CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"2de08423-b89c-4c33-857a-\
1ad153c9765d"]
}, Open  ]],

Cell["\[Bullet] This is a symmetric tensor:", "Text",ExpressionUUID->"05efb439-ec84-476c-8760-7876498018e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "\[Equal]", 
  RowBox[{"T", "[", 
   RowBox[{"b", ",", "a"}], "]"}]}]], "Input",ExpressionUUID->"74adb551-29e0-\
4a17-a9d7-6a2eeda46476"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       StyleBox[GridBox[{
          {
           TagBox[
            TooltipBox["1",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
            Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox["2",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "2"}]],
            Annotation[#, {1, 2} -> 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox["3",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "3"}]],
            Annotation[#, {1, 3} -> 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox["4",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "4"}]],
            Annotation[#, {1, 4} -> 4, "Tooltip"]& ]},
          {
           TagBox[
            TooltipBox["2",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "2"}]],
            Annotation[#, {2, 1} -> 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox["4",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "4"}]],
            Annotation[#, {2, 2} -> 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox["6",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "6"}]],
            Annotation[#, {2, 3} -> 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox["8",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "8"}]],
            Annotation[#, {2, 4} -> 8, "Tooltip"]& ]},
          {
           TagBox[
            TooltipBox["3",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "3"}]],
            Annotation[#, {3, 1} -> 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox["6",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "6"}]],
            Annotation[#, {3, 2} -> 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox["9",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "9"}]],
            Annotation[#, {3, 3} -> 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox["12",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "12"}]],
            Annotation[#, {3, 4} -> 12, "Tooltip"]& ]},
          {
           TagBox[
            TooltipBox["4",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "4"}]],
            Annotation[#, {4, 1} -> 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox["8",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "8"}]],
            Annotation[#, {4, 2} -> 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox["12",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "12"}]],
            Annotation[#, {4, 3} -> 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox["16",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "16"}]],
            Annotation[#, {4, 4} -> 16, "Tooltip"]& ]}
         },
         AutoDelete->False,
         GridBoxDividers->{
          "ColumnsIndexed" -> {
            1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}],
        FontSize->Small], 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xCoba`CTensor[{{1, 2, 3, 4}, {2, 4, 6, 8}, {3, 6, 9, 12}, {4, 8, 12, 
    16}}, {$CellContext`red, $CellContext`red}, 
    0][$CellContext`a, $CellContext`b],
   Editable->False], "\[Equal]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       StyleBox[GridBox[{
          {
           TagBox[
            TooltipBox["1",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
            Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox["2",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "2"}]],
            Annotation[#, {1, 2} -> 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox["3",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "3"}]],
            Annotation[#, {1, 3} -> 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox["4",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "4"}]],
            Annotation[#, {1, 4} -> 4, "Tooltip"]& ]},
          {
           TagBox[
            TooltipBox["2",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "2"}]],
            Annotation[#, {2, 1} -> 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox["4",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "4"}]],
            Annotation[#, {2, 2} -> 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox["6",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "6"}]],
            Annotation[#, {2, 3} -> 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox["8",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "8"}]],
            Annotation[#, {2, 4} -> 8, "Tooltip"]& ]},
          {
           TagBox[
            TooltipBox["3",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "3"}]],
            Annotation[#, {3, 1} -> 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox["6",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "6"}]],
            Annotation[#, {3, 2} -> 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox["9",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "9"}]],
            Annotation[#, {3, 3} -> 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox["12",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "12"}]],
            Annotation[#, {3, 4} -> 12, "Tooltip"]& ]},
          {
           TagBox[
            TooltipBox["4",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "4"}]],
            Annotation[#, {4, 1} -> 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox["8",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "8"}]],
            Annotation[#, {4, 2} -> 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox["12",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "12"}]],
            Annotation[#, {4, 3} -> 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox["16",
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "16"}]],
            Annotation[#, {4, 4} -> 16, "Tooltip"]& ]}
         },
         AutoDelete->False,
         GridBoxDividers->{
          "ColumnsIndexed" -> {
            1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}],
        FontSize->Small], 
       StyleBox[GridBox[{
          {"b", "a"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xCoba`CTensor[{{1, 2, 3, 4}, {2, 4, 6, 8}, {3, 6, 9, 12}, {4, 8, 12, 
    16}}, {$CellContext`red, $CellContext`red}, 
    0][$CellContext`b, $CellContext`a],
   Editable->False]}]], "Output",ExpressionUUID->"3ea464a7-d711-4330-9fc1-\
28a545d0dcec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",ExpressionUUID->"1c82269a-1e10-4f9a-91b9-28503b9924db"],

Cell[BoxData["True"], "Output",ExpressionUUID->"a398dbff-0c6d-4b89-93a1-df36512675d3"]
}, Open  ]],

Cell["\[Bullet] In sums there is automatic reordering of indices:", "Text",ExpressionUUID->"321c2c73-b63e-406b-9dc5-d013cdfa565d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "-", 
  RowBox[{"T", "[", 
   RowBox[{"b", ",", "a"}], "]"}]}]], "Input",ExpressionUUID->"2cfadac6-2ef5-\
4e0f-ac4e-19b3dcffeedc"],

Cell[BoxData["0"], "Output",ExpressionUUID->"b42f87e7-ddfd-4cd6-bded-cc22a5a85fbe"]
}, Open  ]],

Cell[TextData[{
 "\[Bullet] Note that the previous expression returned 0, and not a CTensor \
with an array of zeros. This is to follow the standard behaviour of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"efc83a62-3080-45ab-8f81-bbed06272d8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], 
   RowBox[{"v", "[", "b", "]"}]}], "-", 
  RowBox[{
   RowBox[{"v", "[", "b", "]"}], 
   RowBox[{"v", "[", "a", "]"}]}]}]], "Input",ExpressionUUID->"1c6c695d-9115-\
4a30-939c-c27c8bbc753d"],

Cell[BoxData["0"], "Output",ExpressionUUID->"fe91d877-78ad-49db-9033-579d2ce4e1b6"]
}, Open  ]],

Cell[TextData[{
 "The CTensor notation is an alternative to the \[OpenCurlyDoubleQuote]linear \
combination notation\[CloseCurlyDoubleQuote] in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ". It is possible to change between both notations."
}], "Text",ExpressionUUID->"7a072495-0ca5-415f-a33c-17888d776c51"],

Cell["\<\
\[Bullet] Expand a CTensor into a linear combination of bases objects, and \
then back.\
\>", "Text",ExpressionUUID->"e531980a-d6f1-432c-8022-c2015c5519cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", "a", "]"}]], "Input",ExpressionUUID->"b1adb84f-bf1f-4a9e-8900-e203de52a72c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", "2"}]],
           Annotation[#, {2} -> 2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", "3"}]],
           Annotation[#, {3} -> 3, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", "4"}]],
           Annotation[#, {4} -> 4, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{1, 2, 3, 4}, {$CellContext`red}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"bb803c29-b3c3-472c-8457-\
a573a6b7ffd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BasisExpand", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", "red", "}"}]}], "]"}]], "Input",ExpressionUUID->"4e42a73c-\
a114-43d3-a55d-3a0a20fbc850"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["0",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{0, -$CellContext`red}, $CellContext`a],
   Editable->False], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`red}, $CellContext`a],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`red}, $CellContext`a],
    Editable->False]}], "+", 
  RowBox[{"4", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["3",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{3, -$CellContext`red}, $CellContext`a],
    Editable->False]}]}]], "Output",ExpressionUUID->"85a553df-5ea6-4fdf-9131-\
752b87d400ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%%", "//", "ToBasisExpand"}]], "Input",ExpressionUUID->"9eea2aa0-225b-4a68-a093-805365050c3a"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["0",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{0, -$CellContext`red}, $CellContext`a],
   Editable->False], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`red}, $CellContext`a],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`red}, $CellContext`a],
    Editable->False]}], "+", 
  RowBox[{"4", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["3",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{3, -$CellContext`red}, $CellContext`a],
    Editable->False]}]}]], "Output",ExpressionUUID->"a3a8ba3b-cffb-4fa8-a771-\
49efb649a4cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromBasisExpand", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", "red", "}"}]}], "]"}]], "Input",ExpressionUUID->"e7541faf-\
1064-4ec0-a228-647e37704b37"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", "2"}]],
           Annotation[#, {2} -> 2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", "3"}]],
           Annotation[#, {3} -> 3, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", "4"}]],
           Annotation[#, {4} -> 4, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{1, 2, 3, 4}, {$CellContext`red}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"9e0ae923-bdcd-4e9f-8226-\
e27c191079cf"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. A metric field", "Subsubsection",ExpressionUUID->"bbad4ff0-9a95-487d-b684-132c52ef8cb6"],

Cell["\[Bullet] Define a coordinate system:", "Text",ExpressionUUID->"5f2a9822-aefe-40e9-b648-0c084d9c2c90"],

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"ch", ",", "M", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "[", "]"}], ",", 
     RowBox[{"r", "[", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[Phi]", "[", "]"}]}], "}"}], ",", 
   RowBox[{"ChartColor", "\[Rule]", "Brown"}]}], "]"}]], "Input",ExpressionUUI\
D->"16ef8119-7018-4600-ae0c-9b63ac171ef6"],

Cell["\[Bullet] Now define a metric field, the Schwarzschild metric:", "Text",ExpressionUUID->"03bb7142-0853-4dcb-889c-7d613025f837"],

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"mass", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<M\>\""}]}], "]"}]], "Input",ExpressionUU\
ID->"0c749e99-4e6c-4f81-bee8-e9f468815b5f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"met", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", 
          RowBox[{"mass", "/", 
           RowBox[{"r", "[", "]"}]}]}]}], ",", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", 
            RowBox[{"mass", "/", 
             RowBox[{"r", "[", "]"}]}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"r", "[", "]"}], "^", "2"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"r", "[", "]"}], "^", "2"}], 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"\[Theta]", "[", "]"}], "]"}], "^", "2"}]}]}], "}"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "ch"}], ",", 
       RowBox[{"-", "ch"}]}], "}"}]}], "]"}]}], ";"}]], "Input",ExpressionUUID\
->"fcd08836-ab89-476a-8975-c2881af3a34f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",ExpressionUUID->"f7826553-fde2-41b3-\
b2f7-488981eb395e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             FractionBox[
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`mass,
                Editable->False]}], 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"-", "1"}], "+", 
                FractionBox[
                 RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False]]}]}]],
           
           Annotation[#, {1, 1} -> -1 + 2 $CellContext`mass/$CellContext`r[], 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            FractionBox["1", 
             RowBox[{"1", "-", 
              FractionBox[
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`mass,
                 Editable->False]}], 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]]}]],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              FractionBox["1", 
               RowBox[{"1", "-", 
                 FractionBox[
                  RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False]]}]]}]],
           
           Annotation[#, {2, 
             2} -> (1 - 2 $CellContext`mass/$CellContext`r[])^(-1), 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            SuperscriptBox[
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], "2"],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox[
                "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                $CellContext`r[], Editable -> False], "2"]}]],
           Annotation[#, {3, 3} -> $CellContext`r[]^2, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"], " ", 
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], "2"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", 
              RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False], "2"], " ", 
                SuperscriptBox[
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                   InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                 "2"]}]}]],
           Annotation[#, {4, 4} -> $CellContext`r[]^2 Sin[
                $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}, 
          "RowsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{-1 + 2 $CellContext`mass/$CellContext`r[], 0, 0, 0}, {
    0, (1 - 2 $CellContext`mass/$CellContext`r[])^(-1), 0, 0}, {
    0, 0, $CellContext`r[]^2, 0}, {0, 0, 0, $CellContext`r[]^2 Sin[
        $CellContext`\[Theta][]]^2}}, {-$CellContext`ch, -$CellContext`ch}, 
   0][-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"a6d8ee2f-acbd-46cb-a192-\
0900da125c03"]
}, Open  ]],

Cell["\<\
\[Bullet] We associate the metric to the manifold. Some properties of the \
metric are precomputed and cached (this is roughly the C-version of \
DefMetric):\
\>", "Text",ExpressionUUID->"783989b7-b712-4d43-bd48-ef6c77c4da08"],

Cell[BoxData[
 RowBox[{"SetCMetric", "[", 
  RowBox[{"met", ",", "ch", ",", 
   RowBox[{"SignatureOfMetric", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}]], "Input",ExpressionU\
UID->"65771983-f760-4090-92b2-a5033d5d0f20"],

Cell["\<\
\[Bullet] Now that we have a metric, raising and lowering indices produces \
the expected result:\
\>", "Text",ExpressionUUID->"04af4414-05ae-43b4-9db7-fe4a6ae21e9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"r", "[", "]"}], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", "ch", "}"}]}], "]"}]}]], "Input",ExpressionUUID->"3088145e-\
af6e-4f46-a4be-d16bad31aced"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "ch", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"fc1c4d80-6a7f-4726-a201-388a4bbc3085"]
}, Open  ]],

Cell["The change is automatically computed:", "Text",ExpressionUUID->"1103015e-79bf-4306-ad44-d925026fa5cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"V", "[", "a", "]"}], ",", 
   RowBox[{"V", "[", 
    RowBox[{"-", "a"}], "]"}]}], "}"}]], "Input",ExpressionUUID->"dd693f39-\
3253-42a2-93e3-222209ddfdba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        StyleBox[GridBox[{
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", "1", "}"}], "\[Rule]", "0"}]],
             Annotation[#, {1} -> 0, "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False],
              RowBox[{
                RowBox[{"{", "2", "}"}], "\[Rule]", 
                InterpretationBox[
                 StyleBox["r", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`r[], Editable -> False]}]],
             Annotation[#, {2} -> $CellContext`r[], "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", "3", "}"}], "\[Rule]", "0"}]],
             Annotation[#, {3} -> 0, "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", "4", "}"}], "\[Rule]", "0"}]],
             Annotation[#, {4} -> 0, "Tooltip"]& ]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}],
         FontSize->Small], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCoba`CTensor[{0, 
      $CellContext`r[], 0, 0}, {$CellContext`ch}, 0][$CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        StyleBox[GridBox[{
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", "1", "}"}], "\[Rule]", "0"}]],
             Annotation[#, {1} -> 0, "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox[
              FractionBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], 
               RowBox[{"1", "-", 
                FractionBox[
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False]}], 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]]}]],
              RowBox[{
                RowBox[{"{", "2", "}"}], "\[Rule]", 
                FractionBox[
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False], 
                 RowBox[{"1", "-", 
                   FractionBox[
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]]}]],
             
             Annotation[#, {
               2} -> (1 - 
                 2 $CellContext`mass/$CellContext`r[])^(-1) $CellContext`r[], 
              "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", "3", "}"}], "\[Rule]", "0"}]],
             Annotation[#, {3} -> 0, "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", "4", "}"}], "\[Rule]", "0"}]],
             Annotation[#, {4} -> 0, "Tooltip"]& ]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}],
         FontSize->Small], 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCoba`CTensor[{
     0, (1 - 2 $CellContext`mass/$CellContext`r[])^(-1) $CellContext`r[], 0, 
      0}, {-$CellContext`ch}, 0][-$CellContext`a],
    Editable->False]}], "}"}]], "Output",ExpressionUUID->"bcd944d1-c1f2-47af-\
84b3-2e68044c487f"]
}, Open  ]],

Cell["This is a contraction:", "Text",ExpressionUUID->"cb823a76-74a4-4350-871f-0b5b692b42f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"V", "[", "a", "]"}], 
  RowBox[{"V", "[", 
   RowBox[{"-", "a"}], "]"}]}]], "Input",ExpressionUUID->"3c17cd50-6552-40d6-\
ab6f-d70609574252"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   InterpretationBox[
    StyleBox["r",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`r[],
    Editable->False], "2"], 
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox["M",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`mass,
      Editable->False]}], 
    InterpretationBox[
     StyleBox["r",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`r[],
     Editable->False]]}]]], "Output",ExpressionUUID->"7f8703a1-d7a1-4682-aed8-\
312ed65bf349"]
}, Open  ]],

Cell["If we raise one index of the metric we get the identity:", "Text",ExpressionUUID->"a97f493a-e0e9-4390-828a-bd6eeea68a32"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", "b"}], "]"}]], "Input",ExpressionUUID->"9bf46615-\
8dcf-416d-9556-0b36df8d545d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {2, 2} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {3, 3} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {4, 4} -> 1, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}, 
          "RowsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", "b"},
         {"a", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 
   1}}, {-$CellContext`ch, $CellContext`ch}, 
   0][-$CellContext`a, $CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"d8132c18-311d-4323-910c-\
06c1a60af65d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",ExpressionUUID->"deac5a6c-bb9f-48da-84d8-abd892435a83"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox[
            FractionBox[
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], 
             RowBox[{
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`mass,
                Editable->False]}], "-", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}]],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
              FractionBox[
               InterpretationBox[
                StyleBox[
                "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                $CellContext`r[], Editable -> False], 
               RowBox[{
                 RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], "-", 
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False]}]]}]],
           
           Annotation[#, {1, 
             1} -> (2 $CellContext`mass - $CellContext`r[])^(-1) \
$CellContext`r[], "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`mass,
                Editable->False]}], 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"1", "-", 
                FractionBox[
                 RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False]]}]}]],
           
           Annotation[#, {2, 2} -> 1 - 2 $CellContext`mass/$CellContext`r[], 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            FractionBox["1", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
              FractionBox["1", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`r[], Editable -> False], "2"]]}]],
           Annotation[#, {3, 3} -> $CellContext`r[]^(-2), "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            FractionBox[
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["Csc",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Csc,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], "2"], 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", 
              FractionBox[
               SuperscriptBox[
                RowBox[{
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Csc"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Csc, Editable -> False], "[", 
                  InterpretationBox[
                   StyleBox[
                   "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`\[Theta][], Editable -> False], "]"}], "2"], 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`r[], Editable -> False], "2"]]}]],
           Annotation[#, {4, 4} -> Csc[
                $CellContext`\[Theta][]]^2 $CellContext`r[]^(-2), 
            "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}, 
          "RowsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", "b"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{(
       2 $CellContext`mass - $CellContext`r[])^(-1) $CellContext`r[], 0, 0, 
     0}, {0, 1 - 2 $CellContext`mass/$CellContext`r[], 0, 0}, {
    0, 0, $CellContext`r[]^(-2), 0}, {0, 0, 0, Csc[
        $CellContext`\[Theta][]]^2 $CellContext`r[]^(-2)}}, {$CellContext`ch, \
$CellContext`ch}, 0][$CellContext`a, $CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"deab6ae0-c8c2-4b1d-9429-\
c9820cafe534"]
}, Open  ]],

Cell["\[Bullet] Some properties of the metric:", "Text",ExpressionUUID->"fa19c409-b26a-47b2-bdca-bdfc8e2cf9a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Determinant", "[", 
  RowBox[{"met", ",", "ch"}], "]"}]], "Input",ExpressionUUID->"59b3da92-0cc8-\
460a-8a14-33b26642e946"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["r",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`r[],
       Editable->False], "4"]}], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        ShowAutoStyles->False,
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[Theta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Theta][],
       Editable->False], "]"}], "2"]}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"2", " ", "ch"}]}], "]"}]], "Output",ExpressionUUID->"e5c09895-\
8a7f-43c4-8c0e-3f86fc8eac21"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SignDetOfMetric", "[", "met", "]"}]], "Input",ExpressionUUID->"ae388769-f76b-4f64-a404-183823e31f51"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",ExpressionUUID->"42086c93-cab7-4252-891f-71f458b87fe3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SignatureOfMetric", "[", "met", "]"}]], "Input",ExpressionUUID->"09cd3165-b354-4581-af33-c36ce2437320"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1", ",", "0"}], "}"}]], "Output",ExpressionUUID->\
"6e66beab-2744-4897-941f-ae0b48e27a76"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. Covariant derivatives", "Subsubsection",ExpressionUUID->"7ca90206-71af-41db-a244-1e0deb51ae61"],

Cell[TextData[{
 "Given a covariant derivative operator we can give any other by supplying a \
Christoffel tensor. ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " can handle such transformations using the construction CCovD[covd, \
christoffel, metric], where the third argument specifies a metric tensor, in \
case the Christoffel derives from it."
}], "Text",ExpressionUUID->"98269a25-89bd-4c61-856c-9a5f4a6e68b3"],

Cell["\<\
\[Bullet] This is the Levi-Civita connection associated to the metric:\
\>", "Text",ExpressionUUID->"fbf78665-b9ba-444e-9c2f-c4e0cb9b0837"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cd", "=", 
  RowBox[{"CovDOfMetric", "[", "met", "]"}]}]], "Input",ExpressionUUID->\
"76efc5b1-8bd9-45d9-9c87-b8dab4175840"],

Cell[BoxData[
 RowBox[{"CCovD", "[", 
  RowBox[{"PDch", ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", 
            FractionBox[
             InterpretationBox[
              StyleBox["M",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mass,
              Editable->False], 
             RowBox[{
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`mass,
                Editable->False], " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], "-", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "2"]}]]}], ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             InterpretationBox[
              StyleBox["M",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mass,
              Editable->False], 
             RowBox[{
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`mass,
                Editable->False], " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], "-", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "2"]}]]}], ",", "0", ",", "0", ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{
             InterpretationBox[
              StyleBox["M",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mass,
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`mass,
                 Editable->False]}], "+", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], ")"}]}], 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], "3"]], ",", "0", ",", "0", ",", "0"}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox[
            InterpretationBox[
             StyleBox["M",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`mass,
             Editable->False], 
            RowBox[{
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`mass,
               Editable->False], " ", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}], "-", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["M",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mass,
              Editable->False]}], "-", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`mass,
                Editable->False]}], "-", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], "2"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           FractionBox["1", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox["1", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]], ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              InterpretationBox[
               StyleBox["Cos",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cos,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}]}], " ", 
            RowBox[{
             InterpretationBox[
              StyleBox["Sin",
               ShowAutoStyles->False,
               AutoSpacing->False],
              Sin,
              Editable->False], "[", 
             InterpretationBox[
              StyleBox["\[Theta]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[Theta][],
              Editable->False], "]"}]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           FractionBox["1", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cot",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cot,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox["1", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]], ",", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cot",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cot,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False], "]"}], ",", "0"}], "}"}]}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"ch", ",", 
       RowBox[{"-", "ch"}], ",", 
       RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          FractionBox[
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["M",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`mass,
             Editable->False]}], 
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False]]}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         FractionBox["1", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["M",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mass,
              Editable->False]}], 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]]}]], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "2"], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False], "]"}], "2"]}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "ch"}], ",", 
       RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}]}], "]"}]], "Output",Exp\
ressionUUID->"a52a63cb-cede-4785-87be-602dc8fe3777"]
}, Open  ]],

Cell[TextData[{
 "\[Bullet] Now we can use it to compute covariant derivatives of tensor \
fields. The notation is identical to that used in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"a82c1392-9425-44e9-998f-3be610d604d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"V", "[", "b", "]"}], "]"}]], "Input",ExpressionUUID->"bf472f24-\
40d3-401e-9bb3-7573309bbafe"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox[
            RowBox[{"-", 
             FractionBox[
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`mass,
               Editable->False], 
              RowBox[{
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`mass,
                 Editable->False]}], "-", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}]]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
              RowBox[{"-", 
                FractionBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                   False], $CellContext`mass, Editable -> False], 
                 RowBox[{
                   RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], "-", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]]}]}]],
           
           Annotation[#, {1, 1} -> -$CellContext`mass/(
             2 $CellContext`mass - $CellContext`r[]), "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"1", "+", 
             FractionBox[
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`mass,
               Editable->False], 
              RowBox[{
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`mass,
                 Editable->False]}], "-", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}]]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"1", "+", 
                FractionBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                   False], $CellContext`mass, Editable -> False], 
                 RowBox[{
                   RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], "-", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]]}]}]],
           
           Annotation[#, {2, 2} -> 
            1 + $CellContext`mass/(2 $CellContext`mass - $CellContext`r[]), 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {3, 3} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {4, 4} -> 1, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}, 
          "RowsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"b", " "},
         {" ", "a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{-$CellContext`mass/(
     2 $CellContext`mass - $CellContext`r[]), 0, 0, 0}, {
    0, 1 + $CellContext`mass/(2 $CellContext`mass - $CellContext`r[]), 0, 
     0}, {0, 0, 1, 0}, {0, 0, 0, 1}}, {$CellContext`ch, -$CellContext`ch}, 
   0][$CellContext`b, -$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"8c69c896-7288-4101-84a8-\
285e96a63564"]
}, Open  ]],

Cell["\[Bullet] The covariant derivative of the metric field is zero:", "Text",ExpressionUUID->"67733ccf-c4ea-4436-b4d7-2ef1d67d887b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"met", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}], "]"}]], "Input",ExpressionUUID->"730ad0d5-\
af4e-4117-9bdc-a5082987e7b7"],

Cell[BoxData["0"], "Output",ExpressionUUID->"f1d5d733-3361-4a54-9d14-1366392e739b"]
}, Open  ]],

Cell["\[Bullet] Commuting covariant derivatives:", "Text",ExpressionUUID->"51a26cde-7f4c-46ea-a31e-3de667fe2e6f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"commV", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "b"}], "]"}], "@", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "a"}], "]"}], "@", 
      RowBox[{"V", "[", "c", "]"}]}]}], "-", 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "a"}], "]"}], "@", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "b"}], "]"}], "@", 
      RowBox[{"V", "[", "c", "]"}]}]}]}], "//", "Simplify"}]}]], "Input",Expre\
ssionUUID->"045ef4a1-a917-46fe-a074-d93f3eb880e0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               FractionBox[
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`mass,
                  Editable->False]}], 
                RowBox[{
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], "-", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                 FractionBox[
                  RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                  RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]],
              
              Annotation[#, {1, 1, 2} -> 
               2 $CellContext`mass/(
                2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox[
               RowBox[{"-", 
                FractionBox[
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False]}], 
                 RowBox[{
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], "-", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                 RowBox[{"-", 
                   FractionBox[
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]}]],
              Annotation[#, {1, 2, 1} -> (-2) $CellContext`mass/(
                2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 3, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "3", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 3, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "3", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 3, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 3, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 4, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "4", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 4, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 4, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "4", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 4, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}]},
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 3, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "3", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 3, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "3", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 3, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 3, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 4, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "4", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 4, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 4, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "4", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 4, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}]},
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 1, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 1, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 1, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 1, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 2, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "2", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 2, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               FractionBox[
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`mass,
                 Editable->False], 
                RowBox[{
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], "-", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                 FractionBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                  RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]],
              
              Annotation[#, {3, 2, 3} -> $CellContext`mass/(
                2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "2", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 2, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 3, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"-", 
                FractionBox[
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`mass,
                  Editable->False], 
                 RowBox[{
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], "-", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                 RowBox[{"-", 
                   FractionBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]}]],
              
              Annotation[#, {3, 3, 2} -> -$CellContext`mass/(
                2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "3", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 3, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 3, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 4, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "4", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 4, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 4, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"3", ",", "4", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {3, 4, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}]},
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 1, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 1, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 1, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 1, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 2, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "2", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 2, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "2", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 2, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               FractionBox[
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`mass,
                 Editable->False], 
                RowBox[{
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], "-", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                 FractionBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                  RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]],
              
              Annotation[#, {4, 2, 4} -> $CellContext`mass/(
                2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
               "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 3, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "3", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 3, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "3", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 3, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 3, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
          GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 4, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"-", 
                FractionBox[
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`mass,
                  Editable->False], 
                 RowBox[{
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], "-", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                 RowBox[{"-", 
                   FractionBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]}]],
              
              Annotation[#, {4, 4, 2} -> -$CellContext`mass/(
                2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 4, 3} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"4", ",", "4", ",", "4"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {4, 4, 4} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}, 
          "RowsIndexed" -> {
           1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"c", " ", " "},
         {" ", "a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{{
     0, 2 $CellContext`mass/(
      2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0, 
      0}, {(-2) $CellContext`mass/(
      2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0, 0, 0}, {
     0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {
    0, 0, 0, 0}}, {{0, 0, 0, 0}, {
     0, 0, $CellContext`mass/(
      2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0}, {
     0, -$CellContext`mass/(
      2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0, 0}, {0, 
     0, 0, 0}}, {{0, 0, 0, 0}, {
     0, 0, 0, $CellContext`mass/(
      2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2)}, {0, 0, 0, 
     0}, {0, -$CellContext`mass/(
      2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0, 
      0}}}, {$CellContext`ch, -$CellContext`ch, -$CellContext`ch}, 
   0][$CellContext`c, -$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"d4e15b74-3545-4b22-aae2-\
b9d475ed6dac"]
}, Open  ]],

Cell["\<\
\[Bullet] We can check that the result coincides with the expected \
contraction with the Riemann tensor of the connection:\
\>", "Text",ExpressionUUID->"1dcbb78c-fa34-4dbb-a0f2-1935ad04cefe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"commV", "==", 
  RowBox[{
   RowBox[{
    RowBox[{"Riemann", "[", "cd", "]"}], "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "d"}], ",", "c"}], "]"}], 
   RowBox[{"V", "[", "d", "]"}]}]}]], "Input",ExpressionUUID->"a6a89cc0-1ae8-\
46e5-a07b-ea1c9ec46c87"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       StyleBox[GridBox[{
          {GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox[
                FractionBox[
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False]}], 
                 RowBox[{
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], "-", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                  FractionBox[
                   RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                   RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]],
               
               Annotation[#, {1, 1, 2} -> 
                2 $CellContext`mass/(
                 2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
                "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 1, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 1, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox[
                RowBox[{"-", 
                 FractionBox[
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False]}], 
                  RowBox[{
                   RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False], " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], "-", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]]}],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                  RowBox[{"-", 
                    FractionBox[
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]}]],
               
               Annotation[#, {1, 2, 1} -> (-2) $CellContext`mass/(
                 2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
                "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 2, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 2, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 2, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 3, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 3, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 3, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 3, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 4, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 4, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 4, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 4, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}]},
          
          {GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 1, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 1, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 1, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 2, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 2, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 2, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 3, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 3, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 3, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 3, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 4, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 4, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 4, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 4, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> 
                RGBColor[0.6, 0.4, 0.2]}}]},
          {GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 1, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 1, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 1, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 1, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 2, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 2, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox[
                FractionBox[
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`mass,
                  Editable->False], 
                 RowBox[{
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], "-", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                  FractionBox[
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                   RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]],
               
               Annotation[#, {3, 2, 3} -> $CellContext`mass/(
                 2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
                "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 2, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 3, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox[
                RowBox[{"-", 
                 FractionBox[
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False], 
                  RowBox[{
                   RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False], " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], "-", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]]}],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                  RowBox[{"-", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]}]],
               
               Annotation[#, {3, 3, 2} -> -$CellContext`mass/(
                 2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
                "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 3, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 3, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 4, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 4, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 4, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 4, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> 
                RGBColor[0.6, 0.4, 0.2]}}]},
          {GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 1, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 1, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 1, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 1, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 2, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 2, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 2, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox[
                FractionBox[
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`mass,
                  Editable->False], 
                 RowBox[{
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], "-", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                  FractionBox[
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                   RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]],
               
               Annotation[#, {4, 2, 4} -> $CellContext`mass/(
                 2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
                "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 3, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 3, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 3, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 3, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 4, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox[
                RowBox[{"-", 
                 FractionBox[
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False], 
                  RowBox[{
                   RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False], " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], "-", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]]}],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                  RowBox[{"-", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], "-", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]]}]}]],
               Annotation[#, {4, 4, 2} -> -$CellContext`mass/(
                 2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 
                "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 4, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 4, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}]}
         },
         AutoDelete->False,
         GridBoxDividers->{
          "ColumnsIndexed" -> {
            1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}, 
           "RowsIndexed" -> {
            1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}}],
        FontSize->Small], 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xCoba`CTensor[{{{
      0, 2 $CellContext`mass/(
       2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0, 
       0}, {(-2) $CellContext`mass/(
       2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0, 0, 0}, {
      0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {
     0, 0, 0, 0}}, {{0, 0, 0, 0}, {
      0, 0, $CellContext`mass/(
       2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0}, {
      0, -$CellContext`mass/(
       2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0, 0}, {0, 
      0, 0, 0}}, {{0, 0, 0, 0}, {
      0, 0, 0, $CellContext`mass/(
       2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2)}, {0, 0, 0, 
      0}, {0, -$CellContext`mass/(
       2 $CellContext`mass $CellContext`r[] - $CellContext`r[]^2), 0, 
       0}}}, {$CellContext`ch, -$CellContext`ch, -$CellContext`ch}, 
    0][$CellContext`c, -$CellContext`a, -$CellContext`b],
   Editable->False], "\[Equal]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       StyleBox[GridBox[{
          {GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 1, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 1, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox[
                FractionBox[
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False]}], "-", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}]],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                  FractionBox[
                   RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], "-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]]}]],
               
               Annotation[#, {1, 2, 1} -> 
                2 $CellContext`mass (
                   2 $CellContext`mass - \
$CellContext`r[])^(-1)/$CellContext`r[], "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 2, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 2, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 2, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 3, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 3, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 3, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 3, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 4, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 4, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 4, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {1, 4, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> 
                RGBColor[0.6, 0.4, 0.2]}}]},
          {GridBox[{
             {
              TagBox[
               TooltipBox[
                RowBox[{"-", 
                 FractionBox[
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False]}], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False]}], "-", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]]}],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                  RowBox[{"-", 
                    FractionBox[
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], "-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]]}]}]],
               
               Annotation[#, {2, 1, 
                 1} -> (-2) $CellContext`mass (
                   2 $CellContext`mass - \
$CellContext`r[])^(-1)/$CellContext`r[], "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 1, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 1, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 1, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 2, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 2, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 2, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 3, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 3, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox[
                FractionBox[
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`mass,
                  Editable->False], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False]}], "-", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}]],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                  FractionBox[
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], "-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]]}]],
               
               Annotation[#, {2, 3, 
                 3} -> $CellContext`mass (
                   2 $CellContext`mass - \
$CellContext`r[])^(-1)/$CellContext`r[], "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 3, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 4, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 4, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {2, 4, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox[
                FractionBox[
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`mass,
                  Editable->False], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False]}], "-", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}]],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                  FractionBox[
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], "-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]]}]],
               
               Annotation[#, {2, 4, 
                 4} -> $CellContext`mass (
                   2 $CellContext`mass - \
$CellContext`r[])^(-1)/$CellContext`r[], "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> 
                RGBColor[0.6, 0.4, 0.2]}}]},
          {GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 1, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 1, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 1, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 1, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 2, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 2, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox[
                RowBox[{"-", 
                 FractionBox[
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False]}], "-", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]]}],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                  RowBox[{"-", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], "-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]]}]}]],
               
               Annotation[#, {3, 2, 
                 3} -> -$CellContext`mass (
                   2 $CellContext`mass - \
$CellContext`r[])^(-1)/$CellContext`r[], "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 2, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 3, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 3, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 3, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 3, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 4, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 4, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 4, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {3, 4, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> 
                RGBColor[0.6, 0.4, 0.2]}}]},
          {GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 1, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 1, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 1, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 1, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 2, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 2, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 2, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox[
                RowBox[{"-", 
                 FractionBox[
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mass,
                   Editable->False], 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mass,
                    Editable->False]}], "-", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]]}],
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                  RowBox[{"-", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mass, Editable -> False]}], "-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]]}]}]],
               
               Annotation[#, {4, 2, 
                 4} -> -$CellContext`mass (
                   2 $CellContext`mass - \
$CellContext`r[])^(-1)/$CellContext`r[], "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 3, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 3, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 3, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 3, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}], 
           GridBox[{
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 4, 1} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 4, 2} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 4, 3} -> 0, "Tooltip"]& ]},
             {
              TagBox[
               TooltipBox["0",
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                  "0"}]],
               Annotation[#, {4, 4, 4} -> 0, "Tooltip"]& ]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[0.6, 0.4, 0.2], 2 -> RGBColor[0.6, 0.4, 0.2]}}]}
         },
         AutoDelete->False,
         GridBoxDividers->{
          "ColumnsIndexed" -> {
            1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}, 
           "RowsIndexed" -> {
            1 -> RGBColor[0.6, 0.4, 0.2], 5 -> RGBColor[0.6, 0.4, 0.2]}}],
        FontSize->Small], 
       StyleBox[GridBox[{
          {" ", " ", "c"},
          {"a", "b", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xCoba`CTensor[{{{0, 0, 0, 0}, {
      2 $CellContext`mass (
         2 $CellContext`mass - $CellContext`r[])^(-1)/$CellContext`r[], 0, 0, 
       0}, {0, 0, 0, 0}, {0, 0, 0, 
      0}}, {{(-2) $CellContext`mass (
         2 $CellContext`mass - $CellContext`r[])^(-1)/$CellContext`r[], 0, 0, 
       0}, {0, 0, 0, 0}, {
      0, 0, $CellContext`mass (
         2 $CellContext`mass - $CellContext`r[])^(-1)/$CellContext`r[], 0}, {
      0, 0, 0, $CellContext`mass (
         2 $CellContext`mass - $CellContext`r[])^(-1)/$CellContext`r[]}}, {{0,
       0, 0, 0}, {
      0, 0, -$CellContext`mass (
         2 $CellContext`mass - $CellContext`r[])^(-1)/$CellContext`r[], 0}, {
      0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {
      0, 0, 
       0, -$CellContext`mass (
         2 $CellContext`mass - $CellContext`r[])^(-1)/$CellContext`r[]}, {0, 
      0, 0, 0}, {0, 0, 0, 
      0}}}, {-$CellContext`ch, -$CellContext`ch, $CellContext`ch}, 
    0][-$CellContext`a, -$CellContext`b, $CellContext`c],
   Editable->False]}]], "Output",ExpressionUUID->"a1f6f0ee-e06c-4ef7-9f19-\
c74254803bc4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input",ExpressionUUID->"2b1c1ce3-7405-4c8b-a9ed-c45d439d3a4c"],

Cell[BoxData["True"], "Output",ExpressionUUID->"8a3fea87-1ae6-4c2e-b173-3dda7d97a54f"]
}, Open  ]],

Cell["\[Bullet] Being a Levi-Civita connection, it has zero torsion:", "Text",ExpressionUUID->"3c52aed0-891e-4041-b4de-307b2e2e8c7b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Torsion", "[", "cd", "]"}], "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}]}], "]"}]], "Input",ExpressionUUID->"68137498-23a7-4276-\
a9bf-fcdd0768de83"],

Cell[BoxData["0"], "Output",ExpressionUUID->"65d9dd7b-1854-40ac-a3a2-05ceae100d70"]
}, Open  ]],

Cell["\[Bullet] The Schwarzschild metric is Ricci-flat:", "Text",ExpressionUUID->"38bf0981-b409-42b3-a113-396e7c5e8156"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "[", "cd", "]"}], "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",ExpressionUUID->"50eca37c-e830-4283-\
a8b6-c5cff4833207"],

Cell[BoxData["0"], "Output",ExpressionUUID->"b3c9e351-1f2d-4c73-99c7-310346a8f1bf"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5. Cleanup", "Subsubsection",ExpressionUUID->"77b28e3e-51fa-407f-916e-8ea0440d11f7"],

Cell["Remove the structures defined through Def commands:", "Text",ExpressionUUID->"6505eda3-6976-4a89-9fd1-1fd023439398"],

Cell[BoxData[
 RowBox[{"UnsetCMetric", "[", "met", "]"}]], "Input",ExpressionUUID->"93891727-6827-44f6-aac3-4cf02f346831"],

Cell[BoxData[
 RowBox[{"UndefConstantSymbol", "[", "mass", "]"}]], "Input",ExpressionUUID->"e6670f2b-ec81-4a33-a35f-a0cceff5a5b2"],

Cell[BoxData[
 RowBox[{"UndefChart", "[", "ch", "]"}]], "Input",ExpressionUUID->"2f04506e-a681-42ca-be49-9793de8d1977"],

Cell[BoxData[
 RowBox[{"UndefBasis", "[", "red", "]"}]], "Input",ExpressionUUID->"0be7eb56-c6b6-49d1-ab45-8a1dac6ec7cf"],

Cell[BoxData[
 RowBox[{"UndefBasis", "[", "blue", "]"}]], "Input",ExpressionUUID->"89a0c184-6cc6-4940-b2ff-1568639529c7"],

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "M", "]"}]], "Input",ExpressionUUID->"0ef1c1ba-2868-4f95-b63f-fc5f770b3612"],

Cell["Remove the expressions we have defined interactively:", "Text",ExpressionUUID->"f09f8222-226a-4c1a-968e-7ac0bf1c302d"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "commV", ",", "cd", ",", "V", ",", "v", ",", "met", ",", "S", ",", "T"}], 
  "]"}]], "Input",ExpressionUUID->"b918b0ca-3235-41c4-ac38-3c7db0a9b49a"],

Cell["Clear the cache:", "Text",ExpressionUUID->"120f6191-e3f1-481a-a8b0-8a920d634ecb"],

Cell[BoxData[
 RowBox[{"ClearxCobaCache", "[", "All", "]"}]], "Input",ExpressionUUID->"39287e4b-5a84-468d-98dd-eaf0f82a1199"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Tensors", "Subsection",ExpressionUUID->"5ed7bbd1-8381-4486-ba9c-601d02a9d6e0"],

Cell[CellGroupData[{

Cell["2.1. CTensor expressions", "Subsubsection",ExpressionUUID->"7c959dd8-37dd-422c-aba9-8490132a68cb"],

Cell["\<\
The head CTensor provides an alternative to the use of FoldedRule and \
ToValues. It describes a tensor by giving an array of components in some \
bases. A third argument adds density weight.\
\>", "Text",ExpressionUUID->"8d230a8b-359a-4150-b24f-963b93598124"],

Cell["\<\
\[Bullet] Define a manifold with a basis field for its tangent bundle:\
\>", "Text",ExpressionUUID->"1afdfcf6-ca23-429f-a78c-374b27693560"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"141d7104-3697-4d14-8992-4f1f0b523baf"],

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"B", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",Expr\
essionUUID->"f931a117-2794-477e-ac64-ed04ad5fcbfe"],

Cell["\[Bullet] Define some scalar field on the manifold:", "Text",ExpressionUUID->"d61a4566-14f4-4aa3-a45e-05ed83ba6a9d"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"s", "[", "]"}], ",", "M"}], "]"}]], "Input",ExpressionUUID->\
"3b3f8e21-01da-4745-a413-219384169ae9"],

Cell["\<\
\[Bullet] This is a vector field on M. It automatically adds the third \
argument, meaning that there is no added density weight:\
\>", "Text",ExpressionUUID->"4728ac42-1578-404f-8a2e-955414ff0f77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"I", " ", 
       RowBox[{"s", "[", "]"}]}], ",", "1", ",", 
      RowBox[{"3", 
       RowBox[{
        RowBox[{"s", "[", "]"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{"{", "B", "}"}]}], "]"}]}]], "Input",ExpressionUUID->"6b8c34b1-\
1fc5-479b-b619-8eb1e2790994"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False]}], ",", "1", ",", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["s",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`s[],
        Editable->False], "2"]}]}], "}"}], ",", 
   RowBox[{"{", "B", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"c7d68cf1-35a2-49aa-bd97-a5bec9d9b6d1"]
}, Open  ]],

Cell[TextData[{
 "\[Bullet] This object is now treated by ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " as a head v declared with DefTensor:"
}], "Text",ExpressionUUID->"74103247-8b5f-45e6-97be-935b04f2d900"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTensorQ", "[", "v", "]"}]], "Input",ExpressionUUID->"56b96a5f-7005-4e0b-852f-db43f8a8f852"],

Cell[BoxData["True"], "Output",ExpressionUUID->"ca56e033-ee05-4e1f-84ec-c48dc0d41402"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SlotsOfTensor", "[", "v", "]"}]], "Input",ExpressionUUID->"dafe208e-3b68-4d53-8a8c-452af3a376e2"],

Cell[BoxData[
 RowBox[{"{", 
  InterpretationBox[
   StyleBox["\[DoubleStruckCapitalT]M",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TangentM,
   Editable->False], "}"}]], "Output",ExpressionUUID->"0da0a11d-dd59-4431-\
93c1-50bd648d2ae2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "[", "v", "]"}]], "Input",ExpressionUUID->"5523d4e7-51f3-4f9c-ae47-4cbc163b5d9f"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", "]"}]}], "]"}]], "Output",ExpressionUUID->"9bbb091c-\
0931-4706-ac91-0e037ec4dbc6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DependenciesOfTensor", "[", "v", "]"}]], "Input",ExpressionUUID->"3608cff1-6e92-44a0-949c-5bdf2e3cbe25"],

Cell[BoxData[
 RowBox[{"{", "M", "}"}]], "Output",ExpressionUUID->"f5abbc6f-23e9-45b8-8209-108f36a7ec6c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeightOfTensor", "[", "v", "]"}]], "Input",ExpressionUUID->"3d94abf3-5d77-4b7e-9036-f7e900893cc1"],

Cell[BoxData["0"], "Output",ExpressionUUID->"05929b9a-496c-425c-bdd8-7ef52b6570ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "v", "]"}]], "Input",ExpressionUUID->"93c2796f-c6c2-49f0-82fc-03af2082cebf"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False]}], ",", "1", ",", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["s",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`s[],
        Editable->False], "2"]}]}], "}"}], ",", 
   RowBox[{"{", "B", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"4924c692-6372-4b1d-9783-bb51d14432ba"]
}, Open  ]],

Cell["\<\
\[Bullet] We can have a higher-rank tensor. Let us also make it a density of \
weight +2 in the basis B:\
\>", "Text",ExpressionUUID->"7ef064c6-9c97-4e8f-a948-6fcca5b89979"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"s", "[", "]"}], 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Signature", "[", 
         RowBox[{"{", "##", "}"}], "]"}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "4", ",", "4"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "B"}]}], "}"}], ",", 
    RowBox[{"2", "B"}]}], "]"}]}]], "Input",ExpressionUUID->"5160a158-2bed-\
4d12-9009-92d2b9766918"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0", ",", "0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0", ",", "0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B"}]}], "}"}], ",", 
   RowBox[{"2", " ", "B"}]}], "]"}]], "Output",ExpressionUUID->"e98cdbd1-6496-\
484e-ad06-f02d195f0a26"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTensorQ", "[", "A", "]"}]], "Input",ExpressionUUID->"eaf0bb20-2b7b-4088-af7e-1fce299b87c5"],

Cell[BoxData["True"], "Output",ExpressionUUID->"0ea61de3-ad62-4786-ad61-1f83258f831e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SlotsOfTensor", "[", "A", "]"}]], "Input",ExpressionUUID->"5aadad1b-3db4-42da-8ca7-0b940814dba8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox["\[DoubleStruckCapitalT]M",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TangentM,
     Editable->False]}], ",", 
   RowBox[{"-", 
    InterpretationBox[
     StyleBox["\[DoubleStruckCapitalT]M",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TangentM,
     Editable->False]}], ",", 
   RowBox[{"-", 
    InterpretationBox[
     StyleBox["\[DoubleStruckCapitalT]M",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TangentM,
     Editable->False]}]}], "}"}]], "Output",ExpressionUUID->"c83e799b-3eef-\
4b69-bbd0-c385dc441874"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "[", "A", "]"}]], "Input",ExpressionUUID->"22d93194-4a40-421d-addf-a1e9b10ba392"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"-", 
        RowBox[{"(", "1", ",", "2", ")"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      -xAct`xPerm`Cycles[{1, 2}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[
       RowBox[{"-", 
        RowBox[{"(", "2", ",", "3", ")"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      -xAct`xPerm`Cycles[{2, 3}],
      Editable->False]}], "]"}]}], "]"}]], "Output",ExpressionUUID->"ce8f36d9-\
e415-44bb-b591-c389343b8e95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DependenciesOfTensor", "[", "A", "]"}]], "Input",ExpressionUUID->"4751f3f4-fc11-451a-8a9a-3e3b58b3c141"],

Cell[BoxData[
 RowBox[{"{", "M", "}"}]], "Output",ExpressionUUID->"eb64bda6-dc3d-4802-b03e-66eeabf18f97"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeightOfTensor", "[", "A", "]"}]], "Input",ExpressionUUID->"8a443890-aa6d-44f9-b590-3736d50fe4bf"],

Cell[BoxData[
 RowBox[{"2", " ", "B"}]], "Output",ExpressionUUID->"e7db05a5-3001-4f1b-80df-07279721465b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", "A", "]"}], "===", "A"}]], "Input",ExpressionUUID->\
"6f7632e7-f981-40b7-bc75-b37f821e1f9d"],

Cell[BoxData["True"], "Output",ExpressionUUID->"818fde38-27a7-4031-a50d-179a4eeefb45"]
}, Open  ]],

Cell["\<\
\[Bullet] A CTensor with an array of zeros is replaced by the head Zero, \
which autoconverts to 0 when given indices:\
\>", "Text",ExpressionUUID->"f296838a-945b-47c1-826b-a27a1d0b9547"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"B", ",", "B"}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"db45d5eb-5d8f-4d03-8b04-64f362ce5407"],

Cell[BoxData["Zero"], "Output",ExpressionUUID->"24e33e7d-97ee-413c-925b-d74bfd166028"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zero", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",ExpressionUUID->"e6e741e1-4909-\
44b3-8b84-ed53dc20c636"],

Cell[BoxData["0"], "Output",ExpressionUUID->"7160982b-3df6-4d07-8ff6-d7b20765e223"]
}, Open  ]],

Cell["\<\
\[Bullet] A CTensor containing a scalar is automatically converted into the \
scalar:\
\>", "Text",ExpressionUUID->"004f5540-e1cd-42bf-a55a-25a814a06428"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"s", "[", "]"}], ",", 
    RowBox[{"{", "}"}]}], "]"}], "[", "]"}]], "Input",ExpressionUUID->\
"740a61e3-29ba-429e-824e-b4a54badd41e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["s",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`s[],
  Editable->False]], "Output",ExpressionUUID->"e4dda758-85ad-4342-af5c-\
8e401b8114ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",ExpressionUUID->"07877824-ad76-4c16-979c-80555aa93990"],

Cell["s[]", "Output",ExpressionUUID->"31598936-36f4-47ac-b05a-ca430daca09a"]
}, Open  ]],

Cell["\[Bullet] However, if it is a scalar density then we cannot do that:", \
"Text",ExpressionUUID->"340f01dc-7a14-437b-8da4-662984703670"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"s", "[", "]"}], ",", 
    RowBox[{"{", "}"}], ",", "B"}], "]"}], "[", "]"}]], "Input",ExpressionUUID\
->"7abd9cde-50ba-4234-a056-14a0adb495ad"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   OverscriptBox[
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s[],
     Editable->False], 
    StyleBox["~",
     FontColor->RGBColor[1., 0., 0.]]],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[
   $CellContext`s[], {}, $CellContext`B][],
  Editable->False]], "Output",ExpressionUUID->"8f8c1693-a008-401b-8d6e-\
0f35669406a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",ExpressionUUID->"403e3652-2bc7-4fe7-af78-c382ea64a21f"],

Cell["CTensor[s[], {}, B][]", "Output",ExpressionUUID->"e6111a3e-7e89-4dd8-8660-0ec78c7c7094"]
}, Open  ]],

Cell["\[Bullet] A self-consistency check:", "Text",ExpressionUUID->"8b6429f0-cbf5-4fc9-b196-b945538d5462"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", "B", "}"}]}], "]"}], "//", "Catch"}]], "Input",ExpressionUUID\
->"d4ce6744-ea99-4805-926a-126d098fb150"],

Cell[BoxData[
 TemplateBox[{
  "CTensor","nobd",
   "\"Incompatible number of bases \\!\\(\\*RowBox[{\\\"1\\\"}]\\) and array \
depth \\!\\(\\*RowBox[{\\\"2\\\"}]\\).\"",2,81,1,19248039995900841960,"Local",
   "xAct`xCoba`CTensor"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"cc39164a-1723-4ccd-90ad-0a615846b0a7"]
}, Open  ]],

Cell["\<\
Finally, note that there is no collection of the CTensor objects existing in \
a given session. In particular they do not appear in the list $Tensors.\
\>", "Text",ExpressionUUID->"bddb7097-0541-4d66-9e9c-06129d74441c"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. Indexed CTensor expressions", "Subsubsection",ExpressionUUID->"6169964c-0c5f-4274-9979-fa25d0936ea5"],

Cell[TextData[{
 "Following the standard behaviour in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", the CTensor expressions have a special typesetting when indices are \
added. This is just MatrixForm, which uses:\n\tT[a]\t\t(Column)\n\tT[a, b]\t\t\
(Column-Row)\n\tT[a, b, c]\t(Column-Row)-(Column)\n\t...\t\t..."
}], "Text",ExpressionUUID->"3f8c5ca3-ac6b-4a8e-b249-7ab0e8214eca"],

Cell[TextData[{
 "\[Bullet] Vectors (both covariant and contravariant) are represented as \
columns. In ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " we use the index height to distinguish upper/lower, and never to \
distinguish rows from columns in a matrix."
}], "Text",ExpressionUUID->"d6f4b4f4-df15-4b74-8325-3777539d645e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", "a", "]"}]], "Input",ExpressionUUID->"c4d0920f-8ffe-4a9b-9057-5613f8ea333f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"\[ImaginaryI]", " ", 
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s[],
              Editable->False]}],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{"\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`s[], Editable -> False]}]}]],
           Annotation[#, {2} -> Complex[0, 1] $CellContext`s[], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {3} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "2"]}],
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", 
              RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "2"]}]}]],
           Annotation[#, {4} -> 3 $CellContext`s[]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{
   0, Complex[0, 1] $CellContext`s[], 1, 
    3 $CellContext`s[]^2}, {$CellContext`B}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"f97eed27-d287-4643-ac25-\
19517b0bfdce"]
}, Open  ]],

Cell["\<\
The color of the lines denote the basis associated to the components:\
\>", "Text",ExpressionUUID->"a5181b4b-b500-4b57-bb91-65fe9075b019"],

Cell[CellGroupData[{

Cell[BoxData["v"], "Input",ExpressionUUID->"2bcac57f-ba2f-40e1-ac78-6269adfc2f8f"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False]}], ",", "1", ",", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["s",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`s[],
        Editable->False], "2"]}]}], "}"}], ",", 
   RowBox[{"{", "B", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"253b1fb9-0117-43ff-9f7c-3158594424e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BasisColor", "[", "B", "]"}]], "Input",ExpressionUUID->"ac6436bf-8542-44e4-bf75-0e8604255a33"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     DefaultBaseStyle->"ColorSwatchGraphics",
     Frame->True,
     FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
        AbsoluteCurrentValue[Magnification]}],
     PlotRangePadding->None],
    StyleBox[
     RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> False]],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[1, 0, 0],
  Editable->False,
  Selectable->False]], "Output",ExpressionUUID->"b9f696a5-3076-47d6-bfdb-\
78f1168becc1"]
}, Open  ]],

Cell["\<\
\[Bullet] Higher-order tensors. Note the double tilde, representing weight +2 \
in the basis B:\
\>", "Text",ExpressionUUID->"8bf973d8-afec-4cbe-b646-74ed59032fa5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}]}], "]"}]], "Input",ExpressionUUID->"f6aba3af-192e-4f88-\
82a1-7b4c030a78e6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      OverscriptBox[
       OverscriptBox[
        StyleBox[GridBox[{
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 2, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {1, 2, 3} -> $CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {1, 2, 4} -> $CellContext`s[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 3, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {1, 3, 2} -> -$CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 3, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {1, 3, 4} -> $CellContext`s[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 4, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {1, 4, 2} -> -$CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {1, 4, 3} -> -$CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 4, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 1, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {2, 1, 3} -> -$CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {2, 1, 4} -> -$CellContext`s[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 2, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 2, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 2, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {2, 3, 1} -> $CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 3, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 3, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {2, 3, 4} -> $CellContext`s[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {2, 4, 1} -> $CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 4, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {2, 4, 3} -> -$CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 4, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {3, 1, 2} -> $CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 1, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {3, 1, 4} -> -$CellContext`s[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {3, 2, 1} -> -$CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 2, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 2, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {3, 2, 4} -> -$CellContext`s[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 3, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 3, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 3, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 3, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {3, 4, 1} -> $CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {3, 4, 2} -> $CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 4, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {3, 4, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {4, 1, 2} -> $CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {4, 1, 3} -> $CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 1, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {4, 2, 1} -> -$CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 2, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]],
                Annotation[#, {4, 2, 3} -> $CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 2, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {4, 3, 1} -> -$CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["s",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`s[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
                Annotation[#, {4, 3, 2} -> -$CellContext`s[], "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 3, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 3, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 4, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 4, 2} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 4, 3} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"4", ",", "4", ",", "4"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {4, 4, 4} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}],
         FontSize->Small], 
        StyleBox["~",
         FontColor->RGBColor[1., 0., 0.]]], 
       StyleBox["~",
        FontColor->RGBColor[1., 0., 0.]]], 
      StyleBox[GridBox[{
         {" ", " ", " "},
         {"a", "b", "c"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{{0, 0, 0, 0}, {0, 0, 
      $CellContext`s[], 
      $CellContext`s[]}, {0, -$CellContext`s[], 0, 
      $CellContext`s[]}, {0, -$CellContext`s[], -$CellContext`s[], 0}}, {{
     0, 0, -$CellContext`s[], -$CellContext`s[]}, {0, 0, 0, 0}, {
      $CellContext`s[], 0, 0, 
      $CellContext`s[]}, {
      $CellContext`s[], 0, -$CellContext`s[], 0}}, {{0, 
      $CellContext`s[], 0, -$CellContext`s[]}, {-$CellContext`s[], 0, 
      0, -$CellContext`s[]}, {0, 0, 0, 0}, {
      $CellContext`s[], 
      $CellContext`s[], 0, 0}}, {{0, 
      $CellContext`s[], 
      $CellContext`s[], 0}, {-$CellContext`s[], 0, 
      $CellContext`s[], 0}, {-$CellContext`s[], -$CellContext`s[], 0, 0}, {0, 
     0, 0, 0}}}, {-$CellContext`B, -$CellContext`B, -$CellContext`B}, 
   2 $CellContext`B][-$CellContext`a, -$CellContext`b, -$CellContext`c],
  Editable->False]], "Output",ExpressionUUID->"ce88d985-252f-46ac-8d2b-\
9dbd1e10c827"]
}, Open  ]],

Cell["\<\
All three indices use the same basis B, so all lines in the representation \
are red.\
\>", "Text",ExpressionUUID->"44b82922-b73b-4f8d-9130-ae5f268e6da2"],

Cell[CellGroupData[{

Cell[BoxData["A"], "Input",ExpressionUUID->"7233428d-228d-4b9c-8d04-d9e1c54fe33e"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0", ",", "0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0", ",", "0", ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0", ",", 
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s[],
          Editable->False], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", 
         RowBox[{"-", 
          InterpretationBox[
           StyleBox["s",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`s[],
           Editable->False]}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B"}]}], "}"}], ",", 
   RowBox[{"2", " ", "B"}]}], "]"}]], "Output",ExpressionUUID->"11d27137-f235-\
419f-bef1-dd426a506e74"]
}, Open  ]],

Cell["\<\
Note that odd indices correspond to vertical lines and even indices \
correspond to horizontal lines. This is nonstandard, but as we said it helps \
in distinguishing a matrix {n, 1} from a vector, etc:\
\>", "Text",ExpressionUUID->"e02f4be7-6524-433c-92e7-0c047b642a7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatrixForm", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "2", "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"MatrixForm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "}"}]], "Input",ExpressionUUID->\
"68d57cc4-56c1-4f6f-b4a0-cd17a73d0f9c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"},
       {"2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"2"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",ExpressionUUID->"02a281bb-\
eef3-44e2-a383-b8613b419876"]
}, Open  ]],

Cell["\<\
\[Bullet] This type of representation can get difficult to understand for \
ranks beyond 2. To help with that you can hover over a given element with the \
mouse, and you will get positional information.\
\>", "Text",ExpressionUUID->"c95ad66e-9517-4d46-ac2d-be4bff11851e"],

Cell["\<\
\[Bullet] To avoid formatted tensors getting too large, a given component \
will not be typeset if its ByteCount is larger than a given predefined limit \
(that you can configure):\
\>", "Text",ExpressionUUID->"53172226-827a-4a5a-b91e-105ba1154da0"],

Cell[CellGroupData[{

Cell[BoxData["$LargeComponentSize"], "Input",ExpressionUUID->"19b1a999-f73f-46b9-ac49-84316d2cd7aa"],

Cell[BoxData["1000"], "Output",ExpressionUUID->"98373e74-619d-4dbb-b21d-df433259d264"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$LargeComponentString"], "Input",ExpressionUUID->"b6d1903c-f66d-473f-89c8-8e70928e731f"],

Cell[BoxData["\<\"\[GrayCircle]\"\>"], "Output",ExpressionUUID->"79b2592c-d4d4-4288-8304-e388a78aba2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "[", "]"}], "+", "1"}], ")"}], "^", "4"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "[", "]"}], "+", "1"}], ")"}], "^", "5"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "[", "]"}], "+", "1"}], ")"}], "^", "6"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "[", "]"}], "+", "1"}], ")"}], "^", "7"}]}], "}"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"9f5f5df8-bc6e-417a-964b-1852f35730a7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"4", " ", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "3"]}], "+", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False], "4"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"5", " ", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "4"]}], "+", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False], "5"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"6", " ", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "3"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "5"]}], "+", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False], "6"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"7", " ", 
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "3"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "4"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "5"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "6"]}], "+", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["s",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`s[],
      Editable->False], "7"]}]}], "}"}]], "Output",ExpressionUUID->"4dfd674c-\
2fd9-4afd-b432-8cf5384f8007"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ByteCount", "/@", "%"}]], "Input",ExpressionUUID->"c62d1c58-b58a-435d-863d-c1b1d14e6393"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"688", ",", "880", ",", "1072", ",", "1264"}], "}"}]], "Output",Expr\
essionUUID->"3d498d44-ad99-4ce7-b36b-c0a8914c97d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", "[", "]"}], "+", "1"}], ")"}], "^", "4"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", "[", "]"}], "+", "1"}], ")"}], "^", "5"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", "[", "]"}], "+", "1"}], ")"}], "^", "6"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", "[", "]"}], "+", "1"}], ")"}], "^", "7"}]}], "}"}], 
     ",", 
     RowBox[{"{", "B", "}"}]}], "]"}], "[", "a", "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"83b623f3-d20b-41d6-8eee-f4afe8487551"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox[
            RowBox[{"1", "+", 
             RowBox[{"4", " ", 
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["s",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`s[],
                Editable->False], "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["s",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`s[],
                Editable->False], "3"]}], "+", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "4"]}],
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", 
              RowBox[{"1", "+", 
                RowBox[{"4", " ", 
                  InterpretationBox[
                   StyleBox[
                   "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`s[], Editable -> False]}], "+", 
                RowBox[{"6", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}], "+", 
                RowBox[{"4", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "4"]}]}]],
           
           Annotation[#, {1} -> 
            1 + 4 $CellContext`s[] + 6 $CellContext`s[]^2 + 
             4 $CellContext`s[]^3 + $CellContext`s[]^4, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"1", "+", 
             RowBox[{"5", " ", 
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False]}], "+", 
             RowBox[{"10", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["s",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`s[],
                Editable->False], "2"]}], "+", 
             RowBox[{"10", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["s",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`s[],
                Editable->False], "3"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["s",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`s[],
                Editable->False], "4"]}], "+", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "5"]}],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{"1", "+", 
                RowBox[{"5", " ", 
                  InterpretationBox[
                   StyleBox[
                   "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`s[], Editable -> False]}], "+", 
                RowBox[{"10", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}], "+", 
                RowBox[{"10", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "4"]}], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "5"]}]}]],
           
           Annotation[#, {2} -> 
            1 + 5 $CellContext`s[] + 10 $CellContext`s[]^2 + 
             10 $CellContext`s[]^3 + 
             5 $CellContext`s[]^4 + $CellContext`s[]^5, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", 
              RowBox[{"1", "+", 
                RowBox[{"6", " ", 
                  InterpretationBox[
                   StyleBox[
                   "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`s[], Editable -> False]}], "+", 
                RowBox[{"15", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}], "+", 
                RowBox[{"20", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}], "+", 
                RowBox[{"15", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "4"]}], "+", 
                RowBox[{"6", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "5"]}], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "6"]}]}]],
           
           Annotation[#, {3} -> 
            1 + 6 $CellContext`s[] + 15 $CellContext`s[]^2 + 
             20 $CellContext`s[]^3 + 15 $CellContext`s[]^4 + 
             6 $CellContext`s[]^5 + $CellContext`s[]^6, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", 
              RowBox[{"1", "+", 
                RowBox[{"7", " ", 
                  InterpretationBox[
                   StyleBox[
                   "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`s[], Editable -> False]}], "+", 
                RowBox[{"21", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}], "+", 
                RowBox[{"35", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}], "+", 
                RowBox[{"35", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "4"]}], "+", 
                RowBox[{"21", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "5"]}], "+", 
                RowBox[{"7", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "6"]}], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "7"]}]}]],
           
           Annotation[#, {4} -> 
            1 + 7 $CellContext`s[] + 21 $CellContext`s[]^2 + 
             35 $CellContext`s[]^3 + 35 $CellContext`s[]^4 + 
             21 $CellContext`s[]^5 + 
             7 $CellContext`s[]^6 + $CellContext`s[]^7, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{
   1 + 4 $CellContext`s[] + 6 $CellContext`s[]^2 + 
    4 $CellContext`s[]^3 + $CellContext`s[]^4, 1 + 5 $CellContext`s[] + 
    10 $CellContext`s[]^2 + 10 $CellContext`s[]^3 + 
    5 $CellContext`s[]^4 + $CellContext`s[]^5, 1 + 6 $CellContext`s[] + 
    15 $CellContext`s[]^2 + 20 $CellContext`s[]^3 + 15 $CellContext`s[]^4 + 
    6 $CellContext`s[]^5 + $CellContext`s[]^6, 1 + 7 $CellContext`s[] + 
    21 $CellContext`s[]^2 + 35 $CellContext`s[]^3 + 35 $CellContext`s[]^4 + 
    21 $CellContext`s[]^5 + 
    7 $CellContext`s[]^6 + $CellContext`s[]^7}, {$CellContext`B}, 
   0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"3b6250db-65ff-448a-b570-\
1cd4a87e4647"]
}, Open  ]],

Cell["\<\
\[Bullet] Still, hovering over the \[OpenCurlyDoubleQuote]hidden component\
\[CloseCurlyDoubleQuote] will show you what it actually is.\
\>", "Text",ExpressionUUID->"57614af5-afab-4778-b5c8-2ffbd766fb98"],

Cell["\<\
\[Bullet] As usual in xTensor, you can choose your own formatting for the \
tensor:\
\>", "Text",ExpressionUUID->"1fb680b8-5cb6-40b9-93b9-bd18a303b061"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", "a", "]"}]], "Input",ExpressionUUID->"317f5e48-178f-45dd-b559-b175d8b69d97"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"\[ImaginaryI]", " ", 
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s[],
              Editable->False]}],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{"\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`s[], Editable -> False]}]}]],
           Annotation[#, {2} -> Complex[0, 1] $CellContext`s[], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {3} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "2"]}],
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", 
              RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "2"]}]}]],
           Annotation[#, {4} -> 3 $CellContext`s[]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{
   0, Complex[0, 1] $CellContext`s[], 1, 
    3 $CellContext`s[]^2}, {$CellContext`B}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"6509c785-fbbc-41e3-a3fd-\
1de8f8b4f232"]
}, Open  ]],

Cell["\<\
We need to use Evaluate because PrintAs has attribute HoldFirst:\
\>", "Text",ExpressionUUID->"d0738c2b-ec4f-47d3-8c87-4614e2d8a12f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"Evaluate", "[", "v", "]"}], "]"}], "^=", 
   "\"\<\[DoubleStruckCapitalV]\>\""}], ";"}]], "Input",ExpressionUUID->\
"c11fa16d-0305-40cf-8dbe-e97bf1c75c29"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", "a", "]"}]], "Input",ExpressionUUID->"7b3aea58-1229-4fb5-a265-d56a3e26b1aa"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[DoubleStruckCapitalV]", 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{
   0, Complex[0, 1] $CellContext`s[], 1, 
    3 $CellContext`s[]^2}, {$CellContext`B}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"a44187bb-4fe7-47c8-bc4e-\
414b1a0ca23b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",ExpressionUUID->"f52588c5-2a26-4f11-a986-87bf29b7b1ac"],

Cell["CTensor[{0, I*s[], 1, 3*s[]^2}, {B}, 0][a]", "Output",ExpressionUUID->"36588b76-de9e-4d4a-b68f-e71538b525fe"]
}, Open  ]],

Cell["\<\
\[Bullet] That definition was actually stored as an upvalue of CTensor. You \
can remove it as follows:\
\>", "Text",ExpressionUUID->"72c72cd3-be63-4855-a364-75cffb093861"],

Cell[BoxData[
 RowBox[{"CTensor", "/:", 
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"Evaluate", "[", "v", "]"}], "]"}], "=."}]}]], "Input",ExpressionU\
UID->"d39c9191-a050-46e4-bac3-9274f2f8c7c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", "a", "]"}]], "Input",ExpressionUUID->"c4f4c37e-ff62-4785-b9e9-a3d6dd3f1275"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"\[ImaginaryI]", " ", 
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s[],
              Editable->False]}],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{"\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`s[], Editable -> False]}]}]],
           Annotation[#, {2} -> Complex[0, 1] $CellContext`s[], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {3} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "2"]}],
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", 
              RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "2"]}]}]],
           Annotation[#, {4} -> 3 $CellContext`s[]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{
   0, Complex[0, 1] $CellContext`s[], 1, 
    3 $CellContext`s[]^2}, {$CellContext`B}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"4c1cf8af-28f7-4339-89b5-\
11816b330638"]
}, Open  ]],

Cell["\<\
\[Bullet] Components of a CTensor may be other tensors, as long as there are \
no free indices:\
\>", "Text",ExpressionUUID->"b7cda333-f245-43bf-9b2b-1215784a68a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"Basis", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "B"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", "B"}], "}"}]}], "]"}], ",", 
      RowBox[{"3", 
       RowBox[{"s", "[", "]"}]}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", "B", "}"}]}], "]"}], "[", "c", "]"}]], "Input",ExpressionUUID\
->"acc7070a-2505-476f-9bb3-f24b94d9bd14"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["b",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {
                    StyleBox["a",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             
             xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`B}, \
{$CellContext`b, $CellContext`B}],
             Editable->False],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              InterpretationBox[
               StyleBox[
                GridBox[{{"e", 
                   StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"b\",FontColor->RGBColor[1., 0., \
0.]]\)"}, {"\!\(\*StyleBox[\"a\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                 Center], AutoSpacing -> False, ShowAutoStyles -> False], 
               
               xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`B}, \
{$CellContext`b, $CellContext`B}], Editable -> False]}]],
           
           Annotation[#, {2} -> 
            xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`B}, \
{$CellContext`b, $CellContext`B}], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s[],
              Editable->False]}],
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", 
              RowBox[{"3", " ", 
                InterpretationBox[
                 StyleBox["s", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`s[], Editable -> False]}]}]],
           Annotation[#, {3} -> 3 $CellContext`s[], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4} -> 0, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"c"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{1, 
    xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`B}, {$CellContext`b, \
$CellContext`B}], 3 $CellContext`s[], 0}, {$CellContext`B}, 0][$CellContext`c],
  Editable->False]], "Output",ExpressionUUID->"a06003ce-33dd-49a6-96ef-\
ded56e1adc99"]
}, Open  ]],

Cell[TextData[{
 "Loading ",
 StyleBox["xTerior",
  FontSlant->"Italic"],
 ", the components can also be differential forms, but not tensor-valued \
differential forms."
}], "Text",ExpressionUUID->"b8658ef6-ade4-4639-b5f4-98511a68ad42"],

Cell["\[Bullet] Self-consistency checks:", "Text",ExpressionUUID->"233d9259-0833-4d9e-b397-90614c4b9da0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "//", "Catch"}]], "Input",ExpressionUUID->\
"0b1552a8-7e9a-41af-b6ec-7affd3df3dea"],

Cell[BoxData[
 TemplateBox[{
  "CTensor","nobi",
   "\"Incompatible number of bases \\!\\(\\*RowBox[{\\\"1\\\"}]\\) and \
indices \\!\\(\\*RowBox[{\\\"2\\\"}]\\).\"",2,100,2,19248039995900841960,
   "Local","xAct`xCoba`CTensor"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"bbfb0a86-dad6-4e98-bae2-2a7370461fc1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"-", "a"}], "]"}], "//", "Catch"}]], "Input",ExpressionUUID->\
"6ef84cf2-f42e-4d17-a3aa-78afa9c6ae44"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle","missing",
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]]\\).\"",2,101,3,19248039995900841960,"Local",
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"98024ffa-9326-46b9-9dec-90be2450de86"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3. Basic operations", "Subsubsection",ExpressionUUID->"74b040fb-5046-4994-885f-15db19cb2b19"],

Cell[TextData[{
 "Standard algebraic operations proceed with identical notations to those in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". "
}], "Text",ExpressionUUID->"228c234e-0901-41f2-ae43-6c9b4decd6d9"],

Cell["\<\
\[Bullet] Scalar expressions are automatically multiplied by CTensor objects:\
\
\>", "Text",ExpressionUUID->"dd3198c3-ede0-4117-ab05-dd423d055bfa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", "a", "]"}]], "Input",ExpressionUUID->"8a8ecb01-1bcc-4017-9909-83cf3b6287bd"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"\[ImaginaryI]", " ", 
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s[],
              Editable->False]}],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{"\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`s[], Editable -> False]}]}]],
           Annotation[#, {2} -> Complex[0, 1] $CellContext`s[], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {3} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "2"]}],
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", 
              RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "2"]}]}]],
           Annotation[#, {4} -> 3 $CellContext`s[]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{
   0, Complex[0, 1] $CellContext`s[], 1, 
    3 $CellContext`s[]^2}, {$CellContext`B}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"57955973-2ec9-4bd2-8dc5-\
938efe8ecb55"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7"}], 
  RowBox[{
   RowBox[{"s", "[", "]"}], "^", "2"}], 
  RowBox[{"v", "[", "a", "]"}]}]], "Input",ExpressionUUID->"e1c624c5-b761-\
4638-924c-107dba4395d7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"-", "7"}], " ", "\[ImaginaryI]", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "3"]}],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"-", "7"}], " ", "\[ImaginaryI]", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "3"]}]}]],
           
           Annotation[#, {2} -> Complex[0, -7] $CellContext`s[]^3, 
            "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"-", "7"}], " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "2"]}],
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"-", "7"}], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "2"]}]}]],
           Annotation[#, {3} -> (-7) $CellContext`s[]^2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"-", "21"}], " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "4"]}],
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"-", "21"}], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "4"]}]}]],
           Annotation[#, {4} -> (-21) $CellContext`s[]^4, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{
   0, Complex[
     0, -7] $CellContext`s[]^3, (-7) $CellContext`s[]^2, (-21) \
$CellContext`s[]^4}, {$CellContext`B}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"2c354b3c-e4fb-4bed-b62a-\
30a7aaac2982"]
}, Open  ]],

Cell["\[Bullet] Add CTensor expressions with the same index configuration:", \
"Text",ExpressionUUID->"0cafd586-9f82-4600-ad63-88f7019fd1ca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pi", ",", "E", ",", "I", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "B", "}"}]}], "]"}]}], ";"}]], "Input",ExpressionUUID->\
"e0d47a26-a0c9-40f4-9b8c-79d295f9e8c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "a", "]"}], "+", 
  RowBox[{"3", 
   RowBox[{"w", "[", "a", "]"}]}]}]], "Input",ExpressionUUID->"9a436ce9-dd56-\
4ab7-a83d-afbc089fcea2"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", "\[Pi]"}],
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", 
              RowBox[{"3", " ", "\[Pi]"}]}]],
           Annotation[#, {1} -> 3 Pi, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"3", " ", "\[ExponentialE]"}], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False]}]}],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"3", " ", "\[ExponentialE]"}], "+", 
                RowBox[{"\[ImaginaryI]", " ", 
                  InterpretationBox[
                   StyleBox[
                   "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`s[], Editable -> False]}]}]}]],
           
           Annotation[#, {2} -> 3 E + Complex[0, 1] $CellContext`s[], 
            "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"1", "+", 
             RowBox[{"3", " ", "\[ImaginaryI]"}]}],
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", 
              RowBox[{"1", "+", 
                RowBox[{"3", " ", "\[ImaginaryI]"}]}]}]],
           Annotation[#, {3} -> Complex[1, 3], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"3", "+", 
             RowBox[{"3", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["s",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`s[],
                Editable->False], "2"]}]}],
            RowBox[{
              RowBox[{"{", "4", "}"}], "\[Rule]", 
              RowBox[{"3", "+", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}]}]],
           Annotation[#, {4} -> 3 + 3 $CellContext`s[]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{3 Pi, 3 E + Complex[0, 1] $CellContext`s[], 
    Complex[1, 3], 3 + 3 $CellContext`s[]^2}, {$CellContext`B}, 
   0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"25cea661-b282-4ca8-ad41-\
3b6bb1030b9b"]
}, Open  ]],

Cell["\<\
\[Bullet] Sometimes it may happen that the tensors have the same indices, but \
in a different order. Then we reorder one of them:\
\>", "Text",ExpressionUUID->"8f7590f7-8662-4822-b187-9460c6b597b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"B", ",", "B"}], "}"}]}], "]"}]}], ";"}]], "Input",ExpressionUUI\
D->"5cbdb200-db40-4b59-acc2-d8a9c290150a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "+", 
  RowBox[{"T", "[", 
   RowBox[{"b", ",", "a"}], "]"}]}]], "Input",ExpressionUUID->"589e188c-4964-\
43a5-bd80-5a42da749d3d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "2"}]],
           Annotation[#, {1, 1} -> 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox["5",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "5"}]],
           Annotation[#, {1, 2} -> 5, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["5",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "5"}]],
           Annotation[#, {2, 1} -> 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox["8",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "8"}]],
           Annotation[#, {2, 2} -> 8, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", "b"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{2, 5}, {5, 8}}, {$CellContext`B, $CellContext`B}, 
   0][$CellContext`a, $CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"863d59c9-e40a-4ebc-9951-\
a916628b79e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "-", 
  RowBox[{"T", "[", 
   RowBox[{"b", ",", "a"}], "]"}]}]], "Input",ExpressionUUID->"8bbf21dc-bce0-\
43f6-b2eb-311413abeb8c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"-", "1"}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"-", "1"}]}]],
           Annotation[#, {1, 2} -> -1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {2, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 2} -> 0, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", "b"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{0, -1}, {1, 0}}, {$CellContext`B, $CellContext`B}, 
   0][$CellContext`a, $CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"60ae110b-254a-4674-8d5d-\
2ffb667961be"]
}, Open  ]],

Cell["\<\
\[Bullet] However, we do not move the indices by default, because that may \
interfere with the canonicalizer. The function ToCCanonical is needed then, \
to sort the indices as determined by IndexSort:\
\>", "Text",ExpressionUUID->"64e12b37-52cf-456c-8ecc-4e1955b73819"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "[", 
  RowBox[{"b", ",", "a"}], "]"}]], "Input",ExpressionUUID->"95de87c6-be26-4ab5-b331-cb7007f416f5"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "2"}]],
           Annotation[#, {1, 2} -> 2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "3"}]],
           Annotation[#, {2, 1} -> 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "4"}]],
           Annotation[#, {2, 2} -> 4, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"b", "a"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{1, 2}, {3, 4}}, {$CellContext`B, $CellContext`B}, 
   0][$CellContext`b, $CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"66ee1588-30ff-4cc9-9576-\
a8bdeab39b74"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCCanonical"}]], "Input",ExpressionUUID->"d4b1d64a-e903-4136-a73f-4d463c3cf23b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "3"}]],
           Annotation[#, {1, 2} -> 3, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "2"}]],
           Annotation[#, {2, 1} -> 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "4"}]],
           Annotation[#, {2, 2} -> 4, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", "b"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{1, 3}, {2, 4}}, {$CellContext`B, $CellContext`B}, 
   0][$CellContext`a, $CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"dbf963e1-880f-4acf-9ed0-\
7faa041cb491"]
}, Open  ]],

Cell["\<\
Note that ToCanonical is a different operation, based on the existence of \
symmetry of the tensor. In this case there is no symmetry and hence \
ToCanonical does nothing:\
\>", "Text",ExpressionUUID->"d916cb66-e346-48f2-b445-67af64db1d02"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%%", "//", "ToCanonical"}]], "Input",ExpressionUUID->"b712143a-5ef0-453c-92dc-b4cc5f67bd52"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "2"}]],
           Annotation[#, {1, 2} -> 2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "3"}]],
           Annotation[#, {2, 1} -> 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "4"}]],
           Annotation[#, {2, 2} -> 4, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"b", "a"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{1, 2}, {3, 4}}, {$CellContext`B, $CellContext`B}, 
   0][$CellContext`b, $CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"82287c28-3319-4329-b7cd-\
2cc76a3eb1b8"]
}, Open  ]],

Cell["\<\
\[Bullet] Times multiplication of two CTensor objects triggers their \
immediate tensor product:\
\>", "Text",ExpressionUUID->"6fbe5222-b96a-4830-ba94-70ba138afbee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "a", "]"}], 
  RowBox[{"v", "[", "b", "]"}]}]], "Input",ExpressionUUID->"7a23604d-c239-\
4761-9352-2f60bf170040"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"-", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "2"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"-", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "2"]}]}]],
           Annotation[#, {2, 2} -> -$CellContext`s[]^2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"\[ImaginaryI]", " ", 
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s[],
              Editable->False]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
              RowBox[{"\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`s[], Editable -> False]}]}]],
           
           Annotation[#, {2, 3} -> Complex[0, 1] $CellContext`s[], 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "3"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", 
              RowBox[{"3", " ", "\[ImaginaryI]", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "3"]}]}]],
           
           Annotation[#, {2, 4} -> Complex[0, 3] $CellContext`s[]^3, 
            "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"\[ImaginaryI]", " ", 
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s[],
              Editable->False]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`s[], Editable -> False]}]}]],
           
           Annotation[#, {3, 2} -> Complex[0, 1] $CellContext`s[], 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {3, 3} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "2"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", 
              RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "2"]}]}]],
           Annotation[#, {3, 4} -> 3 $CellContext`s[]^2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "3"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"3", " ", "\[ImaginaryI]", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "3"]}]}]],
           
           Annotation[#, {4, 2} -> Complex[0, 3] $CellContext`s[]^3, 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"3", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "2"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", 
              RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "2"]}]}]],
           Annotation[#, {4, 3} -> 3 $CellContext`s[]^2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"9", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False], "4"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", 
              RowBox[{"9", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`s[], Editable -> False], "4"]}]}]],
           Annotation[#, {4, 4} -> 9 $CellContext`s[]^4, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", "b"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
    0, -$CellContext`s[]^2, Complex[0, 1] $CellContext`s[], 
     Complex[0, 3] $CellContext`s[]^3}, {
    0, Complex[0, 1] $CellContext`s[], 1, 3 $CellContext`s[]^2}, {
    0, Complex[0, 3] $CellContext`s[]^3, 3 $CellContext`s[]^2, 
     9 $CellContext`s[]^4}}, {$CellContext`B, $CellContext`B}, 
   0][$CellContext`a, $CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"970eec32-66c6-4509-a596-\
484f397feb56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "a", "]"}], 
  RowBox[{"T", "[", 
   RowBox[{"b", ",", "c"}], "]"}]}]], "Input",ExpressionUUID->"ac690413-4694-\
4920-ae09-5511e5e55c67"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                 RowBox[{"\[ImaginaryI]", " ", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
              
              Annotation[#, {1, 1, 2} -> Complex[0, 1] $CellContext`s[], 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["1",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "3"}], "}"}], "\[Rule]", "1"}]],
              Annotation[#, {1, 1, 3} -> 1, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                 RowBox[{"3", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}]],
              Annotation[#, {1, 1, 4} -> 3 $CellContext`s[]^2, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"2", " ", "\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                 RowBox[{"2", " ", "\[ImaginaryI]", " ", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
              
              Annotation[#, {1, 2, 2} -> Complex[0, 2] $CellContext`s[], 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["2",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Rule]", "2"}]],
              Annotation[#, {1, 2, 3} -> 2, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"6", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                 RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}]],
              Annotation[#, {1, 2, 4} -> 6 $CellContext`s[]^2, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"3", " ", "\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                 RowBox[{"3", " ", "\[ImaginaryI]", " ", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
              Annotation[#, {2, 1, 2} -> Complex[0, 3] $CellContext`s[], 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["3",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "3"}], "}"}], "\[Rule]", "3"}]],
              Annotation[#, {2, 1, 3} -> 3, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"9", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
                 RowBox[{"9", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}]],
              Annotation[#, {2, 1, 4} -> 9 $CellContext`s[]^2, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"4", " ", "\[ImaginaryI]", " ", 
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                 RowBox[{"4", " ", "\[ImaginaryI]", " ", 
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}]],
              
              Annotation[#, {2, 2, 2} -> Complex[0, 4] $CellContext`s[], 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["4",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "3"}], "}"}], "\[Rule]", "4"}]],
              Annotation[#, {2, 2, 3} -> 4, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"12", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
                 RowBox[{"12", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}]],
              
              Annotation[#, {2, 2, 4} -> 12 $CellContext`s[]^2, 
               "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"b", "c", "a"},
         {" ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{{
     0, Complex[0, 1] $CellContext`s[], 1, 3 $CellContext`s[]^2}, {
     0, Complex[0, 2] $CellContext`s[], 2, 6 $CellContext`s[]^2}}, {{
     0, Complex[0, 3] $CellContext`s[], 3, 9 $CellContext`s[]^2}, {
     0, Complex[0, 4] $CellContext`s[], 4, 
      12 $CellContext`s[]^2}}}, {$CellContext`B, $CellContext`B, \
$CellContext`B}, 0][$CellContext`b, $CellContext`c, $CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"dcdb50d7-5bf1-4760-b733-\
7fbb9e545ea9"]
}, Open  ]],

Cell["\<\
\[Bullet] Finally, contractions are denoted by repeated staggered indices:\
\>", "Text",ExpressionUUID->"50242606-8c2e-433b-879d-5731cc216f35"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}], 
  RowBox[{"v", "[", "b", "]"}]}]], "Input",ExpressionUUID->"1a2b163a-15fb-\
4ec3-88e9-f2fe9533e272"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      OverscriptBox[
       OverscriptBox[
        StyleBox[GridBox[{
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
             Annotation[#, {1, 1} -> 0, "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              RowBox[{
               RowBox[{"-", 
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False]}], "-", 
               RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "3"]}]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
                RowBox[{
                  RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}], "-", 
                  RowBox[{"3", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}]}]}]],
             
             Annotation[#, {1, 2} -> -$CellContext`s[] - 3 $CellContext`s[]^3,
               "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              RowBox[{
               RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "2"]}], "-", 
               RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "3"]}]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
                RowBox[{
                  RowBox[{"\[ImaginaryI]", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}], "-", 
                  RowBox[{"3", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}]}]}]],
             
             Annotation[#, {1, 3} -> 
              Complex[0, 1] $CellContext`s[]^2 - 3 $CellContext`s[]^3, 
              "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              RowBox[{
               InterpretationBox[
                StyleBox["s",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`s[],
                Editable->False], "+", 
               RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "2"]}]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", 
                RowBox[{
                  InterpretationBox[
                   StyleBox[
                   "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`s[], Editable -> False], "+", 
                  RowBox[{"\[ImaginaryI]", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}]}]],
             
             Annotation[#, {1, 4} -> $CellContext`s[] + 
               Complex[0, 1] $CellContext`s[]^2, "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox[
              RowBox[{
               InterpretationBox[
                StyleBox["s",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`s[],
                Editable->False], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "3"]}]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
                RowBox[{
                  InterpretationBox[
                   StyleBox[
                   "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`s[], Editable -> False], "+", 
                  RowBox[{"3", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}]}]}]],
             Annotation[#, {2, 1} -> $CellContext`s[] + 3 $CellContext`s[]^3, 
              "Tooltip"]& ], 
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "0"}]],
             Annotation[#, {2, 2} -> 0, "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              RowBox[{
               RowBox[{"-", "3"}], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False], "3"]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
                RowBox[{
                  RowBox[{"-", "3"}], " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}]}]],
             Annotation[#, {2, 3} -> (-3) $CellContext`s[]^3, "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              InterpretationBox[
               StyleBox["s",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`s[],
               Editable->False],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", 
                InterpretationBox[
                 StyleBox["s", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`s[], Editable -> False]}]],
             Annotation[#, {2, 4} -> $CellContext`s[], "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox[
              RowBox[{
               RowBox[{
                RowBox[{"-", "\[ImaginaryI]"}], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "2"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "3"]}]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
                RowBox[{
                  RowBox[{
                    RowBox[{"-", "\[ImaginaryI]"}], " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}], "+", 
                  RowBox[{"3", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}]}]}]],
             
             Annotation[#, {3, 1} -> 
              Complex[0, -1] $CellContext`s[]^2 + 3 $CellContext`s[]^3, 
              "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              RowBox[{"3", " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False], "3"]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}]}]],
             Annotation[#, {3, 2} -> 3 $CellContext`s[]^3, "Tooltip"]& ], 
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "0"}]],
             Annotation[#, {3, 3} -> 0, "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              RowBox[{
               RowBox[{"-", "\[ImaginaryI]"}], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False], "2"]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", 
                RowBox[{
                  RowBox[{"-", "\[ImaginaryI]"}], " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}]],
             
             Annotation[#, {3, 4} -> Complex[0, -1] $CellContext`s[]^2, 
              "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox[
              RowBox[{
               RowBox[{"-", 
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False]}], "-", 
               RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["s",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`s[],
                  Editable->False], "2"]}]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", 
                RowBox[{
                  RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}], "-", 
                  RowBox[{"\[ImaginaryI]", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}]}]],
             
             Annotation[#, {4, 1} -> -$CellContext`s[] + 
               Complex[0, -1] $CellContext`s[]^2, "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              RowBox[{"-", 
               InterpretationBox[
                StyleBox["s",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`s[],
                Editable->False]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", 
                RowBox[{"-", 
                  InterpretationBox[
                   StyleBox[
                   "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`s[], Editable -> False]}]}]],
             Annotation[#, {4, 2} -> -$CellContext`s[], "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              RowBox[{"\[ImaginaryI]", " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["s",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`s[],
                 Editable->False], "2"]}],
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", 
                RowBox[{"\[ImaginaryI]", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}]],
             
             Annotation[#, {4, 3} -> Complex[0, 1] $CellContext`s[]^2, 
              "Tooltip"]& ], 
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "0"}]],
             Annotation[#, {4, 4} -> 0, "Tooltip"]& ]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}],
         FontSize->Small], 
        StyleBox["~",
         FontColor->RGBColor[1., 0., 0.]]], 
       StyleBox["~",
        FontColor->RGBColor[1., 0., 0.]]], 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "c"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{
    0, -$CellContext`s[] - 3 $CellContext`s[]^3, 
     Complex[0, 1] $CellContext`s[]^2 - 
     3 $CellContext`s[]^3, $CellContext`s[] + 
     Complex[0, 1] $CellContext`s[]^2}, {$CellContext`s[] + 
     3 $CellContext`s[]^3, 0, (-3) $CellContext`s[]^3, 
     $CellContext`s[]}, {
    Complex[0, -1] $CellContext`s[]^2 + 3 $CellContext`s[]^3, 
     3 $CellContext`s[]^3, 0, 
     Complex[0, -1] $CellContext`s[]^2}, {-$CellContext`s[] + 
     Complex[0, -1] $CellContext`s[]^2, -$CellContext`s[], 
     Complex[0, 1] $CellContext`s[]^2, 
     0}}, {-$CellContext`B, -$CellContext`B}, 
   2 $CellContext`B][-$CellContext`a, -$CellContext`c],
  Editable->False]], "Output",ExpressionUUID->"8993a73c-a531-480d-8543-\
20897a2da24e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", 
  RowBox[{"v", "[", "c", "]"}]}]], "Input",ExpressionUUID->"d52a1ea9-8504-4468-85fb-166949cffa03"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      OverscriptBox[
       OverscriptBox[
        StyleBox[GridBox[{
           {
            TagBox[
             TooltipBox["\<\"\[GrayCircle]\"\>",
              RowBox[{
                RowBox[{"{", "1", "}"}], "\[Rule]", 
                RowBox[{
                  RowBox[{"\[ImaginaryI]", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}], "-", 
                  RowBox[{"3", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}], "+", 
                  RowBox[{"3", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "+", 
                    RowBox[{"\[ImaginaryI]", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "2"]}]}], ")"}]}], 
                  "+", 
                  RowBox[{"\[ImaginaryI]", " ", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "3"]}]}], 
                    ")"}]}]}]}]],
             
             Annotation[#, {1} -> 
              Complex[0, 1] $CellContext`s[]^2 - 3 $CellContext`s[]^3 + 
               3 $CellContext`s[]^2 ($CellContext`s[] + 
                 Complex[0, 1] $CellContext`s[]^2) + 
               Complex[0, 1] $CellContext`s[] (-$CellContext`s[] - 
                 3 $CellContext`s[]^3), "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", "2", "}"}], "\[Rule]", "0"}]],
             Annotation[#, {2} -> 0, "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", "3", "}"}], "\[Rule]", "0"}]],
             Annotation[#, {3} -> 0, "Tooltip"]& ]},
           {
            TagBox[
             TooltipBox["0",
              RowBox[{
                RowBox[{"{", "4", "}"}], "\[Rule]", "0"}]],
             Annotation[#, {4} -> 0, "Tooltip"]& ]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
         FontSize->Small], 
        StyleBox["~",
         FontColor->RGBColor[1., 0., 0.]]], 
       StyleBox["~",
        FontColor->RGBColor[1., 0., 0.]]], 
      StyleBox[GridBox[{
         {" "},
         {"a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{
   Complex[0, 1] $CellContext`s[]^2 - 3 $CellContext`s[]^3 + 
    3 $CellContext`s[]^2 ($CellContext`s[] + 
      Complex[0, 1] $CellContext`s[]^2) + 
    Complex[0, 1] $CellContext`s[] (-$CellContext`s[] - 3 $CellContext`s[]^3),
     0, 0, 0}, {-$CellContext`B}, 2 $CellContext`B][-$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"6ec21c66-8ce2-441d-8796-\
04c1e5054f69"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input",ExpressionUUID->"1e01107a-5547-4d7a-a7a1-3385a610af97"],

Cell[BoxData["0"], "Output",ExpressionUUID->"507311c7-5df1-4614-8567-8b004b89d5af"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4. Metric", "Subsubsection",ExpressionUUID->"bca63889-fe4e-4c21-b0a4-388150e2c97a"],

Cell["\<\
Once we have a metric field in our problem, there are many more things we can \
do. In this section we focus on how to set a metric field, and which other \
tensors are algebraically related to it. We can specify a metric field in \
several possible ways. We start with the simpler case of a metric given in a \
coordinate chart. We shall use the example of spherical angles on the \
2-sphere.\
\>", "Text",ExpressionUUID->"f799e780-c163-4138-b3c7-4366fe1d20c6"],

Cell["\[Bullet] Define the S2 manifold, with script indices:", "Text",ExpressionUUID->"4bd80f2e-19e4-41db-a165-884c0eb1d1ac"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"S2", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[ScriptA]", ",", "\[ScriptB]", ",", "\[ScriptC]", ",", "\[ScriptD]", 
     ",", "\[ScriptE]", ",", "\[ScriptF]"}], "}"}]}], "]"}]], "Input",Expressi\
onUUID->"72b4b84b-c494-4eb4-967b-10fac8cc932e"],

Cell["\[Bullet] Define the chart:", "Text",ExpressionUUID->"edd59579-0fc5-4d50-b789-22c236f6ffae"],

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"sph", ",", "S2", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"2b5abe7e-e593-4e89-a59a-65e15d4e2a16"],

Cell["\<\
\[Bullet] Construct a metric field, that is a symmetric covariant 2-tensor:\
\>", "Text",ExpressionUUID->"c81d1b42-5d11-46ef-9a92-f78abb346162"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"\[Theta]", "[", "]"}], "]"}], "^", "2"}]}], "}"}]}], "}"}],
     ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "sph"}], ",", 
      RowBox[{"-", "sph"}]}], "}"}]}], "]"}]}]], "Input",ExpressionUUID->\
"e2b24f6c-809a-42d4-a8dd-de6261718e7b"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False], "]"}], "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph"}], ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUI\
D->"820e6ea9-f6fa-45be-9887-aba83825b3c8"]
}, Open  ]],

Cell["\[Bullet] This is the inverse metric:", "Text",ExpressionUUID->"4f5e77f3-cec9-4afd-8a18-a075d38a0d63"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"imet", "=", 
  RowBox[{"Inv", "[", "met", "]"}]}]], "Input",ExpressionUUID->"de5e07ce-fa08-\
4d69-a07d-8cbb6cbc19b1"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Csc",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Csc,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False], "]"}], "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"sph", ",", "sph"}], "}"}], ",", "0"}], "]"}]], "Output",Expressio\
nUUID->"12cacf48-bea3-4148-ba81-d319aba01cb4"]
}, Open  ]],

Cell["\[Bullet] Check that they are indeed inverses:", "Text",ExpressionUUID->"dea64438-fc84-4f2e-a8ac-fbf6affabcce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"met", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], 
  RowBox[{"imet", "[", 
   RowBox[{"b", ",", "c"}], "]"}]}]], "Input",ExpressionUUID->"af0c8444-e838-\
4758-b257-b0da5710e1d6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {2, 2} -> 1, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"c", " "},
         {" ", "a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{1, 0}, {0, 1}}, {$CellContext`sph, -$CellContext`sph}, 
   0][$CellContext`c, -$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"efcdf8f9-eeec-4b96-a1fb-\
a61c609bf167"]
}, Open  ]],

Cell["\<\
\[Bullet] We can also compute the metric determinant, which is a density of \
weight +2 in the given chart (note the third argument of CTensor in the \
result):\
\>", "Text",ExpressionUUID->"6427ab91-0b2e-4836-9e3a-72d8e8b16540"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Determinant", "[", 
  RowBox[{"met", ",", "sph"}], "]"}]], "Input",ExpressionUUID->"8793a338-2cf3-\
4ec8-b7ce-92da9cde20a9"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], "]"}], "2"], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"2", " ", "sph"}]}], "]"}]], "Output",ExpressionUUID->"0bd9c277-\
a0c5-4be3-81e7-95bd9994694a"]
}, Open  ]],

Cell["\<\
\[Bullet] Or the epsilon tensor, which is a pure tensor, and not a density:\
\>", "Text",ExpressionUUID->"f4bcd84f-8f77-4337-971b-a25f7f933abf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"epsilon", "[", "met", "]"}]], "Input",ExpressionUUID->"bab8c900-eaba-4bc0-9eed-84ee4fc8fbb2"],

Cell[BoxData[
 TemplateBox[{
  "SignDetOfMetric","num",
   "\"Cannot determine sign of determinant of matrix \\!\\(\\*RowBox[{\\\"{\\\
\", RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \\\",\\\", \\\"0\\\"}], \
\\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0\\\", \\\",\\\", \
SuperscriptBox[RowBox[{InterpretationBox[StyleBox[RowBox[{\\\"Sin\\\"}], \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], Sin, Rule[Editable, \
False]], \\\"[\\\", InterpretationBox[StyleBox[\\\"\[Theta]\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], \\\\[Theta][], \
Rule[Editable, False]], \\\"]\\\"}], \\\"2\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}]\
\\). Assuming +1.\"",2,123,4,19248039995900841960,"Local",
   "xAct`xTensor`SignDetOfMetric"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"5f608f1a-70c7-4aaa-9e20-01e0c2a208a2"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     TagBox["SparseArray",
      "SummaryHead"], "[", 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
      "Ready"}, 
      TemplateBox[{PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[
               
               RasterBox[{{{0.5, 0., 0.}, {0.235431, 0.32765, 0.833291}}, {{
                0.235431, 0.32765, 0.833291}, {0.5, 0., 0.}}}, {{0, 0}, {2, 
                2}}, {0, 1}], AspectRatio -> 1, Axes -> False, Frame -> False,
                FrameLabel -> {None, None}, FrameStyle -> Directive[
                 Opacity[0.5], 
                 Thickness[Tiny], 
                 RGBColor[0.368417, 0.506779, 0.709798]], 
               FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
               Directive[
                 GrayLevel[0.5, 0.4]], ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}], 
               Method -> {
                "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> 
                 Automatic, "DefaultPlotStyle" -> Automatic, "DomainPadding" -> 
                 Scaled[0.02], "RangePadding" -> Scaled[0.05]}], 
              GridBox[{{
                 RowBox[{
                   TagBox[
                   "\"Specified elements: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["2", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Dimensions: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}], "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}]], 
              GraphicsBox[
               
               RasterBox[{{{0.5, 0., 0.}, {0.235431, 0.32765, 0.833291}}, {{
                0.235431, 0.32765, 0.833291}, {0.5, 0., 0.}}}, {{0, 0}, {2, 
                2}}, {0, 1}], AspectRatio -> 1, Axes -> False, Frame -> False,
                FrameLabel -> {None, None}, FrameStyle -> Directive[
                 Opacity[0.5], 
                 Thickness[Tiny], 
                 RGBColor[0.368417, 0.506779, 0.709798]], 
               FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
               Directive[
                 GrayLevel[0.5, 0.4]], ImageSize -> 
               Dynamic[{
                 Automatic, 
                  3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}], 
               Method -> {
                "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> 
                 Automatic, "DefaultPlotStyle" -> Automatic, "DomainPadding" -> 
                 Scaled[0.02], "RangePadding" -> Scaled[0.05]}], 
              GridBox[{{
                 RowBox[{
                   TagBox[
                   "\"Specified elements: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["2", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Dimensions: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}], "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Default: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["0", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Density: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["0.5`", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Elements:\"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"\"", "SummaryItem"]}]}, {
                 TagBox[
                  TagBox[
                   GridBox[{{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
                    StyleBox[
                    PaneBox[
                    SqrtBox[
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], "2"]],
                     ContentPadding -> False, FrameMargins -> 0, StripOnInput -> 
                    True, BaselinePosition -> Baseline, 
                    ImageSize -> {{1, 300}, Automatic}], LineBreakWithin -> 
                    False]}]}, {
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
                    StyleBox[
                    PaneBox[
                    RowBox[{"-", 
                    SqrtBox[
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                    "2"]]}], ContentPadding -> False, FrameMargins -> 0, 
                    StripOnInput -> True, BaselinePosition -> Baseline, 
                    ImageSize -> {{1, 300}, Automatic}], LineBreakWithin -> 
                    False]}]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                   "Column"], "SummaryItem"]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic]},
       "SummaryPanel"],
      DynamicModuleValues:>{}], "]"}],
    SparseArray[
    Automatic, {2, 2}, 0, {
     1, {{0, 1, 2}, {{2}, {1}}}, {(Sin[$CellContext`\[Theta][]]^2)^
       Rational[1, 2], -(Sin[$CellContext`\[Theta][]]^2)^Rational[1, 2]}}],
    Editable->False,
    SelectWithContents->True,
    Selectable->False], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph"}], ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUI\
D->"ea61c747-af2b-4a76-9142-78f5fd245532"]
}, Open  ]],

Cell["\<\
It is constructed as a SparseArray. Use Normal to get the corresponding \
normal array:\
\>", "Text",ExpressionUUID->"fd6c5295-2819-43ae-982f-8156212ac94e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Normal"}]], "Input",ExpressionUUID->"e422fffc-3c27-408c-a9f4-085064ba390e"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SqrtBox[
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["\[Theta]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Theta][],
            Editable->False], "]"}], "2"]]}], ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph"}], ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUI\
D->"001f4126-3b96-409a-a11b-78c6e47f2ca0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"\[Theta]", "[", "]"}], "]"}], ">", "0"}]}], "]"}]], "Input",Expr\
essionUUID->"46243fb3-fc0d-481d-9e88-d32b3a274239"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          ShowAutoStyles->False,
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["\[Theta]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Theta][],
         Editable->False], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False], "]"}]}], ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph"}], ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUI\
D->"683fbc24-4655-4c57-b6b8-560da516ee54"]
}, Open  ]],

Cell[TextData[{
 "So far the metric field we have is just a normal tensor field, and ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " does not know yet that it is going to play any special role. In order to \
declare it as special we need to use SetCMetric, the component equivalent of \
DefMetric."
}], "Text",ExpressionUUID->"b2502bad-0b45-4f75-a86f-d9e275f6b495"],

Cell["\<\
\[Bullet] Declare met as the first-metric of the tangent bundle TangentS2. \
This will precompute a number of objects associated to the metric.\
\>", "Text",ExpressionUUID->"2b3b0cdd-035d-4732-a030-7ab68563d972"],

Cell[BoxData[
 RowBox[{"SetCMetric", "[", 
  RowBox[{"met", ",", "sph", ",", 
   RowBox[{"SignatureOfMetric", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "0"}], "}"}]}]}], "]"}]], "Input",ExpressionU\
UID->"17bba426-4ef5-474f-8d1e-c729e3229d00"],

Cell["\<\
\[Bullet] Now we can raise and lower indices, because we know what the metric \
is.\
\>", "Text",ExpressionUUID->"efacfa61-eefe-42ac-8683-76defe10bd6a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", "sph", "}"}]}], "]"}]}]], "Input",ExpressionUUID->"e5fae051-\
0dee-4abd-af63-3481bfb20711"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "sph", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"291daecb-60e0-4f29-a45c-8deec5335843"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "[", "a", "]"}]], "Input",ExpressionUUID->"fb6201c1-f498-44d4-a1f8-76c7f89d5f60"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", "2"}]],
           Annotation[#, {2} -> 2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{1, 2}, {$CellContext`sph}, 0][$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"9881a402-ad09-4c78-86b4-\
fad2ae3b67f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "[", 
  RowBox[{"-", "a"}], "]"}]], "Input",ExpressionUUID->"9e69d616-1a44-4468-b566-190cc0e3c8e8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], "2"]}],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{"2", " ", 
                SuperscriptBox[
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                   InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                 "2"]}]}]],
           Annotation[#, {2} -> 2 Sin[
                $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" "},
         {"a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{1, 2 Sin[
       $CellContext`\[Theta][]]^2}, {-$CellContext`sph}, 0][-$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"271cfdc1-712c-4656-b6c2-\
8565a0c8d405"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"met", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], 
  RowBox[{"V", "[", "b", "]"}]}]], "Input",ExpressionUUID->"1ecd167e-d121-\
4826-99eb-c9ec841607a9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], "2"]}],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{"2", " ", 
                SuperscriptBox[
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                   InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                 "2"]}]}]],
           Annotation[#, {2} -> 2 Sin[
                $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" "},
         {"a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{1, 2 Sin[
       $CellContext`\[Theta][]]^2}, {-$CellContext`sph}, 0][-$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"975addba-97cf-4e8e-ac8f-\
fc91811c52bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", 
  RowBox[{"imet", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Input",ExpressionUUID->"6d7e0202-49dc-\
48aa-9421-6563357c99ba"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1} -> 1, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", "2"}]],
           Annotation[#, {2} -> 2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"b"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{1, 2}, {$CellContext`sph}, 0][$CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"9db1dc47-abd6-4c44-ad19-\
a877f17afdc4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5. ToCTensor: changes of bases and height", "Subsubsection",ExpressionUUID->"a6d6f0f4-86c9-4d00-affb-7cb29a446f88"],

Cell["\<\
One of the most useful features of xCoba in comparison with other tensor CASs \
is its ability to manipulate several bases simultaneously and tensor \
components in different, even mixed bases. We can also have CTensor objects \
expressed in different bases, and we can easily change those bases, \
effectively implementing the basic tensorial transformation law. Note that \
this changes simultaenously bases and components, such that the changes \
compensate mutually and the actual tensor is left unchanged. Hence we are \
referring to passive changes.\
\>", "Text",ExpressionUUID->"0242abc9-e8fb-47cd-b516-0f633ff8a9b6"],

Cell["\<\
\[Bullet] Introduce a second frame on the sphere. To avoid discussing \
coordinate dependencies, we choose it to be a rigid transformation. Note how \
the transformation is provided: the new frame is associated to the first \
tensor slot, and in covariant form:\
\>", "Text",ExpressionUUID->"a8543bc8-574b-4597-a26a-5f1f4138a2ab"],

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"sph2", ",", "TangentS2", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"BasisChange", "\[Rule]", 
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "sph2"}], ",", "sph"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"BasisColor", "\[Rule]", "Blue"}]}], "]"}]], "Input",ExpressionUUID\
->"89f3c1b7-d819-455a-a16f-e360c9f47e66"],

Cell["\[Bullet] This is a vector field on the sphere:", "Text",ExpressionUUID->"16a8b881-c27b-44b3-a1dc-c2ee677e17bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", "sph", "}"}]}], "]"}]}]], "Input",ExpressionUUID->"52f77bdf-\
4f08-4dd4-8de9-2253adb39b65"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "sph", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"4f8388e4-d89e-47a7-bfd6-d7c84621cf67"]
}, Open  ]],

Cell["\[Bullet] Change it to the new frame:", "Text",ExpressionUUID->"a0dd83d8-21b0-4a0e-a756-8f3f55ca3568"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", "sph2", "}"}]}], "]"}]], "Input",ExpressionUUID->"79ed9ff7-\
1a86-49e3-aa30-cfa86896b317"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["5", "7"], ",", 
     FractionBox["1", "7"]}], "}"}], ",", 
   RowBox[{"{", "sph2", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"15fcef6f-3935-4c55-b67f-abda9c285b2f"]
}, Open  ]],

Cell["\[Bullet] Change it back to the original frame:", "Text",ExpressionUUID->"55ec00c5-ee1b-45d4-8ef6-a1d3d4fc67e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", "sph", "}"}]}], "]"}]], "Input",ExpressionUUID->"7f3ebad3-\
0013-479e-ab43-d2e42dbaa806"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "sph", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"a167bc87-4179-47e9-9f91-3d033a73a4b9"]
}, Open  ]],

Cell["\[Bullet] The identity tensor in the sph frame:", "Text",ExpressionUUID->"e7784f3e-219e-4c0b-8fcd-0fb8dcb2fe70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"delta", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph"}], ",", "sph"}], "}"}]}], "]"}]], "Input",ExpressionUU\
ID->"70de3f46-d8c5-4290-a4d0-e1210959f057"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph"}], ",", "sph"}], "}"}], ",", "0"}], "]"}]], "Output",E\
xpressionUUID->"01160e67-6742-49c2-8fb2-bda5c91015d5"]
}, Open  ]],

Cell["\[Bullet] Its components do not change under a change of basis:", "Text",ExpressionUUID->"b44992d4-1caa-44a5-89d5-c04d2885e4f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph2"}], ",", "sph2"}], "}"}]}], "]"}]], "Input",Expression\
UUID->"d4dd7230-c00a-46b0-bae6-0e6b7f974464"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph2"}], ",", "sph2"}], "}"}], ",", "0"}], "]"}]], "Output",\
ExpressionUUID->"41a6be7a-d514-4958-b33f-a3dbe47df0c6"]
}, Open  ]],

Cell["\[Bullet] The components of the metric do change:", "Text",ExpressionUUID->"785dc785-7fcf-4d0c-85d2-bb27b5fd5bf8"],

Cell[CellGroupData[{

Cell[BoxData["met"], "Input",ExpressionUUID->"50c64c12-d951-4515-8ae5-65a098c70121"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False], "]"}], "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph"}], ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUI\
D->"9be680b8-1e96-42c8-8871-3e5fb1c879dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph2"}], ",", 
     RowBox[{"-", "sph2"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"764306ad-f502-41b1-9574-1ea3e83820e0"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "+", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"]}], ",", 
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["\[Theta]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Theta][],
            Editable->False], "]"}], "2"]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["\[Theta]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Theta][],
            Editable->False], "]"}], "2"]}]}], ",", 
       RowBox[{"9", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["\[Theta]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Theta][],
            Editable->False], "]"}], "2"]}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph2"}], ",", 
     RowBox[{"-", "sph2"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUU\
ID->"57be8e6d-143f-477f-a194-d27a435a51ac"]
}, Open  ]],

Cell["\<\
\[Bullet] We can also use CTensor to change the hight of the slots of a \
tensor. Effectively that absorbs metric factors:\
\>", "Text",ExpressionUUID->"7fb27912-f701-4efe-85d7-eefba13a0401"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"met", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph2"}], ",", "sph2"}], "}"}]}], "]"}]], "Input",Expression\
UUID->"358c3871-77bf-48a6-8da8-536fcf6c6fdf"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph2"}], ",", "sph2"}], "}"}], ",", "0"}], "]"}]], "Output",\
ExpressionUUID->"ffd78b80-c14f-4a01-aaec-101d03ad5521"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["v"], "Input",ExpressionUUID->"7d0cdd53-1bfa-4533-8bde-bde2be9c3327"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "sph", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"164e81bc-1853-4826-82e6-e1731de4117c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"v", ",", 
   RowBox[{"{", 
    RowBox[{"-", "sph"}], "}"}]}], "]"}]], "Input",ExpressionUUID->"133f5e14-\
85e9-4900-a063-451e0111429a"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         ShowAutoStyles->False,
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "sph"}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"7df0c12f-924f-41c2-8938-4df1ba7f6fff"]
}, Open  ]],

Cell["\<\
\[Bullet] Finally, we can also use ToCTensor to expand a tensor into its \
components:\
\>", "Text",ExpressionUUID->"1b2ab81c-9025-49a2-adfc-9a1e95e5c9c0"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"\[ScriptA]", ",", 
     RowBox[{"-", "\[ScriptB]"}]}], "]"}], ",", "S2"}], "]"}]], "Input",Expres\
sionUUID->"e3a76a4f-79af-46a0-b174-4c0aa60ee427"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"S", ",", 
   RowBox[{"{", 
    RowBox[{"sph", ",", 
     RowBox[{"-", "sph2"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"b96408b9-c5cc-4a29-be5d-eab32b5ec65d"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"S", 
            StyleBox[GridBox[{
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], " "},
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S[{1, $CellContext`sph}, {1, -$CellContext`sph2}],
        Editable->False], ",", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"S", 
            StyleBox[GridBox[{
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], " "},
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S[{1, $CellContext`sph}, {2, -$CellContext`sph2}],
        Editable->False]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"S", 
            StyleBox[GridBox[{
               {
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], " "},
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S[{2, $CellContext`sph}, {1, -$CellContext`sph2}],
        Editable->False], ",", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"S", 
            StyleBox[GridBox[{
               {
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], " "},
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->Rational[39, 4]]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S[{2, $CellContext`sph}, {2, -$CellContext`sph2}],
        Editable->False]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"sph", ",", 
     RowBox[{"-", "sph2"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUU\
ID->"6c6ff3a4-d4b1-46a0-af90-2ab4284e6666"]
}, Open  ]],

Cell["\[Bullet] Compare with the result from ComponentArray:", "Text",ExpressionUUID->"5dfb437d-a50c-488b-a063-a2c992188c98"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentArray", "[", 
  RowBox[{"S", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[ScriptA]", ",", "sph"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "\[ScriptB]"}], ",", 
      RowBox[{"-", "sph2"}]}], "}"}]}], "]"}], "]"}]], "Input",ExpressionUUID-\
>"a92cc83b-1770-4d24-810d-ebbf1c8ae2df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"S", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], " "},
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[{1, $CellContext`sph}, {1, -$CellContext`sph2}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"S", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], " "},
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[{1, $CellContext`sph}, {2, -$CellContext`sph2}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"S", 
          StyleBox[GridBox[{
             {
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]], " "},
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[{2, $CellContext`sph}, {1, -$CellContext`sph2}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"S", 
          StyleBox[GridBox[{
             {
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]], " "},
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[{2, $CellContext`sph}, {2, -$CellContext`sph2}],
      Editable->False]}], "}"}]}], "}"}]], "Output",ExpressionUUID->"3eea1927-\
5250-4656-a020-a723038777f6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6. Extracting components", "Subsubsection",ExpressionUUID->"97b16043-f684-454c-b371-43ff35dd67b0"],

Cell["\<\
Closely related to the problem of changes of bases we have that of extraction \
of particular components. If necessary, a change of basis will be performed \
automatically.\
\>", "Text",ExpressionUUID->"ae15dff6-63fb-4a59-a483-93fbad828e8e"],

Cell["\[Bullet] Extract a component of the metric in the same bases:", "Text",ExpressionUUID->"e0300adb-165b-4d9e-ae0e-344b80f1b8e6"],

Cell[CellGroupData[{

Cell[BoxData["met"], "Input",ExpressionUUID->"7b0a1ac3-592d-443f-90a4-ce1df3e72353"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False], "]"}], "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph"}], ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUI\
D->"c29ad18a-36aa-40ad-a91d-cdff160ea6a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "sph"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"51f3ad70-0649-4506-a35e-2f3bc6161a70"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{
   InterpretationBox[
    StyleBox["Sin",
     ShowAutoStyles->False,
     AutoSpacing->False],
    Sin,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox["\[Theta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Theta][],
    Editable->False], "]"}], "2"]], "Output",ExpressionUUID->"a569a7a7-db0a-\
4044-bfd7-8a6b03eae092"]
}, Open  ]],

Cell["\[Bullet] Extract a component in a different basis:", "Text",ExpressionUUID->"184ea674-bb58-442f-9206-87e854b11549"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "sph2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "sph2"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"22257414-f055-4d7f-822f-d3ab78d9820a"],

Cell[BoxData[
 RowBox[{"9", "+", 
  RowBox[{"4", " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], "]"}], "2"]}]}]], "Output",ExpressionUUID->"25c086bf-\
7ad3-4cc9-af19-4ad343795784"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCTensor", "[", 
   RowBox[{"met", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "sph2"}], ",", 
      RowBox[{"-", "sph2"}]}], "}"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"-", "\[ScriptA]"}], ",", 
   RowBox[{"-", "\[ScriptB]"}]}], "]"}]], "Input",ExpressionUUID->"38f5f286-\
f955-453d-80ea-62df83df93cb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox[
            RowBox[{"4", "+", 
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], "2"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
              RowBox[{"4", "+", 
                SuperscriptBox[
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                   InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                 "2"]}]}]],
           Annotation[#, {1, 1} -> 4 + Sin[
                $CellContext`\[Theta][]]^2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"-", "6"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False], "]"}], "2"]}]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"-", "6"}], "+", 
                RowBox[{"2", " ", 
                  SuperscriptBox[
                   RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                   "2"]}]}]}]],
           Annotation[#, {1, 2} -> -6 + 2 Sin[
                 $CellContext`\[Theta][]]^2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"-", "6"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False], "]"}], "2"]}]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"-", "6"}], "+", 
                RowBox[{"2", " ", 
                  SuperscriptBox[
                   RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                   "2"]}]}]}]],
           Annotation[#, {2, 1} -> -6 + 2 Sin[
                 $CellContext`\[Theta][]]^2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"9", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False], "]"}], "2"]}]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"9", "+", 
                RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                   "2"]}]}]}]],
           Annotation[#, {2, 2} -> 9 + 4 Sin[
                 $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[0, 0, 1], 3 -> RGBColor[0, 0, 1]},
           "RowsIndexed" -> {1 -> RGBColor[0, 0, 1], 3 -> RGBColor[0, 0, 1]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " "},
         {"\[ScriptA]", "\[ScriptB]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{4 + Sin[
        $CellContext`\[Theta][]]^2, -6 + 2 Sin[
         $CellContext`\[Theta][]]^2}, {-6 + 2 Sin[
         $CellContext`\[Theta][]]^2, 9 + 4 Sin[
         $CellContext`\[Theta][]]^2}}, {-$CellContext`sph2, \
-$CellContext`sph2}, 0][-$CellContext`\[ScriptA], -$CellContext`\[ScriptB]],
  Editable->False]], "Output",ExpressionUUID->"e6a7b91d-6d56-43ef-b935-\
e8821ec68ad0"]
}, Open  ]],

Cell["\[Bullet] A mixture of bases:", "Text",ExpressionUUID->"d1478478-43f1-49f0-8ea5-8d48191d159f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "sph2"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"2e2a6bdf-acff-405d-9595-86fcb40cec24"],

Cell[BoxData[
 RowBox[{"-", "3"}]], "Output",ExpressionUUID->"fc841c74-85f6-4aa1-a76f-ac5226cc56b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCTensor", "[", 
   RowBox[{"met", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "sph"}], ",", 
      RowBox[{"-", "sph2"}]}], "}"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"-", "\[ScriptA]"}], ",", 
   RowBox[{"-", "\[ScriptB]"}]}], "]"}]], "Input",ExpressionUUID->"1bafdd1c-\
d8cc-4d72-97a9-afb9a00d3628"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "2"}]],
           Annotation[#, {1, 1} -> 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"-", "3"}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"-", "3"}]}]],
           Annotation[#, {1, 2} -> -3, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            SuperscriptBox[
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], "2"],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
              SuperscriptBox[
               RowBox[{
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                   False], Sin, Editable -> False], "[", 
                 InterpretationBox[
                  StyleBox[
                  "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                   False], 
                  $CellContext`\[Theta][], Editable -> False], "]"}], "2"]}]],
           
           Annotation[#, {2, 1} -> Sin[
               $CellContext`\[Theta][]]^2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], "2"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"2", " ", 
                SuperscriptBox[
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                   InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                 "2"]}]}]],
           Annotation[#, {2, 2} -> 2 Sin[
                $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[0, 0, 1], 3 -> RGBColor[0, 0, 1]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " "},
         {"\[ScriptA]", "\[ScriptB]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{2, -3}, {Sin[
       $CellContext`\[Theta][]]^2, 2 Sin[
        $CellContext`\[Theta][]]^2}}, {-$CellContext`sph, -$CellContext`sph2},
    0][-$CellContext`\[ScriptA], -$CellContext`\[ScriptB]],
  Editable->False]], "Output",ExpressionUUID->"7bb1052f-3288-4204-89b0-\
deb72f4524bd"]
}, Open  ]],

Cell["\[Bullet] We can extract a sub-CTensor expression:", "Text",ExpressionUUID->"6b887a04-5ec9-45e2-8c4b-817462531d6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{
   RowBox[{"-", "\[ScriptA]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "sph2"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"27f46a65-97c2-43e1-8c21-474d8e0169ba"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["2",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "2"}]],
           Annotation[#, {1} -> 2, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            SuperscriptBox[
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], "2"],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              SuperscriptBox[
               RowBox[{
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                   False], Sin, Editable -> False], "[", 
                 InterpretationBox[
                  StyleBox[
                  "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                   False], 
                  $CellContext`\[Theta][], Editable -> False], "]"}], "2"]}]],
           
           Annotation[#, {2} -> Sin[
               $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" "},
         {"\[ScriptA]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{2, Sin[
      $CellContext`\[Theta][]]^2}, {-$CellContext`sph}, 
   0][-$CellContext`\[ScriptA]],
  Editable->False]], "Output",ExpressionUUID->"703fa52b-361b-458b-809c-\
93e462fb4508"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", 
   RowBox[{"-", "\[ScriptA]"}]}], "]"}]], "Input",ExpressionUUID->"91a1c69b-\
7f8b-4df4-b4eb-97ae1c864ac7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            SuperscriptBox[
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], "2"],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              SuperscriptBox[
               RowBox[{
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                   False], Sin, Editable -> False], "[", 
                 InterpretationBox[
                  StyleBox[
                  "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                   False], 
                  $CellContext`\[Theta][], Editable -> False], "]"}], "2"]}]],
           
           Annotation[#, {2} -> Sin[
               $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" "},
         {"\[ScriptA]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{0, Sin[
      $CellContext`\[Theta][]]^2}, {-$CellContext`sph}, 
   0][-$CellContext`\[ScriptA]],
  Editable->False]], "Output",ExpressionUUID->"a34f8641-42cf-492c-a011-\
f591dd9b3a98"]
}, Open  ]],

Cell["\<\
\[Bullet] Using b-indices will produce an expansion into basis objects:\
\>", "Text",ExpressionUUID->"92d03bdb-878c-49a4-8b0a-b433c611bb96"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[ScriptA]", ",", 
     RowBox[{"-", "sph"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptB]", ",", 
     RowBox[{"-", "sph"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"6ed971af-6d5b-4a07-bd41-05fbd35479c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["\[ScriptA]",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{$CellContext`\[ScriptA], -$CellContext`sph}, {
     1, $CellContext`sph}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["\[ScriptB]",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{$CellContext`\[ScriptB], -$CellContext`sph}, {
     1, $CellContext`sph}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["\[ScriptA]",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{$CellContext`\[ScriptA], -$CellContext`sph}, {
     2, $CellContext`sph}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["\[ScriptB]",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{$CellContext`\[ScriptB], -$CellContext`sph}, {
     2, $CellContext`sph}],
    Editable->False], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], "]"}], "2"]}]}]], "Output",ExpressionUUID->"6d49f7ca-\
0913-4d6f-9db7-c1f6555d5aeb"]
}, Open  ]],

Cell["\<\
\[Bullet] The same result can be obtained directly from the abstract-index \
expression using the following syntax:\
\>", "Text",ExpressionUUID->"6088bd8b-9f79-46d9-9f4d-e1e836dd3cea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "[", 
  RowBox[{
   RowBox[{"-", "\[ScriptA]"}], ",", 
   RowBox[{"-", "\[ScriptB]"}]}], "]"}]], "Input",ExpressionUUID->"1ec7a26d-\
21e9-4930-ba91-47e42c9cf77e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            SuperscriptBox[
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], "2"],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              SuperscriptBox[
               RowBox[{
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                   False], Sin, Editable -> False], "[", 
                 InterpretationBox[
                  StyleBox[
                  "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                   False], 
                  $CellContext`\[Theta][], Editable -> False], "]"}], "2"]}]],
           
           Annotation[#, {2, 2} -> Sin[
               $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " "},
         {"\[ScriptA]", "\[ScriptB]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{1, 0}, {0, Sin[
       $CellContext`\[Theta][]]^2}}, {-$CellContext`sph, -$CellContext`sph}, 
   0][-$CellContext`\[ScriptA], -$CellContext`\[ScriptB]],
  Editable->False]], "Output",ExpressionUUID->"73696d69-fa89-48d8-9042-\
f56c7ce7d7fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToBasisExpand"}]], "Input",ExpressionUUID->"b0419eaf-c192-4a52-bd17-dbd7d702b174"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {"\[ScriptA]", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`\[ScriptA], {1, $CellContext`sph}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {"\[ScriptB]", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`\[ScriptB], {1, $CellContext`sph}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {"\[ScriptA]", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`\[ScriptA], {2, $CellContext`sph}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {"\[ScriptB]", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`\[ScriptB], {2, $CellContext`sph}],
    Editable->False], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], "]"}], "2"]}]}]], "Output",ExpressionUUID->"45159ae7-\
f12b-4c35-a8fc-afc23585379a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromBasisExpand", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "sph"}], ",", 
     RowBox[{"-", "sph"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"f697863b-4547-4160-b986-3dc48a3abdea"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["1",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]],
           Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            SuperscriptBox[
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], "2"],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              SuperscriptBox[
               RowBox[{
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                   False], Sin, Editable -> False], "[", 
                 InterpretationBox[
                  StyleBox[
                  "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                   False], 
                  $CellContext`\[Theta][], Editable -> False], "]"}], "2"]}]],
           
           Annotation[#, {2, 2} -> Sin[
               $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " "},
         {"\[ScriptA]", "\[ScriptB]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{1, 0}, {0, Sin[
       $CellContext`\[Theta][]]^2}}, {-$CellContext`sph, -$CellContext`sph}, 
   0][-$CellContext`\[ScriptA], -$CellContext`\[ScriptB]],
  Editable->False]], "Output",ExpressionUUID->"c7374a5f-f193-426e-90e2-\
df6c67de4629"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7. Cleanup", "Subsubsection",ExpressionUUID->"e796c820-b2e7-4048-94bd-7839eb847cda"],

Cell["Undefine S2:", "Text",ExpressionUUID->"b8aebb3b-74f5-4d35-87b3-414dfd6c09c4"],

Cell[BoxData[
 RowBox[{"UndefBasis", "[", "sph2", "]"}]], "Input",ExpressionUUID->"f9688776-b262-4194-b958-fc229e57edd2"],

Cell[BoxData[
 RowBox[{"UndefChart", "[", "sph", "]"}]], "Input",ExpressionUUID->"c09b74e7-8885-45a4-8254-e2dc9b70379d"],

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "S", "]"}]], "Input",ExpressionUUID->"cbf1f5f1-2be0-4ee4-b170-d7a9896ba713"],

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "S2", "]"}]], "Input",ExpressionUUID->"f9d53db7-aecb-434f-871c-a1dffb3889c8"],

Cell["Undefine M:", "Text",ExpressionUUID->"0333e380-a8d6-4363-9711-57647c2477d3"],

Cell[BoxData[
 RowBox[{"UndefBasis", "[", "B", "]"}]], "Input",ExpressionUUID->"8e0e8fed-e07b-4906-a56c-48d60edb9482"],

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "s", "]"}]], "Input",ExpressionUUID->"28088fc1-93f3-4dcf-8cce-b999748d6246"],

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "M", "]"}]], "Input",ExpressionUUID->"d2501bbf-9e0b-42ac-b089-6e22080b8da2"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "A", ",", "T", ",", "v", ",", "V", ",", "w", ",", "met", ",", "imet"}], 
  "]"}]], "Input",ExpressionUUID->"217251f7-ea44-40eb-bd07-e992a0a7f0d8"],

Cell[BoxData[
 RowBox[{"ClearxCobaCache", "[", "All", "]"}]], "Input",ExpressionUUID->"419eeed8-f504-4d47-afdf-7231766f85e5"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Covariant derivatives", "Subsection",ExpressionUUID->"01eb46be-cc7d-41d9-a962-2fdbfa12545b"],

Cell[CellGroupData[{

Cell["3.1. CCovD expressions", "Subsubsection",ExpressionUUID->"af240dda-201d-49bc-a7de-259bac6fe361"],

Cell["\<\
The key idea is to represent a covariant derivative as another connection \
plus a Christoffel CTensor expressing the relation between those two. \
Optionally, we can also specify a metric CTensor, in case the connection is \
associated to it.\
\>", "Text",ExpressionUUID->"3791cb2b-a55e-4151-8a3b-c9cd4b2837e9"],

Cell["\[Bullet] Define polar coordinates on the 2-plane:", "Text",ExpressionUUID->"6ccc7ba7-5bc5-4e81-9116-3159adf6bc08"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"E2", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"a12e1e89-3791-4a9e-91f6-8101471c0521"],

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"polar", ",", "E2", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "[", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "]"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID\
->"bd98b2af-94d4-4fd4-b9d7-d9ff70807e8c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"r", "[", "]"}], "^", "2"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "polar"}], ",", 
      RowBox[{"-", "polar"}]}], "}"}]}], "]"}]}]], "Input",ExpressionUUID->\
"8e4644aa-30e8-4cb1-82dc-f256997c56d7"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "polar"}], ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionU\
UID->"408edab3-7b79-467e-9468-9861eda66697"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SetCMetric", "[", 
  RowBox[{"met", ",", "polar", ",", 
   RowBox[{"SignatureOfMetric", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "0"}], "}"}]}]}], "]"}]], "Input",ExpressionU\
UID->"0ec11f19-2d03-4482-b2e6-047b07c4258e"],

Cell["\<\
\[Bullet] This is the Levi-Civita connection of the metric. We see it has \
three arguments: the derivative of the coordinate basis, a Christoffel tensor \
and the metric itself.\
\>", "Text",ExpressionUUID->"a16a3aa6-2c85-42d0-99fc-e999c317acf0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cd", "=", 
  RowBox[{"CovDOfMetric", "[", "met", "]"}]}]], "Input",ExpressionUUID->\
"4ff8b86d-ea47-41f8-bd8b-c5b8a063af55"],

Cell[BoxData[
 RowBox[{"CCovD", "[", 
  RowBox[{"PDpolar", ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox["1", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["1", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]], ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"polar", ",", 
       RowBox[{"-", "polar"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "2"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "polar"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "0"}], "]"}]}], "]"}]], "Output",\
ExpressionUUID->"d89de0e3-eafd-4dfc-ade1-5a0d88811521"]
}, Open  ]],

Cell["\<\
\[Bullet] This derivative operator can be now used normally to perform \
operations:\
\>", "Text",ExpressionUUID->"569d1a70-1912-4a6c-a81a-3a83f048647e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{
   RowBox[{"r", "[", "]"}], "^", "3"}], "]"}]], "Input",ExpressionUUID->\
"d95bdbaf-4c48-4e06-9556-73a59194d2d3"],

Cell[BoxData[
 RowBox[{"3", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]},
          {"a", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
   Editable->False], " ", 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["r",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`r[],
    Editable->False], "2"]}]], "Output",ExpressionUUID->"5a41f271-0e04-45d9-\
833d-69b02eb29fd0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "polar", "}"}]}], "]"}], "[", "b", "]"}], "]"}]], "Input",Ex\
pressionUUID->"9795aa24-02e0-491d-8f23-020b1dc8a141"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            FractionBox["1", 
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False]],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              FractionBox["1", 
               InterpretationBox[
                StyleBox[
                "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                $CellContext`r[], Editable -> False]]}]],
           Annotation[#, {2, 2} -> $CellContext`r[]^(-1), "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"b", " "},
         {" ", "a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{0, 0}, {
    0, $CellContext`r[]^(-1)}}, {$CellContext`polar, -$CellContext`polar}, 
   0][$CellContext`b, -$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"ddaa6d15-e0a2-4938-aaed-\
8a72b185e0da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"met", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}], "]"}]], "Input",ExpressionUUID->"1286ab42-\
8f18-438d-b3f7-c2f49c0ba70c"],

Cell[BoxData["0"], "Output",ExpressionUUID->"56f206b2-5c24-4746-abd8-de0cfd084d40"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"-", "a"}], "]"}], "@", 
  RowBox[{
   RowBox[{"cd", "[", 
    RowBox[{"-", "b"}], "]"}], "@", 
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"r", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", "polar", "}"}]}], "]"}], "[", "c", "]"}]}]}]], "Input",Expr\
essionUUID->"a3db7985-9892-47ab-9c9a-a092b9bd5000"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"-", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                 RowBox[{"-", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]],
              Annotation[#, {1, 1, 2} -> -$CellContext`r[], "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox[
               RowBox[{"-", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                 RowBox[{"-", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]],
              Annotation[#, {1, 2, 1} -> -$CellContext`r[], "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
         {GridBox[{
            {
             TagBox[
              TooltipBox[
               FractionBox["2", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                 FractionBox["2", 
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False]]}]],
              Annotation[#, {2, 1, 1} -> 2/$CellContext`r[], "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False]}]],
              Annotation[#, {2, 2, 2} -> $CellContext`r[], "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"c", " ", " "},
         {" ", "b", "a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{{0, -$CellContext`r[]}, {-$CellContext`r[], 0}}, {{
     2/$CellContext`r[], 0}, {0, 
      $CellContext`r[]}}}, {$CellContext`polar, -$CellContext`polar, \
-$CellContext`polar}, 0][$CellContext`c, -$CellContext`b, -$CellContext`a],
  Editable->False]], "Output",ExpressionUUID->"f3e887c6-385a-4926-ab81-\
1e17d1b21ffa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCCanonical"}]], "Input",ExpressionUUID->"47d79c10-c7fc-461a-bb1b-99ff92cda64c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               FractionBox["2", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                 FractionBox["2", 
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False]]}]],
              Annotation[#, {1, 1, 2} -> 2/$CellContext`r[], "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox[
               RowBox[{"-", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                 RowBox[{"-", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]],
              Annotation[#, {1, 2, 1} -> -$CellContext`r[], "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
         {GridBox[{
            {
             TagBox[
              TooltipBox[
               RowBox[{"-", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                 RowBox[{"-", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]],
              Annotation[#, {2, 1, 1} -> -$CellContext`r[], "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 1} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False]}]],
              Annotation[#, {2, 2, 2} -> $CellContext`r[], "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " ", "c"},
         {"a", "b", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{{
     0, 2/$CellContext`r[]}, {-$CellContext`r[], 0}}, {{-$CellContext`r[], 
      0}, {0, 
      $CellContext`r[]}}}, {-$CellContext`polar, -$CellContext`polar, \
$CellContext`polar}, 0][-$CellContext`a, -$CellContext`b, $CellContext`c],
  Editable->False]], "Output",ExpressionUUID->"b9f42090-7eb2-45d9-8dea-\
53f54e103084"]
}, Open  ]],

Cell["\<\
\[Bullet] CCovD derivatives are typeset with the \[Gradient] character, and \
have a tooltip:\
\>", "Text",ExpressionUUID->"c5c7ea12-c089-4112-8217-d68514879655"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "E2"}], "]"}]], "Input",ExpressionUUID->\
"c99594c9-e9a4-4dae-94cd-ec641b0e6f9f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"v", "[", "b", "]"}], "]"}]], "Input",ExpressionUUID->"06c1890a-\
f2ef-4f4d-ba26-d3dd0d48016e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox[
     TooltipBox["\[Gradient]",
      RowBox[{"CCovD", "[", "PDpolar", ",", 
        StyleBox[
         GridBox[{{
            GridBox[{{
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]}, {
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
            GridBox[{{
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]}, {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]], 
                Annotation[#, {1, 2, 2} -> -$CellContext`r[], "Tooltip"]& ]}},
              AutoDelete -> False, 
             GridBoxDividers -> {
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}, {
            GridBox[{{
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]}, {
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False]], 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]], 
                Annotation[#, {2, 1, 2} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]}}, AutoDelete -> False, 
             GridBoxDividers -> {
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
            GridBox[{{
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False]], 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]], 
                Annotation[#, {2, 2, 1} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]}, {
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}}, 
          AutoDelete -> False, 
          GridBoxDividers -> {
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], Small], ",", 
        StyleBox[
         GridBox[{{
            TagBox[
             TooltipBox["1", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
             Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
            TagBox[
             TooltipBox["0", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
             Annotation[#, {1, 2} -> 0, "Tooltip"]& ]}, {
            TagBox[
             TooltipBox["0", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
             Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              SuperscriptBox[
               InterpretationBox[
                StyleBox[
                "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                $CellContext`r[], Editable -> False], "2"], 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False], "2"]}]], 
             Annotation[#, {2, 2} -> $CellContext`r[]^2, "Tooltip"]& ]}}, 
          AutoDelete -> False, 
          GridBoxDividers -> {
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], Small], 
        "]"}]], "a"], GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CCovD[$CellContext`PDpolar, 
   xAct`xCoba`CTensor[{{{0, 0}, {0, -$CellContext`r[]}}, {{
      0, $CellContext`r[]^(-1)}, {$CellContext`r[]^(-1), 
       0}}}, {$CellContext`polar, -$CellContext`polar, -$CellContext`polar}, 
    0], 
   xAct`xCoba`CTensor[{{1, 0}, {
     0, $CellContext`r[]^2}}, {-$CellContext`polar, -$CellContext`polar}, 
    0]][-$CellContext`a][
   $CellContext`v[$CellContext`b]],
  Editable->False]], "Output",ExpressionUUID->"3cd7390c-5e64-4cf2-8a0e-\
e2b2b8c608f0"]
}, Open  ]],

Cell["\<\
\[Bullet] Expansion is not automatic, as usual in xTensor, and must be asked \
for explicitly:\
\>", "Text",ExpressionUUID->"567382f4-4d0a-4d0f-9106-3da6f2d1b362"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeCovD", "[", 
  RowBox[{"%", ",", "cd", ",", "PDpolar"}], "]"}]], "Input",ExpressionUUID->\
"6759677b-628f-41b7-97fb-e8baceacb41b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        StyleBox[GridBox[{
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]],
                Annotation[#, {1, 2, 2} -> -$CellContext`r[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]],
                
                Annotation[#, {2, 1, 2} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]],
                
                Annotation[#, {2, 2, 1} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
         FontSize->Small], 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCoba`CTensor[{{{0, 0}, {0, -$CellContext`r[]}}, {{
       0, $CellContext`r[]^(-1)}, {$CellContext`r[]^(-1), 
        0}}}, {$CellContext`polar, -$CellContext`polar, -$CellContext`polar}, 
     0][$CellContext`b, -$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox[
      StyleBox["\[ScriptCapitalD]",
       FontColor->RGBColor[1., 0., 0.]], "a"], GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`PDpolar[-$CellContext`a][
    $CellContext`v[$CellContext`b]],
   Editable->False]}]], "Output",ExpressionUUID->"07aea66f-a701-4db1-8e26-\
e52ebaad5e89"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeCovD", "[", 
  RowBox[{"%", ",", "PDpolar", ",", "cd"}], "]"}]], "Input",ExpressionUUID->\
"8df43f75-5a10-4b2d-806c-f457bf7df670"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        StyleBox[GridBox[{
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]],
                Annotation[#, {1, 2, 2} -> -$CellContext`r[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]],
                
                Annotation[#, {2, 1, 2} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]],
                
                Annotation[#, {2, 2, 1} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
         FontSize->Small], 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCoba`CTensor[{{{0, 0}, {0, -$CellContext`r[]}}, {{
       0, $CellContext`r[]^(-1)}, {$CellContext`r[]^(-1), 
        0}}}, {$CellContext`polar, -$CellContext`polar, -$CellContext`polar}, 
     0][$CellContext`b, -$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        StyleBox[GridBox[{
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]],
                Annotation[#, {1, 2, 2} -> $CellContext`r[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  FractionBox["1", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]}]],
                
                Annotation[#, {2, 1, 2} -> (-1)/$CellContext`r[], 
                 "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  FractionBox["1", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]}]],
                
                Annotation[#, {2, 2, 1} -> (-1)/$CellContext`r[], 
                 "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
         FontSize->Small], 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCoba`CTensor[{{{0, 0}, {0, 
        $CellContext`r[]}}, {{
       0, (-1)/$CellContext`r[]}, {(-1)/$CellContext`r[], 
        0}}}, {$CellContext`polar, -$CellContext`polar, -$CellContext`polar}, 
     0][$CellContext`b, -$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox[
      TooltipBox["\[Gradient]",
       RowBox[{"CCovD", "[", "PDpolar", ",", 
         StyleBox[
          GridBox[{{
             GridBox[{{
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]}, {
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}}, 
              AutoDelete -> False, 
              GridBoxDividers -> {
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
             GridBox[{{
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]}, {
                TagBox[
                 TooltipBox[
                  RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                    RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]], 
                 Annotation[#, {1, 2, 2} -> -$CellContext`r[], 
                  "Tooltip"]& ]}}, AutoDelete -> False, 
              GridBoxDividers -> {
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}, {
             GridBox[{{
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]}, {
                TagBox[
                 TooltipBox[
                  FractionBox["1", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]], 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]], 
                 Annotation[#, {2, 1, 2} -> $CellContext`r[]^(-1), 
                  "Tooltip"]& ]}}, AutoDelete -> False, 
              GridBoxDividers -> {
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
             GridBox[{{
                TagBox[
                 TooltipBox[
                  FractionBox["1", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]], 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]], 
                 Annotation[#, {2, 2, 1} -> $CellContext`r[]^(-1), 
                  "Tooltip"]& ]}, {
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}}, 
              AutoDelete -> False, 
              GridBoxDividers -> {
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}}, 
           AutoDelete -> False, 
           GridBoxDividers -> {
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], Small], ",", 
         
         StyleBox[
          GridBox[{{
             TagBox[
              TooltipBox["1", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
              Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
              Annotation[#, {1, 2} -> 0, "Tooltip"]& ]}, {
             TagBox[
              TooltipBox["0", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
              Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`r[], Editable -> False], "2"], 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False], "2"]}]], 
              Annotation[#, {2, 2} -> $CellContext`r[]^2, "Tooltip"]& ]}}, 
           AutoDelete -> False, 
           GridBoxDividers -> {
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], Small], 
         "]"}]], "a"], GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xCoba`CCovD[$CellContext`PDpolar, 
    xAct`xCoba`CTensor[{{{0, 0}, {0, -$CellContext`r[]}}, {{
       0, $CellContext`r[]^(-1)}, {$CellContext`r[]^(-1), 
        0}}}, {$CellContext`polar, -$CellContext`polar, -$CellContext`polar}, 
     0], 
    xAct`xCoba`CTensor[{{1, 0}, {
      0, $CellContext`r[]^2}}, {-$CellContext`polar, -$CellContext`polar}, 
     0]][-$CellContext`a][
    $CellContext`v[$CellContext`b]],
   Editable->False]}]], "Output",ExpressionUUID->"16e1ead9-f02d-4ba3-b120-\
423d4883c6f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",ExpressionUUID->"b5959255-2fbe-49c3-8a5c-0e210617ece3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        StyleBox[GridBox[{
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]],
                Annotation[#, {1, 2, 2} -> -$CellContext`r[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]],
                
                Annotation[#, {2, 1, 2} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]],
                
                Annotation[#, {2, 2, 1} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
         FontSize->Small], 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCoba`CTensor[{{{0, 0}, {0, -$CellContext`r[]}}, {{
       0, $CellContext`r[]^(-1)}, {$CellContext`r[]^(-1), 
        0}}}, {$CellContext`polar, -$CellContext`polar, -$CellContext`polar}, 
     0][$CellContext`b, -$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        StyleBox[GridBox[{
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]],
                Annotation[#, {1, 2, 2} -> $CellContext`r[], "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
           {GridBox[{
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  FractionBox["1", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]}]],
                
                Annotation[#, {2, 1, 2} -> (-1)/$CellContext`r[], 
                 "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], GridBox[{
              {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                  FractionBox["1", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]]}],
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]}]],
                
                Annotation[#, {2, 2, 1} -> (-1)/$CellContext`r[], 
                 "Tooltip"]& ]},
              {
               TagBox[
                TooltipBox["0",
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]],
                Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}
             },
             AutoDelete->False,
             
             GridBoxDividers->{
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
          },
          AutoDelete->False,
          
          GridBoxDividers->{
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
         FontSize->Small], 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCoba`CTensor[{{{0, 0}, {0, 
        $CellContext`r[]}}, {{
       0, (-1)/$CellContext`r[]}, {(-1)/$CellContext`r[], 
        0}}}, {$CellContext`polar, -$CellContext`polar, -$CellContext`polar}, 
     0][$CellContext`b, -$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox[
      TooltipBox["\[Gradient]",
       RowBox[{"CCovD", "[", "PDpolar", ",", 
         StyleBox[
          GridBox[{{
             GridBox[{{
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]}, {
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}}, 
              AutoDelete -> False, 
              GridBoxDividers -> {
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
             GridBox[{{
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]}, {
                TagBox[
                 TooltipBox[
                  RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                    RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]], 
                 Annotation[#, {1, 2, 2} -> -$CellContext`r[], 
                  "Tooltip"]& ]}}, AutoDelete -> False, 
              GridBoxDividers -> {
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}, {
             GridBox[{{
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]}, {
                TagBox[
                 TooltipBox[
                  FractionBox["1", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]], 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]], 
                 Annotation[#, {2, 1, 2} -> $CellContext`r[]^(-1), 
                  "Tooltip"]& ]}}, AutoDelete -> False, 
              GridBoxDividers -> {
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
             GridBox[{{
                TagBox[
                 TooltipBox[
                  FractionBox["1", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]], 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]], 
                 Annotation[#, {2, 2, 1} -> $CellContext`r[]^(-1), 
                  "Tooltip"]& ]}, {
                TagBox[
                 TooltipBox["0", 
                  RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                    "0"}]], Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}}, 
              AutoDelete -> False, 
              GridBoxDividers -> {
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}}, 
           AutoDelete -> False, 
           GridBoxDividers -> {
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], Small], ",", 
         
         StyleBox[
          GridBox[{{
             TagBox[
              TooltipBox["1", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
              Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
              Annotation[#, {1, 2} -> 0, "Tooltip"]& ]}, {
             TagBox[
              TooltipBox["0", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
              Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r", AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`r[], Editable -> False], "2"], 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False], "2"]}]], 
              Annotation[#, {2, 2} -> $CellContext`r[]^2, "Tooltip"]& ]}}, 
           AutoDelete -> False, 
           GridBoxDividers -> {
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], Small], 
         "]"}]], "a"], GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xCoba`CCovD[$CellContext`PDpolar, 
    xAct`xCoba`CTensor[{{{0, 0}, {0, -$CellContext`r[]}}, {{
       0, $CellContext`r[]^(-1)}, {$CellContext`r[]^(-1), 
        0}}}, {$CellContext`polar, -$CellContext`polar, -$CellContext`polar}, 
     0], 
    xAct`xCoba`CTensor[{{1, 0}, {
      0, $CellContext`r[]^2}}, {-$CellContext`polar, -$CellContext`polar}, 
     0]][-$CellContext`a][
    $CellContext`v[$CellContext`b]],
   Editable->False]}]], "Output",ExpressionUUID->"50ad733e-83f6-40d1-bde2-\
e87e0f3dbf75"]
}, Open  ]],

Cell["\<\
[This is an interesting problem. The two CTensor expresions should cancel, \
but they don\[CloseCurlyQuote]t (TODO). We need to force them together:]\
\>", "Text",ExpressionUUID->"6e52b122-ca97-48ef-b619-378710544d2f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", "_v", ",", "Simplify"}], "]"}]], "Input",ExpressionUUID->\
"a4d3681b-1919-4b4b-a003-5b734e7b8feb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox[
     TooltipBox["\[Gradient]",
      RowBox[{"CCovD", "[", "PDpolar", ",", 
        StyleBox[
         GridBox[{{
            GridBox[{{
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]}, {
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
            GridBox[{{
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]}, {
               TagBox[
                TooltipBox[
                 RowBox[{"-", 
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]], 
                Annotation[#, {1, 2, 2} -> -$CellContext`r[], "Tooltip"]& ]}},
              AutoDelete -> False, 
             GridBoxDividers -> {
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}, {
            GridBox[{{
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]}, {
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False]], 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]], 
                Annotation[#, {2, 1, 2} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]}}, AutoDelete -> False, 
             GridBoxDividers -> {
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
            GridBox[{{
               TagBox[
                TooltipBox[
                 FractionBox["1", 
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False]], 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]], 
                Annotation[#, {2, 2, 1} -> $CellContext`r[]^(-1), 
                 "Tooltip"]& ]}, {
               TagBox[
                TooltipBox["0", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                   "0"}]], Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {
              "ColumnsIndexed" -> {
                1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}}, 
          AutoDelete -> False, 
          GridBoxDividers -> {
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], Small], ",", 
        StyleBox[
         GridBox[{{
            TagBox[
             TooltipBox["1", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
             Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
            TagBox[
             TooltipBox["0", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
             Annotation[#, {1, 2} -> 0, "Tooltip"]& ]}, {
            TagBox[
             TooltipBox["0", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
             Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
            TagBox[
             TooltipBox[
              SuperscriptBox[
               InterpretationBox[
                StyleBox[
                "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                $CellContext`r[], Editable -> False], "2"], 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False], "2"]}]], 
             Annotation[#, {2, 2} -> $CellContext`r[]^2, "Tooltip"]& ]}}, 
          AutoDelete -> False, 
          GridBoxDividers -> {
           "ColumnsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
            "RowsIndexed" -> {
             1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], Small], 
        "]"}]], "a"], GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CCovD[$CellContext`PDpolar, 
   xAct`xCoba`CTensor[{{{0, 0}, {0, -$CellContext`r[]}}, {{
      0, $CellContext`r[]^(-1)}, {$CellContext`r[]^(-1), 
       0}}}, {$CellContext`polar, -$CellContext`polar, -$CellContext`polar}, 
    0], 
   xAct`xCoba`CTensor[{{1, 0}, {
     0, $CellContext`r[]^2}}, {-$CellContext`polar, -$CellContext`polar}, 
    0]][-$CellContext`a][
   $CellContext`v[$CellContext`b]],
  Editable->False]], "Output",ExpressionUUID->"e8356fd9-5170-4788-b95b-\
dd1ae5c0f558"]
}, Open  ]],

Cell["We can mix abstract and CTensor Christoffels:", "Text",ExpressionUUID->"81884a8e-f186-4cbe-9f62-085bec08b2e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeCovD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"cd", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"v", "[", "b", "]"}], "]"}], ",", "cd"}], "]"}]], "Input",Expressi\
onUUID->"1619782b-c208-47f9-928a-a2f9c6921fd2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`c],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"\[CapitalGamma]", "[", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], "]"}], 
          StyleBox[GridBox[{
             {"b", " ", " "},
             {" ", "a", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ChristoffelPDpolar[$CellContext`b, -$CellContext`a, \
-$CellContext`c],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          StyleBox[GridBox[{
             {GridBox[{
                {
                 TagBox[
                  TooltipBox["0",
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                    "0"}]],
                  Annotation[#, {1, 1, 1} -> 0, "Tooltip"]& ]},
                {
                 TagBox[
                  TooltipBox["0",
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                    "0"}]],
                  Annotation[#, {1, 1, 2} -> 0, "Tooltip"]& ]}
               },
               AutoDelete->False,
               
               GridBoxDividers->{
                "ColumnsIndexed" -> {
                  1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
              GridBox[{
                {
                 TagBox[
                  TooltipBox["0",
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                    "0"}]],
                  Annotation[#, {1, 2, 1} -> 0, "Tooltip"]& ]},
                {
                 TagBox[
                  TooltipBox[
                   RowBox[{"-", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}],
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                    RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]],
                  
                  Annotation[#, {1, 2, 2} -> -$CellContext`r[], 
                   "Tooltip"]& ]}
               },
               AutoDelete->False,
               
               GridBoxDividers->{
                "ColumnsIndexed" -> {
                  1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]},
             {GridBox[{
                {
                 TagBox[
                  TooltipBox["0",
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", 
                    "0"}]],
                  Annotation[#, {2, 1, 1} -> 0, "Tooltip"]& ]},
                {
                 TagBox[
                  TooltipBox[
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]],
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]],
                  
                  Annotation[#, {2, 1, 2} -> $CellContext`r[]^(-1), 
                   "Tooltip"]& ]}
               },
               AutoDelete->False,
               
               GridBoxDividers->{
                "ColumnsIndexed" -> {
                  1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}], 
              GridBox[{
                {
                 TagBox[
                  TooltipBox[
                   FractionBox["1", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]],
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]]}]],
                  
                  Annotation[#, {2, 2, 1} -> $CellContext`r[]^(-1), 
                   "Tooltip"]& ]},
                {
                 TagBox[
                  TooltipBox["0",
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", 
                    "0"}]],
                  Annotation[#, {2, 2, 2} -> 0, "Tooltip"]& ]}
               },
               AutoDelete->False,
               
               GridBoxDividers->{
                "ColumnsIndexed" -> {
                  1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}]}
            },
            AutoDelete->False,
            
            GridBoxDividers->{
             "ColumnsIndexed" -> {
               1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
              "RowsIndexed" -> {
               1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
           FontSize->Small], 
          StyleBox[GridBox[{
             {"b", " ", " "},
             {" ", "a", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xCoba`CTensor[{{{0, 0}, {0, -$CellContext`r[]}}, {{
         0, $CellContext`r[]^(-1)}, {$CellContext`r[]^(-1), 
          0}}}, {$CellContext`polar, -$CellContext`polar, \
-$CellContext`polar}, 0][$CellContext`b, -$CellContext`a, -$CellContext`c],
      Editable->False]}], ")"}]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "a"], GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`a][
    $CellContext`v[$CellContext`b]],
   Editable->False]}]], "Output",ExpressionUUID->"5528fdce-e323-4283-a469-\
d0dc2f25ae6f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. Torsion and curvature", "Subsubsection",ExpressionUUID->"aa8d0c0f-540a-43bc-9c7b-c5df10eb698d"],

Cell["\<\
\[Bullet] Compute the torsion of the covariant derivative. It is a \
torsion-free derivative:\
\>", "Text",ExpressionUUID->"ddafaf57-fe4f-4663-a991-4a43e6e46f50"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Torsion", "[", "cd", "]"}]], "Input",ExpressionUUID->"9be20c86-9d32-467c-b8bb-b5c72423dbc3"],

Cell[BoxData["Zero"], "Output",ExpressionUUID->"a91a7795-dce9-4b49-a814-226a79f2efb6"]
}, Open  ]],

Cell["\<\
\[Bullet] Compute the curvature of the covariant derivative. It is flat\
\>", "Text",ExpressionUUID->"bdfea921-bd71-4304-9947-386f12dd6b0c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riemann", "[", "cd", "]"}]], "Input",ExpressionUUID->"4529a539-107f-4048-b717-93017e1bda95"],

Cell[BoxData["Zero"], "Output",ExpressionUUID->"6236be11-4822-4f50-b865-ec261ef4c8db"]
}, Open  ]],

Cell["\[Bullet] Suppose we introduce a new metric:", "Text",ExpressionUUID->"7126ceb5-6172-4f70-b74d-6160e4f78214"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MET", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"r", "[", "]"}], "^", "4"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "polar"}], ",", 
      RowBox[{"-", "polar"}]}], "}"}]}], "]"}]}]], "Input",ExpressionUUID->\
"af088a77-a867-4c7f-b5a4-2213600419a3"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "4"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "polar"}], ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionU\
UID->"1b23164a-7553-42d4-b7ad-7dfd1bcd58f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CD", "=", 
  RowBox[{"CovDOfMetric", "[", "MET", "]"}]}]], "Input",ExpressionUUID->\
"e7a7744d-be69-4eff-ae1f-baa3dca0706b"],

Cell[BoxData[
 RowBox[{"CCovD", "[", 
  RowBox[{"PDpolar", ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], "3"]}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox["2", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["2", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]], ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"polar", ",", 
       RowBox[{"-", "polar"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "4"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "polar"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "0"}], "]"}]}], "]"}]], "Output",\
ExpressionUUID->"24e311bb-6451-4d80-8c9a-261791e355de"]
}, Open  ]],

Cell["\[Bullet] It is still torsionless:", "Text",ExpressionUUID->"8935c0be-8ba2-42dc-a95d-d40ab38aa357"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Torsion", "[", "CD", "]"}], "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}]}], "]"}]], "Input",ExpressionUUID->"7912cd9b-38ad-4cdc-\
a487-9a7ccfedde5d"],

Cell[BoxData["0"], "Output",ExpressionUUID->"db5e15d4-7fbb-4e87-8590-9261eadcf9c0"]
}, Open  ]],

Cell["\[Bullet] But now it has curvature:", "Text",ExpressionUUID->"a9832359-2401-4bc4-9b53-3d7871439f93"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Riemann", "[", "CD", "]"}], "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", "d"}], "]"}]], "Input",ExpressionUUID->"1ce37c57-\
7b58-45de-b280-775f3ebe8beb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 1, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 1, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "2", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 2, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "1", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 1, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               RowBox[{"-", 
                FractionBox["2", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "}"}], 
                 "\[Rule]", 
                 RowBox[{"-", 
                   FractionBox["2", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]]}]}]],
              
              Annotation[#, {1, 2, 1, 2} -> (-2) $CellContext`r[]^(-2), 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}], 
                 "\[Rule]", 
                 RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}]],
              
              Annotation[#, {1, 2, 2, 1} -> 2 $CellContext`r[]^2, 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "2", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}]},
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 1, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               FractionBox["2", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "1", ",", "2"}], "}"}], 
                 "\[Rule]", 
                 FractionBox["2", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]]}]],
              
              Annotation[#, {2, 1, 1, 2} -> 2 $CellContext`r[]^(-2), 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "2", ",", "1"}], "}"}], 
                 "\[Rule]", 
                 RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}]],
              
              Annotation[#, {2, 1, 2, 1} -> (-2) $CellContext`r[]^2, 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "2", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 1, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "1", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 1, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 2, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " ", " ", "d"},
         {"a", "b", "c", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{{{0, 0}, {0, 
     0}}, {{0, (-2) $CellContext`r[]^(-2)}, {2 $CellContext`r[]^2, 0}}}, {{{
      0, 2 $CellContext`r[]^(-2)}, {(-2) $CellContext`r[]^2, 0}}, {{0, 0}, {0,
      0}}}}, {-$CellContext`polar, -$CellContext`polar, -$CellContext`polar, \
$CellContext`polar}, 
   0][-$CellContext`a, -$CellContext`b, -$CellContext`c, $CellContext`d],
  Editable->False]], "Output",ExpressionUUID->"e58821db-3052-45f9-a4ab-\
09d80d083fc3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannDown", "[", "CD", "]"}], "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",ExpressionUUID->"9d3b3a0e-b344-4c51-\
81f8-1f5c815c028a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 1, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 1, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "2", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 2, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 1, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "1", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 1, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "}"}], 
                 "\[Rule]", 
                 RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}]],
              
              Annotation[#, {1, 2, 1, 2} -> (-2) $CellContext`r[]^2, 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}], 
                 "\[Rule]", 
                 RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}]],
              
              Annotation[#, {1, 2, 2, 1} -> 2 $CellContext`r[]^2, 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"1", ",", "2", ",", "2", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {1, 2, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}]},
         {GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 1, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "1", ",", "2"}], "}"}], 
                 "\[Rule]", 
                 RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}]],
              
              Annotation[#, {2, 1, 1, 2} -> 2 $CellContext`r[]^2, 
               "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox[
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}],
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "2", ",", "1"}], "}"}], 
                 "\[Rule]", 
                 RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}]],
              
              Annotation[#, {2, 1, 2, 1} -> (-2) $CellContext`r[]^2, 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "1", ",", "2", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 1, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}], GridBox[{
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 1, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "1", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 1, 2} -> 0, "Tooltip"]& ]},
            {
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 2, 1} -> 0, "Tooltip"]& ], 
             TagBox[
              TooltipBox["0",
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}], 
                 "\[Rule]", "0"}]],
              Annotation[#, {2, 2, 2, 2} -> 0, "Tooltip"]& ]}
           },
           AutoDelete->False,
           GridBoxDividers->{
            "ColumnsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}, 
             "RowsIndexed" -> {
              1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{{{0, 0}, {0, 
     0}}, {{0, (-2) $CellContext`r[]^2}, {2 $CellContext`r[]^2, 0}}}, {{{
      0, 2 $CellContext`r[]^2}, {(-2) $CellContext`r[]^2, 0}}, {{0, 0}, {0, 
     0}}}}, {-$CellContext`polar, -$CellContext`polar, -$CellContext`polar, \
-$CellContext`polar}, 
   0][-$CellContext`a, -$CellContext`b, -$CellContext`c, -$CellContext`d],
  Editable->False]], "Output",ExpressionUUID->"bb5f49ab-c977-4d4e-82fa-\
2d34723b0d01"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "[", "CD", "]"}], "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",ExpressionUUID->"d1307a8c-748f-4228-\
96cc-b485a71f5fa3"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox[
            RowBox[{"-", 
             FractionBox["2", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "2"]]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
              RowBox[{"-", 
                FractionBox["2", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                   "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                   $CellContext`r[], Editable -> False], "2"]]}]}]],
           Annotation[#, {1, 1} -> (-2) $CellContext`r[]^(-2), "Tooltip"]& ], 
          
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False], "2"]}]}]],
           Annotation[#, {2, 2} -> (-2) $CellContext`r[]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 3 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{(-2) $CellContext`r[]^(-2), 0}, {
    0, (-2) $CellContext`r[]^2}}, {-$CellContext`polar, -$CellContext`polar}, 
   0][-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"8a14833f-57b9-4d33-9771-\
98ebe4fdd202"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RicciScalar", "[", "CD", "]"}], "[", "]"}]], "Input",ExpressionUUID\
->"785ec728-1c6c-43f1-afda-324b7563f668"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["4", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["r",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`r[],
     Editable->False], "2"]]}]], "Output",ExpressionUUID->"bf332a4a-54d7-4d62-\
a87c-2fc69d3e2a19"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. Cleanup", "Subsubsection",ExpressionUUID->"c03062c3-48b5-4998-bc4b-553a0b216818"],

Cell[BoxData[
 RowBox[{"UndefChart", "[", "polar", "]"}]], "Input",ExpressionUUID->"297494aa-12f4-49f0-8236-cb946f56526a"],

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "v", "]"}]], "Input",ExpressionUUID->"2d49f9f0-0f27-4eec-ab17-191bc9df7e8c"],

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "E2", "]"}]], "Input",ExpressionUUID->"2f5b8841-ee89-4441-8e0a-8c9bdf492ada"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"cd", ",", "CD", ",", "met", ",", "MET"}], "]"}]], "Input",Expressio\
nUUID->"14a3cb33-0630-4108-bc57-e0dc00117aa6"],

Cell[BoxData[
 RowBox[{"ClearxCobaCache", "[", "All", "]"}]], "Input",ExpressionUUID->"ba8fe05c-96ff-4939-824d-4a3ab71a0f77"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. Curvature computations", "Subsection",ExpressionUUID->"16db1a3d-bccd-4e44-a636-50b4ad1a9092"],

Cell["\<\
This is probably the most important computation in GR, and we need to do it \
in a simple and fast enough way. Each example in this section is prepared to \
be evaluated independently of the rest of the notebook, and hence there are \
respective Needs commands.\
\>", "Text",ExpressionUUID->"c4a50e8c-37f4-4776-8a85-e256bfbd7d05"],

Cell["\<\
To have info messages from the caching system, activate this cell:\
\>", "Text",ExpressionUUID->"9c6f6974-15cb-4fdc-9d35-960393d226ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$xCobaCacheVerbose", "=", "True"}], ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"1cb09ff9-44cb-438e-bdea-5f2c44422e7d"],

Cell["To see messages from MetricCompute activate this cell:", "Text",ExpressionUUID->"d24a2a4b-47cb-412b-8fba-6d4d9fdee56a"],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"MetricCompute", ",", 
   RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"0ba63123-5448-4705-be77-09f63ba5e2d3"],

Cell[CellGroupData[{

Cell["4.1. Kerr-Newman in the rotating frame", "Subsubsection",ExpressionUUID->"946e877a-5088-4a19-aa0e-98ae3b6d7114"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xCoba`\>\"", "]"}]], "Input",ExpressionUUID->"b3884d04-5227-427e-9f87-eb665d9c3dc1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", 
   RowBox[{"$UndefInfoQ", "=", "False"}]}], ";"}]], "Input",ExpressionUUID->\
"603df35f-0fbe-432b-9995-9ca822008a4c"],

Cell["Define a 4d manifold:", "Text",ExpressionUUID->"eb453612-ee59-431e-9a9f-7b163fcd22ea"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"7e1599a4-2877-44d8-aa63-9469d435191b"],

Cell["Boyer-Lindquist coordinates:", "Text",ExpressionUUID->"a7c63827-d8b5-4e0b-917f-d03a6ab6cce2"],

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"BL", ",", "M", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "[", "]"}], ",", 
     RowBox[{"r", "[", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"40f0916e-9b30-4309-93ae-e66b30634c5f"],

Cell[BoxData[{
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"Mass", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<M\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"Rotation", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<a\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"Charge", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<Q\>\""}]}], "]"}]}], "Input",ExpressionU\
UID->"4ffee666-98a7-4225-9c39-476cc7111dfd"],

Cell["Change of basis:", "Text",ExpressionUUID->"6562e22e-b78e-413f-af95-40649f50d312"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Rho]2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "]"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"Rotation", "^", "2"}], 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"\[Theta]", "[", "]"}], "]"}], "^", "2"}]}]}]}], 
  ";"}]], "Input",ExpressionUUID->"58831832-c124-4cbe-b7e5-addfdef30319"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"change", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"r", "[", "]"}], "^", "2"}], "+", 
        RowBox[{"Rotation", "^", "2"}]}], "\[Rho]2"], ",", "0", ",", "0", ",", 
      FractionBox["Rotation", "\[Rho]2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Rotation", " ", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], "^", "2"}]}], ",", "0", ",", 
      "0", ",", "1"}], "}"}]}], "}"}]}]], "Input",ExpressionUUID->"f92e736b-\
ff73-489c-99af-a57c0187c384"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "2"], "+", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "2"]}], 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         InterpretationBox[
          StyleBox["a",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Rotation,
          Editable->False], "2"], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"]}], "+", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "2"]}]], ",", "0", ",", "0", ",", 
     FractionBox[
      InterpretationBox[
       StyleBox["a",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Rotation,
       Editable->False], 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         InterpretationBox[
          StyleBox["a",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Rotation,
          Editable->False], "2"], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"]}], "+", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox["a",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Rotation,
       Editable->False], " ", 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          ShowAutoStyles->False,
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["\[Theta]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Theta][],
         Editable->False], "]"}], "2"]}], ",", "0", ",", "0", ",", "1"}], 
    "}"}]}], "}"}]], "Output",ExpressionUUID->"f38e5fc6-5336-4633-81d5-\
e9aaeba7c74b"]
}, Open  ]],

Cell["\<\
Now define a frame in terms of the BL coordinates. Note that we need to \
provide the frame in a very specific way:\
\>", "Text",ExpressionUUID->"e8cc138e-3ae2-4269-9306-229f91818529"],

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"frame", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], ",", 
   RowBox[{"BasisChange", "\[Rule]", 
    RowBox[{"CTensor", "[", 
     RowBox[{"change", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "frame"}], ",", "BL"}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"6acfc4a5-3244-4967-a657-3f6c5fe9c4e8"],

Cell["This explains the change we have provided:", "Text",ExpressionUUID->"41a4e9ab-6e6d-4f61-9484-60de83929c0f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"Basis", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "frame"}], ",", "BL"}], "}"}]}], "]"}]], "Input",ExpressionU\
UID->"c43519c5-4aed-4365-a997-81c29cc96d90"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False], "2"], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "2"]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False], "]"}], "2"]}], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "2"]}]], ",", "0", ",", "0", ",", 
       FractionBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False], "]"}], "2"]}], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "2"]}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"]}], ",", "0", ",", "0", ",", "1"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "frame"}], ",", "BL"}], "}"}], ",", "0"}], "]"}]], "Output",\
ExpressionUUID->"a748dca6-0e36-4d02-beaf-d83cd082136c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCTensor", "[", 
   RowBox[{"Basis", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "BL"}], ",", "frame"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",ExpressionUUID->"6add6ba9-fa15-4cee-8549-\
7c8db4a880bb"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False]}], 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], "+", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["a",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Rotation,
             Editable->False], "2"], " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["\[Theta]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[Theta][],
              Editable->False]}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False], "2"]}]}]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox["a",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Rotation,
          Editable->False]}], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"]}], ",", "0", ",", "0", ",", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["a",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Rotation,
             Editable->False], "2"], "+", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False], "2"]}], ")"}]}], 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False], "2"], "+", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]}]]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "BL"}], ",", "frame"}], "}"}], ",", "0"}], "]"}]], "Output",\
ExpressionUUID->"b18a7b83-d020-40cb-8dc8-e40b47aa818b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vt", ",", "vr", ",", "v\[Theta]", ",", "v\[Phi]"}], "}"}], ",", 
     RowBox[{"{", "BL", "}"}]}], "]"}], ",", 
   RowBox[{"{", "frame", "}"}]}], "]"}]], "Input",ExpressionUUID->"c9f91c2a-\
010e-479d-9959-32a366c675c0"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"vt", "-", 
      RowBox[{
       InterpretationBox[
        StyleBox["a",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Rotation,
        Editable->False], " ", "v\[Phi]", " ", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False], "]"}], "2"]}]}], ",", "vr", ",", "v\[Theta]", ",", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False]}], " ", "vt"}], "+", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", "v\[Phi]"}], "+", 
         RowBox[{"v\[Phi]", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "2"], "+", 
       RowBox[{
        SuperscriptBox[
         InterpretationBox[
          StyleBox["a",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Rotation,
          Editable->False], "2"], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"]}]}]]}], "}"}], ",", 
   RowBox[{"{", "frame", "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID->\
"210cd751-2645-4f34-8ee5-cec0a1302f62"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"vt", ",", "vr", ",", "v\[Theta]", ",", "v\[Phi]"}], "]"}]], "Input",\
ExpressionUUID->"d11e843d-8986-4a01-8bb4-a604607f4c85"],

Cell["The metric tensor is diagonal in this frame:", "Text",ExpressionUUID->"9adb66bd-d77c-4929-882d-152b317c4fd6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"factor", "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"r", "[", "]"}], "^", "2"}], "\[Rho]2"], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"2", "Mass"}], 
       RowBox[{"r", "[", "]"}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"Rotation", "^", "2"}], "+", 
        RowBox[{"Charge", "^", "2"}]}], 
       RowBox[{
        RowBox[{"r", "[", "]"}], "^", "2"}]]}], ")"}]}]}], ";"}]], "Input",Exp\
ressionUUID->"6ebd11d5-4600-4db7-9420-9e1b3fe90d7a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "factor"}], ",", 
       RowBox[{"1", "/", "factor"}], ",", "\[Rho]2", ",", 
       RowBox[{"\[Rho]2", " ", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"\[Theta]", "[", "]"}], "]"}], "^", "2"}]}]}], "}"}], "]"}],
     ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "frame"}], ",", 
      RowBox[{"-", "frame"}]}], "}"}], ",", "0"}], "]"}]}]], "Input",Expressio\
nUUID->"0e469695-83ec-48a1-9d46-4ef6900f4d74"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            FractionBox[
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["Q",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Charge,
                Editable->False], "2"], "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"]}], 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]], "-", 
            FractionBox[
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Mass,
               Editable->False]}], 
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False]]}], ")"}], " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}], 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["a",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Rotation,
             Editable->False], "2"], " ", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox["Cos",
               ShowAutoStyles->False,
               AutoSpacing->False],
              Cos,
              Editable->False], "[", 
             InterpretationBox[
              StyleBox["\[Theta]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[Theta][],
              Editable->False], "]"}], "2"]}], "+", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]]}], ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox[
        RowBox[{
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False], "]"}], "2"]}], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "2"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox[
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["Q",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Charge,
               Editable->False], "2"], "+", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], "2"]}], 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], "2"]], "-", 
           FractionBox[
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["M",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Mass,
              Editable->False]}], 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]]}], ")"}], " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["\[Theta]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Theta][],
            Editable->False], "]"}], "2"]}], "+", 
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["a",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Rotation,
             Editable->False], "2"], " ", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox["Cos",
               ShowAutoStyles->False,
               AutoSpacing->False],
              Cos,
              Editable->False], "[", 
             InterpretationBox[
              StyleBox["\[Theta]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[Theta][],
              Editable->False], "]"}], "2"]}], "+", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "frame"}], ",", 
     RowBox[{"-", "frame"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionU\
UID->"19ac0a56-9ff9-431d-b974-1db28bd565c2"]
}, Open  ]],

Cell["\<\
Now set this metric as the first-metric of the TangentM bundle:\
\>", "Text",ExpressionUUID->"34671351-a0b2-4be7-81ce-041283cc15fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "BL", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], "//", 
  "Timing"}]], "Input",ExpressionUUID->"688170f6-15d7-41d8-b1ea-64ece524b752"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.589386`", ",", "Null"}], "}"}]], "Output",ExpressionUUID->\
"fb777e1e-bf30-4f28-9ee9-6c8df732408f"]
}, Open  ]],

Cell["The coordinated metric tensor is nondiagonal:", "Text",ExpressionUUID->"f063371e-6d9f-4cc5-9e19-675db7102e8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "BL"}], ",", 
     RowBox[{"-", "BL"}]}], "}"}]}], "]"}]], "Input",ExpressionUUID->\
"180a2e3a-7392-425b-8690-d1a354937c36"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["Q",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Charge,
              Editable->False], "2"], "+", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], "2"], "-", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["M",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Mass,
              Editable->False], " ", 
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False]}], "+", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], "2"], "-", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], "2"], " ", 
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], "2"]}]}], ")"}]}], 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], "+", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["a",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Rotation,
             Editable->False], "2"], " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["\[Theta]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[Theta][],
              Editable->False]}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False], "2"]}]}]]}], ",", "0", ",", "0", ",", 
       FractionBox[
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox["a",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Rotation,
          Editable->False], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["Q",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Charge,
             Editable->False], "2"], "-", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["M",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Mass,
             Editable->False], " ", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["\[Theta]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Theta][],
            Editable->False], "]"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False], "2"], "+", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox[
        RowBox[{
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False], "]"}], "2"]}], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "2"]}], 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["Q",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Charge,
           Editable->False], "2"], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False], "2"], "-", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["M",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Mass,
           Editable->False], " ", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]}], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["\[Theta]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Theta][],
            Editable->False], "]"}], "2"]}], "+", 
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox["a",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Rotation,
          Editable->False], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["Q",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Charge,
             Editable->False], "2"], "-", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["M",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Mass,
             Editable->False], " ", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["\[Theta]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Theta][],
            Editable->False], "]"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False], "2"], "+", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]}]], ",", "0", ",", "0", ",", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], "2"], "+", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False], "]"}], "2"]}], 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], "+", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["a",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Rotation,
             Editable->False], "2"], " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["\[Theta]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[Theta][],
              Editable->False]}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False], "2"]}]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["Q",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Charge,
              Editable->False], "2"], "+", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], "2"], "+", 
            RowBox[{
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False]}], "+", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False], "]"}], "4"]}], 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["a",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Rotation,
             Editable->False], "2"], " ", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox["Cos",
               ShowAutoStyles->False,
               AutoSpacing->False],
              Cos,
              Editable->False], "[", 
             InterpretationBox[
              StyleBox["\[Theta]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[Theta][],
              Editable->False], "]"}], "2"]}], "+", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "BL"}], ",", 
     RowBox[{"-", "BL"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionUUID\
->"cfe08472-73eb-4e2b-afac-00df35aed157"]
}, Open  ]],

Cell["Compute curvature tensors:", "Text",ExpressionUUID->"257ab56c-e2f7-4571-aa4a-36c507728777"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MetricCompute", "[", 
   RowBox[{"metric", ",", "BL", ",", "All", ",", 
    RowBox[{"Parallelize", "\[Rule]", "True"}]}], "]"}], "//", 
  "AbsoluteTiming"}]], "Input",ExpressionUUID->"c0d3dd71-7a91-47c5-80dc-\
2d27929e1c27"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.507265`", ",", "Null"}], "}"}]], "Output",ExpressionUUID->\
"07bc8d64-b39e-4fb9-8f89-401806c3767d"]
}, Open  ]],

Cell["\<\
That computed and simplified everything, including the Kretschman scalar and \
the first covariant derivative of the Riemann tensor. All those results are \
now cached. If we do it again it takes nothing:\
\>", "Text",ExpressionUUID->"1dddc67b-4cb7-4a5d-9e5e-a50a2e599b95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MetricCompute", "[", 
   RowBox[{"metric", ",", "BL", ",", "All"}], "]"}], "//", 
  "AbsoluteTiming"}]], "Input",ExpressionUUID->"ad3f8c5f-d29d-43d7-8a1d-\
f6ca14671c0f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.032615`", ",", "Null"}], "}"}]], "Output",ExpressionUUID->\
"7d7c03c9-1b17-4beb-a833-4b58e79500ce"]
}, Open  ]],

Cell["Extract information:", "Text",ExpressionUUID->"7b64b8c8-bf67-4e62-8c71-1f77a52ce73f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "=", 
   RowBox[{"CovDOfMetric", "[", "metric", "]"}]}], ";"}]], "Input",ExpressionU\
UID->"94babfc7-3724-4b7e-a6ba-a18f08ec607f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RicciScalar", "[", "cd", "]"}], "[", "]"}]], "Input",ExpressionUUID\
->"c37ee9f8-6fce-4c66-badc-4592ae6e16de"],

Cell[BoxData["0"], "Output",ExpressionUUID->"75f9fdf0-e429-4f59-a718-e0aebab19944"]
}, Open  ]],

Cell["The Ricci tensor is again diagonal in this frame:", "Text",ExpressionUUID->"f6cc2349-a999-48a2-8aa4-08d1e2ac4a06"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ricci", "[", "cd", "]"}]], "Input",ExpressionUUID->"1298d990-ce3c-46da-a3a9-d5481861cef3"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["Q",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Charge,
           Editable->False], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["Q",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Charge,
             Editable->False], "2"], "+", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["a",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Rotation,
             Editable->False], "2"], "+", 
           RowBox[{
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Mass,
                Editable->False]}], "+", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}], ")"}]}]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["a",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`Rotation,
             Editable->False], "2"], "+", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], "2"], " ", 
            RowBox[{
             InterpretationBox[
              StyleBox["Cos",
               ShowAutoStyles->False,
               AutoSpacing->False],
              Cos,
              Editable->False], "[", 
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], "2"]}]}], ")"}], "3"]], ",", "0", ",", "0", 
       ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["Q",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Charge,
            Editable->False], "2"]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], "2"], "+", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], "2"], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Cos",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cos,
               Editable->False], "[", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False]}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["Q",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Charge,
              Editable->False], "2"], "+", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], "2"], "+", 
            RowBox[{
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False]}], "+", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], ")"}]}]}], ")"}]}]]}], ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["Q",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Charge,
           Editable->False], "2"]}], 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False], "2"], "+", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]}]], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["Q",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Charge,
           Editable->False], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["\[Theta]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Theta][],
            Editable->False], "]"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["a",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Rotation,
           Editable->False], "2"], "+", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Rotation,
            Editable->False], "2"], " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["\[Theta]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[Theta][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]}]]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "frame"}], ",", 
     RowBox[{"-", "frame"}]}], "}"}], ",", "0"}], "]"}]], "Output",ExpressionU\
UID->"e2f61a64-88b5-4fb8-81ee-116798c674b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",ExpressionUUID->"8979b816-37cc-48ea-\
839d-e39c15826125"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
              FractionBox[
               RowBox[{"8", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Q"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Charge, Editable -> False], "2"], 
                 " ", 
                 RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Q"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Charge, Editable -> False], "2"], 
                    "+", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                    "+", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Mass, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}], 
                   ")"}]}], 
               SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                    "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                    " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], ")"}], 
                "3"]]}]],
           
           Annotation[#, {1, 1} -> 
            8 $CellContext`Charge^2 ($CellContext`Rotation^2 + \
$CellContext`Rotation^2 Cos[2 $CellContext`\[Theta][]] + 
               2 $CellContext`r[]^2)^(-3) ($CellContext`Charge^2 + \
$CellContext`Rotation^2 + $CellContext`r[] ((-2) $CellContext`Mass + \
$CellContext`r[])), "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"-", 
                FractionBox[
                 RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Q"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Charge, Editable -> False], "2"]}], 
                 RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                    "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                    " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], ")"}], 
                   " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Q"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Charge, Editable -> False], "2"], 
                    "+", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                    "+", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"M"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Mass, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}], 
                    ")"}]}]]}]}]],
           
           Annotation[#, {2, 
             2} -> (-2) $CellContext`Charge^2 ($CellContext`Rotation^2 + \
$CellContext`Rotation^2 Cos[2 $CellContext`\[Theta][]] + 
               2 $CellContext`r[]^2)^(-1)/($CellContext`Charge^2 + \
$CellContext`Rotation^2 + $CellContext`r[] ((-2) $CellContext`Mass + \
$CellContext`r[])), "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            FractionBox[
             RowBox[{"2", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["Q",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Charge,
                Editable->False], "2"]}], 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], "2"]}]}]],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
              FractionBox[
               RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Q"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Charge, Editable -> False], "2"]}], 
               RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                 "+", 
                 RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                   " ", 
                   RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                 "+", 
                 RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}]]}]],
           
           Annotation[#, {3, 3} -> 
            2 $CellContext`Charge^2/($CellContext`Rotation^2 + \
$CellContext`Rotation^2 Cos[2 $CellContext`\[Theta][]] + 
             2 $CellContext`r[]^2), "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", 
              FractionBox[
               RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Q"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Charge, Editable -> False], "2"], 
                 " ", 
                 SuperscriptBox[
                  RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                  "2"]}], 
               RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                 "+", 
                 RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`Rotation, Editable -> False], "2"], 
                   " ", 
                   RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                 "+", 
                 RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}]]}]],
           
           Annotation[#, {4, 4} -> 
            2 $CellContext`Charge^2 ($CellContext`Rotation^2 + \
$CellContext`Rotation^2 Cos[2 $CellContext`\[Theta][]] + 
               2 $CellContext`r[]^2)^(-1) Sin[
                $CellContext`\[Theta][]]^2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[0, 0, 1], 5 -> RGBColor[0, 0, 1]},
           "RowsIndexed" -> {1 -> RGBColor[0, 0, 1], 5 -> RGBColor[0, 0, 1]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{
    8 $CellContext`Charge^2 ($CellContext`Rotation^2 + \
$CellContext`Rotation^2 Cos[2 $CellContext`\[Theta][]] + 
       2 $CellContext`r[]^2)^(-3) ($CellContext`Charge^2 + \
$CellContext`Rotation^2 + $CellContext`r[] ((-2) $CellContext`Mass + \
$CellContext`r[])), 0, 0, 0}, {
    0, (-2) $CellContext`Charge^2 ($CellContext`Rotation^2 + \
$CellContext`Rotation^2 Cos[2 $CellContext`\[Theta][]] + 
       2 $CellContext`r[]^2)^(-1)/($CellContext`Charge^2 + \
$CellContext`Rotation^2 + $CellContext`r[] ((-2) $CellContext`Mass + \
$CellContext`r[])), 0, 0}, {
    0, 0, 2 $CellContext`Charge^2/($CellContext`Rotation^2 + \
$CellContext`Rotation^2 Cos[2 $CellContext`\[Theta][]] + 
     2 $CellContext`r[]^2), 0}, {
    0, 0, 0, 2 $CellContext`Charge^2 ($CellContext`Rotation^2 + \
$CellContext`Rotation^2 Cos[2 $CellContext`\[Theta][]] + 
       2 $CellContext`r[]^2)^(-1) Sin[
        $CellContext`\[Theta][]]^2}}, {-$CellContext`frame, \
-$CellContext`frame}, 0][-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",ExpressionUUID->"13ed93e6-f047-4605-892e-\
38e9d8687348"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Kretschmann", "[", "cd", "]"}], "[", "]"}]], "Input",ExpressionUUID\
->"8794c980-7e57-4d22-9fd2-df9b007f6c76"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "2"], "+", 
       RowBox[{
        SuperscriptBox[
         InterpretationBox[
          StyleBox["a",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Rotation,
          Editable->False], "2"], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"]}]}], ")"}], "6"]], 
   RowBox[{"32", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "42"}], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["Q",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Charge,
         Editable->False], "4"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "4"]}], "+", 
      RowBox[{"30", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["M",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Mass,
         Editable->False], "2"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "6"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["M",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Mass,
         Editable->False], "2"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "6"], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          ShowAutoStyles->False,
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"6", " ", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False]}], "]"}]}], "+", 
      RowBox[{"360", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["Q",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Charge,
         Editable->False], "2"], " ", 
       InterpretationBox[
        StyleBox["M",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Mass,
        Editable->False], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "4"], " ", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False]}], "+", 
      RowBox[{"272", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["Q",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Charge,
         Editable->False], "4"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "2"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "2"]}], "-", 
      RowBox[{"540", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["M",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Mass,
         Editable->False], "2"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "4"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "2"]}], "-", 
      RowBox[{"960", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["Q",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Charge,
         Editable->False], "2"], " ", 
       InterpretationBox[
        StyleBox["M",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Mass,
        Editable->False], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "2"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "3"]}], "-", 
      RowBox[{"112", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["Q",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Charge,
         Editable->False], "4"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "4"]}], "+", 
      RowBox[{"720", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["M",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Mass,
         Editable->False], "2"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "2"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "4"]}], "+", 
      RowBox[{"192", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["Q",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Charge,
         Editable->False], "2"], " ", 
       InterpretationBox[
        StyleBox["M",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Mass,
        Editable->False], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "5"]}], "-", 
      RowBox[{"96", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["M",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Mass,
         Editable->False], "2"], " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "4"], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          ShowAutoStyles->False,
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False]}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["Q",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Charge,
            Editable->False], "4"]}], "+", 
         RowBox[{"60", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["Q",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Charge,
            Editable->False], "2"], " ", 
          InterpretationBox[
           StyleBox["M",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Mass,
           Editable->False], " ", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["M",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Mass,
            Editable->False], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], "2"], "-", 
            RowBox[{"10", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        InterpretationBox[
         StyleBox["a",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Rotation,
         Editable->False], "2"], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          ShowAutoStyles->False,
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False]}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["Q",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Charge,
            Editable->False], "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], "2"]}], "-", 
            RowBox[{"34", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]}]}], ")"}]}], "+", 
         RowBox[{"480", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["Q",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Charge,
            Editable->False], "2"], " ", 
          InterpretationBox[
           StyleBox["M",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Mass,
           Editable->False], " ", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], "2"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]}]}], ")"}]}], "+", 
         RowBox[{"45", " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["M",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Mass,
            Editable->False], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], "4"], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], "2"], " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "4"]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}]}]], "Output",ExpressionUUID->"38830260-75e7-4224-b8e3-\
0146652c2952"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riemann", "[", "cd", "]"}]], "Input",ExpressionUUID->"6852fa8e-9d39-43f8-9e26-28edb5d7de52"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"8", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "6"}], " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{"4", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "3"]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "4"]]}], ",", "0", ",", 
           "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "6"}], " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{"4", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "3"]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], "+", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], " ", 
                  RowBox[{
                   InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                   RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}]}]]}], ",", "0", ",", 
           "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"8", " ", 
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cot",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cot,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "3"]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           FractionBox[
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False]}], "]"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "3"]], ",", "0"}], 
          "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "3"]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                  RowBox[{"3", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}], ")"}], "4"]}]], ",", "0"}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"4", " ", 
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cot",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cot,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "3"]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Mass,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"], " ", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}], "+", 
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Mass,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "3"]}], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "-", 
                RowBox[{"3", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["Q",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Charge,
                Editable->False], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}]}]}], 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}], ")"}], "2"]}]], ",", "0", ",", 
           "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox[
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False]}], "]"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "3"]], ",", "0", ",", 
           "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           FractionBox[
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "3"]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                  RowBox[{"3", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "4"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           FractionBox[
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False]}], "]"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "3"]], ",", "0"}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "3"]]}], ",", "0", ",", 
           "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "3"]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                  RowBox[{"3", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], "2"]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "2"]], ",", "0", ",", 
           "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox[
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "6"}], " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{"4", " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "3"]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "4"]], ",", "0", ",", 
           "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "6"}], " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{"4", " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "3"]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], ")"}]}]}], ")"}]}]], ",", "0", ",", 
           "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           FractionBox[
            RowBox[{"8", " ", 
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Cot",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cot,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "3"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"4", " ", 
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "3"]]}], ",", "0"}], 
          "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           FractionBox[
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Cot",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cot,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "3"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Mass,
                Editable->False], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], "+", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Mass,
                Editable->False], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], "3"]}], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False]}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], "-", 
                 RowBox[{"3", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Mass,
                   Editable->False], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}]}]]}], ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Mass,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"], " ", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}], "+", 
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Mass,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "3"]}], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "-", 
                RowBox[{"3", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["Q",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Charge,
                Editable->False], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}]}]}], 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}], ")"}], "2"]}]], ",", "0", ",", 
           "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False]}], "]"}]}], 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], ")"}]}]}], ")"}]}]], ",", "0", ",", 
           "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "3"]]}], ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           FractionBox[
            RowBox[{
             RowBox[{"6", " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Mass,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"], " ", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}], "-", 
             RowBox[{"4", " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Mass,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "3"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "-", 
                RowBox[{"3", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}]}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["Q",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Charge,
                Editable->False], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}]}]}], 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], ")"}]}]}], ")"}]}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}]}]]}], ",", "0", ",", 
           "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "3"]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                  RowBox[{"3", " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], "2"]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "2"]], ",", "0", ",", 
           "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "3"]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                   RowBox[{"3", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}], ")"}], "4"]}]]}], ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           FractionBox[
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Cot",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cot,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "3"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Mass,
                Editable->False], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], "+", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Mass,
                Editable->False], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], "3"]}], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False]}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], "-", 
                 RowBox[{"3", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Mass,
                   Editable->False], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}], ")"}], "2"]}]]}], ",", "0", ",", 
           "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "3"]]}], ",", "0", ",", 
           "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"4", " ", 
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cot",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cot,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "3"]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Mass,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"], " ", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}], "+", 
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["M",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Mass,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "3"]}], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Rotation,
                Editable->False], "2"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "-", 
                RowBox[{"3", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["Q",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Charge,
                Editable->False], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}]}]}], 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], ")"}]}]}], ")"}]}]], ",", "0"}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Mass,
                Editable->False], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], "+", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Mass,
                Editable->False], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], "3"]}], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False]}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], "-", 
                 RowBox[{"3", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Mass,
                   Editable->False], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}], ")"}], "2"]}]]}], ",", "0", ",", 
           "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}]}]]}], ",", "0", ",", 
           "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"4", " ", 
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "3"]]}], ",", "0", ",", 
           "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}]}]]}], ",", "0", ",", 
           "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "-", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"]}], "-", 
                RowBox[{"3", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "2"]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "-", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"]}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], " ", 
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False], "]"}], "2"]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "2"]]}], ",", "0"}], 
          "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"8", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "3"]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                   RowBox[{"3", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "4"]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`Rotation,
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "3"]]}], ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox[
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False]}], "]"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "3"]], ",", "0", ",", 
           "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], "+", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["M",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Mass,
                  Editable->False], " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "3"]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Charge,
                    Editable->False], "2"], "-", 
                   RowBox[{"3", " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False], "]"}], "2"]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], " ", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False], "2"]}]}], ")"}], "2"]]}], ",", "0", ",", 
           "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           FractionBox[
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], " ", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], "+", 
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], "-", 
                  RowBox[{"6", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False]}], "]"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], "+", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], " ", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False]}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], "2"]}]}], ")"}], "3"]], ",", "0"}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              RowBox[{"6", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Mass,
                Editable->False], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], "-", 
              RowBox[{"4", " ", 
               InterpretationBox[
                StyleBox["M",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Mass,
                Editable->False], " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], "3"]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Rotation,
                 Editable->False], "2"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False]}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["Q",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Charge,
                   Editable->False], "2"], "-", 
                 RowBox[{"3", " ", 
                  InterpretationBox[
                   StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Mass,
                   Editable->False], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["Q",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Charge,
                 Editable->False], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}]}]}], 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`Rotation,
                   Editable->False], "2"], "+", 
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Rotation,
                    Editable->False], "2"], " ", 
                  RowBox[{
                   InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                   RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["Q",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Charge,
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`Rotation,
                  Editable->False], "2"], "+", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}], "+", 
                   InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}], ")"}]}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Rotation,
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                InterpretationBox[
                 StyleBox["M",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Mass,
                 Editable->False], " ", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $