(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   3920753,     105158]
NotebookOptionsPosition[   3754821,     102702]
NotebookOutlinePosition[   3762964,     102873]
CellTagsIndexPosition[   3762162,     102850]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["xAct`xCoba",
  FontSize->18],
 StyleBox["`", "MB",
  FontSize->18]
}], "Section",
 CellTags->{
  "S5.18.1", "1.1"},ExpressionUUID->"dbbba50a-4c94-44b0-a4d2-1993a97edb6b"],

Cell[TextData[{
 "This is the doc file xCobaDoc.nb of version 0.8.4 of ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ". Last update on 28 February 2018."
}], "Text",ExpressionUUID->"74575b00-067d-46dd-b842-ff31b347101c"],

Cell[CellGroupData[{

Cell["Intro", "SubsubsectionIcon",ExpressionUUID->"ceab4abb-2c8a-4962-bfdd-9745e4fed9e7"],

Cell[TextData[{
 StyleBox["xCoba`,",
  FontFamily->"Courier"],
 " a companion package to ",
 StyleBox["xTensor`,", "MR"],
 " provides several tools for working with bases and components. It allows \
the user to define bases on one or more vector bundles and to handle basis \
vectors, using basis indices notation. It performs component calculations \
such as expanding a tensor in a specified basis, changing the basis of an \
expression or tracing the contraction of basis dummies. ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 " stores and handles component values efficiently, making full use of tensor \
symmetries. The package knows how to express derivatives and brackets of \
basis vectors in terms of Christoffel and torsion tensors and how to assign \
values to the components of a tensor. Support for charts (coordinate fields, \
restriction of a field to a point, etc.) is limited."
}], "Text",ExpressionUUID->"3ea432db-0842-4a82-933f-4fc79004767f"],

Cell[TextData[{
 StyleBox["xCoba`", "MR"],
 " is built on the twin package ",
 StyleBox["xTensor`, ", "MR"],
 "which is loaded automatically."
}], "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"19b2c54d-14d5-4b93-87a3-1139d289747f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load the package", "SubsubsectionIcon",ExpressionUUID->"c400feeb-afb2-4fb8-b75a-bc95a6dfa74c"],

Cell[TextData[{
 "This loads the package from the default directory, for example $Home/.",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "/AddOns/Applications/xAct/ for a single-user installation under Linux. ",
 StyleBox["xTensor`", "MR"],
 " and ",
 StyleBox["xPerm` ", "MR"],
 "are automatically loaded."
}], "MathCaption",
 CellTags->{
  "S5.18.1", "1.3"},ExpressionUUID->"905e69e0-0b65-4680-a63d-32011e1e7f2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"5fb34138-8092-45c4-9d4c-d938ef26d371"],

Cell[BoxData["36218176"], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"73fce756-5d29-43c7-be50-5d0ebdccb174"]
}, Open  ]],

Cell[CellGroupData[{

Cell["<<xAct`xCoba`", "Input",
 CellTags->"S5.18.1",
 CellLabel->"In[2]:=",ExpressionUUID->"230b9d8c-8eb7-4fe3-9ce6-d08664c83251"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"eff260bf-ed17-4b7a-8b85-c1ac41f73acc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"d4e7169e-b159-4960-a301-ad0e9d15e51f"],

Cell[BoxData["\<\"CopyRight (C) 2003-2015, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"b3998fee-2275-4abd-abcb-d13634fb188c"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"56042967-66f7-441e-bee3-fc0530190889"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"d8c968e6-9e6d-4b9b-b9bc-cd09f49435e0"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"0b314404-0043-43c7-931c-802d7f694280"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.3", ", ", {2018, 2, 28}],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"430fc51d-5579-42e5-8c62-cb15a407cc86"],

Cell[BoxData["\<\"CopyRight (C) 2002-2018, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"8a1c7a00-e410-47ef-b90a-dbb1df7a1537"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"09767087-367b-4a50-80f9-5492d4157245"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.4", ", ", {2018, 2, 28}],
  
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"d7cb4989-691b-43f3-b967-3c9cacbb1263"],

Cell[BoxData["\<\"CopyRight (C) 2005-2018, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"af42ce6e-d463-4666-a3ce-90e33a73725e"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"a1d3348f-18e4-48f8-94a4-f70c18d0d658"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"bc61ba52-a11c-47e0-86f8-09dba191572f"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"6d2d3785-81a5-4eda-b437-c0288e145fc4"]
}, Open  ]],

Cell[TextData[{
 "Comparing, we see that the packages take about 10Mb  in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.2:"
}], "MathCaption",ExpressionUUID->"c5e6fdf3-7ebd-44eb-a8f1-f386aedc0a6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"aeb08858-07ba-452f-9e9b-15138097f5f9"],

Cell[BoxData["65935896"], "Output",
 CellLabel->"Out[3]=",ExpressionUUID->"c14cf995-88a2-4d85-82fa-f0946fa3d859"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Out", "[", "3", "]"}], "-", 
  RowBox[{"Out", "[", "1", "]"}]}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"80d5f08a-78f9-4cc7-ae84-ce6da63a2bbf"],

Cell[BoxData["29717720"], "Output",
 CellLabel->"Out[4]=",ExpressionUUID->"16e212b7-bc73-4b55-bc4d-e4a93df788ca"]
}, Open  ]],

Cell[TextData[{
 "There are six contexts: ",
 StyleBox["xAct`xCoba`, xAct`xTensor`",
  FontFamily->"Courier"],
 ", ",
 StyleBox["xAct`xPerm`",
  FontFamily->"Courier"],
 " and ",
 StyleBox["xAct`ExpressionManipulation`",
  FontFamily->"Courier"],
 " contain the respective reserved words. ",
 StyleBox["System`",
  FontFamily->"Courier"],
 " contains ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s reserved words. The current context ",
 StyleBox["Global`",
  FontFamily->"Courier"],
 " will contain your definitions and right now it is empty."
}], "MathCaption",ExpressionUUID->"0e34fae5-3f91-4d18-a53d-c90940109afe"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"29314ddf-d969-4f3a-a19c-78995a2cb4a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DocumentationSearch`\"\>", ",", "\<\"ResourceLocator`\"\>", 
   ",", "\<\"xAct`xCoba`\"\>", ",", "\<\"xAct`ExpressionManipulation`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"WolframAlphaClient`\"\>", 
   ",", "\<\"ExternalEvaluateLoader`\"\>", ",", "\<\"SystemTools`\"\>", 
   ",", "\<\"PacletManager`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[5]=",ExpressionUUID->"b7f4f063-4148-4e62-9e19-af7f68a4a8af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "]"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"fb6622f7-47ee-423d-bc6f-cc128980a887"],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellLabel->"Out[6]=",ExpressionUUID->"ea9e3b91-8cde-4f98-8c56-2110c742ae82"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"17c0e62a-a983-4031-bbe2-f134a643880f"],

Cell[BoxData[
 TemplateBox[{
  "Information","nomatch",
   "\"No symbol matching \
\\!\\(\\*RowBox[{\\\"\\\\\\\"Global`*\\\\\\\"\\\"}]\\) found.\"",2,7,1,
   19248065981107874568,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"67765b99-a181-4b88-837e-cb46d735f593"]
}, Open  ]],

Cell["We turn off the annoying spell messages:", "MathCaption",ExpressionUUID->"7fc53feb-25a5-4b93-a010-23f02ff9260e"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell1"}], "]"}]}], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"7f65f126-0de2-43e3-98ac-3716596cc7bf"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["0. xCoba` at a glance",
 FontSize->14]], "SubsectionIcon",ExpressionUUID->"1d1a3bbf-f661-4f3d-8fe4-\
621aa6bd670b"],

Cell[TextData[{
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 "  has been built on ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 "  and shares its approach and priorities. In particular a great deal of \
effort has been made to allow full compatibility between abstract and \
component computations. A crucial ingredient has been the formalism of ",
 StyleBox["marked indices ",
  FontSlant->"Italic"],
 "and particularly the treatment of frame dependent objects. Perhaps the most \
conspicuous example is the covariant parallel derivative, which follows the \
concept of ordinary derivative as described on Wald's ",
 StyleBox["General Relativity.",
  FontSlant->"Italic"],
 "  This reference has been the main inspiration for much of the notation, \
and the user is advised to keep it in mind when dealing with some of the non \
standard ideas employed by this package."
}], "Text",ExpressionUUID->"6474d4f7-8d4a-4dea-b3d1-8af5c08e2840"],

Cell[TextData[{
 "A session with ",
 StyleBox["xCoba` ",
  FontFamily->"Courier"],
 "begins just like one with ",
 StyleBox["xTensor`, ",
  FontFamily->"Courier"],
 "defining one or more manifolds and vector bundles and the objects living on \
them:"
}], "Text",ExpressionUUID->"f0fe6d4f-06bd-416b-9c68-4dbe13a5980f"],

Cell[TextData[{
 "Define a 3d manifold ",
 StyleBox["M3",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"d73d0932-aee1-47f0-97a5-1d9b24e8bb84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M3", ",", " ", "3", ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"2227dbb2-4f25-4016-a854-ecb257ec0cc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"34f6e2c3-f486-4fa4-a965-65a21c22bfab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"93c5b76f-881e-458d-8f6f-df8d3ff6ac26"]
}, Open  ]],

Cell["Define a complex vector bundle", "MathCaption",ExpressionUUID->"2f4e63a1-9698-4648-be5f-74b3a9d261cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefVBundle", "[", 
  RowBox[{"InnerC", ",", "M3", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "G"}], "}"}], 
   ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"1c61b0aa-a0ba-45a1-b437-0e5a59a551ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "InnerC", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`InnerC, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"18af280d-d006-4bee-9716-7d1779818033"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol","capital",
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"C\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"",2,11,2,19248065981107874568,"Local",
   "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"5f7e0443-9531-4f6b-9680-ef9b3b82d5dd"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol","capital",
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"D\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"",2,11,3,19248065981107874568,"Local",
   "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"a353a536-489f-454a-88ba-63da79d9e304"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "InnerC\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between InnerC \
and InnerC\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`InnerC\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between InnerC and InnerC\[Dagger]"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"12a2c6a7-66de-407d-a90f-b6e42901e6c8"]
}, Open  ]],

Cell[TextData[{
 "Define a contravariant vector ",
 StyleBox["v",
  FontFamily->"Courier"],
 " and a covariant symmetric tensor ",
 StyleBox["T",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"144e099c-20ee-46c4-b579-e9eda0162447"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "}"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"fa47a144-19e3-4f11-8851-55e3f7cfe830"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"5c6238ae-43ae-44ea-a13a-804da2c87e75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"dfc49c97-e4ca-478b-bea8-c26478427825"]
}, Open  ]],

Cell[TextData[{
 "Define a Riemann symmetric tensor and a covariant vector on ",
 StyleBox["InnerC",
  FontFamily->"Courier"]
}], "MathCaption",ExpressionUUID->"9e87e110-73d4-42a6-a9b0-9820a7c58a00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"R", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"RiemannSymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"1aa374b7-92b8-4bb2-b014-cf39b8e0f0d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"R", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`R[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[14]:=",ExpressionUUID->"c25c7b95-33ef-4467-8761-36873388f8ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"R\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`R\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[14]:=",ExpressionUUID->"081730e8-b700-47de-b27f-3f5b26c6440d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"-", "A"}], "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"09246897-571f-4402-a8c3-88dac122abee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"u", "[", 
    RowBox[{"-", "A"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`u[-$CellContext`A], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"773000dd-a713-40b3-858b-456adeff50ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"u\[Dagger]", "[", 
    RowBox[{"-", "A\[Dagger]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`u\[Dagger][-$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"43bd8dce-159e-45dc-a345-efb0dcffb246"]
}, Open  ]],

Cell[TextData[{
 "Remember that, in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", we use abstract indices"
}], "MathCaption",ExpressionUUID->"8df2b989-60fa-483e-92c7-b9c8d36c5750"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], 
  RowBox[{"v", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"3e510aa4-9ca5-4a69-b048-4e760800cdd1"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False]}]], "Output",
 CellLabel->"Out[16]=",ExpressionUUID->"e16aae57-dcb3-435e-a7d2-b06a371cfa83"]
}, Open  ]],

Cell["\<\
A basis is a set of vector fields on a vbundle, and the associated dual set \
of vector fields. We only declare the name of the basis and the associated \
cnumbers.\
\>", "Text",ExpressionUUID->"f5748fd6-e0f0-4e93-ad14-30ba9184170e"],

Cell[TextData[{
 "Now ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 "  lets us define  bases. We have to specify its cnumbers (integers \
identifying the vectors of the basis) and vector bundle. Several related \
objects are also defined (parallel derivative and associated tensors). "
}], "MathCaption",ExpressionUUID->"e67021f0-f9cd-4b75-947a-e00601bd1833"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"polar", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"087432d1-54fc-4625-bf20-fe69ae86adb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "polar", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`polar, 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1df73cd9-5bd1-4500-b3eb-91612e0e63a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDpolar", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDpolar[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d937cec7-8a2a-42b1-9509-ccf672092acb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDpolar", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDpolar[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"eba9ae71-7ac2-48d4-ae0e-bdb740c7d0c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDpolar", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDpolar[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"689738b3-11fd-4ab0-aa4e-b1fe8e0549ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDpolar", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDpolar[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"009590e4-e4c8-4b8d-9701-6d6578e4476f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDpolar", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDpolar[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d0eff0d5-9872-47a9-b0ca-73bc339d7b57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUppolar", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUppolar[$CellContext`a, $CellContext`b, $CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"57a1030d-1236-4cc8-a91b-8182bda1a8a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownpolar", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownpolar[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8d52a9bd-41ab-4dc3-82c2-4c955895ffbe"]
}, Open  ]],

Cell["\<\
Each basis has a colour, used to identify its associated objects in \
StandardForm\
\>", "MathCaption",ExpressionUUID->"9291b8b6-e93e-46b0-889f-10bfad8faacc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"cartesian", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"01f5cb31-2e45-4c6f-a741-9ffabb0fc8e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "cartesian", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`cartesian,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"25e8f3ac-5abb-4853-8428-8812af4bcc96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDcartesian", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDcartesian[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"c3130198-c014-4de0-b7f0-92fa9c0f6f8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDcartesian", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDcartesian[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"ffb86a42-3c6b-4290-8758-b6f07d971160"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcartesian", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDcartesian[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"777baeb4-64b1-4ec7-9341-8f3e0ba0a070"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDcartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDcartesian[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"c75bff4e-8e4c-4cd6-bdcf-fa4d513a6cc1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDcartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDcartesian[-$CellContext`a, -$CellContext`b], ". ", ""],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"ba0a865f-513c-4ad2-a07d-448bfd6c70df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpcartesian", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpcartesian[$CellContext`a, $CellContext`b, \
$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"dd134044-8e93-476a-986d-87bc686704f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDowncartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDowncartesian[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"4272b9cb-473f-4d83-860c-1aa8df831ce8"]
}, Open  ]],

Cell["\<\
We can define bases on the complex vector bundle. This generates additional \
objects for its parallel derivative (FRiemann and AChristoffel)\
\>", "MathCaption",ExpressionUUID->"b08378bc-0f01-42bb-8aa5-c2e25a22ee2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"complex", ",", "InnerC", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "1", ",", "0"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"4116992a-0df4-4d2e-9008-e0fb7d61d8fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "complex", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`complex, 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"81502c5f-4e76-426c-812e-1a193787f191"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDcomplex", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDcomplex[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"5a89da82-c647-43b9-91f9-b159b10b4908"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDcomplex", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDcomplex[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"b87f8010-205e-460e-89fc-5d3c4af930b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcomplex", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDcomplex[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"4d89bcc7-e048-4d1b-976d-0a23e06ff95f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDcomplex", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDcomplex[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"2f1512f1-cef9-4f35-bb3e-f0f3179c1c77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDcomplex", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDcomplex[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"1021690d-3033-4a81-84eb-5d73c8241253"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDcomplex", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDcomplex[$CellContext`A, -$CellContext`b, -C], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"87db9a69-0405-4b00-aecd-10f9b462449c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDcomplex\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDcomplex\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"2d0948cb-b8d5-4f7a-a487-685a68b43308"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDcomplex", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDcomplex[-$CellContext`a, -$CellContext`b, -C, D], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"8f06c568-8194-466c-910c-7525f4f39164"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDcomplex\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDcomplex\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"067164e8-3d87-439c-b34b-0ce7cbf7e72a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", 
   "complex\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", 
   "basis ", $CellContext`complex\[Dagger], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"c9b4f722-5958-45dd-9afe-894571f5cd97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpcomplex", "[", 
    RowBox[{"A", ",", "B"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpcomplex[$CellContext`A, $CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"fa9703c3-55fc-4201-95aa-10e8287629e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpcomplex\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "B\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpcomplex\[Dagger][$CellContext`A\[Dagger], $CellContext`B\
\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"f53dd7bb-c316-47be-a5b4-cd00274f8f27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDowncomplex", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDowncomplex[-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"ac15e83e-84c8-4eb4-816d-cb62737ffc2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDowncomplex\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDowncomplex\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"0d311b28-786d-4eda-90b9-8983d41dbf1d"]
}, Open  ]],

Cell["\<\
As we advanced on the introduction, all the objects that depend on a \
particular basis are marked with its colour, for example here the parallel \
derivative of the basis\
\>", "MathCaption",ExpressionUUID->"391bcf87-e02f-46a0-ae84-04de15fddfa1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDpolar", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"f14ab5d7-76cc-4ee3-958e-22377b581561"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox[
     StyleBox["\[ScriptCapitalD]",
      FontColor->RGBColor[1., 0., 0.]], "a"], GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " "},
          {"b", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`PDpolar[-$CellContext`a][
   $CellContext`T[-$CellContext`b, -$CellContext`c]],
  Editable->False]], "Output",
 CellLabel->"Out[20]=",ExpressionUUID->"f6b31141-136c-42b4-a270-e7386da05eb5"]
}, Open  ]],

Cell[TextData[{
 "Now we can use basis indices and work with specific components. A \
contravariant basis index (",
 StyleBox["BIndex",
  FontFamily->"Courier new"],
 ") is represented by ",
 StyleBox["{a, basis}",
  FontFamily->"Courier new"],
 ", where ",
 StyleBox["a",
  FontFamily->"Courier"],
 " is a valid abstract index and ",
 StyleBox["basis",
  FontFamily->"Courier"],
 " an existing basis. A covariant basis index is represented by ",
 StyleBox["{-a, -basis}",
  FontFamily->"Courier new"],
 ".   If we give an integer instead of an abstract index we get a component \
index (",
 StyleBox["CIndex",
  FontFamily->"Courier new"],
 "):"
}], "MathCaption",ExpressionUUID->"893ff924-3a92-4a50-bdcb-73ecee828f56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "polar"}]}], "}"}], ",", "b"}], "]"}], 
  RowBox[{"v", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "cartesian"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[21]:=",ExpressionUUID->"e1993ef5-0f7c-424f-9f13-91f04053b38f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", "b"},
          {
           StyleBox["a",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[{-$CellContext`a, -$CellContext`polar}, $CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{1, $CellContext`cartesian}],
   Editable->False]}]], "Output",
 CellLabel->"Out[21]=",ExpressionUUID->"0a2041ea-4dae-43ce-9edf-4c1d555fe19a"]
}, Open  ]],

Cell[TextData[{
 "Covariant component indices are represented by",
 StyleBox[" {i, -basis}",
  FontFamily->"Courier"],
 ", not by ",
 StyleBox["{-i, -basis}",
  FontFamily->"Courier"],
 ". This is because we consider the bases on the tangent and cotagent bundles \
to have the same cnumbers (and also allows us to use nonpositive  integers as \
cnumbers):"
}], "MathCaption",ExpressionUUID->"09f7c848-189a-407c-9944-0c07042c94b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "cartesian"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"e5525067-912b-4449-9499-3f08234f0b98"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {" "},
         {
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{1, -$CellContext`cartesian}],
  Editable->False]], "Output",
 CellLabel->"Out[22]=",ExpressionUUID->"0a6b04c7-99dd-41a7-8b60-2fa3767b4d3a"]
}, Open  ]],

Cell["\<\
Basis vectors and transition matrices are represented by the two-index object \
Basis. Without a metric, only the down-up configuration is allowed:\
\>", "MathCaption",ExpressionUUID->"e0f55b9e-3dcd-4936-9ae4-6a3451845cfe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "complex"}]}], "}"}], ",", "A"}], "]"}]], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"d4c9e50d-7192-45ff-8f8d-7cc00c86e048"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", "A"},
         {
          StyleBox["4",
           FontColor->RGBColor[0., 1., 0.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{4, -$CellContext`complex}, $CellContext`A],
  Editable->False]], "Output",
 CellLabel->"Out[23]=",ExpressionUUID->"ac526592-57ff-41dd-9c8d-e1f570971d4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{"A", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", 
      RowBox[{"-", "complex"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"a78b18f2-7258-4c1a-bc84-9fb076646eaf"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle","missing",
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"InnerC\\\", Rule[AutoSpacing, False], \
Rule[ShowAutoStyles, False]], InnerC, Rule[Editable, False]]\\).\"",2,24,4,
   19248065981107874568,"Local","xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"d1eb2f54-571f-42ac-9e67-86ceb7292a33"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "cartesian"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"574efbd0-14d4-469e-a113-a3a4d8886874"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["b",
           FontColor->RGBColor[0., 0., 1.]]},
         {
          StyleBox["a",
           FontColor->RGBColor[1., 0., 0.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, {$CellContext`b, \
$CellContext`cartesian}],
  Editable->False]], "Output",
 CellLabel->"Out[25]=",ExpressionUUID->"1beda6d4-7dbc-462c-b2ae-494f2b880b33"]
}, Open  ]],

Cell["\<\
Bases objects are not automatically contracted with one another:\
\>", "MathCaption",ExpressionUUID->"baf6d2eb-1e51-4132-89d3-e488e45da70b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], ",", "a"}], "]"}]}]], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"457abba6-961f-4228-8083-0ae77effb2fe"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["b",
            FontColor->RGBColor[1., 0., 0.]]},
          {"a", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`a, {$CellContext`b, $CellContext`polar}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["c",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`c, -$CellContext`cartesian}, \
$CellContext`a],
   Editable->False]}]], "Output",
 CellLabel->"Out[26]=",ExpressionUUID->"68dabd4a-8fd6-4f3a-8d64-e80570323331"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], ",", "a"}], "]"}], 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}]}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"1461e086-6941-44bd-9ba6-fb7dc9d85c32"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[-$CellContext`a, -$CellContext`b],
   Editable->False]}]], "Output",
 CellLabel->"Out[27]=",ExpressionUUID->"965ab9c5-5c69-4f27-9eae-672b704a705f"]
}, Open  ]],

Cell["\<\
We must use the function ContractBasis to force the operation.\
\>", "MathCaption",ExpressionUUID->"a583f142-5238-4fa0-9d9a-a9ef7828a3b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", "%", "]"}]], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"05576938-a6ed-432c-92cd-92df7da0d29e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"T", 
      StyleBox[GridBox[{
         {" ", " "},
         {
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]], "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`T[{1, -$CellContext`cartesian}, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[28]=",ExpressionUUID->"7beef030-41a0-40a2-a895-5960583e4294"]
}, Open  ]],

Cell["\<\
This function is quite general and allows the user to specify which indices \
should be acted upon.The default is total contraction:\
\>", "MathCaption",ExpressionUUID->"732e82b6-b346-4d4a-8cb7-4804076352ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "cartesian"}], "}"}]}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "e"}], "]"}]}]}]], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"644c1d17-43de-4b30-933f-75681cb99f09"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "e"},
          {
           StyleBox["d",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`d, -$CellContext`polar}, $CellContext`e],
   
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", "c", 
           StyleBox["d",
            FontColor->RGBColor[1., 0., 0.]]},
          {"a", "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`a, -$CellContext`b, $CellContext`c, \
{$CellContext`d, $CellContext`polar}],
   Editable->False]}]], "Output",
 CellLabel->"Out[29]=",ExpressionUUID->"8dce5675-fe1c-4b3c-a193-48691e011587"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", "expr", "]"}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"4023367d-aa79-4d9f-abeb-f2900830add1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {" ", " ", 
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]], "e"},
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{1, -$CellContext`polar}, -$CellContext`b, {
   1, $CellContext`cartesian}, $CellContext`e],
  Editable->False]], "Output",
 CellLabel->"Out[30]=",ExpressionUUID->"a7eb7e56-ee0d-4c66-85b2-8f094c00d5e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", "polar"}], "]"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"b3f1b95a-f13a-49eb-83bd-261e42316d5b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", "c", "e"},
          {"a", "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`e],
   Editable->False]}]], "Output",
 CellLabel->"Out[31]=",ExpressionUUID->"75b09e21-12fa-4a2f-b34f-b14c81f98f1c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"185b485b-f451-4e4c-b55c-c113a375f0c1"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "e"},
          {
           StyleBox["d",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`d, -$CellContext`polar}, $CellContext`e],
   
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", "c", 
           StyleBox["d",
            FontColor->RGBColor[1., 0., 0.]]},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{
    1, -$CellContext`polar}, -$CellContext`b, $CellContext`c, \
{$CellContext`d, $CellContext`polar}],
   Editable->False]}]], "Output",
 CellLabel->"Out[32]=",ExpressionUUID->"2276bfa9-4639-4c52-b03d-d67d8313fbae"]
}, Open  ]],

Cell["\<\
The inverse function is SeparateBasis, also quite general. It can undo the \
action of ContractBasis and also change the basis of the whole expression\
\>", "MathCaption",ExpressionUUID->"f191f0cd-83f9-4208-b040-9a8523661f0f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cexpr", "=", 
  RowBox[{"ContractBasis", "[", "expr", "]"}]}]], "Input",
 CellLabel->"In[33]:=",ExpressionUUID->"9562eb05-9c3e-4c35-a176-2bcd9d36f40c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {" ", " ", 
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]], "e"},
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{1, -$CellContext`polar}, -$CellContext`b, {
   1, $CellContext`cartesian}, $CellContext`e],
  Editable->False]], "Output",
 CellLabel->"Out[33]=",ExpressionUUID->"97cb6e98-f83d-427d-a0f3-fcbe5d36d567"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateBasis", "[", "AIndex", "]"}], "[", "cexpr", "]"}]], "Input",\

 CellLabel->"In[34]:=",ExpressionUUID->"c0e15c0e-7246-4677-83f1-5e4102bfd863"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"f$3056", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`f$3056, {1, $CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "f$3055"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`f$3055],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", "f$3056", "e"},
          {"f$3055", "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`f$3055, -$CellContext`b, $CellContext`f$3056, \
$CellContext`e],
   Editable->False]}]], "Output",
 CellLabel->"Out[34]=",ExpressionUUID->"7952582b-c5f3-42ec-9e0a-86251c3067b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateBasis", "[", "cartesian", "]"}], "[", "cexpr", 
  "]"}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"5f27a659-edaa-4817-9ca6-f92b5b99c917"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["f$3059",
            FontColor->RGBColor[0., 0., 1.]]},
          {"b", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`b, {$CellContext`f$3059, \
$CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["f$3058",
            FontColor->RGBColor[0., 0., 1.]]},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{
    1, -$CellContext`polar}, {$CellContext`f$3058, $CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {
           StyleBox["f$3060",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`f$3060, -$CellContext`cartesian}, {
    1, $CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "e"},
          {
           StyleBox["f$3061",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`f$3061, -$CellContext`cartesian}, \
$CellContext`e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["f$3060",
            FontColor->RGBColor[0., 0., 1.]], 
           StyleBox["f$3061",
            FontColor->RGBColor[0., 0., 1.]]},
          {
           StyleBox["f$3058",
            FontColor->RGBColor[0., 0., 1.]], 
           StyleBox["f$3059",
            FontColor->RGBColor[0., 0., 1.]], " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{-$CellContext`f$3058, -$CellContext`cartesian}, \
{-$CellContext`f$3059, -$CellContext`cartesian}, {$CellContext`f$3060, \
$CellContext`cartesian}, {$CellContext`f$3061, $CellContext`cartesian}],
   Editable->False]}]], "Output",
 CellLabel->"Out[35]=",ExpressionUUID->"6ff8744b-1d4b-48a2-94b3-0dbf099147eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ScreenDollarIndices"}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"1a6a1a5f-ef8f-4479-872b-00e044e9b3bc"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["c",
            FontColor->RGBColor[0., 0., 1.]]},
          {"b", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`b, {$CellContext`c, \
$CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["a",
            FontColor->RGBColor[0., 0., 1.]]},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{
    1, -$CellContext`polar}, {$CellContext`a, $CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {
           StyleBox["d",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`d, -$CellContext`cartesian}, {
    1, $CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "e"},
          {
           StyleBox["f",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`f, -$CellContext`cartesian}, \
$CellContext`e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["d",
            FontColor->RGBColor[0., 0., 1.]], 
           StyleBox["f",
            FontColor->RGBColor[0., 0., 1.]]},
          {
           StyleBox["a",
            FontColor->RGBColor[0., 0., 1.]], 
           StyleBox["c",
            FontColor->RGBColor[0., 0., 1.]], " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{-$CellContext`a, -$CellContext`cartesian}, \
{-$CellContext`c, -$CellContext`cartesian}, {$CellContext`d, \
$CellContext`cartesian}, {$CellContext`f, $CellContext`cartesian}],
   Editable->False]}]], "Output",
 CellLabel->"Out[36]=",ExpressionUUID->"512d640b-837b-4fb6-a0a7-ba07194afc7c"]
}, Open  ]],

Cell["\<\
One of the most important features of the package is the ability to trace \
basis contractions,\
\>", "MathCaption",ExpressionUUID->"600bb412-90c2-4297-af29-984398da8d42"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraceBasisDummy", "[", 
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "cartesian"}], "}"}], "]"}], 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"-", "b"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",ExpressionUUID->"2b19ef62-7e0e-4584-ac0f-0a8cd5e21383"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {
            StyleBox["0",
             FontColor->RGBColor[0., 0., 1.]], "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{0, -$CellContext`cartesian}, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["0",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{0, $CellContext`cartesian}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{1, -$CellContext`cartesian}, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{1, $CellContext`cartesian}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{2, -$CellContext`cartesian}, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{2, $CellContext`cartesian}],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[37]=",ExpressionUUID->"066a4a35-d86c-48d7-bfdf-0649e7ebb2f7"]
}, Open  ]],

Cell["We can produce lists of all the basis vectors,", "MathCaption",ExpressionUUID->"0bdf07ef-1639-46fb-bf0b-59a72ece2afa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", "polar", "]"}], "[", "a", "]"}]], "Input",
 CellLabel->"In[38]:=",ExpressionUUID->"d075a0d4-075d-4ab8-bc1e-2b3f99a85174"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["0",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[38]=",ExpressionUUID->"7c3a0248-779b-4340-aa9b-ab4640292a5b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasisArray", "[", 
    RowBox[{"polar", ",", "cartesian", ",", "cartesian"}], "]"}], "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"7d3602f2-ed3e-4061-bb27-92fc6baf523b"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[39]//MatrixForm=",ExpressionUUID->"3cc82a34-a77c-4ee0-a881-\
59ec2290d490"]
}, Open  ]],

Cell["and lists of all the components of a tensor", "MathCaption",ExpressionUUID->"f315b260-ffa6-404c-8aba-49421fe2cd0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentArray", "[", 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"b852019f-6038-4c28-98ce-8b2f112ff081"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`cartesian}, {
       0, -$CellContext`cartesian}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`cartesian}, {
       1, -$CellContext`cartesian}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`cartesian}, {
       2, -$CellContext`cartesian}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{1, -$CellContext`cartesian}, {
       0, -$CellContext`cartesian}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{1, -$CellContext`cartesian}, {
       1, -$CellContext`cartesian}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{1, -$CellContext`cartesian}, {
       2, -$CellContext`cartesian}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{2, -$CellContext`cartesian}, {
       0, -$CellContext`cartesian}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{2, -$CellContext`cartesian}, {
       1, -$CellContext`cartesian}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{2, -$CellContext`cartesian}, {
       2, -$CellContext`cartesian}],
      Editable->False]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[40]=",ExpressionUUID->"567a8fb1-dcb5-461e-a82e-2742bbd0f385"]
}, Open  ]],

Cell["\<\
Notice that T is a symmetric tensor, so this can be simplified\
\>", "MathCaption",ExpressionUUID->"31d51e36-85ae-433d-b70d-5fef2a5210bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplification", "[", "%", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"95c84cfd-f695-49df-bf33-878fbd0f1e50"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`cartesian}, {
        1, -$CellContext`cartesian}],
       Editable->False], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`cartesian}, {
        2, -$CellContext`cartesian}],
       Editable->False]},
     {
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`cartesian}, {
         1, -$CellContext`cartesian}],
        Editable->False]}], "0", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`cartesian}, {
        2, -$CellContext`cartesian}],
       Editable->False]},
     {
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`cartesian}, {
         2, -$CellContext`cartesian}],
        Editable->False]}], 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`cartesian}, {
         2, -$CellContext`cartesian}],
        Editable->False]}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[41]//MatrixForm=",ExpressionUUID->"8d3589a0-0ec2-44a0-b6a2-\
dbba6bbe27ee"]
}, Open  ]],

Cell["\<\
We can assign rules to the components of a tensor taking the symmetries into \
account\
\>", "MathCaption",ExpressionUUID->"deb17fcf-f095-41f1-a81c-cd04b791fe2d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "-", "j"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"33350187-25c2-431b-b909-dc8b7a9fb8a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AllComponentValues", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}]}], "]"}], ",", " ", "values"}], 
  "]"}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"1b4d9a3d-c4f5-483c-be9a-93895f145913"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{0, -$CellContext`polar}, {0, -$CellContext`polar}],
     Editable->False], "\[Rule]", "0"}], 
   "\[InvisibleSpace]", "\<\" for tensor \"\>", "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{0, -$CellContext`polar}, {
     0, -$CellContext`polar}] -> 0, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"c17492d3-d193-4a88-90d1-9dc89d04872a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", "1"}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added independent rule ", $CellContext`T[{0, -$CellContext`polar}, {
     1, -$CellContext`polar}] -> -1, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"9c57540b-a0d3-45b3-af3b-fa1565431093"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", "2"}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added independent rule ", $CellContext`T[{0, -$CellContext`polar}, {
     2, -$CellContext`polar}] -> -2, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"5ab71b4d-4d45-4014-bdf7-d0e4c1cc2681"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{1, -$CellContext`polar}, {0, -$CellContext`polar}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{1, -$CellContext`polar}, {
     0, -$CellContext`polar}] -> -$CellContext`T[{0, -$CellContext`polar}, {
      1, -$CellContext`polar}], " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"4f05b6f2-f67b-4090-9c1d-05951c5b8e03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{1, -$CellContext`polar}, {1, -$CellContext`polar}],
     Editable->False], "\[Rule]", "0"}], 
   "\[InvisibleSpace]", "\<\" for tensor \"\>", "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{1, -$CellContext`polar}, {
     1, -$CellContext`polar}] -> 0, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"32fcbade-231c-4b1d-a4cf-8af2a7340f7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", "1"}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added independent rule ", $CellContext`T[{1, -$CellContext`polar}, {
     2, -$CellContext`polar}] -> -1, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"b3c5e28c-ede1-4130-85b9-a67bdaf49ac3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{2, -$CellContext`polar}, {0, -$CellContext`polar}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{2, -$CellContext`polar}, {
     0, -$CellContext`polar}] -> -$CellContext`T[{0, -$CellContext`polar}, {
      2, -$CellContext`polar}], " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"4aa7b06b-fb47-4d03-a88d-ab4c950bf4b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{2, -$CellContext`polar}, {1, -$CellContext`polar}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{2, -$CellContext`polar}, {
     1, -$CellContext`polar}] -> -$CellContext`T[{1, -$CellContext`polar}, {
      2, -$CellContext`polar}], " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"b5bd5c7e-0056-4759-b994-55bbe32c5a60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{2, -$CellContext`polar}, {2, -$CellContext`polar}],
     Editable->False], "\[Rule]", "0"}], 
   "\[InvisibleSpace]", "\<\" for tensor \"\>", "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{2, -$CellContext`polar}, {
     2, -$CellContext`polar}] -> 0, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"ad292071-76f3-4baa-a114-16a0a917158e"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`polar}, {0, -$CellContext`polar}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`polar}, {0, -$CellContext`polar}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`polar}, {1, -$CellContext`polar}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`polar}, {0, -$CellContext`polar}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`polar}, {1, -$CellContext`polar}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`polar}, {2, -$CellContext`polar}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[43]=",ExpressionUUID->"ce4dd157-4cb7-4ddc-a170-a6c9296593ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColumnForm", "/@", 
  RowBox[{"TensorValues", "[", "T", "]"}]}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"00f32037-3bee-42f0-a788-d81b78c5e3ff"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   InterpretationBox[GridBox[{
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {0, -$CellContext`polar}],
         Editable->False], "\[Rule]", "0"}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {0, -$CellContext`polar}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {1, -$CellContext`polar}],
         Editable->False], "\[Rule]", "0"}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`polar}, {0, -$CellContext`polar}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`polar}, {1, -$CellContext`polar}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False], "\[Rule]", "0"}]}
     },
     BaselinePosition->{Baseline, {1, 1}},
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    ColumnForm[{$CellContext`T[{0, -$CellContext`polar}, {
        0, -$CellContext`polar}] -> 
      0, $CellContext`T[{1, -$CellContext`polar}, {
        0, -$CellContext`polar}] -> -$CellContext`T[{
         0, -$CellContext`polar}, {1, -$CellContext`polar}], $CellContext`T[{
        1, -$CellContext`polar}, {1, -$CellContext`polar}] -> 
      0, $CellContext`T[{2, -$CellContext`polar}, {
        0, -$CellContext`polar}] -> -$CellContext`T[{
         0, -$CellContext`polar}, {2, -$CellContext`polar}], $CellContext`T[{
        2, -$CellContext`polar}, {
        1, -$CellContext`polar}] -> -$CellContext`T[{
         1, -$CellContext`polar}, {2, -$CellContext`polar}], $CellContext`T[{
        2, -$CellContext`polar}, {2, -$CellContext`polar}] -> 0}],
    Editable->False], ",", 
   InterpretationBox[GridBox[{
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", "2"}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", "1"}]}]}
     },
     BaselinePosition->{Baseline, {1, 1}},
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    ColumnForm[{$CellContext`T[{0, -$CellContext`polar}, {
        1, -$CellContext`polar}] -> -1, $CellContext`T[{
        0, -$CellContext`polar}, {
        2, -$CellContext`polar}] -> -2, $CellContext`T[{
        1, -$CellContext`polar}, {2, -$CellContext`polar}] -> -1}],
    Editable->False]}], "]"}]], "Output",
 CellLabel->"Out[44]=",ExpressionUUID->"cca3186c-2a54-477c-8d84-514dfe50d5c2"]
}, Open  ]],

Cell["\<\
As we can see, dependent and independent components are stored in separate \
sublists. We can change basis:\
\>", "MathCaption",ExpressionUUID->"201596bc-06bb-4556-922e-4c117a9b7035"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CVVerbose", "=", "False"}], ";"}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"26b472bf-3a6f-4dd6-a1a9-016ae202193e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeComponents", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"a", ",", "cartesian"}], "}"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"b", ",", "cartesian"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"a", ",", "polar"}], "}"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"b", ",", "polar"}], "}"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"a88a7724-b78c-4527-b786-30607311eee0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["a",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["b",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{-$CellContext`a, -$CellContext`polar}, {-$CellContext`b, \
-$CellContext`cartesian}],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`cartesian}, \
{$CellContext`c, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["a",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{-$CellContext`a, -$CellContext`polar}, \
{-$CellContext`c, -$CellContext`polar}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" in \"\>", 
   "\[InvisibleSpace]", "0.036931`5.018936060924966", 
   "\[InvisibleSpace]", "\<\" Seconds\"\>"}],
  SequenceForm[
  "Computed ", $CellContext`T[{-$CellContext`a, -$CellContext`polar}, \
{-$CellContext`b, -$CellContext`cartesian}] -> 
   xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`cartesian}, \
{$CellContext`c, $CellContext`polar}] $CellContext`T[{-$CellContext`a, \
-$CellContext`polar}, {-$CellContext`c, -$CellContext`polar}], " in ", 
   0.036931`5.018936060924966, " Seconds"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"b4b3e692-a460-48a7-9cd9-11580b3e7788"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]], 
             StyleBox["b",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{-$CellContext`a, -$CellContext`cartesian}, \
{-$CellContext`b, -$CellContext`cartesian}],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`cartesian}, \
{$CellContext`c, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{-$CellContext`c, -$CellContext`polar}, \
{-$CellContext`b, -$CellContext`cartesian}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" in \"\>", 
   "\[InvisibleSpace]", "0.048895`5.14080944396043", 
   "\[InvisibleSpace]", "\<\" Seconds\"\>"}],
  SequenceForm[
  "Computed ", $CellContext`T[{-$CellContext`a, -$CellContext`cartesian}, \
{-$CellContext`b, -$CellContext`cartesian}] -> 
   xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`cartesian}, \
{$CellContext`c, $CellContext`polar}] $CellContext`T[{-$CellContext`c, \
-$CellContext`polar}, {-$CellContext`b, -$CellContext`cartesian}], " in ", 
   0.048895`5.14080944396043, " Seconds"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"bccd393f-04b5-419f-a8bf-34e13dcf55cd"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`cartesian}, {
        0, -$CellContext`cartesian}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`cartesian}, {
        0, -$CellContext`cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`cartesian}, {
         1, -$CellContext`cartesian}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`cartesian}, {
        1, -$CellContext`cartesian}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`cartesian}, {
        0, -$CellContext`cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`cartesian}, {
         2, -$CellContext`cartesian}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`cartesian}, {
        1, -$CellContext`cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`cartesian}, {
         2, -$CellContext`cartesian}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`cartesian}, {
        2, -$CellContext`cartesian}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`cartesian}, {
        1, -$CellContext`cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          0, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`cartesian}, {
          0, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          1, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`cartesian}, {
          1, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          2, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`cartesian}, {
          2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`cartesian}, {
        2, -$CellContext`cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          0, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`cartesian}, {
          0, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          1, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`cartesian}, {
          1, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          2, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`cartesian}, {
          2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`cartesian}, {
        2, -$CellContext`cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]]},
                 {
                  StyleBox["2",
                   FontColor->RGBColor[0., 0., 1.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
           0, $CellContext`polar}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {
          1, -$CellContext`cartesian}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          1, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`cartesian}, {
          1, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          2, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`cartesian}, {
          2, -$CellContext`polar}],
         Editable->False]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`polar}, {0, -$CellContext`cartesian}],
       
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`cartesian}, {0, -$CellContext`polar}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`polar}, {0, -$CellContext`cartesian}],
       
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`cartesian}, {1, -$CellContext`polar}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`polar}, {0, -$CellContext`cartesian}],
       
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`cartesian}, {2, -$CellContext`polar}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`polar}, {1, -$CellContext`cartesian}],
       
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`cartesian}, {1, -$CellContext`polar}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`polar}, {1, -$CellContext`cartesian}],
       
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`cartesian}, {2, -$CellContext`polar}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`polar}, {2, -$CellContext`cartesian}],
       
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{2, -$CellContext`cartesian}, {2, -$CellContext`polar}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`cartesian}, {0, -$CellContext`polar}],
       
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`cartesian}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`cartesian}, {0, -$CellContext`polar}],
       
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`cartesian}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`cartesian}, {1, -$CellContext`polar}],
       
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`cartesian}],
        Editable->False]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`cartesian}, {0, -$CellContext`polar}],
       
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]]},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[0., 0., 1.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTensor`Basis[{0, -$CellContext`cartesian}, {
           1, $CellContext`polar}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`cartesian}, {
          2, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`cartesian}, {1, -$CellContext`polar}],
       
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`cartesian}, {
          0, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`cartesian}, {
          2, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`cartesian}, {2, -$CellContext`polar}],
       
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`cartesian}, {
          0, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`cartesian}, {
          1, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`cartesian}],
       
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          1, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          2, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`cartesian}, {1, -$CellContext`polar}],
       
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          0, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          2, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`cartesian}, {2, -$CellContext`polar}],
       
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          0, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          1, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`cartesian}],
       
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          1, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          2, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`cartesian}],
       
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]]},
                 {
                  StyleBox["2",
                   FontColor->RGBColor[0., 0., 1.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
           0, $CellContext`polar}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {1, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          2, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`cartesian}, {2, -$CellContext`polar}],
       
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          0, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          1, $CellContext`polar}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {2, -$CellContext`polar}],
         Editable->False]}]}]}]}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[46]=",ExpressionUUID->"05d4fd7d-8808-440e-be25-7d79a9fae2b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColumnForm", "/@", 
  RowBox[{"TensorValues", "[", 
   RowBox[{"T", ",", " ", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "cartesian"}], ",", " ", 
       RowBox[{"-", "cartesian"}]}], "}"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"bdde1cee-8adf-4e1d-aaf1-a71df7604a34"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   InterpretationBox[GridBox[{
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`cartesian}, {
          0, -$CellContext`cartesian}],
         Editable->False], "\[Rule]", "0"}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`cartesian}, {
          0, -$CellContext`cartesian}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[0., 0., 1.]], 
                  StyleBox["1",
                   FontColor->RGBColor[0., 0., 1.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{0, -$CellContext`cartesian}, {
           1, -$CellContext`cartesian}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`cartesian}, {
          1, -$CellContext`cartesian}],
         Editable->False], "\[Rule]", "0"}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`cartesian}, {
          0, -$CellContext`cartesian}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[0., 0., 1.]], 
                  StyleBox["2",
                   FontColor->RGBColor[0., 0., 1.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{0, -$CellContext`cartesian}, {
           2, -$CellContext`cartesian}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`cartesian}, {
          1, -$CellContext`cartesian}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["1",
                   FontColor->RGBColor[0., 0., 1.]], 
                  StyleBox["2",
                   FontColor->RGBColor[0., 0., 1.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{1, -$CellContext`cartesian}, {
           2, -$CellContext`cartesian}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`cartesian}, {
          2, -$CellContext`cartesian}],
         Editable->False], "\[Rule]", "0"}]}
     },
     BaselinePosition->{Baseline, {1, 1}},
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    ColumnForm[{$CellContext`T[{0, -$CellContext`cartesian}, {
        0, -$CellContext`cartesian}] -> 
      0, $CellContext`T[{1, -$CellContext`cartesian}, {
        0, -$CellContext`cartesian}] -> -$CellContext`T[{
         0, -$CellContext`cartesian}, {
         1, -$CellContext`cartesian}], $CellContext`T[{
        1, -$CellContext`cartesian}, {1, -$CellContext`cartesian}] -> 
      0, $CellContext`T[{2, -$CellContext`cartesian}, {
        0, -$CellContext`cartesian}] -> -$CellContext`T[{
         0, -$CellContext`cartesian}, {
         2, -$CellContext`cartesian}], $CellContext`T[{
        2, -$CellContext`cartesian}, {
        1, -$CellContext`cartesian}] -> -$CellContext`T[{
         1, -$CellContext`cartesian}, {
         2, -$CellContext`cartesian}], $CellContext`T[{
        2, -$CellContext`cartesian}, {2, -$CellContext`cartesian}] -> 0}],
    Editable->False], ",", 
   InterpretationBox[GridBox[{
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`cartesian}, {
          1, -$CellContext`cartesian}],
         Editable->False], "\[Rule]", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
            0, $CellContext`polar}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`cartesian}, {
            0, -$CellContext`polar}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
            1, $CellContext`polar}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`cartesian}, {
            1, -$CellContext`polar}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
            2, $CellContext`polar}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`cartesian}, {
            2, -$CellContext`polar}],
           Editable->False]}]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`cartesian}, {
          2, -$CellContext`cartesian}],
         Editable->False], "\[Rule]", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
            0, $CellContext`polar}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`cartesian}, {
            0, -$CellContext`polar}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
            1, $CellContext`polar}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`cartesian}, {
            1, -$CellContext`polar}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
            2, $CellContext`polar}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`cartesian}, {
            2, -$CellContext`polar}],
           Editable->False]}]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`cartesian}, {
          2, -$CellContext`cartesian}],
         Editable->False], "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"e", 
                StyleBox[GridBox[{
                   {" ", 
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            
            xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
             0, $CellContext`polar}],
            Editable->False]}], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], 
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`polar}, {
            1, -$CellContext`cartesian}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
            1, $CellContext`polar}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{1, -$CellContext`cartesian}, {
            1, -$CellContext`polar}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
            2, $CellContext`polar}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{1, -$CellContext`cartesian}, {
            2, -$CellContext`polar}],
           Editable->False]}]}]}]}
     },
     BaselinePosition->{Baseline, {1, 1}},
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    ColumnForm[{$CellContext`T[{0, -$CellContext`cartesian}, {
        1, -$CellContext`cartesian}] -> 
      xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          0, $CellContext`polar}] $CellContext`T[{
          0, -$CellContext`cartesian}, {0, -$CellContext`polar}] + 
       xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          1, $CellContext`polar}] $CellContext`T[{
          0, -$CellContext`cartesian}, {1, -$CellContext`polar}] + 
       xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
          2, $CellContext`polar}] $CellContext`T[{
          0, -$CellContext`cartesian}, {
          2, -$CellContext`polar}], $CellContext`T[{
        0, -$CellContext`cartesian}, {2, -$CellContext`cartesian}] -> 
      xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          0, $CellContext`polar}] $CellContext`T[{
          0, -$CellContext`cartesian}, {0, -$CellContext`polar}] + 
       xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          1, $CellContext`polar}] $CellContext`T[{
          0, -$CellContext`cartesian}, {1, -$CellContext`polar}] + 
       xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          2, $CellContext`polar}] $CellContext`T[{
          0, -$CellContext`cartesian}, {
          2, -$CellContext`polar}], $CellContext`T[{
        1, -$CellContext`cartesian}, {2, -$CellContext`cartesian}] -> -
        xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          0, $CellContext`polar}] $CellContext`T[{0, -$CellContext`polar}, {
          1, -$CellContext`cartesian}] + 
       xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          1, $CellContext`polar}] $CellContext`T[{
          1, -$CellContext`cartesian}, {1, -$CellContext`polar}] + 
       xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
          2, $CellContext`polar}] $CellContext`T[{
          1, -$CellContext`cartesian}, {2, -$CellContext`polar}]}],
    Editable->False]}], "]"}]], "Output",
 CellLabel->"Out[47]=",ExpressionUUID->"6e06991a-f01a-4b1d-abf3-24445dbdabed"]
}, Open  ]],

Cell["Clean up:", "MathCaption",ExpressionUUID->"22be9d13-4b88-494d-afe2-0b5ea855fdca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteTensorValues", "[", "T", "]"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"d394f28a-2df6-4f92-80a6-e57a1477b212"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Deleted values for tensor \"\>", "\[InvisibleSpace]", "T", 
   "\[InvisibleSpace]", "\<\", derivatives \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}], "\[InvisibleSpace]", "\<\" and bases \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "cartesian"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Deleted values for tensor ", $CellContext`T, ", derivatives ", {}, 
   " and bases ", {{-$CellContext`cartesian, -$CellContext`cartesian}}, "."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[48]:=",ExpressionUUID->"1d43e01e-f685-4e84-bcde-f47b7f46e2ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Deleted values for tensor \"\>", "\[InvisibleSpace]", "T", 
   "\[InvisibleSpace]", "\<\", derivatives \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}], "\[InvisibleSpace]", "\<\" and bases \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "cartesian"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "polar"}], ",", 
       RowBox[{"-", "cartesian"}]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Deleted values for tensor ", $CellContext`T, ", derivatives ", {}, 
   " and bases ", {{-$CellContext`cartesian, -$CellContext`polar}, \
{-$CellContext`polar, -$CellContext`cartesian}}, "."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[48]:=",ExpressionUUID->"6d74a4ee-091b-43ea-a1b3-e0a78f6648a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Deleted values for tensor \"\>", "\[InvisibleSpace]", "T", 
   "\[InvisibleSpace]", "\<\", derivatives \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}], "\[InvisibleSpace]", "\<\" and bases \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "polar"}], ",", 
      RowBox[{"-", "polar"}]}], "}"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Deleted values for tensor ", $CellContext`T, ", derivatives ", {}, 
   " and bases ", {{-$CellContext`polar, -$CellContext`polar}}, "."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[48]:=",ExpressionUUID->"a07e23cb-0852-4294-b555-dce193c9c2c9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CVVerbose", "=", "True"}], ";"}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"12dc5e47-bb9e-4b22-82f4-8c45d98d3b38"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Remove", "[", 
   RowBox[{"expr", ",", "cexpr", ",", "values"}], "]"}], ";"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"c77a3710-6030-4a1f-98ed-13582d0d7ac2"],

Cell[TextData[{
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 "  introduces new definitions to work with derivatives. Remember that each \
basis has an associated parallel derivative  (",
 StyleBox["PDbasisname",
  FontFamily->"Courier"],
 "). We can express any derivative of a Basis object in terms of Christoffel \
tensors relating that derivative to the PD of the basis"
}], "MathCaption",ExpressionUUID->"3f7d1587-b36a-47d4-a241-149ce88f0335"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDpolar", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "polar"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"4c3b3c06-8c83-49c0-a960-507076624b9a"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[51]=",ExpressionUUID->"8b3a4434-b4f9-4bf8-9226-4591feb9371a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PD", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[52]:=",ExpressionUUID->"e1815797-058d-480b-b999-4d406318716b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"\[CapitalGamma]", "[", 
       StyleBox["\[ScriptCapitalD]",
        FontColor->RGBColor[1., 0., 0.]], "]"}], 
      StyleBox[GridBox[{
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], " ", " "},
         {" ", "a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`ChristoffelPDpolar[{
   1, $CellContext`polar}, -$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[52]=",ExpressionUUID->"f5081d2e-de09-4283-97a7-e905dca5ceeb"]
}, Open  ]],

Cell["\<\
If we have a basis change a new Christoffel tensor is defined, relating the \
PDs of both bases \
\>", "MathCaption",ExpressionUUID->"ecb91872-c205-4742-b797-f4797b994364"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PD", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "polar"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"31a716f2-fd09-4bd3-b78f-533de91d313d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcartesianPDpolar", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelPDcartesianPDpolar[$CellContext`a, \
-$CellContext`b, -$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[53]:=",ExpressionUUID->"4701f45d-422f-47a8-bb2a-4308e3e6b047"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[0., 0., 1.]], ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
       StyleBox[GridBox[{
          {
           StyleBox["c",
            FontColor->RGBColor[1., 0., 0.]], " ", " "},
          {" ", "a", 
           StyleBox["b",
            FontColor->RGBColor[0., 0., 1.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ChristoffelPDcartesianPDpolar[{$CellContext`c, \
$CellContext`polar}, -$CellContext`a, {-$CellContext`b, \
-$CellContext`cartesian}],
   Editable->False]}]], "Output",
 CellLabel->"Out[53]=",ExpressionUUID->"8f129fab-91d5-42d0-bdf9-94e41b3392ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PD", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "polar"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "cartesian"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"7cfdcfe7-d3ab-4e2d-b76b-9f610261e379"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"\[CapitalGamma]", "[", 
       RowBox[{
        StyleBox["\[ScriptCapitalD]",
         FontColor->RGBColor[0., 0., 1.]], ",", 
        StyleBox["\[ScriptCapitalD]",
         FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
      StyleBox[GridBox[{
         {
          StyleBox["b",
           FontColor->RGBColor[0., 0., 1.]], " ", " "},
         {" ", "a", 
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`ChristoffelPDcartesianPDpolar[{$CellContext`b, \
$CellContext`cartesian}, -$CellContext`a, {2, -$CellContext`polar}],
  Editable->False]], "Output",
 CellLabel->"Out[54]=",ExpressionUUID->"6f9e1267-9bb7-4e88-8326-5a0d9f59b720"]
}, Open  ]],

Cell["\<\
Together with bases, the second basic ingredient in xCoba is a chart.\
\>", "Text",ExpressionUUID->"a10c5b27-6033-42db-bed7-bab45288d8db"],

Cell["We can define charts.", "MathCaption",ExpressionUUID->"d446fe09-0d34-4553-807d-b3720881bac5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"coord", ",", "M3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "]"}], ",", 
     RowBox[{"y", "[", "]"}], ",", 
     RowBox[{"z", "[", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"0d095fb1-327c-42c5-866a-bca7a0142290"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefChart", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"chart \"\>", "\[InvisibleSpace]", "coord", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefChart, ": Defining ", "chart ", $CellContext`coord, 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"653d81fe-1268-4729-bc85-ba068e3f9b84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"coordinate scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"x", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "coordinate scalar ", 
   $CellContext`x[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"ea080a89-ccfa-42db-96bc-ddd232c0b949"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"coordinate scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"y", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "coordinate scalar ", 
   $CellContext`y[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"61641c8e-7b61-4fb5-897f-a9f0fdb31b78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"coordinate scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"z", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "coordinate scalar ", 
   $CellContext`z[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"87a76052-b9a8-4a85-a828-d62e472abc2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefMapping", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"mapping \"\>", "\[InvisibleSpace]", "coord", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefMapping, ": Defining ", 
   "mapping ", $CellContext`coord, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"16a5e680-10f1-4efc-a709-d0c0f4597a04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefMapping", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse mapping \"\>", "\[InvisibleSpace]", 
   "icoord", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefMapping, ": Defining ", 
   "inverse mapping ", $CellContext`icoord, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"a2c23d75-2a74-46d3-93e6-a6c6d41e6ace"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"mapping differential tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"dicoord", "[", 
    RowBox[{
     RowBox[{"-", "\[FormalA]"}], ",", "icoorda"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "mapping differential tensor ", 
   $CellContext`dicoord[-\[FormalA], $CellContext`icoorda], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"21503220-c603-4fa6-a0f9-1d67603a07bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"mapping differential tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"dcoord", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "coord\[FormalA]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "mapping differential tensor ", 
   $CellContext`dcoord[-$CellContext`a, $CellContext`coord\[FormalA]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"7ff4550f-954c-4049-9872-b48900f67b5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "coord", 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Coordinated basis.\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`coord, 
   ". ", "Coordinated basis."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"b865fc7f-1c6b-43de-a4f0-75f7b38ad73b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDcoord", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDcoord[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"871e45cc-84bf-4480-ba62-a8d43fca531d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionPDcoord", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionPDcoord[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"577135ad-f9b4-4401-8c9c-e445019e5cd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcoord", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDcoord[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"d38d0e58-bee9-4939-a2d5-60e14719a09d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDcoord", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDcoord[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"dad99b18-e383-4184-9fdb-9588f3c47a45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDcoord", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDcoord[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"08abdb9b-1022-43fb-826d-b474b35552db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpcoord", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpcoord[$CellContext`a, $CellContext`b, $CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"0fb9fe57-0801-446b-89a7-a4b55d672406"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDowncoord", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDowncoord[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[55]:=",ExpressionUUID->"0e8bf29c-5ebd-4667-966c-fd2c9a8ab975"]
}, Open  ]],

Cell["\<\
and now fields (in particular components in any basis) can be converted into \
functions of the coordinates of any chart:\
\>", "MathCaption",ExpressionUUID->"313c7dc8-ef8e-46b0-8d37-f8471e769749"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InChart", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "cartesian"}], "}"}], "]"}], ",", "coord"}], "]"}], 
  "[", 
  RowBox[{"1", ",", "0", ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[56]:=",ExpressionUUID->"7ae2bc4c-6ebd-4dba-9517-d7415eb4c374"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    UnderscriptBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     StyleBox["_",
      FontColor->RGBColor[1, 0, 0]]],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xCoba`InChart[
    $CellContext`v[{1, $CellContext`cartesian}], $CellContext`coord],
   Editable->False], "[", 
  RowBox[{"1", ",", "0", ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Output",
 CellLabel->"Out[56]=",ExpressionUUID->"a6b266d7-aa4a-4117-acf7-2556de39da79"]
}, Open  ]],

Cell["\<\
Now the torsion tensor vanishes and the Christoffel is symmetric. Functions \
to restrict a field to a point or express it in terms of functions of the \
coordinates are currently under development.\
\>", "MathCaption",ExpressionUUID->"2bfd33a3-6e08-4938-b47c-5a724a7dda61"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefBasis", "/@", 
   RowBox[{"{", 
    RowBox[{"polar", ",", "cartesian"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"68321ca2-7f23-414c-afb7-abf188a74b94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ChristoffelPDcartesianPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`ChristoffelPDcartesianPDpolar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"bb7e4f67-71ba-452b-853c-04d121b391d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDpolar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ffd27538-732c-4be6-9c87-e95bc3599878"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDpolar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"5c70e3c2-e2bf-484d-a098-8dba8243c3d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDpolar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ca064d49-816e-4a49-9b72-57a8d7b0fd44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDpolar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"56a8ffba-8d9b-492f-a227-9df8aa88894e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDpolar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"06cf4823-e84f-4486-915f-184db3d4a3d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUppolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUppolar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"336224a1-da14-4d62-89d6-9adbbc144880"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDownpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDownpolar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ca370be2-6409-4e73-af19-f0a7486c0cc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "polar"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`polar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a44d8e29-49b0-4990-98f7-d5e4634f93fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", 
   " ", $CellContext`ChristoffelPDcartesian],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"97dad62c-b9b1-417d-9a7b-d6b9f46b8df0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDcartesian],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"45287310-1d87-43c0-b58e-963b2ac203b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "RiemannPDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDcartesian],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"0ef6116c-eecc-46d3-9dda-0c0e49a2c65f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "TorsionPDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDcartesian],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"5c5292a4-fe16-491c-af9a-b36781a3cbc1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDcartesian],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e50c0e28-cb65-4fab-b1a6-20d5660e4cae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUpcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUpcartesian],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"fe48db4d-8914-47c9-9535-5443410728d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDowncartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDowncartesian],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"349827b4-1fa2-4977-8ab1-4c33d25592c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "cartesian"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`cartesian],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"513659a9-c7c2-4ec7-bfa6-329db03b5a15"]
}, Open  ]],

Cell["Removing a complex basis also removes its complex conjugate:", \
"MathCaption",ExpressionUUID->"4fbaadb2-6371-4cd5-811a-1b7897c8e955"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefBasis", "[", "complex", "]"}], ";"}]], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"a590ad3f-c9d9-49c4-bf1d-7488a8bfff9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "AChristoffelPDcomplex\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", 
   " ", $CellContext`AChristoffelPDcomplex\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"dc943766-83b8-4439-89d0-fe8eb9ae9acb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "AChristoffelPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", 
   " ", $CellContext`AChristoffelPDcomplex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"09a69ceb-af10-4dad-b06d-06f4452f772c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDcomplex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"15b8fa77-390d-4777-a50e-3101b110f7d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "FRiemannPDcomplex\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemannPDcomplex\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"296aa4dc-1126-460c-a2b4-5f488abd5c14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "FRiemannPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemannPDcomplex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"37e5fe58-f09b-4fcf-8f5b-2510c51dbc98"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDcomplex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"1c85debc-52d8-4599-8532-b621098162cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDcomplex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"1f4f2f32-08b5-49b8-ab16-57d9f1973821"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDcomplex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"1cfcc52e-191f-445a-92b0-068fa3f69609"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDcomplex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"7211a557-6aa8-464b-aff9-bbc209e99b44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "complex\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`complex\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"fc97ca99-066d-48b1-8ee1-7204268ae5ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "etaUpcomplex\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUpcomplex\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"2c768a9c-799b-43ce-850a-2b1a2ad6734d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUpcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUpcomplex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"08442685-cf87-4aec-86c0-dc0b4b397718"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "etaDowncomplex\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDowncomplex\[Dagger]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"4fb8095b-0f81-4d0d-91ae-b7bbe895f43c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDowncomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDowncomplex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"db01699c-995a-4ec5-ba76-4603f48c148e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "complex"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`complex],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[58]:=",ExpressionUUID->"ec3c043f-f928-4b35-a6ef-3f745c4512f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefChart", "[", "coord", "]"}]], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"00d9c94f-975b-4953-8b19-06cf346ce16d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"coordinate scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "x"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "coordinate scalar", 
   " ", $CellContext`x],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"1ba5fc69-4329-4de9-94af-f515315b3267"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"coordinate scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "y"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "coordinate scalar", 
   " ", $CellContext`y],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"fc78f7d1-316f-4c86-971b-47f7ee9b3c26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"coordinate scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "z"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "coordinate scalar", 
   " ", $CellContext`z],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"abc5c53a-5899-4b71-a694-c7e9bd8ebea4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"mapping differential tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "dicoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "mapping differential tensor", " ", $CellContext`dicoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"3377ad6e-cbfe-4c77-b0e7-0336eb506fff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefMapping", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"inverse mapping\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "icoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefMapping, ": Undefined ", "inverse mapping", 
   " ", $CellContext`icoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"c525633a-f160-4d79-9a62-ddfa91e7501a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"mapping differential tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "dcoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "mapping differential tensor", " ", $CellContext`dcoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"318c1ad3-b1f5-4e03-9cea-6e51a4e19690"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDcoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDcoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"fdea89f2-606b-4569-a3c6-08ff4aeb2593"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDcoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDcoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"636301ba-057b-4b10-8784-5b6f92c82f5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDcoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDcoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"6ece7a33-4cd2-4fc6-afef-b10014b12a94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDcoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDcoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"6f23a271-ab96-4fe5-85e7-56c7fb48cf36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDcoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDcoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"448727be-dd82-4300-b79a-64ff57807ff8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUpcoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUpcoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"c2cb5e38-4c4b-4125-baf9-c34c8fdcb9fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDowncoord"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDowncoord],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[59]:=",ExpressionUUID->"9c44e4a9-cc42-4b3c-95b2-fe5d773e0fbb"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1. Real and complex bases. Basis objects and basis \
indices",
 FontSize->14]], "SubsectionIcon",
 CellTags->{
  "S5.18.1", "1.4"},ExpressionUUID->"86385e57-5f81-479d-b8c0-73ad6467ad57"],

Cell[CellGroupData[{

Cell["1.1. DefBasis", "SubsubsectionIcon",ExpressionUUID->"a8c121ed-a412-44f3-a13a-a9fd7d2138af"],

Cell["\<\
This section will explain how to define and work with new bases, without \
assuming that they have an underlying coordinate chart. \
\>", "Text",
 CellTags->{
  "S5.18.1", "1.5"},ExpressionUUID->"6ea21273-ba95-4a75-a84b-683255bd3833"],

Cell[TextData[{
 StyleBox["DefBasis\t\t\t", "DisplayMath"],
 StyleBox["Define a basis", "Text"],
 StyleBox["\nVBundleOfBasis\t\t", "DisplayMath"],
 StyleBox["VBundle on which a basis lives\n", "Text"],
 StyleBox["PDOfBasis\t\t\t", "DisplayMath"],
 StyleBox["Parallel derivative associated to the given basis\n", "Text"],
 StyleBox["$Bases\t\t\t\t", "DisplayMath"],
 StyleBox["List of currently defined bases\n", "Text"],
 StyleBox["BasisQ\t\t\t\t", "DisplayMath"],
 StyleBox["Check existence of a given basis name", "Text"]
}], "DefinitionBox",ExpressionUUID->"a204ebe7-8a70-466f-b93e-31f2286ed32e"],

Cell["Definition of a basis.", "SmallText",ExpressionUUID->"061818b3-e6ff-40f8-b9bb-0589f86c83f6"],

Cell["\<\
To define a basis we only have to provide a name, a vector bundle and a list \
of cnumbers (whose lenght must be the dimension of the bundle). The cnumbers \
can include 0 and even negative integers.\
\>", "MathCaption",
 CellTags->{
  "S5.18.1", "1.6"},ExpressionUUID->"1b913b5b-14e7-4071-af65-bf81fe188bf6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"polar", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[60]:=",ExpressionUUID->"c2ec987c-3aab-44cd-bc09-7bfa61defc86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "polar", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`polar, 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"9f6114ac-3834-4e19-a57f-31faaa71ee54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDpolar", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDpolar[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"d2d9d2bf-3774-4d41-8f51-aa0bbf84abd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDpolar", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDpolar[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"04ef41c6-dfce-4fca-91a9-dc2afd19042f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDpolar", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDpolar[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"e8125314-ebeb-470d-926d-395a9e0b6e96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDpolar", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDpolar[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"ee0cb041-3da6-48b2-b01b-f0d7fdfb5c4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDpolar", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDpolar[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"f1038bbd-406b-47de-b111-01d981b0635f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUppolar", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUppolar[$CellContext`a, $CellContext`b, $CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"362b3970-b232-4734-a496-64b64dfad9a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownpolar", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownpolar[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"b4642910-13e6-4dc5-976a-aeab95fc9154"]
}, Open  ]],

Cell["\<\
As we can see, several other objects are automatically defined: the parallel \
derivative and its torsion, Christoffel, Riemann and Ricci tensors. We shall \
say more about them in Section 3.\
\>", "MathCaption",
 CellTags->{
  "S5.18.1", "1.7"},ExpressionUUID->"f50dbadd-96cf-49cb-b613-f6c7131614b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDOfBasis", "[", "polar", "]"}]], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"64d49cf8-473b-4b55-aed2-ceadd1bec358"],

Cell[BoxData["PDpolar"], "Output",
 CellLabel->"Out[61]=",ExpressionUUID->"e2f3e5d5-c293-49d0-8360-684050dc7f18"]
}, Open  ]],

Cell["\<\
Each basis has a colour, used to identify its associated indices and objects \
in StandardForm. The default for new bases is red, but we can specify a \
different one:\
\>", "MathCaption",ExpressionUUID->"f4b5fb15-fa95-40f5-af81-04cddf29abc6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"cartesian", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", " ", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "1", ",", "0"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[62]:=",ExpressionUUID->"5b5205ac-cdcd-453f-b226-1215b1249018"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "cartesian", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`cartesian,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"defabc9c-6639-49b9-886c-1ca837d452e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDcartesian", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDcartesian[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"f172f4c8-0792-4d0e-ad33-15855c679f56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDcartesian", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDcartesian[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"af64bf56-7141-447f-b9a8-3d11c52601f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcartesian", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDcartesian[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"a1d831c0-1101-43b9-b1c8-e70852dc1520"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDcartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDcartesian[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"57b73c22-93d8-4643-9be2-f3007247db1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDcartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDcartesian[-$CellContext`a, -$CellContext`b], ". ", ""],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"d581ee9b-d7ac-4991-b0f9-2b15970654ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpcartesian", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpcartesian[$CellContext`a, $CellContext`b, \
$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"9382bd3f-f894-4f11-83e2-0d65f7588341"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDowncartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDowncartesian[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"a331b758-278b-427a-a4ed-943393bc2356"]
}, Open  ]],

Cell["\<\
We  can to give different cnumbers to two bases on the same vbundle. A basis \
has several associated definitions and UpValues:\
\>", "MathCaption",ExpressionUUID->"588ab9ea-12b6-4cd9-be95-2b53ccebebd7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "polar"}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"9bfb9365-41e0-450e-9e89-c458ee1bfa00"],

Cell["Global`polar", "Print", "PrintUsage",
 CellTags->
  "Info633728140812-3828762",ExpressionUUID->"e622bd82-5267-4325-96f9-\
10e3e8f66cf9"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"BasisColor", "[", "polar", "]"}], "^=", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"1", ",", "0", ",", "0"}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"BasisQ", "[", "polar", "]"}], "^=", "True"}]},
       {" "},
       {
        RowBox[{"polar", "/:", 
         RowBox[{"CNumbersOf", "[", 
          RowBox[{"polar", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False]}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "2"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "polar", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`polar],
          Editable->False], "^=", "polar"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "polar", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"basis\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfBasis", "[", "polar", "]"}], "^=", 
         RowBox[{"{", "M3", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"etaOrientation", "[", "polar", "]"}], "^=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "polar", "]"}], "^=", 
         RowBox[{"{", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PDOfBasis", "[", "polar", "]"}], "^=", "PDpolar"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ServantsOf", "[", "polar", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"PDpolar", ",", "etaUppolar", ",", "etaDownpolar"}], 
          "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"VBundleOfBasis", "[", "polar", "]"}], "^=", 
         InterpretationBox[
          StyleBox["\[DoubleStruckCapitalT]M3",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`TangentM3,
          Editable->False]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`polar],
  Editable->False]], "Print",
 CellTags->
  "Info633728140812-3828762",ExpressionUUID->"2bfb26f5-7e83-4936-9fe7-\
a37aab90ed13"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], "Input",
 CellLabel->"In[64]:=",ExpressionUUID->"284de3dd-8b5c-47e4-a943-90d6d74f0e55"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"polar", ",", "cartesian"}], "}"}]], "Output",
 CellLabel->"Out[64]=",ExpressionUUID->"9f7a8b1f-9ecf-4757-b2bd-c68c798ae56f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Basis objects and basis indices", "SubsubsectionIcon",ExpressionUUID->"7883ce9d-6f1e-4b4c-826d-d82119e15c0c"],

Cell[TextData[{
 "Now that we have bases, we can use basis vectors and work with tensor \
componentes.  Two new kinds of indices are needed:\n\t ",
 StyleBox["{a, basisname}",
  FontFamily->"Courier"],
 " :  Basis index (",
 StyleBox["BIndex",
  FontFamily->"Courier"],
 "),  ",
 StyleBox["a",
  FontFamily->"Courier"],
 " is an abstract index.\n\t ",
 StyleBox["{i, basisname}",
  FontFamily->"Courier"],
 " :  Component index (",
 StyleBox["CIndex",
  FontFamily->"Courier"],
 "), ",
 StyleBox["i",
  FontFamily->"Courier"],
 " is a valid coordinate number.\nWhen we define a basis in the tangent \
bundle, its dual in the cotangent bundle is also automatically defined. This \
dual basis is called -basisname and has the same cnumbers as the original. \
The notation for covariant bc-indices is \n\t",
 StyleBox["{-a, -basisname}",
  FontFamily->"Courier"],
 " :  Basis index (",
 StyleBox["BIndex",
  FontFamily->"Courier"],
 "),  ",
 StyleBox["a",
  FontFamily->"Courier"],
 " is an abstract index.\n\t",
 StyleBox["{i,  -basisname}",
  FontFamily->"Courier"],
 " :  Component index (",
 StyleBox["CIndex",
  FontFamily->"Courier"],
 "), ",
 StyleBox["i",
  FontFamily->"Courier"],
 " is a valid coordinate number.\nNotice how a covariant b-index is -1 * \
(corresponding contravariant index), but this is not true for c-indices. This \
apparent inconsistency is a conscious choice: it allows us to use zero and \
negative cnumbers (the latter being common in treatments of angular momentum, \
tensor harmonics, etc.)\n\nNOTE: In versions 0.3 and 0.4 we used b-indices \
like {a, polar}, {-a, polar} and c-indices like {1, polar} and {-1, polar}. \
This notational change is ",
 StyleBox["not",
  FontSlant->"Italic"],
 " backwards compatible. We apologize to those users of ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 " who now need to change lots of signs in previously developed notebooks, \
but we feel that the use of this new notation will pay off."
}], "Text",ExpressionUUID->"225c0d65-6dec-4c7f-aeb8-0a7353325878"],

Cell["Several functions are provided to check the validity.", "MathCaption",ExpressionUUID->"536dc41c-e7b4-4863-968d-339931e28a80"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"587060d8-a9c0-4eb1-8df3-ad17ce14a4b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"f1", ",", "f2", ",", "f3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[65]=",ExpressionUUID->"f2d32c34-10af-4a73-806e-8cdf41533117"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"indexlist", "=", 
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "polar"}], "}"}], ",", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"w", ",", "polar"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"A", ",", "polar"}], "}"}], " ", ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}], ",", "   ", "a", " ", ",", "  ", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"a", ",", "spherical"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"5", ",", "polar"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"d4b0cb4a-45b6-4991-a4c1-ca8aae86f333"],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], "Input",
 CellLabel->"In[67]:=",ExpressionUUID->"73543f66-ce0c-41c3-8759-deacdeff54c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"polar", ",", "cartesian"}], "}"}]], "Output",
 CellLabel->"Out[67]=",ExpressionUUID->"277e5372-e40b-4f2f-8779-01db72fec75e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BIndexQ", "/@", " ", "indexlist"}]], "Input",
 CellLabel->"In[68]:=",ExpressionUUID->"32dc7866-a948-4db3-8202-b25604fd70b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "False", ",", "True", ",", "False", ",", "False", 
   ",", "False", ",", "False", ",", "False", ",", "False"}], "}"}]], "Output",\

 CellLabel->"Out[68]=",ExpressionUUID->"87d57181-2a52-4fba-9a75-81fe6711d6c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CIndexQ", " ", "/@", " ", "indexlist"}]], "Input",
 CellLabel->"In[69]:=",ExpressionUUID->"58c5b5e2-6c70-47e7-b949-f203cb85b8c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
   "False", ",", "True", ",", "False", ",", "False", ",", "False"}], 
  "}"}]], "Output",
 CellLabel->"Out[69]=",ExpressionUUID->"6641cc49-0fa8-411b-889f-7802399bba7b"]
}, Open  ]],

Cell["An extra function selects both basis and component indices,", \
"MathCaption",ExpressionUUID->"8e17a1d0-fcfa-45a7-88e1-e8335e2d68e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BCIndexQ", " ", "/@", " ", "indexlist"}]], "Input",
 CellLabel->"In[70]:=",ExpressionUUID->"0c9a0486-7d17-47ea-a628-990f4e38afee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "False", ",", "True", ",", "True", ",", "False", 
   ",", "True", ",", "False", ",", "False", ",", "False"}], "}"}]], "Output",
 CellLabel->"Out[70]=",ExpressionUUID->"d4798776-75bd-410b-a564-db1cebd78c94"]
}, Open  ]],

Cell[TextData[{
 "On ocassion, it is interesting to know whether an index is either an ",
 StyleBox["AIndex",
  FontFamily->"Courier"],
 " or a ",
 StyleBox["BIndex",
  FontFamily->"Courier"],
 ". Those are the only types that may be contracted, which makes them \
important for functions such as ",
 StyleBox["ContractBasis",
  FontFamily->"Courier"],
 ". We will call them `contractible indices'."
}], "MathCaption",ExpressionUUID->"129c6ba2-51dd-4a92-9ef7-b79a233f7ea6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ABIndexQ", " ", "/@", " ", "indexlist"}]], "Input",
 CellLabel->"In[71]:=",ExpressionUUID->"ea5d79e8-f11c-4409-8f0f-490801d63df1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "False", ",", "True", ",", "False", ",", "True", 
   ",", "False", ",", "False", ",", "False", ",", "False"}], "}"}]], "Output",\

 CellLabel->"Out[71]=",ExpressionUUID->"2e809b69-1a33-4ae2-8b94-9d084057ecf6"]
}, Open  ]],

Cell[TextData[{
 "Notice that we can get a ",
 StyleBox["False",
  FontFamily->"Courier"],
 " output for several reasons: The basis, abstract index or cnumber might not \
exist or they might belong to different vbundles."
}], "MathCaption",ExpressionUUID->"444eeeea-77d5-4d25-a3ad-21940ae1a5b2"],

Cell[TextData[{
 StyleBox["If we use these indices inside of tensors, ", "Text"],
 StyleBox["Mathematica", "Text",
  FontSlant->"Italic"],
 StyleBox[" will display them according to ", "Text"],
 StyleBox["BasisColor", "Text",
  FontFamily->"Courier"],
 StyleBox[",", "Text"]
}], "Text",ExpressionUUID->"eebf6268-a2c4-4344-8477-950d6fc8c617"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}], " ", 
  RowBox[{"v", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "polar"}], "}"}], "]"}], " "}]], "Input",
 CellLabel->"In[72]:=",ExpressionUUID->"268191a3-370e-44fb-995b-3764026a42ee"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[{1, -$CellContext`cartesian}, {2, -$CellContext`cartesian}],
   
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {
           StyleBox["a",
            FontColor->RGBColor[1., 0., 0.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{$CellContext`a, $CellContext`polar}],
   Editable->False]}]], "Output",
 CellLabel->"Out[72]=",ExpressionUUID->"30884ef6-1b1b-4c84-a042-b29a7c776379"]
}, Open  ]],

Cell[TextData[{
 "Objects like those in the previous output can be seen as contractions of \
the tensor with some kind of basis object. ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 " provides ",
 StyleBox["Basis",
  FontFamily->"Courier"],
 ", a 1-covariant, 1-contravariant symmetric tensor. Its meaning depends on \
the type of indices used: \n\t- ",
 StyleBox["Basis[ AIndex, BCIndex]",
  FontFamily->"Courier"],
 " :\tBasis vector (or dual basis covector).\n\t- ",
 StyleBox["Basis[ AIndex, AIndex]",
  FontFamily->"Courier"],
 ": \tIdentity tensor in the corresponding vbundle (turns into \[Delta]).\n\t\
- ",
 StyleBox["Basis[ BCIndex, BCIndex]",
  FontFamily->"Courier"],
 ":\tIf the indices belong to different bases, it represents a basis change.\n\
\t\t\t\t\t\tIf they belong to the same basis, we have a Kronecker delta \
(products of the elements of dual bases)."
}], "Text",ExpressionUUID->"d34d2147-8c98-4d66-b59f-1f302fc13ae7"],

Cell[TextData[{
 "Basis is output as an ",
 StyleBox["e",
  FontFamily->"Courier"],
 ". If both indices are abstract, a different symbol (\[Delta]) is used. The \
reason for this is twofold: mathematical and computational. Basis has a lot \
of associated rules and definitions; if we added to them those of \[Delta], \
we would have to perform many checks each time one of these objects appeared, \
thus slowing down  the operation."
}], "MathCaption",ExpressionUUID->"76a5a604-83dc-4878-831c-146276a3514a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "cartesian"}], "}"}]}], "]"}], ",", "  ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[73]:=",ExpressionUUID->"468fa3bd-ce86-4aa7-ad63-104127e19477"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "b"},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`a, $CellContext`b],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["b",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["a",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`cartesian}, \
{$CellContext`b, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["b",
             FontColor->RGBColor[0., 1., 0.]]},
           {
            StyleBox["a",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`cartesian}, \
{$CellContext`b, $CellContext`cartesian}],
    Editable->False], ",", "1", ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[73]=",ExpressionUUID->"436d1743-4c24-4ceb-8902-ad99ae57af1c"]
}, Open  ]],

Cell["\<\
A Basis object with two indices of the same character is converted into a \
metric tensor. If we  have defined more than one metric, the first one is \
used (see xTensorDoc.nb for details)\
\>", "MathCaption",ExpressionUUID->"ddd22766-b3c0-42af-a36b-3184ffae9202"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}]}]], "Input",
 CellLabel->"In[74]:=",ExpressionUUID->"c578bbd3-765d-4ce0-adc2-c97919d73d2b"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle","missing",
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M3\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM3, \
Rule[Editable, False]]\\).\"",2,74,5,19248065981107874568,"Local",
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[74]:=",ExpressionUUID->"aff4cb03-a1fa-42ec-89e4-ab0a84c76bf1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"metricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"SymbolOfCovD", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}]}], ",", 
   RowBox[{"PrintAs", "->", "\"\<g\>\""}]}], "]"}]], "Input",
 CellLabel->"In[75]:=",ExpressionUUID->"adf56673-76fc-41bd-93bf-ad8c5a2b94f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"metricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`metricg[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"449cc916-4b81-4e45-8caf-33015f61dbe3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilonmetricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilonmetricg[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"5370b807-fcb4-4d97-86a5-a4b0ebcbdb58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"aaa484bd-d0e6-46be-8bc7-cbb0144e6dd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"5a114448-5c0c-476c-8007-27da81f48b40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"21c57ac0-dd2e-4e57-a1aa-71a7cc42abbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"d7d3f966-db4d-4ab2-b973-a2662f51a6e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"d20998cf-ca61-411d-a5dd-845c40a3885b"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"3c176eb1-c5bc-4e2e-aefb-2228aed115b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"a7cc0429-b818-4405-b2f7-3a9e1b2e5af2"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"a6ab9360-5bfc-4d48-bbdf-e3e6b71f7cc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"f74d2c93-cd4c-4f36-8a50-3a3b3e3bf7df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"297659b3-5c9c-4216-b8d7-6755525c40b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"6b6b10b6-2c1d-49c6-8931-55a983190503"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"adc8f64b-2393-44e2-8588-0727ae34c906"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 3],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"441c6193-6eae-438f-9a49-083b9451815c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 3],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"fbf7d61b-ba39-4cb5-b0ba-c11c8336f5c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 3],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"f4a33daf-d15f-480f-8b5b-36ac719007df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detmetricg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detmetricg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"30b022aa-a820-43ec-a341-13f0c2224531"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "cartesian"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "cartesian"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "cartesian"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "polar"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[76]:=",ExpressionUUID->"030e90da-d725-49ed-9995-ef89684cd6c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metricg[-$CellContext`a, -$CellContext`b],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {
            StyleBox["a",
             FontColor->RGBColor[0., 1., 0.]], 
            StyleBox["b",
             FontColor->RGBColor[0., 1., 0.]]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metricg[{$CellContext`a, $CellContext`cartesian}, \
{$CellContext`b, $CellContext`cartesian}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {
            StyleBox["a",
             FontColor->RGBColor[0., 1., 0.]], 
            StyleBox["b",
             FontColor->RGBColor[1., 0., 0.]]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metricg[{$CellContext`a, $CellContext`cartesian}, \
{$CellContext`b, $CellContext`polar}],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[76]=",ExpressionUUID->"1ef72df8-6af1-4826-9cea-63f43170e09c"]
}, Open  ]],

Cell["\<\
Now other index configurations are allowed, but transformed automatically \
into the original down-up configuration:\
\>", "MathCaption",ExpressionUUID->"eef2cdde-1048-4cb2-bd37-94b0ab1e03a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "polar"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[77]:=",ExpressionUUID->"08565ed1-7cb9-4ead-a740-a5523f686629"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "a"},
           {"b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`b, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["a",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["b",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`cartesian}, \
{$CellContext`a, $CellContext`polar}],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[77]=",ExpressionUUID->"fbd4bca5-0fc9-4c2f-a5ce-0611d91fb74e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "polar"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "cartesian"}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[78]:=",ExpressionUUID->"ba477352-b254-44b7-bfd8-56f7ed5f643b"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    InterpretationBox[
     StyleBox[
      RowBox[{"(", "1", ",", "2", ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPerm`Cycles[{1, 2}],
     Editable->False], "]"}]}], "]"}]], "Output",
 CellLabel->"Out[78]=",ExpressionUUID->"ec5a6e62-de86-496a-ae28-3f3e5c8b9fdb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefMetric", "[", "metricg", "]"}]], "Input",
 CellLabel->"In[79]:=",ExpressionUUID->"824892bd-03f6-421f-811c-8a38c1b6e85c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Detmetricg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "weight +2 density", 
   " ", $CellContext`Detmetricg],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"6f4c690c-8495-486c-a543-a7fb3a90c07e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"fb01d0d5-f31a-4d7d-a630-1613c4463a24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "EinsteinCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Einstein tensor", " ", $CellContext`EinsteinCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"df8cbdcd-2d95-4cb5-ad51-4754d9f9ffc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "KretschmannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Kretschmann scalar", 
   " ", $CellContext`KretschmannCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"3f3801ab-88fc-412a-b990-163ac66967f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric Ricci tensor", 
   " ", $CellContext`RicciCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"de7abaf4-4122-428a-91ad-c5808a7d3bcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciScalarCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci scalar", 
   " ", $CellContext`RicciScalarCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"4515e5a5-92ce-49df-9ac0-06034c155aaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"fcc70d0a-34c0-4318-a00c-f9c370368e70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TFRicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric TFRicci tensor",
    " ", $CellContext`TFRicciCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"da6bdfbb-d764-48f4-a796-271e69d2b52f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"457e7e5f-833d-4a0c-a3f1-fbd4db8b3d07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "WeylCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl tensor", 
   " ", $CellContext`WeylCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"aedc6898-02ec-42ea-a937-bcc689545056"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"fa4aa69e-eae9-497d-8300-ec3d2d3617a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "epsilonmetricg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric tensor", 
   " ", $CellContext`epsilonmetricg],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"13ec2e03-c474-4713-a8e4-fa68919c647a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "metricg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric metric tensor", 
   " ", $CellContext`metricg],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"9a0fa638-ab86-44a1-b192-cd80ee13b8fa"]
}, Open  ]],

Cell["\<\
Basis is considered to be a tensor whose master is Symbol, so it cannot be \
undefined:\
\>", "MathCaption",ExpressionUUID->"d2ca40a6-8be7-49b9-90cc-ebe5e6d31bfa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTensorQ", "[", "Basis", "]"}]], "Input",
 CellLabel->"In[80]:=",ExpressionUUID->"dac3c695-c2c7-4a8a-b803-c698bd4c3fa0"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[80]=",ExpressionUUID->"8fd8008e-7bae-40a5-9c5e-e04a70be3081"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MasterOf", "[", "Basis", "]"}]], "Input",
 CellLabel->"In[81]:=",ExpressionUUID->"c69d5739-836b-4e1c-a08d-588bbde19b69"],

Cell[BoxData["Symbol"], "Output",
 CellLabel->"Out[81]=",ExpressionUUID->"31bf63ab-804c-4c81-89ca-069d3e2e3ee2"]
}, Open  ]],

Cell["\<\
The bracket of two basis vector fields is automatically converted into a \
torsion tensor (structure coefficients). This tensor is associated with the \
PD of the basis\
\>", "MathCaption",ExpressionUUID->"afd527be-f952-4cce-b3ed-a5be896194ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Torsion", "[", "cartesian", "]"}]], "Input",
 CellLabel->"In[82]:=",ExpressionUUID->"fd8f0152-d5ca-4da9-a670-4207216e7ccf"],

Cell[BoxData["TorsionPDcartesian"], "Output",
 CellLabel->"Out[82]=",ExpressionUUID->"a8907497-7dbc-42a0-ad88-6034bd783fff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Bracket", "[", "a", "]"}], "[", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "b"}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "c"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[83]:=",ExpressionUUID->"d618f47f-53ac-4622-aab0-a9312bae8560"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Bracket", "[", "a", "]"}], "[", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "b"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`b],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`c],
    Editable->False]}], "]"}]], "Output",
 CellLabel->"Out[83]=",ExpressionUUID->"01a14bbc-b1c9-43ab-babc-d4ad6bd9addd"]
}, Open  ]],

Cell[TextData[{
 "If and only if the basis is coordinated, its torsion tensor will be ",
 StyleBox["Zero",
  FontFamily->"Courier"],
 "."
}], "MathCaption",ExpressionUUID->"714b2721-ea93-4bf5-affd-c3b9f8ba698d"],

Cell[TextData[{
 StyleBox["Basis",
  FontFamily->"Courier"],
 " and ",
 StyleBox["Dir",
  FontFamily->"Courier"],
 " act as inverses of each other"
}], "MathCaption",ExpressionUUID->"f2ae76fc-7560-46ee-a7b6-829e61f9f246"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dir", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[84]:=",ExpressionUUID->"71005db8-5dd4-4d14-b9af-e20758159a12"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "polar"}], "}"}]], "Output",
 CellLabel->"Out[84]=",ExpressionUUID->"25d3a3de-df8e-49ab-a06b-4fe4fa63c3ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"Dir", "[", 
    RowBox[{"v", "[", "a", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[85]:=",ExpressionUUID->"a2eedcf1-0da5-400a-93c9-8ea6c4278b6d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{1, $CellContext`polar}],
  Editable->False]], "Output",
 CellLabel->"Out[85]=",ExpressionUUID->"9d8c954d-c9ba-4ee8-aa92-4a7f58f78703"]
}, Open  ]],

Cell["\<\
An important issue is when to contract Basis objects with other tensors and \
with one another:\
\>", "MathCaption",ExpressionUUID->"559dd06d-60d4-449f-9b2b-128865ba1876"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "/@", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "cartesian"}]}], "}"}], ",", "a"}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "polar"}], "}"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "polar"}], "}"}]}], "]"}]}]}], "}"}], 
  " "}]], "Input",
 CellLabel->"In[86]:=",ExpressionUUID->"6c5caee3-0d93-45be-8241-a5e44aed8f86"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["b",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["c",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`c, -$CellContext`cartesian}, \
{$CellContext`b, $CellContext`polar}],
    Editable->False], ",", "1", ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "a"},
           {"c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`c, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[86]=",ExpressionUUID->"a9a6230a-8479-41b7-8041-1024b6324ee0"]
}, Open  ]],

Cell[TextData[{
 "It would be desirable to automatize this behaviour sometimes. We can do it \
with the command ",
 StyleBox["AutomaticBasisContractionStart[]",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"ae04f47c-7779-45d2-a8ff-6c1756179d6c"],

Cell[TextData[{
 StyleBox["AutomaticBasisContractionStart\t\t", "DisplayMath"],
 StyleBox["Start automatic contraction of Basis objects", "Text"],
 StyleBox["\nAutomaticBasisContractionStop\t\t", "DisplayMath"],
 StyleBox["Stop automatic contraction of Basis objects", "Text"]
}], "DefinitionBox",ExpressionUUID->"3c54f885-109b-4734-90ee-89cccb8c4639"],

Cell["Contraction of Basis objects", "SmallText",ExpressionUUID->"62a19e41-3d53-4baf-b6d8-2693966b5396"],

Cell[BoxData[
 RowBox[{"AutomaticBasisContractionStart", "[", "]"}]], "Input",
 CellLabel->"In[87]:=",ExpressionUUID->"c4f766fd-2ed4-4910-97f5-65ffeb5631e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "cartesian"}]}], "}"}], ",", "a"}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "polar"}], "}"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "polar"}], "}"}]}], "]"}]}]}], "}"}], 
  " "}]], "Input",
 CellLabel->"In[88]:=",ExpressionUUID->"2fbe94f4-4d1b-4784-a55c-b1cbdd7c364b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["b",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["c",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`c, -$CellContext`cartesian}, \
{$CellContext`b, $CellContext`polar}],
    Editable->False], ",", "1", ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "a"},
           {"c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`c, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[88]=",ExpressionUUID->"90e882a0-4c23-4dc1-b063-c2e714cce63e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"AutomaticBasisContractionStop", "[", "]"}]], "Input",
 CellLabel->"In[89]:=",ExpressionUUID->"0af93778-d4a6-4e12-b277-a1c839f8ca7a"],

Cell["\<\
When the contraction is between a Basis object and a different tensor, it is \
only performed if the former is a formal Kronecker delta or an identity \
tensor,\
\>", "MathCaption",ExpressionUUID->"5781a117-9b27-41d3-b919-37216dd0c452"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "b"}], "]"}], 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], " ", 
    RowBox[{"v", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "cartesian"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[90]:=",ExpressionUUID->"c210dfb2-afb9-46f3-a745-60fff0813869"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`a, -$CellContext`c],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["a",
             FontColor->RGBColor[1., 0., 0.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{-$CellContext`a, -$CellContext`polar}],
    Editable->False], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "b"},
            {
             StyleBox["a",
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {" "},
            {"b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[-$CellContext`b],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["b",
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 1., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`cartesian}, \
{$CellContext`b, $CellContext`polar}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["b",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{-$CellContext`b, -$CellContext`polar}],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->"Out[90]=",ExpressionUUID->"7457b3ef-2a31-4430-ab4a-6585a3030dfa"]
}, Open  ]],

Cell["\<\
To force the contraction in the last two cases we need a new function (next \
section). Notice how the third contraction is equivalent to expressing a \
tensor in its components and the fourth represents a basis change. \
\>", "MathCaption",ExpressionUUID->"afc732bd-e4d0-4f84-86fc-025f87d783b6"],

Cell["\<\
We can define a special name  for the elements of one particular basis. \
\>", "Text",ExpressionUUID->"97a4ad94-1860-4290-af3b-c6e824da2462"],

Cell[BoxData[
 RowBox[{"FormatBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", "\"\<n\>\""}], "]"}]], "Input",
 CellLabel->"In[91]:=",ExpressionUUID->"642d0f71-619f-4f53-b444-a151fe89bc4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[92]:=",ExpressionUUID->"f4b7b0ee-0d87-4a63-9e33-8eed6897eb48"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"n", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"n", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 1., 0.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {1, $CellContext`polar}],
    
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {2, $CellContext`polar}],
    
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[92]=",ExpressionUUID->"120e6937-7cb3-4498-bcbc-e87520cc3e54"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"FormatBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "polar"}], "}"}], ",", "\"\<l\>\""}], "]"}]], "Input",
 CellLabel->"In[93]:=",ExpressionUUID->"7a64673b-5605-4ea8-916c-bdfaed8ea27b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[94]:=",ExpressionUUID->"de4efe2a-1ed1-42c8-99e1-d829a5090ffc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"n", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"l", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"n", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 1., 0.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {1, $CellContext`polar}],
    
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"l", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 1., 0.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {2, $CellContext`polar}],
    
    Editable->False]}], "}"}]], "Output",
 CellLabel->"Out[94]=",ExpressionUUID->"89b9ea4d-b7e9-460d-97fb-a6ad3138dc71"]
}, Open  ]],

Cell["We remove the special names:", "MathCaption",ExpressionUUID->"3961005f-d594-472d-a0a8-f641e0c1f219"],

Cell[BoxData[{
 RowBox[{"FormatBasis", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "polar"}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FormatBasis", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "polar"}], "}"}], "]"}]}], "Input",
 CellLabel->"In[95]:=",ExpressionUUID->"c2d9f1d9-d136-44b0-8428-cecbe9730339"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. Bases on inner bundles and complex bases", "SubsubsectionIcon",ExpressionUUID->"ad588e59-8951-4a3e-ae93-8d65e3ea4266"],

Cell[TextData[{
 "Starting with version 0.9, ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 "  is capable of dealing with complex tensors and vector bundles. The \
function ",
 StyleBox["DefBasis",
  FontFamily->"Courier"],
 " has been extended accordingly and it now allows the user to define complex \
bases, through the option ",
 StyleBox["Dagger, ",
  FontFamily->"Courier"],
 "taking the values ",
 StyleBox["Real",
  FontFamily->"Courier"],
 " or ",
 StyleBox["Complex",
  FontFamily->"Courier"],
 ". A basis on a real vbundle is real by default:"
}], "Text",ExpressionUUID->"0358f8a9-76cc-4ae8-b6ae-4d70b6cd4a68"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "polar", "]"}]], "Input",
 CellLabel->"In[97]:=",ExpressionUUID->"116011f7-42f4-407e-b277-46c132541d53"],

Cell[BoxData["polar"], "Output",
 CellLabel->"Out[97]=",ExpressionUUID->"e028c2a2-f4a3-42fb-810e-250b97883a1b"]
}, Open  ]],

Cell["\<\
But let us see what happens when we define one on a complex bundle,\
\>", "Text",ExpressionUUID->"9fcdcbff-e456-4f29-a900-bb73000f05da"],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], "Input",
 CellLabel->"In[98]:=",ExpressionUUID->"6e4346ad-9575-41b4-8d31-d5fcedfe1699"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"polar", ",", "cartesian"}], "}"}]], "Output",
 CellLabel->"Out[98]=",ExpressionUUID->"3b252d3d-6430-4d5c-abb9-b636f3792602"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"comp", ",", "InnerC", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"+", "1"}]}], "}"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", " ", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[99]:=",ExpressionUUID->"1ab94e36-e437-4575-ba98-2bcc75ddb04f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "comp", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`comp, 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"949d7f4f-6197-462a-8eb9-714cde930226"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDcomp", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDcomp[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"23d4435e-193e-40da-b709-8f912270824a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDcomp", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDcomp[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"fc5e04d8-6da1-4562-a24d-197ef12b7a98"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcomp", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDcomp[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"437eef1c-5f82-4070-ad2d-7e97ed537d32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDcomp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDcomp[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"945a48cc-fd9f-4994-a4bb-e6a95092267b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDcomp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDcomp[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"8cf83017-6e5f-4fa8-bee8-6b1f1cac3f01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDcomp", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDcomp[$CellContext`A, -$CellContext`b, -C], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"db22691f-6272-4ac0-9343-4d2e3c82c77a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDcomp\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDcomp\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"5b00e0e2-31f5-4237-93b0-a32f0b71125d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDcomp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDcomp[-$CellContext`a, -$CellContext`b, -C, D], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"eabec876-14c9-4faa-8d8e-28e3b6d6241a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDcomp\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDcomp\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"0f048371-0f10-40af-9daa-2f08b5ea4eab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", 
   "comp\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", 
   "basis ", $CellContext`comp\[Dagger], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"6c4c9c29-07b1-41e1-8128-e61b3fee6622"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpcomp", "[", 
    RowBox[{"A", ",", "B"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpcomp[$CellContext`A, $CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"2e87785c-2a17-4387-9d67-5cc285b05a0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpcomp\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "B\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpcomp\[Dagger][$CellContext`A\[Dagger], $CellContext`B\
\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"67eb3983-1fb4-4a25-8fe4-9b192bcba2e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDowncomp", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDowncomp[-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"627abb00-f701-47c6-b8d1-576666108ec0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDowncomp\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDowncomp\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[99]:=",ExpressionUUID->"e8e8be18-ecca-4a78-84dd-6130b6371d98"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], "Input",
 CellLabel->
  "In[100]:=",ExpressionUUID->"f096b0d0-eb4b-4c4a-90ca-80a3e343c1ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"polar", ",", "cartesian", ",", "comp", ",", "comp\[Dagger]"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[100]=",ExpressionUUID->"086bddb0-7372-4a80-b45d-1b232eacc14f"]
}, Open  ]],

Cell["\<\
A conjugate basis has also appeared on the conjugate manifold:\
\>", "Text",ExpressionUUID->"48eceb47-8d82-4491-9731-a9bb32511f7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "/@", 
  RowBox[{"{", 
   RowBox[{"comp", ",", "comp\[Dagger]"}], "}"}]}]], "Input",
 CellLabel->
  "In[101]:=",ExpressionUUID->"8e18fc1a-a81f-41ee-b09f-83a64b62a11e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"comp\[Dagger]", ",", "comp"}], "}"}]], "Output",
 CellLabel->
  "Out[101]=",ExpressionUUID->"f0256d4d-d113-4233-91b1-c1745e01fc8d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VBundleOfBasis", "/@", 
  RowBox[{"{", 
   RowBox[{"comp", ",", "comp\[Dagger]"}], "}"}]}]], "Input",
 CellLabel->
  "In[102]:=",ExpressionUUID->"0b33ed36-0ed6-4b22-bfd8-24aa09f7868d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox["InnerC",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC,
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["InnerC\[Dagger]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC\[Dagger],
    Editable->False]}], "}"}]], "Output",
 CellLabel->
  "Out[102]=",ExpressionUUID->"1e9bd582-dfde-445b-9aeb-7b1c6cb41ab8"]
}, Open  ]],

Cell["\<\
Notice how negative cnumbers do not denote covariant indices:\
\>", "MathCaption",ExpressionUUID->"fad86ace-6ac0-438b-90ff-51ac842864bd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "comp"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "comp\[Dagger]"}], "}"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->
  "In[103]:=",ExpressionUUID->"5f4077eb-97ac-4911-aeb8-548b4e7365c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox[
             RowBox[{"-", "1"}],
             FontColor->RGBColor[0., 0., 1.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {-1, $CellContext`comp}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox[
             RowBox[{"-", "1"}],
             FontColor->RGBColor[0., 0., 1.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {-1, $CellContext`comp\[Dagger]}],
    Editable->False]}], "}"}]], "Output",
 CellLabel->
  "Out[103]=",ExpressionUUID->"ddab7753-ce5e-4a8e-9750-defd898eda11"]
}, Open  ]],

Cell["The basis objects of both bases look the same, because ", "Text",ExpressionUUID->"aec10345-992f-4fb8-8bd2-a8516d0afd05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "Basis", "]"}]], "Input",
 CellLabel->
  "In[104]:=",ExpressionUUID->"e8d7e545-e76e-49fd-aeff-5c74e2b64b91"],

Cell[BoxData["Basis"], "Output",
 CellLabel->
  "Out[104]=",ExpressionUUID->"2b8a1c0f-db1f-46db-93a9-b03a166cb9dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "comp"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[105]:=",ExpressionUUID->"cc27bc8f-e58e-4c31-8834-5742d763e399"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox[
           RowBox[{"-", "1"}],
           FontColor->RGBColor[0., 0., 1.]]},
         {"a", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[-$CellContext`a, {-1, $CellContext`comp\[Dagger]}],
  Editable->False]], "Output",
 CellLabel->
  "Out[105]=",ExpressionUUID->"6ec7833f-0f17-4aa4-a400-dcd955bbd9c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[106]:=",ExpressionUUID->"e84e2d6c-619b-4f6e-aa83-69e0a2ed03d7"],

Cell["Basis[-a, {-1, comp\[Dagger]}]", "Output",
 CellLabel->
  "Out[106]//InputForm=",ExpressionUUID->"fc906a0c-25a4-4884-ac24-\
14473a18456e"]
}, Open  ]],

Cell[TextData[{
 "and their cnumbers are also defined to be the same. This can be changed, \
with the new function ",
 StyleBox["DaggerBCIndex.",
  FontFamily->"Courier"],
 "Remember how in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " the conjugates of indices were given by "
}], "Text",ExpressionUUID->"1de26540-5893-43fa-820e-af6c3d3d8df5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaggerIndex", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "A", ",", "B"}], "}"}]}]], "Input",
 CellLabel->
  "In[107]:=",ExpressionUUID->"c3bdfedb-e251-433b-8db0-dabdca1732d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "A\[Dagger]", ",", "B\[Dagger]"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[107]=",ExpressionUUID->"50841b3b-30e0-4628-be37-fe0477cc3353"]
}, Open  ]],

Cell[TextData[{
 "But we cannot change the definition associated to ",
 StyleBox["DaggerIndex[{1, complex}]",
  FontFamily->"Courier"],
 ",  because ",
 StyleBox["complex",
  FontFamily->"Courier"],
 " is too deep to be given an upvalue. Let us see how we can use  ",
 StyleBox["DaggerCIndex",
  FontFamily->"Courier"],
 " to solve this with an example. We want to complexify a real basis:"
}], "Text",ExpressionUUID->"22b71b56-9c3d-4ee4-a1c7-04b8a788662e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"test", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[108]:=",ExpressionUUID->"8695ff25-fb91-4c86-b442-70e743784f59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "test", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`test, 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"e509897b-042d-452e-93c8-21d07878465e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDtest", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDtest[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"6ddb03cd-ac38-4645-8216-adb13c5e52df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDtest", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDtest[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"15312d18-bfcb-4064-9627-1c49f84ec82e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDtest", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDtest[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"a9386b07-966e-42a8-8cbc-52c2aaf78b62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDtest", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDtest[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"359ebe49-6e5a-40c7-a698-6433a4035aaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDtest", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDtest[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"ab24bc07-554b-4c2a-9669-27bce81c4d60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUptest", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUptest[$CellContext`a, $CellContext`b, $CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"8d55d9a0-a0c8-4478-a47d-d4b6b3ffbe36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDowntest", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDowntest[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[108]:=",ExpressionUUID->"c94470a4-5881-4ae4-9f21-3ed0e81dd860"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DaggerCIndex"}]], "Input",
 CellLabel->
  "In[109]:=",ExpressionUUID->"33bacd2f-f679-4de7-812e-cc96471a0dd4"],

Cell[BoxData["\<\"DaggerCIndex[basis, cindex] returns the conjugated index to \
the cindex (assumed to belong to basis or -basis), in general a Dir \
expression. This function should be handled through upvalues for \
basis.\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info1093728140887-3828762",ExpressionUUID->"85ccb4f2-368d-4cd6-84a2-\
a6cd221ff73c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "test"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "test"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "test"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "test"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->
  "In[110]:=",ExpressionUUID->"6990f634-9fbb-423e-90c8-0366ca3959de"],

Cell["And now", "MathCaption",ExpressionUUID->"2a3e7300-524a-47ae-9d03-2d4426b648ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "test"}], "}"}]}], "]"}], ",", 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "test"}]}], "}"}], ",", "a"}], "]"}]}], "}"}]}]], "Input",\

 CellLabel->
  "In[114]:=",ExpressionUUID->"5107a35c-cee4-4852-bf67-585e2e2e102e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`test}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`test}, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellLabel->
  "Out[114]=",ExpressionUUID->"87270c2e-3c33-4d4d-889a-1b948f3701bc"]
}, Open  ]],

Cell["\<\
If we define a complex tensor on M3 we can see that this works\
\>", "MathCaption",ExpressionUUID->"c74d384d-0b63-428c-a277-971b4d88f69b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"J", "[", "a", "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", " ", "Complex"}]}], "]"}]], "Input",
 CellLabel->
  "In[115]:=",ExpressionUUID->"346fa2a8-49aa-40ec-8727-9793e6fab7f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"J", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`J[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[115]:=",ExpressionUUID->"2bec8043-28c4-46b0-9936-a15cd4a54603"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"J\[Dagger]", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`J\[Dagger][$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[115]:=",ExpressionUUID->"cc8503cb-54ea-4f35-8bb9-270e76546ad6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"J", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "test"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[116]:=",ExpressionUUID->"9ca6c30f-993a-40e0-b2e8-04159f7b92ff"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"J\[Dagger]", 
      StyleBox[GridBox[{
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`J\[Dagger][{1, $CellContext`test}],
  Editable->False]], "Output",
 CellLabel->
  "Out[116]=",ExpressionUUID->"466da7a5-0782-4c40-a9bf-2555267e2e3d"]
}, Open  ]],

Cell["\<\
We can even establish more complicated relations, if we remember that Basis \
and Dir act as inverses of each other\
\>", "MathCaption",ExpressionUUID->"b998c5c5-aab8-4ba3-aca9-9822439a4e2d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"Dir", "[", 
    RowBox[{"I", " ", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "test"}], "}"}]}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"Dir", "[", 
    RowBox[{"I", " ", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "test"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->
  "In[117]:=",ExpressionUUID->"f29c6c77-f41d-452f-af3e-304caf504daa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"J", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "test"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[119]:=",ExpressionUUID->"40b02f95-2a4e-48df-86a9-6cadabd90bd2"],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"J\[Dagger]", 
       StyleBox[GridBox[{
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`J\[Dagger][{1, $CellContext`test}],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[119]=",ExpressionUUID->"cd457229-efd8-4b10-94c1-98bbaff3dc44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefBasis", "[", "test", "]"}], ";"}]], "Input",
 CellLabel->
  "In[120]:=",ExpressionUUID->"ac129649-f83e-453c-babf-02995386158b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDtest],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"4afd97a5-56b0-4743-9bfa-b0bdef8b42b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDtest],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"0413f166-1989-47cd-b9db-807e0c5080c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDtest],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"5e974612-c437-48f5-a1a3-60292a803b25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDtest],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"0ce500ac-ebd6-491a-86bf-e531493b42a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDtest],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"2611bcab-7b9b-462a-9bea-62dbceeba439"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUptest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUptest],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"fba90892-53e2-4b7b-bc5e-705bca6014b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDowntest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDowntest],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"736d5eab-f0ed-4315-90bf-6d84d957544b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "test"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`test],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[120]:=",ExpressionUUID->"c468c89f-c896-4fa3-b145-13f011cb4151"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. BasisArray", "SubsubsectionIcon",ExpressionUUID->"2293933f-3cd3-45d8-9482-8786a1dadffa"],

Cell[TextData[{
 StyleBox["BasisArray\t\t\t", "DisplayMath"],
 StyleBox["List of basis vectors", "Text"]
}], "DefinitionBox",ExpressionUUID->"ae30a1d2-ed84-443a-b53c-1ab209af4509"],

Cell["Listing basis objects", "SmallText",ExpressionUUID->"71caf07e-a74c-4e54-b6d5-a6d4918e2d7d"],

Cell[TextData[{
 "The function ",
 StyleBox["BasisArray",
  FontFamily->"Courier"],
 " returns a list of all basis vectors of a given basis"
}], "Text",ExpressionUUID->"36f5ef7f-e782-4794-96de-a953abadd8ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", "cartesian", "]"}], "[", "a", "]"}]], "Input",
 CellLabel->
  "In[121]:=",ExpressionUUID->"3c419301-418c-4d4c-9a96-ce367f785028"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["0",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellLabel->
  "Out[121]=",ExpressionUUID->"c665f5d1-d9df-4e25-93e5-5256dc55a9ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", "comp", "]"}], "[", "A", "]"}]], "Input",
 CellLabel->
  "In[122]:=",ExpressionUUID->"1a09cf95-6c5f-4394-b6e3-bab07722f3da"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "A"},
           {
            StyleBox[
             RowBox[{"-", "1"}],
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-1, -$CellContext`comp}, $CellContext`A],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "A"},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`comp}, $CellContext`A],
    Editable->False]}], "}"}]], "Output",
 CellLabel->
  "Out[122]=",ExpressionUUID->"d1cc579a-64a4-4482-97a0-a5e691c4c666"]
}, Open  ]],

Cell["If we give several indices, the product basis is displayed", \
"MathCaption",ExpressionUUID->"3dcea435-b176-45a1-886a-4e555c34ee13"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", 
   RowBox[{"polar", ",", "polar"}], "]"}], "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->
  "In[123]:=",ExpressionUUID->"96e1e910-c066-44ab-a78c-bc9ba62e0a4c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`b],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`b],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`b],
       Editable->False]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`b],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`b],
       Editable->False]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`b],
       Editable->False]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->
  "Out[123]=",ExpressionUUID->"7b5d43e2-9eae-45a6-9948-d69f3f9d4f30"]
}, Open  ]],

Cell["We can mix bases", "MathCaption",ExpressionUUID->"7cfbeaad-18f5-437b-8e09-4ca35d55f9ef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasisArray", "[", 
    RowBox[{"polar", ",", "cartesian", ",", "comp"}], "]"}], "[", 
   RowBox[{"a", ",", "c", ",", 
    RowBox[{"-", "B"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->
  "In[124]:=",ExpressionUUID->"b397e55b-f385-4af2-9549-8033b90016e2"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`comp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 1., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`c],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[124]//MatrixForm=",ExpressionUUID->"7ccab4d3-77e2-4764-a9d2-\
479d29533fd5"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2. Manipulating basis indices: ContractBasis, \
SeparateBasis, ToBasis",
 FontSize->14]], "SubsectionIcon",ExpressionUUID->"72218c58-dd15-4055-929e-\
32e81a9d0e94"],

Cell["\<\
We ended the previous section with an open problem: what to do with \
expressions such as\
\>", "Text",ExpressionUUID->"faf43730-e66c-4769-ad12-c851bdfb06a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "cartesian"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], "]"}]}]}], "}"}]], "Input",
 CellLabel->
  "In[125]:=",ExpressionUUID->"acb11796-321d-439a-b0da-b5127f1aa2f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["b",
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 1., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`cartesian}, \
{$CellContext`b, $CellContext`polar}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["b",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{-$CellContext`b, -$CellContext`polar}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["b",
              FontColor->RGBColor[1., 0., 0.]]},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[-$CellContext`a, {$CellContext`b, $CellContext`polar}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["b",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{-$CellContext`b, -$CellContext`polar}],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->
  "Out[125]=",ExpressionUUID->"f34a7c94-6f8d-4752-9e81-43c75ca9dd32"]
}, Open  ]],

Cell[TextData[{
 "The first one represents the expansion of a tensor into its components and \
the second one a basis change.  These operations are seemingly different: we \
are alternatively contracting basis indices and abstract indices. They are \
all, however, encompassed by one single function in ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 " :  ",
 StyleBox["ContractBasis.",
  FontFamily->"Courier"],
 "\n\nConversely, we may want to go from contracted expressions to ones with \
explicit ",
 StyleBox["Basis",
  FontFamily->"Courier"],
 " objects. And we may also need to introduce additional ",
 StyleBox["Basis",
  FontFamily->"Courier"],
 " objects in order to take care of a basis change:"
}], "Text",ExpressionUUID->"cafd8857-f206-4cf8-bbc5-222802112166"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "polar"}], "}"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"v", "[", "b", "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "polar"}], "}"}]}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"v", "[", "a", "]"}], "\[Equal]", " ", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
     RowBox[{"v", "[", 
      RowBox[{"{", 
       RowBox[{"b", ",", "polar"}], "}"}], "]"}]}]}], ",", " ", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "polar"}], "}"}], "]"}], "\[Equal]", " ", 
    RowBox[{
     RowBox[{"v", "[", 
      RowBox[{"{", 
       RowBox[{"b", ",", "cartesian"}], "}"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "cartesian"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "polar"}], "}"}]}], "]"}]}]}]}], "}"}]], "Input",
 CellLabel->
  "In[126]:=",ExpressionUUID->"e2f9cfc7-c865-422f-82e9-f336de5282ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{$CellContext`a, $CellContext`polar}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["a",
               FontColor->RGBColor[1., 0., 0.]]},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`b, {$CellContext`a, \
$CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[$CellContext`b],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[$CellContext`a],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "a"},
             {
              StyleBox["b",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`polar}, \
$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`b, $CellContext`polar}],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {
             StyleBox["a",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{$CellContext`a, $CellContext`polar}],
     Editable->False], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["a",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 1., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`cartesian}, \
{$CellContext`a, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["b",
               FontColor->RGBColor[0., 1., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`b, $CellContext`cartesian}],
      Editable->False]}]}]}], "}"}]], "Output",
 CellLabel->
  "Out[126]=",ExpressionUUID->"67be6651-56e6-4d05-a537-564211b56e82"]
}, Open  ]],

Cell[TextData[{
 "In the first example, we are simply extracting the Basis object from the \
tensor, so to speak; but in the second and third cases we are introducing new \
",
 StyleBox["Basis",
  FontFamily->"Courier"],
 " objects, either to express a tensor in terms of its components or to \
change their basis. Again, all these operations are performed by just one \
function: ",
 StyleBox["SeparateBasis",
  FontFamily->"Courier"],
 "."
}], "Text",ExpressionUUID->"27a23088-6486-48d5-b9ba-835ed3310d49"],

Cell[CellGroupData[{

Cell["2.1. IndicesOf", "SubsubsectionIcon",ExpressionUUID->"36e48e02-82e5-4221-87be-c7807dcd35b4"],

Cell[TextData[{
 "In ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", the main user level function to find indices in an expression was ",
 StyleBox["IndicesOf[selectors][expression]",
  FontFamily->"Courier"],
 ",  "
}], "Text",ExpressionUUID->"54d297ff-67ce-4972-a3f7-040388e78001"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"TT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", "d", ",", 
     RowBox[{"-", "e"}]}], "]"}], ",", "M3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], ",", "M3"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", "B"}], "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]}], "Input",
 CellLabel->
  "In[127]:=",ExpressionUUID->"12c43a21-58ec-4b82-9c1a-a7c05b17d05a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", "d", ",", 
     RowBox[{"-", "e"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TT[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`d, -$CellContext`e], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[127]:=",ExpressionUUID->"b4954f22-8654-42b9-b3e4-dd1c8c634898"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[127]:=",ExpressionUUID->"6847dd63-7900-4819-bf39-2f13607c1de6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", "B"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[-$CellContext`A, $CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[127]:=",ExpressionUUID->"2fa8798c-4210-43ec-843a-ee79c6def8db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", "B\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S\[Dagger][-$CellContext`A\[Dagger], $CellContext`B\[Dagger]],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[127]:=",ExpressionUUID->"ed3bf7e6-e8af-4510-bef7-d2ccc479bdcd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"TT", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "cartesian"}], "}"}], ",", "c", ",", 
      RowBox[{"-", "a"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "cartesian"}], "}"}]}], "]"}], 
    RowBox[{"U", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "d", ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "polar"}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", "c"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "comp"}]}], "}"}], ",", "B"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "B"}], ",", 
      RowBox[{"{", 
       RowBox[{"A", ",", "comp"}], "}"}]}], "]"}]}]}]}]], "Input",
 CellLabel->
  "In[130]:=",ExpressionUUID->"75f1bb86-54a6-4869-b103-46477260b76c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TT", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]], "c", " "},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
     2, $CellContext`cartesian}, $CellContext`c, -$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`polar}, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`polar}],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[130]=",ExpressionUUID->"a5f41d98-8cef-47f9-bb1c-5abe5d426411"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", "Free", "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[131]:=",ExpressionUUID->"563f9246-0de7-43ec-be51-90801d6f26e9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], "c"}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`b, $CellContext`c],
  Editable->False]], "Output",
 CellLabel->
  "Out[131]=",ExpressionUUID->"f9f363f3-e07a-48bb-b178-e2a206406a51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", "TangentM3", "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[132]:=",ExpressionUUID->"62e747e6-e704-464b-bb1f-b730bf6e975b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], "a", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "cartesian"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], "c", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "a"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "d"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], "d", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "polar"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{
   1, -$CellContext`polar}, $CellContext`a, -$CellContext`b, {
   2, $CellContext`cartesian}, $CellContext`c, -$CellContext`a, \
-$CellContext`d, {-$CellContext`e, -$CellContext`polar}, $CellContext`d, \
{$CellContext`e, $CellContext`polar}],
  Editable->False]], "Output",
 CellLabel->
  "Out[132]=",ExpressionUUID->"b033b6ac-ea47-4353-8dac-4e803b5cb093"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", "InnerC", "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[133]:=",ExpressionUUID->"59e57e41-bcdb-4c5a-9aa8-72cd878ffcb4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"-", "B"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"A", ",", "comp"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "comp"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], "B"}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`B, {$CellContext`A, \
$CellContext`comp}, {-$CellContext`A, -$CellContext`comp}, $CellContext`B],
  Editable->False]], "Output",
 CellLabel->
  "Out[133]=",ExpressionUUID->"352926d5-54aa-49ad-87a8-aaa8437dd011"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"U", ",", "Free"}], "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[134]:=",ExpressionUUID->"f28ab0e5-e513-4521-b6db-96ee845e594e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"-", "a"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], "d", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "polar"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`a, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`polar}],
  Editable->False]], "Output",
 CellLabel->
  "Out[134]=",ExpressionUUID->"1b5fd403-7115-4391-b37f-344c14ac5d8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"Free", ",", "U"}], "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[135]:=",ExpressionUUID->"6696e00e-8955-4351-bcf8-101b3ef78416"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{"-", "b"}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`b],
  Editable->False]], "Output",
 CellLabel->
  "Out[135]=",ExpressionUUID->"6505ded8-1016-4297-8e46-0ed34315da0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"{", 
    RowBox[{"U", ",", "Free"}], "}"}], "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[136]:=",ExpressionUUID->"571c8d35-a5c3-4086-8f79-78a9067155db"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"-", "a"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], "d", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "polar"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], "c"}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`a, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`polar}, -$CellContext`b, $CellContext`c],
  Editable->False]], "Output",
 CellLabel->
  "Out[136]=",ExpressionUUID->"31c8170c-cefe-4d52-a8fb-87249a062edf"]
}, Open  ]],

Cell[TextData[{
 "(See xTensorDoc.nb, section 9.1).",
 StyleBox[" xCoba`",
  FontFamily->"Courier"],
 " adds more possibilities. We can now use the types ",
 StyleBox["BIndex",
  FontFamily->"Courier"],
 " and ",
 StyleBox["CIndex",
  FontFamily->"Courier"],
 " as selectors, or search for a particular basis"
}], "MathCaption",ExpressionUUID->"8fd8c5cb-8915-4e3c-8568-8993147aff59"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"{", 
    RowBox[{"BIndex", ",", "CIndex"}], "}"}], "]"}], "[", "expr", 
  "]"}]], "Input",
 CellLabel->
  "In[137]:=",ExpressionUUID->"5011d870-ae08-4b36-b633-1db8d8650a02"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"A", ",", "comp"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "comp"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "polar"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "cartesian"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{-$CellContext`e, -$CellContext`polar}, \
{$CellContext`A, $CellContext`comp}, {-$CellContext`A, -$CellContext`comp}, \
{$CellContext`e, $CellContext`polar}, {1, -$CellContext`polar}, {
   2, $CellContext`cartesian}],
  Editable->False]], "Output",
 CellLabel->
  "Out[137]=",ExpressionUUID->"e28dad8a-10a7-4414-88cd-ffe77249ffaa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", "polar", "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[138]:=",ExpressionUUID->"fe18a01b-35ef-4ad2-b5e0-e0ca9eb665c1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "polar"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{
   1, -$CellContext`polar}, {-$CellContext`e, -$CellContext`polar}, \
{$CellContext`e, $CellContext`polar}],
  Editable->False]], "Output",
 CellLabel->
  "Out[138]=",ExpressionUUID->"9a012d88-5ff0-409f-aadb-f7fcb58c212c"]
}, Open  ]],

Cell["Consider now the following example", "MathCaption",ExpressionUUID->"02557eb9-26fd-4a8a-b9f5-6532564d2409"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"Basis", ",", "polar"}], "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[139]:=",ExpressionUUID->"dc0547a7-f11c-4b82-922a-ee1c47f03739"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{
   1, -$CellContext`polar}, {-$CellContext`e, -$CellContext`polar}],
  Editable->False]], "Output",
 CellLabel->
  "Out[139]=",ExpressionUUID->"72d4a6f5-72a3-48c1-9dfb-84c42ae11b62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"Basis", "[", "polar", "]"}], "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[140]:=",ExpressionUUID->"277857e2-9a66-4a12-8f05-5ddea2f68d9d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{"a", 
     RowBox[{",", "\[ThinSpace]"}], "c", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[$CellContext`a, $CellContext`c, {
   1, -$CellContext`polar}, {-$CellContext`e, -$CellContext`polar}],
  Editable->False]], "Output",
 CellLabel->
  "Out[140]=",ExpressionUUID->"7aeb15c6-28df-4a7d-a479-c4dc86a3d53a"]
}, Open  ]],

Cell[TextData[{
 "The first selects all the indices appearing in Basis objects and then \
selects from those only the ones that belong to polar. The second selects \
only those indices that belong to a Basis object of the polar basis, but \
returns the pair, not only the ",
 StyleBox["BCIndex",
  FontFamily->"Courier"],
 "."
}], "MathCaption",ExpressionUUID->"8416f90a-b65f-49bd-ba1a-fa0b3e1edeaf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"Basis", "[", "polar", "]"}], "]"}], "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "polar"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "cartesian"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[141]:=",ExpressionUUID->"018e1f6f-3e95-40bc-ade0-65018c63ae4b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"b", ",", "cartesian"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`cartesian}],
  Editable->False]], "Output",
 CellLabel->
  "Out[141]=",ExpressionUUID->"60c914fc-63e2-4e3e-8a70-afd0baab824f"]
}, Open  ]],

Cell["\<\
This function will be used heavily to control the behaviour of ContractBasis \
and SeparateBasis.\
\>", "MathCaption",ExpressionUUID->"3a797d89-c1c6-4c23-b19b-e006f338f34a"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. ContractBasis", "SubsubsectionIcon",ExpressionUUID->"dd869560-b307-4804-b0a3-2322cee31c1d"],

Cell[TextData[{
 StyleBox["ContractBasis",
  FontFamily->"Courier"],
 " is responsible for all contractions of ",
 StyleBox["Basis",
  FontFamily->"Courier"],
 " with any other object. "
}], "Text",ExpressionUUID->"b51bd2f9-84ff-4d6d-8263-772889b99dba"],

Cell[TextData[{
 StyleBox["ContractBasis[expr, indices]\t\t", "DisplayMath"],
 StyleBox["Perform the contractions of ", "Text"],
 StyleBox["Basis", "Text",
  FontFamily->"Courier"],
 StyleBox[" objects involving the specified dummy indices", "Text"]
}], "DefinitionBox",ExpressionUUID->"a175050a-6be7-4d1d-be7f-847bee268215"],

Cell["Contraction of Basis objects with tensors.", "SmallText",ExpressionUUID->"293181a8-1fe7-4235-90ab-19e6b5ae9c1e"],

Cell[TextData[{
 "We have complete control over which dummy indices should be eliminated. We \
can select them in several ways, all of which are eventually converted into a \
list of indices with head ",
 StyleBox["IndexList",
  FontFamily->"Courier"],
 ":\n\t- ",
 StyleBox["IndexList[...]",
  FontFamily->"Courier"],
 ",\t\t\nbe careful not to use the normal ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 StyleBox["List",
  FontFamily->"Courier"],
 ", which could be mistaken for a ",
 StyleBox["BCIndex",
  FontFamily->"Courier"],
 ". ",
 StyleBox["IndicesOf[selectors]",
  FontFamily->"Courier"],
 " as a second argument is treated as ",
 StyleBox["IndicesOf[selectors][expr]",
  FontFamily->"Courier"],
 " and gives great flexibility, but it is sometimes too long for simple \
cases. To handle them, several shorthands are defined: \n\t- ",
 StyleBox["ContractBasis[expr,basis] \t= ContractBasis[expr,IndicesOf[basis]]",
  FontFamily->"Courier"],
 ",\n\t- ",
 StyleBox["ContractBasis[expr,vbundle]\t= \
ContractBasis[expr,IndicesOf[vbundle]]",
  FontFamily->"Courier"],
 ",\n\t- ",
 StyleBox["ContractBasis[expr,tensor]\t= \
ContractBasis[expr,IndicesOf[tensor]]",
  FontFamily->"Courier"],
 ",\n\t- ",
 StyleBox["ContractBasis[expr,index]\t\t= \
ContractBasis[expr,IndexList[index]]",
  FontFamily->"Courier"],
 " .\nIt is important to keep in mind that the second argument gives the list \
of indices to be contracted,  not their pairs in the Basis object. \nAll of \
this is best illustrated through some examples:"
}], "Text",ExpressionUUID->"f27ff5fb-0bdc-4e46-b3a9-8c578d8f3cda"],

Cell[CellGroupData[{

Cell[BoxData["expr"], "Input",
 CellLabel->
  "In[142]:=",ExpressionUUID->"1165e8c9-df89-4549-85d6-a51c3503f62c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TT", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]], "c", " "},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
     2, $CellContext`cartesian}, $CellContext`c, -$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`polar}, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`polar}],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[142]=",ExpressionUUID->"3fb99c1c-72f4-4776-853f-c2d83cf5d673"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr2", "=", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", "b"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "comp"}], "}"}]}], "]"}], " ", 
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "B"}], ",", "A"}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"e", ",", "cartesian"}], "}"}], "]"}]}]}]], "Input",
 CellLabel->
  "In[143]:=",ExpressionUUID->"decbdad5-9c12-40a9-98d0-ed0418969392"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"A", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`A, {1, $CellContext`comp}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "b"},
          {
           StyleBox["e",
            FontColor->RGBColor[0., 1., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`cartesian}, \
$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {" ", "A"},
          {"B", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[-$CellContext`B, $CellContext`A],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {
           StyleBox["e",
            FontColor->RGBColor[0., 1., 0.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{$CellContext`e, $CellContext`cartesian}],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[143]=",ExpressionUUID->"4708b54a-690a-456e-97b7-ff203a74569a"]
}, Open  ]],

Cell["\<\
The function called with just one argument performs all the possible \
contractions.\
\>", "MathCaption",ExpressionUUID->"5e0ded7b-692e-4726-a6b0-de8c852fadc3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[144]:=",ExpressionUUID->"beec4951-1537-41a4-83b8-a728fc481f7e"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
    2, $CellContext`cartesian}, $CellContext`c, {1, -$CellContext`polar}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]], "c"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{1, -$CellContext`polar}, -$CellContext`b, {
     2, $CellContext`cartesian}, $CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[144]=",ExpressionUUID->"34b26c40-3fa9-4c95-87c4-716283b027d4"]
}, Open  ]],

Cell["\<\
If we choose to give the indices directly, we can specifiy either element of \
the pair\
\>", "MathCaption",ExpressionUUID->"599a2e5f-bd4a-4bd9-8bcd-9dd0c1cc6739"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ContractBasis", "[", 
       RowBox[{"expr2", ",", " ", "A"}], "]"}], ",", " ", 
      RowBox[{"ContractBasis", "[", 
       RowBox[{"expr2", ",", 
        RowBox[{"-", "A"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ContractBasis", "[", 
       RowBox[{"expr2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "e"}], ",", 
          RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}], ",", " ", 
      RowBox[{"ContractBasis", "[", 
       RowBox[{"expr2", ",", 
        RowBox[{"{", 
         RowBox[{"e", ",", "cartesian"}], "}"}]}], "]"}]}], "}"}]}], "}"}], "//",
   "TableForm"}]], "Input",
 CellLabel->
  "In[145]:=",ExpressionUUID->"b34949bf-5c43-4c79-b7fa-befbb412bf18"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["e",
                FontColor->RGBColor[0., 1., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`cartesian}, \
$CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"S", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {"B", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[-$CellContext`B, {1, $CellContext`comp}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {
               StyleBox["e",
                FontColor->RGBColor[0., 1., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{$CellContext`e, $CellContext`cartesian}],
       Editable->False]}], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["e",
                FontColor->RGBColor[0., 1., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`cartesian}, \
$CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"S", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {"B", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[-$CellContext`B, {1, $CellContext`comp}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {
               StyleBox["e",
                FontColor->RGBColor[0., 1., 0.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{$CellContext`e, $CellContext`cartesian}],
       Editable->False]}]},
    {
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {"A", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[-$CellContext`A, {1, $CellContext`comp}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"S", 
           StyleBox[GridBox[{
              {" ", "A"},
              {"B", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[-$CellContext`B, $CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[$CellContext`b],
       Editable->False]}], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]},
              {"A", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[-$CellContext`A, {1, $CellContext`comp}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"S", 
           StyleBox[GridBox[{
              {" ", "A"},
              {"B", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[-$CellContext`B, $CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[$CellContext`b],
       Editable->False]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[145]//TableForm=",ExpressionUUID->"24e694f2-b49f-440c-ba64-\
f5686a897de1"]
}, Open  ]],

Cell["Nothing happens if we give an invalid index", "MathCaption",ExpressionUUID->"68e86b2c-1ddd-43cf-ac86-bc034db2766b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr2", ",", "C"}], "]"}]], "Input",
 CellLabel->
  "In[146]:=",ExpressionUUID->"bacd5051-b924-46f6-9450-99424ec88845"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"A", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`A, {1, $CellContext`comp}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "b"},
          {
           StyleBox["e",
            FontColor->RGBColor[0., 1., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`cartesian}, \
$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {" ", "A"},
          {"B", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[-$CellContext`B, $CellContext`A],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {
           StyleBox["e",
            FontColor->RGBColor[0., 1., 0.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{$CellContext`e, $CellContext`cartesian}],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[146]=",ExpressionUUID->"0d4576f2-2592-4ab0-a7e3-a59f9e58c7e2"]
}, Open  ]],

Cell["More simple examples", "MathCaption",ExpressionUUID->"2c3c5f61-9573-4923-a647-fac8d8887e51"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"IndicesOf", "[", "AIndex", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[147]:=",ExpressionUUID->"b09fb82c-77e5-447b-ba60-68ae1b883283"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
    2, $CellContext`cartesian}, $CellContext`c, {1, -$CellContext`polar}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`polar}, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]], 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{1, -$CellContext`polar}, -$CellContext`b, {
     2, $CellContext`cartesian}, {$CellContext`e, $CellContext`polar}],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[147]=",ExpressionUUID->"cad34b10-c878-4f6e-861e-83474c01bc08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"IndicesOf", "[", 
    RowBox[{"TT", ",", "U"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[148]:=",ExpressionUUID->"99d0a71c-0244-4532-9286-09bccdf841fc"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
    2, $CellContext`cartesian}, $CellContext`c, {1, -$CellContext`polar}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`polar}, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{
     1, -$CellContext`polar}, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`polar}],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[148]=",ExpressionUUID->"ec1226bf-b21d-4dc2-8e01-1c4ceb989bb5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", " ", 
   RowBox[{"IndicesOf", "[", 
    RowBox[{"{", 
     RowBox[{"TT", ",", "U"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[149]:=",ExpressionUUID->"a779f61a-671e-4dee-93fb-92ea30e20d03"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
    2, $CellContext`cartesian}, $CellContext`c, {1, -$CellContext`polar}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]], "c"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{1, -$CellContext`polar}, -$CellContext`b, {
     2, $CellContext`cartesian}, $CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[149]=",ExpressionUUID->"89d028d2-a42b-4100-befd-279fc1f83903"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr2", ",", "InnerC"}], "]"}]], "Input",
 CellLabel->
  "In[150]:=",ExpressionUUID->"cab229d0-47cc-4953-8742-1d727eb4a378"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "b"},
          {
           StyleBox["e",
            FontColor->RGBColor[0., 1., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`cartesian}, \
$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"B", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[-$CellContext`B, {1, $CellContext`comp}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {
           StyleBox["e",
            FontColor->RGBColor[0., 1., 0.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{$CellContext`e, $CellContext`cartesian}],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[150]=",ExpressionUUID->"21737cce-db64-46d9-9dbf-176c205a7357"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", " ", 
   RowBox[{"IndexList", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "d"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[151]:=",ExpressionUUID->"0c58b5b6-43b9-49d8-a8b3-dff1eba80588"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
    2, $CellContext`cartesian}, $CellContext`c, {1, -$CellContext`polar}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`polar}, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]], 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{1, -$CellContext`polar}, -$CellContext`b, {
     2, $CellContext`cartesian}, {$CellContext`e, $CellContext`polar}],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[151]=",ExpressionUUID->"76a7cbfc-9cc7-426c-8a57-dcb6961e53bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", " ", "polar"}], "]"}]], "Input",
 CellLabel->
  "In[152]:=",ExpressionUUID->"cdc7ec7d-f32f-4eba-87ea-2b6961f5e2f6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TT", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]], "c", " "},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
     2, $CellContext`cartesian}, $CellContext`c, -$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", "c"},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`d, \
$CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[152]=",ExpressionUUID->"943d8344-2a7f-4525-b65b-977ece0d54b2"]
}, Open  ]],

Cell[TextData[{
 "Notice how only the index",
 StyleBox[" {-e, -polar}",
  FontFamily->"Courier"],
 " has been supressed. Nothing has been done to ",
 StyleBox["a",
  FontFamily->"Courier"],
 ", even though its pair in the Basis object belongs to",
 StyleBox[" polar",
  FontFamily->"Courier"],
 ".  If we want to act on that index, we can use"
}], "MathCaption",ExpressionUUID->"48d0d17c-29ba-4a7d-979a-86078e7b6c5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", " ", 
   RowBox[{"IndicesOf", "[", 
    RowBox[{"Basis", "[", "polar", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[153]:=",ExpressionUUID->"c82642e5-1e49-4451-bfe6-e5a36e43835f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
    2, $CellContext`cartesian}, $CellContext`c, {1, -$CellContext`polar}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", "c"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{
     1, -$CellContext`polar}, -$CellContext`b, $CellContext`d, $CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[153]=",ExpressionUUID->"7073a240-3a18-48d7-926b-0b184b37af4b"]
}, Open  ]],

Cell["\<\
to contract everything that appears in a Basis object that has at least one \
polar index. Or\
\>", "MathCaption",ExpressionUUID->"569c28bb-8349-40a3-b0d1-b6b865edb553"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", " ", 
   RowBox[{"IndicesOf", "[", 
    RowBox[{
     RowBox[{"Basis", "[", "polar", "]"}], ",", "AIndex"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->
  "In[154]:=",ExpressionUUID->"b9a6929d-0c6a-49b0-946b-da0a9ec9aaaf"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
    2, $CellContext`cartesian}, $CellContext`c, {1, -$CellContext`polar}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`polar}, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`comp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`comp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{
     1, -$CellContext`polar}, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`polar}],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[154]=",ExpressionUUID->"954f0577-3cfd-4282-a250-bb9bbe9b712c"]
}, Open  ]],

Cell[TextData[{
 "to contract only abstract indices whose pair in ",
 StyleBox["Basis",
  FontFamily->"Courier"],
 " belongs to ",
 StyleBox["polar",
  FontFamily->"Courier"],
 ". Notice that some specifications can be redundant; ",
 StyleBox["IndicesOf[Basis, x]",
  FontFamily->"Courier"],
 " is equivalent to ",
 StyleBox["IndicesOf[x]",
  FontFamily->"Courier"],
 ", because all the indices that can be contracted by this function already \
have to appear in ",
 StyleBox["Basis",
  FontFamily->"Courier"],
 "."
}], "MathCaption",ExpressionUUID->"38deea00-fb20-49eb-bf64-c902147e552d"],

Cell[TextData[{
 "Contraction of ",
 StyleBox["Basis",
  FontFamily->"Courier"],
 " objects can be performed with ",
 StyleBox["ContractBasis",
  FontFamily->"Courier"],
 ", or automatized:"
}], "MathCaption",ExpressionUUID->"813e3dcc-82d7-422c-bd47-760da955b048"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "cartesian"}], "}"}]}], "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}]}]], "Input",
 CellLabel->
  "In[155]:=",ExpressionUUID->"f1bb2e5f-6686-4721-b0f9-77d625b4c071"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["b",
            FontColor->RGBColor[0., 1., 0.]]},
          {"a", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`a, {$CellContext`b, \
$CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["c",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`c, -$CellContext`polar}, $CellContext`a],
   
   Editable->False]}]], "Output",
 CellLabel->
  "Out[155]=",ExpressionUUID->"7594d1e5-f99f-4e4f-9ada-f7a75ba2a872"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[156]:=",ExpressionUUID->"f53d44cd-fdad-49ff-b468-16a992b8d49f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["b",
           FontColor->RGBColor[0., 1., 0.]]},
         {
          StyleBox["c",
           FontColor->RGBColor[1., 0., 0.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{-$CellContext`c, -$CellContext`polar}, {$CellContext`b, \
$CellContext`cartesian}],
  Editable->False]], "Output",
 CellLabel->
  "Out[156]=",ExpressionUUID->"37618a30-58ee-447e-9b59-2161a4c72a99"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"AutomaticBasisContractionStart", "[", "]"}]], "Input",
 CellLabel->
  "In[157]:=",ExpressionUUID->"aebd8276-7a99-409a-9470-ce6aecc5708d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "cartesian"}], "}"}]}], "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}]}]], "Input",
 CellLabel->
  "In[158]:=",ExpressionUUID->"6d53468b-5e7c-4b13-9b1c-7528bc2f41ef"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["b",
           FontColor->RGBColor[0., 1., 0.]]},
         {
          StyleBox["c",
           FontColor->RGBColor[1., 0., 0.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{-$CellContext`c, -$CellContext`polar}, {$CellContext`b, \
$CellContext`cartesian}],
  Editable->False]], "Output",
 CellLabel->
  "Out[158]=",ExpressionUUID->"537deeb9-2939-43e8-a061-36479ef65951"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"AutomaticBasisContractionStop", "[", "]"}]], "Input",
 CellLabel->
  "In[159]:=",ExpressionUUID->"88fed2ab-7212-47f8-a927-88b042fc7695"],

Cell[TextData[{
 "The default behaviour of ",
 StyleBox["ContractBasis",
  FontFamily->"Courier"],
 " disregards contractions involving derivatives. We must use the option ",
 StyleBox["OverDerivatives",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"fcac0608-b255-4d8e-bc6d-905276cafd3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefCovD", "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], ",", 
   RowBox[{"SymbolOfCovD", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<#\>\"", ",", "\"\<D\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->
  "In[160]:=",ExpressionUUID->"a509d96c-81ed-492a-a246-819a74a5c111"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[160]:=",ExpressionUUID->"0e58ef45-5663-42cf-a9ba-12d6c4f09b7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[160]:=",ExpressionUUID->"4171bf90-b426-4aa4-bc21-6afc5d75e1bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[160]:=",ExpressionUUID->"0a4e0967-a3f5-4401-9ea4-0d42639e0075"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[160]:=",ExpressionUUID->"9456e2b4-cc47-4fd3-8611-f9f732370278"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[160]:=",ExpressionUUID->"0e9d1838-b8ed-4a0a-8f1b-70e6c07cba63"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[160]:=",ExpressionUUID->"3510f28c-72f3-4472-8c2e-5440a6441514"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "[", 
   RowBox[{"S", "[", 
    RowBox[{"c", ",", "b"}], "]"}], "]"}]}]], "Input",
 CellLabel->
  "In[161]:=",ExpressionUUID->"4e2226a7-a0bc-494a-be9f-4f39fa95d6d0"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]},
          {"b", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`b, {1, $CellContext`polar}],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["D", "a"], GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {"c", "b"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`a][
     $CellContext`S[$CellContext`c, $CellContext`b]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->
  "Out[161]=",ExpressionUUID->"d3f6590a-f97d-4df0-bb00-a714795b99f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[162]:=",ExpressionUUID->"a78ed31d-cde4-49e7-8fe8-9d86255c992b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]},
          {"b", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`b, {1, $CellContext`polar}],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["D", "a"], GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {"c", "b"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`a][
     $CellContext`S[$CellContext`c, $CellContext`b]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->
  "Out[162]=",ExpressionUUID->"c5d1e9ec-1079-4a27-9a35-8749db9a2e04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"%", ",", 
   RowBox[{"OverDerivatives", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[163]:=",ExpressionUUID->"906d7d83-6d13-4c13-8ba4-eef6383ade75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDPDpolar", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDPDpolar[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"dbcc7e09-b037-4871-a403-011fe9d0c24f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " ", " "},
           {" ", "a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCDPDpolar[{
     1, $CellContext`polar}, -$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {"c", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[$CellContext`c, $CellContext`b],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["D", "a"], GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {"c", 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`a][
    $CellContext`S[$CellContext`c, {1, $CellContext`polar}]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[163]=",ExpressionUUID->"85015f05-3239-4f90-ac6c-5bc22706949d"]
}, Open  ]],

Cell["\<\
A new Christoffel tensor is automatically defined. We shall see more about \
the interplay between bases and derivatives in Section 5. Any type of \
derivate exhibits the same behaviour, \
\>", "MathCaption",ExpressionUUID->"5c1fa4a1-08a8-4b37-9e9a-ebfb7eabe0b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lieexpr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"LieD", "[", 
     RowBox[{"v", "[", "a", "]"}], "]"}], "[", 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "b"}], "]"}]}]}]], "Input",
 CellLabel->
  "In[164]:=",ExpressionUUID->"695685a0-4fa9-4847-a927-b748e0277606"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "b"},
          {
           StyleBox["3",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{3, -$CellContext`polar}, $CellContext`b],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[ScriptCapitalL]", "v"], GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {"a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`LieD[
     $CellContext`v[$CellContext`a]][
     $CellContext`T[-$CellContext`a, -$CellContext`b]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->
  "Out[164]=",ExpressionUUID->"d7956cd3-e924-47a0-af8a-0ae1c60f2475"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ContractBasis", "[", "lieexpr", "]"}], ",", 
    RowBox[{"ContractBasis", "[", 
     RowBox[{"lieexpr", ",", 
      RowBox[{"OverDerivatives", "\[Rule]", " ", "True"}]}], "]"}]}], "}"}], "//",
   "TableForm"}]], "Input",
 CellLabel->
  "In[165]:=",ExpressionUUID->"c35b6d88-8db8-43f9-b960-14330ddf37b3"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "b"},
               {
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{3, -$CellContext`polar}, $CellContext`b],
        Editable->False], " ", 
       RowBox[{"(", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[ScriptCapitalL]", "v"], GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {"a", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`LieD[
          $CellContext`v[$CellContext`a]][
          $CellContext`T[-$CellContext`a, -$CellContext`b]],
         Editable->False], ")"}]}]},
     {
      RowBox[{
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[ScriptCapitalL]", "v"], GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`LieD[
         $CellContext`v[$CellContext`a]][
         $CellContext`T[{1, -$CellContext`polar}, {3, -$CellContext`polar}]],
        Editable->False], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {"a", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[-$CellContext`a, {3, -$CellContext`polar}],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]], GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {"a"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`PDpolar[{1, -$CellContext`polar}][
           $CellContext`v[$CellContext`a]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, -$CellContext`b],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["3",
              FontColor->RGBColor[1., 0., 0.]]], GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {"b"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`PDpolar[{3, -$CellContext`polar}][
           $CellContext`v[$CellContext`b]],
          Editable->False], ")"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[165]//TableForm=",ExpressionUUID->"6c5afb77-7de4-4921-ac74-\
96a334ab71a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"paramexpr", "=", 
  RowBox[{
   RowBox[{"OverDot", "[", 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "b"}], "]"}]}]}]], "Input",
 CellLabel->
  "In[166]:=",ExpressionUUID->"a3b7e8ea-ba13-437a-8cd7-83b01c5608d3"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "b"},
          {
           StyleBox["3",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{3, -$CellContext`polar}, $CellContext`b],
   Editable->False], " ", 
  OverscriptBox[
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`a, -$CellContext`b],
    Editable->False], "."]}]], "Output",
 CellLabel->
  "Out[166]=",ExpressionUUID->"0818dd35-6c71-479c-ae50-635a922e5822"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ContractBasis", "[", "paramexpr", "]"}], ",", 
    RowBox[{"ContractBasis", "[", 
     RowBox[{"paramexpr", ",", 
      RowBox[{"OverDerivatives", "\[Rule]", " ", "True"}]}], "]"}]}], "}"}], "//",
   "TableForm"}]], "Input",
 CellLabel->
  "In[167]:=",ExpressionUUID->"12d1ebb5-23a2-436d-b259-9600e185e618"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "b"},
               {
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{3, -$CellContext`polar}, $CellContext`b],
        Editable->False], " ", 
       OverscriptBox[
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {"a", "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[-$CellContext`a, -$CellContext`b],
         Editable->False], "."]}]},
     {
      RowBox[{
       OverscriptBox[
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, {3, -$CellContext`polar}],
         Editable->False], "."], "-", 
       RowBox[{
        OverscriptBox[
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", "a"},
                 {
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
          Editable->False], "."], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {"a", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[-$CellContext`a, {3, -$CellContext`polar}],
         Editable->False]}], "-", 
       RowBox[{
        OverscriptBox[
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", "b"},
                 {
                  StyleBox["3",
                   FontColor->RGBColor[1., 0., 0.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Basis[{3, -$CellContext`polar}, $CellContext`b],
          Editable->False], "."], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`polar}, -$CellContext`b],
         Editable->False]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->
  "Out[167]//TableForm=",ExpressionUUID->"522033cb-7024-4ed6-b8a5-\
b821ffa324f1"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"expr2", "=."}], "\[IndentingNewLine]", 
 RowBox[{"lieexpr", "=."}], "\[IndentingNewLine]", 
 RowBox[{"paramexpr", "=."}]}], "Input",
 CellLabel->
  "In[168]:=",ExpressionUUID->"89bd548d-8fbf-49f7-9f6d-9118b9fbd62c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefCovD", "[", "CD", "]"}]], "Input",
 CellLabel->
  "In[171]:=",ExpressionUUID->"6e7a8336-94b9-420f-85e2-5aa421faf43b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"ef12ee3f-98c5-4dbb-a98e-f1e9a44935a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ChristoffelCDPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`ChristoffelCDPDpolar],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"9f81c25e-574e-4536-9b5b-48d7a094f11a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Ricci tensor", " ", $CellContext`RicciCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"497ca974-4ec7-48b0-a848-2be4c7f95399"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"422aa8fe-acbd-41f1-87ea-c05156846490"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"69b0ed07-e0cd-4456-b30f-4f14543e2e07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CD],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"ab4fd44b-bffc-4daa-b07a-e9f6dfa24dc0"]
}, Open  ]],

Cell[TextData[{
 "The input expression is automatically expanded (with ",
 StyleBox["Expand",
  FontFamily->"Courier"],
 ") before applying ",
 StyleBox["ContractBasis",
  FontFamily->"Courier"],
 ". It would be better, in principle, to contract the bases only locally, but \
this is not yet implemented.\n\nAt the moment, the user cannot specify in \
which order the indices should be contracted. An option ",
 StyleBox["ContractFirst",
  FontFamily->"Courier"],
 " is planned but not yet coded."
}], "Text",ExpressionUUID->"7cf8717d-6da8-422d-acdd-5ec0734cc807"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3. SeparateBasis", "SubsubsectionIcon",ExpressionUUID->"2f7db809-afa0-432a-9b5f-d4dd5996996f"],

Cell[TextData[{
 StyleBox["SeparateBasis[basis][expr, indices]\t\t", "DisplayMath"],
 StyleBox["Expand the selected indices of a given expression in the specified \
basis ", "Text"]
}], "DefinitionBox",ExpressionUUID->"cf26f1ac-868d-4dad-bc22-c41330818fa7"],

Cell["Expansion of an expression in a given basis.", "SmallText",ExpressionUUID->"a3d63aae-bc1a-4150-a064-1f924728add3"],

Cell[TextData[{
 StyleBox["SeparateBasis",
  FontFamily->"Courier"],
 " works in a similar way to ",
 StyleBox["ContractBasis",
  FontFamily->"Courier"],
 ", but now we have two brackets. In the second one we can specify which \
indices should be `separated' from their original tensor. In the first one we \
say what should remain in their place (either ",
 StyleBox["AIndex",
  FontFamily->"Courier"],
 " or a basis). "
}], "Text",ExpressionUUID->"63e7b682-5352-437f-8a38-97b2f00904ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"TT", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "cartesian"}], "}"}], ",", "c", ",", 
      RowBox[{"-", "a"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "cartesian"}], "}"}]}], "]"}], 
    RowBox[{"U", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "d", ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "polar"}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "polar"}]}], "}"}], ",", "c"}], "]"}]}]}]}]], "Input",
 CellLabel->
  "In[172]:=",ExpressionUUID->"1272182b-62ed-4834-a933-57c104d4b164"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TT", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]], "c", " "},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
     2, $CellContext`cartesian}, $CellContext`c, -$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`polar}, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`polar}],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[172]=",ExpressionUUID->"0d5b4587-a596-4ce2-872b-42ffc5a45837"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cexpr", "=", 
  RowBox[{"ContractBasis", "[", "expr", "]"}]}]], "Input",
 CellLabel->
  "In[173]:=",ExpressionUUID->"548a95c6-39fa-4cdd-b119-5937f69198f7"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`polar}, -$CellContext`b, {
    2, $CellContext`cartesian}, $CellContext`c, {1, -$CellContext`polar}],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]], "c"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[{1, -$CellContext`polar}, -$CellContext`b, {
    2, $CellContext`cartesian}, $CellContext`c],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[173]=",ExpressionUUID->"cd14f4d5-4a21-447c-bd27-006b3734939a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SeparateBasis", "[", "AIndex", "]"}], "[", "cexpr", "]"}], "//", 
  "ScreenDollarIndices"}]], "Input",
 CellLabel->
  "In[174]:=",ExpressionUUID->"5bece986-0760-4793-a3a9-7b5708f5f7d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "e"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TT", 
        StyleBox[GridBox[{
           {" ", " ", "d", "c", " "},
           {"a", "b", " ", " ", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TT[-$CellContext`a, -$CellContext`b, $CellContext`d, \
$CellContext`c, -$CellContext`e],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 1., 0.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", "c"},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`d, \
$CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[174]=",ExpressionUUID->"9a2f3e29-fbff-4b52-bbb1-68569742bb5a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[175]:=",ExpressionUUID->"8164679e-d859-4574-a001-ab58fa03c245"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]]},
          {"d", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "e"},
             {
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"TT", 
          StyleBox[GridBox[{
             {" ", " ", "d", "c", " "},
             {"a", "b", " ", " ", "e"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`TT[-$CellContext`a, -$CellContext`b, $CellContext`d, \
$CellContext`c, -$CellContext`e],
      Editable->False]}], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"U", 
         StyleBox[GridBox[{
            {" ", " ", "d", "c"},
            {"a", "b", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`d, \
$CellContext`c],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[175]=",ExpressionUUID->"f2accbfd-355d-401c-8081-e7160eef9076"]
}, Open  ]],

Cell["\<\
But we may also want to perform a change of basis. This is done as follows\
\>", "Text",ExpressionUUID->"af622d27-d7d8-4beb-86f0-1a2ab685a91b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SeparateBasis", "[", "cartesian", "]"}], "[", "cexpr", "]"}], "//",
   "ScreenDollarIndices"}]], "Input",
 CellLabel->
  "In[176]:=",ExpressionUUID->"20a5e2fb-3ad2-413c-a702-f83641f675d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["d",
             FontColor->RGBColor[0., 1., 0.]]},
           {"b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`b, {$CellContext`d, \
$CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["a",
             FontColor->RGBColor[0., 1., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{
     1, -$CellContext`polar}, {$CellContext`a, $CellContext`cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["f1",
             FontColor->RGBColor[0., 1., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
 