(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[  34827603,     811519]
NotebookOptionsPosition[  34261438,     799803]
NotebookOutlinePosition[  34270437,     800003]
CellTagsIndexPosition[  34269803,     799984]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["xAct`xCoba`", "Section",
 FontSize->24,
 CellTags->{
  "S5.18.1", "1.1"},ExpressionUUID->"dbbba50a-4c94-44b0-a4d2-1993a97edb6b"],

Cell[TextData[{
 StyleBox["xCoba`", "MR"],
 " is the ",
 StyleBox["xAct`", "MR"],
 " package for tensor component computations. These are computations in which \
tensors are expressed as collections of scalar components (or coefficients) \
in a pre-defined basis of vector fields (or tensor products of them). Those \
components can be numbers or functions of the scalar fields of a given \
coordinate system or chart. It is, therefore, complementary to the abstract \
(aka geometric) approach of ",
 StyleBox["xTensor`", "MR"],
 ", where all computations are basis-free and coordinate-free. In ",
 StyleBox["xCoba`", "MR"],
 " the word \"basis\" is fully equivalent to the word \"frame\"."
}], "Text",
 CellChangeTimes->{{3.728649299105685*^9, 3.728649300206122*^9}, {
  3.728649345471011*^9, 3.7286495134044733`*^9}, {3.728649577666924*^9, 
  3.72864967506115*^9}, {3.728649774569929*^9, 3.728649797799415*^9}, {
  3.728650131879994*^9, 3.728650147623506*^9}, {3.728661019153554*^9, 
  3.728661081654855*^9}, {3.728733891302291*^9, 3.728733892939979*^9}, {
  3.790862853064907*^9, 
  3.7908629434119053`*^9}},ExpressionUUID->"3ea432db-0842-4a82-933f-\
4fc79004767f"],

Cell[TextData[{
 StyleBox["xCoba`", "MR"],
 " allows the user to define bases on one or more vector bundles and to \
handle basis vectors, using basis indices notation. It performs component \
calculations such as expanding a tensor in a specified basis, changing the \
basis of an expression or tracing the contraction of basis dummies. ",
 StyleBox["xCoba`", "MR"],
 " stores and handles component values efficiently, making full use of tensor \
symmetries. The package knows how to express derivatives and brackets of \
basis vectors in terms of Christoffel and torsion tensors and how to assign \
values to the components of a tensor. And many other things."
}], "Text",
 CellChangeTimes->{{3.728649299105685*^9, 3.728649300206122*^9}, {
  3.728649345471011*^9, 3.728649363276018*^9}, {3.7286499841202393`*^9, 
  3.7286499928149977`*^9}},
 CellID->981026496,ExpressionUUID->"0338f2fc-a904-4892-9b19-3ff6702765bf"],

Cell[TextData[{
 StyleBox["xCoba`", "MR"],
 " is fully compatible with ",
 StyleBox["xTensor`", "MR"],
 ". In fact, many computations in ",
 StyleBox["xCoba`", "MR"],
 " are performed using the ",
 StyleBox["xTensor`", "MR"],
 " functions. Note, however, that ",
 StyleBox["xTensor`", "MR"],
 " is  independent of ",
 StyleBox["xCoba`", "MR"],
 "."
}], "Text",
 CellChangeTimes->{{3.728649997245592*^9, 3.728650105457034*^9}, {
  3.728650186500956*^9, 3.728650253201866*^9}, {3.7286502897693043`*^9, 
  3.728650315223659*^9}, {3.728650373588835*^9, 3.728650395851543*^9}, {
  3.72873393607399*^9, 3.72873393692181*^9}},
 CellID->1715514340,ExpressionUUID->"fa9ac34b-3607-4207-92e9-185e063bce35"],

Cell[TextData[{
 "A crucial ingredient is the formalism of ",
 StyleBox["marked indices ",
  FontSlant->"Italic"],
 "and particularly the treatment of frame dependent objects. Perhaps the most \
conspicuous example is the covariant parallel derivative, which extends the \
concept of ordinary derivative as described on Wald's ",
 StyleBox["General Relativity.",
  FontSlant->"Italic"],
 " This reference has been the main inspiration for much of the notation, and \
the user is advised to keep it in mind when dealing with some of the non \
standard ideas employed by this package."
}], "Text",
 CellChangeTimes->{{3.728645682029468*^9, 3.728645684935066*^9}, 
   3.728650323793211*^9, {3.728650405923553*^9, 3.728650407811368*^9}, {
   3.728733946314147*^9, 3.7287339777201633`*^9}},
 CellID->2099645976,ExpressionUUID->"6474d4f7-8d4a-4dea-b3d1-8af5c08e2840"],

Cell["\<\
There are several ways of storing the components of a tensor, and xCoba` \
implements three of them:\
\>", "Text",
 CellChangeTimes->{{3.728650474519134*^9, 3.728650519215756*^9}, {
  3.7286527422542887`*^9, 3.728652753453808*^9}, {3.790863026057303*^9, 
  3.7908630366811*^9}},
 CellID->711920896,ExpressionUUID->"5f424d0a-16ab-4859-b710-5e7bb8907abd"],

Cell["\t1) Explicit linear combinations of Basis tensors.", "Text",
 CellChangeTimes->{{3.728650474519134*^9, 3.728650540756831*^9}, {
  3.728652758421358*^9, 3.728652758797284*^9}},
 CellID->519866281,ExpressionUUID->"87731305-ca71-46f2-ab1e-543f7913297c"],

Cell["\t2) A matrix (or array) based approach, using CTensor[...].", "Text",
 CellChangeTimes->{{3.7286505483317842`*^9, 3.7286505509083014`*^9}, {
  3.728652764661096*^9, 3.72865279018821*^9}, {3.728652825906341*^9, 
  3.7286528355450773`*^9}},
 CellID->1569558782,ExpressionUUID->"8e592d57-865d-451c-9c9e-525017076f79"],

Cell["\t3) Implicit storage of components of an abstract tensor.", "Text",
 CellChangeTimes->{{3.728652795587613*^9, 3.728652817778964*^9}},
 CellID->1902448593,ExpressionUUID->"57b046f0-6234-4e17-b5ad-ed61f3702da2"],

Cell["\<\
Each method has pros and cons, and you'll need to decide which method is most \
convenient for your computation. In general, the CTensor[...] approach is the \
easiest for simple manipulations, like computing all curvature tensors of a \
metric field expressed in a given coordinate system. The implicit storage \
method can be useful when working with computations that still have a \
strongly abstract flavor, or a high degree of symmetry. The explicit linear \
combinations can be useful for typesetting results. xCoba` provides functions \
to work in each of these representations, and also to change from one to \
another. This notebook contains descriptions of the three approaches and \
their relations.\
\>", "Text",
 CellChangeTimes->{{3.7286528488694687`*^9, 3.728653106702353*^9}, {
  3.7287340172566223`*^9, 3.728734083963386*^9}},
 CellID->166422542,ExpressionUUID->"ca3b484e-a3a6-4023-91b1-a60eef8264fe"],

Cell[TextData[{
 "Historically (in the development of ",
 StyleBox["xAct`", "MR"],
 "), method 1) was developed first, then method 3) and finally method 2) \
above. In hindsight, the CTensor[...] method 2) is the most natural and \
simplest of them, and we recommend you to start with it if you are new to ",
 StyleBox["xCoba`", "MR"],
 ". You can right now go to section 3 of this document."
}], "Text",
 CellChangeTimes->{{3.790863109490128*^9, 3.790863258626314*^9}, {
  3.790866420158791*^9, 3.790866466799429*^9}, {3.790867225498068*^9, 
  3.79086723724268*^9}},
 CellID->1209417041,ExpressionUUID->"d824ff7a-9884-45ba-bc77-126663bb22d5"],

Cell[CellGroupData[{

Cell["Load the package", "Subsection",
 CellChangeTimes->{{3.7908686241758003`*^9, 3.790868626368066*^9}, {
  3.790876643724308*^9, 
  3.790876645090822*^9}},ExpressionUUID->"c400feeb-afb2-4fb8-b75a-\
bc95a6dfa74c"],

Cell[CellGroupData[{

Cell[TextData[{
 "This loads the package from the default directory, for example $HOME/.",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "/AddOns/Applications/xAct/ for a single-user installation under Linux. ",
 StyleBox["xTensor`", "MR"],
 " and ",
 StyleBox["xPerm` ", "MR"],
 "are automatically loaded. See these [",
 ButtonBox["Installation notes",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://xact.es/download/install"], None},
  ButtonNote->"http://xact.es/download/install"],
 "] for help with installation."
}], "MathCaption",
 CellChangeTimes->{{3.728645731347241*^9, 3.72864573257948*^9}, {
  3.790866494535139*^9, 3.7908665173645697`*^9}, {3.7908665493546343`*^9, 
  3.7908665629689617`*^9}},
 CellTags->{
  "S5.18.1", "1.3"},ExpressionUUID->"905e69e0-0b65-4680-a63d-32011e1e7f2e"],

Cell[CellGroupData[{

Cell["<<xAct`xCoba`", "Input",
 CellTags->"S5.18.1",
 CellLabel->"In[1]:=",ExpressionUUID->"230b9d8c-8eb7-4fe3-9ce6-d08664c83251"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.79227312741565*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1179299757,ExpressionUUID->"ba9e778d-7b75-4d49-badd-8ace32f2ff65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127427191*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1364437736,ExpressionUUID->"81c1f1fe-1d92-4100-b475-ed767052ad80"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127439725*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1274646286,ExpressionUUID->"375f14ff-36e7-4c99-b124-e9243169232e"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127450056*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1830749977,ExpressionUUID->"5f20e29b-4673-4992-a466-a9e4352a4854"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127482608*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->269169223,ExpressionUUID->"29c5c7c7-d6f2-43fa-82bd-1ac7b2c2935e"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127490374*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1326570379,ExpressionUUID->"a1fdd9a4-466b-4b62-96b9-9d9112a747f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2020", ",", "2", ",", "16"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.4", ", ", {2020, 2, 16}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127503167*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->493136699,ExpressionUUID->"d6981527-ad0a-4b72-b1de-9d2aaccab228"],

Cell[BoxData["\<\"CopyRight (C) 2002-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127511488*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1009106320,ExpressionUUID->"605e2495-5085-4665-913a-70e8c1c4e280"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127605134*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1371559881,ExpressionUUID->"0cc75c7a-dfed-4d24-a707-c5d025a7c427"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2020", ",", "2", ",", "16"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.5", ", ", {2020, 2, 16}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.7922731276138773`*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->717453069,ExpressionUUID->"6f2083df-3a6f-45b1-993a-3ba0cc722b11"],

Cell[BoxData["\<\"CopyRight (C) 2005-2020, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.7922731276215487`*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->113052778,ExpressionUUID->"12c7c00d-d500-4221-8f3f-9b085dda45e2"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127630357*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1702495898,ExpressionUUID->"4ac41860-f22b-4a85-8cf3-1e92c262da90"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.7922731276385193`*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->776445058,ExpressionUUID->"2dcd86c4-fb1e-4819-a823-74f6e956c7b2"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.728645581071208*^9, 3.728655115243815*^9, 3.728655380154409*^9, 
   3.728660560061676*^9, 3.7286709929670486`*^9, 3.728674862207717*^9, 
   3.72873264668158*^9, 3.728732781528521*^9, 3.728732965353595*^9, 
   3.72873318559013*^9, 3.728733364720545*^9, 3.728742301210548*^9, 
   3.728743280643224*^9, 3.728743379944036*^9, 3.7287469076880608`*^9, 
   3.728749404278715*^9, 3.7287499227757874`*^9, 3.728750072885293*^9, 
   3.728750171031398*^9, 3.728750281089324*^9, 3.728750506187701*^9, 
   3.7287505659627943`*^9, 3.728750714044882*^9, {3.728750972665595*^9, 
   3.728750996561256*^9}, 3.728751603861548*^9, 3.7287593455663757`*^9, 
   3.728813252044345*^9, 3.728827368522168*^9, 3.728835952688724*^9, 
   3.728836285758855*^9, 3.728842985295206*^9, 3.728845607700259*^9, 
   3.733367186582423*^9, 3.790862251030995*^9, 3.790862558159748*^9, 
   3.790866581734527*^9, 3.7908689999729023`*^9, 3.7908712361143723`*^9, 
   3.790874168786983*^9, 3.7908742777079897`*^9, 3.7908750366484833`*^9, 
   3.790875820427225*^9, 3.790876581445723*^9, 3.790876651280979*^9, 
   3.7908767015020237`*^9, 3.791377987312237*^9, 3.7913816674423523`*^9, 
   3.79138963148276*^9, 3.791389715986176*^9, 3.791389779608074*^9, 
   3.79139065953981*^9, 3.792273127646978*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1601450634,ExpressionUUID->"76c3b7cc-ab4f-4624-a2ae-cf7a524c3985"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Hide dollar-indices, as usual (see ",
 StyleBox["xTensor`", "MR"],
 " documentation for more details on this):"
}], "MathCaption",
 CellChangeTimes->{{3.728732722010008*^9, 3.728732765425928*^9}},
 CellID->899063648,ExpressionUUID->"07b7acc4-9757-4c71-ab8a-974855d85ede"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], ";"}]], "Input",
 CellChangeTimes->{{3.7287327697928743`*^9, 3.72873277018363*^9}},
 CellLabel->"In[2]:=",
 CellID->867791644,ExpressionUUID->"542ec53a-331d-4856-a7d7-e70cc5cb75bc"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["0. xCoba` essentials", "Subsection",
 CellChangeTimes->{{3.728656510283742*^9, 3.728656511217067*^9}, {
  3.7286598570138693`*^9, 3.728659868855068*^9}, {3.728660932877496*^9, 
  3.7286609335000553`*^9}, {3.790868628359874*^9, 3.790868629072007*^9}, {
  3.790876656416953*^9, 
  3.790876657937037*^9}},ExpressionUUID->"1d1a3bbf-f661-4f3d-8fe4-\
621aa6bd670b"],

Cell[TextData[{
 "A session with ",
 StyleBox["xCoba`", "MR"],
 " begins just like one with ",
 StyleBox["xTensor`", "MR"],
 ", defining one or more manifolds and vector bundles and the objects living \
on them."
}], "Text",
 CellChangeTimes->{
  3.72864627574824*^9, {3.728655278473693*^9, 
   3.72865527924363*^9}},ExpressionUUID->"f0fe6d4f-06bd-416b-9c68-\
4dbe13a5980f"],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a 3d manifold ",
 StyleBox["M3", "MR"],
 ", with indices ",
 StyleBox["a...f",
  FontFamily->"Courier",
  FontWeight->"Regular"],
 ":"
}], "MathCaption",
 CellChangeTimes->{{3.790866613985384*^9, 
  3.79086662220093*^9}},ExpressionUUID->"d73d0932-aee1-47f0-97a5-\
1d9b24e8bb84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M3", ",", " ", "3", ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"2227dbb2-4f25-4016-a854-ecb257ec0cc6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728746913041642*^9, 3.728749407468087*^9, 3.7287499235469503`*^9, 
   3.728750073635009*^9, 3.728750174189872*^9, 3.728750281855173*^9, 
   3.7287505072177753`*^9, 3.728750570020459*^9, 3.728750715090887*^9, {
   3.7287509734858227`*^9, 3.728751000013081*^9}, 3.728751604536048*^9, 
   3.7288132529344807`*^9, 3.7288273693552027`*^9, 3.7288429914226313`*^9, 
   3.728845608707136*^9, 3.733367198261632*^9, 3.790862572598646*^9, 
   3.790866605593536*^9, 3.792273141701139*^9},
 CellLabel->"During evaluation of In[3]:=",
 CellID->293029645,ExpressionUUID->"90952141-66c3-40b6-9e8b-4a485d2388ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728746913041642*^9, 3.728749407468087*^9, 3.7287499235469503`*^9, 
   3.728750073635009*^9, 3.728750174189872*^9, 3.728750281855173*^9, 
   3.7287505072177753`*^9, 3.728750570020459*^9, 3.728750715090887*^9, {
   3.7287509734858227`*^9, 3.728751000013081*^9}, 3.728751604536048*^9, 
   3.7288132529344807`*^9, 3.7288273693552027`*^9, 3.7288429914226313`*^9, 
   3.728845608707136*^9, 3.733367198261632*^9, 3.790862572598646*^9, 
   3.790866605593536*^9, 3.7922731417097*^9},
 CellLabel->"During evaluation of In[3]:=",
 CellID->769240944,ExpressionUUID->"ddb35440-7399-42e7-b857-c7fce7c011ee"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Define a complex vector bundle (the warnings are purely informative and \
harmless):\
\>", "MathCaption",
 CellChangeTimes->{
  3.7286552824253073`*^9, {3.728732672908708*^9, 3.728732681972042*^9}, {
   3.728732994022616*^9, 
   3.7287330054606743`*^9}},ExpressionUUID->"2f4e63a1-9698-4648-be5f-\
74b3a9d261cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefVBundle", "[", 
  RowBox[{"InnerC", ",", "M3", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "G"}], "}"}], 
   ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"1c61b0aa-a0ba-45a1-b437-0e5a59a551ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "InnerC", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`InnerC, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728732789216392*^9, 3.728733007375355*^9, 3.728733189752511*^9, 
   3.7287333656471233`*^9, 3.728742302205514*^9, 3.7287432820370502`*^9, 
   3.728743381304302*^9, 3.728746914762179*^9, 3.7287494080059566`*^9, 
   3.7287499237170897`*^9, 3.7287500737875147`*^9, 3.728750174415072*^9, 
   3.728750282026334*^9, 3.728750507387027*^9, 3.72875057027335*^9, 
   3.728750715260644*^9, {3.7287509736369467`*^9, 3.72875100021126*^9}, 
   3.72875160470079*^9, 3.7288132531123457`*^9, 3.728827369570734*^9, 
   3.728842992769582*^9, 3.728845608939727*^9, 3.733367199611528*^9, 
   3.790862574415738*^9, 3.790866684316745*^9, 3.792273143027075*^9},
 CellLabel->"During evaluation of In[4]:=",
 CellID->1034147936,ExpressionUUID->"9fe35c8a-fa01-4731-b10d-4e8e8ceaf3c2"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"C\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 4, 1, 19668387891272167742, "Local", 
   "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{
  3.728645867902925*^9, 3.728655158876857*^9, 3.728655384910871*^9, 
   3.728660570057692*^9, 3.7286710165454817`*^9, 3.728674863441874*^9, 
   3.728732667790407*^9, 3.7287327892828617`*^9, 3.728733007445066*^9, 
   3.72873318985763*^9, 3.728733365719778*^9, 3.728742302337237*^9, 
   3.728743282128933*^9, 3.728743381368064*^9, 3.728746914857394*^9, 
   3.728749408072154*^9, 3.728749923760768*^9, 3.728750073879168*^9, 
   3.7287501744942293`*^9, 3.728750282076119*^9, 3.7287505074364223`*^9, 
   3.7287505703431187`*^9, 3.728750715309421*^9, {3.728750973685526*^9, 
   3.7287510002788773`*^9}, 3.728751604786333*^9, 3.728813253206449*^9, 
   3.7288273696884193`*^9, 3.72884299288723*^9, 3.728845609088861*^9, 
   3.7333671996694517`*^9, 3.7908625744404907`*^9, 3.790866684333572*^9, 
   3.79227314305369*^9},
 CellLabel->"During evaluation of In[4]:=",
 CellID->1339205181,ExpressionUUID->"7695401f-4718-42c0-b04f-8e56c8635877"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"D\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 4, 2, 19668387891272167742, "Local", 
   "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{
  3.728645867902925*^9, 3.728655158876857*^9, 3.728655384910871*^9, 
   3.728660570057692*^9, 3.7286710165454817`*^9, 3.728674863441874*^9, 
   3.728732667790407*^9, 3.7287327892828617`*^9, 3.728733007445066*^9, 
   3.72873318985763*^9, 3.728733365719778*^9, 3.728742302337237*^9, 
   3.728743282128933*^9, 3.728743381368064*^9, 3.728746914857394*^9, 
   3.728749408072154*^9, 3.728749923760768*^9, 3.728750073879168*^9, 
   3.7287501744942293`*^9, 3.728750282076119*^9, 3.7287505074364223`*^9, 
   3.7287505703431187`*^9, 3.728750715309421*^9, {3.728750973685526*^9, 
   3.7287510002788773`*^9}, 3.728751604786333*^9, 3.728813253206449*^9, 
   3.7288273696884193`*^9, 3.72884299288723*^9, 3.728845609088861*^9, 
   3.7333671996694517`*^9, 3.7908625744404907`*^9, 3.790866684333572*^9, 
   3.7922731430656977`*^9},
 CellLabel->"During evaluation of In[4]:=",
 CellID->245372860,ExpressionUUID->"e3d52473-9aff-4678-a8ae-d3522aa85672"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "InnerC\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between InnerC \
and InnerC\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`InnerC\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between InnerC and InnerC\[Dagger]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728732789216392*^9, 3.728733007375355*^9, 3.728733189752511*^9, 
   3.7287333656471233`*^9, 3.728742302205514*^9, 3.7287432820370502`*^9, 
   3.728743381304302*^9, 3.728746914762179*^9, 3.7287494080059566`*^9, 
   3.7287499237170897`*^9, 3.7287500737875147`*^9, 3.728750174415072*^9, 
   3.728750282026334*^9, 3.728750507387027*^9, 3.72875057027335*^9, 
   3.728750715260644*^9, {3.7287509736369467`*^9, 3.72875100021126*^9}, 
   3.72875160470079*^9, 3.7288132531123457`*^9, 3.728827369570734*^9, 
   3.728842992769582*^9, 3.728845608939727*^9, 3.733367199611528*^9, 
   3.790862574415738*^9, 3.790866684316745*^9, 3.792273143077354*^9},
 CellLabel->"During evaluation of In[4]:=",
 CellID->813055780,ExpressionUUID->"726ea625-8b95-43ae-9d74-519d49f6d3d6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a contravariant vector ",
 StyleBox["v", "MR"],
 " and a covariant symmetric tensor ",
 StyleBox["T", "MR"],
 ":"
}], "MathCaption",ExpressionUUID->"144e099c-20ee-46c4-b579-e9eda0162447"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "}"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"fa47a144-19e3-4f11-8851-55e3f7cfe830"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7287327908309793`*^9, 3.7287330150798683`*^9, 3.72873319130202*^9, 
   3.728733365935651*^9, 3.728742302604347*^9, 3.728743284012957*^9, 
   3.7287433815971527`*^9, 3.728746916401211*^9, 3.728749409729851*^9, 
   3.728749923918819*^9, 3.728750074081847*^9, 3.7287501748165493`*^9, 
   3.728750282448073*^9, 3.7287505076363583`*^9, 3.728750570506785*^9, 
   3.728750715507*^9, {3.728750973919486*^9, 3.728751000439788*^9}, 
   3.728751604992632*^9, 3.7288132534313*^9, 3.728827369938023*^9, 
   3.728842994170582*^9, 3.728845611657659*^9, 3.733367201295232*^9, 
   3.790862580791296*^9, 3.790866702489691*^9, 3.792273144126815*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->211920697,ExpressionUUID->"73315d18-a979-4e26-a785-4c75b58f02e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7287327908309793`*^9, 3.7287330150798683`*^9, 3.72873319130202*^9, 
   3.728733365935651*^9, 3.728742302604347*^9, 3.728743284012957*^9, 
   3.7287433815971527`*^9, 3.728746916401211*^9, 3.728749409729851*^9, 
   3.728749923918819*^9, 3.728750074081847*^9, 3.7287501748165493`*^9, 
   3.728750282448073*^9, 3.7287505076363583`*^9, 3.728750570506785*^9, 
   3.728750715507*^9, {3.728750973919486*^9, 3.728751000439788*^9}, 
   3.728751604992632*^9, 3.7288132534313*^9, 3.728827369938023*^9, 
   3.728842994170582*^9, 3.728845611657659*^9, 3.733367201295232*^9, 
   3.790862580791296*^9, 3.790866702489691*^9, 3.7922731441398487`*^9},
 CellLabel->"During evaluation of In[5]:=",
 CellID->1223267753,ExpressionUUID->"10f2167a-ccaa-4478-86bd-151a6a2d36fd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a Riemann symmetric tensor and a covariant vector on ",
 StyleBox["InnerC:", "MR"]
}], "MathCaption",
 CellChangeTimes->{
  3.7286552866653337`*^9},ExpressionUUID->"9e87e110-73d4-42a6-a9b0-\
9820a7c58a00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"R", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"RiemannSymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"1aa374b7-92b8-4bb2-b014-cf39b8e0f0d2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"R", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`R[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728732792164723*^9, 3.72873301786403*^9, 3.728733192700284*^9, 
   3.7287333661043043`*^9, 3.728742302834033*^9, 3.7287432841887074`*^9, 
   3.7287433834456463`*^9, 3.728746917914863*^9, 3.7287494108604794`*^9, 
   3.728749924068158*^9, 3.728750074236538*^9, 3.728750175184826*^9, 
   3.728750284228787*^9, 3.7287505099060297`*^9, 3.728750570672619*^9, 
   3.7287507173700647`*^9, {3.728750974090043*^9, 3.728751000623879*^9}, 
   3.728751605168685*^9, 3.7288132536292467`*^9, 3.728827370153162*^9, 
   3.728842995434134*^9, 3.7288456118472*^9, 3.733367203663684*^9, 
   3.7908625820867233`*^9, 3.79086670524874*^9, 3.792273145507202*^9},
 CellLabel->"During evaluation of In[7]:=",
 CellID->2123278630,ExpressionUUID->"f17adc8a-1554-437a-b866-8a0058efb006"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"R\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`R\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
    ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728732792164723*^9, 3.72873301786403*^9, 3.728733192700284*^9, 
   3.7287333661043043`*^9, 3.728742302834033*^9, 3.7287432841887074`*^9, 
   3.7287433834456463`*^9, 3.728746917914863*^9, 3.7287494108604794`*^9, 
   3.728749924068158*^9, 3.728750074236538*^9, 3.728750175184826*^9, 
   3.728750284228787*^9, 3.7287505099060297`*^9, 3.728750570672619*^9, 
   3.7287507173700647`*^9, {3.728750974090043*^9, 3.728751000623879*^9}, 
   3.728751605168685*^9, 3.7288132536292467`*^9, 3.728827370153162*^9, 
   3.728842995434134*^9, 3.7288456118472*^9, 3.733367203663684*^9, 
   3.7908625820867233`*^9, 3.79086670524874*^9, 3.792273145516654*^9},
 CellLabel->"During evaluation of In[7]:=",
 CellID->1208172211,ExpressionUUID->"430e5b8f-b19e-4f46-bc80-bddc73bf21bd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"-", "A"}], "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"09246897-571f-4402-a8c3-88dac122abee"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"u", "[", 
    RowBox[{"-", "A"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`u[-$CellContext`A], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728732793031885*^9, 3.7287330193964357`*^9, 3.7287331934176197`*^9, 
   3.728733367841752*^9, 3.728742304764203*^9, 3.728743284364119*^9, 
   3.728743383592803*^9, 3.728746918733553*^9, 3.728749411556912*^9, 
   3.728749924201953*^9, 3.728750075996698*^9, 3.7287501753276587`*^9, 
   3.728750284611602*^9, 3.7287505103051558`*^9, 3.728750570813385*^9, 
   3.728750717507382*^9, {3.728750975804295*^9, 3.7287510007569*^9}, 
   3.728751605335957*^9, 3.728813255344324*^9, 3.728827371940276*^9, 
   3.72884299626847*^9, 3.728845612040966*^9, 3.733367204313841*^9, 
   3.7908625832073307`*^9, 3.790866722977416*^9, 3.792273146039297*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->370703793,ExpressionUUID->"9cb4191c-52e6-4546-aa2d-de81d64e02a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"u\[Dagger]", "[", 
    RowBox[{"-", "A\[Dagger]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`u\[Dagger][-$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728732793031885*^9, 3.7287330193964357`*^9, 3.7287331934176197`*^9, 
   3.728733367841752*^9, 3.728742304764203*^9, 3.728743284364119*^9, 
   3.728743383592803*^9, 3.728746918733553*^9, 3.728749411556912*^9, 
   3.728749924201953*^9, 3.728750075996698*^9, 3.7287501753276587`*^9, 
   3.728750284611602*^9, 3.7287505103051558`*^9, 3.728750570813385*^9, 
   3.728750717507382*^9, {3.728750975804295*^9, 3.7287510007569*^9}, 
   3.728751605335957*^9, 3.728813255344324*^9, 3.728827371940276*^9, 
   3.72884299626847*^9, 3.728845612040966*^9, 3.733367204313841*^9, 
   3.7908625832073307`*^9, 3.790866722977416*^9, 3.7922731460509443`*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->568589004,ExpressionUUID->"f5d1b321-f009-4aeb-a074-92b6b7447389"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Remember that in ",
 StyleBox["xTensor`", "MR"],
 " we use abstract indices:"
}], "MathCaption",
 CellChangeTimes->{
  3.728655291680807*^9, {3.7908667412210817`*^9, 
   3.790866743469027*^9}},ExpressionUUID->"8df2b989-60fa-483e-92c7-\
b9c8d36c5750"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], 
  RowBox[{"v", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"3e510aa4-9ca5-4a69-b048-4e760800cdd1"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.7286458767146587`*^9, 3.7286551885318947`*^9, 3.728655390286623*^9, 
   3.728660571033349*^9, 3.728671028487309*^9, 3.728674865970592*^9, 
   3.7287326974532633`*^9, 3.7287327944319696`*^9, 3.728733022430253*^9, 
   3.728733195485608*^9, 3.728733368093307*^9, 3.7287423049633427`*^9, 
   3.7287432845473337`*^9, 3.7287433837479687`*^9, 3.728746921440851*^9, 
   3.728749412796199*^9, 3.7287499243361073`*^9, 3.728750076212714*^9, 
   3.728750175528617*^9, 3.728750284795129*^9, 3.7287505104627028`*^9, 
   3.72875057095914*^9, 3.7287507176556673`*^9, {3.728750976001012*^9, 
   3.728751000892148*^9}, 3.728751607089539*^9, 3.728813255544886*^9, 
   3.728827372169869*^9, 3.728842997551614*^9, 3.728845613230689*^9, 
   3.733367205486898*^9, 3.7908625846351757`*^9, 3.790866730650879*^9, 
   3.792273147399817*^9},
 CellLabel->"Out[9]=",
 CellID->1751099190,ExpressionUUID->"e0637ed9-f69f-441c-b979-9f0b0300d0da"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "A basis (or frame) is a set of independent vector fields on a vbundle, with \
an associated dual basis of vector fields. We only declare the name of the \
basis and the associated cnumbers (\"component numbers\"), integers that will \
identify the individual vectors/covectors. ",
 StyleBox["xCoba`", "MR"],
 " then constructs a number of geometric objects associated to the basis. We \
will review them in detail further down."
}], "Text",
 CellChangeTimes->{{3.728655215908573*^9, 3.7286552396036386`*^9}, {
  3.7286570835519457`*^9, 3.728657160267198*^9}, {3.7287330407074423`*^9, 
  3.728733115239875*^9}},ExpressionUUID->"f5748fd6-e0f0-4e93-ad14-\
30ba9184170e"],

Cell[CellGroupData[{

Cell[TextData[{
 "Now ",
 StyleBox["xCoba`", "MR"],
 "  lets us define a basis, called ",
 StyleBox["fred", "MR"],
 ". We have to specify its vector bundle and cnumbers. Several related \
objects are also defined (parallel derivative and associated tensors and \
densities):"
}], "MathCaption",
 CellChangeTimes->{{3.728655296528775*^9, 3.728655300136568*^9}, {
   3.728733121247657*^9, 3.728733164717702*^9}, {3.728733202092903*^9, 
   3.728733204091763*^9}, {3.7287469313471613`*^9, 3.728746932106833*^9}, 
   3.7908667908275957`*^9},ExpressionUUID->"e67021f0-f9cd-4b75-947a-\
e00601bd1833"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"fred", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728733172278639*^9, 3.728733172669983*^9}, {
  3.7287469345143843`*^9, 3.728746935106546*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"087432d1-54fc-4625-bf20-fe69ae86adb8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "fred", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`fred, 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458789989557`*^9, 3.728655348131331*^9, 3.728655396054265*^9, 
   3.728660571390258*^9, 3.728671031709518*^9, 3.728674866121977*^9, 
   3.728732798434576*^9, 3.728733169099123*^9, 3.728733233489567*^9, 
   3.7287333682539043`*^9, 3.728742305097023*^9, 3.728743284688232*^9, 
   3.7287433838776407`*^9, 3.728746936980541*^9, 3.728749414926165*^9, 
   3.728749926212223*^9, 3.728750076520802*^9, 3.728750175670993*^9, 
   3.728750284975143*^9, 3.728750510583269*^9, 3.728750571074135*^9, 
   3.7287507177754803`*^9, {3.728750976137418*^9, 3.7287510010086803`*^9}, 
   3.728751607274138*^9, 3.728813255662562*^9, 3.7288273723153343`*^9, 
   3.7288429998448687`*^9, 3.728845613410329*^9, 3.7333672104145803`*^9, 
   3.790862589001452*^9, 3.7908668047211323`*^9, 3.792273149394065*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1009788355,ExpressionUUID->"07145505-31b4-4972-8458-6a60642c1427"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDfred", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDfred[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458789989557`*^9, 3.728655348131331*^9, 3.728655396054265*^9, 
   3.728660571390258*^9, 3.728671031709518*^9, 3.728674866121977*^9, 
   3.728732798434576*^9, 3.728733169099123*^9, 3.728733233489567*^9, 
   3.7287333682539043`*^9, 3.728742305097023*^9, 3.728743284688232*^9, 
   3.7287433838776407`*^9, 3.728746936980541*^9, 3.728749414926165*^9, 
   3.728749926212223*^9, 3.728750076520802*^9, 3.728750175670993*^9, 
   3.728750284975143*^9, 3.728750510583269*^9, 3.728750571074135*^9, 
   3.7287507177754803`*^9, {3.728750976137418*^9, 3.7287510010086803`*^9}, 
   3.728751607274138*^9, 3.728813255662562*^9, 3.7288273723153343`*^9, 
   3.7288429998448687`*^9, 3.728845613410329*^9, 3.7333672104145803`*^9, 
   3.790862589001452*^9, 3.7908668047211323`*^9, 3.792273149407629*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->2097103891,ExpressionUUID->"a1676383-3aae-43cd-8644-a9771f721ad4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDfred", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDfred[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458789989557`*^9, 3.728655348131331*^9, 3.728655396054265*^9, 
   3.728660571390258*^9, 3.728671031709518*^9, 3.728674866121977*^9, 
   3.728732798434576*^9, 3.728733169099123*^9, 3.728733233489567*^9, 
   3.7287333682539043`*^9, 3.728742305097023*^9, 3.728743284688232*^9, 
   3.7287433838776407`*^9, 3.728746936980541*^9, 3.728749414926165*^9, 
   3.728749926212223*^9, 3.728750076520802*^9, 3.728750175670993*^9, 
   3.728750284975143*^9, 3.728750510583269*^9, 3.728750571074135*^9, 
   3.7287507177754803`*^9, {3.728750976137418*^9, 3.7287510010086803`*^9}, 
   3.728751607274138*^9, 3.728813255662562*^9, 3.7288273723153343`*^9, 
   3.7288429998448687`*^9, 3.728845613410329*^9, 3.7333672104145803`*^9, 
   3.790862589001452*^9, 3.7908668047211323`*^9, 3.7922731494221487`*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1523481473,ExpressionUUID->"d2d6785c-0e39-4a2b-bc5b-b3eb57923967"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDfred", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDfred[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458789989557`*^9, 3.728655348131331*^9, 3.728655396054265*^9, 
   3.728660571390258*^9, 3.728671031709518*^9, 3.728674866121977*^9, 
   3.728732798434576*^9, 3.728733169099123*^9, 3.728733233489567*^9, 
   3.7287333682539043`*^9, 3.728742305097023*^9, 3.728743284688232*^9, 
   3.7287433838776407`*^9, 3.728746936980541*^9, 3.728749414926165*^9, 
   3.728749926212223*^9, 3.728750076520802*^9, 3.728750175670993*^9, 
   3.728750284975143*^9, 3.728750510583269*^9, 3.728750571074135*^9, 
   3.7287507177754803`*^9, {3.728750976137418*^9, 3.7287510010086803`*^9}, 
   3.728751607274138*^9, 3.728813255662562*^9, 3.7288273723153343`*^9, 
   3.7288429998448687`*^9, 3.728845613410329*^9, 3.7333672104145803`*^9, 
   3.790862589001452*^9, 3.7908668047211323`*^9, 3.792273149430114*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->705593530,ExpressionUUID->"8838fbb9-2a5c-4beb-95b7-1ec14e0063be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDfred", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDfred[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458789989557`*^9, 3.728655348131331*^9, 3.728655396054265*^9, 
   3.728660571390258*^9, 3.728671031709518*^9, 3.728674866121977*^9, 
   3.728732798434576*^9, 3.728733169099123*^9, 3.728733233489567*^9, 
   3.7287333682539043`*^9, 3.728742305097023*^9, 3.728743284688232*^9, 
   3.7287433838776407`*^9, 3.728746936980541*^9, 3.728749414926165*^9, 
   3.728749926212223*^9, 3.728750076520802*^9, 3.728750175670993*^9, 
   3.728750284975143*^9, 3.728750510583269*^9, 3.728750571074135*^9, 
   3.7287507177754803`*^9, {3.728750976137418*^9, 3.7287510010086803`*^9}, 
   3.728751607274138*^9, 3.728813255662562*^9, 3.7288273723153343`*^9, 
   3.7288429998448687`*^9, 3.728845613410329*^9, 3.7333672104145803`*^9, 
   3.790862589001452*^9, 3.7908668047211323`*^9, 3.792273149437521*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->505759976,ExpressionUUID->"1b918961-8ade-4cf5-82cd-352e6e27a8bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDfred", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDfred[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458789989557`*^9, 3.728655348131331*^9, 3.728655396054265*^9, 
   3.728660571390258*^9, 3.728671031709518*^9, 3.728674866121977*^9, 
   3.728732798434576*^9, 3.728733169099123*^9, 3.728733233489567*^9, 
   3.7287333682539043`*^9, 3.728742305097023*^9, 3.728743284688232*^9, 
   3.7287433838776407`*^9, 3.728746936980541*^9, 3.728749414926165*^9, 
   3.728749926212223*^9, 3.728750076520802*^9, 3.728750175670993*^9, 
   3.728750284975143*^9, 3.728750510583269*^9, 3.728750571074135*^9, 
   3.7287507177754803`*^9, {3.728750976137418*^9, 3.7287510010086803`*^9}, 
   3.728751607274138*^9, 3.728813255662562*^9, 3.7288273723153343`*^9, 
   3.7288429998448687`*^9, 3.728845613410329*^9, 3.7333672104145803`*^9, 
   3.790862589001452*^9, 3.7908668047211323`*^9, 3.792273149444989*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->567641806,ExpressionUUID->"1769bf0c-6ad3-486d-9254-70352e1c8bb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpfred", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpfred[$CellContext`a, $CellContext`b, $CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458789989557`*^9, 3.728655348131331*^9, 3.728655396054265*^9, 
   3.728660571390258*^9, 3.728671031709518*^9, 3.728674866121977*^9, 
   3.728732798434576*^9, 3.728733169099123*^9, 3.728733233489567*^9, 
   3.7287333682539043`*^9, 3.728742305097023*^9, 3.728743284688232*^9, 
   3.7287433838776407`*^9, 3.728746936980541*^9, 3.728749414926165*^9, 
   3.728749926212223*^9, 3.728750076520802*^9, 3.728750175670993*^9, 
   3.728750284975143*^9, 3.728750510583269*^9, 3.728750571074135*^9, 
   3.7287507177754803`*^9, {3.728750976137418*^9, 3.7287510010086803`*^9}, 
   3.728751607274138*^9, 3.728813255662562*^9, 3.7288273723153343`*^9, 
   3.7288429998448687`*^9, 3.728845613410329*^9, 3.7333672104145803`*^9, 
   3.790862589001452*^9, 3.7908668047211323`*^9, 3.792273149452388*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1233473468,ExpressionUUID->"af12c497-c6c3-4f87-9f79-d34ab399bb97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownfred", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownfred[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458789989557`*^9, 3.728655348131331*^9, 3.728655396054265*^9, 
   3.728660571390258*^9, 3.728671031709518*^9, 3.728674866121977*^9, 
   3.728732798434576*^9, 3.728733169099123*^9, 3.728733233489567*^9, 
   3.7287333682539043`*^9, 3.728742305097023*^9, 3.728743284688232*^9, 
   3.7287433838776407`*^9, 3.728746936980541*^9, 3.728749414926165*^9, 
   3.728749926212223*^9, 3.728750076520802*^9, 3.728750175670993*^9, 
   3.728750284975143*^9, 3.728750510583269*^9, 3.728750571074135*^9, 
   3.7287507177754803`*^9, {3.728750976137418*^9, 3.7287510010086803`*^9}, 
   3.728751607274138*^9, 3.728813255662562*^9, 3.7288273723153343`*^9, 
   3.7288429998448687`*^9, 3.728845613410329*^9, 3.7333672104145803`*^9, 
   3.790862589001452*^9, 3.7908668047211323`*^9, 3.792273149460125*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1328932185,ExpressionUUID->"6baa3bcf-ed20-447d-b484-08e577adc695"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
These are the basis vector fields. We use covariant C-indices (\"component \
indices\") marked with their basis, with form {cnumber, -basis}:\
\>", "MathCaption",
 CellChangeTimes->{{3.7286554213388577`*^9, 3.7286554302267714`*^9}, {
  3.728656587316477*^9, 3.7286566273477287`*^9}, {3.728656659105844*^9, 
  3.728656670849522*^9}, {3.790866865777133*^9, 3.790866876200891*^9}},
 CellID->1847620262,ExpressionUUID->"bfbb7878-6d87-45eb-9b1f-8134d0c9e7df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"basis", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], ",", 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], ",", 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}]}], "}"}]}]], "Input",\

 CellChangeTimes->{{3.728655433054002*^9, 3.728655473937039*^9}, {
  3.728655514407632*^9, 3.728655516206547*^9}, {3.728733242650382*^9, 
  3.7287332602723618`*^9}, {3.728746947243972*^9, 3.728746952129867*^9}},
 CellLabel->"In[11]:=",
 CellID->1127027992,ExpressionUUID->"184ddbd8-4220-455a-bebc-cb681598f84f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["0",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.728655462000415*^9, 3.728655474457041*^9}, 
   3.728655516531454*^9, 3.728660571825045*^9, 3.7286710330549717`*^9, 
   3.7286748665619583`*^9, 3.728732799816126*^9, 3.728733261926977*^9, 
   3.728733368588394*^9, 3.728742305394815*^9, 3.728743285013411*^9, 
   3.728743384176815*^9, 3.7287469527783337`*^9, 3.7287494163473053`*^9, 
   3.728749926494989*^9, 3.7287500769651737`*^9, 3.728750175896924*^9, 
   3.7287502853269243`*^9, 3.728750511073656*^9, 3.728750571339703*^9, 
   3.728750717993685*^9, {3.728750976350565*^9, 3.728751001246626*^9}, 
   3.728751607577166*^9, 3.728813255942058*^9, 3.728827372638554*^9, 
   3.728843001219489*^9, 3.72884561372703*^9, 3.7333672119989758`*^9, 
   3.790862590535096*^9, 3.7908668271189413`*^9, 3.79227315095926*^9},
 CellLabel->"Out[11]=",
 CellID->1870663923,ExpressionUUID->"867453c7-31ee-48dc-8797-b58f5cef4fe1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", "fred", "]"}], "[", "a", "]"}]], "Input",
 CellChangeTimes->{{3.728733265265188*^9, 3.728733269140704*^9}, {
  3.7287469546834707`*^9, 3.7287469551694403`*^9}},
 CellLabel->"In[12]:=",
 CellID->1216174007,ExpressionUUID->"cde85017-b1a2-4b16-af78-9a532fb54ba8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["0",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.728645911058243*^9, 3.728659447223671*^9, 3.728660571999341*^9, 
   3.728671033670998*^9, 3.728674866709922*^9, 3.728732800612605*^9, 
   3.728733271009583*^9, 3.7287333687759123`*^9, 3.728742305525177*^9, 
   3.728743285162301*^9, 3.728743384329052*^9, 3.7287469556495457`*^9, 
   3.728749417012884*^9, 3.728749926617692*^9, 3.7287500771045313`*^9, 
   3.728750176031145*^9, 3.728750285508523*^9, 3.728750511331139*^9, 
   3.728750571478397*^9, 3.728750718103443*^9, {3.728750976527994*^9, 
   3.728751001385909*^9}, 3.728751607692135*^9, 3.728813256047917*^9, 
   3.7288273727741003`*^9, 3.728843001934779*^9, 3.7288456139106503`*^9, 
   3.733367212698457*^9, 3.7908625913323717`*^9, 3.79086682930262*^9, 
   3.792273151710997*^9},
 CellLabel->"Out[12]=",
 CellID->823175240,ExpressionUUID->"773b7ba5-ac1b-4482-8aa3-a01368a66620"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
And these are the basis covector fields. We use contravariant C-indices of \
the form {cnumber, basis}:\
\>", "MathCaption",
 CellChangeTimes->{{3.728655484409545*^9, 3.7286554903999767`*^9}, {
  3.72865555160491*^9, 3.728655553004799*^9}, {3.7286566170037727`*^9, 
  3.728656666801887*^9}},
 CellID->1297931365,ExpressionUUID->"6c7c536b-1f29-4165-95e7-d244a9731e07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cobasis", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "fred"}], "}"}]}], "]"}], ",", 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "fred"}], "}"}]}], "]"}], ",", 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "fred"}], "}"}]}], "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7286554961356153`*^9, 3.728655543709876*^9}, {
   3.728733275641111*^9, 3.728733284360139*^9}, 3.7287333470137243`*^9, {
   3.728746959955346*^9, 3.728746964441264*^9}},
 CellLabel->"In[13]:=",
 CellID->659237437,ExpressionUUID->"e5a12cc0-15d1-49e0-a791-2092a633badc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["0",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {0, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`fred}],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.728655523231439*^9, 3.7286555442025003`*^9}, 
   3.72866057246726*^9, 3.728671034688511*^9, 3.728674866859187*^9, 
   3.728732801898532*^9, 3.728733287196742*^9, {3.7287333478856897`*^9, 
   3.72873336924189*^9}, 3.728742305638713*^9, 3.7287432853015833`*^9, 
   3.7287433844761047`*^9, 3.728746965111393*^9, 3.728749418096479*^9, 
   3.728749926724791*^9, 3.728750077235261*^9, 3.728750176182753*^9, 
   3.728750285948215*^9, 3.728750511659299*^9, 3.728750571608736*^9, 
   3.728750718226863*^9, {3.728750976723653*^9, 3.7287510015101547`*^9}, 
   3.7287516078344927`*^9, 3.728813256177154*^9, 3.72882737292388*^9, 
   3.7288430030518723`*^9, 3.7288456140718527`*^9, 3.7333672137929697`*^9, 
   3.790862595054039*^9, 3.790866923596253*^9, 3.7922731547611647`*^9},
 CellLabel->"Out[13]=",
 CellID->467570674,ExpressionUUID->"9b553423-f706-4774-919b-b3b99757f0e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", "fred", "]"}], "[", 
  RowBox[{"-", "a"}], "]"}]], "Input",
 CellChangeTimes->{{3.728659454681059*^9, 3.728659493663294*^9}, {
  3.72873329165604*^9, 3.728733295218252*^9}, {3.728746967450945*^9, 
  3.728746968000918*^9}},
 CellLabel->"In[14]:=",
 CellID->1565089844,ExpressionUUID->"08b1c38d-b280-4ba5-9542-498233de0309"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["0",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {0, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`fred}],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.728645911058243*^9, {3.728659455765608*^9, 3.728659494614534*^9}, 
   3.7286605726554947`*^9, 3.7286710352686777`*^9, 3.728674867012429*^9, 
   3.7287328031389713`*^9, 3.728733296230047*^9, {3.728733348636352*^9, 
   3.728733369572157*^9}, 3.7287423057719584`*^9, 3.7287432854466*^9, 
   3.728743384626629*^9, 3.72874696848363*^9, 3.7287494187800407`*^9, 
   3.7287499268513412`*^9, 3.728750077368993*^9, 3.7287501763580847`*^9, 
   3.728750286131349*^9, 3.728750511777478*^9, 3.728750571762067*^9, 
   3.728750718350115*^9, {3.7287509768307056`*^9, 3.7287510016252117`*^9}, 
   3.7287516079667788`*^9, 3.7288132562848253`*^9, 3.7288273730496197`*^9, 
   3.728843003731093*^9, 3.728845614233707*^9, 3.733367214431109*^9, 
   3.790862595767466*^9, 3.790866927050166*^9, 3.79227315541717*^9},
 CellLabel->"Out[14]=",
 CellID->605431428,ExpressionUUID->"e113f92b-1c0b-45c5-abd3-69bddb4ade84"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The so-called ",
 StyleBox["parallel derivative",
  FontSlant->"Italic"],
 " of the ",
 StyleBox["fred", "MR"],
 " basis (denoted ",
 StyleBox["PDfred", "MR"],
 ") is a covariant derivative operator with the fundamental property of \
giving zero on all elements of the basis and its cobasis:"
}], "MathCaption",
 CellChangeTimes->{{3.728655584668852*^9, 3.728655607274728*^9}, {
   3.7286558176967297`*^9, 3.728655858167245*^9}, {3.728655988865336*^9, 
   3.728655988961316*^9}, {3.728656051438716*^9, 3.7286560766764812`*^9}, 
   3.728656941245068*^9, {3.728733310608329*^9, 3.728733315366745*^9}, {
   3.7908669597263927`*^9, 3.790866965062149*^9}},
 CellID->1988507208,ExpressionUUID->"30041a36-35a2-422b-b446-4df5385dfd6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDfred", "[", 
   RowBox[{"-", "b"}], "]"}], "/@", "basis"}]], "Input",
 CellChangeTimes->{{3.728655791316927*^9, 3.7286557990634413`*^9}, {
  3.728733324726336*^9, 3.7287333271524982`*^9}, {3.728746971626563*^9, 
  3.728746973264761*^9}},
 CellLabel->"In[15]:=",
 CellID->1795804312,ExpressionUUID->"080a21f4-b11e-4035-8174-656b65cd33df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7286557996652613`*^9, 3.728660572842967*^9, 3.7286710377564917`*^9, 
   3.728674867167346*^9, 3.7287328068672523`*^9, {3.728733327850851*^9, 
   3.7287333698887377`*^9}, 3.728742305905595*^9, 3.728743285581959*^9, 
   3.728743384775867*^9, 3.72874697381513*^9, 3.728749420505151*^9, 
   3.728749926996276*^9, 3.728750077498836*^9, 3.72875017649741*^9, 
   3.728750286469523*^9, 3.728750512158341*^9, 3.728750571963519*^9, 
   3.728750718450172*^9, {3.7287509769087143`*^9, 3.728751001780058*^9}, 
   3.728751608097495*^9, 3.728813256405746*^9, 3.728827373172605*^9, 
   3.7288430051687403`*^9, 3.728845614383861*^9, 3.733367215732592*^9, 
   3.7908625970352182`*^9, 3.7908669938739557`*^9, 3.7922731571405573`*^9},
 CellLabel->"Out[15]=",
 CellID->892606450,ExpressionUUID->"7b18a9c0-66e5-43fe-9f12-0f3afd5acc02"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDfred", "[", 
   RowBox[{"-", "b"}], "]"}], "/@", "cobasis"}]], "Input",
 CellChangeTimes->{{3.728655802055221*^9, 3.728655808977315*^9}, {
  3.728733330526189*^9, 3.7287333329763403`*^9}, {3.728746975722322*^9, 
  3.7287469767845716`*^9}},
 CellLabel->"In[16]:=",
 CellID->1945905506,ExpressionUUID->"e38a628e-0602-41d9-af35-a7b5321a68a3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.728655809472327*^9, 3.7286605731302767`*^9, 3.7286710383589993`*^9, 
   3.728674867317415*^9, 3.728732808033497*^9, {3.728733333818017*^9, 
   3.72873337017198*^9}, 3.728742306022086*^9, 3.7287432857184258`*^9, 
   3.728743384896708*^9, 3.728746977324727*^9, 3.728749421239315*^9, 
   3.728749927108137*^9, 3.728750077632869*^9, 3.728750176660335*^9, 
   3.728750286797181*^9, 3.728750512468728*^9, 3.728750572109757*^9, 
   3.728750718573182*^9, {3.7287509770030193`*^9, 3.728751001898838*^9}, 
   3.728751608229992*^9, 3.728813256512205*^9, 3.7288273733169317`*^9, 
   3.7288430057926407`*^9, 3.728845614532275*^9, 3.733367216363984*^9, 
   3.7908625976776953`*^9, 3.7908669957894573`*^9, 3.792273157652977*^9},
 CellLabel->"Out[16]=",
 CellID->993820116,ExpressionUUID->"0bb558b1-33dd-4e0d-8955-07f90454dab9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "As any other covariant derivative operator, it has curvature and torsion. \
Parallel derivatives always have zero curvature, but they have torsion if \
they are associated to non-coordinate (or anholonomic) bases. In ",
 StyleBox["xCoba`", "MR"],
 " the defined bases are non-coordinate by default:"
}], "MathCaption",
 CellChangeTimes->{{3.7286568087702217`*^9, 3.728656895535421*^9}, {
  3.728657179641828*^9, 3.7286572275036793`*^9}},
 CellID->1341226455,ExpressionUUID->"e3936a74-132d-44fc-b228-0fe43db46f04"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Riemann", "[", "PDfred", "]"}], "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", "d"}], "]"}]], "Input",
 CellChangeTimes->{{3.7286568998667603`*^9, 3.72865690711069*^9}, {
  3.7287333747251883`*^9, 3.728733376815939*^9}, {3.728746980072507*^9, 
  3.728746981272419*^9}},
 CellLabel->"In[17]:=",
 CellID->1937961720,ExpressionUUID->"23d79355-2836-42ce-a4e2-308af96ae7ff"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.7286569075810328`*^9, 3.728660573290009*^9, 3.728671039577153*^9, 
   3.728674867487274*^9, 3.72873280973309*^9, 3.7287333777732267`*^9, 
   3.728742306159916*^9, 3.728743285866784*^9, 3.728743385028717*^9, 
   3.728746982732587*^9, 3.728749422563686*^9, 3.728749927290986*^9, 
   3.7287500777681417`*^9, 3.728750176770134*^9, 3.728750286960092*^9, 
   3.7287505126199617`*^9, 3.7287505722797747`*^9, 3.72875071869069*^9, {
   3.72875097712186*^9, 3.7287510020002937`*^9}, 3.72875160836451*^9, 
   3.728813256636408*^9, 3.7288273734419928`*^9, 3.728843007109387*^9, 
   3.7288456147547092`*^9, 3.7333672183820753`*^9, 3.7908625989397917`*^9, 
   3.790867021722987*^9, 3.7922731591901493`*^9},
 CellLabel->"Out[17]=",
 CellID->294662927,ExpressionUUID->"a2c4d7de-cf2f-4c7c-8e2a-c17c918d58e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Torsion", "[", "PDfred", "]"}], "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7286569087143793`*^9, 3.728656915486318*^9}, {
  3.728733379757504*^9, 3.728733381295504*^9}, {3.728746984442017*^9, 
  3.7287469857200203`*^9}},
 CellLabel->"In[18]:=",
 CellID->1385272999,ExpressionUUID->"9a072d86-7c51-46a6-a794-ea1ce43b63f9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox["T",
       FontColor->RGBColor[1., 0., 0.]], 
      StyleBox[GridBox[{
         {"a", " ", " "},
         {" ", "b", "c"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TorsionPDfred[$CellContext`a, -$CellContext`b, -$CellContext`c],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728656915895322*^9, 3.728660573440927*^9, 3.728671040155109*^9, 
   3.728674867638186*^9, 3.728732810666657*^9, 3.728733382156805*^9, 
   3.728742306292121*^9, 3.728743286000317*^9, 3.7287433851643877`*^9, 
   3.728746986130619*^9, 3.7287494231916647`*^9, 3.728749927394438*^9, 
   3.7287500779197693`*^9, 3.72875017689419*^9, 3.728750287418477*^9, 
   3.728750512770618*^9, 3.728750572426141*^9, 3.7287507188415127`*^9, {
   3.728750977236865*^9, 3.728751002100812*^9}, 3.728751608500063*^9, 
   3.728813256755705*^9, 3.72882737358352*^9, 3.728843007818997*^9, 
   3.728845615178458*^9, 3.733367219048399*^9, 3.790862599586281*^9, 
   3.7908670227245493`*^9, 3.792273159813241*^9},
 CellLabel->"Out[18]=",
 CellID->1257509919,ExpressionUUID->"acc7e043-d07c-4b5b-8f6f-ea6ceaccec25"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Each basis has a color (red by default), used to identify its associated \
objects in StandardForm. Define another basis, colored blue:\
\>", "MathCaption",
 CellChangeTimes->{{3.7286553028803997`*^9, 3.728655358878181*^9}, {
  3.728656088189817*^9, 
  3.728656102211955*^9}},ExpressionUUID->"9291b8b6-e93e-46b0-889f-\
10bfad8faacc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"blues", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728655362000798*^9, 3.72865536249697*^9}, {
   3.7287333933173723`*^9, 3.728733407178443*^9}, {3.728747009402038*^9, 
   3.728747010455083*^9}, 3.728749224921836*^9},
 CellLabel->"In[19]:=",ExpressionUUID->"01f5cb31-2e45-4c6f-a741-9ffabb0fc8e2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "blues", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`blues, 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458808338213`*^9, 3.728655352350588*^9, 3.728656105652667*^9, 
   3.728660573642881*^9, 3.728671045107004*^9, 3.728674867807619*^9, 
   3.728732812164307*^9, 3.728733409396785*^9, 3.728742306408434*^9, 
   3.728743286153721*^9, 3.7287433853131237`*^9, 3.728747012484117*^9, 
   3.728749424327572*^9, 3.728749927526626*^9, 3.728750078069125*^9, 
   3.728750177076168*^9, 3.728750287577373*^9, 3.728750512885186*^9, 
   3.728750572558249*^9, 3.728750718969363*^9, {3.72875097735047*^9, 
   3.728751002205101*^9}, 3.728751608630973*^9, 3.728813256877846*^9, 
   3.72882737373587*^9, 3.728843009027207*^9, 3.728845615342039*^9, 
   3.733367220212503*^9, 3.790862603802002*^9, 3.790867032499701*^9, 
   3.7922731615125628`*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->175165393,ExpressionUUID->"38372027-d060-4742-b26b-76a3b75a5413"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDblues", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDblues[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458808338213`*^9, 3.728655352350588*^9, 3.728656105652667*^9, 
   3.728660573642881*^9, 3.728671045107004*^9, 3.728674867807619*^9, 
   3.728732812164307*^9, 3.728733409396785*^9, 3.728742306408434*^9, 
   3.728743286153721*^9, 3.7287433853131237`*^9, 3.728747012484117*^9, 
   3.728749424327572*^9, 3.728749927526626*^9, 3.728750078069125*^9, 
   3.728750177076168*^9, 3.728750287577373*^9, 3.728750512885186*^9, 
   3.728750572558249*^9, 3.728750718969363*^9, {3.72875097735047*^9, 
   3.728751002205101*^9}, 3.728751608630973*^9, 3.728813256877846*^9, 
   3.72882737373587*^9, 3.728843009027207*^9, 3.728845615342039*^9, 
   3.733367220212503*^9, 3.790862603802002*^9, 3.790867032499701*^9, 
   3.792273161525831*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1952163761,ExpressionUUID->"75914c48-15b9-42b6-8572-8aac4d274b9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDblues", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDblues[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458808338213`*^9, 3.728655352350588*^9, 3.728656105652667*^9, 
   3.728660573642881*^9, 3.728671045107004*^9, 3.728674867807619*^9, 
   3.728732812164307*^9, 3.728733409396785*^9, 3.728742306408434*^9, 
   3.728743286153721*^9, 3.7287433853131237`*^9, 3.728747012484117*^9, 
   3.728749424327572*^9, 3.728749927526626*^9, 3.728750078069125*^9, 
   3.728750177076168*^9, 3.728750287577373*^9, 3.728750512885186*^9, 
   3.728750572558249*^9, 3.728750718969363*^9, {3.72875097735047*^9, 
   3.728751002205101*^9}, 3.728751608630973*^9, 3.728813256877846*^9, 
   3.72882737373587*^9, 3.728843009027207*^9, 3.728845615342039*^9, 
   3.733367220212503*^9, 3.790862603802002*^9, 3.790867032499701*^9, 
   3.792273161540303*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->761172261,ExpressionUUID->"f8cff853-766e-4995-9938-2f77693c6975"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDblues", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDblues[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458808338213`*^9, 3.728655352350588*^9, 3.728656105652667*^9, 
   3.728660573642881*^9, 3.728671045107004*^9, 3.728674867807619*^9, 
   3.728732812164307*^9, 3.728733409396785*^9, 3.728742306408434*^9, 
   3.728743286153721*^9, 3.7287433853131237`*^9, 3.728747012484117*^9, 
   3.728749424327572*^9, 3.728749927526626*^9, 3.728750078069125*^9, 
   3.728750177076168*^9, 3.728750287577373*^9, 3.728750512885186*^9, 
   3.728750572558249*^9, 3.728750718969363*^9, {3.72875097735047*^9, 
   3.728751002205101*^9}, 3.728751608630973*^9, 3.728813256877846*^9, 
   3.72882737373587*^9, 3.728843009027207*^9, 3.728845615342039*^9, 
   3.733367220212503*^9, 3.790862603802002*^9, 3.790867032499701*^9, 
   3.792273161547595*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->462105448,ExpressionUUID->"b6999010-c6fe-4aa8-859a-375782b264df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDblues", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDblues[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458808338213`*^9, 3.728655352350588*^9, 3.728656105652667*^9, 
   3.728660573642881*^9, 3.728671045107004*^9, 3.728674867807619*^9, 
   3.728732812164307*^9, 3.728733409396785*^9, 3.728742306408434*^9, 
   3.728743286153721*^9, 3.7287433853131237`*^9, 3.728747012484117*^9, 
   3.728749424327572*^9, 3.728749927526626*^9, 3.728750078069125*^9, 
   3.728750177076168*^9, 3.728750287577373*^9, 3.728750512885186*^9, 
   3.728750572558249*^9, 3.728750718969363*^9, {3.72875097735047*^9, 
   3.728751002205101*^9}, 3.728751608630973*^9, 3.728813256877846*^9, 
   3.72882737373587*^9, 3.728843009027207*^9, 3.728845615342039*^9, 
   3.733367220212503*^9, 3.790862603802002*^9, 3.790867032499701*^9, 
   3.79227316155514*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1305396984,ExpressionUUID->"cf96c5f8-8290-430f-8ec7-a5aeac738910"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDblues", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDblues[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458808338213`*^9, 3.728655352350588*^9, 3.728656105652667*^9, 
   3.728660573642881*^9, 3.728671045107004*^9, 3.728674867807619*^9, 
   3.728732812164307*^9, 3.728733409396785*^9, 3.728742306408434*^9, 
   3.728743286153721*^9, 3.7287433853131237`*^9, 3.728747012484117*^9, 
   3.728749424327572*^9, 3.728749927526626*^9, 3.728750078069125*^9, 
   3.728750177076168*^9, 3.728750287577373*^9, 3.728750512885186*^9, 
   3.728750572558249*^9, 3.728750718969363*^9, {3.72875097735047*^9, 
   3.728751002205101*^9}, 3.728751608630973*^9, 3.728813256877846*^9, 
   3.72882737373587*^9, 3.728843009027207*^9, 3.728845615342039*^9, 
   3.733367220212503*^9, 3.790862603802002*^9, 3.790867032499701*^9, 
   3.792273161562517*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1114172336,ExpressionUUID->"80b02b7a-4e63-4408-ada1-22c125276511"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpblues", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpblues[$CellContext`a, $CellContext`b, $CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458808338213`*^9, 3.728655352350588*^9, 3.728656105652667*^9, 
   3.728660573642881*^9, 3.728671045107004*^9, 3.728674867807619*^9, 
   3.728732812164307*^9, 3.728733409396785*^9, 3.728742306408434*^9, 
   3.728743286153721*^9, 3.7287433853131237`*^9, 3.728747012484117*^9, 
   3.728749424327572*^9, 3.728749927526626*^9, 3.728750078069125*^9, 
   3.728750177076168*^9, 3.728750287577373*^9, 3.728750512885186*^9, 
   3.728750572558249*^9, 3.728750718969363*^9, {3.72875097735047*^9, 
   3.728751002205101*^9}, 3.728751608630973*^9, 3.728813256877846*^9, 
   3.72882737373587*^9, 3.728843009027207*^9, 3.728845615342039*^9, 
   3.733367220212503*^9, 3.790862603802002*^9, 3.790867032499701*^9, 
   3.7922731615697107`*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1984532959,ExpressionUUID->"25c1bc30-3e76-4558-9191-872f42012ae4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownblues", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownblues[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286458808338213`*^9, 3.728655352350588*^9, 3.728656105652667*^9, 
   3.728660573642881*^9, 3.728671045107004*^9, 3.728674867807619*^9, 
   3.728732812164307*^9, 3.728733409396785*^9, 3.728742306408434*^9, 
   3.728743286153721*^9, 3.7287433853131237`*^9, 3.728747012484117*^9, 
   3.728749424327572*^9, 3.728749927526626*^9, 3.728750078069125*^9, 
   3.728750177076168*^9, 3.728750287577373*^9, 3.728750512885186*^9, 
   3.728750572558249*^9, 3.728750718969363*^9, {3.72875097735047*^9, 
   3.728751002205101*^9}, 3.728751608630973*^9, 3.728813256877846*^9, 
   3.72882737373587*^9, 3.728843009027207*^9, 3.728845615342039*^9, 
   3.733367220212503*^9, 3.790862603802002*^9, 3.790867032499701*^9, 
   3.792273161577112*^9},
 CellLabel->"During evaluation of In[19]:=",
 CellID->1476920356,ExpressionUUID->"bfdf68ce-aaaf-4e5a-8413-d7db42039835"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
For example, these are the parallel derivatives of the bases acting on a \
given tensor field:\
\>", "MathCaption",
 CellChangeTimes->{{3.728656290588045*^9, 3.7286563303043003`*^9}, {
  3.728656744030398*^9, 3.7286567638451138`*^9}, {3.7286569685473757`*^9, 
  3.7286569810274267`*^9}},
 CellID->1984038762,ExpressionUUID->"391bcf87-e02f-46a0-ae84-04de15fddfa1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDfred", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.728733416906411*^9, 3.728733418173409*^9}, {
  3.728747016598736*^9, 3.728747017886704*^9}},
 CellLabel->"In[20]:=",
 CellID->1760885965,ExpressionUUID->"f14ab5d7-76cc-4ee3-958e-22377b581561"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox[
     StyleBox["\[ScriptCapitalD]",
      FontColor->RGBColor[1., 0., 0.]], "a"], GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " "},
          {"b", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`PDfred[-$CellContext`a][
   $CellContext`T[-$CellContext`b, -$CellContext`c]],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728645884210881*^9, 3.728656293543068*^9, 3.728660574295596*^9, 
   3.728671046357476*^9, 3.728674868236816*^9, 3.72873281400082*^9, 
   3.728733418876144*^9, 3.728742306691835*^9, 3.728743286534622*^9, 
   3.7287433856599903`*^9, 3.7287470186269627`*^9, 3.728749426030559*^9, 
   3.728749927769022*^9, 3.7287500782793627`*^9, 3.728750177340556*^9, 
   3.7287502881189833`*^9, 3.72875051313247*^9, 3.728750572793954*^9, 
   3.728750719222075*^9, {3.728750977633602*^9, 3.7287510024074707`*^9}, 
   3.728751608934576*^9, 3.728813257174419*^9, 3.7288273740535583`*^9, 
   3.728843010586295*^9, 3.7288456156288223`*^9, 3.733367225698143*^9, 
   3.7908626051158333`*^9, 3.790867036523588*^9, 3.792273162895042*^9},
 CellLabel->"Out[20]=",
 CellID->1154765805,ExpressionUUID->"e25a6674-5c55-45a7-b6e2-a963129aa111"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDblues", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.72865633937044*^9, 3.728656342800857*^9}, {
   3.728733422337994*^9, 3.728733423409343*^9}, {3.728747021480248*^9, 
   3.7287470251343*^9}, 3.728749236697857*^9},
 CellLabel->"In[21]:=",
 CellID->320834710,ExpressionUUID->"1a2d5ac5-51d4-43f0-888a-8404a262a17e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox[
     StyleBox["\[ScriptCapitalD]",
      FontColor->RGBColor[0., 0., 1.]], "a"], GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " "},
          {"b", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`PDblues[-$CellContext`a][
   $CellContext`T[-$CellContext`b, -$CellContext`c]],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.7286563433078003`*^9, 3.72866057444617*^9, 3.728671046973516*^9, 
   3.7286748683889503`*^9, 3.728732814966547*^9, 3.72873342419563*^9, 
   3.728742306908111*^9, 3.728743286666613*^9, 3.728743385877739*^9, 
   3.728747026369301*^9, 3.728749426726337*^9, 3.728749927911965*^9, 
   3.7287500783927097`*^9, 3.72875017747672*^9, 3.728750288276533*^9, 
   3.728750513285879*^9, 3.7287505729418907`*^9, 3.728750719371892*^9, {
   3.728750977768615*^9, 3.728751002498704*^9}, 3.7287516090841703`*^9, 
   3.7288132573247023`*^9, 3.7288273742018414`*^9, 3.728843011320195*^9, 
   3.728845615801454*^9, 3.7333672268815393`*^9, 3.790862605788739*^9, 
   3.790867037907772*^9, 3.792273163534154*^9},
 CellLabel->"Out[21]=",
 CellID->1691980261,ExpressionUUID->"d0bed620-799c-42e4-b848-a09a51795b7f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "We now define bases on the complex vector bundle. This generates additional \
\"inner\" objects for its parallel derivative (",
 StyleBox["FRiemann", "MR"],
 " and ",
 StyleBox["AChristoffel", "MR"],
 "):"
}], "MathCaption",
 CellChangeTimes->{
  3.728655315455933*^9, {3.728656991700653*^9, 3.72865699204287*^9}, {
   3.728657042944353*^9, 
   3.728657044400608*^9}},ExpressionUUID->"b08378bc-0f01-42bb-8aa5-\
c2e25a22ee2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"fcomp", ",", "InnerC", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728656111851475*^9, 3.728656112699613*^9}, {
  3.728733438180216*^9, 3.7287334383688593`*^9}, {3.728747037893715*^9, 
  3.728747039485759*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"4116992a-0df4-4d2e-9008-e0fb7d61d8fd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "fcomp", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`fcomp, 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.792273164933652*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->94044733,ExpressionUUID->"6591214d-41a9-4dbe-b28a-16b494d0bf93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDfcomp", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDfcomp[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.79227316494691*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->61863339,ExpressionUUID->"877fe4cc-7525-490d-8268-30a02429f64c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDfcomp", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDfcomp[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.79227316496134*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->355053425,ExpressionUUID->"2d346f63-5728-446f-a198-415a4ad27ea8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDfcomp", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDfcomp[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.792273164968862*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->1673342609,ExpressionUUID->"fbf8c4c1-c8a7-4985-a24c-274ce27758b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDfcomp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDfcomp[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.7922731649764214`*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->423388351,ExpressionUUID->"a4b76c2e-1ce9-4892-8bed-93608127618b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDfcomp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDfcomp[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.79227316498409*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->1274692746,ExpressionUUID->"08d1647f-09ff-4012-afe7-469fc346d5ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDfcomp", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDfcomp[$CellContext`A, -$CellContext`b, -C], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.792273164991181*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->464119550,ExpressionUUID->"69c6d938-4cd9-4a55-ad85-28d5d297fe0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDfcomp\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDfcomp\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.7922731649984827`*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->796670946,ExpressionUUID->"19502156-09e8-4f67-a721-f2862d1f3b09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDfcomp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDfcomp[-$CellContext`a, -$CellContext`b, -C, D], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.792273165005732*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->88050377,ExpressionUUID->"6253fa69-9408-4fcb-bef8-27bd65716fa3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDfcomp\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDfcomp\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.792273165013291*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->246453456,ExpressionUUID->"4bd00293-c989-41f8-9630-c31ed377a1c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", 
   "fcomp\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", 
   "basis ", $CellContext`fcomp\[Dagger], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.7922731650207*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->1794763576,ExpressionUUID->"b3e02462-15be-444c-a299-3476d3805d80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpfcomp", "[", 
    RowBox[{"A", ",", "B"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpfcomp[$CellContext`A, $CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.7922731650278*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->1036116070,ExpressionUUID->"dc918e01-1f1f-4b35-87ba-a2e99dfbfefe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpfcomp\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "B\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpfcomp\[Dagger][$CellContext`A\[Dagger], $CellContext`B\
\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.792273165035139*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->57894967,ExpressionUUID->"f1fb491a-d09d-4286-bc60-e89eff9af817"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownfcomp", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownfcomp[-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.792273165042238*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->230618278,ExpressionUUID->"3fd0c586-9037-4ff6-8575-cdfb0d270a5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownfcomp\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownfcomp\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645882419693*^9, 3.728656279753868*^9, 3.7286605745966597`*^9, 
   3.728671049477675*^9, 3.728674868560582*^9, 3.728732817198344*^9, 
   3.728733440196548*^9, 3.728742307385651*^9, 3.7287432868208437`*^9, 
   3.728743385999811*^9, 3.728747043815258*^9, 3.728749428123103*^9, 
   3.7287499280330343`*^9, 3.728750078538865*^9, 3.728750177616901*^9, 
   3.7287502886486177`*^9, 3.728750513436042*^9, 3.728750573076346*^9, 
   3.7287507194950857`*^9, {3.7287509779871817`*^9, 3.728751002599765*^9}, 
   3.728751609230563*^9, 3.72881325745619*^9, 3.728827374359118*^9, 
   3.728843012899191*^9, 3.728845615976507*^9, 3.733367228512617*^9, 
   3.790862607019595*^9, 3.790867044632689*^9, 3.792273165049589*^9},
 CellLabel->"During evaluation of In[22]:=",
 CellID->1940899158,ExpressionUUID->"b3e11ff3-0898-461b-bd7d-bca31dda6d13"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Once we have defined bases, the first task is to construct tensors. The \
simplest way is to build linear combinations of basis vectors with constant \
coefficients. ",
 StyleBox["xCoba`", "MR"],
 "  also offers a matrix/array representation using the head CTensor."
}], "Text",
 CellChangeTimes->{{3.728657543834518*^9, 3.728657738761075*^9}},
 CellID->1031311492,ExpressionUUID->"41b7ddbd-e6b9-4e91-b209-172a0ce81027"],

Cell[CellGroupData[{

Cell["Linear combination of the basis vector fields:", "MathCaption",
 CellChangeTimes->{{3.7286577709429693`*^9, 3.728657784998665*^9}},
 CellID->567493020,ExpressionUUID->"8cf80a25-7610-4ee8-bf5f-1a09bd97c61b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "3", "]"}], ",", 
    RowBox[{"4", "/", "5"}], ",", 
    RowBox[{"-", "2"}]}], "}"}], ".", "basis"}]], "Input",
 CellChangeTimes->{{3.728657788410364*^9, 3.7286578097334127`*^9}, {
  3.728657853236046*^9, 3.728657867611246*^9}, {3.728659175198987*^9, 
  3.728659176333827*^9}, {3.728659221868815*^9, 3.728659223515777*^9}},
 CellLabel->"In[23]:=",
 CellID->798724419,ExpressionUUID->"939b2cc8-339b-4dbf-aef5-bc4fc457a978"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["3"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["0",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
     Editable->False]}], "5"], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{{3.72865778932733*^9, 3.728657809966426*^9}, 
   3.728657868703639*^9, 3.728658207995817*^9, 3.728659176775906*^9, 
   3.7286592239652157`*^9, 3.7286605755591707`*^9, 3.728671053211897*^9, 
   3.7286748692553368`*^9, 3.7287328200185328`*^9, 3.728733451197308*^9, 
   3.728742308937552*^9, 3.72874328733191*^9, 3.72874338644768*^9, 
   3.728747054089987*^9, 3.728749433731832*^9, 3.728749928348205*^9, 
   3.7287500788663197`*^9, 3.728750178418771*^9, 3.728750289768194*^9, 
   3.728750513765011*^9, 3.728750573396962*^9, 3.728750719963344*^9, {
   3.7287509782892437`*^9, 3.72875100289567*^9}, 3.728751609642486*^9, 
   3.728813257911372*^9, 3.728827374841497*^9, 3.728843015870945*^9, 
   3.72884561639473*^9, 3.7333672316606627`*^9, 3.790862611318912*^9, 
   3.790867047190349*^9, 3.7922731669994917`*^9},
 CellLabel->"Out[23]=",
 CellID->951812572,ExpressionUUID->"acf2015e-6d38-40d4-9196-ed53dd263eb3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Find a particular component using the dual basis:", "MathCaption",
 CellChangeTimes->{{3.728657831036209*^9, 3.728657849931662*^9}},
 CellID->1224072815,ExpressionUUID->"00a20cd5-14c5-4389-b2e8-c7fec37e866d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "fred"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.728657873326367*^9, 3.728657888115551*^9}, {
  3.728733455176523*^9, 3.728733457483597*^9}, {3.728747056596898*^9, 
  3.7287470578517923`*^9}},
 CellLabel->"In[24]:=",
 CellID->146109740,ExpressionUUID->"0fb10a9e-1a6e-46b7-ace1-db410f868873"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]},
          {"a", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`fred}],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SqrtBox["3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "a"},
             {
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
      Editable->False]}], "+", 
    FractionBox[
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
       Editable->False]}], "5"], "-", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", "a"},
             {
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.728657889820837*^9, 3.728658209943397*^9, 3.728659178229656*^9, 
   3.728659225134118*^9, 3.728660575724956*^9, 3.728671054345994*^9, 
   3.7286748693983183`*^9, 3.728732821369384*^9, 3.728733459498345*^9, 
   3.728742309140935*^9, 3.728743287485834*^9, 3.728743386563595*^9, 
   3.728747058608076*^9, 3.7287494349934187`*^9, 3.72874992849739*^9, 
   3.728750079048293*^9, 3.728750179020624*^9, 3.72875028996517*^9, 
   3.728750513925475*^9, 3.72875057354738*^9, 3.7287507202221537`*^9, {
   3.7287509784361897`*^9, 3.728751003003475*^9}, 3.72875160980897*^9, 
   3.728813258060451*^9, 3.728827374992092*^9, 3.728843017320829*^9, 
   3.7288456165726633`*^9, 3.733367232951432*^9, 3.790862614084567*^9, 
   3.790867053046297*^9, 3.792273168468376*^9},
 CellLabel->"Out[24]=",
 CellID->407381183,ExpressionUUID->"cafb6616-daab-42b6-bb4c-c077fc2b5f1a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Contraction of basis elements is not automatic and needs to be forced with \
ContractBasis:\
\>", "MathCaption",
 CellChangeTimes->{{3.7286579086421127`*^9, 3.7286579419502583`*^9}},
 CellID->1517941996,ExpressionUUID->"276f5939-64c7-4551-81d1-62b1cfe2aefe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ContractBasis"}]], "Input",
 CellChangeTimes->{{3.7286578914688883`*^9, 3.728657894305317*^9}},
 CellLabel->"In[25]:=",
 CellID->873925861,ExpressionUUID->"b40a2a60-a516-441e-b0b1-92132c68a089"],

Cell[BoxData[
 FractionBox["4", "5"]], "Output",
 CellChangeTimes->{
  3.7286578947395573`*^9, 3.72865821091333*^9, 3.728659179618195*^9, 
   3.728659226186515*^9, 3.728660575871538*^9, 3.728671055390955*^9, 
   3.72867486953607*^9, 3.728732822800817*^9, 3.7287334613976803`*^9, 
   3.7287423094180937`*^9, 3.728743287617667*^9, 3.728743386679995*^9, 
   3.728747060263914*^9, 3.72874943642666*^9, 3.72874992868524*^9, 
   3.72875007920193*^9, 3.7287501796193247`*^9, 3.728750290131489*^9, 
   3.728750514087226*^9, 3.7287505736927567`*^9, 3.728750720331127*^9, {
   3.7287509785733356`*^9, 3.72875100309855*^9}, 3.7287516099625483`*^9, 
   3.728813258205059*^9, 3.72882737513629*^9, 3.728843018672751*^9, 
   3.728845616760726*^9, 3.733367234267839*^9, 3.790862615530878*^9, 
   3.79086705456151*^9, 3.7922731697002*^9},
 CellLabel->"Out[25]=",
 CellID->896289178,ExpressionUUID->"69738db6-24e3-4311-8947-118ab01abcf0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We can do the same thing with abstract tensors. This is the 1-component of \
the vector v:\
\>", "MathCaption",
 CellChangeTimes->{{3.728657870771105*^9, 3.7286578715551453`*^9}, {
  3.728657968591552*^9, 
  3.728657995292942*^9}},ExpressionUUID->"893ff924-3a92-4a50-bdcb-\
73ecee828f56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "a", "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "fred"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.728657997345171*^9, 3.728658004140646*^9}, {
  3.728733465472506*^9, 3.728733471539266*^9}, {3.728747063468745*^9, 
  3.728747064084592*^9}},
 CellLabel->"In[26]:=",
 CellID->495245388,ExpressionUUID->"88eb222a-0a82-4e42-b087-30b334c8c6b3"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]},
          {"a", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`fred}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.728658004849516*^9, {3.728658094277974*^9, 3.728658104546372*^9}, 
   3.728658212313325*^9, 3.728659180781633*^9, 3.728659227234871*^9, 
   3.728660576038485*^9, 3.728671056424767*^9, 3.72867486968263*^9, 
   3.72873282418576*^9, 3.728733473266857*^9, 3.728742309989181*^9, 
   3.728743287765223*^9, 3.728743386797634*^9, 3.72874706484513*^9, 
   3.7287494382328672`*^9, 3.728749928845009*^9, 3.728750079381485*^9, 
   3.7287501805235367`*^9, 3.728750290294507*^9, 3.72875051421445*^9, 
   3.7287505738264103`*^9, 3.728750720437146*^9, {3.728750978719502*^9, 
   3.72875100318469*^9}, 3.728751610098958*^9, 3.7288132583588533`*^9, 
   3.728827375290291*^9, 3.728843019971199*^9, 3.728845616944168*^9, 
   3.733367235483755*^9, 3.790862617500257*^9, 3.790867055810647*^9, 
   3.792273171245263*^9},
 CellLabel->"Out[26]=",
 CellID->29071767,ExpressionUUID->"ece8551b-c1c4-421a-8c1a-ff37b29d4dd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ContractBasis"}]], "Input",
 CellChangeTimes->{{3.72865800629854*^9, 3.728658009988182*^9}},
 CellLabel->"In[27]:=",
 CellID->354917875,ExpressionUUID->"e352fa8f-f991-40f4-9f4a-696eb0edc24f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{1, $CellContext`fred}],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728658010352304*^9, {3.728658094899235*^9, 3.728658105132345*^9}, 
   3.7286582128967*^9, 3.728659181365068*^9, 3.728659227820901*^9, 
   3.728660576169086*^9, 3.7286710570891438`*^9, 3.728674869822386*^9, 
   3.728732825035427*^9, 3.728733474349777*^9, 3.7287423101119633`*^9, 
   3.7287432879005547`*^9, 3.728743386946542*^9, 3.728747067076078*^9, 
   3.728749438932197*^9, 3.728749928955408*^9, 3.728750079552868*^9, 
   3.7287501809401407`*^9, 3.728750290457869*^9, 3.72875051437143*^9, 
   3.728750573975359*^9, 3.728750720543305*^9, {3.72875097885708*^9, 
   3.728751003279801*^9}, 3.72875161026226*^9, 3.728813258508492*^9, 
   3.7288273754386168`*^9, 3.728843020673112*^9, 3.728845617110462*^9, 
   3.7333672362671623`*^9, 3.7908626204197206`*^9, 3.790867056530903*^9, 
   3.79227317180599*^9},
 CellLabel->"Out[27]=",
 CellID->2128758162,ExpressionUUID->"5b33e57d-752f-4b2f-8f8b-45257cd01ecd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Such object is a scalar, and not a vector. It is a scalar component of the \
vector v, and hence has no free index:\
\>", "MathCaption",
 CellChangeTimes->{{3.728658026652529*^9, 3.728658058410124*^9}, {
  3.728658113574903*^9, 3.72865812752693*^9}},
 CellID->1926011727,ExpressionUUID->"01922e37-a050-4631-968d-54ca32a1b501"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  RowBox[{"IndicesOf", "[", "Free", "]"}]}]], "Input",
 CellChangeTimes->{{3.7286580605327177`*^9, 3.7286581024114122`*^9}},
 CellLabel->"In[28]:=",
 CellID->1726618588,ExpressionUUID->"2fd3c73e-8945-46f6-9f02-1723d21557c5"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   StyleBox[
    RowBox[{"{", "}"}],
    FontColor->RGBColor[0, 0, 1]],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[],
  Editable->False]], "Output",
 CellChangeTimes->{{3.728658069691043*^9, 3.728658106140317*^9}, 
   3.7286582139586277`*^9, 3.728659182397478*^9, 3.728659228887414*^9, 
   3.7286605763310623`*^9, 3.728671058132729*^9, 3.728674869971005*^9, 
   3.72873282631888*^9, 3.72873347573483*^9, 3.728742310270246*^9, 
   3.728743288053254*^9, 3.728743387083701*^9, 3.7287470696638937`*^9, 
   3.728749440154785*^9, 3.728749929065579*^9, 3.728750079686417*^9, 
   3.728750181135494*^9, 3.7287502907730417`*^9, 3.728750514518721*^9, 
   3.728750574122034*^9, 3.7287507206435547`*^9, {3.7287509789696693`*^9, 
   3.728751003359228*^9}, 3.72875161041416*^9, 3.72881325863787*^9, 
   3.728827375586524*^9, 3.728843021904561*^9, 3.728845617282915*^9, 
   3.733367237484853*^9, 3.790862621855618*^9, 3.790867057610441*^9, 
   3.792273172924511*^9},
 CellLabel->"Out[28]=",
 CellID->734337630,ExpressionUUID->"039476bc-8c05-46fb-9df3-55717c3c1d3a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["These are all the components of a tensor in given bases:", "MathCaption",
 CellChangeTimes->{{3.728659553726243*^9, 3.7286595657803907`*^9}},
 CellID->2040884250,ExpressionUUID->"f315b260-ffa6-404c-8aba-49421fe2cd0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentArray", "[", 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "blues"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "blues"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.728733483096191*^9, 3.728733485543358*^9}, {
  3.7287470730764*^9, 3.728747078931922*^9}, {3.728749237674259*^9, 
  3.728749238371763*^9}},
 CellLabel->"In[29]:=",
 CellID->1532779866,ExpressionUUID->"b852019f-6038-4c28-98ce-8b2f112ff081"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`blues}, {0, -$CellContext`blues}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`blues}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`blues}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{1, -$CellContext`blues}, {0, -$CellContext`blues}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{1, -$CellContext`blues}, {1, -$CellContext`blues}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`blues}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["0",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{2, -$CellContext`blues}, {0, -$CellContext`blues}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{2, -$CellContext`blues}, {1, -$CellContext`blues}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{2, -$CellContext`blues}, {2, -$CellContext`blues}],
      Editable->False]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.728645913465144*^9, 3.7286595675123873`*^9, 3.728660576828341*^9, 
   3.728671059242107*^9, 3.7286748701285877`*^9, 3.728732830383156*^9, 
   3.7287334882366533`*^9, 3.728742310674667*^9, 3.7287432882158747`*^9, 
   3.7287433872182207`*^9, 3.7287470796259117`*^9, 3.728749441610855*^9, 
   3.7287499292007093`*^9, 3.728750079860327*^9, 3.728750181540159*^9, 
   3.728750291063883*^9, 3.728750514761248*^9, 3.7287505742767773`*^9, 
   3.7287507207557917`*^9, {3.728750979139906*^9, 3.728751003466155*^9}, 
   3.728751610572269*^9, 3.728813258799909*^9, 3.7288273757476797`*^9, 
   3.728843023180586*^9, 3.728845617462277*^9, 3.733367238851947*^9, 
   3.790862623028624*^9, 3.7908670586740637`*^9, 3.792273174667753*^9},
 CellLabel->"Out[29]=",
 CellID->1881806026,ExpressionUUID->"0e33bec5-87a2-48d0-b3e5-c0bcca9df27e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Notice that T is a symmetric tensor, so this can be simplified\
\>", "MathCaption",
 CellID->217378450,ExpressionUUID->"31d51e36-85ae-433d-b70d-5fef2a5210bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplification", "[", "%", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->609925603,ExpressionUUID->"95c84cfd-f695-49df-bf33-878fbd0f1e50"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`blues}],
       Editable->False], 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`blues}],
       Editable->False]},
     {
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`blues}],
        Editable->False]}], "0", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`blues}],
       Editable->False]},
     {
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`blues}],
        Editable->False]}], 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`blues}],
        Editable->False]}], "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.728645914748652*^9, 3.7286595706313143`*^9, 3.728660576972238*^9, 
   3.728671061709361*^9, 3.728674870276717*^9, 3.728732831891994*^9, 
   3.728733490115657*^9, 3.728742310814097*^9, 3.72874328838453*^9, 
   3.728743387409368*^9, 3.7287470844769583`*^9, 3.728749442933326*^9, 
   3.728749929317546*^9, 3.728750080021885*^9, 3.7287501816988297`*^9, 
   3.728750291231916*^9, 3.728750514970084*^9, 3.728750574405529*^9, 
   3.72875072088616*^9, {3.72875097933547*^9, 3.7287510035829782`*^9}, 
   3.728751610792466*^9, 3.7288132589439993`*^9, 3.728827375891399*^9, 
   3.7288430244731693`*^9, 3.7288456176781816`*^9, 3.733367240083146*^9, 
   3.790862624139817*^9, 3.79086705970389*^9, 3.792273176769701*^9},
 CellLabel->"Out[30]//MatrixForm=",
 CellID->2026104355,ExpressionUUID->"0dd1d415-ef67-429d-a517-377fc94aee8a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["These are all contractions of the basis and cobasis vectors:", \
"MathCaption",
 CellChangeTimes->{{3.728658261080299*^9, 3.728658275112071*^9}},
 CellID->467947572,ExpressionUUID->"9b6da2d7-1380-4536-96d6-bf6760d56437"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Times", ",", "basis", ",", "cobasis"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.728658238158003*^9, 3.728658252599633*^9}},
 CellLabel->"In[31]:=",
 CellID->39003799,ExpressionUUID->"c683d903-b92a-41aa-b2c1-fddf615ddfe1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`a, {0, $CellContext`fred}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
        Editable->False]}], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`fred}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
        Editable->False]}], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`fred}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
        Editable->False]}]},
     {
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`a, {0, $CellContext`fred}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
        Editable->False]}], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`fred}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
        Editable->False]}], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`fred}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
        Editable->False]}]},
     {
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`a, {0, $CellContext`fred}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
        Editable->False]}], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`fred}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
        Editable->False]}], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`fred}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
        Editable->False]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.728658245946588*^9, 3.728658253660502*^9}, 
   3.7286591834475327`*^9, 3.728659230237402*^9, 3.728660577133449*^9, 
   3.728671063292205*^9, 3.728674870453608*^9, 3.728732833408968*^9, 
   3.72873349196168*^9, 3.7287423109711437`*^9, 3.7287432890450363`*^9, 
   3.7287433876032953`*^9, 3.728747087112566*^9, 3.7287494442828503`*^9, 
   3.728749929454063*^9, 3.7287500801840677`*^9, 3.72875018186316*^9, 
   3.728750291752371*^9, 3.7287505151023273`*^9, 3.728750574547233*^9, 
   3.728750721014017*^9, {3.72875097951621*^9, 3.7287510037077436`*^9}, 
   3.7287516109768963`*^9, 3.728813259091239*^9, 3.728827376057448*^9, 
   3.728843025715432*^9, 3.728845617915887*^9, 3.7333672414016457`*^9, 
   3.7908626277834682`*^9, 3.790867063192526*^9, 3.7922731780510883`*^9},
 CellLabel->"Out[31]//MatrixForm=",
 CellID->432518983,ExpressionUUID->"b9b7c6be-1a3a-4740-8de9-5c594af361aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ContractBasis"}]], "Input",
 CellChangeTimes->{{3.728658285587792*^9, 3.7286582889984303`*^9}},
 CellLabel->"In[32]:=",
 CellID->1702767342,ExpressionUUID->"bc7e61e9-0384-4762-83c1-7f23e3b88429"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.728658289756238*^9, 3.728659184981235*^9, 3.7286592315704517`*^9, 
   3.7286605772726393`*^9, 3.7286710638933783`*^9, 3.728674870586783*^9, 
   3.728732834320591*^9, 3.728733493254899*^9, 3.72874231110819*^9, 
   3.7287432896049843`*^9, 3.728743387712571*^9, 3.728747088127081*^9, 
   3.7287494452493896`*^9, 3.728749929626946*^9, 3.728750080352744*^9, 
   3.728750181997426*^9, 3.728750291964533*^9, 3.728750515236052*^9, 
   3.728750574710142*^9, 3.728750721099382*^9, {3.7287509796551733`*^9, 
   3.728751003807551*^9}, 3.7287516111154737`*^9, 3.7288132592387877`*^9, 
   3.728827376202216*^9, 3.7288430265226507`*^9, 3.728845618076868*^9, 
   3.733367242752063*^9, 3.790862628370533*^9, 3.790867063912924*^9, 
   3.7922731786366653`*^9},
 CellLabel->"Out[32]=",
 CellID->1505882069,ExpressionUUID->"c79d527e-e5d6-4fd2-821f-4965540672c0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Our example vector can also be represented in CTensor notation. The fact that \
these are components in the polar basis is represented by the red vertical \
bars:\
\>", "MathCaption",
 CellChangeTimes->{{3.728658451016865*^9, 3.7286584651032963`*^9}, {
  3.7286588851888103`*^9, 3.728658919258182*^9}, {3.728659587435247*^9, 
  3.7286595881634483`*^9}},
 CellID->242311782,ExpressionUUID->"20f59a56-cf63-49ad-ba67-2f2baef4bca1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sqrt", "[", "3", "]"}], ",", 
      RowBox[{"4", "/", "5"}], ",", 
      RowBox[{"-", "2"}]}], "}"}], ",", 
    RowBox[{"{", "fred", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.728657788410364*^9, 3.7286578097334127`*^9}, {
  3.728657853236046*^9, 3.728657867611246*^9}, {3.728658767619624*^9, 
  3.728658778624563*^9}, {3.72865896515481*^9, 3.728658966648027*^9}, {
  3.7286591886861887`*^9, 3.728659190381384*^9}, {3.728659234396261*^9, 
  3.728659235979086*^9}, {3.728733497566725*^9, 3.728733497943125*^9}, {
  3.728747091971465*^9, 3.72874709252317*^9}},
 CellLabel->"In[33]:=",
 CellID->1584502302,ExpressionUUID->"b64f669d-7de5-4b8d-b960-22ad52163c34"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SqrtBox["3"], ",", 
     FractionBox["4", "5"], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", "fred", "}"}], ",", "0"}], "]"}]], "Output",
 CellChangeTimes->{{3.72865778932733*^9, 3.728657809966426*^9}, 
   3.728657868703639*^9, 3.728658207995817*^9, 3.728658466410768*^9, 
   3.728658779122549*^9, 3.728658829308704*^9, 3.7286589670606537`*^9, 
   3.728659190811661*^9, 3.728659236403413*^9, 3.728660577400886*^9, 
   3.728671066262951*^9, 3.728674870738194*^9, 3.728732835887046*^9, 
   3.7287335040387783`*^9, 3.728742311225581*^9, 3.728743289730118*^9, 
   3.7287433878340178`*^9, 3.728747093315234*^9, 3.728749446574032*^9, 
   3.728749929916246*^9, 3.728750080519561*^9, 3.728750182287417*^9, 
   3.728750292127923*^9, 3.728750515372609*^9, 3.728750574922373*^9, 
   3.728750721186805*^9, {3.728750979792142*^9, 3.728751003894363*^9}, 
   3.728751611263776*^9, 3.72881325938962*^9, 3.72882737634579*^9, 
   3.728843028217855*^9, 3.7288456182490807`*^9, 3.733367244151692*^9, 
   3.790862629602626*^9, 3.790867065228609*^9, 3.7922731796454077`*^9},
 CellLabel->"Out[33]=",
 CellID->183612468,ExpressionUUID->"94fe6a1d-0e46-4ec6-aa6c-9d9252c0296c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "[", "a", "]"}]], "Input",
 CellChangeTimes->{{3.72865896869092*^9, 3.728658969159752*^9}},
 CellLabel->"In[34]:=",
 CellID->1820321917,ExpressionUUID->"6b084ed5-c180-42e2-9db7-0e32ed98bca7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox[
            SqrtBox["3"],
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", 
              SqrtBox["3"]}]],
           Annotation[#, {1} -> 3^Rational[1, 2], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            FractionBox["4", "5"],
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              FractionBox["4", "5"]}]],
           Annotation[#, {2} -> Rational[4, 5], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{"-", "2"}],
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", 
              RowBox[{"-", "2"}]}]],
           Annotation[#, {3} -> -2, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{3^Rational[1, 2], 
    Rational[4, 5], -2}, {$CellContext`fred}, 0][$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728658969584231*^9, 3.728659191882553*^9, 3.72865923728759*^9, 
   3.7286605777129517`*^9, 3.728671067263575*^9, 3.72867487115812*^9, 
   3.728732836853332*^9, 3.728733505504985*^9, 3.7287423113612013`*^9, 
   3.728743289868075*^9, 3.728743387965412*^9, 3.728747094730979*^9, 
   3.728749447383438*^9, 3.7287499300370092`*^9, 3.728750080687973*^9, 
   3.728750182647161*^9, 3.728750292670869*^9, 3.72875051550168*^9, 
   3.728750575089509*^9, 3.7287507213014174`*^9, {3.728750979941448*^9, 
   3.728751003984441*^9}, 3.72875161144671*^9, 3.72881325954033*^9, 
   3.7288273765217247`*^9, 3.728843028939458*^9, 3.728845618477373*^9, 
   3.733367244866397*^9, 3.790862630340108*^9, 3.790867066031636*^9, 
   3.792273182750264*^9},
 CellLabel->"Out[34]=",
 CellID->1733239118,ExpressionUUID->"47b89554-787b-481f-9f5b-0aac11630c57"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Convert to an explicit linear combination:", "MathCaption",
 CellChangeTimes->{{3.7286589338730593`*^9, 3.728658941745254*^9}},
 CellID->632631793,ExpressionUUID->"26b0cced-a85b-4400-ba9d-162cfaf7c110"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToBasisExpand"}]], "Input",
 CellChangeTimes->{{3.728658822556219*^9, 3.728658825686892*^9}},
 CellLabel->"In[35]:=",
 CellID->1842212869,ExpressionUUID->"1104ab5c-dc5f-4a57-b1ff-8f6b8500797e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["3"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["0",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "a"},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
     Editable->False]}], "5"], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{{3.728658826546609*^9, 3.7286588300070343`*^9}, 
   3.728658972421937*^9, 3.728659193901593*^9, 3.7286592384717417`*^9, 
   3.728660577990355*^9, 3.7286710683254347`*^9, 3.728674872158225*^9, 
   3.7287328381538467`*^9, 3.728733507170361*^9, 3.728742311493371*^9, 
   3.72874328998131*^9, 3.7287433880841618`*^9, 3.7287470971759033`*^9, 
   3.728749448667193*^9, 3.728749930155632*^9, 3.728750080839747*^9, 
   3.728750183011454*^9, 3.728750292879649*^9, 3.728750516352376*^9, 
   3.728750575322447*^9, 3.7287507214070377`*^9, {3.728750980111847*^9, 
   3.728751004086618*^9}, 3.7287516115835238`*^9, 3.728813259676899*^9, 
   3.728827376675194*^9, 3.7288430302727947`*^9, 3.728845618732238*^9, 
   3.7333672467856417`*^9, 3.790862631485632*^9, 3.79086707071535*^9, 
   3.792273183929689*^9},
 CellLabel->"Out[35]=",
 CellID->671775273,ExpressionUUID->"eb5a6790-4533-4e5c-9712-8d06838a7ae7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "CTensor objects can be manipulated like tensor heads in ",
 StyleBox["xTensor`", "MR"],
 "."
}], "MathCaption",
 CellChangeTimes->{{3.7286589896785583`*^9, 3.728659037996649*^9}},
 CellID->174587974,ExpressionUUID->"a3116752-c77a-4c3e-a713-23368952637d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTensorQ", "[", "w", "]"}]], "Input",
 CellChangeTimes->{{3.728659058700526*^9, 3.728659061629056*^9}},
 CellLabel->"In[36]:=",
 CellID->777404065,ExpressionUUID->"efe69f1c-6189-4eee-a396-338e69fd47ae"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.728659062053235*^9, 3.728659196150271*^9, 3.728659239654976*^9, 
   3.728660578142432*^9, 3.728671069345858*^9, 3.728674872901696*^9, 
   3.728732839403862*^9, 3.728733510472055*^9, 3.728742311629909*^9, 
   3.7287432901777143`*^9, 3.7287433882337017`*^9, 3.728747098394784*^9, 
   3.728749449759087*^9, 3.7287499302673388`*^9, 3.728750081001747*^9, 
   3.7287501832368803`*^9, 3.728750293051141*^9, 3.7287505164725513`*^9, 
   3.7287505754389477`*^9, 3.728750721510827*^9, {3.7287509802557793`*^9, 
   3.7287510041780767`*^9}, 3.728751611951913*^9, 3.728813259821253*^9, 
   3.728827376820032*^9, 3.728843031461504*^9, 3.728845619010659*^9, 
   3.733367248069642*^9, 3.790862632719934*^9, 3.7908670718477983`*^9, 
   3.792273185251446*^9},
 CellLabel->"Out[36]=",
 CellID->1028234363,ExpressionUUID->"cf8ae64f-a76c-4633-ac77-a64d36eb2d63"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "a", "]"}], 
  RowBox[{"w", "[", "b", "]"}]}]], "Input",
 CellChangeTimes->{{3.7286590735504*^9, 3.728659076330945*^9}},
 CellLabel->"In[37]:=",
 CellID->870075231,ExpressionUUID->"f7dd621f-2615-4f58-a013-ea6a4f177477"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["3",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "3"}]],
           Annotation[#, {1, 1} -> 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            FractionBox[
             RowBox[{"4", " ", 
              SqrtBox["3"]}], "5"],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
              FractionBox[
               RowBox[{"4", " ", 
                 SqrtBox["3"]}], "5"]}]],
           
           Annotation[#, {1, 2} -> Rational[4, 5] 3^Rational[1, 2], 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SqrtBox["3"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"-", "2"}], " ", 
                SqrtBox["3"]}]}]],
           Annotation[#, {1, 3} -> (-2) 3^Rational[1, 2], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            FractionBox[
             RowBox[{"4", " ", 
              SqrtBox["3"]}], "5"],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
              FractionBox[
               RowBox[{"4", " ", 
                 SqrtBox["3"]}], "5"]}]],
           
           Annotation[#, {2, 1} -> Rational[4, 5] 3^Rational[1, 2], 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            FractionBox["16", "25"],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              FractionBox["16", "25"]}]],
           Annotation[#, {2, 2} -> Rational[16, 25], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"-", 
             FractionBox["8", "5"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
              RowBox[{"-", 
                FractionBox["8", "5"]}]}]],
           Annotation[#, {2, 3} -> Rational[-8, 5], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox[
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SqrtBox["3"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{"-", "2"}], " ", 
                SqrtBox["3"]}]}]],
           Annotation[#, {3, 1} -> (-2) 3^Rational[1, 2], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{"-", 
             FractionBox["8", "5"]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
              RowBox[{"-", 
                FractionBox["8", "5"]}]}]],
           Annotation[#, {3, 2} -> Rational[-8, 5], "Tooltip"]& ], 
          TagBox[
           TooltipBox["4",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "4"}]],
           Annotation[#, {3, 3} -> 4, "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 4 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 4 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a", "b"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{
    3, Rational[4, 5] 3^Rational[1, 2], (-2) 3^Rational[1, 2]}, {
    Rational[4, 5] 3^Rational[1, 2], 
     Rational[16, 25], 
     Rational[-8, 5]}, {(-2) 3^Rational[1, 2], 
     Rational[-8, 5], 4}}, {$CellContext`fred, $CellContext`fred}, 
   0][$CellContext`a, $CellContext`b],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728659076824127*^9, 3.72865919674898*^9, 3.72865924025385*^9, 
   3.728660578427897*^9, 3.728671070008979*^9, 3.728674873945915*^9, 
   3.728732840186411*^9, 3.7287335115719748`*^9, 3.728742311984723*^9, 
   3.7287432905187798`*^9, 3.7287433883996153`*^9, 3.728747099060446*^9, 
   3.728749450366997*^9, 3.728749930383419*^9, 3.728750081171165*^9, 
   3.728750183394473*^9, 3.7287502934780483`*^9, 3.728750516618408*^9, 
   3.728750575562221*^9, 3.728750721601364*^9, {3.728750980409465*^9, 
   3.728751004263761*^9}, 3.7287516129276447`*^9, 3.728813259982071*^9, 
   3.7288273769731293`*^9, 3.7288430321735983`*^9, 3.728845619186076*^9, 
   3.733367248718882*^9, 3.790862633387103*^9, 3.790867072483173*^9, 
   3.7922731858141413`*^9},
 CellLabel->"Out[37]=",
 CellID->2121223330,ExpressionUUID->"33403d98-cb72-4542-b224-17b6450c97fb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Basis vectors and transition matrices are represented by the two-index object \
Basis. Without a metric, only the down-up configuration is allowed:\
\>", "MathCaption",ExpressionUUID->"e0f55b9e-3dcd-4936-9ae4-6a3451845cfe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "fcomp"}]}], "}"}], ",", "A"}], "]"}]], "Input",
 CellChangeTimes->{{3.72873351551768*^9, 3.728733515717142*^9}, {
  3.728747101658777*^9, 3.7287471030267887`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"d4c9e50d-7192-45ff-8f8d-7cc00c86e048"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", "A"},
         {
          StyleBox["4",
           FontColor->RGBColor[0., 1., 0.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{4, -$CellContext`fcomp}, $CellContext`A],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.7286458898499613`*^9, 3.728658332478682*^9, 3.728659115660843*^9, 
   3.728659201854439*^9, 3.728659242338132*^9, 3.7286605788780327`*^9, 
   3.728671072326453*^9, 3.728674874430497*^9, 3.7287328416203613`*^9, 
   3.7287335221569433`*^9, 3.728742312161118*^9, 3.7287432906847*^9, 
   3.728743388533638*^9, 3.7287471037450037`*^9, 3.7287494516511793`*^9, 
   3.7287499305023947`*^9, 3.728750081336788*^9, 3.72875018364561*^9, 
   3.728750293628276*^9, 3.728750516750753*^9, 3.728750575721716*^9, 
   3.728750721696929*^9, {3.728750980635593*^9, 3.728751004343829*^9}, 
   3.728751613460923*^9, 3.728813260107193*^9, 3.7288273771046257`*^9, 
   3.7288430339393587`*^9, 3.728845619351062*^9, 3.733367250318191*^9, 
   3.7908626348435802`*^9, 3.790867074761552*^9, 3.7922731880128193`*^9},
 CellLabel->"Out[38]=",
 CellID->1277912894,ExpressionUUID->"00e4b102-90f5-4370-8a91-349e7401633d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{"A", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", 
      RowBox[{"-", "fcomp"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.728733524245178*^9, 3.728733524380929*^9}, {
  3.72874710664259*^9, 3.7287471077064543`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"a78b18f2-7258-4c1a-bc84-9fb076646eaf"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"InnerC\\\", Rule[AutoSpacing, False], \
Rule[ShowAutoStyles, False]], InnerC, Rule[Editable, False]]\\).\"", 2, 39, 3,
    19668387891272167742, "Local", "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{
  3.728645891665702*^9, 3.728658333350918*^9, 3.7286591167546873`*^9, 
   3.7286592025318117`*^9, 3.728659243023828*^9, 3.728660579021009*^9, 
   3.728671072902687*^9, 3.72867487499222*^9, 3.728732842519462*^9, 
   3.728733524819257*^9, 3.728742312322235*^9, 3.728743290814465*^9, 
   3.7287433886846123`*^9, 3.728747108047368*^9, 3.7287494522659883`*^9, 
   3.728749930617119*^9, 3.7287500814763823`*^9, 3.728750183851701*^9, 
   3.728750293780211*^9, 3.728750516857692*^9, 3.728750575888358*^9, 
   3.7287507217758427`*^9, {3.728750980819462*^9, 3.728751004431987*^9}, 
   3.7287516136137037`*^9, 3.728813260238896*^9, 3.728827377252462*^9, 
   3.7288430346426487`*^9, 3.728845619510648*^9, 3.733367251034429*^9, 
   3.7908626355377607`*^9, 3.790867077664089*^9, 3.792273188715226*^9},
 CellLabel->"During evaluation of In[39]:=",
 CellID->407528486,ExpressionUUID->"549e158b-4fa1-4245-9e29-d7e06fd9582d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "fred"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "blues"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728733529133051*^9, 3.728733537759077*^9}, {
   3.728747109930544*^9, 3.7287471147063007`*^9}, 3.728749239245758*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"574efbd0-14d4-469e-a113-a3a4d8886874"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["b",
           FontColor->RGBColor[0., 0., 1.]]},
         {
          StyleBox["a",
           FontColor->RGBColor[1., 0., 0.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`fred}, {$CellContext`b, \
$CellContext`blues}],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728645894400773*^9, 3.7286591178395557`*^9, 3.728659203167418*^9, 
   3.728659243655389*^9, 3.728660579628969*^9, 3.728671073576277*^9, 
   3.728674875448032*^9, 3.728732843354403*^9, 3.728733538660166*^9, 
   3.728742312620281*^9, 3.728743290946706*^9, 3.728743389059758*^9, 
   3.7287471151789503`*^9, 3.728749452979878*^9, 3.7287499307038*^9, 
   3.728750081632181*^9, 3.7287501840027027`*^9, 3.728750294135548*^9, 
   3.728750516990486*^9, 3.72875057604432*^9, 3.728750721924171*^9, {
   3.728750980957382*^9, 3.728751004544126*^9}, 3.72875161379213*^9, 
   3.7288132603811502`*^9, 3.728827377392501*^9, 3.728843035340128*^9, 
   3.728845619711618*^9, 3.73336725310111*^9, 3.790862637971806*^9, 
   3.792273190467808*^9},
 CellLabel->"Out[40]=",
 CellID->1751994733,ExpressionUUID->"1b59040e-08cc-44cb-a994-4b7e08a720a6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hence, this is the vector w in a different basis:", "MathCaption",
 CellChangeTimes->{{3.728659247106689*^9, 3.728659268609988*^9}},
 CellID->1417706722,ExpressionUUID->"63abdba6-c302-4ed1-9c3c-74bd5ee4104a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCTensor", "[", 
  RowBox[{"w", ",", 
   RowBox[{"{", "blues", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728659125467942*^9, 3.728659147079515*^9}, {
   3.728659205757403*^9, 3.7286592135086718`*^9}, {3.728733550758011*^9, 
   3.728733554157062*^9}, {3.728747119955625*^9, 3.728747120769897*^9}, 
   3.728749240270226*^9},
 CellLabel->"In[41]:=",
 CellID->1090855304,ExpressionUUID->"faa06ec4-e845-446a-9328-1060eea2ebad"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]]},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{0, -$CellContext`fred}, {0, $CellContext`blues}],
        Editable->False]}], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`fred}, {0, $CellContext`blues}],
         
         Editable->False]}], "5"], "-", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]]},
               {
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{2, -$CellContext`fred}, {0, $CellContext`blues}],
        Editable->False]}]}], ",", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{0, -$CellContext`fred}, {1, $CellContext`blues}],
        Editable->False]}], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`fred}, {1, $CellContext`blues}],
         
         Editable->False]}], "5"], "-", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]},
               {
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{2, -$CellContext`fred}, {1, $CellContext`blues}],
        Editable->False]}]}], ",", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{0, -$CellContext`fred}, {2, $CellContext`blues}],
        Editable->False]}], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`fred}, {2, $CellContext`blues}],
         
         Editable->False]}], "5"], "-", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]},
               {
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{2, -$CellContext`fred}, {2, $CellContext`blues}],
        Editable->False]}]}]}], "}"}], ",", 
   RowBox[{"{", "blues", "}"}], ",", "0"}], "]"}]], "Output",
 CellChangeTimes->{{3.728659137756296*^9, 3.728659147554789*^9}, {
   3.7286592037845783`*^9, 3.728659213998067*^9}, {3.728659270055814*^9, 
   3.728659272842313*^9}, 3.728660579878415*^9, 3.7286710749598703`*^9, 
   3.728674875925165*^9, 3.728732844550922*^9, 3.728733555159945*^9, 
   3.728742312898328*^9, 3.728743291085745*^9, 3.7287433894135313`*^9, 
   3.728747121380472*^9, 3.728749454110663*^9, 3.728749930884413*^9, 
   3.728750081816392*^9, 3.7287501844686813`*^9, 3.728750294547535*^9, 
   3.7287505171508408`*^9, 3.72875057620463*^9, 3.728750722035533*^9, {
   3.728750981069841*^9, 3.728751004650337*^9}, 3.728751614300568*^9, 
   3.728813260530862*^9, 3.728827377547081*^9, 3.728843036503633*^9, 
   3.7288456199006863`*^9, 3.733367254836533*^9, 3.79086264100975*^9, 
   3.790867080055656*^9, 3.792273194180238*^9},
 CellLabel->"Out[41]=",
 CellID->754733583,ExpressionUUID->"5f4fec61-8038-4013-841b-cd34297ac554"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Hover over the \"blobs\" to see the vector components. Note the new color of \
the vertical bars:\
\>", "MathCaption",
 CellChangeTimes->{{3.7286592836506166`*^9, 3.728659312760132*^9}},
 CellID->709935661,ExpressionUUID->"1c30ac6f-acd3-4454-b9d3-6a09f8f82b70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "a", "]"}]], "Input",
 CellChangeTimes->{{3.72865927628489*^9, 3.728659276961568*^9}},
 CellLabel->"In[42]:=",
 CellID->1422333728,ExpressionUUID->"15f54362-4420-4f40-8fc2-7d59c9ba8288"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", "1", "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{
                  SqrtBox["3"], " ", 
                  InterpretationBox[
                   StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"0\",FontColor->RGBColor[0., 0., \
1.]]\)"}, {"\!\(\*StyleBox[\"0\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   
                   xAct`xTensor`Basis[{0, -$CellContext`fred}, {
                    0, $CellContext`blues}], Editable -> False]}], "+", 
                FractionBox[
                 RowBox[{"4", " ", 
                   InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"0\",FontColor->RGBColor[0., 0., \
1.]]\)"}, {"\!\(\*StyleBox[\"1\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    
                    xAct`xTensor`Basis[{1, -$CellContext`fred}, {
                    0, $CellContext`blues}], Editable -> False]}], "5"], "-", 
                
                RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"0\",FontColor->RGBColor[0., 0., \
1.]]\)"}, {"\!\(\*StyleBox[\"2\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   
                   xAct`xTensor`Basis[{2, -$CellContext`fred}, {
                    0, $CellContext`blues}], Editable -> False]}]}]}]],
           
           Annotation[#, {1} -> 
            3^Rational[1, 2] 
              xAct`xTensor`Basis[{0, -$CellContext`fred}, {
                0, $CellContext`blues}] + 
             Rational[4, 5] 
              xAct`xTensor`Basis[{1, -$CellContext`fred}, {
                0, $CellContext`blues}] - 2 
             xAct`xTensor`Basis[{2, -$CellContext`fred}, {
               0, $CellContext`blues}], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", "2", "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{
                  SqrtBox["3"], " ", 
                  InterpretationBox[
                   StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"1\",FontColor->RGBColor[0., 0., \
1.]]\)"}, {"\!\(\*StyleBox[\"0\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   
                   xAct`xTensor`Basis[{0, -$CellContext`fred}, {
                    1, $CellContext`blues}], Editable -> False]}], "+", 
                FractionBox[
                 RowBox[{"4", " ", 
                   InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"1\",FontColor->RGBColor[0., 0., \
1.]]\)"}, {"\!\(\*StyleBox[\"1\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    
                    xAct`xTensor`Basis[{1, -$CellContext`fred}, {
                    1, $CellContext`blues}], Editable -> False]}], "5"], "-", 
                
                RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"1\",FontColor->RGBColor[0., 0., \
1.]]\)"}, {"\!\(\*StyleBox[\"2\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   
                   xAct`xTensor`Basis[{2, -$CellContext`fred}, {
                    1, $CellContext`blues}], Editable -> False]}]}]}]],
           
           Annotation[#, {2} -> 
            3^Rational[1, 2] 
              xAct`xTensor`Basis[{0, -$CellContext`fred}, {
                1, $CellContext`blues}] + 
             Rational[4, 5] 
              xAct`xTensor`Basis[{1, -$CellContext`fred}, {
                1, $CellContext`blues}] - 2 
             xAct`xTensor`Basis[{2, -$CellContext`fred}, {
               1, $CellContext`blues}], "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", "3", "}"}], "\[Rule]", 
              RowBox[{
                RowBox[{
                  SqrtBox["3"], " ", 
                  InterpretationBox[
                   StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"2\",FontColor->RGBColor[0., 0., \
1.]]\)"}, {"\!\(\*StyleBox[\"0\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   
                   xAct`xTensor`Basis[{0, -$CellContext`fred}, {
                    2, $CellContext`blues}], Editable -> False]}], "+", 
                FractionBox[
                 RowBox[{"4", " ", 
                   InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"2\",FontColor->RGBColor[0., 0., \
1.]]\)"}, {"\!\(\*StyleBox[\"1\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    
                    xAct`xTensor`Basis[{1, -$CellContext`fred}, {
                    2, $CellContext`blues}], Editable -> False]}], "5"], "-", 
                
                RowBox[{"2", " ", 
                  InterpretationBox[
                   StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{
                    " ", "\!\(\*StyleBox[\"2\",FontColor->RGBColor[0., 0., \
1.]]\)"}, {"\!\(\*StyleBox[\"2\",FontColor->RGBColor[1., 0., 0.]]\)", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   
                   xAct`xTensor`Basis[{2, -$CellContext`fred}, {
                    2, $CellContext`blues}], Editable -> False]}]}]}]],
           
           Annotation[#, {3} -> 
            3^Rational[1, 2] 
              xAct`xTensor`Basis[{0, -$CellContext`fred}, {
                2, $CellContext`blues}] + 
             Rational[4, 5] 
              xAct`xTensor`Basis[{1, -$CellContext`fred}, {
                2, $CellContext`blues}] - 2 
             xAct`xTensor`Basis[{2, -$CellContext`fred}, {
               2, $CellContext`blues}], "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {
           1 -> RGBColor[0, 0, 1], 2 -> RGBColor[0, 0, 1]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{
   3^Rational[1, 2] 
     xAct`xTensor`Basis[{0, -$CellContext`fred}, {0, $CellContext`blues}] + 
    Rational[4, 5] 
     xAct`xTensor`Basis[{1, -$CellContext`fred}, {0, $CellContext`blues}] - 2 
    xAct`xTensor`Basis[{2, -$CellContext`fred}, {0, $CellContext`blues}], 
    3^Rational[1, 2] 
     xAct`xTensor`Basis[{0, -$CellContext`fred}, {1, $CellContext`blues}] + 
    Rational[4, 5] 
     xAct`xTensor`Basis[{1, -$CellContext`fred}, {1, $CellContext`blues}] - 2 
    xAct`xTensor`Basis[{2, -$CellContext`fred}, {1, $CellContext`blues}], 
    3^Rational[1, 2] 
     xAct`xTensor`Basis[{0, -$CellContext`fred}, {2, $CellContext`blues}] + 
    Rational[4, 5] 
     xAct`xTensor`Basis[{1, -$CellContext`fred}, {2, $CellContext`blues}] - 2 
    xAct`xTensor`Basis[{2, -$CellContext`fred}, {
      2, $CellContext`blues}]}, {$CellContext`blues}, 0][$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.7286592773614264`*^9, 3.728660580063014*^9, 3.728671076309702*^9, 
   3.728674876761455*^9, 3.728732845738203*^9, 3.728733556792618*^9, 
   3.728742313419415*^9, 3.728743291384695*^9, 3.728743389854595*^9, 
   3.728747125664263*^9, 3.7287494556864033`*^9, 3.72874993103216*^9, 
   3.7287500819943523`*^9, 3.728750185117831*^9, 3.7287502952206182`*^9, 
   3.728750517338655*^9, 3.7287505763871727`*^9, 3.728750722127281*^9, {
   3.7287509812516603`*^9, 3.728751004757245*^9}, 3.728751614818686*^9, 
   3.728813260682721*^9, 3.728827377700304*^9, 3.728843037787189*^9, 
   3.728845620080158*^9, 3.7333672574684*^9, 3.790862642464549*^9, 
   3.790867081152453*^9, 3.7922731954534483`*^9},
 CellLabel->"Out[42]=",
 CellID->635845039,ExpressionUUID->"a8ab833a-16d1-4f97-a83a-ae7075a4d5e7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ContractBasis is quite general and allows the user to specify which indices \
should be acted upon. The default is total contraction:\
\>", "MathCaption",
 CellChangeTimes->{{3.7286593507920218`*^9, 
  3.728659357125814*^9}},ExpressionUUID->"732e82b6-b346-4d4a-8cb7-\
4804076352ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "blues"}], "}"}]}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "fred"}], "}"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", "e"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.728733562883897*^9, 3.7287336096098824`*^9}, {
   3.728747128939732*^9, 3.728747161496373*^9}, 3.7287492445139303`*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"644c1d17-43de-4b30-933f-75681cb99f09"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`blues}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "e"},
          {
           StyleBox["d",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`d, -$CellContext`fred}, $CellContext`e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", "c", 
           StyleBox["d",
            FontColor->RGBColor[1., 0., 0.]]},
          {"a", "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`a, -$CellContext`b, $CellContext`c, \
{$CellContext`d, $CellContext`fred}],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.728645901215798*^9, 3.7286593590402937`*^9, 3.72866058025765*^9, 
   3.728671077575845*^9, 3.7286748770658703`*^9, 3.728732852304935*^9, 
   3.728733610232348*^9, 3.728742313561075*^9, 3.7287432915512114`*^9, 
   3.7287433899992857`*^9, 3.7287471619578857`*^9, 3.7287494567594147`*^9, 
   3.72874993115726*^9, 3.7287500821826067`*^9, 3.728750185319347*^9, 
   3.7287502954016447`*^9, 3.728750517536615*^9, 3.728750576529258*^9, 
   3.728750722221685*^9, {3.728750981418046*^9, 3.728751004859355*^9}, 
   3.7287516149816217`*^9, 3.728813260826335*^9, 3.728827377857832*^9, 
   3.72884303927351*^9, 3.7288456202500963`*^9, 3.733367258953932*^9, 
   3.790862643662071*^9, 3.790867091450263*^9, 3.792273196632375*^9},
 CellLabel->"Out[43]=",
 CellID->1421076894,ExpressionUUID->"65cd8321-03db-4867-aad4-cadea8023d4a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", "expr", "]"}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"4023367d-aa79-4d9f-abeb-f2900830add1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {" ", " ", 
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]], "e"},
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{1, -$CellContext`fred}, -$CellContext`b, {
   1, $CellContext`blues}, $CellContext`e],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728645902037877*^9, 3.728659359857806*^9, 3.728660580393265*^9, 
   3.7286710781947403`*^9, 3.728674877218143*^9, 3.728732853288909*^9, 
   3.728733611215819*^9, 3.7287423139089403`*^9, 3.728743291683559*^9, 
   3.728743390132901*^9, 3.728747162846347*^9, 3.72874945740127*^9, 
   3.728749931271481*^9, 3.728750082352669*^9, 3.728750185657567*^9, 
   3.728750295551732*^9, 3.7287505176720333`*^9, 3.728750576713509*^9, 
   3.728750722317079*^9, {3.728750981540331*^9, 3.728751004949976*^9}, 
   3.72875161567697*^9, 3.728813260998289*^9, 3.728827377988513*^9, 
   3.728843039990844*^9, 3.728845620410428*^9, 3.733367259653534*^9, 
   3.790862644290967*^9, 3.790867092265725*^9, 3.7922731973160343`*^9},
 CellLabel->"Out[44]=",
 CellID->2075856550,ExpressionUUID->"4dccd27d-c450-4d22-8572-f86837b10363"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", "fred"}], "]"}]], "Input",
 CellChangeTimes->{{3.728733614481164*^9, 3.728733614801462*^9}, {
  3.7287471669907722`*^9, 3.728747167487653*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"b3f1b95a-f13a-49eb-83bd-261e42316d5b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`blues}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", "c", "e"},
          {"a", "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`e],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.7286459028012047`*^9, 3.7286593605550632`*^9, 3.728660580544837*^9, 
   3.7286710788592587`*^9, 3.728674877400217*^9, 3.7287328541561117`*^9, 
   3.72873361561948*^9, 3.728742314178133*^9, 3.7287432918330936`*^9, 
   3.728743390300458*^9, 3.728747167939932*^9, 3.728749458017366*^9, 
   3.728749931366468*^9, 3.728750082521471*^9, 3.728750186070795*^9, 
   3.728750295731461*^9, 3.728750517853341*^9, 3.728750576878702*^9, 
   3.728750722426601*^9, {3.728750981675538*^9, 3.72875100506754*^9}, 
   3.7287516166572638`*^9, 3.728813261140973*^9, 3.728827378141533*^9, 
   3.728843040674385*^9, 3.7288456205910387`*^9, 3.733367260352812*^9, 
   3.7908626448588543`*^9, 3.7908670929054747`*^9, 3.792273197886033*^9},
 CellLabel->"Out[45]=",
 CellID->875006227,ExpressionUUID->"91944c9a-d826-4f99-a471-80f305b052aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"185b485b-f451-4e4c-b55c-c113a375f0c1"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`blues}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "e"},
          {
           StyleBox["d",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`d, -$CellContext`fred}, $CellContext`e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", "c", 
           StyleBox["d",
            FontColor->RGBColor[1., 0., 0.]]},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{
    1, -$CellContext`fred}, -$CellContext`b, $CellContext`c, {$CellContext`d, \
$CellContext`fred}],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.728645903539863*^9, 3.728659361175002*^9, 3.7286605807039557`*^9, 
   3.728671079493909*^9, 3.728674877547068*^9, 3.7287328549888487`*^9, 
   3.728733617135695*^9, 3.728742314674972*^9, 3.7287432920024557`*^9, 
   3.728743390434216*^9, 3.728747169719655*^9, 3.728749458584783*^9, 
   3.728749931518736*^9, 3.7287500827750263`*^9, 3.7287501866217947`*^9, 
   3.72875029648604*^9, 3.7287505180042343`*^9, 3.728750577026417*^9, 
   3.728750722528451*^9, {3.728750981809354*^9, 3.728751005178564*^9}, 
   3.728751616842252*^9, 3.728813261293439*^9, 3.728827378291399*^9, 
   3.728843041373919*^9, 3.72884562072771*^9, 3.733367261038096*^9, 
   3.790862645954204*^9, 3.790867093488693*^9, 3.792273198406361*^9},
 CellLabel->"Out[46]=",
 CellID->595358560,ExpressionUUID->"32da72cf-b3aa-4c46-8928-aa1bb46437f1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The inverse function is SeparateBasis, also quite general. It can undo the \
action of ContractBasis and also change the basis of the whole expression\
\>", "MathCaption",ExpressionUUID->"f191f0cd-83f9-4208-b040-9a8523661f0f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cexpr", "=", 
  RowBox[{"ContractBasis", "[", "expr", "]"}]}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"9562eb05-9c3e-4c35-a176-2bcd9d36f40c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {" ", " ", 
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]], "e"},
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{1, -$CellContext`fred}, -$CellContext`b, {
   1, $CellContext`blues}, $CellContext`e],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728645905035679*^9, 3.728659365325197*^9, 3.728660581008718*^9, 
   3.7286710807604628`*^9, 3.728674877710493*^9, 3.728732856421146*^9, 
   3.728733620051135*^9, 3.728742314804782*^9, 3.7287432921466208`*^9, 
   3.728743390566123*^9, 3.728747173773511*^9, 3.7287494597346563`*^9, 
   3.728749931637566*^9, 3.728750082916168*^9, 3.728750186807109*^9, 
   3.728750296636909*^9, 3.728750518139744*^9, 3.7287505771768637`*^9, 
   3.728750722627792*^9, {3.728750981925397*^9, 3.728751005267762*^9}, 
   3.728751617038905*^9, 3.728813261439868*^9, 3.7288273784386663`*^9, 
   3.728843042791192*^9, 3.728845620901767*^9, 3.733367262437214*^9, 
   3.790862647499134*^9, 3.7908670952850523`*^9, 3.7922731998988733`*^9},
 CellLabel->"Out[47]=",
 CellID->2130434817,ExpressionUUID->"f9e38686-cad3-4fef-9d05-3e9dcb22de92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateBasis", "[", "AIndex", "]"}], "[", "cexpr", "]"}]], "Input",\

 CellLabel->"In[48]:=",ExpressionUUID->"c0e15c0e-7246-4677-83f1-5e4102bfd863"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {"c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`blues}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", "c", "e"},
          {"a", "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`e],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.728645906085597*^9, 3.7286593660723057`*^9, 3.728660581446041*^9, 
   3.728671081394004*^9, 3.728674877881874*^9, 3.728732858138887*^9, 
   3.728733621401819*^9, 3.7287423154035683`*^9, 3.728743292348319*^9, 
   3.728743390682749*^9, 3.728747176957244*^9, 3.72874946033469*^9, 
   3.72874993175078*^9, 3.728750083099104*^9, 3.728750187284821*^9, 
   3.728750296817696*^9, 3.728750518284646*^9, 3.728750577339946*^9, 
   3.7287507227682056`*^9, {3.728750982036283*^9, 3.728751005347109*^9}, 
   3.728751617239727*^9, 3.728813261592263*^9, 3.728827378606987*^9, 
   3.728843043507699*^9, 3.728845621058146*^9, 3.733367263036324*^9, 
   3.790862648075068*^9, 3.790867096721552*^9, 3.792273200397128*^9},
 CellLabel->"Out[48]=",
 CellID->2018184273,ExpressionUUID->"f0fed273-4c5d-46ef-b7b7-031066f8ea49"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateBasis", "[", "blues", "]"}], "[", "cexpr", "]"}]], "Input",\

 CellChangeTimes->{{3.7287336243046627`*^9, 3.7287336257550917`*^9}, {
   3.728747179993021*^9, 3.7287471806872*^9}, 3.728749246765738*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"5f27a659-edaa-4817-9ca6-f92b5b99c917"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["c",
            FontColor->RGBColor[0., 0., 1.]]},
          {"b", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`b, {$CellContext`c, $CellContext`blues}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["a",
            FontColor->RGBColor[0., 0., 1.]]},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{
    1, -$CellContext`fred}, {$CellContext`a, $CellContext`blues}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]]},
          {
           StyleBox["d",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`d, -$CellContext`blues}, {
    1, $CellContext`blues}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "e"},
          {
           StyleBox["f",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`f, -$CellContext`blues}, $CellContext`e],
   
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["d",
            FontColor->RGBColor[0., 0., 1.]], 
           StyleBox["f",
            FontColor->RGBColor[0., 0., 1.]]},
          {
           StyleBox["a",
            FontColor->RGBColor[0., 0., 1.]], 
           StyleBox["c",
            FontColor->RGBColor[0., 0., 1.]], " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{-$CellContext`a, -$CellContext`blues}, {-$CellContext`c, \
-$CellContext`blues}, {$CellContext`d, $CellContext`blues}, {$CellContext`f, \
$CellContext`blues}],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.7286459069592752`*^9, 3.728659366756983*^9, 3.728660581639659*^9, 
   3.728671082025057*^9, 3.728674878066738*^9, 3.728732859606332*^9, 
   3.728733626418371*^9, 3.728742315869981*^9, 3.7287432924850683`*^9, 
   3.728743390850091*^9, 3.728747181188478*^9, 3.728749460947112*^9, 
   3.728749931868095*^9, 3.7287500832581377`*^9, 3.728750187569511*^9, 
   3.728750297029105*^9, 3.728750518437439*^9, 3.7287505775005627`*^9, 
   3.728750722865849*^9, {3.728750982212698*^9, 3.728751005451541*^9}, 
   3.728751617396041*^9, 3.728813261744954*^9, 3.728827378758469*^9, 
   3.728843044291744*^9, 3.7288456212939568`*^9, 3.733367263834042*^9, 
   3.790862648622868*^9, 3.790867097980218*^9, 3.792273202672491*^9},
 CellLabel->"Out[49]=",
 CellID->2072055645,ExpressionUUID->"26da2d4c-7e0a-4ead-9100-485ae7d95a59"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Another important features is the ability to trace basis contractions,\
\>", "MathCaption",
 CellChangeTimes->{{3.728659376404819*^9, 
  3.728659381884268*^9}},ExpressionUUID->"600bb412-90c2-4297-af29-\
984398da8d42"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraceBasisDummy", "[", 
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "blues"}], "}"}], "]"}], 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", 
     RowBox[{"-", "b"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728733632337534*^9, 3.728733634383157*^9}, {
  3.728747184464964*^9, 3.728747190454898*^9}, {3.728749249641384*^9, 
  3.728749251005344*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"2b19ef62-7e0e-4584-ac0f-0a8cd5e21383"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {
            StyleBox["0",
             FontColor->RGBColor[0., 0., 1.]], "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{0, -$CellContext`blues}, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["0",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{0, $CellContext`blues}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{1, -$CellContext`blues}, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{1, $CellContext`blues}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{2, -$CellContext`blues}, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{2, $CellContext`blues}],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.7286459096361647`*^9, 3.728659383525722*^9, 3.728660581941255*^9, 
   3.7286710837773314`*^9, 3.728674878397744*^9, 3.728732864957357*^9, 
   3.728733635137611*^9, 3.728742315996902*^9, 3.728743292717317*^9, 
   3.728743390966918*^9, 3.728747191171215*^9, 3.728749462223446*^9, 
   3.728749931984376*^9, 3.728750083433025*^9, 3.728750187757642*^9, 
   3.728750297615917*^9, 3.7287505185502977`*^9, 3.7287505776903143`*^9, 
   3.728750722966165*^9, {3.728750982391608*^9, 3.728751005563882*^9}, 
   3.728751617613662*^9, 3.728813261894397*^9, 3.728827378911272*^9, 
   3.7288430460244493`*^9, 3.728845621475374*^9, 3.7333672650225697`*^9, 
   3.790862650020854*^9, 3.790867105302608*^9, 3.792273204857037*^9},
 CellLabel->"Out[50]=",
 CellID->454205248,ExpressionUUID->"6b47f00a-c810-4918-b610-c9100445e6a5"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Finally, we will have a quick look at the third method to store components, \
which is useful for partially-abstract computations, or cases with a high \
degree of symmetry.\
\>", "Text",
 CellChangeTimes->{{3.7286596164167624`*^9, 3.72865967513535*^9}},
 CellID->1541888545,ExpressionUUID->"afbccaae-ae0f-4f20-8cca-5c862826a72a"],

Cell[CellGroupData[{

Cell["\<\
We can assign rules to the components of a tensor taking the symmetries into \
account\
\>", "MathCaption",ExpressionUUID->"deb17fcf-f095-41f1-a81c-cd04b791fe2d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "-", "j"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"33350187-25c2-431b-b909-dc8b7a9fb8a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AllComponentValues", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}]}], "]"}], ",", " ", "values"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.728733642834337*^9, 3.7287336488737307`*^9}, {
  3.7287471964484987`*^9, 3.728747199238364*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"1b4d9a3d-c4f5-483c-be9a-93895f145913"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{0, -$CellContext`fred}, {0, -$CellContext`fred}],
     Editable->False], "\[Rule]", "0"}], 
   "\[InvisibleSpace]", "\<\" for tensor \"\>", "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{0, -$CellContext`fred}, {
     0, -$CellContext`fred}] -> 0, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459173172073`*^9, 3.728659686300744*^9, 3.728660582228342*^9, 
   3.728671086075186*^9, 3.7286748786260967`*^9, 3.7287328676708927`*^9, 
   3.728733649639093*^9, 3.728742316161644*^9, 3.728743292919387*^9, 
   3.728743391180121*^9, 3.728747199672443*^9, 3.7287494655488586`*^9, 
   3.7287499321812153`*^9, 3.728750083671248*^9, 3.728750188389699*^9, 
   3.728750298129628*^9, 3.728750518820197*^9, 3.7287505779621572`*^9, 
   3.728750723090013*^9, {3.7287509825734453`*^9, 3.728751005661495*^9}, 
   3.728751617832035*^9, 3.728813262155266*^9, 3.728827379123863*^9, 
   3.7288430492376633`*^9, 3.728845621854383*^9, 3.733367267635683*^9, 
   3.79086265235045*^9, 3.790867107345881*^9, 3.7922732069714518`*^9},
 CellLabel->"During evaluation of In[52]:=",
 CellID->944573012,ExpressionUUID->"f40e06a7-3aa6-4c4b-98df-2e976f11afc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", "1"}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added independent rule ", $CellContext`T[{0, -$CellContext`fred}, {
     1, -$CellContext`fred}] -> -1, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459173172073`*^9, 3.728659686300744*^9, 3.728660582228342*^9, 
   3.728671086075186*^9, 3.7286748786260967`*^9, 3.7287328676708927`*^9, 
   3.728733649639093*^9, 3.728742316161644*^9, 3.728743292919387*^9, 
   3.728743391180121*^9, 3.728747199672443*^9, 3.7287494655488586`*^9, 
   3.7287499321812153`*^9, 3.728750083671248*^9, 3.728750188389699*^9, 
   3.728750298129628*^9, 3.728750518820197*^9, 3.7287505779621572`*^9, 
   3.728750723090013*^9, {3.7287509825734453`*^9, 3.728751005661495*^9}, 
   3.728751617832035*^9, 3.728813262155266*^9, 3.728827379123863*^9, 
   3.7288430492376633`*^9, 3.728845621854383*^9, 3.733367267635683*^9, 
   3.79086265235045*^9, 3.790867107345881*^9, 3.7922732070026007`*^9},
 CellLabel->"During evaluation of In[52]:=",
 CellID->1239494060,ExpressionUUID->"0ded7113-e553-4f40-9e8f-b69fc788e421"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", "2"}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added independent rule ", $CellContext`T[{0, -$CellContext`fred}, {
     2, -$CellContext`fred}] -> -2, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459173172073`*^9, 3.728659686300744*^9, 3.728660582228342*^9, 
   3.728671086075186*^9, 3.7286748786260967`*^9, 3.7287328676708927`*^9, 
   3.728733649639093*^9, 3.728742316161644*^9, 3.728743292919387*^9, 
   3.728743391180121*^9, 3.728747199672443*^9, 3.7287494655488586`*^9, 
   3.7287499321812153`*^9, 3.728750083671248*^9, 3.728750188389699*^9, 
   3.728750298129628*^9, 3.728750518820197*^9, 3.7287505779621572`*^9, 
   3.728750723090013*^9, {3.7287509825734453`*^9, 3.728751005661495*^9}, 
   3.728751617832035*^9, 3.728813262155266*^9, 3.728827379123863*^9, 
   3.7288430492376633`*^9, 3.728845621854383*^9, 3.733367267635683*^9, 
   3.79086265235045*^9, 3.790867107345881*^9, 3.7922732070222397`*^9},
 CellLabel->"During evaluation of In[52]:=",
 CellID->1585290520,ExpressionUUID->"b375287e-5673-4831-892e-0cdd341ceb22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{1, -$CellContext`fred}, {0, -$CellContext`fred}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{1, -$CellContext`fred}, {
     0, -$CellContext`fred}] -> -$CellContext`T[{0, -$CellContext`fred}, {
      1, -$CellContext`fred}], " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459173172073`*^9, 3.728659686300744*^9, 3.728660582228342*^9, 
   3.728671086075186*^9, 3.7286748786260967`*^9, 3.7287328676708927`*^9, 
   3.728733649639093*^9, 3.728742316161644*^9, 3.728743292919387*^9, 
   3.728743391180121*^9, 3.728747199672443*^9, 3.7287494655488586`*^9, 
   3.7287499321812153`*^9, 3.728750083671248*^9, 3.728750188389699*^9, 
   3.728750298129628*^9, 3.728750518820197*^9, 3.7287505779621572`*^9, 
   3.728750723090013*^9, {3.7287509825734453`*^9, 3.728751005661495*^9}, 
   3.728751617832035*^9, 3.728813262155266*^9, 3.728827379123863*^9, 
   3.7288430492376633`*^9, 3.728845621854383*^9, 3.733367267635683*^9, 
   3.79086265235045*^9, 3.790867107345881*^9, 3.792273207057208*^9},
 CellLabel->"During evaluation of In[52]:=",
 CellID->148161311,ExpressionUUID->"117862d2-3d6e-41f6-8750-2c856039f956"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{1, -$CellContext`fred}, {1, -$CellContext`fred}],
     Editable->False], "\[Rule]", "0"}], 
   "\[InvisibleSpace]", "\<\" for tensor \"\>", "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{1, -$CellContext`fred}, {
     1, -$CellContext`fred}] -> 0, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459173172073`*^9, 3.728659686300744*^9, 3.728660582228342*^9, 
   3.728671086075186*^9, 3.7286748786260967`*^9, 3.7287328676708927`*^9, 
   3.728733649639093*^9, 3.728742316161644*^9, 3.728743292919387*^9, 
   3.728743391180121*^9, 3.728747199672443*^9, 3.7287494655488586`*^9, 
   3.7287499321812153`*^9, 3.728750083671248*^9, 3.728750188389699*^9, 
   3.728750298129628*^9, 3.728750518820197*^9, 3.7287505779621572`*^9, 
   3.728750723090013*^9, {3.7287509825734453`*^9, 3.728751005661495*^9}, 
   3.728751617832035*^9, 3.728813262155266*^9, 3.728827379123863*^9, 
   3.7288430492376633`*^9, 3.728845621854383*^9, 3.733367267635683*^9, 
   3.79086265235045*^9, 3.790867107345881*^9, 3.792273207089044*^9},
 CellLabel->"During evaluation of In[52]:=",
 CellID->1213607104,ExpressionUUID->"61a662ad-2b6c-403a-852d-0fc368e7de74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", "1"}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added independent rule ", $CellContext`T[{1, -$CellContext`fred}, {
     2, -$CellContext`fred}] -> -1, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459173172073`*^9, 3.728659686300744*^9, 3.728660582228342*^9, 
   3.728671086075186*^9, 3.7286748786260967`*^9, 3.7287328676708927`*^9, 
   3.728733649639093*^9, 3.728742316161644*^9, 3.728743292919387*^9, 
   3.728743391180121*^9, 3.728747199672443*^9, 3.7287494655488586`*^9, 
   3.7287499321812153`*^9, 3.728750083671248*^9, 3.728750188389699*^9, 
   3.728750298129628*^9, 3.728750518820197*^9, 3.7287505779621572`*^9, 
   3.728750723090013*^9, {3.7287509825734453`*^9, 3.728751005661495*^9}, 
   3.728751617832035*^9, 3.728813262155266*^9, 3.728827379123863*^9, 
   3.7288430492376633`*^9, 3.728845621854383*^9, 3.733367267635683*^9, 
   3.79086265235045*^9, 3.790867107345881*^9, 3.792273207098261*^9},
 CellLabel->"During evaluation of In[52]:=",
 CellID->294917722,ExpressionUUID->"94dccdfb-5140-42e6-8dad-f0c21f3083d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{2, -$CellContext`fred}, {0, -$CellContext`fred}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["0",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{2, -$CellContext`fred}, {
     0, -$CellContext`fred}] -> -$CellContext`T[{0, -$CellContext`fred}, {
      2, -$CellContext`fred}], " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459173172073`*^9, 3.728659686300744*^9, 3.728660582228342*^9, 
   3.728671086075186*^9, 3.7286748786260967`*^9, 3.7287328676708927`*^9, 
   3.728733649639093*^9, 3.728742316161644*^9, 3.728743292919387*^9, 
   3.728743391180121*^9, 3.728747199672443*^9, 3.7287494655488586`*^9, 
   3.7287499321812153`*^9, 3.728750083671248*^9, 3.728750188389699*^9, 
   3.728750298129628*^9, 3.728750518820197*^9, 3.7287505779621572`*^9, 
   3.728750723090013*^9, {3.7287509825734453`*^9, 3.728751005661495*^9}, 
   3.728751617832035*^9, 3.728813262155266*^9, 3.728827379123863*^9, 
   3.7288430492376633`*^9, 3.728845621854383*^9, 3.733367267635683*^9, 
   3.79086265235045*^9, 3.790867107345881*^9, 3.792273207132406*^9},
 CellLabel->"During evaluation of In[52]:=",
 CellID->289896378,ExpressionUUID->"745c9ebc-aecf-46b3-8510-3b5bd218c97f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{2, -$CellContext`fred}, {1, -$CellContext`fred}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{2, -$CellContext`fred}, {
     1, -$CellContext`fred}] -> -$CellContext`T[{1, -$CellContext`fred}, {
      2, -$CellContext`fred}], " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459173172073`*^9, 3.728659686300744*^9, 3.728660582228342*^9, 
   3.728671086075186*^9, 3.7286748786260967`*^9, 3.7287328676708927`*^9, 
   3.728733649639093*^9, 3.728742316161644*^9, 3.728743292919387*^9, 
   3.728743391180121*^9, 3.728747199672443*^9, 3.7287494655488586`*^9, 
   3.7287499321812153`*^9, 3.728750083671248*^9, 3.728750188389699*^9, 
   3.728750298129628*^9, 3.728750518820197*^9, 3.7287505779621572`*^9, 
   3.728750723090013*^9, {3.7287509825734453`*^9, 3.728751005661495*^9}, 
   3.728751617832035*^9, 3.728813262155266*^9, 3.728827379123863*^9, 
   3.7288430492376633`*^9, 3.728845621854383*^9, 3.733367267635683*^9, 
   3.79086265235045*^9, 3.790867107345881*^9, 3.792273207167738*^9},
 CellLabel->"During evaluation of In[52]:=",
 CellID->1795513650,ExpressionUUID->"267332f1-8507-493f-af6a-97b1e2fcec76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added dependent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{2, -$CellContext`fred}, {2, -$CellContext`fred}],
     Editable->False], "\[Rule]", "0"}], 
   "\[InvisibleSpace]", "\<\" for tensor \"\>", "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "Added dependent rule ", $CellContext`T[{2, -$CellContext`fred}, {
     2, -$CellContext`fred}] -> 0, " for tensor ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459173172073`*^9, 3.728659686300744*^9, 3.728660582228342*^9, 
   3.728671086075186*^9, 3.7286748786260967`*^9, 3.7287328676708927`*^9, 
   3.728733649639093*^9, 3.728742316161644*^9, 3.728743292919387*^9, 
   3.728743391180121*^9, 3.728747199672443*^9, 3.7287494655488586`*^9, 
   3.7287499321812153`*^9, 3.728750083671248*^9, 3.728750188389699*^9, 
   3.728750298129628*^9, 3.728750518820197*^9, 3.7287505779621572`*^9, 
   3.728750723090013*^9, {3.7287509825734453`*^9, 3.728751005661495*^9}, 
   3.728751617832035*^9, 3.728813262155266*^9, 3.728827379123863*^9, 
   3.7288430492376633`*^9, 3.728845621854383*^9, 3.733367267635683*^9, 
   3.79086265235045*^9, 3.790867107345881*^9, 3.7922732071767597`*^9},
 CellLabel->"During evaluation of In[52]:=",
 CellID->757707906,ExpressionUUID->"f79d217b-b6e5-41ae-b9ba-1d1a39fb69dd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`fred}, {0, -$CellContext`fred}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`fred}, {0, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`fred}, {1, -$CellContext`fred}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`fred}, {0, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`fred}, {1, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`fred}, {2, -$CellContext`fred}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.7286459179746923`*^9, 3.728659687048736*^9, 3.728660583362002*^9, 
   3.728671086866268*^9, 3.7286748794919367`*^9, 3.728732868206554*^9, 
   3.728733650319686*^9, 3.7287423167203703`*^9, 3.728743293496194*^9, 
   3.728743391961341*^9, 3.728747200459404*^9, 3.728749466357004*^9, 
   3.728749932922831*^9, 3.728750084574027*^9, 3.728750189459407*^9, 
   3.728750299470415*^9, 3.728750519591885*^9, 3.728750578749645*^9, 
   3.7287507235549517`*^9, {3.7287509832135067`*^9, 3.728751006208733*^9}, 
   3.7287516186252823`*^9, 3.728813262969472*^9, 3.728827379901928*^9, 
   3.7288430502302103`*^9, 3.7288456227529097`*^9, 3.733367268219865*^9, 
   3.790862652599327*^9, 3.7908671076560497`*^9, 3.792273207218918*^9},
 CellLabel->"Out[52]=",
 CellID->218749432,ExpressionUUID->"bb8f41fd-7280-4b15-8402-87665ef58891"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The FoldedRule notation represents a way of storing nested rules:\
\>", "MathCaption",
 CellChangeTimes->{{3.728659694973914*^9, 3.7286597475960093`*^9}},
 CellID->1885112655,ExpressionUUID->"4bdb2f65-538f-4d0c-ac66-cb62449142e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColumnForm", "/@", 
  RowBox[{"TensorValues", "[", "T", "]"}]}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"00f32037-3bee-42f0-a788-d81b78c5e3ff"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   InterpretationBox[GridBox[{
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {0, -$CellContext`fred}],
         Editable->False], "\[Rule]", "0"}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`fred}, {0, -$CellContext`fred}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`fred}, {1, -$CellContext`fred}],
         Editable->False], "\[Rule]", "0"}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`fred}, {0, -$CellContext`fred}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`fred}, {1, -$CellContext`fred}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False], "\[Rule]", "0"}]}
     },
     BaselinePosition->{Baseline, {1, 1}},
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
    ColumnForm[{$CellContext`T[{0, -$CellContext`fred}, {
        0, -$CellContext`fred}] -> 
      0, $CellContext`T[{1, -$CellContext`fred}, {
        0, -$CellContext`fred}] -> -$CellContext`T[{0, -$CellContext`fred}, {
         1, -$CellContext`fred}], $CellContext`T[{1, -$CellContext`fred}, {
        1, -$CellContext`fred}] -> 
      0, $CellContext`T[{2, -$CellContext`fred}, {
        0, -$CellContext`fred}] -> -$CellContext`T[{0, -$CellContext`fred}, {
         2, -$CellContext`fred}], $CellContext`T[{2, -$CellContext`fred}, {
        1, -$CellContext`fred}] -> -$CellContext`T[{1, -$CellContext`fred}, {
         2, -$CellContext`fred}], $CellContext`T[{2, -$CellContext`fred}, {
        2, -$CellContext`fred}] -> 0}],
    Editable->False], ",", 
   InterpretationBox[GridBox[{
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", "2"}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", "1"}]}]}
     },
     BaselinePosition->{Baseline, {1, 1}},
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
    ColumnForm[{$CellContext`T[{0, -$CellContext`fred}, {
        1, -$CellContext`fred}] -> -1, $CellContext`T[{
        0, -$CellContext`fred}, {
        2, -$CellContext`fred}] -> -2, $CellContext`T[{
        1, -$CellContext`fred}, {2, -$CellContext`fred}] -> -1}],
    Editable->False]}], "]"}]], "Output",
 CellChangeTimes->{
  3.728645920101096*^9, 3.7286605835473127`*^9, 3.728671088071703*^9, 
   3.7286748798499327`*^9, 3.728732870520162*^9, 3.728733651825803*^9, 
   3.728742316859425*^9, 3.728743293667642*^9, 3.728743392147851*^9, 
   3.728747202889242*^9, 3.728749467512702*^9, 3.7287499330807123`*^9, 
   3.728750084744596*^9, 3.728750189669278*^9, 3.728750299686432*^9, 
   3.7287505197821074`*^9, 3.7287505789226007`*^9, 3.728750723659313*^9, {
   3.728750983379961*^9, 3.728751006302421*^9}, 3.728751618897305*^9, 
   3.7288132631516123`*^9, 3.72882738013489*^9, 3.728843051852195*^9, 
   3.7288456229477463`*^9, 3.7333672699365463`*^9, 3.790862654237136*^9, 
   3.790867108821273*^9, 3.7922732091408653`*^9},
 CellLabel->"Out[53]=",
 CellID->2010904542,ExpressionUUID->"5701f1c6-5f93-4f66-8f51-66aba91a25dd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
As we can see, dependent and independent components are stored in separate \
sublists. We can change basis:\
\>", "MathCaption",ExpressionUUID->"201596bc-06bb-4556-922e-4c117a9b7035"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CVVerbose", "=", "False"}], ";"}]], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"26b472bf-3a6f-4dd6-a1a9-016ae202193e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeComponents", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"a", ",", "blues"}], "}"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"b", ",", "blues"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"a", ",", "fred"}], "}"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"b", ",", "fred"}], "}"}]}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728733657823721*^9, 3.728733666718472*^9}, {
  3.728747207703905*^9, 3.728747214613381*^9}, {3.728749252135845*^9, 
  3.72874925297509*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"a88a7724-b78c-4527-b786-30607311eee0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["a",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["b",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{-$CellContext`a, -$CellContext`fred}, {-$CellContext`b, \
-$CellContext`blues}],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`blues}, \
{$CellContext`c, $CellContext`fred}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["a",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{-$CellContext`a, -$CellContext`fred}, {-$CellContext`c, \
-$CellContext`fred}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" in \"\>", 
   "\[InvisibleSpace]", "0.039167`5.044465301491588", 
   "\[InvisibleSpace]", "\<\" Seconds\"\>"}],
  SequenceForm[
  "Computed ", $CellContext`T[{-$CellContext`a, -$CellContext`fred}, \
{-$CellContext`b, -$CellContext`blues}] -> 
   xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`blues}, \
{$CellContext`c, $CellContext`fred}] $CellContext`T[{-$CellContext`a, \
-$CellContext`fred}, {-$CellContext`c, -$CellContext`fred}], " in ", 
   0.039167`5.044465301491588, " Seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459228511667`*^9, 3.728659757075322*^9, 3.728660584151334*^9, 
   3.7286710898935127`*^9, 3.7286748800471563`*^9, 3.728732872855349*^9, 
   3.728733667311123*^9, 3.728742317094062*^9, 3.72874329391508*^9, 
   3.728743392411622*^9, 3.728747215006261*^9, 3.7287494692934647`*^9, 
   3.728749933270899*^9, 3.728750085060267*^9, 3.728750190236019*^9, 
   3.728750300144363*^9, 3.728750520034485*^9, 3.728750579189823*^9, 
   3.7287507238179903`*^9, {3.728750983606666*^9, 3.72875100644411*^9}, 
   3.728751619130589*^9, 3.7288132633851347`*^9, 3.7288273803699703`*^9, 
   3.728843054036162*^9, 3.728845623215534*^9, 3.733367272118264*^9, 
   3.790862656260172*^9, 3.790867110543455*^9, 3.7922732113029346`*^9},
 CellLabel->"During evaluation of In[55]:=",
 CellID->1593342428,ExpressionUUID->"b7e58551-71c7-4f5a-95ec-1dd7aeb8cc65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]], 
             StyleBox["b",
              FontColor->RGBColor[0., 0., 1.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[{-$CellContext`a, -$CellContext`blues}, {-$CellContext`b, \
-$CellContext`blues}],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`blues}, \
{$CellContext`c, $CellContext`fred}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {" ", " "},
             {
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]], 
              StyleBox["b",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[{-$CellContext`c, -$CellContext`fred}, {-$CellContext`b, \
-$CellContext`blues}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" in \"\>", 
   "\[InvisibleSpace]", "0.05134`5.162000857831396", 
   "\[InvisibleSpace]", "\<\" Seconds\"\>"}],
  SequenceForm[
  "Computed ", $CellContext`T[{-$CellContext`a, -$CellContext`blues}, \
{-$CellContext`b, -$CellContext`blues}] -> 
   xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`blues}, \
{$CellContext`c, $CellContext`fred}] $CellContext`T[{-$CellContext`c, \
-$CellContext`fred}, {-$CellContext`b, -$CellContext`blues}], " in ", 
   0.05134`5.162000857831396, " Seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7286459228511667`*^9, 3.728659757075322*^9, 3.728660584151334*^9, 
   3.7286710898935127`*^9, 3.7286748800471563`*^9, 3.728732872855349*^9, 
   3.728733667311123*^9, 3.728742317094062*^9, 3.72874329391508*^9, 
   3.728743392411622*^9, 3.728747215006261*^9, 3.7287494692934647`*^9, 
   3.728749933270899*^9, 3.728750085060267*^9, 3.728750190236019*^9, 
   3.728750300144363*^9, 3.728750520034485*^9, 3.728750579189823*^9, 
   3.7287507238179903`*^9, {3.728750983606666*^9, 3.72875100644411*^9}, 
   3.728751619130589*^9, 3.7288132633851347`*^9, 3.7288273803699703`*^9, 
   3.728843054036162*^9, 3.728845623215534*^9, 3.733367272118264*^9, 
   3.790862656260172*^9, 3.790867110543455*^9, 3.792273211356633*^9},
 CellLabel->"During evaluation of In[55]:=",
 CellID->185109306,ExpressionUUID->"d8326ce1-787c-4f52-ac74-31037b577a5a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`blues}, {0, -$CellContext`blues}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`blues}, {0, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`blues}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`blues}, {1, -$CellContext`blues}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`blues}, {0, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`blues}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`blues}, {1, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`blues}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`blues}, {2, -$CellContext`blues}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`blues}, {0, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`blues}, {0, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`blues}, {1, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`blues}, {2, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {0, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`blues}, {0, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {1, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {2, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]]},
                 {
                  StyleBox["2",
                   FontColor->RGBColor[0., 0., 1.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Basis[{2, -$CellContext`blues}, {0, $CellContext`fred}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`blues}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {1, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`blues}, {1, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {2, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`fred}],
         Editable->False]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`fred}, {0, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`blues}, {0, -$CellContext`fred}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`fred}, {0, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`fred}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`fred}, {0, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`fred}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`fred}, {1, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`blues}, {1, -$CellContext`fred}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`fred}, {1, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`fred}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`fred}, {2, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{2, -$CellContext`blues}, {2, -$CellContext`fred}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`blues}, {0, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`blues}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`blues}, {0, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`blues}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`blues}, {1, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {" ", " "},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`blues}],
        Editable->False]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`blues}, {0, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]]},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[0., 0., 1.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Basis[{0, -$CellContext`blues}, {1, $CellContext`fred}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`blues}, {2, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`blues}, {0, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`blues}, {2, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`blues}, {0, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{0, -$CellContext`blues}, {1, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`blues}, {1, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`blues}, {2, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`blues}, {1, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`blues}, {0, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`blues}, {2, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`blues}, {0, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{1, -$CellContext`blues}, {1, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {1, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {2, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`blues}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]]},
                 {
                  StyleBox["2",
                   FontColor->RGBColor[0., 0., 1.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Basis[{2, -$CellContext`blues}, {0, $CellContext`fred}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {2, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[{2, -$CellContext`blues}, {2, -$CellContext`fred}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {0, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[{2, -$CellContext`blues}, {1, $CellContext`fred}],
         
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`fred}, {2, -$CellContext`fred}],
         Editable->False]}]}]}]}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.7286459230374117`*^9, 3.728659757294372*^9, 3.72866058435069*^9, 
   3.728671090099367*^9, 3.728674880297851*^9, 3.728732873036181*^9, 
   3.728733667516769*^9, 3.728742317317684*^9, 3.728743294132987*^9, 
   3.7287433926221437`*^9, 3.728747215201643*^9, 3.728749469484234*^9, 
   3.7287499334980917`*^9, 3.728750085275119*^9, 3.7287501904443293`*^9, 
   3.728750300799444*^9, 3.728750520212735*^9, 3.7287505795030327`*^9, 
   3.7287507239856157`*^9, {3.728750983805768*^9, 3.7287510066182213`*^9}, 
   3.728751619348427*^9, 3.72881326365734*^9, 3.72882738066547*^9, 
   3.728843054295719*^9, 3.728845623469989*^9, 3.733367272289229*^9, 
   3.790862656431302*^9, 3.790867110708832*^9, 3.792273211539281*^9},
 CellLabel->"Out[55]=",
 CellID->1575785086,ExpressionUUID->"721f3b7c-2116-4398-8363-82c4c54b088e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColumnForm", "/@", 
  RowBox[{"TensorValues", "[", 
   RowBox[{"T", ",", " ", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "blues"}], ",", " ", 
       RowBox[{"-", "blues"}]}], "}"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.728733670591663*^9, 3.7287336726387777`*^9}, {
  3.728747218039291*^9, 3.7287472208292637`*^9}, {3.7287492540175743`*^9, 
  3.728749254682846*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"bdde1cee-8adf-4e1d-aaf1-a71df7604a34"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   InterpretationBox[GridBox[{
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`blues}, {0, -$CellContext`blues}],
         Editable->False], "\[Rule]", "0"}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`blues}, {0, -$CellContext`blues}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[0., 0., 1.]], 
                  StyleBox["1",
                   FontColor->RGBColor[0., 0., 1.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`blues}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`blues}, {1, -$CellContext`blues}],
         Editable->False], "\[Rule]", "0"}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`blues}, {0, -$CellContext`blues}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["0",
                   FontColor->RGBColor[0., 0., 1.]], 
                  StyleBox["2",
                   FontColor->RGBColor[0., 0., 1.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`blues}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`blues}, {1, -$CellContext`blues}],
         Editable->False], "\[Rule]", 
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {" ", " "},
                 {
                  StyleBox["1",
                   FontColor->RGBColor[0., 0., 1.]], 
                  StyleBox["2",
                   FontColor->RGBColor[0., 0., 1.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`blues}],
          Editable->False]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{2, -$CellContext`blues}, {2, -$CellContext`blues}],
         Editable->False], "\[Rule]", "0"}]}
     },
     BaselinePosition->{Baseline, {1, 1}},
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
    ColumnForm[{$CellContext`T[{0, -$CellContext`blues}, {
        0, -$CellContext`blues}] -> 
      0, $CellContext`T[{1, -$CellContext`blues}, {
        0, -$CellContext`blues}] -> -$CellContext`T[{
         0, -$CellContext`blues}, {1, -$CellContext`blues}], $CellContext`T[{
        1, -$CellContext`blues}, {1, -$CellContext`blues}] -> 
      0, $CellContext`T[{2, -$CellContext`blues}, {
        0, -$CellContext`blues}] -> -$CellContext`T[{
         0, -$CellContext`blues}, {2, -$CellContext`blues}], $CellContext`T[{
        2, -$CellContext`blues}, {
        1, -$CellContext`blues}] -> -$CellContext`T[{
         1, -$CellContext`blues}, {2, -$CellContext`blues}], $CellContext`T[{
        2, -$CellContext`blues}, {2, -$CellContext`blues}] -> 0}],
    Editable->False], ",", 
   InterpretationBox[GridBox[{
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`blues}],
         Editable->False], "\[Rule]", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{1, -$CellContext`blues}, {
            0, $CellContext`fred}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`blues}, {0, -$CellContext`fred}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{1, -$CellContext`blues}, {
            1, $CellContext`fred}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`fred}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{1, -$CellContext`blues}, {
            2, $CellContext`fred}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`fred}],
           Editable->False]}]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`blues}],
         Editable->False], "\[Rule]", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`blues}, {
            0, $CellContext`fred}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`blues}, {0, -$CellContext`fred}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`blues}, {
            1, $CellContext`fred}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`blues}, {1, -$CellContext`fred}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`blues}, {
            2, $CellContext`fred}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`blues}, {2, -$CellContext`fred}],
           Editable->False]}]}]}]},
      {
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"T", 
             StyleBox[GridBox[{
                {" ", " "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], 
                 StyleBox["2",
                  FontColor->RGBColor[0., 0., 1.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`blues}],
         Editable->False], "\[Rule]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"e", 
                StyleBox[GridBox[{
                   {" ", 
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            
            xAct`xTensor`Basis[{2, -$CellContext`blues}, {
             0, $CellContext`fred}],
            Editable->False]}], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], 
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{0, -$CellContext`fred}, {1, -$CellContext`blues}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`blues}, {
            1, $CellContext`fred}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{1, -$CellContext`blues}, {1, -$CellContext`fred}],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"e", 
               StyleBox[GridBox[{
                  {" ", 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {
                   StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           
           xAct`xTensor`Basis[{2, -$CellContext`blues}, {
            2, $CellContext`fred}],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"T", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {
                   StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], 
                   StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->9]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`fred}],
           Editable->False]}]}]}]}
     },
     BaselinePosition->{Baseline, {1, 1}},
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
    ColumnForm[{$CellContext`T[{0, -$CellContext`blues}, {
        1, -$CellContext`blues}] -> 
      xAct`xTensor`Basis[{1, -$CellContext`blues}, {
          0, $CellContext`fred}] $CellContext`T[{0, -$CellContext`blues}, {
          0, -$CellContext`fred}] + 
       xAct`xTensor`Basis[{1, -$CellContext`blues}, {
          1, $CellContext`fred}] $CellContext`T[{0, -$CellContext`blues}, {
          1, -$CellContext`fred}] + 
       xAct`xTensor`Basis[{1, -$CellContext`blues}, {
          2, $CellContext`fred}] $CellContext`T[{0, -$CellContext`blues}, {
          2, -$CellContext`fred}], $CellContext`T[{0, -$CellContext`blues}, {
        2, -$CellContext`blues}] -> 
      xAct`xTensor`Basis[{2, -$CellContext`blues}, {
          0, $CellContext`fred}] $CellContext`T[{0, -$CellContext`blues}, {
          0, -$CellContext`fred}] + 
       xAct`xTensor`Basis[{2, -$CellContext`blues}, {
          1, $CellContext`fred}] $CellContext`T[{0, -$CellContext`blues}, {
          1, -$CellContext`fred}] + 
       xAct`xTensor`Basis[{2, -$CellContext`blues}, {
          2, $CellContext`fred}] $CellContext`T[{0, -$CellContext`blues}, {
          2, -$CellContext`fred}], $CellContext`T[{1, -$CellContext`blues}, {
        2, -$CellContext`blues}] -> -
        xAct`xTensor`Basis[{2, -$CellContext`blues}, {
          0, $CellContext`fred}] $CellContext`T[{0, -$CellContext`fred}, {
          1, -$CellContext`blues}] + 
       xAct`xTensor`Basis[{2, -$CellContext`blues}, {
          1, $CellContext`fred}] $CellContext`T[{1, -$CellContext`blues}, {
          1, -$CellContext`fred}] + 
       xAct`xTensor`Basis[{2, -$CellContext`blues}, {
          2, $CellContext`fred}] $CellContext`T[{1, -$CellContext`blues}, {
          2, -$CellContext`fred}]}],
    Editable->False]}], "]"}]], "Output",
 CellChangeTimes->{
  3.728645924666836*^9, 3.728659762206048*^9, 3.7286605853308163`*^9, 
   3.728671091742529*^9, 3.728674880475525*^9, 3.728732874218255*^9, 
   3.728733673300496*^9, 3.728742317480967*^9, 3.7287432943153353`*^9, 
   3.728743392781143*^9, 3.728747221333743*^9, 3.728749471109683*^9, 
   3.728749933735169*^9, 3.728750085508163*^9, 3.728750190671772*^9, 
   3.7287503010340233`*^9, 3.7287505204723167`*^9, 3.728750579702359*^9, 
   3.728750724121296*^9, {3.728750984039693*^9, 3.728751006751008*^9}, 
   3.72875161954198*^9, 3.7288132638334303`*^9, 3.72882738087258*^9, 
   3.728843056056176*^9, 3.7288456236959667`*^9, 3.733367273716549*^9, 
   3.79086265757546*^9, 3.790867112029004*^9, 3.7922732129124537`*^9},
 CellLabel->"Out[56]=",
 CellID->50503431,ExpressionUUID->"1e9cb0c5-48c4-4d68-9765-c1690ca4190e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clean up:", "MathCaption",
 CellChangeTimes->{{3.7286597672185*^9, 3.7286597745066967`*^9}, 
   3.728660495866705*^9},ExpressionUUID->"22be9d13-4b88-494d-afe2-\
0b5ea855fdca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteTensorValues", "[", "T", "]"}]], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"d394f28a-2df6-4f92-80a6-e57a1477b212"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Deleted values for tensor \"\>", "\[InvisibleSpace]", "T", 
   "\[InvisibleSpace]", "\<\", derivatives \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}], "\[InvisibleSpace]", "\<\" and bases \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "blues"}], ",", 
      RowBox[{"-", "blues"}]}], "}"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Deleted values for tensor ", $CellContext`T, ", derivatives ", {}, 
   " and bases ", {{-$CellContext`blues, -$CellContext`blues}}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645926770521*^9, 3.7286597758742113`*^9, 3.728660585525004*^9, 
   3.728671093018279*^9, 3.728674880619116*^9, 3.728732876381125*^9, 
   3.728733676557001*^9, 3.728742317613348*^9, 3.728743294432661*^9, 
   3.728743392914095*^9, 3.728747224415332*^9, 3.7287494726411963`*^9, 
   3.728749933919656*^9, 3.728750085682232*^9, 3.7287501908476467`*^9, 
   3.728750301470889*^9, 3.728750520604165*^9, 3.728750579861247*^9, 
   3.728750724218624*^9, {3.728750984191975*^9, 3.728751006851103*^9}, 
   3.728751619682251*^9, 3.7288132639870253`*^9, 3.728827381030262*^9, 
   3.728843057543241*^9, 3.728845623887203*^9, 3.733367275888467*^9, 
   3.790862658836885*^9, 3.790867113306862*^9, 3.792273214557021*^9},
 CellLabel->"During evaluation of In[57]:=",
 CellID->345137860,ExpressionUUID->"ba0bb955-80e9-47ee-9fec-a0d468038c04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Deleted values for tensor \"\>", "\[InvisibleSpace]", "T", 
   "\[InvisibleSpace]", "\<\", derivatives \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}], "\[InvisibleSpace]", "\<\" and bases \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "blues"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "fred"}], ",", 
       RowBox[{"-", "blues"}]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Deleted values for tensor ", $CellContext`T, ", derivatives ", {}, 
   " and bases ", {{-$CellContext`blues, -$CellContext`fred}, \
{-$CellContext`fred, -$CellContext`blues}}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645926770521*^9, 3.7286597758742113`*^9, 3.728660585525004*^9, 
   3.728671093018279*^9, 3.728674880619116*^9, 3.728732876381125*^9, 
   3.728733676557001*^9, 3.728742317613348*^9, 3.728743294432661*^9, 
   3.728743392914095*^9, 3.728747224415332*^9, 3.7287494726411963`*^9, 
   3.728749933919656*^9, 3.728750085682232*^9, 3.7287501908476467`*^9, 
   3.728750301470889*^9, 3.728750520604165*^9, 3.728750579861247*^9, 
   3.728750724218624*^9, {3.728750984191975*^9, 3.728751006851103*^9}, 
   3.728751619682251*^9, 3.7288132639870253`*^9, 3.728827381030262*^9, 
   3.728843057543241*^9, 3.728845623887203*^9, 3.733367275888467*^9, 
   3.790862658836885*^9, 3.790867113306862*^9, 3.7922732145682983`*^9},
 CellLabel->"During evaluation of In[57]:=",
 CellID->378682473,ExpressionUUID->"e59a450a-0dc6-4238-806d-87eb4d5235d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Deleted values for tensor \"\>", "\[InvisibleSpace]", "T", 
   "\[InvisibleSpace]", "\<\", derivatives \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}], "\[InvisibleSpace]", "\<\" and bases \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "fred"}], ",", 
      RowBox[{"-", "fred"}]}], "}"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Deleted values for tensor ", $CellContext`T, ", derivatives ", {}, 
   " and bases ", {{-$CellContext`fred, -$CellContext`fred}}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645926770521*^9, 3.7286597758742113`*^9, 3.728660585525004*^9, 
   3.728671093018279*^9, 3.728674880619116*^9, 3.728732876381125*^9, 
   3.728733676557001*^9, 3.728742317613348*^9, 3.728743294432661*^9, 
   3.728743392914095*^9, 3.728747224415332*^9, 3.7287494726411963`*^9, 
   3.728749933919656*^9, 3.728750085682232*^9, 3.7287501908476467`*^9, 
   3.728750301470889*^9, 3.728750520604165*^9, 3.728750579861247*^9, 
   3.728750724218624*^9, {3.728750984191975*^9, 3.728751006851103*^9}, 
   3.728751619682251*^9, 3.7288132639870253`*^9, 3.728827381030262*^9, 
   3.728843057543241*^9, 3.728845623887203*^9, 3.733367275888467*^9, 
   3.790862658836885*^9, 3.790867113306862*^9, 3.7922732145789757`*^9},
 CellLabel->"During evaluation of In[57]:=",
 CellID->1522277650,ExpressionUUID->"387379d4-cd80-41ec-b4f1-67f669fa4421"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CVVerbose", "=", "True"}], ";"}]], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"12dc5e47-bb9e-4b22-82f4-8c45d98d3b38"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefBasis", "/@", 
   RowBox[{"{", 
    RowBox[{"fred", ",", "blues"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7287336824000797`*^9, 3.7287336849020233`*^9}, {
   3.728747233092782*^9, 3.728747236764454*^9}, 3.7287492602227173`*^9},
 CellLabel->"In[59]:=",ExpressionUUID->"68321ca2-7f23-414c-afb7-abf188a74b94"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDfred"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDfred],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.792273216824662*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->668658622,ExpressionUUID->"20f30a94-0934-46fd-8929-a5a2e99cdfb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDfred"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDfred],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.792273216837693*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->363535203,ExpressionUUID->"248387c7-e78f-4d05-a0b9-51691f210971"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDfred"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDfred],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.7922732168517437`*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->345181106,ExpressionUUID->"3a692f01-3260-412e-b8d1-c7b37b3a5ece"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDfred"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDfred],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.792273216858735*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->1105517995,ExpressionUUID->"beaafcbc-10ea-4767-8fbe-18c113cf1607"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDfred"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDfred],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.7922732168661823`*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->412428121,ExpressionUUID->"4e9ac448-47ff-41ae-bfcf-fe983ff89c68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUpfred"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUpfred],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.7922732168735523`*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->1749700778,ExpressionUUID->"02f628a7-617b-437f-b33a-242efa0f90ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDownfred"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDownfred],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.792273216880509*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->1727397475,ExpressionUUID->"2fcee940-f0a3-41db-9456-a0d0f7637d7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "fred"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`fred],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.7922732168875303`*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->537938532,ExpressionUUID->"e1a9d93f-cb91-4b8d-b880-c6072502cebf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDblues"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDblues],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.7922732168945007`*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->226753454,ExpressionUUID->"c4c06884-8f62-47df-be2f-38528d36d8a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDblues"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDblues],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.792273216901402*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->1409311600,ExpressionUUID->"06cf6d5b-0259-4d12-b4c3-f9e9f5001c9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDblues"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDblues],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.792273216908408*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->1702918437,ExpressionUUID->"6d55ee9c-dee6-4f87-9475-0d996d30c3bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDblues"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDblues],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.792273216915245*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->1435607090,ExpressionUUID->"3aa4c10f-7e90-48df-88dd-8b44919948ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDblues"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDblues],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.7922732169222193`*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->1269587585,ExpressionUUID->"a91eee8c-adc2-438b-aeea-29b261414380"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUpblues"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUpblues],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.7922732169293528`*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->561024503,ExpressionUUID->"1edd1ea1-3722-4b18-b71c-67793ef58a57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDownblues"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDownblues],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.792273216936311*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->1685611591,ExpressionUUID->"01f1e567-7657-4842-84b1-3c72151fde10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "blues"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`blues],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645939324555*^9, 3.728660585841178*^9, 3.728671095157638*^9, 
   3.728674880967157*^9, 3.728732879161681*^9, 3.728733686924255*^9, 
   3.728742318008175*^9, 3.7287432947505503`*^9, 3.728743393197723*^9, 
   3.728747237262712*^9, 3.7287494745303164`*^9, 3.7287499348201714`*^9, 
   3.728750085987439*^9, 3.7287501915322237`*^9, 3.7287503020600357`*^9, 
   3.728750520800502*^9, 3.728750580123959*^9, 3.72875072434544*^9, {
   3.7287509844380207`*^9, 3.728751006976675*^9}, 3.728751619944504*^9, 
   3.728813264274679*^9, 3.728827381326201*^9, 3.7288430592053967`*^9, 
   3.728845624172392*^9, 3.733367277519153*^9, 3.790862660646812*^9, 
   3.790867115247067*^9, 3.7922732169431887`*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->469738713,ExpressionUUID->"c9d2e7e6-026e-4677-970f-b7095935672b"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Removing a complex basis also removes its complex conjugate:", \
"MathCaption",ExpressionUUID->"4fbaadb2-6371-4cd5-811a-1b7897c8e955"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefBasis", "[", "fcomp", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.728733690697093*^9, 3.728733690837076*^9}, {
  3.7287472403500013`*^9, 3.728747241651298*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"a590ad3f-c9d9-49c4-bf1d-7488a8bfff9d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "AChristoffelPDfcomp\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", 
   " ", $CellContext`AChristoffelPDfcomp\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.7922732182599154`*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->908849206,ExpressionUUID->"58c7e838-4903-439e-9fb2-a114e17da76c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "AChristoffelPDfcomp"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", " ", $CellContext`AChristoffelPDfcomp],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218270548*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->2124907778,ExpressionUUID->"75e6d2cd-bc1d-4eb4-819c-bfabfc64903d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDfcomp"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDfcomp],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218285263*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->671975236,ExpressionUUID->"fd077c86-fbf7-4501-adfc-a0a64b2aeb62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "FRiemannPDfcomp\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemannPDfcomp\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218292466*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->271291879,ExpressionUUID->"9a71faa4-0069-4eca-ac0a-35762dfdbd84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "FRiemannPDfcomp"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemannPDfcomp],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218299695*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->494827772,ExpressionUUID->"280b1ad0-faba-4ec0-9170-733c59f08bde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDfcomp"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDfcomp],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.7922732183073063`*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->1513682820,ExpressionUUID->"7916fa80-7af1-46ba-a398-be16b67faa9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDfcomp"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDfcomp],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218314466*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->1375873378,ExpressionUUID->"ac404752-7bb4-45f2-bd4f-e13dce0e2894"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDfcomp"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDfcomp],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.7922732183215723`*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->199953150,ExpressionUUID->"08e5e904-64cf-4446-8929-9d98c375bfe9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDfcomp"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDfcomp],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218328581*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->1948168142,ExpressionUUID->"135da206-eff4-4f71-9c57-c702f6732246"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "fcomp\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`fcomp\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218335402*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->178796785,ExpressionUUID->"a335989a-acd0-4c4e-a100-aa9806c2f73b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "etaUpfcomp\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUpfcomp\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.79227321834212*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->707943342,ExpressionUUID->"aed33cd4-05ac-4471-965f-d8ba2f029330"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUpfcomp"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUpfcomp],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218349063*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->1344344614,ExpressionUUID->"a9132ed3-6fb9-47c3-932e-719611ee79da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "etaDownfcomp\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDownfcomp\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218355761*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->724477411,ExpressionUUID->"7acfa328-d399-4e22-b87f-326da21303c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDownfcomp"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDownfcomp],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.7922732183625937`*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->59568187,ExpressionUUID->"d781ce1f-bf37-42fc-9cae-fb17be06238d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "fcomp"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`fcomp],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728645940536729*^9, 3.728660586170697*^9, 3.7286710969258337`*^9, 
   3.728674881732094*^9, 3.728732882198947*^9, 3.72873369130713*^9, 
   3.728742318595891*^9, 3.728743295627975*^9, 3.72874339368121*^9, 
   3.728747243015862*^9, 3.72874947617679*^9, 3.7287499351204863`*^9, 
   3.728750086642294*^9, 3.728750192197423*^9, 3.7287503026850367`*^9, 
   3.7287505211625357`*^9, 3.728750580457086*^9, 3.728750724629656*^9, {
   3.728750984756345*^9, 3.728751007258465*^9}, 3.7287516202781153`*^9, 
   3.728813264727947*^9, 3.728827381808064*^9, 3.728843061102787*^9, 
   3.728845624726934*^9, 3.733367279436389*^9, 3.7908626620637217`*^9, 
   3.790867116622571*^9, 3.792273218369534*^9},
 CellLabel->"During evaluation of In[60]:=",
 CellID->435139407,ExpressionUUID->"f3fb8537-e3a5-4b4e-bb32-66165ebb774d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefTensor", "/@", 
   RowBox[{"{", 
    RowBox[{"R", ",", "T", ",", "u", ",", "v"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.728750107915875*^9, 3.728750156061103*^9}},
 CellLabel->"In[61]:=",
 CellID->891057657,ExpressionUUID->"624217e7-ddf7-407e-b693-f792e56ca870"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "R\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`R\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750122635363*^9, 3.728750156557139*^9, 3.7287501925812273`*^9, 
   3.728750303300208*^9, 3.728750521528466*^9, 3.7287505807593527`*^9, 
   3.728750724928062*^9, {3.728750985058617*^9, 3.7287510075418243`*^9}, 
   3.728751620777418*^9, 3.728813265182197*^9, 3.728827382390902*^9, 
   3.7288430631029367`*^9, 3.728845625160882*^9, 3.733367281102833*^9, 
   3.790862663395739*^9, 3.790867117657794*^9, 3.792273219749674*^9},
 CellLabel->"During evaluation of In[61]:=",
 CellID->457359816,ExpressionUUID->"72b19dfe-b5bc-4474-a567-bcf8a3ea3795"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "R"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`R],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750122635363*^9, 3.728750156557139*^9, 3.7287501925812273`*^9, 
   3.728750303300208*^9, 3.728750521528466*^9, 3.7287505807593527`*^9, 
   3.728750724928062*^9, {3.728750985058617*^9, 3.7287510075418243`*^9}, 
   3.728751620777418*^9, 3.728813265182197*^9, 3.728827382390902*^9, 
   3.7288430631029367`*^9, 3.728845625160882*^9, 3.733367281102833*^9, 
   3.790862663395739*^9, 3.790867117657794*^9, 3.79227321976206*^9},
 CellLabel->"During evaluation of In[61]:=",
 CellID->1002454899,ExpressionUUID->"d70573e5-0ebd-41ec-98be-4d74fa53556a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750122635363*^9, 3.728750156557139*^9, 3.7287501925812273`*^9, 
   3.728750303300208*^9, 3.728750521528466*^9, 3.7287505807593527`*^9, 
   3.728750724928062*^9, {3.728750985058617*^9, 3.7287510075418243`*^9}, 
   3.728751620777418*^9, 3.728813265182197*^9, 3.728827382390902*^9, 
   3.7288430631029367`*^9, 3.728845625160882*^9, 3.733367281102833*^9, 
   3.790862663395739*^9, 3.790867117657794*^9, 3.792273219776425*^9},
 CellLabel->"During evaluation of In[61]:=",
 CellID->1250276778,ExpressionUUID->"95773e13-5f2d-4533-80ed-72963d3056a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "u\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`u\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750122635363*^9, 3.728750156557139*^9, 3.7287501925812273`*^9, 
   3.728750303300208*^9, 3.728750521528466*^9, 3.7287505807593527`*^9, 
   3.728750724928062*^9, {3.728750985058617*^9, 3.7287510075418243`*^9}, 
   3.728751620777418*^9, 3.728813265182197*^9, 3.728827382390902*^9, 
   3.7288430631029367`*^9, 3.728845625160882*^9, 3.733367281102833*^9, 
   3.790862663395739*^9, 3.790867117657794*^9, 3.792273219783746*^9},
 CellLabel->"During evaluation of In[61]:=",
 CellID->274321951,ExpressionUUID->"4a7d9b88-d68a-477f-9e07-98b40b2f9e9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "u"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`u],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750122635363*^9, 3.728750156557139*^9, 3.7287501925812273`*^9, 
   3.728750303300208*^9, 3.728750521528466*^9, 3.7287505807593527`*^9, 
   3.728750724928062*^9, {3.728750985058617*^9, 3.7287510075418243`*^9}, 
   3.728751620777418*^9, 3.728813265182197*^9, 3.728827382390902*^9, 
   3.7288430631029367`*^9, 3.728845625160882*^9, 3.733367281102833*^9, 
   3.790862663395739*^9, 3.790867117657794*^9, 3.792273219791134*^9},
 CellLabel->"During evaluation of In[61]:=",
 CellID->2029123995,ExpressionUUID->"61b7f67c-4cc6-4d40-93cb-0ad1c804ea4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "v"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`v],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750122635363*^9, 3.728750156557139*^9, 3.7287501925812273`*^9, 
   3.728750303300208*^9, 3.728750521528466*^9, 3.7287505807593527`*^9, 
   3.728750724928062*^9, {3.728750985058617*^9, 3.7287510075418243`*^9}, 
   3.728751620777418*^9, 3.728813265182197*^9, 3.728827382390902*^9, 
   3.7288430631029367`*^9, 3.728845625160882*^9, 3.733367281102833*^9, 
   3.790862663395739*^9, 3.790867117657794*^9, 3.792273219798318*^9},
 CellLabel->"During evaluation of In[61]:=",
 CellID->1446669605,ExpressionUUID->"cb85afb9-2b5e-489e-bd3c-73d1ef5cc3ce"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefVBundle", "[", "InnerC", "]"}]], "Input",
 CellChangeTimes->{{3.7287500333255167`*^9, 3.728750042034931*^9}},
 CellLabel->"In[62]:=",
 CellID->1401790690,ExpressionUUID->"caf0ef7e-cbbb-4142-809d-3a6f314d6837"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["InnerC\[Dagger]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC\[Dagger],
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "conjugated vbundle", 
   " ", $CellContext`InnerC\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750133502331*^9, 3.728750193124095*^9, 3.728750303771426*^9, 
   3.728750521805451*^9, 3.728750581037147*^9, 3.728750725163906*^9, {
   3.728750985386902*^9, 3.728751007790182*^9}, 3.728751621094442*^9, 
   3.728813265533646*^9, 3.728827382736196*^9, 3.728843064817408*^9, 
   3.728845625474742*^9, 3.733367282462525*^9, 3.790862665019261*^9, 
   3.7908671187294807`*^9, 3.792273221245615*^9},
 CellLabel->"During evaluation of In[62]:=",
 CellID->1941333954,ExpressionUUID->"6dfdefbf-aa77-42dd-a57a-1ab493d7024b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["InnerC",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`InnerC],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750133502331*^9, 3.728750193124095*^9, 3.728750303771426*^9, 
   3.728750521805451*^9, 3.728750581037147*^9, 3.728750725163906*^9, {
   3.728750985386902*^9, 3.728751007790182*^9}, 3.728751621094442*^9, 
   3.728813265533646*^9, 3.728827382736196*^9, 3.728843064817408*^9, 
   3.728845625474742*^9, 3.733367282462525*^9, 3.790862665019261*^9, 
   3.7908671187294807`*^9, 3.7922732213076887`*^9},
 CellLabel->"During evaluation of In[62]:=",
 CellID->1280716007,ExpressionUUID->"59a72445-1349-44df-a013-dcd667e416a6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "M3", "]"}]], "Input",
 CellChangeTimes->{{3.728750135437042*^9, 3.728750140151712*^9}},
 CellLabel->"In[63]:=",
 CellID->1216022970,ExpressionUUID->"014fba38-4fd9-4108-a282-a171ba8b66e5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M3",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM3,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750162341569*^9, 3.728750193468371*^9, 3.728750304321321*^9, 
   3.72875052217933*^9, 3.7287505813532248`*^9, 3.728750725472004*^9, {
   3.7287509857227087`*^9, 3.728751008074291*^9}, 3.728751621364987*^9, 
   3.728813265886754*^9, 3.728827383053286*^9, 3.7288430655928698`*^9, 
   3.7288456257819366`*^9, 3.73336728327675*^9, 3.7908626659023037`*^9, 
   3.79086711933471*^9, 3.792273222028212*^9},
 CellLabel->"During evaluation of In[63]:=",
 CellID->2059295894,ExpressionUUID->"8dc4848f-120b-4c67-8a45-21cc4bda9bed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M3"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728750162341569*^9, 3.728750193468371*^9, 3.728750304321321*^9, 
   3.72875052217933*^9, 3.7287505813532248`*^9, 3.728750725472004*^9, {
   3.7287509857227087`*^9, 3.728751008074291*^9}, 3.728751621364987*^9, 
   3.728813265886754*^9, 3.728827383053286*^9, 3.7288430655928698`*^9, 
   3.7288456257819366`*^9, 3.73336728327675*^9, 3.7908626659023037`*^9, 
   3.79086711933471*^9, 3.792273222038924*^9},
 CellLabel->"During evaluation of In[63]:=",
 CellID->1739635406,ExpressionUUID->"b86d2204-c8b1-4aab-a275-3b6bc4ddf341"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "basis", ",", "cobasis", ",", "expr", ",", "cexpr", ",", "values", ",", "i",
    ",", "j", ",", "w"}], "]"}]], "Input",
 CellChangeTimes->{{3.7287502118481293`*^9, 3.72875021828246*^9}, {
  3.7287502530488234`*^9, 3.728750256974098*^9}},
 CellLabel->"In[64]:=",
 CellID->94413090,ExpressionUUID->"5241413d-cefc-4d83-9d9f-25c95dd98a30"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Algebra and bases", "Section",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.7286627354220657`*^9, 3.728662748172317*^9}, {
  3.728664037492599*^9, 3.72866403885896*^9}, {3.7286704747855062`*^9, 
  3.728670480415387*^9}, {3.728670889883876*^9, 3.728670893540101*^9}, {
  3.728673410238123*^9, 3.728673425886174*^9}},
 FontSize->18,
 FontColor->GrayLevel[0],
 CellTags->{"S5.18.1", "1.4"},
 CellID->853073756,ExpressionUUID->"9f2804d8-0164-470b-a13e-c7b68c3d7339"],

Cell[CellGroupData[{

Cell["1.1. Bases", "Subsection",
 CellChangeTimes->{{3.7286627354220657`*^9, 3.728662748172317*^9}, {
  3.728673412590672*^9, 3.728673427462188*^9}},
 CellTags->{
  "S5.18.1", "1.4"},ExpressionUUID->"86385e57-5f81-479d-b8c0-73ad6467ad57"],

Cell[CellGroupData[{

Cell["1.1.1. DefBasis", "Subsubsection",
 CellChangeTimes->{{3.728673437021533*^9, 
  3.72867343714992*^9}},ExpressionUUID->"a8c121ed-a412-44f3-a13a-\
a9fd7d2138af"],

Cell["\<\
This section will explain how to define and work with new bases, without \
assuming that they have an underlying coordinate chart. We will focus on the \
algebraic manipulations, ignoring the fact that our basic objects are \
actually fields, except for a few examples involving differentiation. Later \
on in this notebook, we will show how to work with charts, and how to perform \
derivatives of several kinds.\
\>", "Text",
 CellChangeTimes->{{3.728671118769095*^9, 3.728671210301458*^9}},
 CellTags->{
  "S5.18.1", "1.5"},ExpressionUUID->"6ea21273-ba95-4a75-a84b-683255bd3833"],

Cell[TextData[{
 StyleBox["DefBasis\t\t\t", "DisplayMath"],
 StyleBox["Define a basis", "Text"],
 StyleBox["\nVBundleOfBasis\t\t", "DisplayMath"],
 StyleBox["Vector bundle on which a basis lives\n", "Text"],
 StyleBox["PDOfBasis\t\t\t", "DisplayMath"],
 StyleBox["Parallel derivative associated to a given basis\n", "Text"],
 StyleBox["$Bases\t\t\t\t", "DisplayMath"],
 StyleBox["List of currently defined bases\n", "Text"],
 StyleBox["BasisQ\t\t\t\t", "DisplayMath"],
 StyleBox["Check existence of a given basis name", "Text"]
}], "DefinitionBox",
 CellChangeTimes->{{3.7287423824023037`*^9, 
  3.728742388520258*^9}},ExpressionUUID->"a204ebe7-8a70-466f-b93e-\
31f2286ed32e"],

Cell["Definition of a basis.", "Text",ExpressionUUID->"061818b3-e6ff-40f8-b9bb-0589f86c83f6"],

Cell[CellGroupData[{

Cell["Declare a manifold and some tensors:", "MathCaption",
 CellChangeTimes->{{3.728750346653975*^9, 3.728750350652412*^9}, {
  3.7287505907691298`*^9, 3.728750594465168*^9}},
 CellID->1431971475,ExpressionUUID->"f33a8b9b-febb-4147-996a-db46f665cd76"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M3", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.728750351919133*^9, 3.728750377187203*^9}},
 CellLabel->"In[65]:=",
 CellID->571909325,ExpressionUUID->"ba46731a-9074-4342-a71d-f8619fbc0b8d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7287503777488403`*^9, 3.728750522525712*^9, 
  3.728750585714631*^9, 3.728750759631687*^9, 3.7287510437107277`*^9, 
  3.728751621587109*^9, 3.7287593548827887`*^9, 3.7288132661487617`*^9, 
  3.72882738334347*^9, 3.728835974288519*^9, 3.728836291877338*^9, 
  3.728843080377976*^9, 3.728845626062332*^9, 3.7333672998433867`*^9, 
  3.792273239925037*^9},
 CellLabel->"During evaluation of In[65]:=",
 CellID->60992304,ExpressionUUID->"5d07142e-6384-4562-9e1e-d025fad18b87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7287503777488403`*^9, 3.728750522525712*^9, 
  3.728750585714631*^9, 3.728750759631687*^9, 3.7287510437107277`*^9, 
  3.728751621587109*^9, 3.7287593548827887`*^9, 3.7288132661487617`*^9, 
  3.72882738334347*^9, 3.728835974288519*^9, 3.728836291877338*^9, 
  3.728843080377976*^9, 3.728845626062332*^9, 3.7333672998433867`*^9, 
  3.792273239933625*^9},
 CellLabel->"During evaluation of In[65]:=",
 CellID->747953709,ExpressionUUID->"0f02e7b7-61d9-469b-bf54-2a3dd697325e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M3"}], "]"}]], "Input",
 CellChangeTimes->{{3.7287505537674723`*^9, 3.728750557011115*^9}},
 CellLabel->"In[66]:=",
 CellID->96268193,ExpressionUUID->"10df15cf-8da1-4d20-86a2-afc8aa52cda7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{{3.728750557520774*^9, 3.7287505863204317`*^9}, 
   3.728750759799919*^9, 3.72875104391705*^9, 3.728751621764145*^9, 
   3.728759355134914*^9, 3.7288132663200197`*^9, 3.728827383549553*^9, 
   3.728835974593898*^9, 3.728836292103294*^9, 3.728843080618816*^9, 
   3.72884562626477*^9, 3.733367300910368*^9, 3.79227324080305*^9},
 CellLabel->"During evaluation of In[66]:=",
 CellID->550003913,ExpressionUUID->"7d02a7aa-abf8-489c-a5aa-ab4bb15a0e9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.72875044344412*^9, 3.728750485742198*^9}},
 CellLabel->"In[67]:=",
 CellID->1818717525,ExpressionUUID->"cea71f12-8a6f-4852-9035-62fd44fd7cd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7287504952935467`*^9, 3.728750525108186*^9}, 
   3.728750586936494*^9, 3.728750759940381*^9, 3.728751044057124*^9, 
   3.7287516218973217`*^9, 3.728759355283832*^9, 3.728813266481922*^9, 
   3.728827383715893*^9, 3.728835974767*^9, 3.728836292248*^9, 
   3.728843080784718*^9, 3.7288456264292393`*^9, 3.733367301626313*^9, 
   3.792273241401979*^9},
 CellLabel->"During evaluation of In[67]:=",
 CellID->633278035,ExpressionUUID->"bb212a4a-ecac-4a84-9bd7-94724e98603a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Declare a complex vector bundle and a vector field on it:", \
"MathCaption",
 CellChangeTimes->{{3.7287509198272753`*^9, 3.728750936353177*^9}},
 CellID->1079830948,ExpressionUUID->"a4b54d25-5faf-45cd-a737-f5b18e4b5737"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefVBundle", "[", 
  RowBox[{"InnerC", ",", "M3", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "G"}], "}"}], 
   ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->"In[68]:=",
 CellID->1538122804,ExpressionUUID->"9fd9142d-7e83-4041-9d92-9bddd7058dc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "InnerC", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`InnerC, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728732789216392*^9, 3.728733007375355*^9, 
  3.728733189752511*^9, 3.7287333656471233`*^9, 3.728742302205514*^9, 
  3.7287432820370502`*^9, 3.728743381304302*^9, 3.728746914762179*^9, 
  3.7287494080059566`*^9, 3.7287499237170897`*^9, 3.7287500737875147`*^9, 
  3.728750174415072*^9, 3.728750282026334*^9, 3.728750507387027*^9, 
  3.72875057027335*^9, 3.728750698097638*^9, 3.7287507601412487`*^9, 
  3.7287510441944437`*^9, 3.728751622111302*^9, 3.728759355443617*^9, 
  3.728813266634886*^9, 3.728827383881782*^9, 3.728835974965375*^9, 
  3.728836292392392*^9, 3.7288430809653788`*^9, 3.7288456265978403`*^9, 
  3.733367302792327*^9, 3.792273242325447*^9},
 CellLabel->"During evaluation of In[68]:=",
 CellID->151982334,ExpressionUUID->"7bf9964c-4d03-4b5e-9c1c-06b204350078"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"C\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 68, 4, 19668387891272167742, "Local", 
   "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728645867902925*^9, 3.728655158876857*^9, 
  3.728655384910871*^9, 3.728660570057692*^9, 3.7286710165454817`*^9, 
  3.728674863441874*^9, 3.728732667790407*^9, 3.7287327892828617`*^9, 
  3.728733007445066*^9, 3.72873318985763*^9, 3.728733365719778*^9, 
  3.728742302337237*^9, 3.728743282128933*^9, 3.728743381368064*^9, 
  3.728746914857394*^9, 3.728749408072154*^9, 3.728749923760768*^9, 
  3.728750073879168*^9, 3.7287501744942293`*^9, 3.728750282076119*^9, 
  3.7287505074364223`*^9, 3.7287505703431187`*^9, 3.7287506981274548`*^9, 
  3.728750760171526*^9, 3.7287510442101183`*^9, 3.728751622127942*^9, 
  3.7287593555714617`*^9, 3.728813266651669*^9, 3.728827383900041*^9, 
  3.728835975125285*^9, 3.7288362924418583`*^9, 3.728843081002459*^9, 
  3.728845626617558*^9, 3.73336730281894*^9, 3.79227324233578*^9},
 CellLabel->"During evaluation of In[68]:=",
 CellID->1009031255,ExpressionUUID->"323404f2-2d8c-420a-837f-915d9896e2cd"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"D\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 68, 5, 19668387891272167742, "Local", 
   "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728645867902925*^9, 3.728655158876857*^9, 
  3.728655384910871*^9, 3.728660570057692*^9, 3.7286710165454817`*^9, 
  3.728674863441874*^9, 3.728732667790407*^9, 3.7287327892828617`*^9, 
  3.728733007445066*^9, 3.72873318985763*^9, 3.728733365719778*^9, 
  3.728742302337237*^9, 3.728743282128933*^9, 3.728743381368064*^9, 
  3.728746914857394*^9, 3.728749408072154*^9, 3.728749923760768*^9, 
  3.728750073879168*^9, 3.7287501744942293`*^9, 3.728750282076119*^9, 
  3.7287505074364223`*^9, 3.7287505703431187`*^9, 3.7287506981274548`*^9, 
  3.728750760171526*^9, 3.7287510442101183`*^9, 3.728751622127942*^9, 
  3.7287593555714617`*^9, 3.728813266651669*^9, 3.728827383900041*^9, 
  3.728835975125285*^9, 3.7288362924418583`*^9, 3.728843081002459*^9, 
  3.728845626617558*^9, 3.73336730281894*^9, 3.792273242346336*^9},
 CellLabel->"During evaluation of In[68]:=",
 CellID->109942426,ExpressionUUID->"dd418d3b-7032-4c51-bb3d-679661bd6bc2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "InnerC\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between InnerC \
and InnerC\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`InnerC\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between InnerC and InnerC\[Dagger]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.728732789216392*^9, 3.728733007375355*^9, 
  3.728733189752511*^9, 3.7287333656471233`*^9, 3.728742302205514*^9, 
  3.7287432820370502`*^9, 3.728743381304302*^9, 3.728746914762179*^9, 
  3.7287494080059566`*^9, 3.7287499237170897`*^9, 3.7287500737875147`*^9, 
  3.728750174415072*^9, 3.728750282026334*^9, 3.728750507387027*^9, 
  3.72875057027335*^9, 3.728750698097638*^9, 3.7287507601412487`*^9, 
  3.7287510441944437`*^9, 3.728751622111302*^9, 3.728759355443617*^9, 
  3.728813266634886*^9, 3.728827383881782*^9, 3.728835974965375*^9, 
  3.728836292392392*^9, 3.7288430809653788`*^9, 3.7288456265978403`*^9, 
  3.733367302792327*^9, 3.792273242357745*^9},
 CellLabel->"During evaluation of In[68]:=",
 CellID->966417362,ExpressionUUID->"f4166d09-5e98-4f98-b63a-fa5b279c6a5a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"-", "A"}], "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->"In[69]:=",
 CellID->593059525,ExpressionUUID->"41fee987-76df-4dd9-899d-b2e054ca23ea"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"u", "[", 
    RowBox[{"-", "A"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`u[-$CellContext`A], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7287510446740217`*^9, 3.72875162231525*^9, 
  3.728759355794941*^9, 3.7288132668477507`*^9, 3.72882738412694*^9, 
  3.728835975419291*^9, 3.7288362926715097`*^9, 3.728843081383877*^9, 
  3.728845626833881*^9, 3.733367303759838*^9, 3.792273242939406*^9},
 CellLabel->"During evaluation of In[69]:=",
 CellID->300424984,ExpressionUUID->"c67147a3-a54d-464a-a700-9bb268ac1e6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"u\[Dagger]", "[", 
    RowBox[{"-", "A\[Dagger]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`u\[Dagger][-$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7287510446740217`*^9, 3.72875162231525*^9, 
  3.728759355794941*^9, 3.7288132668477507`*^9, 3.72882738412694*^9, 
  3.728835975419291*^9, 3.7288362926715097`*^9, 3.728843081383877*^9, 
  3.728845626833881*^9, 3.733367303759838*^9, 3.792273242950436*^9},
 CellLabel->"During evaluation of In[69]:=",
 CellID->508651991,ExpressionUUID->"4551fc82-a1c5-4198-9f78-b4c56e9941f5"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
To define a basis we only have to provide a name, a vector bundle and a list \
of cnumbers (\"component numbers\"), whose length must be the dimension of \
the vector bundle. The cnumbers can include 0 and even negative integers:\
\>", "MathCaption",
 CellChangeTimes->{{3.7286611194299307`*^9, 3.728661143387035*^9}, {
  3.72874241716654*^9, 3.728742418102738*^9}},
 CellTags->{
  "S5.18.1", "1.6"},ExpressionUUID->"1b913b5b-14e7-4071-af65-bf81fe188bf6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"fred", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728742430302266*^9, 3.7287424306157227`*^9}, {
  3.7287472611266336`*^9, 3.728747261659307*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"c2ec987c-3aab-44cd-bc09-7bfa61defc86"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "fred", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`fred, 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286611082289352`*^9, 3.728671231038711*^9, 
  3.7286748823136253`*^9, 3.7287424393287687`*^9, 3.72874329617754*^9, 
  3.728743394128528*^9, 3.728747262265957*^9, 3.7287494852097387`*^9, 
  3.728749935431992*^9, 3.7287503828126183`*^9, 3.728750527946123*^9, 
  3.7287505881209917`*^9, 3.7287507606555843`*^9, 3.7287510451404133`*^9, 
  3.7287516224984713`*^9, 3.728759356113003*^9, 3.7288132670155363`*^9, 
  3.728827384314583*^9, 3.7288359757332907`*^9, 3.728836292865864*^9, 
  3.7288430821123743`*^9, 3.728845627120904*^9, 3.733367305188802*^9, 
  3.7922732441733303`*^9},
 CellLabel->"During evaluation of In[70]:=",
 CellID->575210575,ExpressionUUID->"a8d5bf5e-654f-497c-9a04-76d29474aa88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDfred", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDfred[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286611082289352`*^9, 3.728671231038711*^9, 
  3.7286748823136253`*^9, 3.7287424393287687`*^9, 3.72874329617754*^9, 
  3.728743394128528*^9, 3.728747262265957*^9, 3.7287494852097387`*^9, 
  3.728749935431992*^9, 3.7287503828126183`*^9, 3.728750527946123*^9, 
  3.7287505881209917`*^9, 3.7287507606555843`*^9, 3.7287510451404133`*^9, 
  3.7287516224984713`*^9, 3.728759356113003*^9, 3.7288132670155363`*^9, 
  3.728827384314583*^9, 3.7288359757332907`*^9, 3.728836292865864*^9, 
  3.7288430821123743`*^9, 3.728845627120904*^9, 3.733367305188802*^9, 
  3.7922732441865*^9},
 CellLabel->"During evaluation of In[70]:=",
 CellID->1740238878,ExpressionUUID->"eb85d954-50b7-4900-b351-f4d20e285f43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDfred", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDfred[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286611082289352`*^9, 3.728671231038711*^9, 
  3.7286748823136253`*^9, 3.7287424393287687`*^9, 3.72874329617754*^9, 
  3.728743394128528*^9, 3.728747262265957*^9, 3.7287494852097387`*^9, 
  3.728749935431992*^9, 3.7287503828126183`*^9, 3.728750527946123*^9, 
  3.7287505881209917`*^9, 3.7287507606555843`*^9, 3.7287510451404133`*^9, 
  3.7287516224984713`*^9, 3.728759356113003*^9, 3.7288132670155363`*^9, 
  3.728827384314583*^9, 3.7288359757332907`*^9, 3.728836292865864*^9, 
  3.7288430821123743`*^9, 3.728845627120904*^9, 3.733367305188802*^9, 
  3.792273244200592*^9},
 CellLabel->"During evaluation of In[70]:=",
 CellID->1615034053,ExpressionUUID->"03a370a9-fb76-4e76-b865-9ea0dbdb6c32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDfred", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDfred[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286611082289352`*^9, 3.728671231038711*^9, 
  3.7286748823136253`*^9, 3.7287424393287687`*^9, 3.72874329617754*^9, 
  3.728743394128528*^9, 3.728747262265957*^9, 3.7287494852097387`*^9, 
  3.728749935431992*^9, 3.7287503828126183`*^9, 3.728750527946123*^9, 
  3.7287505881209917`*^9, 3.7287507606555843`*^9, 3.7287510451404133`*^9, 
  3.7287516224984713`*^9, 3.728759356113003*^9, 3.7288132670155363`*^9, 
  3.728827384314583*^9, 3.7288359757332907`*^9, 3.728836292865864*^9, 
  3.7288430821123743`*^9, 3.728845627120904*^9, 3.733367305188802*^9, 
  3.792273244207863*^9},
 CellLabel->"During evaluation of In[70]:=",
 CellID->1831514338,ExpressionUUID->"adccf27a-8b56-42cb-8fee-198c0d5b1f37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDfred", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDfred[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286611082289352`*^9, 3.728671231038711*^9, 
  3.7286748823136253`*^9, 3.7287424393287687`*^9, 3.72874329617754*^9, 
  3.728743394128528*^9, 3.728747262265957*^9, 3.7287494852097387`*^9, 
  3.728749935431992*^9, 3.7287503828126183`*^9, 3.728750527946123*^9, 
  3.7287505881209917`*^9, 3.7287507606555843`*^9, 3.7287510451404133`*^9, 
  3.7287516224984713`*^9, 3.728759356113003*^9, 3.7288132670155363`*^9, 
  3.728827384314583*^9, 3.7288359757332907`*^9, 3.728836292865864*^9, 
  3.7288430821123743`*^9, 3.728845627120904*^9, 3.733367305188802*^9, 
  3.792273244215954*^9},
 CellLabel->"During evaluation of In[70]:=",
 CellID->230882668,ExpressionUUID->"1a770054-12c1-453b-910d-b5ab710aab7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDfred", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDfred[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286611082289352`*^9, 3.728671231038711*^9, 
  3.7286748823136253`*^9, 3.7287424393287687`*^9, 3.72874329617754*^9, 
  3.728743394128528*^9, 3.728747262265957*^9, 3.7287494852097387`*^9, 
  3.728749935431992*^9, 3.7287503828126183`*^9, 3.728750527946123*^9, 
  3.7287505881209917`*^9, 3.7287507606555843`*^9, 3.7287510451404133`*^9, 
  3.7287516224984713`*^9, 3.728759356113003*^9, 3.7288132670155363`*^9, 
  3.728827384314583*^9, 3.7288359757332907`*^9, 3.728836292865864*^9, 
  3.7288430821123743`*^9, 3.728845627120904*^9, 3.733367305188802*^9, 
  3.792273244223461*^9},
 CellLabel->"During evaluation of In[70]:=",
 CellID->2089534594,ExpressionUUID->"ca77aa55-0b76-4fc8-9afc-7a6f9c6a0e0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpfred", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpfred[$CellContext`a, $CellContext`b, $CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286611082289352`*^9, 3.728671231038711*^9, 
  3.7286748823136253`*^9, 3.7287424393287687`*^9, 3.72874329617754*^9, 
  3.728743394128528*^9, 3.728747262265957*^9, 3.7287494852097387`*^9, 
  3.728749935431992*^9, 3.7287503828126183`*^9, 3.728750527946123*^9, 
  3.7287505881209917`*^9, 3.7287507606555843`*^9, 3.7287510451404133`*^9, 
  3.7287516224984713`*^9, 3.728759356113003*^9, 3.7288132670155363`*^9, 
  3.728827384314583*^9, 3.7288359757332907`*^9, 3.728836292865864*^9, 
  3.7288430821123743`*^9, 3.728845627120904*^9, 3.733367305188802*^9, 
  3.792273244230814*^9},
 CellLabel->"During evaluation of In[70]:=",
 CellID->1007841967,ExpressionUUID->"b4441d93-bff9-4ca3-95fd-c5a3278d2942"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownfred", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownfred[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286611082289352`*^9, 3.728671231038711*^9, 
  3.7286748823136253`*^9, 3.7287424393287687`*^9, 3.72874329617754*^9, 
  3.728743394128528*^9, 3.728747262265957*^9, 3.7287494852097387`*^9, 
  3.728749935431992*^9, 3.7287503828126183`*^9, 3.728750527946123*^9, 
  3.7287505881209917`*^9, 3.7287507606555843`*^9, 3.7287510451404133`*^9, 
  3.7287516224984713`*^9, 3.728759356113003*^9, 3.7288132670155363`*^9, 
  3.728827384314583*^9, 3.7288359757332907`*^9, 3.728836292865864*^9, 
  3.7288430821123743`*^9, 3.728845627120904*^9, 3.733367305188802*^9, 
  3.792273244238061*^9},
 CellLabel->"During evaluation of In[70]:=",
 CellID->1596415480,ExpressionUUID->"42829db3-b635-4c4b-9dab-be7eaa8913ec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Several other objects are automatically defined: the parallel derivative and \
its torsion, Christoffel, Riemann and Ricci tensors. We shall say more about \
them later on. This is the name of the parallel derivative of the defined \
basis:\
\>", "MathCaption",
 CellChangeTimes->{
  3.728663915144733*^9, {3.728742450013453*^9, 3.7287425031058197`*^9}},
 CellTags->{
  "S5.18.1", "1.7"},ExpressionUUID->"f50dbadd-96cf-49cb-b613-f6c7131614b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDOfBasis", "[", "fred", "]"}]], "Input",
 CellChangeTimes->{{3.728742474803959*^9, 3.728742475909643*^9}, {
  3.728747264588997*^9, 3.728747265083156*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"64d49cf8-473b-4b55-aed2-ceadd1bec358"],

Cell[BoxData["PDfred"], "Output",
 CellChangeTimes->{3.728661158947282*^9, 3.72867123135399*^9, 
  3.728674882680056*^9, 3.728742476741095*^9, 3.728743296601721*^9, 
  3.728743394446211*^9, 3.728747265401724*^9, 3.728749486905335*^9, 
  3.7287499356893187`*^9, 3.728750384396605*^9, 3.728750530298643*^9, 
  3.728750598066757*^9, 3.728750761497398*^9, 3.728751045535391*^9, 
  3.728751622761219*^9, 3.728759356490272*^9, 3.72881326728673*^9, 
  3.728827384612341*^9, 3.728835976077777*^9, 3.728836293159688*^9, 
  3.728843082701517*^9, 3.728845627561737*^9, 3.7333673069269342`*^9, 
  3.792273245801257*^9},
 CellLabel->"Out[71]=",
 CellID->251193709,ExpressionUUID->"8842468a-5a67-4cf0-897b-27804e44b84a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Each basis has a color, used to identify its associated indices and objects \
in StandardForm. The default for new bases is red, but we can specify a \
different color:\
\>", "MathCaption",
 CellChangeTimes->{
  3.7286611631859007`*^9, {3.728742523225885*^9, 
   3.728742523801676*^9}},ExpressionUUID->"f4b5fb15-fa95-40f5-af81-\
04cddf29abc6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"blues", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728661174785022*^9, 3.728661182787078*^9}, {
   3.728742527433813*^9, 3.7287425277786617`*^9}, {3.728742558297847*^9, 
   3.728742558781736*^9}, {3.7287472711248703`*^9, 3.7287472718746767`*^9}, 
   3.728749268079259*^9},
 CellLabel->"In[72]:=",ExpressionUUID->"5b5205ac-cdcd-453f-b226-1215b1249018"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "blues", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`blues, 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661179154333*^9, 3.728671231480196*^9, 
  3.7286748828358517`*^9, 3.728742559486743*^9, 3.728743296733789*^9, 
  3.728743394579537*^9, 3.72874727248982*^9, 3.728749488249411*^9, 
  3.7287499358344307`*^9, 3.7287503857765017`*^9, 3.7287505315481997`*^9, 
  3.7287505994012747`*^9, 3.728750762009864*^9, 3.7287510456985197`*^9, 
  3.728751622914558*^9, 3.728759356797165*^9, 3.728813267431576*^9, 
  3.728827384782134*^9, 3.728835976244763*^9, 3.728836293302853*^9, 
  3.728843083129384*^9, 3.728845627720441*^9, 3.7333673085732183`*^9, 
  3.79227324734207*^9},
 CellLabel->"During evaluation of In[72]:=",
 CellID->731076079,ExpressionUUID->"02efbdff-6e89-493d-ae2c-f05edf8adb62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDblues", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDblues[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661179154333*^9, 3.728671231480196*^9, 
  3.7286748828358517`*^9, 3.728742559486743*^9, 3.728743296733789*^9, 
  3.728743394579537*^9, 3.72874727248982*^9, 3.728749488249411*^9, 
  3.7287499358344307`*^9, 3.7287503857765017`*^9, 3.7287505315481997`*^9, 
  3.7287505994012747`*^9, 3.728750762009864*^9, 3.7287510456985197`*^9, 
  3.728751622914558*^9, 3.728759356797165*^9, 3.728813267431576*^9, 
  3.728827384782134*^9, 3.728835976244763*^9, 3.728836293302853*^9, 
  3.728843083129384*^9, 3.728845627720441*^9, 3.7333673085732183`*^9, 
  3.792273247354578*^9},
 CellLabel->"During evaluation of In[72]:=",
 CellID->1441715266,ExpressionUUID->"a7f64574-17de-47b5-a533-f16476dda035"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDblues", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDblues[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661179154333*^9, 3.728671231480196*^9, 
  3.7286748828358517`*^9, 3.728742559486743*^9, 3.728743296733789*^9, 
  3.728743394579537*^9, 3.72874727248982*^9, 3.728749488249411*^9, 
  3.7287499358344307`*^9, 3.7287503857765017`*^9, 3.7287505315481997`*^9, 
  3.7287505994012747`*^9, 3.728750762009864*^9, 3.7287510456985197`*^9, 
  3.728751622914558*^9, 3.728759356797165*^9, 3.728813267431576*^9, 
  3.728827384782134*^9, 3.728835976244763*^9, 3.728836293302853*^9, 
  3.728843083129384*^9, 3.728845627720441*^9, 3.7333673085732183`*^9, 
  3.792273247369157*^9},
 CellLabel->"During evaluation of In[72]:=",
 CellID->850486561,ExpressionUUID->"6ed28012-b6c2-442e-a554-54363d70a86a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDblues", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDblues[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661179154333*^9, 3.728671231480196*^9, 
  3.7286748828358517`*^9, 3.728742559486743*^9, 3.728743296733789*^9, 
  3.728743394579537*^9, 3.72874727248982*^9, 3.728749488249411*^9, 
  3.7287499358344307`*^9, 3.7287503857765017`*^9, 3.7287505315481997`*^9, 
  3.7287505994012747`*^9, 3.728750762009864*^9, 3.7287510456985197`*^9, 
  3.728751622914558*^9, 3.728759356797165*^9, 3.728813267431576*^9, 
  3.728827384782134*^9, 3.728835976244763*^9, 3.728836293302853*^9, 
  3.728843083129384*^9, 3.728845627720441*^9, 3.7333673085732183`*^9, 
  3.792273247376731*^9},
 CellLabel->"During evaluation of In[72]:=",
 CellID->476476295,ExpressionUUID->"5b03e026-057f-46f2-9000-f2a2ad0d9e12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDblues", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDblues[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661179154333*^9, 3.728671231480196*^9, 
  3.7286748828358517`*^9, 3.728742559486743*^9, 3.728743296733789*^9, 
  3.728743394579537*^9, 3.72874727248982*^9, 3.728749488249411*^9, 
  3.7287499358344307`*^9, 3.7287503857765017`*^9, 3.7287505315481997`*^9, 
  3.7287505994012747`*^9, 3.728750762009864*^9, 3.7287510456985197`*^9, 
  3.728751622914558*^9, 3.728759356797165*^9, 3.728813267431576*^9, 
  3.728827384782134*^9, 3.728835976244763*^9, 3.728836293302853*^9, 
  3.728843083129384*^9, 3.728845627720441*^9, 3.7333673085732183`*^9, 
  3.792273247384388*^9},
 CellLabel->"During evaluation of In[72]:=",
 CellID->170570402,ExpressionUUID->"2650f2e1-4809-43fc-b8b3-9948068612ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDblues", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDblues[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661179154333*^9, 3.728671231480196*^9, 
  3.7286748828358517`*^9, 3.728742559486743*^9, 3.728743296733789*^9, 
  3.728743394579537*^9, 3.72874727248982*^9, 3.728749488249411*^9, 
  3.7287499358344307`*^9, 3.7287503857765017`*^9, 3.7287505315481997`*^9, 
  3.7287505994012747`*^9, 3.728750762009864*^9, 3.7287510456985197`*^9, 
  3.728751622914558*^9, 3.728759356797165*^9, 3.728813267431576*^9, 
  3.728827384782134*^9, 3.728835976244763*^9, 3.728836293302853*^9, 
  3.728843083129384*^9, 3.728845627720441*^9, 3.7333673085732183`*^9, 
  3.792273247391569*^9},
 CellLabel->"During evaluation of In[72]:=",
 CellID->2033561316,ExpressionUUID->"c93d6a16-03ca-4db1-a236-7c10768f8686"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpblues", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpblues[$CellContext`a, $CellContext`b, $CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661179154333*^9, 3.728671231480196*^9, 
  3.7286748828358517`*^9, 3.728742559486743*^9, 3.728743296733789*^9, 
  3.728743394579537*^9, 3.72874727248982*^9, 3.728749488249411*^9, 
  3.7287499358344307`*^9, 3.7287503857765017`*^9, 3.7287505315481997`*^9, 
  3.7287505994012747`*^9, 3.728750762009864*^9, 3.7287510456985197`*^9, 
  3.728751622914558*^9, 3.728759356797165*^9, 3.728813267431576*^9, 
  3.728827384782134*^9, 3.728835976244763*^9, 3.728836293302853*^9, 
  3.728843083129384*^9, 3.728845627720441*^9, 3.7333673085732183`*^9, 
  3.792273247399048*^9},
 CellLabel->"During evaluation of In[72]:=",
 CellID->862796007,ExpressionUUID->"6734124c-c4b0-46b9-a37e-9c6ff3d3c624"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownblues", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownblues[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661179154333*^9, 3.728671231480196*^9, 
  3.7286748828358517`*^9, 3.728742559486743*^9, 3.728743296733789*^9, 
  3.728743394579537*^9, 3.72874727248982*^9, 3.728749488249411*^9, 
  3.7287499358344307`*^9, 3.7287503857765017`*^9, 3.7287505315481997`*^9, 
  3.7287505994012747`*^9, 3.728750762009864*^9, 3.7287510456985197`*^9, 
  3.728751622914558*^9, 3.728759356797165*^9, 3.728813267431576*^9, 
  3.728827384782134*^9, 3.728835976244763*^9, 3.728836293302853*^9, 
  3.728843083129384*^9, 3.728845627720441*^9, 3.7333673085732183`*^9, 
  3.792273247406353*^9},
 CellLabel->"During evaluation of In[72]:=",
 CellID->1202905105,ExpressionUUID->"63cd069e-036f-42ff-ab7e-b11dda6e66a4"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A basis has several associated definitions and UpValues:", "MathCaption",
 CellChangeTimes->{{3.72866118914478*^9, 3.7286611913286448`*^9}, 
   3.728742589917898*^9},ExpressionUUID->"588ab9ea-12b6-4cd9-be95-\
2b53ccebebd7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "fred"}]], "Input",
 CellChangeTimes->{{3.728742592278576*^9, 3.728742593752141*^9}, {
  3.72874727480256*^9, 3.728747275290606*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"9bfb9365-41e0-450e-9e89-c458ee1bfa00"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`fred\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"BasisQ", "[", "fred", "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"BasisColor", "[", "fred", "]"}], "^=", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"VBundleOfBasis", "[", "fred", "]"}], "^=", 
                    InterpretationBox[
                    StyleBox["\[DoubleStruckCapitalT]M3",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`TangentM3,
                    Editable->False]}]},
                    {
                    RowBox[{"fred", "/:", 
                    RowBox[{"CNumbersOf", "[", 
                    RowBox[{"fred", ",", 
                    InterpretationBox[
                    StyleBox["\[DoubleStruckCapitalT]M3",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`TangentM3,
                    Editable->False]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"etaOrientation", "[", "fred", "]"}], "^=", "1"}]},
                    {
                    RowBox[{
                    RowBox[{"DependenciesOfBasis", "[", "fred", "]"}], "^=", 
                    RowBox[{"{", "M3", "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", "fred", "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"basis\"\>", ",", "\<\"\"\>"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"HostsOf", "[", "fred", "]"}], "^=", 
                    RowBox[{"{", 
                    InterpretationBox[
                    StyleBox["\[DoubleStruckCapitalT]M3",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`TangentM3,
                    Editable->False], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PDOfBasis", "[", "fred", "]"}], "^=", "PDfred"}]},
                    {
                    RowBox[{
                    RowBox[{"ServantsOf", "[", "fred", "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"PDfred", ",", "etaUpfred", ",", "etaDownfred"}], 
                    "}"}]}]},
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", "fred", "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`fred],
                    Editable->False], "^=", "fred"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`fred\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {2., 8.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {2., 8.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`fred\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> "Global`fred", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`fred, {
      xAct`xTensor`BasisQ[$CellContext`fred] -> True, 
       xAct`xCoba`BasisColor[$CellContext`fred] -> RGBColor[1, 0, 0], 
       xAct`xCoba`VBundleOfBasis[$CellContext`fred] -> $CellContext`TangentM3,
        xAct`xCoba`CNumbersOf[$CellContext`fred, $CellContext`TangentM3] -> {
        0, 1, 2}, xAct`xCoba`etaOrientation[$CellContext`fred] -> 1, 
       xAct`xCoba`DependenciesOfBasis[$CellContext`fred] -> {$CellContext`M3},
        xAct`xTensor`DefInfo[$CellContext`fred] -> {"basis", ""}, 
       xAct`xTensor`HostsOf[$CellContext`fred] -> {$CellContext`TangentM3}, 
       xAct`xCoba`PDOfBasis[$CellContext`fred] -> $CellContext`PDfred, 
       xAct`xTensor`ServantsOf[$CellContext`fred] -> {$CellContext`PDfred, \
$CellContext`etaUpfred, $CellContext`etaDownfred}, 
       xAct`xTensor`Dagger[$CellContext`fred] -> $CellContext`fred}], 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "Global`fred"], False]]], "Output",
 CellChangeTimes->{3.792273248829608*^9},
 CellLabel->"Out[73]=",
 CellID->835398157,ExpressionUUID->"0a613360-10e5-4875-84c5-2b42866c06b7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["This is the list of bases we have defined so far:", "MathCaption",
 CellChangeTimes->{{3.7286612083358994`*^9, 3.7286612207838573`*^9}},
 CellID->1062134855,ExpressionUUID->"2c95fb17-daae-496b-90bd-14b7cceced56"],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], "Input",
 CellLabel->"In[74]:=",ExpressionUUID->"284de3dd-8b5c-47e4-a943-90d6d74f0e55"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"fred", ",", "blues"}], "}"}]], "Output",
 CellChangeTimes->{3.7286612048268747`*^9, 3.728671232082341*^9, 
  3.728674883500795*^9, 3.728742606243246*^9, 3.728743297961096*^9, 
  3.728743395152429*^9, 3.728747278904173*^9, 3.7287494934410763`*^9, 
  3.728749936335544*^9, 3.728750390630744*^9, 3.728750535411242*^9, 
  3.728750602202997*^9, 3.728750762873687*^9, 3.728751046527026*^9, 
  3.728751623380911*^9, 3.728759357964581*^9, 3.728813267972953*^9, 
  3.728827385428608*^9, 3.728835977050632*^9, 3.7288362938927603`*^9, 
  3.728843084205617*^9, 3.7288456282451344`*^9, 3.733367311293479*^9, 
  3.7922732509842377`*^9},
 CellLabel->"Out[74]=",
 CellID->1057914556,ExpressionUUID->"0a0e6d75-ec94-4060-aaf6-6f57961a95f1"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.2. Basis objects", "Subsubsection",
 CellChangeTimes->{{3.728661774391335*^9, 3.728661777357946*^9}, {
   3.728661817699605*^9, 3.728661818283976*^9}, 3.72866278132205*^9, {
   3.728673438717552*^9, 
   3.728673438909156*^9}},ExpressionUUID->"7883ce9d-6f1e-4b4c-826d-\
d82119e15c0c"],

Cell[TextData[{
 "Now that we have bases, we can use basis vectors and work with tensor \
components. Two new kinds of indices are needed:\n\t ",
 StyleBox["{a, basisname}", "MR"],
 " :  Basis index (",
 StyleBox["BIndex", "MR"],
 "),  ",
 StyleBox["a", "MR"],
 " is an abstract index.\n\t ",
 StyleBox["{i, basisname}", "MR"],
 " :  Component index (",
 StyleBox["CIndex", "MR"],
 "), ",
 StyleBox["i", "MR"],
 " is a valid component number.\nWhen we define a basis in the tangent \
bundle, its dual in the cotangent bundle is also automatically defined. This \
dual basis is called -basisname and has the same cnumbers as the original. \
The notation for covariant bc-indices is \n\t",
 StyleBox["{-a, -basisname}", "MR"],
 " :  Basis index (",
 StyleBox["BIndex", "MR"],
 "),  ",
 StyleBox["a", "MR"],
 " is an abstract index.\n\t",
 StyleBox["{i,  -basisname}", "MR"],
 " :  Component index (",
 StyleBox["CIndex", "MR"],
 "), ",
 StyleBox["i", "MR"],
 " is a valid coordinate number.\nNotice how a covariant b-index is the \
negative of the corresponding contravariant index, but this is not true for \
c-indices. This apparent inconsistency is a conscious choice: it allows us to \
use zero and negative cnumbers (the latter being common in treatments of \
angular momentum, tensor harmonics, etc.)\nNOTE: In versions 0.3 and 0.4 we \
used b-indices like {a, polar}, {-a, polar} and c-indices like {1, polar} and \
{-1, polar}. This notational change is ",
 StyleBox["not",
  FontSlant->"Italic"],
 " backwards compatible. We apologize to those users of ",
 StyleBox["xCoba`", "MR"],
 " who now need to change lots of signs in previously developed notebooks, \
but we feel that the use of this new notation will pay off."
}], "Text",
 CellChangeTimes->{{3.7286612759669437`*^9, 3.728661295501946*^9}, {
  3.728661333340712*^9, 
  3.728661353426968*^9}},ExpressionUUID->"225c0d65-6dec-4c7f-aeb8-\
0a7353325878"],

Cell[CellGroupData[{

Cell["Several functions are provided to check validity:", "MathCaption",
 CellChangeTimes->{{3.728661376151986*^9, 
  3.728661378991946*^9}},ExpressionUUID->"536dc41c-e7b4-4863-968d-\
339931e28a80"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}]], "Input",
 CellLabel->"In[75]:=",ExpressionUUID->"587060d8-a9c0-4eb1-8df3-ad17ce14a4b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"f1", ",", "f2", ",", "f3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728661380379287*^9, 3.728671237060877*^9, 
  3.728674883717046*^9, 3.728742622895011*^9, 3.7287432984615498`*^9, 
  3.728743395276918*^9, 3.7287472862186193`*^9, 3.728749497710363*^9, 
  3.728749936533288*^9, 3.728750410991712*^9, 3.728750538197644*^9, 
  3.728750605802652*^9, 3.728750766786337*^9, 3.728751057183301*^9, 
  3.7287516235902853`*^9, 3.7288132681020727`*^9, 3.728827385598845*^9, 
  3.728835977188724*^9, 3.7288362940430727`*^9, 3.728843089501257*^9, 
  3.728845628395335*^9, 3.733367320426853*^9, 3.7922732653392982`*^9},
 CellLabel->"Out[75]=",
 CellID->2021201992,ExpressionUUID->"d0f83860-d6e6-4dee-995d-326572fc3736"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"indexlist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "fred"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "fred"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"A", ",", "fred"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "fred"}], "}"}], ",", "a", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "fred"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "other"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.728742626429675*^9, 3.728742688873519*^9}, {
  3.728747288236272*^9, 3.728747304105721*^9}, {3.728749277465746*^9, 
  3.7287492783811903`*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"d4b0cb4a-45b6-4991-a4c1-ca8aae86f333"],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], "Input",
 CellLabel->"In[77]:=",ExpressionUUID->"73543f66-ce0c-41c3-8759-deacdeff54c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"fred", ",", "blues"}], "}"}]], "Output",
 CellChangeTimes->{3.728661383210031*^9, 3.728671237265472*^9, 
  3.728674883916779*^9, 3.7287426951716137`*^9, 3.728743298950094*^9, 
  3.728743395531502*^9, 3.728747306790636*^9, 3.728749498942534*^9, 
  3.7287499368185167`*^9, 3.7287504111597*^9, 3.728750539447094*^9, 
  3.7287506070751333`*^9, 3.728750767036315*^9, 3.7287510573349743`*^9, 
  3.728751623879921*^9, 3.728813268240901*^9, 3.728827385828704*^9, 
  3.728835977365494*^9, 3.728836294257658*^9, 3.728843089754072*^9, 
  3.7288456286331577`*^9, 3.733367322044083*^9, 3.792273266897358*^9},
 CellLabel->"Out[77]=",
 CellID->1364513160,ExpressionUUID->"dc41ff6e-c6f1-43cd-bef7-b553e32bd387"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BIndexQ", "/@", " ", "indexlist"}]], "Input",
 CellLabel->"In[78]:=",ExpressionUUID->"32dc7866-a948-4db3-8202-b25604fd70b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "False", ",", "True", ",", "False", ",", "False", 
   ",", "False", ",", "False", ",", "False", ",", "False"}], "}"}]], "Output",\

 CellChangeTimes->{3.728661384313463*^9, 3.728671237398191*^9, 
  3.728674884129939*^9, 3.728742697189395*^9, 3.728743299070634*^9, 
  3.7287433957253036`*^9, 3.7287473077585783`*^9, 3.7287494995308113`*^9, 
  3.728749936951621*^9, 3.728750411293066*^9, 3.728750540022892*^9, 
  3.7287506077680397`*^9, 3.7287507671760187`*^9, 3.728751057484213*^9, 
  3.7287516240146646`*^9, 3.728813268401772*^9, 3.728827385981289*^9, 
  3.72883597750557*^9, 3.728836294410036*^9, 3.72884308989904*^9, 
  3.7288456287823563`*^9, 3.733367322610421*^9, 3.792273267472179*^9},
 CellLabel->"Out[78]=",
 CellID->1429685618,ExpressionUUID->"66ab0f5a-1c2e-4039-b052-ea86545a4864"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CIndexQ", " ", "/@", " ", "indexlist"}]], "Input",
 CellLabel->"In[79]:=",ExpressionUUID->"58c5b5e2-6c70-47e7-b949-f203cb85b8c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", 
   "False", ",", "True", ",", "False", ",", "False", ",", "False"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7286613853437147`*^9, 3.7286712375336933`*^9, 
  3.7286748843441877`*^9, 3.728742698233316*^9, 3.728743299197647*^9, 
  3.728743395864582*^9, 3.728747308605625*^9, 3.728749500173131*^9, 
  3.728749937067589*^9, 3.72875041144209*^9, 3.728750540659316*^9, 
  3.728750608355386*^9, 3.7287507674415293`*^9, 3.728751057616477*^9, 
  3.728751624163352*^9, 3.728813268552442*^9, 3.728827386131575*^9, 
  3.7288359776385317`*^9, 3.728836294559916*^9, 3.728843090218813*^9, 
  3.728845628930691*^9, 3.7333673232462053`*^9, 3.792273268019999*^9},
 CellLabel->"Out[79]=",
 CellID->149829661,ExpressionUUID->"5654b148-4d9f-41e5-b225-0b18652bf811"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["An extra function selects both basis and component indices:", \
"MathCaption",
 CellChangeTimes->{{3.728742702770005*^9, 
  3.7287427033133507`*^9}},ExpressionUUID->"8e17a1d0-fcfa-45a7-88e1-\
e8335e2d68e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BCIndexQ", " ", "/@", " ", "indexlist"}]], "Input",
 CellLabel->"In[80]:=",ExpressionUUID->"0c9a0486-7d17-47ea-a628-990f4e38afee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "False", ",", "True", ",", "True", ",", "False", 
   ",", "True", ",", "False", ",", "False", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.728661388443357*^9, 3.728671237664977*^9, 
  3.728674884516561*^9, 3.728742700418931*^9, 3.728743299338346*^9, 
  3.728743396081163*^9, 3.728747310040349*^9, 3.728749501890305*^9, 
  3.7287499372011433`*^9, 3.728750411575324*^9, 3.7287505416944036`*^9, 
  3.7287506094350843`*^9, 3.728750768042274*^9, 3.7287510578421297`*^9, 
  3.728751624326755*^9, 3.728813269074976*^9, 3.728827386374284*^9, 
  3.7288359777718678`*^9, 3.728836294709413*^9, 3.7288430905625353`*^9, 
  3.7288456290799828`*^9, 3.733367324262833*^9, 3.792273269011567*^9},
 CellLabel->"Out[80]=",
 CellID->440272853,ExpressionUUID->"6117b2df-5ad9-475d-a5f1-ed2323824370"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "On occasion, it is interesting to know whether an index is either an ",
 StyleBox["AIndex", "MR"],
 " or a ",
 StyleBox["BIndex", "MR"],
 ". Those are the only types that may be contracted, which makes them \
important for functions such as ",
 StyleBox["ContractBasis", "MR"],
 ". We will call them `contractible indices'."
}], "MathCaption",
 CellChangeTimes->{{3.733367330880289*^9, 
  3.733367347207659*^9}},ExpressionUUID->"129c6ba2-51dd-4a92-9ef7-\
b79a233f7ea6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ABIndexQ", " ", "/@", " ", "indexlist"}]], "Input",
 CellLabel->"In[81]:=",ExpressionUUID->"ea5d79e8-f11c-4409-8f0f-490801d63df1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "False", ",", "True", ",", "False", ",", "True", 
   ",", "False", ",", "False", ",", "False", ",", "False"}], "}"}]], "Output",\

 CellChangeTimes->{3.728661393245131*^9, 3.728671237792642*^9, 
  3.728674884652648*^9, 3.728742719658112*^9, 3.7287432995539703`*^9, 
  3.72874339619477*^9, 3.728747311337358*^9, 3.728749504371229*^9, 
  3.7287499373178053`*^9, 3.7287504117082357`*^9, 3.728750543961832*^9, 
  3.728750611968759*^9, 3.7287507684900846`*^9, 3.728751058237167*^9, 
  3.72875162445859*^9, 3.728813269564513*^9, 3.728827386606957*^9, 
  3.728835977908737*^9, 3.728836294859911*^9, 3.728843091133651*^9, 
  3.728845629230131*^9, 3.73336735143302*^9, 3.792273270205676*^9},
 CellLabel->"Out[81]=",
 CellID->1691975529,ExpressionUUID->"50245daf-a32c-4598-9962-e0ce436a60dd"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Notice that we can get a ",
 StyleBox["False", "MR"],
 " output for several reasons: The basis, abstract index or cnumber might not \
exist or they might belong to different vbundles."
}], "MathCaption",ExpressionUUID->"444eeeea-77d5-4d25-a3ad-21940ae1a5b2"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["If we use these indices inside of tensors, ", "Text"],
 StyleBox["Mathematica", "Text",
  FontSlant->"Italic"],
 StyleBox[" will display them according to ", "Text"],
 StyleBox["BasisColor", "Text", "MR"],
 StyleBox[",", "Text"]
}], "MathCaption",ExpressionUUID->"eebf6268-a2c4-4344-8477-950d6fc8c617"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "blues"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "blues"}]}], "}"}]}], "]"}], " ", 
  RowBox[{"v", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "fred"}], "}"}], "]"}], " "}]], "Input",
 CellChangeTimes->{
  3.728742736366063*^9, {3.728747315633*^9, 3.7287473206807327`*^9}, {
   3.728749281682767*^9, 3.728749282308937*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"268191a3-370e-44fb-995b-3764026a42ee"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]], 
           StyleBox["2",
            FontColor->RGBColor[0., 0., 1.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[{1, -$CellContext`blues}, {2, -$CellContext`blues}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {
           StyleBox["a",
            FontColor->RGBColor[1., 0., 0.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{$CellContext`a, $CellContext`fred}],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728661405712282*^9, 3.728671237928385*^9, 
  3.728674884827883*^9, 3.728742741010296*^9, 3.72874329968436*^9, 
  3.728743396330844*^9, 3.728747321620275*^9, 3.728749506169181*^9, 
  3.728749937435382*^9, 3.728750411847303*^9, 3.728750545643959*^9, 
  3.728750614459724*^9, 3.728750768676738*^9, 3.728751058381624*^9, 
  3.728751624593524*^9, 3.728813269791626*^9, 3.7288273868110857`*^9, 
  3.728835978083827*^9, 3.728836295035866*^9, 3.728843091307954*^9, 
  3.728845629385003*^9, 3.733367355876244*^9, 3.792273271989026*^9},
 CellLabel->"Out[82]=",
 CellID->148472211,ExpressionUUID->"27651885-7304-4ec0-813a-a8321c7c48fc"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The Basis tensor is formally xTensor's delta tensor, but we prefer to \
separate Basis in xCoba`. Depending on its indices, the meaning will change, \
and in particular when both its indices are abstract, it will autoconvert \
into delta:\n\t- ",
 StyleBox["Basis[ AIndex, BCIndex]", "MR"],
 " :\tBasis vector (or dual basis covector).\n\t- ",
 StyleBox["Basis[ AIndex, AIndex]", "MR"],
 ": \tIdentity tensor in the corresponding vbundle (turns into \[Delta]).\n\t\
- ",
 StyleBox["Basis[ BCIndex, BCIndex]", "MR"],
 ":\tIf the indices belong to different bases, it represents a basis change.\n\
\t\t\t\t\t\tIf they belong to the same basis, we have a Kronecker delta \
(products of the elements of dual bases)."
}], "Text",
 CellChangeTimes->{{3.728661455805543*^9, 3.728661530090159*^9}, {
  3.728661561007251*^9, 3.7286615803757763`*^9}, {3.728742762246937*^9, 
  3.728742764231371*^9}},ExpressionUUID->"d34d2147-8c98-4d66-b59f-\
1f302fc13ae7"],

Cell[CellGroupData[{

Cell["Basis is output as an e, except when it converts into delta:", \
"MathCaption",
 CellChangeTimes->{{3.728661588286262*^9, 
  3.728661606446005*^9}},ExpressionUUID->"76a5a604-83dc-4878-831c-\
146276a3514a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "fred"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "blues"}], "}"}]}], "]"}], ",", "  ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "fred"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "fred"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.728742778262514*^9, 3.7287427941028233`*^9}, {
  3.728747328600923*^9, 3.728747346711525*^9}, {3.72874928319238*^9, 
  3.7287492843490763`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"468fa3bd-ce86-4aa7-ad63-104127e19477"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "b"},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`a, $CellContext`b],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["b",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["a",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`blues}, \
{$CellContext`b, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["b",
             FontColor->RGBColor[0., 0., 1.]]},
           {
            StyleBox["a",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`blues}, \
{$CellContext`b, $CellContext`blues}],
    Editable->False], ",", "1", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.728661608258806*^9, 3.728671238071991*^9, 
  3.728674884988592*^9, 3.728742810486932*^9, 3.728743299802369*^9, 
  3.7287433964477377`*^9, 3.728747347143012*^9, 3.728749509213345*^9, 
  3.7287499375631027`*^9, 3.7287504119943542`*^9, 3.728750616952544*^9, 
  3.728750768855591*^9, 3.728751058519384*^9, 3.7287516247447977`*^9, 
  3.728813269964263*^9, 3.728827386973833*^9, 3.728835978219914*^9, 
  3.72883629518077*^9, 3.728843091735166*^9, 3.7288456295356627`*^9, 
  3.733367360166727*^9, 3.792273274712234*^9},
 CellLabel->"Out[83]=",
 CellID->842480991,ExpressionUUID->"0a565396-33c1-43ce-96a1-a91ac2a6c7ac"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A Basis object with two indices of the same character (covariant or \
contravariant) is converted into a metric tensor. If we  have defined more \
than one metric, the first one is used (see xTensorDoc.nb for details).\
\>", "MathCaption",
 CellChangeTimes->{{3.7286616215969887`*^9, 
  3.7286616343163424`*^9}},ExpressionUUID->"ddd22766-b3c0-42af-a36b-\
3184ffae9202"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}]}]], "Input",
 CellLabel->"In[84]:=",ExpressionUUID->"c578bbd3-765d-4ce0-adc2-c97919d73d2b"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M3\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM3, \
Rule[Editable, False]]\\).\"", 2, 84, 6, 19668387891272167742, "Local", 
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728661636908689*^9, 3.72867123822229*^9, 
  3.7286748853104687`*^9, 3.728742819965699*^9, 3.7287432999438057`*^9, 
  3.72874339656462*^9, 3.728747349521413*^9, 3.7287495106740294`*^9, 
  3.7287499376858253`*^9, 3.728750412142022*^9, 3.728750618184095*^9, 
  3.7287507691354733`*^9, 3.728751058664926*^9, 3.72875162491118*^9, 
  3.728813270140737*^9, 3.728827387130657*^9, 3.728835978354167*^9, 
  3.728836295326893*^9, 3.728843091896617*^9, 3.7288456296777763`*^9, 
  3.733367361516884*^9, 3.792273276544488*^9},
 CellLabel->"During evaluation of In[84]:=",
 CellID->585816200,ExpressionUUID->"3cec4acc-8b23-4480-b915-4b8c9e34d618"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"metricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"SymbolOfCovD", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}]}], ",", 
   RowBox[{"PrintAs", "->", "\"\<g\>\""}]}], "]"}]], "Input",
 CellLabel->"In[85]:=",ExpressionUUID->"adf56673-76fc-41bd-93bf-ad8c5a2b94f4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"metricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`metricg[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277153592*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1085112334,ExpressionUUID->"20864c41-33b6-4a0f-95c9-c285e9fcee58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilonmetricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilonmetricg[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.7922732771639633`*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1051867214,ExpressionUUID->"730608cc-55a0-4046-b25d-11ea92fada14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.7922732771793013`*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->646883594,ExpressionUUID->"085a7d4b-6ee8-44a3-bb4f-0b7713915333"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277187532*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1610343244,ExpressionUUID->"24824b51-6c3b-4f1c-b8ad-d70855c9d57b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277195475*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->302498767,ExpressionUUID->"b2b85861-ec88-4330-a61c-904933638c6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277203349*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1002984520,ExpressionUUID->"a3ca23a7-b1dd-404b-b157-bf8fc6796c80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277211154*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1561682337,ExpressionUUID->"83a4a250-88ed-450e-a417-71a9d511e8b3"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277218889*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->649904325,ExpressionUUID->"90d12eb2-3f31-40e3-ac3f-3dd78d9c7516"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.7922732772262373`*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->840161633,ExpressionUUID->"69fb9bd7-0128-4d12-8f6d-626f92afc21a"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.7922732772339287`*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->891586806,ExpressionUUID->"28354677-d7f6-4b2d-bce1-2bb26931fe8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.7922732772411203`*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1906043323,ExpressionUUID->"64173909-59c4-4153-996e-5da798772610"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277247841*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->856567362,ExpressionUUID->"f46be9e9-b6fa-4e8e-81b9-9edeb1cb37f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277255437*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1744767293,ExpressionUUID->"d8c0ab6f-ac98-4a67-bc2e-352c2fd26079"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.79227327726305*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->414693666,ExpressionUUID->"2d333f68-4b95-4dd0-9ae8-9d758b94bf28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277270741*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1172009947,ExpressionUUID->"d85048b7-1dbb-4b7e-bfdb-0d10114c74f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277278487*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1251168945,ExpressionUUID->"be26bf36-91cf-408c-b230-e70b976bad1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277286379*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->236587191,ExpressionUUID->"7f4ec9d4-004d-43b9-b4ea-e93fd7c48ff6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detmetricg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detmetricg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellChangeTimes->{3.728661638455361*^9, 3.728671238335267*^9, 
  3.728674885590446*^9, 3.7287428220135603`*^9, 3.728743300081644*^9, 
  3.728743396682912*^9, 3.728747351111747*^9, 3.728749511320087*^9, 
  3.7287499378179483`*^9, 3.728750412318598*^9, 3.728750618744329*^9, 
  3.728750769588572*^9, 3.7287510588105593`*^9, 3.7287516250453987`*^9, 
  3.728813270305621*^9, 3.728827387290801*^9, 3.7288359784983664`*^9, 
  3.728836295487876*^9, 3.728843092171422*^9, 3.728845629860628*^9, 
  3.7333673621128187`*^9, 3.792273277324883*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1328688540,ExpressionUUID->"59ba8c7e-b9f9-4809-8a9e-0544a8ce1967"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "blues"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "blues"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "blues"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "fred"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.728742826924197*^9, 3.728742832397194*^9}, {
  3.728747354520946*^9, 3.7287473612949533`*^9}, {3.728749285331777*^9, 
  3.7287492866894617`*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"030e90da-d725-49ed-9995-ef89684cd6c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metricg[-$CellContext`a, -$CellContext`b],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {
            StyleBox["a",
             FontColor->RGBColor[0., 0., 1.]], 
            StyleBox["b",
             FontColor->RGBColor[0., 0., 1.]]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metricg[{$CellContext`a, $CellContext`blues}, \
{$CellContext`b, $CellContext`blues}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {
            StyleBox["a",
             FontColor->RGBColor[0., 0., 1.]], 
            StyleBox["b",
             FontColor->RGBColor[1., 0., 0.]]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metricg[{$CellContext`a, $CellContext`blues}, \
{$CellContext`b, $CellContext`fred}],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.728661643063468*^9, 3.7286712389318123`*^9, 
  3.728674886450713*^9, 3.728742832988544*^9, 3.728743300703643*^9, 
  3.728743397231599*^9, 3.728747361945566*^9, 3.728749513191443*^9, 
  3.728749938149901*^9, 3.72875041266987*^9, 3.728750620369935*^9, 
  3.728750770134644*^9, 3.728751059212175*^9, 3.7287516254445744`*^9, 
  3.7288132707477713`*^9, 3.728827387757455*^9, 3.728835979265053*^9, 
  3.728836295919467*^9, 3.728843093517049*^9, 3.728845630462747*^9, 
  3.7333673636276827`*^9, 3.7922732787005*^9},
 CellLabel->"Out[86]=",
 CellID->1499578617,ExpressionUUID->"6976e279-f426-4d9d-8788-c3acb4c0b61f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Now other index configurations are allowed, but transformed automatically \
into the original down-up configuration:\
\>", "MathCaption",ExpressionUUID->"eef2cdde-1048-4cb2-bd37-94b0ab1e03a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "fred"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "blues"}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.728742836595674*^9, 3.728742838573037*^9}, {
   3.7287473657749567`*^9, 3.728747368214006*^9}, 3.728749287750205*^9},
 CellLabel->"In[87]:=",ExpressionUUID->"08565ed1-7cb9-4ead-a740-a5523f686629"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "a"},
           {"b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`b, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["a",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["b",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`blues}, \
{$CellContext`a, $CellContext`fred}],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.7286616456259317`*^9, 3.7286712390782747`*^9, 
  3.728674886587406*^9, 3.728742839151299*^9, 3.7287433008352003`*^9, 
  3.728743397365224*^9, 3.728747368809691*^9, 3.728749514253943*^9, 
  3.728749938265368*^9, 3.7287504128263206`*^9, 3.7287506214396267`*^9, 
  3.728750770350238*^9, 3.728751059397326*^9, 3.728751625595461*^9, 
  3.728813270914156*^9, 3.728827387913743*^9, 3.72883597949817*^9, 
  3.728836296070532*^9, 3.728843094367774*^9, 3.728845630603524*^9, 
  3.7333673651003923`*^9, 3.7922732808982162`*^9},
 CellLabel->"Out[87]=",
 CellID->1069677556,ExpressionUUID->"eafae9e1-9734-41d3-a6fd-34b24cdc25fe"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
When a vector bundle has a metric, delta and Basis inherit the symmetry of \
that metric.\
\>", "MathCaption",
 CellChangeTimes->{{3.728661657851058*^9, 3.7286616843458*^9}},
 CellID->1116390537,ExpressionUUID->"95ca4695-08b7-4804-943d-72d469c0fe01"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "fred"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "blues"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7287428438849154`*^9, 3.728742847392952*^9}, {
   3.728747372366438*^9, 3.728747375670146*^9}, 3.728749290467914*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"ba477352-b254-44b7-bfd8-56f7ed5f643b"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    InterpretationBox[
     StyleBox[
      RowBox[{"(", "1", ",", "2", ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPerm`Cycles[{1, 2}],
     Editable->False], "]"}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.728661646465723*^9, 3.728671239238368*^9, 3.728674886745989*^9, 
   3.7287428480546017`*^9, 3.728743300967203*^9, 3.7287433974813633`*^9, {
   3.728747373554792*^9, 3.728747376134741*^9}, 3.728749515402854*^9, 
   3.72874993841537*^9, 3.728750412972868*^9, 3.72875062250322*^9, 
   3.7287507704975357`*^9, 3.7287510596445436`*^9, 3.728751625761207*^9, 
   3.72881327107134*^9, 3.728827388095648*^9, 3.728835979677929*^9, 
   3.728836296259377*^9, 3.7288430945576153`*^9, 3.728845630769259*^9, 
   3.733367366332876*^9, 3.792273282450046*^9},
 CellLabel->"Out[88]=",
 CellID->1181479492,ExpressionUUID->"d06c8e45-c4de-4288-a3e0-739ab116cb2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefMetric", "[", "metricg", "]"}]], "Input",
 CellLabel->"In[89]:=",ExpressionUUID->"824892bd-03f6-421f-811c-8a38c1b6e85c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Detmetricg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "weight +2 density", 
   " ", $CellContext`Detmetricg],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.792273283000696*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->25712005,ExpressionUUID->"86b6cda9-7f37-4e8b-8382-f637182db9fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.792273283012747*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->497454988,ExpressionUUID->"6f0e02c4-dd25-4aaa-b37f-b0bfcdd644e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "EinsteinCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Einstein tensor", " ", $CellContext`EinsteinCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.7922732830272083`*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->572145545,ExpressionUUID->"8d8d962a-ce87-460b-a5d4-2fc73a144f5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "KretschmannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Kretschmann scalar", 
   " ", $CellContext`KretschmannCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.792273283034501*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->1765887196,ExpressionUUID->"7ae9f1cf-7849-4987-969b-58ca16e587b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric Ricci tensor", 
   " ", $CellContext`RicciCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.792273283041925*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->1042101632,ExpressionUUID->"c4324fc8-77d0-49e2-9f2f-914cc234a4fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciScalarCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci scalar", 
   " ", $CellContext`RicciScalarCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.792273283049142*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->1872987739,ExpressionUUID->"cc17e843-3040-4928-9075-5f5208017b0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.792273283056467*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->1489631647,ExpressionUUID->"36b9b1d6-7bbe-4b9c-8b47-d80a532b9b09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TFRicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric TFRicci tensor",
    " ", $CellContext`TFRicciCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.792273283064126*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->874734403,ExpressionUUID->"a15af2ba-cb1c-434c-8594-3e4729bdf953"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.792273283071553*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->2135547506,ExpressionUUID->"8abc0fef-1867-4b06-bf48-37fbfa2a04e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "WeylCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl tensor", 
   " ", $CellContext`WeylCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.7922732830785427`*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->1252741031,ExpressionUUID->"83e698ab-3f75-469d-826e-d588eca2e1e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.79227328308562*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->888832829,ExpressionUUID->"1a73b07e-d5a8-4dd5-8a4d-3815091c9092"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "epsilonmetricg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric tensor", 
   " ", $CellContext`epsilonmetricg],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.7922732830938663`*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->717108471,ExpressionUUID->"2b3c0178-692c-4b1f-b092-37441bde7ea6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "metricg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric metric tensor", 
   " ", $CellContext`metricg],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286616909860077`*^9, 3.728671239373364*^9, 
  3.728674886881982*^9, 3.728742849824275*^9, 3.728743301136413*^9, 
  3.7287433976309443`*^9, 3.728747378762335*^9, 3.728749516005363*^9, 
  3.728749938548609*^9, 3.72875041310998*^9, 3.728750623064906*^9, 
  3.72875077066613*^9, 3.72875105978465*^9, 3.728751625894623*^9, 
  3.728813271234043*^9, 3.7288273882579536`*^9, 3.7288359798659163`*^9, 
  3.728836296401224*^9, 3.728843094801313*^9, 3.728845630904367*^9, 
  3.733367366864629*^9, 3.79227328310098*^9},
 CellLabel->"During evaluation of In[89]:=",
 CellID->763845133,ExpressionUUID->"2ec132e4-e810-40f8-a567-f4ec448c5324"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["More on Basis contraction.", "Text",
 CellChangeTimes->{{3.728662296961779*^9, 3.7286623058884783`*^9}},
 CellID->608198706,ExpressionUUID->"45cdac70-2586-456c-8eba-efb49ce35c18"],

Cell[CellGroupData[{

Cell["\<\
An important issue is when to contract Basis objects with other tensors and \
with one another:\
\>", "MathCaption",ExpressionUUID->"559dd06d-60d4-449f-9b2b-128865ba1876"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "/@", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "fred"}], "}"}]}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "blues"}]}], "}"}], ",", "a"}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "fred"}], "}"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "fred"}], "}"}]}], "]"}]}]}], "}"}], " "}]], "Input",\

 CellChangeTimes->{{3.728742860058667*^9, 3.728742874419442*^9}, {
   3.728747381119966*^9, 3.7287473925735693`*^9}, 3.728749291415968*^9},
 CellLabel->"In[90]:=",ExpressionUUID->"6c5caee3-0d93-45be-8241-a5e44aed8f86"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["b",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["c",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`c, -$CellContext`blues}, \
{$CellContext`b, $CellContext`fred}],
    Editable->False], ",", "1", ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "a"},
           {"c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`c, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.728662313013785*^9, 3.728671240050469*^9, 
  3.7286748873911037`*^9, 3.7287428752240343`*^9, 3.728743301518968*^9, 
  3.728743398029992*^9, 3.728747393028531*^9, 3.728749518736701*^9, 
  3.728749938816696*^9, 3.7287504133999643`*^9, 3.728750625119927*^9, 
  3.728750771428582*^9, 3.7287510600848627`*^9, 3.7287516261596737`*^9, 
  3.728813271597406*^9, 3.728827388638134*^9, 3.728835980381736*^9, 
  3.728836296874257*^9, 3.728843095585246*^9, 3.728845631255974*^9, 
  3.7333673687315693`*^9, 3.792273285377809*^9},
 CellLabel->"Out[90]=",
 CellID->1166833561,ExpressionUUID->"b96e7312-cc11-40be-a003-87053f5eefad"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "It would be desirable to automatize this behaviour sometimes. We can do it \
with the command ",
 StyleBox["AutomaticBasisContractionStart[]", "MR"],
 ":"
}], "MathCaption",ExpressionUUID->"ae04f47c-7779-45d2-a8ff-6c1756179d6c"],

Cell[TextData[{
 StyleBox["AutomaticBasisContractionStart\t\t", "DisplayMath"],
 StyleBox["Start automatic contraction of Basis objects", "Text"],
 StyleBox["\nAutomaticBasisContractionStop\t\t", "DisplayMath"],
 StyleBox["Stop automatic contraction of Basis objects", "Text"]
}], "DefinitionBox",ExpressionUUID->"3c54f885-109b-4734-90ee-89cccb8c4639"],

Cell[CellGroupData[{

Cell["Contraction of Basis objects.", "Text",
 CellChangeTimes->{
  3.728742883208961*^9},ExpressionUUID->"62a19e41-3d53-4baf-b6d8-\
2693966b5396"],

Cell[BoxData[
 RowBox[{"AutomaticBasisContractionStart", "[", "]"}]], "Input",
 CellLabel->"In[91]:=",ExpressionUUID->"c4f766fd-2ed4-4910-97f5-65ffeb5631e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "fred"}], "}"}]}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "blues"}]}], "}"}], ",", "a"}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "fred"}], "}"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "fred"}], "}"}]}], "]"}]}]}], "}"}], " "}]], "Input",\

 CellChangeTimes->{{3.72874289605062*^9, 3.7287429144335527`*^9}, {
   3.728747398240921*^9, 3.728747411348606*^9}, 3.728749292282937*^9},
 CellLabel->"In[92]:=",ExpressionUUID->"2fbe94f4-4d1b-4784-a55c-b1cbdd7c364b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["b",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["c",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`c, -$CellContext`blues}, \
{$CellContext`b, $CellContext`fred}],
    Editable->False], ",", "1", ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "a"},
           {"c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`c, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.728662324080068*^9, 3.728671240414238*^9, 3.7286748876006393`*^9, 
   3.72874291529953*^9, 3.728743301704653*^9, 3.728743398215102*^9, {
   3.728747412134615*^9, 3.72874741843577*^9}, 3.728749523401845*^9, 
   3.7287499390151997`*^9, 3.728750413683279*^9, 3.7287506281685247`*^9, 
   3.7287507718333397`*^9, 3.7287510602848253`*^9, 3.728751626368258*^9, 
   3.7288132717890663`*^9, 3.7288273889719877`*^9, 3.7288359806593246`*^9, 
   3.7288362970918016`*^9, 3.728843095875654*^9, 3.728845631464579*^9, 
   3.733367372285383*^9, 3.792273289425418*^9},
 CellLabel->"Out[92]=",
 CellID->2082240699,ExpressionUUID->"c3808519-8e25-4b73-a60c-6e99495e05b8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"AutomaticBasisContractionStop", "[", "]"}]], "Input",
 CellLabel->"In[93]:=",ExpressionUUID->"0af93778-d4a6-4e12-b277-a1c839f8ca7a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
When the contraction is between a Basis object and a different tensor, it is \
only performed if the former is a formal Kronecker delta or an identity \
tensor,\
\>", "MathCaption",ExpressionUUID->"5781a117-9b27-41d3-b919-37216dd0c452"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "b"}], "]"}], 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "fred"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "fred"}], "}"}]}], "]"}], " ", 
    RowBox[{"v", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "fred"}]}], "}"}], ",", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "blues"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "fred"}], "}"}]}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], "]"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.728742924855788*^9, 3.728742939776351*^9}, {
   3.728747422140414*^9, 3.72874744076338*^9}, 3.728749293139597*^9},
 CellLabel->"In[94]:=",ExpressionUUID->"c210dfb2-afb9-46f3-a745-60fff0813869"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`a, -$CellContext`c],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["a",
             FontColor->RGBColor[1., 0., 0.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{-$CellContext`a, -$CellContext`fred}],
    Editable->False], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", "b"},
            {
             StyleBox["a",
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`fred}, $CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {" "},
            {"b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[-$CellContext`b],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["b",
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["a",
              FontColor->RGBColor[0., 0., 1.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`blues}, \
{$CellContext`b, $CellContext`fred}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {" "},
            {
             StyleBox["b",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{-$CellContext`b, -$CellContext`fred}],
     Editable->False]}]}], "}"}]], "Output",
 CellChangeTimes->{3.728662327129163*^9, 3.728671240780653*^9, 
  3.72867488781712*^9, 3.728742940636722*^9, 3.72874330190103*^9, 
  3.7287433984302607`*^9, 3.728747441689652*^9, 3.7287495267160187`*^9, 
  3.728749939234132*^9, 3.728750413991691*^9, 3.728750630268087*^9, 
  3.728750772740086*^9, 3.728751060493637*^9, 3.7287516267009697`*^9, 
  3.7288132721199512`*^9, 3.728827389194763*^9, 3.728835980885695*^9, 
  3.728836297309002*^9, 3.728843096142869*^9, 3.72884563165425*^9, 
  3.733367374069059*^9, 3.792273291015128*^9},
 CellLabel->"Out[94]=",
 CellID->287309547,ExpressionUUID->"5cd7c505-3574-49db-8ba4-46d017cedfc2"]
}, Open  ]]
}, Open  ]],

Cell["\<\
To force the contraction in the last two cases we need a new function (next \
section). Notice how the third contraction is equivalent to expressing a \
tensor in its components and the fourth represents a basis change. \
\>", "MathCaption",ExpressionUUID->"afc732bd-e4d0-4f84-86fc-025f87d783b6"],

Cell["\<\
Basis formatting. We can define a special name  for the elements of one \
particular basis. \
\>", "Text",
 CellChangeTimes->{{3.728662341462467*^9, 
  3.728662344246704*^9}},ExpressionUUID->"97a4ad94-1860-4290-af3b-\
c6e824da2462"],

Cell[CellGroupData[{

Cell["Specify the format of a given basis vector object:", "MathCaption",
 CellChangeTimes->{{3.728742961958776*^9, 3.7287429757809553`*^9}},
 CellID->1298301299,ExpressionUUID->"d496bdab-0792-4b4d-9968-c0b15f004228"],

Cell[BoxData[
 RowBox[{"FormatBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "fred"}], "}"}], ",", "\"\<n\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.728742979741571*^9, 3.728742980046142*^9}, {
  3.72874744812201*^9, 3.7287474486828537`*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"642d0f71-619f-4f53-b444-a151fe89bc4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "fred"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "fred"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "fred"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "fred"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.728742982326457*^9, 3.7287429965416327`*^9}, {
  3.728747450468731*^9, 3.728747467026029*^9}, {3.7287492940733232`*^9, 
  3.728749294900197*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"f4b7b0ee-0d87-4a63-9e33-8eed6897eb48"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"n", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"n", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`blues}, {1, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`blues}, {2, $CellContext`fred}],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.728662346833909*^9, 3.728671240989102*^9, 3.728674888066058*^9, 
   3.728742997563932*^9, 3.72874330208559*^9, 3.7287433986190557`*^9, {
   3.728747467586706*^9, 3.728747495128203*^9}, 3.728749529597672*^9, 
   3.728749939431364*^9, 3.728750414184514*^9, 3.728750633389709*^9, 
   3.728750772991611*^9, 3.7287510607120113`*^9, 3.728751626869123*^9, 
   3.72881327243596*^9, 3.728827389444408*^9, 3.72883598111872*^9, 
   3.728836297506646*^9, 3.728843096936516*^9, 3.728845631857239*^9, 
   3.7333673773480673`*^9, 3.792273297396103*^9},
 CellLabel->"Out[96]=",
 CellID->672679339,ExpressionUUID->"6a19051b-3782-46e5-9dea-9304defd5093"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"FormatBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "fred"}], "}"}], ",", "\"\<l\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.728743005677487*^9, 3.7287430062692013`*^9}, {
  3.728747470513936*^9, 3.7287474710657673`*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"7a64673b-5605-4ea8-916c-bdfaed8ea27b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "fred"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "fred"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "fred"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "fred"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.728743009557383*^9, 3.728743024492346*^9}, {
  3.7287474765393057`*^9, 3.728747490056826*^9}, {3.7287492957987127`*^9, 
  3.7287492966769543`*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"de4efe2a-1ed1-42c8-99e1-d829a5090ffc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"n", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"l", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"n", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`blues}, {1, $CellContext`fred}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"l", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`blues}, {2, $CellContext`fred}],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7286623488675413`*^9, 3.728671241772698*^9, 3.728674888434207*^9, 
   3.728743025496443*^9, 3.728743302349186*^9, 3.7287433988530407`*^9, {
   3.72874749097241*^9, 3.728747496645485*^9}, 3.728749530797489*^9, 
   3.728749939741631*^9, 3.728750414392314*^9, 3.728750634553755*^9, 
   3.728750773241551*^9, 3.7287510609281187`*^9, 3.72875162703512*^9, 
   3.728813272666911*^9, 3.728827389745471*^9, 3.72883598136464*^9, 
   3.728836297707798*^9, 3.7288430977035923`*^9, 3.728845632046257*^9, 
   3.733367379081904*^9, 3.792273298566042*^9},
 CellLabel->"Out[98]=",
 CellID->565320818,ExpressionUUID->"141fdadf-d032-42ca-bbd2-df91a85cc813"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["We remove the special names:", "MathCaption",ExpressionUUID->"3961005f-d594-472d-a0a8-f641e0c1f219"],

Cell[BoxData[{
 RowBox[{"FormatBasis", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "fred"}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FormatBasis", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "fred"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.728743029074996*^9, 3.728743036323586*^9}, {
  3.728747504168293*^9, 3.7287475083840237`*^9}},
 CellLabel->"In[99]:=",ExpressionUUID->"c2d9f1d9-d136-44b0-8428-cecbe9730339"]
}, Open  ]],

Cell["Two more details.", "Text",
 CellChangeTimes->{{3.728662368726519*^9, 3.728662374908482*^9}},
 CellID->2035023769,ExpressionUUID->"1955df8b-2777-4c89-abe1-1b77490b65ad"],

Cell[CellGroupData[{

Cell["\<\
A bookkeeping detail: Basis is considered to be a tensor whose master is \
Symbol, so it cannot be undefined:\
\>", "MathCaption",
 CellChangeTimes->{{3.7286617212001247`*^9, 3.728661734072157*^9}},
 CellID->1177372917,ExpressionUUID->"d2ca40a6-8be7-49b9-90cc-ebe5e6d31bfa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTensorQ", "[", "Basis", "]"}]], "Input",
 CellLabel->"In[101]:=",
 CellID->1192292561,ExpressionUUID->"dac3c695-c2c7-4a8a-b803-c698bd4c3fa0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.7286616955645533`*^9, 3.728671241900662*^9, 
  3.728674888651722*^9, 3.728743045494307*^9, 3.728743302549265*^9, 
  3.7287433990652437`*^9, 3.728747512686635*^9, 3.728749533279435*^9, 
  3.7287499399755363`*^9, 3.728750414587826*^9, 3.7287506387111053`*^9, 
  3.728750773439419*^9, 3.728751061158033*^9, 3.7287516272106857`*^9, 
  3.728813272915758*^9, 3.7288273899838552`*^9, 3.7288359815849733`*^9, 
  3.7288362978935137`*^9, 3.7288430983555193`*^9, 3.7288456322616777`*^9, 
  3.733367382035584*^9, 3.792273304457622*^9},
 CellLabel->"Out[101]=",
 CellID->580559433,ExpressionUUID->"918b136f-d475-4861-99fb-967c71819511"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MasterOf", "[", "Basis", "]"}]], "Input",
 CellLabel->"In[102]:=",
 CellID->691162570,ExpressionUUID->"c69d5739-836b-4e1c-a08d-588bbde19b69"],

Cell[BoxData["Symbol"], "Output",
 CellChangeTimes->{3.728661696565592*^9, 3.72867124223378*^9, 
  3.72867488878331*^9, 3.728743046278872*^9, 3.728743302679347*^9, 
  3.72874339919886*^9, 3.728747513414658*^9, 3.728749533875742*^9, 
  3.728749940086069*^9, 3.728750414740555*^9, 3.728750639338141*^9, 
  3.7287507735903378`*^9, 3.728751061324078*^9, 3.728751627325673*^9, 
  3.7288132730366087`*^9, 3.728827390149475*^9, 3.7288359817429037`*^9, 
  3.7288362980439672`*^9, 3.728843098630637*^9, 3.72884563244127*^9, 
  3.7333673826018353`*^9, 3.79227330507928*^9},
 CellLabel->"Out[102]=",
 CellID->586231575,ExpressionUUID->"59bcfa76-d232-4b84-a09d-0dda13e0d380"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Basis", "MR"],
 " and ",
 StyleBox["Dir", "MR"],
 " act as inverses of each other"
}], "MathCaption",
 CellID->630267367,ExpressionUUID->"f2ae76fc-7560-46ee-a7b6-829e61f9f246"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dir", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "fred"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7287430500736017`*^9, 3.728743053387002*^9}, {
  3.7287475148399267`*^9, 3.72874751539183*^9}},
 CellLabel->"In[103]:=",
 CellID->1514290165,ExpressionUUID->"71005db8-5dd4-4d14-b9af-e20758159a12"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "fred"}], "}"}]], "Output",
 CellChangeTimes->{3.7286712427877703`*^9, 3.7286748889017677`*^9, 
  3.72874305416835*^9, 3.7287433028006697`*^9, 3.728743399331657*^9, 
  3.728747520300786*^9, 3.728749534893056*^9, 3.7287499402200117`*^9, 
  3.728750414874661*^9, 3.728750640581684*^9, 3.728750773737246*^9, 
  3.7287510614911346`*^9, 3.728751627465412*^9, 3.728813273171417*^9, 
  3.728827390294929*^9, 3.72883598189392*^9, 3.7288362981798697`*^9, 
  3.728843099069454*^9, 3.7288456326284037`*^9, 3.733367383635747*^9, 
  3.792273306151977*^9},
 CellLabel->"Out[103]=",
 CellID->1901460078,ExpressionUUID->"6483f584-b440-4cb1-a3c6-23150536e660"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"Dir", "[", 
    RowBox[{"v", "[", "a", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "fred"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728743055921344*^9, 3.728743057122847*^9}, {
  3.7287475170015182`*^9, 3.728747517463586*^9}},
 CellLabel->"In[104]:=",
 CellID->1956465519,ExpressionUUID->"a2eedcf1-0da5-400a-93c9-8ea6c4278b6d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{1, $CellContext`fred}],
  Editable->False]], "Output",
 CellChangeTimes->{3.72867124312745*^9, 3.728674889209538*^9, 
  3.728743058262854*^9, 3.728743302918087*^9, 3.728743399513651*^9, 
  3.7287475210435963`*^9, 3.72874953546037*^9, 3.728749940337488*^9, 
  3.728750415072947*^9, 3.7287506412380047`*^9, 3.728750774227255*^9, 
  3.728751061657795*^9, 3.72875162761244*^9, 3.72881327344273*^9, 
  3.72882739046871*^9, 3.728835982045106*^9, 3.7288362983163*^9, 
  3.7288430995530987`*^9, 3.728845632752743*^9, 3.733367384187002*^9, 
  3.792273306695842*^9},
 CellLabel->"Out[104]=",
 CellID->1729986636,ExpressionUUID->"9605cf6b-c627-400f-9946-e6ac066aa69d"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.3. Bases on inner bundles and complex bases", "Subsubsection",
 CellChangeTimes->{{3.728673439853546*^9, 
  3.728673440141943*^9}},ExpressionUUID->"ad588e59-8951-4a3e-ae93-\
8d65e3ea4266"],

Cell[TextData[{
 "Starting with version 0.9, ",
 StyleBox["xTensor`", "MR"],
 " is capable of dealing with complex tensors and vector bundles. The \
function ",
 StyleBox["DefBasis", "MR"],
 " has been extended accordingly to allow the user to define complex bases, \
through the option ",
 StyleBox["Dagger, ", "MR"],
 "taking the values ",
 StyleBox["Real", "MR"],
 " or ",
 StyleBox["Complex", "MR"],
 "."
}], "Text",
 CellChangeTimes->{{3.728662468554126*^9, 3.728662483048169*^9}, 
   3.728662515014694*^9},ExpressionUUID->"0358f8a9-76cc-4ae8-b6ae-\
4d70b6cd4a68"],

Cell[CellGroupData[{

Cell["A basis on a real vbundle is real by default:", "MathCaption",
 CellChangeTimes->{{3.728662501151197*^9, 3.7286625106152067`*^9}},
 CellID->2018963650,ExpressionUUID->"363948c7-d854-4309-8b3c-4c45d486a48c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "fred", "]"}]], "Input",
 CellChangeTimes->{{3.728743089450519*^9, 3.7287430898012342`*^9}, {
  3.728747537545662*^9, 3.728747538030662*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"116011f7-42f4-407e-b277-46c132541d53"],

Cell[BoxData["fred"], "Output",
 CellChangeTimes->{3.72867124692056*^9, 3.728674889482587*^9, 
  3.728743090679674*^9, 3.728743303036099*^9, 3.728743399699605*^9, 
  3.728747538465747*^9, 3.728749538569736*^9, 3.728749940452485*^9, 
  3.728750655066505*^9, 3.7287507776077757`*^9, 3.728751061818139*^9, 
  3.728751627727195*^9, 3.728813273728304*^9, 3.728827390610705*^9, 
  3.728835982189221*^9, 3.728836298446171*^9, 3.728843105674286*^9, 
  3.728845632931336*^9, 3.733367392634997*^9, 3.79227331397898*^9},
 CellLabel->"Out[105]=",
 CellID->1047717905,ExpressionUUID->"ca4e5d1f-ed96-45b4-b670-9efd0a82ca40"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
But let us see what happens when we define a basis on a complex bundle:\
\>", "MathCaption",
 CellChangeTimes->{{3.728662527157831*^9, 
  3.728662538510088*^9}},ExpressionUUID->"9fcdcbff-e456-4f29-a900-\
bb73000f05da"],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], "Input",
 CellLabel->
  "In[106]:=",ExpressionUUID->"6e4346ad-9575-41b4-8d31-d5fcedfe1699"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"fred", ",", "blues"}], "}"}]], "Output",
 CellChangeTimes->{3.728662535464829*^9, 3.728671247081367*^9, 
  3.728674889632959*^9, 3.7287430921335077`*^9, 3.728743303150292*^9, 
  3.728743399832601*^9, 3.72874754083609*^9, 3.728749540031995*^9, 
  3.728749940552361*^9, 3.728750656924406*^9, 3.728750777774437*^9, 
  3.728751061951644*^9, 3.728751627865032*^9, 3.728813273863812*^9, 
  3.728827390854671*^9, 3.7288359823345423`*^9, 3.728836298577326*^9, 
  3.728843105853525*^9, 3.7288456330477047`*^9, 3.73336739279274*^9, 
  3.7922733153777637`*^9},
 CellLabel->"Out[106]=",
 CellID->423408786,ExpressionUUID->"67d2a4c7-7224-45f3-a8c4-e2be128e51a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"fcomp", ",", "InnerC", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"+", "1"}]}], "}"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", " ", "Green"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.728743101663217*^9, {3.7287431841429234`*^9, 3.728743184995275*^9}, {
   3.728747543366444*^9, 3.728747544510332*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"1ab94e36-e437-4575-ba98-2bcc75ddb04f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "fcomp", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`fcomp, 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316016864*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->457973117,ExpressionUUID->"1fe6afb1-6fea-4550-b90b-9be5cd4a70b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDfcomp", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDfcomp[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316025237*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->572786571,ExpressionUUID->"f04e4bf4-9f57-4464-9ced-98b50742825e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDfcomp", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDfcomp[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.7922733160361347`*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->1802192943,ExpressionUUID->"907c69a4-1708-4938-9db6-bfada43db1fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDfcomp", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDfcomp[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.7922733160438967`*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->1347435713,ExpressionUUID->"a2f9a11a-b4d9-4715-bc6e-a335fbba43e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDfcomp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDfcomp[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316051384*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->1136970776,ExpressionUUID->"f37883bf-afd3-4da4-9162-78a3bff78891"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDfcomp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDfcomp[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316058969*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->758341226,ExpressionUUID->"2dd05365-f479-407b-9293-aa89f3c4b10b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDfcomp", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDfcomp[$CellContext`A, -$CellContext`b, -C], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316066289*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->125540437,ExpressionUUID->"89fc858c-e1d2-4591-94c7-2f7392997ed6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDfcomp\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDfcomp\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316073503*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->1129183305,ExpressionUUID->"29ef0b62-c1d3-4d21-a3ca-3b01a13cad7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDfcomp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDfcomp[-$CellContext`a, -$CellContext`b, -C, D], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316080656*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->870818596,ExpressionUUID->"f4e15e2e-bfd3-4a97-89c1-303eb6ba9bb7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDfcomp\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDfcomp\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316088019*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->747088667,ExpressionUUID->"9f04e2e3-b9b3-4946-a0f0-b8ac8bfed560"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", 
   "fcomp\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", 
   "basis ", $CellContext`fcomp\[Dagger], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316095182*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->2129825907,ExpressionUUID->"f251092d-e7c1-460a-a962-b24da7424004"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpfcomp", "[", 
    RowBox[{"A", ",", "B"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpfcomp[$CellContext`A, $CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.7922733161024857`*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->1726590753,ExpressionUUID->"a30acda1-8557-4aa1-9ef3-c2dafa6648b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpfcomp\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "B\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpfcomp\[Dagger][$CellContext`A\[Dagger], $CellContext`B\
\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316109995*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->2011747407,ExpressionUUID->"06551c1b-5de5-495f-bbde-b719b93b5835"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownfcomp", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownfcomp[-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.792273316117756*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->1456131081,ExpressionUUID->"a4c6dfa7-f6b5-42f5-89d3-0ec85a88d69b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownfcomp\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownfcomp\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662543911641*^9, 3.728671247284732*^9, 
  3.728674889773672*^9, 3.728743103159237*^9, 3.728743303269644*^9, 
  3.728743399965954*^9, 3.7287475449351387`*^9, 3.728749540708436*^9, 
  3.7287499406822033`*^9, 3.728750777972083*^9, 3.7287510620820227`*^9, 
  3.7287516279936934`*^9, 3.728813274031293*^9, 3.728827391107604*^9, 
  3.728835982479816*^9, 3.728836298736219*^9, 3.728843106132284*^9, 
  3.7288456331746893`*^9, 3.7333673929673634`*^9, 3.7922733161252613`*^9},
 CellLabel->"During evaluation of In[107]:=",
 CellID->471437155,ExpressionUUID->"232a1dd5-83a2-4ef5-9b78-2969fe6ecd84"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], "Input",
 CellLabel->
  "In[108]:=",ExpressionUUID->"f096b0d0-eb4b-4c4a-90ca-80a3e343c1ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"fred", ",", "blues", ",", "fcomp", ",", "fcomp\[Dagger]"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.728662545449069*^9, 3.7286712476994133`*^9, 
  3.728674890334281*^9, 3.72874310587364*^9, 3.72874330368539*^9, 
  3.7287434003972397`*^9, 3.7287475470835943`*^9, 3.728749542759932*^9, 
  3.728749940948069*^9, 3.7287507784555483`*^9, 3.728751062512973*^9, 
  3.728751628343998*^9, 3.728813274366044*^9, 3.728827391512039*^9, 
  3.7288359829991837`*^9, 3.728836299135511*^9, 3.728843106974292*^9, 
  3.7288456339592543`*^9, 3.733367393354104*^9, 3.792273317094853*^9},
 CellLabel->"Out[108]=",
 CellID->1466307460,ExpressionUUID->"7fb28bc8-daaa-4dee-9c4e-755017aafaf8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A conjugate basis has also appeared on the conjugate manifold:\
\>", "MathCaption",ExpressionUUID->"48eceb47-8d82-4491-9731-a9bb32511f7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "/@", 
  RowBox[{"{", 
   RowBox[{"fcomp", ",", "fcomp\[Dagger]"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.728743118302342*^9, 3.7287431238460617`*^9}, {
  3.728747556285782*^9, 3.728747559565571*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"8e18fc1a-a81f-41ee-b09f-83a64b62a11e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"fcomp\[Dagger]", ",", "fcomp"}], "}"}]], "Output",
 CellChangeTimes->{3.728662554682727*^9, 3.728671247847705*^9, 
  3.7286748904856*^9, 3.728743124777381*^9, 3.728743303870226*^9, 
  3.728743400529509*^9, 3.728747559969225*^9, 3.7287495440568943`*^9, 
  3.728749941091353*^9, 3.7287507787583*^9, 3.728751062666411*^9, 
  3.728751628481544*^9, 3.728813274516375*^9, 3.7288273916617737`*^9, 
  3.7288359831446457`*^9, 3.728836299305315*^9, 3.728843107672044*^9, 
  3.728845634178636*^9, 3.733367393604959*^9, 3.792273318518443*^9},
 CellLabel->"Out[109]=",
 CellID->922155191,ExpressionUUID->"0230dce8-6f63-485a-b7b2-737fcb3524aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VBundleOfBasis", "/@", 
  RowBox[{"{", 
   RowBox[{"fcomp", ",", "fcomp\[Dagger]"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.728743129093815*^9, 3.728743131365672*^9}, {
  3.7287475628694*^9, 3.728747567301271*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"0b33ed36-0ed6-4b22-bfd8-24aa09f7868d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox["InnerC",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC,
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["InnerC\[Dagger]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC\[Dagger],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.72866255575674*^9, 3.728671247996912*^9, 
  3.728674890636238*^9, 3.728743131938429*^9, 3.728743303986672*^9, 
  3.7287434006464243`*^9, 3.7287475676011744`*^9, 3.728749544644074*^9, 
  3.728749941277614*^9, 3.72875077894623*^9, 3.728751062795731*^9, 
  3.728751628614292*^9, 3.7288132746642027`*^9, 3.728827391834931*^9, 
  3.7288359832967577`*^9, 3.728836299441401*^9, 3.728843107915455*^9, 
  3.72884563434454*^9, 3.7333673938364067`*^9, 3.792273319046935*^9},
 CellLabel->"Out[110]=",
 CellID->1233431399,ExpressionUUID->"bddbd679-9d17-4954-a94c-53dcc07bedcb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Notice how negative cnumbers do not denote covariant indices:\
\>", "MathCaption",ExpressionUUID->"fad86ace-6ac0-438b-90ff-51ac842864bd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "fcomp"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "fcomp\[Dagger]"}], "}"}]}], "]"}]}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.728743139190913*^9, 3.7287431419094763`*^9}, {
  3.728747570485351*^9, 3.728747574565057*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"5f4077eb-97ac-4911-aeb8-548b4e7365c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox[
             RowBox[{"-", "1"}],
             FontColor->RGBColor[0., 1., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {-1, $CellContext`fcomp}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox[
             RowBox[{"-", "1"}],
             FontColor->RGBColor[0., 1., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {-1, $CellContext`fcomp\[Dagger]}],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.728662561074698*^9, 3.72867124819037*^9, 
  3.72867489081181*^9, 3.7287431425161877`*^9, 3.7287433041026773`*^9, 
  3.7287434007634573`*^9, 3.7287475748662577`*^9, 3.728749547061842*^9, 
  3.728749941431819*^9, 3.728750779102298*^9, 3.728751062951744*^9, 
  3.728751628788262*^9, 3.728813274800503*^9, 3.728827392297591*^9, 
  3.7288359834615097`*^9, 3.7288362996033573`*^9, 3.728843108115877*^9, 
  3.72884563451518*^9, 3.7333673940040913`*^9, 3.7922733212005463`*^9},
 CellLabel->"Out[111]=",
 CellID->400987425,ExpressionUUID->"abf35b60-cdb0-421f-bde7-d59c5d7dec6e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The basis objects of both bases look the same, because ", "MathCaption",ExpressionUUID->"aec10345-992f-4fb8-8bd2-a8516d0afd05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "Basis", "]"}]], "Input",
 CellLabel->
  "In[112]:=",ExpressionUUID->"e8d7e545-e76e-49fd-aeff-5c74e2b64b91"],

Cell[BoxData["Basis"], "Output",
 CellChangeTimes->{3.728662570374631*^9, 3.72867124834468*^9, 
  3.728674890951342*^9, 3.7287431504622087`*^9, 3.728743304218072*^9, 
  3.728743400896872*^9, 3.728747576999234*^9, 3.728749548144659*^9, 
  3.728749941565023*^9, 3.7287507792485857`*^9, 3.72875106307299*^9, 
  3.728751628986322*^9, 3.728813275033065*^9, 3.7288273925626917`*^9, 
  3.72883598361465*^9, 3.728836299775648*^9, 3.728843108349691*^9, 
  3.728845634680299*^9, 3.733367394154217*^9, 3.792273322904826*^9},
 CellLabel->"Out[112]=",
 CellID->862925962,ExpressionUUID->"4d52fca8-9aca-40a2-bb98-9bbfe18442ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "fcomp"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.728743157901415*^9, {3.7287475791568823`*^9, 3.728747580316689*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"cc27bc8f-e58e-4c31-8834-5742d763e399"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox[
           RowBox[{"-", "1"}],
           FontColor->RGBColor[0., 1., 0.]]},
         {"a", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[-$CellContext`a, {-1, $CellContext`fcomp\[Dagger]}],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728662571365798*^9, 3.728671248478361*^9, 3.7286748911839848`*^9, {
   3.728743153464117*^9, 3.728743158467505*^9}, 3.7287433043362207`*^9, 
   3.728743401015444*^9, 3.728747580817154*^9, 3.728749548761578*^9, 
   3.728749941703971*^9, 3.728750779402073*^9, 3.728751063216125*^9, 
   3.728751629133195*^9, 3.728813275283862*^9, 3.7288273926952143`*^9, 
   3.728835983777828*^9, 3.728836299922529*^9, 3.728843108898394*^9, 
   3.728845634864781*^9, 3.733367394403808*^9, 3.7922733234006033`*^9},
 CellLabel->"Out[113]=",
 CellID->1859674700,ExpressionUUID->"ed9ba09d-085e-42cb-8b14-4b30ac14095c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[114]:=",ExpressionUUID->"e84e2d6c-619b-4f6e-aa83-69e0a2ed03d7"],

Cell["Basis[-a, {-1, fcomp\[Dagger]}]", "Output",
 CellChangeTimes->{3.728662572752851*^9, 3.728671248818705*^9, 
  3.728674891300931*^9, 3.728743159865275*^9, 3.728743304452919*^9, 
  3.728743401147974*^9, 3.728747583006897*^9, 3.7287495493685217`*^9, 
  3.7287499418338947`*^9, 3.728750779532933*^9, 3.7287510633490334`*^9, 
  3.72875162926143*^9, 3.7288132754474287`*^9, 3.728827392844061*^9, 
  3.728835983922563*^9, 3.72883630007096*^9, 3.7288431091977577`*^9, 
  3.728845635030485*^9, 3.733367394686515*^9, 3.792273324951456*^9},
 CellLabel->"Out[114]//InputForm=",
 CellID->1593238590,ExpressionUUID->"1647086e-e1f9-4937-bf8d-073506ad91da"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "and their cnumbers are also defined to be the same. This can be changed, \
with the new function ",
 StyleBox["DaggerBCIndex. ", "MR"],
 "Remember how in ",
 StyleBox["xTensor`", "MR"],
 " the conjugates of indices were given by "
}], "MathCaption",
 CellChangeTimes->{
  3.7287431704520893`*^9},ExpressionUUID->"1de26540-5893-43fa-820e-\
af6c3d3d8df5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaggerIndex", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "A", ",", "B"}], "}"}]}]], "Input",
 CellLabel->
  "In[115]:=",ExpressionUUID->"c3bdfedb-e251-433b-8db0-dabdca1732d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "A\[Dagger]", ",", "B\[Dagger]"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.728662585419776*^9, 3.728671249404047*^9, 
  3.728674891436489*^9, 3.728743162099724*^9, 3.728743304585217*^9, 
  3.7287434012634363`*^9, 3.728747585533781*^9, 3.7287495506050243`*^9, 
  3.728749941953538*^9, 3.72875077965828*^9, 3.728751063496058*^9, 
  3.7287516294149303`*^9, 3.728813275695641*^9, 3.728827392996203*^9, 
  3.728835984078121*^9, 3.728836300227271*^9, 3.728843109417149*^9, 
  3.728845635230579*^9, 3.7333673948859463`*^9, 3.792273327512177*^9},
 CellLabel->"Out[115]=",
 CellID->1702226930,ExpressionUUID->"a80ca744-ea41-4a25-a079-4c9d3637d6bd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "But we cannot change the definition associated to ",
 StyleBox["DaggerIndex[{1,fcomp}]", "MR"],
 ",  because ",
 StyleBox["complex", "MR"],
 " is too deep to be given an upvalue. Let us see how we can use  ",
 StyleBox["DaggerCIndex", "MR"],
 " to solve this with an example. We want to complexify a real basis:"
}], "MathCaption",
 CellChangeTimes->{{3.7287475934042387`*^9, 
  3.7287475973957453`*^9}},ExpressionUUID->"22b71b56-9c3d-4ee4-a1c7-\
04b8a788662e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"test", ",", "TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[116]:=",ExpressionUUID->"8695ff25-fb91-4c86-b442-70e743784f59"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "test", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`test, 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662591992484*^9, 3.728671249713957*^9, 
  3.7286748915900917`*^9, 3.7287432021954117`*^9, 3.7287433047520227`*^9, 
  3.728743401381711*^9, 3.72874760149131*^9, 3.728749551841444*^9, 
  3.728749942084701*^9, 3.728750779964903*^9, 3.72875106364469*^9, 
  3.728751629543634*^9, 3.728813276110716*^9, 3.728827393136383*^9, 
  3.728835984227166*^9, 3.728836300381048*^9, 3.728843109666819*^9, 
  3.728845635421936*^9, 3.733367395051529*^9, 3.79227332979818*^9},
 CellLabel->"During evaluation of In[116]:=",
 CellID->1921187312,ExpressionUUID->"b201662e-eebe-4b95-85a6-ec15854e888b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDtest", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDtest[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662591992484*^9, 3.728671249713957*^9, 
  3.7286748915900917`*^9, 3.7287432021954117`*^9, 3.7287433047520227`*^9, 
  3.728743401381711*^9, 3.72874760149131*^9, 3.728749551841444*^9, 
  3.728749942084701*^9, 3.728750779964903*^9, 3.72875106364469*^9, 
  3.728751629543634*^9, 3.728813276110716*^9, 3.728827393136383*^9, 
  3.728835984227166*^9, 3.728836300381048*^9, 3.728843109666819*^9, 
  3.728845635421936*^9, 3.733367395051529*^9, 3.79227332981013*^9},
 CellLabel->"During evaluation of In[116]:=",
 CellID->1978520139,ExpressionUUID->"a0fa3a78-07ed-4240-9c37-9cd7be9ba9d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDtest", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDtest[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662591992484*^9, 3.728671249713957*^9, 
  3.7286748915900917`*^9, 3.7287432021954117`*^9, 3.7287433047520227`*^9, 
  3.728743401381711*^9, 3.72874760149131*^9, 3.728749551841444*^9, 
  3.728749942084701*^9, 3.728750779964903*^9, 3.72875106364469*^9, 
  3.728751629543634*^9, 3.728813276110716*^9, 3.728827393136383*^9, 
  3.728835984227166*^9, 3.728836300381048*^9, 3.728843109666819*^9, 
  3.728845635421936*^9, 3.733367395051529*^9, 3.792273329824707*^9},
 CellLabel->"During evaluation of In[116]:=",
 CellID->1351186025,ExpressionUUID->"0f147443-fec2-47dc-b334-fca4e7f13c3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDtest", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDtest[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662591992484*^9, 3.728671249713957*^9, 
  3.7286748915900917`*^9, 3.7287432021954117`*^9, 3.7287433047520227`*^9, 
  3.728743401381711*^9, 3.72874760149131*^9, 3.728749551841444*^9, 
  3.728749942084701*^9, 3.728750779964903*^9, 3.72875106364469*^9, 
  3.728751629543634*^9, 3.728813276110716*^9, 3.728827393136383*^9, 
  3.728835984227166*^9, 3.728836300381048*^9, 3.728843109666819*^9, 
  3.728845635421936*^9, 3.733367395051529*^9, 3.7922733298319798`*^9},
 CellLabel->"During evaluation of In[116]:=",
 CellID->1891438797,ExpressionUUID->"1e0eaa49-6100-47bc-aa3c-a60e317716fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDtest", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDtest[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662591992484*^9, 3.728671249713957*^9, 
  3.7286748915900917`*^9, 3.7287432021954117`*^9, 3.7287433047520227`*^9, 
  3.728743401381711*^9, 3.72874760149131*^9, 3.728749551841444*^9, 
  3.728749942084701*^9, 3.728750779964903*^9, 3.72875106364469*^9, 
  3.728751629543634*^9, 3.728813276110716*^9, 3.728827393136383*^9, 
  3.728835984227166*^9, 3.728836300381048*^9, 3.728843109666819*^9, 
  3.728845635421936*^9, 3.733367395051529*^9, 3.79227332983949*^9},
 CellLabel->"During evaluation of In[116]:=",
 CellID->211434638,ExpressionUUID->"ddf3c89c-36f6-4c37-863e-a1d366313c2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDtest", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDtest[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662591992484*^9, 3.728671249713957*^9, 
  3.7286748915900917`*^9, 3.7287432021954117`*^9, 3.7287433047520227`*^9, 
  3.728743401381711*^9, 3.72874760149131*^9, 3.728749551841444*^9, 
  3.728749942084701*^9, 3.728750779964903*^9, 3.72875106364469*^9, 
  3.728751629543634*^9, 3.728813276110716*^9, 3.728827393136383*^9, 
  3.728835984227166*^9, 3.728836300381048*^9, 3.728843109666819*^9, 
  3.728845635421936*^9, 3.733367395051529*^9, 3.792273329847333*^9},
 CellLabel->"During evaluation of In[116]:=",
 CellID->1644008728,ExpressionUUID->"73e3eab5-ce14-4da6-926a-c17ef6a89f9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUptest", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUptest[$CellContext`a, $CellContext`b, $CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662591992484*^9, 3.728671249713957*^9, 
  3.7286748915900917`*^9, 3.7287432021954117`*^9, 3.7287433047520227`*^9, 
  3.728743401381711*^9, 3.72874760149131*^9, 3.728749551841444*^9, 
  3.728749942084701*^9, 3.728750779964903*^9, 3.72875106364469*^9, 
  3.728751629543634*^9, 3.728813276110716*^9, 3.728827393136383*^9, 
  3.728835984227166*^9, 3.728836300381048*^9, 3.728843109666819*^9, 
  3.728845635421936*^9, 3.733367395051529*^9, 3.792273329854677*^9},
 CellLabel->"During evaluation of In[116]:=",
 CellID->1330089194,ExpressionUUID->"fe01269b-06ca-4693-bffe-6dda69c1177e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDowntest", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDowntest[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662591992484*^9, 3.728671249713957*^9, 
  3.7286748915900917`*^9, 3.7287432021954117`*^9, 3.7287433047520227`*^9, 
  3.728743401381711*^9, 3.72874760149131*^9, 3.728749551841444*^9, 
  3.728749942084701*^9, 3.728750779964903*^9, 3.72875106364469*^9, 
  3.728751629543634*^9, 3.728813276110716*^9, 3.728827393136383*^9, 
  3.728835984227166*^9, 3.728836300381048*^9, 3.728843109666819*^9, 
  3.728845635421936*^9, 3.733367395051529*^9, 3.792273329861988*^9},
 CellLabel->"During evaluation of In[116]:=",
 CellID->1651801935,ExpressionUUID->"f2ff2998-b67c-42f3-aec8-034a8fa6a80d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DaggerCIndex"}]], "Input",
 CellLabel->
  "In[117]:=",ExpressionUUID->"33bacd2f-f679-4de7-812e-cc96471a0dd4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DaggerCIndex[basis, cindex] returns the conjugated \
index to the cindex (assumed to belong to basis or -basis), in general a Dir \
expression. This function should be handled through upvalues for basis.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"DaggerCIndex", "[", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DaggerCIndex", "::", "argrx"}], "MessageName"], 
                    ",", "DaggerCIndex", ",", "0", ",", "2"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xCoba`Private`basis_"}], ",", 
                    "xAct`xCoba`Private`cindex_"}], "]"}], ":=", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{
                    "xAct`xCoba`Private`basis", ",", 
                    "xAct`xCoba`Private`cindex"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"_", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "xAct`xCoba`Private`a_Integer", ",", 
                    "xAct`xCoba`Private`basis_"}], "}"}]}], "]"}], ":=", 
                    RowBox[{"{", 
                    RowBox[{"xAct`xCoba`Private`a", ",", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", "xAct`xCoba`Private`basis", "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[xAct`xCoba`Private`basis],
                    Editable->False]}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"_", ",", 
                    RowBox[{
                    RowBox[{"xAct`xCoba`Private`basis_", "?", "BasisQ"}], "[",
                     "xAct`xCoba`Private`a_Integer", "]"}]}], "]"}], ":=", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", "xAct`xCoba`Private`basis", "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[xAct`xCoba`Private`basis],
                    Editable->False], "[", "xAct`xCoba`Private`a", "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DaggerCIndex", "[", "_", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DaggerCIndex", "::", "argr"}], "MessageName"], 
                    ",", "DaggerCIndex", ",", "2"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"_", ",", "_", ",", "xAct`xCore`Private`x__"}], 
                    "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DaggerCIndex", "::", "argrx"}], "MessageName"], 
                    ",", "DaggerCIndex", ",", 
                    RowBox[{"2", "+", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xCore`Private`x", "}"}], "]"}]}], ",", 
                    "2"}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`DaggerCIndex\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DaggerCIndex[basis, cindex] returns the conjugated \
index to the cindex (assumed to belong to basis or -basis), in general a Dir \
expression. This function should be handled through upvalues for basis.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {2., 8.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {2., 8.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "DaggerCIndex[basis, cindex] returns the conjugated index to the cindex \
(assumed to belong to basis or -basis), in general a Dir expression. This \
function should be handled through upvalues for basis.", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xCoba`DaggerCIndex, {
      xAct`xCoba`DaggerCIndex[] :> Message[
         MessageName[xAct`xCoba`DaggerCIndex, "argrx"], 
         xAct`xCoba`DaggerCIndex, 0, 2], 
       xAct`xCoba`DaggerCIndex[-Pattern[xAct`xCoba`Private`basis, 
           Blank[]], 
         Pattern[xAct`xCoba`Private`cindex, 
          Blank[]]] :> 
       xAct`xCoba`DaggerCIndex[
        xAct`xCoba`Private`basis, xAct`xCoba`Private`cindex], 
       xAct`xCoba`DaggerCIndex[
         Blank[], {
          Pattern[xAct`xCoba`Private`a, 
           Blank[Integer]], 
          Pattern[xAct`xCoba`Private`basis, 
           Blank[]]}] :> {xAct`xCoba`Private`a, 
         xAct`xTensor`Dagger[xAct`xCoba`Private`basis]}, 
       xAct`xCoba`DaggerCIndex[
         Blank[], 
         PatternTest[
          Pattern[xAct`xCoba`Private`basis, 
           Blank[]], xAct`xTensor`BasisQ][
          Pattern[xAct`xCoba`Private`a, 
           Blank[Integer]]]] :> 
       xAct`xTensor`Dagger[xAct`xCoba`Private`basis][xAct`xCoba`Private`a], 
       xAct`xCoba`DaggerCIndex[
         Blank[]] :> Message[
         MessageName[xAct`xCoba`DaggerCIndex, "argr"], 
         xAct`xCoba`DaggerCIndex, 2], xAct`xCoba`DaggerCIndex[
         Blank[], 
         Blank[], 
         Pattern[xAct`xCore`Private`x, 
          BlankSequence[]]] :> Message[
         MessageName[xAct`xCoba`DaggerCIndex, "argrx"], 
         xAct`xCoba`DaggerCIndex, 2 + Length[{xAct`xCore`Private`x}], 2]}], 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "xAct`xCoba`DaggerCIndex"], False]]], "Output",
 CellChangeTimes->{3.792273331301209*^9},
 CellLabel->"Out[117]=",
 CellID->1287333306,ExpressionUUID->"70d492b0-9c07-41e9-bb22-859d844a16e4"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "test"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "test"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "test"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "test"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->
  "In[118]:=",ExpressionUUID->"6990f634-9fbb-423e-90c8-0366ca3959de"]
}, Open  ]],

Cell[CellGroupData[{

Cell["And now:", "MathCaption",
 CellChangeTimes->{
  3.728662597786602*^9},ExpressionUUID->"2a3e7300-524a-47ae-9d03-\
2d4426b648ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "test"}], "}"}]}], "]"}], ",", 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "test"}]}], "}"}], ",", "a"}], "]"}]}], "}"}]}]], "Input",\

 CellLabel->
  "In[122]:=",ExpressionUUID->"5107a35c-cee4-4852-bf67-585e2e2e102e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`test}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`test}, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.728662598929804*^9, 3.728671250398526*^9, 
  3.7286748922505074`*^9, 3.7287432100997057`*^9, 3.728743305752893*^9, 
  3.728743402025063*^9, 3.728747606352209*^9, 3.728749555598225*^9, 
  3.728749942675518*^9, 3.7287507816376953`*^9, 3.72875106419559*^9, 
  3.7287516300940447`*^9, 3.728813276826453*^9, 3.728827393745614*^9, 
  3.728835985106072*^9, 3.728836300995817*^9, 3.728843110882763*^9, 
  3.7288456360833893`*^9, 3.73336739581744*^9, 3.79227333626521*^9},
 CellLabel->"Out[122]=",
 CellID->1835792792,ExpressionUUID->"a7a6821f-d72a-4815-aced-d68b5a5658b7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
If we define a complex tensor on M3 we can see that this works\
\>", "MathCaption",ExpressionUUID->"c74d384d-0b63-428c-a277-971b4d88f69b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"J", "[", "a", "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", " ", "Complex"}]}], "]"}]], "Input",
 CellLabel->
  "In[123]:=",ExpressionUUID->"346fa2a8-49aa-40ec-8727-9793e6fab7f1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"J", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`J[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662600651246*^9, 3.7286712505475492`*^9, 
  3.728674892384047*^9, 3.728743213731908*^9, 3.728743305884169*^9, 
  3.728743402150305*^9, 3.728747608346651*^9, 3.7287495566299047`*^9, 
  3.728749942865288*^9, 3.7287507817918*^9, 3.728751064345154*^9, 
  3.728751630278948*^9, 3.7288132771157017`*^9, 3.728827393962731*^9, 
  3.7288359852176743`*^9, 3.728836301138102*^9, 3.728843111289583*^9, 
  3.728845636251433*^9, 3.733367395952888*^9, 3.792273338129738*^9},
 CellLabel->"During evaluation of In[123]:=",
 CellID->1706961440,ExpressionUUID->"28e6af69-97a6-4888-ad68-8277aba051bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"J\[Dagger]", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`J\[Dagger][$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728662600651246*^9, 3.7286712505475492`*^9, 
  3.728674892384047*^9, 3.728743213731908*^9, 3.728743305884169*^9, 
  3.728743402150305*^9, 3.728747608346651*^9, 3.7287495566299047`*^9, 
  3.728749942865288*^9, 3.7287507817918*^9, 3.728751064345154*^9, 
  3.728751630278948*^9, 3.7288132771157017`*^9, 3.728827393962731*^9, 
  3.7288359852176743`*^9, 3.728836301138102*^9, 3.728843111289583*^9, 
  3.728845636251433*^9, 3.733367395952888*^9, 3.792273338138747*^9},
 CellLabel->"During evaluation of In[123]:=",
 CellID->666881807,ExpressionUUID->"014c562f-73b8-4614-b07b-5e8df844cb66"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"J", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "test"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[124]:=",ExpressionUUID->"9ca6c30f-993a-40e0-b2e8-04159f7b92ff"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"J\[Dagger]", 
      StyleBox[GridBox[{
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`J\[Dagger][{1, $CellContext`test}],
  Editable->False]], "Output",
 CellChangeTimes->{3.7286626015496798`*^9, 3.7286712511715803`*^9, 
  3.728674892555069*^9, 3.728743214899925*^9, 3.728743306068276*^9, 
  3.728743402346798*^9, 3.728747609319138*^9, 3.728749557196179*^9, 
  3.728749943034581*^9, 3.728750782293539*^9, 3.728751064541338*^9, 
  3.7287516304494267`*^9, 3.72881327728329*^9, 3.728827394227569*^9, 
  3.728835985382608*^9, 3.728836301305984*^9, 3.7288431119524117`*^9, 
  3.728845636465294*^9, 3.73336739646026*^9, 3.792273338697386*^9},
 CellLabel->"Out[124]=",
 CellID->2138518791,ExpressionUUID->"20064156-7601-419d-b885-3c07ebe18bea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We can even establish more complicated relations, if we remember that Basis \
and Dir act as inverses of each other\
\>", "MathCaption",ExpressionUUID->"b998c5c5-aab8-4ba3-aca9-9822439a4e2d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"Dir", "[", 
    RowBox[{"I", " ", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "test"}], "}"}]}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"Dir", "[", 
    RowBox[{"I", " ", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "test"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->
  "In[125]:=",ExpressionUUID->"f29c6c77-f41d-452f-af3e-304caf504daa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"J", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "test"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[127]:=",ExpressionUUID->"40b02f95-2a4e-48df-86a9-6cadabd90bd2"],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"J\[Dagger]", 
       StyleBox[GridBox[{
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`J\[Dagger][{1, $CellContext`test}],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728662603705291*^9, 3.728671251553388*^9, 
  3.728674892757125*^9, 3.728743219134955*^9, 3.728743306345037*^9, 
  3.728743402515512*^9, 3.728747611694564*^9, 3.72874955877943*^9, 
  3.72874994321653*^9, 3.7287507827941303`*^9, 3.728751064896092*^9, 
  3.728751630773662*^9, 3.7288132774823914`*^9, 3.728827394411394*^9, 
  3.728835985554162*^9, 3.72883630152188*^9, 3.728843113003737*^9, 
  3.7288456366992683`*^9, 3.733367396668973*^9, 3.7922733404328003`*^9},
 CellLabel->"Out[127]=",
 CellID->711058643,ExpressionUUID->"3947039e-d028-4533-b693-5b72b9db7ef1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefBasis", "[", "test", "]"}], ";"}]], "Input",
 CellLabel->
  "In[128]:=",ExpressionUUID->"ac129649-f83e-453c-babf-02995386158b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDtest],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286626045098763`*^9, 3.728671251705339*^9, 
  3.728674892884242*^9, 3.728743220050411*^9, 3.7287433065214567`*^9, 
  3.7287434026481123`*^9, 3.728747612287574*^9, 3.728749559360145*^9, 
  3.728749943353883*^9, 3.728750782957477*^9, 3.728751065067802*^9, 
  3.728751630893968*^9, 3.728813277649822*^9, 3.728827394546196*^9, 
  3.7288359856773148`*^9, 3.7288363016877937`*^9, 3.7288431132055492`*^9, 
  3.728845636847151*^9, 3.7333673968064833`*^9, 3.792273341556437*^9},
 CellLabel->"During evaluation of In[128]:=",
 CellID->1866498034,ExpressionUUID->"c36167c3-2d5a-42ae-8ed3-44c817f6f55f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDtest],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286626045098763`*^9, 3.728671251705339*^9, 
  3.728674892884242*^9, 3.728743220050411*^9, 3.7287433065214567`*^9, 
  3.7287434026481123`*^9, 3.728747612287574*^9, 3.728749559360145*^9, 
  3.728749943353883*^9, 3.728750782957477*^9, 3.728751065067802*^9, 
  3.728751630893968*^9, 3.728813277649822*^9, 3.728827394546196*^9, 
  3.7288359856773148`*^9, 3.7288363016877937`*^9, 3.7288431132055492`*^9, 
  3.728845636847151*^9, 3.7333673968064833`*^9, 3.7922733415684547`*^9},
 CellLabel->"During evaluation of In[128]:=",
 CellID->1938825709,ExpressionUUID->"7097503f-b615-40d6-b6e3-38ca750d199a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDtest],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286626045098763`*^9, 3.728671251705339*^9, 
  3.728674892884242*^9, 3.728743220050411*^9, 3.7287433065214567`*^9, 
  3.7287434026481123`*^9, 3.728747612287574*^9, 3.728749559360145*^9, 
  3.728749943353883*^9, 3.728750782957477*^9, 3.728751065067802*^9, 
  3.728751630893968*^9, 3.728813277649822*^9, 3.728827394546196*^9, 
  3.7288359856773148`*^9, 3.7288363016877937`*^9, 3.7288431132055492`*^9, 
  3.728845636847151*^9, 3.7333673968064833`*^9, 3.7922733415826263`*^9},
 CellLabel->"During evaluation of In[128]:=",
 CellID->2074315232,ExpressionUUID->"4c7f35cd-420f-4809-800a-abb39e54752e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDtest],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286626045098763`*^9, 3.728671251705339*^9, 
  3.728674892884242*^9, 3.728743220050411*^9, 3.7287433065214567`*^9, 
  3.7287434026481123`*^9, 3.728747612287574*^9, 3.728749559360145*^9, 
  3.728749943353883*^9, 3.728750782957477*^9, 3.728751065067802*^9, 
  3.728751630893968*^9, 3.728813277649822*^9, 3.728827394546196*^9, 
  3.7288359856773148`*^9, 3.7288363016877937`*^9, 3.7288431132055492`*^9, 
  3.728845636847151*^9, 3.7333673968064833`*^9, 3.792273341589675*^9},
 CellLabel->"During evaluation of In[128]:=",
 CellID->766578826,ExpressionUUID->"f861fcff-37b1-4048-9d3e-d264b52c6d15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDtest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDtest],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286626045098763`*^9, 3.728671251705339*^9, 
  3.728674892884242*^9, 3.728743220050411*^9, 3.7287433065214567`*^9, 
  3.7287434026481123`*^9, 3.728747612287574*^9, 3.728749559360145*^9, 
  3.728749943353883*^9, 3.728750782957477*^9, 3.728751065067802*^9, 
  3.728751630893968*^9, 3.728813277649822*^9, 3.728827394546196*^9, 
  3.7288359856773148`*^9, 3.7288363016877937`*^9, 3.7288431132055492`*^9, 
  3.728845636847151*^9, 3.7333673968064833`*^9, 3.792273341596857*^9},
 CellLabel->"During evaluation of In[128]:=",
 CellID->1135930229,ExpressionUUID->"2ad2bbb2-1fd7-466f-b734-af4e57cc52e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUptest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUptest],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286626045098763`*^9, 3.728671251705339*^9, 
  3.728674892884242*^9, 3.728743220050411*^9, 3.7287433065214567`*^9, 
  3.7287434026481123`*^9, 3.728747612287574*^9, 3.728749559360145*^9, 
  3.728749943353883*^9, 3.728750782957477*^9, 3.728751065067802*^9, 
  3.728751630893968*^9, 3.728813277649822*^9, 3.728827394546196*^9, 
  3.7288359856773148`*^9, 3.7288363016877937`*^9, 3.7288431132055492`*^9, 
  3.728845636847151*^9, 3.7333673968064833`*^9, 3.792273341604622*^9},
 CellLabel->"During evaluation of In[128]:=",
 CellID->449736973,ExpressionUUID->"76106789-5b14-4fda-958e-43fc1a3cd5f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDowntest"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDowntest],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286626045098763`*^9, 3.728671251705339*^9, 
  3.728674892884242*^9, 3.728743220050411*^9, 3.7287433065214567`*^9, 
  3.7287434026481123`*^9, 3.728747612287574*^9, 3.728749559360145*^9, 
  3.728749943353883*^9, 3.728750782957477*^9, 3.728751065067802*^9, 
  3.728751630893968*^9, 3.728813277649822*^9, 3.728827394546196*^9, 
  3.7288359856773148`*^9, 3.7288363016877937`*^9, 3.7288431132055492`*^9, 
  3.728845636847151*^9, 3.7333673968064833`*^9, 3.7922733416123734`*^9},
 CellLabel->"During evaluation of In[128]:=",
 CellID->1734351418,ExpressionUUID->"f2f2eaf2-db82-4ae3-9505-fdc9d78f79dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "test"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`test],
  Editable->False]], "Print",
 CellChangeTimes->{3.7286626045098763`*^9, 3.728671251705339*^9, 
  3.728674892884242*^9, 3.728743220050411*^9, 3.7287433065214567`*^9, 
  3.7287434026481123`*^9, 3.728747612287574*^9, 3.728749559360145*^9, 
  3.728749943353883*^9, 3.728750782957477*^9, 3.728751065067802*^9, 
  3.728751630893968*^9, 3.728813277649822*^9, 3.728827394546196*^9, 
  3.7288359856773148`*^9, 3.7288363016877937`*^9, 3.7288431132055492`*^9, 
  3.728845636847151*^9, 3.7333673968064833`*^9, 3.79227334161996*^9},
 CellLabel->"During evaluation of In[128]:=",
 CellID->1448741595,ExpressionUUID->"bb1a7bb2-4c97-4b61-aab9-4a3c853a3aae"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.4. BasisArray", "Subsubsection",
 CellChangeTimes->{{3.728673440948658*^9, 
  3.728673441228715*^9}},ExpressionUUID->"2293933f-3cd3-45d8-9482-\
8786a1dadffa"],

Cell[TextData[{
 StyleBox["BasisArray\t\t\t", "DisplayMath"],
 StyleBox["List of basis vectors", "Text"]
}], "DefinitionBox",ExpressionUUID->"ae30a1d2-ed84-443a-b53c-1ab209af4509"],

Cell["Listing basis objects", "Text",ExpressionUUID->"71caf07e-a74c-4e54-b6d5-a6d4918e2d7d"],

Cell[CellGroupData[{

Cell[TextData[{
 "The function ",
 StyleBox["BasisArray", "MR"],
 " returns a list of all basis vectors of a given basis:"
}], "MathCaption",
 CellChangeTimes->{
  3.728662629057212*^9},ExpressionUUID->"36f5ef7f-e782-4794-96de-\
a953abadd8ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", "blues", "]"}], "[", "a", "]"}]], "Input",
 CellChangeTimes->{{3.728743232041184*^9, 3.7287432325706367`*^9}, {
   3.7287476192189407`*^9, 3.728747620194909*^9}, 3.7287493010675297`*^9},
 CellLabel->
  "In[129]:=",ExpressionUUID->"3c419301-418c-4d4c-9a96-ce367f785028"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["0",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{0, -$CellContext`blues}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`blues}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`blues}, $CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.728662630718644*^9, 3.728671255566935*^9, 
  3.728674893267625*^9, 3.728743249286961*^9, 3.728743306786578*^9, 
  3.7287434029489317`*^9, 3.7287476209716377`*^9, 3.728749565010408*^9, 
  3.728749943599453*^9, 3.728750787158956*^9, 3.728751065300852*^9, 
  3.728751631162703*^9, 3.728813277915422*^9, 3.728827394822345*^9, 
  3.728835985994619*^9, 3.728836301989148*^9, 3.728843120517087*^9, 
  3.728845637195084*^9, 3.733367401628311*^9, 3.792273347459838*^9},
 CellLabel->"Out[129]=",
 CellID->627601471,ExpressionUUID->"19a17f7a-49ba-4bf5-81ee-6f1138d02cea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", "fcomp", "]"}], "[", "A", "]"}]], "Input",
 CellChangeTimes->{
  3.728743235200674*^9, {3.728747622988144*^9, 3.728747624306611*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"1a09cf95-6c5f-4394-b6e3-bab07722f3da"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "A"},
           {
            StyleBox[
             RowBox[{"-", "1"}],
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-1, -$CellContext`fcomp}, $CellContext`A],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "A"},
           {
            StyleBox["1",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fcomp}, $CellContext`A],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.728662631418577*^9, 3.728671255753602*^9, 
  3.728674893469021*^9, 3.728743250158434*^9, 3.7287433069203377`*^9, 
  3.728743403082686*^9, 3.728747624788251*^9, 3.7287495652013817`*^9, 
  3.728749943721011*^9, 3.728750787344207*^9, 3.728751065451335*^9, 
  3.728751631316011*^9, 3.728813278056772*^9, 3.728827394965919*^9, 
  3.7288359860850687`*^9, 3.728836302105842*^9, 3.728843120716978*^9, 
  3.728845637528639*^9, 3.733367401752824*^9, 3.792273347518866*^9},
 CellLabel->"Out[130]=",
 CellID->1805732680,ExpressionUUID->"bf559b56-6d36-45a5-9c5a-3f4aceada8a1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["If we give several indices, the product basis is displayed:", \
"MathCaption",
 CellChangeTimes->{
  3.728662633441082*^9},ExpressionUUID->"3dcea435-b176-45a1-886a-\
4e555c34ee13"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", 
   RowBox[{"fred", ",", "fred"}], "]"}], "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellChangeTimes->{{3.7287432379546537`*^9, 3.728743239698331*^9}, {
  3.7287476272666197`*^9, 3.728747629962434*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"96e1e910-c066-44ab-a78c-bc9ba62e0a4c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`b],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`b],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`b],
       Editable->False]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`b],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`b],
       Editable->False]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "a"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`b],
       Editable->False]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7286626345827093`*^9, 3.728671255978422*^9, 
  3.7286748936159554`*^9, 3.72874325173666*^9, 3.728743307068747*^9, 
  3.728743403265562*^9, 3.728747630422699*^9, 3.728749565422147*^9, 
  3.728749943865258*^9, 3.728750787583197*^9, 3.7287510656293507`*^9, 
  3.728751631495434*^9, 3.728813278187914*^9, 3.728827395120206*^9, 
  3.7288359862023697`*^9, 3.728836302303639*^9, 3.728843120977862*^9, 
  3.728845637693138*^9, 3.7333674018816223`*^9, 3.792273347581558*^9},
 CellLabel->"Out[131]=",
 CellID->710253356,ExpressionUUID->"68815388-709c-4091-8ba1-78b25af8ae7f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["We can mix bases:", "MathCaption",
 CellChangeTimes->{
  3.728662635840891*^9},ExpressionUUID->"7cfbeaad-18f5-437b-8e09-\
4ca35d55f9ef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasisArray", "[", 
    RowBox[{"fred", ",", "blues", ",", "fcomp"}], "]"}], "[", 
   RowBox[{"a", ",", "c", ",", 
    RowBox[{"-", "B"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.728743241833324*^9, 3.728743246561861*^9}, {
   3.7287476326280937`*^9, 3.728747637898013*^9}, 3.728749302018683*^9},
 CellLabel->
  "In[132]:=",ExpressionUUID->"b397e55b-f385-4af2-9549-8033b90016e2"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`blues}, $CellContext`c],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`blues}, $CellContext`c],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`blues}, $CellContext`c],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`fred}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`blues}, $CellContext`c],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`blues}, $CellContext`c],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`blues}, $CellContext`c],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["0",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{0, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox[
                    RowBox[{"-", "1"}],
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {-1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[0., 1., 0.]]},
                    {"B", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`B, {1, $CellContext`fcomp}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "c"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`blues}, $CellContext`c],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`fred}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.728662637101242*^9, 3.7286712561746473`*^9, 
  3.728674893812711*^9, 3.728743252922406*^9, 3.7287433072348557`*^9, 
  3.7287434035022383`*^9, 3.728747638416152*^9, 3.728749565617111*^9, 
  3.728749944055521*^9, 3.7287507877982283`*^9, 3.728751065845194*^9, 
  3.728751631711618*^9, 3.728813278420416*^9, 3.7288273957265863`*^9, 
  3.728835986360104*^9, 3.72883630259731*^9, 3.728843121231201*^9, 
  3.728845637869211*^9, 3.7333674020527153`*^9, 3.792273347680484*^9},
 CellLabel->"Out[132]//MatrixForm=",
 CellID->1514044266,ExpressionUUID->"bac0b3ea-0565-4a8d-8420-9d5c09c4e000"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Basis indices", "Subsection",
 CellChangeTimes->{{3.728662754011717*^9, 3.728662756723887*^9}, {
  3.728673416534724*^9, 
  3.728673428653996*^9}},ExpressionUUID->"72218c58-dd15-4055-929e-\
32e81a9d0e94"],

Cell[CellGroupData[{

Cell["1.2.1. IndicesOf", "Subsubsection",
 CellChangeTimes->{{3.728673447277226*^9, 
  3.728673447413394*^9}},ExpressionUUID->"36e48e02-82e5-4221-87be-\
c7807dcd35b4"],

Cell[TextData[{
 "In ",
 StyleBox["xTensor`", "MR"],
 ", the main user level function to find indices in an expression was ",
 StyleBox["IndicesOf[selectors][expression]", "MR"],
 ". Let us start by reviewin that function."
}], "Text",
 CellChangeTimes->{{3.728743417978653*^9, 
  3.728743438911489*^9}},ExpressionUUID->"54d297ff-67ce-4972-a3f7-\
040388e78001"],

Cell[CellGroupData[{

Cell["Define several tensors:", "MathCaption",
 CellChangeTimes->{{3.728662867607512*^9, 3.728662873854418*^9}},
 CellID->266904421,ExpressionUUID->"b30e1f89-0463-43bb-95c2-da41d44b9bab"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"TT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", "d", ",", 
     RowBox[{"-", "e"}]}], "]"}], ",", "M3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], ",", "M3"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", "B"}], "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]}], "Input",
 CellLabel->
  "In[133]:=",ExpressionUUID->"12c43a21-58ec-4b82-9c1a-a7c05b17d05a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", "d", ",", 
     RowBox[{"-", "e"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TT[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`d, -$CellContext`e], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728743478958407*^9, 3.728747651284718*^9, 
  3.728749569519003*^9, 3.728749944165229*^9, 3.728750797945162*^9, 
  3.728751069959074*^9, 3.7287516318716927`*^9, 3.7288132785833197`*^9, 
  3.728827395953147*^9, 3.728835986455418*^9, 3.728836302739628*^9, 
  3.728843127676228*^9, 3.728845637998889*^9, 3.7333674100780687`*^9, 
  3.792273354649199*^9},
 CellLabel->"During evaluation of In[133]:=",
 CellID->920137883,ExpressionUUID->"53693de6-650a-4baf-b4ee-a251cd53ac4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728743478958407*^9, 3.728747651284718*^9, 
  3.728749569519003*^9, 3.728749944165229*^9, 3.728750797945162*^9, 
  3.728751069959074*^9, 3.7287516318716927`*^9, 3.7288132785833197`*^9, 
  3.728827395953147*^9, 3.728835986455418*^9, 3.728836302739628*^9, 
  3.728843127676228*^9, 3.728845637998889*^9, 3.7333674100780687`*^9, 
  3.7922733546599607`*^9},
 CellLabel->"During evaluation of In[133]:=",
 CellID->727657534,ExpressionUUID->"ded9321e-8b15-4c15-ad44-83e7972f6b4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", "B"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[-$CellContext`A, $CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728743478958407*^9, 3.728747651284718*^9, 
  3.728749569519003*^9, 3.728749944165229*^9, 3.728750797945162*^9, 
  3.728751069959074*^9, 3.7287516318716927`*^9, 3.7288132785833197`*^9, 
  3.728827395953147*^9, 3.728835986455418*^9, 3.728836302739628*^9, 
  3.728843127676228*^9, 3.728845637998889*^9, 3.7333674100780687`*^9, 
  3.7922733546783*^9},
 CellLabel->"During evaluation of In[133]:=",
 CellID->1968287920,ExpressionUUID->"4ba7f0ca-08a0-42d3-b61b-7593946a5ab2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", "B\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S\[Dagger][-$CellContext`A\[Dagger], $CellContext`B\[Dagger]],
    ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728743478958407*^9, 3.728747651284718*^9, 
  3.728749569519003*^9, 3.728749944165229*^9, 3.728750797945162*^9, 
  3.728751069959074*^9, 3.7287516318716927`*^9, 3.7288132785833197`*^9, 
  3.728827395953147*^9, 3.728835986455418*^9, 3.728836302739628*^9, 
  3.728843127676228*^9, 3.728845637998889*^9, 3.7333674100780687`*^9, 
  3.7922733546857977`*^9},
 CellLabel->"During evaluation of In[133]:=",
 CellID->1176973052,ExpressionUUID->"10d789d3-6d8e-4f77-8192-91530ffedbec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Construct an expression containing them:", "MathCaption",
 CellChangeTimes->{{3.7286628855483027`*^9, 3.728662900476931*^9}},
 CellID->617006311,ExpressionUUID->"bc2c03a8-6f62-45fc-ae7a-4e54c61d7dad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"TT", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "fred"}]}], "}"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "blues"}], "}"}], ",", "c", ",", 
      RowBox[{"-", "a"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "fred"}]}], "}"}], ",", "a"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "blues"}], "}"}]}], "]"}], 
    RowBox[{"U", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "d", ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "fred"}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "fred"}]}], "}"}], ",", "c"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "fcomp"}]}], "}"}], ",", "B"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "B"}], ",", 
      RowBox[{"{", 
       RowBox[{"A", ",", "fcomp"}], "}"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.728743485312006*^9, 3.728743507948966*^9}, {
  3.72874765346628*^9, 3.7287476726091223`*^9}, {3.728749302968383*^9, 
  3.728749303666894*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"75f1bb86-54a6-4869-b103-46477260b76c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TT", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "c", " "},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TT[{1, -$CellContext`fred}, -$CellContext`b, {
     2, $CellContext`blues}, $CellContext`c, -$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`blues}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`fred}, $CellContext`c],
    
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`fcomp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`fcomp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`fred}],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728662901700288*^9, 3.7286712664372473`*^9, 
  3.728674894261183*^9, 3.728743307564918*^9, 3.728743509266629*^9, 
  3.7287476730941467`*^9, 3.728749570080853*^9, 3.7287499443667803`*^9, 
  3.72875079824466*^9, 3.728751070240017*^9, 3.728751632045661*^9, 
  3.728813278798461*^9, 3.728827396164927*^9, 3.7288359868571243`*^9, 
  3.728836302933477*^9, 3.7288431280525303`*^9, 3.728845638320331*^9, 
  3.7333674103728724`*^9, 3.792273354761351*^9},
 CellLabel->"Out[136]=",
 CellID->914212447,ExpressionUUID->"fce32b15-e43a-46a0-9615-96117e84f21d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Find different types of indices (See xTensorDoc.nb, section 9.1):\
\>", "MathCaption",
 CellChangeTimes->{{3.7286629064843082`*^9, 3.7286629334287148`*^9}},
 CellID->1719940314,ExpressionUUID->"fd814381-e900-4682-a039-e257f3076cd5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", "Free", "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[137]:=",ExpressionUUID->"563f9246-0de7-43ec-be51-90801d6f26e9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], "c"}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`b, $CellContext`c],
  Editable->False]], "Output",
 CellChangeTimes->{3.728662913025135*^9, 3.728671266601688*^9, 
  3.72867489440442*^9, 3.728743307678035*^9, 3.728743511172538*^9, 
  3.728747675370242*^9, 3.72874957060299*^9, 3.728749944486382*^9, 
  3.728750798402842*^9, 3.728751070455977*^9, 3.72875163219838*^9, 
  3.728813278938417*^9, 3.7288273964052773`*^9, 3.728835987046899*^9, 
  3.7288363030575123`*^9, 3.728843128292523*^9, 3.728845638605145*^9, 
  3.73336741052242*^9, 3.792273354816433*^9},
 CellLabel->"Out[137]=",
 CellID->2070586091,ExpressionUUID->"97a1ee93-2ef3-4e72-80c9-58a69a31ff16"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", "TangentM3", "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[138]:=",ExpressionUUID->"62e747e6-e704-464b-bb1f-b730bf6e975b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], "a", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "blues"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], "c", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "a"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "d"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], "d", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "fred"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{
   1, -$CellContext`fred}, $CellContext`a, -$CellContext`b, {
   2, $CellContext`blues}, $CellContext`c, -$CellContext`a, -$CellContext`d, \
{-$CellContext`e, -$CellContext`fred}, $CellContext`d, {$CellContext`e, \
$CellContext`fred}],
  Editable->False]], "Output",
 CellChangeTimes->{3.728662913828676*^9, 3.728671266755533*^9, 
  3.728674894617045*^9, 3.728743307820076*^9, 3.728743593027919*^9, 
  3.728747677214147*^9, 3.728749570785131*^9, 3.72874994463627*^9, 
  3.728750798562683*^9, 3.728751070842411*^9, 3.728751632348804*^9, 
  3.7288132791450663`*^9, 3.728827396710535*^9, 3.7288359872319098`*^9, 
  3.728836303204278*^9, 3.728843128483032*^9, 3.728845638822239*^9, 
  3.733367410804085*^9, 3.7922733548683777`*^9},
 CellLabel->"Out[138]=",
 CellID->367931802,ExpressionUUID->"95bd047b-053c-4fcf-ac10-2ff84c0d45ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", "InnerC", "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[139]:=",ExpressionUUID->"59e57e41-bcdb-4c5a-9aa8-72cd878ffcb4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"-", "B"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"A", ",", "fcomp"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "fcomp"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], "B"}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`B, {$CellContext`A, \
$CellContext`fcomp}, {-$CellContext`A, -$CellContext`fcomp}, $CellContext`B],
  Editable->False]], "Output",
 CellChangeTimes->{3.728662914593055*^9, 3.728671266905149*^9, 
  3.7286748948291893`*^9, 3.7287433079364643`*^9, 3.728743561278638*^9, 
  3.728747679534916*^9, 3.7287495710710783`*^9, 3.7287499447430773`*^9, 
  3.728750798729145*^9, 3.728751071169552*^9, 3.728751632542307*^9, 
  3.7288132792897577`*^9, 3.728827396902165*^9, 3.728835987413169*^9, 
  3.728836303304405*^9, 3.728843129123221*^9, 3.728845638990073*^9, 
  3.73336741112834*^9, 3.792273354926408*^9},
 CellLabel->"Out[139]=",
 CellID->1224376501,ExpressionUUID->"4c94c0b5-6bbd-4c47-a71e-2d47ccce7641"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"U", ",", "Free"}], "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[140]:=",ExpressionUUID->"f28ab0e5-e513-4521-b6db-96ee845e594e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"-", "a"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], "d", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "fred"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`a, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`fred}],
  Editable->False]], "Output",
 CellChangeTimes->{3.7286629153060007`*^9, 3.728671267056593*^9, 
  3.7286748949666767`*^9, 3.728743308055807*^9, 3.72874356514459*^9, 
  3.728747681223322*^9, 3.7287495715528507`*^9, 3.7287499448858843`*^9, 
  3.728750798894746*^9, 3.728751071493341*^9, 3.728751632778537*^9, 
  3.7288132795339403`*^9, 3.728827397113237*^9, 3.72883598759137*^9, 
  3.728836303421398*^9, 3.728843129490836*^9, 3.72884563916651*^9, 
  3.73336741124319*^9, 3.7922733549728603`*^9},
 CellLabel->"Out[140]=",
 CellID->907546753,ExpressionUUID->"1a11710d-b6d0-43d4-b395-a359a7a706c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"Free", ",", "U"}], "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[141]:=",ExpressionUUID->"6696e00e-8955-4351-bcf8-101b3ef78416"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{"-", "b"}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`b],
  Editable->False]], "Output",
 CellChangeTimes->{3.728662916075876*^9, 3.728671267221127*^9, 
  3.7286748951207848`*^9, 3.7287433081892776`*^9, 3.7287435669116783`*^9, 
  3.728747682745392*^9, 3.728749572068906*^9, 3.728749945019732*^9, 
  3.728750799053091*^9, 3.728751071671332*^9, 3.72875163293152*^9, 
  3.728813279655222*^9, 3.7288273972670717`*^9, 3.7288359878207912`*^9, 
  3.7288363035866117`*^9, 3.7288431296943502`*^9, 3.728845639337706*^9, 
  3.733367411396675*^9, 3.792273355023271*^9},
 CellLabel->"Out[141]=",
 CellID->1709416677,ExpressionUUID->"2e00e1a5-bb06-4b0d-a32d-34cd52619aa7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"{", 
    RowBox[{"U", ",", "Free"}], "}"}], "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[142]:=",ExpressionUUID->"571c8d35-a5c3-4086-8f79-78a9067155db"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"-", "a"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], "d", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "fred"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"-", "b"}], 
     RowBox[{",", "\[ThinSpace]"}], "c"}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[-$CellContext`a, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`fred}, -$CellContext`b, $CellContext`c],
  Editable->False]], "Output",
 CellChangeTimes->{3.728662916911298*^9, 3.72867126740421*^9, 
  3.728674895301733*^9, 3.728743308324449*^9, 3.728743568726738*^9, 
  3.728747683590425*^9, 3.7287495722686777`*^9, 3.7287499451521873`*^9, 
  3.728750799628355*^9, 3.7287510718454638`*^9, 3.728751633095399*^9, 
  3.728813279771282*^9, 3.728827397413208*^9, 3.7288359879944897`*^9, 
  3.728836303708001*^9, 3.7288431299179697`*^9, 3.728845639523444*^9, 
  3.733367411537825*^9, 3.792273355073821*^9},
 CellLabel->"Out[142]=",
 CellID->1129860773,ExpressionUUID->"3d57c3fe-bf7f-4b17-8abd-bba27b51330c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["xCoba`", "MR"],
 " adds more possibilities. We can now use the types ",
 StyleBox["BIndex", "MR"],
 " and ",
 StyleBox["CIndex", "MR"],
 " as selectors, or search for a particular basis"
}], "MathCaption",
 CellChangeTimes->{{3.728662928825243*^9, 
  3.728662936274993*^9}},ExpressionUUID->"8fd8c5cb-8915-4e3c-8568-\
8993147aff59"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"{", 
    RowBox[{"BIndex", ",", "CIndex"}], "}"}], "]"}], "[", "expr", 
  "]"}]], "Input",
 CellLabel->
  "In[143]:=",ExpressionUUID->"5011d870-ae08-4b36-b633-1db8d8650a02"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"A", ",", "fcomp"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "fcomp"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "fred"}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"2", ",", "blues"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{-$CellContext`e, -$CellContext`fred}, \
{$CellContext`A, $CellContext`fcomp}, {-$CellContext`A, -$CellContext`fcomp}, \
{$CellContext`e, $CellContext`fred}, {1, -$CellContext`fred}, {
   2, $CellContext`blues}],
  Editable->False]], "Output",
 CellChangeTimes->{3.728662940575639*^9, 3.7286712675460443`*^9, 
  3.7286748954532957`*^9, 3.728743308498334*^9, 3.728743625990293*^9, 
  3.728747687315961*^9, 3.7287495726695642`*^9, 3.728749945265636*^9, 
  3.728750799899115*^9, 3.728751072013143*^9, 3.728751633249147*^9, 
  3.7288132798893843`*^9, 3.728827397563284*^9, 3.728835988183255*^9, 
  3.7288363039104433`*^9, 3.728843130098372*^9, 3.728845639729144*^9, 
  3.7333674116890383`*^9, 3.7922733551230516`*^9},
 CellLabel->"Out[143]=",
 CellID->1519605037,ExpressionUUID->"abbd73f1-d10a-435d-a708-cbeaa6fc6875"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", "fred", "]"}], "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.728743629407703*^9, 3.728743629752121*^9}, {
  3.728747690286623*^9, 3.728747690791609*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"fe18a01b-35ef-4ad2-b5e0-e0ca9eb665c1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"e", ",", "fred"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{
   1, -$CellContext`fred}, {-$CellContext`e, -$CellContext`fred}, \
{$CellContext`e, $CellContext`fred}],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728662941563719*^9, 3.7286712676785994`*^9, 3.728674895599922*^9, 
   3.728743308706205*^9, {3.728743627191276*^9, 3.728743630232864*^9}, 
   3.7287476912151833`*^9, 3.728749573069787*^9, 3.7287499454021*^9, 
   3.728750800310749*^9, 3.728751072176577*^9, 3.7287516333997717`*^9, 
   3.7288132800208473`*^9, 3.728827397718237*^9, 3.7288359883308287`*^9, 
   3.728836304037706*^9, 3.728843130373419*^9, 3.728845639914359*^9, 
   3.733367411861854*^9, 3.792273355173645*^9},
 CellLabel->"Out[144]=",
 CellID->2126326735,ExpressionUUID->"9e8a4101-d72e-4af7-9de9-7de849439cb2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Consider now the following example", "MathCaption",ExpressionUUID->"02557eb9-26fd-4a8a-b9f5-6532564d2409"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"Basis", ",", "fred"}], "]"}], "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.72874363329669*^9, 3.728743633591782*^9}, {
  3.728747693752948*^9, 3.7287476942235394`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"dc0547a7-f11c-4b82-922a-ee1c47f03739"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{
   1, -$CellContext`fred}, {-$CellContext`e, -$CellContext`fred}],
  Editable->False]], "Output",
 CellChangeTimes->{3.728662944481868*^9, 3.7286712678132353`*^9, 
  3.728674895754097*^9, 3.7287433089043617`*^9, 3.728743634169718*^9, 
  3.72874769455389*^9, 3.728749573331471*^9, 3.728749945536181*^9, 
  3.728750800606406*^9, 3.728751072346672*^9, 3.728751633548877*^9, 
  3.728813280148264*^9, 3.7288273978946257`*^9, 3.728835988483926*^9, 
  3.728836304172531*^9, 3.7288431305621758`*^9, 3.728845640079959*^9, 
  3.733367412038066*^9, 3.7922733552346687`*^9},
 CellLabel->"Out[145]=",
 CellID->898065418,ExpressionUUID->"06c35b40-d3f0-45f3-98f1-d04cd820da48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"Basis", "[", "fred", "]"}], "]"}], "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.728743635664445*^9, 3.7287436359753857`*^9}, {
  3.728747696577207*^9, 3.7287476971993856`*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"277857e2-9a66-4a12-8f05-5ddea2f68d9d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{"a", 
     RowBox[{",", "\[ThinSpace]"}], "c", 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "fred"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[$CellContext`a, $CellContext`c, {
   1, -$CellContext`fred}, {-$CellContext`e, -$CellContext`fred}],
  Editable->False]], "Output",
 CellChangeTimes->{3.728662945861377*^9, 3.7286712679470377`*^9, 
  3.728674895902524*^9, 3.728743309020855*^9, 3.728743636666313*^9, 
  3.7287476979181967`*^9, 3.728749573519548*^9, 3.728749945670128*^9, 
  3.728750800744646*^9, 3.72875107247948*^9, 3.728751633683181*^9, 
  3.728813280288496*^9, 3.7288273980456953`*^9, 3.7288359886347027`*^9, 
  3.728836304333148*^9, 3.728843130737877*^9, 3.728845640451013*^9, 
  3.73336741220759*^9, 3.792273355282111*^9},
 CellLabel->"Out[146]=",
 CellID->1270409210,ExpressionUUID->"0b50deb8-c36b-4b3b-85b3-7ad2f4a5934c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The first selects all the indices appearing in Basis objects and then \
selects from those only the ones that belong to polar. The second selects \
only those indices that belong to a Basis object of the polar basis, but \
returns the pair, not only the ",
 StyleBox["BCIndex", "MR"],
 "."
}], "MathCaption",ExpressionUUID->"8416f90a-b65f-49bd-ba1a-fa0b3e1edeaf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", 
   RowBox[{"Basis", "[", "fred", "]"}], "]"}], "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "fred"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "blues"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.728743642952241*^9, 3.728743654126987*^9}, {
   3.728747700800893*^9, 3.728747707014974*^9}, 3.7287493083194723`*^9},
 CellLabel->
  "In[147]:=",ExpressionUUID->"018e1f6f-3e95-40bc-ade0-65018c63ae4b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "fred"}]}], "}"}], 
     RowBox[{",", "\[ThinSpace]"}], 
     RowBox[{"{", 
      RowBox[{"b", ",", "blues"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{-$CellContext`a, -$CellContext`fred}, \
{$CellContext`b, $CellContext`blues}],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.728662950030306*^9, 3.7286712680957212`*^9, 3.728674896053019*^9, 
   3.728743309156048*^9, {3.728743646068892*^9, 3.728743654842252*^9}, 
   3.728747707552477*^9, 3.728749573662181*^9, 3.7287499458040752`*^9, 
   3.728750800910693*^9, 3.728751072630424*^9, 3.7287516338336773`*^9, 
   3.728813280421391*^9, 3.728827398203546*^9, 3.728835988792111*^9, 
   3.728836304473757*^9, 3.728843130952777*^9, 3.7288456408305187`*^9, 
   3.733367412355309*^9, 3.792273355342181*^9},
 CellLabel->"Out[147]=",
 CellID->1485173996,ExpressionUUID->"a40e4244-2a8e-4398-8b7d-bd2eaaebb36b"]
}, Open  ]]
}, Open  ]],

Cell["\<\
This function will be used heavily to control the behaviour of ContractBasis \
and SeparateBasis.\
\>", "MathCaption",ExpressionUUID->"3a797d89-c1c6-4c23-b19b-e006f338f34a"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.2. ContractBasis", "Subsubsection",
 CellChangeTimes->{{3.728673448516897*^9, 
  3.728673448668441*^9}},ExpressionUUID->"dd869560-b307-4804-b0a3-\
2322cee31c1d"],

Cell[TextData[{
 StyleBox["ContractBasis", "MR"],
 " is responsible for all contractions of ",
 StyleBox["Basis", "MR"],
 " with any other object. "
}], "Text",ExpressionUUID->"b51bd2f9-84ff-4d6d-8263-772889b99dba"],

Cell[TextData[{
 StyleBox["ContractBasis[expr, indices]\t\t", "DisplayMath"],
 StyleBox["Perform the contractions of ", "Text"],
 StyleBox["Basis", "Text", "MR"],
 StyleBox[" objects involving the specified dummy indices", "Text"]
}], "DefinitionBox",ExpressionUUID->"a175050a-6be7-4d1d-be7f-847bee268215"],

Cell["Contraction of Basis objects with tensors.", "Text",ExpressionUUID->"293181a8-1fe7-4235-90ab-19e6b5ae9c1e"],

Cell[TextData[{
 "We have complete control over which dummy indices should be eliminated. We \
can select them in several ways, all of which are eventually converted into a \
list of indices with head ",
 StyleBox["IndexList", "MR"],
 ":\n\t- ",
 StyleBox["IndexList[...]", "MR"],
 ",\t\t\nbe careful not to use the normal ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 StyleBox["List", "MR"],
 ", which could be mistaken for a ",
 StyleBox["BCIndex", "MR"],
 ". ",
 StyleBox["IndicesOf[selectors]", "MR"],
 " as a second argument is treated as ",
 StyleBox["IndicesOf[selectors][expr]", "MR"],
 " and gives great flexibility, but it is sometimes too long for simple \
cases. To handle them, several shorthands are defined: \n\t- ",
 StyleBox["ContractBasis[expr,basis] \t= \
ContractBasis[expr,IndicesOf[basis]]", "MR"],
 ",\n\t- ",
 StyleBox["ContractBasis[expr,vbundle]\t= \
ContractBasis[expr,IndicesOf[vbundle]]", "MR"],
 ",\n\t- ",
 StyleBox["ContractBasis[expr,tensor]\t= \
ContractBasis[expr,IndicesOf[tensor]]", "MR"],
 ",\n\t- ",
 StyleBox["ContractBasis[expr,index]\t= ContractBasis[expr,IndexList[index]]",
   "MR"],
 " .\nIt is important to keep in mind that the second argument gives the list \
of indices to be contracted, not their pairs in the Basis object. \nAll of \
this is best illustrated through some examples."
}], "Text",
 CellChangeTimes->{{3.7286629733615017`*^9, 
  3.728662989425746*^9}},ExpressionUUID->"f27ff5fb-0bdc-4e46-b3a9-\
8c578d8f3cda"],

Cell[CellGroupData[{

Cell["Take again example expressions:", "MathCaption",
 CellChangeTimes->{{3.72866299287225*^9, 3.728663009839904*^9}},
 CellID->1402959324,ExpressionUUID->"08360204-917c-4a99-af4d-cb1071d41802"],

Cell[CellGroupData[{

Cell[BoxData["expr"], "Input",
 CellLabel->
  "In[148]:=",ExpressionUUID->"1165e8c9-df89-4549-85d6-a51c3503f62c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TT", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "c", " "},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TT[{1, -$CellContext`fred}, -$CellContext`b, {
     2, $CellContext`blues}, $CellContext`c, -$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`blues}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`fred}, $CellContext`c],
    
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`fcomp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`fcomp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`fred}],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728663011165794*^9, 3.7286712717804623`*^9, 
  3.728674896215891*^9, 3.72874330932238*^9, 3.728743677514431*^9, 
  3.728747718455544*^9, 3.728749578624978*^9, 3.7287499459502163`*^9, 
  3.728750804701466*^9, 3.7287510792015457`*^9, 3.728751633988937*^9, 
  3.728813280541718*^9, 3.728827398360956*^9, 3.728835988937056*^9, 
  3.7288363046334057`*^9, 3.728843135552659*^9, 3.728845641007641*^9, 
  3.733367418455378*^9, 3.7922733697722692`*^9},
 CellLabel->"Out[148]=",
 CellID->1639099083,ExpressionUUID->"d4801b87-9bd0-40c0-91ca-1e0023a879b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr2", "=", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "blues"}]}], "}"}], ",", "b"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "fcomp"}], "}"}]}], "]"}], " ", 
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "B"}], ",", "A"}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"e", ",", "blues"}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7287436818228903`*^9, 3.728743686853614*^9}, {
  3.7287477223842*^9, 3.728747728861279*^9}, {3.7287493121841*^9, 
  3.728749312876054*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"decbdad5-9c12-40a9-98d0-ed0418969392"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]},
          {"A", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`A, {1, $CellContext`fcomp}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "b"},
          {
           StyleBox["e",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`blues}, $CellContext`b],
   
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {" ", "A"},
          {"B", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[-$CellContext`B, $CellContext`A],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {
           StyleBox["e",
            FontColor->RGBColor[0., 0., 1.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{$CellContext`e, $CellContext`blues}],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728663011764852*^9, 3.728671271911983*^9, 
  3.7286748964178877`*^9, 3.72874330948427*^9, 3.728743687485941*^9, 
  3.7287477297563143`*^9, 3.728749578760478*^9, 3.7287499460729513`*^9, 
  3.7287508048732*^9, 3.7287510793498383`*^9, 3.728751634134891*^9, 
  3.7288132807003403`*^9, 3.72882739862958*^9, 3.728835989103211*^9, 
  3.728836304779057*^9, 3.728843135750628*^9, 3.728845641193734*^9, 
  3.733367418601719*^9, 3.792273370611444*^9},
 CellLabel->"Out[149]=",
 CellID->632927560,ExpressionUUID->"38100f1d-fe38-4c4b-8933-453d4db65395"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The function called with just one argument performs all the possible \
contractions:\
\>", "MathCaption",
 CellChangeTimes->{{3.728663020086968*^9, 
  3.7286630207992764`*^9}},ExpressionUUID->"5e0ded7b-692e-4726-a6b0-\
de8c852fadc3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[150]:=",ExpressionUUID->"beec4951-1537-41a4-83b8-a728fc481f7e"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 0., 1.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`fred}, -$CellContext`b, {
    2, $CellContext`blues}, $CellContext`c, {1, -$CellContext`fred}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`fcomp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`fcomp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "c"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{1, -$CellContext`fred}, -$CellContext`b, {
     2, $CellContext`blues}, $CellContext`c],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728663014720232*^9, 3.728671272065366*^9, 
  3.728674896617235*^9, 3.728743309635664*^9, 3.728743690316615*^9, 
  3.728747731219652*^9, 3.728749578888653*^9, 3.728749946205847*^9, 
  3.72875080504277*^9, 3.728751079516765*^9, 3.72875163427899*^9, 
  3.728813280933338*^9, 3.728827398878858*^9, 3.728835989252557*^9, 
  3.7288363049492817`*^9, 3.728843135893608*^9, 3.7288456413746223`*^9, 
  3.733367418738909*^9, 3.792273371642367*^9},
 CellLabel->"Out[150]=",
 CellID->1423645728,ExpressionUUID->"20d4c8fe-a444-4a40-8384-9188bad474b1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
If we choose to give the indices directly, we can specifiy either element of \
the pair:\
\>", "MathCaption",
 CellChangeTimes->{
  3.728663022687049*^9},ExpressionUUID->"599a2e5f-bd4a-4bd9-8bcd-\
9dd0c1cc6739"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ContractBasis", "[", 
       RowBox[{"expr2", ",", " ", "A"}], "]"}], ",", " ", 
      RowBox[{"ContractBasis", "[", 
       RowBox[{"expr2", ",", 
        RowBox[{"-", "A"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ContractBasis", "[", 
       RowBox[{"expr2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "e"}], ",", 
          RowBox[{"-", "blues"}]}], "}"}]}], "]"}], ",", " ", 
      RowBox[{"ContractBasis", "[", 
       RowBox[{"expr2", ",", 
        RowBox[{"{", 
         RowBox[{"e", ",", "blues"}], "}"}]}], "]"}]}], "}"}]}], "}"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.728743698140293*^9, 3.728743702236883*^9}, {
  3.728747734966063*^9, 3.728747738388536*^9}, {3.72874931378502*^9, 
  3.728749314411675*^9}},
 CellLabel->
  "In[151]:=",ExpressionUUID->"b34949bf-5c43-4c79-b7fa-befbb412bf18"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["e",
                FontColor->RGBColor[0., 0., 1.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`blues}, \
$CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"S", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[0., 1., 0.]]},
              {"B", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[-$CellContext`B, {1, $CellContext`fcomp}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {
               StyleBox["e",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{$CellContext`e, $CellContext`blues}],
       Editable->False]}], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", "b"},
              {
               StyleBox["e",
                FontColor->RGBColor[0., 0., 1.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`blues}, \
$CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"S", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[0., 1., 0.]]},
              {"B", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[-$CellContext`B, {1, $CellContext`fcomp}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {
               StyleBox["e",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{$CellContext`e, $CellContext`blues}],
       Editable->False]}]},
    {
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[0., 1., 0.]]},
              {"A", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[-$CellContext`A, {1, $CellContext`fcomp}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"S", 
           StyleBox[GridBox[{
              {" ", "A"},
              {"B", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[-$CellContext`B, $CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[$CellContext`b],
       Editable->False]}], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[0., 1., 0.]]},
              {"A", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[-$CellContext`A, {1, $CellContext`fcomp}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"S", 
           StyleBox[GridBox[{
              {" ", "A"},
              {"B", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[-$CellContext`B, $CellContext`A],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[$CellContext`b],
       Editable->False]}]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.7286630162568293`*^9, 3.7286712721918716`*^9, 
  3.728674896778658*^9, 3.728743309757697*^9, 3.728743703584848*^9, 
  3.728747739002524*^9, 3.728749579017353*^9, 3.728749946345387*^9, 
  3.728750805177804*^9, 3.728751079667246*^9, 3.728751634442272*^9, 
  3.7288132811508827`*^9, 3.7288273990418253`*^9, 3.7288359894122257`*^9, 
  3.728836305153501*^9, 3.728843136505499*^9, 3.728845641566951*^9, 
  3.733367418866384*^9, 3.792273372680544*^9},
 CellLabel->"Out[151]//TableForm=",
 CellID->461810322,ExpressionUUID->"66168d59-6dd8-4555-8956-a12873168123"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nothing happens if we give an invalid index:", "MathCaption",
 CellChangeTimes->{
  3.7286630257186127`*^9},ExpressionUUID->"68e86b2c-1ddd-43cf-ac86-\
bc034db2766b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr2", ",", "C"}], "]"}]], "Input",
 CellLabel->
  "In[152]:=",ExpressionUUID->"bacd5051-b924-46f6-9450-99424ec88845"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]},
          {"A", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`A, {1, $CellContext`fcomp}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "b"},
          {
           StyleBox["e",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`blues}, $CellContext`b],
   
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {" ", "A"},
          {"B", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[-$CellContext`B, $CellContext`A],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {
           StyleBox["e",
            FontColor->RGBColor[0., 0., 1.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{$CellContext`e, $CellContext`blues}],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7286630176183662`*^9, 3.728671272327167*^9, 
  3.7286748969234657`*^9, 3.728743309952489*^9, 3.7287437127167997`*^9, 
  3.728747742739894*^9, 3.728749579434037*^9, 3.7287499465011044`*^9, 
  3.7287508056167*^9, 3.728751079790455*^9, 3.728751634596306*^9, 
  3.728813281284278*^9, 3.728827399190762*^9, 3.7288359895526867`*^9, 
  3.728836305296734*^9, 3.728843136701837*^9, 3.7288456417746964`*^9, 
  3.733367419057459*^9, 3.7922733744917803`*^9},
 CellLabel->"Out[152]=",
 CellID->1960327329,ExpressionUUID->"81f251a8-e610-4c77-a851-255407ceed5b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["More simple examples:", "MathCaption",
 CellChangeTimes->{
  3.72866302884656*^9},ExpressionUUID->"2c3c5f61-9573-4923-a647-fac8d8887e51"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"IndicesOf", "[", "AIndex", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[153]:=",ExpressionUUID->"b09fb82c-77e5-447b-ba60-68ae1b883283"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 0., 1.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`fred}, -$CellContext`b, {
    2, $CellContext`blues}, $CellContext`c, {1, -$CellContext`fred}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`fred}, $CellContext`c],
    
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`fcomp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`fcomp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{1, -$CellContext`fred}, -$CellContext`b, {
     2, $CellContext`blues}, {$CellContext`e, $CellContext`fred}],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728663037470421*^9, 3.72867127245844*^9, 
  3.7286748970527763`*^9, 3.728743310103649*^9, 3.7287437157167263`*^9, 
  3.728747744524109*^9, 3.728749579722011*^9, 3.7287499466501427`*^9, 
  3.728750805889895*^9, 3.728751079906003*^9, 3.7287516347274647`*^9, 
  3.72881328144967*^9, 3.728827399325493*^9, 3.728835989737007*^9, 
  3.7288363055551167`*^9, 3.728843136935309*^9, 3.728845642113414*^9, 
  3.7333674194750557`*^9, 3.792273376288932*^9},
 CellLabel->"Out[153]=",
 CellID->936333049,ExpressionUUID->"86303904-5c21-4f9d-bfb7-6b089adfd258"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"IndicesOf", "[", 
    RowBox[{"TT", ",", "U"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[154]:=",ExpressionUUID->"99d0a71c-0244-4532-9286-09bccdf841fc"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 0., 1.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`fred}, -$CellContext`b, {
    2, $CellContext`blues}, $CellContext`c, {1, -$CellContext`fred}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`blues}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`fred}, $CellContext`c],
    
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`fcomp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`fcomp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{
     1, -$CellContext`fred}, -$CellContext`b, $CellContext`d, \
{$CellContext`e, $CellContext`fred}],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728663037699325*^9, 3.728671272585891*^9, 
  3.728674897210112*^9, 3.728743310246863*^9, 3.7287437175356817`*^9, 
  3.728747745288149*^9, 3.7287495803859777`*^9, 3.7287499468000174`*^9, 
  3.72875080608013*^9, 3.728751080051708*^9, 3.728751634879304*^9, 
  3.7288132815794067`*^9, 3.7288273994760733`*^9, 3.728835989896276*^9, 
  3.728836305699483*^9, 3.728843137127388*^9, 3.7288456422738657`*^9, 
  3.7333674196359577`*^9, 3.792273376825521*^9},
 CellLabel->"Out[154]=",
 CellID->1746856133,ExpressionUUID->"84af7c29-383b-4271-8029-f214c3813ee5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"IndicesOf", "[", 
    RowBox[{"{", 
     RowBox[{"TT", ",", "U"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{3.728747755444659*^9},
 CellLabel->
  "In[155]:=",ExpressionUUID->"a779f61a-671e-4dee-93fb-92ea30e20d03"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 0., 1.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`fred}, -$CellContext`b, {
    2, $CellContext`blues}, $CellContext`c, {1, -$CellContext`fred}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`fcomp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`fcomp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "c"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{1, -$CellContext`fred}, -$CellContext`b, {
     2, $CellContext`blues}, $CellContext`c],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728663037841983*^9, 3.728671272725999*^9, 
  3.72867489738348*^9, 3.7287433103788137`*^9, 3.7287437188805304`*^9, 
  3.728747745983366*^9, 3.728749580586484*^9, 3.72874994692204*^9, 
  3.728750806236944*^9, 3.728751080173587*^9, 3.7287516350181627`*^9, 
  3.728813281743771*^9, 3.728827399628521*^9, 3.728835990054654*^9, 
  3.728836305884104*^9, 3.728843137858159*^9, 3.728845642452681*^9, 
  3.733367419973032*^9, 3.792273377843425*^9},
 CellLabel->"Out[155]=",
 CellID->289727438,ExpressionUUID->"b4b29332-f625-4201-87cc-d6e56764fcc8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr2", ",", "InnerC"}], "]"}]], "Input",
 CellLabel->
  "In[156]:=",ExpressionUUID->"cab229d0-47cc-4953-8742-1d727eb4a378"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "b"},
          {
           StyleBox["e",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`blues}, $CellContext`b],
   
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]},
          {"B", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[-$CellContext`B, {1, $CellContext`fcomp}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {
           StyleBox["e",
            FontColor->RGBColor[0., 0., 1.]]},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[{$CellContext`e, $CellContext`blues}],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728663037992858*^9, 3.7286712728591213`*^9, 
  3.728674897590745*^9, 3.728743310479224*^9, 3.728743720265397*^9, 
  3.728747746600493*^9, 3.728749580887897*^9, 3.728749947065178*^9, 
  3.728750806402104*^9, 3.728751080305382*^9, 3.7287516351846313`*^9, 
  3.728813281917762*^9, 3.72882739974617*^9, 3.728835990197287*^9, 
  3.728836306050655*^9, 3.7288431380736923`*^9, 3.7288456426144333`*^9, 
  3.7333674200910254`*^9, 3.792273378327318*^9},
 CellLabel->"Out[156]=",
 CellID->1601519298,ExpressionUUID->"de69afdd-43a9-4e89-af8e-32e0f9a11fc9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "d"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.728747758588607*^9, 3.7287477637724743`*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"0c58b5b6-43b9-49d8-a8b3-dff1eba80588"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 0., 1.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`fred}, -$CellContext`b, {
    2, $CellContext`blues}, $CellContext`c, {1, -$CellContext`fred}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "c"},
           {
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{-$CellContext`e, -$CellContext`fred}, $CellContext`c],
    
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`fcomp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`fcomp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], 
            StyleBox["e",
             FontColor->RGBColor[1., 0., 0.]]},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[{1, -$CellContext`fred}, -$CellContext`b, {
     2, $CellContext`blues}, {$CellContext`e, $CellContext`fred}],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728663038151451*^9, 3.728671272957246*^9, 
  3.72867489773435*^9, 3.7287433105825853`*^9, 3.7287437236136427`*^9, 
  3.728747747632903*^9, 3.7287495810843983`*^9, 3.728749947187538*^9, 
  3.728750806563682*^9, 3.728751080462019*^9, 3.728751635345593*^9, 
  3.7288132821167717`*^9, 3.728827399891308*^9, 3.72883599035998*^9, 
  3.728836306197598*^9, 3.728843138283201*^9, 3.728845642796091*^9, 
  3.733367420241695*^9, 3.792273379329015*^9},
 CellLabel->"Out[157]=",
 CellID->123988376,ExpressionUUID->"5436f05b-e70d-41e7-843f-f253ca6bf695"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", "fred"}], "]"}]], "Input",
 CellChangeTimes->{{3.7287437289625807`*^9, 3.728743729563363*^9}, {
  3.728747748925027*^9, 3.728747767004155*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"cdc7ec7d-f32f-4eba-87ea-2b6961f5e2f6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"TT", 
        StyleBox[GridBox[{
           {" ", " ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "c", " "},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TT[{1, -$CellContext`fred}, -$CellContext`b, {
     2, $CellContext`blues}, $CellContext`c, -$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`blues}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`fred}, $CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[-$CellContext`B, {$CellContext`A, $CellContext`fcomp}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", "B"},
           {
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[{-$CellContext`A, -$CellContext`fcomp}, $CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {" ", " ", "d", "c"},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[-$CellContext`a, -$CellContext`b, $CellContext`d, \
$CellContext`c],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728663038303135*^9, 3.7286712731156797`*^9, 
  3.728674897884893*^9, 3.728743310714995*^9, 3.7287437311048393`*^9, 
  3.7287477507367983`*^9, 3.728749581265134*^9, 3.7287499473328876`*^9, 
  3.7287508067169456`*^9, 3.728751080664998*^9, 3.728751635478985*^9, 
  3.728813282339802*^9, 3.728827400146914*^9, 3.7288359905085897`*^9, 
  3.728836306352727*^9, 3.728843138488131*^9, 3.7288456429723797`*^9, 
  3.733367420445752*^9, 3.7922733797935667`*^9},
 CellLabel->"Out[158]=",
 CellID->1187002912,ExpressionUUID->"b3de59a9-ebab-4297-a0b8-01fe1a58ebaf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Notice how only the index",
 StyleBox[" {-e, -bas}", "MR"],
 " has been supressed. Nothing has been done to ",
 StyleBox["a", "MR"],
 ", even though its pair in the Basis object belongs to",
 StyleBox[" polar", "MR"],
 ".  If we want to act on that index, we can use the following to contract \
everything that appears in a Basis object that has at least one polar index:"
}], "MathCaption",
 CellChangeTimes->{{3.7286630442301197`*^9, 3.7286630664931383`*^9}, {
  3.7287437382501793`*^9, 
  3.728743738769786*^9}},ExpressionUUID->"48d0d17c-29ba-4a7d-979a-\
86078e7b6c5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"expr", ",", " ", 
   RowBox[{"IndicesOf", "[", 
    RowBox[{"Basis", "[", "fred", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.72874374257813*^9, 3.728743742946794*^9}, {
  3.728747772221841*^9, 3.7287477727396317`*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"c82642e5-1e49-4451-bfe6-e5a36e43835f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"TT", 
       StyleBox[GridBox[{
          {" ", " ", 
           StyleBox["2",
            FontColor->RGBColor[0., 0., 1.]], "c", " "},
          {
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]], "b", " ", " ", 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TT[{1, -$CellContext`fred}, -$CellContext`b, {
    2, $CellContext`blues}, $CellContext`c, {1, -$CellContext`fred}],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]]},
           {"d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`d, {2, $CellContext`blues}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["A",
             FontColor->RGBColor[0., 1., 0.]]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->F