(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1006662,      26269]
NotebookOptionsPosition[    912834,      24557]
NotebookOutlinePosition[    926984,      24850]
CellTagsIndexPosition[    926860,      24844]
WindowTitle->DebeverNullDirections
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["X IDEAL SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "cc8087e1-2dc1-4901-9e93-f14ceffad4b8"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "f97122c8-a20d-4012-aeb3-5d14db2abe7a"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[Cell[BoxData[
     TagBox[
      ActionMenuBox[
       FrameBox[Cell[TextData[{
         "URL",
         " ",
         Cell[BoxData[
          GraphicsBox[
           {GrayLevel[0.66667], Thickness[0.13], 
            LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
           AspectRatio->1,
           ImageSize->20,
           PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
          "f863353b-8213-4622-9091-ad7f2f256c68"]
        }],ExpressionUUID->"e7a45e56-0f02-4805-ac8a-7572dd7e3ab6"],
        StripOnInput->False],{
       "\"xIdeal/ref/DebeverNullDirections\"" :> None, 
        "\"Copy Wolfram Documentation Center URL\"" :> 
        Module[{DocumentationSearch`Private`nb$}, 
          DocumentationSearch`Private`nb$ = 
           NotebookPut[
            Notebook[{Cell["xIdeal/ref/DebeverNullDirections"]}, Visible -> 
              False]]; SelectionMove[
           DocumentationSearch`Private`nb$, All, Notebook]; 
          FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
          NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
        "\"Copy web URL\"" :> 
        Module[{DocumentationSearch`Private`nb$}, 
          DocumentationSearch`Private`nb$ = 
           NotebookPut[
            Notebook[{
              Cell[BoxData[
                MakeBoxes[
                 Hyperlink[
                  "http://reference.wolfram.com/language/xIdeal/ref/\
DebeverNullDirections.html"], StandardForm]], "Input", TextClipboardType -> 
                "PlainText"]}, Visible -> False]]; 
          SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
          FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
          NotebookClose[DocumentationSearch`Private`nb$]; Null], 
        "\"Go to web URL\"" :> 
        FrontEndExecute[{
          NotebookLocate[{
            URL[(If[TrueQ[False], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "xIdeal/ref/DebeverNullDirections") <> ".html"], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"],
      MouseAppearanceTag["LinkHand"]]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "abe0557c-41f0-4f8a-b78b-427b3fd8a70a"]], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "a3d6c1c5-7486-4c80-9f5c-18f13e5131af"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"1df62c01-8fae-4abc-b003-b9baa0bea05b"],

Cell["xAct`xIdeal`", "ContextNameCell",ExpressionUUID->"7b9fbad8-4bbf-4d7d-a395-655952bee155"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "DebeverNullDirections", "ObjectName",ExpressionUUID->
      "09896c7d-3bfc-42be-b8da-1cc7f718e1cc"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"3e0f2b74-bb08-48c3-8651-2680aaeee425"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "e5a2de98-c4b3-4049-92e3-252ae8cef528"]
    }],ExpressionUUID->"c4b4c184-7c02-4080-bac0-5eb29809309f"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"e5e03f69-de4d-4226-88c8-\
2fe474bbb61a"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DebeverNullDirections", "[", 
       RowBox[{"metric", ",", " ", "opts"}], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "091b6994-3282-4f0e-a5b9-a3d1f1b46f6d"],
     " returns the  multiple Debever null directions of metric."
    }],ExpressionUUID->"89719ca9-9535-40f2-b384-7f23a32fa65b"]}
  }]], "Usage",
 CellID->423578463,ExpressionUUID->"d0853635-e888-4632-b531-9010a8a52da4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"45f99aee-59c0-4c73-b003-2c8efefe22c7"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"e89ecf3a-f2be-4c4a-839b-d88fbdf4b128"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"c4fa4d0e-ef35-4344-9131-0516481ff52b"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"3d7c205b-031e-49e0-a4ed-b2826a8fcbb8"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->1851554135,ExpressionUUID->"2e45002b-957a-45ba-81a0-22a075b3f70c"],

Cell["The following options can be given: ", "Notes",
 CellID->354734344,ExpressionUUID->"134d028e-088b-4fa4-8b4b-f43e149f403b"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "477b2a2f-6b53-405a-91ed-354573f1e2ac"], "Method", "\"\<Default\>\"", 
    Cell["\<\
Method is an option for various algorithm-intensive functions that specifies \
what internal methods they should use.\
\>", "TableText",ExpressionUUID->"3d0618ba-634b-4877-b7d1-654e5606517b"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "a0ee9373-cf1a-43bb-852d-66169943c7b0"], "PSimplify", "$CVSimplify", 
    Cell["\<\
PSimplify is an option to choose the function used to simplify expressions.\
\>", "TableText",ExpressionUUID->"7e077c11-030d-4001-bbe6-75d756057f61"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "0032cfc2-cc88-4fa9-8d2e-2621b9aedffc"], "Parallelize", 
    TemplateBox[{
      Cell[
       TextData["True"]], "paclet:ref/True"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Parallelize", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "ae8428ff-c2eb-41bd-b43d-b9dbe418fabb"],
     " evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "e56bbb51-b8ac-4294-a98b-2cb05076d579"],
     " using automatic parallelization."
    }], "TableText",ExpressionUUID->"147faebb-22e0-4afd-9035-8f1e4eaf82c7"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "47ce0258-b79d-4e40-b323-3a1d409f2e67"], "Verbose", 
    TemplateBox[{
      Cell[
       TextData["True"]], "paclet:ref/True"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell[TextData[Cell[BoxData[Cell["\<\
Verbose is a Boolean option for MakeRule, AutomaticRules and ToCanonical. \
Verbose->True gives lots of log-info about the internals of the calculation. \
Its default value is False.\
\>", "TableText",ExpressionUUID->"377de862-ada0-462a-bbae-0a31fa419c9b"]],
     ExpressionUUID->"b9614ac8-76ca-4648-85f6-8cf2852bbc1c"]], "TableText",
     ExpressionUUID->"0600ef8a-51e3-4fca-9c70-2f6e5930878f"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "a44807e3-562b-41e6-abfa-e1e1bdb6eba7"], "\"\<Observer\>\"", 
    TemplateBox[{
      Cell[
       TextData["Null"]], "paclet:ref/Null"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell[
    "Arbitrary time-like rank 1 CTensor always needed.", "TableText",
     ExpressionUUID->"e2614675-3eb3-4713-9fcc-2a2dd8509c9f"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "14466461-1ae0-4c4a-a4b0-6db343044f4b"], "\"\<Vector\>\"", 
    TemplateBox[{
      Cell[
       TextData["Null"]], "paclet:ref/Null"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell["\<\
Arbitrary rank 1 CTensor needed if the \"PetrovMatrix\" Method is used for a \
Petrov Type D metric.\
\>", "TableText",ExpressionUUID->"1d787978-74e3-44ed-8172-42c8d9a35d58"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "27649c18-ba72-43dc-9884-82a960b8f691"], "\"\<Bivector\>\"", 
    TemplateBox[{
      Cell[
       TextData["Null"]], "paclet:ref/Null"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell["\<\
Arbitrary antisymmetric rank 2 CTensor needed if the \"WeylSelfDual\" Method \
is used. This is the method used by default.\
\>", "TableText",ExpressionUUID->"5ab35bdd-7f6f-4eb5-bfa8-7bfaffdf7e10"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, 
   "Rows" -> {None, None, None, None, None, None, {None}}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->55188794,ExpressionUUID->"cabe4873-b21d-4d4c-b508-6cb87fc34ce3"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"d244f5cb-835d-4eba-bb63-d83325af16a9"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"98c6aadd-46e7-4830-841b-b1a64f9e3355"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(8)", "ExampleCount",ExpressionUUID->
  "de8f6917-0652-45f9-849f-61ff47b5de07"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->784848252,ExpressionUUID->"c66f1b97-afa1-4787-b251-31145eb43622"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<xAct`xIdeal`\>\"", "]"}], ";"}]], "Input", \
"ExampleInitialization",
 Evaluatable->True,
 CellLabel->"In[1]:=",ExpressionUUID->"2f47d450-71bc-4a05-9ac0-2b4ab1390aaa"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"9b070de2-8d1b-4c5d-bb67-3857c8ca8e0f"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5694e58e-5830-43ac-836f-598b5cd4fd14"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "e4041dce-36e1-4527-9705-6171dff2c96e"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->187009598,ExpressionUUID->"534c1ec5-92cd-48ae-b8c5-bf4beffee7f4"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"77789aa3-d210-453c-bf02-21094ad21bb9"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"4b47621e-6bfa-46be-b764-c00e4c594dc8"],
 "Schwarzschild metric:",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "f524cfb9-1f5c-4c61-b9bc-445f8dbca552"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->127660352,ExpressionUUID->"ae9382e4-c372-40b8-a503-3da72918f262"],

Cell["\<\
Here, we will obtain the multiple Debever null directions of the \
Schwarzschild metric. We start by defining the coordinates and the metric:\
\>", "ExampleText",
 CellID->50967587,ExpressionUUID->"1babf5af-a6b2-4854-8cdb-d3f6768471fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";", 
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[1]:=",
 CellID->1291860986,ExpressionUUID->"bbc4b615-70a1-4799-bdc2-5966c8fdc875"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"Schw", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"\[Theta]", "[", "]"}], ",", 
      RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"mm", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<m\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "]"}], ">", "0"}], "&&", " ", 
    RowBox[{"mm", ">", "0"}], "&&", " ", 
    RowBox[{"Pi", ">", 
     RowBox[{"\[Theta]", "[", "]"}], ">", "0"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "mm"}], 
          RowBox[{"r", "[", "]"}]]}], ")"}]}], ",", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "mm"}], 
          RowBox[{"r", "[", "]"}]]}], ")"}], 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox[
       RowBox[{"r", "[", "]"}], "2"], ",", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"r", "[", "]"}], "2"], 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Schw"}], ",", 
       RowBox[{"-", "Schw"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "Schw", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[2]:=",
 CellID->203828065,ExpressionUUID->"424e743d-711d-4bc3-8775-8d1e650351f7"],

Cell["Now, we need to define an arbitrary observer:", "ExampleText",
 CellID->252826225,ExpressionUUID->"e06c452f-aa6f-4843-aca7-6cd3fbec9024"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "mm"}], 
           RowBox[{"r", "[", "]"}]]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]], ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", "Schw", "}"}]}], "]"}]}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[3]:=",
 CellID->435705,ExpressionUUID->"eda99c78-de79-4e55-89f3-f210b54c35a6"],

Cell["and, an arbitrary bivector:", "ExampleText",
 CellID->172899496,ExpressionUUID->"3368c10d-c5fc-4d32-98b5-4c64dedf09df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"With", " ", "some", " ", 
      RowBox[{"restrictions", ".", " ", "We"}], " ", "should", " ", "check", 
      " ", "that", " ", "it", " ", "is", " ", "a", " ", "rank"}], "-", 
     RowBox[{"2", " ", "CTensor"}]}], ",", " ", 
    RowBox[{
    "antysymmetric", " ", "and", " ", "such", " ", "that", " ", "its", " ", 
     "necessary", " ", "contractions"}], ",", " ", 
    RowBox[{
     RowBox[{"i", ".", "e", ".", " ", 
      RowBox[{"scrp", "[", 
       RowBox[{
        RowBox[{"-", "a1"}], ",", 
        RowBox[{"-", "b1"}], ",", 
        RowBox[{"-", "i1"}], ",", 
        RowBox[{"-", "j1"}]}], "]"}]}], " ", 
     RowBox[{"X", "[", 
      RowBox[{"i1", ",", "j1"}], "]"}], " ", "and", " ", 
     RowBox[{"scrp2", "[", 
      RowBox[{
       RowBox[{"-", "i1"}], ",", 
       RowBox[{"-", "j1"}], ",", 
       RowBox[{"-", "k1"}], ",", 
       RowBox[{"-", "l1"}]}], "]"}], " ", 
     RowBox[{"X", "[", 
      RowBox[{"i1", ",", "j1"}], "]"}], " ", 
     RowBox[{"X", "[", 
      RowBox[{"k1", ",", "l1"}], "]"}]}], ",", " ", 
    RowBox[{"do", " ", "not", " ", 
     RowBox[{"vanish", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "We", " ", "should", " ", "also", " ", "group", " ", "options", " ", 
    "conveniently"}], "*)"}]}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[4]:=",
 CellID->218378580,ExpressionUUID->"2587eaf0-6ebe-4506-b455-be4f41953438"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bv", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Schw"}], ",", 
       RowBox[{"-", "Schw"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[5]:=",
 CellID->270763279,ExpressionUUID->"33944c4b-c5d8-4a01-997b-b654f8ca7734"],

Cell[TextData[{
 "With that, we can finally use the ",
 StyleBox["DebeverNullDirections", "Input"],
 " function:"
}], "ExampleText",
 CellID->137807236,ExpressionUUID->"c5e6d167-8f3d-4528-8ae2-c3a1bf8450ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}], ",", " ", 
   RowBox[{"\"\<Bivector\>\"", "->", "bv"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[6]:=",
 CellID->135730069,ExpressionUUID->"81c6d8c9-5736-4a97-b83c-7d21dbe9d142"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->5852917,ExpressionUUID->"559a0dd4-c56e-4d6a-b764-38e4c433284b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->463641036,ExpressionUUID->"599303b0-7164-4cae-a0fa-866508d464c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->5065389,ExpressionUUID->"e77ac173-4e7c-4009-acf7-527d43ad86aa"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->278465605,ExpressionUUID->"bf3ccec0-eb62-47ef-8f80-d68a158106a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->65984570,ExpressionUUID->"fd271bf9-5c81-45cc-9aee-0204396d7a62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000531`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000531, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->634367901,ExpressionUUID->"2ef2cc67-fef4-4f60-bf41-5e07530b801d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "3.4273875`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 3.4273875, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->130222697,ExpressionUUID->"c1f43267-ac3f-4746-9df1-aa9a72b93740"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->196042145,ExpressionUUID->"3b498070-410c-4d2d-b989-e3c4c5a2a5ab"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->168339647,ExpressionUUID->"0fa9116a-b9af-4627-938d-e108c040d441"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->99045589,ExpressionUUID->"a675fdd0-894c-45ba-bf47-794ea31c1819"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->783455,ExpressionUUID->"2e0fbcca-506e-4b04-8b37-105c729b3997"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->77227295,ExpressionUUID->"4063c993-3bfb-4593-b323-ac5e78b49738"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->47806718,ExpressionUUID->"88fdae19-04eb-4708-a3c6-787b9006736c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->694131442,ExpressionUUID->"5d17f20e-b955-44dd-9934-6c1a54c3f78f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0009092`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0009092, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->57488658,ExpressionUUID->"5a4d5fac-cf19-42e3-906d-a16d4a9def97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0500471`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0500471, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->267522509,ExpressionUUID->"c5487866-79e7-43fd-8607-2f8cbc07bb1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0007367`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "15040",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0007367, " seconds and ", 15040, " bytes"],
  
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->19466874,ExpressionUUID->"4d1982af-6dbc-4003-82dc-a502e4adf00f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->838919888,ExpressionUUID->"d03100a2-cb5a-483c-a190-ecf7e7535966"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0025625`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0025625, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->696503788,ExpressionUUID->"1af37374-a07b-4506-9263-a4de44366990"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0419097`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0419097, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->2661945,ExpressionUUID->"7c039f6f-b033-491c-889f-e722ccf30c3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0011409`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "14432",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0011409, " seconds and ", 14432, " bytes"],
  
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->184307024,ExpressionUUID->"984a96e0-e10e-4849-8cd9-219b888b74a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->227886861,ExpressionUUID->"a06938ca-4571-496e-81dc-dbc8dda82171"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0002243`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0002243, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->384030,ExpressionUUID->"b74b7a5b-c764-4569-8a2e-2e6a2011ea7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0124155`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0124155, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->547270926,ExpressionUUID->"ea13ed11-319b-479d-bff8-e3bb86f6c01e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0001739`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0001739, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->15713929,ExpressionUUID->"359160e6-1461-4a7b-bbc5-f4a54b4d43d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->59716844,ExpressionUUID->"61bf1c80-27d3-4f77-a81b-42e3f1cd2619"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0000674`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0000674, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->101400817,ExpressionUUID->"479bc5c9-dd79-47a3-bd19-f6f10aceebba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0215795`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0215795, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->166958084,ExpressionUUID->"fa24d017-ba3d-4d17-96fd-696f535ba443"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0001582`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0001582, " seconds and ", 64, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->341131364,ExpressionUUID->"df9e28b4-cc22-4820-a77e-571a3d62a9c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->412264477,ExpressionUUID->"aff30cfc-7316-4055-9227-d1845fe5af7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0004258`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0004258, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->468115244,ExpressionUUID->"04461a96-52ca-460b-8837-dc5cfd037110"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0311718`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0311718, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->82378815,ExpressionUUID->"122a00a5-7b46-4ffc-853e-f33853795ae9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000901`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "15040",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000901, " seconds and ", 15040, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->849169183,ExpressionUUID->"d84594af-7be2-46ae-a757-b17cdfa6e89c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.0312878`5.9469200203222385", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.0312878`5.9469200203222385, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->138627308,ExpressionUUID->"217d488c-bdb6-4879-a749-111ef4f9b04d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.031224`5.946033531769165", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.031224`5.946033531769165, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->16223750,ExpressionUUID->"3f8cf9e6-8bbb-4415-b813-78c9967f4fbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->394301372,ExpressionUUID->"b80aca3e-9f58-4bc1-ab54-021fb62adf07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.0226331`5.806289035771034", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.0226331`5.806289035771034, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->152543602,ExpressionUUID->"b19a37c1-8fec-4492-b8e0-378cd99b2cb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->132575061,ExpressionUUID->"923e3a7e-e122-49d4-9074-4f17f2014069"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0313506`5.947790850439283", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"G2Form\" in ", 0.0313506`5.947790850439283, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->457906397,ExpressionUUID->"825d3497-2d77-40a5-a977-56418bd3623e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.0944043`6.426536769825198", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.0944043`6.426536769825198, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->378840197,ExpressionUUID->"2b59cab2-7d9d-4c45-a5ec-59ad68c61109"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.0626371`6.2483766358544095", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.0626371`6.2483766358544095,
    " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->124513870,ExpressionUUID->"edbd8b8f-fb0a-4d11-b664-217d296bd294"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.1257409`6.551021558016858", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.1257409`6.551021558016858, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->512557888,ExpressionUUID->"5e1d37d7-ee60-4b3e-b836-d9abb9f978be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->9087502,ExpressionUUID->"cc3508ea-a69d-4ed3-9be7-7d297f37ba6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.0161372`5.6593731750566985", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.0161372`5.6593731750566985, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->527578536,ExpressionUUID->"365d83c1-5926-49d8-b0a3-d78325d24c60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.0520322`6.167817182406829", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.0520322`6.167817182406829, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->28528108,ExpressionUUID->"fe84739b-4673-4bfc-bd58-33a28c262320"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.1384056`6.592698655870301", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.1384056`6.592698655870301, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->612405706,ExpressionUUID->"56375308-bf96-4d63-af47-a6f0ddf99454"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0.0006327`4.252742827955119", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.0006327`4.252742827955119, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->185933523,ExpressionUUID->"ab597c2c-ae9c-4e38-a0f8-da6c3d751e47"],

Cell[BoxData["\<\"Type D\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->109884437,ExpressionUUID->"bd262f76-e502-4fd1-b7c6-a6ffd3cd62c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorScP\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScP\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->593297084,ExpressionUUID->"58eefa92-8916-40e8-af00-aa9f77d7235e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScP\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0150094`5.6279083251864535", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorScP\" in ", 0.0150094`5.6279083251864535, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->158414543,ExpressionUUID->"65156578-eb89-4b10-ae7e-01d7f1560068"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TensorScP2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0473706`6.127053879069167", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScP2\" in ", 
   0.0473706`6.127053879069167, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->185149827,ExpressionUUID->"fd7f8e19-c8d8-47f4-b0c4-8c40659bb02e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScP2\\\" in \"\>",
    "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorScP2\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->144308100,ExpressionUUID->"4cea9325-db20-4a84-8380-334650d85251"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"PTDCanonicalBivector\\\" in \"\>", "\[InvisibleSpace]", 
   "0.023142`5.815945882745656", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"PTDCanonicalBivector\" in ",
    0.023142`5.815945882745656, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->250090492,ExpressionUUID->"3cd46119-35b3-41c8-be12-963bceb0d3c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"PTDCanonicalBivector\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0194181`5.739751726797929", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"PTDCanonicalBivector\" in ", 
   0.0194181`5.739751726797929, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->151160510,ExpressionUUID->"0ae475c4-30b7-4b43-9f9f-f323c977b2b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WNullDirectionTypeDPlus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0060702`5.234747993873613", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WNullDirectionTypeDPlus\" \
in ", 0.0060702`5.234747993873613, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->116873806,ExpressionUUID->"0fb80419-3841-4b72-adba-5579b5c85496"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WNullDirectionTypeDPlus\
\\\" in \"\>", "\[InvisibleSpace]", "0.0316706`5.952201284661406", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WNullDirectionTypeDPlus\" in ", 
   0.0316706`5.952201284661406, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->101328155,ExpressionUUID->"d7045d6e-f5ee-4884-8c8c-81c488f8d0cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WNullDirectionTypeDMinus\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WNullDirectionTypeDMinus\" \
in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->277979585,ExpressionUUID->"3d1808c5-e87d-4a55-923c-e1f6faafe2ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"WNullDirectionTypeDMinus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0156375`5.645712316197447", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WNullDirectionTypeDMinus\" in ", 
   0.0156375`5.645712316197447, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->278679933,ExpressionUUID->"a7a12a1e-de0e-4058-8b8d-5810691e6248"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], 
        SqrtBox[
         RowBox[{
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             InterpretationBox[
              StyleBox["m",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mm,
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]}], ")"}]}]]], ",", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], 
        SqrtBox[
         RowBox[{
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             InterpretationBox[
              StyleBox["m",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mm,
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]}], ")"}]}]]], ",", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["m",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`mm,
             Editable->False]}], 
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False]]}]]}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->320999606,ExpressionUUID->"ae504e03-f647-4a5a-9e5a-19a70e1683a1"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"2532c505-0b94-4ae6-9e4a-5e2f4e4f232f"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"b866d246-ca09-4662-ab07-248d3db41d77"],
 "Scope",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "7b55f1f4-4312-48cb-acc0-dcf8a8fe1db5"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"8ae91dd6-234b-4a7b-99e1-acc5768c4117"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"696ce22c-7267-4ce4-86a8-1d7c7dab613c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f925a7de-1d84-42b9-877f-9179f570c47a"],
 "Petrov metric & Type-II metric:",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "af4e86f8-85aa-4aed-a525-ef7b8ae34e27"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->166252624,ExpressionUUID->"9defd73a-b61f-4169-8f3d-b9ac1216e7cc"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[1]:=",
 CellID->177197649,ExpressionUUID->"3060cbae-deff-4dc3-a21f-267e8cc4c2d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";", 
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[2]:=",
 CellID->1547569602,ExpressionUUID->"5fea6f4d-ac5d-43e9-842e-d9c9a564b641"],

Cell["\<\
Now, we consider the Petrov metric (see Stephani H, Kramer D, MacCallum M A \
H, Hoenselaers C and Herlt E 2003 Exact Solutions of the Einstein\
\[CloseCurlyQuote]s Field Equation (Cambridge University Press) eq. (12.14)):\
\
\>", "ExampleText",
 CellID->1038097723,ExpressionUUID->"013615b1-eaa4-4bef-a9ad-50100869561c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"ch", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"x", "[", "]"}], ",", 
      RowBox[{"y", "[", "]"}], ",", 
      RowBox[{"z", "[", "]"}]}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"kk", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<k\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"kk", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["E", 
             RowBox[{"x", "[", "]"}]]}], 
           RowBox[{"Cos", "[", 
            RowBox[{
             SqrtBox["3"], 
             RowBox[{"x", "[", "]"}]}], "]"}]}], ",", "0", ",", "0", ",", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["E", 
             RowBox[{"x", "[", "]"}]]}], 
           RowBox[{"Sin", "[", 
            RowBox[{
             SqrtBox["3"], 
             RowBox[{"x", "[", "]"}]}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          SuperscriptBox["E", 
           RowBox[{
            RowBox[{"-", "2"}], 
            RowBox[{"x", "[", "]"}]}]], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["E", 
             RowBox[{"x", "[", "]"}]]}], 
           RowBox[{"Sin", "[", 
            RowBox[{
             SqrtBox["3"], 
             RowBox[{"x", "[", "]"}]}], "]"}]}], ",", "0", ",", "0", ",", 
          RowBox[{
           SuperscriptBox["E", 
            RowBox[{"x", "[", "]"}]], 
           RowBox[{"Cos", "[", 
            RowBox[{
             SqrtBox["3"], 
             RowBox[{"x", "[", "]"}]}], "]"}]}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "ch"}], ",", 
       RowBox[{"-", "ch"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "ch", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[3]:=",
 CellID->924481581,ExpressionUUID->"cd11e155-77b6-43b9-842c-03e449c9f07c"],

Cell["and obtain its multiple Debever null directions:", "ExampleText",
 CellID->340800963,ExpressionUUID->"da3043bc-a3c1-424a-8ff3-38c8a765a02e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"kk", " ", 
          SuperscriptBox["E", 
           RowBox[{"x", "[", "]"}]], 
          RowBox[{"Cos", "[", 
           RowBox[{
            SqrtBox["3"], 
            RowBox[{"x", "[", "]"}]}], "]"}]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]], ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", "ch", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"bv", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "ch"}], ",", 
       RowBox[{"-", "ch"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[4]:=",ExpressionUUID->"9430adca-6d1c-4077-a419-24cb82685d48"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}], ",", " ", 
   RowBox[{"\"\<Bivector\>\"", "->", "bv"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[5]:=",
 CellID->349984709,ExpressionUUID->"6b7bbf62-5e5c-486c-981f-1f904fc137b2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1357956904,ExpressionUUID->"53b688d1-24c8-42ed-9862-af46a8cbe3bc"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->40428323,ExpressionUUID->"c040d50a-d432-4226-96f4-fee1f59be50b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->200199492,ExpressionUUID->"27832f2a-e62e-4a59-82fc-7767c54c65ed"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->914944930,ExpressionUUID->"579b2533-cb1a-41bf-9bdf-38ca112d5c70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->53285616,ExpressionUUID->"a78f5d7f-56a0-43b2-b9a1-382f9982523e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000819`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000819, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1127335999,ExpressionUUID->"36ec9d6e-ea9e-4f2d-8349-72970b7c1c5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "2.264202`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 2.264202, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1175955294,ExpressionUUID->"75ff0cf0-f3f3-4350-8869-78e172246e2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->258082200,ExpressionUUID->"7b5b4bde-a17d-407d-99f7-9120161f8965"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1601017655,ExpressionUUID->"524fbed4-1955-42c9-863d-2e686df1d998"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1893234523,ExpressionUUID->"aedacfb1-8c6d-46fe-bcbc-6dd864043e29"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1315599441,ExpressionUUID->"84ec8c03-22a5-4341-80a1-c1f1a2174d75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->170053423,ExpressionUUID->"b510804d-19b7-4dd2-afad-5f0e08701788"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->2070432172,ExpressionUUID->"ec9d13db-7572-490d-b814-a8421960dc71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->960457348,ExpressionUUID->"07658a55-4616-445c-aef7-4ef39a10089a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000798`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000798, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1988655692,ExpressionUUID->"c534ccd3-efd2-4e48-80b5-05edb85ca29a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.065678`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.065678, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1279696056,ExpressionUUID->"5a357c15-e162-4785-8f32-7b5d668fc651"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.002122`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "41888",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.002122, " seconds and ", 41888, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->412831267,ExpressionUUID->"880a93a1-c3ca-4fe0-bd8d-df8acef5db4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1408843370,ExpressionUUID->"7fd57841-a7c2-4dec-a317-3937bd7ebbe5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.004755`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.004755, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1228005106,ExpressionUUID->"efc36d13-d4de-4234-8bfd-65df85134786"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.05571`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.05571, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->613625818,ExpressionUUID->"fac436de-7695-43cc-809e-9fc9da999d20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.002819`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "29944",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.002819, " seconds and ", 29944, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->880752784,ExpressionUUID->"f7bab082-ebaf-4d25-9cdf-b1da452ec883"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->716925503,ExpressionUUID->"3fdb392f-7852-4620-959e-2f7dc511ed02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.00028`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.00028, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1409789729,ExpressionUUID->"90f6808d-2197-4eee-b233-c327d424cc08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.031659`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.031659, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1815347444,ExpressionUUID->"39934dbb-9175-4940-8a97-b12cf2f95a88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000302`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000302, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1718102184,ExpressionUUID->"0a222363-f698-438e-8c74-ceddf73dcc3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->800340296,ExpressionUUID->"2d3df40d-34f8-4a29-848b-89daeebdead2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000113`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000113, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1744371901,ExpressionUUID->"7c4b831b-7e74-4ea6-b937-ac0943b29a08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.024786`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.024786, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1481870291,ExpressionUUID->"a2d3090f-f54f-48e4-b394-35316aeb9df8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000226`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000226, " seconds and ", 64, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1265001489,ExpressionUUID->"8cd09a45-7a05-46bf-971c-e0f1d0a255dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->2051354177,ExpressionUUID->"13930ea3-8439-48a3-bc3b-2a4daadb36a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000659`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000659, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->692343547,ExpressionUUID->"73ad9b16-7a79-4cac-9891-f0d1ea7a27cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.042714`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.042714, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1305429812,ExpressionUUID->"72917d7d-c90b-451e-a276-4338cc14cb6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001191`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "41888",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001191, " seconds and ", 41888, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->104070021,ExpressionUUID->"6593993d-4544-419c-a789-6ef73bfbb37b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.086511`5.388616325649478", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.086511`5.388616325649478, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1607288477,ExpressionUUID->"bee41e10-a365-4a41-9e44-d987dd391e8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.071673`5.30690057650853", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.071673`5.30690057650853, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1358715429,ExpressionUUID->"80ea89e8-935d-4d0b-9caa-199addbf5fcc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001244`3.5463653738507706", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.001244`3.5463653738507706, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1231406020,ExpressionUUID->"9e29249b-5869-44f5-938c-ad1816b8e8d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.065511`5.267859222315292", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.065511`5.267859222315292, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1689786230,ExpressionUUID->"27f7a4f2-6646-4925-ad01-143151368c9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0.003636`4.012168868045901", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0.003636`4.012168868045901, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->387187075,ExpressionUUID->"311f1e09-4851-47cc-9d10-3651741f3fc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.025347`4.855471558327239", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"G2Form\" in ", 0.025347`4.855471558327239, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1489488220,ExpressionUUID->"19682b8a-9c50-422d-a0b3-8b640054dd82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.341863`5.9853970929314375", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.341863`5.9853970929314375, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1143320237,ExpressionUUID->"0192180f-ce9d-48a9-9bf3-90ffb7779776"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.055324`5.1944585661466585", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.055324`5.1944585661466585, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->132937950,ExpressionUUID->"ae9c89bc-7c44-409c-8614-dbf62f02fa57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.258237`5.8635634612660565", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.258237`5.8635634612660565, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->657604013,ExpressionUUID->"3dd30155-1799-4fe6-bf88-721d83fc0e87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0.00002`1.752574989159954", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.00002`1.752574989159954, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1313373661,ExpressionUUID->"5dc5ce06-cf8c-450a-998a-47757168d9e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.020032`4.753269305026309", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.020032`4.753269305026309, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->55886474,ExpressionUUID->"f4f42d17-5bbd-42f2-848c-8f9d910ab5f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.038856`5.04100308396095", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.038856`5.04100308396095, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1618061362,ExpressionUUID->"6a87537f-a7a8-43eb-976f-983e0095cdb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.09089`5.410061096919014", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.09089`5.410061096919014, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1154545705,ExpressionUUID->"4b184a54-8536-4ee7-a7b1-103463590dbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0.000104`2.4685783327947535", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.000104`2.4685783327947535, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->1335582531,ExpressionUUID->"59f65fd9-3c84-4774-b9e4-2c1bfd3c202f"],

Cell[BoxData["\<\"Type I\"\>"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->2030892629,ExpressionUUID->"e7e88a72-0d7d-4836-a9d1-9b6994e9bb75"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Since this metric is of Petrov Type I, it does not have any multiple Debever \
null direction.\
\>", "ExampleText",
 CellID->314540351,ExpressionUUID->"ccb55ab7-f974-4377-b148-a07713221009"],

Cell["\<\
If we now want to declare a new metric on the manifold, we need to unset the \
previous one and clear the Weyl concomitants saved on the cache:\
\>", "ExampleText",
 CellID->383569643,ExpressionUUID->"0afb36e6-d21f-47f7-9481-88dbd56c6795"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnsetCMetric", "/@", "$Metrics"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]}], "Input",\

 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[6]:=",
 CellID->812989402,ExpressionUUID->"0360e55b-74b3-490c-8aa6-b0c4e0b690d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"TODO", ":", " ", 
    RowBox[{
    "Add", " ", "the", " ", "option", " ", "of", " ", "clearing", " ", "all", 
     " ", "the", " ", "concomitants"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"TODO", ":", " ", 
    RowBox[{
    "It", " ", "is", " ", "a", " ", "bit", " ", "tiresome", " ", "to", " ", 
     "use", " ", "ClearxIdealCache", " ", "each", " ", "time"}]}], 
   "*)"}]}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[7]:=",
 CellID->267828646,ExpressionUUID->"68259d73-e86c-47fd-994d-543603eaf68d"],

Cell["\<\
Now we can declare a metric of Petrov type II (see Stephani H, Kramer D, \
MacCallum M A H, Hoenselaers C and Herlt E 2003 Exact Solutions of the \
Einstein\[CloseCurlyQuote]s Field Equation (Cambridge University Press) eqs. \
(33.25) and (33.30)):\
\>", "ExampleText",
 CellID->36750435,ExpressionUUID->"83e2ce50-e187-4f7d-a51e-41e7a155824a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"ch2", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"v", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"x", "[", "]"}], ",", 
      RowBox[{"y", "[", "]"}]}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"\[Kappa]", ",", 
    RowBox[{
    "PrintAs", "->", " ", 
     "\"\<\!\(\*SubscriptBox[\(\[Kappa]\), \(0\)]\)\>\""}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Kappa]", " ", 
           RowBox[{"x", "[", "]"}]}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", 
          FractionBox[
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SqrtBox["2"]}], 
           RowBox[{"4", " ", 
            RowBox[{"x", "[", "]"}]}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
          FractionBox[
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SqrtBox["2"]}], 
           RowBox[{"4", " ", "\[Kappa]", " ", 
            SuperscriptBox[
             RowBox[{"x", "[", "]"}], "2"]}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          FractionBox["3", 
           RowBox[{"2", "\[Kappa]", " ", 
            SuperscriptBox[
             RowBox[{"x", "[", "]"}], "3"]}]], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SqrtBox["2"]}], 
           RowBox[{"4", " ", 
            RowBox[{"x", "[", "]"}]}]], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SqrtBox["2"]}], 
           RowBox[{"4", " ", "\[Kappa]", " ", 
            SuperscriptBox[
             RowBox[{"x", "[", "]"}], "2"]}]], ",", "0", ",", 
          FractionBox[
           RowBox[{"-", "15"}], 
           RowBox[{"8", "\[Kappa]", " ", 
            SuperscriptBox[
             RowBox[{"x", "[", "]"}], "3"]}]]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "ch2"}], ",", 
       RowBox[{"-", "ch2"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "ch2", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[8]:=",
 CellID->9496957,ExpressionUUID->"03725d35-62be-4033-ac15-756cdc5205ce"],

Cell["and determine its multiple Debever null directions:", "ExampleText",
 CellID->314375278,ExpressionUUID->"601f828d-89eb-45fa-88e5-b35fd931eede"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[Kappa]", " ", 
          RowBox[{"x", "[", "]"}]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]], ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", "ch2", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bv", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "ch2"}], ",", 
       RowBox[{"-", "ch2"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[9]:=",
 CellID->198482489,ExpressionUUID->"22366b2d-43f2-43e8-b4e0-8ab54e577367"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}], ",", " ", 
   RowBox[{"\"\<Bivector\>\"", "->", "bv"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[10]:=",
 CellID->195155793,ExpressionUUID->"8753a13a-15f3-4854-8766-332c428f374e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->415905427,ExpressionUUID->"fbe29e79-8a2d-4aea-b02a-f67a63efe39b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->416103989,ExpressionUUID->"d3b0e2b0-50e0-4ec8-b5a0-432facd5e90c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->497034799,ExpressionUUID->"8c4d1cdc-f1e2-41a8-a77a-e82bdf88cf45"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1296658211,ExpressionUUID->"df74f91a-d470-4727-83c2-3db834338b60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1133029492,ExpressionUUID->"b781dad5-fe32-462e-9a52-3f1229b2ea69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000693`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000693, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1906824529,ExpressionUUID->"f0d77161-231c-48bd-bc51-e2207e754d8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.023095`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.023095, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->964522007,ExpressionUUID->"3810c559-d61c-45bb-a5c3-4d2163dd676d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->703648029,ExpressionUUID->"76c99fe2-d675-43bd-93e9-4e740ca813c9"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->559681177,ExpressionUUID->"5d85d291-0b60-4d31-9b3b-c05fe67f0342"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->561410260,ExpressionUUID->"2a097b2c-33d4-4afe-8310-677216d9836d"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->38034672,ExpressionUUID->"3c197651-bc66-4ae9-8dd9-07112daa4c2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1824682666,ExpressionUUID->"977660c9-6e8d-4fd4-9092-a4d64498c1a7"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->465280790,ExpressionUUID->"27fd90de-01b1-48c8-94e1-ef348f711e2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->730378219,ExpressionUUID->"6208cf52-6fce-4b34-a5b1-9b8e227189e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000787`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000787, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->982628831,ExpressionUUID->"d493ff9e-5035-40ef-ad9b-7a6190a2af81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.029922`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.029922, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->569350811,ExpressionUUID->"8327a242-2223-4f4d-9564-aa89f4d7202b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001101`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "21120",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001101, " seconds and ", 21120, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->190183049,ExpressionUUID->"46a234ff-63f6-4061-bbf9-42505eec7e74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->193860612,ExpressionUUID->"f6513cb9-9168-44bf-b31c-e0b3c8ad6c3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.002933`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.002933, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1800756832,ExpressionUUID->"2a0f2ada-1348-4aa4-837b-71d93e0fe1e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.043375`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.043375, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1879969279,ExpressionUUID->"f0732192-529d-432a-bc12-805d482d3767"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001045`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "23840",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001045, " seconds and ", 23840, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->581047687,ExpressionUUID->"840f5e7f-eff5-4d3e-bc60-fe362e1e5894"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1142761404,ExpressionUUID->"98b6d9ec-6277-4700-9387-511ddbc1b097"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000192`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000192, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->875805868,ExpressionUUID->"104c9c59-787e-4931-b73a-d17d8110f30c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.006902`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.006902, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->713985638,ExpressionUUID->"db01e5a5-4e55-495c-a644-e01a0bcd9757"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000202`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "1240", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000202, " seconds and ", 1240, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1800365418,ExpressionUUID->"c06b144f-2e48-48a5-8ae1-c9b5c8aedf6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->41695881,ExpressionUUID->"47d2f125-7fea-4052-a3a2-e9b294d3381d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000099`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000099, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->769872112,ExpressionUUID->"c8373598-532d-4838-a806-057b36d8ed57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.038174`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.038174, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1270943132,ExpressionUUID->"96231247-98ab-4c60-959c-80e92eead760"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000157`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "144", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000157, " seconds and ", 144, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1196241587,ExpressionUUID->"87ba1335-8f8e-4ab3-aa18-efc7df6c935e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->2105454643,ExpressionUUID->"bd177063-f207-43a5-ada3-e00274f51609"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000836`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000836, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1154352113,ExpressionUUID->"4f5aa81d-78fb-4e88-a8d8-25630c2dfd28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.030468`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.030468, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1612147014,ExpressionUUID->"38e25ae9-4814-4341-a7c5-2655e7f4c863"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000911`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "22000",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000911, " seconds and ", 22000, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->374074985,ExpressionUUID->"2c53ae59-766d-453a-9042-529254b1abec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.037423`5.024683593100949", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.037423`5.024683593100949, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1651386912,ExpressionUUID->"28ec4230-6429-4a19-a3ef-d9402dd86778"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.021113`4.776094941198526", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.021113`4.776094941198526, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->761321578,ExpressionUUID->"285e4093-74d1-4f92-8e14-9c98befd5255"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001513`3.631383921519158", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.001513`3.631383921519158, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1507104477,ExpressionUUID->"53d05e93-db2a-4caf-9296-127c7acb0836"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.022329`4.800414267207505", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.022329`4.800414267207505, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1410727793,ExpressionUUID->"32e78755-4f55-4a6d-922a-3ebeb6633d8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0.003936`4.046600083255277", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0.003936`4.046600083255277, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1725843585,ExpressionUUID->"0edf0459-dcc7-4e7d-b9ca-452abb6a00e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.008952`4.403465067016267", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"G2Form\" in ", 0.008952`4.403465067016267, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->63268858,ExpressionUUID->"14be46bb-8367-448e-8e68-0ae485cfe9db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.21752`5.789044188075417", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.21752`5.789044188075417, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1970408971,ExpressionUUID->"4ecbe660-c691-49f7-bcf9-a30742d8c55c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.051554`5.163807360701022", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.051554`5.163807360701022, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->139770198,ExpressionUUID->"69d37c06-605a-4fdd-93d1-33675e2836e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.170253`5.682639766779572", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.170253`5.682639766779572, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->101303530,ExpressionUUID->"198f2443-084a-4fbc-9c6e-e40c621021a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0.000026`1.8665183414667905", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.000026`1.8665183414667905, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1647607989,ExpressionUUID->"f4196aaa-9d0a-4115-931e-1ba76ee53ab0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.049217`5.1436601314455865", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.049217`5.1436601314455865, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->605050988,ExpressionUUID->"9ceb8dfc-7660-4528-9dda-7e359c76279a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.056295`5.202014816964739", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.056295`5.202014816964739, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->831681750,ExpressionUUID->"50838cef-072b-47e5-b964-dcfd5a380dd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.178947`5.70426941544878", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.178947`5.70426941544878, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->482753172,ExpressionUUID->"c7fac7b5-3453-41b4-811f-52c6934b306a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0.000193`2.7371023025037444", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.000193`2.7371023025037444, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1174401799,ExpressionUUID->"19fbcdec-3ba2-4875-a575-f6e598484918"],

Cell[BoxData["\<\"Type II\"\>"], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1021864799,ExpressionUUID->"fb1d034e-fd8b-4cd1-9495-d3d40916a36d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorScQ\\\" \
in \"\>", "\[InvisibleSpace]", "0.006502`4.264591958656078", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScQ\" in ", 
   0.006502`4.264591958656078, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->676613784,ExpressionUUID->"21eb3576-04b6-4a87-a23d-b0906b981b34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScQ\\\" in \"\>", 
   "\[InvisibleSpace]", "0.009535`4.430865690878", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorScQ\" in ", 0.009535`4.430865690878, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->827674983,ExpressionUUID->"fcd64aaa-04da-4e58-9557-f86ddbf251a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"PTIICanonicalBivector1\\\" in \"\>", "\[InvisibleSpace]", 
   "0.008024`4.355935913508337", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"PTIICanonicalBivector1\" in \
", 0.008024`4.355935913508337, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->754350430,ExpressionUUID->"fdce85fb-b563-4968-9530-a17983f200d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"PTIICanonicalBivector1\\\" in \"\>", "\[InvisibleSpace]", 
   "0.024448`4.839788330391567", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"PTIICanonicalBivector1\" in ", 
   0.024448`4.839788330391567, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1257661472,ExpressionUUID->"d3294443-d77b-4a1c-9bf6-51c57b39f1d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorH\\\" \
in \"\>", "\[InvisibleSpace]", "0.003904`4.043054802490629", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorH\" in ", 
   0.003904`4.043054802490629, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1970436388,ExpressionUUID->"875aa6f1-1757-438d-8856-862e07e391f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorH2\\\" \
in \"\>", "\[InvisibleSpace]", "0.007723`4.339331028334344", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorH2\" in ", 
   0.007723`4.339331028334344, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1630156298,ExpressionUUID->"4acc9a4e-5b5c-46ca-afc6-6a0d6bc3f40e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorH2\\\" in \"\>", 
   "\[InvisibleSpace]", "0.000305`2.935844832842761", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorH2\" in ", 0.000305`2.935844832842761, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1971647110,ExpressionUUID->"0d339abf-2f26-454a-b038-390cc7cab11b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WNullDirectionTypeII\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000909`3.4101088767179406", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WNullDirectionTypeII\" in ",
    0.000909`3.4101088767179406, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1623318158,ExpressionUUID->"19e8cd36-8160-4db2-96b3-67c6ebf3b2ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"WNullDirectionTypeII\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001854`3.719654723304449", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WNullDirectionTypeII\" in ", 
   0.001854`3.719654723304449, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1671852180,ExpressionUUID->"7f5f63f5-e447-4b4f-a56e-be81e9f005c9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SqrtBox[
        FractionBox["2", "3"]]}], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Kappa]", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["x",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`x[],
       Editable->False]}], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       SqrtBox["3"], 
       RowBox[{"2", " ", 
        InterpretationBox[
         StyleBox["x",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`x[],
         Editable->False]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "ch2"}], "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->594035574,ExpressionUUID->"5c2d6702-579b-4015-aa9b-9dda32bbe366"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"Method", "->", "\"\<PetrovMatrix\>\""}], ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[11]:=",
 CellID->173070296,ExpressionUUID->"058ce5b5-09a4-4fb9-84fd-35c5c95c6ba7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->746777642,ExpressionUUID->"3f4ce4df-b5a6-467d-9995-e79c78b415c5"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->720610119,ExpressionUUID->"22af1331-7674-4b7b-8baa-e794cba6c0d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->552006570,ExpressionUUID->"0ae5ca0c-7f28-43f7-b3e7-de37be552ec2"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1901129755,ExpressionUUID->"29e5e10e-63a4-443f-90cd-f9c283a0b6bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->185273485,ExpressionUUID->"f5014cff-2a8f-4d81-b7cf-ce6759022575"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->926081555,ExpressionUUID->"af4700ee-0e07-4e29-9abf-e5c642138196"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1405033019,ExpressionUUID->"9c2127e1-84a4-45ee-899b-770009a13a3f"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->946595063,ExpressionUUID->"923af294-827a-42b2-a18e-a92e09f4dec5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->285702384,ExpressionUUID->"704ee7eb-3fcd-4a7d-a0db-d070014a9e1b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->668277165,ExpressionUUID->"809cf22c-37d5-494c-bf5e-153b8e7ba801"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->524955001,ExpressionUUID->"505a982c-00d7-4d96-b7da-73a67e432401"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->348971243,ExpressionUUID->"15b5ba63-6b58-4fca-b46f-0c00949e021f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->491202488,ExpressionUUID->"75a18830-082f-4908-9900-282c0d273f0b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->664725199,ExpressionUUID->"74d180ae-1462-4cda-9382-a24ec2513579"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->450274773,ExpressionUUID->"611256cc-9c97-434d-9e71-d8231a67c7f3"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->2138810477,ExpressionUUID->"9a9105de-eae7-4a76-bb28-64e2aee5d6cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1269776187,ExpressionUUID->"1c641a9a-ca7f-4726-b1d7-2f81db703c1c"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1281956523,ExpressionUUID->"431f93ca-afe3-4dbd-9e98-313e56cec740"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->474080002,ExpressionUUID->"6a9d407b-df97-41fb-bbf6-be20689aad8e"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->296694338,ExpressionUUID->"0e81b369-64d7-427c-ab86-7395a66da356"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->156337674,ExpressionUUID->"ddb1b537-970d-4825-8434-7f21371f84c0"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1150693786,ExpressionUUID->"0888de53-8c2e-49d5-95a1-b2770d1a260f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.014477`4.61222356789636", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.014477`4.61222356789636, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1124369322,ExpressionUUID->"a8a2ee7b-c1c8-4c98-94a3-dc4218960cf4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.00024`2.8317562352075787", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.00024`2.8317562352075787, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->910688104,ExpressionUUID->"16fde88a-7268-4654-a9a7-6a69d6a3fd05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001912`3.733032881436054", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.001912`3.733032881436054, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->260871610,ExpressionUUID->"0b64d893-5c3e-400a-b2d2-4d1fb1bcf953"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.000268`2.879679787524764", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.000268`2.879679787524764, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->947322062,ExpressionUUID->"e1cb241e-e54b-4fff-a71c-c8a52418c894"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylMatrixQ\\\
\" in \"\>", "\[InvisibleSpace]", "0.038424`5.036147567126878", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ\" in ", 
   0.038424`5.036147567126878, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->393360755,ExpressionUUID->"51ca7242-8069-45df-ae32-a266e567f3a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ\\\" in \
\"\>", "\[InvisibleSpace]", "0.004011`4.054797655477622", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ\" in ", 0.004011`4.054797655477622, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->85035072,ExpressionUUID->"565f5891-e72c-4c41-b12c-b3e2f7ddab43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"SpatialMetric\\\" in \"\>", "\[InvisibleSpace]", 
   "0.007082`4.301700915918068", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"SpatialMetric\" in ", 
   0.007082`4.301700915918068, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->423156572,ExpressionUUID->"fca35861-f319-423f-9258-32bd7db576f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"SpatialMetric\\\" in \
\"\>", "\[InvisibleSpace]", "0.001288`3.5614608565197687", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"SpatialMetric\" in ", 
   0.001288`3.5614608565197687, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->2065212935,ExpressionUUID->"0b586e04-bc66-4e38-b10a-bc4715551774"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.009135`4.4122535451845275", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ2\" in ", 
   0.009135`4.4122535451845275, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->679070647,ExpressionUUID->"1494727e-2112-4354-a7f7-7d1f9a5d5a3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ2\\\" in \
\"\>", "\[InvisibleSpace]", "0.005575`4.197789865216169", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ2\" in ", 0.005575`4.197789865216169, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1169934214,ExpressionUUID->"55b41350-c4ac-4cb8-b3d3-084992f8f3f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.009872`4.445950140185137", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.009872`4.445950140185137, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->638339406,ExpressionUUID->"6bfda3a0-a8b4-4c9d-b87f-e0644dc42822"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ2\\\" \
in \"\>", "\[InvisibleSpace]", "0.000035`1.9956130378462489", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.000035`1.9956130378462489, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1231077217,ExpressionUUID->"54dc68ee-80f0-4a66-b3be-d7ef6119e107"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001154`3.5137508023156876", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ3\" in ", 
   0.001154`3.5137508023156876, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->923580321,ExpressionUUID->"48d1c7ea-9026-40d7-99e8-c19e9d49d311"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ3\\\" in \
\"\>", "\[InvisibleSpace]", "0.002558`3.859445533638606", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ3\" in ", 0.002558`3.859445533638606, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->823612891,ExpressionUUID->"8ab1cf07-4ba9-4862-8c85-7d13e9cc9015"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.008073`4.35857994597939", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   0.008073`4.35857994597939, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->9675124,ExpressionUUID->"16aa9354-b8d9-4134-81d3-71ca615f31bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ3\\\" \
in \"\>", "\[InvisibleSpace]", "0.000234`2.820760850906114", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   0.000234`2.820760850906114, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->181129692,ExpressionUUID->"de192018-466a-492a-bf27-541198c37aaf"],

Cell[BoxData["\<\"Type II\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1770207955,ExpressionUUID->"7ce01672-5b8d-4a5c-a91b-c8709e941115"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"ScalarRho\\\" \
in \"\>", "\[InvisibleSpace]", "0.000025`1.8494850021680107", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"ScalarRho\" in ", 
   0.000025`1.8494850021680107, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->295377508,ExpressionUUID->"e7e8a88c-3d85-4957-8f97-941c7c93408c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"ScalarRho\\\" in \"\>", 
   "\[InvisibleSpace]", "0.000025`1.849485002168013", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"ScalarRho\" in ", 0.000025`1.849485002168013, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->849406857,ExpressionUUID->"7d2ba331-20b9-4a81-a099-cc9740673b75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorP\\\" \
in \"\>", "\[InvisibleSpace]", "0.000794`3.351365495923069", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorP\" in ", 
   0.000794`3.351365495923069, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->147679308,ExpressionUUID->"9167b50d-d2f1-4fa6-9394-2541ef524791"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorP\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0006310000000000001`3.2515743527401053", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorP\" in ", 
   0.0006310000000000001`3.2515743527401053, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->644348751,ExpressionUUID->"599fab5d-d18b-4fb6-855b-6b9fc582a90f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"NullDirectionTypeII\\\" in \"\>", "\[InvisibleSpace]", 
   "0.040388`5.057797341083647", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"NullDirectionTypeII\" in ", 
   0.040388`5.057797341083647, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1340609345,ExpressionUUID->"329c18ae-971f-4a98-a7fc-ea031a30ac09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"NullDirectionTypeII\\\" \
in \"\>", "\[InvisibleSpace]", "0.004779`4.130882024016767", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"NullDirectionTypeII\" in ", 
   0.004779`4.130882024016767, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->812404507,ExpressionUUID->"37d4cc62-3b03-4092-8790-fa4cab909d8f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["4", "9"]}], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Kappa]", "0"],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Kappa],
        Editable->False], "4"], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["x",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`x[],
        Editable->False], "4"], " ", 
      SqrtBox[
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubscriptBox["\[Kappa]", "0"],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Kappa],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox["x",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`x[],
         Editable->False]}]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "ch2", "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[11]=",
 CellID->1094623525,ExpressionUUID->"2c40e989-501e-4bea-8a93-580bf005b59a"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"383cf5bd-20e0-40be-b538-67e2b3ffbb4d"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"32d5e211-ed42-43e7-bbb5-bdedb6e83e7f"],
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount",ExpressionUUID->
  "38246836-892b-4114-9b2f-bdcb5c28069e"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"5edb2320-4eb6-4ce1-89f9-1cf2372daa4e"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"02e2be9a-24af-4d03-b8be-88863e92eae2"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"3bf10918-6872-4623-9cb3-de221e2063e2"],
 "Method and Observer",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "c3fb0783-394d-4fb8-ac2b-27734b4e75ba"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"bb880758-946c-4e54-bad3-94ef77348f2b"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsubsection", "0"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"60192a8a-b646-45ce-adc5-466358817ab3"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"61fd705a-e310-46f4-8ec8-c6be33f09721"],
 "WeylSelfdual",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a5a34cff-83fb-469c-a524-f3a8063551a9"]
}], "ExampleSubsubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->101096468,ExpressionUUID->"eeeab065-e1c7-47b4-b893-5c7ac78267a3"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[19]:=",
 CellID->1331936175,ExpressionUUID->"6c301771-0f6f-4778-88e5-fbee65b4fe61"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";", 
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[1]:=",
 CellID->2082180694,ExpressionUUID->"97364013-e3a1-4526-8daa-cb72f0379943"],

Cell["\<\
This is the method used by default, but we can also specify it. Let us \
declare the Schwarzschild metric, the observer and the arbitrary bivector:\
\>", "ExampleText",
 CellID->56015443,ExpressionUUID->"4b77643d-66e9-4b40-a476-60606a1c6cea"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"Schw", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"\[Theta]", "[", "]"}], ",", 
      RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"mm", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<m\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "]"}], ">", "0"}], "&&", " ", 
    RowBox[{"mm", ">", "0"}], "&&", " ", 
    RowBox[{"Pi", ">", 
     RowBox[{"\[Theta]", "[", "]"}], ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"2", 
       RowBox[{"mm", "/", 
        RowBox[{"r", "[", "]"}]}]}]}], ">", "0"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "mm"}], 
          RowBox[{"r", "[", "]"}]]}], ")"}]}], ",", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "mm"}], 
          RowBox[{"r", "[", "]"}]]}], ")"}], 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox[
       RowBox[{"r", "[", "]"}], "2"], ",", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"r", "[", "]"}], "2"], 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Schw"}], ",", 
       RowBox[{"-", "Schw"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "Schw", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[2]:=",
 CellID->55503591,ExpressionUUID->"d44cd67d-cb72-4a61-a10b-370c08c49279"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "mm"}], 
           RowBox[{"r", "[", "]"}]]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]], ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", "Schw", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bv", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Schw"}], ",", 
       RowBox[{"-", "Schw"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[8]:=",
 CellID->153306904,ExpressionUUID->"c8112747-0ab5-4f3e-a805-b01482780540"],

Cell["\<\
Now, we specify the desired method to determine its multiple Debever null \
directions by using the following syntax:\
\>", "ExampleText",
 CellID->353703688,ExpressionUUID->"9a3243d6-5987-4e44-a6fd-d5110a281a27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"Method", "->", " ", "\"\<WeylSelfdual\>\""}], ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}], ",", " ", 
   RowBox[{"\"\<Bivector\>\"", "->", "bv"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[10]:=",
 CellID->348469371,ExpressionUUID->"3e5f52c7-6fbe-4f8f-b11b-a97b3a873ccd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->2010397025,ExpressionUUID->"c4400149-1fc6-4645-9e01-fefcd6386fdf"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->297634757,ExpressionUUID->"0c37a350-2b26-4a23-a403-6594813718ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1143389371,ExpressionUUID->"e2dd42b5-e644-4f52-b2e4-2d79ad107400"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1085763224,ExpressionUUID->"5c68e22b-366f-4fd0-b38b-d366296d6cd5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1852957886,ExpressionUUID->"bd48e5e6-b5a1-4871-a67d-53772614b107"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000713`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000713, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1835473857,ExpressionUUID->"08196071-3c93-48ac-accf-d5758b052b90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "2.357267`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 2.357267, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->453923065,ExpressionUUID->"1d3d7999-a5a1-45f2-ab8b-6fc9750f06d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1192479202,ExpressionUUID->"5080226f-3f45-4b64-b156-05d80c6bdf3d"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1619816650,ExpressionUUID->"09172591-8a11-4a3d-85f0-a7e820a4b381"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->386824419,ExpressionUUID->"650bdd3e-17b1-4f80-bc64-18cb15a0b09a"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->484181593,ExpressionUUID->"ca70413d-d293-42ab-a91b-b9397cabf1c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->515767878,ExpressionUUID->"e2e78551-d17e-434a-b97b-cffaa7b52c91"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->2125741950,ExpressionUUID->"acc172ee-c5d6-4ed5-904a-d4b7774a01ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->7275368,ExpressionUUID->"5b8c9e41-2114-414d-91fd-6e82e33d6e94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000775`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000775, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1944636829,ExpressionUUID->"5d7f9966-4d16-4f3f-8e83-f9324c99fa7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.046334`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.046334, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->378918501,ExpressionUUID->"820891cb-0f71-43d6-aa2d-eb2d79312885"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001008`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "15040",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001008, " seconds and ", 15040, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->886129850,ExpressionUUID->"91201b4d-bf98-46c3-a5e2-bcd1f1a83a36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->374660664,ExpressionUUID->"87a726eb-d977-47a1-96e7-b206328d7cd5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.002087`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.002087, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1849676625,ExpressionUUID->"417628ad-2e8f-4d82-a934-5d80926d3f67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.033574`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.033574, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1920583453,ExpressionUUID->"6c5b9fb7-2d04-4bc4-a217-01a11b6a0337"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000781`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "14432",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000781, " seconds and ", 14432, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->494167433,ExpressionUUID->"d0ae2267-815a-402e-af10-1963dd80806d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->180600452,ExpressionUUID->"3fc70c9b-7a7e-4053-be1a-0b61afed199b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000166`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000166, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1386309100,ExpressionUUID->"cd8f2b24-907b-4691-b8bd-7922e8b77573"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.012351`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.012351, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->73402775,ExpressionUUID->"dc81c5b2-b46b-46a1-8723-0d9518ff0eea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000215`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000215, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->345727925,ExpressionUUID->"5cfb56c5-a330-44b1-b482-ecdde66f9c59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->453241005,ExpressionUUID->"07bf63a8-a3fb-43b4-8ebc-d6a2ca7b4a29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000076`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000076, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1898189745,ExpressionUUID->"589fafd1-8eea-4ad8-8335-80350a4fe4c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.026684`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.026684, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1428652612,ExpressionUUID->"a2701938-e440-4875-b86b-f8bed694cc92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000227`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000227, " seconds and ", 64, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->44959490,ExpressionUUID->"06054fd2-96dd-4eef-9648-71cea0c18c4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->349690290,ExpressionUUID->"87bb05ea-7bde-49fb-99a1-c15fe3985da4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000489`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000489, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1291565989,ExpressionUUID->"236635ee-bdad-483e-9ca9-b1cb02cb3464"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.041842`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.041842, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->342594247,ExpressionUUID->"eeb7f104-01e3-4edb-8d53-d90c108510d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000798`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "15040",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000798, " seconds and ", 15040, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1493079661,ExpressionUUID->"8dd83348-3f40-4119-87e4-86c2a85c1d48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.036535`5.014254105177207", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.036535`5.014254105177207, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->229845566,ExpressionUUID->"cfa21698-b51d-47f8-9c37-930a03ed8953"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.027426`4.889707465168949", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.027426`4.889707465168949, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->48068486,ExpressionUUID->"b7eef08f-a60e-4a3b-b809-382127eff0c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000601`3.230419465498714", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.000601`3.230419465498714, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1181069870,ExpressionUUID->"03a16fae-3744-496c-887c-bddb6c2ddd7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.027896`4.897086927863895", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.027896`4.897086927863895, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1035323741,ExpressionUUID->"4137810d-76b3-405d-9fa0-fb85f55aa3c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0.002556`3.8591058429823333", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0.002556`3.8591058429823333, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->501991551,ExpressionUUID->"ea34be33-954e-4d96-b14f-f790cdb20bea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.032995`4.969993126194114", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"G2Form\" in ", 0.032995`4.969993126194114, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->226065424,ExpressionUUID->"b864d2ad-3fc9-45c7-84e2-df2c779db497"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.095966`5.433662386662446", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.095966`5.433662386662446, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->507656743,ExpressionUUID->"7768b1d0-b451-4634-b9ba-89f9d353299a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.048693`5.139011525965653", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.048693`5.139011525965653, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->888815971,ExpressionUUID->"f8cd032e-92f7-414d-ac2d-c7b0be9a18a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.101668`5.458729273751085", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.101668`5.458729273751085, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->710247017,ExpressionUUID->"a3f2e520-bb0a-4bb1-929f-b376c33cd2d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0.000292`2.9169278449443916", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.000292`2.9169278449443916, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1023424622,ExpressionUUID->"68ca771b-d8c1-469f-93a1-e3a4b23cbfd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.010478`4.4718233876079", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.010478`4.4718233876079, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->867074273,ExpressionUUID->"b109ae88-b33b-4409-97ea-a17dd5be7f33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.048001`5.132795278579018", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.048001`5.132795278579018, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->717522386,ExpressionUUID->"bd80f311-d920-44c6-9fe6-5578b367c645"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.101302`5.457163013193763", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.101302`5.457163013193763, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->820577803,ExpressionUUID->"efe24b92-8cbf-4ee9-9d9b-80fa0bd027a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0.0003`2.9286662482156354", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.0003`2.9286662482156354, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1245992774,ExpressionUUID->"b5997426-0246-4775-a27f-d2620d64e48d"],

Cell[BoxData["\<\"Type D\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1603652236,ExpressionUUID->"c457d5fb-dffc-4972-aa09-33c16b9eae9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorScP\\\" \
in \"\>", "\[InvisibleSpace]", "0.001091`3.4893697440843168", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScP\" in ", 
   0.001091`3.4893697440843168, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1195238467,ExpressionUUID->"81edb7b6-5122-4a09-ae61-096980bac399"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScP\\\" in \"\>", 
   "\[InvisibleSpace]", "0.006103`4.237088363452566", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorScP\" in ", 0.006103`4.237088363452566, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->948185752,ExpressionUUID->"946584a0-6f1c-4099-bf14-80a3c3c8b887"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TensorScP2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.038365`5.035480196032725", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScP2\" in ", 
   0.038365`5.035480196032725, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1376752041,ExpressionUUID->"c2647b6f-5ee4-4336-9160-cbefa683085c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScP2\\\" in \"\>",
    "\[InvisibleSpace]", "0.007784`4.342747820756266", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorScP2\" in ", 0.007784`4.342747820756266, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1689405900,ExpressionUUID->"cd6a2b2a-5042-47a4-96dc-631573f5340d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"PTDCanonicalBivector\\\" in \"\>", "\[InvisibleSpace]", 
   "0.005026`4.1527674777525325", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"PTDCanonicalBivector\" in ",
    0.005026`4.1527674777525325, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1128786204,ExpressionUUID->"a8470701-4388-41b5-87ec-ace793118594"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"PTDCanonicalBivector\\\" in \"\>", "\[InvisibleSpace]", 
   "0.013008`4.565755521745964", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"PTDCanonicalBivector\" in ", 
   0.013008`4.565755521745964, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->615577493,ExpressionUUID->"aee99cec-3092-4ae2-a799-ffa829776a38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WNullDirectionTypeDPlus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.00412`4.066442209529108", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WNullDirectionTypeDPlus\" \
in ", 0.00412`4.066442209529108, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1762808676,ExpressionUUID->"cd201646-d57b-469b-9588-0d23ec2168cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WNullDirectionTypeDPlus\
\\\" in \"\>", "\[InvisibleSpace]", "0.034087`4.984133774109508", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WNullDirectionTypeDPlus\" in ", 
   0.034087`4.984133774109508, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1474514129,ExpressionUUID->"e8ae603f-d2fd-47c8-9ef4-63e20f062a88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WNullDirectionTypeDMinus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001933`3.7377768475245237", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WNullDirectionTypeDMinus\" \
in ", 0.001933`3.7377768475245237, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1068818499,ExpressionUUID->"500bca8a-ba17-45c2-a445-40578e027b33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"WNullDirectionTypeDMinus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.007416`4.321714714632414", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WNullDirectionTypeDMinus\" in ", 
   0.007416`4.321714714632414, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1513514773,ExpressionUUID->"42f65557-50d7-4956-ba38-6da8fc210d05"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SqrtBox[
        FractionBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]}]]], ",", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SqrtBox[
        FractionBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]}]]], ",", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["m",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`mm,
           Editable->False]}], "-", 
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False]}], 
        SqrtBox[
         RowBox[{
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             InterpretationBox[
              StyleBox["m",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mm,
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]}], ")"}]}]]], ",", "0", ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->755683093,ExpressionUUID->"750ac0a5-450f-48a5-aacb-af086e99f3a0"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsubsection", "0"},
   Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsubsection", "1"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"6a05de77-ba0f-47f5-bce3-f7c051ee9ab7"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"291c0e97-edfc-4d2e-8dff-4da1aceaa67b"],
 "PetrovMatrix",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "46f99cca-3914-4b05-aaca-27f631f34a43"]
}], "ExampleSubsubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->17838787,ExpressionUUID->"41da11e5-eba6-49f4-9425-70eab266c7f3"],

Cell[TextData[{
 "The ",
 StyleBox["DebeverNullDirections", "Input"],
 " function can also determine the multiple Debever null directions of a \
metric by using the Petrov Matrix method. In that case however, it does not \
need an arbitrary bivector but, if metric is of Petrov Type D, an arbitrary \
vector or nothing otherwise. Let us first clear the cache:"
}], "ExampleText",
 CellID->487371356,ExpressionUUID->"b314aeca-ae50-4d4f-98a6-02c7a703481b"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",\

 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[11]:=",
 CellID->132427965,ExpressionUUID->"851e2fcb-f338-44eb-ad5a-830ebd737084"],

Cell["\<\
Now, since Schwarzschild is of Petrov Type D, we define an arbitrary vector:\
\>", "ExampleText",
 CellID->461760098,ExpressionUUID->"865928af-e172-4575-b554-e72c14b0bc16"],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "mm"}], 
           RowBox[{"r", "[", "]"}]]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"2", "mm"}], 
            RowBox[{"r", "[", "]"}]]}], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], "/", "2"}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"2", "mm"}], 
            RowBox[{"r", "[", "]"}]]}], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], "/", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", "Schw", "}"}]}], "]"}]}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[12]:=",
 CellID->49066715,ExpressionUUID->"76541119-2d72-4d87-ac7b-9c05634b4518"],

Cell[TextData[{
 "and now use the ",
 StyleBox["DebeverNullDirections", "Input"],
 " function:"
}], "ExampleText",
 CellID->459508800,ExpressionUUID->"b093a3d7-7972-4941-b7e4-28451c34f517"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"Method", "->", "\"\<PetrovMatrix\>\""}], ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}], ",", " ", 
   RowBox[{"\"\<Vector\>\"", "->", "w"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[13]:=",
 CellID->150318374,ExpressionUUID->"af4709a3-330a-4f2c-84ea-8cbcb586be40"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1113777989,ExpressionUUID->"edfe89bc-611d-4b60-a55f-bd7507e1525c"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1863205064,ExpressionUUID->"86e3f132-19c7-44d5-9626-72ff86e74684"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2047249083,ExpressionUUID->"0f261d15-0cdd-48d1-bdbc-517cb20d3d79"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1456372237,ExpressionUUID->"ae1ad00c-a5c6-4aec-90be-009776f7fb47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1208801077,ExpressionUUID->"f5406df7-4de1-4820-9039-e6f364bdaddb"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->129611001,ExpressionUUID->"2aed1549-8c03-4cd0-8f6e-b171df751657"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1504440723,ExpressionUUID->"68497844-d48c-4fbb-93e5-a2aecffac64b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->242387300,ExpressionUUID->"e5f9627c-b652-4db1-92f4-abf8d27019fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1164934742,ExpressionUUID->"66c45e68-9383-484e-9680-a9bc4e7d9a2c"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2006432274,ExpressionUUID->"6e67593f-64ec-43db-806a-0fca039a79ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->468452724,ExpressionUUID->"4d678b38-7cd3-465a-8535-b725f98347fb"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1672591485,ExpressionUUID->"695f67ef-925a-4869-8c78-73524a7346a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->747764597,ExpressionUUID->"35d67c74-ab83-454b-910a-d0cb71bf5f60"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1178699742,ExpressionUUID->"bed23133-656d-4537-962c-c5453d8e22e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->548532459,ExpressionUUID->"2682cc90-06a5-4306-9a2c-140c0768c5ed"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1614838871,ExpressionUUID->"cad40430-dcff-485f-9389-fda7e84ef775"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1896222128,ExpressionUUID->"a8c1f329-171c-4ff1-a216-763096c15e2d"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1369110263,ExpressionUUID->"70c45a5c-96e3-441d-ad52-c27cf55e3052"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->713347997,ExpressionUUID->"2e60b9df-5e66-42f6-bcd5-2935664df531"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1352390716,ExpressionUUID->"9e572405-89ff-4c7d-9018-17005b4463b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->416865082,ExpressionUUID->"0c69cf7e-b012-41da-9ada-b6d7a1b1d942"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1661533749,ExpressionUUID->"d0ff1e4e-cefc-4792-93c3-0c42cbfe10b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.008871`4.399517572741751", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.008871`4.399517572741751, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->581659110,ExpressionUUID->"4014b8a3-d813-4e06-821c-eb30d707d32a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.000179`2.7043980244758683", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.000179`2.7043980244758683, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2106270983,ExpressionUUID->"8b070bf5-9223-42db-9881-c5b018a9e90b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0006`3.2296962438796166", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.0006`3.2296962438796166, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->642836306,ExpressionUUID->"0fc85277-41ae-4e01-adc3-71a8d783ff82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.000135`2.581878761990979", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.000135`2.581878761990979, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1197236603,ExpressionUUID->"ae5c7fc0-dd2c-4982-86e1-446037ce24b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylMatrixQ\\\
\" in \"\>", "\[InvisibleSpace]", "0.030186`4.931350561205363", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ\" in ", 
   0.030186`4.931350561205363, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1721596011,ExpressionUUID->"bd21f42e-df00-4fa8-9931-ff9e8faf9bbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ\\\" in \
\"\>", "\[InvisibleSpace]", "0.002846`3.9057798892442386", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ\" in ", 0.002846`3.9057798892442386, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2117350435,ExpressionUUID->"7435bc7f-c559-4d29-baa0-ee5d51d2a40b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"SpatialMetric\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001356`3.5838046830270174", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"SpatialMetric\" in ", 
   0.001356`3.5838046830270174, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->118571454,ExpressionUUID->"de262bae-8ec3-41ae-bae2-a69ed2960210"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"SpatialMetric\\\" in \
\"\>", "\[InvisibleSpace]", "0.002677`3.8791933646829078", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"SpatialMetric\" in ", 
   0.002677`3.8791933646829078, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1087627136,ExpressionUUID->"85a7cacc-4a2a-4d7a-8ece-d0c818d033d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001132`3.5053914203482255", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ2\" in ", 
   0.001132`3.5053914203482255, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->725549881,ExpressionUUID->"d0653e8d-bf57-4d33-95bf-409ec3b2496f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ2\\\" in \
\"\>", "\[InvisibleSpace]", "0.001989`3.7501797766204086", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ2\" in ", 0.001989`3.7501797766204086, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1232349444,ExpressionUUID->"b7f8d4da-c54f-4444-945e-5afac2988d37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.00138`3.5914240798972097", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.00138`3.5914240798972097, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->803348552,ExpressionUUID->"2e97886b-9e98-4ba6-bf25-77291d6373ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ2\\\" \
in \"\>", "\[InvisibleSpace]", "0.000029`1.9139429913949293", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.000029`1.9139429913949293, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->625315316,ExpressionUUID->"568059c9-9eeb-4f96-b2da-b45710945e73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000729`3.3142725218139475", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ3\" in ", 
   0.000729`3.3142725218139475, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->541238033,ExpressionUUID->"495c603d-bfec-4d7c-8a42-2c9b3ce08d8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ3\\\" in \
\"\>", "\[InvisibleSpace]", "0.002048`3.762874945799764", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ3\" in ", 0.002048`3.762874945799764, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2012149630,ExpressionUUID->"10413caa-ffbf-4a89-9e20-cd92f73aaf97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001578`3.6496519923693724", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   0.001578`3.6496519923693724, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->754926317,ExpressionUUID->"a74ee90f-e43a-46c3-af7a-6239b41f69f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ3\\\" \
in \"\>", "\[InvisibleSpace]", "0.000366`3.015026078890386", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   0.000366`3.015026078890386, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2045678756,ExpressionUUID->"66f34f07-79bf-448c-b966-922b17342631"],

Cell[BoxData["\<\"Type D\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->107053282,ExpressionUUID->"194201b1-6686-4603-9db0-5f387c72a61d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"ScalarRho\\\" \
in \"\>", "\[InvisibleSpace]", "0.000024`1.831756235207579", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"ScalarRho\" in ", 
   0.000024`1.831756235207579, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1919861059,ExpressionUUID->"690fdeb6-b884-4570-ada8-d54b2eeb52ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"ScalarRho\\\" in \"\>", 
   "\[InvisibleSpace]", "0.000029`1.9139429913949293", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"ScalarRho\" in ", 0.000029`1.9139429913949293, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1904627382,ExpressionUUID->"9942b75f-06e1-497e-bba6-0a13aee1a3cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorP\\\" \
in \"\>", "\[InvisibleSpace]", "0.000192`2.7348462221995224", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorP\" in ", 
   0.000192`2.7348462221995224, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->575506006,ExpressionUUID->"a156813d-3f49-43e9-8cc1-c39d4e4807ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorP\\\" in \"\>", 
   "\[InvisibleSpace]", "0.003851`4.037118512118704", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorP\" in ", 0.003851`4.037118512118704, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1444968896,ExpressionUUID->"7e7fca27-6518-41a4-be73-c35af08b3532"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TensorPdag\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000169`2.679431698109646", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorPdag\" in ", 
   0.000169`2.679431698109646, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->504908332,ExpressionUUID->"54104eb9-e607-489b-b57d-d7e72961dec1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorPdag\\\" in \"\>",
    "\[InvisibleSpace]", "0.000142`2.603833337879029", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorPdag\" in ", 0.000142`2.603833337879029, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1754205748,ExpressionUUID->"ad0639e0-c932-4f59-99b4-355af41bfda4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TensorScrP\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001264`3.553292067442339", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScrP\" in ", 
   0.001264`3.553292067442339, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1993501356,ExpressionUUID->"ff23abcd-8fdb-4994-a973-218a707d5642"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScrP\\\" in \"\>",
    "\[InvisibleSpace]", "0.003781`4.029151670858511", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorScrP\" in ", 0.003781`4.029151670858511, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2119747203,ExpressionUUID->"cb41a539-877a-45e2-b3aa-e08612538b1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorScrP2\\\
\" in \"\>", "\[InvisibleSpace]", "0.000756`3.3300667889971796", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScrP2\" in ", 
   0.000756`3.3300667889971796, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1502944228,ExpressionUUID->"2ae40399-e87b-4f7b-90f2-b10245ce11c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScrP2\\\" in \
\"\>", "\[InvisibleSpace]", "0.000062`2.2439366829942267", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorScrP2\" in ", 0.000062`2.2439366829942267, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1215127971,ExpressionUUID->"15883c6b-dfb2-4c0e-ba5a-da419aab503b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"ScalarDseda\\\
\" in \"\>", "\[InvisibleSpace]", "0.000933`3.421426637242475", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"ScalarDseda\" in ", 
   0.000933`3.421426637242475, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->685611552,ExpressionUUID->"11e8d97c-c527-4908-a701-c99009c02644"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"ScalarDseda\\\" in \
\"\>", "\[InvisibleSpace]", "0.000026`1.8665183414667883", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"ScalarDseda\" in ", 0.000026`1.8665183414667883, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->707851297,ExpressionUUID->"dc3c4253-443e-40f8-9070-c0e4e0b1e76b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorS\\\" \
in \"\>", "\[InvisibleSpace]", "0.000291`2.91543798248188", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorS\" in ", 
   0.000291`2.91543798248188, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1631993053,ExpressionUUID->"e08ccb33-1299-4d94-8f65-6baaf90fd661"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorS\\\" in \"\>", 
   "\[InvisibleSpace]", "0.000864`3.3880587359748664", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorS\" in ", 0.000864`3.3880587359748664, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->199661654,ExpressionUUID->"cbf76b7e-7320-4f8d-bb1e-c3c56c557c2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"Cosh2\\\" in \
\"\>", "\[InvisibleSpace]", "7.`1.2966430335102281*^-6", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"Cosh2\" in ", 
   7.`1.2966430335102281*^-6, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1289510407,ExpressionUUID->"c969f04e-2e34-43d7-96e8-a57c381a96b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"Cosh2\\\" in \"\>", 
   "\[InvisibleSpace]", "0.00002`1.752574989159954", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"Cosh2\" in ", 0.00002`1.752574989159954, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1590780388,ExpressionUUID->"ffce3394-20b5-424e-b4c7-ec7a8929828f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"v0\\\" in \
\"\>", "\[InvisibleSpace]", "0.055409`5.195125305749346", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"v0\" in ", 
   0.055409`5.195125305749346, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->842497960,ExpressionUUID->"68f94cf7-3847-4601-a844-632eba40495f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"v0\\\" in \"\>", 
   "\[InvisibleSpace]", "0.00461`4.115245918885619", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, " to Weyl concomitant \"v0\" in ",
    0.00461`4.115245918885619, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->339263362,ExpressionUUID->"1acb76f2-97db-480f-9750-25aa6be71e56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"v1\\\" in \
\"\>", "\[InvisibleSpace]", "0.001824`3.7125698274883705", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"v1\" in ", 
   0.001824`3.7125698274883705, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1164892751,ExpressionUUID->"8288f67b-096b-4aae-884c-0c96e8c48f66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"v1\\\" in \"\>", 
   "\[InvisibleSpace]", "0.013256`4.573957488907253", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, " to Weyl concomitant \"v1\" in ",
    0.013256`4.573957488907253, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->812364747,ExpressionUUID->"40951cec-d7c4-4d06-9169-fe34f3ce865e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"NullDirectionTypeDPlus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000038`2.031328590112781", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"NullDirectionTypeDPlus\" in \
", 0.000038`2.031328590112781, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->457834817,ExpressionUUID->"294631cd-bdd1-4be1-a50f-bb2a6552adc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"NullDirectionTypeDPlus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000108`2.4849687489829204", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"NullDirectionTypeDPlus\" in ", 
   0.000108`2.4849687489829204, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->105036240,ExpressionUUID->"a5e36a21-4b34-4d4d-b454-0e389d0c6e8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"NullDirectionTypeDMinus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000224`2.8017930118301337", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"NullDirectionTypeDMinus\" \
in ", 0.000224`2.8017930118301337, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1537914628,ExpressionUUID->"d2b7b87a-6dc7-42cb-946b-810f48de6ba7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"NullDirectionTypeDMinus\
\\\" in \"\>", "\[InvisibleSpace]", "0.002148`3.783579270523491", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"NullDirectionTypeDMinus\" in ", 
   0.002148`3.783579270523491, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1690184261,ExpressionUUID->"f1944cef-0024-435b-86ff-33d588e91b49"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["m",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`mm,
             Editable->False]}], 
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False]]}]]], ",", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["m",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`mm,
             Editable->False]}], 
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False]]}]]], ",", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["m",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`mm,
             Editable->False]}], 
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False]]}]]}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[13]=",
 CellID->908384792,ExpressionUUID->"6d65c1f7-ffe5-4d57-bdee-1b5c3c381a2a"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsubsection", "1"},
   Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "3"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"30550a82-22f6-4c9e-b8c5-26ac823a168b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"59bdc2c9-c7a4-45ee-a85d-69efcd018ae8"],
 "PSimplify",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "8f930718-8eff-437b-8f93-ecd41b8ea1be"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"7f032146-221a-40d2-85e4-4e6402d4223a"],

Cell[TextData[{
 "This option allows us to choose a function that is applied to expressions \
in computations. By default, it coincides with the value of ",
 Cell[BoxData[
  StyleBox["$CVSimplify", "Input"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2a77f503-21da-4145-a45e-d2ee18e97295"],
 ":"
}], "ExampleText",
 CellID->8693097,ExpressionUUID->"69f5d37c-91bb-4883-b3dd-df2ad1c8b294"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",\

 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[1]:=",
 CellID->111291632,ExpressionUUID->"84b8d7b1-5801-4df1-ad6d-8df638105cd9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"PSimplify", "->", "FullSimplify"}], ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}], ",", " ", 
   RowBox[{"\"\<Bivector\>\"", "->", "bv"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[2]:=",
 CellID->599055540,ExpressionUUID->"d3b6e71c-e615-4424-908c-62f3c9a20a97"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->15746296,ExpressionUUID->"162ab8c9-130c-491f-854b-2bc71d966dd0"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->83938646,ExpressionUUID->"7f931a61-bb95-41b5-9e0d-12855a78775d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->773050774,ExpressionUUID->"9047c501-595d-43dd-a5a9-583656abb586"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->770672613,ExpressionUUID->"b6458f8b-90a3-4878-ac2e-6987c70f7b46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->2129617402,ExpressionUUID->"7c374803-0015-4d7c-b693-ee941c4ef295"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->880104056,ExpressionUUID->"bb931c6c-6af8-44b6-ba03-4845a868c693"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->543050024,ExpressionUUID->"fd75ecf2-db42-4294-a7c9-f13980d6fc2f"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1886761136,ExpressionUUID->"dc240e75-b469-49d6-be4d-7c823586c7c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1455610063,ExpressionUUID->"732928f3-27f2-4ac3-b959-51c9b058e27a"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1988018921,ExpressionUUID->"7e6ccf0f-14fb-4d99-bc75-abe46d68df71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->244185820,ExpressionUUID->"0cab9165-b627-48b7-b033-642c9c431e2c"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1062332163,ExpressionUUID->"90fc2d77-750e-4603-8456-a7b8863d1d6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1834036629,ExpressionUUID->"cf4a6b59-6715-41d6-bf05-0f036ea33b0d"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->216449375,ExpressionUUID->"a5cb415f-9b92-49d5-a553-32a8d09d022c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->417792744,ExpressionUUID->"a9a78d23-448c-45b4-92d1-dd5f12450e91"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->901680952,ExpressionUUID->"7f3d9d41-4b39-4f79-9683-59d904b6545b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->902060928,ExpressionUUID->"7adba8c2-906c-45bf-b75b-7f5393fc9e62"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1125644041,ExpressionUUID->"0cc3ec8f-918f-4703-9ead-0b4bfa11fc20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->386190357,ExpressionUUID->"9c4567fc-7ced-4c6f-a998-7ebf03795179"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1101722582,ExpressionUUID->"ccee7654-6815-45a3-b366-37d8e2cc1e21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->267670800,ExpressionUUID->"802e535b-d2d4-4587-8e7a-1bb84531cd7e"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1976970746,ExpressionUUID->"34797586-8eae-4369-b135-bb3bc2b51fec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.008923`4.402055886481969", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.008923`4.402055886481969, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1944220542,ExpressionUUID->"fb379489-c004-4b54-b669-38e571a84d6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.073298`5.316637118194209", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.073298`5.316637118194209, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->606934162,ExpressionUUID->"d7d57692-277d-4187-8a9d-1b8a094b4000"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.00056`3.199733020502173", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.00056`3.199733020502173, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->994379849,ExpressionUUID->"7c41f36f-bf62-45bb-ad63-89b693c040b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.154951`5.641739376866246", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.154951`5.641739376866246, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->609101641,ExpressionUUID->"70982bb1-0bc0-4235-a2f0-9b1d55b14276"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0.002214`3.796722610038677", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0.002214`3.796722610038677, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1064768979,ExpressionUUID->"65eb0c52-e2b7-4811-81d5-183805103ded"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.10231`5.461463078161874", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"G2Form\" in ", 0.10231`5.461463078161874, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1099416089,ExpressionUUID->"9ebed62b-5855-47a8-875f-5db261dffdf2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.029011`4.914107692550164", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.029011`4.914107692550164, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->2147016270,ExpressionUUID->"8361503e-fb1f-4ae2-afc2-3c5126b21fdf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.196129`5.744086807504418", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.196129`5.744086807504418, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->607469592,ExpressionUUID->"e1aad3dd-d2dd-4bad-8ca4-96b08ceba03d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000955`3.4315483650797196", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.000955`3.4315483650797196, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->2007800882,ExpressionUUID->"bc424862-eb31-42e3-9ecb-4e6d38f9a1f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0.001531`3.636520184194234", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.001531`3.636520184194234, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->15278918,ExpressionUUID->"09f55b5d-e86e-4912-9d6b-8e1847cf3191"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.015388`4.638727171130751", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.015388`4.638727171130751, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->691408238,ExpressionUUID->"b5eba55d-8606-4c74-9320-78f631df0bd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.189108`5.728254895066371", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.189108`5.728254895066371, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->633368008,ExpressionUUID->"31192e1e-a62b-4c82-9efb-161369118a85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001432`3.6074880114678076", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.001432`3.6074880114678076, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->785951532,ExpressionUUID->"f8a26d1c-b367-4ed4-ae72-c1f3977add0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0.002433`3.8376871024267896", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.002433`3.8376871024267896, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->673541992,ExpressionUUID->"1d031f60-d1e5-418d-9001-4702c8963e70"],

Cell[BoxData["\<\"Type D\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1513472065,ExpressionUUID->"aefa3737-92d4-4c75-ac3f-33bcc09f5628"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorScP\\\" \
in \"\>", "\[InvisibleSpace]", "0.001888`3.727546983458025", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScP\" in ", 
   0.001888`3.727546983458025, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1329001556,ExpressionUUID->"1f3ff9df-15ad-4bc1-9467-0cf31f6c046f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScP\\\" in \"\>", 
   "\[InvisibleSpace]", "0.038648`5.038672017974436", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"TensorScP\" in ", 0.038648`5.038672017974436, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->412819481,ExpressionUUID->"5a165719-6bf5-4f11-90fa-dc8cf34613e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TensorScP2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.006172`4.241970910887083", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScP2\" in ", 
   0.006172`4.241970910887083, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->821598480,ExpressionUUID->"42760329-1533-4029-b0f7-31c0691ea284"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScP2\\\" in \"\>",
    "\[InvisibleSpace]", "0.046181`5.116008326359933", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"TensorScP2\" in ", 0.046181`5.116008326359933, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1169536829,ExpressionUUID->"5685c251-355b-4c9e-b1ac-16b7ce4a1236"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"PTDCanonicalBivector\\\" in \"\>", "\[InvisibleSpace]", 
   "0.00389`4.041494594821681", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"PTDCanonicalBivector\" in ",
    0.00389`4.041494594821681, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->657005301,ExpressionUUID->"bc0523ee-cc42-4f69-ab4e-6e3adaa933d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"PTDCanonicalBivector\\\" in \"\>", "\[InvisibleSpace]", 
   "0.033185`4.972486815474034", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"PTDCanonicalBivector\" in ", 
   0.033185`4.972486815474034, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1883930643,ExpressionUUID->"e1ea0a47-2abd-4065-acf5-36230740a8e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WNullDirectionTypeDPlus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001485`3.6232714471492042", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WNullDirectionTypeDPlus\" \
in ", 0.001485`3.6232714471492042, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->856089810,ExpressionUUID->"9517104a-4495-42ce-93d2-84452d094ac1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WNullDirectionTypeDPlus\
\\\" in \"\>", "\[InvisibleSpace]", "0.035182`4.997865517766787", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WNullDirectionTypeDPlus\" in ", 
   0.035182`4.997865517766787, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->873454677,ExpressionUUID->"54df3e15-cdc6-43db-8684-98dd4958e173"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WNullDirectionTypeDMinus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001631`3.6639989545362464", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WNullDirectionTypeDMinus\" \
in ", 0.001631`3.6639989545362464, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->154239739,ExpressionUUID->"d91070bd-ea39-4159-8156-c70b25740688"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"WNullDirectionTypeDMinus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.027163`4.8855227271270785", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WNullDirectionTypeDMinus\" in ", 
   0.027163`4.8855227271270785, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->1757770762,ExpressionUUID->"ea869518-87d3-4b37-a514-38b9e9021ba8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SqrtBox[
        FractionBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]}]]], ",", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SqrtBox[
        FractionBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]}]]], ",", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox["m",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`mm,
             Editable->False]}], 
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False]]}]]}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1775515605,ExpressionUUID->"bf23a027-a373-480b-8223-e5b2e3da6d4a"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "3"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "4"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"8a7d8c62-0c2c-4522-afbd-9a8b8abbc282"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"a08e2d95-5f3c-4ca4-9e92-b844b633e5b4"],
 "Verbose",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "4c5ebf21-689a-464d-94ac-84e429fedb2b"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->365788128,ExpressionUUID->"efda6c46-46b5-4087-a0e9-ba0be218c5b1"],

Cell["\<\
If we do not want to see the printed messages from xIdeal, we need to set \
this option to False:\
\>", "ExampleText",
 CellID->346332891,ExpressionUUID->"01f7e47d-06f3-4524-8548-c828808f69a6"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",\

 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[1]:=",
 CellID->292193654,ExpressionUUID->"369b015a-5168-4b2d-93e0-3150dc6f2786"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"Verbose", "->", "False"}], ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}], ",", " ", 
   RowBox[{"\"\<Bivector\>\"", "->", "bv"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[2]:=",
 CellID->833269130,ExpressionUUID->"401a4e3b-2f9f-4f78-8683-521fa8fe4f86"],

Cell[BoxData["\<\"Type D\"\>"], "Print",
 CellLabel->"During evaluation of In[17]:=",
 CellID->1279883780,ExpressionUUID->"55be5150-031e-4ed8-96a8-740d350f7d3c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SqrtBox[
        FractionBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]}]]], ",", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SqrtBox[
        FractionBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mm,
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]}]]], ",", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["m",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`mm,
           Editable->False]}], "-", 
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False]}], 
        SqrtBox[
         RowBox[{
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             InterpretationBox[
              StyleBox["m",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mm,
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False]}], ")"}]}]]], ",", "0", ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", "Schw", "}"}], ",", "0"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->2143961120,ExpressionUUID->"eb34fde6-fb5e-4ec0-a7ba-e515f4cfe750"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "4"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"c21f4ab4-0431-4bce-92cf-1e9532fdbbba"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"bfdace7b-cd0a-4296-84d5-9f464ce8406c"],
 "Neat Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "46b9a123-1eed-49a0-a269-05a8b73de0e1"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"c835a3ff-33c3-4b2f-804b-a00962575dce"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "5"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"d8d1ebb6-7202-480b-8060-8acff60133e6"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"af9456ad-c714-406d-b5d1-ce1d0647f873"],
 "Kerr metric:",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a0e07d43-6c81-4e6f-bf97-e0fe35924e27"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->39279124,ExpressionUUID->"cb030081-cc80-43c7-bd00-40eddf2e3fae"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[1]:=",
 CellID->729754539,ExpressionUUID->"7602ceec-047b-45b7-b584-84f9a2285b32"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";", 
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[2]:=",
 CellID->1547554580,ExpressionUUID->"0f6f127a-5963-4e5f-ba31-9b729da095df"],

Cell["\<\
Let us obtain the multiple Debever null directions of Kerr's metric:\
\>", "ExampleText",
 CellID->530967077,ExpressionUUID->"47cbd0ee-9be9-44ed-867f-21e0d71f8d29"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"ch", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"\[Theta]", "[", "]"}], ",", 
      RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"AA", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<a\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"mm", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<m\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"\[CapitalSigma]", "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"r", "[", "]"}], "2"], "+", 
     RowBox[{
      SuperscriptBox["AA", "2"], 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}]}]}], ";", 
   RowBox[{"\[CapitalDelta]", "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"r", "[", "]"}], "2"], "-", 
     RowBox[{"2", "mm", " ", 
      RowBox[{"r", "[", "]"}]}], "+", 
     SuperscriptBox["AA", "2"]}]}], ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Theta]", "[", "]"}], "\[Element]", "Reals"}], "&&", 
    RowBox[{"mm", ">", "0"}], "&&", 
    RowBox[{"AA", ">=", "0"}], "&&", 
    RowBox[{"Pi", ">", 
     RowBox[{"\[Theta]", "[", "]"}], ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"r", "[", "]"}], ">", "0"}], "&&", 
    RowBox[{"\[CapitalSigma]", ">", "0"}], "&&", 
    RowBox[{"\[CapitalDelta]", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"2", "mm", " ", 
      RowBox[{"r", "[", "]"}]}], "<", 
     RowBox[{
      RowBox[{
       SuperscriptBox["AA", "2"], 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}], "+", 
      SuperscriptBox[
       RowBox[{"r", "[", "]"}], "2"]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"2", "mm", " ", 
             RowBox[{"r", "[", "]"}]}], "\[CapitalSigma]"]}], ")"}]}], ",", 
        "0", ",", "0", ",", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", "mm", " ", 
           RowBox[{"r", "[", "]"}], "AA", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}], 
          "\[CapitalSigma]"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        FractionBox["\[CapitalSigma]", "\[CapitalDelta]"], ",", "0", ",", 
        "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "\[CapitalSigma]", ",", "0"}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", "mm", " ", 
           RowBox[{"r", "[", "]"}], "AA", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}], 
          "\[CapitalSigma]"]}], ",", "0", ",", "0", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"r", "[", "]"}], "2"], "+", 
           SuperscriptBox["AA", "2"], "+", 
           RowBox[{
            FractionBox[
             RowBox[{"2", "mm", " ", 
              RowBox[{"r", "[", "]"}], 
              SuperscriptBox["AA", "2"]}], "\[CapitalSigma]"], 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}]}], "}"}]}], "}"}], "//",
     "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "ch"}], ",", 
       RowBox[{"-", "ch"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "ch", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[3]:=",
 CellID->662879132,ExpressionUUID->"224f7ed1-d6f8-4073-8577-223967b3e6c9"],

Cell["Unitary observer and vector for Kerr:", "ExampleText",
 CellID->58442655,ExpressionUUID->"24fcfa3b-c667-4efb-a0d4-1e7919604a52"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "mm", " ", 
            RowBox[{"r", "[", "]"}]}], "\[CapitalSigma]"]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]], ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", "ch", "}"}], ",", "0"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "mm", " ", 
            RowBox[{"r", "[", "]"}]}], "\[CapitalSigma]"]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"2", "mm", " ", 
             RowBox[{"r", "[", "]"}]}], "\[CapitalSigma]"]}], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], "/", "2"}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"2", "mm", " ", 
             RowBox[{"r", "[", "]"}]}], "\[CapitalSigma]"]}], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], "/", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", "ch", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[4]:=",
 CellID->22494714,ExpressionUUID->"07f5f938-313d-4f73-b057-53a950a2c8f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"Method", "->", "\"\<PetrovMatrix\>\""}], ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}], ",", " ", 
   RowBox[{"\"\<Vector\>\"", "->", "w"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellTags->"TextAnnotation",
 CellLabel->"In[5]:=",
 CellID->711938469,ExpressionUUID->"1e20bf0f-fd14-4fd2-ad0a-aa52dee2300f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1749613872,ExpressionUUID->"bd67ed70-2bea-43eb-b30d-4eaaa5fbbffe"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1735705612,ExpressionUUID->"1cf80300-c8e9-45b8-ba61-97873b0a8afa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1195419200,ExpressionUUID->"1d5c006b-538c-4b9c-b68e-b9965b816c08"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->598147271,ExpressionUUID->"4a171b82-a7b5-4732-9efc-42f650e422b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->280728025,ExpressionUUID->"065487ac-a1df-4cc0-a06c-03df8c85f3dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.001153`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.001153, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1539654935,ExpressionUUID->"2f9b00e3-718c-49c4-a191-e610b3770744"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "3.780005`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 3.780005, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->601266044,ExpressionUUID->"24e3512e-80eb-4832-9dad-77c42c00fc01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1016290803,ExpressionUUID->"72e2843f-b7b5-4335-9d6c-11d198ac48a5"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1807233067,ExpressionUUID->"1984a902-61b2-403f-a5bd-05bd40659e64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1651558601,ExpressionUUID->"c10493ef-7411-42ae-94cb-51067cddc018"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->2040481252,ExpressionUUID->"5326ef56-1407-47cc-834a-f5cc6649933a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->88495623,ExpressionUUID->"96a07a0e-16b8-47ac-984d-4b5ab66a3b0b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1080858944,ExpressionUUID->"1e2bd444-018b-4f69-80f3-608fe30a3e7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->924193147,ExpressionUUID->"b0af3737-b06c-4f42-8a91-d8d25e1704f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.001408`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.001408, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1337586247,ExpressionUUID->"cff23048-8e86-47de-b74c-2b1a69675750"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.562789`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.562789, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1645752361,ExpressionUUID->"5def0ed6-af8d-42c2-a166-950d6042e730"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001802`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", 
   "191552", "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001802, " seconds and ", 191552, " bytes"],
  
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->879679117,ExpressionUUID->"9ae2088b-3cfe-4c34-ae62-b84259b820e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->211470083,ExpressionUUID->"55749739-d7cf-4b58-aa8d-d7832b453615"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.003146`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.003146, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1198287826,ExpressionUUID->"d7f0269c-a296-46cc-bec4-9128ec6e1e2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.530642`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.530642, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->366925106,ExpressionUUID->"16cc009b-23b5-472b-b27f-4789b122202b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001968`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", 
   "218888", "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001968, " seconds and ", 218888, " bytes"],
  
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->865431663,ExpressionUUID->"7d267c30-5d79-42c5-bf4c-350d9ba3d0ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1901227907,ExpressionUUID->"7353a57d-971d-4746-ab53-f8945c44f041"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000175`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000175, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->77339353,ExpressionUUID->"ae8350df-12be-48e4-8409-f811d2a6badf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.037308`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.037308, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1785355346,ExpressionUUID->"626e63c4-f577-4f19-8101-94f58e41bdfb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000281`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000281, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->245556838,ExpressionUUID->"d0e6787d-128c-44dc-89ac-eae822c2b65a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->684463849,ExpressionUUID->"8b58890d-3207-497d-9d36-c4b340d58181"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000089`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000089, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->189745901,ExpressionUUID->"9a01296a-c5eb-41e8-b234-8e4ab97ded8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.014487`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.014487, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1855243473,ExpressionUUID->"732be6b4-afae-4ac0-bd38-8db16b59f1fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000328`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000328, " seconds and ", 64, " bytes"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->453634429,ExpressionUUID->"dcb4bd2e-59cf-42a9-8d46-b2e869cc3a73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1195169105,ExpressionUUID->"86a60dd3-4705-4274-ad5d-80dd335ec437"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000554`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000554, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1457373697,ExpressionUUID->"abb57ba8-f0e2-4ddd-b469-fc2682676446"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.088515`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.088515, " seconds"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->41856393,ExpressionUUID->"3fe5db5b-f07e-418a-b92e-05bf349b0c7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001774`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", 
   "191552", "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001774, " seconds and ", 191552, " bytes"],
  
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->243104657,ExpressionUUID->"0bd65900-43be-430a-b85b-acb0023fc690"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "6.914754`7.291321727710942", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   6.914754`7.291321727710942, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->2055520969,ExpressionUUID->"b30396fb-34d9-4cd8-9ed1-ba4732b1c11b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "3.315806`6.972134106570181", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 3.315806`6.972134106570181, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->322584418,ExpressionUUID->"0d050b03-7559-4388-aa8f-53f737137c95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.00113`3.5046234369793927", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.00113`3.5046234369793927, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1782759593,ExpressionUUID->"f5c5d8ed-f4e9-4014-8552-8932caf3930f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "6.960821`7.2942054593625265", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 6.960821`7.2942054593625265, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1112488754,ExpressionUUID->"d6c210c4-98e0-4325-b45d-e12149540422"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylMatrixQ\\\
\" in \"\>", "\[InvisibleSpace]", "22.252528`7.798924349670658", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ\" in ", 
   22.252528`7.798924349670658, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->923850462,ExpressionUUID->"e92ce240-11e4-4446-aac4-bcc19b4c7ff9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ\\\" in \
\"\>", "\[InvisibleSpace]", "0.149943`5.627471189284521", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ\" in ", 0.149943`5.627471189284521, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->651566748,ExpressionUUID->"49161f5e-b186-4f0c-82f7-7fe1ada5e187"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"SpatialMetric\\\" in \"\>", "\[InvisibleSpace]", 
   "12.519352`7.549126843927306", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"SpatialMetric\" in ", 
   12.519352`7.549126843927306, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->772238174,ExpressionUUID->"8b113f00-bc77-41bf-b825-22bda7959fb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"SpatialMetric\\\" in \
\"\>", "\[InvisibleSpace]", "0.71237`6.304250615251814", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"SpatialMetric\" in ", 0.71237`6.304250615251814, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->427925416,ExpressionUUID->"66203e65-e0ce-4809-bd3b-4b94f4166d6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.212544`5.7789938430782435", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ2\" in ", 
   0.212544`5.7789938430782435, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->544564352,ExpressionUUID->"298d7199-a0bb-4126-bca7-4fdfbf6d1393"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ2\\\" in \
\"\>", "\[InvisibleSpace]", "1.765856`6.698500278833089", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ2\" in ", 1.765856`6.698500278833089, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->860733797,ExpressionUUID->"ba96bf9a-f3d4-49bb-8753-e8426b930a70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.527804`6.174017670723967", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.527804`6.174017670723967, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1508784360,ExpressionUUID->"3a769e5e-040d-4308-8412-4c14f204cf05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ2\\\" \
in \"\>", "\[InvisibleSpace]", "0.003746`4.025112766535192", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.003746`4.025112766535192, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1468757500,ExpressionUUID->"7bfa521e-2559-4289-9ce0-93a30de1ed80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000829`3.3700995240462466", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ3\" in ", 
   0.000829`3.3700995240462466, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->50836396,ExpressionUUID->"4855a577-6aa2-4a0c-8350-6b850fe95e32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ3\\\" in \
\"\>", "\[InvisibleSpace]", "1.006143`6.4542047035373225", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ3\" in ", 1.006143`6.4542047035373225, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1007053073,ExpressionUUID->"f25d2968-2c11-4762-942d-ce9f8dfcc96b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.273731`5.888868977484689", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   0.273731`5.888868977484689, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->200952969,ExpressionUUID->"b1efe63b-fd11-4c80-9c4d-fa62597cfba1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ3\\\" \
in \"\>", "\[InvisibleSpace]", "0.005268`4.17319075978572", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   0.005268`4.17319075978572, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->262306480,ExpressionUUID->"e4ae0813-fe26-44e7-b519-14abd6bbd413"],

Cell[BoxData["\<\"Type D\"\>"], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->57857251,ExpressionUUID->"938aca39-c57c-4c7e-81b6-4dd474867287"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"ScalarRho\\\" \
in \"\>", "\[InvisibleSpace]", "0.000026`1.8665183414667894", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"ScalarRho\" in ", 
   0.000026`1.8665183414667894, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->567878076,ExpressionUUID->"82c54e99-1a68-4f36-89fa-cfd603aff43c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"ScalarRho\\\" in \"\>", 
   "\[InvisibleSpace]", "0.001917`3.734167106374035", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"ScalarRho\" in ", 0.001917`3.734167106374035, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1127738143,ExpressionUUID->"0f9c14f8-c247-41c4-a9d2-7740b6c6edc5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorP\\\" \
in \"\>", "\[InvisibleSpace]", "0.000271`2.8845142843703764", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorP\" in ", 
   0.000271`2.8845142843703764, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1959085158,ExpressionUUID->"fbcd3599-e657-4154-a2cf-5a903fb85930"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorP\\\" in \"\>", 
   "\[InvisibleSpace]", "0.065241`5.266065602687532", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorP\" in ", 0.065241`5.266065602687532, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->645217429,ExpressionUUID->"0aba7ea0-9266-46ab-8d3a-397968aa62b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TensorPdag\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000579`3.214223557223411", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorPdag\" in ", 
   0.000579`3.214223557223411, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->765609841,ExpressionUUID->"65134fa3-225a-4b81-b056-5de36b7a691d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorPdag\\\" in \"\>",
    "\[InvisibleSpace]", "0.007851`4.346469970855514", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorPdag\" in ", 0.007851`4.346469970855514, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->57158349,ExpressionUUID->"1ef6c3f0-1317-42a5-b3b4-a7a32a81d982"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TensorScrP\\\" in \"\>", "\[InvisibleSpace]", 
   "0.081332`5.361806445475014", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScrP\" in ", 
   0.081332`5.361806445475014, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1329681278,ExpressionUUID->"7de54172-58bc-4ea0-ba0d-a599c76f6f53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScrP\\\" in \"\>",
    "\[InvisibleSpace]", "0.427682`6.082665965835605", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorScrP\" in ", 0.427682`6.082665965835605, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->955355742,ExpressionUUID->"0bda2937-63b9-4b47-a7da-7f85340658f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorScrP2\\\
\" in \"\>", "\[InvisibleSpace]", "0.017559`4.696044772329816", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorScrP2\" in ", 
   0.017559`4.696044772329816, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1912401822,ExpressionUUID->"dec3e844-0d17-4cce-b38e-c109fad2157a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorScrP2\\\" in \
\"\>", "\[InvisibleSpace]", "0.016535`4.669949192745697", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorScrP2\" in ", 0.016535`4.669949192745697, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1783315707,ExpressionUUID->"7aedf452-8067-495f-bbaf-76a951c2319e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"ScalarDseda\\\
\" in \"\>", "\[InvisibleSpace]", "0.228739`5.810885211626077", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"ScalarDseda\" in ", 
   0.228739`5.810885211626077, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->3041200,ExpressionUUID->"391b459b-773c-4807-8a3e-76166272edb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"ScalarDseda\\\" in \
\"\>", "\[InvisibleSpace]", "0.033812`4.980615853799587", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"ScalarDseda\" in ", 0.033812`4.980615853799587, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1222291872,ExpressionUUID->"129ff4a5-cb46-40e7-bd2d-80c4c4cb1a4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"TensorS\\\" \
in \"\>", "\[InvisibleSpace]", "0.00128`3.558754963143841", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TensorS\" in ", 
   0.00128`3.558754963143841, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1825172100,ExpressionUUID->"f50af189-481b-4185-9012-4a8aa2041f78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TensorS\\\" in \"\>", 
   "\[InvisibleSpace]", "20.856891`7.77079456497989", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TensorS\" in ", 20.856891`7.77079456497989, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->246145857,ExpressionUUID->"394419b2-ccbe-432a-8e0c-b89e8cea241a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"Cosh2\\\" in \
\"\>", "\[InvisibleSpace]", "0.000017`1.6819939148742478", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"Cosh2\" in ", 
   0.000017`1.6819939148742478, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1130329193,ExpressionUUID->"7f7f68e7-3a88-4388-89d4-307d13dae5ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"Cosh2\\\" in \"\>", 
   "\[InvisibleSpace]", "0.178934`5.704237864020977", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"Cosh2\" in ", 0.178934`5.704237864020977, 
   " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->272871,ExpressionUUID->"c3782472-3d36-40aa-b2d7-bef19f30318e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"v0\\\" in \
\"\>", "\[InvisibleSpace]", "0.923326`6.416900058556808", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"v0\" in ", 
   0.923326`6.416900058556808, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->2028905450,ExpressionUUID->"122ff2da-25f0-4860-bcf5-581814c59a61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"v0\\\" in \"\>", 
   "\[InvisibleSpace]", "1.152269`6.51309887152241", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, " to Weyl concomitant \"v0\" in ",
    1.152269`6.51309887152241, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->95334299,ExpressionUUID->"b3e374bb-aaca-446b-b8c2-a48a57feae73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"v1\\\" in \
\"\>", "\[InvisibleSpace]", "0.000642`3.2590800215648263", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"v1\" in ", 
   0.000642`3.2590800215648263, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->924123333,ExpressionUUID->"39418410-1e5f-4730-9b64-e4f6f3a7f64d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"v1\\\" in \"\>", 
   "\[InvisibleSpace]", "0.152004`5.633400010092527", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, " to Weyl concomitant \"v1\" in ",
    0.152004`5.633400010092527, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->532988551,ExpressionUUID->"917dc100-9978-417d-9e8d-3f8587152e5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"NullDirectionTypeDPlus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.00003`1.9286662482156358", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"NullDirectionTypeDPlus\" in \
", 0.00003`1.9286662482156358, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->867572473,ExpressionUUID->"7d70c561-e4a0-4871-839c-3faab4e7688d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"NullDirectionTypeDPlus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.506945`6.156505837460074", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"NullDirectionTypeDPlus\" in ", 
   0.506945`6.156505837460074, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1352048749,ExpressionUUID->"9e68195c-d35d-4d68-800d-259b48adb61c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"NullDirectionTypeDMinus\\\" in \"\>", "\[InvisibleSpace]", 
   "0.507104`6.1566420297410955", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"NullDirectionTypeDMinus\" \
in ", 0.507104`6.1566420297410955, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1077552903,ExpressionUUID->"6438df23-5a39-4800-a87f-63f447b3b2f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"NullDirectionTypeDMinus\
\\\" in \"\>", "\[InvisibleSpace]", "0.022151`4.796938330586833", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"NullDirectionTypeDMinus\" in ", 
   0.022151`4.796938330586833, " seconds:"],
  Editable->False]], "Print",
 CellTags->"TextAnnotation",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1728306271,ExpressionUUID->"ef455198-2edf-41ee-a839-8da70d838918"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`AA,
               Editable->False], "2"]}], "-", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`AA,
               Editable->False], "2"], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Cos",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cos,
               Editable->False], "[", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False]}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                InterpretationBox[
                 StyleBox["m",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`mm,
                 Editable->False]}], "+", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], ")"}]}]}], 
           RowBox[{
            InterpretationBox[
             StyleBox["Abs",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Abs,
             Editable->False], "[", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`AA,
               Editable->False], "2"], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`AA,
                Editable->False], "2"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 InterpretationBox[
                  StyleBox["m",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`mm,
                  Editable->False]}], "+", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], ")"}]}]}], "]"}]], "+", 
          FractionBox[
           RowBox[{"16", " ", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`AA,
              Editable->False], "2"], " ", 
            InterpretationBox[
             StyleBox["m",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`mm,
             Editable->False], " ", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False], " ", 
            SuperscriptBox[
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], "2"]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`AA,
                Editable->False], "2"], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`AA,
                 Editable->False], "2"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`AA,
                Editable->False], "2"], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`AA,
                 Editable->False], "2"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  InterpretationBox[
                   StyleBox["m",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mm,
                   Editable->False]}], "+", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], ")"}]}]}], ")"}]}]]}], 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            FractionBox[
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["m",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`mm,
               Editable->False], " ", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}], 
             RowBox[{
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`AA,
                 Editable->False], "2"], " ", 
               SuperscriptBox[
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False], "]"}], "2"]}], "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "2"]}]]}]]}]], ",", "0", ",", "0", ",", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`AA,
            Editable->False]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`AA,
               Editable->False], "2"], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`AA,
                Editable->False], "2"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "2"]}]}], ")"}], " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["m",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`mm,
                Editable->False], " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`AA,
                  Editable->False], "2"], " ", 
                SuperscriptBox[
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False], "]"}], "2"]}], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], "2"]}]]}]]}]]}]}], "}"}], ",", 
      RowBox[{"{", "ch", "}"}], ",", "0"}], "]"}], "+", 
    RowBox[{"HeadOfTensor", "[", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {
            StyleBox[GridBox[{
               {
                TagBox[
                 TooltipBox["\<\"\[GrayCircle]\"\>",
                  RowBox[{
                    RowBox[{"{", "1", "}"}], "\[Rule]", 
                    FractionBox["1", 
                    RowBox[{
                    SqrtBox[
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{
                    StyleBox[
                    GridBox[{{
                    TagBox[
                    TooltipBox["1", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
                    Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 2} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 3} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {1, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {2, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {2, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {3, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {3, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 4} -> 0, "Tooltip"]& ]}}, AutoDelete -> 
                    False, GridBoxDividers -> {
                    "ColumnsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
                    "RowsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}], Small], 
                    StyleBox[
                    
                    GridBox[{{"b", "d"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d], Editable -> False]], 
                    " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"(", 
                    TagBox[
                    GridBox[{{"\[Piecewise]", 
                    GridBox[{{
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], ")"}], 
                    " ", 
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                    "2"]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]]}], ",",
                     "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], "<", 
                    RowBox[{"4", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]}, {
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]], ",", 
                    "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
                    ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, 
                    ColumnWidths -> Automatic, 
                    AllowedDimensions -> {2, Automatic}, Selectable -> True, 
                    Editable -> True]}}, ColumnAlignments -> {Left}, 
                    ColumnSpacings -> 0.5, ColumnWidths -> Automatic], 
                    "Piecewise", SyntaxForm -> Equal, SelectWithContents -> 
                    True, StripWrapperBoxes -> True, Selectable -> False, 
                    Editable -> False, DeleteWithContents -> True], ")"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"-", "d"}], ",", 
                    RowBox[{"-", "b"}]}], "]"}]]}]]}]],
                 Annotation[#, {1} -> xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d]^Rational[-1, 2] 
                   Piecewise[{{
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                    0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0], $CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
                    4 $CellContext`mm $CellContext`r[]}}, 
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
                    0, ($CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2)/($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[])), 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
                  "Tooltip"]& ]},
               {
                TagBox[
                 TooltipBox["\<\"\[GrayCircle]\"\>",
                  RowBox[{
                    RowBox[{"{", "2", "}"}], "\[Rule]", 
                    FractionBox["1", 
                    RowBox[{"2", " ", 
                    SqrtBox[
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{
                    StyleBox[
                    GridBox[{{
                    TagBox[
                    TooltipBox["1", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
                    Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 2} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 3} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {1, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {2, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {2, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {3, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {3, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 4} -> 0, "Tooltip"]& ]}}, AutoDelete -> 
                    False, GridBoxDividers -> {
                    "ColumnsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
                    "RowsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}], Small], 
                    StyleBox[
                    
                    GridBox[{{"b", "d"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d], Editable -> False]], 
                    " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"(", 
                    TagBox[
                    GridBox[{{"\[Piecewise]", 
                    GridBox[{{
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], ")"}], 
                    " ", 
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                    "2"]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]]}], ",",
                     "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], "<", 
                    RowBox[{"4", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]}, {
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]], ",", 
                    "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
                    ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, 
                    ColumnWidths -> Automatic, 
                    AllowedDimensions -> {2, Automatic}, Selectable -> True, 
                    Editable -> True]}}, ColumnAlignments -> {Left}, 
                    ColumnSpacings -> 0.5, ColumnWidths -> Automatic], 
                    "Piecewise", SyntaxForm -> Equal, SelectWithContents -> 
                    True, StripWrapperBoxes -> True, Selectable -> False, 
                    Editable -> False, DeleteWithContents -> True], ")"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"-", "d"}], ",", 
                    RowBox[{"-", "b"}]}], "]"}]]}]]}]],
                 Annotation[#, {2} -> Rational[1, 2] xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d]^Rational[-1, 2] 
                   Piecewise[{{
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                    0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0], $CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
                    4 $CellContext`mm $CellContext`r[]}}, 
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
                    0, ($CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2)/($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[])), 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
                  "Tooltip"]& ]},
               {
                TagBox[
                 TooltipBox["\<\"\[GrayCircle]\"\>",
                  RowBox[{
                    RowBox[{"{", "3", "}"}], "\[Rule]", 
                    FractionBox["1", 
                    RowBox[{"2", " ", 
                    SqrtBox[
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{
                    StyleBox[
                    GridBox[{{
                    TagBox[
                    TooltipBox["1", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
                    Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 2} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 3} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {1, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {2, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {2, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {3, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {3, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 4} -> 0, "Tooltip"]& ]}}, AutoDelete -> 
                    False, GridBoxDividers -> {
                    "ColumnsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
                    "RowsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}], Small], 
                    StyleBox[
                    
                    GridBox[{{"b", "d"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d], Editable -> False]], 
                    " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"(", 
                    TagBox[
                    GridBox[{{"\[Piecewise]", 
                    GridBox[{{
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], ")"}], 
                    " ", 
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                    "2"]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]]}], ",",
                     "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], "<", 
                    RowBox[{"4", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]}, {
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]], ",", 
                    "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
                    ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, 
                    ColumnWidths -> Automatic, 
                    AllowedDimensions -> {2, Automatic}, Selectable -> True, 
                    Editable -> True]}}, ColumnAlignments -> {Left}, 
                    ColumnSpacings -> 0.5, ColumnWidths -> Automatic], 
                    "Piecewise", SyntaxForm -> Equal, SelectWithContents -> 
                    True, StripWrapperBoxes -> True, Selectable -> False, 
                    Editable -> False, DeleteWithContents -> True], ")"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"-", "d"}], ",", 
                    RowBox[{"-", "b"}]}], "]"}]]}]]}]],
                 Annotation[#, {3} -> Rational[1, 2] xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d]^Rational[-1, 2] 
                   Piecewise[{{
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                    0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0], $CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
                    4 $CellContext`mm $CellContext`r[]}}, 
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
                    0, ($CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2)/($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[])), 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
                  "Tooltip"]& ]},
               {
                TagBox[
                 TooltipBox["0",
                  RowBox[{
                    RowBox[{"{", "4", "}"}], "\[Rule]", "0"}]],
                 Annotation[#, {4} -> 0, "Tooltip"]& ]}
              },
              AutoDelete->False,
              
              GridBoxDividers->{
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
             FontSize->Small], 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xCoba`CTensor[{xAct`xCoba`CTensor[{{1, 
               Rational[1, 2], 
               Rational[1, 2], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {0, 0, 0, 
              0}}, {$CellContext`ch, $CellContext`ch}, 
             0][$CellContext`b, $CellContext`d]^Rational[-1, 2] Piecewise[{{
               
               xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                 0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                   2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                 0}}, {-$CellContext`ch, -$CellContext`ch}, 
                0], $CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
               4 $CellContext`mm $CellContext`r[]}}, 
             
             xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
               0, ($CellContext`AA^2 + $CellContext`AA^2 
                  Cos[2 $CellContext`\[Theta][]] + 
                 2 $CellContext`r[]^2)/($CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 
                2 $CellContext`r[] ((-2) $CellContext`mm + $CellContext`r[])),
                 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
               0}}, {-$CellContext`ch, -$CellContext`ch}, 
              0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
          Rational[1, 2] xAct`xCoba`CTensor[{{1, 
               Rational[1, 2], 
               Rational[1, 2], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {0, 0, 0, 
              0}}, {$CellContext`ch, $CellContext`ch}, 
             0][$CellContext`b, $CellContext`d]^Rational[-1, 2] Piecewise[{{
               
               xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                 0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                   2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                 0}}, {-$CellContext`ch, -$CellContext`ch}, 
                0], $CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
               4 $CellContext`mm $CellContext`r[]}}, 
             
             xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
               0, ($CellContext`AA^2 + $CellContext`AA^2 
                  Cos[2 $CellContext`\[Theta][]] + 
                 2 $CellContext`r[]^2)/($CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 
                2 $CellContext`r[] ((-2) $CellContext`mm + $CellContext`r[])),
                 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
               0}}, {-$CellContext`ch, -$CellContext`ch}, 
              0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
          Rational[1, 2] xAct`xCoba`CTensor[{{1, 
               Rational[1, 2], 
               Rational[1, 2], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {0, 0, 0, 
              0}}, {$CellContext`ch, $CellContext`ch}, 
             0][$CellContext`b, $CellContext`d]^Rational[-1, 2] Piecewise[{{
               
               xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                 0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                   2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                 0}}, {-$CellContext`ch, -$CellContext`ch}, 
                0], $CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
               4 $CellContext`mm $CellContext`r[]}}, 
             
             xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
               0, ($CellContext`AA^2 + $CellContext`AA^2 
                  Cos[2 $CellContext`\[Theta][]] + 
                 2 $CellContext`r[]^2)/($CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 
                2 $CellContext`r[] ((-2) $CellContext`mm + $CellContext`r[])),
                 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
               0}}, {-$CellContext`ch, -$CellContext`ch}, 
              0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
          0}, {$CellContext`ch}, 0][$CellContext`c],
        Editable->False], " ", 
       RowBox[{
        RowBox[{"(", 
         TagBox[GridBox[{
            {"\[Piecewise]", GridBox[{
               {
                RowBox[{"CTensor", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Sin",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Sin,
                    Editable->False], "[", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["m",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mm,
                    Editable->False]}], "+", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}]]}], ",", "0"}], "}"}], ",", 
                    
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                RowBox[{
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                   RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], "<", 
                 RowBox[{"4", " ", 
                  InterpretationBox[
                   StyleBox["m",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mm,
                   Editable->False], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}]}]},
               {
                RowBox[{"CTensor", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["m",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mm,
                    Editable->False]}], "+", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}]], ",", "0", ",", "0"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                TagBox["True",
                 "PiecewiseDefault",
                 AutoDelete->True]}
              },
              AllowedDimensions->{2, Automatic},
              Editable->True,
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
              
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.84]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}},
              Selectable->True]}
           },
           GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
           GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.35]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          "Piecewise",
          DeleteWithContents->True,
          Editable->False,
          SelectWithContents->True,
          Selectable->False,
          StripWrapperBoxes->True], ")"}], "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", "a"}], "]"}]}], ",", 
      RowBox[{"{", "a", "}"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`AA,
               Editable->False], "2"]}], "-", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`AA,
               Editable->False], "2"], " ", 
             RowBox[{
              InterpretationBox[
               StyleBox["Cos",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cos,
               Editable->False], "[", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["\[Theta]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[Theta][],
                Editable->False]}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox["r",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`r[],
              Editable->False], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                InterpretationBox[
                 StyleBox["m",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`mm,
                 Editable->False]}], "+", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], ")"}]}]}], 
           RowBox[{
            InterpretationBox[
             StyleBox["Abs",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Abs,
             Editable->False], "[", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`AA,
               Editable->False], "2"], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`AA,
                Editable->False], "2"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 InterpretationBox[
                  StyleBox["m",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`mm,
                  Editable->False]}], "+", 
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False]}], ")"}]}]}], "]"}]], "+", 
          FractionBox[
           RowBox[{"16", " ", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["a",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`AA,
              Editable->False], "2"], " ", 
            InterpretationBox[
             StyleBox["m",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`mm,
             Editable->False], " ", 
            InterpretationBox[
             StyleBox["r",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`r[],
             Editable->False], " ", 
            SuperscriptBox[
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox["\[Theta]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[Theta][],
               Editable->False], "]"}], "2"]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`AA,
                Editable->False], "2"], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`AA,
                 Editable->False], "2"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`AA,
                Editable->False], "2"], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`AA,
                 Editable->False], "2"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{"2", " ", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  InterpretationBox[
                   StyleBox["m",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mm,
                   Editable->False]}], "+", 
                 InterpretationBox[
                  StyleBox["r",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`r[],
                  Editable->False]}], ")"}]}]}], ")"}]}]]}], 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            FractionBox[
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox["m",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`mm,
               Editable->False], " ", 
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False]}], 
             RowBox[{
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["a",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`AA,
                 Editable->False], "2"], " ", 
               SuperscriptBox[
                RowBox[{
                 InterpretationBox[
                  StyleBox["Cos",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  Cos,
                  Editable->False], "[", 
                 InterpretationBox[
                  StyleBox["\[Theta]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[Theta][],
                  Editable->False], "]"}], "2"]}], "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "2"]}]]}]]}]], ",", "0", ",", "0", ",", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox["a",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`AA,
            Editable->False]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["a",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`AA,
               Editable->False], "2"], "+", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["a",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`AA,
                Editable->False], "2"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox["\[Theta]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[Theta][],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False], "2"]}]}], ")"}], " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"2", " ", 
               InterpretationBox[
                StyleBox["m",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`mm,
                Editable->False], " ", 
               InterpretationBox[
                StyleBox["r",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`r[],
                Editable->False]}], 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["a",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`AA,
                  Editable->False], "2"], " ", 
                SuperscriptBox[
                 RowBox[{
                  InterpretationBox[
                   StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   Cos,
                   Editable->False], "[", 
                  InterpretationBox[
                   StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[Theta][],
                   Editable->False], "]"}], "2"]}], "+", 
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["r",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`r[],
                 Editable->False], "2"]}]]}]]}]]}]}], "}"}], ",", 
      RowBox[{"{", "ch", "}"}], ",", "0"}], "]"}], "-", 
    RowBox[{"HeadOfTensor", "[", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {
            StyleBox[GridBox[{
               {
                TagBox[
                 TooltipBox["\<\"\[GrayCircle]\"\>",
                  RowBox[{
                    RowBox[{"{", "1", "}"}], "\[Rule]", 
                    FractionBox["1", 
                    RowBox[{
                    SqrtBox[
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{
                    StyleBox[
                    GridBox[{{
                    TagBox[
                    TooltipBox["1", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
                    Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 2} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 3} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {1, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {2, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {2, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {3, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {3, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 4} -> 0, "Tooltip"]& ]}}, AutoDelete -> 
                    False, GridBoxDividers -> {
                    "ColumnsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
                    "RowsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}], Small], 
                    StyleBox[
                    
                    GridBox[{{"b", "d"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d], Editable -> False]], 
                    " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"(", 
                    TagBox[
                    GridBox[{{"\[Piecewise]", 
                    GridBox[{{
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], ")"}], 
                    " ", 
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                    "2"]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]]}], ",",
                     "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], "<", 
                    RowBox[{"4", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]}, {
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]], ",", 
                    "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
                    ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, 
                    ColumnWidths -> Automatic, 
                    AllowedDimensions -> {2, Automatic}, Selectable -> True, 
                    Editable -> True]}}, ColumnAlignments -> {Left}, 
                    ColumnSpacings -> 0.5, ColumnWidths -> Automatic], 
                    "Piecewise", SyntaxForm -> Equal, SelectWithContents -> 
                    True, StripWrapperBoxes -> True, Selectable -> False, 
                    Editable -> False, DeleteWithContents -> True], ")"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"-", "d"}], ",", 
                    RowBox[{"-", "b"}]}], "]"}]]}]]}]],
                 Annotation[#, {1} -> xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d]^Rational[-1, 2] 
                   Piecewise[{{
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                    0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0], $CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
                    4 $CellContext`mm $CellContext`r[]}}, 
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
                    0, ($CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2)/($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[])), 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
                  "Tooltip"]& ]},
               {
                TagBox[
                 TooltipBox["\<\"\[GrayCircle]\"\>",
                  RowBox[{
                    RowBox[{"{", "2", "}"}], "\[Rule]", 
                    FractionBox["1", 
                    RowBox[{"2", " ", 
                    SqrtBox[
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{
                    StyleBox[
                    GridBox[{{
                    TagBox[
                    TooltipBox["1", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
                    Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 2} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 3} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {1, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {2, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {2, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {3, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {3, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 4} -> 0, "Tooltip"]& ]}}, AutoDelete -> 
                    False, GridBoxDividers -> {
                    "ColumnsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
                    "RowsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}], Small], 
                    StyleBox[
                    
                    GridBox[{{"b", "d"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d], Editable -> False]], 
                    " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"(", 
                    TagBox[
                    GridBox[{{"\[Piecewise]", 
                    GridBox[{{
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], ")"}], 
                    " ", 
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                    "2"]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]]}], ",",
                     "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], "<", 
                    RowBox[{"4", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]}, {
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]], ",", 
                    "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
                    ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, 
                    ColumnWidths -> Automatic, 
                    AllowedDimensions -> {2, Automatic}, Selectable -> True, 
                    Editable -> True]}}, ColumnAlignments -> {Left}, 
                    ColumnSpacings -> 0.5, ColumnWidths -> Automatic], 
                    "Piecewise", SyntaxForm -> Equal, SelectWithContents -> 
                    True, StripWrapperBoxes -> True, Selectable -> False, 
                    Editable -> False, DeleteWithContents -> True], ")"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"-", "d"}], ",", 
                    RowBox[{"-", "b"}]}], "]"}]]}]]}]],
                 Annotation[#, {2} -> Rational[1, 2] xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d]^Rational[-1, 2] 
                   Piecewise[{{
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                    0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0], $CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
                    4 $CellContext`mm $CellContext`r[]}}, 
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
                    0, ($CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2)/($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[])), 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
                  "Tooltip"]& ]},
               {
                TagBox[
                 TooltipBox["\<\"\[GrayCircle]\"\>",
                  RowBox[{
                    RowBox[{"{", "3", "}"}], "\[Rule]", 
                    FractionBox["1", 
                    RowBox[{"2", " ", 
                    SqrtBox[
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{
                    StyleBox[
                    GridBox[{{
                    TagBox[
                    TooltipBox["1", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}]], 
                    Annotation[#, {1, 1} -> 1, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 2} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {1, 3} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {1, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {2, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {2, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {2, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "2"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
                    FractionBox["1", "2"]}]], 
                    Annotation[#, {3, 1} -> Rational[1, 2], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 2} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    FractionBox["1", "4"], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
                    FractionBox["1", "4"]}]], 
                    Annotation[#, {3, 3} -> Rational[1, 4], "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {3, 4} -> 0, "Tooltip"]& ]}, {
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
                    TagBox[
                    TooltipBox["0", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "0"}]], 
                    Annotation[#, {4, 4} -> 0, "Tooltip"]& ]}}, AutoDelete -> 
                    False, GridBoxDividers -> {
                    "ColumnsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}, 
                    "RowsIndexed" -> {
                    1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}], Small], 
                    StyleBox[
                    
                    GridBox[{{"b", "d"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d], Editable -> False]], 
                    " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"(", 
                    TagBox[
                    GridBox[{{"\[Piecewise]", 
                    GridBox[{{
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], ")"}], 
                    " ", 
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], 
                    "2"]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]]}], ",",
                     "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], "<", 
                    RowBox[{"4", " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False], " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}]}]}, {
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"a"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`AA, Editable -> False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Cos"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Cos, Editable -> False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False]}], "]"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"m"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`mm, Editable -> False]}], "+", 
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False]}], ")"}]}]}]], ",", 
                    "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                    TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
                    ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, 
                    ColumnWidths -> Automatic, 
                    AllowedDimensions -> {2, Automatic}, Selectable -> True, 
                    Editable -> True]}}, ColumnAlignments -> {Left}, 
                    ColumnSpacings -> 0.5, ColumnWidths -> Automatic], 
                    "Piecewise", SyntaxForm -> Equal, SelectWithContents -> 
                    True, StripWrapperBoxes -> True, Selectable -> False, 
                    Editable -> False, DeleteWithContents -> True], ")"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"-", "d"}], ",", 
                    RowBox[{"-", "b"}]}], "]"}]]}]]}]],
                 Annotation[#, {3} -> Rational[1, 2] xAct`xCoba`CTensor[{{1, 
                    Rational[1, 2], 
                    Rational[1, 2], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {
                    Rational[1, 2], 
                    Rational[1, 4], 
                    Rational[1, 4], 0}, {0, 0, 0, 
                    0}}, {$CellContext`ch, $CellContext`ch}, 
                    0][$CellContext`b, $CellContext`d]^Rational[-1, 2] 
                   Piecewise[{{
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                    0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0], $CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
                    4 $CellContext`mm $CellContext`r[]}}, 
                    
                    xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
                    0, ($CellContext`AA^2 + $CellContext`AA^2 
                    Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[]^2)/($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[])), 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
                    0}}, {-$CellContext`ch, -$CellContext`ch}, 
                    0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
                  "Tooltip"]& ]},
               {
                TagBox[
                 TooltipBox["0",
                  RowBox[{
                    RowBox[{"{", "4", "}"}], "\[Rule]", "0"}]],
                 Annotation[#, {4} -> 0, "Tooltip"]& ]}
              },
              AutoDelete->False,
              
              GridBoxDividers->{
               "ColumnsIndexed" -> {
                 1 -> RGBColor[1, 0, 0], 2 -> RGBColor[1, 0, 0]}}],
             FontSize->Small], 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xCoba`CTensor[{xAct`xCoba`CTensor[{{1, 
               Rational[1, 2], 
               Rational[1, 2], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {0, 0, 0, 
              0}}, {$CellContext`ch, $CellContext`ch}, 
             0][$CellContext`b, $CellContext`d]^Rational[-1, 2] Piecewise[{{
               
               xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                 0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                   2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                 0}}, {-$CellContext`ch, -$CellContext`ch}, 
                0], $CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
               4 $CellContext`mm $CellContext`r[]}}, 
             
             xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
               0, ($CellContext`AA^2 + $CellContext`AA^2 
                  Cos[2 $CellContext`\[Theta][]] + 
                 2 $CellContext`r[]^2)/($CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 
                2 $CellContext`r[] ((-2) $CellContext`mm + $CellContext`r[])),
                 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
               0}}, {-$CellContext`ch, -$CellContext`ch}, 
              0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
          Rational[1, 2] xAct`xCoba`CTensor[{{1, 
               Rational[1, 2], 
               Rational[1, 2], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {0, 0, 0, 
              0}}, {$CellContext`ch, $CellContext`ch}, 
             0][$CellContext`b, $CellContext`d]^Rational[-1, 2] Piecewise[{{
               
               xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                 0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                   2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                 0}}, {-$CellContext`ch, -$CellContext`ch}, 
                0], $CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
               4 $CellContext`mm $CellContext`r[]}}, 
             
             xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
               0, ($CellContext`AA^2 + $CellContext`AA^2 
                  Cos[2 $CellContext`\[Theta][]] + 
                 2 $CellContext`r[]^2)/($CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 
                2 $CellContext`r[] ((-2) $CellContext`mm + $CellContext`r[])),
                 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
               0}}, {-$CellContext`ch, -$CellContext`ch}, 
              0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
          Rational[1, 2] xAct`xCoba`CTensor[{{1, 
               Rational[1, 2], 
               Rational[1, 2], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {
               Rational[1, 2], 
               Rational[1, 4], 
               Rational[1, 4], 0}, {0, 0, 0, 
              0}}, {$CellContext`ch, $CellContext`ch}, 
             0][$CellContext`b, $CellContext`d]^Rational[-1, 2] Piecewise[{{
               
               xAct`xCoba`CTensor[{{0, 0, 0, 0}, {0, 0, 0, 0}, {
                 0, 0, (-$CellContext`AA^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                   2 $CellContext`r[]^2) ($CellContext`AA^2 + \
$CellContext`AA^2 Cos[2 $CellContext`\[Theta][]] + 
                    2 $CellContext`r[] ((-2) $CellContext`mm + \
$CellContext`r[]))^(-1) Sin[
                    $CellContext`\[Theta][]]^2, 0}, {0, 0, 0, 
                 0}}, {-$CellContext`ch, -$CellContext`ch}, 
                0], $CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 2 $CellContext`r[]^2 < 
               4 $CellContext`mm $CellContext`r[]}}, 
             
             xAct`xCoba`CTensor[{{0, 0, 0, 0}, {
               0, ($CellContext`AA^2 + $CellContext`AA^2 
                  Cos[2 $CellContext`\[Theta][]] + 
                 2 $CellContext`r[]^2)/($CellContext`AA^2 + $CellContext`AA^2 
                 Cos[2 $CellContext`\[Theta][]] + 
                2 $CellContext`r[] ((-2) $CellContext`mm + $CellContext`r[])),
                 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
               0}}, {-$CellContext`ch, -$CellContext`ch}, 
              0]][-$CellContext`d, -$CellContext`b]^Rational[-1, 2], 
          0}, {$CellContext`ch}, 0][$CellContext`c],
        Editable->False], " ", 
       RowBox[{
        RowBox[{"(", 
         TagBox[GridBox[{
            {"\[Piecewise]", GridBox[{
               {
                RowBox[{"CTensor", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], ")"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Sin",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Sin,
                    Editable->False], "[", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False], "]"}], "2"]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["m",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mm,
                    Editable->False]}], "+", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}]]}], ",", "0"}], "}"}], ",", 
                    
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                RowBox[{
                 RowBox[{
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                  RowBox[{
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                   RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], "<", 
                 RowBox[{"4", " ", 
                  InterpretationBox[
                   StyleBox["m",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`mm,
                   Editable->False], " ", 
                  InterpretationBox[
                   StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`r[],
                   Editable->False]}]}]},
               {
                RowBox[{"CTensor", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], "2"]}]}], 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], "+", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["a",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`AA,
                    Editable->False], "2"], " ", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox["Cos",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    Cos,
                    Editable->False], "[", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["\[Theta]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`\[Theta][],
                    Editable->False]}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    InterpretationBox[
                    StyleBox["m",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`mm,
                    Editable->False]}], "+", 
                    InterpretationBox[
                    StyleBox["r",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`r[],
                    Editable->False]}], ")"}]}]}]], ",", "0", ",", "0"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "ch"}], ",", 
                    RowBox[{"-", "ch"}]}], "}"}], ",", "0"}], "]"}], 
                TagBox["True",
                 "PiecewiseDefault",
                 AutoDelete->True]}
              },
              AllowedDimensions->{2, Automatic},
              Editable->True,
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
              
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.84]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}},
              Selectable->True]}
           },
           GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
           GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.35]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          "Piecewise",
          DeleteWithContents->True,
          Editable->False,
          SelectWithContents->True,
          Selectable->False,
          StripWrapperBoxes->True], ")"}], "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", "a"}], "]"}]}], ",", 
      RowBox[{"{", "a", "}"}]}], "]"}]}]}], "}"}]], "Output",
 CellTags->"TextAnnotation",
 CellLabel->"Out[5]=",
 CellID->713349461,ExpressionUUID->"3f8afc3e-fefd-436f-8762-79c71060ccbb"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "5"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "6"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"bcb81212-3de8-4706-a55e-478414cbf11a"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"77a67f3d-1a0b-4763-bd8e-93ce60720935"],
 "\nRowBox[{\"Type\", \"-\", RowBox[{\"III\", \" \", \"metric\"}]}]",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "2677815f-a383-48ae-917d-c309bc8f2922"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->144740365,ExpressionUUID->"998d7fb0-5e73-4cb1-accf-502267bc73dc"],

Cell[BoxData[
 RowBox[{"UnsetCMetric", "[", "metric", "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[1]:=",
 CellID->61235782,ExpressionUUID->"cfd7960e-634c-4d08-a177-74b8256509b6"],

Cell["\<\
The following metric is, in general, of Petrov Type III (see Stephani H, \
Kramer D, MacCallum M A H, Hoenselaers C and Herlt E 2003 Exact Solutions of \
the Einstein\[CloseCurlyQuote]s Field Equation (Cambridge University Press) \
eqs. (31.34)):\
\>", "ExampleText",
 CellID->4041254,ExpressionUUID->"66c56f29-13f1-45b2-8f7d-8da6b95a432c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"chart", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[ScriptU]", "[", "]"}], ",", 
      RowBox[{"v", "[", "]"}], ",", 
      RowBox[{"x", "[", "]"}], ",", 
      RowBox[{"y", "[", "]"}]}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DefScalarFunction", "[", 
   RowBox[{"ReW", ",", 
    RowBox[{"PrintAs", "->", "\"\<Re(W)\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefScalarFunction", "[", 
   RowBox[{"ImW", ",", 
    RowBox[{"PrintAs", "->", "\"\<Im(W)\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefScalarFunction", "[", 
   RowBox[{"H", ",", 
    RowBox[{
    "PrintAs", "->", " ", "\"\<\!\(\*SuperscriptBox[\(H\), \(0\)]\)\>\""}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ReW", "\[Element]", "Reals"}], ",", 
     RowBox[{"ImW", "\[Element]", "Reals"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{"-", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"v", "[", "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Derivative", "[", 
               RowBox[{"0", ",", "1", ",", "0"}], "]"}], "[", "ReW", "]"}], 
             "[", 
             RowBox[{
              RowBox[{"\[ScriptU]", "[", "]"}], ",", 
              RowBox[{"x", "[", "]"}], ",", 
              RowBox[{"y", "[", "]"}]}], "]"}], "-", 
            RowBox[{
             RowBox[{
              RowBox[{"Derivative", "[", 
               RowBox[{"0", ",", "0", ",", "1"}], "]"}], "[", "ImW", "]"}], 
             "[", 
             RowBox[{
              RowBox[{"\[ScriptU]", "[", "]"}], ",", 
              RowBox[{"x", "[", "]"}], ",", 
              RowBox[{"y", "[", "]"}]}], "]"}]}], ")"}]}], "+", 
         RowBox[{"2", 
          RowBox[{"H", "[", 
           RowBox[{
            RowBox[{"\[ScriptU]", "[", "]"}], ",", 
            RowBox[{"x", "[", "]"}], ",", 
            RowBox[{"y", "[", "]"}]}], "]"}]}]}], ",", "1", ",", 
        RowBox[{"2", 
         RowBox[{"ReW", "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], 
         RowBox[{"ImW", "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"ReW", "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}], ",", "0", ",", 
        RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], 
         RowBox[{"ImW", "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}], ",", "0", ",", "0", ",", 
        RowBox[{"-", "2"}]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "chart"}], ",", 
       RowBox[{"-", "chart"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[2]:=",
 CellID->190388794,ExpressionUUID->"e574ec65-eb5d-49c7-bce9-35f6b3fa92f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "chart", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[3]:=",
 CellID->94826705,ExpressionUUID->"6e53d836-b157-4a3c-b411-5a3f5f0af960"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"v", "[", "]"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"Derivative", "[", 
                RowBox[{"0", ",", "1", ",", "0"}], "]"}], "[", "ReW", "]"}], 
              "[", 
              RowBox[{
               RowBox[{"\[ScriptU]", "[", "]"}], ",", 
               RowBox[{"x", "[", "]"}], ",", 
               RowBox[{"y", "[", "]"}]}], "]"}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"Derivative", "[", 
                RowBox[{"0", ",", "0", ",", "1"}], "]"}], "[", "ImW", "]"}], 
              "[", 
              RowBox[{
               RowBox[{"\[ScriptU]", "[", "]"}], ",", 
               RowBox[{"x", "[", "]"}], ",", 
               RowBox[{"y", "[", "]"}]}], "]"}]}], ")"}]}], "+", 
          RowBox[{"2", 
           RowBox[{"H", "[", 
            RowBox[{
             RowBox[{"\[ScriptU]", "[", "]"}], ",", 
             RowBox[{"x", "[", "]"}], ",", 
             RowBox[{"y", "[", "]"}]}], "]"}]}]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]], ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", "chart", "}"}]}], "]"}]}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[4]:=",
 CellID->356039542,ExpressionUUID->"289f0470-6d44-4ff1-8ae6-96b127fb08db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"Method", "->", "\"\<PetrovMatrix\>\""}], ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[5]:=",
 CellID->280547322,ExpressionUUID->"e8101faf-f9e2-4026-8008-c8743aaf051c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->398826755,ExpressionUUID->"95d67dff-5b5f-41f1-8b6f-40930b18518b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1779142667,ExpressionUUID->"2facd683-08d2-4367-9e96-d9b1ae23d80e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1720402534,ExpressionUUID->"befb0431-6cbe-44d8-a404-7bddb72270fd"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->599779725,ExpressionUUID->"a43edf63-0831-4c95-b3c2-eb0bc0e7902a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->2041449147,ExpressionUUID->"27ddee4e-ac4b-405b-a23e-364e4c472353"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.001521`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.001521, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1778259786,ExpressionUUID->"d2c1eb67-7256-4ce5-9e11-f556189b9936"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.024363`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.024363, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1167657801,ExpressionUUID->"1d63bc2a-19b9-4817-af96-01e1cbc105ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1021703642,ExpressionUUID->"904cbe7c-7539-4183-a624-92b400cd239f"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1589861296,ExpressionUUID->"680034e9-8c46-4912-a8f0-3d9dc36e6a85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1812875230,ExpressionUUID->"2f87f9d9-29de-49ef-970e-c3ba628050c6"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1787313483,ExpressionUUID->"1c5d68f1-ad83-4fed-b30d-5a9a6493fe1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1647019645,ExpressionUUID->"b7cab47c-e71c-4ae5-aec6-c4cb817fbc6d"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->995072860,ExpressionUUID->"d12076bf-a9a1-490a-8ef9-4d6cae85cc2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->595185578,ExpressionUUID->"a5eca16d-d135-40a4-9560-e73589adc639"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000663`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000663, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1411937820,ExpressionUUID->"09571972-dd82-4c12-bbe7-5b324d78bb1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.068209`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.068209, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->630904920,ExpressionUUID->"a9ed2c28-3c2c-436a-b788-2e0796f173b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001023`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "97184",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001023, " seconds and ", 97184, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->598226778,ExpressionUUID->"aa3aa383-3a99-4218-9961-dbcf77273cc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->486746044,ExpressionUUID->"2c8a7ff2-c030-4225-93cf-5fd21ae2303a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.002741`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.002741, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->308593372,ExpressionUUID->"e5c57138-427f-4978-91dc-717350168110"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.073909`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.073909, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->844372635,ExpressionUUID->"c9c18de7-294e-417b-b408-ebd103298217"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.00144`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", 
   "169536", "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.00144, " seconds and ", 169536, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1617075237,ExpressionUUID->"4cbef2b9-ea9b-449b-b0a6-1c0e7aa99a34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->308866243,ExpressionUUID->"8f42d595-7265-4371-b58b-8608af711ac3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000117`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000117, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->725794438,ExpressionUUID->"0edf0fd0-7fd8-4bb3-a74d-22c10bb6530f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.042221`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.042221, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1712409536,ExpressionUUID->"7526bcfc-f8d0-46e5-8621-7212dd1eeba7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000236`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "13744",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000236, " seconds and ", 13744, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1232989577,ExpressionUUID->"588a6c13-3a5f-4c33-9653-4a293e760b5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1258782989,ExpressionUUID->"5ba23fd7-2ccf-4230-af89-b2fd12b2d6fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000063`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000063, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->432498362,ExpressionUUID->"d67b1998-877a-4a66-9bb2-794a90181bd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.013061`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.013061, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->437554678,ExpressionUUID->"547db700-ea46-4848-b46d-1f52ba7e02ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000256`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000256, " seconds and ", 64, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->188852244,ExpressionUUID->"de928d8f-fabb-4e27-b94e-f5cee99106c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->13320985,ExpressionUUID->"f9a70e98-3a29-42b1-83f6-ed0ebab02367"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000671`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000671, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1150904140,ExpressionUUID->"d060ccd0-0b0c-4c7c-9d45-d2e6d27dcead"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.059204`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.059204, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->587679000,ExpressionUUID->"aa39917b-687c-48a6-8711-47fae4e7456a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001384`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", 
   "154496", "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001384, " seconds and ", 154496, " bytes"],
  
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1792463652,ExpressionUUID->"a4f00a97-737e-4a9a-b8b0-43b8b58d34db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.535871`6.180605248242959", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.535871`6.180605248242959, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->723823026,ExpressionUUID->"b7dc7e09-b594-4878-872e-2fe424dcfc45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.027019`4.883214264809716", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.027019`4.883214264809716, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1187458725,ExpressionUUID->"ed984eed-8338-4693-b247-1effc65e6b13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000536`3.180709783188745", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.000536`3.180709783188745, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1686429152,ExpressionUUID->"2cf18bba-70a4-4750-8d2d-1b3d1fb7669b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.292694`5.917958813320953", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.292694`5.917958813320953, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->354599164,ExpressionUUID->"7a6a53e7-e2d4-46f3-889d-6f82aa3e8f88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylMatrixQ\\\
\" in \"\>", "\[InvisibleSpace]", "1.175746`6.521858503405366", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ\" in ", 
   1.175746`6.521858503405366, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->207632878,ExpressionUUID->"6fbf1c79-c058-4702-b12a-c9cebd5839c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ\\\" in \
\"\>", "\[InvisibleSpace]", "0.032557`4.96418937302175", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ\" in ", 0.032557`4.96418937302175, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->560649146,ExpressionUUID->"2217a1c5-f038-4bfe-ad99-03b2fddeafe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"SpatialMetric\\\" in \"\>", "\[InvisibleSpace]", 
   "0.024893`4.847622232608926", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"SpatialMetric\" in ", 
   0.024893`4.847622232608926, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1944460461,ExpressionUUID->"0df8a1da-5366-4280-8654-65586d67e140"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"SpatialMetric\\\" in \
\"\>", "\[InvisibleSpace]", "0.015051`4.629110349243389", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"SpatialMetric\" in ", 0.015051`4.629110349243389,
    " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->2020508108,ExpressionUUID->"97af766f-a5ed-4d8e-a80e-3fca6448afe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.605841`6.233903654158763", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ2\" in ", 
   0.605841`6.233903654158763, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->200478982,ExpressionUUID->"7f158aa0-aa46-4165-8ba3-721680f5fc4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ2\\\" in \
\"\>", "\[InvisibleSpace]", "0.137439`5.589654980087466", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ2\" in ", 0.137439`5.589654980087466, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1443996458,ExpressionUUID->"3a9933b9-5bb5-4181-8268-97609e3f92d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.026183`4.869564399224915", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.026183`4.869564399224915, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->868097320,ExpressionUUID->"43219215-1f32-491b-8f0c-4f8c7eb0cce5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ2\\\" \
in \"\>", "\[InvisibleSpace]", "0.000027`1.8829087576549601", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.000027`1.8829087576549601, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->795664560,ExpressionUUID->"64e12f0d-328f-4f74-9f19-9d5a7dc70efe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001024`3.461844950135785", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ3\" in ", 
   0.001024`3.461844950135785, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->708450630,ExpressionUUID->"6440a72f-234d-4c05-b4c6-cb690d700a8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ3\\\" in \
\"\>", "\[InvisibleSpace]", "0.014357`4.608608693878594", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ3\" in ", 0.014357`4.608608693878594, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1499002240,ExpressionUUID->"a8a9c990-b0ce-461b-9bee-efb87e86be31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "9.`1.4057875029353*^-6", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   9.`1.4057875029353*^-6, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1393891338,ExpressionUUID->"e67ae47d-1679-4eb4-9749-95e03285b7b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ3\\\" \
in \"\>", "\[InvisibleSpace]", "0.000026`1.8665183414667905", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   0.000026`1.8665183414667905, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1195196674,ExpressionUUID->"d6c19cff-42e0-4309-bb52-72e242ee05f4"],

Cell[BoxData["\<\"Type III\"\>"], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->1807595613,ExpressionUUID->"002d215d-7f83-435a-8f01-58d85f59f889"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"NullDirectionTypeIII\\\" in \"\>", "\[InvisibleSpace]", 
   "0.061461`5.2401446156537", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"NullDirectionTypeIII\" in ",
    0.061461`5.2401446156537, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->90780325,ExpressionUUID->"51529595-971c-4543-b1bc-d875b0594851"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"NullDirectionTypeIII\\\" in \"\>", "\[InvisibleSpace]", 
   "0.141241`5.6015057772450385", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"NullDirectionTypeIII\" in ", 
   0.141241`5.6015057772450385, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[23]:=",
 CellID->664788263,ExpressionUUID->"4fe75170-3115-4c6c-9fdf-1bb9fa36e36c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{
             InterpretationBox[
              StyleBox["\[ScriptU]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[ScriptU][],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox["x",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`x[],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox["y",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`y[],
              Editable->False]}], "]"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox[
                  RowBox[{"Re", 
                   RowBox[{"(", "W", ")"}]}],
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`ReW,
                 Editable->False], 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{
                InterpretationBox[
                 StyleBox["\[ScriptU]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[ScriptU][],
                 Editable->False], ",", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False], ",", 
                InterpretationBox[
                 StyleBox["y",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`y[],
                 Editable->False]}], "]"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox[
                  RowBox[{"Re", 
                   RowBox[{"(", "W", ")"}]}],
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`ReW,
                 Editable->False], 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{
                InterpretationBox[
                 StyleBox["\[ScriptU]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[ScriptU][],
                 Editable->False], ",", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False], ",", 
                InterpretationBox[
                 StyleBox["y",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`y[],
                 Editable->False]}], "]"}]}], ")"}]}]}], ")"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{
             InterpretationBox[
              StyleBox["\[ScriptU]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[ScriptU][],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox["x",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`x[],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox["y",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`y[],
              Editable->False]}], "]"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}]}], ")"}], "2"]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"256", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               SuperscriptBox["H", "0"],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`H,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{
            InterpretationBox[
             StyleBox["v",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[],
             Editable->False], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox[
                  RowBox[{"Re", 
                   RowBox[{"(", "W", ")"}]}],
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`ReW,
                 Editable->False], 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{
                InterpretationBox[
                 StyleBox["\[ScriptU]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[ScriptU][],
                 Editable->False], ",", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False], ",", 
                InterpretationBox[
                 StyleBox["y",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`y[],
                 Editable->False]}], "]"}]}], ")"}]}]}], ")"}], 
         RowBox[{"3", "/", "2"}]]}], ")"}]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", "chart", "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->2116461856,ExpressionUUID->"2bbe1f1f-bdfd-4764-ae64-6882baafaa3e"]
}, Open  ]],

Cell["But a particular case of the same metric is of type N:", "ExampleText",
 CellID->85129712,ExpressionUUID->"19d527be-fa61-4599-9d1a-62c0b2cad7fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ReW", "\[Element]", "Reals"}], ",", 
     RowBox[{"ImW", "\[Element]", "Reals"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "1", ",", "1"}], "]"}], "[", "ImW", "]"}], "[", 
        RowBox[{
         RowBox[{"\[ScriptU]", "[", "]"}], ",", 
         RowBox[{"x", "[", "]"}], ",", 
         RowBox[{"y", "[", "]"}]}], "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", 
             RowBox[{"0", ",", "2", ",", "0"}], "]"}], "[", "ReW", "]"}], "[", 
           RowBox[{
            RowBox[{"\[ScriptU]", "[", "]"}], ",", 
            RowBox[{"x", "[", "]"}], ",", 
            RowBox[{"y", "[", "]"}]}], "]"}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", 
             RowBox[{"0", ",", "0", ",", "2"}], "]"}], "[", "ReW", "]"}], "[", 
           RowBox[{
            RowBox[{"\[ScriptU]", "[", "]"}], ",", 
            RowBox[{"x", "[", "]"}], ",", 
            RowBox[{"y", "[", "]"}]}], "]"}]}], ")"}]}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "1", ",", "1"}], "]"}], "[", "ReW", "]"}], "[", 
        RowBox[{
         RowBox[{"\[ScriptU]", "[", "]"}], ",", 
         RowBox[{"x", "[", "]"}], ",", 
         RowBox[{"y", "[", "]"}]}], "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{
             RowBox[{"Derivative", "[", 
              RowBox[{"0", ",", "2", ",", "0"}], "]"}], "[", "ImW", "]"}], 
            "[", 
            RowBox[{
             RowBox[{"\[ScriptU]", "[", "]"}], ",", 
             RowBox[{"x", "[", "]"}], ",", 
             RowBox[{"y", "[", "]"}]}], "]"}]}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", 
             RowBox[{"0", ",", "0", ",", "2"}], "]"}], "[", "ImW", "]"}], "[", 
           RowBox[{
            RowBox[{"\[ScriptU]", "[", "]"}], ",", 
            RowBox[{"x", "[", "]"}], ",", 
            RowBox[{"y", "[", "]"}]}], "]"}]}], ")"}]}]}], "==", "0"}]}], 
    "}"}]}], ";"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[6]:=",
 CellID->99890060,ExpressionUUID->"8b88fc27-d429-4d56-a470-608cd450e77c"],

Cell["\<\
We need to clear the appropriate cache to do some computations again:\
\>", "ExampleText",
 CellID->575459736,ExpressionUUID->"9ce34014-94dc-4c7f-856d-02f9cbbde91c"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",\

 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[7]:=",
 CellID->290589307,ExpressionUUID->"333b556c-33b2-4c7f-9e9e-326d3c18b6b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DebeverNullDirections", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"Method", "->", "\"\<PetrovMatrix\>\""}], ",", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}]}], "]"}]], "Input",
 CellProlog:>(Needs["xAct`xIdeal`"]; Null),
 CellLabel->"In[8]:=",
 CellID->39795717,ExpressionUUID->"bc2a0052-1e63-4a2d-bf62-e3c4dd245158"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->816574763,ExpressionUUID->"19dbc1a8-4f28-4146-b7da-e0cf56395cd5"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->229714152,ExpressionUUID->"0f38a0d4-dc4c-4416-b6bd-2e1b153b7959"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1201967785,ExpressionUUID->"7c31ea1d-3548-4685-a76f-daed59dc6014"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->2075357752,ExpressionUUID->"86b36029-7668-4961-a149-c6f26a700435"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->662212514,ExpressionUUID->"dbef3abc-a369-409c-913a-ecde09d489c9"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1639522464,ExpressionUUID->"12b5ef5c-7c5f-434c-9ea3-a063a11a548c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->116726349,ExpressionUUID->"90048f1d-1fc8-4556-911f-9ee04c135781"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->675533499,ExpressionUUID->"b8371545-57c7-48f1-9ecd-0744d8352153"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->642942956,ExpressionUUID->"8a7adebe-5433-48e7-9c47-79579965a1f0"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->704405349,ExpressionUUID->"7dca59dd-8d24-46d0-8a11-228d8a7fd8a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->320513503,ExpressionUUID->"19592985-ca90-47b2-92c4-2f49c839b67b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1366765982,ExpressionUUID->"a6049456-aa04-468c-ac7d-5ff9242236f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1891864074,ExpressionUUID->"c346acfb-2e4d-4a45-9451-6de4e2ff2642"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->2006942655,ExpressionUUID->"e6a2a91e-836e-45dd-8dba-2a817f81d04e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1721365147,ExpressionUUID->"4dda5a71-14eb-43b2-b79d-fdb35a87ad36"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->2099496952,ExpressionUUID->"ec58831f-2b89-4117-bc2b-41199d460526"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->420108154,ExpressionUUID->"7d1bd141-c27e-4884-9a6e-f0a830b5e6b2"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1518341960,ExpressionUUID->"8b999989-e24f-42ed-b955-d31350295537"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1972521412,ExpressionUUID->"e6c4f6ba-d023-4020-9449-7762028a6676"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->620587136,ExpressionUUID->"6e6c8645-2a09-4741-9766-c5b08527bc15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->814854770,ExpressionUUID->"595f4252-adad-4faf-8a44-579a19db0d36"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->693135084,ExpressionUUID->"23ccf8bc-3e4d-4940-92ce-6f30c1b6d94f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.017345`4.690719297674051", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.017345`4.690719297674051, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1416251696,ExpressionUUID->"035aeda8-b553-4fe3-989c-6de6c076b6eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.241943`5.835258054925735", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.241943`5.835258054925735, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1523305401,ExpressionUUID->"7fc025e7-b09f-4758-8bd6-5621cc1bdec6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000638`3.2563656722171355", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.000638`3.2563656722171355, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->44653677,ExpressionUUID->"1b8324c2-4212-49d9-b6cf-4a3b36bd3b97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.845153`6.37848033089636", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.845153`6.37848033089636, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->662659386,ExpressionUUID->"b41252b3-b8aa-498d-8b3a-4cff752ecb07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylMatrixQ\\\
\" in \"\>", "\[InvisibleSpace]", "1.134574`6.506377820507216", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ\" in ", 
   1.134574`6.506377820507216, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->571018427,ExpressionUUID->"4c9e6c79-69d8-4e8e-aa4a-b8d6fa0947b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ\\\" in \
\"\>", "\[InvisibleSpace]", "0.196675`5.745294152337144", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ\" in ", 0.196675`5.745294152337144, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1852249290,ExpressionUUID->"1b8f4c7f-0876-4c91-af90-fee2445a77cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.454767`6.109333936235773", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ2\" in ", 
   0.454767`6.109333936235773, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->753439711,ExpressionUUID->"471e4c2b-aa88-4c8b-90ef-9a0788f39a4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ2\\\" in \
\"\>", "\[InvisibleSpace]", "1.110983`6.497252407015888", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ2\" in ", 1.110983`6.497252407015888, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1235806691,ExpressionUUID->"3591b88b-6ae4-491b-8ca5-09382d4829d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "1.`1.4515449934959717*^-5", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.00001`1.4515449934959717, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1821227498,ExpressionUUID->"4b5cd956-ca12-4688-b75c-8c187b045a6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ2\\\" \
in \"\>", "\[InvisibleSpace]", "0.000035`1.9956130378462467", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0.000035`1.9956130378462467, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1570014475,ExpressionUUID->"61fbe58a-247d-44a8-b690-1f68742b6913"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000566`3.2043614246842447", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ3\" in ", 
   0.000566`3.2043614246842447, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1465520843,ExpressionUUID->"a9bbb245-674d-4960-873c-a9e1ddcb50d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ3\\\" in \
\"\>", "\[InvisibleSpace]", "0.000244`2.8389348198347046", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ3\" in ", 0.000244`2.8389348198347046, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->875711636,ExpressionUUID->"cea0463f-f28e-4647-823b-cab6c4b01aa1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "9.`1.4057875029352955*^-6", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   9.`1.4057875029352955*^-6, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1497888579,ExpressionUUID->"fed6293d-9508-459b-b112-65ecd3b5b44e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ3\\\" \
in \"\>", "\[InvisibleSpace]", "0.000029`1.9139429913949293", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   0.000029`1.9139429913949293, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->2127733357,ExpressionUUID->"1df31525-e786-4fc5-9db6-e44fa4560f26"],

Cell[BoxData["\<\"Type N\"\>"], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->367750452,ExpressionUUID->"4aa56676-f5a8-451e-ab13-e1ae81493fad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"NullDirectionTypeN\\\" in \"\>", "\[InvisibleSpace]", 
   "0.577916`6.213409711868775", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"NullDirectionTypeN\" in ", 
   0.577916`6.213409711868775, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->1614614928,ExpressionUUID->"b383f343-b69c-429d-9ab4-5d37815ac874"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"NullDirectionTypeN\\\" \
in \"\>", "\[InvisibleSpace]", "6.734461`7.2798478357089325", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"NullDirectionTypeN\" in ", 
   6.734461`7.2798478357089325, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[26]:=",
 CellID->655783208,ExpressionUUID->"b49d0cbe-a15f-4d53-8f2f-d4e5f66cf444"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "4"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              SuperscriptBox["H", "0"],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`H,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "-", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "3"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "-", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "-", 
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "4"]}], "-", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              SuperscriptBox["H", "0"],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`H,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"16", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "-", 
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              SuperscriptBox["H", "0"],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`H,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"32", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "-", 
        RowBox[{"32", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "-", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "-", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["v",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[],
           Editable->False], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "3", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"32", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"16", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "-", 
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{
             InterpretationBox[
              StyleBox["\[ScriptU]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[ScriptU][],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox["x",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`x[],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox["y",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`y[],
              Editable->False]}], "]"}], "-", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{
             InterpretationBox[
              StyleBox["\[ScriptU]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[ScriptU][],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox["x",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`x[],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox["y",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`y[],
              Editable->False]}], "]"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                SuperscriptBox["H", "0"],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`H,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{
            InterpretationBox[
             StyleBox["v",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[],
             Editable->False], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{
            InterpretationBox[
             StyleBox["v",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[],
             Editable->False], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}]}], ")"}]}], "-", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"32", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"16", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"32", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Im", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ImW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                SuperscriptBox["H", "0"],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`H,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{
            InterpretationBox[
             StyleBox["v",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[],
             Editable->False], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "3"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox[
                 RowBox[{"Re", 
                  RowBox[{"(", "W", ")"}]}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`ReW,
                Editable->False], 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{
               InterpretationBox[
                StyleBox["\[ScriptU]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[ScriptU][],
                Editable->False], ",", 
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False], ",", 
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False]}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{
            InterpretationBox[
             StyleBox["v",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[],
             Editable->False], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                SuperscriptBox["H", "0"],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`H,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{
            InterpretationBox[
             StyleBox["v",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[],
             Editable->False], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{
            InterpretationBox[
             StyleBox["v",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[],
             Editable->False], " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "3", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Im", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ImW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox[
                RowBox[{"Re", 
                 RowBox[{"(", "W", ")"}]}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`ReW,
               Editable->False], 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"16", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             SuperscriptBox["H", "0"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`H,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "-", 
        RowBox[{"8", " ", 
         InterpretationBox[
          StyleBox["v",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`v[],
          Editable->False], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"32", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox[
              RowBox[{"Re", 
               RowBox[{"(", "W", ")"}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`ReW,
             Editable->False], 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox["\[ScriptU]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`\[ScriptU][],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], ",", 
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False]}], "]"}], "2"]}], "-", 
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "3"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`ReW,
                   Editable->False], 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["\[ScriptU]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[ScriptU][],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["x",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`x[],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["y",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`y[],
                   Editable->False]}], "]"}], "2"]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "3", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "3"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`ReW,
                   Editable->False], 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["\[ScriptU]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[ScriptU][],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["x",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`x[],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["y",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`y[],
                   Editable->False]}], "]"}], "2"]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "3", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Im", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ImW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`ReW,
                   Editable->False], 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["\[ScriptU]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[ScriptU][],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["x",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`x[],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["y",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`y[],
                   Editable->False]}], "]"}]}], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "3"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`ReW,
                   Editable->False], 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["\[ScriptU]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[ScriptU][],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["x",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`x[],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["y",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`y[],
                   Editable->False]}], "]"}], "2"]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "3", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox[
             RowBox[{"Re", 
              RowBox[{"(", "W", ")"}]}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ReW,
            Editable->False], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[ScriptU]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[ScriptU][],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Im", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ImW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`ReW,
                   Editable->False], 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["\[ScriptU]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[ScriptU][],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["x",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`x[],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["y",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`y[],
                   Editable->False]}], "]"}]}], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"Re", 
                RowBox[{"(", "W", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`ReW,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "3"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`ReW,
                   Editable->False], 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["\[ScriptU]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`\[ScriptU][],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["x",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`x[],
                   Editable->False], ",", 
                  InterpretationBox[
                   StyleBox["y",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`y[],
                   Editable->False]}], "]"}], "2"]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   SuperscriptBox["H", "0"],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`H,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "-", 
              RowBox[{
               InterpretationBox[
                StyleBox["v",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[],
                Editable->False], " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "3", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Re", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ReW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], 
      "/", 
      RowBox[{"(", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               SuperscriptBox["H", "0"],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`H,
              Editable->False], "[", 
             RowBox[{
              InterpretationBox[
               StyleBox["\[ScriptU]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[ScriptU][],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["x",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`x[],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox["y",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`y[],
               Editable->False]}], "]"}]}], "+", 
           RowBox[{
            InterpretationBox[
             StyleBox["v",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[],
             Editable->False], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                   RowBox[{"Im", 
                    RowBox[{"(", "W", ")"}]}],
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`ImW,
                  Editable->False], 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{
                 InterpretationBox[
                  StyleBox["\[ScriptU]",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`\[ScriptU][],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], ",", 
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox[
                  RowBox[{"Re", 
                   RowBox[{"(", "W", ")"}]}],
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`ReW,
                 Editable->False], 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{
                InterpretationBox[
                 StyleBox["\[ScriptU]",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`\[ScriptU][],
                 Editable->False], ",", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False], ",", 
                InterpretationBox[
                 StyleBox["y",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`y[],
                 Editable->False]}], "]"}]}], ")"}]}]}], ")"}], 
         RowBox[{"3", "/", "2"}]]}], ")"}]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", "chart", "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->1010693408,ExpressionUUID->"9df63b2e-929e-43d9-b2ab-7e064a6cd4f5"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "6"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"8b5cffcc-3f44-41ea-a49e-\
d012d2dec198"],

Cell[" ", "FooterCell",ExpressionUUID->"5508471c-9c00-42d2-881d-5e234bfdf272"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 750},
WindowMargins->{{Automatic, -900}, {Automatic, 0}},
WindowTitle->"DebeverNullDirections",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {
     "0" -> Open, "1" -> Closed, "2" -> Closed, "3" -> Closed}, 
    "AllOptsTable" -> Closed, "NotesSection" -> Closed, 
    "ExampleSubsection" -> {
     "0" -> Closed, "1" -> Closed, "2" -> Closed, "3" -> Closed, "4" -> 
      Closed, "5" -> Closed, "6" -> Closed}, 
    "ExampleSubsubsection" -> {"0" -> Closed, "1" -> Closed}}, "NewStyles" -> 
  True, "CitationPopupData" -> $Failed, "ShowCitation" -> False, 
  "RootCaptions" -> "", "HeaderCoreAreaLink" -> {}, 
  "Metadata" -> {
   "built" -> "{2024, 7, 9, 14, 29, 31.049840}", 
    "history" -> {"XX", "", "", ""}, "context" -> "xAct`xIdeal`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "x Ideal Symbol", "language" -> "en", "paclet" -> "xIdeal", "status" -> 
    "None", "summary" -> 
    "DebeverNullDirections[metric, opts] returns the multiple Debever null \
directions of metric.", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "DebeverNullDirections", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "DebeverNullDirections", "type" -> "Symbol", "uri" -> 
    "xIdeal/ref/DebeverNullDirections", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"14.0 for Linux x86 (64-bit) (December 12, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "14.0 for Linux x86 (64-bit) (December 12, 2023)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"9d209a65-1689-4a93-9cb5-7435581d2013"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11014, 275, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"c66f1b97-afa1-4787-b251-31145eb43622",
   CellTags->"PrimaryExamplesSection",
   CellID->784848252]},
 "TextAnnotation"->{
  Cell[254146, 6747, 425, 9, 70, "Input",ExpressionUUID->"1e20bf0f-fd14-4fd2-ad0a-aa52dee2300f",
   CellTags->"TextAnnotation",
   CellID->711938469],
  Cell[254596, 6760, 406, 10, 70, "Print",ExpressionUUID->"bd67ed70-2bea-43eb-b30d-4eaaa5fbbffe",
   CellTags->"TextAnnotation",
   CellID->1749613872],
  Cell[255005, 6772, 202, 3, 70, "Print",ExpressionUUID->"1cf80300-c8e9-45b8-ba61-97873b0a8afa",
   CellTags->"TextAnnotation",
   CellID->1735705612],
  Cell[255210, 6777, 487, 13, 70, "Print",ExpressionUUID->"1d5c006b-538c-4b9c-b68e-b9965b816c08",
   CellTags->"TextAnnotation",
   CellID->1195419200],
  Cell[255700, 6792, 201, 3, 70, "Print",ExpressionUUID->"4a171b82-a7b5-4732-9efc-42f650e422b5",
   CellTags->"TextAnnotation",
   CellID->598147271],
  Cell[255904, 6797, 523, 14, 70, "Print",ExpressionUUID->"065487ac-a1df-4cc0-a06c-03df8c85f3dc",
   CellTags->"TextAnnotation",
   CellID->280728025],
  Cell[256430, 6813, 396, 8, 70, "Print",ExpressionUUID->"2f9b00e3-718c-49c4-a191-e610b3770744",
   CellTags->"TextAnnotation",
   CellID->1539654935],
  Cell[256829, 6823, 473, 9, 70, "Print",ExpressionUUID->"24e3512e-80eb-4832-9dad-77c42c00fc01",
   CellTags->"TextAnnotation",
   CellID->601266044],
  Cell[257305, 6834, 495, 13, 70, "Print",ExpressionUUID->"72e2843f-b7b5-4335-9d6c-11d198ac48a5",
   CellTags->"TextAnnotation",
   CellID->1016290803],
  Cell[257803, 6849, 202, 3, 70, "Print",ExpressionUUID->"1984a902-61b2-403f-a5bd-05bd40659e64",
   CellTags->"TextAnnotation",
   CellID->1807233067],
  Cell[258008, 6854, 473, 12, 70, "Print",ExpressionUUID->"c10493ef-7411-42ae-94cb-51067cddc018",
   CellTags->"TextAnnotation",
   CellID->1651558601],
  Cell[258484, 6868, 202, 3, 70, "Print",ExpressionUUID->"5326ef56-1407-47cc-834a-f5cc6649933a",
   CellTags->"TextAnnotation",
   CellID->2040481252],
  Cell[258689, 6873, 356, 8, 70, "Print",ExpressionUUID->"96a07a0e-16b8-47ac-984d-4b5ab66a3b0b",
   CellTags->"TextAnnotation",
   CellID->88495623],
  Cell[259048, 6883, 202, 3, 70, "Print",ExpressionUUID->"1e2bd444-018b-4f69-80f3-608fe30a3e7d",
   CellTags->"TextAnnotation",
   CellID->1080858944],
  Cell[259253, 6888, 521, 14, 70, "Print",ExpressionUUID->"b0af3737-b06c-4f42-8a91-d8d25e1704f4",
   CellTags->"TextAnnotation",
   CellID->924193147],
  Cell[259777, 6904, 396, 8, 70, "Print",ExpressionUUID->"cff23048-8e86-47de-b74c-2b1a69675750",
   CellTags->"TextAnnotation",
   CellID->1337586247],
  Cell[260176, 6914, 474, 9, 70, "Print",ExpressionUUID->"5def0ed6-af8d-42c2-a166-950d6042e730",
   CellTags->"TextAnnotation",
   CellID->1645752361],
  Cell[260653, 6925, 490, 10, 70, "Print",ExpressionUUID->"9ae2088b-3cfe-4c34-ae62-b84259b820e4",
   CellTags->"TextAnnotation",
   CellID->879679117],
  Cell[261146, 6937, 499, 13, 70, "Print",ExpressionUUID->"55749739-d7cf-4b58-aa8d-d7832b453615",
   CellTags->"TextAnnotation",
   CellID->211470083],
  Cell[261648, 6952, 396, 8, 70, "Print",ExpressionUUID->"d7f0269c-a296-46cc-bec4-9128ec6e1e2b",
   CellTags->"TextAnnotation",
   CellID->1198287826],
  Cell[262047, 6962, 473, 9, 70, "Print",ExpressionUUID->"16cc009b-23b5-472b-b27f-4789b122202b",
   CellTags->"TextAnnotation",
   CellID->366925106],
  Cell[262523, 6973, 490, 10, 70, "Print",ExpressionUUID->"7d267c30-5d79-42c5-bf4c-350d9ba3d0ed",
   CellTags->"TextAnnotation",
   CellID->865431663],
  Cell[263016, 6985, 448, 12, 70, "Print",ExpressionUUID->"7353a57d-971d-4746-ab53-f8945c44f041",
   CellTags->"TextAnnotation",
   CellID->1901227907],
  Cell[263467, 6999, 394, 8, 70, "Print",ExpressionUUID->"ae8350df-12be-48e4-8409-f811d2a6badf",
   CellTags->"TextAnnotation",
   CellID->77339353],
  Cell[263864, 7009, 474, 9, 70, "Print",ExpressionUUID->"626e63c4-f577-4f19-8101-94f58e41bdfb",
   CellTags->"TextAnnotation",
   CellID->1785355346],
  Cell[264341, 7020, 481, 9, 70, "Print",ExpressionUUID->"d0e6787d-128c-44dc-89ac-eae822c2b65a",
   CellTags->"TextAnnotation",
   CellID->245556838],
  Cell[264825, 7031, 381, 9, 70, "Print",ExpressionUUID->"8b58890d-3207-497d-9d36-c4b340d58181",
   CellTags->"TextAnnotation",
   CellID->684463849],
  Cell[265209, 7042, 395, 8, 70, "Print",ExpressionUUID->"9a01296a-c5eb-41e8-b234-8e4ab97ded8d",
   CellTags->"TextAnnotation",
   CellID->189745901],
  Cell[265607, 7052, 474, 9, 70, "Print",ExpressionUUID->"732be6b4-afae-4ac0-bd38-8db16b59f1fd",
   CellTags->"TextAnnotation",
   CellID->1855243473],
  Cell[266084, 7063, 479, 9, 70, "Print",ExpressionUUID->"dcb4bd2e-59cf-42a9-8d46-b2e869cc3a73",
   CellTags->"TextAnnotation",
   CellID->453634429],
  Cell[266566, 7074, 516, 14, 70, "Print",ExpressionUUID->"86a60dd3-4705-4274-ad5d-80dd335ec437",
   CellTags->"TextAnnotation",
   CellID->1195169105],
  Cell[267085, 7090, 396, 8, 70, "Print",ExpressionUUID->"abb57ba8-f0e2-4ddd-b469-fc2682676446",
   CellTags->"TextAnnotation",
   CellID->1457373697],
  Cell[267484, 7100, 472, 9, 70, "Print",ExpressionUUID->"3fe5db5b-f07e-418a-b92e-05bf349b0c7d",
   CellTags->"TextAnnotation",
   CellID->41856393],
  Cell[267959, 7111, 490, 10, 70, "Print",ExpressionUUID->"0bd65900-43be-430a-b85b-acb0023fc690",
   CellTags->"TextAnnotation",
   CellID->243104657],
  Cell[268452, 7123, 530, 11, 70, "Print",ExpressionUUID->"b30396fb-34d9-4cd8-9ed1-ba4732b1c11b",
   CellTags->"TextAnnotation",
   CellID->2055520969],
  Cell[268985, 7136, 631, 14, 70, "Print",ExpressionUUID->"0d050b03-7559-4388-aa8f-53f737137c95",
   CellTags->"TextAnnotation",
   CellID->322584418],
  Cell[269619, 7152, 538, 11, 70, "Print",ExpressionUUID->"f5c5d8ed-f4e9-4014-8552-8932caf3930f",
   CellTags->"TextAnnotation",
   CellID->1782759593],
  Cell[270160, 7165, 640, 14, 70, "Print",ExpressionUUID->"d6c210c4-98e0-4325-b45d-e12149540422",
   CellTags->"TextAnnotation",
   CellID->1112488754],
  Cell[270803, 7181, 537, 11, 70, "Print",ExpressionUUID->"e92ce240-11e4-4446-aac4-bcc19b4c7ff9",
   CellTags->"TextAnnotation",
   CellID->923850462],
  Cell[271343, 7194, 635, 14, 70, "Print",ExpressionUUID->"49161f5e-b186-4f0c-82f7-7fe1ada5e187",
   CellTags->"TextAnnotation",
   CellID->651566748],
  Cell[271981, 7210, 545, 11, 70, "Print",ExpressionUUID->"8b113f00-bc77-41bf-b825-22bda7959fb2",
   CellTags->"TextAnnotation",
   CellID->772238174],
  Cell[272529, 7223, 641, 14, 70, "Print",ExpressionUUID->"66203e65-e0ce-4809-bd3b-4b94f4166d6c",
   CellTags->"TextAnnotation",
   CellID->427925416],
  Cell[273173, 7239, 539, 11, 70, "Print",ExpressionUUID->"298d7199-a0bb-4126-bca7-4fdfbf6d1393",
   CellTags->"TextAnnotation",
   CellID->544564352],
  Cell[273715, 7252, 637, 14, 70, "Print",ExpressionUUID->"ba96bf9a-f3d4-49bb-8753-e8426b930a70",
   CellTags->"TextAnnotation",
   CellID->860733797],
  Cell[274355, 7268, 548, 11, 70, "Print",ExpressionUUID->"3a769e5e-040d-4308-8412-4c14f204cf05",
   CellTags->"TextAnnotation",
   CellID->1508784360],
  Cell[274906, 7281, 648, 14, 70, "Print",ExpressionUUID->"7bfa521e-2559-4289-9ce0-93a30de1ed80",
   CellTags->"TextAnnotation",
   CellID->1468757500],
  Cell[275557, 7297, 538, 11, 70, "Print",ExpressionUUID->"4855a577-6aa2-4a0c-8350-6b850fe95e32",
   CellTags->"TextAnnotation",
   CellID->50836396],
  Cell[276098, 7310, 640, 14, 70, "Print",ExpressionUUID->"f25d2968-2c11-4762-942d-ce9f8dfcc96b",
   CellTags->"TextAnnotation",
   CellID->1007053073],
  Cell[276741, 7326, 547, 11, 70, "Print",ExpressionUUID->"b1efe63b-fd11-4c80-9c4d-fa62597cfba1",
   CellTags->"TextAnnotation",
   CellID->200952969],
  Cell[277291, 7339, 645, 14, 70, "Print",ExpressionUUID->"e4ae0813-fe26-44e7-b519-14abd6bbd413",
   CellTags->"TextAnnotation",
   CellID->262306480],
  Cell[277939, 7355, 188, 3, 70, "Print",ExpressionUUID->"938aca39-c57c-4c7e-81b6-4dd474867287",
   CellTags->"TextAnnotation",
   CellID->57857251],
  Cell[278130, 7360, 533, 11, 70, "Print",ExpressionUUID->"82c54e99-1a68-4f36-89fa-cfd603aff43c",
   CellTags->"TextAnnotation",
   CellID->567878076],
  Cell[278666, 7373, 634, 14, 70, "Print",ExpressionUUID->"0f9c14f8-c247-41c4-a9d2-7740b6c6edc5",
   CellTags->"TextAnnotation",
   CellID->1127738143],
  Cell[279303, 7389, 530, 11, 70, "Print",ExpressionUUID->"fbcd3599-e657-4154-a2cf-5a903fb85930",
   CellTags->"TextAnnotation",
   CellID->1959085158],
  Cell[279836, 7402, 629, 14, 70, "Print",ExpressionUUID->"0aba7ea0-9266-46ab-8d3a-397968aa62b5",
   CellTags->"TextAnnotation",
   CellID->645217429],
  Cell[280468, 7418, 533, 11, 70, "Print",ExpressionUUID->"65134fa3-225a-4b81-b056-5de36b7a691d",
   CellTags->"TextAnnotation",
   CellID->765609841],
  Cell[281004, 7431, 634, 14, 70, "Print",ExpressionUUID->"1ef6c3f0-1317-42a5-b3b4-a7a32a81d982",
   CellTags->"TextAnnotation",
   CellID->57158349],
  Cell[281641, 7447, 534, 11, 70, "Print",ExpressionUUID->"7de54172-58bc-4ea0-ba0d-a599c76f6f53",
   CellTags->"TextAnnotation",
   CellID->1329681278],
  Cell[282178, 7460, 635, 14, 70, "Print",ExpressionUUID->"0bda2937-63b9-4b47-a7da-7f85340658f4",
   CellTags->"TextAnnotation",
   CellID->955355742],
  Cell[282816, 7476, 536, 11, 70, "Print",ExpressionUUID->"dec3e844-0d17-4cce-b38e-c109fad2157a",
   CellTags->"TextAnnotation",
   CellID->1912401822],
  Cell[283355, 7489, 636, 14, 70, "Print",ExpressionUUID->"7aedf452-8067-495f-bbaf-76a951c2319e",
   CellTags->"TextAnnotation",
   CellID->1783315707],
  Cell[283994, 7505, 533, 11, 70, "Print",ExpressionUUID->"391b459b-773c-4807-8a3e-76166272edb1",
   CellTags->"TextAnnotation",
   CellID->3041200],
  Cell[284530, 7518, 636, 14, 70, "Print",ExpressionUUID->"129ff4a5-cb46-40e7-bd2d-80c4c4cb1a4b",
   CellTags->"TextAnnotation",
   CellID->1222291872],
  Cell[285169, 7534, 526, 11, 70, "Print",ExpressionUUID->"f50af189-481b-4185-9012-4a8aa2041f78",
   CellTags->"TextAnnotation",
   CellID->1825172100],
  Cell[285698, 7547, 629, 14, 70, "Print",ExpressionUUID->"394419b2-ccbe-432a-8e0c-b89e8cea241a",
   CellTags->"TextAnnotation",
   CellID->246145857],
  Cell[286330, 7563, 526, 11, 70, "Print",ExpressionUUID->"7f7f68e7-3a88-4388-89d4-307d13dae5ea",
   CellTags->"TextAnnotation",
   CellID->1130329193],
  Cell[286859, 7576, 622, 14, 70, "Print",ExpressionUUID->"c3782472-3d36-40aa-b2d7-bef19f30318e",
   CellTags->"TextAnnotation",
   CellID->272871],
  Cell[287484, 7592, 518, 11, 70, "Print",ExpressionUUID->"122ff2da-25f0-4860-bcf5-581814c59a61",
   CellTags->"TextAnnotation",
   CellID->2028905450],
  Cell[288005, 7605, 612, 13, 70, "Print",ExpressionUUID->"b3e374bb-aaca-446b-b8c2-a48a57feae73",
   CellTags->"TextAnnotation",
   CellID->95334299],
  Cell[288620, 7620, 519, 11, 70, "Print",ExpressionUUID->"39418410-1e5f-4730-9b64-e4f6f3a7f64d",
   CellTags->"TextAnnotation",
   CellID->924123333],
  Cell[289142, 7633, 615, 13, 70, "Print",ExpressionUUID->"917dc100-9978-417d-9e8d-3f8587152e5e",
   CellTags->"TextAnnotation",
   CellID->532988551],
  Cell[289760, 7648, 555, 11, 70, "Print",ExpressionUUID->"7d70c561-e4a0-4871-839c-3faab4e7688d",
   CellTags->"TextAnnotation",
   CellID->867572473],
  Cell[290318, 7661, 658, 14, 70, "Print",ExpressionUUID->"9e68195c-d35d-4d68-800d-259b48adb61c",
   CellTags->"TextAnnotation",
   CellID->1352048749],
  Cell[290979, 7677, 560, 11, 70, "Print",ExpressionUUID->"6438df23-5a39-4800-a87f-63f447b3b2f8",
   CellTags->"TextAnnotation",
   CellID->1077552903],
  Cell[291542, 7690, 660, 14, 70, "Print",ExpressionUUID->"ef455198-2edf-41ee-a839-8da70d838918",
   CellTags->"TextAnnotation",
   CellID->1728306271],
  Cell[292217, 7707, 192176, 4431, 70, "Output",ExpressionUUID->"3f8afc3e-fefd-436f-8762-79c71060ccbb",
   CellTags->"TextAnnotation",
   CellID->713349461]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 915080, 24608},
 {"TextAnnotation", 915278, 24612}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[593, 21, 3338, 78, 58, "AnchorBarGrid",ExpressionUUID->"1df62c01-8fae-4abc-b003-b9baa0bea05b",
 CellID->1],
Cell[3934, 101, 94, 0, 23, "ContextNameCell",ExpressionUUID->"7b9fbad8-4bbf-4d7d-a395-655952bee155"],
Cell[CellGroupData[{
Cell[4053, 105, 564, 14, 59, "ObjectNameGrid",ExpressionUUID->"e5e03f69-de4d-4226-88c8-2fe474bbb61a"],
Cell[4620, 121, 500, 10, 89, "Usage",ExpressionUUID->"d0853635-e888-4632-b531-9010a8a52da4",
 CellID->423578463]
}, Open  ]],
Cell[CellGroupData[{
Cell[5157, 136, 1908, 48, 37, "NotesSection",ExpressionUUID->"2e45002b-957a-45ba-81a0-22a075b3f70c",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1851554135],
Cell[7068, 186, 128, 1, 70, "Notes",ExpressionUUID->"134d028e-088b-4fa4-8b4b-f43e149f403b",
 CellID->354734344],
Cell[7199, 189, 3688, 80, 70, "3ColumnTableMod",ExpressionUUID->"cabe4873-b21d-4d4c-b508-6cb87fc34ce3",
 CellID->55188794]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[11014, 275, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"c66f1b97-afa1-4787-b251-31145eb43622",
 CellTags->"PrimaryExamplesSection",
 CellID->784848252],
Cell[12437, 314, 220, 5, 27, "Input",ExpressionUUID->"2f47d450-71bc-4a05-9ac0-2b4ab1390aaa",
 Evaluatable->True],
Cell[CellGroupData[{
Cell[12682, 323, 1398, 36, 30, "ExampleSection",ExpressionUUID->"534c1ec5-92cd-48ae-b8c5-bf4beffee7f4",
 CellID->187009598],
Cell[CellGroupData[{
Cell[14105, 363, 1437, 37, 30, "ExampleSubsection",ExpressionUUID->"ae9382e4-c372-40b8-a503-3da72918f262",
 CellID->127660352],
Cell[15545, 402, 246, 4, 70, "ExampleText",ExpressionUUID->"1babf5af-a6b2-4854-8cdb-d3f6768471fb",
 CellID->50967587],
Cell[15794, 408, 369, 9, 70, "Input",ExpressionUUID->"bbc4b615-70a1-4799-bdc2-5966c8fdc875",
 CellID->1291860986],
Cell[16166, 419, 2192, 69, 70, "Input",ExpressionUUID->"424e743d-711d-4bc3-8775-8d1e650351f7",
 CellID->203828065],
Cell[18361, 490, 143, 1, 70, "ExampleText",ExpressionUUID->"e06c452f-aa6f-4843-aca7-6cd3fbec9024",
 CellID->252826225],
Cell[18507, 493, 606, 19, 70, "Input",ExpressionUUID->"eda99c78-de79-4e55-89f3-f210b54c35a6",
 CellID->435705],
Cell[19116, 514, 125, 1, 70, "ExampleText",ExpressionUUID->"3368c10d-c5fc-4d32-98b5-4c64dedf09df",
 CellID->172899496],
Cell[19244, 517, 1498, 40, 70, "Input",ExpressionUUID->"2587eaf0-6ebe-4506-b455-be4f41953438",
 CellID->218378580],
Cell[20745, 559, 781, 22, 70, "Input",ExpressionUUID->"33944c4b-c5d8-4a01-997b-b654f8ca7734",
 CellID->270763279],
Cell[21529, 583, 207, 5, 70, "ExampleText",ExpressionUUID->"c5e6d167-8f3d-4528-8ae2-c3a1bf8450ac",
 CellID->137807236],
Cell[CellGroupData[{
Cell[21761, 592, 340, 7, 70, "Input",ExpressionUUID->"81c6d8c9-5736-4a97-b83c-7d21dbe9d142",
 CellID->135730069],
Cell[CellGroupData[{
Cell[22126, 603, 374, 9, 70, "Print",ExpressionUUID->"559a0dd4-c56e-4d6a-b764-38e4c433284b",
 CellID->5852917],
Cell[22503, 614, 172, 2, 70, "Print",ExpressionUUID->"599303b0-7164-4cae-a0fa-866508d464c4",
 CellID->463641036],
Cell[22678, 618, 455, 12, 70, "Print",ExpressionUUID->"e77ac173-4e7c-4009-acf7-527d43ad86aa",
 CellID->5065389],
Cell[23136, 632, 172, 2, 70, "Print",ExpressionUUID->"bf3ccec0-eb62-47ef-8f80-d68a158106a9",
 CellID->278465605],
Cell[23311, 636, 493, 13, 70, "Print",ExpressionUUID->"fd271bf9-5c81-45cc-9aee-0204396d7a62",
 CellID->65984570],
Cell[23807, 651, 366, 7, 70, "Print",ExpressionUUID->"2ef2cc67-fef4-4f60-bf41-5e07530b801d",
 CellID->634367901],
Cell[24176, 660, 446, 8, 70, "Print",ExpressionUUID->"c1f43267-ac3f-4746-9df1-aa9a72b93740",
 CellID->130222697],
Cell[24625, 670, 465, 12, 70, "Print",ExpressionUUID->"3b498070-410c-4d2d-b989-e3c4c5a2a5ab",
 CellID->196042145],
Cell[25093, 684, 172, 2, 70, "Print",ExpressionUUID->"0fa9116a-b9af-4627-938d-e108c040d441",
 CellID->168339647],
Cell[25268, 688, 442, 11, 70, "Print",ExpressionUUID->"a675fdd0-894c-45ba-bf47-794ea31c1819",
 CellID->99045589],
Cell[25713, 701, 169, 2, 70, "Print",ExpressionUUID->"2e0fbcca-506e-4b04-8b37-105c729b3997",
 CellID->783455],
Cell[25885, 705, 327, 7, 70, "Print",ExpressionUUID->"4063c993-3bfb-4593-b323-ac5e78b49738",
 CellID->77227295],
Cell[26215, 714, 171, 2, 70, "Print",ExpressionUUID->"88fdae19-04eb-4708-a3c6-787b9006736c",
 CellID->47806718],
Cell[26389, 718, 492, 13, 70, "Print",ExpressionUUID->"5d17f20e-b955-44dd-9934-6c1a54c3f78f",
 CellID->694131442],
Cell[26884, 733, 367, 7, 70, "Print",ExpressionUUID->"5a4d5fac-cf19-42e3-906d-a16d4a9def97",
 CellID->57488658],
Cell[27254, 742, 446, 8, 70, "Print",ExpressionUUID->"c5487866-79e7-43fd-8607-2f8cbc07bb1d",
 CellID->267522509],
Cell[27703, 752, 460, 9, 70, "Print",ExpressionUUID->"4d1982af-6dbc-4003-82dc-a502e4adf00f",
 CellID->19466874],
Cell[28166, 763, 470, 12, 70, "Print",ExpressionUUID->"d03100a2-cb5a-483c-a190-ecf7e7535966",
 CellID->838919888],
Cell[28639, 777, 368, 7, 70, "Print",ExpressionUUID->"1af37374-a07b-4506-9263-a4de44366990",
 CellID->696503788],
Cell[29010, 786, 444, 8, 70, "Print",ExpressionUUID->"7c039f6f-b033-491c-889f-e722ccf30c3f",
 CellID->2661945],
Cell[29457, 796, 461, 9, 70, "Print",ExpressionUUID->"984a96e0-e10e-4849-8cd9-219b888b74a2",
 CellID->184307024],
Cell[29921, 807, 418, 11, 70, "Print",ExpressionUUID->"a06938ca-4571-496e-81dc-dbc8dda82171",
 CellID->227886861],
Cell[30342, 820, 365, 7, 70, "Print",ExpressionUUID->"b74b7a5b-c764-4569-8a2e-2e6a2011ea7d",
 CellID->384030],
Cell[30710, 829, 446, 8, 70, "Print",ExpressionUUID->"ea13ed11-319b-479d-bff8-e3bb86f6c01e",
 CellID->547270926],
Cell[31159, 839, 453, 8, 70, "Print",ExpressionUUID->"359160e6-1461-4a7b-bbc5-f4a54b4d43d3",
 CellID->15713929],
Cell[31615, 849, 351, 8, 70, "Print",ExpressionUUID->"61bf1c80-27d3-4f77-a81b-42e3f1cd2619",
 CellID->59716844],
Cell[31969, 859, 368, 7, 70, "Print",ExpressionUUID->"479bc5c9-dd79-47a3-bd19-f6f10aceebba",
 CellID->101400817],
Cell[32340, 868, 446, 8, 70, "Print",ExpressionUUID->"fa24d017-ba3d-4d17-96fd-696f535ba443",
 CellID->166958084],
Cell[32789, 878, 452, 8, 70, "Print",ExpressionUUID->"df9e28b4-cc22-4820-a77e-571a3d62a9c3",
 CellID->341131364],
Cell[33244, 888, 486, 13, 70, "Print",ExpressionUUID->"aff30cfc-7316-4055-9227-d1845fe5af7f",
 CellID->412264477],
Cell[33733, 903, 368, 7, 70, "Print",ExpressionUUID->"04461a96-52ca-460b-8837-dc5cfd037110",
 CellID->468115244],
Cell[34104, 912, 445, 8, 70, "Print",ExpressionUUID->"122a00a5-7b46-4ffc-853e-f33853795ae9",
 CellID->82378815],
Cell[34552, 922, 456, 8, 70, "Print",ExpressionUUID->"d84594af-7be2-46ae-a757-b17cdfa6e89c",
 CellID->849169183],
Cell[35011, 932, 504, 10, 70, "Print",ExpressionUUID->"217d488c-bdb6-4879-a749-111ef4f9b04d",
 CellID->138627308],
Cell[35518, 944, 601, 13, 70, "Print",ExpressionUUID->"3f8cf9e6-8bbb-4415-b813-78c9967f4fbd",
 CellID->16223750],
Cell[36122, 959, 496, 10, 70, "Print",ExpressionUUID->"b80aca3e-9f58-4bc1-ab54-021fb62adf07",
 CellID->394301372],
Cell[36621, 971, 610, 13, 70, "Print",ExpressionUUID->"b19a37c1-8fec-4492-b8e0-378cd99b2cb0",
 CellID->152543602],
Cell[37234, 986, 488, 10, 70, "Print",ExpressionUUID->"923e3a7e-e122-49d4-9074-4f17f2014069",
 CellID->132575061],
Cell[37725, 998, 604, 13, 70, "Print",ExpressionUUID->"825d3497-2d77-40a5-a977-56418bd3623e",
 CellID->457906397],
Cell[38332, 1013, 512, 10, 70, "Print",ExpressionUUID->"2b59cab2-7d9d-4c45-a5ec-59ad68c61109",
 CellID->378840197],
Cell[38847, 1025, 614, 13, 70, "Print",ExpressionUUID->"edbd8b8f-fb0a-4d11-b664-217d296bd294",
 CellID->124513870],
Cell[39464, 1040, 522, 10, 70, "Print",ExpressionUUID->"5e1d37d7-ee60-4b3e-b836-d9abb9f978be",
 CellID->512557888],
Cell[39989, 1052, 606, 13, 70, "Print",ExpressionUUID->"cc3508ea-a69d-4ed3-9be7-7d297f37ba6d",
 CellID->9087502],
Cell[40598, 1067, 514, 10, 70, "Print",ExpressionUUID->"365d83c1-5926-49d8-b0a3-d78325d24c60",
 CellID->527578536],
Cell[41115, 1079, 611, 13, 70, "Print",ExpressionUUID->"fe84739b-4673-4bfc-bd58-33a28c262320",
 CellID->28528108],
Cell[41729, 1094, 522, 10, 70, "Print",ExpressionUUID->"56375308-bf96-4d63-af47-a6f0ddf99454",
 CellID->612405706],
Cell[42254, 1106, 622, 13, 70, "Print",ExpressionUUID->"ab597c2c-ae9c-4e38-a0f8-da6c3d751e47",
 CellID->185933523],
Cell[42879, 1121, 160, 2, 70, "Print",ExpressionUUID->"bd262f76-e502-4fd1-b7c6-a6ffd3cd62c8",
 CellID->109884437],
Cell[43042, 1125, 490, 10, 70, "Print",ExpressionUUID->"58eefa92-8916-40e8-af00-aa9f77d7235e",
 CellID->593297084],
Cell[43535, 1137, 608, 13, 70, "Print",ExpressionUUID->"65156578-eb89-4b10-ae7e-01d7f1560068",
 CellID->158414543],
Cell[44146, 1152, 506, 10, 70, "Print",ExpressionUUID->"fd7f8e19-c8d8-47f4-b0c4-8c40659bb02e",
 CellID->185149827],
Cell[44655, 1164, 594, 13, 70, "Print",ExpressionUUID->"4cea9325-db20-4a84-8380-334650d85251",
 CellID->144308100],
Cell[45252, 1179, 524, 10, 70, "Print",ExpressionUUID->"3cd46119-35b3-41c8-be12-963bceb0d3c6",
 CellID->250090492],
Cell[45779, 1191, 626, 13, 70, "Print",ExpressionUUID->"0ae475c4-30b7-4b43-9f9f-f323c977b2b0",
 CellID->151160510],
Cell[46408, 1206, 530, 10, 70, "Print",ExpressionUUID->"0fb80419-3841-4b72-adba-5579b5c85496",
 CellID->116873806],
Cell[46941, 1218, 632, 13, 70, "Print",ExpressionUUID->"d7045d6e-f5ee-4884-8c8c-81c488f8d0cc",
 CellID->101328155],
Cell[47576, 1233, 518, 10, 70, "Print",ExpressionUUID->"3d1808c5-e87d-4a55-923c-e1f6faafe2ea",
 CellID->277979585],
Cell[48097, 1245, 634, 13, 70, "Print",ExpressionUUID->"a7a12a1e-de0e-4058-8b8d-5810691e6248",
 CellID->278679933]
}, Open  ]],
Cell[48746, 1261, 3318, 109, 70, "Output",ExpressionUUID->"ae504e03-f647-4a5a-9e5a-19a70e1683a1",
 CellID->320999606]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[52328, 1381, 1392, 36, 30, "ExampleSection",ExpressionUUID->"8ae91dd6-234b-4a7b-99e1-acc5768c4117"],
Cell[CellGroupData[{
Cell[53745, 1421, 1447, 37, 70, "ExampleSubsection",ExpressionUUID->"9defd73a-b61f-4169-8f3d-b9ac1216e7cc",
 CellID->166252624],
Cell[55195, 1460, 194, 4, 70, "Input",ExpressionUUID->"3060cbae-deff-4dc3-a21f-267e8cc4c2d3",
 CellID->177197649],
Cell[55392, 1466, 369, 9, 70, "Input",ExpressionUUID->"5fea6f4d-ac5d-43e9-842e-d9c9a564b641",
 CellID->1547569602],
Cell[55764, 1477, 331, 6, 70, "ExampleText",ExpressionUUID->"013615b1-eaa4-4bef-a9ad-50100869561c",
 CellID->1038097723],
Cell[56098, 1485, 2596, 79, 70, "Input",ExpressionUUID->"cd11e155-77b6-43b9-842c-03e449c9f07c",
 CellID->924481581],
Cell[58697, 1566, 146, 1, 70, "ExampleText",ExpressionUUID->"da3043bc-a3c1-424a-8ff3-38c8a765a02e",
 CellID->340800963],
Cell[58846, 1569, 1309, 40, 70, "Input",ExpressionUUID->"9430adca-6d1c-4077-a419-24cb82685d48"],
Cell[CellGroupData[{
Cell[60180, 1613, 340, 7, 70, "Input",ExpressionUUID->"6b7bbf62-5e5c-486c-981f-1f904fc137b2",
 CellID->349984709],
Cell[CellGroupData[{
Cell[60545, 1624, 376, 9, 70, "Print",ExpressionUUID->"53b688d1-24c8-42ed-9862-af46a8cbe3bc",
 CellID->1357956904],
Cell[60924, 1635, 170, 2, 70, "Print",ExpressionUUID->"c040d50a-d432-4226-96f4-fee1f59be50b",
 CellID->40428323],
Cell[61097, 1639, 456, 12, 70, "Print",ExpressionUUID->"27832f2a-e62e-4a59-82fc-7767c54c65ed",
 CellID->200199492],
Cell[61556, 1653, 171, 2, 70, "Print",ExpressionUUID->"579b2533-cb1a-41bf-9bdf-38ca112d5c70",
 CellID->914944930],
Cell[61730, 1657, 492, 13, 70, "Print",ExpressionUUID->"a78f5d7f-56a0-43b2-b9a1-382f9982523e",
 CellID->53285616],
Cell[62225, 1672, 366, 7, 70, "Print",ExpressionUUID->"36ec9d6e-ea9e-4f2d-8349-72970b7c1c5b",
 CellID->1127335999],
Cell[62594, 1681, 444, 8, 70, "Print",ExpressionUUID->"75ff0cf0-f3f3-4350-8869-78e172246e2c",
 CellID->1175955294],
Cell[63041, 1691, 464, 12, 70, "Print",ExpressionUUID->"7b5b4bde-a17d-407d-99f7-9120161f8965",
 CellID->258082200],
Cell[63508, 1705, 172, 2, 70, "Print",ExpressionUUID->"524fbed4-1955-42c9-863d-2e686df1d998",
 CellID->1601017655],
Cell[63683, 1709, 443, 11, 70, "Print",ExpressionUUID->"aedacfb1-8c6d-46fe-bcbc-6dd864043e29",
 CellID->1893234523],
Cell[64129, 1722, 172, 2, 70, "Print",ExpressionUUID->"84ec8c03-22a5-4341-80a1-c1f1a2174d75",
 CellID->1315599441],
Cell[64304, 1726, 327, 7, 70, "Print",ExpressionUUID->"b510804d-19b7-4dd2-afad-5f0e08701788",
 CellID->170053423],
Cell[64634, 1735, 172, 2, 70, "Print",ExpressionUUID->"ec9d13db-7572-490d-b814-a8421960dc71",
 CellID->2070432172],
Cell[64809, 1739, 491, 13, 70, "Print",ExpressionUUID->"07658a55-4616-445c-aef7-4ef39a10089a",
 CellID->960457348],
Cell[65303, 1754, 366, 7, 70, "Print",ExpressionUUID->"c534ccd3-efd2-4e48-80b5-05edb85ca29a",
 CellID->1988655692],
Cell[65672, 1763, 444, 8, 70, "Print",ExpressionUUID->"5a357c15-e162-4785-8f32-7b5d668fc651",
 CellID->1279696056],
Cell[66119, 1773, 455, 8, 70, "Print",ExpressionUUID->"880a93a1-c3ca-4fe0-bd8d-df8acef5db4d",
 CellID->412831267],
Cell[66577, 1783, 470, 12, 70, "Print",ExpressionUUID->"7fd57841-a7c2-4dec-a317-3937bd7ebbe5",
 CellID->1408843370],
Cell[67050, 1797, 366, 7, 70, "Print",ExpressionUUID->"efc36d13-d4de-4234-8bfd-65df85134786",
 CellID->1228005106],
Cell[67419, 1806, 441, 8, 70, "Print",ExpressionUUID->"fac436de-7695-43cc-809e-9fc9da999d20",
 CellID->613625818],
Cell[67863, 1816, 455, 8, 70, "Print",ExpressionUUID->"f7bab082-ebaf-4d25-9cdf-b1da452ec883",
 CellID->880752784],
Cell[68321, 1826, 417, 11, 70, "Print",ExpressionUUID->"3fdb392f-7852-4620-959e-2f7dc511ed02",
 CellID->716925503],
Cell[68741, 1839, 364, 7, 70, "Print",ExpressionUUID->"90f6808d-2197-4eee-b233-c327d424cc08",
 CellID->1409789729],
Cell[69108, 1848, 444, 8, 70, "Print",ExpressionUUID->"39934dbb-9175-4940-8a97-b12cf2f95a88",
 CellID->1815347444],
Cell[69555, 1858, 452, 8, 70, "Print",ExpressionUUID->"0a222363-f698-438e-8c74-ceddf73dcc3d",
 CellID->1718102184],
Cell[70010, 1868, 351, 8, 70, "Print",ExpressionUUID->"2d3df40d-34f8-4a29-848b-89daeebdead2",
 CellID->800340296],
Cell[70364, 1878, 366, 7, 70, "Print",ExpressionUUID->"7c4b831b-7e74-4ea6-b937-ac0943b29a08",
 CellID->1744371901],
Cell[70733, 1887, 444, 8, 70, "Print",ExpressionUUID->"a2d3090f-f54f-48e4-b394-35316aeb9df8",
 CellID->1481870291],
Cell[71180, 1897, 450, 8, 70, "Print",ExpressionUUID->"8cd09a45-7a05-46bf-971c-e0f1d0a255dc",
 CellID->1265001489],
Cell[71633, 1907, 486, 13, 70, "Print",ExpressionUUID->"13930ea3-8439-48a3-bc3b-2a4daadb36a8",
 CellID->2051354177],
Cell[72122, 1922, 365, 7, 70, "Print",ExpressionUUID->"73ad9b16-7a79-4cac-9891-f0d1ea7a27cc",
 CellID->692343547],
Cell[72490, 1931, 444, 8, 70, "Print",ExpressionUUID->"72917d7d-c90b-451e-a276-4338cc14cb6b",
 CellID->1305429812],
Cell[72937, 1941, 455, 8, 70, "Print",ExpressionUUID->"6593993d-4544-419c-a789-6ef73bfbb37b",
 CellID->104070021],
Cell[73395, 1951, 500, 10, 70, "Print",ExpressionUUID->"bee41e10-a365-4a41-9e44-d987dd391e8f",
 CellID->1607288477],
Cell[73898, 1963, 600, 13, 70, "Print",ExpressionUUID->"80ea89e8-935d-4d0b-9caa-199addbf5fcc",
 CellID->1358715429],
Cell[74501, 1978, 510, 10, 70, "Print",ExpressionUUID->"9e29249b-5869-44f5-938c-ad1816b8e8d0",
 CellID->1231406020],
Cell[75014, 1990, 608, 13, 70, "Print",ExpressionUUID->"27f7a4f2-6646-4925-ad01-143151368c9e",
 CellID->1689786230],
Cell[75625, 2005, 499, 10, 70, "Print",ExpressionUUID->"311f1e09-4851-47cc-9d10-3651741f3fc8",
 CellID->387187075],
Cell[76127, 2017, 602, 13, 70, "Print",ExpressionUUID->"19682b8a-9c50-422d-a0b3-8b640054dd82",
 CellID->1489488220],
Cell[76732, 2032, 512, 10, 70, "Print",ExpressionUUID->"0192180f-ce9d-48a9-9bf3-90ffb7779776",
 CellID->1143320237],
Cell[77247, 2044, 611, 13, 70, "Print",ExpressionUUID->"ae9c89bc-7c44-409c-8614-dbf62f02fa57",
 CellID->132937950],
Cell[77861, 2059, 521, 10, 70, "Print",ExpressionUUID->"3dd30155-1799-4fe6-bf88-721d83fc0e87",
 CellID->657604013],
Cell[78385, 2071, 618, 13, 70, "Print",ExpressionUUID->"5dc5ce06-cf8c-450a-998a-47757168d9e8",
 CellID->1313373661],
Cell[79006, 2086, 508, 10, 70, "Print",ExpressionUUID->"f4f42d17-5bbd-42f2-848c-8f9d910ab5f0",
 CellID->55886474],
Cell[79517, 2098, 608, 13, 70, "Print",ExpressionUUID->"6a87537f-a7a8-43eb-976f-983e0095cdb0",
 CellID->1618061362],
Cell[80128, 2113, 518, 10, 70, "Print",ExpressionUUID->"4b184a54-8536-4ee7-a7b1-103463590dbd",
 CellID->1154545705],
Cell[80649, 2125, 622, 13, 70, "Print",ExpressionUUID->"59f65fd9-3c84-4774-b9e4-2c1bfd3c202f",
 CellID->1335582531],
Cell[81274, 2140, 160, 2, 70, "Print",ExpressionUUID->"e7e88a72-0d7d-4836-a9d1-9b6994e9bb75",
 CellID->2030892629]
}, Open  ]]
}, Open  ]],
Cell[81461, 2146, 200, 4, 70, "ExampleText",ExpressionUUID->"ccb55ab7-f974-4377-b148-a07713221009",
 CellID->314540351],
Cell[81664, 2152, 249, 4, 70, "ExampleText",ExpressionUUID->"0afb36e6-d21f-47f7-9481-88dbd56c6795",
 CellID->383569643],
Cell[81916, 2158, 325, 7, 70, "Input",ExpressionUUID->"0360e55b-74b3-490c-8aa6-b0c4e0b690d9",
 CellID->812989402],
Cell[82244, 2167, 606, 15, 70, "Input",ExpressionUUID->"68259d73-e86c-47fd-994d-543603eaf68d",
 CellID->267828646],
Cell[82853, 2184, 353, 6, 70, "ExampleText",ExpressionUUID->"83e2ce50-e187-4f7d-a51e-41e7a155824a",
 CellID->36750435],
Cell[83209, 2192, 2806, 85, 70, "Input",ExpressionUUID->"03725d35-62be-4033-ac15-756cdc5205ce",
 CellID->9496957],
Cell[86018, 2279, 149, 1, 70, "ExampleText",ExpressionUUID->"601f828d-89eb-45fa-88e5-b35fd931eede",
 CellID->314375278],
Cell[86170, 2282, 1197, 36, 70, "Input",ExpressionUUID->"22366b2d-43f2-43e8-b4e0-8ab54e577367",
 CellID->198482489],
Cell[CellGroupData[{
Cell[87392, 2322, 341, 7, 70, "Input",ExpressionUUID->"8753a13a-15f3-4854-8766-332c428f374e",
 CellID->195155793],
Cell[CellGroupData[{
Cell[87758, 2333, 376, 9, 70, "Print",ExpressionUUID->"fbe29e79-8a2d-4aea-b02a-f67a63efe39b",
 CellID->415905427],
Cell[88137, 2344, 172, 2, 70, "Print",ExpressionUUID->"d3b0e2b0-50e0-4ec8-b5a0-432facd5e90c",
 CellID->416103989],
Cell[88312, 2348, 457, 12, 70, "Print",ExpressionUUID->"8c4d1cdc-f1e2-41a8-a77a-e82bdf88cf45",
 CellID->497034799],
Cell[88772, 2362, 173, 2, 70, "Print",ExpressionUUID->"df74f91a-d470-4727-83c2-3db834338b60",
 CellID->1296658211],
Cell[88948, 2366, 495, 13, 70, "Print",ExpressionUUID->"b781dad5-fe32-462e-9a52-3f1229b2ea69",
 CellID->1133029492],
Cell[89446, 2381, 367, 7, 70, "Print",ExpressionUUID->"f0d77161-231c-48bd-bc51-e2207e754d8d",
 CellID->1906824529],
Cell[89816, 2390, 444, 8, 70, "Print",ExpressionUUID->"3810c559-d61c-45bb-a5c3-4d2163dd676d",
 CellID->964522007],
Cell[90263, 2400, 465, 12, 70, "Print",ExpressionUUID->"76c99fe2-d675-43bd-93e9-4e740ca813c9",
 CellID->703648029],
Cell[90731, 2414, 172, 2, 70, "Print",ExpressionUUID->"5d85d291-0b60-4d31-9b3b-c05fe67f0342",
 CellID->559681177],
Cell[90906, 2418, 443, 11, 70, "Print",ExpressionUUID->"2a097b2c-33d4-4afe-8310-677216d9836d",
 CellID->561410260],
Cell[91352, 2431, 171, 2, 70, "Print",ExpressionUUID->"3c197651-bc66-4ae9-8dd9-07112daa4c2a",
 CellID->38034672],
Cell[91526, 2435, 329, 7, 70, "Print",ExpressionUUID->"977660c9-6e8d-4fd4-9092-a4d64498c1a7",
 CellID->1824682666],
Cell[91858, 2444, 172, 2, 70, "Print",ExpressionUUID->"27fd90de-01b1-48c8-94e1-ef348f711e2b",
 CellID->465280790],
Cell[92033, 2448, 492, 13, 70, "Print",ExpressionUUID->"6208cf52-6fce-4b34-a5b1-9b8e227189e7",
 CellID->730378219],
Cell[92528, 2463, 366, 7, 70, "Print",ExpressionUUID->"d493ff9e-5035-40ef-ad9b-7a6190a2af81",
 CellID->982628831],
Cell[92897, 2472, 444, 8, 70, "Print",ExpressionUUID->"8327a242-2223-4f4d-9564-aa89f4d7202b",
 CellID->569350811],
Cell[93344, 2482, 456, 8, 70, "Print",ExpressionUUID->"46a234ff-63f6-4061-bbf9-42505eec7e74",
 CellID->190183049],
Cell[93803, 2492, 470, 12, 70, "Print",ExpressionUUID->"f6513cb9-9168-44bf-b31c-e0b3c8ad6c3b",
 CellID->193860612],
Cell[94276, 2506, 367, 7, 70, "Print",ExpressionUUID->"2a0f2ada-1348-4aa4-837b-71d93e0fe1e7",
 CellID->1800756832],
Cell[94646, 2515, 445, 8, 70, "Print",ExpressionUUID->"f0732192-529d-432a-bc12-805d482d3767",
 CellID->1879969279],
Cell[95094, 2525, 456, 8, 70, "Print",ExpressionUUID->"840f5e7f-eff5-4d3e-bc60-fe362e1e5894",
 CellID->581047687],
Cell[95553, 2535, 419, 11, 70, "Print",ExpressionUUID->"98b6d9ec-6277-4700-9387-511ddbc1b097",
 CellID->1142761404],
Cell[95975, 2548, 366, 7, 70, "Print",ExpressionUUID->"104c9c59-787e-4931-b73a-d17d8110f30c",
 CellID->875805868],
Cell[96344, 2557, 444, 8, 70, "Print",ExpressionUUID->"db01e5a5-4e55-495c-a644-e01a0bcd9757",
 CellID->713985638],
Cell[96791, 2567, 455, 8, 70, "Print",ExpressionUUID->"c06b144f-2e48-48a5-8ae1-c9b5c8aedf6c",
 CellID->1800365418],
Cell[97249, 2577, 351, 8, 70, "Print",ExpressionUUID->"47d2f125-7fea-4052-a3a2-e9b294d3381d",
 CellID->41695881],
Cell[97603, 2587, 366, 7, 70, "Print",ExpressionUUID->"c8373598-532d-4838-a806-057b36d8ed57",
 CellID->769872112],
Cell[97972, 2596, 445, 8, 70, "Print",ExpressionUUID->"96231247-98ab-4c60-959c-80e92eead760",
 CellID->1270943132],
Cell[98420, 2606, 453, 8, 70, "Print",ExpressionUUID->"87ba1335-8f8e-4ab3-aa18-efc7df6c935e",
 CellID->1196241587],
Cell[98876, 2616, 487, 13, 70, "Print",ExpressionUUID->"bd177063-f207-43a5-ada3-e00274f51609",
 CellID->2105454643],
Cell[99366, 2631, 367, 7, 70, "Print",ExpressionUUID->"4f5aa81d-78fb-4e88-a8d8-25630c2dfd28",
 CellID->1154352113],
Cell[99736, 2640, 445, 8, 70, "Print",ExpressionUUID->"38e25ae9-4814-4341-a7c5-2655e7f4c863",
 CellID->1612147014],
Cell[100184, 2650, 456, 8, 70, "Print",ExpressionUUID->"2c53ae59-766d-453a-9042-529254b1abec",
 CellID->374074985],
Cell[100643, 2660, 501, 10, 70, "Print",ExpressionUUID->"28ec4230-6429-4a19-a3ef-d9402dd86778",
 CellID->1651386912],
Cell[101147, 2672, 602, 13, 70, "Print",ExpressionUUID->"285e4093-74d1-4f92-8e14-9c98befd5255",
 CellID->761321578],
Cell[101752, 2687, 509, 10, 70, "Print",ExpressionUUID->"53d05e93-db2a-4caf-9296-127c7acb0836",
 CellID->1507104477],
Cell[102264, 2699, 609, 13, 70, "Print",ExpressionUUID->"32e78755-4f55-4a6d-922a-3ebeb6633d8c",
 CellID->1410727793],
Cell[102876, 2714, 501, 10, 70, "Print",ExpressionUUID->"0edf0459-dcc7-4e7d-b9ca-452abb6a00e8",
 CellID->1725843585],
Cell[103380, 2726, 601, 13, 70, "Print",ExpressionUUID->"14be46bb-8367-448e-8e68-0ae485cfe9db",
 CellID->63268858],
Cell[103984, 2741, 509, 10, 70, "Print",ExpressionUUID->"4ecbe660-c691-49f7-bcf9-a30742d8c55c",
 CellID->1970408971],
Cell[104496, 2753, 610, 13, 70, "Print",ExpressionUUID->"69d37c06-605a-4fdd-93d1-33675e2836e5",
 CellID->139770198],
Cell[105109, 2768, 520, 10, 70, "Print",ExpressionUUID->"198f2443-084a-4fbc-9c6e-e40c621021a8",
 CellID->101303530],
Cell[105632, 2780, 623, 13, 70, "Print",ExpressionUUID->"f4196aaa-9d0a-4115-931e-1ba76ee53ab0",
 CellID->1647607989],
Cell[106258, 2795, 512, 10, 70, "Print",ExpressionUUID->"9ceb8dfc-7660-4528-9dda-7e359c76279a",
 CellID->605050988],
Cell[106773, 2807, 610, 13, 70, "Print",ExpressionUUID->"50838cef-072b-47e5-b964-dcfd5a380dd4",
 CellID->831681750],
Cell[107386, 2822, 518, 10, 70, "Print",ExpressionUUID->"c7fac7b5-3453-41b4-811f-52c6934b306a",
 CellID->482753172],
Cell[107907, 2834, 623, 13, 70, "Print",ExpressionUUID->"19fbcdec-3ba2-4875-a575-f6e598484918",
 CellID->1174401799],
Cell[108533, 2849, 162, 2, 70, "Print",ExpressionUUID->"fb1d034e-fd8b-4cd1-9495-d3d40916a36d",
 CellID->1021864799],
Cell[108698, 2853, 502, 10, 70, "Print",ExpressionUUID->"21eb3576-04b6-4a87-a23d-b0906b981b34",
 CellID->676613784],
Cell[109203, 2865, 598, 13, 70, "Print",ExpressionUUID->"fcd64aaa-04da-4e58-9557-f86ddbf251a9",
 CellID->827674983],
Cell[109804, 2880, 526, 10, 70, "Print",ExpressionUUID->"fdce85fb-b563-4968-9530-a17983f200d6",
 CellID->754350430],
Cell[110333, 2892, 629, 13, 70, "Print",ExpressionUUID->"d3294443-d77b-4a1c-9bf6-51c57b39f1d3",
 CellID->1257661472],
Cell[110965, 2907, 499, 10, 70, "Print",ExpressionUUID->"875aa6f1-1757-438d-8856-862e07e391f4",
 CellID->1970436388],
Cell[111467, 2919, 501, 10, 70, "Print",ExpressionUUID->"4acc9a4e-5b5c-46ca-afc6-6a0d6bc3f40e",
 CellID->1630156298],
Cell[111971, 2931, 603, 13, 70, "Print",ExpressionUUID->"0d339abf-2f26-454a-b038-390cc7cab11b",
 CellID->1971647110],
Cell[112577, 2946, 527, 10, 70, "Print",ExpressionUUID->"19e8cd36-8160-4db2-96b3-67c6ebf3b2ee",
 CellID->1623318158],
Cell[113107, 2958, 625, 13, 70, "Print",ExpressionUUID->"7f5f63f5-e447-4b4f-a56e-be81e9f005c9",
 CellID->1671852180]
}, Open  ]],
Cell[113747, 2974, 1009, 35, 70, "Output",ExpressionUUID->"5c2d6702-579b-4015-aa9b-9dda32bbe366",
 CellID->594035574]
}, Open  ]],
Cell[CellGroupData[{
Cell[114793, 3014, 344, 7, 70, "Input",ExpressionUUID->"058ce5b5-09a4-4fb9-84fd-35c5c95c6ba7",
 CellID->173070296],
Cell[CellGroupData[{
Cell[115162, 3025, 376, 9, 70, "Print",ExpressionUUID->"3f4ce4df-b5a6-467d-9995-e79c78b415c5",
 CellID->746777642],
Cell[115541, 3036, 172, 2, 70, "Print",ExpressionUUID->"22af1331-7674-4b7b-8baa-e794cba6c0d6",
 CellID->720610119],
Cell[115716, 3040, 457, 12, 70, "Print",ExpressionUUID->"0ae5ca0c-7f28-43f7-b3e7-de37be552ec2",
 CellID->552006570],
Cell[116176, 3054, 173, 2, 70, "Print",ExpressionUUID->"29e5e10e-63a4-443f-90cd-f9c283a0b6bf",
 CellID->1901129755],
Cell[116352, 3058, 494, 13, 70, "Print",ExpressionUUID->"f5014cff-2a8f-4d81-b7cf-ce6759022575",
 CellID->185273485],
Cell[116849, 3073, 172, 2, 70, "Print",ExpressionUUID->"af4700ee-0e07-4e29-9abf-e5c642138196",
 CellID->926081555],
Cell[117024, 3077, 466, 12, 70, "Print",ExpressionUUID->"9c2127e1-84a4-45ee-899b-770009a13a3f",
 CellID->1405033019],
Cell[117493, 3091, 172, 2, 70, "Print",ExpressionUUID->"923af294-827a-42b2-a18e-a92e09f4dec5",
 CellID->946595063],
Cell[117668, 3095, 443, 11, 70, "Print",ExpressionUUID->"704ee7eb-3fcd-4a7d-a0db-d070014a9e1b",
 CellID->285702384],
Cell[118114, 3108, 172, 2, 70, "Print",ExpressionUUID->"809cf22c-37d5-494c-bf5e-153b8e7ba801",
 CellID->668277165],
Cell[118289, 3112, 328, 7, 70, "Print",ExpressionUUID->"505a982c-00d7-4d96-b7da-73a67e432401",
 CellID->524955001],
Cell[118620, 3121, 172, 2, 70, "Print",ExpressionUUID->"15b5ba63-6b58-4fca-b46f-0c00949e021f",
 CellID->348971243],
Cell[118795, 3125, 492, 13, 70, "Print",ExpressionUUID->"75a18830-082f-4908-9900-282c0d273f0b",
 CellID->491202488],
Cell[119290, 3140, 172, 2, 70, "Print",ExpressionUUID->"74d180ae-1462-4cda-9382-a24ec2513579",
 CellID->664725199],
Cell[119465, 3144, 470, 12, 70, "Print",ExpressionUUID->"611256cc-9c97-434d-9e71-d8231a67c7f3",
 CellID->450274773],
Cell[119938, 3158, 173, 2, 70, "Print",ExpressionUUID->"9a9105de-eae7-4a76-bb28-64e2aee5d6cb",
 CellID->2138810477],
Cell[120114, 3162, 419, 11, 70, "Print",ExpressionUUID->"1c641a9a-ca7f-4726-b1d7-2f81db703c1c",
 CellID->1269776187],
Cell[120536, 3175, 173, 2, 70, "Print",ExpressionUUID->"431f93ca-afe3-4dbd-9e98-313e56cec740",
 CellID->1281956523],
Cell[120712, 3179, 352, 8, 70, "Print",ExpressionUUID->"6a9d407b-df97-41fb-bbf6-be20689aad8e",
 CellID->474080002],
Cell[121067, 3189, 172, 2, 70, "Print",ExpressionUUID->"0e81b369-64d7-427c-ab86-7395a66da356",
 CellID->296694338],
Cell[121242, 3193, 486, 13, 70, "Print",ExpressionUUID->"ddb1b537-970d-4825-8434-7f21371f84c0",
 CellID->156337674],
Cell[121731, 3208, 173, 2, 70, "Print",ExpressionUUID->"0888de53-8c2e-49d5-95a1-b2770d1a260f",
 CellID->1150693786],
Cell[121907, 3212, 499, 10, 70, "Print",ExpressionUUID->"a8a2ee7b-c1c8-4c98-94a3-dc4218960cf4",
 CellID->1124369322],
Cell[122409, 3224, 602, 13, 70, "Print",ExpressionUUID->"16fde88a-7268-4654-a9a7-6a69d6a3fd05",
 CellID->910688104],
Cell[123014, 3239, 508, 10, 70, "Print",ExpressionUUID->"0b64d893-5c3e-400a-b2d2-4d1fb1bcf953",
 CellID->260871610],
Cell[123525, 3251, 608, 13, 70, "Print",ExpressionUUID->"e1cb241e-e54b-4fff-a71c-c8a52418c894",
 CellID->947322062],
Cell[124136, 3266, 506, 10, 70, "Print",ExpressionUUID->"51ca7242-8069-45df-ae32-a266e567f3a1",
 CellID->393360755],
Cell[124645, 3278, 605, 13, 70, "Print",ExpressionUUID->"565f5891-e72c-4c41-b12c-b3e2f7ddab43",
 CellID->85035072],
Cell[125253, 3293, 514, 10, 70, "Print",ExpressionUUID->"fca35861-f319-423f-9258-32bd7db576f2",
 CellID->423156572],
Cell[125770, 3305, 617, 13, 70, "Print",ExpressionUUID->"0b586e04-bc66-4e38-b10a-bc4715551774",
 CellID->2065212935],
Cell[126390, 3320, 510, 10, 70, "Print",ExpressionUUID->"1494727e-2112-4354-a7f7-7d1f9a5d5a3c",
 CellID->679070647],
Cell[126903, 3332, 609, 13, 70, "Print",ExpressionUUID->"55b41350-c4ac-4cb8-b3d3-084992f8f3f2",
 CellID->1169934214],
Cell[127515, 3347, 518, 10, 70, "Print",ExpressionUUID->"6bfda3a0-a8b4-4c9d-b87f-e0644dc42822",
 CellID->638339406],
Cell[128036, 3359, 621, 13, 70, "Print",ExpressionUUID->"54dc68ee-80f0-4a66-b3be-d7ef6119e107",
 CellID->1231077217],
Cell[128660, 3374, 510, 10, 70, "Print",ExpressionUUID->"48d1c7ea-9026-40d7-99e8-c19e9d49d311",
 CellID->923580321],
Cell[129173, 3386, 608, 13, 70, "Print",ExpressionUUID->"8ab1cf07-4ba9-4862-8c85-7d13e9cc9015",
 CellID->823612891],
Cell[129784, 3401, 514, 10, 70, "Print",ExpressionUUID->"16aa9354-b8d9-4134-81d3-71ca615f31bc",
 CellID->9675124],
Cell[130301, 3413, 618, 13, 70, "Print",ExpressionUUID->"de192018-466a-492a-bf27-541198c37aaf",
 CellID->181129692],
Cell[130922, 3428, 162, 2, 70, "Print",ExpressionUUID->"7ce01672-5b8d-4a5c-a91b-c8709e941115",
 CellID->1770207955],
Cell[131087, 3432, 504, 10, 70, "Print",ExpressionUUID->"e7e8a88c-3d85-4957-8f97-941c7c93408c",
 CellID->295377508],
Cell[131594, 3444, 604, 13, 70, "Print",ExpressionUUID->"7d2ba331-20b9-4a81-a099-cc9740673b75",
 CellID->849406857],
Cell[132201, 3459, 498, 10, 70, "Print",ExpressionUUID->"9167b50d-d2f1-4fa6-9394-2541ef524791",
 CellID->147679308],
Cell[132702, 3471, 628, 13, 70, "Print",ExpressionUUID->"599fab5d-d18b-4fb6-855b-6b9fc582a90f",
 CellID->644348751],
Cell[133333, 3486, 523, 10, 70, "Print",ExpressionUUID->"329c18ae-971f-4a98-a7fc-ea031a30ac09",
 CellID->1340609345],
Cell[133859, 3498, 622, 13, 70, "Print",ExpressionUUID->"37d4cc62-3b03-4092-8790-fa4cab909d8f",
 CellID->812404507]
}, Open  ]],
Cell[134496, 3514, 1210, 40, 70, "Output",ExpressionUUID->"2c40e989-501e-4bea-8a93-580bf005b59a",
 CellID->1094623525]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, Closed]]]],
Cell[CellGroupData[{
Cell[135970, 3565, 1394, 36, 24, "ExampleSection",ExpressionUUID->"5edb2320-4eb6-4ce1-89f9-1cf2372daa4e"],
Cell[CellGroupData[{
Cell[137389, 3605, 1415, 36, 70, "ExampleSubsection",ExpressionUUID->"bb880758-946c-4e54-bad3-94ef77348f2b"],
Cell[CellGroupData[{
Cell[138829, 3645, 1413, 37, 70, "ExampleSubsubsection",ExpressionUUID->"eeeab065-e1c7-47b4-b893-5c7ac78267a3",
 CellID->101096468],
Cell[140245, 3684, 196, 4, 70, "Input",ExpressionUUID->"6c301771-0f6f-4778-88e5-fbee65b4fe61",
 CellID->1331936175],
Cell[140444, 3690, 369, 9, 70, "Input",ExpressionUUID->"97364013-e3a1-4526-8daa-cb72f0379943",
 CellID->2082180694],
Cell[140816, 3701, 252, 4, 70, "ExampleText",ExpressionUUID->"4b77643d-66e9-4b40-a476-60606a1c6cea",
 CellID->56015443],
Cell[141071, 3707, 2333, 74, 70, "Input",ExpressionUUID->"d44cd67d-cb72-4a61-a10b-370c08c49279",
 CellID->55503591],
Cell[143407, 3783, 1251, 38, 70, "Input",ExpressionUUID->"c8112747-0ab5-4f3e-a805-b01482780540",
 CellID->153306904],
Cell[144661, 3823, 223, 4, 70, "ExampleText",ExpressionUUID->"9a3243d6-5987-4e44-a6fd-d5110a281a27",
 CellID->353703688],
Cell[CellGroupData[{
Cell[144909, 3831, 405, 8, 70, "Input",ExpressionUUID->"3e5f52c7-6fbe-4f8f-b11b-a97b3a873ccd",
 CellID->348469371],
Cell[CellGroupData[{
Cell[145339, 3843, 377, 9, 70, "Print",ExpressionUUID->"c4400149-1fc6-4645-9e01-fefcd6386fdf",
 CellID->2010397025],
Cell[145719, 3854, 172, 2, 70, "Print",ExpressionUUID->"0c37a350-2b26-4a23-a403-6594813718ee",
 CellID->297634757],
Cell[145894, 3858, 458, 12, 70, "Print",ExpressionUUID->"e2dd42b5-e644-4f52-b2e4-2d79ad107400",
 CellID->1143389371],
Cell[146355, 3872, 173, 2, 70, "Print",ExpressionUUID->"5c68e22b-366f-4fd0-b38b-d366296d6cd5",
 CellID->1085763224],
Cell[146531, 3876, 495, 13, 70, "Print",ExpressionUUID->"bd48e5e6-b5a1-4871-a67d-53772614b107",
 CellID->1852957886],
Cell[147029, 3891, 367, 7, 70, "Print",ExpressionUUID->"08196071-3c93-48ac-accf-d5758b052b90",
 CellID->1835473857],
Cell[147399, 3900, 444, 8, 70, "Print",ExpressionUUID->"1d3d7999-a5a1-45f2-ab8b-6fc9750f06d6",
 CellID->453923065],
Cell[147846, 3910, 466, 12, 70, "Print",ExpressionUUID->"5080226f-3f45-4b64-b156-05d80c6bdf3d",
 CellID->1192479202],
Cell[148315, 3924, 173, 2, 70, "Print",ExpressionUUID->"09172591-8a11-4a3d-85f0-a7e820a4b381",
 CellID->1619816650],
Cell[148491, 3928, 443, 11, 70, "Print",ExpressionUUID->"650bdd3e-17b1-4f80-bc64-18cb15a0b09a",
 CellID->386824419],
Cell[148937, 3941, 172, 2, 70, "Print",ExpressionUUID->"ca70413d-d293-42ab-a91b-b9397cabf1c4",
 CellID->484181593],
Cell[149112, 3945, 328, 7, 70, "Print",ExpressionUUID->"e2e78551-d17e-434a-b97b-cffaa7b52c91",
 CellID->515767878],
Cell[149443, 3954, 173, 2, 70, "Print",ExpressionUUID->"acc172ee-c5d6-4ed5-904a-d4b7774a01ea",
 CellID->2125741950],
Cell[149619, 3958, 490, 13, 70, "Print",ExpressionUUID->"5b8c9e41-2114-414d-91fd-6e82e33d6e94",
 CellID->7275368],
Cell[150112, 3973, 367, 7, 70, "Print",ExpressionUUID->"5d7f9966-4d16-4f3f-8e83-f9324c99fa7d",
 CellID->1944636829],
Cell[150482, 3982, 444, 8, 70, "Print",ExpressionUUID->"820891cb-0f71-43d6-aa2d-eb2d79312885",
 CellID->378918501],
Cell[150929, 3992, 456, 8, 70, "Print",ExpressionUUID->"91201b4d-bf98-46c3-a5e2-bcd1f1a83a36",
 CellID->886129850],
Cell[151388, 4002, 470, 12, 70, "Print",ExpressionUUID->"87a726eb-d977-47a1-96e7-b206328d7cd5",
 CellID->374660664],
Cell[151861, 4016, 367, 7, 70, "Print",ExpressionUUID->"417628ad-2e8f-4d82-a934-5d80926d3f67",
 CellID->1849676625],
Cell[152231, 4025, 445, 8, 70, "Print",ExpressionUUID->"6c5b9fb7-2d04-4bc4-a217-01a11b6a0337",
 CellID->1920583453],
Cell[152679, 4035, 456, 8, 70, "Print",ExpressionUUID->"d0ae2267-815a-402e-af10-1963dd80806d",
 CellID->494167433],
Cell[153138, 4045, 418, 11, 70, "Print",ExpressionUUID->"3fc70c9b-7a7e-4053-be1a-0b61afed199b",
 CellID->180600452],
Cell[153559, 4058, 367, 7, 70, "Print",ExpressionUUID->"cd8f2b24-907b-4691-b8bd-7922e8b77573",
 CellID->1386309100],
Cell[153929, 4067, 443, 8, 70, "Print",ExpressionUUID->"dc81c5b2-b46b-46a1-8723-0d9518ff0eea",
 CellID->73402775],
Cell[154375, 4077, 452, 8, 70, "Print",ExpressionUUID->"5cfb56c5-a330-44b1-b482-ecdde66f9c59",
 CellID->345727925],
Cell[154830, 4087, 352, 8, 70, "Print",ExpressionUUID->"07bf63a8-a3fb-43b4-8ebc-d6a2ca7b4a29",
 CellID->453241005],
Cell[155185, 4097, 367, 7, 70, "Print",ExpressionUUID->"589fafd1-8eea-4ad8-8335-80350a4fe4c7",
 CellID->1898189745],
Cell[155555, 4106, 445, 8, 70, "Print",ExpressionUUID->"a2701938-e440-4875-b86b-f8bed694cc92",
 CellID->1428652612],
Cell[156003, 4116, 449, 8, 70, "Print",ExpressionUUID->"06054fd2-96dd-4eef-9648-71cea0c18c4a",
 CellID->44959490],
Cell[156455, 4126, 486, 13, 70, "Print",ExpressionUUID->"87bb05ea-7bde-49fb-99a1-c15fe3985da4",
 CellID->349690290],
Cell[156944, 4141, 367, 7, 70, "Print",ExpressionUUID->"236635ee-bdad-483e-9ca9-b1cb02cb3464",
 CellID->1291565989],
Cell[157314, 4150, 444, 8, 70, "Print",ExpressionUUID->"eeb7f104-01e3-4edb-8d53-d90c108510d7",
 CellID->342594247],
Cell[157761, 4160, 457, 8, 70, "Print",ExpressionUUID->"8dd83348-3f40-4119-87e4-86c2a85c1d48",
 CellID->1493079661],
Cell[158221, 4170, 500, 10, 70, "Print",ExpressionUUID->"cfa21698-b51d-47f8-9c37-930a03ed8953",
 CellID->229845566],
Cell[158724, 4182, 601, 13, 70, "Print",ExpressionUUID->"b7eef08f-a60e-4a3b-b809-382127eff0c0",
 CellID->48068486],
Cell[159328, 4197, 509, 10, 70, "Print",ExpressionUUID->"03a16fae-3744-496c-887c-bddb6c2ddd7d",
 CellID->1181069870],
Cell[159840, 4209, 609, 13, 70, "Print",ExpressionUUID->"4137810d-76b3-405d-9fa0-fb85f55aa3c6",
 CellID->1035323741],
Cell[160452, 4224, 502, 10, 70, "Print",ExpressionUUID->"ea34be33-954e-4d96-b14f-f790cdb20bea",
 CellID->501991551],
Cell[160957, 4236, 602, 13, 70, "Print",ExpressionUUID->"b864d2ad-3fc9-45c7-84e2-df2c779db497",
 CellID->226065424],
Cell[161562, 4251, 510, 10, 70, "Print",ExpressionUUID->"7768b1d0-b451-4634-b9ba-89f9d353299a",
 CellID->507656743],
Cell[162075, 4263, 610, 13, 70, "Print",ExpressionUUID->"f8cd032e-92f7-414d-ac2d-c7b0be9a18a3",
 CellID->888815971],
Cell[162688, 4278, 520, 10, 70, "Print",ExpressionUUID->"a3f2e520-bb0a-4bb1-929f-b376c33cd2d1",
 CellID->710247017],
Cell[163211, 4290, 623, 13, 70, "Print",ExpressionUUID->"68ca771b-d8c1-469f-93a1-e3a4b23cbfd0",
 CellID->1023424622],
Cell[163837, 4305, 506, 10, 70, "Print",ExpressionUUID->"b109ae88-b33b-4409-97ea-a17dd5be7f33",
 CellID->867074273],
Cell[164346, 4317, 610, 13, 70, "Print",ExpressionUUID->"bd80f311-d920-44c6-9fe6-5578b367c645",
 CellID->717522386],
Cell[164959, 4332, 520, 10, 70, "Print",ExpressionUUID->"efe24b92-8cbf-4ee9-9d9b-80fa0bd027a7",
 CellID->820577803],
Cell[165482, 4344, 619, 13, 70, "Print",ExpressionUUID->"b5997426-0246-4775-a27f-d2620d64e48d",
 CellID->1245992774],
Cell[166104, 4359, 161, 2, 70, "Print",ExpressionUUID->"c457d5fb-dffc-4972-aa09-33c16b9eae9c",
 CellID->1603652236],
Cell[166268, 4363, 505, 10, 70, "Print",ExpressionUUID->"81edb7b6-5122-4a09-ae61-096980bac399",
 CellID->1195238467],
Cell[166776, 4375, 604, 13, 70, "Print",ExpressionUUID->"946584a0-6f1c-4099-bf14-80a3c3c8b887",
 CellID->948185752],
Cell[167383, 4390, 505, 10, 70, "Print",ExpressionUUID->"c2647b6f-5ee4-4336-9160-cbefa683085c",
 CellID->1376752041],
Cell[167891, 4402, 607, 13, 70, "Print",ExpressionUUID->"cd6a2b2a-5042-47a4-96dc-631573f5340d",
 CellID->1689405900],
Cell[168501, 4417, 527, 10, 70, "Print",ExpressionUUID->"a8470701-4388-41b5-87ec-ace793118594",
 CellID->1128786204],
Cell[169031, 4429, 624, 13, 70, "Print",ExpressionUUID->"aee99cec-3092-4ae2-a799-ffa829776a38",
 CellID->615577493],
Cell[169658, 4444, 527, 10, 70, "Print",ExpressionUUID->"cd201646-d57b-469b-9588-0d23ec2168cb",
 CellID->1762808676],
Cell[170188, 4456, 631, 13, 70, "Print",ExpressionUUID->"e8ae603f-d2fd-47c8-9ef4-63e20f062a88",
 CellID->1474514129],
Cell[170822, 4471, 533, 10, 70, "Print",ExpressionUUID->"500bca8a-ba17-45c2-a445-40578e027b33",
 CellID->1068818499],
Cell[171358, 4483, 633, 13, 70, "Print",ExpressionUUID->"42f65557-50d7-4956-ba38-6da8fc210d05",
 CellID->1513514773]
}, Open  ]],
Cell[172006, 4499, 3462, 116, 70, "Output",ExpressionUUID->"750ac0a5-450f-48a5-aacb-af086e99f3a0",
 CellID->755683093]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsubsection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[175623, 4623, 1412, 37, 70, "ExampleSubsubsection",ExpressionUUID->"41da11e5-eba6-49f4-9425-70eab266c7f3",
 CellID->17838787],
Cell[177038, 4662, 454, 8, 70, "ExampleText",ExpressionUUID->"b314aeca-ae50-4d4f-98a6-02c7a703481b",
 CellID->487371356],
Cell[177495, 4672, 237, 5, 70, "Input",ExpressionUUID->"851e2fcb-f338-44eb-ad5a-830ebd737084",
 CellID->132427965],
Cell[177735, 4679, 182, 3, 70, "ExampleText",ExpressionUUID->"865928af-e172-4575-b554-e72c14b0bc16",
 CellID->461760098],
Cell[177920, 4684, 1136, 36, 70, "Input",ExpressionUUID->"76541119-2d72-4d87-ac7b-9c05634b4518",
 CellID->49066715],
Cell[179059, 4722, 189, 5, 70, "ExampleText",ExpressionUUID->"b093a3d7-7972-4941-b7e4-28451c34f517",
 CellID->459508800],
Cell[CellGroupData[{
Cell[179273, 4731, 397, 8, 70, "Input",ExpressionUUID->"af4709a3-330a-4f2c-84ea-8cbcb586be40",
 CellID->150318374],
Cell[CellGroupData[{
Cell[179695, 4743, 377, 9, 70, "Print",ExpressionUUID->"edfe89bc-611d-4b60-a55f-bd7507e1525c",
 CellID->1113777989],
Cell[180075, 4754, 173, 2, 70, "Print",ExpressionUUID->"86e3f132-19c7-44d5-9626-72ff86e74684",
 CellID->1863205064],
Cell[180251, 4758, 458, 12, 70, "Print",ExpressionUUID->"0f261d15-0cdd-48d1-bdbc-517cb20d3d79",
 CellID->2047249083],
Cell[180712, 4772, 173, 2, 70, "Print",ExpressionUUID->"ae1ad00c-a5c6-4aec-90be-009776f7fb47",
 CellID->1456372237],
Cell[180888, 4776, 495, 13, 70, "Print",ExpressionUUID->"f5406df7-4de1-4820-9039-e6f364bdaddb",
 CellID->1208801077],
Cell[181386, 4791, 172, 2, 70, "Print",ExpressionUUID->"2aed1549-8c03-4cd0-8f6e-b171df751657",
 CellID->129611001],
Cell[181561, 4795, 466, 12, 70, "Print",ExpressionUUID->"68497844-d48c-4fbb-93e5-a2aecffac64b",
 CellID->1504440723],
Cell[182030, 4809, 172, 2, 70, "Print",ExpressionUUID->"e5f9627c-b652-4db1-92f4-abf8d27019fc",
 CellID->242387300],
Cell[182205, 4813, 444, 11, 70, "Print",ExpressionUUID->"66c45e68-9383-484e-9680-a9bc4e7d9a2c",
 CellID->1164934742],
Cell[182652, 4826, 173, 2, 70, "Print",ExpressionUUID->"6e67593f-64ec-43db-806a-0fca039a79ad",
 CellID->2006432274],
Cell[182828, 4830, 328, 7, 70, "Print",ExpressionUUID->"4d678b38-7cd3-465a-8535-b725f98347fb",
 CellID->468452724],
Cell[183159, 4839, 173, 2, 70, "Print",ExpressionUUID->"695f67ef-925a-4869-8c78-73524a7346a2",
 CellID->1672591485],
Cell[183335, 4843, 492, 13, 70, "Print",ExpressionUUID->"35d67c74-ab83-454b-910a-d0cb71bf5f60",
 CellID->747764597],
Cell[183830, 4858, 173, 2, 70, "Print",ExpressionUUID->"bed23133-656d-4537-962c-c5453d8e22e5",
 CellID->1178699742],
Cell[184006, 4862, 470, 12, 70, "Print",ExpressionUUID->"2682cc90-06a5-4306-9a2c-140c0768c5ed",
 CellID->548532459],
Cell[184479, 4876, 173, 2, 70, "Print",ExpressionUUID->"cad40430-dcff-485f-9389-fda7e84ef775",
 CellID->1614838871],
Cell[184655, 4880, 419, 11, 70, "Print",ExpressionUUID->"a8c1f329-171c-4ff1-a216-763096c15e2d",
 CellID->1896222128],
Cell[185077, 4893, 173, 2, 70, "Print",ExpressionUUID->"70c45a5c-96e3-441d-ad52-c27cf55e3052",
 CellID->1369110263],
Cell[185253, 4897, 352, 8, 70, "Print",ExpressionUUID->"2e60b9df-5e66-42f6-bcd5-2935664df531",
 CellID->713347997],
Cell[185608, 4907, 173, 2, 70, "Print",ExpressionUUID->"9e572405-89ff-4c7d-9018-17005b4463b2",
 CellID->1352390716],
Cell[185784, 4911, 486, 13, 70, "Print",ExpressionUUID->"0c69cf7e-b012-41da-9ada-b6d7a1b1d942",
 CellID->416865082],
Cell[186273, 4926, 173, 2, 70, "Print",ExpressionUUID->"d0ff1e4e-cefc-4792-93c3-0c42cbfe10b8",
 CellID->1661533749],
Cell[186449, 4930, 500, 10, 70, "Print",ExpressionUUID->"4014b8a3-d813-4e06-821c-eb30d707d32a",
 CellID->581659110],
Cell[186952, 4942, 605, 13, 70, "Print",ExpressionUUID->"8b070bf5-9223-42db-9881-c5b018a9e90b",
 CellID->2106270983],
Cell[187560, 4957, 506, 10, 70, "Print",ExpressionUUID->"0fc85277-41ae-4e01-adc3-71a8d783ff82",
 CellID->642836306],
Cell[188069, 4969, 609, 13, 70, "Print",ExpressionUUID->"ae5c7fc0-dd2c-4982-86e1-446037ce24b5",
 CellID->1197236603],
Cell[188681, 4984, 507, 10, 70, "Print",ExpressionUUID->"bd21f42e-df00-4fa8-9931-ff9e8faf9bbb",
 CellID->1721596011],
Cell[189191, 4996, 609, 13, 70, "Print",ExpressionUUID->"7435bc7f-c559-4d29-baa0-ee5d51d2a40b",
 CellID->2117350435],
Cell[189803, 5011, 516, 10, 70, "Print",ExpressionUUID->"de262bae-8ec3-41ae-bae2-a69ed2960210",
 CellID->118571454],
Cell[190322, 5023, 617, 13, 70, "Print",ExpressionUUID->"85a7cacc-4a2a-4d7a-8ece-d0c818d033d9",
 CellID->1087627136],
Cell[190942, 5038, 510, 10, 70, "Print",ExpressionUUID->"d0653e8d-bf57-4d33-95bf-409ec3b2496f",
 CellID->725549881],
Cell[191455, 5050, 611, 13, 70, "Print",ExpressionUUID->"b7f8d4da-c54f-4444-945e-5afac2988d37",
 CellID->1232349444],
Cell[192069, 5065, 518, 10, 70, "Print",ExpressionUUID->"2e97886b-9e98-4ba6-bf25-77291d6373ab",
 CellID->803348552],
Cell[192590, 5077, 620, 13, 70, "Print",ExpressionUUID->"568059c9-9eeb-4f96-b2da-b45710945e73",
 CellID->625315316],
Cell[193213, 5092, 510, 10, 70, "Print",ExpressionUUID->"495c603d-bfec-4d7c-8a42-2c9b3ce08d8e",
 CellID->541238033],
Cell[193726, 5104, 609, 13, 70, "Print",ExpressionUUID->"10413caa-ffbf-4a89-9e20-cd92f73aaf97",
 CellID->2012149630],
Cell[194338, 5119, 520, 10, 70, "Print",ExpressionUUID->"a74ee90f-e43a-46c3-af7a-6239b41f69f9",
 CellID->754926317],
Cell[194861, 5131, 619, 13, 70, "Print",ExpressionUUID->"66f34f07-79bf-448c-b966-922b17342631",
 CellID->2045678756],
Cell[195483, 5146, 160, 2, 70, "Print",ExpressionUUID->"194201b1-6686-4603-9db0-5f387c72a61d",
 CellID->107053282],
Cell[195646, 5150, 503, 10, 70, "Print",ExpressionUUID->"690fdeb6-b884-4570-ada8-d54b2eeb52ef",
 CellID->1919861059],
Cell[196152, 5162, 607, 13, 70, "Print",ExpressionUUID->"9942b75f-06e1-497e-bba6-0a13aee1a3cc",
 CellID->1904627382],
Cell[196762, 5177, 500, 10, 70, "Print",ExpressionUUID->"a156813d-3f49-43e9-8cc1-c39d4e4807ca",
 CellID->575506006],
Cell[197265, 5189, 601, 13, 70, "Print",ExpressionUUID->"7e7fca27-6518-41a4-be73-c35af08b3532",
 CellID->1444968896],
Cell[197869, 5204, 504, 10, 70, "Print",ExpressionUUID->"54104eb9-e607-489b-b57d-d7e72961dec1",
 CellID->504908332],
Cell[198376, 5216, 607, 13, 70, "Print",ExpressionUUID->"ad0639e0-c932-4f59-99b4-355af41bfda4",
 CellID->1754205748],
Cell[198986, 5231, 505, 10, 70, "Print",ExpressionUUID->"ff23abcd-8fdb-4994-a973-218a707d5642",
 CellID->1993501356],
Cell[199494, 5243, 607, 13, 70, "Print",ExpressionUUID->"cb41a539-877a-45e2-b3aa-e08612538b1a",
 CellID->2119747203],
Cell[200104, 5258, 509, 10, 70, "Print",ExpressionUUID->"2ae40399-e87b-4f7b-90f2-b10245ce11c2",
 CellID->1502944228],
Cell[200616, 5270, 609, 13, 70, "Print",ExpressionUUID->"15883c6b-dfb2-4c0e-ba5a-da419aab503b",
 CellID->1215127971],
Cell[201228, 5285, 506, 10, 70, "Print",ExpressionUUID->"11e8d97c-c527-4908-a701-c99009c02644",
 CellID->685611552],
Cell[201737, 5297, 608, 13, 70, "Print",ExpressionUUID->"dc3c4253-443e-40f8-9070-c0e4e0b1e76b",
 CellID->707851297],
Cell[202348, 5312, 497, 10, 70, "Print",ExpressionUUID->"e08ccb33-1299-4d94-8f65-6baaf90fd661",
 CellID->1631993053],
Cell[202848, 5324, 602, 13, 70, "Print",ExpressionUUID->"cbf76b7e-7320-4f8d-bb1e-c3c56c557c2b",
 CellID->199661654],
Cell[203453, 5339, 493, 10, 70, "Print",ExpressionUUID->"c969f04e-2e34-43d7-96e8-a57c381a96b3",
 CellID->1289510407],
Cell[203949, 5351, 595, 13, 70, "Print",ExpressionUUID->"ffce3394-20b5-424e-b4c7-ec7a8929828f",
 CellID->1590780388],
Cell[204547, 5366, 488, 10, 70, "Print",ExpressionUUID->"68f94cf7-3847-4601-a844-632eba40495f",
 CellID->842497960],
Cell[205038, 5378, 584, 12, 70, "Print",ExpressionUUID->"1acb76f2-97db-480f-9750-25aa6be71e56",
 CellID->339263362],
Cell[205625, 5392, 491, 10, 70, "Print",ExpressionUUID->"8288f67b-096b-4aae-884c-0c96e8c48f66",
 CellID->1164892751],
Cell[206119, 5404, 586, 12, 70, "Print",ExpressionUUID->"40951cec-d7c4-4d06-9169-fe34f3ce865e",
 CellID->812364747],
Cell[206708, 5418, 526, 10, 70, "Print",ExpressionUUID->"294631cd-bdd1-4be1-a50f-bb2a6552adc9",
 CellID->457834817],
Cell[207237, 5430, 630, 13, 70, "Print",ExpressionUUID->"a5e36a21-4b34-4d4d-b454-0e389d0c6e8b",
 CellID->105036240],
Cell[207870, 5445, 531, 10, 70, "Print",ExpressionUUID->"d2b7b87a-6dc7-42cb-946b-810f48de6ba7",
 CellID->1537914628],
Cell[208404, 5457, 631, 13, 70, "Print",ExpressionUUID->"f1944cef-0024-435b-86ff-33d588e91b49",
 CellID->1690184261]
}, Open  ]],
Cell[209050, 5473, 2487, 81, 70, "Output",ExpressionUUID->"6d65c1f7-ffe5-4d57-bdee-1b5c3c381a2a",
 CellID->908384792]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsubsection", "1"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed]]]],
Cell[CellGroupData[{
Cell[211807, 5565, 1405, 36, 70, "ExampleSubsection",ExpressionUUID->"7f032146-221a-40d2-85e4-4e6402d4223a"],
Cell[213215, 5603, 414, 9, 70, "ExampleText",ExpressionUUID->"69f5d37c-91bb-4883-b3dd-df2ad1c8b294",
 CellID->8693097],
Cell[213632, 5614, 236, 5, 70, "Input",ExpressionUUID->"84b8d7b1-5801-4df1-ad6d-8df638105cd9",
 CellID->111291632],
Cell[CellGroupData[{
Cell[213893, 5623, 394, 8, 70, "Input",ExpressionUUID->"d3b6e71c-e615-4424-908c-62f3c9a20a97",
 CellID->599055540],
Cell[CellGroupData[{
Cell[214312, 5635, 375, 9, 70, "Print",ExpressionUUID->"162ab8c9-130c-491f-854b-2bc71d966dd0",
 CellID->15746296],
Cell[214690, 5646, 171, 2, 70, "Print",ExpressionUUID->"7f931a61-bb95-41b5-9e0d-12855a78775d",
 CellID->83938646],
Cell[214864, 5650, 457, 12, 70, "Print",ExpressionUUID->"9047c501-595d-43dd-a5a9-583656abb586",
 CellID->773050774],
Cell[215324, 5664, 172, 2, 70, "Print",ExpressionUUID->"b6458f8b-90a3-4878-ac2e-6987c70f7b46",
 CellID->770672613],
Cell[215499, 5668, 495, 13, 70, "Print",ExpressionUUID->"7c374803-0015-4d7c-b693-ee941c4ef295",
 CellID->2129617402],
Cell[215997, 5683, 172, 2, 70, "Print",ExpressionUUID->"bb931c6c-6af8-44b6-ba03-4845a868c693",
 CellID->880104056],
Cell[216172, 5687, 465, 12, 70, "Print",ExpressionUUID->"fd75ecf2-db42-4294-a7c9-f13980d6fc2f",
 CellID->543050024],
Cell[216640, 5701, 173, 2, 70, "Print",ExpressionUUID->"dc240e75-b469-49d6-be4d-7c823586c7c4",
 CellID->1886761136],
Cell[216816, 5705, 444, 11, 70, "Print",ExpressionUUID->"732928f3-27f2-4ac3-b959-51c9b058e27a",
 CellID->1455610063],
Cell[217263, 5718, 173, 2, 70, "Print",ExpressionUUID->"7e6ccf0f-14fb-4d99-bc75-abe46d68df71",
 CellID->1988018921],
Cell[217439, 5722, 328, 7, 70, "Print",ExpressionUUID->"0cab9165-b627-48b7-b033-642c9c431e2c",
 CellID->244185820],
Cell[217770, 5731, 173, 2, 70, "Print",ExpressionUUID->"90fc2d77-750e-4603-8456-a7b8863d1d6b",
 CellID->1062332163],
Cell[217946, 5735, 493, 13, 70, "Print",ExpressionUUID->"cf4a6b59-6715-41d6-bf05-0f036ea33b0d",
 CellID->1834036629],
Cell[218442, 5750, 172, 2, 70, "Print",ExpressionUUID->"a5cb415f-9b92-49d5-a553-32a8d09d022c",
 CellID->216449375],
Cell[218617, 5754, 470, 12, 70, "Print",ExpressionUUID->"a9a78d23-448c-45b4-92d1-dd5f12450e91",
 CellID->417792744],
Cell[219090, 5768, 172, 2, 70, "Print",ExpressionUUID->"7f3d9d41-4b39-4f79-9683-59d904b6545b",
 CellID->901680952],
Cell[219265, 5772, 418, 11, 70, "Print",ExpressionUUID->"7adba8c2-906c-45bf-b75b-7f5393fc9e62",
 CellID->902060928],
Cell[219686, 5785, 173, 2, 70, "Print",ExpressionUUID->"0cc3ec8f-918f-4703-9ead-0b4bfa11fc20",
 CellID->1125644041],
Cell[219862, 5789, 352, 8, 70, "Print",ExpressionUUID->"9c4567fc-7ced-4c6f-a998-7ebf03795179",
 CellID->386190357],
Cell[220217, 5799, 173, 2, 70, "Print",ExpressionUUID->"ccee7654-6815-45a3-b366-37d8e2cc1e21",
 CellID->1101722582],
Cell[220393, 5803, 486, 13, 70, "Print",ExpressionUUID->"802e535b-d2d4-4587-8e7a-1bb84531cd7e",
 CellID->267670800],
Cell[220882, 5818, 173, 2, 70, "Print",ExpressionUUID->"34797586-8eae-4369-b135-bb3bc2b51fec",
 CellID->1976970746],
Cell[221058, 5822, 501, 10, 70, "Print",ExpressionUUID->"fb379489-c004-4b54-b669-38e571a84d6e",
 CellID->1944220542],
Cell[221562, 5834, 610, 13, 70, "Print",ExpressionUUID->"d7d57692-277d-4187-8a9d-1b8a094b4000",
 CellID->606934162],
Cell[222175, 5849, 506, 10, 70, "Print",ExpressionUUID->"7c41f36f-bf62-45bb-ad63-89b693c040b6",
 CellID->994379849],
Cell[222684, 5861, 616, 13, 70, "Print",ExpressionUUID->"70982bb1-0bc0-4235-a2f0-9b1d55b14276",
 CellID->609101641],
Cell[223303, 5876, 501, 10, 70, "Print",ExpressionUUID->"65eb0c52-e2b7-4811-81d5-183805103ded",
 CellID->1064768979],
Cell[223807, 5888, 609, 13, 70, "Print",ExpressionUUID->"9ebed62b-5855-47a8-875f-5db261dffdf2",
 CellID->1099416089],
Cell[224419, 5903, 511, 10, 70, "Print",ExpressionUUID->"8361503e-fb1f-4ae2-afc2-3c5126b21fdf",
 CellID->2147016270],
Cell[224933, 5915, 618, 13, 70, "Print",ExpressionUUID->"e1aad3dd-d2dd-4bad-8ca4-96b08ceba03d",
 CellID->607469592],
Cell[225554, 5930, 523, 10, 70, "Print",ExpressionUUID->"bc424862-eb31-42e3-9ecb-4e6d38f9a1f2",
 CellID->2007800882],
Cell[226080, 5942, 627, 13, 70, "Print",ExpressionUUID->"09f55b5d-e86e-4912-9d6b-8e1847cf3191",
 CellID->15278918],
Cell[226710, 5957, 510, 10, 70, "Print",ExpressionUUID->"b5eba55d-8606-4c74-9320-78f631df0bd8",
 CellID->691408238],
Cell[227223, 5969, 618, 13, 70, "Print",ExpressionUUID->"31192e1e-a62b-4c82-9efb-161369118a85",
 CellID->633368008],
Cell[227844, 5984, 522, 10, 70, "Print",ExpressionUUID->"f8a26d1c-b367-4ed4-ae72-c1f3977add0d",
 CellID->785951532],
Cell[228369, 5996, 630, 13, 70, "Print",ExpressionUUID->"1d031f60-d1e5-418d-9001-4702c8963e70",
 CellID->673541992],
Cell[229002, 6011, 161, 2, 70, "Print",ExpressionUUID->"aefa3737-92d4-4c75-ac3f-33bcc09f5628",
 CellID->1513472065],
Cell[229166, 6015, 503, 10, 70, "Print",ExpressionUUID->"1f3ff9df-15ad-4bc1-9467-0cf31f6c046f",
 CellID->1329001556],
Cell[229672, 6027, 612, 13, 70, "Print",ExpressionUUID->"5a165719-6bf5-4f11-90fa-dc8cf34613e5",
 CellID->412819481],
Cell[230287, 6042, 504, 10, 70, "Print",ExpressionUUID->"42760329-1533-4029-b0f7-31c0691ea284",
 CellID->821598480],
Cell[230794, 6054, 615, 13, 70, "Print",ExpressionUUID->"5685c251-355b-4c9e-b1ac-16b7ce4a1236",
 CellID->1169536829],
Cell[231412, 6069, 522, 10, 70, "Print",ExpressionUUID->"bc0523ee-cc42-4f69-ab4e-6e3adaa933d3",
 CellID->657005301],
Cell[231937, 6081, 633, 13, 70, "Print",ExpressionUUID->"e1ea0a47-2abd-4065-acf5-36230740a8e7",
 CellID->1883930643],
Cell[232573, 6096, 530, 10, 70, "Print",ExpressionUUID->"9517104a-4495-42ce-93d2-84452d094ac1",
 CellID->856089810],
Cell[233106, 6108, 638, 13, 70, "Print",ExpressionUUID->"54df3e15-cdc6-43db-8684-98dd4958e173",
 CellID->873454677],
Cell[233747, 6123, 532, 10, 70, "Print",ExpressionUUID->"d91070bd-ea39-4159-8156-c70b25740688",
 CellID->154239739],
Cell[234282, 6135, 643, 13, 70, "Print",ExpressionUUID->"ea869518-87d3-4b37-a514-38b9e9021ba8",
 CellID->1757770762]
}, Open  ]],
Cell[234940, 6151, 2797, 93, 70, "Output",ExpressionUUID->"bf23a027-a373-480b-8223-e5b2e3da6d4a",
 CellID->1775515605]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "3"}, Closed]]]],
Cell[CellGroupData[{
Cell[237889, 6252, 1423, 37, 70, "ExampleSubsection",ExpressionUUID->"efda6c46-46b5-4087-a0e9-ba0be218c5b1",
 CellID->365788128],
Cell[239315, 6291, 203, 4, 70, "ExampleText",ExpressionUUID->"01f7e47d-06f3-4524-8548-c828808f69a6",
 CellID->346332891],
Cell[239521, 6297, 236, 5, 70, "Input",ExpressionUUID->"369b015a-5168-4b2d-93e0-3150dc6f2786",
 CellID->292193654],
Cell[CellGroupData[{
Cell[239782, 6306, 385, 8, 70, "Input",ExpressionUUID->"401a4e3b-2f9f-4f78-8683-521fa8fe4f86",
 CellID->833269130],
Cell[240170, 6316, 161, 2, 70, "Print",ExpressionUUID->"55be5150-031e-4ed8-96a8-740d350f7d3c",
 CellID->1279883780],
Cell[240334, 6320, 3462, 116, 70, "Output",ExpressionUUID->"eb34fde6-fb5e-4ec0-a7ba-e515f4cfe750",
 CellID->2143961120]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "4"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]],
Cell[CellGroupData[{
Cell[244060, 6447, 1400, 36, 24, "ExampleSection",ExpressionUUID->"c835a3ff-33c3-4b2f-804b-a00962575dce"],
Cell[CellGroupData[{
Cell[245485, 6487, 1427, 37, 70, "ExampleSubsection",ExpressionUUID->"cb030081-cc80-43c7-bd00-40eddf2e3fae",
 CellID->39279124],
Cell[246915, 6526, 194, 4, 70, "Input",ExpressionUUID->"7602ceec-047b-45b7-b584-84f9a2285b32",
 CellID->729754539],
Cell[247112, 6532, 369, 9, 70, "Input",ExpressionUUID->"0f6f127a-5963-4e5f-ba31-9b729da095df",
 CellID->1547554580],
Cell[247484, 6543, 174, 3, 70, "ExampleText",ExpressionUUID->"47cbd0ee-9be9-44ed-867f-21e0d71f8d29",
 CellID->530967077],
Cell[247661, 6548, 4626, 138, 70, "Input",ExpressionUUID->"224f7ed1-d6f8-4073-8577-223967b3e6c9",
 CellID->662879132],
Cell[252290, 6688, 134, 1, 70, "ExampleText",ExpressionUUID->"24fcfa3b-c667-4efb-a0d4-1e7919604a52",
 CellID->58442655],
Cell[252427, 6691, 1694, 52, 70, "Input",ExpressionUUID->"07f5f938-313d-4f73-b057-53a950a2c8f4",
 CellID->22494714],
Cell[CellGroupData[{
Cell[254146, 6747, 425, 9, 70, "Input",ExpressionUUID->"1e20bf0f-fd14-4fd2-ad0a-aa52dee2300f",
 CellTags->"TextAnnotation",
 CellID->711938469],
Cell[CellGroupData[{
Cell[254596, 6760, 406, 10, 70, "Print",ExpressionUUID->"bd67ed70-2bea-43eb-b30d-4eaaa5fbbffe",
 CellTags->"TextAnnotation",
 CellID->1749613872],
Cell[255005, 6772, 202, 3, 70, "Print",ExpressionUUID->"1cf80300-c8e9-45b8-ba61-97873b0a8afa",
 CellTags->"TextAnnotation",
 CellID->1735705612],
Cell[255210, 6777, 487, 13, 70, "Print",ExpressionUUID->"1d5c006b-538c-4b9c-b68e-b9965b816c08",
 CellTags->"TextAnnotation",
 CellID->1195419200],
Cell[255700, 6792, 201, 3, 70, "Print",ExpressionUUID->"4a171b82-a7b5-4732-9efc-42f650e422b5",
 CellTags->"TextAnnotation",
 CellID->598147271],
Cell[255904, 6797, 523, 14, 70, "Print",ExpressionUUID->"065487ac-a1df-4cc0-a06c-03df8c85f3dc",
 CellTags->"TextAnnotation",
 CellID->280728025],
Cell[256430, 6813, 396, 8, 70, "Print",ExpressionUUID->"2f9b00e3-718c-49c4-a191-e610b3770744",
 CellTags->"TextAnnotation",
 CellID->1539654935],
Cell[256829, 6823, 473, 9, 70, "Print",ExpressionUUID->"24e3512e-80eb-4832-9dad-77c42c00fc01",
 CellTags->"TextAnnotation",
 CellID->601266044],
Cell[257305, 6834, 495, 13, 70, "Print",ExpressionUUID->"72e2843f-b7b5-4335-9d6c-11d198ac48a5",
 CellTags->"TextAnnotation",
 CellID->1016290803],
Cell[257803, 6849, 202, 3, 70, "Print",ExpressionUUID->"1984a902-61b2-403f-a5bd-05bd40659e64",
 CellTags->"TextAnnotation",
 CellID->1807233067],
Cell[258008, 6854, 473, 12, 70, "Print",ExpressionUUID->"c10493ef-7411-42ae-94cb-51067cddc018",
 CellTags->"TextAnnotation",
 CellID->1651558601],
Cell[258484, 6868, 202, 3, 70, "Print",ExpressionUUID->"5326ef56-1407-47cc-834a-f5cc6649933a",
 CellTags->"TextAnnotation",
 CellID->2040481252],
Cell[258689, 6873, 356, 8, 70, "Print",ExpressionUUID->"96a07a0e-16b8-47ac-984d-4b5ab66a3b0b",
 CellTags->"TextAnnotation",
 CellID->88495623],
Cell[259048, 6883, 202, 3, 70, "Print",ExpressionUUID->"1e2bd444-018b-4f69-80f3-608fe30a3e7d",
 CellTags->"TextAnnotation",
 CellID->1080858944],
Cell[259253, 6888, 521, 14, 70, "Print",ExpressionUUID->"b0af3737-b06c-4f42-8a91-d8d25e1704f4",
 CellTags->"TextAnnotation",
 CellID->924193147],
Cell[259777, 6904, 396, 8, 70, "Print",ExpressionUUID->"cff23048-8e86-47de-b74c-2b1a69675750",
 CellTags->"TextAnnotation",
 CellID->1337586247],
Cell[260176, 6914, 474, 9, 70, "Print",ExpressionUUID->"5def0ed6-af8d-42c2-a166-950d6042e730",
 CellTags->"TextAnnotation",
 CellID->1645752361],
Cell[260653, 6925, 490, 10, 70, "Print",ExpressionUUID->"9ae2088b-3cfe-4c34-ae62-b84259b820e4",
 CellTags->"TextAnnotation",
 CellID->879679117],
Cell[261146, 6937, 499, 13, 70, "Print",ExpressionUUID->"55749739-d7cf-4b58-aa8d-d7832b453615",
 CellTags->"TextAnnotation",
 CellID->211470083],
Cell[261648, 6952, 396, 8, 70, "Print",ExpressionUUID->"d7f0269c-a296-46cc-bec4-9128ec6e1e2b",
 CellTags->"TextAnnotation",
 CellID->1198287826],
Cell[262047, 6962, 473, 9, 70, "Print",ExpressionUUID->"16cc009b-23b5-472b-b27f-4789b122202b",
 CellTags->"TextAnnotation",
 CellID->366925106],
Cell[262523, 6973, 490, 10, 70, "Print",ExpressionUUID->"7d267c30-5d79-42c5-bf4c-350d9ba3d0ed",
 CellTags->"TextAnnotation",
 CellID->865431663],
Cell[263016, 6985, 448, 12, 70, "Print",ExpressionUUID->"7353a57d-971d-4746-ab53-f8945c44f041",
 CellTags->"TextAnnotation",
 CellID->1901227907],
Cell[263467, 6999, 394, 8, 70, "Print",ExpressionUUID->"ae8350df-12be-48e4-8409-f811d2a6badf",
 CellTags->"TextAnnotation",
 CellID->77339353],
Cell[263864, 7009, 474, 9, 70, "Print",ExpressionUUID->"626e63c4-f577-4f19-8101-94f58e41bdfb",
 CellTags->"TextAnnotation",
 CellID->1785355346],
Cell[264341, 7020, 481, 9, 70, "Print",ExpressionUUID->"d0e6787d-128c-44dc-89ac-eae822c2b65a",
 CellTags->"TextAnnotation",
 CellID->245556838],
Cell[264825, 7031, 381, 9, 70, "Print",ExpressionUUID->"8b58890d-3207-497d-9d36-c4b340d58181",
 CellTags->"TextAnnotation",
 CellID->684463849],
Cell[265209, 7042, 395, 8, 70, "Print",ExpressionUUID->"9a01296a-c5eb-41e8-b234-8e4ab97ded8d",
 CellTags->"TextAnnotation",
 CellID->189745901],
Cell[265607, 7052, 474, 9, 70, "Print",ExpressionUUID->"732be6b4-afae-4ac0-bd38-8db16b59f1fd",
 CellTags->"TextAnnotation",
 CellID->1855243473],
Cell[266084, 7063, 479, 9, 70, "Print",ExpressionUUID->"dcb4bd2e-59cf-42a9-8d46-b2e869cc3a73",
 CellTags->"TextAnnotation",
 CellID->453634429],
Cell[266566, 7074, 516, 14, 70, "Print",ExpressionUUID->"86a60dd3-4705-4274-ad5d-80dd335ec437",
 CellTags->"TextAnnotation",
 CellID->1195169105],
Cell[267085, 7090, 396, 8, 70, "Print",ExpressionUUID->"abb57ba8-f0e2-4ddd-b469-fc2682676446",
 CellTags->"TextAnnotation",
 CellID->1457373697],
Cell[267484, 7100, 472, 9, 70, "Print",ExpressionUUID->"3fe5db5b-f07e-418a-b92e-05bf349b0c7d",
 CellTags->"TextAnnotation",
 CellID->41856393],
Cell[267959, 7111, 490, 10, 70, "Print",ExpressionUUID->"0bd65900-43be-430a-b85b-acb0023fc690",
 CellTags->"TextAnnotation",
 CellID->243104657],
Cell[268452, 7123, 530, 11, 70, "Print",ExpressionUUID->"b30396fb-34d9-4cd8-9ed1-ba4732b1c11b",
 CellTags->"TextAnnotation",
 CellID->2055520969],
Cell[268985, 7136, 631, 14, 70, "Print",ExpressionUUID->"0d050b03-7559-4388-aa8f-53f737137c95",
 CellTags->"TextAnnotation",
 CellID->322584418],
Cell[269619, 7152, 538, 11, 70, "Print",ExpressionUUID->"f5c5d8ed-f4e9-4014-8552-8932caf3930f",
 CellTags->"TextAnnotation",
 CellID->1782759593],
Cell[270160, 7165, 640, 14, 70, "Print",ExpressionUUID->"d6c210c4-98e0-4325-b45d-e12149540422",
 CellTags->"TextAnnotation",
 CellID->1112488754],
Cell[270803, 7181, 537, 11, 70, "Print",ExpressionUUID->"e92ce240-11e4-4446-aac4-bcc19b4c7ff9",
 CellTags->"TextAnnotation",
 CellID->923850462],
Cell[271343, 7194, 635, 14, 70, "Print",ExpressionUUID->"49161f5e-b186-4f0c-82f7-7fe1ada5e187",
 CellTags->"TextAnnotation",
 CellID->651566748],
Cell[271981, 7210, 545, 11, 70, "Print",ExpressionUUID->"8b113f00-bc77-41bf-b825-22bda7959fb2",
 CellTags->"TextAnnotation",
 CellID->772238174],
Cell[272529, 7223, 641, 14, 70, "Print",ExpressionUUID->"66203e65-e0ce-4809-bd3b-4b94f4166d6c",
 CellTags->"TextAnnotation",
 CellID->427925416],
Cell[273173, 7239, 539, 11, 70, "Print",ExpressionUUID->"298d7199-a0bb-4126-bca7-4fdfbf6d1393",
 CellTags->"TextAnnotation",
 CellID->544564352],
Cell[273715, 7252, 637, 14, 70, "Print",ExpressionUUID->"ba96bf9a-f3d4-49bb-8753-e8426b930a70",
 CellTags->"TextAnnotation",
 CellID->860733797],
Cell[274355, 7268, 548, 11, 70, "Print",ExpressionUUID->"3a769e5e-040d-4308-8412-4c14f204cf05",
 CellTags->"TextAnnotation",
 CellID->1508784360],
Cell[274906, 7281, 648, 14, 70, "Print",ExpressionUUID->"7bfa521e-2559-4289-9ce0-93a30de1ed80",
 CellTags->"TextAnnotation",
 CellID->1468757500],
Cell[275557, 7297, 538, 11, 70, "Print",ExpressionUUID->"4855a577-6aa2-4a0c-8350-6b850fe95e32",
 CellTags->"TextAnnotation",
 CellID->50836396],
Cell[276098, 7310, 640, 14, 70, "Print",ExpressionUUID->"f25d2968-2c11-4762-942d-ce9f8dfcc96b",
 CellTags->"TextAnnotation",
 CellID->1007053073],
Cell[276741, 7326, 547, 11, 70, "Print",ExpressionUUID->"b1efe63b-fd11-4c80-9c4d-fa62597cfba1",
 CellTags->"TextAnnotation",
 CellID->200952969],
Cell[277291, 7339, 645, 14, 70, "Print",ExpressionUUID->"e4ae0813-fe26-44e7-b519-14abd6bbd413",
 CellTags->"TextAnnotation",
 CellID->262306480],
Cell[277939, 7355, 188, 3, 70, "Print",ExpressionUUID->"938aca39-c57c-4c7e-81b6-4dd474867287",
 CellTags->"TextAnnotation",
 CellID->57857251],
Cell[278130, 7360, 533, 11, 70, "Print",ExpressionUUID->"82c54e99-1a68-4f36-89fa-cfd603aff43c",
 CellTags->"TextAnnotation",
 CellID->567878076],
Cell[278666, 7373, 634, 14, 70, "Print",ExpressionUUID->"0f9c14f8-c247-41c4-a9d2-7740b6c6edc5",
 CellTags->"TextAnnotation",
 CellID->1127738143],
Cell[279303, 7389, 530, 11, 70, "Print",ExpressionUUID->"fbcd3599-e657-4154-a2cf-5a903fb85930",
 CellTags->"TextAnnotation",
 CellID->1959085158],
Cell[279836, 7402, 629, 14, 70, "Print",ExpressionUUID->"0aba7ea0-9266-46ab-8d3a-397968aa62b5",
 CellTags->"TextAnnotation",
 CellID->645217429],
Cell[280468, 7418, 533, 11, 70, "Print",ExpressionUUID->"65134fa3-225a-4b81-b056-5de36b7a691d",
 CellTags->"TextAnnotation",
 CellID->765609841],
Cell[281004, 7431, 634, 14, 70, "Print",ExpressionUUID->"1ef6c3f0-1317-42a5-b3b4-a7a32a81d982",
 CellTags->"TextAnnotation",
 CellID->57158349],
Cell[281641, 7447, 534, 11, 70, "Print",ExpressionUUID->"7de54172-58bc-4ea0-ba0d-a599c76f6f53",
 CellTags->"TextAnnotation",
 CellID->1329681278],
Cell[282178, 7460, 635, 14, 70, "Print",ExpressionUUID->"0bda2937-63b9-4b47-a7da-7f85340658f4",
 CellTags->"TextAnnotation",
 CellID->955355742],
Cell[282816, 7476, 536, 11, 70, "Print",ExpressionUUID->"dec3e844-0d17-4cce-b38e-c109fad2157a",
 CellTags->"TextAnnotation",
 CellID->1912401822],
Cell[283355, 7489, 636, 14, 70, "Print",ExpressionUUID->"7aedf452-8067-495f-bbaf-76a951c2319e",
 CellTags->"TextAnnotation",
 CellID->1783315707],
Cell[283994, 7505, 533, 11, 70, "Print",ExpressionUUID->"391b459b-773c-4807-8a3e-76166272edb1",
 CellTags->"TextAnnotation",
 CellID->3041200],
Cell[284530, 7518, 636, 14, 70, "Print",ExpressionUUID->"129ff4a5-cb46-40e7-bd2d-80c4c4cb1a4b",
 CellTags->"TextAnnotation",
 CellID->1222291872],
Cell[285169, 7534, 526, 11, 70, "Print",ExpressionUUID->"f50af189-481b-4185-9012-4a8aa2041f78",
 CellTags->"TextAnnotation",
 CellID->1825172100],
Cell[285698, 7547, 629, 14, 70, "Print",ExpressionUUID->"394419b2-ccbe-432a-8e0c-b89e8cea241a",
 CellTags->"TextAnnotation",
 CellID->246145857],
Cell[286330, 7563, 526, 11, 70, "Print",ExpressionUUID->"7f7f68e7-3a88-4388-89d4-307d13dae5ea",
 CellTags->"TextAnnotation",
 CellID->1130329193],
Cell[286859, 7576, 622, 14, 70, "Print",ExpressionUUID->"c3782472-3d36-40aa-b2d7-bef19f30318e",
 CellTags->"TextAnnotation",
 CellID->272871],
Cell[287484, 7592, 518, 11, 70, "Print",ExpressionUUID->"122ff2da-25f0-4860-bcf5-581814c59a61",
 CellTags->"TextAnnotation",
 CellID->2028905450],
Cell[288005, 7605, 612, 13, 70, "Print",ExpressionUUID->"b3e374bb-aaca-446b-b8c2-a48a57feae73",
 CellTags->"TextAnnotation",
 CellID->95334299],
Cell[288620, 7620, 519, 11, 70, "Print",ExpressionUUID->"39418410-1e5f-4730-9b64-e4f6f3a7f64d",
 CellTags->"TextAnnotation",
 CellID->924123333],
Cell[289142, 7633, 615, 13, 70, "Print",ExpressionUUID->"917dc100-9978-417d-9e8d-3f8587152e5e",
 CellTags->"TextAnnotation",
 CellID->532988551],
Cell[289760, 7648, 555, 11, 70, "Print",ExpressionUUID->"7d70c561-e4a0-4871-839c-3faab4e7688d",
 CellTags->"TextAnnotation",
 CellID->867572473],
Cell[290318, 7661, 658, 14, 70, "Print",ExpressionUUID->"9e68195c-d35d-4d68-800d-259b48adb61c",
 CellTags->"TextAnnotation",
 CellID->1352048749],
Cell[290979, 7677, 560, 11, 70, "Print",ExpressionUUID->"6438df23-5a39-4800-a87f-63f447b3b2f8",
 CellTags->"TextAnnotation",
 CellID->1077552903],
Cell[291542, 7690, 660, 14, 70, "Print",ExpressionUUID->"ef455198-2edf-41ee-a839-8da70d838918",
 CellTags->"TextAnnotation",
 CellID->1728306271]
}, Open  ]],
Cell[292217, 7707, 192176, 4431, 70, "Output",ExpressionUUID->"3f8afc3e-fefd-436f-8762-79c71060ccbb",
 CellTags->"TextAnnotation",
 CellID->713349461]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "5"}, Closed]]]],
Cell[CellGroupData[{
Cell[484545, 12146, 1481, 37, 70, "ExampleSubsection",ExpressionUUID->"998d7fb0-5e73-4cb1-accf-502267bc73dc",
 CellID->144740365],
Cell[486029, 12185, 211, 4, 70, "Input",ExpressionUUID->"cfd7960e-634c-4d08-a177-74b8256509b6",
 CellID->61235782],
Cell[486243, 12191, 350, 6, 70, "ExampleText",ExpressionUUID->"66c56f29-13f1-45b2-8f7d-8da6b95a432c",
 CellID->4041254],
Cell[486596, 12199, 3952, 116, 70, "Input",ExpressionUUID->"e574ec65-eb5d-49c7-bce9-35f6b3fa92f0",
 CellID->190388794],
Cell[490551, 12317, 375, 9, 70, "Input",ExpressionUUID->"6e53d836-b157-4a3c-b411-5a3f5f0af960",
 CellID->94826705],
Cell[490929, 12328, 1571, 44, 70, "Input",ExpressionUUID->"289f0470-6d44-4ff1-8ae6-96b127fb08db",
 CellID->356039542],
Cell[CellGroupData[{
Cell[492525, 12376, 343, 7, 70, "Input",ExpressionUUID->"e8101faf-f9e2-4026-8008-c8743aaf051c",
 CellID->280547322],
Cell[CellGroupData[{
Cell[492893, 12387, 376, 9, 70, "Print",ExpressionUUID->"95d67dff-5b5f-41f1-8b6f-40930b18518b",
 CellID->398826755],
Cell[493272, 12398, 173, 2, 70, "Print",ExpressionUUID->"2facd683-08d2-4367-9e96-d9b1ae23d80e",
 CellID->1779142667],
Cell[493448, 12402, 458, 12, 70, "Print",ExpressionUUID->"befb0431-6cbe-44d8-a404-7bddb72270fd",
 CellID->1720402534],
Cell[493909, 12416, 172, 2, 70, "Print",ExpressionUUID->"a43edf63-0831-4c95-b3c2-eb0bc0e7902a",
 CellID->599779725],
Cell[494084, 12420, 495, 13, 70, "Print",ExpressionUUID->"27ddee4e-ac4b-405b-a23e-364e4c472353",
 CellID->2041449147],
Cell[494582, 12435, 367, 7, 70, "Print",ExpressionUUID->"d2c1eb67-7256-4ce5-9e11-f556189b9936",
 CellID->1778259786],
Cell[494952, 12444, 445, 8, 70, "Print",ExpressionUUID->"1d63bc2a-19b9-4817-af96-01e1cbc105ec",
 CellID->1167657801],
Cell[495400, 12454, 466, 12, 70, "Print",ExpressionUUID->"904cbe7c-7539-4183-a624-92b400cd239f",
 CellID->1021703642],
Cell[495869, 12468, 173, 2, 70, "Print",ExpressionUUID->"680034e9-8c46-4912-a8f0-3d9dc36e6a85",
 CellID->1589861296],
Cell[496045, 12472, 444, 11, 70, "Print",ExpressionUUID->"2f87f9d9-29de-49ef-970e-c3ba628050c6",
 CellID->1812875230],
Cell[496492, 12485, 173, 2, 70, "Print",ExpressionUUID->"1c5d68f1-ad83-4fed-b30d-5a9a6493fe1c",
 CellID->1787313483],
Cell[496668, 12489, 329, 7, 70, "Print",ExpressionUUID->"b7cab47c-e71c-4ae5-aec6-c4cb817fbc6d",
 CellID->1647019645],
Cell[497000, 12498, 172, 2, 70, "Print",ExpressionUUID->"d12076bf-a9a1-490a-8ef9-4d6cae85cc2b",
 CellID->995072860],
Cell[497175, 12502, 492, 13, 70, "Print",ExpressionUUID->"a5eca16d-d135-40a4-9560-e73589adc639",
 CellID->595185578],
Cell[497670, 12517, 367, 7, 70, "Print",ExpressionUUID->"09571972-dd82-4c12-bbe7-5b324d78bb1b",
 CellID->1411937820],
Cell[498040, 12526, 444, 8, 70, "Print",ExpressionUUID->"a9ed2c28-3c2c-436a-b788-2e0796f173b0",
 CellID->630904920],
Cell[498487, 12536, 456, 8, 70, "Print",ExpressionUUID->"aa3aa383-3a99-4218-9961-dbcf77273cc0",
 CellID->598226778],
Cell[498946, 12546, 470, 12, 70, "Print",ExpressionUUID->"2c8a7ff2-c030-4225-93cf-5fd21ae2303a",
 CellID->486746044],
Cell[499419, 12560, 366, 7, 70, "Print",ExpressionUUID->"e5c57138-427f-4978-91dc-717350168110",
 CellID->308593372],
Cell[499788, 12569, 444, 8, 70, "Print",ExpressionUUID->"c9c18de7-294e-417b-b408-ebd103298217",
 CellID->844372635],
Cell[500235, 12579, 457, 8, 70, "Print",ExpressionUUID->"4cbef2b9-ea9b-449b-b0a6-1c0e7aa99a34",
 CellID->1617075237],
Cell[500695, 12589, 418, 11, 70, "Print",ExpressionUUID->"8f42d595-7265-4371-b58b-8608af711ac3",
 CellID->308866243],
Cell[501116, 12602, 366, 7, 70, "Print",ExpressionUUID->"0edf0fd0-7fd8-4bb3-a74d-22c10bb6530f",
 CellID->725794438],
Cell[501485, 12611, 445, 8, 70, "Print",ExpressionUUID->"7526bcfc-f8d0-46e5-8621-7212dd1eeba7",
 CellID->1712409536],
Cell[501933, 12621, 457, 8, 70, "Print",ExpressionUUID->"588a6c13-3a5f-4c33-9653-4a293e760b5a",
 CellID->1232989577],
Cell[502393, 12631, 353, 8, 70, "Print",ExpressionUUID->"5ba23fd7-2ccf-4230-af89-b2fd12b2d6fb",
 CellID->1258782989],
Cell[502749, 12641, 366, 7, 70, "Print",ExpressionUUID->"d67b1998-877a-4a66-9bb2-794a90181bd3",
 CellID->432498362],
Cell[503118, 12650, 444, 8, 70, "Print",ExpressionUUID->"547db700-ea46-4848-b46d-1f52ba7e02ed",
 CellID->437554678],
Cell[503565, 12660, 450, 8, 70, "Print",ExpressionUUID->"de928d8f-fabb-4e27-b94e-f5cee99106c3",
 CellID->188852244],
Cell[504018, 12670, 485, 13, 70, "Print",ExpressionUUID->"f9a70e98-3a29-42b1-83f6-ed0ebab02367",
 CellID->13320985],
Cell[504506, 12685, 367, 7, 70, "Print",ExpressionUUID->"d060ccd0-0b0c-4c7c-9d45-d2e6d27dcead",
 CellID->1150904140],
Cell[504876, 12694, 444, 8, 70, "Print",ExpressionUUID->"aa39917b-687c-48a6-8711-47fae4e7456a",
 CellID->587679000],
Cell[505323, 12704, 462, 9, 70, "Print",ExpressionUUID->"a4f00a97-737e-4a9a-b8b0-43b8b58d34db",
 CellID->1792463652],
Cell[505788, 12715, 500, 10, 70, "Print",ExpressionUUID->"b7dc7e09-b594-4878-872e-2fe424dcfc45",
 CellID->723823026],
Cell[506291, 12727, 603, 13, 70, "Print",ExpressionUUID->"ed984eed-8338-4693-b247-1effc65e6b13",
 CellID->1187458725],
Cell[506897, 12742, 509, 10, 70, "Print",ExpressionUUID->"2cf18bba-70a4-4750-8d2d-1b3d1fb7669b",
 CellID->1686429152],
Cell[507409, 12754, 608, 13, 70, "Print",ExpressionUUID->"7a6a53e7-e2d4-46f3-889d-6f82aa3e8f88",
 CellID->354599164],
Cell[508020, 12769, 506, 10, 70, "Print",ExpressionUUID->"6fbf1c79-c058-4702-b12a-c9cebd5839c5",
 CellID->207632878],
Cell[508529, 12781, 604, 13, 70, "Print",ExpressionUUID->"2217a1c5-f038-4bfe-ad99-03b2fddeafe8",
 CellID->560649146],
Cell[509136, 12796, 515, 10, 70, "Print",ExpressionUUID->"0df8a1da-5366-4280-8654-65586d67e140",
 CellID->1944460461],
Cell[509654, 12808, 615, 13, 70, "Print",ExpressionUUID->"97af766f-a5ed-4d8e-a80e-3fca6448afe8",
 CellID->2020508108],
Cell[510272, 12823, 508, 10, 70, "Print",ExpressionUUID->"7f158aa0-aa46-4165-8ba3-721680f5fc4c",
 CellID->200478982],
Cell[510783, 12835, 609, 13, 70, "Print",ExpressionUUID->"3a9933b9-5bb5-4181-8268-97609e3f92d2",
 CellID->1443996458],
Cell[511395, 12850, 518, 10, 70, "Print",ExpressionUUID->"43219215-1f32-491b-8f0c-4f8c7eb0cce5",
 CellID->868097320],
Cell[511916, 12862, 620, 13, 70, "Print",ExpressionUUID->"64e12f0d-328f-4f74-9f19-9d5a7dc70efe",
 CellID->795664560],
Cell[512539, 12877, 508, 10, 70, "Print",ExpressionUUID->"6440a72f-234d-4c05-b4c6-cb690d700