(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    184731,       4424]
NotebookOptionsPosition[    148980,       3779]
NotebookOutlinePosition[    151434,       3841]
CellTagsIndexPosition[    151347,       3836]
WindowTitle->GenericIdealGasQ
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["X IDEAL SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "6122a83b-ea9e-954c-b028-bbe9350d54e2"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "1ebd456c-0f0c-7a47-969b-9ed7d62f3be1"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[Cell[BoxData[
     TagBox[
      ActionMenuBox[
       FrameBox[Cell[TextData[{
         "URL",
         " ",
         Cell[BoxData[
          GraphicsBox[
           {GrayLevel[0.66667], Thickness[0.13], 
            LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
           AspectRatio->1,
           ImageSize->20,
           PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
          "1143487c-5568-b74a-927a-6a18303512eb"]
        }],ExpressionUUID->"407112c7-f07c-e24a-9131-6bbbf5bcc30d"],
        StripOnInput->False],{
       "\"xIdeal/ref/ConnectionTensor\"" :> None, 
        "\"Copy Wolfram Documentation Center URL\"" :> 
        Module[{DocumentationSearch`Private`nb$}, 
          DocumentationSearch`Private`nb$ = 
           NotebookPut[
            Notebook[{Cell["xIdeal/ref/ConnectionTensor"]}, Visible -> 
              False]]; SelectionMove[
           DocumentationSearch`Private`nb$, All, Notebook]; 
          FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
          NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
        "\"Copy web URL\"" :> 
        Module[{DocumentationSearch`Private`nb$}, 
          DocumentationSearch`Private`nb$ = 
           NotebookPut[
            Notebook[{
              Cell[BoxData[
                MakeBoxes[
                 Hyperlink[
                  "http://reference.wolfram.com/language/xIdeal/ref/\
ConnectionTensor.html"], StandardForm]], "Input", TextClipboardType -> 
                "PlainText"]}, Visible -> False]]; 
          SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
          FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
          NotebookClose[DocumentationSearch`Private`nb$]; Null], 
        "\"Go to web URL\"" :> 
        FrontEndExecute[{
          NotebookLocate[{
            URL[(If[TrueQ[False], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "xIdeal/ref/ConnectionTensor") <> ".html"], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"],
      MouseAppearanceTag["LinkHand"]]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "2b784451-83c6-f64b-a56c-78c2fe39619a"]], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "c8056aa9-a14d-474a-a310-d210dbe0dee8"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"6af1d756-454a-d74e-9fb4-f2d9c7a13904"],

Cell["xAct`xIdeal`", "ContextNameCell",ExpressionUUID->"aa59401b-85f7-d64f-9059-a7b7e23a8542"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "GenericIdealGasQ", "ObjectName",ExpressionUUID->
      "ca0c3827-f1a1-a64d-b83f-993f2cdb9574"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"84ebaa4c-05a8-054b-9bb7-ae72b13a6fdc"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "cec9b92c-616e-544e-a62c-01ad43fc4472"]
    }],ExpressionUUID->"a0885fbf-848f-0e46-b514-46e878332234"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"908a2026-684e-3242-9647-\
f774108ebaab"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GenericIdealGasQ", "[", 
       RowBox[{"metric", ",", " ", "w"}], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a9ecdbb3-7938-c649-9e10-ef3ecb5be285"],
     " returns True if metric is of the generic ideal gas type. To do so, it \
needs an arbitrary unitary time-like vector w."
    }],ExpressionUUID->"345728f9-2b0b-6046-b3a8-303fb55989fe"]}
  }]], "Usage",
 CellID->423578463,ExpressionUUID->"a2159931-a5d4-b94b-80ee-7b568f1fe8e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"2a43084a-fd1e-2346-8033-3d8e46a14797"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"ee7b299f-fee2-7c41-97be-5143c85bcbc0"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"7c90c064-ce30-5442-9b61-fef6d563b24c"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"9117d2b8-a091-f042-925c-e845527bab5d"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->467077136,ExpressionUUID->"385d3ec3-b537-cf45-a3f2-d9610ead5236"],

Cell["The following options can be given: ", "Notes",
 CellID->354734344,ExpressionUUID->"b53b1068-9abb-6147-a233-df4ca87d0b6f"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "df3032e3-6b11-1b48-8fd2-364b6e8de7bd"], 
    RowBox[{
     TemplateBox[{
       Cell[
        TextData["PSimplify"]], "paclet:xIdeal/ref/PSimplify", 
       "xIdeal Package Symbol"},
      "PackageLink",
      BaseStyle->"3ColumnTableMod"], " ", 
     TemplateBox[{332337614},
      "ExampleJumpLink"]}], "$CVSimplify", Cell["\<\
PSimplify is an option to choose the function used to simplify expressions.\
\>", "TableText",ExpressionUUID->"1a181014-0fdb-1f4c-864e-4eeb106f1284"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "19a5cbac-1a3c-5e4b-b7c0-69db3b63669c"], 
    TemplateBox[{
      Cell[
       TextData["Parallelize"]], "paclet:ref/Parallelize"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], 
    TemplateBox[{
      Cell[
       TextData["True"]], "paclet:ref/True"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Parallelize", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "43957d08-bbaf-5644-89a9-9c4c0b0f55da"],
     " evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "5fafa3d0-6981-2b46-99ca-fddc4897d9ba"],
     " using automatic parallelization."
    }], "TableText",ExpressionUUID->"c398d2da-1c82-624f-a28d-b27b8f93fdb4"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "50e3704d-487e-f747-97b9-7e5a2d2804d3"], 
    RowBox[{
     TemplateBox[{
       Cell[
        TextData["Verbose"]], "paclet:ref/Verbose"},
      "RefLink",
      BaseStyle->{"3ColumnTableMod"}], " ", 
     TemplateBox[{80309467},
      "ExampleJumpLink"]}], 
    TemplateBox[{
      Cell[
       TextData["True"]], "paclet:ref/True"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell["\<\
Verbose is a Boolean option for MakeRule, AutomaticRules and ToCanonical. \
Verbose->True gives lots of log-info about the internals of the calculation. \
Its default value is False.\
\>", "TableText",ExpressionUUID->"79e632a7-1f64-6943-b679-5c58e9fadade"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->27290970,ExpressionUUID->"1757023c-e90b-c445-b7e8-27e56da90159"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"0206e4c2-1a47-4949-ac3b-d4a5dc83e520"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"942b4214-cf93-0e4d-a024-b037dac6a342"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount",ExpressionUUID->
  "8ceeba09-eaf7-7849-b2cb-1310846b3bf6"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->621751721,ExpressionUUID->"0b3dd7bb-3a56-c04e-81bd-e748285b6e68"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xIdeal`\>\"", "]"}]], "Input", "ExampleInitialization",
 CellLabel->"In[1]:=",
 CellID->19048104,ExpressionUUID->"b2919055-af09-a14b-be3c-0b4135d3cfe7"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"de732f98-8096-bd4b-a6db-f27157944d6b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"eccc8e08-d916-774e-92fe-0af79bd8c592"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "981b125d-98ea-c042-99f9-833d6482ebe4"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->96541105,ExpressionUUID->"8bca7bbe-d079-804a-a9e3-961a9ef0bd50"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"c6049680-149b-9443-aed5-13c181ebff8a"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"0db47705-51c2-114a-91a3-47a30834a1f9"],
 "Ideal T-models:",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "432860fb-ce6c-b44d-a449-1ba5b5a585f8"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->127660352,ExpressionUUID->"6f102aaf-3ba3-f745-be24-09625e9afba7"],

Cell[TextData[{
 "Here, we will check that the ideal T-models (see ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData["Ferrando J J and Mengual S 2021 Phys. Rev. D 104 024038"]], 
    "https://arxiv.org/abs/2106.01015"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "b574d7ce-77ae-2542-b8bb-f38431349d1c"],
 ") are indeed generic ideal gas solutions. We start by defining the \
coordinates and the metric:"
}], "ExampleText",
 CellID->50967587,ExpressionUUID->"9348b1e2-cbc6-644d-aa00-5099e90a8870"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"chart", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"x", "[", "]"}], ",", 
      RowBox[{"y", "[", "]"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefScalarFunction", "[", "Q", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", "\[Gamma]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"t", "[", "]"}], 
        FractionBox["4", 
         RowBox[{"3", "\[Gamma]"}]]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"t", "[", "]"}], 
           RowBox[{"1", "-", 
            FractionBox["2", "\[Gamma]"]}]], "+", 
          RowBox[{"Q", "[", 
           RowBox[{"r", "[", "]"}], "]"}]}], ")"}], "2"]}], ",", 
      SuperscriptBox[
       RowBox[{"t", "[", "]"}], 
       FractionBox["4", 
        RowBox[{"3", "\[Gamma]"}]]], ",", 
      SuperscriptBox[
       RowBox[{"t", "[", "]"}], 
       FractionBox["4", 
        RowBox[{"3", "\[Gamma]"}]]]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "chart"}], ",", 
       RowBox[{"-", "chart"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "chart", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"t", "[", "]"}], ">", "0"}]}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->140152022,ExpressionUUID->"2b4327f4-7a80-dd41-8f36-a130d1f7a737"],

Cell["Now, we define the arbitrary unitary time-like vector:", "ExampleText",
 CellID->536840932,ExpressionUUID->"38cd4713-affd-de4b-be59-c3003428d5eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", "chart", "}"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"w", "[", "a", "]"}], 
   RowBox[{"w", "[", 
    RowBox[{"-", "a"}], "]"}]}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->460319658,ExpressionUUID->"bf4a06d0-70f1-7d49-99a3-48ba15a12c5b"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->375539115,ExpressionUUID->"800d0c9f-5a59-e047-8466-b7c714829e67"]
}, Open  ]],

Cell[TextData[{
 "Finally, we can use the ",
 StyleBox["GenericIdealGasQ", "Input"],
 " function:"
}], "ExampleText",
 CellID->205275238,ExpressionUUID->"b6b12992-e80a-1f4f-a1e6-2b9fd7d7b16d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GenericIdealGasQ", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"\"\<Vector\>\"", "->", "w"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->18878652,ExpressionUUID->"0993cb51-f9c7-c64c-b85a-ddcec0693eac"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->199894610,ExpressionUUID->"c401f63e-f631-5144-94b8-6b974a41921e"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->284379009,ExpressionUUID->"1baa7a2e-8f4a-5d4b-9140-30962d517582"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->321161971,ExpressionUUID->"5ff49fef-05a6-594a-8b7b-fd65a1bfc3b8"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->164480594,ExpressionUUID->"c424d323-2a5e-8a49-8a2f-4027bfb36718"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->80652402,ExpressionUUID->"ed709dd5-cd2a-094c-aea7-54ab82076b55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0047235`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0047235, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->29876433,ExpressionUUID->"95782fe6-6718-974d-ada9-9e32e17f159c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "3.8793621`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 3.8793621, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->711137987,ExpressionUUID->"ac0a998d-a060-9243-ba0c-a8c744d23db1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->253945277,ExpressionUUID->"8a89240d-fab7-254d-bc52-d81d9c819976"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->166242698,ExpressionUUID->"9e41980f-d9ca-8c43-9264-5669d3772005"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->556470339,ExpressionUUID->"39a8da1e-1363-6548-9fe8-e22bde25a2ea"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->392511631,ExpressionUUID->"4e962f94-d681-a844-b10a-6f9a00ebb1b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->501934909,ExpressionUUID->"d1eb534e-f2bd-3b45-a58c-4330d8d308d9"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->309331836,ExpressionUUID->"23fa652b-2c76-d84a-b6d3-61c7e4f295b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->260337149,ExpressionUUID->"05952651-2bf4-944e-8093-5b5944f7c52c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0007163`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0007163, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->545297068,ExpressionUUID->"fbe45466-74f1-964b-af48-3a0663be05de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0426098`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0426098, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->667279460,ExpressionUUID->"9fff255c-e473-024d-b1ca-8b068bf370a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0008768`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "35168",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0008768, " seconds and ", 35168, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->132355864,ExpressionUUID->"0f276c9b-bce0-c840-a03e-a9d812a7d594"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->185958401,ExpressionUUID->"64620144-3578-9e49-9e80-022f17d18a69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0019836`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0019836, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->755067430,ExpressionUUID->"2002fd1f-ed89-454a-b89b-a5511dd16bf0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0572398`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0572398, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->269169355,ExpressionUUID->"09e47af2-39b6-db42-bbf4-91dbfe9098ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0008713`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "34160",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0008713, " seconds and ", 34160, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->943414289,ExpressionUUID->"e8a8a7ba-ac18-8848-8699-9d21904dc21d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->429752402,ExpressionUUID->"0c61f46f-e5d4-9e43-91ed-5aa1c857388e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0002052`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0002052, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->520052951,ExpressionUUID->"94a88f93-481f-ae4b-b8c2-564934faa423"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0462046`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0462046, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->212592565,ExpressionUUID->"e508e391-aaf7-0d4a-a190-c336c2c24474"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0004303`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "5808", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0004303, " seconds and ", 5808, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->136856021,ExpressionUUID->"b53580ea-046d-394d-b324-56cfa19dc7ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->62712626,ExpressionUUID->"f30593f0-f8bf-dc4f-91c5-3a4f3cae16c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0003222`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0003222, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->173858095,ExpressionUUID->"b8a02e3c-92a0-3544-b405-3c45bce72f4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0422168`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0422168, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->2725631,ExpressionUUID->"47000cde-8e89-d844-b096-d2cf5432068b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0003581`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "1728", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0003581, " seconds and ", 1728, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->200798782,ExpressionUUID->"a74dcaa3-2e4c-524d-94fd-0d6fa2c6f50e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->308429006,ExpressionUUID->"2c7a0986-c81e-1b4b-bb73-60275df014b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0021074`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0021074, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->563856554,ExpressionUUID->"1db065f2-e4d1-d447-b6be-dae514e39aba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0593107`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0593107, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->342898314,ExpressionUUID->"a10c897a-e32e-9e42-926a-bf394a0f5b75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0019539`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "33440",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0019539, " seconds and ", 33440, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->466911984,ExpressionUUID->"1868b621-ec0d-2248-8d82-7c4070bb59e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"STensor\\\" \
in \"\>", "\[InvisibleSpace]", "0.0020129`4.7553671933588175", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor\" in ", 
   0.0020129`4.7553671933588175, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->126957635,ExpressionUUID->"b5d382df-66da-6f4e-b949-992b6f61929a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0511121`6.160068718311042", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"STensor\" in ", 0.0511121`6.160068718311042, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->111392664,ExpressionUUID->"1495bfd6-c6a2-1346-85e2-d478b0743fbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"STensor2\\\" in \"\>", "\[InvisibleSpace]", "0.0209899`5.773555363019217",
    "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor2\" in ", 
   0.0209899`5.773555363019217, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->902543726,ExpressionUUID->"d82b1a23-9b5e-194a-b3c0-bb4c16d2962c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor2\\\" in \"\>",
    "\[InvisibleSpace]", "0.0418682`6.07342928357585", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"STensor2\" in ", 0.0418682`6.07342928357585, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->486418,ExpressionUUID->"675395b4-01d4-1a4f-9d24-66bb0e73f5dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"STensor3\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor3\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->226917783,ExpressionUUID->"cc2bf0e6-7f35-2749-9115-a5f5a3ddac63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor3\\\" in \"\>",
    "\[InvisibleSpace]", "0.0471386`6.124921673480978", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"STensor3\" in ", 0.0471386`6.124921673480978, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->339987587,ExpressionUUID->"ed3c0653-ad9c-df44-ab04-6bac6a14236b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"TrSTensor2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0158926`5.652739946290714", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"TrSTensor2\" in ", 
   0.0158926`5.652739946290714, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->381527907,ExpressionUUID->"55ff44bd-d2aa-c44b-8b61-15de8464e61a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"TrSTensor2\\\" in \
\"\>", "\[InvisibleSpace]", "0.0045353`5.108151013455554", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"TrSTensor2\" in ", 0.0045353`5.108151013455554, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->298638005,ExpressionUUID->"7604fa21-c749-e145-8eba-fad4a514a039"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"TrSTensor3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.017386`5.691744668785128", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"TrSTensor3\" in ", 
   0.017386`5.691744668785128, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->34293854,ExpressionUUID->"74b55331-d8ad-3a42-99d3-006ec8493021"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"TrSTensor3\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"TrSTensor3\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->183325057,ExpressionUUID->"626029e0-9bec-ae49-baad-a94333fc6acf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"qScalar\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"qScalar\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->38319385,ExpressionUUID->"0bbac675-39ae-0648-b19d-67a5bcddc438"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"qScalar\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0160959`5.6582602587118185", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"qScalar\" in ", 0.0160959`5.6582602587118185, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->506684129,ExpressionUUID->"9ecb3dc0-afc5-3c41-a7c7-34a441b7a248"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"QTensor\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"QTensor\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->115157910,ExpressionUUID->"610814fb-a1b7-8a4e-85d2-9055ec3518ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"QTensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"QTensor\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->648532840,ExpressionUUID->"09bf5f74-c802-c04e-a427-e95b47287ac7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"QTensor2\\\" in \"\>", "\[InvisibleSpace]", "0.0102959`5.464209309282443",
    "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"QTensor2\" in ", 
   0.0102959`5.464209309282443, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->13871061,ExpressionUUID->"f565609a-cab0-a444-832b-6e094f9d386d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"QTensor2\\\" in \"\>",
    "\[InvisibleSpace]", "0.0058622`5.219605624625801", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"QTensor2\" in ", 0.0058622`5.219605624625801, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->538874506,ExpressionUUID->"e554af4d-2932-aa4e-a59f-ae0244179d7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"FluPerCond1\
\\\" in \"\>", "\[InvisibleSpace]", "0.0022931`4.811967987825222", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerCond1\" in ", 
   0.0022931`4.811967987825222, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->87018577,ExpressionUUID->"06d5987e-beef-b748-baa5-4fde1e60e0f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerCond1\\\" in \"\
\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FluPerCond1\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->569501031,ExpressionUUID->"5982ced8-02ff-6b4b-9c50-f369eb9de75c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"FluPerCond2\
\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerCond2\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->818280550,ExpressionUUID->"e87841c3-0da8-4c47-b63f-bbfb01c1afe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerCond2\\\" in \"\
\>", "\[InvisibleSpace]", "0.0040108`5.0547759997653365", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FluPerCond2\" in ", 0.0040108`5.0547759997653365,
    " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->224878284,ExpressionUUID->"0cc9013b-066e-5243-922e-1e0cba49467f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"rScalar\\\" \
in \"\>", "\[InvisibleSpace]", "0.0290214`5.914263352583531", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"rScalar\" in ", 
   0.0290214`5.914263352583531, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->607431991,ExpressionUUID->"8b2a930f-2e72-664c-9018-ea96463eaf39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"rScalar\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0155637`5.643657844412033", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"rScalar\" in ", 0.0155637`5.643657844412033, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->578716080,ExpressionUUID->"e687a984-fb27-de43-a8b8-47a0143f3b3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"Pressure\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->11740360,ExpressionUUID->"87a25bb3-9329-2c49-8c9d-ee364b0d7476"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"Pressure\\\" in \"\>",
    "\[InvisibleSpace]", "0.0020056`4.753789314446131", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"Pressure\" in ", 0.0020056`4.753789314446131, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->36517226,ExpressionUUID->"df2c6eac-1767-0441-bc11-32ab8c955f64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"EnergyDensity\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->75810382,ExpressionUUID->"871ba17e-69f1-5443-b608-22879596d5e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"EnergyDensity\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"EnergyDensity\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->7627517,ExpressionUUID->"f9207f83-4687-7043-939a-e10a720aba79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"FlowProjector\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FlowProjector\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->173497921,ExpressionUUID->"47cb3023-d906-7540-98a5-4c7588116a99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FlowProjector\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FlowProjector\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->545642348,ExpressionUUID->"5aadcfca-9a76-a946-9c8b-d0efc7414acb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"FluPerFlow\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerFlow\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->32923112,ExpressionUUID->"32eb0bda-5f4c-7d4f-80b9-ae829cd36182"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerFlow\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FluPerFlow\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->366506641,ExpressionUUID->"4b85fbc3-ada3-a64a-86b5-693d0fcf5c12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.063507`6.254366591131618", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"IndicatrixFunction\" in ",
    0.063507`6.254366591131618, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->290908732,ExpressionUUID->"aebeb264-59f6-d645-88ca-3754b36c3c6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \
\\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0176264`5.697708614939717", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"IndicatrixFunction\" in ", 
   0.0176264`5.697708614939717, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->376994840,ExpressionUUID->"b9ad883f-6026-a740-95c4-3217605d2285"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"Pressure\" in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->244370128,ExpressionUUID->"2746cbff-f667-184a-9a6e-28d1a48be864"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"Pressure\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->375307823,ExpressionUUID->"14bd902f-a5e7-8a47-af12-1e64b9cf1922"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"EnergyDensity\" in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->389923481,ExpressionUUID->"ec7239e8-d0d6-e042-88f1-f1dff5a76457"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"EnergyDensity\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->176225150,ExpressionUUID->"e0b0fa5c-5b34-ec4c-9063-be57ebe28ad1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.1026409`6.46286544496222", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"IndicatrixFunction\" in ", 0.1026409`6.46286544496222, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->35566531,ExpressionUUID->"ea2f9054-f1f4-ae41-a5e8-2a803d5be2ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495968", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"IndicatrixFunction\" \
in ", 0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->811172667,ExpressionUUID->"f7cc6f58-bdd1-dc41-a1da-b05014ee54d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"ThermoFluPerCond\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0072699`5.313073430524626", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"ThermoFluPerCond\" in ", 
   0.0072699`5.313073430524626, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->1175063,ExpressionUUID->"d71620d0-f084-1543-a5d0-3d84cca62e04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"ThermoFluPerCond\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"ThermoFluPerCond\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->634487167,ExpressionUUID->"d5f0e64d-1f21-0c4e-ad67-71c2be8cd1a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"Pi\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"Pi\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->467732218,ExpressionUUID->"91c97701-d1e1-4a47-82a4-245479932a3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"Pressure\\\" in \"\>",
    "\[InvisibleSpace]", "0.0040107`5.054765171504239", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"Pressure\" in ", 0.0040107`5.054765171504239, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->264036348,ExpressionUUID->"5a3ec029-ee1e-0244-a9ba-13b607758880"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"Pi\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0263015`5.871525510926656", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"Pi\" in ", 0.0263015`5.871525510926656, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->277476628,ExpressionUUID->"e2473f9a-ad89-4547-81b8-7afe71aa7497"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"Pi\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"Pi\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->387362823,ExpressionUUID->"ec747d47-2ed3-f14c-9352-655c0597cab8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"IndicatrixFunction\" in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->31539642,ExpressionUUID->"8a587e36-bb22-6c44-bd4d-b52c59ef882d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"IndicatrixFunction\" \
in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->162930425,ExpressionUUID->"9934a4b9-baac-1246-8e68-0ffed4589208"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"GenericIdealGasCond\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"GenericIdealGasCond\" in \
", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->108005011,ExpressionUUID->"0be9a9dc-8f30-a64c-93e4-b7327a2d1f1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"GenericIdealGasCond\\\
\" in \"\>", "\[InvisibleSpace]", "0.0158656`5.652001494247682", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"GenericIdealGasCond\" in ", 
   0.0158656`5.652001494247682, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->40378780,ExpressionUUID->"38594236-bfdb-954d-b48b-626058793c0f"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[3]=",
 CellID->15434047,ExpressionUUID->"b174d2ad-08be-224f-abe2-1d5ddf2d875f"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"a90f6882-ca36-bb4a-96cb-e871ceeaf05b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f318cc84-1d32-f54d-9aac-7f89f4f6d46d"],
 "Scope",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "3aa6520f-7aa5-1749-9b2b-856ddb7b6248"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->99653001,ExpressionUUID->"cfb2b5e8-ae2a-8143-9abb-2fe82599e753"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"252097ce-c122-2447-a7f4-dd7031877aa9"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"e576d58c-d420-da49-bc80-46d448f714c5"],
 "Spherically symmetric Stephani universes:",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "49420d93-c9a0-4d4c-95f9-68af0aeefbc3"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->847191,ExpressionUUID->"b1f2cd23-bd9d-da4a-a49e-5d6c5ed98b99"],

Cell[TextData[{
 "Here, we will check that the spherically symmetric Stephani universes (see \
section 4.10 of  Krasi\:0144ski A 1997 ",
 StyleBox["Inhomogeneous Cosmological Models",
  FontSlant->"Italic"],
 " (Cambridge University Press, Cambridge, England) or ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
     "Mengual S, S\[AAcute]ez J a and Ferrando J J 2024 Phys. Rev. D 110 \
044012"]], "https://arxiv.org/abs/2409.01852"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "fd1a1bb8-1396-c44c-b728-334ba2c58d72"],
 ") are not, in general, generic ideal gas solutions. We start by defining \
the coordinates and the metric:"
}], "ExampleText",
 CellID->540994405,ExpressionUUID->"a1c08ac3-253a-b146-a7e5-fc952599c537"],

Cell[BoxData[
 RowBox[{"UnsetCMetric", "[", "metric", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->22747195,ExpressionUUID->"2db132f3-a20d-444d-b9da-283c3fad36d4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"char", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"\[Theta]", "[", "]"}], ",", 
      RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefScalarFunction", "[", "R", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefScalarFunction", "[", 
   RowBox[{"kk", ",", 
    RowBox[{"PrintAs", "->", "\"\<k\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalOmega]", "=", 
   FractionBox[
    RowBox[{"R", "[", 
     RowBox[{"t", "[", "]"}], "]"}], 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"kk", "[", 
       RowBox[{"t", "[", "]"}], "]"}], 
      SuperscriptBox[
       RowBox[{"r", "[", "]"}], "2"]}]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"R", "[", 
      RowBox[{"t", "[", "]"}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"t", "[", "]"}], "]"}], ",", 
       RowBox[{"t", "[", "]"}]}], "]"}]], 
    FractionBox[
     RowBox[{"D", "[", 
      RowBox[{"\[CapitalOmega]", ",", 
       RowBox[{"t", "[", "]"}]}], "]"}], "\[CapitalOmega]"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[Alpha]", "2"]}], ",", 
      SuperscriptBox["\[CapitalOmega]", "2"], ",", 
      RowBox[{
       SuperscriptBox["\[CapitalOmega]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"r", "[", "]"}], "2"]}], ",", 
      RowBox[{
       SuperscriptBox["\[CapitalOmega]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"r", "[", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "char"}], ",", 
       RowBox[{"-", "char"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "char", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->575875497,ExpressionUUID->"bbab46c7-2c70-2640-b9ff-b1a26a36cb7c"],

Cell["Now, we define the arbitrary unitary time-like vector:", "ExampleText",
 CellID->420765059,ExpressionUUID->"0729ca5a-e996-6a4a-9488-1154fb3b43b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "\[Alpha]"], ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", "char", "}"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{
    RowBox[{"w", "[", "a", "]"}], 
    RowBox[{"w", "[", 
     RowBox[{"-", "a"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->255693001,ExpressionUUID->"8e970eef-388b-b04c-9859-f2b9dea5bcf3"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->736350347,ExpressionUUID->"183139af-4a11-f145-bf0c-42d21e81d3bb"]
}, Open  ]],

Cell[TextData[{
 "Finally, we can use the ",
 StyleBox["GenericIdealGasQ", "Input"],
 " function:"
}], "ExampleText",
 CellID->255754560,ExpressionUUID->"cc9f09f9-c6d2-3b4a-ac51-f707a080b65d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GenericIdealGasQ", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"\"\<Vector\>\"", "->", "w"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",
 CellID->94237115,ExpressionUUID->"f9ef527b-f292-2c45-8654-dca02e6d92e7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->564816374,ExpressionUUID->"745cc4ba-f2d1-2449-bf8f-806968cb9c24"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->112309591,ExpressionUUID->"b33d76f0-babf-2d4e-9d11-293f786e513a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->183393588,ExpressionUUID->"bd81d0b1-9c51-ff4e-915d-026ab39c0ba3"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->299176215,ExpressionUUID->"4cc5429e-c3b1-654d-911a-0aed613ecfd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->490702906,ExpressionUUID->"c1596af5-5f7f-e048-b840-e0fd6dedb151"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0012464`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0012464, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->341035772,ExpressionUUID->"f7d90876-029f-ed4c-bb2c-58fb797c564e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "4.4578079`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 4.4578079, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->77715002,ExpressionUUID->"8e40727a-a85b-584a-a302-615ce6337f08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->390864081,ExpressionUUID->"a2105557-0e0f-1a42-b8fc-9c38801cd2d7"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->706286,ExpressionUUID->"1a340f78-ddb3-604c-8914-51b9698f0bfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->417861246,ExpressionUUID->"ba8eaecb-5f9a-0648-b82c-9a0d8022e244"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->123829111,ExpressionUUID->"fead5d18-d721-e44c-8597-021bc778bb65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->127916646,ExpressionUUID->"cdd84de8-bcee-be49-949f-af4ef4c7adf2"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->314722725,ExpressionUUID->"f3a20dfb-e2f0-674d-950a-364be78f3fd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->68259005,ExpressionUUID->"558e1b93-bf40-404c-be06-7367c5a52a39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0018838`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0018838, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->311557775,ExpressionUUID->"c6a7184e-7108-9549-b92d-c8e4e1f18145"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.1089897`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.1089897, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->364414901,ExpressionUUID->"cca72965-3db4-4b41-a734-3c22606c2f47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.002131`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "70688",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.002131, " seconds and ", 70688, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->799249401,ExpressionUUID->"a1d15822-4cb2-8347-a025-6fbb88aaa7d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->98365936,ExpressionUUID->"2deca3a7-9f28-1d41-94fc-cabb86dfd690"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0027042`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0027042, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->29929570,ExpressionUUID->"a80259fd-4ba5-204a-8199-8ccff6e6a0d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0687936`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0687936, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->228444079,ExpressionUUID->"2636b35a-f00b-384b-bb5d-ba216de35de2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0009561`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "65888",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0009561, " seconds and ", 65888, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->175956674,ExpressionUUID->"751eea4a-7766-1841-bd88-6e17642a5da0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->398757780,ExpressionUUID->"f4f0d0c5-899c-c44d-bc73-89e7f40f8641"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0001831`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0001831, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->182238272,ExpressionUUID->"db45f728-d3a2-704a-8e2b-f31d7272c512"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0595726`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0595726, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->221277073,ExpressionUUID->"67313aab-8057-c144-ae76-451d61b8cf8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0005154`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "18904",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0005154, " seconds and ", 18904, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->306478107,ExpressionUUID->"ba5e031b-f8d6-e141-bc1e-826e4779a78d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->65902239,ExpressionUUID->"37c149e4-b687-f744-90e2-6810fd7c9c8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0002458`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0002458, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->208605351,ExpressionUUID->"fefd9ff5-460e-5f42-ae20-f6520e7f9b80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0456952`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0456952, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->7137331,ExpressionUUID->"50d48530-afa1-8045-9621-6a9b44bd9d5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0004906`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "4704", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0004906, " seconds and ", 4704, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->65568651,ExpressionUUID->"08053003-88f7-de4c-98fd-12fab63d7ee2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->49699043,ExpressionUUID->"3521e734-f579-694e-81e9-b5b36719c07c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0014906`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0014906, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->22292850,ExpressionUUID->"0bb6c660-22cf-4642-b701-b89bab8a735f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0398991`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0398991, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->350120429,ExpressionUUID->"fc6ec60d-61b4-8f49-9f6a-473f86ddc044"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0010121`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "6272", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0010121, " seconds and ", 6272, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->111775248,ExpressionUUID->"a10bea41-f2d1-4b42-88e6-a74126d17296"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"STensor\\\" \
in \"\>", "\[InvisibleSpace]", "0.0080845`5.359198158869407", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor\" in ", 
   0.0080845`5.359198158869407, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->437417143,ExpressionUUID->"510219eb-8818-7741-9843-e2ce11f92458"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0398589`6.052070302649151", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"STensor\" in ", 0.0398589`6.052070302649151, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->469430664,ExpressionUUID->"53d1e516-ca32-8944-81be-d08ed0b1dfe6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"STensor2\\\" in \"\>", "\[InvisibleSpace]", "0.0216992`5.787988716192886",
    "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor2\" in ", 
   0.0216992`5.787988716192886, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->578972231,ExpressionUUID->"b363ad00-210f-ec43-90f2-e56869bd0b2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor2\\\" in \"\>",
    "\[InvisibleSpace]", "0.0424593`6.079517823442689", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"STensor2\" in ", 0.0424593`6.079517823442689, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->135338848,ExpressionUUID->"c799d7cd-88ee-494b-95b1-948a4fa1ed82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"STensor3\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor3\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->293355344,ExpressionUUID->"848001e3-4dd8-0046-b76e-2a4d38aebd01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor3\\\" in \"\>",
    "\[InvisibleSpace]", "0.111328`6.498149400563466", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"STensor3\" in ", 0.111328`6.498149400563466, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->218691264,ExpressionUUID->"9122be20-6d2b-7c44-bfea-a5d7e0284ac8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"TrSTensor2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0157062`5.647616116877355", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"TrSTensor2\" in ", 
   0.0157062`5.647616116877355, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->376135526,ExpressionUUID->"6de9002b-dacd-de4c-b6be-73079961ca39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"TrSTensor2\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"TrSTensor2\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->240587259,ExpressionUUID->"c6b03cc4-f6d6-9c4a-b6d8-1abcda4f3c47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"TrSTensor3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0476346`6.129467516182319", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"TrSTensor3\" in ", 
   0.0476346`6.129467516182319, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->144715876,ExpressionUUID->"ac8db915-ddbe-d04b-ba48-9eb1054af674"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"TrSTensor3\\\" in \
\"\>", "\[InvisibleSpace]", "0.0219839`5.7936497333683805", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"TrSTensor3\" in ", 0.0219839`5.7936497333683805, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->70601928,ExpressionUUID->"1deea549-fa76-0144-b943-0d7d96a11996"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"qScalar\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"qScalar\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->18154891,ExpressionUUID->"8c12a389-ac42-6545-8007-a31bdfef0fae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"qScalar\\\" in \"\>", 
   "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"qScalar\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->43126696,ExpressionUUID->"60074146-3845-1847-a838-bbee91166cb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"QTensor\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"QTensor\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->495073566,ExpressionUUID->"0150fe0a-9e84-f64e-ab60-304b913d58fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"QTensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0.010167`5.458737817053013", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"QTensor\" in ", 0.010167`5.458737817053013, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->159200226,ExpressionUUID->"741b2427-4c17-7148-9162-f6d61ea724f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"QTensor2\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"QTensor2\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->200487353,ExpressionUUID->"ef65cb7a-93b6-a641-bca6-15773f60227d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"QTensor2\\\" in \"\>",
    "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"QTensor2\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->8702478,ExpressionUUID->"bd8b889f-4f91-2d4a-865f-6eaceeea9be9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"FluPerCond1\
\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerCond1\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->172649893,ExpressionUUID->"4fe3464e-6865-4040-88a1-c0ad5ae06890"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerCond1\\\" in \"\
\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FluPerCond1\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->126800601,ExpressionUUID->"9fd78614-2c3b-0d42-b952-c40fce41f0e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"FluPerCond2\
\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerCond2\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->231059603,ExpressionUUID->"63dadc47-10c8-0440-a634-19d211009b09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerCond2\\\" in \"\
\>", "\[InvisibleSpace]", "0.0161068`5.6585542595275", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FluPerCond2\" in ", 0.0161068`5.6585542595275, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->96965784,ExpressionUUID->"989a5ff9-33f9-774a-b33a-91427cd72a7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"rScalar\\\" \
in \"\>", "\[InvisibleSpace]", "0.0637665`6.256137573688474", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"rScalar\" in ", 
   0.0637665`6.256137573688474, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->164091347,ExpressionUUID->"c5a57999-383c-7947-be8b-46684911b324"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"rScalar\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0157688`5.649343638428706", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"rScalar\" in ", 0.0157688`5.649343638428706, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->321533382,ExpressionUUID->"3cc7f4d3-658a-264a-9d04-44511661f8e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"Pressure\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->113948126,ExpressionUUID->"e6db7e0d-e4bf-b947-830b-e0b65415c0da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"Pressure\\\" in \"\>",
    "\[InvisibleSpace]", "0.0158262`5.650921643219795", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"Pressure\" in ", 0.0158262`5.650921643219795, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->37494766,ExpressionUUID->"ca5c2e17-d0f7-2349-ace4-a0e5628c458a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"EnergyDensity\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->227469761,ExpressionUUID->"9a6897ff-f74c-7f4b-b60c-36f4043298cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"EnergyDensity\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"EnergyDensity\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->17195922,ExpressionUUID->"67c62d33-adb1-a142-8f65-fd7fdf527964"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"FlowProjector\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FlowProjector\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->298991709,ExpressionUUID->"181796be-c4f8-6949-9681-1742c9da6748"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FlowProjector\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FlowProjector\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->445450467,ExpressionUUID->"77d48fcc-8148-f041-94b6-f72d160e2ea1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"FluPerFlow\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerFlow\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->57078828,ExpressionUUID->"af042264-7cc5-524e-98ac-020f4c9ee482"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerFlow\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FluPerFlow\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->36305369,ExpressionUUID->"bf193314-d467-4e4f-8230-79eaf7d5824b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.1761855`6.69751515677114", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"IndicatrixFunction\" in ",
    0.1761855`6.69751515677114, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->112493357,ExpressionUUID->"045ff683-8ec5-d141-9855-62b4ccd5df26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \
\\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0158015`5.650243308982164", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"IndicatrixFunction\" in ", 
   0.0158015`5.650243308982164, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->411947965,ExpressionUUID->"303dff31-9f2d-b142-b5a5-18e26109b9ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"Pressure\" in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->246450641,ExpressionUUID->"78a18c4e-a49b-b74c-9476-96f95e474cb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"Pressure\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->167310006,ExpressionUUID->"56c9dc57-c56b-cb4f-8487-b203361d653d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"EnergyDensity\" in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->584567191,ExpressionUUID->"f5adf449-1516-c144-a244-8c042307e7f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"EnergyDensity\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->91275486,ExpressionUUID->"c034d5f4-2933-6943-a355-071e25a5b698"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "1.7031247`7.682791440953124", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"IndicatrixFunction\" in ", 1.7031247`7.682791440953124, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->339003983,ExpressionUUID->"4ccb74d7-44f2-9649-aaf5-cdb40c97ac9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0958683`6.43322001973901", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"IndicatrixFunction\" \
in ", 0.0958683`6.43322001973901, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->399424101,ExpressionUUID->"c6a7c3e6-f738-474d-8462-a625a5d3359c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"ThermoFluPerCond\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0261533`5.869071489046047", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"ThermoFluPerCond\" in ", 
   0.0261533`5.869071489046047, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->5443454,ExpressionUUID->"3ba2a507-a070-3d42-9e02-507e1fe635de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"ThermoFluPerCond\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"ThermoFluPerCond\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->143232420,ExpressionUUID->"ba589069-efd0-6b4e-b2cd-08f38a6dc8e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"Pi\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"Pi\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->531126840,ExpressionUUID->"475175a3-fda3-614e-88b4-3b6e371f5092"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"Pressure\\\" in \"\>",
    "\[InvisibleSpace]", "0.0056392`5.2027624910557915", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"Pressure\" in ", 0.0056392`5.2027624910557915, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->304504417,ExpressionUUID->"69136f36-e27b-6044-9943-cb7f28fe83c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"Pi\\\" in \"\>", "\[InvisibleSpace]", 
   "0.2694039`6.88194887195131", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"Pi\" in ", 0.2694039`6.88194887195131, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->351890261,ExpressionUUID->"c67b6075-23a0-df46-84a6-0501f7e676ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"Pi\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"Pi\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->125088117,ExpressionUUID->"8425dbb9-61aa-a749-af71-a163783f2f3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495968", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"IndicatrixFunction\" in ", 0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->35410674,ExpressionUUID->"bb0f373b-1528-fa44-be82-fbbe25a34349"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0793432`6.351054705569527", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"IndicatrixFunction\" \
in ", 0.0793432`6.351054705569527, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->248783509,ExpressionUUID->"53321233-11fa-0649-8a5b-d43602a2618b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"GenericIdealGasCond\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0159216`5.6535317023910405", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"GenericIdealGasCond\" in \
", 0.0159216`5.6535317023910405, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->29135077,ExpressionUUID->"96cdc918-2736-f644-9e81-af23921ece06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"GenericIdealGasCond\\\
\" in \"\>", "\[InvisibleSpace]", "4.3400026`8.089034983184824", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"GenericIdealGasCond\" in ", 
   4.3400026`8.089034983184824, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->148177168,ExpressionUUID->"83c0bed7-dc1d-8647-9bdb-726f0d2515a4"]
}, Open  ]],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[4]=",
 CellID->253029733,ExpressionUUID->"efb55393-55ee-bc46-8893-ab0068eef001"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"e20ebaae-d68f-d045-a21c-a9c00bf8c49c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"7ed148d9-7c12-a648-8425-68b2a044b55e"],
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "8aeadb87-2b6a-b84d-a2bf-deb4854cb742"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->3691380,ExpressionUUID->"e66a2094-a6b4-894f-856f-b177c07ccbb4"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"3596ada1-b411-c54d-95d1-8a7ca97b09ba"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f9912d11-f02c-774b-ac96-5da5bd86fbb0"],
 "PSimplify",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "27ef3a95-63e3-134a-a58d-5ca12092212e"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->332337614,ExpressionUUID->"5c92ee3d-e944-5a43-9c79-4197afed6172"],

Cell[TextData[{
 "This option allows us to choose a function that is applied to expressions \
in computations. By default, it coincides with the value of ",
 Cell[BoxData[
  StyleBox["$CVSimplify", "Input"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "fb72495a-8470-7346-a807-85122b2d59a3"],
 ":"
}], "ExampleText",
 CellID->8693097,ExpressionUUID->"56f5ce6f-b647-1843-9083-9029cd199e8d"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->111291632,ExpressionUUID->"36d1b5f5-5634-e341-aecd-e31a0a66e462"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GenericIdealGasQ", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"\"\<Vector\>\"", "->", "u"}], ",", 
   RowBox[{"PSimplify", "->", "FullSimplify"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->226448609,ExpressionUUID->"5dd9b636-3c88-6741-8f30-0bf4598c4059"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->4381773,ExpressionUUID->"395925f5-21aa-f847-96ab-5aed306ae591"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->468564936,ExpressionUUID->"b82f2f33-a596-294c-9094-5214dcaebf41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->8416077,ExpressionUUID->"4b1d3b80-afa5-dc49-9b91-c02376eee6fc"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->287569964,ExpressionUUID->"75352f50-ec56-5440-a380-dbd3e669979a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->186032408,ExpressionUUID->"31d76d92-4358-6544-8922-707f69408682"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->197208557,ExpressionUUID->"3c0d79a3-7ed4-474b-9a19-7431c2062783"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->252828300,ExpressionUUID->"be275562-ae20-e54f-8067-75ed26ec8b22"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->344712582,ExpressionUUID->"457a50a4-7bd1-6947-a5e4-76cf2b08857e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->62174048,ExpressionUUID->"a9d933f6-b324-5848-98c7-d3d364aa39c1"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->243830245,ExpressionUUID->"ce2e579c-30a8-3840-a9ef-2a4233c7b133"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->152924455,ExpressionUUID->"9925e00e-1eb7-714b-bff5-7481f78138d1"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->707481,ExpressionUUID->"100061fe-08e1-1747-a14d-fb4b95bcf06e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->410106915,ExpressionUUID->"3792736f-e434-3d42-8e3d-cc3f0eaeff90"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->395484257,ExpressionUUID->"538d57c2-9d8a-6148-a2fd-2841e274f904"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->262075961,ExpressionUUID->"25f7b147-36e3-f640-a954-95146d295c57"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->83157414,ExpressionUUID->"92e4db8a-d682-9c4b-b980-5ef54eddf1c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->79263625,ExpressionUUID->"abdeb6d1-a7e3-bb4f-8e4b-950bf64ae55c"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->178419785,ExpressionUUID->"6e4efcab-35c6-0c4c-9052-eeab70660c99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->156250142,ExpressionUUID->"b615f7d7-3886-8144-950e-1dadfb73efab"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->86986005,ExpressionUUID->"eec468c9-8c72-994e-9f66-ca3d443d69c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->25352390,ExpressionUUID->"1318cff6-2236-9a47-bf77-113e2f9c00aa"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->70339416,ExpressionUUID->"39fb1963-17ef-2d41-b21b-9c9b6dfb5352"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"STensor\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->505683421,ExpressionUUID->"52ac24ec-9462-0649-b118-1fca0f9858ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0.2386197`6.829251288857606", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"STensor\" in ", 0.2386197`6.829251288857606, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->58490764,ExpressionUUID->"70eea08f-fdea-0d41-85cf-9017b3e97f5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"STensor2\\\" in \"\>", "\[InvisibleSpace]", "0.0143943`5.609735543326315",
    "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor2\" in ", 
   0.0143943`5.609735543326315, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->61594084,ExpressionUUID->"2d54883e-4ca4-2a4a-97b1-6ac32fe25278"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor2\\\" in \"\>",
    "\[InvisibleSpace]", "0.171566`6.685976219459643", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"STensor2\" in ", 0.171566`6.685976219459643, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->32392535,ExpressionUUID->"25452184-5292-4f43-a2b2-585fbcd0610d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"STensor3\\\" in \"\>", "\[InvisibleSpace]", "0.0020048`4.753616047146045",
    "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor3\" in ", 
   0.0020048`4.753616047146045, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->270995444,ExpressionUUID->"c56c8696-63d7-7644-ada2-e9b46d046f5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor3\\\" in \"\>",
    "\[InvisibleSpace]", "0.1925262`6.736034832489405", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"STensor3\" in ", 0.1925262`6.736034832489405, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->302881164,ExpressionUUID->"cb276582-2713-834d-96a8-f1a31aa866d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"TrSTensor2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0209234`5.772177251189297", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"TrSTensor2\" in ", 
   0.0209234`5.772177251189297, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->56709698,ExpressionUUID->"3d09e98d-2acb-c44b-8ce9-a31eae080f91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"TrSTensor2\\\" in \
\"\>", "\[InvisibleSpace]", "0.0453328`6.107957537769627", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"TrSTensor2\" in ", 0.0453328`6.107957537769627, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->494538385,ExpressionUUID->"e878ba60-4ad3-b44b-bc40-a7670a09cb82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"TrSTensor3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0066275`5.272894729901102", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"TrSTensor3\" in ", 
   0.0066275`5.272894729901102, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->905926521,ExpressionUUID->"d795088a-ca94-ae43-a482-31c429567db3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"TrSTensor3\\\" in \
\"\>", "\[InvisibleSpace]", "0.0557824`6.198042189054075", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"TrSTensor3\" in ", 0.0557824`6.198042189054075, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->339420450,ExpressionUUID->"a318f073-4d2b-7440-a796-bcd1894effc2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"qScalar\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"qScalar\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->497758426,ExpressionUUID->"59920248-9174-6e41-8f04-836fe36b0651"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"qScalar\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0297688`5.9253063217979784", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"qScalar\" in ", 0.0297688`5.9253063217979784, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->415640200,ExpressionUUID->"7344aea1-2230-3f4a-8213-3be358f9d017"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"QTensor\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"QTensor\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->55901425,ExpressionUUID->"8efbebbc-204b-b343-91e7-1ced1b4eb17c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"QTensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0159183`5.653441678754319", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"QTensor\" in ", 0.0159183`5.653441678754319, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->367286107,ExpressionUUID->"508b3b3b-7dbe-084a-a4d1-6f28379fca67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"QTensor2\\\" in \"\>", "\[InvisibleSpace]", "0.0040124`5.054949215235537",
    "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"QTensor2\" in ", 
   0.0040124`5.054949215235537, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->6172145,ExpressionUUID->"e130fbd7-4a2a-b04d-a140-b0df3c2e52fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"QTensor2\\\" in \"\>",
    "\[InvisibleSpace]", "0.0383092`6.034848076327049", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"QTensor2\" in ", 0.0383092`6.034848076327049, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->306552290,ExpressionUUID->"df21fbf6-b248-5d46-9bac-656405613322"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"FluPerCond1\
\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerCond1\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->51623681,ExpressionUUID->"8817675c-75ad-4342-9b92-e19c766cc58e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerCond1\\\" in \"\
\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"FluPerCond1\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->5156549,ExpressionUUID->"dec5d152-0138-4443-a1e4-175d92f3985f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"FluPerCond2\
\\\" in \"\>", "\[InvisibleSpace]", "0.0053355`5.178720117737434", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerCond2\" in ", 
   0.0053355`5.178720117737434, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->80993030,ExpressionUUID->"2ec63ae7-ef16-d349-a21b-04aa511ab94e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerCond2\\\" in \"\
\>", "\[InvisibleSpace]", "0.0318654`5.9548643679579385", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"FluPerCond2\" in ", 0.0318654`5.9548643679579385,
    " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->494448348,ExpressionUUID->"794817ae-a95e-8b47-8830-5e617485e2d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"rScalar\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"rScalar\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->432679888,ExpressionUUID->"f36dfd04-97eb-db44-8716-5571165fda54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"rScalar\\\" in \"\>", 
   "\[InvisibleSpace]", "0.1543834`6.6401455947031165", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"rScalar\" in ", 0.1543834`6.6401455947031165, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->599613108,ExpressionUUID->"43ad3278-90f1-8849-a3be-b9265e897e1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"Pressure\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->230174956,ExpressionUUID->"0bd65419-9ede-f542-ab4e-94d22ef12db5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"Pressure\\\" in \"\>",
    "\[InvisibleSpace]", "0.0079647`5.352714415717456", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"Pressure\" in ", 0.0079647`5.352714415717456, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->751347965,ExpressionUUID->"0dba93a1-ead9-244e-9b6c-52be4ec0d248"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"EnergyDensity\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->228095518,ExpressionUUID->"0a3efeec-da96-6c4b-ab44-94dc70c9e33d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"EnergyDensity\\\" in \
\"\>", "\[InvisibleSpace]", "0.0449627`6.104397376125779", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"EnergyDensity\" in ", 
   0.0449627`6.104397376125779, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->310581139,ExpressionUUID->"8d681b76-ea50-e140-a508-e222cbededfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"FlowProjector\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FlowProjector\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->144579880,ExpressionUUID->"066e18cb-852a-be45-9d1b-7c7194d18329"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FlowProjector\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"FlowProjector\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->136613024,ExpressionUUID->"bd8d749b-3616-a348-92a4-269d04ba6f6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"FluPerFlow\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0020057`4.753810967998944", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerFlow\" in ", 
   0.0020057`4.753810967998944, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->253619995,ExpressionUUID->"cbcb58d4-a6bb-ca44-9e06-a3c0d2c55819"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerFlow\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"FluPerFlow\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->15818737,ExpressionUUID->"c1a0546e-5e84-ce46-aad2-86f1e160022f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0129934`5.565267801846098", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"IndicatrixFunction\" in ",
    0.0129934`5.565267801846098, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->292365057,ExpressionUUID->"67dd5b2c-8ca3-9644-8e16-53de662bb0da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \
\\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.080941`6.35971355915319", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"IndicatrixFunction\" in ", 
   0.080941`6.35971355915319, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->140218565,ExpressionUUID->"1903de1b-00db-8e4d-8506-0bc92e623c5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"Pressure\" in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->148720899,ExpressionUUID->"a25c120e-4f91-e24f-8059-6823168a3942"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", 
   "0.009433`5.426194827934696", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to the exterior derivative of metric concomitant \"Pressure\" in ", 
   0.009433`5.426194827934696, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->517175751,ExpressionUUID->"a914fa4c-a4c2-1549-9a4a-f243cb0693e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"EnergyDensity\" in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->167063583,ExpressionUUID->"39b804b6-6ded-8a40-b348-6d0bdbbce85c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", 
   "0.1433327`6.607890275376038", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to the exterior derivative of metric concomitant \"EnergyDensity\" in ", 
   0.1433327`6.607890275376038, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->492864053,ExpressionUUID->"0f7eff86-2928-8342-8782-aaf6b5e2dd02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0525585`6.17218795562192", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"IndicatrixFunction\" in ", 0.0525585`6.17218795562192, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->264847594,ExpressionUUID->"5c6f97a4-389a-ca43-84c6-73e21d25daaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.3421955`6.985819287602228", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to the exterior derivative of metric concomitant \"IndicatrixFunction\" \
in ", 0.3421955`6.985819287602228, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->390688241,ExpressionUUID->"0a3487b8-b242-9040-ae3e-f415ede3be03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"ThermoFluPerCond\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0180873`5.708918735446059", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"ThermoFluPerCond\" in ", 
   0.0180873`5.708918735446059, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->197138453,ExpressionUUID->"1d844688-2127-864f-8944-dfc623989e45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"ThermoFluPerCond\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"ThermoFluPerCond\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->423571210,ExpressionUUID->"974cbfc3-34af-ea4e-ae2a-740eee257cd1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"Pi\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"Pi\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->624832389,ExpressionUUID->"4a8e81d1-8a2d-cc44-8aa8-97720c6a1770"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"Pressure\\\" in \"\>",
    "\[InvisibleSpace]", "0.0137971`5.591332805524017", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"Pressure\" in ", 0.0137971`5.591332805524017, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->714298267,ExpressionUUID->"d5f5f78d-8bff-8b43-a22d-2577de9b5456"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"Pi\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0294315`5.920357390326194", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"Pi\" in ", 0.0294315`5.920357390326194, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->3183085,ExpressionUUID->"0764d592-c7a3-fc46-9e4d-ddb95828800c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"Pi\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0973002`6.4396587264550424", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to the exterior derivative of metric concomitant \"Pi\" in ", 
   0.0973002`6.4396587264550424, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->485784602,ExpressionUUID->"fbb531b5-0e4e-d24f-a3cf-0cb4357901ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"IndicatrixFunction\" in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->172518274,ExpressionUUID->"b2c0f128-682e-9c42-8847-95acb24b3f8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to the exterior derivative of metric concomitant \"IndicatrixFunction\" \
in ", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->196248669,ExpressionUUID->"d3de6da3-1131-df47-b201-edbb63f57a64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"GenericIdealGasCond\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"GenericIdealGasCond\" in \
", 0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->20950487,ExpressionUUID->"eb5a77f9-d5a5-8d47-a5e2-8f2a82c8d475"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"GenericIdealGasCond\\\
\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"GenericIdealGasCond\" in ", 0``7.451544993495973,
    " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->30553438,ExpressionUUID->"7b878b9c-0032-6842-856a-a3b99b705a97"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[2]=",
 CellID->780919801,ExpressionUUID->"74be44ee-8e44-264d-a4ee-e41b30900abd"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "3"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"66b2de22-e93d-084a-93b4-7b9a8c9c2cf4"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"5055d263-67f5-334b-8b6b-4cffd3b339ce"],
 "Verbose",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "4f732d00-3762-a645-8567-f841c1cd5030"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->80309467,ExpressionUUID->"674df9e5-9358-a940-bdc7-c75e8b4be97d"],

Cell["\<\
If we do not want to see the printed messages from xIdeal, we need to set \
this option to False:\
\>", "ExampleText",
 CellID->346332891,ExpressionUUID->"a8dd30ff-7d5f-9544-b013-cfafc504f3e8"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->292193654,ExpressionUUID->"2e8e5b18-227b-9140-af2c-046fa628ee47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GenericIdealGasQ", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"\"\<Vector\>\"", "->", "u"}], ",", 
   RowBox[{"Verbose", "->", "False"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->22056319,ExpressionUUID->"4830edcb-e89c-e64c-87c4-688e3e0006e1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[2]=",
 CellID->188912593,ExpressionUUID->"5ee3cd1e-e072-b145-b7e9-8bdc2f352456"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "3"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"a0986fbd-4a01-1b41-8565-\
11a03fa7a433"],

Cell[" ", "FooterCell",ExpressionUUID->"386a14df-b442-3f4e-9f98-0c8fb73c61bb"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 765.75},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GenericIdealGasQ",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "1" -> Closed, "2" -> Closed}, 
    "AllOptsTable" -> Closed, "NotesSection" -> Closed, 
    "ExampleSubsection" -> {
     "0" -> Closed, "1" -> Closed, "2" -> Closed, "3" -> Closed}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", "HeaderCoreAreaLink" -> {}, 
  "Metadata" -> {
   "built" -> "{2025, 6, 2, 11, 30, 45.7252349}", 
    "history" -> {"XX", "", "", ""}, "context" -> "xAct`xIdeal`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "x Ideal Symbol", "language" -> "en", "paclet" -> "xIdeal", "status" -> 
    "None", "summary" -> 
    "GenericIdealGasQ[metric, w] returns True if metric is of the generic \
ideal gas type. To do so, it needs an arbitrary unitary time-like vector w.", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "GenericIdealGasQ", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "GenericIdealGasQ", "type" -> "Symbol", "uri" -> 
    "xIdeal/ref/ConnectionTensor", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> 
  "14.0 for Microsoft Windows (64-bit) (December 12, 2023)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"80eaba8e-63cb-1245-99d5-049944415b4a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9784, 257, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"0b3dd7bb-3a56-c04e-81bd-e748285b6e68",
   CellTags->"PrimaryExamplesSection",
   CellID->621751721]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 151148, 3829}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[588, 21, 3318, 78, 57, "AnchorBarGrid",ExpressionUUID->"6af1d756-454a-d74e-9fb4-f2d9c7a13904",
 CellID->1],
Cell[3909, 101, 94, 0, 23, "ContextNameCell",ExpressionUUID->"aa59401b-85f7-d64f-9059-a7b7e23a8542"],
Cell[CellGroupData[{
Cell[4028, 105, 559, 14, 56, "ObjectNameGrid",ExpressionUUID->"908a2026-684e-3242-9647-f774108ebaab"],
Cell[4590, 121, 554, 11, 111, "Usage",ExpressionUUID->"a2159931-a5d4-b94b-80ee-7b568f1fe8e3",
 CellID->423578463]
}, Open  ]],
Cell[CellGroupData[{
Cell[5181, 137, 1907, 48, 37, "NotesSection",ExpressionUUID->"385d3ec3-b537-cf45-a3f2-d9610ead5236",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->467077136],
Cell[7091, 187, 128, 1, 70, "Notes",ExpressionUUID->"b53b1068-9abb-6147-a233-df4ca87d0b6f",
 CellID->354734344],
Cell[7222, 190, 2435, 61, 70, "3ColumnTableMod",ExpressionUUID->"1757023c-e90b-c445-b7e8-27e56da90159",
 CellID->27290970]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[9784, 257, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"0b3dd7bb-3a56-c04e-81bd-e748285b6e68",
 CellTags->"PrimaryExamplesSection",
 CellID->621751721],
Cell[11207, 296, 199, 3, 26, "Input",ExpressionUUID->"b2919055-af09-a14b-be3c-0b4135d3cfe7",
 CellID->19048104],
Cell[CellGroupData[{
Cell[11431, 303, 1397, 36, 30, "ExampleSection",ExpressionUUID->"8bca7bbe-d079-804a-a9e3-961a9ef0bd50",
 CellID->96541105],
Cell[CellGroupData[{
Cell[12853, 343, 1431, 37, 29, "ExampleSubsection",ExpressionUUID->"6f102aaf-3ba3-f745-be24-09625e9afba7",
 CellID->127660352],
Cell[14287, 382, 526, 13, 70, "ExampleText",ExpressionUUID->"9348b1e2-cbc6-644d-aa00-5099e90a8870",
 CellID->50967587],
Cell[14816, 397, 2193, 68, 70, "Input",ExpressionUUID->"2b4327f4-7a80-dd41-8f36-a130d1f7a737",
 CellID->140152022],
Cell[17012, 467, 152, 1, 70, "ExampleText",ExpressionUUID->"38cd4713-affd-de4b-be59-c3003428d5eb",
 CellID->536840932],
Cell[CellGroupData[{
Cell[17189, 472, 465, 14, 70, "Input",ExpressionUUID->"bf4a06d0-70f1-7d49-99a3-48ba15a12c5b",
 CellID->460319658],
Cell[17657, 488, 143, 3, 70, "Output",ExpressionUUID->"800d0c9f-5a59-e047-8466-b7c714829e67",
 CellID->375539115]
}, Open  ]],
Cell[17815, 494, 192, 5, 70, "ExampleText",ExpressionUUID->"b6b12992-e80a-1f4f-a1e6-2b9fd7d7b16d",
 CellID->205275238],
Cell[CellGroupData[{
Cell[18032, 503, 268, 6, 70, "Input",ExpressionUUID->"0993cb51-f9c7-c64c-b85a-ddcec0693eac",
 CellID->18878652],
Cell[CellGroupData[{
Cell[18325, 513, 376, 9, 70, "Print",ExpressionUUID->"c401f63e-f631-5144-94b8-6b974a41921e",
 CellID->199894610],
Cell[18704, 524, 172, 2, 70, "Print",ExpressionUUID->"1baa7a2e-8f4a-5d4b-9140-30962d517582",
 CellID->284379009],
Cell[18879, 528, 457, 12, 70, "Print",ExpressionUUID->"5ff49fef-05a6-594a-8b7b-fd65a1bfc3b8",
 CellID->321161971],
Cell[19339, 542, 172, 2, 70, "Print",ExpressionUUID->"c424d323-2a5e-8a49-8a2f-4027bfb36718",
 CellID->164480594],
Cell[19514, 546, 493, 13, 70, "Print",ExpressionUUID->"ed709dd5-cd2a-094c-aea7-54ab82076b55",
 CellID->80652402],
Cell[20010, 561, 367, 7, 70, "Print",ExpressionUUID->"95782fe6-6718-974d-ada9-9e32e17f159c",
 CellID->29876433],
Cell[20380, 570, 446, 8, 70, "Print",ExpressionUUID->"ac0a998d-a060-9243-ba0c-a8c744d23db1",
 CellID->711137987],
Cell[20829, 580, 465, 12, 70, "Print",ExpressionUUID->"8a89240d-fab7-254d-bc52-d81d9c819976",
 CellID->253945277],
Cell[21297, 594, 172, 2, 70, "Print",ExpressionUUID->"9e41980f-d9ca-8c43-9264-5669d3772005",
 CellID->166242698],
Cell[21472, 598, 443, 11, 70, "Print",ExpressionUUID->"39a8da1e-1363-6548-9fe8-e22bde25a2ea",
 CellID->556470339],
Cell[21918, 611, 172, 2, 70, "Print",ExpressionUUID->"4e962f94-d681-a844-b10a-6f9a00ebb1b9",
 CellID->392511631],
Cell[22093, 615, 328, 7, 70, "Print",ExpressionUUID->"d1eb534e-f2bd-3b45-a58c-4330d8d308d9",
 CellID->501934909],
Cell[22424, 624, 172, 2, 70, "Print",ExpressionUUID->"23fa652b-2c76-d84a-b6d3-61c7e4f295b8",
 CellID->309331836],
Cell[22599, 628, 492, 13, 70, "Print",ExpressionUUID->"05952651-2bf4-944e-8093-5b5944f7c52c",
 CellID->260337149],
Cell[23094, 643, 368, 7, 70, "Print",ExpressionUUID->"fbe45466-74f1-964b-af48-3a0663be05de",
 CellID->545297068],
Cell[23465, 652, 446, 8, 70, "Print",ExpressionUUID->"9fff255c-e473-024d-b1ca-8b068bf370a1",
 CellID->667279460],
Cell[23914, 662, 458, 8, 70, "Print",ExpressionUUID->"0f276c9b-bce0-c840-a03e-a9d812a7d594",
 CellID->132355864],
Cell[24375, 672, 470, 12, 70, "Print",ExpressionUUID->"64620144-3578-9e49-9e80-022f17d18a69",
 CellID->185958401],
Cell[24848, 686, 368, 7, 70, "Print",ExpressionUUID->"2002fd1f-ed89-454a-b89b-a5511dd16bf0",
 CellID->755067430],
Cell[25219, 695, 446, 8, 70, "Print",ExpressionUUID->"09e47af2-39b6-db42-bbf4-91dbfe9098ce",
 CellID->269169355],
Cell[25668, 705, 458, 8, 70, "Print",ExpressionUUID->"e8a8a7ba-ac18-8848-8699-9d21904dc21d",
 CellID->943414289],
Cell[26129, 715, 418, 11, 70, "Print",ExpressionUUID->"0c61f46f-e5d4-9e43-91ed-5aa1c857388e",
 CellID->429752402],
Cell[26550, 728, 368, 7, 70, "Print",ExpressionUUID->"94a88f93-481f-ae4b-b8c2-564934faa423",
 CellID->520052951],
Cell[26921, 737, 446, 8, 70, "Print",ExpressionUUID->"e508e391-aaf7-0d4a-a190-c336c2c24474",
 CellID->212592565],
Cell[27370, 747, 456, 8, 70, "Print",ExpressionUUID->"b53580ea-046d-394d-b324-56cfa19dc7ce",
 CellID->136856021],
Cell[27829, 757, 351, 8, 70, "Print",ExpressionUUID->"f30593f0-f8bf-dc4f-91c5-3a4f3cae16c4",
 CellID->62712626],
Cell[28183, 767, 368, 7, 70, "Print",ExpressionUUID->"b8a02e3c-92a0-3544-b405-3c45bce72f4e",
 CellID->173858095],
Cell[28554, 776, 444, 8, 70, "Print",ExpressionUUID->"47000cde-8e89-d844-b096-d2cf5432068b",
 CellID->2725631],
Cell[29001, 786, 456, 8, 70, "Print",ExpressionUUID->"a74dcaa3-2e4c-524d-94fd-0d6fa2c6f50e",
 CellID->200798782],
Cell[29460, 796, 486, 13, 70, "Print",ExpressionUUID->"2c7a0986-c81e-1b4b-bb73-60275df014b2",
 CellID->308429006],
Cell[29949, 811, 368, 7, 70, "Print",ExpressionUUID->"1db065f2-e4d1-d447-b6be-dae514e39aba",
 CellID->563856554],
Cell[30320, 820, 446, 8, 70, "Print",ExpressionUUID->"a10c897a-e32e-9e42-926a-bf394a0f5b75",
 CellID->342898314],
Cell[30769, 830, 458, 8, 70, "Print",ExpressionUUID->"1868b621-ec0d-2248-8d82-7c4070bb59e8",
 CellID->466911984],
Cell[31230, 840, 506, 10, 70, "Print",ExpressionUUID->"b5d382df-66da-6f4e-b949-992b6f61929a",
 CellID->126957635],
Cell[31739, 852, 606, 13, 70, "Print",ExpressionUUID->"1495bfd6-c6a2-1346-85e2-d478b0743fbe",
 CellID->111392664],
Cell[32348, 867, 506, 10, 70, "Print",ExpressionUUID->"d82b1a23-9b5e-194a-b3c0-bb4c16d2962c",
 CellID->902543726],
Cell[32857, 879, 603, 13, 70, "Print",ExpressionUUID->"675395b4-01d4-1a4f-9d24-66bb0e73f5dc",
 CellID->486418],
Cell[33463, 894, 492, 10, 70, "Print",ExpressionUUID->"cc2bf0e6-7f35-2749-9115-a5f5a3ddac63",
 CellID->226917783],
Cell[33958, 906, 608, 13, 70, "Print",ExpressionUUID->"ed3c0653-ad9c-df44-ab04-6bac6a14236b",
 CellID->339987587],
Cell[34569, 921, 510, 10, 70, "Print",ExpressionUUID->"55ff44bd-d2aa-c44b-8b61-15de8464e61a",
 CellID->381527907],
Cell[35082, 933, 610, 13, 70, "Print",ExpressionUUID->"7604fa21-c749-e145-8eba-fad4a514a039",
 CellID->298638005],
Cell[35695, 948, 507, 10, 70, "Print",ExpressionUUID->"74b55331-d8ad-3a42-99d3-006ec8493021",
 CellID->34293854],
Cell[36205, 960, 596, 13, 70, "Print",ExpressionUUID->"626029e0-9bec-ae49-baad-a94333fc6acf",
 CellID->183325057],
Cell[36804, 975, 489, 10, 70, "Print",ExpressionUUID->"0bbac675-39ae-0648-b19d-67a5bcddc438",
 CellID->38319385],
Cell[37296, 987, 608, 13, 70, "Print",ExpressionUUID->"9ecb3dc0-afc5-3c41-a7c7-34a441b7a248",
 CellID->506684129],
Cell[37907, 1002, 490, 10, 70, "Print",ExpressionUUID->"610814fb-a1b7-8a4e-85d2-9055ec3518ed",
 CellID->115157910],
Cell[38400, 1014, 592, 13, 70, "Print",ExpressionUUID->"09bf5f74-c802-c04e-a427-e95b47287ac7",
 CellID->648532840],
Cell[38995, 1029, 505, 10, 70, "Print",ExpressionUUID->"f565609a-cab0-a444-832b-6e094f9d386d",
 CellID->13871061],
Cell[39503, 1041, 608, 13, 70, "Print",ExpressionUUID->"e554af4d-2932-aa4e-a59f-ae0244179d7d",
 CellID->538874506],
Cell[40114, 1056, 511, 10, 70, "Print",ExpressionUUID->"06d5987e-beef-b748-baa5-4fde1e60e0f4",
 CellID->87018577],
Cell[40628, 1068, 598, 13, 70, "Print",ExpressionUUID->"5982ced8-02ff-6b4b-9c50-f369eb9de75c",
 CellID->569501031],
Cell[41229, 1083, 498, 10, 70, "Print",ExpressionUUID->"e87841c3-0da8-4c47-b63f-bbfb01c1afe8",
 CellID->818280550],
Cell[41730, 1095, 614, 13, 70, "Print",ExpressionUUID->"0cc9013b-066e-5243-922e-1e0cba49467f",
 CellID->224878284],
Cell[42347, 1110, 504, 10, 70, "Print",ExpressionUUID->"8b2a930f-2e72-664c-9018-ea96463eaf39",
 CellID->607431991],
Cell[42854, 1122, 606, 13, 70, "Print",ExpressionUUID->"e687a984-fb27-de43-a8b8-47a0143f3b3e",
 CellID->578716080],
Cell[43463, 1137, 491, 10, 70, "Print",ExpressionUUID->"87a25bb3-9329-2c49-8c9d-ee364b0d7476",
 CellID->11740360],
Cell[43957, 1149, 607, 13, 70, "Print",ExpressionUUID->"df2c6eac-1767-0441-bc11-32ab8c955f64",
 CellID->36517226],
Cell[44567, 1164, 501, 10, 70, "Print",ExpressionUUID->"871ba17e-69f1-5443-b608-22879596d5e3",
 CellID->75810382],
Cell[45071, 1176, 600, 13, 70, "Print",ExpressionUUID->"f9207f83-4687-7043-939a-e10a720aba79",
 CellID->7627517],
Cell[45674, 1191, 502, 10, 70, "Print",ExpressionUUID->"47cb3023-d906-7540-98a5-4c7588116a99",
 CellID->173497921],
Cell[46179, 1203, 602, 13, 70, "Print",ExpressionUUID->"5aadcfca-9a76-a946-9c8b-d0efc7414acb",
 CellID->545642348],
Cell[46784, 1218, 495, 10, 70, "Print",ExpressionUUID->"32eb0bda-5f4c-7d4f-80b9-ae829cd36182",
 CellID->32923112],
Cell[47282, 1230, 596, 13, 70, "Print",ExpressionUUID->"4b85fbc3-ada3-a64a-86b5-693d0fcf5c12",
 CellID->366506641],
Cell[47881, 1245, 524, 10, 70, "Print",ExpressionUUID->"aebeb264-59f6-d645-88ca-3754b36c3c6f",
 CellID->290908732],
Cell[48408, 1257, 626, 13, 70, "Print",ExpressionUUID->"b9ad883f-6026-a740-95c4-3217605d2285",
 CellID->376994840],
Cell[49037, 1272, 544, 10, 70, "Print",ExpressionUUID->"2746cbff-f667-184a-9a6e-28d1a48be864",
 CellID->244370128],
Cell[49584, 1284, 646, 13, 70, "Print",ExpressionUUID->"14bd902f-a5e7-8a47-af12-1e64b9cf1922",
 CellID->375307823],
Cell[50233, 1299, 554, 10, 70, "Print",ExpressionUUID->"ec7239e8-d0d6-e042-88f1-f1dff5a76457",
 CellID->389923481],
Cell[50790, 1311, 656, 13, 70, "Print",ExpressionUUID->"e0b0fa5c-5b34-ec4c-9063-be57ebe28ad1",
 CellID->176225150],
Cell[51449, 1326, 575, 10, 70, "Print",ExpressionUUID->"ea2f9054-f1f4-ae41-a5e8-2a803d5be2ea",
 CellID->35566531],
Cell[52027, 1338, 664, 13, 70, "Print",ExpressionUUID->"f7cc6f58-bdd1-dc41-a1da-b05014ee54d4",
 CellID->811172667],
Cell[52694, 1353, 520, 10, 70, "Print",ExpressionUUID->"d71620d0-f084-1543-a5d0-3d84cca62e04",
 CellID->1175063],
Cell[53217, 1365, 608, 13, 70, "Print",ExpressionUUID->"d5f0e64d-1f21-0c4e-ad67-71c2be8cd1a0",
 CellID->634487167],
Cell[53828, 1380, 480, 10, 70, "Print",ExpressionUUID->"91c97701-d1e1-4a47-82a4-245479932a3a",
 CellID->467732218],
Cell[54311, 1392, 608, 13, 70, "Print",ExpressionUUID->"5a3ec029-ee1e-0244-a9ba-13b607758880",
 CellID->264036348],
Cell[54922, 1407, 546, 10, 70, "Print",ExpressionUUID->"e2473f9a-ad89-4547-81b8-7afe71aa7497",
 CellID->277476628],
Cell[55471, 1419, 634, 13, 70, "Print",ExpressionUUID->"ec747d47-2ed3-f14c-9352-655c0597cab8",
 CellID->387362823],
Cell[56108, 1434, 563, 10, 70, "Print",ExpressionUUID->"8a587e36-bb22-6c44-bd4d-b52c59ef882d",
 CellID->31539642],
Cell[56674, 1446, 664, 13, 70, "Print",ExpressionUUID->"9934a4b9-baac-1246-8e68-0ffed4589208",
 CellID->162930425],
Cell[57341, 1461, 512, 10, 70, "Print",ExpressionUUID->"0be9a9dc-8f30-a64c-93e4-b7327a2d1f1a",
 CellID->108005011],
Cell[57856, 1473, 627, 13, 70, "Print",ExpressionUUID->"38594236-bfdb-954d-b48b-626058793c0f",
 CellID->40378780]
}, Open  ]],
Cell[58498, 1489, 128, 2, 70, "Output",ExpressionUUID->"b174d2ad-08be-224f-abe2-1d5ddf2d875f",
 CellID->15434047]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[58890, 1502, 1411, 37, 30, "ExampleSection",ExpressionUUID->"cfb2b5e8-ae2a-8143-9abb-2fe82599e753",
 CellID->99653001],
Cell[CellGroupData[{
Cell[60326, 1543, 1454, 37, 70, "ExampleSubsection",ExpressionUUID->"b1f2cd23-bd9d-da4a-a49e-5d6c5ed98b99",
 CellID->847191],
Cell[61783, 1582, 754, 18, 70, "ExampleText",ExpressionUUID->"a1c08ac3-253a-b146-a7e5-fc952599c537",
 CellID->540994405],
Cell[62540, 1602, 203, 4, 70, "Input",ExpressionUUID->"2db132f3-a20d-444d-b9da-283c3fad36d4",
 CellID->22747195],
Cell[62746, 1608, 2708, 84, 70, "Input",ExpressionUUID->"bbab46c7-2c70-2640-b9ff-b1a26a36cb7c",
 CellID->575875497],
Cell[65457, 1694, 152, 1, 70, "ExampleText",ExpressionUUID->"0729ca5a-e996-6a4a-9488-1154fb3b43b4",
 CellID->420765059],
Cell[CellGroupData[{
Cell[65634, 1699, 538, 17, 70, "Input",ExpressionUUID->"8e970eef-388b-b04c-9859-f2b9dea5bcf3",
 CellID->255693001],
Cell[66175, 1718, 143, 3, 70, "Output",ExpressionUUID->"183139af-4a11-f145-bf0c-42d21e81d3bb",
 CellID->736350347]
}, Open  ]],
Cell[66333, 1724, 192, 5, 70, "ExampleText",ExpressionUUID->"cc9f09f9-c6d2-3b4a-ac51-f707a080b65d",
 CellID->255754560],
Cell[CellGroupData[{
Cell[66550, 1733, 268, 6, 70, "Input",ExpressionUUID->"f9ef527b-f292-2c45-8654-dca02e6d92e7",
 CellID->94237115],
Cell[CellGroupData[{
Cell[66843, 1743, 376, 9, 70, "Print",ExpressionUUID->"745cc4ba-f2d1-2449-bf8f-806968cb9c24",
 CellID->564816374],
Cell[67222, 1754, 172, 2, 70, "Print",ExpressionUUID->"b33d76f0-babf-2d4e-9d11-293f786e513a",
 CellID->112309591],
Cell[67397, 1758, 457, 12, 70, "Print",ExpressionUUID->"bd81d0b1-9c51-ff4e-915d-026ab39c0ba3",
 CellID->183393588],
Cell[67857, 1772, 172, 2, 70, "Print",ExpressionUUID->"4cc5429e-c3b1-654d-911a-0aed613ecfd4",
 CellID->299176215],
Cell[68032, 1776, 494, 13, 70, "Print",ExpressionUUID->"c1596af5-5f7f-e048-b840-e0fd6dedb151",
 CellID->490702906],
Cell[68529, 1791, 368, 7, 70, "Print",ExpressionUUID->"f7d90876-029f-ed4c-bb2c-58fb797c564e",
 CellID->341035772],
Cell[68900, 1800, 445, 8, 70, "Print",ExpressionUUID->"8e40727a-a85b-584a-a302-615ce6337f08",
 CellID->77715002],
Cell[69348, 1810, 465, 12, 70, "Print",ExpressionUUID->"a2105557-0e0f-1a42-b8fc-9c38801cd2d7",
 CellID->390864081],
Cell[69816, 1824, 169, 2, 70, "Print",ExpressionUUID->"1a340f78-ddb3-604c-8914-51b9698f0bfc",
 CellID->706286],
Cell[69988, 1828, 443, 11, 70, "Print",ExpressionUUID->"ba8eaecb-5f9a-0648-b82c-9a0d8022e244",
 CellID->417861246],
Cell[70434, 1841, 172, 2, 70, "Print",ExpressionUUID->"fead5d18-d721-e44c-8597-021bc778bb65",
 CellID->123829111],
Cell[70609, 1845, 328, 7, 70, "Print",ExpressionUUID->"cdd84de8-bcee-be49-949f-af4ef4c7adf2",
 CellID->127916646],
Cell[70940, 1854, 172, 2, 70, "Print",ExpressionUUID->"f3a20dfb-e2f0-674d-950a-364be78f3fd3",
 CellID->314722725],
Cell[71115, 1858, 491, 13, 70, "Print",ExpressionUUID->"558e1b93-bf40-404c-be06-7367c5a52a39",
 CellID->68259005],
Cell[71609, 1873, 368, 7, 70, "Print",ExpressionUUID->"c6a7184e-7108-9549-b92d-c8e4e1f18145",
 CellID->311557775],
Cell[71980, 1882, 446, 8, 70, "Print",ExpressionUUID->"cca72965-3db4-4b41-a734-3c22606c2f47",
 CellID->364414901],
Cell[72429, 1892, 456, 8, 70, "Print",ExpressionUUID->"a1d15822-4cb2-8347-a025-6fbb88aaa7d7",
 CellID->799249401],
Cell[72888, 1902, 469, 12, 70, "Print",ExpressionUUID->"2deca3a7-9f28-1d41-94fc-cabb86dfd690",
 CellID->98365936],
Cell[73360, 1916, 367, 7, 70, "Print",ExpressionUUID->"a80259fd-4ba5-204a-8199-8ccff6e6a0d1",
 CellID->29929570],
Cell[73730, 1925, 446, 8, 70, "Print",ExpressionUUID->"2636b35a-f00b-384b-bb5d-ba216de35de2",
 CellID->228444079],
Cell[74179, 1935, 458, 8, 70, "Print",ExpressionUUID->"751eea4a-7766-1841-bd88-6e17642a5da0",
 CellID->175956674],
Cell[74640, 1945, 418, 11, 70, "Print",ExpressionUUID->"f4f0d0c5-899c-c44d-bc73-89e7f40f8641",
 CellID->398757780],
Cell[75061, 1958, 368, 7, 70, "Print",ExpressionUUID->"db45f728-d3a2-704a-8e2b-f31d7272c512",
 CellID->182238272],
Cell[75432, 1967, 446, 8, 70, "Print",ExpressionUUID->"67313aab-8057-c144-ae76-451d61b8cf8f",
 CellID->221277073],
Cell[75881, 1977, 458, 8, 70, "Print",ExpressionUUID->"ba5e031b-f8d6-e141-bc1e-826e4779a78d",
 CellID->306478107],
Cell[76342, 1987, 351, 8, 70, "Print",ExpressionUUID->"37c149e4-b687-f744-90e2-6810fd7c9c8f",
 CellID->65902239],
Cell[76696, 1997, 368, 7, 70, "Print",ExpressionUUID->"fefd9ff5-460e-5f42-ae20-f6520e7f9b80",
 CellID->208605351],
Cell[77067, 2006, 444, 8, 70, "Print",ExpressionUUID->"50d48530-afa1-8045-9621-6a9b44bd9d5b",
 CellID->7137331],
Cell[77514, 2016, 455, 8, 70, "Print",ExpressionUUID->"08053003-88f7-de4c-98fd-12fab63d7ee2",
 CellID->65568651],
Cell[77972, 2026, 485, 13, 70, "Print",ExpressionUUID->"3521e734-f579-694e-81e9-b5b36719c07c",
 CellID->49699043],
Cell[78460, 2041, 367, 7, 70, "Print",ExpressionUUID->"0bb6c660-22cf-4642-b701-b89bab8a735f",
 CellID->22292850],
Cell[78830, 2050, 446, 8, 70, "Print",ExpressionUUID->"fc6ec60d-61b4-8f49-9f6a-473f86ddc044",
 CellID->350120429],
Cell[79279, 2060, 456, 8, 70, "Print",ExpressionUUID->"a10bea41-f2d1-4b42-88e6-a74126d17296",
 CellID->111775248],
Cell[79738, 2070, 504, 10, 70, "Print",ExpressionUUID->"510219eb-8818-7741-9843-e2ce11f92458",
 CellID->437417143],
Cell[80245, 2082, 606, 13, 70, "Print",ExpressionUUID->"53d1e516-ca32-8944-81be-d08ed0b1dfe6",
 CellID->469430664],
Cell[80854, 2097, 506, 10, 70, "Print",ExpressionUUID->"b363ad00-210f-ec43-90f2-e56869bd0b2e",
 CellID->578972231],
Cell[81363, 2109, 608, 13, 70, "Print",ExpressionUUID->"c799d7cd-88ee-494b-95b1-948a4fa1ed82",
 CellID->135338848],
Cell[81974, 2124, 492, 10, 70, "Print",ExpressionUUID->"848001e3-4dd8-0046-b76e-2a4d38aebd01",
 CellID->293355344],
Cell[82469, 2136, 606, 13, 70, "Print",ExpressionUUID->"9122be20-6d2b-7c44-bfea-a5d7e0284ac8",
 CellID->218691264],
Cell[83078, 2151, 510, 10, 70, "Print",ExpressionUUID->"6de9002b-dacd-de4c-b6be-73079961ca39",
 CellID->376135526],
Cell[83591, 2163, 596, 13, 70, "Print",ExpressionUUID->"c6b03cc4-f6d6-9c4a-b6d8-1abcda4f3c47",
 CellID->240587259],
Cell[84190, 2178, 510, 10, 70, "Print",ExpressionUUID->"ac8db915-ddbe-d04b-ba48-9eb1054af674",
 CellID->144715876],
Cell[84703, 2190, 611, 13, 70, "Print",ExpressionUUID->"1deea549-fa76-0144-b943-0d7d96a11996",
 CellID->70601928],
Cell[85317, 2205, 489, 10, 70, "Print",ExpressionUUID->"8c12a389-ac42-6545-8007-a31bdfef0fae",
 CellID->18154891],
Cell[85809, 2217, 591, 13, 70, "Print",ExpressionUUID->"60074146-3845-1847-a838-bbee91166cb9",
 CellID->43126696],
Cell[86403, 2232, 490, 10, 70, "Print",ExpressionUUID->"0150fe0a-9e84-f64e-ab60-304b913d58fe",
 CellID->495073566],
Cell[86896, 2244, 604, 13, 70, "Print",ExpressionUUID->"741b2427-4c17-7148-9162-f6d61ea724f3",
 CellID->159200226],
Cell[87503, 2259, 492, 10, 70, "Print",ExpressionUUID->"ef65cb7a-93b6-a641-bca6-15773f60227d",
 CellID->200487353],
Cell[87998, 2271, 592, 13, 70, "Print",ExpressionUUID->"bd8b889f-4f91-2d4a-865f-6eaceeea9be9",
 CellID->8702478],
Cell[88593, 2286, 498, 10, 70, "Print",ExpressionUUID->"4fe3464e-6865-4040-88a1-c0ad5ae06890",
 CellID->172649893],
Cell[89094, 2298, 598, 13, 70, "Print",ExpressionUUID->"9fd78614-2c3b-0d42-b952-c40fce41f0e4",
 CellID->126800601],
Cell[89695, 2313, 498, 10, 70, "Print",ExpressionUUID->"63dadc47-10c8-0440-a634-19d211009b09",
 CellID->231059603],
Cell[90196, 2325, 607, 13, 70, "Print",ExpressionUUID->"989a5ff9-33f9-774a-b33a-91427cd72a7f",
 CellID->96965784],
Cell[90806, 2340, 504, 10, 70, "Print",ExpressionUUID->"c5a57999-383c-7947-be8b-46684911b324",
 CellID->164091347],
Cell[91313, 2352, 606, 13, 70, "Print",ExpressionUUID->"3cc7f4d3-658a-264a-9d04-44511661f8e6",
 CellID->321533382],
Cell[91922, 2367, 492, 10, 70, "Print",ExpressionUUID->"e6db7e0d-e4bf-b947-830b-e0b65415c0da",
 CellID->113948126],
Cell[92417, 2379, 607, 13, 70, "Print",ExpressionUUID->"ca5c2e17-d0f7-2349-ace4-a0e5628c458a",
 CellID->37494766],
Cell[93027, 2394, 502, 10, 70, "Print",ExpressionUUID->"9a6897ff-f74c-7f4b-b60c-36f4043298cd",
 CellID->227469761],
Cell[93532, 2406, 601, 13, 70, "Print",ExpressionUUID->"67c62d33-adb1-a142-8f65-fd7fdf527964",
 CellID->17195922],
Cell[94136, 2421, 502, 10, 70, "Print",ExpressionUUID->"181796be-c4f8-6949-9681-1742c9da6748",
 CellID->298991709],
Cell[94641, 2433, 602, 13, 70, "Print",ExpressionUUID->"77d48fcc-8148-f041-94b6-f72d160e2ea1",
 CellID->445450467],
Cell[95246, 2448, 495, 10, 70, "Print",ExpressionUUID->"af042264-7cc5-524e-98ac-020f4c9ee482",
 CellID->57078828],
Cell[95744, 2460, 595, 13, 70, "Print",ExpressionUUID->"bf193314-d467-4e4f-8230-79eaf7d5824b",
 CellID->36305369],
Cell[96342, 2475, 524, 10, 70, "Print",ExpressionUUID->"045ff683-8ec5-d141-9855-62b4ccd5df26",
 CellID->112493357],
Cell[96869, 2487, 626, 13, 70, "Print",ExpressionUUID->"303dff31-9f2d-b142-b5a5-18e26109b9ba",
 CellID->411947965],
Cell[97498, 2502, 544, 10, 70, "Print",ExpressionUUID->"78a18c4e-a49b-b74c-9476-96f95e474cb9",
 CellID->246450641],
Cell[98045, 2514, 646, 13, 70, "Print",ExpressionUUID->"56c9dc57-c56b-cb4f-8487-b203361d653d",
 CellID->167310006],
Cell[98694, 2529, 554, 10, 70, "Print",ExpressionUUID->"f5adf449-1516-c144-a244-8c042307e7f0",
 CellID->584567191],
Cell[99251, 2541, 655, 13, 70, "Print",ExpressionUUID->"c034d5f4-2933-6943-a355-071e25a5b698",
 CellID->91275486],
Cell[99909, 2556, 578, 10, 70, "Print",ExpressionUUID->"4ccb74d7-44f2-9649-aaf5-cdb40c97ac9a",
 CellID->339003983],
Cell[100490, 2568, 676, 13, 70, "Print",ExpressionUUID->"c6a7c3e6-f738-474d-8462-a625a5d3359c",
 CellID->399424101],
Cell[101169, 2583, 520, 10, 70, "Print",ExpressionUUID->"3ba2a507-a070-3d42-9e02-507e1fe635de",
 CellID->5443454],
Cell[101692, 2595, 608, 13, 70, "Print",ExpressionUUID->"ba589069-efd0-6b4e-b2cd-08f38a6dc8e6",
 CellID->143232420],
Cell[102303, 2610, 480, 10, 70, "Print",ExpressionUUID->"475175a3-fda3-614e-88b4-3b6e371f5092",
 CellID->531126840],
Cell[102786, 2622, 610, 13, 70, "Print",ExpressionUUID->"69136f36-e27b-6044-9943-cb7f28fe83c8",
 CellID->304504417],
Cell[103399, 2637, 544, 10, 70, "Print",ExpressionUUID->"c67b6075-23a0-df46-84a6-0501f7e676ea",
 CellID->351890261],
Cell[103946, 2649, 634, 13, 70, "Print",ExpressionUUID->"8425dbb9-61aa-a749-af71-a163783f2f3a",
 CellID->125088117],
Cell[104583, 2664, 563, 10, 70, "Print",ExpressionUUID->"bb0f373b-1528-fa44-be82-fbbe25a34349",
 CellID->35410674],
Cell[105149, 2676, 678, 13, 70, "Print",ExpressionUUID->"53321233-11fa-0649-8a5b-d43602a2618b",
 CellID->248783509],
Cell[105830, 2691, 527, 10, 70, "Print",ExpressionUUID->"96cdc918-2736-f644-9e81-af23921ece06",
 CellID->29135077],
Cell[106360, 2703, 628, 13, 70, "Print",ExpressionUUID->"83c0bed7-dc1d-8647-9bdb-726f0d2515a4",
 CellID->148177168]
}, Open  ]],
Cell[107003, 2719, 130, 2, 70, "Output",ExpressionUUID->"efb55393-55ee-bc46-8893-ab0068eef001",
 CellID->253029733]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, Closed]]]],
Cell[CellGroupData[{
Cell[107397, 2732, 1412, 37, 24, "ExampleSection",ExpressionUUID->"e66a2094-a6b4-894f-856f-b177c07ccbb4",
 CellID->3691380],
Cell[CellGroupData[{
Cell[108834, 2773, 1425, 37, 70, "ExampleSubsection",ExpressionUUID->"5c92ee3d-e944-5a43-9c79-4197afed6172",
 CellID->332337614],
Cell[110262, 2812, 414, 9, 70, "ExampleText",ExpressionUUID->"56f5ce6f-b647-1843-9083-9029cd199e8d",
 CellID->8693097],
Cell[110679, 2823, 226, 4, 70, "Input",ExpressionUUID->"36d1b5f5-5634-e341-aecd-e31a0a66e462",
 CellID->111291632],
Cell[CellGroupData[{
Cell[110930, 2831, 323, 7, 70, "Input",ExpressionUUID->"5dd9b636-3c88-6741-8f30-0bf4598c4059",
 CellID->226448609],
Cell[CellGroupData[{
Cell[111278, 2842, 374, 9, 70, "Print",ExpressionUUID->"395925f5-21aa-f847-96ab-5aed306ae591",
 CellID->4381773],
Cell[111655, 2853, 172, 2, 70, "Print",ExpressionUUID->"b82f2f33-a596-294c-9094-5214dcaebf41",
 CellID->468564936],
Cell[111830, 2857, 455, 12, 70, "Print",ExpressionUUID->"4b1d3b80-afa5-dc49-9b91-c02376eee6fc",
 CellID->8416077],
Cell[112288, 2871, 172, 2, 70, "Print",ExpressionUUID->"75352f50-ec56-5440-a380-dbd3e669979a",
 CellID->287569964],
Cell[112463, 2875, 494, 13, 70, "Print",ExpressionUUID->"31d76d92-4358-6544-8922-707f69408682",
 CellID->186032408],
Cell[112960, 2890, 172, 2, 70, "Print",ExpressionUUID->"3c0d79a3-7ed4-474b-9a19-7431c2062783",
 CellID->197208557],
Cell[113135, 2894, 465, 12, 70, "Print",ExpressionUUID->"be275562-ae20-e54f-8067-75ed26ec8b22",
 CellID->252828300],
Cell[113603, 2908, 172, 2, 70, "Print",ExpressionUUID->"457a50a4-7bd1-6947-a5e4-76cf2b08857e",
 CellID->344712582],
Cell[113778, 2912, 442, 11, 70, "Print",ExpressionUUID->"a9d933f6-b324-5848-98c7-d3d364aa39c1",
 CellID->62174048],
Cell[114223, 2925, 172, 2, 70, "Print",ExpressionUUID->"ce2e579c-30a8-3840-a9ef-2a4233c7b133",
 CellID->243830245],
Cell[114398, 2929, 328, 7, 70, "Print",ExpressionUUID->"9925e00e-1eb7-714b-bff5-7481f78138d1",
 CellID->152924455],
Cell[114729, 2938, 169, 2, 70, "Print",ExpressionUUID->"100061fe-08e1-1747-a14d-fb4b95bcf06e",
 CellID->707481],
Cell[114901, 2942, 492, 13, 70, "Print",ExpressionUUID->"3792736f-e434-3d42-8e3d-cc3f0eaeff90",
 CellID->410106915],
Cell[115396, 2957, 172, 2, 70, "Print",ExpressionUUID->"538d57c2-9d8a-6148-a2fd-2841e274f904",
 CellID->395484257],
Cell[115571, 2961, 470, 12, 70, "Print",ExpressionUUID->"25f7b147-36e3-f640-a954-95146d295c57",
 CellID->262075961],
Cell[116044, 2975, 171, 2, 70, "Print",ExpressionUUID->"92e4db8a-d682-9c4b-b980-5ef54eddf1c4",
 CellID->83157414],
Cell[116218, 2979, 417, 11, 70, "Print",ExpressionUUID->"abdeb6d1-a7e3-bb4f-8e4b-950bf64ae55c",
 CellID->79263625],
Cell[116638, 2992, 172, 2, 70, "Print",ExpressionUUID->"6e4efcab-35c6-0c4c-9052-eeab70660c99",
 CellID->178419785],
Cell[116813, 2996, 352, 8, 70, "Print",ExpressionUUID->"b615f7d7-3886-8144-950e-1dadfb73efab",
 CellID->156250142],
Cell[117168, 3006, 171, 2, 70, "Print",ExpressionUUID->"eec468c9-8c72-994e-9f66-ca3d443d69c0",
 CellID->86986005],
Cell[117342, 3010, 485, 13, 70, "Print",ExpressionUUID->"1318cff6-2236-9a47-bf77-113e2f9c00aa",
 CellID->25352390],
Cell[117830, 3025, 171, 2, 70, "Print",ExpressionUUID->"39fb1963-17ef-2d41-b21b-9c9b6dfb5352",
 CellID->70339416],
Cell[118004, 3029, 490, 10, 70, "Print",ExpressionUUID->"52ac24ec-9462-0649-b118-1fca0f9858ae",
 CellID->505683421],
Cell[118497, 3041, 613, 13, 70, "Print",ExpressionUUID->"70eea08f-fdea-0d41-85cf-9017b3e97f5f",
 CellID->58490764],
Cell[119113, 3056, 505, 10, 70, "Print",ExpressionUUID->"2d54883e-4ca4-2a4a-97b1-6ac32fe25278",
 CellID->61594084],
Cell[119621, 3068, 613, 13, 70, "Print",ExpressionUUID->"25452184-5292-4f43-a2b2-585fbcd0610d",
 CellID->32392535],
Cell[120237, 3083, 506, 10, 70, "Print",ExpressionUUID->"c56c8696-63d7-7644-ada2-e9b46d046f5f",
 CellID->270995444],
Cell[120746, 3095, 616, 13, 70, "Print",ExpressionUUID->"cb276582-2713-834d-96a8-f1a31aa866d8",
 CellID->302881164],
Cell[121365, 3110, 509, 10, 70, "Print",ExpressionUUID->"3d09e98d-2acb-c44b-8ce9-a31eae080f91",
 CellID->56709698],
Cell[121877, 3122, 618, 13, 70, "Print",ExpressionUUID->"e878ba60-4ad3-b44b-bc40-a7670a09cb82",
 CellID->494538385],
Cell[122498, 3137, 510, 10, 70, "Print",ExpressionUUID->"d795088a-ca94-ae43-a482-31c429567db3",
 CellID->905926521],
Cell[123011, 3149, 618, 13, 70, "Print",ExpressionUUID->"a318f073-4d2b-7440-a796-bcd1894effc2",
 CellID->339420450],
Cell[123632, 3164, 490, 10, 70, "Print",ExpressionUUID->"59920248-9174-6e41-8f04-836fe36b0651",
 CellID->497758426],
Cell[124125, 3176, 616, 13, 70, "Print",ExpressionUUID->"7344aea1-2230-3f4a-8213-3be358f9d017",
 CellID->415640200],
Cell[124744, 3191, 489, 10, 70, "Print",ExpressionUUID->"8efbebbc-204b-b343-91e7-1ced1b4eb17c",
 CellID->55901425],
Cell[125236, 3203, 614, 13, 70, "Print",ExpressionUUID->"508b3b3b-7dbe-084a-a4d1-6f28379fca67",
 CellID->367286107],
Cell[125853, 3218, 504, 10, 70, "Print",ExpressionUUID->"e130fbd7-4a2a-b04d-a140-b0df3c2e52fd",
 CellID->6172145],
Cell[126360, 3230, 616, 13, 70, "Print",ExpressionUUID->"df21fbf6-b248-5d46-9bac-656405613322",
 CellID->306552290],
Cell[126979, 3245, 497, 10, 70, "Print",ExpressionUUID->"8817675c-75ad-4342-9b92-e19c766cc58e",
 CellID->51623681],
Cell[127479, 3257, 604, 13, 70, "Print",ExpressionUUID->"dec5d152-0138-4443-a1e4-175d92f3985f",
 CellID->5156549],
Cell[128086, 3272, 511, 10, 70, "Print",ExpressionUUID->"2ec63ae7-ef16-d349-a21b-04aa511ab94e",
 CellID->80993030],
Cell[128600, 3284, 622, 13, 70, "Print",ExpressionUUID->"794817ae-a95e-8b47-8830-5e617485e2d9",
 CellID->494448348],
Cell[129225, 3299, 490, 10, 70, "Print",ExpressionUUID->"f36dfd04-97eb-db44-8716-5571165fda54",
 CellID->432679888],
Cell[129718, 3311, 616, 13, 70, "Print",ExpressionUUID->"43ad3278-90f1-8849-a3be-b9265e897e1f",
 CellID->599613108],
Cell[130337, 3326, 492, 10, 70, "Print",ExpressionUUID->"0bd65419-9ede-f542-ab4e-94d22ef12db5",
 CellID->230174956],
Cell[130832, 3338, 616, 13, 70, "Print",ExpressionUUID->"0dba93a1-ead9-244e-9b6c-52be4ec0d248",
 CellID->751347965],
Cell[131451, 3353, 502, 10, 70, "Print",ExpressionUUID->"0a3efeec-da96-6c4b-ab44-94dc70c9e33d",
 CellID->228095518],
Cell[131956, 3365, 624, 13, 70, "Print",ExpressionUUID->"8d681b76-ea50-e140-a508-e222cbededfe",
 CellID->310581139],
Cell[132583, 3380, 502, 10, 70, "Print",ExpressionUUID->"066e18cb-852a-be45-9d1b-7c7194d18329",
 CellID->144579880],
Cell[133088, 3392, 610, 13, 70, "Print",ExpressionUUID->"bd8d749b-3616-a348-92a4-269d04ba6f6b",
 CellID->136613024],
Cell[133701, 3407, 510, 10, 70, "Print",ExpressionUUID->"cbcb58d4-a6bb-ca44-9e06-a3c0d2c55819",
 CellID->253619995],
Cell[134214, 3419, 603, 13, 70, "Print",ExpressionUUID->"c1a0546e-5e84-ce46-aad2-86f1e160022f",
 CellID->15818737],
Cell[134820, 3434, 526, 10, 70, "Print",ExpressionUUID->"67dd5b2c-8ca3-9644-8e16-53de662bb0da",
 CellID->292365057],
Cell[135349, 3446, 630, 13, 70, "Print",ExpressionUUID->"1903de1b-00db-8e4d-8506-0bc92e623c5f",
 CellID->140218565],
Cell[135982, 3461, 544, 10, 70, "Print",ExpressionUUID->"a25c120e-4f91-e24f-8059-6823168a3942",
 CellID->148720899],
Cell[136529, 3473, 666, 13, 70, "Print",ExpressionUUID->"a914fa4c-a4c2-1549-9a4a-f243cb0693e5",
 CellID->517175751],
Cell[137198, 3488, 554, 10, 70, "Print",ExpressionUUID->"39b804b6-6ded-8a40-b348-6d0bdbbce85c",
 CellID->167063583],
Cell[137755, 3500, 678, 13, 70, "Print",ExpressionUUID->"0f7eff86-2928-8342-8782-aaf6b5e2dd02",
 CellID->492864053],
Cell[138436, 3515, 576, 10, 70, "Print",ExpressionUUID->"5c6f97a4-389a-ca43-84c6-73e21d25daaa",
 CellID->264847594],
Cell[139015, 3527, 686, 13, 70, "Print",ExpressionUUID->"0a3487b8-b242-9040-ae3e-f415ede3be03",
 CellID->390688241],
Cell[139704, 3542, 522, 10, 70, "Print",ExpressionUUID->"1d844688-2127-864f-8944-dfc623989e45",
 CellID->197138453],
Cell[140229, 3554, 616, 13, 70, "Print",ExpressionUUID->"974cbfc3-34af-ea4e-ae2a-740eee257cd1",
 CellID->423571210],
Cell[140848, 3569, 480, 10, 70, "Print",ExpressionUUID->"4a8e81d1-8a2d-cc44-8aa8-97720c6a1770",
 CellID->624832389],
Cell[141331, 3581, 616, 13, 70, "Print",ExpressionUUID->"d5f5f78d-8bff-8b43-a22d-2577de9b5456",
 CellID->714298267],
Cell[141950, 3596, 544, 10, 70, "Print",ExpressionUUID->"0764d592-c7a3-fc46-9e4d-ddb95828800c",
 CellID->3183085],
Cell[142497, 3608, 658, 13, 70, "Print",ExpressionUUID->"fbb531b5-0e4e-d24f-a3cf-0cb4357901ef",
 CellID->485784602],
Cell[143158, 3623, 564, 10, 70, "Print",ExpressionUUID->"b2c0f128-682e-9c42-8847-95acb24b3f8f",
 CellID->172518274],
Cell[143725, 3635, 672, 13, 70, "Print",ExpressionUUID->"d3de6da3-1131-df47-b201-edbb63f57a64",
 CellID->196248669],
Cell[144400, 3650, 511, 10, 70, "Print",ExpressionUUID->"eb5a77f9-d5a5-8d47-a5e2-8f2a82c8d475",
 CellID->20950487],
Cell[144914, 3662, 621, 13, 70, "Print",ExpressionUUID->"7b878b9c-0032-6842-856a-a3b99b705a97",
 CellID->30553438]
}, Open  ]],
Cell[145550, 3678, 129, 2, 70, "Output",ExpressionUUID->"74be44ee-8e44-264d-a4ee-e41b30900abd",
 CellID->780919801]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed]]]],
Cell[CellGroupData[{
Cell[145831, 3688, 1422, 37, 70, "ExampleSubsection",ExpressionUUID->"674df9e5-9358-a940-bdc7-c75e8b4be97d",
 CellID->80309467],
Cell[147256, 3727, 203, 4, 70, "ExampleText",ExpressionUUID->"a8dd30ff-7d5f-9544-b013-cfafc504f3e8",
 CellID->346332891],
Cell[147462, 3733, 226, 4, 70, "Input",ExpressionUUID->"2e8e5b18-227b-9140-af2c-046fa628ee47",
 CellID->292193654],
Cell[CellGroupData[{
Cell[147713, 3741, 313, 7, 70, "Input",ExpressionUUID->"4830edcb-e89c-e64c-87c4-688e3e0006e1",
 CellID->22056319],
Cell[148029, 3750, 129, 2, 70, "Output",ExpressionUUID->"5ee3cd1e-e072-b145-b7e9-8bdc2f352456",
 CellID->188912593]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "3"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[148515, 3764, 380, 11, 114, "SeeAlsoSection",ExpressionUUID->"a0986fbd-4a01-1b41-8565-11a03fa7a433"],
Cell[148898, 3777, 78, 0, 25, "FooterCell",ExpressionUUID->"386a14df-b442-3f4e-9f98-0c8fb73c61bb"]
}
]
*)

(* End of internal cache information *)

