(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     84632,       2182]
NotebookOptionsPosition[     70729,       1919]
NotebookOutlinePosition[     73139,       1979]
CellTagsIndexPosition[     73053,       1974]
WindowTitle->IsometryGroupDimension
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["X IDEAL SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "08fe2af8-9fb5-4d7f-8cda-7c4e81b4f4a4"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "78061f72-0d1d-4ff9-89be-bebdfc2190fc"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[Cell[BoxData[
     TagBox[
      ActionMenuBox[
       FrameBox[Cell[TextData[{
         "URL",
         " ",
         Cell[BoxData[
          GraphicsBox[
           {GrayLevel[0.66667], Thickness[0.13], 
            LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
           AspectRatio->1,
           ImageSize->20,
           PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
          "3dad8b95-64d8-42e1-9e36-d9a951818693"]
        }],ExpressionUUID->"6bc92f18-f13c-4280-a72c-84c5c30aac6c"],
        StripOnInput->False],{
       "\"xIdeal/ref/IsometryGroupDimension\"" :> None, 
        "\"Copy Wolfram Documentation Center URL\"" :> 
        Module[{DocumentationSearch`Private`nb$}, 
          DocumentationSearch`Private`nb$ = 
           NotebookPut[
            Notebook[{Cell["xIdeal/ref/IsometryGroupDimension"]}, Visible -> 
              DocumentationBuild`Make`Private`visible$19817]]; 
          SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
          FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
          NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
        "\"Copy web URL\"" :> 
        Module[{DocumentationSearch`Private`nb$}, 
          DocumentationSearch`Private`nb$ = 
           NotebookPut[
            Notebook[{
              Cell[BoxData[
                MakeBoxes[
                 Hyperlink[
                  "http://reference.wolfram.com/language/xIdeal/ref/\
IsometryGroupDimension.html"], StandardForm]], "Input", TextClipboardType -> 
                "PlainText"]}, Visible -> 
              DocumentationBuild`Make`Private`visible$19817]]; 
          SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
          FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
          NotebookClose[DocumentationSearch`Private`nb$]; Null], 
        "\"Go to web URL\"" :> 
        FrontEndExecute[{
          NotebookLocate[{
            URL[(If[TrueQ[False], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "xIdeal/ref/IsometryGroupDimension") <> ".html"], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"],
      MouseAppearanceTag["LinkHand"]]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "d721d936-5d18-4ffd-b767-3c520685b916"]], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "c1d8d5cb-6def-4de1-bcbe-713ea2f2eabf"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"70bf4929-f666-4b74-8866-2376626a85d8"],

Cell["xAct`xIdeal`", "ContextNameCell",ExpressionUUID->"89c6dc95-7120-4faf-ac0d-1a4d3efda1f5"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "IsometryGroupDimension", "ObjectName",ExpressionUUID->
      "d5a4beff-46ec-4bf3-9d37-6e046f4c9aaf"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"0d0909c8-2445-4b3f-a9bf-225d308b9331"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "ef299b5f-500c-49d4-a011-e0134ac91d6a"]
    }],ExpressionUUID->"a22f6da2-be92-4359-9c45-3f88ff3b215c"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"39d751cc-44e1-49e6-b00f-\
28aa1cd3215e"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"IsometryGroupDimension", "[", 
       RowBox[{"metric", ",", " ", "H"}], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "014e5640-3975-496f-a925-2c448bec97af"],
     " returns the dimension of the maximal isometry group admitted by  \
metric with connection tensor H."
    }],ExpressionUUID->"db31a1a5-5967-4326-aa0b-a5a628eef2ad"]}
  }]], "Usage",
 CellID->423578463,ExpressionUUID->"704642dd-fc46-49d6-a4d7-3e6a3a4110bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {-0.09851562499999922, 13.698515625}}]],
    ExpressionUUID->"46a72785-86f0-4a8f-9aa0-47f861ca8d6e"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"8755e12d-eff9-44c1-b30d-2bfb9ad56e25"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"ea4b86e9-5fcf-4de5-917a-d1d595ce020b"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"5f6435cc-d2f3-434b-ae91-1a5841b93414"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->1299517144,ExpressionUUID->"31c4a09b-7f1d-46dc-9fed-be622d06ca87"],

Cell["The following options can be given: ", "Notes",
 CellID->354734344,ExpressionUUID->"3e38f2a2-ece8-4172-96e9-95e8cfd7ac93"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "6fe57286-cd2c-4fd7-8f0f-bbc4930e2bd8"], 
    TemplateBox[{
      Cell[
       TextData["PSimplify"]], "paclet:xIdeal/ref/PSimplify", 
      "xIdeal Package Symbol"},
     "PackageLink",
     BaseStyle->"3ColumnTableMod"], "$CVSimplify", Cell["\<\
PSimplify is an option to choose the function used to simplify expressions.\
\>", "TableText",ExpressionUUID->"9b300815-4845-4a20-a995-ce7f4b05232b"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "5c3635d8-87c4-4d6c-9995-57b373be1788"], 
    TemplateBox[{
      Cell[
       TextData["Parallelize"]], "paclet:ref/Parallelize"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], 
    TemplateBox[{
      Cell[
       TextData["True"]], "paclet:ref/True"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Parallelize", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "10927653-edc5-4f2a-b343-0d43b8fb1f01"],
     " evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "27c29ff3-94eb-48be-93d2-e3df4e144a45"],
     " using automatic parallelization."
    }], "TableText",ExpressionUUID->"d69011f5-3ed1-4f80-ba71-cf9787c7baa6"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "1cfed5da-f1d3-421a-8427-4e79f1cb5dde"], 
    TemplateBox[{
      Cell[
       TextData["Verbose"]], "paclet:ref/Verbose"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], 
    TemplateBox[{
      Cell[
       TextData["True"]], "paclet:ref/True"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell["\<\
Verbose is a Boolean option for MakeRule, AutomaticRules and ToCanonical. \
Verbose->True gives lots of log-info about the internals of the calculation. \
Its default value is False.\
\>", "TableText",ExpressionUUID->"06403c68-da5e-43c2-971d-8084f24524d5"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {None, None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->27290970,ExpressionUUID->"c1a8586e-2966-4ba7-b5fd-8be12f543c26"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {4.321484375000001, 9.278515625}}]],
  ExpressionUUID->"13276122-d6f9-45e2-b084-b10aaccacb38"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"26398206-4109-476e-860c-d45a6a7e747c"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount",ExpressionUUID->
  "af0884f5-13ee-43f9-867e-9513a9a20e4d"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->122255542,ExpressionUUID->"abc9c414-39d6-4b60-8dc6-6d1bffccb6f7"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xIdeal`\>\"", "]"}]], "Input", "ExampleInitialization",
 Evaluatable->True,
 CellLabel->"In[1]:=",ExpressionUUID->"af827305-61d9-45a4-bd49-33f042ee4f28"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {4.485546875000001, 9.114453125}}]],
  ExpressionUUID->"37ac873c-e47b-4486-b418-1d304735496e"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"af50d570-d942-427c-b7a7-7ee9338bd5e2"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "29448988-c0dd-44ef-a070-e23604321204"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->722357294,ExpressionUUID->"6815db92-ff99-41eb-b527-0d28ded12af0"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.22960937500000078`, 13.370390625}}]],
  ExpressionUUID->"10c22138-9f04-474d-9c06-cbc39c462f75"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"031a4d38-cdbe-4c97-b1ec-effb96377187"],
 "Petrov homogeneous vacuum solution:",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "44cfe2b0-dd61-4541-8de4-dee6aa108625"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->500462958,ExpressionUUID->"aa439b9a-6144-4d69-b421-96278cd88ca4"],

Cell[TextData[{
 "Here, we will obtain the dimension of the maximal isometry group of Petrov \
homogeneous vacuum solution (see ",
 Cell[BoxData[
  TemplateBox[{
    Cell[
     TextData[
     "Petrov A Z 1962 Gravitational Field Geometry as the Geometry of \
Automorphisms (Recent Developments in General Relativity) (Pergamon) p 379"]],
     "https://dokumen.pub/recent-developments-in-general-relativity.html"},
   "WebLink",
   BaseStyle->{"ExampleText"}]],ExpressionUUID->
  "f6492c8e-36c6-43c5-b92a-3e8de3246fa7"],
 "). We start by defining the coordinates and the metric:"
}], "ExampleText",
 CellID->50967587,ExpressionUUID->"6df7e739-4964-4d43-9010-b3baa6da8e17"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "q"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"char", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"x", "[", "]"}], ",", 
      RowBox[{"y", "[", "]"}], ",", 
      RowBox[{"z", "[", "]"}]}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"kk", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<k\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{"kk", "\[Element]", " ", "Reals"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["E", 
           RowBox[{"x", "[", "]"}]]}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           SqrtBox["3"], 
           RowBox[{"x", "[", "]"}]}], "]"}]}], ",", "0", ",", "0", ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["E", 
           RowBox[{"x", "[", "]"}]]}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           SqrtBox["3"], 
           RowBox[{"x", "[", "]"}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        SuperscriptBox["E", 
         RowBox[{
          RowBox[{"-", "2"}], 
          RowBox[{"x", "[", "]"}]}]], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["E", 
           RowBox[{"x", "[", "]"}]]}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           SqrtBox["3"], 
           RowBox[{"x", "[", "]"}]}], "]"}]}], ",", "0", ",", "0", ",", 
        RowBox[{
         SuperscriptBox["E", 
          RowBox[{"x", "[", "]"}]], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           SqrtBox["3"], 
           RowBox[{"x", "[", "]"}]}], "]"}]}]}], "}"}]}], "}"}], "/", 
    SuperscriptBox["kk", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "char"}], ",", 
       RowBox[{"-", "char"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "char", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->140152022,ExpressionUUID->"e8f78712-0565-4320-af21-904c8522f1da"],

Cell[TextData[{
 "Now, we need to compute the connection tensor. To do so, we can use the ",
 StyleBox["ConnectionTensor", "Input"],
 " function:"
}], "ExampleText",
 CellID->205275238,ExpressionUUID->"83dd33b7-e231-4157-841b-130c326ac4eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"H", "=", 
  RowBox[{"ConnectionTensor", "[", "metric", "]"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->18878652,ExpressionUUID->"911e3a56-32f1-4879-97ac-006bf5fb9ef6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->169643559,ExpressionUUID->"d64c7a9c-24a8-4c5c-8425-84d1fa25e1e2"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1493375352,ExpressionUUID->"754dd09a-6c78-46ea-b464-f2f9649df13f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->980035558,ExpressionUUID->"27ca8f3f-6b0f-4f04-85be-6b67454f793f"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1951754814,ExpressionUUID->"7e26982f-7daa-49d6-b8aa-3586edebd89c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1065345077,ExpressionUUID->"291749bb-8d4b-4ef4-b548-986b0bdb1e82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000689`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000689, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1626579359,ExpressionUUID->"55d5761a-c67e-442f-905f-cde3d39e8374"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "7.323995`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 7.323995, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1372215500,ExpressionUUID->"c0e1aa29-fdcd-4fd0-b70a-43272d206060"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->423666428,ExpressionUUID->"1e1d2f09-a0df-4b2a-b74b-8d24015cb4ae"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1384741951,ExpressionUUID->"82bf3872-e1f0-4de5-a9d2-70ba8472985d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->781035457,ExpressionUUID->"a945f56f-7f6e-4408-9195-750eacfc8f88"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1993440569,ExpressionUUID->"b8bbdb29-a9e9-4653-9ff9-b4d35f0d7f36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->247923483,ExpressionUUID->"07d4a916-5118-43d3-ac79-123264322cff"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->158622753,ExpressionUUID->"7be47115-a6aa-418e-82c5-7b92eb1a78e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1025678119,ExpressionUUID->"65ebdfed-8d36-46a2-83ab-e1219e96ca4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000858`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000858, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->296387168,ExpressionUUID->"84afbd8a-5b3c-4c0e-981e-bcfcd7785ebc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.08222`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.08222, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1393172663,ExpressionUUID->"5a513779-5d61-4cd0-8c2f-a7f810ddf9fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001106`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "44384",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001106, " seconds and ", 44384, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1678870774,ExpressionUUID->"a933d596-8a6f-4e10-a052-0495ae3454be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1870879545,ExpressionUUID->"db5328ce-4476-462e-862d-fe08ff2b06ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.002805`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.002805, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1192894586,ExpressionUUID->"14e372be-1aaa-4568-887a-abbde1a9c064"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.078199`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.078199, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1320293819,ExpressionUUID->"f0d40828-4c04-453f-b33d-150307a8d760"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001136`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "29944",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001136, " seconds and ", 29944, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1130608833,ExpressionUUID->"ce20d223-776c-43a4-a19f-bba7321d69a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->281238445,ExpressionUUID->"32f7a4e4-9c5f-44dd-8ce8-58fdb410f641"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000176`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000176, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1998423734,ExpressionUUID->"3033e458-c293-45f3-b08b-7a0d769840ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.045963`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.045963, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->131037245,ExpressionUUID->"60d554e7-7f43-4447-88d7-01e54c090a56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000187`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000187, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->160945712,ExpressionUUID->"3e93904b-27d9-41e7-ad41-710872ec6c44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->949033189,ExpressionUUID->"a75679e3-43d3-4add-a1dc-86d8675476c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000083`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000083, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1912190941,ExpressionUUID->"6c7d9af8-fe90-4d14-8f87-732032cea0cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.040469`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.040469, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->959664899,ExpressionUUID->"09e956a9-72bd-4149-afdd-ef82e1b05bb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000262`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000262, " seconds and ", 64, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1402092899,ExpressionUUID->"ebc5a270-f4c6-4b67-9204-2d5e4c562270"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1778316645,ExpressionUUID->"7c0bb558-19e0-4f0e-9ae5-41df901b6459"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000642`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000642, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1129308458,ExpressionUUID->"72d6a952-79d4-4f15-bf38-faccbbf0c5a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.071429`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.071429, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->747984604,ExpressionUUID->"042b18db-b0ac-4336-8f30-1b0be58335b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001052`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "44384",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001052, " seconds and ", 44384, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->610868555,ExpressionUUID->"7993e1ab-979b-442f-b11c-f5bd651eea11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.091782`5.414302510566754", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.091782`5.414302510566754, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->933579624,ExpressionUUID->"05e7c913-e72b-48e9-9346-41cefbd63adc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.027922`4.8974915162528045", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.027922`4.8974915162528045, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1813329681,ExpressionUUID->"37ee4417-d5f4-4d63-a5ba-4bb5c50d24a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000893`3.4023964523845214", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.000893`3.4023964523845214, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->89964267,ExpressionUUID->"be6ab50f-8617-4d79-8f31-cf16ec260160"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.070526`5.299894246301438", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.070526`5.299894246301438, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1394638110,ExpressionUUID->"5fc3a1cb-570e-427f-bd66-e36824625c52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0.003694`4.019041884600194", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0.003694`4.019041884600194, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1038061533,ExpressionUUID->"73bf6d4c-02c2-418f-afd1-a9ae37d001b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.032392`4.961982757256328", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"G2Form\" in ", 0.032392`4.961982757256328, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->513630695,ExpressionUUID->"dc67ea56-9daf-4293-a6c3-fc66d23946b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.277369`5.894602914251766", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.277369`5.894602914251766, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->631896413,ExpressionUUID->"7d6ef0c0-83b8-45dc-92f1-134a92ffac45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.055887`5.198855790919814", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.055887`5.198855790919814, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1819096991,ExpressionUUID->"a312d40b-18c4-4f73-b287-df11f056b9d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.254631`5.857456269126936", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.254631`5.857456269126936, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->359587617,ExpressionUUID->"30a059ff-a082-434a-b4e1-15da4fce8849"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0.00003`1.9286662482156336", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.00003`1.9286662482156336, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->879819896,ExpressionUUID->"3f1f3cab-b3ed-4a39-a55e-0acdf5c8f701"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.022294`4.799732990288261", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.022294`4.799732990288261, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1977719744,ExpressionUUID->"bb60527e-93df-447a-bf1a-33bb827ff9ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.039614`5.049393690740443", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.039614`5.049393690740443, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1385265736,ExpressionUUID->"e83c304b-2405-43e3-952e-14611d5d4770"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.059723`5.227686608535598", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.059723`5.227686608535598, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1176207065,ExpressionUUID->"2664da8a-8026-4e6d-bc29-4c520ec2dc34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0.000253`2.854665514671791", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.000253`2.854665514671791, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1223408759,ExpressionUUID->"fa178071-3e8a-4770-94c6-29920a2bd4b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"scXtensor\\\" \
in \"\>", "\[InvisibleSpace]", "0.507652`6.157111095012394", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"scXtensor\" in ", 
   0.507652`6.157111095012394, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->916652863,ExpressionUUID->"4d6c0aea-0838-4aca-b22a-0628e7bd5ae5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"scXtensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0.046574`5.119688532337592", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"scXtensor\" in ", 0.046574`5.119688532337592, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->899602962,ExpressionUUID->"c828bc8a-73f7-4652-be58-62234d5123c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"scYtensor\\\" \
in \"\>", "\[InvisibleSpace]", "0.002983`3.926198246858034", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"scYtensor\" in ", 
   0.002983`3.926198246858034, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->268819697,ExpressionUUID->"b73304ef-c18e-4f53-bab0-927c1b8afd2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"scYtensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0.042962`5.084629484268147", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"scYtensor\" in ", 0.042962`5.084629484268147, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->89463034,ExpressionUUID->"dc6d308f-f887-4379-a900-768bbcf143e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"SelfDualPTIConnectionTensor\\\" in \"\>", "\[InvisibleSpace]", 
   "0.311335`5.944772939917106", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"SelfDualPTIConnectionTensor\
\" in ", 0.311335`5.944772939917106, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->2030211795,ExpressionUUID->"849f5dd2-2d88-4f9c-9c50-1de10b0e4fe3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \
\\\"SelfDualPTIConnectionTensor\\\" in \"\>", "\[InvisibleSpace]", 
   "0.074677`5.324731856206119", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"SelfDualPTIConnectionTensor\" in ", 
   0.074677`5.324731856206119, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->550058143,ExpressionUUID->"7c3e479f-75a2-4e0b-be4f-53712dbf1e4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"PTIConnectionTensor\\\" in \"\>", "\[InvisibleSpace]", 
   "0.001511`3.630809457834996", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"PTIConnectionTensor\" in ", 
   0.001511`3.630809457834996, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->2087886768,ExpressionUUID->"4c1860da-e814-4732-9001-54261132fa75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"PTIConnectionTensor\\\" \
in \"\>", "\[InvisibleSpace]", "0.000671`3.278267513664963", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"PTIConnectionTensor\" in ", 
   0.000671`3.278267513664963, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->13765393,ExpressionUUID->"056c6056-2c16-4f3b-88cb-682b9cffbd1f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              InterpretationBox[
               StyleBox["Cos",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cos,
               Editable->False], "[", 
              RowBox[{
               SqrtBox["3"], " ", 
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False]}], "]"}], "-", 
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}]}], ")"}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["k",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`kk,
             Editable->False], "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}]}], ")"}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["k",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`kk,
             Editable->False], "2"]}]], ",", "0", ",", "0", ",", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             InterpretationBox[
              StyleBox["x",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`x[],
              Editable->False]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SqrtBox["3"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{
                 SqrtBox["3"], " ", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}], ")"}]}], 
           RowBox[{"2", " ", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["k",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`kk,
              Editable->False], "2"]}]]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              RowBox[{
               SqrtBox["3"], " ", 
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False]}], "]"}]}], ")"}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["k",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`kk,
             Editable->False], "2"]}]], ",", "0", ",", "0"}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             InterpretationBox[
              StyleBox["x",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`x[],
              Editable->False]}]], 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["k",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`kk,
             Editable->False], "2"]]}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         FractionBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False]}]], 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["k",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`kk,
            Editable->False], "2"]], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              RowBox[{
               SqrtBox["3"], " ", 
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False]}], "]"}]}], ")"}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["k",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`kk,
             Editable->False], "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             InterpretationBox[
              StyleBox["x",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`x[],
              Editable->False]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SqrtBox["3"], " ", 
               RowBox[{
                InterpretationBox[
                 StyleBox["Cos",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 Cos,
                 Editable->False], "[", 
                RowBox[{
                 SqrtBox["3"], " ", 
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False]}], "]"}]}], "+", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}], ")"}]}], 
           RowBox[{"2", " ", 
            SuperscriptBox[
             InterpretationBox[
              StyleBox["k",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`kk,
              Editable->False], "2"]}]]}], ",", "0", ",", "0", ",", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              InterpretationBox[
               StyleBox["Cos",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cos,
               Editable->False], "[", 
              RowBox[{
               SqrtBox["3"], " ", 
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False]}], "]"}], "-", 
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}]}], ")"}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["k",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`kk,
             Editable->False], "2"]}]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{
              SqrtBox["3"], " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{
                SqrtBox["3"], " ", 
                InterpretationBox[
                 StyleBox["x",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`x[],
                 Editable->False]}], "]"}]}]}], ")"}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["k",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`kk,
             Editable->False], "2"]}]], ",", "0", ",", "0"}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "char"}], ",", 
     RowBox[{"-", "char"}], ",", 
     RowBox[{"-", "char"}]}], "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->711003855,ExpressionUUID->"a6522fdd-320a-467e-9699-7db347e37714"]
}, Open  ]],

Cell[TextData[{
 "Finally, we  use the ",
 StyleBox["IsometryGroupDimension", "Input"],
 " function:"
}], "ExampleText",
 CellID->82588054,ExpressionUUID->"8049e64a-5ab2-48ff-aec3-16baa890bf20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsometryGroupDimension", "[", 
  RowBox[{"metric", ",", "H"}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->63038074,ExpressionUUID->"af10933b-7442-4799-aeb5-3c25b8fe84dd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Connection Tensor concomitant \
\\\"C1\\\" in \"\>", "\[InvisibleSpace]", "0.124618`5.547125770458577", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Connection Tensor concomitant \"C1\" in ", 
   0.124618`5.547125770458577, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->889436309,ExpressionUUID->"880f51e1-dbbf-48da-a537-fb7125768d34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Connection Tensor concomitant \\\"C1\\\" in \
\"\>", "\[InvisibleSpace]", "0.007987`4.3539286779284465", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Connection Tensor concomitant \"C1\" in ", 
   0.007987`4.3539286779284465, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->1925956334,ExpressionUUID->"fc6f43db-4423-458e-a11c-8eade0758407"],

Cell[BoxData["\<\"\\!\\(\\*SubscriptBox[\\(G\\), \\(4\\)]\\)\"\>"], "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->1670668754,ExpressionUUID->"11ce7354-7da5-4f56-ad9c-7a87e4a1e371"]
}, Open  ]]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.06554687500000078, 13.534453125}}]],
  ExpressionUUID->"2aca11c2-546e-4ccb-a2d4-5fb2897284f9"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"599078c1-bb8c-4711-8728-e4a27d3fc2cd"],
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "f7f62d8d-3ee0-48cd-b9a1-61f8b7322fc9"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"3ac7a9bd-cbaa-4561-ab4f-2805e15beddc"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.3936718750000008, 13.206328125}}]],ExpressionUUID->
  "5f6ff5fc-0001-4e14-9424-8cd345699241"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"42b33274-65df-47bd-80c2-6d5388cb68ca"],
 "PSimplify",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "7a615907-b0ce-465e-bb5e-9fda710c97d3"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"b4a07b29-2de0-43ba-a863-063494a261e2"],

Cell[TextData[{
 "This option allows us to choose a function that is applied to expressions \
in computations. By default, it coincides with the value of ",
 Cell[BoxData[
  StyleBox["$CVSimplify", "Input"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "1a3377af-d239-4fba-920b-6f13a9eeafde"],
 ":"
}], "ExampleText",
 CellID->8693097,ExpressionUUID->"bd21673f-033b-45d6-a90d-92705689d280"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",\

 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->111291632,ExpressionUUID->"33289f98-5395-4be8-95cc-909f5eaced20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsometryGroupDimension", "[", 
  RowBox[{"metric", ",", "H", ",", " ", 
   RowBox[{"PSimplify", "->", "FullSimplify"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->245010494,ExpressionUUID->"7ae38f4e-cca0-4fe2-a207-74e3f34b4367"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Connection Tensor concomitant \
\\\"C1\\\" in \"\>", "\[InvisibleSpace]", "0.007445`4.323409695584168", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Connection Tensor concomitant \"C1\" in ", 
   0.007445`4.323409695584168, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->144045561,ExpressionUUID->"fdf2912c-ac07-4b19-9fa5-9412b5bd7262"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Connection Tensor concomitant \\\"C1\\\" in \
\"\>", "\[InvisibleSpace]", "0.01028`4.463538108155232", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Connection Tensor concomitant \"C1\" in ", 0.01028`4.463538108155232, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1556789331,ExpressionUUID->"67842538-fb6b-4863-9963-40cca7142bd7"],

Cell[BoxData["\<\"\\!\\(\\*SubscriptBox[\\(G\\), \\(4\\)]\\)\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->652493564,ExpressionUUID->"91be6c05-6fe1-42b1-bef3-7cbe6c85a346"]
}, Open  ]]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.3936718750000008, 13.206328125}}]],ExpressionUUID->
  "8dc1485c-706b-4041-8ee3-601cc3f68c68"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"55b42c06-ea0a-4a11-aef0-2c0363d4a3be"],
 "Verbose",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "22a7a8d2-ad86-4a07-8236-668faf948042"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"616d950c-0053-4529-89a6-9b3c82b0eaa0"],

Cell["\<\
If we do not want to see the printed messages from xIdeal, we need to set \
this option to False:\
\>", "ExampleText",
 CellID->346332891,ExpressionUUID->"59f3d7a8-b413-4660-a0c9-f58b38d25492"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",\

 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->292193654,ExpressionUUID->"ef46744a-ae04-4d3c-b550-8f35ad93d632"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsometryGroupDimension", "[", 
  RowBox[{"metric", ",", "H", ",", " ", 
   RowBox[{"Verbose", "->", "False"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->57249108,ExpressionUUID->"3c6d1462-ec10-4105-b609-716e4f302694"],

Cell[BoxData["\<\"\\!\\(\\*SubscriptBox[\\(G\\), \\(4\\)]\\)\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->892030165,ExpressionUUID->"c7ee6fa6-0ce3-4b68-a2cf-385aad3f5ccc"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[" ", "FooterCell",ExpressionUUID->"721f2f2a-6ddb-4cc0-abd7-c090e3c3ae50"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 830.25},
WindowMargins->{{-1920, Automatic}, {369.75, Automatic}},
WindowTitle->"IsometryGroupDimension",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Open, "1" -> Closed}, "AllOptsTable" -> 
    Closed, "NotesSection" -> Closed, 
    "ExampleSubsection" -> {"0" -> Closed, "1" -> Closed, "2" -> Closed}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", "HeaderCoreAreaLink" -> {}, 
  "Metadata" -> {
   "built" -> "{2024, 12, 16, 19, 49, 23.923684}", 
    "history" -> {"XX", "", "", ""}, "context" -> "xAct`xIdeal`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "x Ideal Symbol", "language" -> "en", "paclet" -> "xIdeal", "status" -> 
    "None", "summary" -> 
    "IsometryGroupDimension[metric, H] returns the dimension of the maximal \
isometry group admitted by metric with connection tensor H.", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "IsometryGroupDimension", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "IsometryGroupDimension", "type" -> "Symbol", "uri" -> 
    "xIdeal/ref/IsometryGroupDimension", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"14.1 for Linux x86 (64-bit) (July 16, 2024)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "14.1 for Linux x86 (64-bit) (July 16, 2024)", 
  StyleDefinitions -> "Default.nb"],
ExpressionUUID->"3301e357-b4a0-481b-8c8a-b85c29f8f77f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9729, 252, 1429, 37, 34, "PrimaryExamplesSection",ExpressionUUID->"abc9c414-39d6-4b60-8dc6-6d1bffccb6f7",
   CellTags->"PrimaryExamplesSection",
   CellID->122255542]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 72854, 1967}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[590, 21, 3436, 79, 59, "AnchorBarGrid",ExpressionUUID->"70bf4929-f666-4b74-8866-2376626a85d8",
 CellID->1],
Cell[4029, 102, 94, 0, 22, "ContextNameCell",ExpressionUUID->"89c6dc95-7120-4faf-ac0d-1a4d3efda1f5"],
Cell[CellGroupData[{
Cell[4148, 106, 565, 14, 57, "ObjectNameGrid",ExpressionUUID->"39d751cc-44e1-49e6-b00f-28aa1cd3215e"],
Cell[4716, 122, 541, 11, 86, "Usage",ExpressionUUID->"704642dd-fc46-49d6-a4d7-3e6a3a4110bc",
 CellID->423578463]
}, Open  ]],
Cell[CellGroupData[{
Cell[5294, 138, 1903, 48, 34, "NotesSection",ExpressionUUID->"31c4a09b-7f1d-46dc-9fed-be622d06ca87",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1299517144],
Cell[7200, 188, 128, 1, 70, "Notes",ExpressionUUID->"3e38f2a2-ece8-4172-96e9-95e8cfd7ac93",
 CellID->354734344],
Cell[7331, 191, 2271, 55, 70, "3ColumnTableMod",ExpressionUUID->"c1a8586e-2966-4ba7-b5fd-8be12f543c26",
 CellID->27290970]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[9729, 252, 1429, 37, 34, "PrimaryExamplesSection",ExpressionUUID->"abc9c414-39d6-4b60-8dc6-6d1bffccb6f7",
 CellTags->"PrimaryExamplesSection",
 CellID->122255542],
Cell[11161, 291, 200, 3, 28, "Input",ExpressionUUID->"af827305-61d9-45a4-bd49-33f042ee4f28",
 Evaluatable->True],
Cell[CellGroupData[{
Cell[11386, 298, 1407, 36, 29, "ExampleSection",ExpressionUUID->"6815db92-ff99-41eb-b527-0d28ded12af0",
 CellID->722357294],
Cell[CellGroupData[{
Cell[12818, 338, 1446, 37, 28, "ExampleSubsection",ExpressionUUID->"aa439b9a-6144-4d69-b421-96278cd88ca4",
 CellID->500462958],
Cell[14267, 377, 671, 15, 70, "ExampleText",ExpressionUUID->"6df7e739-4964-4d43-9010-b3baa6da8e17",
 CellID->50967587],
Cell[14941, 394, 3077, 95, 70, "Input",ExpressionUUID->"e8f78712-0565-4320-af21-904c8522f1da",
 CellID->140152022],
Cell[18021, 491, 240, 5, 70, "ExampleText",ExpressionUUID->"83dd33b7-e231-4157-841b-130c326ac4eb",
 CellID->205275238],
Cell[CellGroupData[{
Cell[18286, 500, 230, 5, 70, "Input",ExpressionUUID->"911e3a56-32f1-4879-97ac-006bf5fb9ef6",
 CellID->18878652],
Cell[CellGroupData[{
Cell[18541, 509, 376, 9, 70, "Print",ExpressionUUID->"d64c7a9c-24a8-4c5c-8425-84d1fa25e1e2",
 CellID->169643559],
Cell[18920, 520, 173, 2, 70, "Print",ExpressionUUID->"754dd09a-6c78-46ea-b464-f2f9649df13f",
 CellID->1493375352],
Cell[19096, 524, 457, 12, 70, "Print",ExpressionUUID->"27ca8f3f-6b0f-4f04-85be-6b67454f793f",
 CellID->980035558],
Cell[19556, 538, 173, 2, 70, "Print",ExpressionUUID->"7e26982f-7daa-49d6-b8aa-3586edebd89c",
 CellID->1951754814],
Cell[19732, 542, 495, 13, 70, "Print",ExpressionUUID->"291749bb-8d4b-4ef4-b548-986b0bdb1e82",
 CellID->1065345077],
Cell[20230, 557, 367, 7, 70, "Print",ExpressionUUID->"55d5761a-c67e-442f-905f-cde3d39e8374",
 CellID->1626579359],
Cell[20600, 566, 445, 8, 70, "Print",ExpressionUUID->"c0e1aa29-fdcd-4fd0-b70a-43272d206060",
 CellID->1372215500],
Cell[21048, 576, 465, 12, 70, "Print",ExpressionUUID->"1e1d2f09-a0df-4b2a-b74b-8d24015cb4ae",
 CellID->423666428],
Cell[21516, 590, 173, 2, 70, "Print",ExpressionUUID->"82bf3872-e1f0-4de5-a9d2-70ba8472985d",
 CellID->1384741951],
Cell[21692, 594, 443, 11, 70, "Print",ExpressionUUID->"a945f56f-7f6e-4408-9195-750eacfc8f88",
 CellID->781035457],
Cell[22138, 607, 173, 2, 70, "Print",ExpressionUUID->"b8bbdb29-a9e9-4653-9ff9-b4d35f0d7f36",
 CellID->1993440569],
Cell[22314, 611, 328, 7, 70, "Print",ExpressionUUID->"07d4a916-5118-43d3-ac79-123264322cff",
 CellID->247923483],
Cell[22645, 620, 172, 2, 70, "Print",ExpressionUUID->"7be47115-a6aa-418e-82c5-7b92eb1a78e3",
 CellID->158622753],
Cell[22820, 624, 493, 13, 70, "Print",ExpressionUUID->"65ebdfed-8d36-46a2-83ab-e1219e96ca4f",
 CellID->1025678119],
Cell[23316, 639, 366, 7, 70, "Print",ExpressionUUID->"84afbd8a-5b3c-4c0e-981e-bcfcd7785ebc",
 CellID->296387168],
Cell[23685, 648, 443, 8, 70, "Print",ExpressionUUID->"5a513779-5d61-4cd0-8c2f-a7f810ddf9fa",
 CellID->1393172663],
Cell[24131, 658, 457, 8, 70, "Print",ExpressionUUID->"a933d596-8a6f-4e10-a052-0495ae3454be",
 CellID->1678870774],
Cell[24591, 668, 471, 12, 70, "Print",ExpressionUUID->"db5328ce-4476-462e-862d-fe08ff2b06ad",
 CellID->1870879545],
Cell[25065, 682, 367, 7, 70, "Print",ExpressionUUID->"14e372be-1aaa-4568-887a-abbde1a9c064",
 CellID->1192894586],
Cell[25435, 691, 445, 8, 70, "Print",ExpressionUUID->"f0d40828-4c04-453f-b33d-150307a8d760",
 CellID->1320293819],
Cell[25883, 701, 457, 8, 70, "Print",ExpressionUUID->"ce20d223-776c-43a4-a19f-bba7321d69a4",
 CellID->1130608833],
Cell[26343, 711, 418, 11, 70, "Print",ExpressionUUID->"32f7a4e4-9c5f-44dd-8ce8-58fdb410f641",
 CellID->281238445],
Cell[26764, 724, 367, 7, 70, "Print",ExpressionUUID->"3033e458-c293-45f3-b08b-7a0d769840ac",
 CellID->1998423734],
Cell[27134, 733, 444, 8, 70, "Print",ExpressionUUID->"60d554e7-7f43-4447-88d7-01e54c090a56",
 CellID->131037245],
Cell[27581, 743, 452, 8, 70, "Print",ExpressionUUID->"3e93904b-27d9-41e7-ad41-710872ec6c44",
 CellID->160945712],
Cell[28036, 753, 352, 8, 70, "Print",ExpressionUUID->"a75679e3-43d3-4add-a1dc-86d8675476c6",
 CellID->949033189],
Cell[28391, 763, 367, 7, 70, "Print",ExpressionUUID->"6c7d9af8-fe90-4d14-8f87-732032cea0cc",
 CellID->1912190941],
Cell[28761, 772, 444, 8, 70, "Print",ExpressionUUID->"09e956a9-72bd-4149-afdd-ef82e1b05bb8",
 CellID->959664899],
Cell[29208, 782, 451, 8, 70, "Print",ExpressionUUID->"ebc5a270-f4c6-4b67-9204-2d5e4c562270",
 CellID->1402092899],
Cell[29662, 792, 487, 13, 70, "Print",ExpressionUUID->"7c0bb558-19e0-4f0e-9ae5-41df901b6459",
 CellID->1778316645],
Cell[30152, 807, 367, 7, 70, "Print",ExpressionUUID->"72d6a952-79d4-4f15-bf38-faccbbf0c5a6",
 CellID->1129308458],
Cell[30522, 816, 444, 8, 70, "Print",ExpressionUUID->"042b18db-b0ac-4336-8f30-1b0be58335b9",
 CellID->747984604],
Cell[30969, 826, 456, 8, 70, "Print",ExpressionUUID->"7993e1ab-979b-442f-b11c-f5bd651eea11",
 CellID->610868555],
Cell[31428, 836, 500, 10, 70, "Print",ExpressionUUID->"05e7c913-e72b-48e9-9346-41cefbd63adc",
 CellID->933579624],
Cell[31931, 848, 605, 13, 70, "Print",ExpressionUUID->"37ee4417-d5f4-4d63-a5ba-4bb5c50d24a1",
 CellID->1813329681],
Cell[32539, 863, 509, 10, 70, "Print",ExpressionUUID->"be6ab50f-8617-4d79-8f31-cf16ec260160",
 CellID->89964267],
Cell[33051, 875, 609, 13, 70, "Print",ExpressionUUID->"5fc3a1cb-570e-427f-bd66-e36824625c52",
 CellID->1394638110],
Cell[33663, 890, 501, 10, 70, "Print",ExpressionUUID->"73bf6d4c-02c2-418f-afd1-a9ae37d001b9",
 CellID->1038061533],
Cell[34167, 902, 602, 13, 70, "Print",ExpressionUUID->"dc67ea56-9daf-4293-a6c3-fc66d23946b6",
 CellID->513630695],
Cell[34772, 917, 510, 10, 70, "Print",ExpressionUUID->"7d6ef0c0-83b8-45dc-92f1-134a92ffac45",
 CellID->631896413],
Cell[35285, 929, 611, 13, 70, "Print",ExpressionUUID->"a312d40b-18c4-4f73-b287-df11f056b9d9",
 CellID->1819096991],
Cell[35899, 944, 520, 10, 70, "Print",ExpressionUUID->"30a059ff-a082-434a-b4e1-15da4fce8849",
 CellID->359587617],
Cell[36422, 956, 620, 13, 70, "Print",ExpressionUUID->"3f1f3cab-b3ed-4a39-a55e-0acdf5c8f701",
 CellID->879819896],
Cell[37045, 971, 511, 10, 70, "Print",ExpressionUUID->"bb60527e-93df-447a-bf1a-33bb827ff9ee",
 CellID->1977719744],
Cell[37559, 983, 611, 13, 70, "Print",ExpressionUUID->"e83c304b-2405-43e3-952e-14611d5d4770",
 CellID->1385265736],
Cell[38173, 998, 521, 10, 70, "Print",ExpressionUUID->"2664da8a-8026-4e6d-bc29-4c520ec2dc34",
 CellID->1176207065],
Cell[38697, 1010, 621, 13, 70, "Print",ExpressionUUID->"fa178071-3e8a-4770-94c6-29920a2bd4b8",
 CellID->1223408759],
Cell[39321, 1025, 502, 10, 70, "Print",ExpressionUUID->"4d6c0aea-0838-4aca-b22a-0628e7bd5ae5",
 CellID->916652863],
Cell[39826, 1037, 604, 13, 70, "Print",ExpressionUUID->"c828bc8a-73f7-4652-be58-62234d5123c6",
 CellID->899602962],
Cell[40433, 1052, 502, 10, 70, "Print",ExpressionUUID->"b73304ef-c18e-4f53-bab0-927c1b8afd2d",
 CellID->268819697],
Cell[40938, 1064, 603, 13, 70, "Print",ExpressionUUID->"dc6d308f-f887-4379-a900-768bbcf143e7",
 CellID->89463034],
Cell[41544, 1079, 537, 10, 70, "Print",ExpressionUUID->"849f5dd2-2d88-4f9c-9c50-1de10b0e4fe3",
 CellID->2030211795],
Cell[42084, 1091, 638, 13, 70, "Print",ExpressionUUID->"7c3e479f-75a2-4e0b-be4f-53712dbf1e4d",
 CellID->550058143],
Cell[42725, 1106, 523, 10, 70, "Print",ExpressionUUID->"4c1860da-e814-4732-9001-54261132fa75",
 CellID->2087886768],
Cell[43251, 1118, 621, 13, 70, "Print",ExpressionUUID->"056c6056-2c16-4f3b-88cb-682b9cffbd1f",
 CellID->13765393]
}, Open  ]],
Cell[43887, 1134, 16649, 500, 70, "Output",ExpressionUUID->"a6522fdd-320a-467e-9699-7db347e37714",
 CellID->711003855]
}, Open  ]],
Cell[60551, 1637, 194, 5, 70, "ExampleText",ExpressionUUID->"8049e64a-5ab2-48ff-aec3-16baa890bf20",
 CellID->82588054],
Cell[CellGroupData[{
Cell[60770, 1646, 236, 5, 70, "Input",ExpressionUUID->"af10933b-7442-4799-aeb5-3c25b8fe84dd",
 CellID->63038074],
Cell[CellGroupData[{
Cell[61031, 1655, 514, 10, 70, "Print",ExpressionUUID->"880f51e1-dbbf-48da-a537-fb7125768d34",
 CellID->889436309],
Cell[61548, 1667, 617, 13, 70, "Print",ExpressionUUID->"fc6f43db-4423-458e-a11c-8eade0758407",
 CellID->1925956334],
Cell[62168, 1682, 197, 2, 70, "Print",ExpressionUUID->"11ce7354-7da5-4f56-ad9c-7a87e4a1e371",
 CellID->1670668754]
}, Open  ]]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[62641, 1696, 1388, 36, 28, "ExampleSection",ExpressionUUID->"3ac7a9bd-cbaa-4561-ab4f-2805e15beddc"],
Cell[CellGroupData[{
Cell[64054, 1736, 1398, 36, 70, "ExampleSubsection",ExpressionUUID->"b4a07b29-2de0-43ba-a863-063494a261e2"],
Cell[65455, 1774, 414, 9, 70, "ExampleText",ExpressionUUID->"bd21673f-033b-45d6-a90d-92705689d280",
 CellID->8693097],
Cell[65872, 1785, 228, 5, 70, "Input",ExpressionUUID->"33289f98-5395-4be8-95cc-909f5eaced20",
 CellID->111291632],
Cell[CellGroupData[{
Cell[66125, 1794, 296, 6, 70, "Input",ExpressionUUID->"7ae38f4e-cca0-4fe2-a207-74e3f34b4367",
 CellID->245010494],
Cell[CellGroupData[{
Cell[66446, 1804, 514, 10, 70, "Print",ExpressionUUID->"fdf2912c-ac07-4b19-9fa5-9412b5bd7262",
 CellID->144045561],
Cell[66963, 1816, 621, 13, 70, "Print",ExpressionUUID->"67842538-fb6b-4863-9963-40cca7142bd7",
 CellID->1556789331],
Cell[67587, 1831, 196, 2, 70, "Print",ExpressionUUID->"91be6c05-6fe1-42b1-bef3-7cbe6c85a346",
 CellID->652493564]
}, Open  ]]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed]]]],
Cell[CellGroupData[{
Cell[67947, 1842, 1396, 36, 70, "ExampleSubsection",ExpressionUUID->"616d950c-0053-4529-89a6-9b3c82b0eaa0"],
Cell[69346, 1880, 203, 4, 70, "ExampleText",ExpressionUUID->"59f3d7a8-b413-4660-a0c9-f58b38d25492",
 CellID->346332891],
Cell[69552, 1886, 228, 5, 70, "Input",ExpressionUUID->"ef46744a-ae04-4d3c-b550-8f35ad93d632",
 CellID->292193654],
Cell[CellGroupData[{
Cell[69805, 1895, 286, 6, 70, "Input",ExpressionUUID->"3c6d1462-ec10-4105-b609-716e4f302694",
 CellID->57249108],
Cell[70094, 1903, 196, 2, 70, "Print",ExpressionUUID->"c7ee6fa6-0ce3-4b68-a2cf-385aad3f5ccc",
 CellID->892030165]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[70647, 1917, 78, 0, 40, "FooterCell",ExpressionUUID->"721f2f2a-6ddb-4cc0-abd7-c090e3c3ae50"]
}
]
*)

(* End of internal cache information *)

